/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1/os_policy.proto

package com.google.cloud.osconfig.v1;

/**
 *
 *
 * <pre>
 * An OS policy defines the desired state configuration for a VM.
 * </pre>
 *
 * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy}
 */
public final class OSPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy)
    OSPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OSPolicy.newBuilder() to construct.
  private OSPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OSPolicy() {
    id_ = "";
    description_ = "";
    mode_ = 0;
    resourceGroups_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OSPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.osconfig.v1.OsPolicyProto
        .internal_static_google_cloud_osconfig_v1_OSPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.osconfig.v1.OsPolicyProto
        .internal_static_google_cloud_osconfig_v1_OSPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.osconfig.v1.OSPolicy.class,
            com.google.cloud.osconfig.v1.OSPolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Policy mode
   * </pre>
   *
   * Protobuf enum {@code google.cloud.osconfig.v1.OSPolicy.Mode}
   */
  public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid mode
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * This mode checks if the configuration resources in the policy are in
     * their desired state. No actions are performed if they are not in the
     * desired state. This mode is used for reporting purposes.
     * </pre>
     *
     * <code>VALIDATION = 1;</code>
     */
    VALIDATION(1),
    /**
     *
     *
     * <pre>
     * This mode checks if the configuration resources in the policy are in
     * their desired state, and if not, enforces the desired state.
     * </pre>
     *
     * <code>ENFORCEMENT = 2;</code>
     */
    ENFORCEMENT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid mode
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    public static final int MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This mode checks if the configuration resources in the policy are in
     * their desired state. No actions are performed if they are not in the
     * desired state. This mode is used for reporting purposes.
     * </pre>
     *
     * <code>VALIDATION = 1;</code>
     */
    public static final int VALIDATION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * This mode checks if the configuration resources in the policy are in
     * their desired state, and if not, enforces the desired state.
     * </pre>
     *
     * <code>ENFORCEMENT = 2;</code>
     */
    public static final int ENFORCEMENT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Mode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Mode forNumber(int value) {
      switch (value) {
        case 0:
          return MODE_UNSPECIFIED;
        case 1:
          return VALIDATION;
        case 2:
          return ENFORCEMENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
          public Mode findValueByNumber(int number) {
            return Mode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.OSPolicy.getDescriptor().getEnumTypes().get(0);
    }

    private static final Mode[] VALUES = values();

    public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Mode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.OSPolicy.Mode)
  }

  public interface InventoryFilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.InventoryFilter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The OS short name
     * </pre>
     *
     * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The osShortName.
     */
    java.lang.String getOsShortName();
    /**
     *
     *
     * <pre>
     * Required. The OS short name
     * </pre>
     *
     * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for osShortName.
     */
    com.google.protobuf.ByteString getOsShortNameBytes();

    /**
     *
     *
     * <pre>
     * The OS version
     *
     * Prefix matches are supported if asterisk(*) is provided as the
     * last character. For example, to match all versions with a major
     * version of `7`, specify the following value for this field `7.*`
     *
     * An empty string matches all OS versions.
     * </pre>
     *
     * <code>string os_version = 2;</code>
     *
     * @return The osVersion.
     */
    java.lang.String getOsVersion();
    /**
     *
     *
     * <pre>
     * The OS version
     *
     * Prefix matches are supported if asterisk(*) is provided as the
     * last character. For example, to match all versions with a major
     * version of `7`, specify the following value for this field `7.*`
     *
     * An empty string matches all OS versions.
     * </pre>
     *
     * <code>string os_version = 2;</code>
     *
     * @return The bytes for osVersion.
     */
    com.google.protobuf.ByteString getOsVersionBytes();
  }
  /**
   *
   *
   * <pre>
   * Filtering criteria to select VMs based on inventory details.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.InventoryFilter}
   */
  public static final class InventoryFilter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.InventoryFilter)
      InventoryFilterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InventoryFilter.newBuilder() to construct.
    private InventoryFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InventoryFilter() {
      osShortName_ = "";
      osVersion_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InventoryFilter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.OsPolicyProto
          .internal_static_google_cloud_osconfig_v1_OSPolicy_InventoryFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.OsPolicyProto
          .internal_static_google_cloud_osconfig_v1_OSPolicy_InventoryFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter.class,
              com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter.Builder.class);
    }

    public static final int OS_SHORT_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object osShortName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The OS short name
     * </pre>
     *
     * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The osShortName.
     */
    @java.lang.Override
    public java.lang.String getOsShortName() {
      java.lang.Object ref = osShortName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        osShortName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The OS short name
     * </pre>
     *
     * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for osShortName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOsShortNameBytes() {
      java.lang.Object ref = osShortName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        osShortName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OS_VERSION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object osVersion_ = "";
    /**
     *
     *
     * <pre>
     * The OS version
     *
     * Prefix matches are supported if asterisk(*) is provided as the
     * last character. For example, to match all versions with a major
     * version of `7`, specify the following value for this field `7.*`
     *
     * An empty string matches all OS versions.
     * </pre>
     *
     * <code>string os_version = 2;</code>
     *
     * @return The osVersion.
     */
    @java.lang.Override
    public java.lang.String getOsVersion() {
      java.lang.Object ref = osVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        osVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The OS version
     *
     * Prefix matches are supported if asterisk(*) is provided as the
     * last character. For example, to match all versions with a major
     * version of `7`, specify the following value for this field `7.*`
     *
     * An empty string matches all OS versions.
     * </pre>
     *
     * <code>string os_version = 2;</code>
     *
     * @return The bytes for osVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOsVersionBytes() {
      java.lang.Object ref = osVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        osVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osShortName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, osShortName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, osVersion_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osShortName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, osShortName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, osVersion_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter other =
          (com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter) obj;

      if (!getOsShortName().equals(other.getOsShortName())) return false;
      if (!getOsVersion().equals(other.getOsVersion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OS_SHORT_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getOsShortName().hashCode();
      hash = (37 * hash) + OS_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getOsVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Filtering criteria to select VMs based on inventory details.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.InventoryFilter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.InventoryFilter)
        com.google.cloud.osconfig.v1.OSPolicy.InventoryFilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_InventoryFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_InventoryFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter.class,
                com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        osShortName_ = "";
        osVersion_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_InventoryFilter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter build() {
        com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter buildPartial() {
        com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter result =
            new com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.osShortName_ = osShortName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.osVersion_ = osVersion_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter) {
          return mergeFrom((com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter other) {
        if (other == com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter.getDefaultInstance())
          return this;
        if (!other.getOsShortName().isEmpty()) {
          osShortName_ = other.osShortName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getOsVersion().isEmpty()) {
          osVersion_ = other.osVersion_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  osShortName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  osVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object osShortName_ = "";
      /**
       *
       *
       * <pre>
       * Required. The OS short name
       * </pre>
       *
       * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The osShortName.
       */
      public java.lang.String getOsShortName() {
        java.lang.Object ref = osShortName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          osShortName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The OS short name
       * </pre>
       *
       * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for osShortName.
       */
      public com.google.protobuf.ByteString getOsShortNameBytes() {
        java.lang.Object ref = osShortName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          osShortName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The OS short name
       * </pre>
       *
       * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The osShortName to set.
       * @return This builder for chaining.
       */
      public Builder setOsShortName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        osShortName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The OS short name
       * </pre>
       *
       * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOsShortName() {
        osShortName_ = getDefaultInstance().getOsShortName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The OS short name
       * </pre>
       *
       * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for osShortName to set.
       * @return This builder for chaining.
       */
      public Builder setOsShortNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        osShortName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object osVersion_ = "";
      /**
       *
       *
       * <pre>
       * The OS version
       *
       * Prefix matches are supported if asterisk(*) is provided as the
       * last character. For example, to match all versions with a major
       * version of `7`, specify the following value for this field `7.*`
       *
       * An empty string matches all OS versions.
       * </pre>
       *
       * <code>string os_version = 2;</code>
       *
       * @return The osVersion.
       */
      public java.lang.String getOsVersion() {
        java.lang.Object ref = osVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          osVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The OS version
       *
       * Prefix matches are supported if asterisk(*) is provided as the
       * last character. For example, to match all versions with a major
       * version of `7`, specify the following value for this field `7.*`
       *
       * An empty string matches all OS versions.
       * </pre>
       *
       * <code>string os_version = 2;</code>
       *
       * @return The bytes for osVersion.
       */
      public com.google.protobuf.ByteString getOsVersionBytes() {
        java.lang.Object ref = osVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          osVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The OS version
       *
       * Prefix matches are supported if asterisk(*) is provided as the
       * last character. For example, to match all versions with a major
       * version of `7`, specify the following value for this field `7.*`
       *
       * An empty string matches all OS versions.
       * </pre>
       *
       * <code>string os_version = 2;</code>
       *
       * @param value The osVersion to set.
       * @return This builder for chaining.
       */
      public Builder setOsVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        osVersion_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The OS version
       *
       * Prefix matches are supported if asterisk(*) is provided as the
       * last character. For example, to match all versions with a major
       * version of `7`, specify the following value for this field `7.*`
       *
       * An empty string matches all OS versions.
       * </pre>
       *
       * <code>string os_version = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOsVersion() {
        osVersion_ = getDefaultInstance().getOsVersion();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The OS version
       *
       * Prefix matches are supported if asterisk(*) is provided as the
       * last character. For example, to match all versions with a major
       * version of `7`, specify the following value for this field `7.*`
       *
       * An empty string matches all OS versions.
       * </pre>
       *
       * <code>string os_version = 2;</code>
       *
       * @param value The bytes for osVersion to set.
       * @return This builder for chaining.
       */
      public Builder setOsVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        osVersion_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.InventoryFilter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.InventoryFilter)
    private static final com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter();
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InventoryFilter> PARSER =
        new com.google.protobuf.AbstractParser<InventoryFilter>() {
          @java.lang.Override
          public InventoryFilter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InventoryFilter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InventoryFilter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicy.InventoryFilter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ResourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The id of the resource with the following restrictions:
     *
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the OS policy.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * Required. The id of the resource with the following restrictions:
     *
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the OS policy.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * Package resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
     *
     * @return Whether the pkg field is set.
     */
    boolean hasPkg();
    /**
     *
     *
     * <pre>
     * Package resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
     *
     * @return The pkg.
     */
    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource getPkg();
    /**
     *
     *
     * <pre>
     * Package resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
     */
    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResourceOrBuilder getPkgOrBuilder();

    /**
     *
     *
     * <pre>
     * Package repository resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
     *
     * @return Whether the repository field is set.
     */
    boolean hasRepository();
    /**
     *
     *
     * <pre>
     * Package repository resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
     *
     * @return The repository.
     */
    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource getRepository();
    /**
     *
     *
     * <pre>
     * Package repository resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
     */
    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResourceOrBuilder
        getRepositoryOrBuilder();

    /**
     *
     *
     * <pre>
     * Exec resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource exec = 4;</code>
     *
     * @return Whether the exec field is set.
     */
    boolean hasExec();
    /**
     *
     *
     * <pre>
     * Exec resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource exec = 4;</code>
     *
     * @return The exec.
     */
    com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource getExec();
    /**
     *
     *
     * <pre>
     * Exec resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource exec = 4;</code>
     */
    com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResourceOrBuilder getExecOrBuilder();

    /**
     *
     *
     * <pre>
     * File resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource file = 5;</code>
     *
     * @return Whether the file field is set.
     */
    boolean hasFile();
    /**
     *
     *
     * <pre>
     * File resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource file = 5;</code>
     *
     * @return The file.
     */
    com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource getFile();
    /**
     *
     *
     * <pre>
     * File resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource file = 5;</code>
     */
    com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResourceOrBuilder getFileOrBuilder();

    com.google.cloud.osconfig.v1.OSPolicy.Resource.ResourceTypeCase getResourceTypeCase();
  }
  /**
   *
   *
   * <pre>
   * An OS policy resource is used to define the desired state configuration
   * and provides a specific functionality like installing/removing packages,
   * executing a script etc.
   *
   * The system ensures that resources are always in their desired state by
   * taking necessary actions if they have drifted from their desired state.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource}
   */
  public static final class Resource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource)
      ResourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Resource.newBuilder() to construct.
    private Resource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Resource() {
      id_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Resource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.OsPolicyProto
          .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.OsPolicyProto
          .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.class,
              com.google.cloud.osconfig.v1.OSPolicy.Resource.Builder.class);
    }

    public interface FileOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.File)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * A generic remote file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
       *
       * @return Whether the remote field is set.
       */
      boolean hasRemote();
      /**
       *
       *
       * <pre>
       * A generic remote file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
       *
       * @return The remote.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote getRemote();
      /**
       *
       *
       * <pre>
       * A generic remote file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.File.RemoteOrBuilder getRemoteOrBuilder();

      /**
       *
       *
       * <pre>
       * A Cloud Storage object.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
       *
       * @return Whether the gcs field is set.
       */
      boolean hasGcs();
      /**
       *
       *
       * <pre>
       * A Cloud Storage object.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
       *
       * @return The gcs.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs getGcs();
      /**
       *
       *
       * <pre>
       * A Cloud Storage object.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.File.GcsOrBuilder getGcsOrBuilder();

      /**
       *
       *
       * <pre>
       * A local path within the VM to use.
       * </pre>
       *
       * <code>string local_path = 3;</code>
       *
       * @return Whether the localPath field is set.
       */
      boolean hasLocalPath();
      /**
       *
       *
       * <pre>
       * A local path within the VM to use.
       * </pre>
       *
       * <code>string local_path = 3;</code>
       *
       * @return The localPath.
       */
      java.lang.String getLocalPath();
      /**
       *
       *
       * <pre>
       * A local path within the VM to use.
       * </pre>
       *
       * <code>string local_path = 3;</code>
       *
       * @return The bytes for localPath.
       */
      com.google.protobuf.ByteString getLocalPathBytes();

      /**
       *
       *
       * <pre>
       * Defaults to false. When false, files are subject to validations
       * based on the file type:
       *
       * Remote: A checksum must be specified.
       * Cloud Storage: An object generation number must be specified.
       * </pre>
       *
       * <code>bool allow_insecure = 4;</code>
       *
       * @return The allowInsecure.
       */
      boolean getAllowInsecure();

      com.google.cloud.osconfig.v1.OSPolicy.Resource.File.TypeCase getTypeCase();
    }
    /**
     *
     *
     * <pre>
     * A remote or local file.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.File}
     */
    public static final class File extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.File)
        FileOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use File.newBuilder() to construct.
      private File(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private File() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new File();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.class,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder.class);
      }

      public interface RemoteOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. URI from which to fetch the object. It should contain both
         * the protocol and path following the format `{protocol}://{location}`.
         * </pre>
         *
         * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The uri.
         */
        java.lang.String getUri();
        /**
         *
         *
         * <pre>
         * Required. URI from which to fetch the object. It should contain both
         * the protocol and path following the format `{protocol}://{location}`.
         * </pre>
         *
         * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for uri.
         */
        com.google.protobuf.ByteString getUriBytes();

        /**
         *
         *
         * <pre>
         * SHA256 checksum of the remote file.
         * </pre>
         *
         * <code>string sha256_checksum = 2;</code>
         *
         * @return The sha256Checksum.
         */
        java.lang.String getSha256Checksum();
        /**
         *
         *
         * <pre>
         * SHA256 checksum of the remote file.
         * </pre>
         *
         * <code>string sha256_checksum = 2;</code>
         *
         * @return The bytes for sha256Checksum.
         */
        com.google.protobuf.ByteString getSha256ChecksumBytes();
      }
      /**
       *
       *
       * <pre>
       * Specifies a file available via some URI.
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote}
       */
      public static final class Remote extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote)
          RemoteOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Remote.newBuilder() to construct.
        private Remote(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Remote() {
          uri_ = "";
          sha256Checksum_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Remote();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_Remote_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_Remote_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.Builder.class);
        }

        public static final int URI_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object uri_ = "";
        /**
         *
         *
         * <pre>
         * Required. URI from which to fetch the object. It should contain both
         * the protocol and path following the format `{protocol}://{location}`.
         * </pre>
         *
         * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The uri.
         */
        @java.lang.Override
        public java.lang.String getUri() {
          java.lang.Object ref = uri_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            uri_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. URI from which to fetch the object. It should contain both
         * the protocol and path following the format `{protocol}://{location}`.
         * </pre>
         *
         * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for uri.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getUriBytes() {
          java.lang.Object ref = uri_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            uri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int SHA256_CHECKSUM_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object sha256Checksum_ = "";
        /**
         *
         *
         * <pre>
         * SHA256 checksum of the remote file.
         * </pre>
         *
         * <code>string sha256_checksum = 2;</code>
         *
         * @return The sha256Checksum.
         */
        @java.lang.Override
        public java.lang.String getSha256Checksum() {
          java.lang.Object ref = sha256Checksum_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            sha256Checksum_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * SHA256 checksum of the remote file.
         * </pre>
         *
         * <code>string sha256_checksum = 2;</code>
         *
         * @return The bytes for sha256Checksum.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getSha256ChecksumBytes() {
          java.lang.Object ref = sha256Checksum_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            sha256Checksum_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sha256Checksum_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sha256Checksum_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sha256Checksum_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sha256Checksum_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote) obj;

          if (!getUri().equals(other.getUri())) return false;
          if (!getSha256Checksum().equals(other.getSha256Checksum())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + URI_FIELD_NUMBER;
          hash = (53 * hash) + getUri().hashCode();
          hash = (37 * hash) + SHA256_CHECKSUM_FIELD_NUMBER;
          hash = (53 * hash) + getSha256Checksum().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote parseDelimitedFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Specifies a file available via some URI.
         * </pre>
         *
         * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.File.RemoteOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_Remote_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_Remote_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.Builder.class);
          }

          // Construct using com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            uri_ = "";
            sha256Checksum_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_Remote_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote result =
                new com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.uri_ = uri_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.sha256Checksum_ = sha256Checksum_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote) {
              return mergeFrom((com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.getDefaultInstance())
              return this;
            if (!other.getUri().isEmpty()) {
              uri_ = other.uri_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getSha256Checksum().isEmpty()) {
              sha256Checksum_ = other.sha256Checksum_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      uri_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      sha256Checksum_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object uri_ = "";
          /**
           *
           *
           * <pre>
           * Required. URI from which to fetch the object. It should contain both
           * the protocol and path following the format `{protocol}://{location}`.
           * </pre>
           *
           * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The uri.
           */
          public java.lang.String getUri() {
            java.lang.Object ref = uri_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              uri_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. URI from which to fetch the object. It should contain both
           * the protocol and path following the format `{protocol}://{location}`.
           * </pre>
           *
           * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for uri.
           */
          public com.google.protobuf.ByteString getUriBytes() {
            java.lang.Object ref = uri_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              uri_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. URI from which to fetch the object. It should contain both
           * the protocol and path following the format `{protocol}://{location}`.
           * </pre>
           *
           * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The uri to set.
           * @return This builder for chaining.
           */
          public Builder setUri(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            uri_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. URI from which to fetch the object. It should contain both
           * the protocol and path following the format `{protocol}://{location}`.
           * </pre>
           *
           * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearUri() {
            uri_ = getDefaultInstance().getUri();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. URI from which to fetch the object. It should contain both
           * the protocol and path following the format `{protocol}://{location}`.
           * </pre>
           *
           * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for uri to set.
           * @return This builder for chaining.
           */
          public Builder setUriBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            uri_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object sha256Checksum_ = "";
          /**
           *
           *
           * <pre>
           * SHA256 checksum of the remote file.
           * </pre>
           *
           * <code>string sha256_checksum = 2;</code>
           *
           * @return The sha256Checksum.
           */
          public java.lang.String getSha256Checksum() {
            java.lang.Object ref = sha256Checksum_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              sha256Checksum_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * SHA256 checksum of the remote file.
           * </pre>
           *
           * <code>string sha256_checksum = 2;</code>
           *
           * @return The bytes for sha256Checksum.
           */
          public com.google.protobuf.ByteString getSha256ChecksumBytes() {
            java.lang.Object ref = sha256Checksum_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              sha256Checksum_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * SHA256 checksum of the remote file.
           * </pre>
           *
           * <code>string sha256_checksum = 2;</code>
           *
           * @param value The sha256Checksum to set.
           * @return This builder for chaining.
           */
          public Builder setSha256Checksum(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            sha256Checksum_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * SHA256 checksum of the remote file.
           * </pre>
           *
           * <code>string sha256_checksum = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearSha256Checksum() {
            sha256Checksum_ = getDefaultInstance().getSha256Checksum();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * SHA256 checksum of the remote file.
           * </pre>
           *
           * <code>string sha256_checksum = 2;</code>
           *
           * @param value The bytes for sha256Checksum to set.
           * @return This builder for chaining.
           */
          public Builder setSha256ChecksumBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            sha256Checksum_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Remote> PARSER =
            new com.google.protobuf.AbstractParser<Remote>() {
              @java.lang.Override
              public Remote parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Remote> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Remote> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface GcsOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Bucket of the Cloud Storage object.
         * </pre>
         *
         * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bucket.
         */
        java.lang.String getBucket();
        /**
         *
         *
         * <pre>
         * Required. Bucket of the Cloud Storage object.
         * </pre>
         *
         * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for bucket.
         */
        com.google.protobuf.ByteString getBucketBytes();

        /**
         *
         *
         * <pre>
         * Required. Name of the Cloud Storage object.
         * </pre>
         *
         * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The object.
         */
        java.lang.String getObject();
        /**
         *
         *
         * <pre>
         * Required. Name of the Cloud Storage object.
         * </pre>
         *
         * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for object.
         */
        com.google.protobuf.ByteString getObjectBytes();

        /**
         *
         *
         * <pre>
         * Generation number of the Cloud Storage object.
         * </pre>
         *
         * <code>int64 generation = 3;</code>
         *
         * @return The generation.
         */
        long getGeneration();
      }
      /**
       *
       *
       * <pre>
       * Specifies a file available as a Cloud Storage Object.
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs}
       */
      public static final class Gcs extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs)
          GcsOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Gcs.newBuilder() to construct.
        private Gcs(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Gcs() {
          bucket_ = "";
          object_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Gcs();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_Gcs_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_Gcs_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.Builder.class);
        }

        public static final int BUCKET_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object bucket_ = "";
        /**
         *
         *
         * <pre>
         * Required. Bucket of the Cloud Storage object.
         * </pre>
         *
         * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bucket.
         */
        @java.lang.Override
        public java.lang.String getBucket() {
          java.lang.Object ref = bucket_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            bucket_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Bucket of the Cloud Storage object.
         * </pre>
         *
         * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for bucket.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getBucketBytes() {
          java.lang.Object ref = bucket_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            bucket_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int OBJECT_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object object_ = "";
        /**
         *
         *
         * <pre>
         * Required. Name of the Cloud Storage object.
         * </pre>
         *
         * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The object.
         */
        @java.lang.Override
        public java.lang.String getObject() {
          java.lang.Object ref = object_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            object_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Name of the Cloud Storage object.
         * </pre>
         *
         * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for object.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getObjectBytes() {
          java.lang.Object ref = object_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            object_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int GENERATION_FIELD_NUMBER = 3;
        private long generation_ = 0L;
        /**
         *
         *
         * <pre>
         * Generation number of the Cloud Storage object.
         * </pre>
         *
         * <code>int64 generation = 3;</code>
         *
         * @return The generation.
         */
        @java.lang.Override
        public long getGeneration() {
          return generation_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucket_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(object_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, object_);
          }
          if (generation_ != 0L) {
            output.writeInt64(3, generation_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, bucket_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(object_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, object_);
          }
          if (generation_ != 0L) {
            size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, generation_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs) obj;

          if (!getBucket().equals(other.getBucket())) return false;
          if (!getObject().equals(other.getObject())) return false;
          if (getGeneration() != other.getGeneration()) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + BUCKET_FIELD_NUMBER;
          hash = (53 * hash) + getBucket().hashCode();
          hash = (37 * hash) + OBJECT_FIELD_NUMBER;
          hash = (53 * hash) + getObject().hashCode();
          hash = (37 * hash) + GENERATION_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getGeneration());
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs parseDelimitedFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Specifies a file available as a Cloud Storage Object.
         * </pre>
         *
         * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.File.GcsOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_Gcs_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_Gcs_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.Builder.class);
          }

          // Construct using com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            bucket_ = "";
            object_ = "";
            generation_ = 0L;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_Gcs_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs result =
                new com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.bucket_ = bucket_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.object_ = object_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.generation_ = generation_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs) {
              return mergeFrom((com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.getDefaultInstance())
              return this;
            if (!other.getBucket().isEmpty()) {
              bucket_ = other.bucket_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getObject().isEmpty()) {
              object_ = other.object_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            if (other.getGeneration() != 0L) {
              setGeneration(other.getGeneration());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      bucket_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      object_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  case 24:
                    {
                      generation_ = input.readInt64();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 24
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object bucket_ = "";
          /**
           *
           *
           * <pre>
           * Required. Bucket of the Cloud Storage object.
           * </pre>
           *
           * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bucket.
           */
          public java.lang.String getBucket() {
            java.lang.Object ref = bucket_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              bucket_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Bucket of the Cloud Storage object.
           * </pre>
           *
           * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for bucket.
           */
          public com.google.protobuf.ByteString getBucketBytes() {
            java.lang.Object ref = bucket_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              bucket_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Bucket of the Cloud Storage object.
           * </pre>
           *
           * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bucket to set.
           * @return This builder for chaining.
           */
          public Builder setBucket(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bucket_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Bucket of the Cloud Storage object.
           * </pre>
           *
           * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearBucket() {
            bucket_ = getDefaultInstance().getBucket();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Bucket of the Cloud Storage object.
           * </pre>
           *
           * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for bucket to set.
           * @return This builder for chaining.
           */
          public Builder setBucketBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            bucket_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object object_ = "";
          /**
           *
           *
           * <pre>
           * Required. Name of the Cloud Storage object.
           * </pre>
           *
           * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The object.
           */
          public java.lang.String getObject() {
            java.lang.Object ref = object_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              object_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Name of the Cloud Storage object.
           * </pre>
           *
           * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for object.
           */
          public com.google.protobuf.ByteString getObjectBytes() {
            java.lang.Object ref = object_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              object_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Name of the Cloud Storage object.
           * </pre>
           *
           * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The object to set.
           * @return This builder for chaining.
           */
          public Builder setObject(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            object_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Name of the Cloud Storage object.
           * </pre>
           *
           * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearObject() {
            object_ = getDefaultInstance().getObject();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Name of the Cloud Storage object.
           * </pre>
           *
           * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for object to set.
           * @return This builder for chaining.
           */
          public Builder setObjectBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            object_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          private long generation_;
          /**
           *
           *
           * <pre>
           * Generation number of the Cloud Storage object.
           * </pre>
           *
           * <code>int64 generation = 3;</code>
           *
           * @return The generation.
           */
          @java.lang.Override
          public long getGeneration() {
            return generation_;
          }
          /**
           *
           *
           * <pre>
           * Generation number of the Cloud Storage object.
           * </pre>
           *
           * <code>int64 generation = 3;</code>
           *
           * @param value The generation to set.
           * @return This builder for chaining.
           */
          public Builder setGeneration(long value) {

            generation_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Generation number of the Cloud Storage object.
           * </pre>
           *
           * <code>int64 generation = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearGeneration() {
            bitField0_ = (bitField0_ & ~0x00000004);
            generation_ = 0L;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Gcs> PARSER =
            new com.google.protobuf.AbstractParser<Gcs>() {
              @java.lang.Override
              public Gcs parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Gcs> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Gcs> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int typeCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object type_;

      public enum TypeCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        REMOTE(1),
        GCS(2),
        LOCAL_PATH(3),
        TYPE_NOT_SET(0);
        private final int value;

        private TypeCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static TypeCase valueOf(int value) {
          return forNumber(value);
        }

        public static TypeCase forNumber(int value) {
          switch (value) {
            case 1:
              return REMOTE;
            case 2:
              return GCS;
            case 3:
              return LOCAL_PATH;
            case 0:
              return TYPE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public TypeCase getTypeCase() {
        return TypeCase.forNumber(typeCase_);
      }

      public static final int REMOTE_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * A generic remote file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
       *
       * @return Whether the remote field is set.
       */
      @java.lang.Override
      public boolean hasRemote() {
        return typeCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * A generic remote file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
       *
       * @return The remote.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote getRemote() {
        if (typeCase_ == 1) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote) type_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A generic remote file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.RemoteOrBuilder
          getRemoteOrBuilder() {
        if (typeCase_ == 1) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote) type_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.getDefaultInstance();
      }

      public static final int GCS_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * A Cloud Storage object.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
       *
       * @return Whether the gcs field is set.
       */
      @java.lang.Override
      public boolean hasGcs() {
        return typeCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
       *
       * @return The gcs.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs getGcs() {
        if (typeCase_ == 2) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs) type_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.GcsOrBuilder getGcsOrBuilder() {
        if (typeCase_ == 2) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs) type_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.getDefaultInstance();
      }

      public static final int LOCAL_PATH_FIELD_NUMBER = 3;
      /**
       *
       *
       * <pre>
       * A local path within the VM to use.
       * </pre>
       *
       * <code>string local_path = 3;</code>
       *
       * @return Whether the localPath field is set.
       */
      public boolean hasLocalPath() {
        return typeCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * A local path within the VM to use.
       * </pre>
       *
       * <code>string local_path = 3;</code>
       *
       * @return The localPath.
       */
      public java.lang.String getLocalPath() {
        java.lang.Object ref = "";
        if (typeCase_ == 3) {
          ref = type_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (typeCase_ == 3) {
            type_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * A local path within the VM to use.
       * </pre>
       *
       * <code>string local_path = 3;</code>
       *
       * @return The bytes for localPath.
       */
      public com.google.protobuf.ByteString getLocalPathBytes() {
        java.lang.Object ref = "";
        if (typeCase_ == 3) {
          ref = type_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (typeCase_ == 3) {
            type_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ALLOW_INSECURE_FIELD_NUMBER = 4;
      private boolean allowInsecure_ = false;
      /**
       *
       *
       * <pre>
       * Defaults to false. When false, files are subject to validations
       * based on the file type:
       *
       * Remote: A checksum must be specified.
       * Cloud Storage: An object generation number must be specified.
       * </pre>
       *
       * <code>bool allow_insecure = 4;</code>
       *
       * @return The allowInsecure.
       */
      @java.lang.Override
      public boolean getAllowInsecure() {
        return allowInsecure_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (typeCase_ == 1) {
          output.writeMessage(
              1, (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote) type_);
        }
        if (typeCase_ == 2) {
          output.writeMessage(2, (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs) type_);
        }
        if (typeCase_ == 3) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, type_);
        }
        if (allowInsecure_ != false) {
          output.writeBool(4, allowInsecure_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (typeCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1, (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote) type_);
        }
        if (typeCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs) type_);
        }
        if (typeCase_ == 3) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, type_);
        }
        if (allowInsecure_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, allowInsecure_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.File)) {
          return super.equals(obj);
        }
        com.google.cloud.osconfig.v1.OSPolicy.Resource.File other =
            (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) obj;

        if (getAllowInsecure() != other.getAllowInsecure()) return false;
        if (!getTypeCase().equals(other.getTypeCase())) return false;
        switch (typeCase_) {
          case 1:
            if (!getRemote().equals(other.getRemote())) return false;
            break;
          case 2:
            if (!getGcs().equals(other.getGcs())) return false;
            break;
          case 3:
            if (!getLocalPath().equals(other.getLocalPath())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ALLOW_INSECURE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowInsecure());
        switch (typeCase_) {
          case 1:
            hash = (37 * hash) + REMOTE_FIELD_NUMBER;
            hash = (53 * hash) + getRemote().hashCode();
            break;
          case 2:
            hash = (37 * hash) + GCS_FIELD_NUMBER;
            hash = (53 * hash) + getGcs().hashCode();
            break;
          case 3:
            hash = (37 * hash) + LOCAL_PATH_FIELD_NUMBER;
            hash = (53 * hash) + getLocalPath().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.osconfig.v1.OSPolicy.Resource.File prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A remote or local file.
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.File}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.File)
          com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder.class);
        }

        // Construct using com.google.cloud.osconfig.v1.OSPolicy.Resource.File.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (remoteBuilder_ != null) {
            remoteBuilder_.clear();
          }
          if (gcsBuilder_ != null) {
            gcsBuilder_.clear();
          }
          allowInsecure_ = false;
          typeCase_ = 0;
          type_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_File_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File getDefaultInstanceForType() {
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File build() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.File result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File buildPartial() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.File result =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.File(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.cloud.osconfig.v1.OSPolicy.Resource.File result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.allowInsecure_ = allowInsecure_;
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.File result) {
          result.typeCase_ = typeCase_;
          result.type_ = this.type_;
          if (typeCase_ == 1 && remoteBuilder_ != null) {
            result.type_ = remoteBuilder_.build();
          }
          if (typeCase_ == 2 && gcsBuilder_ != null) {
            result.type_ = gcsBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.File) {
            return mergeFrom((com.google.cloud.osconfig.v1.OSPolicy.Resource.File) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.osconfig.v1.OSPolicy.Resource.File other) {
          if (other == com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance())
            return this;
          if (other.getAllowInsecure() != false) {
            setAllowInsecure(other.getAllowInsecure());
          }
          switch (other.getTypeCase()) {
            case REMOTE:
              {
                mergeRemote(other.getRemote());
                break;
              }
            case GCS:
              {
                mergeGcs(other.getGcs());
                break;
              }
            case LOCAL_PATH:
              {
                typeCase_ = 3;
                type_ = other.type_;
                onChanged();
                break;
              }
            case TYPE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getRemoteFieldBuilder().getBuilder(), extensionRegistry);
                    typeCase_ = 1;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getGcsFieldBuilder().getBuilder(), extensionRegistry);
                    typeCase_ = 2;
                    break;
                  } // case 18
                case 26:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    typeCase_ = 3;
                    type_ = s;
                    break;
                  } // case 26
                case 32:
                  {
                    allowInsecure_ = input.readBool();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int typeCase_ = 0;
        private java.lang.Object type_;

        public TypeCase getTypeCase() {
          return TypeCase.forNumber(typeCase_);
        }

        public Builder clearType() {
          typeCase_ = 0;
          type_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.RemoteOrBuilder>
            remoteBuilder_;
        /**
         *
         *
         * <pre>
         * A generic remote file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
         *
         * @return Whether the remote field is set.
         */
        @java.lang.Override
        public boolean hasRemote() {
          return typeCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * A generic remote file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
         *
         * @return The remote.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote getRemote() {
          if (remoteBuilder_ == null) {
            if (typeCase_ == 1) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote) type_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.getDefaultInstance();
          } else {
            if (typeCase_ == 1) {
              return remoteBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A generic remote file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
         */
        public Builder setRemote(com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote value) {
          if (remoteBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            type_ = value;
            onChanged();
          } else {
            remoteBuilder_.setMessage(value);
          }
          typeCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A generic remote file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
         */
        public Builder setRemote(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.Builder builderForValue) {
          if (remoteBuilder_ == null) {
            type_ = builderForValue.build();
            onChanged();
          } else {
            remoteBuilder_.setMessage(builderForValue.build());
          }
          typeCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A generic remote file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
         */
        public Builder mergeRemote(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote value) {
          if (remoteBuilder_ == null) {
            if (typeCase_ == 1
                && type_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote
                        .getDefaultInstance()) {
              type_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote) type_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              type_ = value;
            }
            onChanged();
          } else {
            if (typeCase_ == 1) {
              remoteBuilder_.mergeFrom(value);
            } else {
              remoteBuilder_.setMessage(value);
            }
          }
          typeCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A generic remote file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
         */
        public Builder clearRemote() {
          if (remoteBuilder_ == null) {
            if (typeCase_ == 1) {
              typeCase_ = 0;
              type_ = null;
              onChanged();
            }
          } else {
            if (typeCase_ == 1) {
              typeCase_ = 0;
              type_ = null;
            }
            remoteBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A generic remote file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.Builder
            getRemoteBuilder() {
          return getRemoteFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A generic remote file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.RemoteOrBuilder
            getRemoteOrBuilder() {
          if ((typeCase_ == 1) && (remoteBuilder_ != null)) {
            return remoteBuilder_.getMessageOrBuilder();
          } else {
            if (typeCase_ == 1) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote) type_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A generic remote file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote remote = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.RemoteOrBuilder>
            getRemoteFieldBuilder() {
          if (remoteBuilder_ == null) {
            if (!(typeCase_ == 1)) {
              type_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.getDefaultInstance();
            }
            remoteBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote.Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.File.RemoteOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Remote) type_,
                    getParentForChildren(),
                    isClean());
            type_ = null;
          }
          typeCase_ = 1;
          onChanged();
          return remoteBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.GcsOrBuilder>
            gcsBuilder_;
        /**
         *
         *
         * <pre>
         * A Cloud Storage object.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
         *
         * @return Whether the gcs field is set.
         */
        @java.lang.Override
        public boolean hasGcs() {
          return typeCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * A Cloud Storage object.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
         *
         * @return The gcs.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs getGcs() {
          if (gcsBuilder_ == null) {
            if (typeCase_ == 2) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs) type_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.getDefaultInstance();
          } else {
            if (typeCase_ == 2) {
              return gcsBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A Cloud Storage object.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
         */
        public Builder setGcs(com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs value) {
          if (gcsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            type_ = value;
            onChanged();
          } else {
            gcsBuilder_.setMessage(value);
          }
          typeCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Cloud Storage object.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
         */
        public Builder setGcs(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.Builder builderForValue) {
          if (gcsBuilder_ == null) {
            type_ = builderForValue.build();
            onChanged();
          } else {
            gcsBuilder_.setMessage(builderForValue.build());
          }
          typeCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Cloud Storage object.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
         */
        public Builder mergeGcs(com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs value) {
          if (gcsBuilder_ == null) {
            if (typeCase_ == 2
                && type_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs
                        .getDefaultInstance()) {
              type_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs) type_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              type_ = value;
            }
            onChanged();
          } else {
            if (typeCase_ == 2) {
              gcsBuilder_.mergeFrom(value);
            } else {
              gcsBuilder_.setMessage(value);
            }
          }
          typeCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Cloud Storage object.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
         */
        public Builder clearGcs() {
          if (gcsBuilder_ == null) {
            if (typeCase_ == 2) {
              typeCase_ = 0;
              type_ = null;
              onChanged();
            }
          } else {
            if (typeCase_ == 2) {
              typeCase_ = 0;
              type_ = null;
            }
            gcsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Cloud Storage object.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.Builder getGcsBuilder() {
          return getGcsFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A Cloud Storage object.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.GcsOrBuilder getGcsOrBuilder() {
          if ((typeCase_ == 2) && (gcsBuilder_ != null)) {
            return gcsBuilder_.getMessageOrBuilder();
          } else {
            if (typeCase_ == 2) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs) type_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A Cloud Storage object.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs gcs = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.GcsOrBuilder>
            getGcsFieldBuilder() {
          if (gcsBuilder_ == null) {
            if (!(typeCase_ == 2)) {
              type_ = com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.getDefaultInstance();
            }
            gcsBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs.Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.File.GcsOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Gcs) type_,
                    getParentForChildren(),
                    isClean());
            type_ = null;
          }
          typeCase_ = 2;
          onChanged();
          return gcsBuilder_;
        }

        /**
         *
         *
         * <pre>
         * A local path within the VM to use.
         * </pre>
         *
         * <code>string local_path = 3;</code>
         *
         * @return Whether the localPath field is set.
         */
        @java.lang.Override
        public boolean hasLocalPath() {
          return typeCase_ == 3;
        }
        /**
         *
         *
         * <pre>
         * A local path within the VM to use.
         * </pre>
         *
         * <code>string local_path = 3;</code>
         *
         * @return The localPath.
         */
        @java.lang.Override
        public java.lang.String getLocalPath() {
          java.lang.Object ref = "";
          if (typeCase_ == 3) {
            ref = type_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (typeCase_ == 3) {
              type_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A local path within the VM to use.
         * </pre>
         *
         * <code>string local_path = 3;</code>
         *
         * @return The bytes for localPath.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getLocalPathBytes() {
          java.lang.Object ref = "";
          if (typeCase_ == 3) {
            ref = type_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (typeCase_ == 3) {
              type_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A local path within the VM to use.
         * </pre>
         *
         * <code>string local_path = 3;</code>
         *
         * @param value The localPath to set.
         * @return This builder for chaining.
         */
        public Builder setLocalPath(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          typeCase_ = 3;
          type_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A local path within the VM to use.
         * </pre>
         *
         * <code>string local_path = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLocalPath() {
          if (typeCase_ == 3) {
            typeCase_ = 0;
            type_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A local path within the VM to use.
         * </pre>
         *
         * <code>string local_path = 3;</code>
         *
         * @param value The bytes for localPath to set.
         * @return This builder for chaining.
         */
        public Builder setLocalPathBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          typeCase_ = 3;
          type_ = value;
          onChanged();
          return this;
        }

        private boolean allowInsecure_;
        /**
         *
         *
         * <pre>
         * Defaults to false. When false, files are subject to validations
         * based on the file type:
         *
         * Remote: A checksum must be specified.
         * Cloud Storage: An object generation number must be specified.
         * </pre>
         *
         * <code>bool allow_insecure = 4;</code>
         *
         * @return The allowInsecure.
         */
        @java.lang.Override
        public boolean getAllowInsecure() {
          return allowInsecure_;
        }
        /**
         *
         *
         * <pre>
         * Defaults to false. When false, files are subject to validations
         * based on the file type:
         *
         * Remote: A checksum must be specified.
         * Cloud Storage: An object generation number must be specified.
         * </pre>
         *
         * <code>bool allow_insecure = 4;</code>
         *
         * @param value The allowInsecure to set.
         * @return This builder for chaining.
         */
        public Builder setAllowInsecure(boolean value) {

          allowInsecure_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Defaults to false. When false, files are subject to validations
         * based on the file type:
         *
         * Remote: A checksum must be specified.
         * Cloud Storage: An object generation number must be specified.
         * </pre>
         *
         * <code>bool allow_insecure = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAllowInsecure() {
          bitField0_ = (bitField0_ & ~0x00000008);
          allowInsecure_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.File)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.File)
      private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.File DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.OSPolicy.Resource.File();
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.File getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<File> PARSER =
          new com.google.protobuf.AbstractParser<File>() {
            @java.lang.Override
            public File parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<File> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<File> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.File getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface PackageResourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The desired state the agent should maintain for this package.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState desired_state = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for desiredState.
       */
      int getDesiredStateValue();
      /**
       *
       *
       * <pre>
       * Required. The desired state the agent should maintain for this package.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState desired_state = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The desiredState.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState getDesiredState();

      /**
       *
       *
       * <pre>
       * A package managed by Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
       *
       * @return Whether the apt field is set.
       */
      boolean hasApt();
      /**
       *
       *
       * <pre>
       * A package managed by Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
       *
       * @return The apt.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT getApt();
      /**
       *
       *
       * <pre>
       * A package managed by Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APTOrBuilder getAptOrBuilder();

      /**
       *
       *
       * <pre>
       * A deb package file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
       *
       * @return Whether the deb field is set.
       */
      boolean hasDeb();
      /**
       *
       *
       * <pre>
       * A deb package file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
       *
       * @return The deb.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb getDeb();
      /**
       *
       *
       * <pre>
       * A deb package file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DebOrBuilder getDebOrBuilder();

      /**
       *
       *
       * <pre>
       * A package managed by YUM.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
       *
       * @return Whether the yum field is set.
       */
      boolean hasYum();
      /**
       *
       *
       * <pre>
       * A package managed by YUM.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
       *
       * @return The yum.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM getYum();
      /**
       *
       *
       * <pre>
       * A package managed by YUM.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUMOrBuilder getYumOrBuilder();

      /**
       *
       *
       * <pre>
       * A package managed by Zypper.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;</code>
       *
       * @return Whether the zypper field is set.
       */
      boolean hasZypper();
      /**
       *
       *
       * <pre>
       * A package managed by Zypper.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;</code>
       *
       * @return The zypper.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper getZypper();
      /**
       *
       *
       * <pre>
       * A package managed by Zypper.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;</code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.ZypperOrBuilder
          getZypperOrBuilder();

      /**
       *
       *
       * <pre>
       * An rpm package file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
       *
       * @return Whether the rpm field is set.
       */
      boolean hasRpm();
      /**
       *
       *
       * <pre>
       * An rpm package file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
       *
       * @return The rpm.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM getRpm();
      /**
       *
       *
       * <pre>
       * An rpm package file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPMOrBuilder getRpmOrBuilder();

      /**
       *
       *
       * <pre>
       * A package managed by GooGet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;</code>
       *
       * @return Whether the googet field is set.
       */
      boolean hasGooget();
      /**
       *
       *
       * <pre>
       * A package managed by GooGet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;</code>
       *
       * @return The googet.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet getGooget();
      /**
       *
       *
       * <pre>
       * A package managed by GooGet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;</code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGetOrBuilder
          getGoogetOrBuilder();

      /**
       *
       *
       * <pre>
       * An MSI package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
       *
       * @return Whether the msi field is set.
       */
      boolean hasMsi();
      /**
       *
       *
       * <pre>
       * An MSI package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
       *
       * @return The msi.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI getMsi();
      /**
       *
       *
       * <pre>
       * An MSI package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSIOrBuilder getMsiOrBuilder();

      com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.SystemPackageCase
          getSystemPackageCase();
    }
    /**
     *
     *
     * <pre>
     * A resource that manages a system package.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource}
     */
    public static final class PackageResource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource)
        PackageResourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use PackageResource.newBuilder() to construct.
      private PackageResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private PackageResource() {
        desiredState_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new PackageResource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.class,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * The desired state that the OS Config agent maintains on the VM.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState}
       */
      public enum DesiredState implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified is invalid.
         * </pre>
         *
         * <code>DESIRED_STATE_UNSPECIFIED = 0;</code>
         */
        DESIRED_STATE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Ensure that the package is installed.
         * </pre>
         *
         * <code>INSTALLED = 1;</code>
         */
        INSTALLED(1),
        /**
         *
         *
         * <pre>
         * The agent ensures that the package is not installed and
         * uninstalls it if detected.
         * </pre>
         *
         * <code>REMOVED = 2;</code>
         */
        REMOVED(2),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified is invalid.
         * </pre>
         *
         * <code>DESIRED_STATE_UNSPECIFIED = 0;</code>
         */
        public static final int DESIRED_STATE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Ensure that the package is installed.
         * </pre>
         *
         * <code>INSTALLED = 1;</code>
         */
        public static final int INSTALLED_VALUE = 1;
        /**
         *
         *
         * <pre>
         * The agent ensures that the package is not installed and
         * uninstalls it if detected.
         * </pre>
         *
         * <code>REMOVED = 2;</code>
         */
        public static final int REMOVED_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static DesiredState valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static DesiredState forNumber(int value) {
          switch (value) {
            case 0:
              return DESIRED_STATE_UNSPECIFIED;
            case 1:
              return INSTALLED;
            case 2:
              return REMOVED;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<DesiredState> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<DesiredState>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<DesiredState>() {
                  public DesiredState findValueByNumber(int number) {
                    return DesiredState.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final DesiredState[] VALUES = values();

        public static DesiredState valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private DesiredState(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState)
      }

      public interface DebOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. A deb package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the source field is set.
         */
        boolean hasSource();
        /**
         *
         *
         * <pre>
         * Required. A deb package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The source.
         */
        com.google.cloud.osconfig.v1.OSPolicy.Resource.File getSource();
        /**
         *
         *
         * <pre>
         * Required. A deb package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getSourceOrBuilder();

        /**
         *
         *
         * <pre>
         * Whether dependencies should also be installed.
         * - install when false: `dpkg -i package`
         * - install when true: `apt-get update &amp;&amp; apt-get -y install
         * package.deb`
         * </pre>
         *
         * <code>bool pull_deps = 2;</code>
         *
         * @return The pullDeps.
         */
        boolean getPullDeps();
      }
      /**
       *
       *
       * <pre>
       * A deb package file. dpkg packages only support INSTALLED state.
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb}
       */
      public static final class Deb extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb)
          DebOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Deb.newBuilder() to construct.
        private Deb(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Deb() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Deb();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_Deb_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_Deb_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb.Builder.class);
        }

        public static final int SOURCE_FIELD_NUMBER = 1;
        private com.google.cloud.osconfig.v1.OSPolicy.Resource.File source_;
        /**
         *
         *
         * <pre>
         * Required. A deb package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the source field is set.
         */
        @java.lang.Override
        public boolean hasSource() {
          return source_ != null;
        }
        /**
         *
         *
         * <pre>
         * Required. A deb package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The source.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File getSource() {
          return source_ == null
              ? com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()
              : source_;
        }
        /**
         *
         *
         * <pre>
         * Required. A deb package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getSourceOrBuilder() {
          return source_ == null
              ? com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()
              : source_;
        }

        public static final int PULL_DEPS_FIELD_NUMBER = 2;
        private boolean pullDeps_ = false;
        /**
         *
         *
         * <pre>
         * Whether dependencies should also be installed.
         * - install when false: `dpkg -i package`
         * - install when true: `apt-get update &amp;&amp; apt-get -y install
         * package.deb`
         * </pre>
         *
         * <code>bool pull_deps = 2;</code>
         *
         * @return The pullDeps.
         */
        @java.lang.Override
        public boolean getPullDeps() {
          return pullDeps_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (source_ != null) {
            output.writeMessage(1, getSource());
          }
          if (pullDeps_ != false) {
            output.writeBool(2, pullDeps_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (source_ != null) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSource());
          }
          if (pullDeps_ != false) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, pullDeps_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb) obj;

          if (hasSource() != other.hasSource()) return false;
          if (hasSource()) {
            if (!getSource().equals(other.getSource())) return false;
          }
          if (getPullDeps() != other.getPullDeps()) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasSource()) {
            hash = (37 * hash) + SOURCE_FIELD_NUMBER;
            hash = (53 * hash) + getSource().hashCode();
          }
          hash = (37 * hash) + PULL_DEPS_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPullDeps());
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A deb package file. dpkg packages only support INSTALLED state.
         * </pre>
         *
         * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DebOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_Deb_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_Deb_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb.class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb.Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            source_ = null;
            if (sourceBuilder_ != null) {
              sourceBuilder_.dispose();
              sourceBuilder_ = null;
            }
            pullDeps_ = false;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_Deb_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb result =
                new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.source_ = sourceBuilder_ == null ? source_ : sourceBuilder_.build();
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.pullDeps_ = pullDeps_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
                    .getDefaultInstance()) return this;
            if (other.hasSource()) {
              mergeSource(other.getSource());
            }
            if (other.getPullDeps() != false) {
              setPullDeps(other.getPullDeps());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(getSourceFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 16:
                    {
                      pullDeps_ = input.readBool();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 16
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.cloud.osconfig.v1.OSPolicy.Resource.File source_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>
              sourceBuilder_;
          /**
           *
           *
           * <pre>
           * Required. A deb package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return Whether the source field is set.
           */
          public boolean hasSource() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * Required. A deb package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The source.
           */
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File getSource() {
            if (sourceBuilder_ == null) {
              return source_ == null
                  ? com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()
                  : source_;
            } else {
              return sourceBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Required. A deb package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setSource(com.google.cloud.osconfig.v1.OSPolicy.Resource.File value) {
            if (sourceBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              source_ = value;
            } else {
              sourceBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. A deb package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setSource(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder builderForValue) {
            if (sourceBuilder_ == null) {
              source_ = builderForValue.build();
            } else {
              sourceBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. A deb package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder mergeSource(com.google.cloud.osconfig.v1.OSPolicy.Resource.File value) {
            if (sourceBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)
                  && source_ != null
                  && source_
                      != com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()) {
                getSourceBuilder().mergeFrom(value);
              } else {
                source_ = value;
              }
            } else {
              sourceBuilder_.mergeFrom(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. A deb package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder clearSource() {
            bitField0_ = (bitField0_ & ~0x00000001);
            source_ = null;
            if (sourceBuilder_ != null) {
              sourceBuilder_.dispose();
              sourceBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. A deb package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder getSourceBuilder() {
            bitField0_ |= 0x00000001;
            onChanged();
            return getSourceFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Required. A deb package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getSourceOrBuilder() {
            if (sourceBuilder_ != null) {
              return sourceBuilder_.getMessageOrBuilder();
            } else {
              return source_ == null
                  ? com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()
                  : source_;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. A deb package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>
              getSourceFieldBuilder() {
            if (sourceBuilder_ == null) {
              sourceBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                      com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                      com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>(
                      getSource(), getParentForChildren(), isClean());
              source_ = null;
            }
            return sourceBuilder_;
          }

          private boolean pullDeps_;
          /**
           *
           *
           * <pre>
           * Whether dependencies should also be installed.
           * - install when false: `dpkg -i package`
           * - install when true: `apt-get update &amp;&amp; apt-get -y install
           * package.deb`
           * </pre>
           *
           * <code>bool pull_deps = 2;</code>
           *
           * @return The pullDeps.
           */
          @java.lang.Override
          public boolean getPullDeps() {
            return pullDeps_;
          }
          /**
           *
           *
           * <pre>
           * Whether dependencies should also be installed.
           * - install when false: `dpkg -i package`
           * - install when true: `apt-get update &amp;&amp; apt-get -y install
           * package.deb`
           * </pre>
           *
           * <code>bool pull_deps = 2;</code>
           *
           * @param value The pullDeps to set.
           * @return This builder for chaining.
           */
          public Builder setPullDeps(boolean value) {

            pullDeps_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Whether dependencies should also be installed.
           * - install when false: `dpkg -i package`
           * - install when true: `apt-get update &amp;&amp; apt-get -y install
           * package.deb`
           * </pre>
           *
           * <code>bool pull_deps = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPullDeps() {
            bitField0_ = (bitField0_ & ~0x00000002);
            pullDeps_ = false;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Deb> PARSER =
            new com.google.protobuf.AbstractParser<Deb>() {
              @java.lang.Override
              public Deb parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Deb> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Deb> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface APTOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The name.
         */
        java.lang.String getName();
        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for name.
         */
        com.google.protobuf.ByteString getNameBytes();
      }
      /**
       *
       *
       * <pre>
       * A package managed by APT.
       * - install: `apt-get update &amp;&amp; apt-get -y install [name]`
       * - remove: `apt-get -y remove [name]`
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT}
       */
      public static final class APT extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT)
          APTOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use APT.newBuilder() to construct.
        private APT(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private APT() {
          name_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new APT();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_APT_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_APT_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT.Builder.class);
        }

        public static final int NAME_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The name.
         */
        @java.lang.Override
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for name.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT) obj;

          if (!getName().equals(other.getName())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + NAME_FIELD_NUMBER;
          hash = (53 * hash) + getName().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A package managed by APT.
         * - install: `apt-get update &amp;&amp; apt-get -y install [name]`
         * - remove: `apt-get -y remove [name]`
         * </pre>
         *
         * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APTOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_APT_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_APT_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT.class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
                        .Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            name_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_APT_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT result =
                new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.name_ = name_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
                    .getDefaultInstance()) return this;
            if (!other.getName().isEmpty()) {
              name_ = other.name_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      name_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object name_ = "";
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The name.
           */
          public java.lang.String getName() {
            java.lang.Object ref = name_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              name_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for name.
           */
          public com.google.protobuf.ByteString getNameBytes() {
            java.lang.Object ref = name_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              name_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The name to set.
           * @return This builder for chaining.
           */
          public Builder setName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            name_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearName() {
            name_ = getDefaultInstance().getName();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for name to set.
           * @return This builder for chaining.
           */
          public Builder setNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            name_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<APT> PARSER =
            new com.google.protobuf.AbstractParser<APT>() {
              @java.lang.Override
              public APT parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<APT> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<APT> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface RPMOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. An rpm package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the source field is set.
         */
        boolean hasSource();
        /**
         *
         *
         * <pre>
         * Required. An rpm package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The source.
         */
        com.google.cloud.osconfig.v1.OSPolicy.Resource.File getSource();
        /**
         *
         *
         * <pre>
         * Required. An rpm package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getSourceOrBuilder();

        /**
         *
         *
         * <pre>
         * Whether dependencies should also be installed.
         * - install when false: `rpm --upgrade --replacepkgs package.rpm`
         * - install when true: `yum -y install package.rpm` or
         * `zypper -y install package.rpm`
         * </pre>
         *
         * <code>bool pull_deps = 2;</code>
         *
         * @return The pullDeps.
         */
        boolean getPullDeps();
      }
      /**
       *
       *
       * <pre>
       * An RPM package file. RPM packages only support INSTALLED state.
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM}
       */
      public static final class RPM extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM)
          RPMOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use RPM.newBuilder() to construct.
        private RPM(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private RPM() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new RPM();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_RPM_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_RPM_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM.Builder.class);
        }

        public static final int SOURCE_FIELD_NUMBER = 1;
        private com.google.cloud.osconfig.v1.OSPolicy.Resource.File source_;
        /**
         *
         *
         * <pre>
         * Required. An rpm package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the source field is set.
         */
        @java.lang.Override
        public boolean hasSource() {
          return source_ != null;
        }
        /**
         *
         *
         * <pre>
         * Required. An rpm package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The source.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File getSource() {
          return source_ == null
              ? com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()
              : source_;
        }
        /**
         *
         *
         * <pre>
         * Required. An rpm package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getSourceOrBuilder() {
          return source_ == null
              ? com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()
              : source_;
        }

        public static final int PULL_DEPS_FIELD_NUMBER = 2;
        private boolean pullDeps_ = false;
        /**
         *
         *
         * <pre>
         * Whether dependencies should also be installed.
         * - install when false: `rpm --upgrade --replacepkgs package.rpm`
         * - install when true: `yum -y install package.rpm` or
         * `zypper -y install package.rpm`
         * </pre>
         *
         * <code>bool pull_deps = 2;</code>
         *
         * @return The pullDeps.
         */
        @java.lang.Override
        public boolean getPullDeps() {
          return pullDeps_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (source_ != null) {
            output.writeMessage(1, getSource());
          }
          if (pullDeps_ != false) {
            output.writeBool(2, pullDeps_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (source_ != null) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSource());
          }
          if (pullDeps_ != false) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, pullDeps_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM) obj;

          if (hasSource() != other.hasSource()) return false;
          if (hasSource()) {
            if (!getSource().equals(other.getSource())) return false;
          }
          if (getPullDeps() != other.getPullDeps()) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasSource()) {
            hash = (37 * hash) + SOURCE_FIELD_NUMBER;
            hash = (53 * hash) + getSource().hashCode();
          }
          hash = (37 * hash) + PULL_DEPS_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPullDeps());
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * An RPM package file. RPM packages only support INSTALLED state.
         * </pre>
         *
         * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPMOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_RPM_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_RPM_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM.class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
                        .Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            source_ = null;
            if (sourceBuilder_ != null) {
              sourceBuilder_.dispose();
              sourceBuilder_ = null;
            }
            pullDeps_ = false;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_RPM_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM result =
                new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.source_ = sourceBuilder_ == null ? source_ : sourceBuilder_.build();
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.pullDeps_ = pullDeps_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
                    .getDefaultInstance()) return this;
            if (other.hasSource()) {
              mergeSource(other.getSource());
            }
            if (other.getPullDeps() != false) {
              setPullDeps(other.getPullDeps());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(getSourceFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 16:
                    {
                      pullDeps_ = input.readBool();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 16
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.cloud.osconfig.v1.OSPolicy.Resource.File source_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>
              sourceBuilder_;
          /**
           *
           *
           * <pre>
           * Required. An rpm package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return Whether the source field is set.
           */
          public boolean hasSource() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * Required. An rpm package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The source.
           */
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File getSource() {
            if (sourceBuilder_ == null) {
              return source_ == null
                  ? com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()
                  : source_;
            } else {
              return sourceBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Required. An rpm package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setSource(com.google.cloud.osconfig.v1.OSPolicy.Resource.File value) {
            if (sourceBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              source_ = value;
            } else {
              sourceBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. An rpm package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setSource(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder builderForValue) {
            if (sourceBuilder_ == null) {
              source_ = builderForValue.build();
            } else {
              sourceBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. An rpm package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder mergeSource(com.google.cloud.osconfig.v1.OSPolicy.Resource.File value) {
            if (sourceBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)
                  && source_ != null
                  && source_
                      != com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()) {
                getSourceBuilder().mergeFrom(value);
              } else {
                source_ = value;
              }
            } else {
              sourceBuilder_.mergeFrom(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. An rpm package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder clearSource() {
            bitField0_ = (bitField0_ & ~0x00000001);
            source_ = null;
            if (sourceBuilder_ != null) {
              sourceBuilder_.dispose();
              sourceBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. An rpm package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder getSourceBuilder() {
            bitField0_ |= 0x00000001;
            onChanged();
            return getSourceFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Required. An rpm package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getSourceOrBuilder() {
            if (sourceBuilder_ != null) {
              return sourceBuilder_.getMessageOrBuilder();
            } else {
              return source_ == null
                  ? com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()
                  : source_;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. An rpm package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>
              getSourceFieldBuilder() {
            if (sourceBuilder_ == null) {
              sourceBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                      com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                      com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>(
                      getSource(), getParentForChildren(), isClean());
              source_ = null;
            }
            return sourceBuilder_;
          }

          private boolean pullDeps_;
          /**
           *
           *
           * <pre>
           * Whether dependencies should also be installed.
           * - install when false: `rpm --upgrade --replacepkgs package.rpm`
           * - install when true: `yum -y install package.rpm` or
           * `zypper -y install package.rpm`
           * </pre>
           *
           * <code>bool pull_deps = 2;</code>
           *
           * @return The pullDeps.
           */
          @java.lang.Override
          public boolean getPullDeps() {
            return pullDeps_;
          }
          /**
           *
           *
           * <pre>
           * Whether dependencies should also be installed.
           * - install when false: `rpm --upgrade --replacepkgs package.rpm`
           * - install when true: `yum -y install package.rpm` or
           * `zypper -y install package.rpm`
           * </pre>
           *
           * <code>bool pull_deps = 2;</code>
           *
           * @param value The pullDeps to set.
           * @return This builder for chaining.
           */
          public Builder setPullDeps(boolean value) {

            pullDeps_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Whether dependencies should also be installed.
           * - install when false: `rpm --upgrade --replacepkgs package.rpm`
           * - install when true: `yum -y install package.rpm` or
           * `zypper -y install package.rpm`
           * </pre>
           *
           * <code>bool pull_deps = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPullDeps() {
            bitField0_ = (bitField0_ & ~0x00000002);
            pullDeps_ = false;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<RPM> PARSER =
            new com.google.protobuf.AbstractParser<RPM>() {
              @java.lang.Override
              public RPM parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<RPM> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<RPM> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface YUMOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The name.
         */
        java.lang.String getName();
        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for name.
         */
        com.google.protobuf.ByteString getNameBytes();
      }
      /**
       *
       *
       * <pre>
       * A package managed by YUM.
       * - install: `yum -y install package`
       * - remove: `yum -y remove package`
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM}
       */
      public static final class YUM extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM)
          YUMOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use YUM.newBuilder() to construct.
        private YUM(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private YUM() {
          name_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new YUM();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_YUM_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_YUM_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM.Builder.class);
        }

        public static final int NAME_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The name.
         */
        @java.lang.Override
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for name.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM) obj;

          if (!getName().equals(other.getName())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + NAME_FIELD_NUMBER;
          hash = (53 * hash) + getName().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A package managed by YUM.
         * - install: `yum -y install package`
         * - remove: `yum -y remove package`
         * </pre>
         *
         * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUMOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_YUM_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_YUM_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM.class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
                        .Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            name_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_YUM_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM result =
                new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.name_ = name_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
                    .getDefaultInstance()) return this;
            if (!other.getName().isEmpty()) {
              name_ = other.name_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      name_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object name_ = "";
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The name.
           */
          public java.lang.String getName() {
            java.lang.Object ref = name_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              name_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for name.
           */
          public com.google.protobuf.ByteString getNameBytes() {
            java.lang.Object ref = name_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              name_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The name to set.
           * @return This builder for chaining.
           */
          public Builder setName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            name_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearName() {
            name_ = getDefaultInstance().getName();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for name to set.
           * @return This builder for chaining.
           */
          public Builder setNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            name_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<YUM> PARSER =
            new com.google.protobuf.AbstractParser<YUM>() {
              @java.lang.Override
              public YUM parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<YUM> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<YUM> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface ZypperOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The name.
         */
        java.lang.String getName();
        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for name.
         */
        com.google.protobuf.ByteString getNameBytes();
      }
      /**
       *
       *
       * <pre>
       * A package managed by Zypper.
       * - install: `zypper -y install package`
       * - remove: `zypper -y rm package`
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper}
       */
      public static final class Zypper extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)
          ZypperOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Zypper.newBuilder() to construct.
        private Zypper(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Zypper() {
          name_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Zypper();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_Zypper_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_Zypper_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper.Builder
                      .class);
        }

        public static final int NAME_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The name.
         */
        @java.lang.Override
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for name.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper) obj;

          if (!getName().equals(other.getName())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + NAME_FIELD_NUMBER;
          hash = (53 * hash) + getName().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A package managed by Zypper.
         * - install: `zypper -y install package`
         * - remove: `zypper -y rm package`
         * </pre>
         *
         * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.ZypperOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_Zypper_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_Zypper_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper.class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper.Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            name_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_Zypper_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
              buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper result =
                new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.name_ = name_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
                    .getDefaultInstance()) return this;
            if (!other.getName().isEmpty()) {
              name_ = other.name_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      name_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object name_ = "";
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The name.
           */
          public java.lang.String getName() {
            java.lang.Object ref = name_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              name_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for name.
           */
          public com.google.protobuf.ByteString getNameBytes() {
            java.lang.Object ref = name_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              name_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The name to set.
           * @return This builder for chaining.
           */
          public Builder setName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            name_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearName() {
            name_ = getDefaultInstance().getName();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for name to set.
           * @return This builder for chaining.
           */
          public Builder setNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            name_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Zypper> PARSER =
            new com.google.protobuf.AbstractParser<Zypper>() {
              @java.lang.Override
              public Zypper parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Zypper> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Zypper> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface GooGetOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The name.
         */
        java.lang.String getName();
        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for name.
         */
        com.google.protobuf.ByteString getNameBytes();
      }
      /**
       *
       *
       * <pre>
       * A package managed by GooGet.
       * - install: `googet -noconfirm install package`
       * - remove: `googet -noconfirm remove package`
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet}
       */
      public static final class GooGet extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)
          GooGetOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use GooGet.newBuilder() to construct.
        private GooGet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private GooGet() {
          name_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new GooGet();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_GooGet_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_GooGet_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet.Builder
                      .class);
        }

        public static final int NAME_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The name.
         */
        @java.lang.Override
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Package name.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for name.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet) obj;

          if (!getName().equals(other.getName())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + NAME_FIELD_NUMBER;
          hash = (53 * hash) + getName().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A package managed by GooGet.
         * - install: `googet -noconfirm install package`
         * - remove: `googet -noconfirm remove package`
         * </pre>
         *
         * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGetOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_GooGet_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_GooGet_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet.class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet.Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            name_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_GooGet_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
              buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet result =
                new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.name_ = name_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
                    .getDefaultInstance()) return this;
            if (!other.getName().isEmpty()) {
              name_ = other.name_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      name_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object name_ = "";
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The name.
           */
          public java.lang.String getName() {
            java.lang.Object ref = name_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              name_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for name.
           */
          public com.google.protobuf.ByteString getNameBytes() {
            java.lang.Object ref = name_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              name_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The name to set.
           * @return This builder for chaining.
           */
          public Builder setName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            name_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearName() {
            name_ = getDefaultInstance().getName();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Package name.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for name to set.
           * @return This builder for chaining.
           */
          public Builder setNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            name_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<GooGet> PARSER =
            new com.google.protobuf.AbstractParser<GooGet>() {
              @java.lang.Override
              public GooGet parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<GooGet> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<GooGet> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface MSIOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. The MSI package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the source field is set.
         */
        boolean hasSource();
        /**
         *
         *
         * <pre>
         * Required. The MSI package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The source.
         */
        com.google.cloud.osconfig.v1.OSPolicy.Resource.File getSource();
        /**
         *
         *
         * <pre>
         * Required. The MSI package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getSourceOrBuilder();

        /**
         *
         *
         * <pre>
         * Additional properties to use during installation.
         * This should be in the format of Property=Setting.
         * Appended to the defaults of `ACTION=INSTALL
         * REBOOT=ReallySuppress`.
         * </pre>
         *
         * <code>repeated string properties = 2;</code>
         *
         * @return A list containing the properties.
         */
        java.util.List<java.lang.String> getPropertiesList();
        /**
         *
         *
         * <pre>
         * Additional properties to use during installation.
         * This should be in the format of Property=Setting.
         * Appended to the defaults of `ACTION=INSTALL
         * REBOOT=ReallySuppress`.
         * </pre>
         *
         * <code>repeated string properties = 2;</code>
         *
         * @return The count of properties.
         */
        int getPropertiesCount();
        /**
         *
         *
         * <pre>
         * Additional properties to use during installation.
         * This should be in the format of Property=Setting.
         * Appended to the defaults of `ACTION=INSTALL
         * REBOOT=ReallySuppress`.
         * </pre>
         *
         * <code>repeated string properties = 2;</code>
         *
         * @param index The index of the element to return.
         * @return The properties at the given index.
         */
        java.lang.String getProperties(int index);
        /**
         *
         *
         * <pre>
         * Additional properties to use during installation.
         * This should be in the format of Property=Setting.
         * Appended to the defaults of `ACTION=INSTALL
         * REBOOT=ReallySuppress`.
         * </pre>
         *
         * <code>repeated string properties = 2;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the properties at the given index.
         */
        com.google.protobuf.ByteString getPropertiesBytes(int index);
      }
      /**
       *
       *
       * <pre>
       * An MSI package. MSI packages only support INSTALLED state.
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI}
       */
      public static final class MSI extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI)
          MSIOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use MSI.newBuilder() to construct.
        private MSI(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private MSI() {
          properties_ = com.google.protobuf.LazyStringArrayList.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new MSI();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_MSI_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_MSI_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI.Builder.class);
        }

        public static final int SOURCE_FIELD_NUMBER = 1;
        private com.google.cloud.osconfig.v1.OSPolicy.Resource.File source_;
        /**
         *
         *
         * <pre>
         * Required. The MSI package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the source field is set.
         */
        @java.lang.Override
        public boolean hasSource() {
          return source_ != null;
        }
        /**
         *
         *
         * <pre>
         * Required. The MSI package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The source.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File getSource() {
          return source_ == null
              ? com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()
              : source_;
        }
        /**
         *
         *
         * <pre>
         * Required. The MSI package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getSourceOrBuilder() {
          return source_ == null
              ? com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()
              : source_;
        }

        public static final int PROPERTIES_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList properties_ =
            com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         *
         *
         * <pre>
         * Additional properties to use during installation.
         * This should be in the format of Property=Setting.
         * Appended to the defaults of `ACTION=INSTALL
         * REBOOT=ReallySuppress`.
         * </pre>
         *
         * <code>repeated string properties = 2;</code>
         *
         * @return A list containing the properties.
         */
        public com.google.protobuf.ProtocolStringList getPropertiesList() {
          return properties_;
        }
        /**
         *
         *
         * <pre>
         * Additional properties to use during installation.
         * This should be in the format of Property=Setting.
         * Appended to the defaults of `ACTION=INSTALL
         * REBOOT=ReallySuppress`.
         * </pre>
         *
         * <code>repeated string properties = 2;</code>
         *
         * @return The count of properties.
         */
        public int getPropertiesCount() {
          return properties_.size();
        }
        /**
         *
         *
         * <pre>
         * Additional properties to use during installation.
         * This should be in the format of Property=Setting.
         * Appended to the defaults of `ACTION=INSTALL
         * REBOOT=ReallySuppress`.
         * </pre>
         *
         * <code>repeated string properties = 2;</code>
         *
         * @param index The index of the element to return.
         * @return The properties at the given index.
         */
        public java.lang.String getProperties(int index) {
          return properties_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Additional properties to use during installation.
         * This should be in the format of Property=Setting.
         * Appended to the defaults of `ACTION=INSTALL
         * REBOOT=ReallySuppress`.
         * </pre>
         *
         * <code>repeated string properties = 2;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the properties at the given index.
         */
        public com.google.protobuf.ByteString getPropertiesBytes(int index) {
          return properties_.getByteString(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (source_ != null) {
            output.writeMessage(1, getSource());
          }
          for (int i = 0; i < properties_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, properties_.getRaw(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (source_ != null) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSource());
          }
          {
            int dataSize = 0;
            for (int i = 0; i < properties_.size(); i++) {
              dataSize += computeStringSizeNoTag(properties_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getPropertiesList().size();
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI) obj;

          if (hasSource() != other.hasSource()) return false;
          if (hasSource()) {
            if (!getSource().equals(other.getSource())) return false;
          }
          if (!getPropertiesList().equals(other.getPropertiesList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasSource()) {
            hash = (37 * hash) + SOURCE_FIELD_NUMBER;
            hash = (53 * hash) + getSource().hashCode();
          }
          if (getPropertiesCount() > 0) {
            hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
            hash = (53 * hash) + getPropertiesList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * An MSI package. MSI packages only support INSTALLED state.
         * </pre>
         *
         * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSIOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_MSI_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_MSI_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI.class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
                        .Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            source_ = null;
            if (sourceBuilder_ != null) {
              sourceBuilder_.dispose();
              sourceBuilder_ = null;
            }
            properties_ = com.google.protobuf.LazyStringArrayList.emptyList();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_MSI_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI result =
                new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.source_ = sourceBuilder_ == null ? source_ : sourceBuilder_.build();
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              properties_.makeImmutable();
              result.properties_ = properties_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
                    .getDefaultInstance()) return this;
            if (other.hasSource()) {
              mergeSource(other.getSource());
            }
            if (!other.properties_.isEmpty()) {
              if (properties_.isEmpty()) {
                properties_ = other.properties_;
                bitField0_ |= 0x00000002;
              } else {
                ensurePropertiesIsMutable();
                properties_.addAll(other.properties_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(getSourceFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensurePropertiesIsMutable();
                      properties_.add(s);
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.cloud.osconfig.v1.OSPolicy.Resource.File source_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>
              sourceBuilder_;
          /**
           *
           *
           * <pre>
           * Required. The MSI package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return Whether the source field is set.
           */
          public boolean hasSource() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * Required. The MSI package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The source.
           */
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File getSource() {
            if (sourceBuilder_ == null) {
              return source_ == null
                  ? com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()
                  : source_;
            } else {
              return sourceBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The MSI package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setSource(com.google.cloud.osconfig.v1.OSPolicy.Resource.File value) {
            if (sourceBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              source_ = value;
            } else {
              sourceBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The MSI package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder setSource(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder builderForValue) {
            if (sourceBuilder_ == null) {
              source_ = builderForValue.build();
            } else {
              sourceBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The MSI package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder mergeSource(com.google.cloud.osconfig.v1.OSPolicy.Resource.File value) {
            if (sourceBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)
                  && source_ != null
                  && source_
                      != com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()) {
                getSourceBuilder().mergeFrom(value);
              } else {
                source_ = value;
              }
            } else {
              sourceBuilder_.mergeFrom(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The MSI package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public Builder clearSource() {
            bitField0_ = (bitField0_ & ~0x00000001);
            source_ = null;
            if (sourceBuilder_ != null) {
              sourceBuilder_.dispose();
              sourceBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The MSI package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder getSourceBuilder() {
            bitField0_ |= 0x00000001;
            onChanged();
            return getSourceFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Required. The MSI package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getSourceOrBuilder() {
            if (sourceBuilder_ != null) {
              return sourceBuilder_.getMessageOrBuilder();
            } else {
              return source_ == null
                  ? com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()
                  : source_;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The MSI package.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.File source = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>
              getSourceFieldBuilder() {
            if (sourceBuilder_ == null) {
              sourceBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                      com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                      com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>(
                      getSource(), getParentForChildren(), isClean());
              source_ = null;
            }
            return sourceBuilder_;
          }

          private com.google.protobuf.LazyStringArrayList properties_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensurePropertiesIsMutable() {
            if (!properties_.isModifiable()) {
              properties_ = new com.google.protobuf.LazyStringArrayList(properties_);
            }
            bitField0_ |= 0x00000002;
          }
          /**
           *
           *
           * <pre>
           * Additional properties to use during installation.
           * This should be in the format of Property=Setting.
           * Appended to the defaults of `ACTION=INSTALL
           * REBOOT=ReallySuppress`.
           * </pre>
           *
           * <code>repeated string properties = 2;</code>
           *
           * @return A list containing the properties.
           */
          public com.google.protobuf.ProtocolStringList getPropertiesList() {
            properties_.makeImmutable();
            return properties_;
          }
          /**
           *
           *
           * <pre>
           * Additional properties to use during installation.
           * This should be in the format of Property=Setting.
           * Appended to the defaults of `ACTION=INSTALL
           * REBOOT=ReallySuppress`.
           * </pre>
           *
           * <code>repeated string properties = 2;</code>
           *
           * @return The count of properties.
           */
          public int getPropertiesCount() {
            return properties_.size();
          }
          /**
           *
           *
           * <pre>
           * Additional properties to use during installation.
           * This should be in the format of Property=Setting.
           * Appended to the defaults of `ACTION=INSTALL
           * REBOOT=ReallySuppress`.
           * </pre>
           *
           * <code>repeated string properties = 2;</code>
           *
           * @param index The index of the element to return.
           * @return The properties at the given index.
           */
          public java.lang.String getProperties(int index) {
            return properties_.get(index);
          }
          /**
           *
           *
           * <pre>
           * Additional properties to use during installation.
           * This should be in the format of Property=Setting.
           * Appended to the defaults of `ACTION=INSTALL
           * REBOOT=ReallySuppress`.
           * </pre>
           *
           * <code>repeated string properties = 2;</code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the properties at the given index.
           */
          public com.google.protobuf.ByteString getPropertiesBytes(int index) {
            return properties_.getByteString(index);
          }
          /**
           *
           *
           * <pre>
           * Additional properties to use during installation.
           * This should be in the format of Property=Setting.
           * Appended to the defaults of `ACTION=INSTALL
           * REBOOT=ReallySuppress`.
           * </pre>
           *
           * <code>repeated string properties = 2;</code>
           *
           * @param index The index to set the value at.
           * @param value The properties to set.
           * @return This builder for chaining.
           */
          public Builder setProperties(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensurePropertiesIsMutable();
            properties_.set(index, value);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Additional properties to use during installation.
           * This should be in the format of Property=Setting.
           * Appended to the defaults of `ACTION=INSTALL
           * REBOOT=ReallySuppress`.
           * </pre>
           *
           * <code>repeated string properties = 2;</code>
           *
           * @param value The properties to add.
           * @return This builder for chaining.
           */
          public Builder addProperties(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensurePropertiesIsMutable();
            properties_.add(value);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Additional properties to use during installation.
           * This should be in the format of Property=Setting.
           * Appended to the defaults of `ACTION=INSTALL
           * REBOOT=ReallySuppress`.
           * </pre>
           *
           * <code>repeated string properties = 2;</code>
           *
           * @param values The properties to add.
           * @return This builder for chaining.
           */
          public Builder addAllProperties(java.lang.Iterable<java.lang.String> values) {
            ensurePropertiesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, properties_);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Additional properties to use during installation.
           * This should be in the format of Property=Setting.
           * Appended to the defaults of `ACTION=INSTALL
           * REBOOT=ReallySuppress`.
           * </pre>
           *
           * <code>repeated string properties = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearProperties() {
            properties_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            ;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Additional properties to use during installation.
           * This should be in the format of Property=Setting.
           * Appended to the defaults of `ACTION=INSTALL
           * REBOOT=ReallySuppress`.
           * </pre>
           *
           * <code>repeated string properties = 2;</code>
           *
           * @param value The bytes of the properties to add.
           * @return This builder for chaining.
           */
          public Builder addPropertiesBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensurePropertiesIsMutable();
            properties_.add(value);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<MSI> PARSER =
            new com.google.protobuf.AbstractParser<MSI>() {
              @java.lang.Override
              public MSI parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<MSI> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<MSI> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int systemPackageCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object systemPackage_;

      public enum SystemPackageCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        APT(2),
        DEB(3),
        YUM(4),
        ZYPPER(5),
        RPM(6),
        GOOGET(7),
        MSI(8),
        SYSTEMPACKAGE_NOT_SET(0);
        private final int value;

        private SystemPackageCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static SystemPackageCase valueOf(int value) {
          return forNumber(value);
        }

        public static SystemPackageCase forNumber(int value) {
          switch (value) {
            case 2:
              return APT;
            case 3:
              return DEB;
            case 4:
              return YUM;
            case 5:
              return ZYPPER;
            case 6:
              return RPM;
            case 7:
              return GOOGET;
            case 8:
              return MSI;
            case 0:
              return SYSTEMPACKAGE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public SystemPackageCase getSystemPackageCase() {
        return SystemPackageCase.forNumber(systemPackageCase_);
      }

      public static final int DESIRED_STATE_FIELD_NUMBER = 1;
      private int desiredState_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The desired state the agent should maintain for this package.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState desired_state = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for desiredState.
       */
      @java.lang.Override
      public int getDesiredStateValue() {
        return desiredState_;
      }
      /**
       *
       *
       * <pre>
       * Required. The desired state the agent should maintain for this package.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState desired_state = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The desiredState.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState
          getDesiredState() {
        com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState result =
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState.forNumber(
                desiredState_);
        return result == null
            ? com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState
                .UNRECOGNIZED
            : result;
      }

      public static final int APT_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * A package managed by Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
       *
       * @return Whether the apt field is set.
       */
      @java.lang.Override
      public boolean hasApt() {
        return systemPackageCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * A package managed by Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
       *
       * @return The apt.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT getApt() {
        if (systemPackageCase_ == 2) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A package managed by Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APTOrBuilder
          getAptOrBuilder() {
        if (systemPackageCase_ == 2) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
            .getDefaultInstance();
      }

      public static final int DEB_FIELD_NUMBER = 3;
      /**
       *
       *
       * <pre>
       * A deb package file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
       *
       * @return Whether the deb field is set.
       */
      @java.lang.Override
      public boolean hasDeb() {
        return systemPackageCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * A deb package file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
       *
       * @return The deb.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb getDeb() {
        if (systemPackageCase_ == 3) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A deb package file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DebOrBuilder
          getDebOrBuilder() {
        if (systemPackageCase_ == 3) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
            .getDefaultInstance();
      }

      public static final int YUM_FIELD_NUMBER = 4;
      /**
       *
       *
       * <pre>
       * A package managed by YUM.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
       *
       * @return Whether the yum field is set.
       */
      @java.lang.Override
      public boolean hasYum() {
        return systemPackageCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * A package managed by YUM.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
       *
       * @return The yum.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM getYum() {
        if (systemPackageCase_ == 4) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A package managed by YUM.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUMOrBuilder
          getYumOrBuilder() {
        if (systemPackageCase_ == 4) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
            .getDefaultInstance();
      }

      public static final int ZYPPER_FIELD_NUMBER = 5;
      /**
       *
       *
       * <pre>
       * A package managed by Zypper.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;</code>
       *
       * @return Whether the zypper field is set.
       */
      @java.lang.Override
      public boolean hasZypper() {
        return systemPackageCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * A package managed by Zypper.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;</code>
       *
       * @return The zypper.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper getZypper() {
        if (systemPackageCase_ == 5) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A package managed by Zypper.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.ZypperOrBuilder
          getZypperOrBuilder() {
        if (systemPackageCase_ == 5) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
            .getDefaultInstance();
      }

      public static final int RPM_FIELD_NUMBER = 6;
      /**
       *
       *
       * <pre>
       * An rpm package file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
       *
       * @return Whether the rpm field is set.
       */
      @java.lang.Override
      public boolean hasRpm() {
        return systemPackageCase_ == 6;
      }
      /**
       *
       *
       * <pre>
       * An rpm package file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
       *
       * @return The rpm.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM getRpm() {
        if (systemPackageCase_ == 6) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * An rpm package file.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPMOrBuilder
          getRpmOrBuilder() {
        if (systemPackageCase_ == 6) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
            .getDefaultInstance();
      }

      public static final int GOOGET_FIELD_NUMBER = 7;
      /**
       *
       *
       * <pre>
       * A package managed by GooGet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;</code>
       *
       * @return Whether the googet field is set.
       */
      @java.lang.Override
      public boolean hasGooget() {
        return systemPackageCase_ == 7;
      }
      /**
       *
       *
       * <pre>
       * A package managed by GooGet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;</code>
       *
       * @return The googet.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet getGooget() {
        if (systemPackageCase_ == 7) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A package managed by GooGet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGetOrBuilder
          getGoogetOrBuilder() {
        if (systemPackageCase_ == 7) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
            .getDefaultInstance();
      }

      public static final int MSI_FIELD_NUMBER = 8;
      /**
       *
       *
       * <pre>
       * An MSI package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
       *
       * @return Whether the msi field is set.
       */
      @java.lang.Override
      public boolean hasMsi() {
        return systemPackageCase_ == 8;
      }
      /**
       *
       *
       * <pre>
       * An MSI package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
       *
       * @return The msi.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI getMsi() {
        if (systemPackageCase_ == 8) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * An MSI package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSIOrBuilder
          getMsiOrBuilder() {
        if (systemPackageCase_ == 8) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI)
              systemPackage_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
            .getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (desiredState_
            != com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState
                .DESIRED_STATE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, desiredState_);
        }
        if (systemPackageCase_ == 2) {
          output.writeMessage(
              2,
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT) systemPackage_);
        }
        if (systemPackageCase_ == 3) {
          output.writeMessage(
              3,
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb) systemPackage_);
        }
        if (systemPackageCase_ == 4) {
          output.writeMessage(
              4,
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM) systemPackage_);
        }
        if (systemPackageCase_ == 5) {
          output.writeMessage(
              5,
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)
                  systemPackage_);
        }
        if (systemPackageCase_ == 6) {
          output.writeMessage(
              6,
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM) systemPackage_);
        }
        if (systemPackageCase_ == 7) {
          output.writeMessage(
              7,
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)
                  systemPackage_);
        }
        if (systemPackageCase_ == 8) {
          output.writeMessage(
              8,
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI) systemPackage_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (desiredState_
            != com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState
                .DESIRED_STATE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, desiredState_);
        }
        if (systemPackageCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2,
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT)
                      systemPackage_);
        }
        if (systemPackageCase_ == 3) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3,
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb)
                      systemPackage_);
        }
        if (systemPackageCase_ == 4) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  4,
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM)
                      systemPackage_);
        }
        if (systemPackageCase_ == 5) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  5,
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)
                      systemPackage_);
        }
        if (systemPackageCase_ == 6) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  6,
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM)
                      systemPackage_);
        }
        if (systemPackageCase_ == 7) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  7,
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)
                      systemPackage_);
        }
        if (systemPackageCase_ == 8) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  8,
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI)
                      systemPackage_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource)) {
          return super.equals(obj);
        }
        com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource other =
            (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource) obj;

        if (desiredState_ != other.desiredState_) return false;
        if (!getSystemPackageCase().equals(other.getSystemPackageCase())) return false;
        switch (systemPackageCase_) {
          case 2:
            if (!getApt().equals(other.getApt())) return false;
            break;
          case 3:
            if (!getDeb().equals(other.getDeb())) return false;
            break;
          case 4:
            if (!getYum().equals(other.getYum())) return false;
            break;
          case 5:
            if (!getZypper().equals(other.getZypper())) return false;
            break;
          case 6:
            if (!getRpm().equals(other.getRpm())) return false;
            break;
          case 7:
            if (!getGooget().equals(other.getGooget())) return false;
            break;
          case 8:
            if (!getMsi().equals(other.getMsi())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DESIRED_STATE_FIELD_NUMBER;
        hash = (53 * hash) + desiredState_;
        switch (systemPackageCase_) {
          case 2:
            hash = (37 * hash) + APT_FIELD_NUMBER;
            hash = (53 * hash) + getApt().hashCode();
            break;
          case 3:
            hash = (37 * hash) + DEB_FIELD_NUMBER;
            hash = (53 * hash) + getDeb().hashCode();
            break;
          case 4:
            hash = (37 * hash) + YUM_FIELD_NUMBER;
            hash = (53 * hash) + getYum().hashCode();
            break;
          case 5:
            hash = (37 * hash) + ZYPPER_FIELD_NUMBER;
            hash = (53 * hash) + getZypper().hashCode();
            break;
          case 6:
            hash = (37 * hash) + RPM_FIELD_NUMBER;
            hash = (53 * hash) + getRpm().hashCode();
            break;
          case 7:
            hash = (37 * hash) + GOOGET_FIELD_NUMBER;
            hash = (53 * hash) + getGooget().hashCode();
            break;
          case 8:
            hash = (37 * hash) + MSI_FIELD_NUMBER;
            hash = (53 * hash) + getMsi().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A resource that manages a system package.
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource)
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Builder.class);
        }

        // Construct using
        // com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          desiredState_ = 0;
          if (aptBuilder_ != null) {
            aptBuilder_.clear();
          }
          if (debBuilder_ != null) {
            debBuilder_.clear();
          }
          if (yumBuilder_ != null) {
            yumBuilder_.clear();
          }
          if (zypperBuilder_ != null) {
            zypperBuilder_.clear();
          }
          if (rpmBuilder_ != null) {
            rpmBuilder_.clear();
          }
          if (googetBuilder_ != null) {
            googetBuilder_.clear();
          }
          if (msiBuilder_ != null) {
            msiBuilder_.clear();
          }
          systemPackageCase_ = 0;
          systemPackage_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_PackageResource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource
            getDefaultInstanceForType() {
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource build() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource buildPartial() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource result =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.desiredState_ = desiredState_;
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource result) {
          result.systemPackageCase_ = systemPackageCase_;
          result.systemPackage_ = this.systemPackage_;
          if (systemPackageCase_ == 2 && aptBuilder_ != null) {
            result.systemPackage_ = aptBuilder_.build();
          }
          if (systemPackageCase_ == 3 && debBuilder_ != null) {
            result.systemPackage_ = debBuilder_.build();
          }
          if (systemPackageCase_ == 4 && yumBuilder_ != null) {
            result.systemPackage_ = yumBuilder_.build();
          }
          if (systemPackageCase_ == 5 && zypperBuilder_ != null) {
            result.systemPackage_ = zypperBuilder_.build();
          }
          if (systemPackageCase_ == 6 && rpmBuilder_ != null) {
            result.systemPackage_ = rpmBuilder_.build();
          }
          if (systemPackageCase_ == 7 && googetBuilder_ != null) {
            result.systemPackage_ = googetBuilder_.build();
          }
          if (systemPackageCase_ == 8 && msiBuilder_ != null) {
            result.systemPackage_ = msiBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource) {
            return mergeFrom(
                (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource other) {
          if (other
              == com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource
                  .getDefaultInstance()) return this;
          if (other.desiredState_ != 0) {
            setDesiredStateValue(other.getDesiredStateValue());
          }
          switch (other.getSystemPackageCase()) {
            case APT:
              {
                mergeApt(other.getApt());
                break;
              }
            case DEB:
              {
                mergeDeb(other.getDeb());
                break;
              }
            case YUM:
              {
                mergeYum(other.getYum());
                break;
              }
            case ZYPPER:
              {
                mergeZypper(other.getZypper());
                break;
              }
            case RPM:
              {
                mergeRpm(other.getRpm());
                break;
              }
            case GOOGET:
              {
                mergeGooget(other.getGooget());
                break;
              }
            case MSI:
              {
                mergeMsi(other.getMsi());
                break;
              }
            case SYSTEMPACKAGE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    desiredState_ = input.readEnum();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 18:
                  {
                    input.readMessage(getAptFieldBuilder().getBuilder(), extensionRegistry);
                    systemPackageCase_ = 2;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getDebFieldBuilder().getBuilder(), extensionRegistry);
                    systemPackageCase_ = 3;
                    break;
                  } // case 26
                case 34:
                  {
                    input.readMessage(getYumFieldBuilder().getBuilder(), extensionRegistry);
                    systemPackageCase_ = 4;
                    break;
                  } // case 34
                case 42:
                  {
                    input.readMessage(getZypperFieldBuilder().getBuilder(), extensionRegistry);
                    systemPackageCase_ = 5;
                    break;
                  } // case 42
                case 50:
                  {
                    input.readMessage(getRpmFieldBuilder().getBuilder(), extensionRegistry);
                    systemPackageCase_ = 6;
                    break;
                  } // case 50
                case 58:
                  {
                    input.readMessage(getGoogetFieldBuilder().getBuilder(), extensionRegistry);
                    systemPackageCase_ = 7;
                    break;
                  } // case 58
                case 66:
                  {
                    input.readMessage(getMsiFieldBuilder().getBuilder(), extensionRegistry);
                    systemPackageCase_ = 8;
                    break;
                  } // case 66
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int systemPackageCase_ = 0;
        private java.lang.Object systemPackage_;

        public SystemPackageCase getSystemPackageCase() {
          return SystemPackageCase.forNumber(systemPackageCase_);
        }

        public Builder clearSystemPackage() {
          systemPackageCase_ = 0;
          systemPackage_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private int desiredState_ = 0;
        /**
         *
         *
         * <pre>
         * Required. The desired state the agent should maintain for this package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState desired_state = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for desiredState.
         */
        @java.lang.Override
        public int getDesiredStateValue() {
          return desiredState_;
        }
        /**
         *
         *
         * <pre>
         * Required. The desired state the agent should maintain for this package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState desired_state = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @param value The enum numeric value on the wire for desiredState to set.
         * @return This builder for chaining.
         */
        public Builder setDesiredStateValue(int value) {
          desiredState_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The desired state the agent should maintain for this package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState desired_state = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The desiredState.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState
            getDesiredState() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState result =
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState.forNumber(
                  desiredState_);
          return result == null
              ? com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState
                  .UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Required. The desired state the agent should maintain for this package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState desired_state = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @param value The desiredState to set.
         * @return This builder for chaining.
         */
        public Builder setDesiredState(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          desiredState_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The desired state the agent should maintain for this package.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DesiredState desired_state = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDesiredState() {
          bitField0_ = (bitField0_ & ~0x00000001);
          desiredState_ = 0;
          onChanged();
          return this;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APTOrBuilder>
            aptBuilder_;
        /**
         *
         *
         * <pre>
         * A package managed by Apt.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
         *
         * @return Whether the apt field is set.
         */
        @java.lang.Override
        public boolean hasApt() {
          return systemPackageCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * A package managed by Apt.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
         *
         * @return The apt.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT getApt() {
          if (aptBuilder_ == null) {
            if (systemPackageCase_ == 2) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
                .getDefaultInstance();
          } else {
            if (systemPackageCase_ == 2) {
              return aptBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A package managed by Apt.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
         */
        public Builder setApt(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT value) {
          if (aptBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            systemPackage_ = value;
            onChanged();
          } else {
            aptBuilder_.setMessage(value);
          }
          systemPackageCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by Apt.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
         */
        public Builder setApt(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT.Builder
                builderForValue) {
          if (aptBuilder_ == null) {
            systemPackage_ = builderForValue.build();
            onChanged();
          } else {
            aptBuilder_.setMessage(builderForValue.build());
          }
          systemPackageCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by Apt.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
         */
        public Builder mergeApt(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT value) {
          if (aptBuilder_ == null) {
            if (systemPackageCase_ == 2
                && systemPackage_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
                        .getDefaultInstance()) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
                      .newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT)
                              systemPackage_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              systemPackage_ = value;
            }
            onChanged();
          } else {
            if (systemPackageCase_ == 2) {
              aptBuilder_.mergeFrom(value);
            } else {
              aptBuilder_.setMessage(value);
            }
          }
          systemPackageCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by Apt.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
         */
        public Builder clearApt() {
          if (aptBuilder_ == null) {
            if (systemPackageCase_ == 2) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
              onChanged();
            }
          } else {
            if (systemPackageCase_ == 2) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
            }
            aptBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by Apt.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT.Builder
            getAptBuilder() {
          return getAptFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A package managed by Apt.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APTOrBuilder
            getAptOrBuilder() {
          if ((systemPackageCase_ == 2) && (aptBuilder_ != null)) {
            return aptBuilder_.getMessageOrBuilder();
          } else {
            if (systemPackageCase_ == 2) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A package managed by Apt.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT apt = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APTOrBuilder>
            getAptFieldBuilder() {
          if (aptBuilder_ == null) {
            if (!(systemPackageCase_ == 2)) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT
                      .getDefaultInstance();
            }
            aptBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT.Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APTOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.APT)
                        systemPackage_,
                    getParentForChildren(),
                    isClean());
            systemPackage_ = null;
          }
          systemPackageCase_ = 2;
          onChanged();
          return aptBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DebOrBuilder>
            debBuilder_;
        /**
         *
         *
         * <pre>
         * A deb package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
         *
         * @return Whether the deb field is set.
         */
        @java.lang.Override
        public boolean hasDeb() {
          return systemPackageCase_ == 3;
        }
        /**
         *
         *
         * <pre>
         * A deb package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
         *
         * @return The deb.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb getDeb() {
          if (debBuilder_ == null) {
            if (systemPackageCase_ == 3) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
                .getDefaultInstance();
          } else {
            if (systemPackageCase_ == 3) {
              return debBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A deb package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
         */
        public Builder setDeb(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb value) {
          if (debBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            systemPackage_ = value;
            onChanged();
          } else {
            debBuilder_.setMessage(value);
          }
          systemPackageCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A deb package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
         */
        public Builder setDeb(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb.Builder
                builderForValue) {
          if (debBuilder_ == null) {
            systemPackage_ = builderForValue.build();
            onChanged();
          } else {
            debBuilder_.setMessage(builderForValue.build());
          }
          systemPackageCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A deb package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
         */
        public Builder mergeDeb(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb value) {
          if (debBuilder_ == null) {
            if (systemPackageCase_ == 3
                && systemPackage_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
                        .getDefaultInstance()) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb.newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb)
                              systemPackage_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              systemPackage_ = value;
            }
            onChanged();
          } else {
            if (systemPackageCase_ == 3) {
              debBuilder_.mergeFrom(value);
            } else {
              debBuilder_.setMessage(value);
            }
          }
          systemPackageCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A deb package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
         */
        public Builder clearDeb() {
          if (debBuilder_ == null) {
            if (systemPackageCase_ == 3) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
              onChanged();
            }
          } else {
            if (systemPackageCase_ == 3) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
            }
            debBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A deb package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb.Builder
            getDebBuilder() {
          return getDebFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A deb package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DebOrBuilder
            getDebOrBuilder() {
          if ((systemPackageCase_ == 3) && (debBuilder_ != null)) {
            return debBuilder_.getMessageOrBuilder();
          } else {
            if (systemPackageCase_ == 3) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A deb package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb deb = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DebOrBuilder>
            getDebFieldBuilder() {
          if (debBuilder_ == null) {
            if (!(systemPackageCase_ == 3)) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb
                      .getDefaultInstance();
            }
            debBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb.Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.DebOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Deb)
                        systemPackage_,
                    getParentForChildren(),
                    isClean());
            systemPackage_ = null;
          }
          systemPackageCase_ = 3;
          onChanged();
          return debBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUMOrBuilder>
            yumBuilder_;
        /**
         *
         *
         * <pre>
         * A package managed by YUM.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
         *
         * @return Whether the yum field is set.
         */
        @java.lang.Override
        public boolean hasYum() {
          return systemPackageCase_ == 4;
        }
        /**
         *
         *
         * <pre>
         * A package managed by YUM.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
         *
         * @return The yum.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM getYum() {
          if (yumBuilder_ == null) {
            if (systemPackageCase_ == 4) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
                .getDefaultInstance();
          } else {
            if (systemPackageCase_ == 4) {
              return yumBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A package managed by YUM.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
         */
        public Builder setYum(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM value) {
          if (yumBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            systemPackage_ = value;
            onChanged();
          } else {
            yumBuilder_.setMessage(value);
          }
          systemPackageCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by YUM.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
         */
        public Builder setYum(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM.Builder
                builderForValue) {
          if (yumBuilder_ == null) {
            systemPackage_ = builderForValue.build();
            onChanged();
          } else {
            yumBuilder_.setMessage(builderForValue.build());
          }
          systemPackageCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by YUM.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
         */
        public Builder mergeYum(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM value) {
          if (yumBuilder_ == null) {
            if (systemPackageCase_ == 4
                && systemPackage_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
                        .getDefaultInstance()) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
                      .newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM)
                              systemPackage_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              systemPackage_ = value;
            }
            onChanged();
          } else {
            if (systemPackageCase_ == 4) {
              yumBuilder_.mergeFrom(value);
            } else {
              yumBuilder_.setMessage(value);
            }
          }
          systemPackageCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by YUM.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
         */
        public Builder clearYum() {
          if (yumBuilder_ == null) {
            if (systemPackageCase_ == 4) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
              onChanged();
            }
          } else {
            if (systemPackageCase_ == 4) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
            }
            yumBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by YUM.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM.Builder
            getYumBuilder() {
          return getYumFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A package managed by YUM.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUMOrBuilder
            getYumOrBuilder() {
          if ((systemPackageCase_ == 4) && (yumBuilder_ != null)) {
            return yumBuilder_.getMessageOrBuilder();
          } else {
            if (systemPackageCase_ == 4) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A package managed by YUM.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM yum = 4;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUMOrBuilder>
            getYumFieldBuilder() {
          if (yumBuilder_ == null) {
            if (!(systemPackageCase_ == 4)) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM
                      .getDefaultInstance();
            }
            yumBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM.Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUMOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.YUM)
                        systemPackage_,
                    getParentForChildren(),
                    isClean());
            systemPackage_ = null;
          }
          systemPackageCase_ = 4;
          onChanged();
          return yumBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.ZypperOrBuilder>
            zypperBuilder_;
        /**
         *
         *
         * <pre>
         * A package managed by Zypper.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;
         * </code>
         *
         * @return Whether the zypper field is set.
         */
        @java.lang.Override
        public boolean hasZypper() {
          return systemPackageCase_ == 5;
        }
        /**
         *
         *
         * <pre>
         * A package managed by Zypper.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;
         * </code>
         *
         * @return The zypper.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper getZypper() {
          if (zypperBuilder_ == null) {
            if (systemPackageCase_ == 5) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
                .getDefaultInstance();
          } else {
            if (systemPackageCase_ == 5) {
              return zypperBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A package managed by Zypper.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;
         * </code>
         */
        public Builder setZypper(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper value) {
          if (zypperBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            systemPackage_ = value;
            onChanged();
          } else {
            zypperBuilder_.setMessage(value);
          }
          systemPackageCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by Zypper.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;
         * </code>
         */
        public Builder setZypper(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper.Builder
                builderForValue) {
          if (zypperBuilder_ == null) {
            systemPackage_ = builderForValue.build();
            onChanged();
          } else {
            zypperBuilder_.setMessage(builderForValue.build());
          }
          systemPackageCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by Zypper.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;
         * </code>
         */
        public Builder mergeZypper(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper value) {
          if (zypperBuilder_ == null) {
            if (systemPackageCase_ == 5
                && systemPackage_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
                        .getDefaultInstance()) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper.newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)
                              systemPackage_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              systemPackage_ = value;
            }
            onChanged();
          } else {
            if (systemPackageCase_ == 5) {
              zypperBuilder_.mergeFrom(value);
            } else {
              zypperBuilder_.setMessage(value);
            }
          }
          systemPackageCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by Zypper.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;
         * </code>
         */
        public Builder clearZypper() {
          if (zypperBuilder_ == null) {
            if (systemPackageCase_ == 5) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
              onChanged();
            }
          } else {
            if (systemPackageCase_ == 5) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
            }
            zypperBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by Zypper.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper.Builder
            getZypperBuilder() {
          return getZypperFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A package managed by Zypper.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.ZypperOrBuilder
            getZypperOrBuilder() {
          if ((systemPackageCase_ == 5) && (zypperBuilder_ != null)) {
            return zypperBuilder_.getMessageOrBuilder();
          } else {
            if (systemPackageCase_ == 5) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A package managed by Zypper.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper zypper = 5;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.ZypperOrBuilder>
            getZypperFieldBuilder() {
          if (zypperBuilder_ == null) {
            if (!(systemPackageCase_ == 5)) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper
                      .getDefaultInstance();
            }
            zypperBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper.Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.ZypperOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Zypper)
                        systemPackage_,
                    getParentForChildren(),
                    isClean());
            systemPackage_ = null;
          }
          systemPackageCase_ = 5;
          onChanged();
          return zypperBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPMOrBuilder>
            rpmBuilder_;
        /**
         *
         *
         * <pre>
         * An rpm package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
         *
         * @return Whether the rpm field is set.
         */
        @java.lang.Override
        public boolean hasRpm() {
          return systemPackageCase_ == 6;
        }
        /**
         *
         *
         * <pre>
         * An rpm package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
         *
         * @return The rpm.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM getRpm() {
          if (rpmBuilder_ == null) {
            if (systemPackageCase_ == 6) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
                .getDefaultInstance();
          } else {
            if (systemPackageCase_ == 6) {
              return rpmBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * An rpm package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
         */
        public Builder setRpm(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM value) {
          if (rpmBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            systemPackage_ = value;
            onChanged();
          } else {
            rpmBuilder_.setMessage(value);
          }
          systemPackageCase_ = 6;
          return this;
        }
        /**
         *
         *
         * <pre>
         * An rpm package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
         */
        public Builder setRpm(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM.Builder
                builderForValue) {
          if (rpmBuilder_ == null) {
            systemPackage_ = builderForValue.build();
            onChanged();
          } else {
            rpmBuilder_.setMessage(builderForValue.build());
          }
          systemPackageCase_ = 6;
          return this;
        }
        /**
         *
         *
         * <pre>
         * An rpm package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
         */
        public Builder mergeRpm(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM value) {
          if (rpmBuilder_ == null) {
            if (systemPackageCase_ == 6
                && systemPackage_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
                        .getDefaultInstance()) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
                      .newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM)
                              systemPackage_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              systemPackage_ = value;
            }
            onChanged();
          } else {
            if (systemPackageCase_ == 6) {
              rpmBuilder_.mergeFrom(value);
            } else {
              rpmBuilder_.setMessage(value);
            }
          }
          systemPackageCase_ = 6;
          return this;
        }
        /**
         *
         *
         * <pre>
         * An rpm package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
         */
        public Builder clearRpm() {
          if (rpmBuilder_ == null) {
            if (systemPackageCase_ == 6) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
              onChanged();
            }
          } else {
            if (systemPackageCase_ == 6) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
            }
            rpmBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * An rpm package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM.Builder
            getRpmBuilder() {
          return getRpmFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * An rpm package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPMOrBuilder
            getRpmOrBuilder() {
          if ((systemPackageCase_ == 6) && (rpmBuilder_ != null)) {
            return rpmBuilder_.getMessageOrBuilder();
          } else {
            if (systemPackageCase_ == 6) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * An rpm package file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM rpm = 6;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPMOrBuilder>
            getRpmFieldBuilder() {
          if (rpmBuilder_ == null) {
            if (!(systemPackageCase_ == 6)) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM
                      .getDefaultInstance();
            }
            rpmBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM.Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPMOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.RPM)
                        systemPackage_,
                    getParentForChildren(),
                    isClean());
            systemPackage_ = null;
          }
          systemPackageCase_ = 6;
          onChanged();
          return rpmBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGetOrBuilder>
            googetBuilder_;
        /**
         *
         *
         * <pre>
         * A package managed by GooGet.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;
         * </code>
         *
         * @return Whether the googet field is set.
         */
        @java.lang.Override
        public boolean hasGooget() {
          return systemPackageCase_ == 7;
        }
        /**
         *
         *
         * <pre>
         * A package managed by GooGet.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;
         * </code>
         *
         * @return The googet.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet getGooget() {
          if (googetBuilder_ == null) {
            if (systemPackageCase_ == 7) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
                .getDefaultInstance();
          } else {
            if (systemPackageCase_ == 7) {
              return googetBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A package managed by GooGet.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;
         * </code>
         */
        public Builder setGooget(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet value) {
          if (googetBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            systemPackage_ = value;
            onChanged();
          } else {
            googetBuilder_.setMessage(value);
          }
          systemPackageCase_ = 7;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by GooGet.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;
         * </code>
         */
        public Builder setGooget(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet.Builder
                builderForValue) {
          if (googetBuilder_ == null) {
            systemPackage_ = builderForValue.build();
            onChanged();
          } else {
            googetBuilder_.setMessage(builderForValue.build());
          }
          systemPackageCase_ = 7;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by GooGet.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;
         * </code>
         */
        public Builder mergeGooget(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet value) {
          if (googetBuilder_ == null) {
            if (systemPackageCase_ == 7
                && systemPackage_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
                        .getDefaultInstance()) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet.newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)
                              systemPackage_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              systemPackage_ = value;
            }
            onChanged();
          } else {
            if (systemPackageCase_ == 7) {
              googetBuilder_.mergeFrom(value);
            } else {
              googetBuilder_.setMessage(value);
            }
          }
          systemPackageCase_ = 7;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by GooGet.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;
         * </code>
         */
        public Builder clearGooget() {
          if (googetBuilder_ == null) {
            if (systemPackageCase_ == 7) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
              onChanged();
            }
          } else {
            if (systemPackageCase_ == 7) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
            }
            googetBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A package managed by GooGet.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet.Builder
            getGoogetBuilder() {
          return getGoogetFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A package managed by GooGet.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGetOrBuilder
            getGoogetOrBuilder() {
          if ((systemPackageCase_ == 7) && (googetBuilder_ != null)) {
            return googetBuilder_.getMessageOrBuilder();
          } else {
            if (systemPackageCase_ == 7) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A package managed by GooGet.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet googet = 7;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGetOrBuilder>
            getGoogetFieldBuilder() {
          if (googetBuilder_ == null) {
            if (!(systemPackageCase_ == 7)) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet
                      .getDefaultInstance();
            }
            googetBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet.Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGetOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.GooGet)
                        systemPackage_,
                    getParentForChildren(),
                    isClean());
            systemPackage_ = null;
          }
          systemPackageCase_ = 7;
          onChanged();
          return googetBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSIOrBuilder>
            msiBuilder_;
        /**
         *
         *
         * <pre>
         * An MSI package.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
         *
         * @return Whether the msi field is set.
         */
        @java.lang.Override
        public boolean hasMsi() {
          return systemPackageCase_ == 8;
        }
        /**
         *
         *
         * <pre>
         * An MSI package.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
         *
         * @return The msi.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI getMsi() {
          if (msiBuilder_ == null) {
            if (systemPackageCase_ == 8) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
                .getDefaultInstance();
          } else {
            if (systemPackageCase_ == 8) {
              return msiBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * An MSI package.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
         */
        public Builder setMsi(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI value) {
          if (msiBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            systemPackage_ = value;
            onChanged();
          } else {
            msiBuilder_.setMessage(value);
          }
          systemPackageCase_ = 8;
          return this;
        }
        /**
         *
         *
         * <pre>
         * An MSI package.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
         */
        public Builder setMsi(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI.Builder
                builderForValue) {
          if (msiBuilder_ == null) {
            systemPackage_ = builderForValue.build();
            onChanged();
          } else {
            msiBuilder_.setMessage(builderForValue.build());
          }
          systemPackageCase_ = 8;
          return this;
        }
        /**
         *
         *
         * <pre>
         * An MSI package.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
         */
        public Builder mergeMsi(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI value) {
          if (msiBuilder_ == null) {
            if (systemPackageCase_ == 8
                && systemPackage_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
                        .getDefaultInstance()) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
                      .newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI)
                              systemPackage_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              systemPackage_ = value;
            }
            onChanged();
          } else {
            if (systemPackageCase_ == 8) {
              msiBuilder_.mergeFrom(value);
            } else {
              msiBuilder_.setMessage(value);
            }
          }
          systemPackageCase_ = 8;
          return this;
        }
        /**
         *
         *
         * <pre>
         * An MSI package.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
         */
        public Builder clearMsi() {
          if (msiBuilder_ == null) {
            if (systemPackageCase_ == 8) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
              onChanged();
            }
          } else {
            if (systemPackageCase_ == 8) {
              systemPackageCase_ = 0;
              systemPackage_ = null;
            }
            msiBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * An MSI package.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI.Builder
            getMsiBuilder() {
          return getMsiFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * An MSI package.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSIOrBuilder
            getMsiOrBuilder() {
          if ((systemPackageCase_ == 8) && (msiBuilder_ != null)) {
            return msiBuilder_.getMessageOrBuilder();
          } else {
            if (systemPackageCase_ == 8) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI)
                  systemPackage_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * An MSI package.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI msi = 8;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSIOrBuilder>
            getMsiFieldBuilder() {
          if (msiBuilder_ == null) {
            if (!(systemPackageCase_ == 8)) {
              systemPackage_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI
                      .getDefaultInstance();
            }
            msiBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI.Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSIOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.MSI)
                        systemPackage_,
                    getParentForChildren(),
                    isClean());
            systemPackage_ = null;
          }
          systemPackageCase_ = 8;
          onChanged();
          return msiBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource)
      private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource();
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<PackageResource> PARSER =
          new com.google.protobuf.AbstractParser<PackageResource>() {
            @java.lang.Override
            public PackageResource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<PackageResource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<PackageResource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface RepositoryResourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * An Apt Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
       * </code>
       *
       * @return Whether the apt field is set.
       */
      boolean hasApt();
      /**
       *
       *
       * <pre>
       * An Apt Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
       * </code>
       *
       * @return The apt.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository getApt();
      /**
       *
       *
       * <pre>
       * An Apt Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
       * </code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepositoryOrBuilder
          getAptOrBuilder();

      /**
       *
       *
       * <pre>
       * A Yum Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
       * </code>
       *
       * @return Whether the yum field is set.
       */
      boolean hasYum();
      /**
       *
       *
       * <pre>
       * A Yum Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
       * </code>
       *
       * @return The yum.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository getYum();
      /**
       *
       *
       * <pre>
       * A Yum Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
       * </code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepositoryOrBuilder
          getYumOrBuilder();

      /**
       *
       *
       * <pre>
       * A Zypper Repository.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
       * </code>
       *
       * @return Whether the zypper field is set.
       */
      boolean hasZypper();
      /**
       *
       *
       * <pre>
       * A Zypper Repository.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
       * </code>
       *
       * @return The zypper.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
          getZypper();
      /**
       *
       *
       * <pre>
       * A Zypper Repository.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
       * </code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepositoryOrBuilder
          getZypperOrBuilder();

      /**
       *
       *
       * <pre>
       * A Goo Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
       * </code>
       *
       * @return Whether the goo field is set.
       */
      boolean hasGoo();
      /**
       *
       *
       * <pre>
       * A Goo Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
       * </code>
       *
       * @return The goo.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository getGoo();
      /**
       *
       *
       * <pre>
       * A Goo Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
       * </code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepositoryOrBuilder
          getGooOrBuilder();

      com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.RepositoryCase
          getRepositoryCase();
    }
    /**
     *
     *
     * <pre>
     * A resource that manages a package repository.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource}
     */
    public static final class RepositoryResource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource)
        RepositoryResourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use RepositoryResource.newBuilder() to construct.
      private RepositoryResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private RepositoryResource() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new RepositoryResource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.class,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.Builder.class);
      }

      public interface AptRepositoryOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Type of archive files in this repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType archive_type = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for archiveType.
         */
        int getArchiveTypeValue();
        /**
         *
         *
         * <pre>
         * Required. Type of archive files in this repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType archive_type = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The archiveType.
         */
        com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType
            getArchiveType();

        /**
         *
         *
         * <pre>
         * Required. URI for this repository.
         * </pre>
         *
         * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The uri.
         */
        java.lang.String getUri();
        /**
         *
         *
         * <pre>
         * Required. URI for this repository.
         * </pre>
         *
         * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for uri.
         */
        com.google.protobuf.ByteString getUriBytes();

        /**
         *
         *
         * <pre>
         * Required. Distribution of this repository.
         * </pre>
         *
         * <code>string distribution = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The distribution.
         */
        java.lang.String getDistribution();
        /**
         *
         *
         * <pre>
         * Required. Distribution of this repository.
         * </pre>
         *
         * <code>string distribution = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for distribution.
         */
        com.google.protobuf.ByteString getDistributionBytes();

        /**
         *
         *
         * <pre>
         * Required. List of components for this repository. Must contain at
         * least one item.
         * </pre>
         *
         * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the components.
         */
        java.util.List<java.lang.String> getComponentsList();
        /**
         *
         *
         * <pre>
         * Required. List of components for this repository. Must contain at
         * least one item.
         * </pre>
         *
         * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of components.
         */
        int getComponentsCount();
        /**
         *
         *
         * <pre>
         * Required. List of components for this repository. Must contain at
         * least one item.
         * </pre>
         *
         * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The components at the given index.
         */
        java.lang.String getComponents(int index);
        /**
         *
         *
         * <pre>
         * Required. List of components for this repository. Must contain at
         * least one item.
         * </pre>
         *
         * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the components at the given index.
         */
        com.google.protobuf.ByteString getComponentsBytes(int index);

        /**
         *
         *
         * <pre>
         * URI of the key file for this repository. The agent maintains a
         * keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
         * </pre>
         *
         * <code>string gpg_key = 5;</code>
         *
         * @return The gpgKey.
         */
        java.lang.String getGpgKey();
        /**
         *
         *
         * <pre>
         * URI of the key file for this repository. The agent maintains a
         * keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
         * </pre>
         *
         * <code>string gpg_key = 5;</code>
         *
         * @return The bytes for gpgKey.
         */
        com.google.protobuf.ByteString getGpgKeyBytes();
      }
      /**
       *
       *
       * <pre>
       * Represents a single apt package repository. These will be added to
       * a repo file that will be managed at
       * `/etc/apt/sources.list.d/google_osconfig.list`.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository}
       */
      public static final class AptRepository extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository)
          AptRepositoryOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use AptRepository.newBuilder() to construct.
        private AptRepository(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private AptRepository() {
          archiveType_ = 0;
          uri_ = "";
          distribution_ = "";
          components_ = com.google.protobuf.LazyStringArrayList.emptyList();
          gpgKey_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new AptRepository();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_AptRepository_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_AptRepository_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                      .class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                      .Builder.class);
        }

        /**
         *
         *
         * <pre>
         * Type of archive.
         * </pre>
         *
         * Protobuf enum {@code
         * google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType}
         */
        public enum ArchiveType implements com.google.protobuf.ProtocolMessageEnum {
          /**
           *
           *
           * <pre>
           * Unspecified is invalid.
           * </pre>
           *
           * <code>ARCHIVE_TYPE_UNSPECIFIED = 0;</code>
           */
          ARCHIVE_TYPE_UNSPECIFIED(0),
          /**
           *
           *
           * <pre>
           * Deb indicates that the archive contains binary files.
           * </pre>
           *
           * <code>DEB = 1;</code>
           */
          DEB(1),
          /**
           *
           *
           * <pre>
           * Deb-src indicates that the archive contains source files.
           * </pre>
           *
           * <code>DEB_SRC = 2;</code>
           */
          DEB_SRC(2),
          UNRECOGNIZED(-1),
          ;

          /**
           *
           *
           * <pre>
           * Unspecified is invalid.
           * </pre>
           *
           * <code>ARCHIVE_TYPE_UNSPECIFIED = 0;</code>
           */
          public static final int ARCHIVE_TYPE_UNSPECIFIED_VALUE = 0;
          /**
           *
           *
           * <pre>
           * Deb indicates that the archive contains binary files.
           * </pre>
           *
           * <code>DEB = 1;</code>
           */
          public static final int DEB_VALUE = 1;
          /**
           *
           *
           * <pre>
           * Deb-src indicates that the archive contains source files.
           * </pre>
           *
           * <code>DEB_SRC = 2;</code>
           */
          public static final int DEB_SRC_VALUE = 2;

          public final int getNumber() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalArgumentException(
                  "Can't get the number of an unknown enum value.");
            }
            return value;
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static ArchiveType valueOf(int value) {
            return forNumber(value);
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           */
          public static ArchiveType forNumber(int value) {
            switch (value) {
              case 0:
                return ARCHIVE_TYPE_UNSPECIFIED;
              case 1:
                return DEB;
              case 2:
                return DEB_SRC;
              default:
                return null;
            }
          }

          public static com.google.protobuf.Internal.EnumLiteMap<ArchiveType>
              internalGetValueMap() {
            return internalValueMap;
          }

          private static final com.google.protobuf.Internal.EnumLiteMap<ArchiveType>
              internalValueMap =
                  new com.google.protobuf.Internal.EnumLiteMap<ArchiveType>() {
                    public ArchiveType findValueByNumber(int number) {
                      return ArchiveType.forNumber(number);
                    }
                  };

          public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalStateException(
                  "Can't get the descriptor of an unrecognized enum value.");
            }
            return getDescriptor().getValues().get(ordinal());
          }

          public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
            return getDescriptor();
          }

          public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                .getDescriptor()
                .getEnumTypes()
                .get(0);
          }

          private static final ArchiveType[] VALUES = values();

          public static ArchiveType valueOf(
              com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
              throw new java.lang.IllegalArgumentException(
                  "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
              return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
          }

          private final int value;

          private ArchiveType(int value) {
            this.value = value;
          }

          // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType)
        }

        public static final int ARCHIVE_TYPE_FIELD_NUMBER = 1;
        private int archiveType_ = 0;
        /**
         *
         *
         * <pre>
         * Required. Type of archive files in this repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType archive_type = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for archiveType.
         */
        @java.lang.Override
        public int getArchiveTypeValue() {
          return archiveType_;
        }
        /**
         *
         *
         * <pre>
         * Required. Type of archive files in this repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType archive_type = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The archiveType.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                .ArchiveType
            getArchiveType() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                  .ArchiveType
              result =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                      .ArchiveType.forNumber(archiveType_);
          return result == null
              ? com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                  .ArchiveType.UNRECOGNIZED
              : result;
        }

        public static final int URI_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object uri_ = "";
        /**
         *
         *
         * <pre>
         * Required. URI for this repository.
         * </pre>
         *
         * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The uri.
         */
        @java.lang.Override
        public java.lang.String getUri() {
          java.lang.Object ref = uri_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            uri_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. URI for this repository.
         * </pre>
         *
         * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for uri.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getUriBytes() {
          java.lang.Object ref = uri_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            uri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int DISTRIBUTION_FIELD_NUMBER = 3;

        @SuppressWarnings("serial")
        private volatile java.lang.Object distribution_ = "";
        /**
         *
         *
         * <pre>
         * Required. Distribution of this repository.
         * </pre>
         *
         * <code>string distribution = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The distribution.
         */
        @java.lang.Override
        public java.lang.String getDistribution() {
          java.lang.Object ref = distribution_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            distribution_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Distribution of this repository.
         * </pre>
         *
         * <code>string distribution = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for distribution.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getDistributionBytes() {
          java.lang.Object ref = distribution_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            distribution_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int COMPONENTS_FIELD_NUMBER = 4;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList components_ =
            com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         *
         *
         * <pre>
         * Required. List of components for this repository. Must contain at
         * least one item.
         * </pre>
         *
         * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the components.
         */
        public com.google.protobuf.ProtocolStringList getComponentsList() {
          return components_;
        }
        /**
         *
         *
         * <pre>
         * Required. List of components for this repository. Must contain at
         * least one item.
         * </pre>
         *
         * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of components.
         */
        public int getComponentsCount() {
          return components_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. List of components for this repository. Must contain at
         * least one item.
         * </pre>
         *
         * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The components at the given index.
         */
        public java.lang.String getComponents(int index) {
          return components_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Required. List of components for this repository. Must contain at
         * least one item.
         * </pre>
         *
         * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the components at the given index.
         */
        public com.google.protobuf.ByteString getComponentsBytes(int index) {
          return components_.getByteString(index);
        }

        public static final int GPG_KEY_FIELD_NUMBER = 5;

        @SuppressWarnings("serial")
        private volatile java.lang.Object gpgKey_ = "";
        /**
         *
         *
         * <pre>
         * URI of the key file for this repository. The agent maintains a
         * keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
         * </pre>
         *
         * <code>string gpg_key = 5;</code>
         *
         * @return The gpgKey.
         */
        @java.lang.Override
        public java.lang.String getGpgKey() {
          java.lang.Object ref = gpgKey_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            gpgKey_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * URI of the key file for this repository. The agent maintains a
         * keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
         * </pre>
         *
         * <code>string gpg_key = 5;</code>
         *
         * @return The bytes for gpgKey.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getGpgKeyBytes() {
          java.lang.Object ref = gpgKey_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            gpgKey_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (archiveType_
              != com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                  .ArchiveType.ARCHIVE_TYPE_UNSPECIFIED
                  .getNumber()) {
            output.writeEnum(1, archiveType_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(distribution_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 3, distribution_);
          }
          for (int i = 0; i < components_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 4, components_.getRaw(i));
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gpgKey_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 5, gpgKey_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (archiveType_
              != com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                  .ArchiveType.ARCHIVE_TYPE_UNSPECIFIED
                  .getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, archiveType_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(distribution_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, distribution_);
          }
          {
            int dataSize = 0;
            for (int i = 0; i < components_.size(); i++) {
              dataSize += computeStringSizeNoTag(components_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getComponentsList().size();
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gpgKey_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, gpgKey_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository) obj;

          if (archiveType_ != other.archiveType_) return false;
          if (!getUri().equals(other.getUri())) return false;
          if (!getDistribution().equals(other.getDistribution())) return false;
          if (!getComponentsList().equals(other.getComponentsList())) return false;
          if (!getGpgKey().equals(other.getGpgKey())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + ARCHIVE_TYPE_FIELD_NUMBER;
          hash = (53 * hash) + archiveType_;
          hash = (37 * hash) + URI_FIELD_NUMBER;
          hash = (53 * hash) + getUri().hashCode();
          hash = (37 * hash) + DISTRIBUTION_FIELD_NUMBER;
          hash = (53 * hash) + getDistribution().hashCode();
          if (getComponentsCount() > 0) {
            hash = (37 * hash) + COMPONENTS_FIELD_NUMBER;
            hash = (53 * hash) + getComponentsList().hashCode();
          }
          hash = (37 * hash) + GPG_KEY_FIELD_NUMBER;
          hash = (53 * hash) + getGpgKey().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Represents a single apt package repository. These will be added to
         * a repo file that will be managed at
         * `/etc/apt/sources.list.d/google_osconfig.list`.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepositoryOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_AptRepository_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_AptRepository_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                        .class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                        .Builder.class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            archiveType_ = 0;
            uri_ = "";
            distribution_ = "";
            components_ = com.google.protobuf.LazyStringArrayList.emptyList();
            gpgKey_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_AptRepository_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
              build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
              buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository result =
                new com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository(
                    this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.archiveType_ = archiveType_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.uri_ = uri_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.distribution_ = distribution_;
            }
            if (((from_bitField0_ & 0x00000008) != 0)) {
              components_.makeImmutable();
              result.components_ = components_;
            }
            if (((from_bitField0_ & 0x00000010) != 0)) {
              result.gpgKey_ = gpgKey_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                  other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                    .getDefaultInstance()) return this;
            if (other.archiveType_ != 0) {
              setArchiveTypeValue(other.getArchiveTypeValue());
            }
            if (!other.getUri().isEmpty()) {
              uri_ = other.uri_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            if (!other.getDistribution().isEmpty()) {
              distribution_ = other.distribution_;
              bitField0_ |= 0x00000004;
              onChanged();
            }
            if (!other.components_.isEmpty()) {
              if (components_.isEmpty()) {
                components_ = other.components_;
                bitField0_ |= 0x00000008;
              } else {
                ensureComponentsIsMutable();
                components_.addAll(other.components_);
              }
              onChanged();
            }
            if (!other.getGpgKey().isEmpty()) {
              gpgKey_ = other.gpgKey_;
              bitField0_ |= 0x00000010;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      archiveType_ = input.readEnum();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  case 18:
                    {
                      uri_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  case 26:
                    {
                      distribution_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 26
                  case 34:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureComponentsIsMutable();
                      components_.add(s);
                      break;
                    } // case 34
                  case 42:
                    {
                      gpgKey_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000010;
                      break;
                    } // case 42
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int archiveType_ = 0;
          /**
           *
           *
           * <pre>
           * Required. Type of archive files in this repository.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType archive_type = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The enum numeric value on the wire for archiveType.
           */
          @java.lang.Override
          public int getArchiveTypeValue() {
            return archiveType_;
          }
          /**
           *
           *
           * <pre>
           * Required. Type of archive files in this repository.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType archive_type = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @param value The enum numeric value on the wire for archiveType to set.
           * @return This builder for chaining.
           */
          public Builder setArchiveTypeValue(int value) {
            archiveType_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Type of archive files in this repository.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType archive_type = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The archiveType.
           */
          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                  .ArchiveType
              getArchiveType() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                    .ArchiveType
                result =
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                        .ArchiveType.forNumber(archiveType_);
            return result == null
                ? com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                    .ArchiveType.UNRECOGNIZED
                : result;
          }
          /**
           *
           *
           * <pre>
           * Required. Type of archive files in this repository.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType archive_type = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @param value The archiveType to set.
           * @return This builder for chaining.
           */
          public Builder setArchiveType(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                      .ArchiveType
                  value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000001;
            archiveType_ = value.getNumber();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Type of archive files in this repository.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType archive_type = 1 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearArchiveType() {
            bitField0_ = (bitField0_ & ~0x00000001);
            archiveType_ = 0;
            onChanged();
            return this;
          }

          private java.lang.Object uri_ = "";
          /**
           *
           *
           * <pre>
           * Required. URI for this repository.
           * </pre>
           *
           * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The uri.
           */
          public java.lang.String getUri() {
            java.lang.Object ref = uri_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              uri_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. URI for this repository.
           * </pre>
           *
           * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for uri.
           */
          public com.google.protobuf.ByteString getUriBytes() {
            java.lang.Object ref = uri_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              uri_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. URI for this repository.
           * </pre>
           *
           * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The uri to set.
           * @return This builder for chaining.
           */
          public Builder setUri(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            uri_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. URI for this repository.
           * </pre>
           *
           * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearUri() {
            uri_ = getDefaultInstance().getUri();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. URI for this repository.
           * </pre>
           *
           * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for uri to set.
           * @return This builder for chaining.
           */
          public Builder setUriBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            uri_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          private java.lang.Object distribution_ = "";
          /**
           *
           *
           * <pre>
           * Required. Distribution of this repository.
           * </pre>
           *
           * <code>string distribution = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The distribution.
           */
          public java.lang.String getDistribution() {
            java.lang.Object ref = distribution_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              distribution_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Distribution of this repository.
           * </pre>
           *
           * <code>string distribution = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for distribution.
           */
          public com.google.protobuf.ByteString getDistributionBytes() {
            java.lang.Object ref = distribution_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              distribution_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Distribution of this repository.
           * </pre>
           *
           * <code>string distribution = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The distribution to set.
           * @return This builder for chaining.
           */
          public Builder setDistribution(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            distribution_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Distribution of this repository.
           * </pre>
           *
           * <code>string distribution = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDistribution() {
            distribution_ = getDefaultInstance().getDistribution();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Distribution of this repository.
           * </pre>
           *
           * <code>string distribution = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for distribution to set.
           * @return This builder for chaining.
           */
          public Builder setDistributionBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            distribution_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringArrayList components_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureComponentsIsMutable() {
            if (!components_.isModifiable()) {
              components_ = new com.google.protobuf.LazyStringArrayList(components_);
            }
            bitField0_ |= 0x00000008;
          }
          /**
           *
           *
           * <pre>
           * Required. List of components for this repository. Must contain at
           * least one item.
           * </pre>
           *
           * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return A list containing the components.
           */
          public com.google.protobuf.ProtocolStringList getComponentsList() {
            components_.makeImmutable();
            return components_;
          }
          /**
           *
           *
           * <pre>
           * Required. List of components for this repository. Must contain at
           * least one item.
           * </pre>
           *
           * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The count of components.
           */
          public int getComponentsCount() {
            return components_.size();
          }
          /**
           *
           *
           * <pre>
           * Required. List of components for this repository. Must contain at
           * least one item.
           * </pre>
           *
           * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index of the element to return.
           * @return The components at the given index.
           */
          public java.lang.String getComponents(int index) {
            return components_.get(index);
          }
          /**
           *
           *
           * <pre>
           * Required. List of components for this repository. Must contain at
           * least one item.
           * </pre>
           *
           * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the components at the given index.
           */
          public com.google.protobuf.ByteString getComponentsBytes(int index) {
            return components_.getByteString(index);
          }
          /**
           *
           *
           * <pre>
           * Required. List of components for this repository. Must contain at
           * least one item.
           * </pre>
           *
           * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index to set the value at.
           * @param value The components to set.
           * @return This builder for chaining.
           */
          public Builder setComponents(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureComponentsIsMutable();
            components_.set(index, value);
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. List of components for this repository. Must contain at
           * least one item.
           * </pre>
           *
           * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The components to add.
           * @return This builder for chaining.
           */
          public Builder addComponents(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureComponentsIsMutable();
            components_.add(value);
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. List of components for this repository. Must contain at
           * least one item.
           * </pre>
           *
           * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param values The components to add.
           * @return This builder for chaining.
           */
          public Builder addAllComponents(java.lang.Iterable<java.lang.String> values) {
            ensureComponentsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, components_);
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. List of components for this repository. Must contain at
           * least one item.
           * </pre>
           *
           * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearComponents() {
            components_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            ;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. List of components for this repository. Must contain at
           * least one item.
           * </pre>
           *
           * <code>repeated string components = 4 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes of the components to add.
           * @return This builder for chaining.
           */
          public Builder addComponentsBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureComponentsIsMutable();
            components_.add(value);
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }

          private java.lang.Object gpgKey_ = "";
          /**
           *
           *
           * <pre>
           * URI of the key file for this repository. The agent maintains a
           * keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
           * </pre>
           *
           * <code>string gpg_key = 5;</code>
           *
           * @return The gpgKey.
           */
          public java.lang.String getGpgKey() {
            java.lang.Object ref = gpgKey_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              gpgKey_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * URI of the key file for this repository. The agent maintains a
           * keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
           * </pre>
           *
           * <code>string gpg_key = 5;</code>
           *
           * @return The bytes for gpgKey.
           */
          public com.google.protobuf.ByteString getGpgKeyBytes() {
            java.lang.Object ref = gpgKey_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              gpgKey_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * URI of the key file for this repository. The agent maintains a
           * keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
           * </pre>
           *
           * <code>string gpg_key = 5;</code>
           *
           * @param value The gpgKey to set.
           * @return This builder for chaining.
           */
          public Builder setGpgKey(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            gpgKey_ = value;
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * URI of the key file for this repository. The agent maintains a
           * keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
           * </pre>
           *
           * <code>string gpg_key = 5;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearGpgKey() {
            gpgKey_ = getDefaultInstance().getGpgKey();
            bitField0_ = (bitField0_ & ~0x00000010);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * URI of the key file for this repository. The agent maintains a
           * keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
           * </pre>
           *
           * <code>string gpg_key = 5;</code>
           *
           * @param value The bytes for gpgKey to set.
           * @return This builder for chaining.
           */
          public Builder setGpgKeyBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            gpgKey_ = value;
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepository
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<AptRepository> PARSER =
            new com.google.protobuf.AbstractParser<AptRepository>() {
              @java.lang.Override
              public AptRepository parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<AptRepository> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<AptRepository> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface YumRepositoryOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. A one word, unique name for this repository. This is  the
         * `repo id` in the yum config file and also the `display_name` if
         * `display_name` is omitted. This id is also used as the unique
         * identifier when checking for resource conflicts.
         * </pre>
         *
         * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The id.
         */
        java.lang.String getId();
        /**
         *
         *
         * <pre>
         * Required. A one word, unique name for this repository. This is  the
         * `repo id` in the yum config file and also the `display_name` if
         * `display_name` is omitted. This id is also used as the unique
         * identifier when checking for resource conflicts.
         * </pre>
         *
         * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for id.
         */
        com.google.protobuf.ByteString getIdBytes();

        /**
         *
         *
         * <pre>
         * The display name of the repository.
         * </pre>
         *
         * <code>string display_name = 2;</code>
         *
         * @return The displayName.
         */
        java.lang.String getDisplayName();
        /**
         *
         *
         * <pre>
         * The display name of the repository.
         * </pre>
         *
         * <code>string display_name = 2;</code>
         *
         * @return The bytes for displayName.
         */
        com.google.protobuf.ByteString getDisplayNameBytes();

        /**
         *
         *
         * <pre>
         * Required. The location of the repository directory.
         * </pre>
         *
         * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The baseUrl.
         */
        java.lang.String getBaseUrl();
        /**
         *
         *
         * <pre>
         * Required. The location of the repository directory.
         * </pre>
         *
         * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for baseUrl.
         */
        com.google.protobuf.ByteString getBaseUrlBytes();

        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @return A list containing the gpgKeys.
         */
        java.util.List<java.lang.String> getGpgKeysList();
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @return The count of gpgKeys.
         */
        int getGpgKeysCount();
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @param index The index of the element to return.
         * @return The gpgKeys at the given index.
         */
        java.lang.String getGpgKeys(int index);
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the gpgKeys at the given index.
         */
        com.google.protobuf.ByteString getGpgKeysBytes(int index);
      }
      /**
       *
       *
       * <pre>
       * Represents a single yum package repository. These are added to a
       * repo file that is managed at
       * `/etc/yum.repos.d/google_osconfig.repo`.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository}
       */
      public static final class YumRepository extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository)
          YumRepositoryOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use YumRepository.newBuilder() to construct.
        private YumRepository(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private YumRepository() {
          id_ = "";
          displayName_ = "";
          baseUrl_ = "";
          gpgKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new YumRepository();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_YumRepository_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_YumRepository_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                      .class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                      .Builder.class);
        }

        public static final int ID_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object id_ = "";
        /**
         *
         *
         * <pre>
         * Required. A one word, unique name for this repository. This is  the
         * `repo id` in the yum config file and also the `display_name` if
         * `display_name` is omitted. This id is also used as the unique
         * identifier when checking for resource conflicts.
         * </pre>
         *
         * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The id.
         */
        @java.lang.Override
        public java.lang.String getId() {
          java.lang.Object ref = id_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            id_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A one word, unique name for this repository. This is  the
         * `repo id` in the yum config file and also the `display_name` if
         * `display_name` is omitted. This id is also used as the unique
         * identifier when checking for resource conflicts.
         * </pre>
         *
         * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for id.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getIdBytes() {
          java.lang.Object ref = id_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            id_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object displayName_ = "";
        /**
         *
         *
         * <pre>
         * The display name of the repository.
         * </pre>
         *
         * <code>string display_name = 2;</code>
         *
         * @return The displayName.
         */
        @java.lang.Override
        public java.lang.String getDisplayName() {
          java.lang.Object ref = displayName_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            displayName_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The display name of the repository.
         * </pre>
         *
         * <code>string display_name = 2;</code>
         *
         * @return The bytes for displayName.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getDisplayNameBytes() {
          java.lang.Object ref = displayName_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            displayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int BASE_URL_FIELD_NUMBER = 3;

        @SuppressWarnings("serial")
        private volatile java.lang.Object baseUrl_ = "";
        /**
         *
         *
         * <pre>
         * Required. The location of the repository directory.
         * </pre>
         *
         * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The baseUrl.
         */
        @java.lang.Override
        public java.lang.String getBaseUrl() {
          java.lang.Object ref = baseUrl_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            baseUrl_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The location of the repository directory.
         * </pre>
         *
         * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for baseUrl.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getBaseUrlBytes() {
          java.lang.Object ref = baseUrl_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            baseUrl_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int GPG_KEYS_FIELD_NUMBER = 4;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList gpgKeys_ =
            com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @return A list containing the gpgKeys.
         */
        public com.google.protobuf.ProtocolStringList getGpgKeysList() {
          return gpgKeys_;
        }
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @return The count of gpgKeys.
         */
        public int getGpgKeysCount() {
          return gpgKeys_.size();
        }
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @param index The index of the element to return.
         * @return The gpgKeys at the given index.
         */
        public java.lang.String getGpgKeys(int index) {
          return gpgKeys_.get(index);
        }
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the gpgKeys at the given index.
         */
        public com.google.protobuf.ByteString getGpgKeysBytes(int index) {
          return gpgKeys_.getByteString(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseUrl_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 3, baseUrl_);
          }
          for (int i = 0; i < gpgKeys_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 4, gpgKeys_.getRaw(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseUrl_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, baseUrl_);
          }
          {
            int dataSize = 0;
            for (int i = 0; i < gpgKeys_.size(); i++) {
              dataSize += computeStringSizeNoTag(gpgKeys_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getGpgKeysList().size();
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository) obj;

          if (!getId().equals(other.getId())) return false;
          if (!getDisplayName().equals(other.getDisplayName())) return false;
          if (!getBaseUrl().equals(other.getBaseUrl())) return false;
          if (!getGpgKeysList().equals(other.getGpgKeysList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + ID_FIELD_NUMBER;
          hash = (53 * hash) + getId().hashCode();
          hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getDisplayName().hashCode();
          hash = (37 * hash) + BASE_URL_FIELD_NUMBER;
          hash = (53 * hash) + getBaseUrl().hashCode();
          if (getGpgKeysCount() > 0) {
            hash = (37 * hash) + GPG_KEYS_FIELD_NUMBER;
            hash = (53 * hash) + getGpgKeysList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Represents a single yum package repository. These are added to a
         * repo file that is managed at
         * `/etc/yum.repos.d/google_osconfig.repo`.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepositoryOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_YumRepository_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_YumRepository_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                        .class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                        .Builder.class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            id_ = "";
            displayName_ = "";
            baseUrl_ = "";
            gpgKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_YumRepository_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
              build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
              buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository result =
                new com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository(
                    this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.id_ = id_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.displayName_ = displayName_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.baseUrl_ = baseUrl_;
            }
            if (((from_bitField0_ & 0x00000008) != 0)) {
              gpgKeys_.makeImmutable();
              result.gpgKeys_ = gpgKeys_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                  other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                    .getDefaultInstance()) return this;
            if (!other.getId().isEmpty()) {
              id_ = other.id_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getDisplayName().isEmpty()) {
              displayName_ = other.displayName_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            if (!other.getBaseUrl().isEmpty()) {
              baseUrl_ = other.baseUrl_;
              bitField0_ |= 0x00000004;
              onChanged();
            }
            if (!other.gpgKeys_.isEmpty()) {
              if (gpgKeys_.isEmpty()) {
                gpgKeys_ = other.gpgKeys_;
                bitField0_ |= 0x00000008;
              } else {
                ensureGpgKeysIsMutable();
                gpgKeys_.addAll(other.gpgKeys_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      id_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      displayName_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  case 26:
                    {
                      baseUrl_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 26
                  case 34:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureGpgKeysIsMutable();
                      gpgKeys_.add(s);
                      break;
                    } // case 34
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object id_ = "";
          /**
           *
           *
           * <pre>
           * Required. A one word, unique name for this repository. This is  the
           * `repo id` in the yum config file and also the `display_name` if
           * `display_name` is omitted. This id is also used as the unique
           * identifier when checking for resource conflicts.
           * </pre>
           *
           * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The id.
           */
          public java.lang.String getId() {
            java.lang.Object ref = id_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              id_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. A one word, unique name for this repository. This is  the
           * `repo id` in the yum config file and also the `display_name` if
           * `display_name` is omitted. This id is also used as the unique
           * identifier when checking for resource conflicts.
           * </pre>
           *
           * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for id.
           */
          public com.google.protobuf.ByteString getIdBytes() {
            java.lang.Object ref = id_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              id_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. A one word, unique name for this repository. This is  the
           * `repo id` in the yum config file and also the `display_name` if
           * `display_name` is omitted. This id is also used as the unique
           * identifier when checking for resource conflicts.
           * </pre>
           *
           * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The id to set.
           * @return This builder for chaining.
           */
          public Builder setId(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            id_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. A one word, unique name for this repository. This is  the
           * `repo id` in the yum config file and also the `display_name` if
           * `display_name` is omitted. This id is also used as the unique
           * identifier when checking for resource conflicts.
           * </pre>
           *
           * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearId() {
            id_ = getDefaultInstance().getId();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. A one word, unique name for this repository. This is  the
           * `repo id` in the yum config file and also the `display_name` if
           * `display_name` is omitted. This id is also used as the unique
           * identifier when checking for resource conflicts.
           * </pre>
           *
           * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for id to set.
           * @return This builder for chaining.
           */
          public Builder setIdBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            id_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object displayName_ = "";
          /**
           *
           *
           * <pre>
           * The display name of the repository.
           * </pre>
           *
           * <code>string display_name = 2;</code>
           *
           * @return The displayName.
           */
          public java.lang.String getDisplayName() {
            java.lang.Object ref = displayName_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              displayName_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The display name of the repository.
           * </pre>
           *
           * <code>string display_name = 2;</code>
           *
           * @return The bytes for displayName.
           */
          public com.google.protobuf.ByteString getDisplayNameBytes() {
            java.lang.Object ref = displayName_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              displayName_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The display name of the repository.
           * </pre>
           *
           * <code>string display_name = 2;</code>
           *
           * @param value The displayName to set.
           * @return This builder for chaining.
           */
          public Builder setDisplayName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            displayName_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The display name of the repository.
           * </pre>
           *
           * <code>string display_name = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDisplayName() {
            displayName_ = getDefaultInstance().getDisplayName();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The display name of the repository.
           * </pre>
           *
           * <code>string display_name = 2;</code>
           *
           * @param value The bytes for displayName to set.
           * @return This builder for chaining.
           */
          public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            displayName_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          private java.lang.Object baseUrl_ = "";
          /**
           *
           *
           * <pre>
           * Required. The location of the repository directory.
           * </pre>
           *
           * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The baseUrl.
           */
          public java.lang.String getBaseUrl() {
            java.lang.Object ref = baseUrl_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              baseUrl_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The location of the repository directory.
           * </pre>
           *
           * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for baseUrl.
           */
          public com.google.protobuf.ByteString getBaseUrlBytes() {
            java.lang.Object ref = baseUrl_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              baseUrl_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The location of the repository directory.
           * </pre>
           *
           * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The baseUrl to set.
           * @return This builder for chaining.
           */
          public Builder setBaseUrl(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            baseUrl_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The location of the repository directory.
           * </pre>
           *
           * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearBaseUrl() {
            baseUrl_ = getDefaultInstance().getBaseUrl();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The location of the repository directory.
           * </pre>
           *
           * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for baseUrl to set.
           * @return This builder for chaining.
           */
          public Builder setBaseUrlBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            baseUrl_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringArrayList gpgKeys_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureGpgKeysIsMutable() {
            if (!gpgKeys_.isModifiable()) {
              gpgKeys_ = new com.google.protobuf.LazyStringArrayList(gpgKeys_);
            }
            bitField0_ |= 0x00000008;
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @return A list containing the gpgKeys.
           */
          public com.google.protobuf.ProtocolStringList getGpgKeysList() {
            gpgKeys_.makeImmutable();
            return gpgKeys_;
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @return The count of gpgKeys.
           */
          public int getGpgKeysCount() {
            return gpgKeys_.size();
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @param index The index of the element to return.
           * @return The gpgKeys at the given index.
           */
          public java.lang.String getGpgKeys(int index) {
            return gpgKeys_.get(index);
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the gpgKeys at the given index.
           */
          public com.google.protobuf.ByteString getGpgKeysBytes(int index) {
            return gpgKeys_.getByteString(index);
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @param index The index to set the value at.
           * @param value The gpgKeys to set.
           * @return This builder for chaining.
           */
          public Builder setGpgKeys(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureGpgKeysIsMutable();
            gpgKeys_.set(index, value);
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @param value The gpgKeys to add.
           * @return This builder for chaining.
           */
          public Builder addGpgKeys(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureGpgKeysIsMutable();
            gpgKeys_.add(value);
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @param values The gpgKeys to add.
           * @return This builder for chaining.
           */
          public Builder addAllGpgKeys(java.lang.Iterable<java.lang.String> values) {
            ensureGpgKeysIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, gpgKeys_);
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearGpgKeys() {
            gpgKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            ;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @param value The bytes of the gpgKeys to add.
           * @return This builder for chaining.
           */
          public Builder addGpgKeysBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureGpgKeysIsMutable();
            gpgKeys_.add(value);
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepository
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<YumRepository> PARSER =
            new com.google.protobuf.AbstractParser<YumRepository>() {
              @java.lang.Override
              public YumRepository parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<YumRepository> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<YumRepository> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface ZypperRepositoryOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. A one word, unique name for this repository. This is the
         * `repo id` in the zypper config file and also the `display_name` if
         * `display_name` is omitted. This id is also used as the unique
         * identifier when checking for GuestPolicy conflicts.
         * </pre>
         *
         * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The id.
         */
        java.lang.String getId();
        /**
         *
         *
         * <pre>
         * Required. A one word, unique name for this repository. This is the
         * `repo id` in the zypper config file and also the `display_name` if
         * `display_name` is omitted. This id is also used as the unique
         * identifier when checking for GuestPolicy conflicts.
         * </pre>
         *
         * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for id.
         */
        com.google.protobuf.ByteString getIdBytes();

        /**
         *
         *
         * <pre>
         * The display name of the repository.
         * </pre>
         *
         * <code>string display_name = 2;</code>
         *
         * @return The displayName.
         */
        java.lang.String getDisplayName();
        /**
         *
         *
         * <pre>
         * The display name of the repository.
         * </pre>
         *
         * <code>string display_name = 2;</code>
         *
         * @return The bytes for displayName.
         */
        com.google.protobuf.ByteString getDisplayNameBytes();

        /**
         *
         *
         * <pre>
         * Required. The location of the repository directory.
         * </pre>
         *
         * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The baseUrl.
         */
        java.lang.String getBaseUrl();
        /**
         *
         *
         * <pre>
         * Required. The location of the repository directory.
         * </pre>
         *
         * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for baseUrl.
         */
        com.google.protobuf.ByteString getBaseUrlBytes();

        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @return A list containing the gpgKeys.
         */
        java.util.List<java.lang.String> getGpgKeysList();
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @return The count of gpgKeys.
         */
        int getGpgKeysCount();
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @param index The index of the element to return.
         * @return The gpgKeys at the given index.
         */
        java.lang.String getGpgKeys(int index);
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the gpgKeys at the given index.
         */
        com.google.protobuf.ByteString getGpgKeysBytes(int index);
      }
      /**
       *
       *
       * <pre>
       * Represents a single zypper package repository. These are added to a
       * repo file that is managed at
       * `/etc/zypp/repos.d/google_osconfig.repo`.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository}
       */
      public static final class ZypperRepository extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository)
          ZypperRepositoryOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use ZypperRepository.newBuilder() to construct.
        private ZypperRepository(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private ZypperRepository() {
          id_ = "";
          displayName_ = "";
          baseUrl_ = "";
          gpgKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new ZypperRepository();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_ZypperRepository_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_ZypperRepository_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                      .class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                      .Builder.class);
        }

        public static final int ID_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object id_ = "";
        /**
         *
         *
         * <pre>
         * Required. A one word, unique name for this repository. This is the
         * `repo id` in the zypper config file and also the `display_name` if
         * `display_name` is omitted. This id is also used as the unique
         * identifier when checking for GuestPolicy conflicts.
         * </pre>
         *
         * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The id.
         */
        @java.lang.Override
        public java.lang.String getId() {
          java.lang.Object ref = id_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            id_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A one word, unique name for this repository. This is the
         * `repo id` in the zypper config file and also the `display_name` if
         * `display_name` is omitted. This id is also used as the unique
         * identifier when checking for GuestPolicy conflicts.
         * </pre>
         *
         * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for id.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getIdBytes() {
          java.lang.Object ref = id_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            id_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object displayName_ = "";
        /**
         *
         *
         * <pre>
         * The display name of the repository.
         * </pre>
         *
         * <code>string display_name = 2;</code>
         *
         * @return The displayName.
         */
        @java.lang.Override
        public java.lang.String getDisplayName() {
          java.lang.Object ref = displayName_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            displayName_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The display name of the repository.
         * </pre>
         *
         * <code>string display_name = 2;</code>
         *
         * @return The bytes for displayName.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getDisplayNameBytes() {
          java.lang.Object ref = displayName_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            displayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int BASE_URL_FIELD_NUMBER = 3;

        @SuppressWarnings("serial")
        private volatile java.lang.Object baseUrl_ = "";
        /**
         *
         *
         * <pre>
         * Required. The location of the repository directory.
         * </pre>
         *
         * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The baseUrl.
         */
        @java.lang.Override
        public java.lang.String getBaseUrl() {
          java.lang.Object ref = baseUrl_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            baseUrl_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The location of the repository directory.
         * </pre>
         *
         * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for baseUrl.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getBaseUrlBytes() {
          java.lang.Object ref = baseUrl_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            baseUrl_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int GPG_KEYS_FIELD_NUMBER = 4;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList gpgKeys_ =
            com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @return A list containing the gpgKeys.
         */
        public com.google.protobuf.ProtocolStringList getGpgKeysList() {
          return gpgKeys_;
        }
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @return The count of gpgKeys.
         */
        public int getGpgKeysCount() {
          return gpgKeys_.size();
        }
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @param index The index of the element to return.
         * @return The gpgKeys at the given index.
         */
        public java.lang.String getGpgKeys(int index) {
          return gpgKeys_.get(index);
        }
        /**
         *
         *
         * <pre>
         * URIs of GPG keys.
         * </pre>
         *
         * <code>repeated string gpg_keys = 4;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the gpgKeys at the given index.
         */
        public com.google.protobuf.ByteString getGpgKeysBytes(int index) {
          return gpgKeys_.getByteString(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseUrl_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 3, baseUrl_);
          }
          for (int i = 0; i < gpgKeys_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 4, gpgKeys_.getRaw(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseUrl_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, baseUrl_);
          }
          {
            int dataSize = 0;
            for (int i = 0; i < gpgKeys_.size(); i++) {
              dataSize += computeStringSizeNoTag(gpgKeys_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getGpgKeysList().size();
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository)
                  obj;

          if (!getId().equals(other.getId())) return false;
          if (!getDisplayName().equals(other.getDisplayName())) return false;
          if (!getBaseUrl().equals(other.getBaseUrl())) return false;
          if (!getGpgKeysList().equals(other.getGpgKeysList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + ID_FIELD_NUMBER;
          hash = (53 * hash) + getId().hashCode();
          hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getDisplayName().hashCode();
          hash = (37 * hash) + BASE_URL_FIELD_NUMBER;
          hash = (53 * hash) + getBaseUrl().hashCode();
          if (getGpgKeysCount() > 0) {
            hash = (37 * hash) + GPG_KEYS_FIELD_NUMBER;
            hash = (53 * hash) + getGpgKeysList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Represents a single zypper package repository. These are added to a
         * repo file that is managed at
         * `/etc/zypp/repos.d/google_osconfig.repo`.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepositoryOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_ZypperRepository_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_ZypperRepository_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                        .ZypperRepository.class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                        .ZypperRepository.Builder.class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            id_ = "";
            displayName_ = "";
            baseUrl_ = "";
            gpgKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_ZypperRepository_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
              build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
              buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                result =
                    new com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                        .ZypperRepository(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.id_ = id_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.displayName_ = displayName_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.baseUrl_ = baseUrl_;
            }
            if (((from_bitField0_ & 0x00000008) != 0)) {
              gpgKeys_.makeImmutable();
              result.gpgKeys_ = gpgKeys_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                    .ZypperRepository) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                          .ZypperRepository)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                  other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                    .ZypperRepository.getDefaultInstance()) return this;
            if (!other.getId().isEmpty()) {
              id_ = other.id_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getDisplayName().isEmpty()) {
              displayName_ = other.displayName_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            if (!other.getBaseUrl().isEmpty()) {
              baseUrl_ = other.baseUrl_;
              bitField0_ |= 0x00000004;
              onChanged();
            }
            if (!other.gpgKeys_.isEmpty()) {
              if (gpgKeys_.isEmpty()) {
                gpgKeys_ = other.gpgKeys_;
                bitField0_ |= 0x00000008;
              } else {
                ensureGpgKeysIsMutable();
                gpgKeys_.addAll(other.gpgKeys_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      id_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      displayName_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  case 26:
                    {
                      baseUrl_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 26
                  case 34:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureGpgKeysIsMutable();
                      gpgKeys_.add(s);
                      break;
                    } // case 34
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object id_ = "";
          /**
           *
           *
           * <pre>
           * Required. A one word, unique name for this repository. This is the
           * `repo id` in the zypper config file and also the `display_name` if
           * `display_name` is omitted. This id is also used as the unique
           * identifier when checking for GuestPolicy conflicts.
           * </pre>
           *
           * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The id.
           */
          public java.lang.String getId() {
            java.lang.Object ref = id_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              id_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. A one word, unique name for this repository. This is the
           * `repo id` in the zypper config file and also the `display_name` if
           * `display_name` is omitted. This id is also used as the unique
           * identifier when checking for GuestPolicy conflicts.
           * </pre>
           *
           * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for id.
           */
          public com.google.protobuf.ByteString getIdBytes() {
            java.lang.Object ref = id_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              id_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. A one word, unique name for this repository. This is the
           * `repo id` in the zypper config file and also the `display_name` if
           * `display_name` is omitted. This id is also used as the unique
           * identifier when checking for GuestPolicy conflicts.
           * </pre>
           *
           * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The id to set.
           * @return This builder for chaining.
           */
          public Builder setId(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            id_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. A one word, unique name for this repository. This is the
           * `repo id` in the zypper config file and also the `display_name` if
           * `display_name` is omitted. This id is also used as the unique
           * identifier when checking for GuestPolicy conflicts.
           * </pre>
           *
           * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearId() {
            id_ = getDefaultInstance().getId();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. A one word, unique name for this repository. This is the
           * `repo id` in the zypper config file and also the `display_name` if
           * `display_name` is omitted. This id is also used as the unique
           * identifier when checking for GuestPolicy conflicts.
           * </pre>
           *
           * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for id to set.
           * @return This builder for chaining.
           */
          public Builder setIdBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            id_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object displayName_ = "";
          /**
           *
           *
           * <pre>
           * The display name of the repository.
           * </pre>
           *
           * <code>string display_name = 2;</code>
           *
           * @return The displayName.
           */
          public java.lang.String getDisplayName() {
            java.lang.Object ref = displayName_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              displayName_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The display name of the repository.
           * </pre>
           *
           * <code>string display_name = 2;</code>
           *
           * @return The bytes for displayName.
           */
          public com.google.protobuf.ByteString getDisplayNameBytes() {
            java.lang.Object ref = displayName_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              displayName_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The display name of the repository.
           * </pre>
           *
           * <code>string display_name = 2;</code>
           *
           * @param value The displayName to set.
           * @return This builder for chaining.
           */
          public Builder setDisplayName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            displayName_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The display name of the repository.
           * </pre>
           *
           * <code>string display_name = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDisplayName() {
            displayName_ = getDefaultInstance().getDisplayName();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The display name of the repository.
           * </pre>
           *
           * <code>string display_name = 2;</code>
           *
           * @param value The bytes for displayName to set.
           * @return This builder for chaining.
           */
          public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            displayName_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          private java.lang.Object baseUrl_ = "";
          /**
           *
           *
           * <pre>
           * Required. The location of the repository directory.
           * </pre>
           *
           * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The baseUrl.
           */
          public java.lang.String getBaseUrl() {
            java.lang.Object ref = baseUrl_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              baseUrl_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The location of the repository directory.
           * </pre>
           *
           * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for baseUrl.
           */
          public com.google.protobuf.ByteString getBaseUrlBytes() {
            java.lang.Object ref = baseUrl_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              baseUrl_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The location of the repository directory.
           * </pre>
           *
           * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The baseUrl to set.
           * @return This builder for chaining.
           */
          public Builder setBaseUrl(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            baseUrl_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The location of the repository directory.
           * </pre>
           *
           * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearBaseUrl() {
            baseUrl_ = getDefaultInstance().getBaseUrl();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The location of the repository directory.
           * </pre>
           *
           * <code>string base_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for baseUrl to set.
           * @return This builder for chaining.
           */
          public Builder setBaseUrlBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            baseUrl_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringArrayList gpgKeys_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureGpgKeysIsMutable() {
            if (!gpgKeys_.isModifiable()) {
              gpgKeys_ = new com.google.protobuf.LazyStringArrayList(gpgKeys_);
            }
            bitField0_ |= 0x00000008;
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @return A list containing the gpgKeys.
           */
          public com.google.protobuf.ProtocolStringList getGpgKeysList() {
            gpgKeys_.makeImmutable();
            return gpgKeys_;
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @return The count of gpgKeys.
           */
          public int getGpgKeysCount() {
            return gpgKeys_.size();
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @param index The index of the element to return.
           * @return The gpgKeys at the given index.
           */
          public java.lang.String getGpgKeys(int index) {
            return gpgKeys_.get(index);
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the gpgKeys at the given index.
           */
          public com.google.protobuf.ByteString getGpgKeysBytes(int index) {
            return gpgKeys_.getByteString(index);
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @param index The index to set the value at.
           * @param value The gpgKeys to set.
           * @return This builder for chaining.
           */
          public Builder setGpgKeys(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureGpgKeysIsMutable();
            gpgKeys_.set(index, value);
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @param value The gpgKeys to add.
           * @return This builder for chaining.
           */
          public Builder addGpgKeys(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureGpgKeysIsMutable();
            gpgKeys_.add(value);
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @param values The gpgKeys to add.
           * @return This builder for chaining.
           */
          public Builder addAllGpgKeys(java.lang.Iterable<java.lang.String> values) {
            ensureGpgKeysIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, gpgKeys_);
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearGpgKeys() {
            gpgKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            ;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * URIs of GPG keys.
           * </pre>
           *
           * <code>repeated string gpg_keys = 4;</code>
           *
           * @param value The bytes of the gpgKeys to add.
           * @return This builder for chaining.
           */
          public Builder addGpgKeysBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureGpgKeysIsMutable();
            gpgKeys_.add(value);
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                  .ZypperRepository();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<ZypperRepository> PARSER =
            new com.google.protobuf.AbstractParser<ZypperRepository>() {
              @java.lang.Override
              public ZypperRepository parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<ZypperRepository> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<ZypperRepository> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface GooRepositoryOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. The name of the repository.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The name.
         */
        java.lang.String getName();
        /**
         *
         *
         * <pre>
         * Required. The name of the repository.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for name.
         */
        com.google.protobuf.ByteString getNameBytes();

        /**
         *
         *
         * <pre>
         * Required. The url of the repository.
         * </pre>
         *
         * <code>string url = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The url.
         */
        java.lang.String getUrl();
        /**
         *
         *
         * <pre>
         * Required. The url of the repository.
         * </pre>
         *
         * <code>string url = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for url.
         */
        com.google.protobuf.ByteString getUrlBytes();
      }
      /**
       *
       *
       * <pre>
       * Represents a Goo package repository. These are added to a repo file
       * that is managed at
       * `C:/ProgramData/GooGet/repos/google_osconfig.repo`.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository}
       */
      public static final class GooRepository extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository)
          GooRepositoryOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use GooRepository.newBuilder() to construct.
        private GooRepository(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private GooRepository() {
          name_ = "";
          url_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new GooRepository();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_GooRepository_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_GooRepository_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                      .class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                      .Builder.class);
        }

        public static final int NAME_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * Required. The name of the repository.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The name.
         */
        @java.lang.Override
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The name of the repository.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for name.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int URL_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object url_ = "";
        /**
         *
         *
         * <pre>
         * Required. The url of the repository.
         * </pre>
         *
         * <code>string url = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The url.
         */
        @java.lang.Override
        public java.lang.String getUrl() {
          java.lang.Object ref = url_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            url_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The url of the repository.
         * </pre>
         *
         * <code>string url = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for url.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getUrlBytes() {
          java.lang.Object ref = url_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            url_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, url_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, url_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository) obj;

          if (!getName().equals(other.getName())) return false;
          if (!getUrl().equals(other.getUrl())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + NAME_FIELD_NUMBER;
          hash = (53 * hash) + getName().hashCode();
          hash = (37 * hash) + URL_FIELD_NUMBER;
          hash = (53 * hash) + getUrl().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Represents a Goo package repository. These are added to a repo file
         * that is managed at
         * `C:/ProgramData/GooGet/repos/google_osconfig.repo`.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepositoryOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_GooRepository_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_GooRepository_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                        .class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                        .Builder.class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            name_ = "";
            url_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_GooRepository_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
              build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
              buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository result =
                new com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository(
                    this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.name_ = name_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.url_ = url_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                  other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                    .getDefaultInstance()) return this;
            if (!other.getName().isEmpty()) {
              name_ = other.name_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getUrl().isEmpty()) {
              url_ = other.url_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      name_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      url_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object name_ = "";
          /**
           *
           *
           * <pre>
           * Required. The name of the repository.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The name.
           */
          public java.lang.String getName() {
            java.lang.Object ref = name_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              name_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The name of the repository.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for name.
           */
          public com.google.protobuf.ByteString getNameBytes() {
            java.lang.Object ref = name_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              name_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The name of the repository.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The name to set.
           * @return This builder for chaining.
           */
          public Builder setName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            name_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The name of the repository.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearName() {
            name_ = getDefaultInstance().getName();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The name of the repository.
           * </pre>
           *
           * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for name to set.
           * @return This builder for chaining.
           */
          public Builder setNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            name_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object url_ = "";
          /**
           *
           *
           * <pre>
           * Required. The url of the repository.
           * </pre>
           *
           * <code>string url = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The url.
           */
          public java.lang.String getUrl() {
            java.lang.Object ref = url_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              url_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The url of the repository.
           * </pre>
           *
           * <code>string url = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for url.
           */
          public com.google.protobuf.ByteString getUrlBytes() {
            java.lang.Object ref = url_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              url_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. The url of the repository.
           * </pre>
           *
           * <code>string url = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The url to set.
           * @return This builder for chaining.
           */
          public Builder setUrl(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            url_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The url of the repository.
           * </pre>
           *
           * <code>string url = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearUrl() {
            url_ = getDefaultInstance().getUrl();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The url of the repository.
           * </pre>
           *
           * <code>string url = 2 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for url to set.
           * @return This builder for chaining.
           */
          public Builder setUrlBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            url_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepository
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<GooRepository> PARSER =
            new com.google.protobuf.AbstractParser<GooRepository>() {
              @java.lang.Override
              public GooRepository parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<GooRepository> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<GooRepository> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int repositoryCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object repository_;

      public enum RepositoryCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        APT(1),
        YUM(2),
        ZYPPER(3),
        GOO(4),
        REPOSITORY_NOT_SET(0);
        private final int value;

        private RepositoryCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static RepositoryCase valueOf(int value) {
          return forNumber(value);
        }

        public static RepositoryCase forNumber(int value) {
          switch (value) {
            case 1:
              return APT;
            case 2:
              return YUM;
            case 3:
              return ZYPPER;
            case 4:
              return GOO;
            case 0:
              return REPOSITORY_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public RepositoryCase getRepositoryCase() {
        return RepositoryCase.forNumber(repositoryCase_);
      }

      public static final int APT_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * An Apt Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
       * </code>
       *
       * @return Whether the apt field is set.
       */
      @java.lang.Override
      public boolean hasApt() {
        return repositoryCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * An Apt Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
       * </code>
       *
       * @return The apt.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
          getApt() {
        if (repositoryCase_ == 1) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository)
              repository_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * An Apt Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
              .AptRepositoryOrBuilder
          getAptOrBuilder() {
        if (repositoryCase_ == 1) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository)
              repository_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
            .getDefaultInstance();
      }

      public static final int YUM_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * A Yum Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
       * </code>
       *
       * @return Whether the yum field is set.
       */
      @java.lang.Override
      public boolean hasYum() {
        return repositoryCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * A Yum Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
       * </code>
       *
       * @return The yum.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
          getYum() {
        if (repositoryCase_ == 2) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository)
              repository_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A Yum Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
              .YumRepositoryOrBuilder
          getYumOrBuilder() {
        if (repositoryCase_ == 2) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository)
              repository_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
            .getDefaultInstance();
      }

      public static final int ZYPPER_FIELD_NUMBER = 3;
      /**
       *
       *
       * <pre>
       * A Zypper Repository.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
       * </code>
       *
       * @return Whether the zypper field is set.
       */
      @java.lang.Override
      public boolean hasZypper() {
        return repositoryCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * A Zypper Repository.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
       * </code>
       *
       * @return The zypper.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
          getZypper() {
        if (repositoryCase_ == 3) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                  .ZypperRepository)
              repository_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A Zypper Repository.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
              .ZypperRepositoryOrBuilder
          getZypperOrBuilder() {
        if (repositoryCase_ == 3) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                  .ZypperRepository)
              repository_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
            .getDefaultInstance();
      }

      public static final int GOO_FIELD_NUMBER = 4;
      /**
       *
       *
       * <pre>
       * A Goo Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
       * </code>
       *
       * @return Whether the goo field is set.
       */
      @java.lang.Override
      public boolean hasGoo() {
        return repositoryCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * A Goo Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
       * </code>
       *
       * @return The goo.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
          getGoo() {
        if (repositoryCase_ == 4) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository)
              repository_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A Goo Repository.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
              .GooRepositoryOrBuilder
          getGooOrBuilder() {
        if (repositoryCase_ == 4) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository)
              repository_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
            .getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (repositoryCase_ == 1) {
          output.writeMessage(
              1,
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository)
                  repository_);
        }
        if (repositoryCase_ == 2) {
          output.writeMessage(
              2,
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository)
                  repository_);
        }
        if (repositoryCase_ == 3) {
          output.writeMessage(
              3,
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository)
                  repository_);
        }
        if (repositoryCase_ == 4) {
          output.writeMessage(
              4,
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository)
                  repository_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (repositoryCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1,
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository)
                      repository_);
        }
        if (repositoryCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2,
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository)
                      repository_);
        }
        if (repositoryCase_ == 3) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3,
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                          .ZypperRepository)
                      repository_);
        }
        if (repositoryCase_ == 4) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  4,
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository)
                      repository_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource)) {
          return super.equals(obj);
        }
        com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource other =
            (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource) obj;

        if (!getRepositoryCase().equals(other.getRepositoryCase())) return false;
        switch (repositoryCase_) {
          case 1:
            if (!getApt().equals(other.getApt())) return false;
            break;
          case 2:
            if (!getYum().equals(other.getYum())) return false;
            break;
          case 3:
            if (!getZypper().equals(other.getZypper())) return false;
            break;
          case 4:
            if (!getGoo().equals(other.getGoo())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (repositoryCase_) {
          case 1:
            hash = (37 * hash) + APT_FIELD_NUMBER;
            hash = (53 * hash) + getApt().hashCode();
            break;
          case 2:
            hash = (37 * hash) + YUM_FIELD_NUMBER;
            hash = (53 * hash) + getYum().hashCode();
            break;
          case 3:
            hash = (37 * hash) + ZYPPER_FIELD_NUMBER;
            hash = (53 * hash) + getZypper().hashCode();
            break;
          case 4:
            hash = (37 * hash) + GOO_FIELD_NUMBER;
            hash = (53 * hash) + getGoo().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A resource that manages a package repository.
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource)
          com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.Builder.class);
        }

        // Construct using
        // com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (aptBuilder_ != null) {
            aptBuilder_.clear();
          }
          if (yumBuilder_ != null) {
            yumBuilder_.clear();
          }
          if (zypperBuilder_ != null) {
            zypperBuilder_.clear();
          }
          if (gooBuilder_ != null) {
            gooBuilder_.clear();
          }
          repositoryCase_ = 0;
          repository_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_RepositoryResource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
            getDefaultInstanceForType() {
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource build() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource buildPartial() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource result =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource result) {
          result.repositoryCase_ = repositoryCase_;
          result.repository_ = this.repository_;
          if (repositoryCase_ == 1 && aptBuilder_ != null) {
            result.repository_ = aptBuilder_.build();
          }
          if (repositoryCase_ == 2 && yumBuilder_ != null) {
            result.repository_ = yumBuilder_.build();
          }
          if (repositoryCase_ == 3 && zypperBuilder_ != null) {
            result.repository_ = zypperBuilder_.build();
          }
          if (repositoryCase_ == 4 && gooBuilder_ != null) {
            result.repository_ = gooBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource) {
            return mergeFrom(
                (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource other) {
          if (other
              == com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                  .getDefaultInstance()) return this;
          switch (other.getRepositoryCase()) {
            case APT:
              {
                mergeApt(other.getApt());
                break;
              }
            case YUM:
              {
                mergeYum(other.getYum());
                break;
              }
            case ZYPPER:
              {
                mergeZypper(other.getZypper());
                break;
              }
            case GOO:
              {
                mergeGoo(other.getGoo());
                break;
              }
            case REPOSITORY_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getAptFieldBuilder().getBuilder(), extensionRegistry);
                    repositoryCase_ = 1;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getYumFieldBuilder().getBuilder(), extensionRegistry);
                    repositoryCase_ = 2;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getZypperFieldBuilder().getBuilder(), extensionRegistry);
                    repositoryCase_ = 3;
                    break;
                  } // case 26
                case 34:
                  {
                    input.readMessage(getGooFieldBuilder().getBuilder(), extensionRegistry);
                    repositoryCase_ = 4;
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int repositoryCase_ = 0;
        private java.lang.Object repository_;

        public RepositoryCase getRepositoryCase() {
          return RepositoryCase.forNumber(repositoryCase_);
        }

        public Builder clearRepository() {
          repositoryCase_ = 0;
          repository_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                    .Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                    .AptRepositoryOrBuilder>
            aptBuilder_;
        /**
         *
         *
         * <pre>
         * An Apt Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
         * </code>
         *
         * @return Whether the apt field is set.
         */
        @java.lang.Override
        public boolean hasApt() {
          return repositoryCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * An Apt Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
         * </code>
         *
         * @return The apt.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
            getApt() {
          if (aptBuilder_ == null) {
            if (repositoryCase_ == 1) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                      .AptRepository)
                  repository_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                .getDefaultInstance();
          } else {
            if (repositoryCase_ == 1) {
              return aptBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * An Apt Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
         * </code>
         */
        public Builder setApt(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository value) {
          if (aptBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            repository_ = value;
            onChanged();
          } else {
            aptBuilder_.setMessage(value);
          }
          repositoryCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * An Apt Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
         * </code>
         */
        public Builder setApt(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository.Builder
                builderForValue) {
          if (aptBuilder_ == null) {
            repository_ = builderForValue.build();
            onChanged();
          } else {
            aptBuilder_.setMessage(builderForValue.build());
          }
          repositoryCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * An Apt Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
         * </code>
         */
        public Builder mergeApt(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository value) {
          if (aptBuilder_ == null) {
            if (repositoryCase_ == 1
                && repository_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                        .AptRepository.getDefaultInstance()) {
              repository_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                      .newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                                  .AptRepository)
                              repository_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              repository_ = value;
            }
            onChanged();
          } else {
            if (repositoryCase_ == 1) {
              aptBuilder_.mergeFrom(value);
            } else {
              aptBuilder_.setMessage(value);
            }
          }
          repositoryCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * An Apt Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
         * </code>
         */
        public Builder clearApt() {
          if (aptBuilder_ == null) {
            if (repositoryCase_ == 1) {
              repositoryCase_ = 0;
              repository_ = null;
              onChanged();
            }
          } else {
            if (repositoryCase_ == 1) {
              repositoryCase_ = 0;
              repository_ = null;
            }
            aptBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * An Apt Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                .Builder
            getAptBuilder() {
          return getAptFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * An Apt Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .AptRepositoryOrBuilder
            getAptOrBuilder() {
          if ((repositoryCase_ == 1) && (aptBuilder_ != null)) {
            return aptBuilder_.getMessageOrBuilder();
          } else {
            if (repositoryCase_ == 1) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                      .AptRepository)
                  repository_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * An Apt Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository apt = 1;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                    .Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                    .AptRepositoryOrBuilder>
            getAptFieldBuilder() {
          if (aptBuilder_ == null) {
            if (!(repositoryCase_ == 1)) {
              repository_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                      .getDefaultInstance();
            }
            aptBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.AptRepository
                        .Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                        .AptRepositoryOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                            .AptRepository)
                        repository_,
                    getParentForChildren(),
                    isClean());
            repository_ = null;
          }
          repositoryCase_ = 1;
          onChanged();
          return aptBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                    .Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                    .YumRepositoryOrBuilder>
            yumBuilder_;
        /**
         *
         *
         * <pre>
         * A Yum Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
         * </code>
         *
         * @return Whether the yum field is set.
         */
        @java.lang.Override
        public boolean hasYum() {
          return repositoryCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * A Yum Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
         * </code>
         *
         * @return The yum.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
            getYum() {
          if (yumBuilder_ == null) {
            if (repositoryCase_ == 2) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                      .YumRepository)
                  repository_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                .getDefaultInstance();
          } else {
            if (repositoryCase_ == 2) {
              return yumBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A Yum Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
         * </code>
         */
        public Builder setYum(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository value) {
          if (yumBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            repository_ = value;
            onChanged();
          } else {
            yumBuilder_.setMessage(value);
          }
          repositoryCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Yum Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
         * </code>
         */
        public Builder setYum(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository.Builder
                builderForValue) {
          if (yumBuilder_ == null) {
            repository_ = builderForValue.build();
            onChanged();
          } else {
            yumBuilder_.setMessage(builderForValue.build());
          }
          repositoryCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Yum Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
         * </code>
         */
        public Builder mergeYum(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository value) {
          if (yumBuilder_ == null) {
            if (repositoryCase_ == 2
                && repository_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                        .YumRepository.getDefaultInstance()) {
              repository_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                      .newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                                  .YumRepository)
                              repository_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              repository_ = value;
            }
            onChanged();
          } else {
            if (repositoryCase_ == 2) {
              yumBuilder_.mergeFrom(value);
            } else {
              yumBuilder_.setMessage(value);
            }
          }
          repositoryCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Yum Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
         * </code>
         */
        public Builder clearYum() {
          if (yumBuilder_ == null) {
            if (repositoryCase_ == 2) {
              repositoryCase_ = 0;
              repository_ = null;
              onChanged();
            }
          } else {
            if (repositoryCase_ == 2) {
              repositoryCase_ = 0;
              repository_ = null;
            }
            yumBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Yum Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                .Builder
            getYumBuilder() {
          return getYumFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A Yum Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .YumRepositoryOrBuilder
            getYumOrBuilder() {
          if ((repositoryCase_ == 2) && (yumBuilder_ != null)) {
            return yumBuilder_.getMessageOrBuilder();
          } else {
            if (repositoryCase_ == 2) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                      .YumRepository)
                  repository_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A Yum Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository yum = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                    .Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                    .YumRepositoryOrBuilder>
            getYumFieldBuilder() {
          if (yumBuilder_ == null) {
            if (!(repositoryCase_ == 2)) {
              repository_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                      .getDefaultInstance();
            }
            yumBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.YumRepository
                        .Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                        .YumRepositoryOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                            .YumRepository)
                        repository_,
                    getParentForChildren(),
                    isClean());
            repository_ = null;
          }
          repositoryCase_ = 2;
          onChanged();
          return yumBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                    .Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                    .ZypperRepositoryOrBuilder>
            zypperBuilder_;
        /**
         *
         *
         * <pre>
         * A Zypper Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
         * </code>
         *
         * @return Whether the zypper field is set.
         */
        @java.lang.Override
        public boolean hasZypper() {
          return repositoryCase_ == 3;
        }
        /**
         *
         *
         * <pre>
         * A Zypper Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
         * </code>
         *
         * @return The zypper.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
            getZypper() {
          if (zypperBuilder_ == null) {
            if (repositoryCase_ == 3) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                      .ZypperRepository)
                  repository_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository.getDefaultInstance();
          } else {
            if (repositoryCase_ == 3) {
              return zypperBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A Zypper Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
         * </code>
         */
        public Builder setZypper(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                value) {
          if (zypperBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            repository_ = value;
            onChanged();
          } else {
            zypperBuilder_.setMessage(value);
          }
          repositoryCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Zypper Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
         * </code>
         */
        public Builder setZypper(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                    .Builder
                builderForValue) {
          if (zypperBuilder_ == null) {
            repository_ = builderForValue.build();
            onChanged();
          } else {
            zypperBuilder_.setMessage(builderForValue.build());
          }
          repositoryCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Zypper Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
         * </code>
         */
        public Builder mergeZypper(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                value) {
          if (zypperBuilder_ == null) {
            if (repositoryCase_ == 3
                && repository_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                        .ZypperRepository.getDefaultInstance()) {
              repository_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                      .newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                                  .ZypperRepository)
                              repository_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              repository_ = value;
            }
            onChanged();
          } else {
            if (repositoryCase_ == 3) {
              zypperBuilder_.mergeFrom(value);
            } else {
              zypperBuilder_.setMessage(value);
            }
          }
          repositoryCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Zypper Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
         * </code>
         */
        public Builder clearZypper() {
          if (zypperBuilder_ == null) {
            if (repositoryCase_ == 3) {
              repositoryCase_ = 0;
              repository_ = null;
              onChanged();
            }
          } else {
            if (repositoryCase_ == 3) {
              repositoryCase_ = 0;
              repository_ = null;
            }
            zypperBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Zypper Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                .Builder
            getZypperBuilder() {
          return getZypperFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A Zypper Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepositoryOrBuilder
            getZypperOrBuilder() {
          if ((repositoryCase_ == 3) && (zypperBuilder_ != null)) {
            return zypperBuilder_.getMessageOrBuilder();
          } else {
            if (repositoryCase_ == 3) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                      .ZypperRepository)
                  repository_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .ZypperRepository.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A Zypper Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository zypper = 3;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                    .Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                    .ZypperRepositoryOrBuilder>
            getZypperFieldBuilder() {
          if (zypperBuilder_ == null) {
            if (!(repositoryCase_ == 3)) {
              repository_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
                      .getDefaultInstance();
            }
            zypperBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                        .ZypperRepository,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                        .ZypperRepository.Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                        .ZypperRepositoryOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                            .ZypperRepository)
                        repository_,
                    getParentForChildren(),
                    isClean());
            repository_ = null;
          }
          repositoryCase_ = 3;
          onChanged();
          return zypperBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                    .Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                    .GooRepositoryOrBuilder>
            gooBuilder_;
        /**
         *
         *
         * <pre>
         * A Goo Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
         * </code>
         *
         * @return Whether the goo field is set.
         */
        @java.lang.Override
        public boolean hasGoo() {
          return repositoryCase_ == 4;
        }
        /**
         *
         *
         * <pre>
         * A Goo Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
         * </code>
         *
         * @return The goo.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
            getGoo() {
          if (gooBuilder_ == null) {
            if (repositoryCase_ == 4) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                      .GooRepository)
                  repository_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                .getDefaultInstance();
          } else {
            if (repositoryCase_ == 4) {
              return gooBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A Goo Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
         * </code>
         */
        public Builder setGoo(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository value) {
          if (gooBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            repository_ = value;
            onChanged();
          } else {
            gooBuilder_.setMessage(value);
          }
          repositoryCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Goo Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
         * </code>
         */
        public Builder setGoo(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository.Builder
                builderForValue) {
          if (gooBuilder_ == null) {
            repository_ = builderForValue.build();
            onChanged();
          } else {
            gooBuilder_.setMessage(builderForValue.build());
          }
          repositoryCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Goo Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
         * </code>
         */
        public Builder mergeGoo(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository value) {
          if (gooBuilder_ == null) {
            if (repositoryCase_ == 4
                && repository_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                        .GooRepository.getDefaultInstance()) {
              repository_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                      .newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                                  .GooRepository)
                              repository_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              repository_ = value;
            }
            onChanged();
          } else {
            if (repositoryCase_ == 4) {
              gooBuilder_.mergeFrom(value);
            } else {
              gooBuilder_.setMessage(value);
            }
          }
          repositoryCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Goo Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
         * </code>
         */
        public Builder clearGoo() {
          if (gooBuilder_ == null) {
            if (repositoryCase_ == 4) {
              repositoryCase_ = 0;
              repository_ = null;
              onChanged();
            }
          } else {
            if (repositoryCase_ == 4) {
              repositoryCase_ = 0;
              repository_ = null;
            }
            gooBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A Goo Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                .Builder
            getGooBuilder() {
          return getGooFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A Goo Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                .GooRepositoryOrBuilder
            getGooOrBuilder() {
          if ((repositoryCase_ == 4) && (gooBuilder_ != null)) {
            return gooBuilder_.getMessageOrBuilder();
          } else {
            if (repositoryCase_ == 4) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                      .GooRepository)
                  repository_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A Goo Repository.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository goo = 4;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                    .Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                    .GooRepositoryOrBuilder>
            getGooFieldBuilder() {
          if (gooBuilder_ == null) {
            if (!(repositoryCase_ == 4)) {
              repository_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                      .getDefaultInstance();
            }
            gooBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.GooRepository
                        .Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                        .GooRepositoryOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                            .GooRepository)
                        repository_,
                    getParentForChildren(),
                    isClean());
            repository_ = null;
          }
          repositoryCase_ = 4;
          onChanged();
          return gooBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource)
      private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource();
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<RepositoryResource> PARSER =
          new com.google.protobuf.AbstractParser<RepositoryResource>() {
            @java.lang.Override
            public RepositoryResource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<RepositoryResource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<RepositoryResource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ExecResourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. What to run to validate this resource is in the desired
       * state. An exit code of 100 indicates "in desired state", and exit code
       * of 101 indicates "not in desired state". Any other exit code indicates
       * a failure running validate.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the validate field is set.
       */
      boolean hasValidate();
      /**
       *
       *
       * <pre>
       * Required. What to run to validate this resource is in the desired
       * state. An exit code of 100 indicates "in desired state", and exit code
       * of 101 indicates "not in desired state". Any other exit code indicates
       * a failure running validate.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The validate.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec getValidate();
      /**
       *
       *
       * <pre>
       * Required. What to run to validate this resource is in the desired
       * state. An exit code of 100 indicates "in desired state", and exit code
       * of 101 indicates "not in desired state". Any other exit code indicates
       * a failure running validate.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.ExecOrBuilder
          getValidateOrBuilder();

      /**
       *
       *
       * <pre>
       * What to run to bring this resource into the desired state.
       * An exit code of 100 indicates "success", any other exit code indicates
       * a failure running enforce.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
       *
       * @return Whether the enforce field is set.
       */
      boolean hasEnforce();
      /**
       *
       *
       * <pre>
       * What to run to bring this resource into the desired state.
       * An exit code of 100 indicates "success", any other exit code indicates
       * a failure running enforce.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
       *
       * @return The enforce.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec getEnforce();
      /**
       *
       *
       * <pre>
       * What to run to bring this resource into the desired state.
       * An exit code of 100 indicates "success", any other exit code indicates
       * a failure running enforce.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.ExecOrBuilder
          getEnforceOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * A resource that allows executing scripts on the VM.
     *
     * The `ExecResource` has 2 stages: `validate` and `enforce` and both stages
     * accept a script as an argument to execute.
     *
     * When the `ExecResource` is applied by the agent, it first executes the
     * script in the `validate` stage. The `validate` stage can signal that the
     * `ExecResource` is already in the desired state by returning an exit code
     * of `100`. If the `ExecResource` is not in the desired state, it should
     * return an exit code of `101`. Any other exit code returned by this stage
     * is considered an error.
     *
     * If the `ExecResource` is not in the desired state based on the exit code
     * from the `validate` stage, the agent proceeds to execute the script from
     * the `enforce` stage. If the `ExecResource` is already in the desired
     * state, the `enforce` stage will not be run.
     * Similar to `validate` stage, the `enforce` stage should return an exit
     * code of `100` to indicate that the resource in now in its desired state.
     * Any other exit code is considered an error.
     *
     * NOTE: An exit code of `100` was chosen over `0` (and `101` vs `1`) to
     * have an explicit indicator of `in desired state`, `not in desired state`
     * and errors. Because, for example, Powershell will always return an exit
     * code of `0` unless an `exit` statement is provided in the script. So, for
     * reasons of consistency and being explicit, exit codes `100` and `101`
     * were chosen.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource}
     */
    public static final class ExecResource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource)
        ExecResourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ExecResource.newBuilder() to construct.
      private ExecResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ExecResource() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ExecResource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_ExecResource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_ExecResource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.class,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Builder.class);
      }

      public interface ExecOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * A remote or local file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         *
         * @return Whether the file field is set.
         */
        boolean hasFile();
        /**
         *
         *
         * <pre>
         * A remote or local file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         *
         * @return The file.
         */
        com.google.cloud.osconfig.v1.OSPolicy.Resource.File getFile();
        /**
         *
         *
         * <pre>
         * A remote or local file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         */
        com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getFileOrBuilder();

        /**
         *
         *
         * <pre>
         * An inline script.
         * The size of the script is limited to 1024 characters.
         * </pre>
         *
         * <code>string script = 2;</code>
         *
         * @return Whether the script field is set.
         */
        boolean hasScript();
        /**
         *
         *
         * <pre>
         * An inline script.
         * The size of the script is limited to 1024 characters.
         * </pre>
         *
         * <code>string script = 2;</code>
         *
         * @return The script.
         */
        java.lang.String getScript();
        /**
         *
         *
         * <pre>
         * An inline script.
         * The size of the script is limited to 1024 characters.
         * </pre>
         *
         * <code>string script = 2;</code>
         *
         * @return The bytes for script.
         */
        com.google.protobuf.ByteString getScriptBytes();

        /**
         *
         *
         * <pre>
         * Optional arguments to pass to the source during execution.
         * </pre>
         *
         * <code>repeated string args = 3;</code>
         *
         * @return A list containing the args.
         */
        java.util.List<java.lang.String> getArgsList();
        /**
         *
         *
         * <pre>
         * Optional arguments to pass to the source during execution.
         * </pre>
         *
         * <code>repeated string args = 3;</code>
         *
         * @return The count of args.
         */
        int getArgsCount();
        /**
         *
         *
         * <pre>
         * Optional arguments to pass to the source during execution.
         * </pre>
         *
         * <code>repeated string args = 3;</code>
         *
         * @param index The index of the element to return.
         * @return The args at the given index.
         */
        java.lang.String getArgs(int index);
        /**
         *
         *
         * <pre>
         * Optional arguments to pass to the source during execution.
         * </pre>
         *
         * <code>repeated string args = 3;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the args at the given index.
         */
        com.google.protobuf.ByteString getArgsBytes(int index);

        /**
         *
         *
         * <pre>
         * Required. The script interpreter to use.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter interpreter = 4 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for interpreter.
         */
        int getInterpreterValue();
        /**
         *
         *
         * <pre>
         * Required. The script interpreter to use.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter interpreter = 4 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The interpreter.
         */
        com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter
            getInterpreter();

        /**
         *
         *
         * <pre>
         * Only recorded for enforce Exec.
         * Path to an output file (that is created by this Exec) whose
         * content will be recorded in OSPolicyResourceCompliance after a
         * successful run. Absence or failure to read this file will result in
         * this ExecResource being non-compliant. Output file size is limited to
         * 100K bytes.
         * </pre>
         *
         * <code>string output_file_path = 5;</code>
         *
         * @return The outputFilePath.
         */
        java.lang.String getOutputFilePath();
        /**
         *
         *
         * <pre>
         * Only recorded for enforce Exec.
         * Path to an output file (that is created by this Exec) whose
         * content will be recorded in OSPolicyResourceCompliance after a
         * successful run. Absence or failure to read this file will result in
         * this ExecResource being non-compliant. Output file size is limited to
         * 100K bytes.
         * </pre>
         *
         * <code>string output_file_path = 5;</code>
         *
         * @return The bytes for outputFilePath.
         */
        com.google.protobuf.ByteString getOutputFilePathBytes();

        com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.SourceCase getSourceCase();
      }
      /**
       *
       *
       * <pre>
       * A file or script to execute.
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec}
       */
      public static final class Exec extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec)
          ExecOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Exec.newBuilder() to construct.
        private Exec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Exec() {
          args_ = com.google.protobuf.LazyStringArrayList.emptyList();
          interpreter_ = 0;
          outputFilePath_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Exec();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_ExecResource_Exec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_ExecResource_Exec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Builder.class);
        }

        /**
         *
         *
         * <pre>
         * The interpreter to use.
         * </pre>
         *
         * Protobuf enum {@code
         * google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter}
         */
        public enum Interpreter implements com.google.protobuf.ProtocolMessageEnum {
          /**
           *
           *
           * <pre>
           * Invalid value, the request will return validation error.
           * </pre>
           *
           * <code>INTERPRETER_UNSPECIFIED = 0;</code>
           */
          INTERPRETER_UNSPECIFIED(0),
          /**
           *
           *
           * <pre>
           * If an interpreter is not specified, the
           * source is executed directly. This execution, without an
           * interpreter, only succeeds for executables and scripts that have &lt;a
           * href="https://en.wikipedia.org/wiki/Shebang_(Unix)"
           * class="external"&gt;shebang lines&lt;/a&gt;.
           * </pre>
           *
           * <code>NONE = 1;</code>
           */
          NONE(1),
          /**
           *
           *
           * <pre>
           * Indicates that the script runs with `/bin/sh` on Linux and
           * `cmd.exe` on Windows.
           * </pre>
           *
           * <code>SHELL = 2;</code>
           */
          SHELL(2),
          /**
           *
           *
           * <pre>
           * Indicates that the script runs with PowerShell.
           * </pre>
           *
           * <code>POWERSHELL = 3;</code>
           */
          POWERSHELL(3),
          UNRECOGNIZED(-1),
          ;

          /**
           *
           *
           * <pre>
           * Invalid value, the request will return validation error.
           * </pre>
           *
           * <code>INTERPRETER_UNSPECIFIED = 0;</code>
           */
          public static final int INTERPRETER_UNSPECIFIED_VALUE = 0;
          /**
           *
           *
           * <pre>
           * If an interpreter is not specified, the
           * source is executed directly. This execution, without an
           * interpreter, only succeeds for executables and scripts that have &lt;a
           * href="https://en.wikipedia.org/wiki/Shebang_(Unix)"
           * class="external"&gt;shebang lines&lt;/a&gt;.
           * </pre>
           *
           * <code>NONE = 1;</code>
           */
          public static final int NONE_VALUE = 1;
          /**
           *
           *
           * <pre>
           * Indicates that the script runs with `/bin/sh` on Linux and
           * `cmd.exe` on Windows.
           * </pre>
           *
           * <code>SHELL = 2;</code>
           */
          public static final int SHELL_VALUE = 2;
          /**
           *
           *
           * <pre>
           * Indicates that the script runs with PowerShell.
           * </pre>
           *
           * <code>POWERSHELL = 3;</code>
           */
          public static final int POWERSHELL_VALUE = 3;

          public final int getNumber() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalArgumentException(
                  "Can't get the number of an unknown enum value.");
            }
            return value;
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static Interpreter valueOf(int value) {
            return forNumber(value);
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           */
          public static Interpreter forNumber(int value) {
            switch (value) {
              case 0:
                return INTERPRETER_UNSPECIFIED;
              case 1:
                return NONE;
              case 2:
                return SHELL;
              case 3:
                return POWERSHELL;
              default:
                return null;
            }
          }

          public static com.google.protobuf.Internal.EnumLiteMap<Interpreter>
              internalGetValueMap() {
            return internalValueMap;
          }

          private static final com.google.protobuf.Internal.EnumLiteMap<Interpreter>
              internalValueMap =
                  new com.google.protobuf.Internal.EnumLiteMap<Interpreter>() {
                    public Interpreter findValueByNumber(int number) {
                      return Interpreter.forNumber(number);
                    }
                  };

          public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalStateException(
                  "Can't get the descriptor of an unrecognized enum value.");
            }
            return getDescriptor().getValues().get(ordinal());
          }

          public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
            return getDescriptor();
          }

          public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.getDescriptor()
                .getEnumTypes()
                .get(0);
          }

          private static final Interpreter[] VALUES = values();

          public static Interpreter valueOf(
              com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
              throw new java.lang.IllegalArgumentException(
                  "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
              return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
          }

          private final int value;

          private Interpreter(int value) {
            this.value = value;
          }

          // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter)
        }

        private int sourceCase_ = 0;

        @SuppressWarnings("serial")
        private java.lang.Object source_;

        public enum SourceCase
            implements
                com.google.protobuf.Internal.EnumLite,
                com.google.protobuf.AbstractMessage.InternalOneOfEnum {
          FILE(1),
          SCRIPT(2),
          SOURCE_NOT_SET(0);
          private final int value;

          private SourceCase(int value) {
            this.value = value;
          }
          /**
           * @param value The number of the enum to look for.
           * @return The enum associated with the given number.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static SourceCase valueOf(int value) {
            return forNumber(value);
          }

          public static SourceCase forNumber(int value) {
            switch (value) {
              case 1:
                return FILE;
              case 2:
                return SCRIPT;
              case 0:
                return SOURCE_NOT_SET;
              default:
                return null;
            }
          }

          public int getNumber() {
            return this.value;
          }
        };

        public SourceCase getSourceCase() {
          return SourceCase.forNumber(sourceCase_);
        }

        public static final int FILE_FIELD_NUMBER = 1;
        /**
         *
         *
         * <pre>
         * A remote or local file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         *
         * @return Whether the file field is set.
         */
        @java.lang.Override
        public boolean hasFile() {
          return sourceCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * A remote or local file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         *
         * @return The file.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File getFile() {
          if (sourceCase_ == 1) {
            return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_;
          }
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * A remote or local file.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getFileOrBuilder() {
          if (sourceCase_ == 1) {
            return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_;
          }
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance();
        }

        public static final int SCRIPT_FIELD_NUMBER = 2;
        /**
         *
         *
         * <pre>
         * An inline script.
         * The size of the script is limited to 1024 characters.
         * </pre>
         *
         * <code>string script = 2;</code>
         *
         * @return Whether the script field is set.
         */
        public boolean hasScript() {
          return sourceCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * An inline script.
         * The size of the script is limited to 1024 characters.
         * </pre>
         *
         * <code>string script = 2;</code>
         *
         * @return The script.
         */
        public java.lang.String getScript() {
          java.lang.Object ref = "";
          if (sourceCase_ == 2) {
            ref = source_;
          }
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (sourceCase_ == 2) {
              source_ = s;
            }
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * An inline script.
         * The size of the script is limited to 1024 characters.
         * </pre>
         *
         * <code>string script = 2;</code>
         *
         * @return The bytes for script.
         */
        public com.google.protobuf.ByteString getScriptBytes() {
          java.lang.Object ref = "";
          if (sourceCase_ == 2) {
            ref = source_;
          }
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (sourceCase_ == 2) {
              source_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int ARGS_FIELD_NUMBER = 3;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList args_ =
            com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         *
         *
         * <pre>
         * Optional arguments to pass to the source during execution.
         * </pre>
         *
         * <code>repeated string args = 3;</code>
         *
         * @return A list containing the args.
         */
        public com.google.protobuf.ProtocolStringList getArgsList() {
          return args_;
        }
        /**
         *
         *
         * <pre>
         * Optional arguments to pass to the source during execution.
         * </pre>
         *
         * <code>repeated string args = 3;</code>
         *
         * @return The count of args.
         */
        public int getArgsCount() {
          return args_.size();
        }
        /**
         *
         *
         * <pre>
         * Optional arguments to pass to the source during execution.
         * </pre>
         *
         * <code>repeated string args = 3;</code>
         *
         * @param index The index of the element to return.
         * @return The args at the given index.
         */
        public java.lang.String getArgs(int index) {
          return args_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Optional arguments to pass to the source during execution.
         * </pre>
         *
         * <code>repeated string args = 3;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the args at the given index.
         */
        public com.google.protobuf.ByteString getArgsBytes(int index) {
          return args_.getByteString(index);
        }

        public static final int INTERPRETER_FIELD_NUMBER = 4;
        private int interpreter_ = 0;
        /**
         *
         *
         * <pre>
         * Required. The script interpreter to use.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter interpreter = 4 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for interpreter.
         */
        @java.lang.Override
        public int getInterpreterValue() {
          return interpreter_;
        }
        /**
         *
         *
         * <pre>
         * Required. The script interpreter to use.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter interpreter = 4 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The interpreter.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter
            getInterpreter() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter result =
              com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter
                  .forNumber(interpreter_);
          return result == null
              ? com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter
                  .UNRECOGNIZED
              : result;
        }

        public static final int OUTPUT_FILE_PATH_FIELD_NUMBER = 5;

        @SuppressWarnings("serial")
        private volatile java.lang.Object outputFilePath_ = "";
        /**
         *
         *
         * <pre>
         * Only recorded for enforce Exec.
         * Path to an output file (that is created by this Exec) whose
         * content will be recorded in OSPolicyResourceCompliance after a
         * successful run. Absence or failure to read this file will result in
         * this ExecResource being non-compliant. Output file size is limited to
         * 100K bytes.
         * </pre>
         *
         * <code>string output_file_path = 5;</code>
         *
         * @return The outputFilePath.
         */
        @java.lang.Override
        public java.lang.String getOutputFilePath() {
          java.lang.Object ref = outputFilePath_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            outputFilePath_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Only recorded for enforce Exec.
         * Path to an output file (that is created by this Exec) whose
         * content will be recorded in OSPolicyResourceCompliance after a
         * successful run. Absence or failure to read this file will result in
         * this ExecResource being non-compliant. Output file size is limited to
         * 100K bytes.
         * </pre>
         *
         * <code>string output_file_path = 5;</code>
         *
         * @return The bytes for outputFilePath.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getOutputFilePathBytes() {
          java.lang.Object ref = outputFilePath_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            outputFilePath_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (sourceCase_ == 1) {
            output.writeMessage(1, (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_);
          }
          if (sourceCase_ == 2) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, source_);
          }
          for (int i = 0; i < args_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 3, args_.getRaw(i));
          }
          if (interpreter_
              != com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter
                  .INTERPRETER_UNSPECIFIED
                  .getNumber()) {
            output.writeEnum(4, interpreter_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputFilePath_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 5, outputFilePath_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (sourceCase_ == 1) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    1, (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_);
          }
          if (sourceCase_ == 2) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, source_);
          }
          {
            int dataSize = 0;
            for (int i = 0; i < args_.size(); i++) {
              dataSize += computeStringSizeNoTag(args_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getArgsList().size();
          }
          if (interpreter_
              != com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter
                  .INTERPRETER_UNSPECIFIED
                  .getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, interpreter_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputFilePath_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, outputFilePath_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec other =
              (com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec) obj;

          if (!getArgsList().equals(other.getArgsList())) return false;
          if (interpreter_ != other.interpreter_) return false;
          if (!getOutputFilePath().equals(other.getOutputFilePath())) return false;
          if (!getSourceCase().equals(other.getSourceCase())) return false;
          switch (sourceCase_) {
            case 1:
              if (!getFile().equals(other.getFile())) return false;
              break;
            case 2:
              if (!getScript().equals(other.getScript())) return false;
              break;
            case 0:
            default:
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getArgsCount() > 0) {
            hash = (37 * hash) + ARGS_FIELD_NUMBER;
            hash = (53 * hash) + getArgsList().hashCode();
          }
          hash = (37 * hash) + INTERPRETER_FIELD_NUMBER;
          hash = (53 * hash) + interpreter_;
          hash = (37 * hash) + OUTPUT_FILE_PATH_FIELD_NUMBER;
          hash = (53 * hash) + getOutputFilePath().hashCode();
          switch (sourceCase_) {
            case 1:
              hash = (37 * hash) + FILE_FIELD_NUMBER;
              hash = (53 * hash) + getFile().hashCode();
              break;
            case 2:
              hash = (37 * hash) + SCRIPT_FIELD_NUMBER;
              hash = (53 * hash) + getScript().hashCode();
              break;
            case 0:
            default:
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A file or script to execute.
         * </pre>
         *
         * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec)
            com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.ExecOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_ExecResource_Exec_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_ExecResource_Exec_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.class,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Builder.class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            if (fileBuilder_ != null) {
              fileBuilder_.clear();
            }
            args_ = com.google.protobuf.LazyStringArrayList.emptyList();
            interpreter_ = 0;
            outputFilePath_ = "";
            sourceCase_ = 0;
            source_ = null;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OsPolicyProto
                .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_ExecResource_Exec_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec build() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec result =
                new com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            buildPartialOneofs(result);
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000004) != 0)) {
              args_.makeImmutable();
              result.args_ = args_;
            }
            if (((from_bitField0_ & 0x00000008) != 0)) {
              result.interpreter_ = interpreter_;
            }
            if (((from_bitField0_ & 0x00000010) != 0)) {
              result.outputFilePath_ = outputFilePath_;
            }
          }

          private void buildPartialOneofs(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec result) {
            result.sourceCase_ = sourceCase_;
            result.source_ = this.source_;
            if (sourceCase_ == 1 && fileBuilder_ != null) {
              result.source_ = fileBuilder_.build();
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
                    .getDefaultInstance()) return this;
            if (!other.args_.isEmpty()) {
              if (args_.isEmpty()) {
                args_ = other.args_;
                bitField0_ |= 0x00000004;
              } else {
                ensureArgsIsMutable();
                args_.addAll(other.args_);
              }
              onChanged();
            }
            if (other.interpreter_ != 0) {
              setInterpreterValue(other.getInterpreterValue());
            }
            if (!other.getOutputFilePath().isEmpty()) {
              outputFilePath_ = other.outputFilePath_;
              bitField0_ |= 0x00000010;
              onChanged();
            }
            switch (other.getSourceCase()) {
              case FILE:
                {
                  mergeFile(other.getFile());
                  break;
                }
              case SCRIPT:
                {
                  sourceCase_ = 2;
                  source_ = other.source_;
                  onChanged();
                  break;
                }
              case SOURCE_NOT_SET:
                {
                  break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(getFileFieldBuilder().getBuilder(), extensionRegistry);
                      sourceCase_ = 1;
                      break;
                    } // case 10
                  case 18:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      sourceCase_ = 2;
                      source_ = s;
                      break;
                    } // case 18
                  case 26:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureArgsIsMutable();
                      args_.add(s);
                      break;
                    } // case 26
                  case 32:
                    {
                      interpreter_ = input.readEnum();
                      bitField0_ |= 0x00000008;
                      break;
                    } // case 32
                  case 42:
                    {
                      outputFilePath_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000010;
                      break;
                    } // case 42
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int sourceCase_ = 0;
          private java.lang.Object source_;

          public SourceCase getSourceCase() {
            return SourceCase.forNumber(sourceCase_);
          }

          public Builder clearSource() {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>
              fileBuilder_;
          /**
           *
           *
           * <pre>
           * A remote or local file.
           * </pre>
           *
           * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
           *
           * @return Whether the file field is set.
           */
          @java.lang.Override
          public boolean hasFile() {
            return sourceCase_ == 1;
          }
          /**
           *
           *
           * <pre>
           * A remote or local file.
           * </pre>
           *
           * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
           *
           * @return The file.
           */
          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File getFile() {
            if (fileBuilder_ == null) {
              if (sourceCase_ == 1) {
                return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_;
              }
              return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance();
            } else {
              if (sourceCase_ == 1) {
                return fileBuilder_.getMessage();
              }
              return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * A remote or local file.
           * </pre>
           *
           * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
           */
          public Builder setFile(com.google.cloud.osconfig.v1.OSPolicy.Resource.File value) {
            if (fileBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              source_ = value;
              onChanged();
            } else {
              fileBuilder_.setMessage(value);
            }
            sourceCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * A remote or local file.
           * </pre>
           *
           * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
           */
          public Builder setFile(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder builderForValue) {
            if (fileBuilder_ == null) {
              source_ = builderForValue.build();
              onChanged();
            } else {
              fileBuilder_.setMessage(builderForValue.build());
            }
            sourceCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * A remote or local file.
           * </pre>
           *
           * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
           */
          public Builder mergeFile(com.google.cloud.osconfig.v1.OSPolicy.Resource.File value) {
            if (fileBuilder_ == null) {
              if (sourceCase_ == 1
                  && source_
                      != com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()) {
                source_ =
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.File.newBuilder(
                            (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                source_ = value;
              }
              onChanged();
            } else {
              if (sourceCase_ == 1) {
                fileBuilder_.mergeFrom(value);
              } else {
                fileBuilder_.setMessage(value);
              }
            }
            sourceCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * A remote or local file.
           * </pre>
           *
           * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
           */
          public Builder clearFile() {
            if (fileBuilder_ == null) {
              if (sourceCase_ == 1) {
                sourceCase_ = 0;
                source_ = null;
                onChanged();
              }
            } else {
              if (sourceCase_ == 1) {
                sourceCase_ = 0;
                source_ = null;
              }
              fileBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A remote or local file.
           * </pre>
           *
           * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
           */
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder getFileBuilder() {
            return getFileFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * A remote or local file.
           * </pre>
           *
           * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
           */
          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getFileOrBuilder() {
            if ((sourceCase_ == 1) && (fileBuilder_ != null)) {
              return fileBuilder_.getMessageOrBuilder();
            } else {
              if (sourceCase_ == 1) {
                return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_;
              }
              return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * A remote or local file.
           * </pre>
           *
           * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>
              getFileFieldBuilder() {
            if (fileBuilder_ == null) {
              if (!(sourceCase_ == 1)) {
                source_ = com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance();
              }
              fileBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                      com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                      com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>(
                      (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_,
                      getParentForChildren(),
                      isClean());
              source_ = null;
            }
            sourceCase_ = 1;
            onChanged();
            return fileBuilder_;
          }

          /**
           *
           *
           * <pre>
           * An inline script.
           * The size of the script is limited to 1024 characters.
           * </pre>
           *
           * <code>string script = 2;</code>
           *
           * @return Whether the script field is set.
           */
          @java.lang.Override
          public boolean hasScript() {
            return sourceCase_ == 2;
          }
          /**
           *
           *
           * <pre>
           * An inline script.
           * The size of the script is limited to 1024 characters.
           * </pre>
           *
           * <code>string script = 2;</code>
           *
           * @return The script.
           */
          @java.lang.Override
          public java.lang.String getScript() {
            java.lang.Object ref = "";
            if (sourceCase_ == 2) {
              ref = source_;
            }
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              if (sourceCase_ == 2) {
                source_ = s;
              }
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * An inline script.
           * The size of the script is limited to 1024 characters.
           * </pre>
           *
           * <code>string script = 2;</code>
           *
           * @return The bytes for script.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getScriptBytes() {
            java.lang.Object ref = "";
            if (sourceCase_ == 2) {
              ref = source_;
            }
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              if (sourceCase_ == 2) {
                source_ = b;
              }
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * An inline script.
           * The size of the script is limited to 1024 characters.
           * </pre>
           *
           * <code>string script = 2;</code>
           *
           * @param value The script to set.
           * @return This builder for chaining.
           */
          public Builder setScript(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            sourceCase_ = 2;
            source_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * An inline script.
           * The size of the script is limited to 1024 characters.
           * </pre>
           *
           * <code>string script = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearScript() {
            if (sourceCase_ == 2) {
              sourceCase_ = 0;
              source_ = null;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * An inline script.
           * The size of the script is limited to 1024 characters.
           * </pre>
           *
           * <code>string script = 2;</code>
           *
           * @param value The bytes for script to set.
           * @return This builder for chaining.
           */
          public Builder setScriptBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            sourceCase_ = 2;
            source_ = value;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringArrayList args_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureArgsIsMutable() {
            if (!args_.isModifiable()) {
              args_ = new com.google.protobuf.LazyStringArrayList(args_);
            }
            bitField0_ |= 0x00000004;
          }
          /**
           *
           *
           * <pre>
           * Optional arguments to pass to the source during execution.
           * </pre>
           *
           * <code>repeated string args = 3;</code>
           *
           * @return A list containing the args.
           */
          public com.google.protobuf.ProtocolStringList getArgsList() {
            args_.makeImmutable();
            return args_;
          }
          /**
           *
           *
           * <pre>
           * Optional arguments to pass to the source during execution.
           * </pre>
           *
           * <code>repeated string args = 3;</code>
           *
           * @return The count of args.
           */
          public int getArgsCount() {
            return args_.size();
          }
          /**
           *
           *
           * <pre>
           * Optional arguments to pass to the source during execution.
           * </pre>
           *
           * <code>repeated string args = 3;</code>
           *
           * @param index The index of the element to return.
           * @return The args at the given index.
           */
          public java.lang.String getArgs(int index) {
            return args_.get(index);
          }
          /**
           *
           *
           * <pre>
           * Optional arguments to pass to the source during execution.
           * </pre>
           *
           * <code>repeated string args = 3;</code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the args at the given index.
           */
          public com.google.protobuf.ByteString getArgsBytes(int index) {
            return args_.getByteString(index);
          }
          /**
           *
           *
           * <pre>
           * Optional arguments to pass to the source during execution.
           * </pre>
           *
           * <code>repeated string args = 3;</code>
           *
           * @param index The index to set the value at.
           * @param value The args to set.
           * @return This builder for chaining.
           */
          public Builder setArgs(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureArgsIsMutable();
            args_.set(index, value);
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional arguments to pass to the source during execution.
           * </pre>
           *
           * <code>repeated string args = 3;</code>
           *
           * @param value The args to add.
           * @return This builder for chaining.
           */
          public Builder addArgs(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureArgsIsMutable();
            args_.add(value);
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional arguments to pass to the source during execution.
           * </pre>
           *
           * <code>repeated string args = 3;</code>
           *
           * @param values The args to add.
           * @return This builder for chaining.
           */
          public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
            ensureArgsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional arguments to pass to the source during execution.
           * </pre>
           *
           * <code>repeated string args = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearArgs() {
            args_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            ;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional arguments to pass to the source during execution.
           * </pre>
           *
           * <code>repeated string args = 3;</code>
           *
           * @param value The bytes of the args to add.
           * @return This builder for chaining.
           */
          public Builder addArgsBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureArgsIsMutable();
            args_.add(value);
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          private int interpreter_ = 0;
          /**
           *
           *
           * <pre>
           * Required. The script interpreter to use.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter interpreter = 4 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The enum numeric value on the wire for interpreter.
           */
          @java.lang.Override
          public int getInterpreterValue() {
            return interpreter_;
          }
          /**
           *
           *
           * <pre>
           * Required. The script interpreter to use.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter interpreter = 4 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @param value The enum numeric value on the wire for interpreter to set.
           * @return This builder for chaining.
           */
          public Builder setInterpreterValue(int value) {
            interpreter_ = value;
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The script interpreter to use.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter interpreter = 4 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The interpreter.
           */
          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter
              getInterpreter() {
            com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter result =
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter
                    .forNumber(interpreter_);
            return result == null
                ? com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter
                    .UNRECOGNIZED
                : result;
          }
          /**
           *
           *
           * <pre>
           * Required. The script interpreter to use.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter interpreter = 4 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @param value The interpreter to set.
           * @return This builder for chaining.
           */
          public Builder setInterpreter(
              com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000008;
            interpreter_ = value.getNumber();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. The script interpreter to use.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter interpreter = 4 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearInterpreter() {
            bitField0_ = (bitField0_ & ~0x00000008);
            interpreter_ = 0;
            onChanged();
            return this;
          }

          private java.lang.Object outputFilePath_ = "";
          /**
           *
           *
           * <pre>
           * Only recorded for enforce Exec.
           * Path to an output file (that is created by this Exec) whose
           * content will be recorded in OSPolicyResourceCompliance after a
           * successful run. Absence or failure to read this file will result in
           * this ExecResource being non-compliant. Output file size is limited to
           * 100K bytes.
           * </pre>
           *
           * <code>string output_file_path = 5;</code>
           *
           * @return The outputFilePath.
           */
          public java.lang.String getOutputFilePath() {
            java.lang.Object ref = outputFilePath_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              outputFilePath_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Only recorded for enforce Exec.
           * Path to an output file (that is created by this Exec) whose
           * content will be recorded in OSPolicyResourceCompliance after a
           * successful run. Absence or failure to read this file will result in
           * this ExecResource being non-compliant. Output file size is limited to
           * 100K bytes.
           * </pre>
           *
           * <code>string output_file_path = 5;</code>
           *
           * @return The bytes for outputFilePath.
           */
          public com.google.protobuf.ByteString getOutputFilePathBytes() {
            java.lang.Object ref = outputFilePath_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              outputFilePath_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Only recorded for enforce Exec.
           * Path to an output file (that is created by this Exec) whose
           * content will be recorded in OSPolicyResourceCompliance after a
           * successful run. Absence or failure to read this file will result in
           * this ExecResource being non-compliant. Output file size is limited to
           * 100K bytes.
           * </pre>
           *
           * <code>string output_file_path = 5;</code>
           *
           * @param value The outputFilePath to set.
           * @return This builder for chaining.
           */
          public Builder setOutputFilePath(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            outputFilePath_ = value;
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Only recorded for enforce Exec.
           * Path to an output file (that is created by this Exec) whose
           * content will be recorded in OSPolicyResourceCompliance after a
           * successful run. Absence or failure to read this file will result in
           * this ExecResource being non-compliant. Output file size is limited to
           * 100K bytes.
           * </pre>
           *
           * <code>string output_file_path = 5;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearOutputFilePath() {
            outputFilePath_ = getDefaultInstance().getOutputFilePath();
            bitField0_ = (bitField0_ & ~0x00000010);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Only recorded for enforce Exec.
           * Path to an output file (that is created by this Exec) whose
           * content will be recorded in OSPolicyResourceCompliance after a
           * successful run. Absence or failure to read this file will result in
           * this ExecResource being non-compliant. Output file size is limited to
           * 100K bytes.
           * </pre>
           *
           * <code>string output_file_path = 5;</code>
           *
           * @param value The bytes for outputFilePath to set.
           * @return This builder for chaining.
           */
          public Builder setOutputFilePathBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            outputFilePath_ = value;
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec)
        private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec();
        }

        public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Exec> PARSER =
            new com.google.protobuf.AbstractParser<Exec>() {
              @java.lang.Override
              public Exec parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Exec> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Exec> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int VALIDATE_FIELD_NUMBER = 1;
      private com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate_;
      /**
       *
       *
       * <pre>
       * Required. What to run to validate this resource is in the desired
       * state. An exit code of 100 indicates "in desired state", and exit code
       * of 101 indicates "not in desired state". Any other exit code indicates
       * a failure running validate.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the validate field is set.
       */
      @java.lang.Override
      public boolean hasValidate() {
        return validate_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. What to run to validate this resource is in the desired
       * state. An exit code of 100 indicates "in desired state", and exit code
       * of 101 indicates "not in desired state". Any other exit code indicates
       * a failure running validate.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The validate.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec getValidate() {
        return validate_ == null
            ? com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.getDefaultInstance()
            : validate_;
      }
      /**
       *
       *
       * <pre>
       * Required. What to run to validate this resource is in the desired
       * state. An exit code of 100 indicates "in desired state", and exit code
       * of 101 indicates "not in desired state". Any other exit code indicates
       * a failure running validate.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.ExecOrBuilder
          getValidateOrBuilder() {
        return validate_ == null
            ? com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.getDefaultInstance()
            : validate_;
      }

      public static final int ENFORCE_FIELD_NUMBER = 2;
      private com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce_;
      /**
       *
       *
       * <pre>
       * What to run to bring this resource into the desired state.
       * An exit code of 100 indicates "success", any other exit code indicates
       * a failure running enforce.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
       *
       * @return Whether the enforce field is set.
       */
      @java.lang.Override
      public boolean hasEnforce() {
        return enforce_ != null;
      }
      /**
       *
       *
       * <pre>
       * What to run to bring this resource into the desired state.
       * An exit code of 100 indicates "success", any other exit code indicates
       * a failure running enforce.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
       *
       * @return The enforce.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec getEnforce() {
        return enforce_ == null
            ? com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.getDefaultInstance()
            : enforce_;
      }
      /**
       *
       *
       * <pre>
       * What to run to bring this resource into the desired state.
       * An exit code of 100 indicates "success", any other exit code indicates
       * a failure running enforce.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.ExecOrBuilder
          getEnforceOrBuilder() {
        return enforce_ == null
            ? com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.getDefaultInstance()
            : enforce_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (validate_ != null) {
          output.writeMessage(1, getValidate());
        }
        if (enforce_ != null) {
          output.writeMessage(2, getEnforce());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (validate_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getValidate());
        }
        if (enforce_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEnforce());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource)) {
          return super.equals(obj);
        }
        com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource other =
            (com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource) obj;

        if (hasValidate() != other.hasValidate()) return false;
        if (hasValidate()) {
          if (!getValidate().equals(other.getValidate())) return false;
        }
        if (hasEnforce() != other.hasEnforce()) return false;
        if (hasEnforce()) {
          if (!getEnforce().equals(other.getEnforce())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasValidate()) {
          hash = (37 * hash) + VALIDATE_FIELD_NUMBER;
          hash = (53 * hash) + getValidate().hashCode();
        }
        if (hasEnforce()) {
          hash = (37 * hash) + ENFORCE_FIELD_NUMBER;
          hash = (53 * hash) + getEnforce().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A resource that allows executing scripts on the VM.
       *
       * The `ExecResource` has 2 stages: `validate` and `enforce` and both stages
       * accept a script as an argument to execute.
       *
       * When the `ExecResource` is applied by the agent, it first executes the
       * script in the `validate` stage. The `validate` stage can signal that the
       * `ExecResource` is already in the desired state by returning an exit code
       * of `100`. If the `ExecResource` is not in the desired state, it should
       * return an exit code of `101`. Any other exit code returned by this stage
       * is considered an error.
       *
       * If the `ExecResource` is not in the desired state based on the exit code
       * from the `validate` stage, the agent proceeds to execute the script from
       * the `enforce` stage. If the `ExecResource` is already in the desired
       * state, the `enforce` stage will not be run.
       * Similar to `validate` stage, the `enforce` stage should return an exit
       * code of `100` to indicate that the resource in now in its desired state.
       * Any other exit code is considered an error.
       *
       * NOTE: An exit code of `100` was chosen over `0` (and `101` vs `1`) to
       * have an explicit indicator of `in desired state`, `not in desired state`
       * and errors. Because, for example, Powershell will always return an exit
       * code of `0` unless an `exit` statement is provided in the script. So, for
       * reasons of consistency and being explicit, exit codes `100` and `101`
       * were chosen.
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource)
          com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_ExecResource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_ExecResource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Builder.class);
        }

        // Construct using com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          validate_ = null;
          if (validateBuilder_ != null) {
            validateBuilder_.dispose();
            validateBuilder_ = null;
          }
          enforce_ = null;
          if (enforceBuilder_ != null) {
            enforceBuilder_.dispose();
            enforceBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_ExecResource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource
            getDefaultInstanceForType() {
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource build() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource buildPartial() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource result =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.validate_ = validateBuilder_ == null ? validate_ : validateBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.enforce_ = enforceBuilder_ == null ? enforce_ : enforceBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource) {
            return mergeFrom((com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource other) {
          if (other
              == com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.getDefaultInstance())
            return this;
          if (other.hasValidate()) {
            mergeValidate(other.getValidate());
          }
          if (other.hasEnforce()) {
            mergeEnforce(other.getEnforce());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getValidateFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getEnforceFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.ExecOrBuilder>
            validateBuilder_;
        /**
         *
         *
         * <pre>
         * Required. What to run to validate this resource is in the desired
         * state. An exit code of 100 indicates "in desired state", and exit code
         * of 101 indicates "not in desired state". Any other exit code indicates
         * a failure running validate.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the validate field is set.
         */
        public boolean hasValidate() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Required. What to run to validate this resource is in the desired
         * state. An exit code of 100 indicates "in desired state", and exit code
         * of 101 indicates "not in desired state". Any other exit code indicates
         * a failure running validate.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The validate.
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec getValidate() {
          if (validateBuilder_ == null) {
            return validate_ == null
                ? com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
                    .getDefaultInstance()
                : validate_;
          } else {
            return validateBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. What to run to validate this resource is in the desired
         * state. An exit code of 100 indicates "in desired state", and exit code
         * of 101 indicates "not in desired state". Any other exit code indicates
         * a failure running validate.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setValidate(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec value) {
          if (validateBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            validate_ = value;
          } else {
            validateBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. What to run to validate this resource is in the desired
         * state. An exit code of 100 indicates "in desired state", and exit code
         * of 101 indicates "not in desired state". Any other exit code indicates
         * a failure running validate.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setValidate(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Builder
                builderForValue) {
          if (validateBuilder_ == null) {
            validate_ = builderForValue.build();
          } else {
            validateBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. What to run to validate this resource is in the desired
         * state. An exit code of 100 indicates "in desired state", and exit code
         * of 101 indicates "not in desired state". Any other exit code indicates
         * a failure running validate.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeValidate(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec value) {
          if (validateBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && validate_ != null
                && validate_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
                        .getDefaultInstance()) {
              getValidateBuilder().mergeFrom(value);
            } else {
              validate_ = value;
            }
          } else {
            validateBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. What to run to validate this resource is in the desired
         * state. An exit code of 100 indicates "in desired state", and exit code
         * of 101 indicates "not in desired state". Any other exit code indicates
         * a failure running validate.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearValidate() {
          bitField0_ = (bitField0_ & ~0x00000001);
          validate_ = null;
          if (validateBuilder_ != null) {
            validateBuilder_.dispose();
            validateBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. What to run to validate this resource is in the desired
         * state. An exit code of 100 indicates "in desired state", and exit code
         * of 101 indicates "not in desired state". Any other exit code indicates
         * a failure running validate.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Builder
            getValidateBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getValidateFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Required. What to run to validate this resource is in the desired
         * state. An exit code of 100 indicates "in desired state", and exit code
         * of 101 indicates "not in desired state". Any other exit code indicates
         * a failure running validate.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.ExecOrBuilder
            getValidateOrBuilder() {
          if (validateBuilder_ != null) {
            return validateBuilder_.getMessageOrBuilder();
          } else {
            return validate_ == null
                ? com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
                    .getDefaultInstance()
                : validate_;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. What to run to validate this resource is in the desired
         * state. An exit code of 100 indicates "in desired state", and exit code
         * of 101 indicates "not in desired state". Any other exit code indicates
         * a failure running validate.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec validate = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.ExecOrBuilder>
            getValidateFieldBuilder() {
          if (validateBuilder_ == null) {
            validateBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.ExecOrBuilder>(
                    getValidate(), getParentForChildren(), isClean());
            validate_ = null;
          }
          return validateBuilder_;
        }

        private com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.ExecOrBuilder>
            enforceBuilder_;
        /**
         *
         *
         * <pre>
         * What to run to bring this resource into the desired state.
         * An exit code of 100 indicates "success", any other exit code indicates
         * a failure running enforce.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
         *
         * @return Whether the enforce field is set.
         */
        public boolean hasEnforce() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * What to run to bring this resource into the desired state.
         * An exit code of 100 indicates "success", any other exit code indicates
         * a failure running enforce.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
         *
         * @return The enforce.
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec getEnforce() {
          if (enforceBuilder_ == null) {
            return enforce_ == null
                ? com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
                    .getDefaultInstance()
                : enforce_;
          } else {
            return enforceBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * What to run to bring this resource into the desired state.
         * An exit code of 100 indicates "success", any other exit code indicates
         * a failure running enforce.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
         */
        public Builder setEnforce(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec value) {
          if (enforceBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            enforce_ = value;
          } else {
            enforceBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * What to run to bring this resource into the desired state.
         * An exit code of 100 indicates "success", any other exit code indicates
         * a failure running enforce.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
         */
        public Builder setEnforce(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Builder
                builderForValue) {
          if (enforceBuilder_ == null) {
            enforce_ = builderForValue.build();
          } else {
            enforceBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * What to run to bring this resource into the desired state.
         * An exit code of 100 indicates "success", any other exit code indicates
         * a failure running enforce.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
         */
        public Builder mergeEnforce(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec value) {
          if (enforceBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && enforce_ != null
                && enforce_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
                        .getDefaultInstance()) {
              getEnforceBuilder().mergeFrom(value);
            } else {
              enforce_ = value;
            }
          } else {
            enforceBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * What to run to bring this resource into the desired state.
         * An exit code of 100 indicates "success", any other exit code indicates
         * a failure running enforce.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
         */
        public Builder clearEnforce() {
          bitField0_ = (bitField0_ & ~0x00000002);
          enforce_ = null;
          if (enforceBuilder_ != null) {
            enforceBuilder_.dispose();
            enforceBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * What to run to bring this resource into the desired state.
         * An exit code of 100 indicates "success", any other exit code indicates
         * a failure running enforce.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Builder
            getEnforceBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getEnforceFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * What to run to bring this resource into the desired state.
         * An exit code of 100 indicates "success", any other exit code indicates
         * a failure running enforce.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.ExecOrBuilder
            getEnforceOrBuilder() {
          if (enforceBuilder_ != null) {
            return enforceBuilder_.getMessageOrBuilder();
          } else {
            return enforce_ == null
                ? com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec
                    .getDefaultInstance()
                : enforce_;
          }
        }
        /**
         *
         *
         * <pre>
         * What to run to bring this resource into the desired state.
         * An exit code of 100 indicates "success", any other exit code indicates
         * a failure running enforce.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec enforce = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.ExecOrBuilder>
            getEnforceFieldBuilder() {
          if (enforceBuilder_ == null) {
            enforceBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Exec.Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.ExecOrBuilder>(
                    getEnforce(), getParentForChildren(), isClean());
            enforce_ = null;
          }
          return enforceBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource)
      private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource();
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ExecResource> PARSER =
          new com.google.protobuf.AbstractParser<ExecResource>() {
            @java.lang.Override
            public ExecResource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ExecResource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ExecResource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface FileResourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicy.Resource.FileResource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * A remote or local source.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
       *
       * @return Whether the file field is set.
       */
      boolean hasFile();
      /**
       *
       *
       * <pre>
       * A remote or local source.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
       *
       * @return The file.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.File getFile();
      /**
       *
       *
       * <pre>
       * A remote or local source.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getFileOrBuilder();

      /**
       *
       *
       * <pre>
       * A a file with this content.
       * The size of the content is limited to 1024 characters.
       * </pre>
       *
       * <code>string content = 2;</code>
       *
       * @return Whether the content field is set.
       */
      boolean hasContent();
      /**
       *
       *
       * <pre>
       * A a file with this content.
       * The size of the content is limited to 1024 characters.
       * </pre>
       *
       * <code>string content = 2;</code>
       *
       * @return The content.
       */
      java.lang.String getContent();
      /**
       *
       *
       * <pre>
       * A a file with this content.
       * The size of the content is limited to 1024 characters.
       * </pre>
       *
       * <code>string content = 2;</code>
       *
       * @return The bytes for content.
       */
      com.google.protobuf.ByteString getContentBytes();

      /**
       *
       *
       * <pre>
       * Required. The absolute path of the file within the VM.
       * </pre>
       *
       * <code>string path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The path.
       */
      java.lang.String getPath();
      /**
       *
       *
       * <pre>
       * Required. The absolute path of the file within the VM.
       * </pre>
       *
       * <code>string path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for path.
       */
      com.google.protobuf.ByteString getPathBytes();

      /**
       *
       *
       * <pre>
       * Required. Desired state of the file.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState state = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      int getStateValue();
      /**
       *
       *
       * <pre>
       * Required. Desired state of the file.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState state = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The state.
       */
      com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState getState();

      /**
       *
       *
       * <pre>
       * Consists of three octal digits which represent, in
       * order, the permissions of the owner, group, and other users for the
       * file (similarly to the numeric mode used in the linux chmod
       * utility). Each digit represents a three bit number with the 4 bit
       * corresponding to the read permissions, the 2 bit corresponds to the
       * write bit, and the one bit corresponds to the execute permission.
       * Default behavior is 755.
       *
       * Below are some examples of permissions and their associated values:
       * read, write, and execute: 7
       * read and execute: 5
       * read and write: 6
       * read only: 4
       * </pre>
       *
       * <code>string permissions = 5;</code>
       *
       * @return The permissions.
       */
      java.lang.String getPermissions();
      /**
       *
       *
       * <pre>
       * Consists of three octal digits which represent, in
       * order, the permissions of the owner, group, and other users for the
       * file (similarly to the numeric mode used in the linux chmod
       * utility). Each digit represents a three bit number with the 4 bit
       * corresponding to the read permissions, the 2 bit corresponds to the
       * write bit, and the one bit corresponds to the execute permission.
       * Default behavior is 755.
       *
       * Below are some examples of permissions and their associated values:
       * read, write, and execute: 7
       * read and execute: 5
       * read and write: 6
       * read only: 4
       * </pre>
       *
       * <code>string permissions = 5;</code>
       *
       * @return The bytes for permissions.
       */
      com.google.protobuf.ByteString getPermissionsBytes();

      com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.SourceCase getSourceCase();
    }
    /**
     *
     *
     * <pre>
     * A resource that manages the state of a file.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.FileResource}
     */
    public static final class FileResource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicy.Resource.FileResource)
        FileResourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FileResource.newBuilder() to construct.
      private FileResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FileResource() {
        path_ = "";
        state_ = 0;
        permissions_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FileResource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_FileResource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_FileResource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.class,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Desired state of the file.
       * </pre>
       *
       * Protobuf enum {@code google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState}
       */
      public enum DesiredState implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified is invalid.
         * </pre>
         *
         * <code>DESIRED_STATE_UNSPECIFIED = 0;</code>
         */
        DESIRED_STATE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Ensure file at path is present.
         * </pre>
         *
         * <code>PRESENT = 1;</code>
         */
        PRESENT(1),
        /**
         *
         *
         * <pre>
         * Ensure file at path is absent.
         * </pre>
         *
         * <code>ABSENT = 2;</code>
         */
        ABSENT(2),
        /**
         *
         *
         * <pre>
         * Ensure the contents of the file at path matches. If the file does
         * not exist it will be created.
         * </pre>
         *
         * <code>CONTENTS_MATCH = 3;</code>
         */
        CONTENTS_MATCH(3),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified is invalid.
         * </pre>
         *
         * <code>DESIRED_STATE_UNSPECIFIED = 0;</code>
         */
        public static final int DESIRED_STATE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Ensure file at path is present.
         * </pre>
         *
         * <code>PRESENT = 1;</code>
         */
        public static final int PRESENT_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Ensure file at path is absent.
         * </pre>
         *
         * <code>ABSENT = 2;</code>
         */
        public static final int ABSENT_VALUE = 2;
        /**
         *
         *
         * <pre>
         * Ensure the contents of the file at path matches. If the file does
         * not exist it will be created.
         * </pre>
         *
         * <code>CONTENTS_MATCH = 3;</code>
         */
        public static final int CONTENTS_MATCH_VALUE = 3;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static DesiredState valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static DesiredState forNumber(int value) {
          switch (value) {
            case 0:
              return DESIRED_STATE_UNSPECIFIED;
            case 1:
              return PRESENT;
            case 2:
              return ABSENT;
            case 3:
              return CONTENTS_MATCH;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<DesiredState> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<DesiredState>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<DesiredState>() {
                  public DesiredState findValueByNumber(int number) {
                    return DesiredState.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final DesiredState[] VALUES = values();

        public static DesiredState valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private DesiredState(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState)
      }

      private int sourceCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object source_;

      public enum SourceCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        FILE(1),
        CONTENT(2),
        SOURCE_NOT_SET(0);
        private final int value;

        private SourceCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static SourceCase valueOf(int value) {
          return forNumber(value);
        }

        public static SourceCase forNumber(int value) {
          switch (value) {
            case 1:
              return FILE;
            case 2:
              return CONTENT;
            case 0:
              return SOURCE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public SourceCase getSourceCase() {
        return SourceCase.forNumber(sourceCase_);
      }

      public static final int FILE_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * A remote or local source.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
       *
       * @return Whether the file field is set.
       */
      @java.lang.Override
      public boolean hasFile() {
        return sourceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * A remote or local source.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
       *
       * @return The file.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.File getFile() {
        if (sourceCase_ == 1) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A remote or local source.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getFileOrBuilder() {
        if (sourceCase_ == 1) {
          return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_;
        }
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance();
      }

      public static final int CONTENT_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * A a file with this content.
       * The size of the content is limited to 1024 characters.
       * </pre>
       *
       * <code>string content = 2;</code>
       *
       * @return Whether the content field is set.
       */
      public boolean hasContent() {
        return sourceCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * A a file with this content.
       * The size of the content is limited to 1024 characters.
       * </pre>
       *
       * <code>string content = 2;</code>
       *
       * @return The content.
       */
      public java.lang.String getContent() {
        java.lang.Object ref = "";
        if (sourceCase_ == 2) {
          ref = source_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (sourceCase_ == 2) {
            source_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * A a file with this content.
       * The size of the content is limited to 1024 characters.
       * </pre>
       *
       * <code>string content = 2;</code>
       *
       * @return The bytes for content.
       */
      public com.google.protobuf.ByteString getContentBytes() {
        java.lang.Object ref = "";
        if (sourceCase_ == 2) {
          ref = source_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (sourceCase_ == 2) {
            source_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PATH_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object path_ = "";
      /**
       *
       *
       * <pre>
       * Required. The absolute path of the file within the VM.
       * </pre>
       *
       * <code>string path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The path.
       */
      @java.lang.Override
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The absolute path of the file within the VM.
       * </pre>
       *
       * <code>string path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for path.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int STATE_FIELD_NUMBER = 4;
      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Required. Desired state of the file.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState state = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Required. Desired state of the file.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState state = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState getState() {
        com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState result =
            com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState.forNumber(
                state_);
        return result == null
            ? com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState.UNRECOGNIZED
            : result;
      }

      public static final int PERMISSIONS_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private volatile java.lang.Object permissions_ = "";
      /**
       *
       *
       * <pre>
       * Consists of three octal digits which represent, in
       * order, the permissions of the owner, group, and other users for the
       * file (similarly to the numeric mode used in the linux chmod
       * utility). Each digit represents a three bit number with the 4 bit
       * corresponding to the read permissions, the 2 bit corresponds to the
       * write bit, and the one bit corresponds to the execute permission.
       * Default behavior is 755.
       *
       * Below are some examples of permissions and their associated values:
       * read, write, and execute: 7
       * read and execute: 5
       * read and write: 6
       * read only: 4
       * </pre>
       *
       * <code>string permissions = 5;</code>
       *
       * @return The permissions.
       */
      @java.lang.Override
      public java.lang.String getPermissions() {
        java.lang.Object ref = permissions_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          permissions_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Consists of three octal digits which represent, in
       * order, the permissions of the owner, group, and other users for the
       * file (similarly to the numeric mode used in the linux chmod
       * utility). Each digit represents a three bit number with the 4 bit
       * corresponding to the read permissions, the 2 bit corresponds to the
       * write bit, and the one bit corresponds to the execute permission.
       * Default behavior is 755.
       *
       * Below are some examples of permissions and their associated values:
       * read, write, and execute: 7
       * read and execute: 5
       * read and write: 6
       * read only: 4
       * </pre>
       *
       * <code>string permissions = 5;</code>
       *
       * @return The bytes for permissions.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPermissionsBytes() {
        java.lang.Object ref = permissions_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          permissions_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (sourceCase_ == 1) {
          output.writeMessage(1, (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_);
        }
        if (sourceCase_ == 2) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, source_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, path_);
        }
        if (state_
            != com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState
                .DESIRED_STATE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(4, state_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(permissions_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, permissions_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (sourceCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1, (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_);
        }
        if (sourceCase_ == 2) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, source_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, path_);
        }
        if (state_
            != com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState
                .DESIRED_STATE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(permissions_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, permissions_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource)) {
          return super.equals(obj);
        }
        com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource other =
            (com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource) obj;

        if (!getPath().equals(other.getPath())) return false;
        if (state_ != other.state_) return false;
        if (!getPermissions().equals(other.getPermissions())) return false;
        if (!getSourceCase().equals(other.getSourceCase())) return false;
        switch (sourceCase_) {
          case 1:
            if (!getFile().equals(other.getFile())) return false;
            break;
          case 2:
            if (!getContent().equals(other.getContent())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
        hash = (37 * hash) + STATE_FIELD_NUMBER;
        hash = (53 * hash) + state_;
        hash = (37 * hash) + PERMISSIONS_FIELD_NUMBER;
        hash = (53 * hash) + getPermissions().hashCode();
        switch (sourceCase_) {
          case 1:
            hash = (37 * hash) + FILE_FIELD_NUMBER;
            hash = (53 * hash) + getFile().hashCode();
            break;
          case 2:
            hash = (37 * hash) + CONTENT_FIELD_NUMBER;
            hash = (53 * hash) + getContent().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A resource that manages the state of a file.
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource.FileResource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource.FileResource)
          com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_FileResource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_FileResource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.class,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.Builder.class);
        }

        // Construct using com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (fileBuilder_ != null) {
            fileBuilder_.clear();
          }
          path_ = "";
          state_ = 0;
          permissions_ = "";
          sourceCase_ = 0;
          source_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.osconfig.v1.OsPolicyProto
              .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_FileResource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource
            getDefaultInstanceForType() {
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource build() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource buildPartial() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource result =
              new com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.path_ = path_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.state_ = state_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.permissions_ = permissions_;
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource result) {
          result.sourceCase_ = sourceCase_;
          result.source_ = this.source_;
          if (sourceCase_ == 1 && fileBuilder_ != null) {
            result.source_ = fileBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource) {
            return mergeFrom((com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource other) {
          if (other
              == com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.getDefaultInstance())
            return this;
          if (!other.getPath().isEmpty()) {
            path_ = other.path_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (other.state_ != 0) {
            setStateValue(other.getStateValue());
          }
          if (!other.getPermissions().isEmpty()) {
            permissions_ = other.permissions_;
            bitField0_ |= 0x00000010;
            onChanged();
          }
          switch (other.getSourceCase()) {
            case FILE:
              {
                mergeFile(other.getFile());
                break;
              }
            case CONTENT:
              {
                sourceCase_ = 2;
                source_ = other.source_;
                onChanged();
                break;
              }
            case SOURCE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getFileFieldBuilder().getBuilder(), extensionRegistry);
                    sourceCase_ = 1;
                    break;
                  } // case 10
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    sourceCase_ = 2;
                    source_ = s;
                    break;
                  } // case 18
                case 26:
                  {
                    path_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 32:
                  {
                    state_ = input.readEnum();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                case 42:
                  {
                    permissions_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int sourceCase_ = 0;
        private java.lang.Object source_;

        public SourceCase getSourceCase() {
          return SourceCase.forNumber(sourceCase_);
        }

        public Builder clearSource() {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>
            fileBuilder_;
        /**
         *
         *
         * <pre>
         * A remote or local source.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         *
         * @return Whether the file field is set.
         */
        @java.lang.Override
        public boolean hasFile() {
          return sourceCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * A remote or local source.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         *
         * @return The file.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File getFile() {
          if (fileBuilder_ == null) {
            if (sourceCase_ == 1) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance();
          } else {
            if (sourceCase_ == 1) {
              return fileBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A remote or local source.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         */
        public Builder setFile(com.google.cloud.osconfig.v1.OSPolicy.Resource.File value) {
          if (fileBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            source_ = value;
            onChanged();
          } else {
            fileBuilder_.setMessage(value);
          }
          sourceCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A remote or local source.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         */
        public Builder setFile(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder builderForValue) {
          if (fileBuilder_ == null) {
            source_ = builderForValue.build();
            onChanged();
          } else {
            fileBuilder_.setMessage(builderForValue.build());
          }
          sourceCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A remote or local source.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         */
        public Builder mergeFile(com.google.cloud.osconfig.v1.OSPolicy.Resource.File value) {
          if (fileBuilder_ == null) {
            if (sourceCase_ == 1
                && source_
                    != com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance()) {
              source_ =
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.File.newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              source_ = value;
            }
            onChanged();
          } else {
            if (sourceCase_ == 1) {
              fileBuilder_.mergeFrom(value);
            } else {
              fileBuilder_.setMessage(value);
            }
          }
          sourceCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A remote or local source.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         */
        public Builder clearFile() {
          if (fileBuilder_ == null) {
            if (sourceCase_ == 1) {
              sourceCase_ = 0;
              source_ = null;
              onChanged();
            }
          } else {
            if (sourceCase_ == 1) {
              sourceCase_ = 0;
              source_ = null;
            }
            fileBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A remote or local source.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         */
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder getFileBuilder() {
          return getFileFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A remote or local source.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder getFileOrBuilder() {
          if ((sourceCase_ == 1) && (fileBuilder_ != null)) {
            return fileBuilder_.getMessageOrBuilder();
          } else {
            if (sourceCase_ == 1) {
              return (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_;
            }
            return com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A remote or local source.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.File file = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>
            getFileFieldBuilder() {
          if (fileBuilder_ == null) {
            if (!(sourceCase_ == 1)) {
              source_ = com.google.cloud.osconfig.v1.OSPolicy.Resource.File.getDefaultInstance();
            }
            fileBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.File,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.File.Builder,
                    com.google.cloud.osconfig.v1.OSPolicy.Resource.FileOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicy.Resource.File) source_,
                    getParentForChildren(),
                    isClean());
            source_ = null;
          }
          sourceCase_ = 1;
          onChanged();
          return fileBuilder_;
        }

        /**
         *
         *
         * <pre>
         * A a file with this content.
         * The size of the content is limited to 1024 characters.
         * </pre>
         *
         * <code>string content = 2;</code>
         *
         * @return Whether the content field is set.
         */
        @java.lang.Override
        public boolean hasContent() {
          return sourceCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * A a file with this content.
         * The size of the content is limited to 1024 characters.
         * </pre>
         *
         * <code>string content = 2;</code>
         *
         * @return The content.
         */
        @java.lang.Override
        public java.lang.String getContent() {
          java.lang.Object ref = "";
          if (sourceCase_ == 2) {
            ref = source_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (sourceCase_ == 2) {
              source_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A a file with this content.
         * The size of the content is limited to 1024 characters.
         * </pre>
         *
         * <code>string content = 2;</code>
         *
         * @return The bytes for content.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getContentBytes() {
          java.lang.Object ref = "";
          if (sourceCase_ == 2) {
            ref = source_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (sourceCase_ == 2) {
              source_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A a file with this content.
         * The size of the content is limited to 1024 characters.
         * </pre>
         *
         * <code>string content = 2;</code>
         *
         * @param value The content to set.
         * @return This builder for chaining.
         */
        public Builder setContent(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          sourceCase_ = 2;
          source_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A a file with this content.
         * The size of the content is limited to 1024 characters.
         * </pre>
         *
         * <code>string content = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearContent() {
          if (sourceCase_ == 2) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A a file with this content.
         * The size of the content is limited to 1024 characters.
         * </pre>
         *
         * <code>string content = 2;</code>
         *
         * @param value The bytes for content to set.
         * @return This builder for chaining.
         */
        public Builder setContentBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          sourceCase_ = 2;
          source_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object path_ = "";
        /**
         *
         *
         * <pre>
         * Required. The absolute path of the file within the VM.
         * </pre>
         *
         * <code>string path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The path.
         */
        public java.lang.String getPath() {
          java.lang.Object ref = path_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            path_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The absolute path of the file within the VM.
         * </pre>
         *
         * <code>string path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for path.
         */
        public com.google.protobuf.ByteString getPathBytes() {
          java.lang.Object ref = path_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            path_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The absolute path of the file within the VM.
         * </pre>
         *
         * <code>string path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The path to set.
         * @return This builder for chaining.
         */
        public Builder setPath(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          path_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The absolute path of the file within the VM.
         * </pre>
         *
         * <code>string path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPath() {
          path_ = getDefaultInstance().getPath();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The absolute path of the file within the VM.
         * </pre>
         *
         * <code>string path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for path to set.
         * @return This builder for chaining.
         */
        public Builder setPathBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          path_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private int state_ = 0;
        /**
         *
         *
         * <pre>
         * Required. Desired state of the file.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState state = 4 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for state.
         */
        @java.lang.Override
        public int getStateValue() {
          return state_;
        }
        /**
         *
         *
         * <pre>
         * Required. Desired state of the file.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState state = 4 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @param value The enum numeric value on the wire for state to set.
         * @return This builder for chaining.
         */
        public Builder setStateValue(int value) {
          state_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Desired state of the file.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState state = 4 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The state.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState getState() {
          com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState result =
              com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState.forNumber(
                  state_);
          return result == null
              ? com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState
                  .UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Required. Desired state of the file.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState state = 4 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @param value The state to set.
         * @return This builder for chaining.
         */
        public Builder setState(
            com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000008;
          state_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Desired state of the file.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.DesiredState state = 4 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearState() {
          bitField0_ = (bitField0_ & ~0x00000008);
          state_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object permissions_ = "";
        /**
         *
         *
         * <pre>
         * Consists of three octal digits which represent, in
         * order, the permissions of the owner, group, and other users for the
         * file (similarly to the numeric mode used in the linux chmod
         * utility). Each digit represents a three bit number with the 4 bit
         * corresponding to the read permissions, the 2 bit corresponds to the
         * write bit, and the one bit corresponds to the execute permission.
         * Default behavior is 755.
         *
         * Below are some examples of permissions and their associated values:
         * read, write, and execute: 7
         * read and execute: 5
         * read and write: 6
         * read only: 4
         * </pre>
         *
         * <code>string permissions = 5;</code>
         *
         * @return The permissions.
         */
        public java.lang.String getPermissions() {
          java.lang.Object ref = permissions_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            permissions_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Consists of three octal digits which represent, in
         * order, the permissions of the owner, group, and other users for the
         * file (similarly to the numeric mode used in the linux chmod
         * utility). Each digit represents a three bit number with the 4 bit
         * corresponding to the read permissions, the 2 bit corresponds to the
         * write bit, and the one bit corresponds to the execute permission.
         * Default behavior is 755.
         *
         * Below are some examples of permissions and their associated values:
         * read, write, and execute: 7
         * read and execute: 5
         * read and write: 6
         * read only: 4
         * </pre>
         *
         * <code>string permissions = 5;</code>
         *
         * @return The bytes for permissions.
         */
        public com.google.protobuf.ByteString getPermissionsBytes() {
          java.lang.Object ref = permissions_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            permissions_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Consists of three octal digits which represent, in
         * order, the permissions of the owner, group, and other users for the
         * file (similarly to the numeric mode used in the linux chmod
         * utility). Each digit represents a three bit number with the 4 bit
         * corresponding to the read permissions, the 2 bit corresponds to the
         * write bit, and the one bit corresponds to the execute permission.
         * Default behavior is 755.
         *
         * Below are some examples of permissions and their associated values:
         * read, write, and execute: 7
         * read and execute: 5
         * read and write: 6
         * read only: 4
         * </pre>
         *
         * <code>string permissions = 5;</code>
         *
         * @param value The permissions to set.
         * @return This builder for chaining.
         */
        public Builder setPermissions(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          permissions_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Consists of three octal digits which represent, in
         * order, the permissions of the owner, group, and other users for the
         * file (similarly to the numeric mode used in the linux chmod
         * utility). Each digit represents a three bit number with the 4 bit
         * corresponding to the read permissions, the 2 bit corresponds to the
         * write bit, and the one bit corresponds to the execute permission.
         * Default behavior is 755.
         *
         * Below are some examples of permissions and their associated values:
         * read, write, and execute: 7
         * read and execute: 5
         * read and write: 6
         * read only: 4
         * </pre>
         *
         * <code>string permissions = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPermissions() {
          permissions_ = getDefaultInstance().getPermissions();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Consists of three octal digits which represent, in
         * order, the permissions of the owner, group, and other users for the
         * file (similarly to the numeric mode used in the linux chmod
         * utility). Each digit represents a three bit number with the 4 bit
         * corresponding to the read permissions, the 2 bit corresponds to the
         * write bit, and the one bit corresponds to the execute permission.
         * Default behavior is 755.
         *
         * Below are some examples of permissions and their associated values:
         * read, write, and execute: 7
         * read and execute: 5
         * read and write: 6
         * read only: 4
         * </pre>
         *
         * <code>string permissions = 5;</code>
         *
         * @param value The bytes for permissions to set.
         * @return This builder for chaining.
         */
        public Builder setPermissionsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          permissions_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicy.Resource.FileResource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicy.Resource.FileResource)
      private static final com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource();
      }

      public static com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FileResource> PARSER =
          new com.google.protobuf.AbstractParser<FileResource>() {
            @java.lang.Override
            public FileResource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FileResource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FileResource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int resourceTypeCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object resourceType_;

    public enum ResourceTypeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      PKG(2),
      REPOSITORY(3),
      EXEC(4),
      FILE(5),
      RESOURCETYPE_NOT_SET(0);
      private final int value;

      private ResourceTypeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ResourceTypeCase valueOf(int value) {
        return forNumber(value);
      }

      public static ResourceTypeCase forNumber(int value) {
        switch (value) {
          case 2:
            return PKG;
          case 3:
            return REPOSITORY;
          case 4:
            return EXEC;
          case 5:
            return FILE;
          case 0:
            return RESOURCETYPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ResourceTypeCase getResourceTypeCase() {
      return ResourceTypeCase.forNumber(resourceTypeCase_);
    }

    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Required. The id of the resource with the following restrictions:
     *
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the OS policy.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The id of the resource with the following restrictions:
     *
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the OS policy.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PKG_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Package resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
     *
     * @return Whether the pkg field is set.
     */
    @java.lang.Override
    public boolean hasPkg() {
      return resourceTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Package resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
     *
     * @return The pkg.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource getPkg() {
      if (resourceTypeCase_ == 2) {
        return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource) resourceType_;
      }
      return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Package resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResourceOrBuilder
        getPkgOrBuilder() {
      if (resourceTypeCase_ == 2) {
        return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource) resourceType_;
      }
      return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.getDefaultInstance();
    }

    public static final int REPOSITORY_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Package repository resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
     *
     * @return Whether the repository field is set.
     */
    @java.lang.Override
    public boolean hasRepository() {
      return resourceTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Package repository resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
     *
     * @return The repository.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource getRepository() {
      if (resourceTypeCase_ == 3) {
        return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource) resourceType_;
      }
      return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Package repository resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResourceOrBuilder
        getRepositoryOrBuilder() {
      if (resourceTypeCase_ == 3) {
        return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource) resourceType_;
      }
      return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.getDefaultInstance();
    }

    public static final int EXEC_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Exec resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource exec = 4;</code>
     *
     * @return Whether the exec field is set.
     */
    @java.lang.Override
    public boolean hasExec() {
      return resourceTypeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Exec resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource exec = 4;</code>
     *
     * @return The exec.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource getExec() {
      if (resourceTypeCase_ == 4) {
        return (com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource) resourceType_;
      }
      return com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Exec resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource exec = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResourceOrBuilder getExecOrBuilder() {
      if (resourceTypeCase_ == 4) {
        return (com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource) resourceType_;
      }
      return com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.getDefaultInstance();
    }

    public static final int FILE_FIELD_NUMBER = 5;
    /**
     *
     *
     * <pre>
     * File resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource file = 5;</code>
     *
     * @return Whether the file field is set.
     */
    @java.lang.Override
    public boolean hasFile() {
      return resourceTypeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * File resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource file = 5;</code>
     *
     * @return The file.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource getFile() {
      if (resourceTypeCase_ == 5) {
        return (com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource) resourceType_;
      }
      return com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * File resource
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource file = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResourceOrBuilder getFileOrBuilder() {
      if (resourceTypeCase_ == 5) {
        return (com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource) resourceType_;
      }
      return com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (resourceTypeCase_ == 2) {
        output.writeMessage(
            2, (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource) resourceType_);
      }
      if (resourceTypeCase_ == 3) {
        output.writeMessage(
            3, (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource) resourceType_);
      }
      if (resourceTypeCase_ == 4) {
        output.writeMessage(
            4, (com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource) resourceType_);
      }
      if (resourceTypeCase_ == 5) {
        output.writeMessage(
            5, (com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource) resourceType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (resourceTypeCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource) resourceType_);
      }
      if (resourceTypeCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource) resourceType_);
      }
      if (resourceTypeCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, (com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource) resourceType_);
      }
      if (resourceTypeCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, (com.google.cloud.osconfig.v1.OSPolicy.Resource.FileResource) resourceType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.OSPolicy.Resource other =
          (com.google.cloud.osconfig.v1.OSPolicy.Resource) obj;

      if (!getId().equals(other.getId())) return false;
      if (!getResourceTypeCase().equals(other.getResourceTypeCase())) return false;
      switch (resourceTypeCase_) {
        case 2:
          if (!getPkg().equals(other.getPkg())) return false;
          break;
        case 3:
          if (!getRepository().equals(other.getRepository())) return false;
          break;
        case 4:
          if (!getExec().equals(other.getExec())) return false;
          break;
        case 5:
          if (!getFile().equals(other.getFile())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      switch (resourceTypeCase_) {
        case 2:
          hash = (37 * hash) + PKG_FIELD_NUMBER;
          hash = (53 * hash) + getPkg().hashCode();
          break;
        case 3:
          hash = (37 * hash) + REPOSITORY_FIELD_NUMBER;
          hash = (53 * hash) + getRepository().hashCode();
          break;
        case 4:
          hash = (37 * hash) + EXEC_FIELD_NUMBER;
          hash = (53 * hash) + getExec().hashCode();
          break;
        case 5:
          hash = (37 * hash) + FILE_FIELD_NUMBER;
          hash = (53 * hash) + getFile().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.Resource parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.Resource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.Resource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.Resource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.Resource parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.Resource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.Resource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.Resource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.Resource parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.Resource parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.Resource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.OSPolicy.Resource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.osconfig.v1.OSPolicy.Resource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An OS policy resource is used to define the desired state configuration
     * and provides a specific functionality like installing/removing packages,
     * executing a script etc.
     *
     * The system ensures that resources are always in their desired state by
     * taking necessary actions if they have drifted from their desired state.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.OSPolicy.Resource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicy.Resource)
        com.google.cloud.osconfig.v1.OSPolicy.ResourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.OSPolicy.Resource.class,
                com.google.cloud.osconfig.v1.OSPolicy.Resource.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.OSPolicy.Resource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        if (pkgBuilder_ != null) {
          pkgBuilder_.clear();
        }
        if (repositoryBuilder_ != null) {
          repositoryBuilder_.clear();
        }
        if (execBuilder_ != null) {
          execBuilder_.clear();
        }
        if (fileBuilder_ != null) {
          fileBuilder_.clear();
        }
        resourceTypeCase_ = 0;
        resourceType_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.OsPolicyProto
            .internal_static_google_cloud_osconfig_v1_OSPolicy_Resource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.OSPolicy.Resource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource build() {
        com.google.cloud.osconfig.v1.OSPolicy.Resource result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource buildPartial() {
        com.google.cloud.osconfig.v1.OSPolicy.Resource result =
            new com.google.cloud.osconfig.v1.OSPolicy.Resource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.osconfig.v1.OSPolicy.Resource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
      }

      private void buildPartialOneofs(com.google.cloud.osconfig.v1.OSPolicy.Resource result) {
        result.resourceTypeCase_ = resourceTypeCase_;
        result.resourceType_ = this.resourceType_;
        if (resourceTypeCase_ == 2 && pkgBuilder_ != null) {
          result.resourceType_ = pkgBuilder_.build();
        }
        if (resourceTypeCase_ == 3 && repositoryBuilder_ != null) {
          result.resourceType_ = repositoryBuilder_.build();
        }
        if (resourceTypeCase_ == 4 && execBuilder_ != null) {
          result.resourceType_ = execBuilder_.build();
        }
        if (resourceTypeCase_ == 5 && fileBuilder_ != null) {
          result.resourceType_ = fileBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.OSPolicy.Resource) {
          return mergeFrom((com.google.cloud.osconfig.v1.OSPolicy.Resource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.OSPolicy.Resource other) {
        if (other == com.google.cloud.osconfig.v1.OSPolicy.Resource.getDefaultInstance())
          return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        switch (other.getResourceTypeCase()) {
          case PKG:
            {
              mergePkg(other.getPkg());
              break;
            }
          case REPOSITORY:
            {
              mergeRepository(other.getRepository());
              break;
            }
          case EXEC:
            {
              mergeExec(other.getExec());
              break;
            }
          case FILE:
            {
              mergeFile(other.getFile());
              break;
            }
          case RESOURCETYPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getPkgFieldBuilder().getBuilder(), extensionRegistry);
                  resourceTypeCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getRepositoryFieldBuilder().getBuilder(), extensionRegistry);
                  resourceTypeCase_ = 3;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getExecFieldBuilder().getBuilder(), extensionRegistry);
                  resourceTypeCase_ = 4;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getFileFieldBuilder().getBuilder(), extensionRegistry);
                  resourceTypeCase_ = 5;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int resourceTypeCase_ = 0;
      private java.lang.Object resourceType_;

      public ResourceTypeCase getResourceTypeCase() {
        return ResourceTypeCase.forNumber(resourceTypeCase_);
      }

      public Builder clearResourceType() {
        resourceTypeCase_ = 0;
        resourceType_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * Required. The id of the resource with the following restrictions:
       *
       * * Must contain only lowercase letters, numbers, and hyphens.
       * * Must start with a letter.
       * * Must be between 1-63 characters.
       * * Must end with a number or a letter.
       * * Must be unique within the OS policy.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The id of the resource with the following restrictions:
       *
       * * Must contain only lowercase letters, numbers, and hyphens.
       * * Must start with a letter.
       * * Must be between 1-63 characters.
       * * Must end with a number or a letter.
       * * Must be unique within the OS policy.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The id of the resource with the following restrictions:
       *
       * * Must contain only lowercase letters, numbers, and hyphens.
       * * Must start with a letter.
       * * Must be between 1-63 characters.
       * * Must end with a number or a letter.
       * * Must be unique within the OS policy.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The id of the resource with the following restrictions:
       *
       * * Must contain only lowercase letters, numbers, and hyphens.
       * * Must start with a letter.
       * * Must be between 1-63 characters.
       * * Must end with a number or a letter.
       * * Must be unique within the OS policy.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The id of the resource with the following restrictions:
       *
       * * Must contain only lowercase letters, numbers, and hyphens.
       * * Must start with a letter.
       * * Must be between 1-63 characters.
       * * Must end with a number or a letter.
       * * Must be unique within the OS policy.
       * </pre>
       *
       * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource,
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Builder,
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResourceOrBuilder>
          pkgBuilder_;
      /**
       *
       *
       * <pre>
       * Package resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
       *
       * @return Whether the pkg field is set.
       */
      @java.lang.Override
      public boolean hasPkg() {
        return resourceTypeCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Package resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
       *
       * @return The pkg.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource getPkg() {
        if (pkgBuilder_ == null) {
          if (resourceTypeCase_ == 2) {
            return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource) resourceType_;
          }
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource
              .getDefaultInstance();
        } else {
          if (resourceTypeCase_ == 2) {
            return pkgBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Package resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
       */
      public Builder setPkg(com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource value) {
        if (pkgBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          resourceType_ = value;
          onChanged();
        } else {
          pkgBuilder_.setMessage(value);
        }
        resourceTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Package resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
       */
      public Builder setPkg(
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Builder builderForValue) {
        if (pkgBuilder_ == null) {
          resourceType_ = builderForValue.build();
          onChanged();
        } else {
          pkgBuilder_.setMessage(builderForValue.build());
        }
        resourceTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Package resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
       */
      public Builder mergePkg(
          com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource value) {
        if (pkgBuilder_ == null) {
          if (resourceTypeCase_ == 2
              && resourceType_
                  != com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource
                      .getDefaultInstance()) {
            resourceType_ =
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.newBuilder(
                        (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource)
                            resourceType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            resourceType_ = value;
          }
          onChanged();
        } else {
          if (resourceTypeCase_ == 2) {
            pkgBuilder_.mergeFrom(value);
          } else {
            pkgBuilder_.setMessage(value);
          }
        }
        resourceTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Package resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
       */
      public Builder clearPkg() {
        if (pkgBuilder_ == null) {
          if (resourceTypeCase_ == 2) {
            resourceTypeCase_ = 0;
            resourceType_ = null;
            onChanged();
          }
        } else {
          if (resourceTypeCase_ == 2) {
            resourceTypeCase_ = 0;
            resourceType_ = null;
          }
          pkgBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Package resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
       */
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Builder
          getPkgBuilder() {
        return getPkgFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Package resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResourceOrBuilder
          getPkgOrBuilder() {
        if ((resourceTypeCase_ == 2) && (pkgBuilder_ != null)) {
          return pkgBuilder_.getMessageOrBuilder();
        } else {
          if (resourceTypeCase_ == 2) {
            return (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource) resourceType_;
          }
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Package resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource pkg = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource,
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Builder,
              com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResourceOrBuilder>
          getPkgFieldBuilder() {
        if (pkgBuilder_ == null) {
          if (!(resourceTypeCase_ == 2)) {
            resourceType_ =
                com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.getDefaultInstance();
          }
          pkgBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource.Builder,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResourceOrBuilder>(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.PackageResource) resourceType_,
                  getParentForChildren(),
                  isClean());
          resourceType_ = null;
        }
        resourceTypeCase_ = 2;
        onChanged();
        return pkgBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource,
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.Builder,
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResourceOrBuilder>
          repositoryBuilder_;
      /**
       *
       *
       * <pre>
       * Package repository resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
       *
       * @return Whether the repository field is set.
       */
      @java.lang.Override
      public boolean hasRepository() {
        return resourceTypeCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Package repository resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
       *
       * @return The repository.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource getRepository() {
        if (repositoryBuilder_ == null) {
          if (resourceTypeCase_ == 3) {
            return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource)
                resourceType_;
          }
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
              .getDefaultInstance();
        } else {
          if (resourceTypeCase_ == 3) {
            return repositoryBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Package repository resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
       */
      public Builder setRepository(
          com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource value) {
        if (repositoryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          resourceType_ = value;
          onChanged();
        } else {
          repositoryBuilder_.setMessage(value);
        }
        resourceTypeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Package repository resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
       */
      public Builder setRepository(
          com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.Builder
              builderForValue) {
        if (repositoryBuilder_ == null) {
          resourceType_ = builderForValue.build();
          onChanged();
        } else {
          repositoryBuilder_.setMessage(builderForValue.build());
        }
        resourceTypeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Package repository resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
       */
      public Builder mergeRepository(
          com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource value) {
        if (repositoryBuilder_ == null) {
          if (resourceTypeCase_ == 3
              && resourceType_
                  != com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                      .getDefaultInstance()) {
            resourceType_ =
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.newBuilder(
                        (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource)
                            resourceType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            resourceType_ = value;
          }
          onChanged();
        } else {
          if (resourceTypeCase_ == 3) {
            repositoryBuilder_.mergeFrom(value);
          } else {
            repositoryBuilder_.setMessage(value);
          }
        }
        resourceTypeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Package repository resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
       */
      public Builder clearRepository() {
        if (repositoryBuilder_ == null) {
          if (resourceTypeCase_ == 3) {
            resourceTypeCase_ = 0;
            resourceType_ = null;
            onChanged();
          }
        } else {
          if (resourceTypeCase_ == 3) {
            resourceTypeCase_ = 0;
            resourceType_ = null;
          }
          repositoryBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Package repository resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
       */
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.Builder
          getRepositoryBuilder() {
        return getRepositoryFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Package repository resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResourceOrBuilder
          getRepositoryOrBuilder() {
        if ((resourceTypeCase_ == 3) && (repositoryBuilder_ != null)) {
          return repositoryBuilder_.getMessageOrBuilder();
        } else {
          if (resourceTypeCase_ == 3) {
            return (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource)
                resourceType_;
          }
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Package repository resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource repository = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource,
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.Builder,
              com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResourceOrBuilder>
          getRepositoryFieldBuilder() {
        if (repositoryBuilder_ == null) {
          if (!(resourceTypeCase_ == 3)) {
            resourceType_ =
                com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource
                    .getDefaultInstance();
          }
          repositoryBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource.Builder,
                  com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResourceOrBuilder>(
                  (com.google.cloud.osconfig.v1.OSPolicy.Resource.RepositoryResource) resourceType_,
                  getParentForChildren(),
                  isClean());
          resourceType_ = null;
        }
        resourceTypeCase_ = 3;
        onChanged();
        return repositoryBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource,
              com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.Builder,
              com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResourceOrBuilder>
          execBuilder_;
      /**
       *
       *
       * <pre>
       * Exec resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource exec = 4;</code>
       *
       * @return Whether the exec field is set.
       */
      @java.lang.Override
      public boolean hasExec() {
        return resourceTypeCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Exec resource
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource exec = 4;</code>
       *
       * @return The exec.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource getExec() {
        if (execBuilder_ == null) {
          if (resourceTypeCase_ == 4) {
            return (com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource) resourceType_;
          }
          return com.google.cloud.osconfig.v1.OSPolicy.Resource.ExecResource.getDefaultInstance();
        } else {
          if (resourceTypeCase_ == 4) {
            return ex