/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1/os_policy_assignment_reports.proto

package com.google.cloud.osconfig.v1;

/**
 *
 *
 * <pre>
 * A report of the OS policy assignment status for a given instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.osconfig.v1.OSPolicyAssignmentReport}
 */
public final class OSPolicyAssignmentReport extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicyAssignmentReport)
    OSPolicyAssignmentReportOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OSPolicyAssignmentReport.newBuilder() to construct.
  private OSPolicyAssignmentReport(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OSPolicyAssignmentReport() {
    name_ = "";
    instance_ = "";
    osPolicyAssignment_ = "";
    osPolicyCompliances_ = java.util.Collections.emptyList();
    lastRunId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OSPolicyAssignmentReport();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
        .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
        .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.class,
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.Builder.class);
  }

  public interface OSPolicyComplianceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The OS policy id
     * </pre>
     *
     * <code>string os_policy_id = 1;</code>
     *
     * @return The osPolicyId.
     */
    java.lang.String getOsPolicyId();
    /**
     *
     *
     * <pre>
     * The OS policy id
     * </pre>
     *
     * <code>string os_policy_id = 1;</code>
     *
     * @return The bytes for osPolicyId.
     */
    com.google.protobuf.ByteString getOsPolicyIdBytes();

    /**
     *
     *
     * <pre>
     * The compliance state of the OS policy.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState compliance_state = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for complianceState.
     */
    int getComplianceStateValue();
    /**
     *
     *
     * <pre>
     * The compliance state of the OS policy.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState compliance_state = 2;
     * </code>
     *
     * @return The complianceState.
     */
    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState
        getComplianceState();

    /**
     *
     *
     * <pre>
     * The reason for the OS policy to be in an unknown compliance state.
     * This field is always populated when `compliance_state` is `UNKNOWN`.
     *
     * If populated, the field can contain one of the following values:
     *
     * * `vm-not-running`: The VM was not running.
     * * `os-policies-not-supported-by-agent`: The version of the OS Config
     * agent running on the VM does not support running OS policies.
     * * `no-agent-detected`: The OS Config agent is not detected for the VM.
     * * `resource-execution-errors`: The OS Config agent encountered errors
     * while executing one or more resources in the policy. See
     * `os_policy_resource_compliances` for details.
     * * `task-timeout`: The task sent to the agent to apply the policy timed
     * out.
     * * `unexpected-agent-state`: The OS Config agent did not report the final
     * status of the task that attempted to apply the policy. Instead, the agent
     * unexpectedly started working on a different task. This mostly happens
     * when the agent or VM unexpectedly restarts while applying OS policies.
     * * `internal-service-errors`: Internal service errors were encountered
     * while attempting to apply the policy.
     * </pre>
     *
     * <code>string compliance_state_reason = 3;</code>
     *
     * @return The complianceStateReason.
     */
    java.lang.String getComplianceStateReason();
    /**
     *
     *
     * <pre>
     * The reason for the OS policy to be in an unknown compliance state.
     * This field is always populated when `compliance_state` is `UNKNOWN`.
     *
     * If populated, the field can contain one of the following values:
     *
     * * `vm-not-running`: The VM was not running.
     * * `os-policies-not-supported-by-agent`: The version of the OS Config
     * agent running on the VM does not support running OS policies.
     * * `no-agent-detected`: The OS Config agent is not detected for the VM.
     * * `resource-execution-errors`: The OS Config agent encountered errors
     * while executing one or more resources in the policy. See
     * `os_policy_resource_compliances` for details.
     * * `task-timeout`: The task sent to the agent to apply the policy timed
     * out.
     * * `unexpected-agent-state`: The OS Config agent did not report the final
     * status of the task that attempted to apply the policy. Instead, the agent
     * unexpectedly started working on a different task. This mostly happens
     * when the agent or VM unexpectedly restarts while applying OS policies.
     * * `internal-service-errors`: Internal service errors were encountered
     * while attempting to apply the policy.
     * </pre>
     *
     * <code>string compliance_state_reason = 3;</code>
     *
     * @return The bytes for complianceStateReason.
     */
    com.google.protobuf.ByteString getComplianceStateReasonBytes();

    /**
     *
     *
     * <pre>
     * Compliance data for each resource within the policy that is applied to
     * the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
     * </code>
     */
    java.util.List<
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance>
        getOsPolicyResourceCompliancesList();
    /**
     *
     *
     * <pre>
     * Compliance data for each resource within the policy that is applied to
     * the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
     * </code>
     */
    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
            .OSPolicyResourceCompliance
        getOsPolicyResourceCompliances(int index);
    /**
     *
     *
     * <pre>
     * Compliance data for each resource within the policy that is applied to
     * the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
     * </code>
     */
    int getOsPolicyResourceCompliancesCount();
    /**
     *
     *
     * <pre>
     * Compliance data for each resource within the policy that is applied to
     * the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceComplianceOrBuilder>
        getOsPolicyResourceCompliancesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Compliance data for each resource within the policy that is applied to
     * the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
     * </code>
     */
    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
            .OSPolicyResourceComplianceOrBuilder
        getOsPolicyResourceCompliancesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Compliance data for an OS policy
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance}
   */
  public static final class OSPolicyCompliance extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance)
      OSPolicyComplianceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OSPolicyCompliance.newBuilder() to construct.
    private OSPolicyCompliance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OSPolicyCompliance() {
      osPolicyId_ = "";
      complianceState_ = 0;
      complianceStateReason_ = "";
      osPolicyResourceCompliances_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OSPolicyCompliance();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
          .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
          .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.class,
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * Possible compliance states for an os policy.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState}
     */
    public enum ComplianceState implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The policy is in an unknown compliance state.
       *
       * Refer to the field `compliance_state_reason` to learn the exact reason
       * for the policy to be in this compliance state.
       * </pre>
       *
       * <code>UNKNOWN = 0;</code>
       */
      UNKNOWN(0),
      /**
       *
       *
       * <pre>
       * Policy is compliant.
       *
       * The policy is compliant if all the underlying resources are also
       * compliant.
       * </pre>
       *
       * <code>COMPLIANT = 1;</code>
       */
      COMPLIANT(1),
      /**
       *
       *
       * <pre>
       * Policy is non-compliant.
       *
       * The policy is non-compliant if one or more underlying resources are
       * non-compliant.
       * </pre>
       *
       * <code>NON_COMPLIANT = 2;</code>
       */
      NON_COMPLIANT(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * The policy is in an unknown compliance state.
       *
       * Refer to the field `compliance_state_reason` to learn the exact reason
       * for the policy to be in this compliance state.
       * </pre>
       *
       * <code>UNKNOWN = 0;</code>
       */
      public static final int UNKNOWN_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Policy is compliant.
       *
       * The policy is compliant if all the underlying resources are also
       * compliant.
       * </pre>
       *
       * <code>COMPLIANT = 1;</code>
       */
      public static final int COMPLIANT_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Policy is non-compliant.
       *
       * The policy is non-compliant if one or more underlying resources are
       * non-compliant.
       * </pre>
       *
       * <code>NON_COMPLIANT = 2;</code>
       */
      public static final int NON_COMPLIANT_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ComplianceState valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ComplianceState forNumber(int value) {
        switch (value) {
          case 0:
            return UNKNOWN;
          case 1:
            return COMPLIANT;
          case 2:
            return NON_COMPLIANT;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ComplianceState>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ComplianceState>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<ComplianceState>() {
                public ComplianceState findValueByNumber(int number) {
                  return ComplianceState.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ComplianceState[] VALUES = values();

      public static ComplianceState valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ComplianceState(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState)
    }

    public interface OSPolicyResourceComplianceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The ID of the OS policy resource.
       * </pre>
       *
       * <code>string os_policy_resource_id = 1;</code>
       *
       * @return The osPolicyResourceId.
       */
      java.lang.String getOsPolicyResourceId();
      /**
       *
       *
       * <pre>
       * The ID of the OS policy resource.
       * </pre>
       *
       * <code>string os_policy_resource_id = 1;</code>
       *
       * @return The bytes for osPolicyResourceId.
       */
      com.google.protobuf.ByteString getOsPolicyResourceIdBytes();

      /**
       *
       *
       * <pre>
       * Ordered list of configuration completed by the agent for the OS policy
       * resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
       * </code>
       */
      java.util.List<
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep>
          getConfigStepsList();
      /**
       *
       *
       * <pre>
       * Ordered list of configuration completed by the agent for the OS policy
       * resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
       * </code>
       */
      com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
          getConfigSteps(int index);
      /**
       *
       *
       * <pre>
       * Ordered list of configuration completed by the agent for the OS policy
       * resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
       * </code>
       */
      int getConfigStepsCount();
      /**
       *
       *
       * <pre>
       * Ordered list of configuration completed by the agent for the OS policy
       * resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.OSPolicyResourceConfigStepOrBuilder>
          getConfigStepsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Ordered list of configuration completed by the agent for the OS policy
       * resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
       * </code>
       */
      com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.OSPolicyResourceConfigStepOrBuilder
          getConfigStepsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * The compliance state of the resource.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ComplianceState compliance_state = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for complianceState.
       */
      int getComplianceStateValue();
      /**
       *
       *
       * <pre>
       * The compliance state of the resource.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ComplianceState compliance_state = 3;
       * </code>
       *
       * @return The complianceState.
       */
      com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.ComplianceState
          getComplianceState();

      /**
       *
       *
       * <pre>
       * A reason for the resource to be in the given compliance state.
       * This field is always populated when `compliance_state` is `UNKNOWN`.
       *
       * The following values are supported when `compliance_state == UNKNOWN`
       *
       * * `execution-errors`: Errors were encountered by the agent while
       * executing the resource and the compliance state couldn't be
       * determined.
       * * `execution-skipped-by-agent`: Resource execution was skipped by the
       * agent because errors were encountered while executing prior resources
       * in the OS policy.
       * * `os-policy-execution-attempt-failed`: The execution of the OS policy
       * containing this resource failed and the compliance state couldn't be
       * determined.
       * </pre>
       *
       * <code>string compliance_state_reason = 4;</code>
       *
       * @return The complianceStateReason.
       */
      java.lang.String getComplianceStateReason();
      /**
       *
       *
       * <pre>
       * A reason for the resource to be in the given compliance state.
       * This field is always populated when `compliance_state` is `UNKNOWN`.
       *
       * The following values are supported when `compliance_state == UNKNOWN`
       *
       * * `execution-errors`: Errors were encountered by the agent while
       * executing the resource and the compliance state couldn't be
       * determined.
       * * `execution-skipped-by-agent`: Resource execution was skipped by the
       * agent because errors were encountered while executing prior resources
       * in the OS policy.
       * * `os-policy-execution-attempt-failed`: The execution of the OS policy
       * containing this resource failed and the compliance state couldn't be
       * determined.
       * </pre>
       *
       * <code>string compliance_state_reason = 4;</code>
       *
       * @return The bytes for complianceStateReason.
       */
      com.google.protobuf.ByteString getComplianceStateReasonBytes();

      /**
       *
       *
       * <pre>
       * ExecResource specific output.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
       * </code>
       *
       * @return Whether the execResourceOutput field is set.
       */
      boolean hasExecResourceOutput();
      /**
       *
       *
       * <pre>
       * ExecResource specific output.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
       * </code>
       *
       * @return The execResourceOutput.
       */
      com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.ExecResourceOutput
          getExecResourceOutput();
      /**
       *
       *
       * <pre>
       * ExecResource specific output.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
       * </code>
       */
      com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.ExecResourceOutputOrBuilder
          getExecResourceOutputOrBuilder();

      com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.OutputCase
          getOutputCase();
    }
    /**
     *
     *
     * <pre>
     * Compliance data for an OS policy resource.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance}
     */
    public static final class OSPolicyResourceCompliance
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance)
        OSPolicyResourceComplianceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use OSPolicyResourceCompliance.newBuilder() to construct.
      private OSPolicyResourceCompliance(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private OSPolicyResourceCompliance() {
        osPolicyResourceId_ = "";
        configSteps_ = java.util.Collections.emptyList();
        complianceState_ = 0;
        complianceStateReason_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new OSPolicyResourceCompliance();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
            .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
            .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.class,
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Possible compliance states for a resource.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ComplianceState}
       */
      public enum ComplianceState implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * The resource is in an unknown compliance state.
         *
         * To get more details about why the policy is in this state, review
         * the output of the `compliance_state_reason` field.
         * </pre>
         *
         * <code>UNKNOWN = 0;</code>
         */
        UNKNOWN(0),
        /**
         *
         *
         * <pre>
         * Resource is compliant.
         * </pre>
         *
         * <code>COMPLIANT = 1;</code>
         */
        COMPLIANT(1),
        /**
         *
         *
         * <pre>
         * Resource is non-compliant.
         * </pre>
         *
         * <code>NON_COMPLIANT = 2;</code>
         */
        NON_COMPLIANT(2),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * The resource is in an unknown compliance state.
         *
         * To get more details about why the policy is in this state, review
         * the output of the `compliance_state_reason` field.
         * </pre>
         *
         * <code>UNKNOWN = 0;</code>
         */
        public static final int UNKNOWN_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Resource is compliant.
         * </pre>
         *
         * <code>COMPLIANT = 1;</code>
         */
        public static final int COMPLIANT_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Resource is non-compliant.
         * </pre>
         *
         * <code>NON_COMPLIANT = 2;</code>
         */
        public static final int NON_COMPLIANT_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ComplianceState valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static ComplianceState forNumber(int value) {
          switch (value) {
            case 0:
              return UNKNOWN;
            case 1:
              return COMPLIANT;
            case 2:
              return NON_COMPLIANT;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<ComplianceState>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<ComplianceState>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<ComplianceState>() {
                  public ComplianceState findValueByNumber(int number) {
                    return ComplianceState.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final ComplianceState[] VALUES = values();

        public static ComplianceState valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private ComplianceState(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ComplianceState)
      }

      public interface OSPolicyResourceConfigStepOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Configuration step type.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type type = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for type.
         */
        int getTypeValue();
        /**
         *
         *
         * <pre>
         * Configuration step type.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type type = 1;
         * </code>
         *
         * @return The type.
         */
        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type
            getType();

        /**
         *
         *
         * <pre>
         * An error message recorded during the execution of this step.
         * Only populated if errors were encountered during this step execution.
         * </pre>
         *
         * <code>string error_message = 2;</code>
         *
         * @return The errorMessage.
         */
        java.lang.String getErrorMessage();
        /**
         *
         *
         * <pre>
         * An error message recorded during the execution of this step.
         * Only populated if errors were encountered during this step execution.
         * </pre>
         *
         * <code>string error_message = 2;</code>
         *
         * @return The bytes for errorMessage.
         */
        com.google.protobuf.ByteString getErrorMessageBytes();
      }
      /**
       *
       *
       * <pre>
       * Step performed by the OS Config agent for configuring an
       * `OSPolicy` resource to its desired state.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep}
       */
      public static final class OSPolicyResourceConfigStep
          extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep)
          OSPolicyResourceConfigStepOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use OSPolicyResourceConfigStep.newBuilder() to construct.
        private OSPolicyResourceConfigStep(
            com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private OSPolicyResourceConfigStep() {
          type_ = 0;
          errorMessage_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new OSPolicyResourceConfigStep();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
              .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
              .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.class,
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Builder.class);
        }

        /**
         *
         *
         * <pre>
         * Supported configuration step types
         * </pre>
         *
         * Protobuf enum {@code
         * google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type}
         */
        public enum Type implements com.google.protobuf.ProtocolMessageEnum {
          /**
           *
           *
           * <pre>
           * Default value. This value is unused.
           * </pre>
           *
           * <code>TYPE_UNSPECIFIED = 0;</code>
           */
          TYPE_UNSPECIFIED(0),
          /**
           *
           *
           * <pre>
           * Checks for resource conflicts such as schema errors.
           * </pre>
           *
           * <code>VALIDATION = 1;</code>
           */
          VALIDATION(1),
          /**
           *
           *
           * <pre>
           * Checks the current status of the desired state for a resource.
           * </pre>
           *
           * <code>DESIRED_STATE_CHECK = 2;</code>
           */
          DESIRED_STATE_CHECK(2),
          /**
           *
           *
           * <pre>
           * Enforces the desired state for a resource that is not in desired
           * state.
           * </pre>
           *
           * <code>DESIRED_STATE_ENFORCEMENT = 3;</code>
           */
          DESIRED_STATE_ENFORCEMENT(3),
          /**
           *
           *
           * <pre>
           * Re-checks the status of the desired state. This check is done
           * for a resource after the enforcement of all OS policies.
           *
           * This step is used to determine the final desired state status for
           * the resource. It accounts for any resources that might have drifted
           * from their desired state due to side effects from executing other
           * resources.
           * </pre>
           *
           * <code>DESIRED_STATE_CHECK_POST_ENFORCEMENT = 4;</code>
           */
          DESIRED_STATE_CHECK_POST_ENFORCEMENT(4),
          UNRECOGNIZED(-1),
          ;

          /**
           *
           *
           * <pre>
           * Default value. This value is unused.
           * </pre>
           *
           * <code>TYPE_UNSPECIFIED = 0;</code>
           */
          public static final int TYPE_UNSPECIFIED_VALUE = 0;
          /**
           *
           *
           * <pre>
           * Checks for resource conflicts such as schema errors.
           * </pre>
           *
           * <code>VALIDATION = 1;</code>
           */
          public static final int VALIDATION_VALUE = 1;
          /**
           *
           *
           * <pre>
           * Checks the current status of the desired state for a resource.
           * </pre>
           *
           * <code>DESIRED_STATE_CHECK = 2;</code>
           */
          public static final int DESIRED_STATE_CHECK_VALUE = 2;
          /**
           *
           *
           * <pre>
           * Enforces the desired state for a resource that is not in desired
           * state.
           * </pre>
           *
           * <code>DESIRED_STATE_ENFORCEMENT = 3;</code>
           */
          public static final int DESIRED_STATE_ENFORCEMENT_VALUE = 3;
          /**
           *
           *
           * <pre>
           * Re-checks the status of the desired state. This check is done
           * for a resource after the enforcement of all OS policies.
           *
           * This step is used to determine the final desired state status for
           * the resource. It accounts for any resources that might have drifted
           * from their desired state due to side effects from executing other
           * resources.
           * </pre>
           *
           * <code>DESIRED_STATE_CHECK_POST_ENFORCEMENT = 4;</code>
           */
          public static final int DESIRED_STATE_CHECK_POST_ENFORCEMENT_VALUE = 4;

          public final int getNumber() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalArgumentException(
                  "Can't get the number of an unknown enum value.");
            }
            return value;
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static Type valueOf(int value) {
            return forNumber(value);
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           */
          public static Type forNumber(int value) {
            switch (value) {
              case 0:
                return TYPE_UNSPECIFIED;
              case 1:
                return VALIDATION;
              case 2:
                return DESIRED_STATE_CHECK;
              case 3:
                return DESIRED_STATE_ENFORCEMENT;
              case 4:
                return DESIRED_STATE_CHECK_POST_ENFORCEMENT;
              default:
                return null;
            }
          }

          public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
            return internalValueMap;
          }

          private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<Type>() {
                public Type findValueByNumber(int number) {
                  return Type.forNumber(number);
                }
              };

          public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalStateException(
                  "Can't get the descriptor of an unrecognized enum value.");
            }
            return getDescriptor().getValues().get(ordinal());
          }

          public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
            return getDescriptor();
          }

          public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.getDescriptor()
                .getEnumTypes()
                .get(0);
          }

          private static final Type[] VALUES = values();

          public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
              throw new java.lang.IllegalArgumentException(
                  "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
              return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
          }

          private final int value;

          private Type(int value) {
            this.value = value;
          }

          // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type)
        }

        public static final int TYPE_FIELD_NUMBER = 1;
        private int type_ = 0;
        /**
         *
         *
         * <pre>
         * Configuration step type.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type type = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for type.
         */
        @java.lang.Override
        public int getTypeValue() {
          return type_;
        }
        /**
         *
         *
         * <pre>
         * Configuration step type.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type type = 1;
         * </code>
         *
         * @return The type.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type
            getType() {
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type
              result =
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type.forNumber(type_);
          return result == null
              ? com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type.UNRECOGNIZED
              : result;
        }

        public static final int ERROR_MESSAGE_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object errorMessage_ = "";
        /**
         *
         *
         * <pre>
         * An error message recorded during the execution of this step.
         * Only populated if errors were encountered during this step execution.
         * </pre>
         *
         * <code>string error_message = 2;</code>
         *
         * @return The errorMessage.
         */
        @java.lang.Override
        public java.lang.String getErrorMessage() {
          java.lang.Object ref = errorMessage_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            errorMessage_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * An error message recorded during the execution of this step.
         * Only populated if errors were encountered during this step execution.
         * </pre>
         *
         * <code>string error_message = 2;</code>
         *
         * @return The bytes for errorMessage.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getErrorMessageBytes() {
          java.lang.Object ref = errorMessage_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            errorMessage_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (type_
              != com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type.TYPE_UNSPECIFIED
                  .getNumber()) {
            output.writeEnum(1, type_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, errorMessage_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (type_
              != com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type.TYPE_UNSPECIFIED
                  .getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, errorMessage_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
              other =
                  (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                          .OSPolicyResourceCompliance.OSPolicyResourceConfigStep)
                      obj;

          if (type_ != other.type_) return false;
          if (!getErrorMessage().equals(other.getErrorMessage())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + TYPE_FIELD_NUMBER;
          hash = (53 * hash) + type_;
          hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
          hash = (53 * hash) + getErrorMessage().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Step performed by the OS Config agent for configuring an
         * `OSPolicy` resource to its desired state.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep)
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStepOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
                .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
                .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.class,
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Builder.class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            type_ = 0;
            errorMessage_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
                .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
              build() {
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
              buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
                result =
                    new com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.OSPolicyResourceConfigStep(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.type_ = type_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.errorMessage_ = errorMessage_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                          .OSPolicyResourceCompliance.OSPolicyResourceConfigStep)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
                  other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.getDefaultInstance())
              return this;
            if (other.type_ != 0) {
              setTypeValue(other.getTypeValue());
            }
            if (!other.getErrorMessage().isEmpty()) {
              errorMessage_ = other.errorMessage_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      type_ = input.readEnum();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  case 18:
                    {
                      errorMessage_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int type_ = 0;
          /**
           *
           *
           * <pre>
           * Configuration step type.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type type = 1;
           * </code>
           *
           * @return The enum numeric value on the wire for type.
           */
          @java.lang.Override
          public int getTypeValue() {
            return type_;
          }
          /**
           *
           *
           * <pre>
           * Configuration step type.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type type = 1;
           * </code>
           *
           * @param value The enum numeric value on the wire for type to set.
           * @return This builder for chaining.
           */
          public Builder setTypeValue(int value) {
            type_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Configuration step type.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type type = 1;
           * </code>
           *
           * @return The type.
           */
          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type
              getType() {
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type
                result =
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type.forNumber(
                        type_);
            return result == null
                ? com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type.UNRECOGNIZED
                : result;
          }
          /**
           *
           *
           * <pre>
           * Configuration step type.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type type = 1;
           * </code>
           *
           * @param value The type to set.
           * @return This builder for chaining.
           */
          public Builder setType(
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type
                  value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000001;
            type_ = value.getNumber();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Configuration step type.
           * </pre>
           *
           * <code>
           * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type type = 1;
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearType() {
            bitField0_ = (bitField0_ & ~0x00000001);
            type_ = 0;
            onChanged();
            return this;
          }

          private java.lang.Object errorMessage_ = "";
          /**
           *
           *
           * <pre>
           * An error message recorded during the execution of this step.
           * Only populated if errors were encountered during this step execution.
           * </pre>
           *
           * <code>string error_message = 2;</code>
           *
           * @return The errorMessage.
           */
          public java.lang.String getErrorMessage() {
            java.lang.Object ref = errorMessage_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              errorMessage_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * An error message recorded during the execution of this step.
           * Only populated if errors were encountered during this step execution.
           * </pre>
           *
           * <code>string error_message = 2;</code>
           *
           * @return The bytes for errorMessage.
           */
          public com.google.protobuf.ByteString getErrorMessageBytes() {
            java.lang.Object ref = errorMessage_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              errorMessage_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * An error message recorded during the execution of this step.
           * Only populated if errors were encountered during this step execution.
           * </pre>
           *
           * <code>string error_message = 2;</code>
           *
           * @param value The errorMessage to set.
           * @return This builder for chaining.
           */
          public Builder setErrorMessage(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            errorMessage_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * An error message recorded during the execution of this step.
           * Only populated if errors were encountered during this step execution.
           * </pre>
           *
           * <code>string error_message = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearErrorMessage() {
            errorMessage_ = getDefaultInstance().getErrorMessage();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * An error message recorded during the execution of this step.
           * Only populated if errors were encountered during this step execution.
           * </pre>
           *
           * <code>string error_message = 2;</code>
           *
           * @param value The bytes for errorMessage to set.
           * @return This builder for chaining.
           */
          public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            errorMessage_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep)
        private static final com.google.cloud.osconfig.v1.OSPolicyAssignmentReport
                .OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep();
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<OSPolicyResourceConfigStep> PARSER =
            new com.google.protobuf.AbstractParser<OSPolicyResourceConfigStep>() {
              @java.lang.Override
              public OSPolicyResourceConfigStep parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<OSPolicyResourceConfigStep> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<OSPolicyResourceConfigStep> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface ExecResourceOutputOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Output from enforcement phase output file (if run).
         * Output size is limited to 100K bytes.
         * </pre>
         *
         * <code>bytes enforcement_output = 2;</code>
         *
         * @return The enforcementOutput.
         */
        com.google.protobuf.ByteString getEnforcementOutput();
      }
      /**
       *
       *
       * <pre>
       * ExecResource specific output.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput}
       */
      public static final class ExecResourceOutput extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput)
          ExecResourceOutputOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use ExecResourceOutput.newBuilder() to construct.
        private ExecResourceOutput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private ExecResourceOutput() {
          enforcementOutput_ = com.google.protobuf.ByteString.EMPTY;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new ExecResourceOutput();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
              .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
              .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.ExecResourceOutput.class,
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.ExecResourceOutput.Builder.class);
        }

        public static final int ENFORCEMENT_OUTPUT_FIELD_NUMBER = 2;
        private com.google.protobuf.ByteString enforcementOutput_ =
            com.google.protobuf.ByteString.EMPTY;
        /**
         *
         *
         * <pre>
         * Output from enforcement phase output file (if run).
         * Output size is limited to 100K bytes.
         * </pre>
         *
         * <code>bytes enforcement_output = 2;</code>
         *
         * @return The enforcementOutput.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getEnforcementOutput() {
          return enforcementOutput_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!enforcementOutput_.isEmpty()) {
            output.writeBytes(2, enforcementOutput_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!enforcementOutput_.isEmpty()) {
            size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, enforcementOutput_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.ExecResourceOutput)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.ExecResourceOutput
              other =
                  (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                          .OSPolicyResourceCompliance.ExecResourceOutput)
                      obj;

          if (!getEnforcementOutput().equals(other.getEnforcementOutput())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + ENFORCEMENT_OUTPUT_FIELD_NUMBER;
          hash = (53 * hash) + getEnforcementOutput().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutput
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * ExecResource specific output.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput)
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutputOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
                .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
                .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.ExecResourceOutput.class,
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.ExecResourceOutput.Builder.class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            enforcementOutput_ = com.google.protobuf.ByteString.EMPTY;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
                .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.ExecResourceOutput
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.ExecResourceOutput
              build() {
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutput
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.ExecResourceOutput
              buildPartial() {
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutput
                result =
                    new com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.ExecResourceOutput(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.ExecResourceOutput
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.enforcementOutput_ = enforcementOutput_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutput) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                          .OSPolicyResourceCompliance.ExecResourceOutput)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.ExecResourceOutput
                  other) {
            if (other
                == com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutput.getDefaultInstance())
              return this;
            if (other.getEnforcementOutput() != com.google.protobuf.ByteString.EMPTY) {
              setEnforcementOutput(other.getEnforcementOutput());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 18:
                    {
                      enforcementOutput_ = input.readBytes();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.ByteString enforcementOutput_ =
              com.google.protobuf.ByteString.EMPTY;
          /**
           *
           *
           * <pre>
           * Output from enforcement phase output file (if run).
           * Output size is limited to 100K bytes.
           * </pre>
           *
           * <code>bytes enforcement_output = 2;</code>
           *
           * @return The enforcementOutput.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getEnforcementOutput() {
            return enforcementOutput_;
          }
          /**
           *
           *
           * <pre>
           * Output from enforcement phase output file (if run).
           * Output size is limited to 100K bytes.
           * </pre>
           *
           * <code>bytes enforcement_output = 2;</code>
           *
           * @param value The enforcementOutput to set.
           * @return This builder for chaining.
           */
          public Builder setEnforcementOutput(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            enforcementOutput_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Output from enforcement phase output file (if run).
           * Output size is limited to 100K bytes.
           * </pre>
           *
           * <code>bytes enforcement_output = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearEnforcementOutput() {
            bitField0_ = (bitField0_ & ~0x00000001);
            enforcementOutput_ = getDefaultInstance().getEnforcementOutput();
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput)
        private static final com.google.cloud.osconfig.v1.OSPolicyAssignmentReport
                .OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.ExecResourceOutput();
        }

        public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<ExecResourceOutput> PARSER =
            new com.google.protobuf.AbstractParser<ExecResourceOutput>() {
              @java.lang.Override
              public ExecResourceOutput parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<ExecResourceOutput> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<ExecResourceOutput> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int outputCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object output_;

      public enum OutputCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        EXEC_RESOURCE_OUTPUT(5),
        OUTPUT_NOT_SET(0);
        private final int value;

        private OutputCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static OutputCase valueOf(int value) {
          return forNumber(value);
        }

        public static OutputCase forNumber(int value) {
          switch (value) {
            case 5:
              return EXEC_RESOURCE_OUTPUT;
            case 0:
              return OUTPUT_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public OutputCase getOutputCase() {
        return OutputCase.forNumber(outputCase_);
      }

      public static final int OS_POLICY_RESOURCE_ID_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object osPolicyResourceId_ = "";
      /**
       *
       *
       * <pre>
       * The ID of the OS policy resource.
       * </pre>
       *
       * <code>string os_policy_resource_id = 1;</code>
       *
       * @return The osPolicyResourceId.
       */
      @java.lang.Override
      public java.lang.String getOsPolicyResourceId() {
        java.lang.Object ref = osPolicyResourceId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          osPolicyResourceId_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the OS policy resource.
       * </pre>
       *
       * <code>string os_policy_resource_id = 1;</code>
       *
       * @return The bytes for osPolicyResourceId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getOsPolicyResourceIdBytes() {
        java.lang.Object ref = osPolicyResourceId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          osPolicyResourceId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CONFIG_STEPS_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep>
          configSteps_;
      /**
       *
       *
       * <pre>
       * Ordered list of configuration completed by the agent for the OS policy
       * resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.OSPolicyResourceConfigStep>
          getConfigStepsList() {
        return configSteps_;
      }
      /**
       *
       *
       * <pre>
       * Ordered list of configuration completed by the agent for the OS policy
       * resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.OSPolicyResourceConfigStepOrBuilder>
          getConfigStepsOrBuilderList() {
        return configSteps_;
      }
      /**
       *
       *
       * <pre>
       * Ordered list of configuration completed by the agent for the OS policy
       * resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
       * </code>
       */
      @java.lang.Override
      public int getConfigStepsCount() {
        return configSteps_.size();
      }
      /**
       *
       *
       * <pre>
       * Ordered list of configuration completed by the agent for the OS policy
       * resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
          getConfigSteps(int index) {
        return configSteps_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Ordered list of configuration completed by the agent for the OS policy
       * resource.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.OSPolicyResourceConfigStepOrBuilder
          getConfigStepsOrBuilder(int index) {
        return configSteps_.get(index);
      }

      public static final int COMPLIANCE_STATE_FIELD_NUMBER = 3;
      private int complianceState_ = 0;
      /**
       *
       *
       * <pre>
       * The compliance state of the resource.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ComplianceState compliance_state = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for complianceState.
       */
      @java.lang.Override
      public int getComplianceStateValue() {
        return complianceState_;
      }
      /**
       *
       *
       * <pre>
       * The compliance state of the resource.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ComplianceState compliance_state = 3;
       * </code>
       *
       * @return The complianceState.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.ComplianceState
          getComplianceState() {
        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ComplianceState
            result =
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ComplianceState.forNumber(complianceState_);
        return result == null
            ? com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ComplianceState.UNRECOGNIZED
            : result;
      }

      public static final int COMPLIANCE_STATE_REASON_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object complianceStateReason_ = "";
      /**
       *
       *
       * <pre>
       * A reason for the resource to be in the given compliance state.
       * This field is always populated when `compliance_state` is `UNKNOWN`.
       *
       * The following values are supported when `compliance_state == UNKNOWN`
       *
       * * `execution-errors`: Errors were encountered by the agent while
       * executing the resource and the compliance state couldn't be
       * determined.
       * * `execution-skipped-by-agent`: Resource execution was skipped by the
       * agent because errors were encountered while executing prior resources
       * in the OS policy.
       * * `os-policy-execution-attempt-failed`: The execution of the OS policy
       * containing this resource failed and the compliance state couldn't be
       * determined.
       * </pre>
       *
       * <code>string compliance_state_reason = 4;</code>
       *
       * @return The complianceStateReason.
       */
      @java.lang.Override
      public java.lang.String getComplianceStateReason() {
        java.lang.Object ref = complianceStateReason_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          complianceStateReason_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * A reason for the resource to be in the given compliance state.
       * This field is always populated when `compliance_state` is `UNKNOWN`.
       *
       * The following values are supported when `compliance_state == UNKNOWN`
       *
       * * `execution-errors`: Errors were encountered by the agent while
       * executing the resource and the compliance state couldn't be
       * determined.
       * * `execution-skipped-by-agent`: Resource execution was skipped by the
       * agent because errors were encountered while executing prior resources
       * in the OS policy.
       * * `os-policy-execution-attempt-failed`: The execution of the OS policy
       * containing this resource failed and the compliance state couldn't be
       * determined.
       * </pre>
       *
       * <code>string compliance_state_reason = 4;</code>
       *
       * @return The bytes for complianceStateReason.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getComplianceStateReasonBytes() {
        java.lang.Object ref = complianceStateReason_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          complianceStateReason_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int EXEC_RESOURCE_OUTPUT_FIELD_NUMBER = 5;
      /**
       *
       *
       * <pre>
       * ExecResource specific output.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
       * </code>
       *
       * @return Whether the execResourceOutput field is set.
       */
      @java.lang.Override
      public boolean hasExecResourceOutput() {
        return outputCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * ExecResource specific output.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
       * </code>
       *
       * @return The execResourceOutput.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.ExecResourceOutput
          getExecResourceOutput() {
        if (outputCase_ == 5) {
          return (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.ExecResourceOutput)
              output_;
        }
        return com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
            .OSPolicyResourceCompliance.ExecResourceOutput.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * ExecResource specific output.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.ExecResourceOutputOrBuilder
          getExecResourceOutputOrBuilder() {
        if (outputCase_ == 5) {
          return (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.ExecResourceOutput)
              output_;
        }
        return com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
            .OSPolicyResourceCompliance.ExecResourceOutput.getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyResourceId_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, osPolicyResourceId_);
        }
        for (int i = 0; i < configSteps_.size(); i++) {
          output.writeMessage(2, configSteps_.get(i));
        }
        if (complianceState_
            != com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ComplianceState.UNKNOWN
                .getNumber()) {
          output.writeEnum(3, complianceState_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(complianceStateReason_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, complianceStateReason_);
        }
        if (outputCase_ == 5) {
          output.writeMessage(
              5,
              (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.ExecResourceOutput)
                  output_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyResourceId_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, osPolicyResourceId_);
        }
        for (int i = 0; i < configSteps_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, configSteps_.get(i));
        }
        if (complianceState_
            != com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ComplianceState.UNKNOWN
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, complianceState_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(complianceStateReason_)) {
          size +=
              com.google.protobuf.GeneratedMessageV3.computeStringSize(4, complianceStateReason_);
        }
        if (outputCase_ == 5) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  5,
                  (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                          .OSPolicyResourceCompliance.ExecResourceOutput)
                      output_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance)) {
          return super.equals(obj);
        }
        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance
            other =
                (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance)
                    obj;

        if (!getOsPolicyResourceId().equals(other.getOsPolicyResourceId())) return false;
        if (!getConfigStepsList().equals(other.getConfigStepsList())) return false;
        if (complianceState_ != other.complianceState_) return false;
        if (!getComplianceStateReason().equals(other.getComplianceStateReason())) return false;
        if (!getOutputCase().equals(other.getOutputCase())) return false;
        switch (outputCase_) {
          case 5:
            if (!getExecResourceOutput().equals(other.getExecResourceOutput())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + OS_POLICY_RESOURCE_ID_FIELD_NUMBER;
        hash = (53 * hash) + getOsPolicyResourceId().hashCode();
        if (getConfigStepsCount() > 0) {
          hash = (37 * hash) + CONFIG_STEPS_FIELD_NUMBER;
          hash = (53 * hash) + getConfigStepsList().hashCode();
        }
        hash = (37 * hash) + COMPLIANCE_STATE_FIELD_NUMBER;
        hash = (53 * hash) + complianceState_;
        hash = (37 * hash) + COMPLIANCE_STATE_REASON_FIELD_NUMBER;
        hash = (53 * hash) + getComplianceStateReason().hashCode();
        switch (outputCase_) {
          case 5:
            hash = (37 * hash) + EXEC_RESOURCE_OUTPUT_FIELD_NUMBER;
            hash = (53 * hash) + getExecResourceOutput().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for an OS policy resource.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance)
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceComplianceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
              .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
              .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.class,
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.Builder.class);
        }

        // Construct using
        // com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          osPolicyResourceId_ = "";
          if (configStepsBuilder_ == null) {
            configSteps_ = java.util.Collections.emptyList();
          } else {
            configSteps_ = null;
            configStepsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          complianceState_ = 0;
          complianceStateReason_ = "";
          if (execResourceOutputBuilder_ != null) {
            execResourceOutputBuilder_.clear();
          }
          outputCase_ = 0;
          output_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
              .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance
            getDefaultInstanceForType() {
          return com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance
            build() {
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance
            buildPartial() {
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance
              result =
                  new com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance
                result) {
          if (configStepsBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              configSteps_ = java.util.Collections.unmodifiableList(configSteps_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.configSteps_ = configSteps_;
          } else {
            result.configSteps_ = configStepsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.osPolicyResourceId_ = osPolicyResourceId_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.complianceState_ = complianceState_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.complianceStateReason_ = complianceStateReason_;
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance
                result) {
          result.outputCase_ = outputCase_;
          result.output_ = this.output_;
          if (outputCase_ == 5 && execResourceOutputBuilder_ != null) {
            result.output_ = execResourceOutputBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance) {
            return mergeFrom(
                (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance
                other) {
          if (other
              == com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.getDefaultInstance()) return this;
          if (!other.getOsPolicyResourceId().isEmpty()) {
            osPolicyResourceId_ = other.osPolicyResourceId_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (configStepsBuilder_ == null) {
            if (!other.configSteps_.isEmpty()) {
              if (configSteps_.isEmpty()) {
                configSteps_ = other.configSteps_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureConfigStepsIsMutable();
                configSteps_.addAll(other.configSteps_);
              }
              onChanged();
            }
          } else {
            if (!other.configSteps_.isEmpty()) {
              if (configStepsBuilder_.isEmpty()) {
                configStepsBuilder_.dispose();
                configStepsBuilder_ = null;
                configSteps_ = other.configSteps_;
                bitField0_ = (bitField0_ & ~0x00000002);
                configStepsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getConfigStepsFieldBuilder()
                        : null;
              } else {
                configStepsBuilder_.addAllMessages(other.configSteps_);
              }
            }
          }
          if (other.complianceState_ != 0) {
            setComplianceStateValue(other.getComplianceStateValue());
          }
          if (!other.getComplianceStateReason().isEmpty()) {
            complianceStateReason_ = other.complianceStateReason_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          switch (other.getOutputCase()) {
            case EXEC_RESOURCE_OUTPUT:
              {
                mergeExecResourceOutput(other.getExecResourceOutput());
                break;
              }
            case OUTPUT_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    osPolicyResourceId_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                            .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
                        m =
                            input.readMessage(
                                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport
                                    .OSPolicyCompliance.OSPolicyResourceCompliance
                                    .OSPolicyResourceConfigStep.parser(),
                                extensionRegistry);
                    if (configStepsBuilder_ == null) {
                      ensureConfigStepsIsMutable();
                      configSteps_.add(m);
                    } else {
                      configStepsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                case 24:
                  {
                    complianceState_ = input.readEnum();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 34:
                  {
                    complianceStateReason_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                case 42:
                  {
                    input.readMessage(
                        getExecResourceOutputFieldBuilder().getBuilder(), extensionRegistry);
                    outputCase_ = 5;
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int outputCase_ = 0;
        private java.lang.Object output_;

        public OutputCase getOutputCase() {
          return OutputCase.forNumber(outputCase_);
        }

        public Builder clearOutput() {
          outputCase_ = 0;
          output_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private java.lang.Object osPolicyResourceId_ = "";
        /**
         *
         *
         * <pre>
         * The ID of the OS policy resource.
         * </pre>
         *
         * <code>string os_policy_resource_id = 1;</code>
         *
         * @return The osPolicyResourceId.
         */
        public java.lang.String getOsPolicyResourceId() {
          java.lang.Object ref = osPolicyResourceId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            osPolicyResourceId_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The ID of the OS policy resource.
         * </pre>
         *
         * <code>string os_policy_resource_id = 1;</code>
         *
         * @return The bytes for osPolicyResourceId.
         */
        public com.google.protobuf.ByteString getOsPolicyResourceIdBytes() {
          java.lang.Object ref = osPolicyResourceId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            osPolicyResourceId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The ID of the OS policy resource.
         * </pre>
         *
         * <code>string os_policy_resource_id = 1;</code>
         *
         * @param value The osPolicyResourceId to set.
         * @return This builder for chaining.
         */
        public Builder setOsPolicyResourceId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          osPolicyResourceId_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The ID of the OS policy resource.
         * </pre>
         *
         * <code>string os_policy_resource_id = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOsPolicyResourceId() {
          osPolicyResourceId_ = getDefaultInstance().getOsPolicyResourceId();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The ID of the OS policy resource.
         * </pre>
         *
         * <code>string os_policy_resource_id = 1;</code>
         *
         * @param value The bytes for osPolicyResourceId to set.
         * @return This builder for chaining.
         */
        public Builder setOsPolicyResourceIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          osPolicyResourceId_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep>
            configSteps_ = java.util.Collections.emptyList();

        private void ensureConfigStepsIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            configSteps_ =
                new java.util.ArrayList<
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.OSPolicyResourceConfigStep>(configSteps_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep,
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Builder,
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStepOrBuilder>
            configStepsBuilder_;

        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep>
            getConfigStepsList() {
          if (configStepsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(configSteps_);
          } else {
            return configStepsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public int getConfigStepsCount() {
          if (configStepsBuilder_ == null) {
            return configSteps_.size();
          } else {
            return configStepsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
            getConfigSteps(int index) {
          if (configStepsBuilder_ == null) {
            return configSteps_.get(index);
          } else {
            return configStepsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public Builder setConfigSteps(
            int index,
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
                value) {
          if (configStepsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureConfigStepsIsMutable();
            configSteps_.set(index, value);
            onChanged();
          } else {
            configStepsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public Builder setConfigSteps(
            int index,
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Builder
                builderForValue) {
          if (configStepsBuilder_ == null) {
            ensureConfigStepsIsMutable();
            configSteps_.set(index, builderForValue.build());
            onChanged();
          } else {
            configStepsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public Builder addConfigSteps(
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
                value) {
          if (configStepsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureConfigStepsIsMutable();
            configSteps_.add(value);
            onChanged();
          } else {
            configStepsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public Builder addConfigSteps(
            int index,
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep
                value) {
          if (configStepsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureConfigStepsIsMutable();
            configSteps_.add(index, value);
            onChanged();
          } else {
            configStepsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public Builder addConfigSteps(
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Builder
                builderForValue) {
          if (configStepsBuilder_ == null) {
            ensureConfigStepsIsMutable();
            configSteps_.add(builderForValue.build());
            onChanged();
          } else {
            configStepsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public Builder addConfigSteps(
            int index,
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Builder
                builderForValue) {
          if (configStepsBuilder_ == null) {
            ensureConfigStepsIsMutable();
            configSteps_.add(index, builderForValue.build());
            onChanged();
          } else {
            configStepsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public Builder addAllConfigSteps(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                            .OSPolicyResourceCompliance.OSPolicyResourceConfigStep>
                values) {
          if (configStepsBuilder_ == null) {
            ensureConfigStepsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, configSteps_);
            onChanged();
          } else {
            configStepsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public Builder clearConfigSteps() {
          if (configStepsBuilder_ == null) {
            configSteps_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            configStepsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public Builder removeConfigSteps(int index) {
          if (configStepsBuilder_ == null) {
            ensureConfigStepsIsMutable();
            configSteps_.remove(index);
            onChanged();
          } else {
            configStepsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Builder
            getConfigStepsBuilder(int index) {
          return getConfigStepsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStepOrBuilder
            getConfigStepsOrBuilder(int index) {
          if (configStepsBuilder_ == null) {
            return configSteps_.get(index);
          } else {
            return configStepsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.OSPolicyResourceConfigStepOrBuilder>
            getConfigStepsOrBuilderList() {
          if (configStepsBuilder_ != null) {
            return configStepsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(configSteps_);
          }
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Builder
            addConfigStepsBuilder() {
          return getConfigStepsFieldBuilder()
              .addBuilder(
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Builder
            addConfigStepsBuilder(int index) {
          return getConfigStepsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Ordered list of configuration completed by the agent for the OS policy
         * resource.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep config_steps = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Builder>
            getConfigStepsBuilderList() {
          return getConfigStepsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep,
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Builder,
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.OSPolicyResourceConfigStepOrBuilder>
            getConfigStepsFieldBuilder() {
          if (configStepsBuilder_ == null) {
            configStepsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.OSPolicyResourceConfigStep,
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Builder,
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.OSPolicyResourceConfigStepOrBuilder>(
                    configSteps_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            configSteps_ = null;
          }
          return configStepsBuilder_;
        }

        private int complianceState_ = 0;
        /**
         *
         *
         * <pre>
         * The compliance state of the resource.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ComplianceState compliance_state = 3;
         * </code>
         *
         * @return The enum numeric value on the wire for complianceState.
         */
        @java.lang.Override
        public int getComplianceStateValue() {
          return complianceState_;
        }
        /**
         *
         *
         * <pre>
         * The compliance state of the resource.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ComplianceState compliance_state = 3;
         * </code>
         *
         * @param value The enum numeric value on the wire for complianceState to set.
         * @return This builder for chaining.
         */
        public Builder setComplianceStateValue(int value) {
          complianceState_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The compliance state of the resource.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ComplianceState compliance_state = 3;
         * </code>
         *
         * @return The complianceState.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ComplianceState
            getComplianceState() {
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.ComplianceState
              result =
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.ComplianceState.forNumber(complianceState_);
          return result == null
              ? com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.ComplianceState.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * The compliance state of the resource.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ComplianceState compliance_state = 3;
         * </code>
         *
         * @param value The complianceState to set.
         * @return This builder for chaining.
         */
        public Builder setComplianceState(
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ComplianceState
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000004;
          complianceState_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The compliance state of the resource.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ComplianceState compliance_state = 3;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearComplianceState() {
          bitField0_ = (bitField0_ & ~0x00000004);
          complianceState_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object complianceStateReason_ = "";
        /**
         *
         *
         * <pre>
         * A reason for the resource to be in the given compliance state.
         * This field is always populated when `compliance_state` is `UNKNOWN`.
         *
         * The following values are supported when `compliance_state == UNKNOWN`
         *
         * * `execution-errors`: Errors were encountered by the agent while
         * executing the resource and the compliance state couldn't be
         * determined.
         * * `execution-skipped-by-agent`: Resource execution was skipped by the
         * agent because errors were encountered while executing prior resources
         * in the OS policy.
         * * `os-policy-execution-attempt-failed`: The execution of the OS policy
         * containing this resource failed and the compliance state couldn't be
         * determined.
         * </pre>
         *
         * <code>string compliance_state_reason = 4;</code>
         *
         * @return The complianceStateReason.
         */
        public java.lang.String getComplianceStateReason() {
          java.lang.Object ref = complianceStateReason_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            complianceStateReason_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A reason for the resource to be in the given compliance state.
         * This field is always populated when `compliance_state` is `UNKNOWN`.
         *
         * The following values are supported when `compliance_state == UNKNOWN`
         *
         * * `execution-errors`: Errors were encountered by the agent while
         * executing the resource and the compliance state couldn't be
         * determined.
         * * `execution-skipped-by-agent`: Resource execution was skipped by the
         * agent because errors were encountered while executing prior resources
         * in the OS policy.
         * * `os-policy-execution-attempt-failed`: The execution of the OS policy
         * containing this resource failed and the compliance state couldn't be
         * determined.
         * </pre>
         *
         * <code>string compliance_state_reason = 4;</code>
         *
         * @return The bytes for complianceStateReason.
         */
        public com.google.protobuf.ByteString getComplianceStateReasonBytes() {
          java.lang.Object ref = complianceStateReason_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            complianceStateReason_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A reason for the resource to be in the given compliance state.
         * This field is always populated when `compliance_state` is `UNKNOWN`.
         *
         * The following values are supported when `compliance_state == UNKNOWN`
         *
         * * `execution-errors`: Errors were encountered by the agent while
         * executing the resource and the compliance state couldn't be
         * determined.
         * * `execution-skipped-by-agent`: Resource execution was skipped by the
         * agent because errors were encountered while executing prior resources
         * in the OS policy.
         * * `os-policy-execution-attempt-failed`: The execution of the OS policy
         * containing this resource failed and the compliance state couldn't be
         * determined.
         * </pre>
         *
         * <code>string compliance_state_reason = 4;</code>
         *
         * @param value The complianceStateReason to set.
         * @return This builder for chaining.
         */
        public Builder setComplianceStateReason(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          complianceStateReason_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A reason for the resource to be in the given compliance state.
         * This field is always populated when `compliance_state` is `UNKNOWN`.
         *
         * The following values are supported when `compliance_state == UNKNOWN`
         *
         * * `execution-errors`: Errors were encountered by the agent while
         * executing the resource and the compliance state couldn't be
         * determined.
         * * `execution-skipped-by-agent`: Resource execution was skipped by the
         * agent because errors were encountered while executing prior resources
         * in the OS policy.
         * * `os-policy-execution-attempt-failed`: The execution of the OS policy
         * containing this resource failed and the compliance state couldn't be
         * determined.
         * </pre>
         *
         * <code>string compliance_state_reason = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearComplianceStateReason() {
          complianceStateReason_ = getDefaultInstance().getComplianceStateReason();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A reason for the resource to be in the given compliance state.
         * This field is always populated when `compliance_state` is `UNKNOWN`.
         *
         * The following values are supported when `compliance_state == UNKNOWN`
         *
         * * `execution-errors`: Errors were encountered by the agent while
         * executing the resource and the compliance state couldn't be
         * determined.
         * * `execution-skipped-by-agent`: Resource execution was skipped by the
         * agent because errors were encountered while executing prior resources
         * in the OS policy.
         * * `os-policy-execution-attempt-failed`: The execution of the OS policy
         * containing this resource failed and the compliance state couldn't be
         * determined.
         * </pre>
         *
         * <code>string compliance_state_reason = 4;</code>
         *
         * @param value The bytes for complianceStateReason to set.
         * @return This builder for chaining.
         */
        public Builder setComplianceStateReasonBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          complianceStateReason_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutput,
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutput.Builder,
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutputOrBuilder>
            execResourceOutputBuilder_;
        /**
         *
         *
         * <pre>
         * ExecResource specific output.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
         * </code>
         *
         * @return Whether the execResourceOutput field is set.
         */
        @java.lang.Override
        public boolean hasExecResourceOutput() {
          return outputCase_ == 5;
        }
        /**
         *
         *
         * <pre>
         * ExecResource specific output.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
         * </code>
         *
         * @return The execResourceOutput.
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput
            getExecResourceOutput() {
          if (execResourceOutputBuilder_ == null) {
            if (outputCase_ == 5) {
              return (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.ExecResourceOutput)
                  output_;
            }
            return com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput.getDefaultInstance();
          } else {
            if (outputCase_ == 5) {
              return execResourceOutputBuilder_.getMessage();
            }
            return com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * ExecResource specific output.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
         * </code>
         */
        public Builder setExecResourceOutput(
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutput
                value) {
          if (execResourceOutputBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            output_ = value;
            onChanged();
          } else {
            execResourceOutputBuilder_.setMessage(value);
          }
          outputCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * ExecResource specific output.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
         * </code>
         */
        public Builder setExecResourceOutput(
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutput.Builder
                builderForValue) {
          if (execResourceOutputBuilder_ == null) {
            output_ = builderForValue.build();
            onChanged();
          } else {
            execResourceOutputBuilder_.setMessage(builderForValue.build());
          }
          outputCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * ExecResource specific output.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
         * </code>
         */
        public Builder mergeExecResourceOutput(
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutput
                value) {
          if (execResourceOutputBuilder_ == null) {
            if (outputCase_ == 5
                && output_
                    != com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.ExecResourceOutput.getDefaultInstance()) {
              output_ =
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.ExecResourceOutput.newBuilder(
                          (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                                  .OSPolicyResourceCompliance.ExecResourceOutput)
                              output_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              output_ = value;
            }
            onChanged();
          } else {
            if (outputCase_ == 5) {
              execResourceOutputBuilder_.mergeFrom(value);
            } else {
              execResourceOutputBuilder_.setMessage(value);
            }
          }
          outputCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * ExecResource specific output.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
         * </code>
         */
        public Builder clearExecResourceOutput() {
          if (execResourceOutputBuilder_ == null) {
            if (outputCase_ == 5) {
              outputCase_ = 0;
              output_ = null;
              onChanged();
            }
          } else {
            if (outputCase_ == 5) {
              outputCase_ = 0;
              output_ = null;
            }
            execResourceOutputBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * ExecResource specific output.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
         * </code>
         */
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput.Builder
            getExecResourceOutputBuilder() {
          return getExecResourceOutputFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * ExecResource specific output.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutputOrBuilder
            getExecResourceOutputOrBuilder() {
          if ((outputCase_ == 5) && (execResourceOutputBuilder_ != null)) {
            return execResourceOutputBuilder_.getMessageOrBuilder();
          } else {
            if (outputCase_ == 5) {
              return (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.ExecResourceOutput)
                  output_;
            }
            return com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance.ExecResourceOutput.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * ExecResource specific output.
         * </pre>
         *
         * <code>
         * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 5;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutput,
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutput.Builder,
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.ExecResourceOutputOrBuilder>
            getExecResourceOutputFieldBuilder() {
          if (execResourceOutputBuilder_ == null) {
            if (!(outputCase_ == 5)) {
              output_ =
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.ExecResourceOutput.getDefaultInstance();
            }
            execResourceOutputBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.ExecResourceOutput,
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.ExecResourceOutput.Builder,
                    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                        .OSPolicyResourceCompliance.ExecResourceOutputOrBuilder>(
                    (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                            .OSPolicyResourceCompliance.ExecResourceOutput)
                        output_,
                    getParentForChildren(),
                    isClean());
            output_ = null;
          }
          outputCase_ = 5;
          onChanged();
          return execResourceOutputBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance)
      private static final com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance();
      }

      public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<OSPolicyResourceCompliance> PARSER =
          new com.google.protobuf.AbstractParser<OSPolicyResourceCompliance>() {
            @java.lang.Override
            public OSPolicyResourceCompliance parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<OSPolicyResourceCompliance> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<OSPolicyResourceCompliance> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int OS_POLICY_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object osPolicyId_ = "";
    /**
     *
     *
     * <pre>
     * The OS policy id
     * </pre>
     *
     * <code>string os_policy_id = 1;</code>
     *
     * @return The osPolicyId.
     */
    @java.lang.Override
    public java.lang.String getOsPolicyId() {
      java.lang.Object ref = osPolicyId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        osPolicyId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The OS policy id
     * </pre>
     *
     * <code>string os_policy_id = 1;</code>
     *
     * @return The bytes for osPolicyId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOsPolicyIdBytes() {
      java.lang.Object ref = osPolicyId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        osPolicyId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COMPLIANCE_STATE_FIELD_NUMBER = 2;
    private int complianceState_ = 0;
    /**
     *
     *
     * <pre>
     * The compliance state of the OS policy.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState compliance_state = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for complianceState.
     */
    @java.lang.Override
    public int getComplianceStateValue() {
      return complianceState_;
    }
    /**
     *
     *
     * <pre>
     * The compliance state of the OS policy.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState compliance_state = 2;
     * </code>
     *
     * @return The complianceState.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState
        getComplianceState() {
      com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState
          result =
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .ComplianceState.forNumber(complianceState_);
      return result == null
          ? com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState
              .UNRECOGNIZED
          : result;
    }

    public static final int COMPLIANCE_STATE_REASON_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object complianceStateReason_ = "";
    /**
     *
     *
     * <pre>
     * The reason for the OS policy to be in an unknown compliance state.
     * This field is always populated when `compliance_state` is `UNKNOWN`.
     *
     * If populated, the field can contain one of the following values:
     *
     * * `vm-not-running`: The VM was not running.
     * * `os-policies-not-supported-by-agent`: The version of the OS Config
     * agent running on the VM does not support running OS policies.
     * * `no-agent-detected`: The OS Config agent is not detected for the VM.
     * * `resource-execution-errors`: The OS Config agent encountered errors
     * while executing one or more resources in the policy. See
     * `os_policy_resource_compliances` for details.
     * * `task-timeout`: The task sent to the agent to apply the policy timed
     * out.
     * * `unexpected-agent-state`: The OS Config agent did not report the final
     * status of the task that attempted to apply the policy. Instead, the agent
     * unexpectedly started working on a different task. This mostly happens
     * when the agent or VM unexpectedly restarts while applying OS policies.
     * * `internal-service-errors`: Internal service errors were encountered
     * while attempting to apply the policy.
     * </pre>
     *
     * <code>string compliance_state_reason = 3;</code>
     *
     * @return The complianceStateReason.
     */
    @java.lang.Override
    public java.lang.String getComplianceStateReason() {
      java.lang.Object ref = complianceStateReason_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        complianceStateReason_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The reason for the OS policy to be in an unknown compliance state.
     * This field is always populated when `compliance_state` is `UNKNOWN`.
     *
     * If populated, the field can contain one of the following values:
     *
     * * `vm-not-running`: The VM was not running.
     * * `os-policies-not-supported-by-agent`: The version of the OS Config
     * agent running on the VM does not support running OS policies.
     * * `no-agent-detected`: The OS Config agent is not detected for the VM.
     * * `resource-execution-errors`: The OS Config agent encountered errors
     * while executing one or more resources in the policy. See
     * `os_policy_resource_compliances` for details.
     * * `task-timeout`: The task sent to the agent to apply the policy timed
     * out.
     * * `unexpected-agent-state`: The OS Config agent did not report the final
     * status of the task that attempted to apply the policy. Instead, the agent
     * unexpectedly started working on a different task. This mostly happens
     * when the agent or VM unexpectedly restarts while applying OS policies.
     * * `internal-service-errors`: Internal service errors were encountered
     * while attempting to apply the policy.
     * </pre>
     *
     * <code>string compliance_state_reason = 3;</code>
     *
     * @return The bytes for complianceStateReason.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getComplianceStateReasonBytes() {
      java.lang.Object ref = complianceStateReason_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        complianceStateReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OS_POLICY_RESOURCE_COMPLIANCES_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance>
        osPolicyResourceCompliances_;
    /**
     *
     *
     * <pre>
     * Compliance data for each resource within the policy that is applied to
     * the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .OSPolicyResourceCompliance>
        getOsPolicyResourceCompliancesList() {
      return osPolicyResourceCompliances_;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each resource within the policy that is applied to
     * the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceComplianceOrBuilder>
        getOsPolicyResourceCompliancesOrBuilderList() {
      return osPolicyResourceCompliances_;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each resource within the policy that is applied to
     * the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
     * </code>
     */
    @java.lang.Override
    public int getOsPolicyResourceCompliancesCount() {
      return osPolicyResourceCompliances_.size();
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each resource within the policy that is applied to
     * the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
            .OSPolicyResourceCompliance
        getOsPolicyResourceCompliances(int index) {
      return osPolicyResourceCompliances_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each resource within the policy that is applied to
     * the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
            .OSPolicyResourceComplianceOrBuilder
        getOsPolicyResourceCompliancesOrBuilder(int index) {
      return osPolicyResourceCompliances_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, osPolicyId_);
      }
      if (complianceState_
          != com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .ComplianceState.UNKNOWN
              .getNumber()) {
        output.writeEnum(2, complianceState_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(complianceStateReason_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, complianceStateReason_);
      }
      for (int i = 0; i < osPolicyResourceCompliances_.size(); i++) {
        output.writeMessage(4, osPolicyResourceCompliances_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, osPolicyId_);
      }
      if (complianceState_
          != com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .ComplianceState.UNKNOWN
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, complianceState_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(complianceStateReason_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, complianceStateReason_);
      }
      for (int i = 0; i < osPolicyResourceCompliances_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, osPolicyResourceCompliances_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance other =
          (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance) obj;

      if (!getOsPolicyId().equals(other.getOsPolicyId())) return false;
      if (complianceState_ != other.complianceState_) return false;
      if (!getComplianceStateReason().equals(other.getComplianceStateReason())) return false;
      if (!getOsPolicyResourceCompliancesList().equals(other.getOsPolicyResourceCompliancesList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OS_POLICY_ID_FIELD_NUMBER;
      hash = (53 * hash) + getOsPolicyId().hashCode();
      hash = (37 * hash) + COMPLIANCE_STATE_FIELD_NUMBER;
      hash = (53 * hash) + complianceState_;
      hash = (37 * hash) + COMPLIANCE_STATE_REASON_FIELD_NUMBER;
      hash = (53 * hash) + getComplianceStateReason().hashCode();
      if (getOsPolicyResourceCompliancesCount() > 0) {
        hash = (37 * hash) + OS_POLICY_RESOURCE_COMPLIANCES_FIELD_NUMBER;
        hash = (53 * hash) + getOsPolicyResourceCompliancesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for an OS policy
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance)
        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyComplianceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
            .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
            .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.class,
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        osPolicyId_ = "";
        complianceState_ = 0;
        complianceStateReason_ = "";
        if (osPolicyResourceCompliancesBuilder_ == null) {
          osPolicyResourceCompliances_ = java.util.Collections.emptyList();
        } else {
          osPolicyResourceCompliances_ = null;
          osPolicyResourceCompliancesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
            .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_OSPolicyCompliance_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance build() {
        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
          buildPartial() {
        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance result =
            new com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance result) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            osPolicyResourceCompliances_ =
                java.util.Collections.unmodifiableList(osPolicyResourceCompliances_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.osPolicyResourceCompliances_ = osPolicyResourceCompliances_;
        } else {
          result.osPolicyResourceCompliances_ = osPolicyResourceCompliancesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.osPolicyId_ = osPolicyId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.complianceState_ = complianceState_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.complianceStateReason_ = complianceStateReason_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance other) {
        if (other
            == com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .getDefaultInstance()) return this;
        if (!other.getOsPolicyId().isEmpty()) {
          osPolicyId_ = other.osPolicyId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.complianceState_ != 0) {
          setComplianceStateValue(other.getComplianceStateValue());
        }
        if (!other.getComplianceStateReason().isEmpty()) {
          complianceStateReason_ = other.complianceStateReason_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (osPolicyResourceCompliancesBuilder_ == null) {
          if (!other.osPolicyResourceCompliances_.isEmpty()) {
            if (osPolicyResourceCompliances_.isEmpty()) {
              osPolicyResourceCompliances_ = other.osPolicyResourceCompliances_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureOsPolicyResourceCompliancesIsMutable();
              osPolicyResourceCompliances_.addAll(other.osPolicyResourceCompliances_);
            }
            onChanged();
          }
        } else {
          if (!other.osPolicyResourceCompliances_.isEmpty()) {
            if (osPolicyResourceCompliancesBuilder_.isEmpty()) {
              osPolicyResourceCompliancesBuilder_.dispose();
              osPolicyResourceCompliancesBuilder_ = null;
              osPolicyResourceCompliances_ = other.osPolicyResourceCompliances_;
              bitField0_ = (bitField0_ & ~0x00000008);
              osPolicyResourceCompliancesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getOsPolicyResourceCompliancesFieldBuilder()
                      : null;
            } else {
              osPolicyResourceCompliancesBuilder_.addAllMessages(
                  other.osPolicyResourceCompliances_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  osPolicyId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  complianceState_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  complianceStateReason_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                          .OSPolicyResourceCompliance
                      m =
                          input.readMessage(
                              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport
                                  .OSPolicyCompliance.OSPolicyResourceCompliance.parser(),
                              extensionRegistry);
                  if (osPolicyResourceCompliancesBuilder_ == null) {
                    ensureOsPolicyResourceCompliancesIsMutable();
                    osPolicyResourceCompliances_.add(m);
                  } else {
                    osPolicyResourceCompliancesBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object osPolicyId_ = "";
      /**
       *
       *
       * <pre>
       * The OS policy id
       * </pre>
       *
       * <code>string os_policy_id = 1;</code>
       *
       * @return The osPolicyId.
       */
      public java.lang.String getOsPolicyId() {
        java.lang.Object ref = osPolicyId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          osPolicyId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The OS policy id
       * </pre>
       *
       * <code>string os_policy_id = 1;</code>
       *
       * @return The bytes for osPolicyId.
       */
      public com.google.protobuf.ByteString getOsPolicyIdBytes() {
        java.lang.Object ref = osPolicyId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          osPolicyId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The OS policy id
       * </pre>
       *
       * <code>string os_policy_id = 1;</code>
       *
       * @param value The osPolicyId to set.
       * @return This builder for chaining.
       */
      public Builder setOsPolicyId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        osPolicyId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The OS policy id
       * </pre>
       *
       * <code>string os_policy_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOsPolicyId() {
        osPolicyId_ = getDefaultInstance().getOsPolicyId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The OS policy id
       * </pre>
       *
       * <code>string os_policy_id = 1;</code>
       *
       * @param value The bytes for osPolicyId to set.
       * @return This builder for chaining.
       */
      public Builder setOsPolicyIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        osPolicyId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int complianceState_ = 0;
      /**
       *
       *
       * <pre>
       * The compliance state of the OS policy.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState compliance_state = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for complianceState.
       */
      @java.lang.Override
      public int getComplianceStateValue() {
        return complianceState_;
      }
      /**
       *
       *
       * <pre>
       * The compliance state of the OS policy.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState compliance_state = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for complianceState to set.
       * @return This builder for chaining.
       */
      public Builder setComplianceStateValue(int value) {
        complianceState_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The compliance state of the OS policy.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState compliance_state = 2;
       * </code>
       *
       * @return The complianceState.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .ComplianceState
          getComplianceState() {
        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState
            result =
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .ComplianceState.forNumber(complianceState_);
        return result == null
            ? com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                .ComplianceState.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The compliance state of the OS policy.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState compliance_state = 2;
       * </code>
       *
       * @param value The complianceState to set.
       * @return This builder for chaining.
       */
      public Builder setComplianceState(
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        complianceState_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The compliance state of the OS policy.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState compliance_state = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearComplianceState() {
        bitField0_ = (bitField0_ & ~0x00000002);
        complianceState_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object complianceStateReason_ = "";
      /**
       *
       *
       * <pre>
       * The reason for the OS policy to be in an unknown compliance state.
       * This field is always populated when `compliance_state` is `UNKNOWN`.
       *
       * If populated, the field can contain one of the following values:
       *
       * * `vm-not-running`: The VM was not running.
       * * `os-policies-not-supported-by-agent`: The version of the OS Config
       * agent running on the VM does not support running OS policies.
       * * `no-agent-detected`: The OS Config agent is not detected for the VM.
       * * `resource-execution-errors`: The OS Config agent encountered errors
       * while executing one or more resources in the policy. See
       * `os_policy_resource_compliances` for details.
       * * `task-timeout`: The task sent to the agent to apply the policy timed
       * out.
       * * `unexpected-agent-state`: The OS Config agent did not report the final
       * status of the task that attempted to apply the policy. Instead, the agent
       * unexpectedly started working on a different task. This mostly happens
       * when the agent or VM unexpectedly restarts while applying OS policies.
       * * `internal-service-errors`: Internal service errors were encountered
       * while attempting to apply the policy.
       * </pre>
       *
       * <code>string compliance_state_reason = 3;</code>
       *
       * @return The complianceStateReason.
       */
      public java.lang.String getComplianceStateReason() {
        java.lang.Object ref = complianceStateReason_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          complianceStateReason_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The reason for the OS policy to be in an unknown compliance state.
       * This field is always populated when `compliance_state` is `UNKNOWN`.
       *
       * If populated, the field can contain one of the following values:
       *
       * * `vm-not-running`: The VM was not running.
       * * `os-policies-not-supported-by-agent`: The version of the OS Config
       * agent running on the VM does not support running OS policies.
       * * `no-agent-detected`: The OS Config agent is not detected for the VM.
       * * `resource-execution-errors`: The OS Config agent encountered errors
       * while executing one or more resources in the policy. See
       * `os_policy_resource_compliances` for details.
       * * `task-timeout`: The task sent to the agent to apply the policy timed
       * out.
       * * `unexpected-agent-state`: The OS Config agent did not report the final
       * status of the task that attempted to apply the policy. Instead, the agent
       * unexpectedly started working on a different task. This mostly happens
       * when the agent or VM unexpectedly restarts while applying OS policies.
       * * `internal-service-errors`: Internal service errors were encountered
       * while attempting to apply the policy.
       * </pre>
       *
       * <code>string compliance_state_reason = 3;</code>
       *
       * @return The bytes for complianceStateReason.
       */
      public com.google.protobuf.ByteString getComplianceStateReasonBytes() {
        java.lang.Object ref = complianceStateReason_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          complianceStateReason_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The reason for the OS policy to be in an unknown compliance state.
       * This field is always populated when `compliance_state` is `UNKNOWN`.
       *
       * If populated, the field can contain one of the following values:
       *
       * * `vm-not-running`: The VM was not running.
       * * `os-policies-not-supported-by-agent`: The version of the OS Config
       * agent running on the VM does not support running OS policies.
       * * `no-agent-detected`: The OS Config agent is not detected for the VM.
       * * `resource-execution-errors`: The OS Config agent encountered errors
       * while executing one or more resources in the policy. See
       * `os_policy_resource_compliances` for details.
       * * `task-timeout`: The task sent to the agent to apply the policy timed
       * out.
       * * `unexpected-agent-state`: The OS Config agent did not report the final
       * status of the task that attempted to apply the policy. Instead, the agent
       * unexpectedly started working on a different task. This mostly happens
       * when the agent or VM unexpectedly restarts while applying OS policies.
       * * `internal-service-errors`: Internal service errors were encountered
       * while attempting to apply the policy.
       * </pre>
       *
       * <code>string compliance_state_reason = 3;</code>
       *
       * @param value The complianceStateReason to set.
       * @return This builder for chaining.
       */
      public Builder setComplianceStateReason(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        complianceStateReason_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The reason for the OS policy to be in an unknown compliance state.
       * This field is always populated when `compliance_state` is `UNKNOWN`.
       *
       * If populated, the field can contain one of the following values:
       *
       * * `vm-not-running`: The VM was not running.
       * * `os-policies-not-supported-by-agent`: The version of the OS Config
       * agent running on the VM does not support running OS policies.
       * * `no-agent-detected`: The OS Config agent is not detected for the VM.
       * * `resource-execution-errors`: The OS Config agent encountered errors
       * while executing one or more resources in the policy. See
       * `os_policy_resource_compliances` for details.
       * * `task-timeout`: The task sent to the agent to apply the policy timed
       * out.
       * * `unexpected-agent-state`: The OS Config agent did not report the final
       * status of the task that attempted to apply the policy. Instead, the agent
       * unexpectedly started working on a different task. This mostly happens
       * when the agent or VM unexpectedly restarts while applying OS policies.
       * * `internal-service-errors`: Internal service errors were encountered
       * while attempting to apply the policy.
       * </pre>
       *
       * <code>string compliance_state_reason = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearComplianceStateReason() {
        complianceStateReason_ = getDefaultInstance().getComplianceStateReason();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The reason for the OS policy to be in an unknown compliance state.
       * This field is always populated when `compliance_state` is `UNKNOWN`.
       *
       * If populated, the field can contain one of the following values:
       *
       * * `vm-not-running`: The VM was not running.
       * * `os-policies-not-supported-by-agent`: The version of the OS Config
       * agent running on the VM does not support running OS policies.
       * * `no-agent-detected`: The OS Config agent is not detected for the VM.
       * * `resource-execution-errors`: The OS Config agent encountered errors
       * while executing one or more resources in the policy. See
       * `os_policy_resource_compliances` for details.
       * * `task-timeout`: The task sent to the agent to apply the policy timed
       * out.
       * * `unexpected-agent-state`: The OS Config agent did not report the final
       * status of the task that attempted to apply the policy. Instead, the agent
       * unexpectedly started working on a different task. This mostly happens
       * when the agent or VM unexpectedly restarts while applying OS policies.
       * * `internal-service-errors`: Internal service errors were encountered
       * while attempting to apply the policy.
       * </pre>
       *
       * <code>string compliance_state_reason = 3;</code>
       *
       * @param value The bytes for complianceStateReason to set.
       * @return This builder for chaining.
       */
      public Builder setComplianceStateReasonBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        complianceStateReason_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance>
          osPolicyResourceCompliances_ = java.util.Collections.emptyList();

      private void ensureOsPolicyResourceCompliancesIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          osPolicyResourceCompliances_ =
              new java.util.ArrayList<
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance>(osPolicyResourceCompliances_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance,
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.Builder,
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceComplianceOrBuilder>
          osPolicyResourceCompliancesBuilder_;

      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public java.util.List<
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance>
          getOsPolicyResourceCompliancesList() {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(osPolicyResourceCompliances_);
        } else {
          return osPolicyResourceCompliancesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public int getOsPolicyResourceCompliancesCount() {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          return osPolicyResourceCompliances_.size();
        } else {
          return osPolicyResourceCompliancesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance
          getOsPolicyResourceCompliances(int index) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          return osPolicyResourceCompliances_.get(index);
        } else {
          return osPolicyResourceCompliancesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public Builder setOsPolicyResourceCompliances(
          int index,
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance
              value) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.set(index, value);
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public Builder setOsPolicyResourceCompliances(
          int index,
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.Builder
              builderForValue) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.set(index, builderForValue.build());
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public Builder addOsPolicyResourceCompliances(
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance
              value) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.add(value);
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public Builder addOsPolicyResourceCompliances(
          int index,
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance
              value) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.add(index, value);
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public Builder addOsPolicyResourceCompliances(
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.Builder
              builderForValue) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.add(builderForValue.build());
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public Builder addOsPolicyResourceCompliances(
          int index,
          com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.Builder
              builderForValue) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.add(index, builderForValue.build());
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public Builder addAllOsPolicyResourceCompliances(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                          .OSPolicyResourceCompliance>
              values) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          ensureOsPolicyResourceCompliancesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, osPolicyResourceCompliances_);
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public Builder clearOsPolicyResourceCompliances() {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          osPolicyResourceCompliances_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public Builder removeOsPolicyResourceCompliances(int index) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.remove(index);
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.Builder
          getOsPolicyResourceCompliancesBuilder(int index) {
        return getOsPolicyResourceCompliancesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceComplianceOrBuilder
          getOsPolicyResourceCompliancesOrBuilder(int index) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          return osPolicyResourceCompliances_.get(index);
        } else {
          return osPolicyResourceCompliancesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceComplianceOrBuilder>
          getOsPolicyResourceCompliancesOrBuilderList() {
        if (osPolicyResourceCompliancesBuilder_ != null) {
          return osPolicyResourceCompliancesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(osPolicyResourceCompliances_);
        }
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.Builder
          addOsPolicyResourceCompliancesBuilder() {
        return getOsPolicyResourceCompliancesFieldBuilder()
            .addBuilder(
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
              .OSPolicyResourceCompliance.Builder
          addOsPolicyResourceCompliancesBuilder(int index) {
        return getOsPolicyResourceCompliancesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                    .OSPolicyResourceCompliance.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each resource within the policy that is applied to
       * the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance os_policy_resource_compliances = 4;
       * </code>
       */
      public java.util.List<
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.Builder>
          getOsPolicyResourceCompliancesBuilderList() {
        return getOsPolicyResourceCompliancesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance,
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceCompliance.Builder,
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .OSPolicyResourceComplianceOrBuilder>
          getOsPolicyResourceCompliancesFieldBuilder() {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          osPolicyResourceCompliancesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance,
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceCompliance.Builder,
                  com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                      .OSPolicyResourceComplianceOrBuilder>(
                  osPolicyResourceCompliances_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          osPolicyResourceCompliances_ = null;
        }
        return osPolicyResourceCompliancesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance)
    private static final com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance();
    }

    public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OSPolicyCompliance> PARSER =
        new com.google.protobuf.AbstractParser<OSPolicyCompliance>() {
          @java.lang.Override
          public OSPolicyCompliance parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OSPolicyCompliance> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OSPolicyCompliance> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The `OSPolicyAssignmentReport` API resource name.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/instances/{instance_id}/osPolicyAssignments/{os_policy_assignment_id}/report`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The `OSPolicyAssignmentReport` API resource name.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/instances/{instance_id}/osPolicyAssignments/{os_policy_assignment_id}/report`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instance_ = "";
  /**
   *
   *
   * <pre>
   * The Compute Engine VM instance name.
   * </pre>
   *
   * <code>string instance = 2;</code>
   *
   * @return The instance.
   */
  @java.lang.Override
  public java.lang.String getInstance() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instance_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Compute Engine VM instance name.
   * </pre>
   *
   * <code>string instance = 2;</code>
   *
   * @return The bytes for instance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceBytes() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OS_POLICY_ASSIGNMENT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object osPolicyAssignment_ = "";
  /**
   *
   *
   * <pre>
   * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
   * belongs to.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
   * </pre>
   *
   * <code>string os_policy_assignment = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The osPolicyAssignment.
   */
  @java.lang.Override
  public java.lang.String getOsPolicyAssignment() {
    java.lang.Object ref = osPolicyAssignment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      osPolicyAssignment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
   * belongs to.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
   * </pre>
   *
   * <code>string os_policy_assignment = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for osPolicyAssignment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOsPolicyAssignmentBytes() {
    java.lang.Object ref = osPolicyAssignment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      osPolicyAssignment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OS_POLICY_COMPLIANCES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance>
      osPolicyCompliances_;
  /**
   *
   *
   * <pre>
   * Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance>
      getOsPolicyCompliancesList() {
    return osPolicyCompliances_;
  }
  /**
   *
   *
   * <pre>
   * Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyComplianceOrBuilder>
      getOsPolicyCompliancesOrBuilderList() {
    return osPolicyCompliances_;
  }
  /**
   *
   *
   * <pre>
   * Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
   * </code>
   */
  @java.lang.Override
  public int getOsPolicyCompliancesCount() {
    return osPolicyCompliances_.size();
  }
  /**
   *
   *
   * <pre>
   * Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
      getOsPolicyCompliances(int index) {
    return osPolicyCompliances_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyComplianceOrBuilder
      getOsPolicyCompliancesOrBuilder(int index) {
    return osPolicyCompliances_.get(index);
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Timestamp for when the report was last generated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Timestamp for when the report was last generated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Timestamp for when the report was last generated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LAST_RUN_ID_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastRunId_ = "";
  /**
   *
   *
   * <pre>
   * Unique identifier of the last attempted run to apply the OS policies
   * associated with this assignment on the VM.
   *
   * This ID is logged by the OS Config agent while applying the OS
   * policies associated with this assignment on the VM.
   * NOTE: If the service is unable to successfully connect to the agent for
   * this run, then this id will not be available in the agent logs.
   * </pre>
   *
   * <code>string last_run_id = 6;</code>
   *
   * @return The lastRunId.
   */
  @java.lang.Override
  public java.lang.String getLastRunId() {
    java.lang.Object ref = lastRunId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastRunId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique identifier of the last attempted run to apply the OS policies
   * associated with this assignment on the VM.
   *
   * This ID is logged by the OS Config agent while applying the OS
   * policies associated with this assignment on the VM.
   * NOTE: If the service is unable to successfully connect to the agent for
   * this run, then this id will not be available in the agent logs.
   * </pre>
   *
   * <code>string last_run_id = 6;</code>
   *
   * @return The bytes for lastRunId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastRunIdBytes() {
    java.lang.Object ref = lastRunId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastRunId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instance_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, instance_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyAssignment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, osPolicyAssignment_);
    }
    for (int i = 0; i < osPolicyCompliances_.size(); i++) {
      output.writeMessage(4, osPolicyCompliances_.get(i));
    }
    if (updateTime_ != null) {
      output.writeMessage(5, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastRunId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, lastRunId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instance_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, instance_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyAssignment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, osPolicyAssignment_);
    }
    for (int i = 0; i < osPolicyCompliances_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, osPolicyCompliances_.get(i));
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastRunId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, lastRunId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.osconfig.v1.OSPolicyAssignmentReport)) {
      return super.equals(obj);
    }
    com.google.cloud.osconfig.v1.OSPolicyAssignmentReport other =
        (com.google.cloud.osconfig.v1.OSPolicyAssignmentReport) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getInstance().equals(other.getInstance())) return false;
    if (!getOsPolicyAssignment().equals(other.getOsPolicyAssignment())) return false;
    if (!getOsPolicyCompliancesList().equals(other.getOsPolicyCompliancesList())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getLastRunId().equals(other.getLastRunId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
    hash = (53 * hash) + getInstance().hashCode();
    hash = (37 * hash) + OS_POLICY_ASSIGNMENT_FIELD_NUMBER;
    hash = (53 * hash) + getOsPolicyAssignment().hashCode();
    if (getOsPolicyCompliancesCount() > 0) {
      hash = (37 * hash) + OS_POLICY_COMPLIANCES_FIELD_NUMBER;
      hash = (53 * hash) + getOsPolicyCompliancesList().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + LAST_RUN_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLastRunId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.osconfig.v1.OSPolicyAssignmentReport prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A report of the OS policy assignment status for a given instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.OSPolicyAssignmentReport}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OSPolicyAssignmentReport)
      com.google.cloud.osconfig.v1.OSPolicyAssignmentReportOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
          .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
          .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.class,
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.Builder.class);
    }

    // Construct using com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      instance_ = "";
      osPolicyAssignment_ = "";
      if (osPolicyCompliancesBuilder_ == null) {
        osPolicyCompliances_ = java.util.Collections.emptyList();
      } else {
        osPolicyCompliances_ = null;
        osPolicyCompliancesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      lastRunId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.osconfig.v1.OSPolicyAssignmentReportsProto
          .internal_static_google_cloud_osconfig_v1_OSPolicyAssignmentReport_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport getDefaultInstanceForType() {
      return com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport build() {
      com.google.cloud.osconfig.v1.OSPolicyAssignmentReport result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport buildPartial() {
      com.google.cloud.osconfig.v1.OSPolicyAssignmentReport result =
          new com.google.cloud.osconfig.v1.OSPolicyAssignmentReport(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport result) {
      if (osPolicyCompliancesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          osPolicyCompliances_ = java.util.Collections.unmodifiableList(osPolicyCompliances_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.osPolicyCompliances_ = osPolicyCompliances_;
      } else {
        result.osPolicyCompliances_ = osPolicyCompliancesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.osconfig.v1.OSPolicyAssignmentReport result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.instance_ = instance_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.osPolicyAssignment_ = osPolicyAssignment_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.lastRunId_ = lastRunId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.osconfig.v1.OSPolicyAssignmentReport) {
        return mergeFrom((com.google.cloud.osconfig.v1.OSPolicyAssignmentReport) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.osconfig.v1.OSPolicyAssignmentReport other) {
      if (other == com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getInstance().isEmpty()) {
        instance_ = other.instance_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getOsPolicyAssignment().isEmpty()) {
        osPolicyAssignment_ = other.osPolicyAssignment_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (osPolicyCompliancesBuilder_ == null) {
        if (!other.osPolicyCompliances_.isEmpty()) {
          if (osPolicyCompliances_.isEmpty()) {
            osPolicyCompliances_ = other.osPolicyCompliances_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureOsPolicyCompliancesIsMutable();
            osPolicyCompliances_.addAll(other.osPolicyCompliances_);
          }
          onChanged();
        }
      } else {
        if (!other.osPolicyCompliances_.isEmpty()) {
          if (osPolicyCompliancesBuilder_.isEmpty()) {
            osPolicyCompliancesBuilder_.dispose();
            osPolicyCompliancesBuilder_ = null;
            osPolicyCompliances_ = other.osPolicyCompliances_;
            bitField0_ = (bitField0_ & ~0x00000008);
            osPolicyCompliancesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOsPolicyCompliancesFieldBuilder()
                    : null;
          } else {
            osPolicyCompliancesBuilder_.addAllMessages(other.osPolicyCompliances_);
          }
        }
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getLastRunId().isEmpty()) {
        lastRunId_ = other.lastRunId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                instance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                osPolicyAssignment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance m =
                    input.readMessage(
                        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                            .parser(),
                        extensionRegistry);
                if (osPolicyCompliancesBuilder_ == null) {
                  ensureOsPolicyCompliancesIsMutable();
                  osPolicyCompliances_.add(m);
                } else {
                  osPolicyCompliancesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                lastRunId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The `OSPolicyAssignmentReport` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/osPolicyAssignments/{os_policy_assignment_id}/report`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The `OSPolicyAssignmentReport` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/osPolicyAssignments/{os_policy_assignment_id}/report`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The `OSPolicyAssignmentReport` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/osPolicyAssignments/{os_policy_assignment_id}/report`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `OSPolicyAssignmentReport` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/osPolicyAssignments/{os_policy_assignment_id}/report`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `OSPolicyAssignmentReport` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/osPolicyAssignments/{os_policy_assignment_id}/report`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object instance_ = "";
    /**
     *
     *
     * <pre>
     * The Compute Engine VM instance name.
     * </pre>
     *
     * <code>string instance = 2;</code>
     *
     * @return The instance.
     */
    public java.lang.String getInstance() {
      java.lang.Object ref = instance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine VM instance name.
     * </pre>
     *
     * <code>string instance = 2;</code>
     *
     * @return The bytes for instance.
     */
    public com.google.protobuf.ByteString getInstanceBytes() {
      java.lang.Object ref = instance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine VM instance name.
     * </pre>
     *
     * <code>string instance = 2;</code>
     *
     * @param value The instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instance_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine VM instance name.
     * </pre>
     *
     * <code>string instance = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstance() {
      instance_ = getDefaultInstance().getInstance();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine VM instance name.
     * </pre>
     *
     * <code>string instance = 2;</code>
     *
     * @param value The bytes for instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instance_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object osPolicyAssignment_ = "";
    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
     * belongs to.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The osPolicyAssignment.
     */
    public java.lang.String getOsPolicyAssignment() {
      java.lang.Object ref = osPolicyAssignment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        osPolicyAssignment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
     * belongs to.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for osPolicyAssignment.
     */
    public com.google.protobuf.ByteString getOsPolicyAssignmentBytes() {
      java.lang.Object ref = osPolicyAssignment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        osPolicyAssignment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
     * belongs to.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The osPolicyAssignment to set.
     * @return This builder for chaining.
     */
    public Builder setOsPolicyAssignment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      osPolicyAssignment_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
     * belongs to.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOsPolicyAssignment() {
      osPolicyAssignment_ = getDefaultInstance().getOsPolicyAssignment();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
     * belongs to.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for osPolicyAssignment to set.
     * @return This builder for chaining.
     */
    public Builder setOsPolicyAssignmentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      osPolicyAssignment_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance>
        osPolicyCompliances_ = java.util.Collections.emptyList();

    private void ensureOsPolicyCompliancesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        osPolicyCompliances_ =
            new java.util.ArrayList<
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance>(
                osPolicyCompliances_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance,
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.Builder,
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyComplianceOrBuilder>
        osPolicyCompliancesBuilder_;

    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance>
        getOsPolicyCompliancesList() {
      if (osPolicyCompliancesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(osPolicyCompliances_);
      } else {
        return osPolicyCompliancesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public int getOsPolicyCompliancesCount() {
      if (osPolicyCompliancesBuilder_ == null) {
        return osPolicyCompliances_.size();
      } else {
        return osPolicyCompliancesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
        getOsPolicyCompliances(int index) {
      if (osPolicyCompliancesBuilder_ == null) {
        return osPolicyCompliances_.get(index);
      } else {
        return osPolicyCompliancesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public Builder setOsPolicyCompliances(
        int index, com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance value) {
      if (osPolicyCompliancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.set(index, value);
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public Builder setOsPolicyCompliances(
        int index,
        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.Builder
            builderForValue) {
      if (osPolicyCompliancesBuilder_ == null) {
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.set(index, builderForValue.build());
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public Builder addOsPolicyCompliances(
        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance value) {
      if (osPolicyCompliancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.add(value);
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public Builder addOsPolicyCompliances(
        int index, com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance value) {
      if (osPolicyCompliancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.add(index, value);
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public Builder addOsPolicyCompliances(
        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.Builder
            builderForValue) {
      if (osPolicyCompliancesBuilder_ == null) {
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.add(builderForValue.build());
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public Builder addOsPolicyCompliances(
        int index,
        com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.Builder
            builderForValue) {
      if (osPolicyCompliancesBuilder_ == null) {
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.add(index, builderForValue.build());
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public Builder addAllOsPolicyCompliances(
        java.lang.Iterable<
                ? extends com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance>
            values) {
      if (osPolicyCompliancesBuilder_ == null) {
        ensureOsPolicyCompliancesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, osPolicyCompliances_);
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public Builder clearOsPolicyCompliances() {
      if (osPolicyCompliancesBuilder_ == null) {
        osPolicyCompliances_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public Builder removeOsPolicyCompliances(int index) {
      if (osPolicyCompliancesBuilder_ == null) {
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.remove(index);
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.Builder
        getOsPolicyCompliancesBuilder(int index) {
      return getOsPolicyCompliancesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyComplianceOrBuilder
        getOsPolicyCompliancesOrBuilder(int index) {
      if (osPolicyCompliancesBuilder_ == null) {
        return osPolicyCompliances_.get(index);
      } else {
        return osPolicyCompliancesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyComplianceOrBuilder>
        getOsPolicyCompliancesOrBuilderList() {
      if (osPolicyCompliancesBuilder_ != null) {
        return osPolicyCompliancesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(osPolicyCompliances_);
      }
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.Builder
        addOsPolicyCompliancesBuilder() {
      return getOsPolicyCompliancesFieldBuilder()
          .addBuilder(
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.Builder
        addOsPolicyCompliancesBuilder(int index) {
      return getOsPolicyCompliancesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance os_policy_compliances = 4;
     * </code>
     */
    public java.util.List<
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.Builder>
        getOsPolicyCompliancesBuilderList() {
      return getOsPolicyCompliancesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance,
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.Builder,
            com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyComplianceOrBuilder>
        getOsPolicyCompliancesFieldBuilder() {
      if (osPolicyCompliancesBuilder_ == null) {
        osPolicyCompliancesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance,
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyCompliance.Builder,
                com.google.cloud.osconfig.v1.OSPolicyAssignmentReport.OSPolicyComplianceOrBuilder>(
                osPolicyCompliances_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        osPolicyCompliances_ = null;
      }
      return osPolicyCompliancesBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Timestamp for when the report was last generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Timestamp for when the report was last generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp for when the report was last generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp for when the report was last generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp for when the report was last generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp for when the report was last generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp for when the report was last generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Timestamp for when the report was last generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp for when the report was last generated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object lastRunId_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier of the last attempted run to apply the OS policies
     * associated with this assignment on the VM.
     *
     * This ID is logged by the OS Config agent while applying the OS
     * policies associated with this assignment on the VM.
     * NOTE: If the service is unable to successfully connect to the agent for
     * this run, then this id will not be available in the agent logs.
     * </pre>
     *
     * <code>string last_run_id = 6;</code>
     *
     * @return The lastRunId.
     */
    public java.lang.String getLastRunId() {
      java.lang.Object ref = lastRunId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastRunId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the last attempted run to apply the OS policies
     * associated with this assignment on the VM.
     *
     * This ID is logged by the OS Config agent while applying the OS
     * policies associated with this assignment on the VM.
     * NOTE: If the service is unable to successfully connect to the agent for
     * this run, then this id will not be available in the agent logs.
     * </pre>
     *
     * <code>string last_run_id = 6;</code>
     *
     * @return The bytes for lastRunId.
     */
    public com.google.protobuf.ByteString getLastRunIdBytes() {
      java.lang.Object ref = lastRunId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastRunId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the last attempted run to apply the OS policies
     * associated with this assignment on the VM.
     *
     * This ID is logged by the OS Config agent while applying the OS
     * policies associated with this assignment on the VM.
     * NOTE: If the service is unable to successfully connect to the agent for
     * this run, then this id will not be available in the agent logs.
     * </pre>
     *
     * <code>string last_run_id = 6;</code>
     *
     * @param value The lastRunId to set.
     * @return This builder for chaining.
     */
    public Builder setLastRunId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastRunId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the last attempted run to apply the OS policies
     * associated with this assignment on the VM.
     *
     * This ID is logged by the OS Config agent while applying the OS
     * policies associated with this assignment on the VM.
     * NOTE: If the service is unable to successfully connect to the agent for
     * this run, then this id will not be available in the agent logs.
     * </pre>
     *
     * <code>string last_run_id = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastRunId() {
      lastRunId_ = getDefaultInstance().getLastRunId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier of the last attempted run to apply the OS policies
     * associated with this assignment on the VM.
     *
     * This ID is logged by the OS Config agent while applying the OS
     * policies associated with this assignment on the VM.
     * NOTE: If the service is unable to successfully connect to the agent for
     * this run, then this id will not be available in the agent logs.
     * </pre>
     *
     * <code>string last_run_id = 6;</code>
     *
     * @param value The bytes for lastRunId to set.
     * @return This builder for chaining.
     */
    public Builder setLastRunIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastRunId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OSPolicyAssignmentReport)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OSPolicyAssignmentReport)
  private static final com.google.cloud.osconfig.v1.OSPolicyAssignmentReport DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.OSPolicyAssignmentReport();
  }

  public static com.google.cloud.osconfig.v1.OSPolicyAssignmentReport getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OSPolicyAssignmentReport> PARSER =
      new com.google.protobuf.AbstractParser<OSPolicyAssignmentReport>() {
        @java.lang.Override
        public OSPolicyAssignmentReport parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OSPolicyAssignmentReport> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OSPolicyAssignmentReport> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.osconfig.v1.OSPolicyAssignmentReport getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
