/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1/patch_deployments.proto

package com.google.cloud.osconfig.v1;

public final class PatchDeployments {
  private PatchDeployments() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  public interface PatchDeploymentOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.PatchDeployment)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Unique name for the patch deployment resource in a project. The patch
     * deployment name is in the form:
     * `projects/{project_id}/patchDeployments/{patch_deployment_id}`.
     * This field is ignored when you create a new patch deployment.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Unique name for the patch deployment resource in a project. The patch
     * deployment name is in the form:
     * `projects/{project_id}/patchDeployments/{patch_deployment_id}`.
     * This field is ignored when you create a new patch deployment.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. Description of the patch deployment. Length of the description is
     * limited to 1024 characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * Optional. Description of the patch deployment. Length of the description is
     * limited to 1024 characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * Required. VM instances to patch.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the instanceFilter field is set.
     */
    boolean hasInstanceFilter();
    /**
     *
     *
     * <pre>
     * Required. VM instances to patch.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The instanceFilter.
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter getInstanceFilter();
    /**
     *
     *
     * <pre>
     * Required. VM instances to patch.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder
        getInstanceFilterOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Patch configuration that is applied.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the patchConfig field is set.
     */
    boolean hasPatchConfig();
    /**
     *
     *
     * <pre>
     * Optional. Patch configuration that is applied.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The patchConfig.
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchConfig getPatchConfig();
    /**
     *
     *
     * <pre>
     * Optional. Patch configuration that is applied.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder getPatchConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Duration of the patch. After the duration ends, the patch times
     * out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the duration field is set.
     */
    boolean hasDuration();
    /**
     *
     *
     * <pre>
     * Optional. Duration of the patch. After the duration ends, the patch times
     * out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The duration.
     */
    com.google.protobuf.Duration getDuration();
    /**
     *
     *
     * <pre>
     * Optional. Duration of the patch. After the duration ends, the patch times
     * out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Schedule a one-time execution.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the oneTimeSchedule field is set.
     */
    boolean hasOneTimeSchedule();
    /**
     *
     *
     * <pre>
     * Required. Schedule a one-time execution.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The oneTimeSchedule.
     */
    com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule getOneTimeSchedule();
    /**
     *
     *
     * <pre>
     * Required. Schedule a one-time execution.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchDeployments.OneTimeScheduleOrBuilder
        getOneTimeScheduleOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Schedule recurring executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the recurringSchedule field is set.
     */
    boolean hasRecurringSchedule();
    /**
     *
     *
     * <pre>
     * Required. Schedule recurring executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The recurringSchedule.
     */
    com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule getRecurringSchedule();
    /**
     *
     *
     * <pre>
     * Required. Schedule recurring executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchDeployments.RecurringScheduleOrBuilder
        getRecurringScheduleOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Time the patch deployment was created. Timestamp is in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    boolean hasCreateTime();
    /**
     *
     *
     * <pre>
     * Output only. Time the patch deployment was created. Timestamp is in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    com.google.protobuf.Timestamp getCreateTime();
    /**
     *
     *
     * <pre>
     * Output only. Time the patch deployment was created. Timestamp is in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Time the patch deployment was last updated. Timestamp is in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    boolean hasUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. Time the patch deployment was last updated. Timestamp is in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    com.google.protobuf.Timestamp getUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. Time the patch deployment was last updated. Timestamp is in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The last time a patch job was started by this deployment.
     * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
     * format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastExecuteTime field is set.
     */
    boolean hasLastExecuteTime();
    /**
     *
     *
     * <pre>
     * Output only. The last time a patch job was started by this deployment.
     * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
     * format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastExecuteTime.
     */
    com.google.protobuf.Timestamp getLastExecuteTime();
    /**
     *
     *
     * <pre>
     * Output only. The last time a patch job was started by this deployment.
     * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
     * format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getLastExecuteTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Rollout strategy of the patch job.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the rollout field is set.
     */
    boolean hasRollout();
    /**
     *
     *
     * <pre>
     * Optional. Rollout strategy of the patch job.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rollout.
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchRollout getRollout();
    /**
     *
     *
     * <pre>
     * Optional. Rollout strategy of the patch job.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder getRolloutOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Current state of the patch deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Output only. Current state of the patch deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.State getState();

    com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.ScheduleCase getScheduleCase();
  }
  /**
   *
   *
   * <pre>
   * Patch deployments are configurations that individual patch jobs use to
   * complete a patch. These configurations include instance filter, package
   * repository settings, and a schedule. For more information about creating and
   * managing patch deployments, see [Scheduling patch
   * jobs](https://cloud.google.com/compute/docs/os-patch-management/schedule-patch-jobs).
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.PatchDeployment}
   */
  public static final class PatchDeployment extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.PatchDeployment)
      PatchDeploymentOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PatchDeployment.newBuilder() to construct.
    private PatchDeployment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PatchDeployment() {
      name_ = "";
      description_ = "";
      state_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PatchDeployment();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_PatchDeployment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_PatchDeployment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.class,
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Represents state of patch peployment.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.osconfig.v1.PatchDeployment.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The default value. This value is used if the state is omitted.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Active value means that patch deployment generates Patch Jobs.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      ACTIVE(1),
      /**
       *
       *
       * <pre>
       * Paused value means that patch deployment does not generate
       * Patch jobs. Requires user action to move in and out from this state.
       * </pre>
       *
       * <code>PAUSED = 2;</code>
       */
      PAUSED(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * The default value. This value is used if the state is omitted.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Active value means that patch deployment generates Patch Jobs.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      public static final int ACTIVE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Paused value means that patch deployment does not generate
       * Patch jobs. Requires user action to move in and out from this state.
       * </pre>
       *
       * <code>PAUSED = 2;</code>
       */
      public static final int PAUSED_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return ACTIVE;
          case 2:
            return PAUSED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.PatchDeployment.State)
    }

    private int scheduleCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object schedule_;

    public enum ScheduleCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ONE_TIME_SCHEDULE(6),
      RECURRING_SCHEDULE(7),
      SCHEDULE_NOT_SET(0);
      private final int value;

      private ScheduleCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ScheduleCase valueOf(int value) {
        return forNumber(value);
      }

      public static ScheduleCase forNumber(int value) {
        switch (value) {
          case 6:
            return ONE_TIME_SCHEDULE;
          case 7:
            return RECURRING_SCHEDULE;
          case 0:
            return SCHEDULE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ScheduleCase getScheduleCase() {
      return ScheduleCase.forNumber(scheduleCase_);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Unique name for the patch deployment resource in a project. The patch
     * deployment name is in the form:
     * `projects/{project_id}/patchDeployments/{patch_deployment_id}`.
     * This field is ignored when you create a new patch deployment.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique name for the patch deployment resource in a project. The patch
     * deployment name is in the form:
     * `projects/{project_id}/patchDeployments/{patch_deployment_id}`.
     * This field is ignored when you create a new patch deployment.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Description of the patch deployment. Length of the description is
     * limited to 1024 characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the patch deployment. Length of the description is
     * limited to 1024 characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INSTANCE_FILTER_FIELD_NUMBER = 3;
    private com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter instanceFilter_;
    /**
     *
     *
     * <pre>
     * Required. VM instances to patch.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the instanceFilter field is set.
     */
    @java.lang.Override
    public boolean hasInstanceFilter() {
      return instanceFilter_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. VM instances to patch.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The instanceFilter.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter getInstanceFilter() {
      return instanceFilter_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.getDefaultInstance()
          : instanceFilter_;
    }
    /**
     *
     *
     * <pre>
     * Required. VM instances to patch.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder
        getInstanceFilterOrBuilder() {
      return instanceFilter_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.getDefaultInstance()
          : instanceFilter_;
    }

    public static final int PATCH_CONFIG_FIELD_NUMBER = 4;
    private com.google.cloud.osconfig.v1.PatchJobs.PatchConfig patchConfig_;
    /**
     *
     *
     * <pre>
     * Optional. Patch configuration that is applied.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the patchConfig field is set.
     */
    @java.lang.Override
    public boolean hasPatchConfig() {
      return patchConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Patch configuration that is applied.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The patchConfig.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig getPatchConfig() {
      return patchConfig_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()
          : patchConfig_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Patch configuration that is applied.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder getPatchConfigOrBuilder() {
      return patchConfig_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()
          : patchConfig_;
    }

    public static final int DURATION_FIELD_NUMBER = 5;
    private com.google.protobuf.Duration duration_;
    /**
     *
     *
     * <pre>
     * Optional. Duration of the patch. After the duration ends, the patch times
     * out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the duration field is set.
     */
    @java.lang.Override
    public boolean hasDuration() {
      return duration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Duration of the patch. After the duration ends, the patch times
     * out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The duration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getDuration() {
      return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Duration of the patch. After the duration ends, the patch times
     * out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
      return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
    }

    public static final int ONE_TIME_SCHEDULE_FIELD_NUMBER = 6;
    /**
     *
     *
     * <pre>
     * Required. Schedule a one-time execution.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the oneTimeSchedule field is set.
     */
    @java.lang.Override
    public boolean hasOneTimeSchedule() {
      return scheduleCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule a one-time execution.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The oneTimeSchedule.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule getOneTimeSchedule() {
      if (scheduleCase_ == 6) {
        return (com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule) schedule_;
      }
      return com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule a one-time execution.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.OneTimeScheduleOrBuilder
        getOneTimeScheduleOrBuilder() {
      if (scheduleCase_ == 6) {
        return (com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule) schedule_;
      }
      return com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.getDefaultInstance();
    }

    public static final int RECURRING_SCHEDULE_FIELD_NUMBER = 7;
    /**
     *
     *
     * <pre>
     * Required. Schedule recurring executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the recurringSchedule field is set.
     */
    @java.lang.Override
    public boolean hasRecurringSchedule() {
      return scheduleCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule recurring executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The recurringSchedule.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule getRecurringSchedule() {
      if (scheduleCase_ == 7) {
        return (com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule) schedule_;
      }
      return com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule recurring executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.RecurringScheduleOrBuilder
        getRecurringScheduleOrBuilder() {
      if (scheduleCase_ == 7) {
        return (com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule) schedule_;
      }
      return com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.getDefaultInstance();
    }

    public static final int CREATE_TIME_FIELD_NUMBER = 8;
    private com.google.protobuf.Timestamp createTime_;
    /**
     *
     *
     * <pre>
     * Output only. Time the patch deployment was created. Timestamp is in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    @java.lang.Override
    public boolean hasCreateTime() {
      return createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the patch deployment was created. Timestamp is in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getCreateTime() {
      return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the patch deployment was created. Timestamp is in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
    }

    public static final int UPDATE_TIME_FIELD_NUMBER = 9;
    private com.google.protobuf.Timestamp updateTime_;
    /**
     *
     *
     * <pre>
     * Output only. Time the patch deployment was last updated. Timestamp is in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    @java.lang.Override
    public boolean hasUpdateTime() {
      return updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the patch deployment was last updated. Timestamp is in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getUpdateTime() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the patch deployment was last updated. Timestamp is in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }

    public static final int LAST_EXECUTE_TIME_FIELD_NUMBER = 10;
    private com.google.protobuf.Timestamp lastExecuteTime_;
    /**
     *
     *
     * <pre>
     * Output only. The last time a patch job was started by this deployment.
     * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
     * format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastExecuteTime field is set.
     */
    @java.lang.Override
    public boolean hasLastExecuteTime() {
      return lastExecuteTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time a patch job was started by this deployment.
     * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
     * format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastExecuteTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getLastExecuteTime() {
      return lastExecuteTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : lastExecuteTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time a patch job was started by this deployment.
     * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
     * format.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getLastExecuteTimeOrBuilder() {
      return lastExecuteTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : lastExecuteTime_;
    }

    public static final int ROLLOUT_FIELD_NUMBER = 11;
    private com.google.cloud.osconfig.v1.PatchJobs.PatchRollout rollout_;
    /**
     *
     *
     * <pre>
     * Optional. Rollout strategy of the patch job.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the rollout field is set.
     */
    @java.lang.Override
    public boolean hasRollout() {
      return rollout_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout strategy of the patch job.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rollout.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchRollout getRollout() {
      return rollout_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()
          : rollout_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rollout strategy of the patch job.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder getRolloutOrBuilder() {
      return rollout_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()
          : rollout_;
    }

    public static final int STATE_FIELD_NUMBER = 12;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current state of the patch deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the patch deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.State getState() {
      com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.State result =
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.State.forNumber(state_);
      return result == null
          ? com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.State.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
      }
      if (instanceFilter_ != null) {
        output.writeMessage(3, getInstanceFilter());
      }
      if (patchConfig_ != null) {
        output.writeMessage(4, getPatchConfig());
      }
      if (duration_ != null) {
        output.writeMessage(5, getDuration());
      }
      if (scheduleCase_ == 6) {
        output.writeMessage(
            6, (com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule) schedule_);
      }
      if (scheduleCase_ == 7) {
        output.writeMessage(
            7, (com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule) schedule_);
      }
      if (createTime_ != null) {
        output.writeMessage(8, getCreateTime());
      }
      if (updateTime_ != null) {
        output.writeMessage(9, getUpdateTime());
      }
      if (lastExecuteTime_ != null) {
        output.writeMessage(10, getLastExecuteTime());
      }
      if (rollout_ != null) {
        output.writeMessage(11, getRollout());
      }
      if (state_
          != com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(12, state_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
      }
      if (instanceFilter_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getInstanceFilter());
      }
      if (patchConfig_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPatchConfig());
      }
      if (duration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDuration());
      }
      if (scheduleCase_ == 6) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6, (com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule) schedule_);
      }
      if (scheduleCase_ == 7) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                7, (com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule) schedule_);
      }
      if (createTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreateTime());
      }
      if (updateTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
      }
      if (lastExecuteTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getLastExecuteTime());
      }
      if (rollout_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getRollout());
      }
      if (state_
          != com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, state_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment other =
          (com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (hasInstanceFilter() != other.hasInstanceFilter()) return false;
      if (hasInstanceFilter()) {
        if (!getInstanceFilter().equals(other.getInstanceFilter())) return false;
      }
      if (hasPatchConfig() != other.hasPatchConfig()) return false;
      if (hasPatchConfig()) {
        if (!getPatchConfig().equals(other.getPatchConfig())) return false;
      }
      if (hasDuration() != other.hasDuration()) return false;
      if (hasDuration()) {
        if (!getDuration().equals(other.getDuration())) return false;
      }
      if (hasCreateTime() != other.hasCreateTime()) return false;
      if (hasCreateTime()) {
        if (!getCreateTime().equals(other.getCreateTime())) return false;
      }
      if (hasUpdateTime() != other.hasUpdateTime()) return false;
      if (hasUpdateTime()) {
        if (!getUpdateTime().equals(other.getUpdateTime())) return false;
      }
      if (hasLastExecuteTime() != other.hasLastExecuteTime()) return false;
      if (hasLastExecuteTime()) {
        if (!getLastExecuteTime().equals(other.getLastExecuteTime())) return false;
      }
      if (hasRollout() != other.hasRollout()) return false;
      if (hasRollout()) {
        if (!getRollout().equals(other.getRollout())) return false;
      }
      if (state_ != other.state_) return false;
      if (!getScheduleCase().equals(other.getScheduleCase())) return false;
      switch (scheduleCase_) {
        case 6:
          if (!getOneTimeSchedule().equals(other.getOneTimeSchedule())) return false;
          break;
        case 7:
          if (!getRecurringSchedule().equals(other.getRecurringSchedule())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      if (hasInstanceFilter()) {
        hash = (37 * hash) + INSTANCE_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getInstanceFilter().hashCode();
      }
      if (hasPatchConfig()) {
        hash = (37 * hash) + PATCH_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getPatchConfig().hashCode();
      }
      if (hasDuration()) {
        hash = (37 * hash) + DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getDuration().hashCode();
      }
      if (hasCreateTime()) {
        hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getCreateTime().hashCode();
      }
      if (hasUpdateTime()) {
        hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateTime().hashCode();
      }
      if (hasLastExecuteTime()) {
        hash = (37 * hash) + LAST_EXECUTE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getLastExecuteTime().hashCode();
      }
      if (hasRollout()) {
        hash = (37 * hash) + ROLLOUT_FIELD_NUMBER;
        hash = (53 * hash) + getRollout().hashCode();
      }
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      switch (scheduleCase_) {
        case 6:
          hash = (37 * hash) + ONE_TIME_SCHEDULE_FIELD_NUMBER;
          hash = (53 * hash) + getOneTimeSchedule().hashCode();
          break;
        case 7:
          hash = (37 * hash) + RECURRING_SCHEDULE_FIELD_NUMBER;
          hash = (53 * hash) + getRecurringSchedule().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Patch deployments are configurations that individual patch jobs use to
     * complete a patch. These configurations include instance filter, package
     * repository settings, and a schedule. For more information about creating and
     * managing patch deployments, see [Scheduling patch
     * jobs](https://cloud.google.com/compute/docs/os-patch-management/schedule-patch-jobs).
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.PatchDeployment}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.PatchDeployment)
        com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_PatchDeployment_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_PatchDeployment_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.class,
                com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        description_ = "";
        instanceFilter_ = null;
        if (instanceFilterBuilder_ != null) {
          instanceFilterBuilder_.dispose();
          instanceFilterBuilder_ = null;
        }
        patchConfig_ = null;
        if (patchConfigBuilder_ != null) {
          patchConfigBuilder_.dispose();
          patchConfigBuilder_ = null;
        }
        duration_ = null;
        if (durationBuilder_ != null) {
          durationBuilder_.dispose();
          durationBuilder_ = null;
        }
        if (oneTimeScheduleBuilder_ != null) {
          oneTimeScheduleBuilder_.clear();
        }
        if (recurringScheduleBuilder_ != null) {
          recurringScheduleBuilder_.clear();
        }
        createTime_ = null;
        if (createTimeBuilder_ != null) {
          createTimeBuilder_.dispose();
          createTimeBuilder_ = null;
        }
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        lastExecuteTime_ = null;
        if (lastExecuteTimeBuilder_ != null) {
          lastExecuteTimeBuilder_.dispose();
          lastExecuteTimeBuilder_ = null;
        }
        rollout_ = null;
        if (rolloutBuilder_ != null) {
          rolloutBuilder_.dispose();
          rolloutBuilder_ = null;
        }
        state_ = 0;
        scheduleCase_ = 0;
        schedule_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_PatchDeployment_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment build() {
        com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment result =
            new com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.instanceFilter_ =
              instanceFilterBuilder_ == null ? instanceFilter_ : instanceFilterBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.patchConfig_ =
              patchConfigBuilder_ == null ? patchConfig_ : patchConfigBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.createTime_ =
              createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.updateTime_ =
              updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.lastExecuteTime_ =
              lastExecuteTimeBuilder_ == null ? lastExecuteTime_ : lastExecuteTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.rollout_ = rolloutBuilder_ == null ? rollout_ : rolloutBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000800) != 0)) {
          result.state_ = state_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment result) {
        result.scheduleCase_ = scheduleCase_;
        result.schedule_ = this.schedule_;
        if (scheduleCase_ == 6 && oneTimeScheduleBuilder_ != null) {
          result.schedule_ = oneTimeScheduleBuilder_.build();
        }
        if (scheduleCase_ == 7 && recurringScheduleBuilder_ != null) {
          result.schedule_ = recurringScheduleBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasInstanceFilter()) {
          mergeInstanceFilter(other.getInstanceFilter());
        }
        if (other.hasPatchConfig()) {
          mergePatchConfig(other.getPatchConfig());
        }
        if (other.hasDuration()) {
          mergeDuration(other.getDuration());
        }
        if (other.hasCreateTime()) {
          mergeCreateTime(other.getCreateTime());
        }
        if (other.hasUpdateTime()) {
          mergeUpdateTime(other.getUpdateTime());
        }
        if (other.hasLastExecuteTime()) {
          mergeLastExecuteTime(other.getLastExecuteTime());
        }
        if (other.hasRollout()) {
          mergeRollout(other.getRollout());
        }
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        switch (other.getScheduleCase()) {
          case ONE_TIME_SCHEDULE:
            {
              mergeOneTimeSchedule(other.getOneTimeSchedule());
              break;
            }
          case RECURRING_SCHEDULE:
            {
              mergeRecurringSchedule(other.getRecurringSchedule());
              break;
            }
          case SCHEDULE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getInstanceFilterFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getPatchConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getOneTimeScheduleFieldBuilder().getBuilder(), extensionRegistry);
                  scheduleCase_ = 6;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(
                      getRecurringScheduleFieldBuilder().getBuilder(), extensionRegistry);
                  scheduleCase_ = 7;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000100;
                  break;
                } // case 74
              case 82:
                {
                  input.readMessage(
                      getLastExecuteTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000200;
                  break;
                } // case 82
              case 90:
                {
                  input.readMessage(getRolloutFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000400;
                  break;
                } // case 90
              case 96:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000800;
                  break;
                } // case 96
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int scheduleCase_ = 0;
      private java.lang.Object schedule_;

      public ScheduleCase getScheduleCase() {
        return ScheduleCase.forNumber(scheduleCase_);
      }

      public Builder clearSchedule() {
        scheduleCase_ = 0;
        schedule_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Unique name for the patch deployment resource in a project. The patch
       * deployment name is in the form:
       * `projects/{project_id}/patchDeployments/{patch_deployment_id}`.
       * This field is ignored when you create a new patch deployment.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Unique name for the patch deployment resource in a project. The patch
       * deployment name is in the form:
       * `projects/{project_id}/patchDeployments/{patch_deployment_id}`.
       * This field is ignored when you create a new patch deployment.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Unique name for the patch deployment resource in a project. The patch
       * deployment name is in the form:
       * `projects/{project_id}/patchDeployments/{patch_deployment_id}`.
       * This field is ignored when you create a new patch deployment.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Unique name for the patch deployment resource in a project. The patch
       * deployment name is in the form:
       * `projects/{project_id}/patchDeployments/{patch_deployment_id}`.
       * This field is ignored when you create a new patch deployment.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Unique name for the patch deployment resource in a project. The patch
       * deployment name is in the form:
       * `projects/{project_id}/patchDeployments/{patch_deployment_id}`.
       * This field is ignored when you create a new patch deployment.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Description of the patch deployment. Length of the description is
       * limited to 1024 characters.
       * </pre>
       *
       * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Description of the patch deployment. Length of the description is
       * limited to 1024 characters.
       * </pre>
       *
       * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Description of the patch deployment. Length of the description is
       * limited to 1024 characters.
       * </pre>
       *
       * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Description of the patch deployment. Length of the description is
       * limited to 1024 characters.
       * </pre>
       *
       * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Description of the patch deployment. Length of the description is
       * limited to 1024 characters.
       * </pre>
       *
       * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter instanceFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter,
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder>
          instanceFilterBuilder_;
      /**
       *
       *
       * <pre>
       * Required. VM instances to patch.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the instanceFilter field is set.
       */
      public boolean hasInstanceFilter() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. VM instances to patch.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The instanceFilter.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter getInstanceFilter() {
        if (instanceFilterBuilder_ == null) {
          return instanceFilter_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.getDefaultInstance()
              : instanceFilter_;
        } else {
          return instanceFilterBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. VM instances to patch.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setInstanceFilter(
          com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter value) {
        if (instanceFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          instanceFilter_ = value;
        } else {
          instanceFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. VM instances to patch.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setInstanceFilter(
          com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder builderForValue) {
        if (instanceFilterBuilder_ == null) {
          instanceFilter_ = builderForValue.build();
        } else {
          instanceFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. VM instances to patch.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeInstanceFilter(
          com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter value) {
        if (instanceFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && instanceFilter_ != null
              && instanceFilter_
                  != com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter
                      .getDefaultInstance()) {
            getInstanceFilterBuilder().mergeFrom(value);
          } else {
            instanceFilter_ = value;
          }
        } else {
          instanceFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. VM instances to patch.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearInstanceFilter() {
        bitField0_ = (bitField0_ & ~0x00000004);
        instanceFilter_ = null;
        if (instanceFilterBuilder_ != null) {
          instanceFilterBuilder_.dispose();
          instanceFilterBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. VM instances to patch.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder
          getInstanceFilterBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getInstanceFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. VM instances to patch.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder
          getInstanceFilterOrBuilder() {
        if (instanceFilterBuilder_ != null) {
          return instanceFilterBuilder_.getMessageOrBuilder();
        } else {
          return instanceFilter_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.getDefaultInstance()
              : instanceFilter_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. VM instances to patch.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter,
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder>
          getInstanceFilterFieldBuilder() {
        if (instanceFilterBuilder_ == null) {
          instanceFilterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder>(
                  getInstanceFilter(), getParentForChildren(), isClean());
          instanceFilter_ = null;
        }
        return instanceFilterBuilder_;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.PatchConfig patchConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig,
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder>
          patchConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Patch configuration that is applied.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the patchConfig field is set.
       */
      public boolean hasPatchConfig() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Patch configuration that is applied.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The patchConfig.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig getPatchConfig() {
        if (patchConfigBuilder_ == null) {
          return patchConfig_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()
              : patchConfig_;
        } else {
          return patchConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Patch configuration that is applied.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPatchConfig(com.google.cloud.osconfig.v1.PatchJobs.PatchConfig value) {
        if (patchConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          patchConfig_ = value;
        } else {
          patchConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Patch configuration that is applied.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPatchConfig(
          com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder builderForValue) {
        if (patchConfigBuilder_ == null) {
          patchConfig_ = builderForValue.build();
        } else {
          patchConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Patch configuration that is applied.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergePatchConfig(com.google.cloud.osconfig.v1.PatchJobs.PatchConfig value) {
        if (patchConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && patchConfig_ != null
              && patchConfig_
                  != com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()) {
            getPatchConfigBuilder().mergeFrom(value);
          } else {
            patchConfig_ = value;
          }
        } else {
          patchConfigBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Patch configuration that is applied.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearPatchConfig() {
        bitField0_ = (bitField0_ & ~0x00000008);
        patchConfig_ = null;
        if (patchConfigBuilder_ != null) {
          patchConfigBuilder_.dispose();
          patchConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Patch configuration that is applied.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder getPatchConfigBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getPatchConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Patch configuration that is applied.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder getPatchConfigOrBuilder() {
        if (patchConfigBuilder_ != null) {
          return patchConfigBuilder_.getMessageOrBuilder();
        } else {
          return patchConfig_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()
              : patchConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Patch configuration that is applied.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchConfig patch_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig,
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder>
          getPatchConfigFieldBuilder() {
        if (patchConfigBuilder_ == null) {
          patchConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.PatchConfig,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder>(
                  getPatchConfig(), getParentForChildren(), isClean());
          patchConfig_ = null;
        }
        return patchConfigBuilder_;
      }

      private com.google.protobuf.Duration duration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          durationBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Duration of the patch. After the duration ends, the patch times
       * out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the duration field is set.
       */
      public boolean hasDuration() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Duration of the patch. After the duration ends, the patch times
       * out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The duration.
       */
      public com.google.protobuf.Duration getDuration() {
        if (durationBuilder_ == null) {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        } else {
          return durationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Duration of the patch. After the duration ends, the patch times
       * out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          duration_ = value;
        } else {
          durationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Duration of the patch. After the duration ends, the patch times
       * out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (durationBuilder_ == null) {
          duration_ = builderForValue.build();
        } else {
          durationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Duration of the patch. After the duration ends, the patch times
       * out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && duration_ != null
              && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getDurationBuilder().mergeFrom(value);
          } else {
            duration_ = value;
          }
        } else {
          durationBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Duration of the patch. After the duration ends, the patch times
       * out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearDuration() {
        bitField0_ = (bitField0_ & ~0x00000010);
        duration_ = null;
        if (durationBuilder_ != null) {
          durationBuilder_.dispose();
          durationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Duration of the patch. After the duration ends, the patch times
       * out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Duration.Builder getDurationBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Duration of the patch. After the duration ends, the patch times
       * out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        if (durationBuilder_ != null) {
          return durationBuilder_.getMessageOrBuilder();
        } else {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Duration of the patch. After the duration ends, the patch times
       * out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getDurationFieldBuilder() {
        if (durationBuilder_ == null) {
          durationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getDuration(), getParentForChildren(), isClean());
          duration_ = null;
        }
        return durationBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule,
              com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.OneTimeScheduleOrBuilder>
          oneTimeScheduleBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Schedule a one-time execution.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the oneTimeSchedule field is set.
       */
      @java.lang.Override
      public boolean hasOneTimeSchedule() {
        return scheduleCase_ == 6;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule a one-time execution.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The oneTimeSchedule.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule getOneTimeSchedule() {
        if (oneTimeScheduleBuilder_ == null) {
          if (scheduleCase_ == 6) {
            return (com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule) schedule_;
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.getDefaultInstance();
        } else {
          if (scheduleCase_ == 6) {
            return oneTimeScheduleBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule a one-time execution.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setOneTimeSchedule(
          com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule value) {
        if (oneTimeScheduleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schedule_ = value;
          onChanged();
        } else {
          oneTimeScheduleBuilder_.setMessage(value);
        }
        scheduleCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule a one-time execution.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setOneTimeSchedule(
          com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.Builder builderForValue) {
        if (oneTimeScheduleBuilder_ == null) {
          schedule_ = builderForValue.build();
          onChanged();
        } else {
          oneTimeScheduleBuilder_.setMessage(builderForValue.build());
        }
        scheduleCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule a one-time execution.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeOneTimeSchedule(
          com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule value) {
        if (oneTimeScheduleBuilder_ == null) {
          if (scheduleCase_ == 6
              && schedule_
                  != com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule
                      .getDefaultInstance()) {
            schedule_ =
                com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.newBuilder(
                        (com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule) schedule_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            schedule_ = value;
          }
          onChanged();
        } else {
          if (scheduleCase_ == 6) {
            oneTimeScheduleBuilder_.mergeFrom(value);
          } else {
            oneTimeScheduleBuilder_.setMessage(value);
          }
        }
        scheduleCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule a one-time execution.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearOneTimeSchedule() {
        if (oneTimeScheduleBuilder_ == null) {
          if (scheduleCase_ == 6) {
            scheduleCase_ = 0;
            schedule_ = null;
            onChanged();
          }
        } else {
          if (scheduleCase_ == 6) {
            scheduleCase_ = 0;
            schedule_ = null;
          }
          oneTimeScheduleBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule a one-time execution.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.Builder
          getOneTimeScheduleBuilder() {
        return getOneTimeScheduleFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule a one-time execution.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.OneTimeScheduleOrBuilder
          getOneTimeScheduleOrBuilder() {
        if ((scheduleCase_ == 6) && (oneTimeScheduleBuilder_ != null)) {
          return oneTimeScheduleBuilder_.getMessageOrBuilder();
        } else {
          if (scheduleCase_ == 6) {
            return (com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule) schedule_;
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule a one-time execution.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.OneTimeSchedule one_time_schedule = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule,
              com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.OneTimeScheduleOrBuilder>
          getOneTimeScheduleFieldBuilder() {
        if (oneTimeScheduleBuilder_ == null) {
          if (!(scheduleCase_ == 6)) {
            schedule_ =
                com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.getDefaultInstance();
          }
          oneTimeScheduleBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule,
                  com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.Builder,
                  com.google.cloud.osconfig.v1.PatchDeployments.OneTimeScheduleOrBuilder>(
                  (com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule) schedule_,
                  getParentForChildren(),
                  isClean());
          schedule_ = null;
        }
        scheduleCase_ = 6;
        onChanged();
        return oneTimeScheduleBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule,
              com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.RecurringScheduleOrBuilder>
          recurringScheduleBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Schedule recurring executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the recurringSchedule field is set.
       */
      @java.lang.Override
      public boolean hasRecurringSchedule() {
        return scheduleCase_ == 7;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule recurring executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The recurringSchedule.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule
          getRecurringSchedule() {
        if (recurringScheduleBuilder_ == null) {
          if (scheduleCase_ == 7) {
            return (com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule) schedule_;
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule
              .getDefaultInstance();
        } else {
          if (scheduleCase_ == 7) {
            return recurringScheduleBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule recurring executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setRecurringSchedule(
          com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule value) {
        if (recurringScheduleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schedule_ = value;
          onChanged();
        } else {
          recurringScheduleBuilder_.setMessage(value);
        }
        scheduleCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule recurring executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setRecurringSchedule(
          com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Builder builderForValue) {
        if (recurringScheduleBuilder_ == null) {
          schedule_ = builderForValue.build();
          onChanged();
        } else {
          recurringScheduleBuilder_.setMessage(builderForValue.build());
        }
        scheduleCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule recurring executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeRecurringSchedule(
          com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule value) {
        if (recurringScheduleBuilder_ == null) {
          if (scheduleCase_ == 7
              && schedule_
                  != com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule
                      .getDefaultInstance()) {
            schedule_ =
                com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.newBuilder(
                        (com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule) schedule_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            schedule_ = value;
          }
          onChanged();
        } else {
          if (scheduleCase_ == 7) {
            recurringScheduleBuilder_.mergeFrom(value);
          } else {
            recurringScheduleBuilder_.setMessage(value);
          }
        }
        scheduleCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule recurring executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearRecurringSchedule() {
        if (recurringScheduleBuilder_ == null) {
          if (scheduleCase_ == 7) {
            scheduleCase_ = 0;
            schedule_ = null;
            onChanged();
          }
        } else {
          if (scheduleCase_ == 7) {
            scheduleCase_ = 0;
            schedule_ = null;
          }
          recurringScheduleBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule recurring executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Builder
          getRecurringScheduleBuilder() {
        return getRecurringScheduleFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule recurring executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.RecurringScheduleOrBuilder
          getRecurringScheduleOrBuilder() {
        if ((scheduleCase_ == 7) && (recurringScheduleBuilder_ != null)) {
          return recurringScheduleBuilder_.getMessageOrBuilder();
        } else {
          if (scheduleCase_ == 7) {
            return (com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule) schedule_;
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule recurring executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule recurring_schedule = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule,
              com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.RecurringScheduleOrBuilder>
          getRecurringScheduleFieldBuilder() {
        if (recurringScheduleBuilder_ == null) {
          if (!(scheduleCase_ == 7)) {
            schedule_ =
                com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule
                    .getDefaultInstance();
          }
          recurringScheduleBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule,
                  com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Builder,
                  com.google.cloud.osconfig.v1.PatchDeployments.RecurringScheduleOrBuilder>(
                  (com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule) schedule_,
                  getParentForChildren(),
                  isClean());
          schedule_ = null;
        }
        scheduleCase_ = 7;
        onChanged();
        return recurringScheduleBuilder_;
      }

      private com.google.protobuf.Timestamp createTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          createTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was created. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the createTime field is set.
       */
      public boolean hasCreateTime() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was created. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The createTime.
       */
      public com.google.protobuf.Timestamp getCreateTime() {
        if (createTimeBuilder_ == null) {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        } else {
          return createTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was created. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          createTime_ = value;
        } else {
          createTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was created. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (createTimeBuilder_ == null) {
          createTime_ = builderForValue.build();
        } else {
          createTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was created. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && createTime_ != null
              && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getCreateTimeBuilder().mergeFrom(value);
          } else {
            createTime_ = value;
          }
        } else {
          createTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was created. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearCreateTime() {
        bitField0_ = (bitField0_ & ~0x00000080);
        createTime_ = null;
        if (createTimeBuilder_ != null) {
          createTimeBuilder_.dispose();
          createTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was created. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getCreateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was created. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
        if (createTimeBuilder_ != null) {
          return createTimeBuilder_.getMessageOrBuilder();
        } else {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was created. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getCreateTimeFieldBuilder() {
        if (createTimeBuilder_ == null) {
          createTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getCreateTime(), getParentForChildren(), isClean());
          createTime_ = null;
        }
        return createTimeBuilder_;
      }

      private com.google.protobuf.Timestamp updateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          updateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was last updated. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the updateTime field is set.
       */
      public boolean hasUpdateTime() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was last updated. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The updateTime.
       */
      public com.google.protobuf.Timestamp getUpdateTime() {
        if (updateTimeBuilder_ == null) {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        } else {
          return updateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was last updated. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateTime_ = value;
        } else {
          updateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was last updated. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (updateTimeBuilder_ == null) {
          updateTime_ = builderForValue.build();
        } else {
          updateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was last updated. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)
              && updateTime_ != null
              && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getUpdateTimeBuilder().mergeFrom(value);
          } else {
            updateTime_ = value;
          }
        } else {
          updateTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was last updated. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearUpdateTime() {
        bitField0_ = (bitField0_ & ~0x00000100);
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was last updated. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was last updated. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
        if (updateTimeBuilder_ != null) {
          return updateTimeBuilder_.getMessageOrBuilder();
        } else {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Time the patch deployment was last updated. Timestamp is in
       * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getUpdateTimeFieldBuilder() {
        if (updateTimeBuilder_ == null) {
          updateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getUpdateTime(), getParentForChildren(), isClean());
          updateTime_ = null;
        }
        return updateTimeBuilder_;
      }

      private com.google.protobuf.Timestamp lastExecuteTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          lastExecuteTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The last time a patch job was started by this deployment.
       * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
       * format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the lastExecuteTime field is set.
       */
      public boolean hasLastExecuteTime() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The last time a patch job was started by this deployment.
       * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
       * format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The lastExecuteTime.
       */
      public com.google.protobuf.Timestamp getLastExecuteTime() {
        if (lastExecuteTimeBuilder_ == null) {
          return lastExecuteTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastExecuteTime_;
        } else {
          return lastExecuteTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The last time a patch job was started by this deployment.
       * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
       * format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setLastExecuteTime(com.google.protobuf.Timestamp value) {
        if (lastExecuteTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastExecuteTime_ = value;
        } else {
          lastExecuteTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The last time a patch job was started by this deployment.
       * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
       * format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setLastExecuteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (lastExecuteTimeBuilder_ == null) {
          lastExecuteTime_ = builderForValue.build();
        } else {
          lastExecuteTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The last time a patch job was started by this deployment.
       * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
       * format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeLastExecuteTime(com.google.protobuf.Timestamp value) {
        if (lastExecuteTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000200) != 0)
              && lastExecuteTime_ != null
              && lastExecuteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getLastExecuteTimeBuilder().mergeFrom(value);
          } else {
            lastExecuteTime_ = value;
          }
        } else {
          lastExecuteTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The last time a patch job was started by this deployment.
       * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
       * format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearLastExecuteTime() {
        bitField0_ = (bitField0_ & ~0x00000200);
        lastExecuteTime_ = null;
        if (lastExecuteTimeBuilder_ != null) {
          lastExecuteTimeBuilder_.dispose();
          lastExecuteTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The last time a patch job was started by this deployment.
       * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
       * format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getLastExecuteTimeBuilder() {
        bitField0_ |= 0x00000200;
        onChanged();
        return getLastExecuteTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The last time a patch job was started by this deployment.
       * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
       * format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getLastExecuteTimeOrBuilder() {
        if (lastExecuteTimeBuilder_ != null) {
          return lastExecuteTimeBuilder_.getMessageOrBuilder();
        } else {
          return lastExecuteTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastExecuteTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The last time a patch job was started by this deployment.
       * Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text
       * format.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getLastExecuteTimeFieldBuilder() {
        if (lastExecuteTimeBuilder_ == null) {
          lastExecuteTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getLastExecuteTime(), getParentForChildren(), isClean());
          lastExecuteTime_ = null;
        }
        return lastExecuteTimeBuilder_;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.PatchRollout rollout_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchRollout,
              com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder>
          rolloutBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Rollout strategy of the patch job.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the rollout field is set.
       */
      public boolean hasRollout() {
        return ((bitField0_ & 0x00000400) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Rollout strategy of the patch job.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The rollout.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchRollout getRollout() {
        if (rolloutBuilder_ == null) {
          return rollout_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()
              : rollout_;
        } else {
          return rolloutBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Rollout strategy of the patch job.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRollout(com.google.cloud.osconfig.v1.PatchJobs.PatchRollout value) {
        if (rolloutBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rollout_ = value;
        } else {
          rolloutBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Rollout strategy of the patch job.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRollout(
          com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder builderForValue) {
        if (rolloutBuilder_ == null) {
          rollout_ = builderForValue.build();
        } else {
          rolloutBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Rollout strategy of the patch job.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeRollout(com.google.cloud.osconfig.v1.PatchJobs.PatchRollout value) {
        if (rolloutBuilder_ == null) {
          if (((bitField0_ & 0x00000400) != 0)
              && rollout_ != null
              && rollout_
                  != com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()) {
            getRolloutBuilder().mergeFrom(value);
          } else {
            rollout_ = value;
          }
        } else {
          rolloutBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Rollout strategy of the patch job.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearRollout() {
        bitField0_ = (bitField0_ & ~0x00000400);
        rollout_ = null;
        if (rolloutBuilder_ != null) {
          rolloutBuilder_.dispose();
          rolloutBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Rollout strategy of the patch job.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder getRolloutBuilder() {
        bitField0_ |= 0x00000400;
        onChanged();
        return getRolloutFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Rollout strategy of the patch job.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder getRolloutOrBuilder() {
        if (rolloutBuilder_ != null) {
          return rolloutBuilder_.getMessageOrBuilder();
        } else {
          return rollout_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()
              : rollout_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Rollout strategy of the patch job.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchRollout rollout = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchRollout,
              com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder>
          getRolloutFieldBuilder() {
        if (rolloutBuilder_ == null) {
          rolloutBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.PatchRollout,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder>(
                  getRollout(), getParentForChildren(), isClean());
          rollout_ = null;
        }
        return rolloutBuilder_;
      }

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. Current state of the patch deployment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Current state of the patch deployment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Current state of the patch deployment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.State getState() {
        com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.State result =
            com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.State.forNumber(state_);
        return result == null
            ? com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.State.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. Current state of the patch deployment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000800;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Current state of the patch deployment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000800);
        state_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.PatchDeployment)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.PatchDeployment)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PatchDeployment> PARSER =
        new com.google.protobuf.AbstractParser<PatchDeployment>() {
          @java.lang.Override
          public PatchDeployment parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PatchDeployment> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PatchDeployment> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OneTimeScheduleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.OneTimeSchedule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The desired patch job execution time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the executeTime field is set.
     */
    boolean hasExecuteTime();
    /**
     *
     *
     * <pre>
     * Required. The desired patch job execution time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The executeTime.
     */
    com.google.protobuf.Timestamp getExecuteTime();
    /**
     *
     *
     * <pre>
     * Required. The desired patch job execution time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getExecuteTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Sets the time for a one time patch deployment. Timestamp is in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.OneTimeSchedule}
   */
  public static final class OneTimeSchedule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.OneTimeSchedule)
      OneTimeScheduleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OneTimeSchedule.newBuilder() to construct.
    private OneTimeSchedule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OneTimeSchedule() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OneTimeSchedule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_OneTimeSchedule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_OneTimeSchedule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.class,
              com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.Builder.class);
    }

    public static final int EXECUTE_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp executeTime_;
    /**
     *
     *
     * <pre>
     * Required. The desired patch job execution time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the executeTime field is set.
     */
    @java.lang.Override
    public boolean hasExecuteTime() {
      return executeTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired patch job execution time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The executeTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getExecuteTime() {
      return executeTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : executeTime_;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired patch job execution time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getExecuteTimeOrBuilder() {
      return executeTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : executeTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (executeTime_ != null) {
        output.writeMessage(1, getExecuteTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (executeTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getExecuteTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule other =
          (com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule) obj;

      if (hasExecuteTime() != other.hasExecuteTime()) return false;
      if (hasExecuteTime()) {
        if (!getExecuteTime().equals(other.getExecuteTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasExecuteTime()) {
        hash = (37 * hash) + EXECUTE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getExecuteTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Sets the time for a one time patch deployment. Timestamp is in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.OneTimeSchedule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.OneTimeSchedule)
        com.google.cloud.osconfig.v1.PatchDeployments.OneTimeScheduleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_OneTimeSchedule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_OneTimeSchedule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.class,
                com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        executeTime_ = null;
        if (executeTimeBuilder_ != null) {
          executeTimeBuilder_.dispose();
          executeTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_OneTimeSchedule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule build() {
        com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule result =
            new com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.executeTime_ =
              executeTimeBuilder_ == null ? executeTime_ : executeTimeBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule.getDefaultInstance())
          return this;
        if (other.hasExecuteTime()) {
          mergeExecuteTime(other.getExecuteTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getExecuteTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp executeTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          executeTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The desired patch job execution time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the executeTime field is set.
       */
      public boolean hasExecuteTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The desired patch job execution time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The executeTime.
       */
      public com.google.protobuf.Timestamp getExecuteTime() {
        if (executeTimeBuilder_ == null) {
          return executeTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : executeTime_;
        } else {
          return executeTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The desired patch job execution time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setExecuteTime(com.google.protobuf.Timestamp value) {
        if (executeTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          executeTime_ = value;
        } else {
          executeTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The desired patch job execution time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setExecuteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (executeTimeBuilder_ == null) {
          executeTime_ = builderForValue.build();
        } else {
          executeTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The desired patch job execution time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeExecuteTime(com.google.protobuf.Timestamp value) {
        if (executeTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && executeTime_ != null
              && executeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getExecuteTimeBuilder().mergeFrom(value);
          } else {
            executeTime_ = value;
          }
        } else {
          executeTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The desired patch job execution time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearExecuteTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        executeTime_ = null;
        if (executeTimeBuilder_ != null) {
          executeTimeBuilder_.dispose();
          executeTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The desired patch job execution time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getExecuteTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getExecuteTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The desired patch job execution time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getExecuteTimeOrBuilder() {
        if (executeTimeBuilder_ != null) {
          return executeTimeBuilder_.getMessageOrBuilder();
        } else {
          return executeTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : executeTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The desired patch job execution time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp execute_time = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getExecuteTimeFieldBuilder() {
        if (executeTimeBuilder_ == null) {
          executeTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getExecuteTime(), getParentForChildren(), isClean());
          executeTime_ = null;
        }
        return executeTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.OneTimeSchedule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.OneTimeSchedule)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OneTimeSchedule> PARSER =
        new com.google.protobuf.AbstractParser<OneTimeSchedule>() {
          @java.lang.Override
          public OneTimeSchedule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OneTimeSchedule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OneTimeSchedule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.OneTimeSchedule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RecurringScheduleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.RecurringSchedule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Defines the time zone that `time_of_day` is relative to.
     * The rules for daylight saving time are determined by the chosen time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the timeZone field is set.
     */
    boolean hasTimeZone();
    /**
     *
     *
     * <pre>
     * Required. Defines the time zone that `time_of_day` is relative to.
     * The rules for daylight saving time are determined by the chosen time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The timeZone.
     */
    com.google.type.TimeZone getTimeZone();
    /**
     *
     *
     * <pre>
     * Required. Defines the time zone that `time_of_day` is relative to.
     * The rules for daylight saving time are determined by the chosen time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    com.google.type.TimeZoneOrBuilder getTimeZoneOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. The time that the recurring schedule becomes effective.
     * Defaults to `create_time` of the patch deployment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    boolean hasStartTime();
    /**
     *
     *
     * <pre>
     * Optional. The time that the recurring schedule becomes effective.
     * Defaults to `create_time` of the patch deployment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The startTime.
     */
    com.google.protobuf.Timestamp getStartTime();
    /**
     *
     *
     * <pre>
     * Optional. The time that the recurring schedule becomes effective.
     * Defaults to `create_time` of the patch deployment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. The end time at which a recurring patch deployment schedule is no
     * longer active.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    boolean hasEndTime();
    /**
     *
     *
     * <pre>
     * Optional. The end time at which a recurring patch deployment schedule is no
     * longer active.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The endTime.
     */
    com.google.protobuf.Timestamp getEndTime();
    /**
     *
     *
     * <pre>
     * Optional. The end time at which a recurring patch deployment schedule is no
     * longer active.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Time of the day to run a recurring deployment.
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the timeOfDay field is set.
     */
    boolean hasTimeOfDay();
    /**
     *
     *
     * <pre>
     * Required. Time of the day to run a recurring deployment.
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The timeOfDay.
     */
    com.google.type.TimeOfDay getTimeOfDay();
    /**
     *
     *
     * <pre>
     * Required. Time of the day to run a recurring deployment.
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.type.TimeOfDayOrBuilder getTimeOfDayOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. The frequency unit of this recurring schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.RecurringSchedule.Frequency frequency = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for frequency.
     */
    int getFrequencyValue();
    /**
     *
     *
     * <pre>
     * Required. The frequency unit of this recurring schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.RecurringSchedule.Frequency frequency = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The frequency.
     */
    com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Frequency getFrequency();

    /**
     *
     *
     * <pre>
     * Required. Schedule with weekly executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the weekly field is set.
     */
    boolean hasWeekly();
    /**
     *
     *
     * <pre>
     * Required. Schedule with weekly executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The weekly.
     */
    com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule getWeekly();
    /**
     *
     *
     * <pre>
     * Required. Schedule with weekly executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchDeployments.WeeklyScheduleOrBuilder getWeeklyOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Schedule with monthly executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the monthly field is set.
     */
    boolean hasMonthly();
    /**
     *
     *
     * <pre>
     * Required. Schedule with monthly executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The monthly.
     */
    com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule getMonthly();
    /**
     *
     *
     * <pre>
     * Required. Schedule with monthly executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchDeployments.MonthlyScheduleOrBuilder getMonthlyOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The time the last patch job ran successfully.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastExecuteTime field is set.
     */
    boolean hasLastExecuteTime();
    /**
     *
     *
     * <pre>
     * Output only. The time the last patch job ran successfully.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastExecuteTime.
     */
    com.google.protobuf.Timestamp getLastExecuteTime();
    /**
     *
     *
     * <pre>
     * Output only. The time the last patch job ran successfully.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getLastExecuteTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The time the next patch job is scheduled to run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the nextExecuteTime field is set.
     */
    boolean hasNextExecuteTime();
    /**
     *
     *
     * <pre>
     * Output only. The time the next patch job is scheduled to run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The nextExecuteTime.
     */
    com.google.protobuf.Timestamp getNextExecuteTime();
    /**
     *
     *
     * <pre>
     * Output only. The time the next patch job is scheduled to run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getNextExecuteTimeOrBuilder();

    com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.ScheduleConfigCase
        getScheduleConfigCase();
  }
  /**
   *
   *
   * <pre>
   * Sets the time for recurring patch deployments.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.RecurringSchedule}
   */
  public static final class RecurringSchedule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.RecurringSchedule)
      RecurringScheduleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RecurringSchedule.newBuilder() to construct.
    private RecurringSchedule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RecurringSchedule() {
      frequency_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RecurringSchedule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_RecurringSchedule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_RecurringSchedule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.class,
              com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Specifies the frequency of the recurring patch deployments.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.osconfig.v1.RecurringSchedule.Frequency}
     */
    public enum Frequency implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Invalid. A frequency must be specified.
       * </pre>
       *
       * <code>FREQUENCY_UNSPECIFIED = 0;</code>
       */
      FREQUENCY_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Indicates that the frequency of recurrence should be expressed in terms
       * of weeks.
       * </pre>
       *
       * <code>WEEKLY = 1;</code>
       */
      WEEKLY(1),
      /**
       *
       *
       * <pre>
       * Indicates that the frequency of recurrence should be expressed in terms
       * of months.
       * </pre>
       *
       * <code>MONTHLY = 2;</code>
       */
      MONTHLY(2),
      /**
       *
       *
       * <pre>
       * Indicates that the frequency of recurrence should be expressed in terms
       * of days.
       * </pre>
       *
       * <code>DAILY = 3;</code>
       */
      DAILY(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Invalid. A frequency must be specified.
       * </pre>
       *
       * <code>FREQUENCY_UNSPECIFIED = 0;</code>
       */
      public static final int FREQUENCY_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Indicates that the frequency of recurrence should be expressed in terms
       * of weeks.
       * </pre>
       *
       * <code>WEEKLY = 1;</code>
       */
      public static final int WEEKLY_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Indicates that the frequency of recurrence should be expressed in terms
       * of months.
       * </pre>
       *
       * <code>MONTHLY = 2;</code>
       */
      public static final int MONTHLY_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Indicates that the frequency of recurrence should be expressed in terms
       * of days.
       * </pre>
       *
       * <code>DAILY = 3;</code>
       */
      public static final int DAILY_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Frequency valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Frequency forNumber(int value) {
        switch (value) {
          case 0:
            return FREQUENCY_UNSPECIFIED;
          case 1:
            return WEEKLY;
          case 2:
            return MONTHLY;
          case 3:
            return DAILY;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Frequency> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Frequency> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Frequency>() {
            public Frequency findValueByNumber(int number) {
              return Frequency.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Frequency[] VALUES = values();

      public static Frequency valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Frequency(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.RecurringSchedule.Frequency)
    }

    private int scheduleConfigCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object scheduleConfig_;

    public enum ScheduleConfigCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      WEEKLY(6),
      MONTHLY(7),
      SCHEDULECONFIG_NOT_SET(0);
      private final int value;

      private ScheduleConfigCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ScheduleConfigCase valueOf(int value) {
        return forNumber(value);
      }

      public static ScheduleConfigCase forNumber(int value) {
        switch (value) {
          case 6:
            return WEEKLY;
          case 7:
            return MONTHLY;
          case 0:
            return SCHEDULECONFIG_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ScheduleConfigCase getScheduleConfigCase() {
      return ScheduleConfigCase.forNumber(scheduleConfigCase_);
    }

    public static final int TIME_ZONE_FIELD_NUMBER = 1;
    private com.google.type.TimeZone timeZone_;
    /**
     *
     *
     * <pre>
     * Required. Defines the time zone that `time_of_day` is relative to.
     * The rules for daylight saving time are determined by the chosen time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the timeZone field is set.
     */
    @java.lang.Override
    public boolean hasTimeZone() {
      return timeZone_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the time zone that `time_of_day` is relative to.
     * The rules for daylight saving time are determined by the chosen time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The timeZone.
     */
    @java.lang.Override
    public com.google.type.TimeZone getTimeZone() {
      return timeZone_ == null ? com.google.type.TimeZone.getDefaultInstance() : timeZone_;
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the time zone that `time_of_day` is relative to.
     * The rules for daylight saving time are determined by the chosen time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public com.google.type.TimeZoneOrBuilder getTimeZoneOrBuilder() {
      return timeZone_ == null ? com.google.type.TimeZone.getDefaultInstance() : timeZone_;
    }

    public static final int START_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp startTime_;
    /**
     *
     *
     * <pre>
     * Optional. The time that the recurring schedule becomes effective.
     * Defaults to `create_time` of the patch deployment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    @java.lang.Override
    public boolean hasStartTime() {
      return startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time that the recurring schedule becomes effective.
     * Defaults to `create_time` of the patch deployment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The startTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStartTime() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time that the recurring schedule becomes effective.
     * Defaults to `create_time` of the patch deployment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }

    public static final int END_TIME_FIELD_NUMBER = 3;
    private com.google.protobuf.Timestamp endTime_;
    /**
     *
     *
     * <pre>
     * Optional. The end time at which a recurring patch deployment schedule is no
     * longer active.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    @java.lang.Override
    public boolean hasEndTime() {
      return endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The end time at which a recurring patch deployment schedule is no
     * longer active.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The endTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEndTime() {
      return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The end time at which a recurring patch deployment schedule is no
     * longer active.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
    }

    public static final int TIME_OF_DAY_FIELD_NUMBER = 4;
    private com.google.type.TimeOfDay timeOfDay_;
    /**
     *
     *
     * <pre>
     * Required. Time of the day to run a recurring deployment.
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the timeOfDay field is set.
     */
    @java.lang.Override
    public boolean hasTimeOfDay() {
      return timeOfDay_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Time of the day to run a recurring deployment.
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The timeOfDay.
     */
    @java.lang.Override
    public com.google.type.TimeOfDay getTimeOfDay() {
      return timeOfDay_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : timeOfDay_;
    }
    /**
     *
     *
     * <pre>
     * Required. Time of the day to run a recurring deployment.
     * </pre>
     *
     * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.type.TimeOfDayOrBuilder getTimeOfDayOrBuilder() {
      return timeOfDay_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : timeOfDay_;
    }

    public static final int FREQUENCY_FIELD_NUMBER = 5;
    private int frequency_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The frequency unit of this recurring schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.RecurringSchedule.Frequency frequency = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for frequency.
     */
    @java.lang.Override
    public int getFrequencyValue() {
      return frequency_;
    }
    /**
     *
     *
     * <pre>
     * Required. The frequency unit of this recurring schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.RecurringSchedule.Frequency frequency = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The frequency.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Frequency
        getFrequency() {
      com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Frequency result =
          com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Frequency.forNumber(
              frequency_);
      return result == null
          ? com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Frequency.UNRECOGNIZED
          : result;
    }

    public static final int WEEKLY_FIELD_NUMBER = 6;
    /**
     *
     *
     * <pre>
     * Required. Schedule with weekly executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the weekly field is set.
     */
    @java.lang.Override
    public boolean hasWeekly() {
      return scheduleConfigCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule with weekly executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The weekly.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule getWeekly() {
      if (scheduleConfigCase_ == 6) {
        return (com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule) scheduleConfig_;
      }
      return com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule with weekly executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.WeeklyScheduleOrBuilder
        getWeeklyOrBuilder() {
      if (scheduleConfigCase_ == 6) {
        return (com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule) scheduleConfig_;
      }
      return com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.getDefaultInstance();
    }

    public static final int MONTHLY_FIELD_NUMBER = 7;
    /**
     *
     *
     * <pre>
     * Required. Schedule with monthly executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the monthly field is set.
     */
    @java.lang.Override
    public boolean hasMonthly() {
      return scheduleConfigCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule with monthly executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The monthly.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule getMonthly() {
      if (scheduleConfigCase_ == 7) {
        return (com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule) scheduleConfig_;
      }
      return com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Required. Schedule with monthly executions.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.MonthlyScheduleOrBuilder
        getMonthlyOrBuilder() {
      if (scheduleConfigCase_ == 7) {
        return (com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule) scheduleConfig_;
      }
      return com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.getDefaultInstance();
    }

    public static final int LAST_EXECUTE_TIME_FIELD_NUMBER = 9;
    private com.google.protobuf.Timestamp lastExecuteTime_;
    /**
     *
     *
     * <pre>
     * Output only. The time the last patch job ran successfully.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastExecuteTime field is set.
     */
    @java.lang.Override
    public boolean hasLastExecuteTime() {
      return lastExecuteTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the last patch job ran successfully.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastExecuteTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getLastExecuteTime() {
      return lastExecuteTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : lastExecuteTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the last patch job ran successfully.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getLastExecuteTimeOrBuilder() {
      return lastExecuteTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : lastExecuteTime_;
    }

    public static final int NEXT_EXECUTE_TIME_FIELD_NUMBER = 10;
    private com.google.protobuf.Timestamp nextExecuteTime_;
    /**
     *
     *
     * <pre>
     * Output only. The time the next patch job is scheduled to run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the nextExecuteTime field is set.
     */
    @java.lang.Override
    public boolean hasNextExecuteTime() {
      return nextExecuteTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the next patch job is scheduled to run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The nextExecuteTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getNextExecuteTime() {
      return nextExecuteTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : nextExecuteTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the next patch job is scheduled to run.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getNextExecuteTimeOrBuilder() {
      return nextExecuteTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : nextExecuteTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (timeZone_ != null) {
        output.writeMessage(1, getTimeZone());
      }
      if (startTime_ != null) {
        output.writeMessage(2, getStartTime());
      }
      if (endTime_ != null) {
        output.writeMessage(3, getEndTime());
      }
      if (timeOfDay_ != null) {
        output.writeMessage(4, getTimeOfDay());
      }
      if (frequency_
          != com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Frequency
              .FREQUENCY_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(5, frequency_);
      }
      if (scheduleConfigCase_ == 6) {
        output.writeMessage(
            6, (com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule) scheduleConfig_);
      }
      if (scheduleConfigCase_ == 7) {
        output.writeMessage(
            7, (com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule) scheduleConfig_);
      }
      if (lastExecuteTime_ != null) {
        output.writeMessage(9, getLastExecuteTime());
      }
      if (nextExecuteTime_ != null) {
        output.writeMessage(10, getNextExecuteTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (timeZone_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTimeZone());
      }
      if (startTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStartTime());
      }
      if (endTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEndTime());
      }
      if (timeOfDay_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTimeOfDay());
      }
      if (frequency_
          != com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Frequency
              .FREQUENCY_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, frequency_);
      }
      if (scheduleConfigCase_ == 6) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6, (com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule) scheduleConfig_);
      }
      if (scheduleConfigCase_ == 7) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                7, (com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule) scheduleConfig_);
      }
      if (lastExecuteTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getLastExecuteTime());
      }
      if (nextExecuteTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getNextExecuteTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule other =
          (com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule) obj;

      if (hasTimeZone() != other.hasTimeZone()) return false;
      if (hasTimeZone()) {
        if (!getTimeZone().equals(other.getTimeZone())) return false;
      }
      if (hasStartTime() != other.hasStartTime()) return false;
      if (hasStartTime()) {
        if (!getStartTime().equals(other.getStartTime())) return false;
      }
      if (hasEndTime() != other.hasEndTime()) return false;
      if (hasEndTime()) {
        if (!getEndTime().equals(other.getEndTime())) return false;
      }
      if (hasTimeOfDay() != other.hasTimeOfDay()) return false;
      if (hasTimeOfDay()) {
        if (!getTimeOfDay().equals(other.getTimeOfDay())) return false;
      }
      if (frequency_ != other.frequency_) return false;
      if (hasLastExecuteTime() != other.hasLastExecuteTime()) return false;
      if (hasLastExecuteTime()) {
        if (!getLastExecuteTime().equals(other.getLastExecuteTime())) return false;
      }
      if (hasNextExecuteTime() != other.hasNextExecuteTime()) return false;
      if (hasNextExecuteTime()) {
        if (!getNextExecuteTime().equals(other.getNextExecuteTime())) return false;
      }
      if (!getScheduleConfigCase().equals(other.getScheduleConfigCase())) return false;
      switch (scheduleConfigCase_) {
        case 6:
          if (!getWeekly().equals(other.getWeekly())) return false;
          break;
        case 7:
          if (!getMonthly().equals(other.getMonthly())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTimeZone()) {
        hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
        hash = (53 * hash) + getTimeZone().hashCode();
      }
      if (hasStartTime()) {
        hash = (37 * hash) + START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartTime().hashCode();
      }
      if (hasEndTime()) {
        hash = (37 * hash) + END_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEndTime().hashCode();
      }
      if (hasTimeOfDay()) {
        hash = (37 * hash) + TIME_OF_DAY_FIELD_NUMBER;
        hash = (53 * hash) + getTimeOfDay().hashCode();
      }
      hash = (37 * hash) + FREQUENCY_FIELD_NUMBER;
      hash = (53 * hash) + frequency_;
      if (hasLastExecuteTime()) {
        hash = (37 * hash) + LAST_EXECUTE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getLastExecuteTime().hashCode();
      }
      if (hasNextExecuteTime()) {
        hash = (37 * hash) + NEXT_EXECUTE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getNextExecuteTime().hashCode();
      }
      switch (scheduleConfigCase_) {
        case 6:
          hash = (37 * hash) + WEEKLY_FIELD_NUMBER;
          hash = (53 * hash) + getWeekly().hashCode();
          break;
        case 7:
          hash = (37 * hash) + MONTHLY_FIELD_NUMBER;
          hash = (53 * hash) + getMonthly().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Sets the time for recurring patch deployments.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.RecurringSchedule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.RecurringSchedule)
        com.google.cloud.osconfig.v1.PatchDeployments.RecurringScheduleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_RecurringSchedule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_RecurringSchedule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.class,
                com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Builder.class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        timeZone_ = null;
        if (timeZoneBuilder_ != null) {
          timeZoneBuilder_.dispose();
          timeZoneBuilder_ = null;
        }
        startTime_ = null;
        if (startTimeBuilder_ != null) {
          startTimeBuilder_.dispose();
          startTimeBuilder_ = null;
        }
        endTime_ = null;
        if (endTimeBuilder_ != null) {
          endTimeBuilder_.dispose();
          endTimeBuilder_ = null;
        }
        timeOfDay_ = null;
        if (timeOfDayBuilder_ != null) {
          timeOfDayBuilder_.dispose();
          timeOfDayBuilder_ = null;
        }
        frequency_ = 0;
        if (weeklyBuilder_ != null) {
          weeklyBuilder_.clear();
        }
        if (monthlyBuilder_ != null) {
          monthlyBuilder_.clear();
        }
        lastExecuteTime_ = null;
        if (lastExecuteTimeBuilder_ != null) {
          lastExecuteTimeBuilder_.dispose();
          lastExecuteTimeBuilder_ = null;
        }
        nextExecuteTime_ = null;
        if (nextExecuteTimeBuilder_ != null) {
          nextExecuteTimeBuilder_.dispose();
          nextExecuteTimeBuilder_ = null;
        }
        scheduleConfigCase_ = 0;
        scheduleConfig_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_RecurringSchedule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule build() {
        com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule result =
            new com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.timeZone_ = timeZoneBuilder_ == null ? timeZone_ : timeZoneBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.timeOfDay_ = timeOfDayBuilder_ == null ? timeOfDay_ : timeOfDayBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.frequency_ = frequency_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.lastExecuteTime_ =
              lastExecuteTimeBuilder_ == null ? lastExecuteTime_ : lastExecuteTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.nextExecuteTime_ =
              nextExecuteTimeBuilder_ == null ? nextExecuteTime_ : nextExecuteTimeBuilder_.build();
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule result) {
        result.scheduleConfigCase_ = scheduleConfigCase_;
        result.scheduleConfig_ = this.scheduleConfig_;
        if (scheduleConfigCase_ == 6 && weeklyBuilder_ != null) {
          result.scheduleConfig_ = weeklyBuilder_.build();
        }
        if (scheduleConfigCase_ == 7 && monthlyBuilder_ != null) {
          result.scheduleConfig_ = monthlyBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.getDefaultInstance())
          return this;
        if (other.hasTimeZone()) {
          mergeTimeZone(other.getTimeZone());
        }
        if (other.hasStartTime()) {
          mergeStartTime(other.getStartTime());
        }
        if (other.hasEndTime()) {
          mergeEndTime(other.getEndTime());
        }
        if (other.hasTimeOfDay()) {
          mergeTimeOfDay(other.getTimeOfDay());
        }
        if (other.frequency_ != 0) {
          setFrequencyValue(other.getFrequencyValue());
        }
        if (other.hasLastExecuteTime()) {
          mergeLastExecuteTime(other.getLastExecuteTime());
        }
        if (other.hasNextExecuteTime()) {
          mergeNextExecuteTime(other.getNextExecuteTime());
        }
        switch (other.getScheduleConfigCase()) {
          case WEEKLY:
            {
              mergeWeekly(other.getWeekly());
              break;
            }
          case MONTHLY:
            {
              mergeMonthly(other.getMonthly());
              break;
            }
          case SCHEDULECONFIG_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getTimeZoneFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getTimeOfDayFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 40:
                {
                  frequency_ = input.readEnum();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              case 50:
                {
                  input.readMessage(getWeeklyFieldBuilder().getBuilder(), extensionRegistry);
                  scheduleConfigCase_ = 6;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(getMonthlyFieldBuilder().getBuilder(), extensionRegistry);
                  scheduleConfigCase_ = 7;
                  break;
                } // case 58
              case 74:
                {
                  input.readMessage(
                      getLastExecuteTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 74
              case 82:
                {
                  input.readMessage(
                      getNextExecuteTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000100;
                  break;
                } // case 82
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int scheduleConfigCase_ = 0;
      private java.lang.Object scheduleConfig_;

      public ScheduleConfigCase getScheduleConfigCase() {
        return ScheduleConfigCase.forNumber(scheduleConfigCase_);
      }

      public Builder clearScheduleConfig() {
        scheduleConfigCase_ = 0;
        scheduleConfig_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.type.TimeZone timeZone_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.TimeZone,
              com.google.type.TimeZone.Builder,
              com.google.type.TimeZoneOrBuilder>
          timeZoneBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Defines the time zone that `time_of_day` is relative to.
       * The rules for daylight saving time are determined by the chosen time zone.
       * </pre>
       *
       * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return Whether the timeZone field is set.
       */
      public boolean hasTimeZone() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Defines the time zone that `time_of_day` is relative to.
       * The rules for daylight saving time are determined by the chosen time zone.
       * </pre>
       *
       * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The timeZone.
       */
      public com.google.type.TimeZone getTimeZone() {
        if (timeZoneBuilder_ == null) {
          return timeZone_ == null ? com.google.type.TimeZone.getDefaultInstance() : timeZone_;
        } else {
          return timeZoneBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Defines the time zone that `time_of_day` is relative to.
       * The rules for daylight saving time are determined by the chosen time zone.
       * </pre>
       *
       * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder setTimeZone(com.google.type.TimeZone value) {
        if (timeZoneBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timeZone_ = value;
        } else {
          timeZoneBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Defines the time zone that `time_of_day` is relative to.
       * The rules for daylight saving time are determined by the chosen time zone.
       * </pre>
       *
       * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder setTimeZone(com.google.type.TimeZone.Builder builderForValue) {
        if (timeZoneBuilder_ == null) {
          timeZone_ = builderForValue.build();
        } else {
          timeZoneBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Defines the time zone that `time_of_day` is relative to.
       * The rules for daylight saving time are determined by the chosen time zone.
       * </pre>
       *
       * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder mergeTimeZone(com.google.type.TimeZone value) {
        if (timeZoneBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && timeZone_ != null
              && timeZone_ != com.google.type.TimeZone.getDefaultInstance()) {
            getTimeZoneBuilder().mergeFrom(value);
          } else {
            timeZone_ = value;
          }
        } else {
          timeZoneBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Defines the time zone that `time_of_day` is relative to.
       * The rules for daylight saving time are determined by the chosen time zone.
       * </pre>
       *
       * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder clearTimeZone() {
        bitField0_ = (bitField0_ & ~0x00000001);
        timeZone_ = null;
        if (timeZoneBuilder_ != null) {
          timeZoneBuilder_.dispose();
          timeZoneBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Defines the time zone that `time_of_day` is relative to.
       * The rules for daylight saving time are determined by the chosen time zone.
       * </pre>
       *
       * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public com.google.type.TimeZone.Builder getTimeZoneBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getTimeZoneFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Defines the time zone that `time_of_day` is relative to.
       * The rules for daylight saving time are determined by the chosen time zone.
       * </pre>
       *
       * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public com.google.type.TimeZoneOrBuilder getTimeZoneOrBuilder() {
        if (timeZoneBuilder_ != null) {
          return timeZoneBuilder_.getMessageOrBuilder();
        } else {
          return timeZone_ == null ? com.google.type.TimeZone.getDefaultInstance() : timeZone_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Defines the time zone that `time_of_day` is relative to.
       * The rules for daylight saving time are determined by the chosen time zone.
       * </pre>
       *
       * <code>.google.type.TimeZone time_zone = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.TimeZone,
              com.google.type.TimeZone.Builder,
              com.google.type.TimeZoneOrBuilder>
          getTimeZoneFieldBuilder() {
        if (timeZoneBuilder_ == null) {
          timeZoneBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.TimeZone,
                  com.google.type.TimeZone.Builder,
                  com.google.type.TimeZoneOrBuilder>(
                  getTimeZone(), getParentForChildren(), isClean());
          timeZone_ = null;
        }
        return timeZoneBuilder_;
      }

      private com.google.protobuf.Timestamp startTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          startTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. The time that the recurring schedule becomes effective.
       * Defaults to `create_time` of the patch deployment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the startTime field is set.
       */
      public boolean hasStartTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The time that the recurring schedule becomes effective.
       * Defaults to `create_time` of the patch deployment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The startTime.
       */
      public com.google.protobuf.Timestamp getStartTime() {
        if (startTimeBuilder_ == null) {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        } else {
          return startTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The time that the recurring schedule becomes effective.
       * Defaults to `create_time` of the patch deployment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTime_ = value;
        } else {
          startTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The time that the recurring schedule becomes effective.
       * Defaults to `create_time` of the patch deployment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (startTimeBuilder_ == null) {
          startTime_ = builderForValue.build();
        } else {
          startTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The time that the recurring schedule becomes effective.
       * Defaults to `create_time` of the patch deployment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && startTime_ != null
              && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getStartTimeBuilder().mergeFrom(value);
          } else {
            startTime_ = value;
          }
        } else {
          startTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The time that the recurring schedule becomes effective.
       * Defaults to `create_time` of the patch deployment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearStartTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        startTime_ = null;
        if (startTimeBuilder_ != null) {
          startTimeBuilder_.dispose();
          startTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The time that the recurring schedule becomes effective.
       * Defaults to `create_time` of the patch deployment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. The time that the recurring schedule becomes effective.
       * Defaults to `create_time` of the patch deployment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
        if (startTimeBuilder_ != null) {
          return startTimeBuilder_.getMessageOrBuilder();
        } else {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The time that the recurring schedule becomes effective.
       * Defaults to `create_time` of the patch deployment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStartTimeFieldBuilder() {
        if (startTimeBuilder_ == null) {
          startTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStartTime(), getParentForChildren(), isClean());
          startTime_ = null;
        }
        return startTimeBuilder_;
      }

      private com.google.protobuf.Timestamp endTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          endTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. The end time at which a recurring patch deployment schedule is no
       * longer active.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the endTime field is set.
       */
      public boolean hasEndTime() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The end time at which a recurring patch deployment schedule is no
       * longer active.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The endTime.
       */
      public com.google.protobuf.Timestamp getEndTime() {
        if (endTimeBuilder_ == null) {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        } else {
          return endTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The end time at which a recurring patch deployment schedule is no
       * longer active.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endTime_ = value;
        } else {
          endTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The end time at which a recurring patch deployment schedule is no
       * longer active.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (endTimeBuilder_ == null) {
          endTime_ = builderForValue.build();
        } else {
          endTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The end time at which a recurring patch deployment schedule is no
       * longer active.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && endTime_ != null
              && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getEndTimeBuilder().mergeFrom(value);
          } else {
            endTime_ = value;
          }
        } else {
          endTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The end time at which a recurring patch deployment schedule is no
       * longer active.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearEndTime() {
        bitField0_ = (bitField0_ & ~0x00000004);
        endTime_ = null;
        if (endTimeBuilder_ != null) {
          endTimeBuilder_.dispose();
          endTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The end time at which a recurring patch deployment schedule is no
       * longer active.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getEndTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. The end time at which a recurring patch deployment schedule is no
       * longer active.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
        if (endTimeBuilder_ != null) {
          return endTimeBuilder_.getMessageOrBuilder();
        } else {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The end time at which a recurring patch deployment schedule is no
       * longer active.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEndTimeFieldBuilder() {
        if (endTimeBuilder_ == null) {
          endTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEndTime(), getParentForChildren(), isClean());
          endTime_ = null;
        }
        return endTimeBuilder_;
      }

      private com.google.type.TimeOfDay timeOfDay_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.TimeOfDay,
              com.google.type.TimeOfDay.Builder,
              com.google.type.TimeOfDayOrBuilder>
          timeOfDayBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Time of the day to run a recurring deployment.
       * </pre>
       *
       * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the timeOfDay field is set.
       */
      public boolean hasTimeOfDay() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Time of the day to run a recurring deployment.
       * </pre>
       *
       * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The timeOfDay.
       */
      public com.google.type.TimeOfDay getTimeOfDay() {
        if (timeOfDayBuilder_ == null) {
          return timeOfDay_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : timeOfDay_;
        } else {
          return timeOfDayBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Time of the day to run a recurring deployment.
       * </pre>
       *
       * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setTimeOfDay(com.google.type.TimeOfDay value) {
        if (timeOfDayBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timeOfDay_ = value;
        } else {
          timeOfDayBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Time of the day to run a recurring deployment.
       * </pre>
       *
       * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setTimeOfDay(com.google.type.TimeOfDay.Builder builderForValue) {
        if (timeOfDayBuilder_ == null) {
          timeOfDay_ = builderForValue.build();
        } else {
          timeOfDayBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Time of the day to run a recurring deployment.
       * </pre>
       *
       * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeTimeOfDay(com.google.type.TimeOfDay value) {
        if (timeOfDayBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && timeOfDay_ != null
              && timeOfDay_ != com.google.type.TimeOfDay.getDefaultInstance()) {
            getTimeOfDayBuilder().mergeFrom(value);
          } else {
            timeOfDay_ = value;
          }
        } else {
          timeOfDayBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Time of the day to run a recurring deployment.
       * </pre>
       *
       * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearTimeOfDay() {
        bitField0_ = (bitField0_ & ~0x00000008);
        timeOfDay_ = null;
        if (timeOfDayBuilder_ != null) {
          timeOfDayBuilder_.dispose();
          timeOfDayBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Time of the day to run a recurring deployment.
       * </pre>
       *
       * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.type.TimeOfDay.Builder getTimeOfDayBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getTimeOfDayFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Time of the day to run a recurring deployment.
       * </pre>
       *
       * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.type.TimeOfDayOrBuilder getTimeOfDayOrBuilder() {
        if (timeOfDayBuilder_ != null) {
          return timeOfDayBuilder_.getMessageOrBuilder();
        } else {
          return timeOfDay_ == null ? com.google.type.TimeOfDay.getDefaultInstance() : timeOfDay_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Time of the day to run a recurring deployment.
       * </pre>
       *
       * <code>.google.type.TimeOfDay time_of_day = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.TimeOfDay,
              com.google.type.TimeOfDay.Builder,
              com.google.type.TimeOfDayOrBuilder>
          getTimeOfDayFieldBuilder() {
        if (timeOfDayBuilder_ == null) {
          timeOfDayBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.TimeOfDay,
                  com.google.type.TimeOfDay.Builder,
                  com.google.type.TimeOfDayOrBuilder>(
                  getTimeOfDay(), getParentForChildren(), isClean());
          timeOfDay_ = null;
        }
        return timeOfDayBuilder_;
      }

      private int frequency_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The frequency unit of this recurring schedule.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule.Frequency frequency = 5 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for frequency.
       */
      @java.lang.Override
      public int getFrequencyValue() {
        return frequency_;
      }
      /**
       *
       *
       * <pre>
       * Required. The frequency unit of this recurring schedule.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule.Frequency frequency = 5 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for frequency to set.
       * @return This builder for chaining.
       */
      public Builder setFrequencyValue(int value) {
        frequency_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The frequency unit of this recurring schedule.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule.Frequency frequency = 5 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The frequency.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Frequency
          getFrequency() {
        com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Frequency result =
            com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Frequency.forNumber(
                frequency_);
        return result == null
            ? com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Frequency.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. The frequency unit of this recurring schedule.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule.Frequency frequency = 5 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The frequency to set.
       * @return This builder for chaining.
       */
      public Builder setFrequency(
          com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule.Frequency value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        frequency_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The frequency unit of this recurring schedule.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.RecurringSchedule.Frequency frequency = 5 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFrequency() {
        bitField0_ = (bitField0_ & ~0x00000010);
        frequency_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule,
              com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.WeeklyScheduleOrBuilder>
          weeklyBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Schedule with weekly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the weekly field is set.
       */
      @java.lang.Override
      public boolean hasWeekly() {
        return scheduleConfigCase_ == 6;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with weekly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The weekly.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule getWeekly() {
        if (weeklyBuilder_ == null) {
          if (scheduleConfigCase_ == 6) {
            return (com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule) scheduleConfig_;
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.getDefaultInstance();
        } else {
          if (scheduleConfigCase_ == 6) {
            return weeklyBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with weekly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setWeekly(com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule value) {
        if (weeklyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          scheduleConfig_ = value;
          onChanged();
        } else {
          weeklyBuilder_.setMessage(value);
        }
        scheduleConfigCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with weekly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setWeekly(
          com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.Builder builderForValue) {
        if (weeklyBuilder_ == null) {
          scheduleConfig_ = builderForValue.build();
          onChanged();
        } else {
          weeklyBuilder_.setMessage(builderForValue.build());
        }
        scheduleConfigCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with weekly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeWeekly(
          com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule value) {
        if (weeklyBuilder_ == null) {
          if (scheduleConfigCase_ == 6
              && scheduleConfig_
                  != com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule
                      .getDefaultInstance()) {
            scheduleConfig_ =
                com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.newBuilder(
                        (com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule)
                            scheduleConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            scheduleConfig_ = value;
          }
          onChanged();
        } else {
          if (scheduleConfigCase_ == 6) {
            weeklyBuilder_.mergeFrom(value);
          } else {
            weeklyBuilder_.setMessage(value);
          }
        }
        scheduleConfigCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with weekly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearWeekly() {
        if (weeklyBuilder_ == null) {
          if (scheduleConfigCase_ == 6) {
            scheduleConfigCase_ = 0;
            scheduleConfig_ = null;
            onChanged();
          }
        } else {
          if (scheduleConfigCase_ == 6) {
            scheduleConfigCase_ = 0;
            scheduleConfig_ = null;
          }
          weeklyBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with weekly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.Builder
          getWeeklyBuilder() {
        return getWeeklyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with weekly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.WeeklyScheduleOrBuilder
          getWeeklyOrBuilder() {
        if ((scheduleConfigCase_ == 6) && (weeklyBuilder_ != null)) {
          return weeklyBuilder_.getMessageOrBuilder();
        } else {
          if (scheduleConfigCase_ == 6) {
            return (com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule) scheduleConfig_;
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with weekly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeeklySchedule weekly = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule,
              com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.WeeklyScheduleOrBuilder>
          getWeeklyFieldBuilder() {
        if (weeklyBuilder_ == null) {
          if (!(scheduleConfigCase_ == 6)) {
            scheduleConfig_ =
                com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.getDefaultInstance();
          }
          weeklyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule,
                  com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.Builder,
                  com.google.cloud.osconfig.v1.PatchDeployments.WeeklyScheduleOrBuilder>(
                  (com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule) scheduleConfig_,
                  getParentForChildren(),
                  isClean());
          scheduleConfig_ = null;
        }
        scheduleConfigCase_ = 6;
        onChanged();
        return weeklyBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule,
              com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.MonthlyScheduleOrBuilder>
          monthlyBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Schedule with monthly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the monthly field is set.
       */
      @java.lang.Override
      public boolean hasMonthly() {
        return scheduleConfigCase_ == 7;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with monthly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The monthly.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule getMonthly() {
        if (monthlyBuilder_ == null) {
          if (scheduleConfigCase_ == 7) {
            return (com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule) scheduleConfig_;
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.getDefaultInstance();
        } else {
          if (scheduleConfigCase_ == 7) {
            return monthlyBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with monthly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMonthly(
          com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule value) {
        if (monthlyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          scheduleConfig_ = value;
          onChanged();
        } else {
          monthlyBuilder_.setMessage(value);
        }
        scheduleConfigCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with monthly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMonthly(
          com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.Builder builderForValue) {
        if (monthlyBuilder_ == null) {
          scheduleConfig_ = builderForValue.build();
          onChanged();
        } else {
          monthlyBuilder_.setMessage(builderForValue.build());
        }
        scheduleConfigCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with monthly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeMonthly(
          com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule value) {
        if (monthlyBuilder_ == null) {
          if (scheduleConfigCase_ == 7
              && scheduleConfig_
                  != com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule
                      .getDefaultInstance()) {
            scheduleConfig_ =
                com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.newBuilder(
                        (com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule)
                            scheduleConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            scheduleConfig_ = value;
          }
          onChanged();
        } else {
          if (scheduleConfigCase_ == 7) {
            monthlyBuilder_.mergeFrom(value);
          } else {
            monthlyBuilder_.setMessage(value);
          }
        }
        scheduleConfigCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with monthly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearMonthly() {
        if (monthlyBuilder_ == null) {
          if (scheduleConfigCase_ == 7) {
            scheduleConfigCase_ = 0;
            scheduleConfig_ = null;
            onChanged();
          }
        } else {
          if (scheduleConfigCase_ == 7) {
            scheduleConfigCase_ = 0;
            scheduleConfig_ = null;
          }
          monthlyBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with monthly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.Builder
          getMonthlyBuilder() {
        return getMonthlyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with monthly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.MonthlyScheduleOrBuilder
          getMonthlyOrBuilder() {
        if ((scheduleConfigCase_ == 7) && (monthlyBuilder_ != null)) {
          return monthlyBuilder_.getMessageOrBuilder();
        } else {
          if (scheduleConfigCase_ == 7) {
            return (com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule) scheduleConfig_;
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Schedule with monthly executions.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.MonthlySchedule monthly = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule,
              com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.MonthlyScheduleOrBuilder>
          getMonthlyFieldBuilder() {
        if (monthlyBuilder_ == null) {
          if (!(scheduleConfigCase_ == 7)) {
            scheduleConfig_ =
                com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.getDefaultInstance();
          }
          monthlyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule,
                  com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.Builder,
                  com.google.cloud.osconfig.v1.PatchDeployments.MonthlyScheduleOrBuilder>(
                  (com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule) scheduleConfig_,
                  getParentForChildren(),
                  isClean());
          scheduleConfig_ = null;
        }
        scheduleConfigCase_ = 7;
        onChanged();
        return monthlyBuilder_;
      }

      private com.google.protobuf.Timestamp lastExecuteTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          lastExecuteTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The time the last patch job ran successfully.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the lastExecuteTime field is set.
       */
      public boolean hasLastExecuteTime() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the last patch job ran successfully.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The lastExecuteTime.
       */
      public com.google.protobuf.Timestamp getLastExecuteTime() {
        if (lastExecuteTimeBuilder_ == null) {
          return lastExecuteTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastExecuteTime_;
        } else {
          return lastExecuteTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the last patch job ran successfully.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setLastExecuteTime(com.google.protobuf.Timestamp value) {
        if (lastExecuteTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastExecuteTime_ = value;
        } else {
          lastExecuteTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the last patch job ran successfully.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setLastExecuteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (lastExecuteTimeBuilder_ == null) {
          lastExecuteTime_ = builderForValue.build();
        } else {
          lastExecuteTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the last patch job ran successfully.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeLastExecuteTime(com.google.protobuf.Timestamp value) {
        if (lastExecuteTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && lastExecuteTime_ != null
              && lastExecuteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getLastExecuteTimeBuilder().mergeFrom(value);
          } else {
            lastExecuteTime_ = value;
          }
        } else {
          lastExecuteTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the last patch job ran successfully.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearLastExecuteTime() {
        bitField0_ = (bitField0_ & ~0x00000080);
        lastExecuteTime_ = null;
        if (lastExecuteTimeBuilder_ != null) {
          lastExecuteTimeBuilder_.dispose();
          lastExecuteTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the last patch job ran successfully.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getLastExecuteTimeBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getLastExecuteTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the last patch job ran successfully.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getLastExecuteTimeOrBuilder() {
        if (lastExecuteTimeBuilder_ != null) {
          return lastExecuteTimeBuilder_.getMessageOrBuilder();
        } else {
          return lastExecuteTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastExecuteTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the last patch job ran successfully.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp last_execute_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getLastExecuteTimeFieldBuilder() {
        if (lastExecuteTimeBuilder_ == null) {
          lastExecuteTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getLastExecuteTime(), getParentForChildren(), isClean());
          lastExecuteTime_ = null;
        }
        return lastExecuteTimeBuilder_;
      }

      private com.google.protobuf.Timestamp nextExecuteTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          nextExecuteTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The time the next patch job is scheduled to run.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the nextExecuteTime field is set.
       */
      public boolean hasNextExecuteTime() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the next patch job is scheduled to run.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The nextExecuteTime.
       */
      public com.google.protobuf.Timestamp getNextExecuteTime() {
        if (nextExecuteTimeBuilder_ == null) {
          return nextExecuteTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : nextExecuteTime_;
        } else {
          return nextExecuteTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the next patch job is scheduled to run.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setNextExecuteTime(com.google.protobuf.Timestamp value) {
        if (nextExecuteTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          nextExecuteTime_ = value;
        } else {
          nextExecuteTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the next patch job is scheduled to run.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setNextExecuteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (nextExecuteTimeBuilder_ == null) {
          nextExecuteTime_ = builderForValue.build();
        } else {
          nextExecuteTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the next patch job is scheduled to run.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeNextExecuteTime(com.google.protobuf.Timestamp value) {
        if (nextExecuteTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)
              && nextExecuteTime_ != null
              && nextExecuteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getNextExecuteTimeBuilder().mergeFrom(value);
          } else {
            nextExecuteTime_ = value;
          }
        } else {
          nextExecuteTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the next patch job is scheduled to run.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearNextExecuteTime() {
        bitField0_ = (bitField0_ & ~0x00000100);
        nextExecuteTime_ = null;
        if (nextExecuteTimeBuilder_ != null) {
          nextExecuteTimeBuilder_.dispose();
          nextExecuteTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the next patch job is scheduled to run.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getNextExecuteTimeBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getNextExecuteTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the next patch job is scheduled to run.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getNextExecuteTimeOrBuilder() {
        if (nextExecuteTimeBuilder_ != null) {
          return nextExecuteTimeBuilder_.getMessageOrBuilder();
        } else {
          return nextExecuteTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : nextExecuteTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The time the next patch job is scheduled to run.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp next_execute_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getNextExecuteTimeFieldBuilder() {
        if (nextExecuteTimeBuilder_ == null) {
          nextExecuteTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getNextExecuteTime(), getParentForChildren(), isClean());
          nextExecuteTime_ = null;
        }
        return nextExecuteTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.RecurringSchedule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.RecurringSchedule)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RecurringSchedule> PARSER =
        new com.google.protobuf.AbstractParser<RecurringSchedule>() {
          @java.lang.Override
          public RecurringSchedule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RecurringSchedule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RecurringSchedule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.RecurringSchedule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WeeklyScheduleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.WeeklySchedule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Day of the week.
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for dayOfWeek.
     */
    int getDayOfWeekValue();
    /**
     *
     *
     * <pre>
     * Required. Day of the week.
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The dayOfWeek.
     */
    com.google.type.DayOfWeek getDayOfWeek();
  }
  /**
   *
   *
   * <pre>
   * Represents a weekly schedule.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.WeeklySchedule}
   */
  public static final class WeeklySchedule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.WeeklySchedule)
      WeeklyScheduleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WeeklySchedule.newBuilder() to construct.
    private WeeklySchedule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WeeklySchedule() {
      dayOfWeek_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WeeklySchedule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_WeeklySchedule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_WeeklySchedule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.class,
              com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.Builder.class);
    }

    public static final int DAY_OF_WEEK_FIELD_NUMBER = 1;
    private int dayOfWeek_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Day of the week.
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for dayOfWeek.
     */
    @java.lang.Override
    public int getDayOfWeekValue() {
      return dayOfWeek_;
    }
    /**
     *
     *
     * <pre>
     * Required. Day of the week.
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The dayOfWeek.
     */
    @java.lang.Override
    public com.google.type.DayOfWeek getDayOfWeek() {
      com.google.type.DayOfWeek result = com.google.type.DayOfWeek.forNumber(dayOfWeek_);
      return result == null ? com.google.type.DayOfWeek.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (dayOfWeek_ != com.google.type.DayOfWeek.DAY_OF_WEEK_UNSPECIFIED.getNumber()) {
        output.writeEnum(1, dayOfWeek_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (dayOfWeek_ != com.google.type.DayOfWeek.DAY_OF_WEEK_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, dayOfWeek_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule other =
          (com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule) obj;

      if (dayOfWeek_ != other.dayOfWeek_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DAY_OF_WEEK_FIELD_NUMBER;
      hash = (53 * hash) + dayOfWeek_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a weekly schedule.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.WeeklySchedule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.WeeklySchedule)
        com.google.cloud.osconfig.v1.PatchDeployments.WeeklyScheduleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_WeeklySchedule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_WeeklySchedule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.class,
                com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dayOfWeek_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_WeeklySchedule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule build() {
        com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule result =
            new com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dayOfWeek_ = dayOfWeek_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule.getDefaultInstance())
          return this;
        if (other.dayOfWeek_ != 0) {
          setDayOfWeekValue(other.getDayOfWeekValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  dayOfWeek_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int dayOfWeek_ = 0;
      /**
       *
       *
       * <pre>
       * Required. Day of the week.
       * </pre>
       *
       * <code>.google.type.DayOfWeek day_of_week = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for dayOfWeek.
       */
      @java.lang.Override
      public int getDayOfWeekValue() {
        return dayOfWeek_;
      }
      /**
       *
       *
       * <pre>
       * Required. Day of the week.
       * </pre>
       *
       * <code>.google.type.DayOfWeek day_of_week = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for dayOfWeek to set.
       * @return This builder for chaining.
       */
      public Builder setDayOfWeekValue(int value) {
        dayOfWeek_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Day of the week.
       * </pre>
       *
       * <code>.google.type.DayOfWeek day_of_week = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The dayOfWeek.
       */
      @java.lang.Override
      public com.google.type.DayOfWeek getDayOfWeek() {
        com.google.type.DayOfWeek result = com.google.type.DayOfWeek.forNumber(dayOfWeek_);
        return result == null ? com.google.type.DayOfWeek.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * Required. Day of the week.
       * </pre>
       *
       * <code>.google.type.DayOfWeek day_of_week = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The dayOfWeek to set.
       * @return This builder for chaining.
       */
      public Builder setDayOfWeek(com.google.type.DayOfWeek value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        dayOfWeek_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Day of the week.
       * </pre>
       *
       * <code>.google.type.DayOfWeek day_of_week = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDayOfWeek() {
        bitField0_ = (bitField0_ & ~0x00000001);
        dayOfWeek_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.WeeklySchedule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.WeeklySchedule)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WeeklySchedule> PARSER =
        new com.google.protobuf.AbstractParser<WeeklySchedule>() {
          @java.lang.Override
          public WeeklySchedule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WeeklySchedule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WeeklySchedule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.WeeklySchedule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MonthlyScheduleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.MonthlySchedule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Week day in a month.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the weekDayOfMonth field is set.
     */
    boolean hasWeekDayOfMonth();
    /**
     *
     *
     * <pre>
     * Required. Week day in a month.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The weekDayOfMonth.
     */
    com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth getWeekDayOfMonth();
    /**
     *
     *
     * <pre>
     * Required. Week day in a month.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonthOrBuilder
        getWeekDayOfMonthOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. One day of the month. 1-31 indicates the 1st to the 31st day.
     * -1 indicates the last day of the month. Months without the target day
     * will be skipped. For example, a schedule to run "every month on the 31st"
     * will not run in February, April, June, etc.
     * </pre>
     *
     * <code>int32 month_day = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the monthDay field is set.
     */
    boolean hasMonthDay();
    /**
     *
     *
     * <pre>
     * Required. One day of the month. 1-31 indicates the 1st to the 31st day.
     * -1 indicates the last day of the month. Months without the target day
     * will be skipped. For example, a schedule to run "every month on the 31st"
     * will not run in February, April, June, etc.
     * </pre>
     *
     * <code>int32 month_day = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The monthDay.
     */
    int getMonthDay();

    com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.DayOfMonthCase
        getDayOfMonthCase();
  }
  /**
   *
   *
   * <pre>
   * Represents a monthly schedule. An example of a valid monthly schedule is
   * "on the third Tuesday of the month" or "on the 15th of the month".
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.MonthlySchedule}
   */
  public static final class MonthlySchedule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.MonthlySchedule)
      MonthlyScheduleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MonthlySchedule.newBuilder() to construct.
    private MonthlySchedule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MonthlySchedule() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MonthlySchedule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_MonthlySchedule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_MonthlySchedule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.class,
              com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.Builder.class);
    }

    private int dayOfMonthCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object dayOfMonth_;

    public enum DayOfMonthCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      WEEK_DAY_OF_MONTH(1),
      MONTH_DAY(2),
      DAYOFMONTH_NOT_SET(0);
      private final int value;

      private DayOfMonthCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DayOfMonthCase valueOf(int value) {
        return forNumber(value);
      }

      public static DayOfMonthCase forNumber(int value) {
        switch (value) {
          case 1:
            return WEEK_DAY_OF_MONTH;
          case 2:
            return MONTH_DAY;
          case 0:
            return DAYOFMONTH_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DayOfMonthCase getDayOfMonthCase() {
      return DayOfMonthCase.forNumber(dayOfMonthCase_);
    }

    public static final int WEEK_DAY_OF_MONTH_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Required. Week day in a month.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the weekDayOfMonth field is set.
     */
    @java.lang.Override
    public boolean hasWeekDayOfMonth() {
      return dayOfMonthCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Required. Week day in a month.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The weekDayOfMonth.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth getWeekDayOfMonth() {
      if (dayOfMonthCase_ == 1) {
        return (com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth) dayOfMonth_;
      }
      return com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Required. Week day in a month.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonthOrBuilder
        getWeekDayOfMonthOrBuilder() {
      if (dayOfMonthCase_ == 1) {
        return (com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth) dayOfMonth_;
      }
      return com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.getDefaultInstance();
    }

    public static final int MONTH_DAY_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Required. One day of the month. 1-31 indicates the 1st to the 31st day.
     * -1 indicates the last day of the month. Months without the target day
     * will be skipped. For example, a schedule to run "every month on the 31st"
     * will not run in February, April, June, etc.
     * </pre>
     *
     * <code>int32 month_day = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the monthDay field is set.
     */
    @java.lang.Override
    public boolean hasMonthDay() {
      return dayOfMonthCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Required. One day of the month. 1-31 indicates the 1st to the 31st day.
     * -1 indicates the last day of the month. Months without the target day
     * will be skipped. For example, a schedule to run "every month on the 31st"
     * will not run in February, April, June, etc.
     * </pre>
     *
     * <code>int32 month_day = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The monthDay.
     */
    @java.lang.Override
    public int getMonthDay() {
      if (dayOfMonthCase_ == 2) {
        return (java.lang.Integer) dayOfMonth_;
      }
      return 0;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (dayOfMonthCase_ == 1) {
        output.writeMessage(
            1, (com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth) dayOfMonth_);
      }
      if (dayOfMonthCase_ == 2) {
        output.writeInt32(2, (int) ((java.lang.Integer) dayOfMonth_));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (dayOfMonthCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth) dayOfMonth_);
      }
      if (dayOfMonthCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                2, (int) ((java.lang.Integer) dayOfMonth_));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule other =
          (com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule) obj;

      if (!getDayOfMonthCase().equals(other.getDayOfMonthCase())) return false;
      switch (dayOfMonthCase_) {
        case 1:
          if (!getWeekDayOfMonth().equals(other.getWeekDayOfMonth())) return false;
          break;
        case 2:
          if (getMonthDay() != other.getMonthDay()) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (dayOfMonthCase_) {
        case 1:
          hash = (37 * hash) + WEEK_DAY_OF_MONTH_FIELD_NUMBER;
          hash = (53 * hash) + getWeekDayOfMonth().hashCode();
          break;
        case 2:
          hash = (37 * hash) + MONTH_DAY_FIELD_NUMBER;
          hash = (53 * hash) + getMonthDay();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a monthly schedule. An example of a valid monthly schedule is
     * "on the third Tuesday of the month" or "on the 15th of the month".
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.MonthlySchedule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.MonthlySchedule)
        com.google.cloud.osconfig.v1.PatchDeployments.MonthlyScheduleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_MonthlySchedule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_MonthlySchedule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.class,
                com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (weekDayOfMonthBuilder_ != null) {
          weekDayOfMonthBuilder_.clear();
        }
        dayOfMonthCase_ = 0;
        dayOfMonth_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_MonthlySchedule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule build() {
        com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule result =
            new com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule result) {
        result.dayOfMonthCase_ = dayOfMonthCase_;
        result.dayOfMonth_ = this.dayOfMonth_;
        if (dayOfMonthCase_ == 1 && weekDayOfMonthBuilder_ != null) {
          result.dayOfMonth_ = weekDayOfMonthBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule.getDefaultInstance())
          return this;
        switch (other.getDayOfMonthCase()) {
          case WEEK_DAY_OF_MONTH:
            {
              mergeWeekDayOfMonth(other.getWeekDayOfMonth());
              break;
            }
          case MONTH_DAY:
            {
              setMonthDay(other.getMonthDay());
              break;
            }
          case DAYOFMONTH_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getWeekDayOfMonthFieldBuilder().getBuilder(), extensionRegistry);
                  dayOfMonthCase_ = 1;
                  break;
                } // case 10
              case 16:
                {
                  dayOfMonth_ = input.readInt32();
                  dayOfMonthCase_ = 2;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int dayOfMonthCase_ = 0;
      private java.lang.Object dayOfMonth_;

      public DayOfMonthCase getDayOfMonthCase() {
        return DayOfMonthCase.forNumber(dayOfMonthCase_);
      }

      public Builder clearDayOfMonth() {
        dayOfMonthCase_ = 0;
        dayOfMonth_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth,
              com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonthOrBuilder>
          weekDayOfMonthBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Week day in a month.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the weekDayOfMonth field is set.
       */
      @java.lang.Override
      public boolean hasWeekDayOfMonth() {
        return dayOfMonthCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Required. Week day in a month.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The weekDayOfMonth.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth getWeekDayOfMonth() {
        if (weekDayOfMonthBuilder_ == null) {
          if (dayOfMonthCase_ == 1) {
            return (com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth) dayOfMonth_;
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.getDefaultInstance();
        } else {
          if (dayOfMonthCase_ == 1) {
            return weekDayOfMonthBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Week day in a month.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setWeekDayOfMonth(
          com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth value) {
        if (weekDayOfMonthBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dayOfMonth_ = value;
          onChanged();
        } else {
          weekDayOfMonthBuilder_.setMessage(value);
        }
        dayOfMonthCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Week day in a month.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setWeekDayOfMonth(
          com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.Builder builderForValue) {
        if (weekDayOfMonthBuilder_ == null) {
          dayOfMonth_ = builderForValue.build();
          onChanged();
        } else {
          weekDayOfMonthBuilder_.setMessage(builderForValue.build());
        }
        dayOfMonthCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Week day in a month.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeWeekDayOfMonth(
          com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth value) {
        if (weekDayOfMonthBuilder_ == null) {
          if (dayOfMonthCase_ == 1
              && dayOfMonth_
                  != com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth
                      .getDefaultInstance()) {
            dayOfMonth_ =
                com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.newBuilder(
                        (com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth) dayOfMonth_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dayOfMonth_ = value;
          }
          onChanged();
        } else {
          if (dayOfMonthCase_ == 1) {
            weekDayOfMonthBuilder_.mergeFrom(value);
          } else {
            weekDayOfMonthBuilder_.setMessage(value);
          }
        }
        dayOfMonthCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Week day in a month.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearWeekDayOfMonth() {
        if (weekDayOfMonthBuilder_ == null) {
          if (dayOfMonthCase_ == 1) {
            dayOfMonthCase_ = 0;
            dayOfMonth_ = null;
            onChanged();
          }
        } else {
          if (dayOfMonthCase_ == 1) {
            dayOfMonthCase_ = 0;
            dayOfMonth_ = null;
          }
          weekDayOfMonthBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Week day in a month.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.Builder
          getWeekDayOfMonthBuilder() {
        return getWeekDayOfMonthFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Week day in a month.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonthOrBuilder
          getWeekDayOfMonthOrBuilder() {
        if ((dayOfMonthCase_ == 1) && (weekDayOfMonthBuilder_ != null)) {
          return weekDayOfMonthBuilder_.getMessageOrBuilder();
        } else {
          if (dayOfMonthCase_ == 1) {
            return (com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth) dayOfMonth_;
          }
          return com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Week day in a month.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.WeekDayOfMonth week_day_of_month = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth,
              com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonthOrBuilder>
          getWeekDayOfMonthFieldBuilder() {
        if (weekDayOfMonthBuilder_ == null) {
          if (!(dayOfMonthCase_ == 1)) {
            dayOfMonth_ =
                com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.getDefaultInstance();
          }
          weekDayOfMonthBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth,
                  com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.Builder,
                  com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonthOrBuilder>(
                  (com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth) dayOfMonth_,
                  getParentForChildren(),
                  isClean());
          dayOfMonth_ = null;
        }
        dayOfMonthCase_ = 1;
        onChanged();
        return weekDayOfMonthBuilder_;
      }

      /**
       *
       *
       * <pre>
       * Required. One day of the month. 1-31 indicates the 1st to the 31st day.
       * -1 indicates the last day of the month. Months without the target day
       * will be skipped. For example, a schedule to run "every month on the 31st"
       * will not run in February, April, June, etc.
       * </pre>
       *
       * <code>int32 month_day = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return Whether the monthDay field is set.
       */
      public boolean hasMonthDay() {
        return dayOfMonthCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Required. One day of the month. 1-31 indicates the 1st to the 31st day.
       * -1 indicates the last day of the month. Months without the target day
       * will be skipped. For example, a schedule to run "every month on the 31st"
       * will not run in February, April, June, etc.
       * </pre>
       *
       * <code>int32 month_day = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The monthDay.
       */
      public int getMonthDay() {
        if (dayOfMonthCase_ == 2) {
          return (java.lang.Integer) dayOfMonth_;
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * Required. One day of the month. 1-31 indicates the 1st to the 31st day.
       * -1 indicates the last day of the month. Months without the target day
       * will be skipped. For example, a schedule to run "every month on the 31st"
       * will not run in February, April, June, etc.
       * </pre>
       *
       * <code>int32 month_day = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The monthDay to set.
       * @return This builder for chaining.
       */
      public Builder setMonthDay(int value) {

        dayOfMonthCase_ = 2;
        dayOfMonth_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. One day of the month. 1-31 indicates the 1st to the 31st day.
       * -1 indicates the last day of the month. Months without the target day
       * will be skipped. For example, a schedule to run "every month on the 31st"
       * will not run in February, April, June, etc.
       * </pre>
       *
       * <code>int32 month_day = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMonthDay() {
        if (dayOfMonthCase_ == 2) {
          dayOfMonthCase_ = 0;
          dayOfMonth_ = null;
          onChanged();
        }
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.MonthlySchedule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.MonthlySchedule)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MonthlySchedule> PARSER =
        new com.google.protobuf.AbstractParser<MonthlySchedule>() {
          @java.lang.Override
          public MonthlySchedule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MonthlySchedule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MonthlySchedule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.MonthlySchedule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WeekDayOfMonthOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.WeekDayOfMonth)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Week number in a month. 1-4 indicates the 1st to 4th week of the
     * month. -1 indicates the last week of the month.
     * </pre>
     *
     * <code>int32 week_ordinal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The weekOrdinal.
     */
    int getWeekOrdinal();

    /**
     *
     *
     * <pre>
     * Required. A day of the week.
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for dayOfWeek.
     */
    int getDayOfWeekValue();
    /**
     *
     *
     * <pre>
     * Required. A day of the week.
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The dayOfWeek.
     */
    com.google.type.DayOfWeek getDayOfWeek();

    /**
     *
     *
     * <pre>
     * Optional. Represents the number of days before or after the given week day
     * of month that the patch deployment is scheduled for. For example if
     * `week_ordinal` and `day_of_week` values point to the second day of the
     * month and this `day_offset` value is set to `3`, the patch deployment takes
     * place three days after the second Tuesday of the month. If this value is
     * negative, for example -5, the patches are deployed five days before before
     * the second Tuesday of the month. Allowed values are in range [-30, 30].
     * </pre>
     *
     * <code>int32 day_offset = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The dayOffset.
     */
    int getDayOffset();
  }
  /**
   *
   *
   * <pre>
   * Represents one week day in a month. An example is "the 4th Sunday".
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.WeekDayOfMonth}
   */
  public static final class WeekDayOfMonth extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.WeekDayOfMonth)
      WeekDayOfMonthOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WeekDayOfMonth.newBuilder() to construct.
    private WeekDayOfMonth(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WeekDayOfMonth() {
      dayOfWeek_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WeekDayOfMonth();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_WeekDayOfMonth_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_WeekDayOfMonth_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.class,
              com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.Builder.class);
    }

    public static final int WEEK_ORDINAL_FIELD_NUMBER = 1;
    private int weekOrdinal_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Week number in a month. 1-4 indicates the 1st to 4th week of the
     * month. -1 indicates the last week of the month.
     * </pre>
     *
     * <code>int32 week_ordinal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The weekOrdinal.
     */
    @java.lang.Override
    public int getWeekOrdinal() {
      return weekOrdinal_;
    }

    public static final int DAY_OF_WEEK_FIELD_NUMBER = 2;
    private int dayOfWeek_ = 0;
    /**
     *
     *
     * <pre>
     * Required. A day of the week.
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for dayOfWeek.
     */
    @java.lang.Override
    public int getDayOfWeekValue() {
      return dayOfWeek_;
    }
    /**
     *
     *
     * <pre>
     * Required. A day of the week.
     * </pre>
     *
     * <code>.google.type.DayOfWeek day_of_week = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The dayOfWeek.
     */
    @java.lang.Override
    public com.google.type.DayOfWeek getDayOfWeek() {
      com.google.type.DayOfWeek result = com.google.type.DayOfWeek.forNumber(dayOfWeek_);
      return result == null ? com.google.type.DayOfWeek.UNRECOGNIZED : result;
    }

    public static final int DAY_OFFSET_FIELD_NUMBER = 3;
    private int dayOffset_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Represents the number of days before or after the given week day
     * of month that the patch deployment is scheduled for. For example if
     * `week_ordinal` and `day_of_week` values point to the second day of the
     * month and this `day_offset` value is set to `3`, the patch deployment takes
     * place three days after the second Tuesday of the month. If this value is
     * negative, for example -5, the patches are deployed five days before before
     * the second Tuesday of the month. Allowed values are in range [-30, 30].
     * </pre>
     *
     * <code>int32 day_offset = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The dayOffset.
     */
    @java.lang.Override
    public int getDayOffset() {
      return dayOffset_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (weekOrdinal_ != 0) {
        output.writeInt32(1, weekOrdinal_);
      }
      if (dayOfWeek_ != com.google.type.DayOfWeek.DAY_OF_WEEK_UNSPECIFIED.getNumber()) {
        output.writeEnum(2, dayOfWeek_);
      }
      if (dayOffset_ != 0) {
        output.writeInt32(3, dayOffset_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (weekOrdinal_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, weekOrdinal_);
      }
      if (dayOfWeek_ != com.google.type.DayOfWeek.DAY_OF_WEEK_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, dayOfWeek_);
      }
      if (dayOffset_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, dayOffset_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth other =
          (com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth) obj;

      if (getWeekOrdinal() != other.getWeekOrdinal()) return false;
      if (dayOfWeek_ != other.dayOfWeek_) return false;
      if (getDayOffset() != other.getDayOffset()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + WEEK_ORDINAL_FIELD_NUMBER;
      hash = (53 * hash) + getWeekOrdinal();
      hash = (37 * hash) + DAY_OF_WEEK_FIELD_NUMBER;
      hash = (53 * hash) + dayOfWeek_;
      hash = (37 * hash) + DAY_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getDayOffset();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents one week day in a month. An example is "the 4th Sunday".
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.WeekDayOfMonth}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.WeekDayOfMonth)
        com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonthOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_WeekDayOfMonth_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_WeekDayOfMonth_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.class,
                com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        weekOrdinal_ = 0;
        dayOfWeek_ = 0;
        dayOffset_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_WeekDayOfMonth_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth build() {
        com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth result =
            new com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.weekOrdinal_ = weekOrdinal_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.dayOfWeek_ = dayOfWeek_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.dayOffset_ = dayOffset_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth.getDefaultInstance())
          return this;
        if (other.getWeekOrdinal() != 0) {
          setWeekOrdinal(other.getWeekOrdinal());
        }
        if (other.dayOfWeek_ != 0) {
          setDayOfWeekValue(other.getDayOfWeekValue());
        }
        if (other.getDayOffset() != 0) {
          setDayOffset(other.getDayOffset());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  weekOrdinal_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  dayOfWeek_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  dayOffset_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int weekOrdinal_;
      /**
       *
       *
       * <pre>
       * Required. Week number in a month. 1-4 indicates the 1st to 4th week of the
       * month. -1 indicates the last week of the month.
       * </pre>
       *
       * <code>int32 week_ordinal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The weekOrdinal.
       */
      @java.lang.Override
      public int getWeekOrdinal() {
        return weekOrdinal_;
      }
      /**
       *
       *
       * <pre>
       * Required. Week number in a month. 1-4 indicates the 1st to 4th week of the
       * month. -1 indicates the last week of the month.
       * </pre>
       *
       * <code>int32 week_ordinal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The weekOrdinal to set.
       * @return This builder for chaining.
       */
      public Builder setWeekOrdinal(int value) {

        weekOrdinal_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Week number in a month. 1-4 indicates the 1st to 4th week of the
       * month. -1 indicates the last week of the month.
       * </pre>
       *
       * <code>int32 week_ordinal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWeekOrdinal() {
        bitField0_ = (bitField0_ & ~0x00000001);
        weekOrdinal_ = 0;
        onChanged();
        return this;
      }

      private int dayOfWeek_ = 0;
      /**
       *
       *
       * <pre>
       * Required. A day of the week.
       * </pre>
       *
       * <code>.google.type.DayOfWeek day_of_week = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for dayOfWeek.
       */
      @java.lang.Override
      public int getDayOfWeekValue() {
        return dayOfWeek_;
      }
      /**
       *
       *
       * <pre>
       * Required. A day of the week.
       * </pre>
       *
       * <code>.google.type.DayOfWeek day_of_week = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for dayOfWeek to set.
       * @return This builder for chaining.
       */
      public Builder setDayOfWeekValue(int value) {
        dayOfWeek_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A day of the week.
       * </pre>
       *
       * <code>.google.type.DayOfWeek day_of_week = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The dayOfWeek.
       */
      @java.lang.Override
      public com.google.type.DayOfWeek getDayOfWeek() {
        com.google.type.DayOfWeek result = com.google.type.DayOfWeek.forNumber(dayOfWeek_);
        return result == null ? com.google.type.DayOfWeek.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * Required. A day of the week.
       * </pre>
       *
       * <code>.google.type.DayOfWeek day_of_week = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The dayOfWeek to set.
       * @return This builder for chaining.
       */
      public Builder setDayOfWeek(com.google.type.DayOfWeek value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        dayOfWeek_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A day of the week.
       * </pre>
       *
       * <code>.google.type.DayOfWeek day_of_week = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDayOfWeek() {
        bitField0_ = (bitField0_ & ~0x00000002);
        dayOfWeek_ = 0;
        onChanged();
        return this;
      }

      private int dayOffset_;
      /**
       *
       *
       * <pre>
       * Optional. Represents the number of days before or after the given week day
       * of month that the patch deployment is scheduled for. For example if
       * `week_ordinal` and `day_of_week` values point to the second day of the
       * month and this `day_offset` value is set to `3`, the patch deployment takes
       * place three days after the second Tuesday of the month. If this value is
       * negative, for example -5, the patches are deployed five days before before
       * the second Tuesday of the month. Allowed values are in range [-30, 30].
       * </pre>
       *
       * <code>int32 day_offset = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The dayOffset.
       */
      @java.lang.Override
      public int getDayOffset() {
        return dayOffset_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Represents the number of days before or after the given week day
       * of month that the patch deployment is scheduled for. For example if
       * `week_ordinal` and `day_of_week` values point to the second day of the
       * month and this `day_offset` value is set to `3`, the patch deployment takes
       * place three days after the second Tuesday of the month. If this value is
       * negative, for example -5, the patches are deployed five days before before
       * the second Tuesday of the month. Allowed values are in range [-30, 30].
       * </pre>
       *
       * <code>int32 day_offset = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The dayOffset to set.
       * @return This builder for chaining.
       */
      public Builder setDayOffset(int value) {

        dayOffset_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Represents the number of days before or after the given week day
       * of month that the patch deployment is scheduled for. For example if
       * `week_ordinal` and `day_of_week` values point to the second day of the
       * month and this `day_offset` value is set to `3`, the patch deployment takes
       * place three days after the second Tuesday of the month. If this value is
       * negative, for example -5, the patches are deployed five days before before
       * the second Tuesday of the month. Allowed values are in range [-30, 30].
       * </pre>
       *
       * <code>int32 day_offset = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDayOffset() {
        bitField0_ = (bitField0_ & ~0x00000004);
        dayOffset_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.WeekDayOfMonth)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.WeekDayOfMonth)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WeekDayOfMonth> PARSER =
        new com.google.protobuf.AbstractParser<WeekDayOfMonth>() {
          @java.lang.Override
          public WeekDayOfMonth parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WeekDayOfMonth> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WeekDayOfMonth> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.WeekDayOfMonth
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CreatePatchDeploymentRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.CreatePatchDeploymentRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The project to apply this patch deployment to in the form
     * `projects/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    java.lang.String getParent();
    /**
     *
     *
     * <pre>
     * Required. The project to apply this patch deployment to in the form
     * `projects/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    com.google.protobuf.ByteString getParentBytes();

    /**
     *
     *
     * <pre>
     * Required. A name for the patch deployment in the project. When creating a
     * name the following rules apply:
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the project.
     * </pre>
     *
     * <code>string patch_deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The patchDeploymentId.
     */
    java.lang.String getPatchDeploymentId();
    /**
     *
     *
     * <pre>
     * Required. A name for the patch deployment in the project. When creating a
     * name the following rules apply:
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the project.
     * </pre>
     *
     * <code>string patch_deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for patchDeploymentId.
     */
    com.google.protobuf.ByteString getPatchDeploymentIdBytes();

    /**
     *
     *
     * <pre>
     * Required. The patch deployment to create.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the patchDeployment field is set.
     */
    boolean hasPatchDeployment();
    /**
     *
     *
     * <pre>
     * Required. The patch deployment to create.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The patchDeployment.
     */
    com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment getPatchDeployment();
    /**
     *
     *
     * <pre>
     * Required. The patch deployment to create.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder
        getPatchDeploymentOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A request message for creating a patch deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.CreatePatchDeploymentRequest}
   */
  public static final class CreatePatchDeploymentRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.CreatePatchDeploymentRequest)
      CreatePatchDeploymentRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CreatePatchDeploymentRequest.newBuilder() to construct.
    private CreatePatchDeploymentRequest(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CreatePatchDeploymentRequest() {
      parent_ = "";
      patchDeploymentId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CreatePatchDeploymentRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_CreatePatchDeploymentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_CreatePatchDeploymentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest.class,
              com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest.Builder
                  .class);
    }

    public static final int PARENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The project to apply this patch deployment to in the form
     * `projects/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    @java.lang.Override
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The project to apply this patch deployment to in the form
     * `projects/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATCH_DEPLOYMENT_ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object patchDeploymentId_ = "";
    /**
     *
     *
     * <pre>
     * Required. A name for the patch deployment in the project. When creating a
     * name the following rules apply:
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the project.
     * </pre>
     *
     * <code>string patch_deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The patchDeploymentId.
     */
    @java.lang.Override
    public java.lang.String getPatchDeploymentId() {
      java.lang.Object ref = patchDeploymentId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        patchDeploymentId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A name for the patch deployment in the project. When creating a
     * name the following rules apply:
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the project.
     * </pre>
     *
     * <code>string patch_deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for patchDeploymentId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPatchDeploymentIdBytes() {
      java.lang.Object ref = patchDeploymentId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        patchDeploymentId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATCH_DEPLOYMENT_FIELD_NUMBER = 3;
    private com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment patchDeployment_;
    /**
     *
     *
     * <pre>
     * Required. The patch deployment to create.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the patchDeployment field is set.
     */
    @java.lang.Override
    public boolean hasPatchDeployment() {
      return patchDeployment_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The patch deployment to create.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The patchDeployment.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment getPatchDeployment() {
      return patchDeployment_ == null
          ? com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.getDefaultInstance()
          : patchDeployment_;
    }
    /**
     *
     *
     * <pre>
     * Required. The patch deployment to create.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder
        getPatchDeploymentOrBuilder() {
      return patchDeployment_ == null
          ? com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.getDefaultInstance()
          : patchDeployment_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(patchDeploymentId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, patchDeploymentId_);
      }
      if (patchDeployment_ != null) {
        output.writeMessage(3, getPatchDeployment());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(patchDeploymentId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, patchDeploymentId_);
      }
      if (patchDeployment_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPatchDeployment());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest other =
          (com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest) obj;

      if (!getParent().equals(other.getParent())) return false;
      if (!getPatchDeploymentId().equals(other.getPatchDeploymentId())) return false;
      if (hasPatchDeployment() != other.hasPatchDeployment()) return false;
      if (hasPatchDeployment()) {
        if (!getPatchDeployment().equals(other.getPatchDeployment())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
      hash = (37 * hash) + PATCH_DEPLOYMENT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getPatchDeploymentId().hashCode();
      if (hasPatchDeployment()) {
        hash = (37 * hash) + PATCH_DEPLOYMENT_FIELD_NUMBER;
        hash = (53 * hash) + getPatchDeployment().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A request message for creating a patch deployment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.CreatePatchDeploymentRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.CreatePatchDeploymentRequest)
        com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_CreatePatchDeploymentRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_CreatePatchDeploymentRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest.class,
                com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        parent_ = "";
        patchDeploymentId_ = "";
        patchDeployment_ = null;
        if (patchDeploymentBuilder_ != null) {
          patchDeploymentBuilder_.dispose();
          patchDeploymentBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_CreatePatchDeploymentRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest build() {
        com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
          buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest result =
            new com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.parent_ = parent_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.patchDeploymentId_ = patchDeploymentId_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.patchDeployment_ =
              patchDeploymentBuilder_ == null ? patchDeployment_ : patchDeploymentBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
                .getDefaultInstance()) return this;
        if (!other.getParent().isEmpty()) {
          parent_ = other.parent_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getPatchDeploymentId().isEmpty()) {
          patchDeploymentId_ = other.patchDeploymentId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasPatchDeployment()) {
          mergePatchDeployment(other.getPatchDeployment());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  parent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  patchDeploymentId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getPatchDeploymentFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object parent_ = "";
      /**
       *
       *
       * <pre>
       * Required. The project to apply this patch deployment to in the form
       * `projects/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The parent.
       */
      public java.lang.String getParent() {
        java.lang.Object ref = parent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The project to apply this patch deployment to in the form
       * `projects/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for parent.
       */
      public com.google.protobuf.ByteString getParentBytes() {
        java.lang.Object ref = parent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The project to apply this patch deployment to in the form
       * `projects/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The parent to set.
       * @return This builder for chaining.
       */
      public Builder setParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The project to apply this patch deployment to in the form
       * `projects/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParent() {
        parent_ = getDefaultInstance().getParent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The project to apply this patch deployment to in the form
       * `projects/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for parent to set.
       * @return This builder for chaining.
       */
      public Builder setParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object patchDeploymentId_ = "";
      /**
       *
       *
       * <pre>
       * Required. A name for the patch deployment in the project. When creating a
       * name the following rules apply:
       * * Must contain only lowercase letters, numbers, and hyphens.
       * * Must start with a letter.
       * * Must be between 1-63 characters.
       * * Must end with a number or a letter.
       * * Must be unique within the project.
       * </pre>
       *
       * <code>string patch_deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The patchDeploymentId.
       */
      public java.lang.String getPatchDeploymentId() {
        java.lang.Object ref = patchDeploymentId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          patchDeploymentId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A name for the patch deployment in the project. When creating a
       * name the following rules apply:
       * * Must contain only lowercase letters, numbers, and hyphens.
       * * Must start with a letter.
       * * Must be between 1-63 characters.
       * * Must end with a number or a letter.
       * * Must be unique within the project.
       * </pre>
       *
       * <code>string patch_deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for patchDeploymentId.
       */
      public com.google.protobuf.ByteString getPatchDeploymentIdBytes() {
        java.lang.Object ref = patchDeploymentId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          patchDeploymentId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A name for the patch deployment in the project. When creating a
       * name the following rules apply:
       * * Must contain only lowercase letters, numbers, and hyphens.
       * * Must start with a letter.
       * * Must be between 1-63 characters.
       * * Must end with a number or a letter.
       * * Must be unique within the project.
       * </pre>
       *
       * <code>string patch_deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The patchDeploymentId to set.
       * @return This builder for chaining.
       */
      public Builder setPatchDeploymentId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        patchDeploymentId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A name for the patch deployment in the project. When creating a
       * name the following rules apply:
       * * Must contain only lowercase letters, numbers, and hyphens.
       * * Must start with a letter.
       * * Must be between 1-63 characters.
       * * Must end with a number or a letter.
       * * Must be unique within the project.
       * </pre>
       *
       * <code>string patch_deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPatchDeploymentId() {
        patchDeploymentId_ = getDefaultInstance().getPatchDeploymentId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A name for the patch deployment in the project. When creating a
       * name the following rules apply:
       * * Must contain only lowercase letters, numbers, and hyphens.
       * * Must start with a letter.
       * * Must be between 1-63 characters.
       * * Must end with a number or a letter.
       * * Must be unique within the project.
       * </pre>
       *
       * <code>string patch_deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for patchDeploymentId to set.
       * @return This builder for chaining.
       */
      public Builder setPatchDeploymentIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        patchDeploymentId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment patchDeployment_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment,
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder>
          patchDeploymentBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to create.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the patchDeployment field is set.
       */
      public boolean hasPatchDeployment() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to create.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The patchDeployment.
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment getPatchDeployment() {
        if (patchDeploymentBuilder_ == null) {
          return patchDeployment_ == null
              ? com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.getDefaultInstance()
              : patchDeployment_;
        } else {
          return patchDeploymentBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to create.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setPatchDeployment(
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment value) {
        if (patchDeploymentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          patchDeployment_ = value;
        } else {
          patchDeploymentBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to create.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setPatchDeployment(
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder builderForValue) {
        if (patchDeploymentBuilder_ == null) {
          patchDeployment_ = builderForValue.build();
        } else {
          patchDeploymentBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to create.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergePatchDeployment(
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment value) {
        if (patchDeploymentBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && patchDeployment_ != null
              && patchDeployment_
                  != com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment
                      .getDefaultInstance()) {
            getPatchDeploymentBuilder().mergeFrom(value);
          } else {
            patchDeployment_ = value;
          }
        } else {
          patchDeploymentBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to create.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearPatchDeployment() {
        bitField0_ = (bitField0_ & ~0x00000004);
        patchDeployment_ = null;
        if (patchDeploymentBuilder_ != null) {
          patchDeploymentBuilder_.dispose();
          patchDeploymentBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to create.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder
          getPatchDeploymentBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getPatchDeploymentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to create.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder
          getPatchDeploymentOrBuilder() {
        if (patchDeploymentBuilder_ != null) {
          return patchDeploymentBuilder_.getMessageOrBuilder();
        } else {
          return patchDeployment_ == null
              ? com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.getDefaultInstance()
              : patchDeployment_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to create.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment,
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder>
          getPatchDeploymentFieldBuilder() {
        if (patchDeploymentBuilder_ == null) {
          patchDeploymentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment,
                  com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder,
                  com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder>(
                  getPatchDeployment(), getParentForChildren(), isClean());
          patchDeployment_ = null;
        }
        return patchDeploymentBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.CreatePatchDeploymentRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.CreatePatchDeploymentRequest)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CreatePatchDeploymentRequest> PARSER =
        new com.google.protobuf.AbstractParser<CreatePatchDeploymentRequest>() {
          @java.lang.Override
          public CreatePatchDeploymentRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CreatePatchDeploymentRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CreatePatchDeploymentRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.CreatePatchDeploymentRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GetPatchDeploymentRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.GetPatchDeploymentRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * A request message for retrieving a patch deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.GetPatchDeploymentRequest}
   */
  public static final class GetPatchDeploymentRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.GetPatchDeploymentRequest)
      GetPatchDeploymentRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GetPatchDeploymentRequest.newBuilder() to construct.
    private GetPatchDeploymentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GetPatchDeploymentRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GetPatchDeploymentRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_GetPatchDeploymentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_GetPatchDeploymentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest.class,
              com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest.Builder
                  .class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest other =
          (com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A request message for retrieving a patch deployment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.GetPatchDeploymentRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.GetPatchDeploymentRequest)
        com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_GetPatchDeploymentRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_GetPatchDeploymentRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest.class,
                com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_GetPatchDeploymentRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest build() {
        com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest
          buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest result =
            new com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.GetPatchDeploymentRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.GetPatchDeploymentRequest)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GetPatchDeploymentRequest> PARSER =
        new com.google.protobuf.AbstractParser<GetPatchDeploymentRequest>() {
          @java.lang.Override
          public GetPatchDeploymentRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GetPatchDeploymentRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetPatchDeploymentRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.GetPatchDeploymentRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ListPatchDeploymentsRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.ListPatchDeploymentsRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The resource name of the parent in the form `projects/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    java.lang.String getParent();
    /**
     *
     *
     * <pre>
     * Required. The resource name of the parent in the form `projects/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    com.google.protobuf.ByteString getParentBytes();

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of patch deployments to return. Default is
     * 100.
     * </pre>
     *
     * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    int getPageSize();

    /**
     *
     *
     * <pre>
     * Optional. A pagination token returned from a previous call to
     * ListPatchDeployments that indicates where this listing should continue
     * from.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    java.lang.String getPageToken();
    /**
     *
     *
     * <pre>
     * Optional. A pagination token returned from a previous call to
     * ListPatchDeployments that indicates where this listing should continue
     * from.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    com.google.protobuf.ByteString getPageTokenBytes();
  }
  /**
   *
   *
   * <pre>
   * A request message for listing patch deployments.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.ListPatchDeploymentsRequest}
   */
  public static final class ListPatchDeploymentsRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.ListPatchDeploymentsRequest)
      ListPatchDeploymentsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListPatchDeploymentsRequest.newBuilder() to construct.
    private ListPatchDeploymentsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListPatchDeploymentsRequest() {
      parent_ = "";
      pageToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListPatchDeploymentsRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest.class,
              com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest.Builder
                  .class);
    }

    public static final int PARENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the parent in the form `projects/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    @java.lang.Override
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the parent in the form `projects/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PAGE_SIZE_FIELD_NUMBER = 2;
    private int pageSize_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The maximum number of patch deployments to return. Default is
     * 100.
     * </pre>
     *
     * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    public static final int PAGE_TOKEN_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A pagination token returned from a previous call to
     * ListPatchDeployments that indicates where this listing should continue
     * from.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    @java.lang.Override
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A pagination token returned from a previous call to
     * ListPatchDeployments that indicates where this listing should continue
     * from.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
      }
      if (pageSize_ != 0) {
        output.writeInt32(2, pageSize_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
      }
      if (pageSize_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageSize_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest other =
          (com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest) obj;

      if (!getParent().equals(other.getParent())) return false;
      if (getPageSize() != other.getPageSize()) return false;
      if (!getPageToken().equals(other.getPageToken())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
      hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getPageSize();
      hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getPageToken().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A request message for listing patch deployments.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.ListPatchDeploymentsRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.ListPatchDeploymentsRequest)
        com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest.class,
                com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        parent_ = "";
        pageSize_ = 0;
        pageToken_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest build() {
        com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
          buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest result =
            new com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.parent_ = parent_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.pageSize_ = pageSize_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.pageToken_ = pageToken_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
                .getDefaultInstance()) return this;
        if (!other.getParent().isEmpty()) {
          parent_ = other.parent_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getPageSize() != 0) {
          setPageSize(other.getPageSize());
        }
        if (!other.getPageToken().isEmpty()) {
          pageToken_ = other.pageToken_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  parent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  pageSize_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  pageToken_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object parent_ = "";
      /**
       *
       *
       * <pre>
       * Required. The resource name of the parent in the form `projects/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The parent.
       */
      public java.lang.String getParent() {
        java.lang.Object ref = parent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the parent in the form `projects/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for parent.
       */
      public com.google.protobuf.ByteString getParentBytes() {
        java.lang.Object ref = parent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the parent in the form `projects/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The parent to set.
       * @return This builder for chaining.
       */
      public Builder setParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the parent in the form `projects/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParent() {
        parent_ = getDefaultInstance().getParent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the parent in the form `projects/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for parent to set.
       * @return This builder for chaining.
       */
      public Builder setParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int pageSize_;
      /**
       *
       *
       * <pre>
       * Optional. The maximum number of patch deployments to return. Default is
       * 100.
       * </pre>
       *
       * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The pageSize.
       */
      @java.lang.Override
      public int getPageSize() {
        return pageSize_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The maximum number of patch deployments to return. Default is
       * 100.
       * </pre>
       *
       * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The pageSize to set.
       * @return This builder for chaining.
       */
      public Builder setPageSize(int value) {

        pageSize_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The maximum number of patch deployments to return. Default is
       * 100.
       * </pre>
       *
       * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageSize() {
        bitField0_ = (bitField0_ & ~0x00000002);
        pageSize_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object pageToken_ = "";
      /**
       *
       *
       * <pre>
       * Optional. A pagination token returned from a previous call to
       * ListPatchDeployments that indicates where this listing should continue
       * from.
       * </pre>
       *
       * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The pageToken.
       */
      public java.lang.String getPageToken() {
        java.lang.Object ref = pageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pageToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A pagination token returned from a previous call to
       * ListPatchDeployments that indicates where this listing should continue
       * from.
       * </pre>
       *
       * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for pageToken.
       */
      public com.google.protobuf.ByteString getPageTokenBytes() {
        java.lang.Object ref = pageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A pagination token returned from a previous call to
       * ListPatchDeployments that indicates where this listing should continue
       * from.
       * </pre>
       *
       * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageToken_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A pagination token returned from a previous call to
       * ListPatchDeployments that indicates where this listing should continue
       * from.
       * </pre>
       *
       * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageToken() {
        pageToken_ = getDefaultInstance().getPageToken();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A pagination token returned from a previous call to
       * ListPatchDeployments that indicates where this listing should continue
       * from.
       * </pre>
       *
       * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        pageToken_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.ListPatchDeploymentsRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.ListPatchDeploymentsRequest)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListPatchDeploymentsRequest> PARSER =
        new com.google.protobuf.AbstractParser<ListPatchDeploymentsRequest>() {
          @java.lang.Override
          public ListPatchDeploymentsRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListPatchDeploymentsRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListPatchDeploymentsRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ListPatchDeploymentsResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.ListPatchDeploymentsResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The list of patch deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
     */
    java.util.List<com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment>
        getPatchDeploymentsList();
    /**
     *
     *
     * <pre>
     * The list of patch deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
     */
    com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment getPatchDeployments(int index);
    /**
     *
     *
     * <pre>
     * The list of patch deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
     */
    int getPatchDeploymentsCount();
    /**
     *
     *
     * <pre>
     * The list of patch deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
     */
    java.util.List<? extends com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder>
        getPatchDeploymentsOrBuilderList();
    /**
     *
     *
     * <pre>
     * The list of patch deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
     */
    com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder
        getPatchDeploymentsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A pagination token that can be used to get the next page of patch
     * deployments.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    java.lang.String getNextPageToken();
    /**
     *
     *
     * <pre>
     * A pagination token that can be used to get the next page of patch
     * deployments.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    com.google.protobuf.ByteString getNextPageTokenBytes();
  }
  /**
   *
   *
   * <pre>
   * A response message for listing patch deployments.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.ListPatchDeploymentsResponse}
   */
  public static final class ListPatchDeploymentsResponse
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.ListPatchDeploymentsResponse)
      ListPatchDeploymentsResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListPatchDeploymentsResponse.newBuilder() to construct.
    private ListPatchDeploymentsResponse(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListPatchDeploymentsResponse() {
      patchDeployments_ = java.util.Collections.emptyList();
      nextPageToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListPatchDeploymentsResponse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse.class,
              com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse.Builder
                  .class);
    }

    public static final int PATCH_DEPLOYMENTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment>
        patchDeployments_;
    /**
     *
     *
     * <pre>
     * The list of patch deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment>
        getPatchDeploymentsList() {
      return patchDeployments_;
    }
    /**
     *
     *
     * <pre>
     * The list of patch deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder>
        getPatchDeploymentsOrBuilderList() {
      return patchDeployments_;
    }
    /**
     *
     *
     * <pre>
     * The list of patch deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
     */
    @java.lang.Override
    public int getPatchDeploymentsCount() {
      return patchDeployments_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of patch deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment getPatchDeployments(
        int index) {
      return patchDeployments_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of patch deployments.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder
        getPatchDeploymentsOrBuilder(int index) {
      return patchDeployments_.get(index);
    }

    public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * A pagination token that can be used to get the next page of patch
     * deployments.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    @java.lang.Override
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A pagination token that can be used to get the next page of patch
     * deployments.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < patchDeployments_.size(); i++) {
        output.writeMessage(1, patchDeployments_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < patchDeployments_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, patchDeployments_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse other =
          (com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse) obj;

      if (!getPatchDeploymentsList().equals(other.getPatchDeploymentsList())) return false;
      if (!getNextPageToken().equals(other.getNextPageToken())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPatchDeploymentsCount() > 0) {
        hash = (37 * hash) + PATCH_DEPLOYMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getPatchDeploymentsList().hashCode();
      }
      hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getNextPageToken().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A response message for listing patch deployments.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.ListPatchDeploymentsResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.ListPatchDeploymentsResponse)
        com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse.class,
                com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (patchDeploymentsBuilder_ == null) {
          patchDeployments_ = java.util.Collections.emptyList();
        } else {
          patchDeployments_ = null;
          patchDeploymentsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        nextPageToken_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsResponse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse build() {
        com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
          buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse result =
            new com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse result) {
        if (patchDeploymentsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            patchDeployments_ = java.util.Collections.unmodifiableList(patchDeployments_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.patchDeployments_ = patchDeployments_;
        } else {
          result.patchDeployments_ = patchDeploymentsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.nextPageToken_ = nextPageToken_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
                .getDefaultInstance()) return this;
        if (patchDeploymentsBuilder_ == null) {
          if (!other.patchDeployments_.isEmpty()) {
            if (patchDeployments_.isEmpty()) {
              patchDeployments_ = other.patchDeployments_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePatchDeploymentsIsMutable();
              patchDeployments_.addAll(other.patchDeployments_);
            }
            onChanged();
          }
        } else {
          if (!other.patchDeployments_.isEmpty()) {
            if (patchDeploymentsBuilder_.isEmpty()) {
              patchDeploymentsBuilder_.dispose();
              patchDeploymentsBuilder_ = null;
              patchDeployments_ = other.patchDeployments_;
              bitField0_ = (bitField0_ & ~0x00000001);
              patchDeploymentsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPatchDeploymentsFieldBuilder()
                      : null;
            } else {
              patchDeploymentsBuilder_.addAllMessages(other.patchDeployments_);
            }
          }
        }
        if (!other.getNextPageToken().isEmpty()) {
          nextPageToken_ = other.nextPageToken_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment m =
                      input.readMessage(
                          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.parser(),
                          extensionRegistry);
                  if (patchDeploymentsBuilder_ == null) {
                    ensurePatchDeploymentsIsMutable();
                    patchDeployments_.add(m);
                  } else {
                    patchDeploymentsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  nextPageToken_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment>
          patchDeployments_ = java.util.Collections.emptyList();

      private void ensurePatchDeploymentsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          patchDeployments_ =
              new java.util.ArrayList<
                  com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment>(patchDeployments_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment,
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder>
          patchDeploymentsBuilder_;

      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public java.util.List<com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment>
          getPatchDeploymentsList() {
        if (patchDeploymentsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(patchDeployments_);
        } else {
          return patchDeploymentsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public int getPatchDeploymentsCount() {
        if (patchDeploymentsBuilder_ == null) {
          return patchDeployments_.size();
        } else {
          return patchDeploymentsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment getPatchDeployments(
          int index) {
        if (patchDeploymentsBuilder_ == null) {
          return patchDeployments_.get(index);
        } else {
          return patchDeploymentsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public Builder setPatchDeployments(
          int index, com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment value) {
        if (patchDeploymentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePatchDeploymentsIsMutable();
          patchDeployments_.set(index, value);
          onChanged();
        } else {
          patchDeploymentsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public Builder setPatchDeployments(
          int index,
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder builderForValue) {
        if (patchDeploymentsBuilder_ == null) {
          ensurePatchDeploymentsIsMutable();
          patchDeployments_.set(index, builderForValue.build());
          onChanged();
        } else {
          patchDeploymentsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public Builder addPatchDeployments(
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment value) {
        if (patchDeploymentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePatchDeploymentsIsMutable();
          patchDeployments_.add(value);
          onChanged();
        } else {
          patchDeploymentsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public Builder addPatchDeployments(
          int index, com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment value) {
        if (patchDeploymentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePatchDeploymentsIsMutable();
          patchDeployments_.add(index, value);
          onChanged();
        } else {
          patchDeploymentsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public Builder addPatchDeployments(
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder builderForValue) {
        if (patchDeploymentsBuilder_ == null) {
          ensurePatchDeploymentsIsMutable();
          patchDeployments_.add(builderForValue.build());
          onChanged();
        } else {
          patchDeploymentsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public Builder addPatchDeployments(
          int index,
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder builderForValue) {
        if (patchDeploymentsBuilder_ == null) {
          ensurePatchDeploymentsIsMutable();
          patchDeployments_.add(index, builderForValue.build());
          onChanged();
        } else {
          patchDeploymentsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public Builder addAllPatchDeployments(
          java.lang.Iterable<
                  ? extends com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment>
              values) {
        if (patchDeploymentsBuilder_ == null) {
          ensurePatchDeploymentsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, patchDeployments_);
          onChanged();
        } else {
          patchDeploymentsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public Builder clearPatchDeployments() {
        if (patchDeploymentsBuilder_ == null) {
          patchDeployments_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          patchDeploymentsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public Builder removePatchDeployments(int index) {
        if (patchDeploymentsBuilder_ == null) {
          ensurePatchDeploymentsIsMutable();
          patchDeployments_.remove(index);
          onChanged();
        } else {
          patchDeploymentsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder
          getPatchDeploymentsBuilder(int index) {
        return getPatchDeploymentsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder
          getPatchDeploymentsOrBuilder(int index) {
        if (patchDeploymentsBuilder_ == null) {
          return patchDeployments_.get(index);
        } else {
          return patchDeploymentsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder>
          getPatchDeploymentsOrBuilderList() {
        if (patchDeploymentsBuilder_ != null) {
          return patchDeploymentsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(patchDeployments_);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder
          addPatchDeploymentsBuilder() {
        return getPatchDeploymentsFieldBuilder()
            .addBuilder(
                com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder
          addPatchDeploymentsBuilder(int index) {
        return getPatchDeploymentsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The list of patch deployments.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchDeployment patch_deployments = 1;</code>
       */
      public java.util.List<com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder>
          getPatchDeploymentsBuilderList() {
        return getPatchDeploymentsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment,
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder>
          getPatchDeploymentsFieldBuilder() {
        if (patchDeploymentsBuilder_ == null) {
          patchDeploymentsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment,
                  com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder,
                  com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder>(
                  patchDeployments_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          patchDeployments_ = null;
        }
        return patchDeploymentsBuilder_;
      }

      private java.lang.Object nextPageToken_ = "";
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of patch
       * deployments.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return The nextPageToken.
       */
      public java.lang.String getNextPageToken() {
        java.lang.Object ref = nextPageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          nextPageToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of patch
       * deployments.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return The bytes for nextPageToken.
       */
      public com.google.protobuf.ByteString getNextPageTokenBytes() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          nextPageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of patch
       * deployments.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @param value The nextPageToken to set.
       * @return This builder for chaining.
       */
      public Builder setNextPageToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        nextPageToken_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of patch
       * deployments.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNextPageToken() {
        nextPageToken_ = getDefaultInstance().getNextPageToken();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of patch
       * deployments.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @param value The bytes for nextPageToken to set.
       * @return This builder for chaining.
       */
      public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        nextPageToken_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.ListPatchDeploymentsResponse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.ListPatchDeploymentsResponse)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListPatchDeploymentsResponse> PARSER =
        new com.google.protobuf.AbstractParser<ListPatchDeploymentsResponse>() {
          @java.lang.Override
          public ListPatchDeploymentsResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListPatchDeploymentsResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListPatchDeploymentsResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.ListPatchDeploymentsResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeletePatchDeploymentRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.DeletePatchDeploymentRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * A request message for deleting a patch deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.DeletePatchDeploymentRequest}
   */
  public static final class DeletePatchDeploymentRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.DeletePatchDeploymentRequest)
      DeletePatchDeploymentRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeletePatchDeploymentRequest.newBuilder() to construct.
    private DeletePatchDeploymentRequest(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeletePatchDeploymentRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeletePatchDeploymentRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_DeletePatchDeploymentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_DeletePatchDeploymentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest.class,
              com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest.Builder
                  .class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest other =
          (com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A request message for deleting a patch deployment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.DeletePatchDeploymentRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.DeletePatchDeploymentRequest)
        com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_DeletePatchDeploymentRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_DeletePatchDeploymentRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest.class,
                com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_DeletePatchDeploymentRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest build() {
        com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
          buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest result =
            new com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.DeletePatchDeploymentRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.DeletePatchDeploymentRequest)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeletePatchDeploymentRequest> PARSER =
        new com.google.protobuf.AbstractParser<DeletePatchDeploymentRequest>() {
          @java.lang.Override
          public DeletePatchDeploymentRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeletePatchDeploymentRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeletePatchDeploymentRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.DeletePatchDeploymentRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UpdatePatchDeploymentRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.UpdatePatchDeploymentRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The patch deployment to Update.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the patchDeployment field is set.
     */
    boolean hasPatchDeployment();
    /**
     *
     *
     * <pre>
     * Required. The patch deployment to Update.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The patchDeployment.
     */
    com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment getPatchDeployment();
    /**
     *
     *
     * <pre>
     * Required. The patch deployment to Update.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder
        getPatchDeploymentOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Field mask that controls which fields of the patch deployment
     * should be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    boolean hasUpdateMask();
    /**
     *
     *
     * <pre>
     * Optional. Field mask that controls which fields of the patch deployment
     * should be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The updateMask.
     */
    com.google.protobuf.FieldMask getUpdateMask();
    /**
     *
     *
     * <pre>
     * Optional. Field mask that controls which fields of the patch deployment
     * should be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A request message for updating a patch deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.UpdatePatchDeploymentRequest}
   */
  public static final class UpdatePatchDeploymentRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.UpdatePatchDeploymentRequest)
      UpdatePatchDeploymentRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UpdatePatchDeploymentRequest.newBuilder() to construct.
    private UpdatePatchDeploymentRequest(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UpdatePatchDeploymentRequest() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UpdatePatchDeploymentRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_UpdatePatchDeploymentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_UpdatePatchDeploymentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest.class,
              com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest.Builder
                  .class);
    }

    public static final int PATCH_DEPLOYMENT_FIELD_NUMBER = 1;
    private com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment patchDeployment_;
    /**
     *
     *
     * <pre>
     * Required. The patch deployment to Update.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the patchDeployment field is set.
     */
    @java.lang.Override
    public boolean hasPatchDeployment() {
      return patchDeployment_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The patch deployment to Update.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The patchDeployment.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment getPatchDeployment() {
      return patchDeployment_ == null
          ? com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.getDefaultInstance()
          : patchDeployment_;
    }
    /**
     *
     *
     * <pre>
     * Required. The patch deployment to Update.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder
        getPatchDeploymentOrBuilder() {
      return patchDeployment_ == null
          ? com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.getDefaultInstance()
          : patchDeployment_;
    }

    public static final int UPDATE_MASK_FIELD_NUMBER = 2;
    private com.google.protobuf.FieldMask updateMask_;
    /**
     *
     *
     * <pre>
     * Optional. Field mask that controls which fields of the patch deployment
     * should be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    @java.lang.Override
    public boolean hasUpdateMask() {
      return updateMask_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Field mask that controls which fields of the patch deployment
     * should be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The updateMask.
     */
    @java.lang.Override
    public com.google.protobuf.FieldMask getUpdateMask() {
      return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Field mask that controls which fields of the patch deployment
     * should be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (patchDeployment_ != null) {
        output.writeMessage(1, getPatchDeployment());
      }
      if (updateMask_ != null) {
        output.writeMessage(2, getUpdateMask());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (patchDeployment_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPatchDeployment());
      }
      if (updateMask_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpdateMask());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest other =
          (com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest) obj;

      if (hasPatchDeployment() != other.hasPatchDeployment()) return false;
      if (hasPatchDeployment()) {
        if (!getPatchDeployment().equals(other.getPatchDeployment())) return false;
      }
      if (hasUpdateMask() != other.hasUpdateMask()) return false;
      if (hasUpdateMask()) {
        if (!getUpdateMask().equals(other.getUpdateMask())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPatchDeployment()) {
        hash = (37 * hash) + PATCH_DEPLOYMENT_FIELD_NUMBER;
        hash = (53 * hash) + getPatchDeployment().hashCode();
      }
      if (hasUpdateMask()) {
        hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateMask().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A request message for updating a patch deployment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.UpdatePatchDeploymentRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.UpdatePatchDeploymentRequest)
        com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_UpdatePatchDeploymentRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_UpdatePatchDeploymentRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest.class,
                com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        patchDeployment_ = null;
        if (patchDeploymentBuilder_ != null) {
          patchDeploymentBuilder_.dispose();
          patchDeploymentBuilder_ = null;
        }
        updateMask_ = null;
        if (updateMaskBuilder_ != null) {
          updateMaskBuilder_.dispose();
          updateMaskBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_UpdatePatchDeploymentRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest build() {
        com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
          buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest result =
            new com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.patchDeployment_ =
              patchDeploymentBuilder_ == null ? patchDeployment_ : patchDeploymentBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.updateMask_ =
              updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
                .getDefaultInstance()) return this;
        if (other.hasPatchDeployment()) {
          mergePatchDeployment(other.getPatchDeployment());
        }
        if (other.hasUpdateMask()) {
          mergeUpdateMask(other.getUpdateMask());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getPatchDeploymentFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment patchDeployment_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment,
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder>
          patchDeploymentBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to Update.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the patchDeployment field is set.
       */
      public boolean hasPatchDeployment() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to Update.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The patchDeployment.
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment getPatchDeployment() {
        if (patchDeploymentBuilder_ == null) {
          return patchDeployment_ == null
              ? com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.getDefaultInstance()
              : patchDeployment_;
        } else {
          return patchDeploymentBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to Update.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setPatchDeployment(
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment value) {
        if (patchDeploymentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          patchDeployment_ = value;
        } else {
          patchDeploymentBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to Update.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setPatchDeployment(
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder builderForValue) {
        if (patchDeploymentBuilder_ == null) {
          patchDeployment_ = builderForValue.build();
        } else {
          patchDeploymentBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to Update.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergePatchDeployment(
          com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment value) {
        if (patchDeploymentBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && patchDeployment_ != null
              && patchDeployment_
                  != com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment
                      .getDefaultInstance()) {
            getPatchDeploymentBuilder().mergeFrom(value);
          } else {
            patchDeployment_ = value;
          }
        } else {
          patchDeploymentBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to Update.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearPatchDeployment() {
        bitField0_ = (bitField0_ & ~0x00000001);
        patchDeployment_ = null;
        if (patchDeploymentBuilder_ != null) {
          patchDeploymentBuilder_.dispose();
          patchDeploymentBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to Update.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder
          getPatchDeploymentBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getPatchDeploymentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to Update.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder
          getPatchDeploymentOrBuilder() {
        if (patchDeploymentBuilder_ != null) {
          return patchDeploymentBuilder_.getMessageOrBuilder();
        } else {
          return patchDeployment_ == null
              ? com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.getDefaultInstance()
              : patchDeployment_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The patch deployment to Update.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchDeployment patch_deployment = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment,
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder,
              com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder>
          getPatchDeploymentFieldBuilder() {
        if (patchDeploymentBuilder_ == null) {
          patchDeploymentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment,
                  com.google.cloud.osconfig.v1.PatchDeployments.PatchDeployment.Builder,
                  com.google.cloud.osconfig.v1.PatchDeployments.PatchDeploymentOrBuilder>(
                  getPatchDeployment(), getParentForChildren(), isClean());
          patchDeployment_ = null;
        }
        return patchDeploymentBuilder_;
      }

      private com.google.protobuf.FieldMask updateMask_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FieldMask,
              com.google.protobuf.FieldMask.Builder,
              com.google.protobuf.FieldMaskOrBuilder>
          updateMaskBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Field mask that controls which fields of the patch deployment
       * should be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the updateMask field is set.
       */
      public boolean hasUpdateMask() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Field mask that controls which fields of the patch deployment
       * should be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The updateMask.
       */
      public com.google.protobuf.FieldMask getUpdateMask() {
        if (updateMaskBuilder_ == null) {
          return updateMask_ == null
              ? com.google.protobuf.FieldMask.getDefaultInstance()
              : updateMask_;
        } else {
          return updateMaskBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Field mask that controls which fields of the patch deployment
       * should be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
        if (updateMaskBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateMask_ = value;
        } else {
          updateMaskBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Field mask that controls which fields of the patch deployment
       * should be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
        if (updateMaskBuilder_ == null) {
          updateMask_ = builderForValue.build();
        } else {
          updateMaskBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Field mask that controls which fields of the patch deployment
       * should be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
        if (updateMaskBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && updateMask_ != null
              && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
            getUpdateMaskBuilder().mergeFrom(value);
          } else {
            updateMask_ = value;
          }
        } else {
          updateMaskBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Field mask that controls which fields of the patch deployment
       * should be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearUpdateMask() {
        bitField0_ = (bitField0_ & ~0x00000002);
        updateMask_ = null;
        if (updateMaskBuilder_ != null) {
          updateMaskBuilder_.dispose();
          updateMaskBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Field mask that controls which fields of the patch deployment
       * should be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getUpdateMaskFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Field mask that controls which fields of the patch deployment
       * should be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
        if (updateMaskBuilder_ != null) {
          return updateMaskBuilder_.getMessageOrBuilder();
        } else {
          return updateMask_ == null
              ? com.google.protobuf.FieldMask.getDefaultInstance()
              : updateMask_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Field mask that controls which fields of the patch deployment
       * should be updated.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FieldMask,
              com.google.protobuf.FieldMask.Builder,
              com.google.protobuf.FieldMaskOrBuilder>
          getUpdateMaskFieldBuilder() {
        if (updateMaskBuilder_ == null) {
          updateMaskBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.FieldMask,
                  com.google.protobuf.FieldMask.Builder,
                  com.google.protobuf.FieldMaskOrBuilder>(
                  getUpdateMask(), getParentForChildren(), isClean());
          updateMask_ = null;
        }
        return updateMaskBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.UpdatePatchDeploymentRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.UpdatePatchDeploymentRequest)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UpdatePatchDeploymentRequest> PARSER =
        new com.google.protobuf.AbstractParser<UpdatePatchDeploymentRequest>() {
          @java.lang.Override
          public UpdatePatchDeploymentRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UpdatePatchDeploymentRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UpdatePatchDeploymentRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.UpdatePatchDeploymentRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PausePatchDeploymentRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.PausePatchDeploymentRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * A request message for pausing a patch deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.PausePatchDeploymentRequest}
   */
  public static final class PausePatchDeploymentRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.PausePatchDeploymentRequest)
      PausePatchDeploymentRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PausePatchDeploymentRequest.newBuilder() to construct.
    private PausePatchDeploymentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PausePatchDeploymentRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PausePatchDeploymentRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_PausePatchDeploymentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_PausePatchDeploymentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest.class,
              com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest.Builder
                  .class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest other =
          (com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A request message for pausing a patch deployment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.PausePatchDeploymentRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.PausePatchDeploymentRequest)
        com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_PausePatchDeploymentRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_PausePatchDeploymentRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest.class,
                com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_PausePatchDeploymentRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest build() {
        com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
          buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest result =
            new com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.PausePatchDeploymentRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.PausePatchDeploymentRequest)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PausePatchDeploymentRequest> PARSER =
        new com.google.protobuf.AbstractParser<PausePatchDeploymentRequest>() {
          @java.lang.Override
          public PausePatchDeploymentRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PausePatchDeploymentRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PausePatchDeploymentRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.PausePatchDeploymentRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ResumePatchDeploymentRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.ResumePatchDeploymentRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * A request message for resuming a patch deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.ResumePatchDeploymentRequest}
   */
  public static final class ResumePatchDeploymentRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.ResumePatchDeploymentRequest)
      ResumePatchDeploymentRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ResumePatchDeploymentRequest.newBuilder() to construct.
    private ResumePatchDeploymentRequest(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ResumePatchDeploymentRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ResumePatchDeploymentRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_ResumePatchDeploymentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchDeployments
          .internal_static_google_cloud_osconfig_v1_ResumePatchDeploymentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest.class,
              com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest.Builder
                  .class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the patch deployment in the form
     * `projects/&#42;&#47;patchDeployments/&#42;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest other =
          (com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A request message for resuming a patch deployment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.ResumePatchDeploymentRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.ResumePatchDeploymentRequest)
        com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_ResumePatchDeploymentRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_ResumePatchDeploymentRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest.class,
                com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments
            .internal_static_google_cloud_osconfig_v1_ResumePatchDeploymentRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest build() {
        com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
          buildPartial() {
        com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest result =
            new com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name of the patch deployment in the form
       * `projects/&#42;&#47;patchDeployments/&#42;`.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.ResumePatchDeploymentRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.ResumePatchDeploymentRequest)
    private static final com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest();
    }

    public static com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ResumePatchDeploymentRequest> PARSER =
        new com.google.protobuf.AbstractParser<ResumePatchDeploymentRequest>() {
          @java.lang.Override
          public ResumePatchDeploymentRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ResumePatchDeploymentRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ResumePatchDeploymentRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchDeployments.ResumePatchDeploymentRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_PatchDeployment_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_PatchDeployment_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_OneTimeSchedule_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_OneTimeSchedule_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_RecurringSchedule_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_RecurringSchedule_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_WeeklySchedule_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_WeeklySchedule_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_MonthlySchedule_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_MonthlySchedule_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_WeekDayOfMonth_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_WeekDayOfMonth_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_CreatePatchDeploymentRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_CreatePatchDeploymentRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_GetPatchDeploymentRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_GetPatchDeploymentRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsResponse_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsResponse_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_DeletePatchDeploymentRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_DeletePatchDeploymentRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_UpdatePatchDeploymentRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_UpdatePatchDeploymentRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_PausePatchDeploymentRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_PausePatchDeploymentRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_osconfig_v1_ResumePatchDeploymentRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_osconfig_v1_ResumePatchDeploymentRequest_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor getDescriptor() {
    return descriptor;
  }

  private static com.google.protobuf.Descriptors.FileDescriptor descriptor;

  static {
    java.lang.String[] descriptorData = {
      "\n0google/cloud/osconfig/v1/patch_deploym"
          + "ents.proto\022\030google.cloud.osconfig.v1\032\037go"
          + "ogle/api/field_behavior.proto\032\031google/ap"
          + "i/resource.proto\032)google/cloud/osconfig/"
          + "v1/patch_jobs.proto\032\036google/protobuf/dur"
          + "ation.proto\032 google/protobuf/field_mask."
          + "proto\032\037google/protobuf/timestamp.proto\032\032"
          + "google/type/datetime.proto\032\033google/type/"
          + "dayofweek.proto\032\033google/type/timeofday.p"
          + "roto\"\367\006\n\017PatchDeployment\022\014\n\004name\030\001 \001(\t\022\031"
          + "\n\013description\030\002 \001(\tB\004\342A\001\001\022L\n\017instance_fi"
          + "lter\030\003 \001(\0132-.google.cloud.osconfig.v1.Pa"
          + "tchInstanceFilterB\004\342A\001\002\022A\n\014patch_config\030"
          + "\004 \001(\0132%.google.cloud.osconfig.v1.PatchCo"
          + "nfigB\004\342A\001\001\0221\n\010duration\030\005 \001(\0132\031.google.pr"
          + "otobuf.DurationB\004\342A\001\001\022L\n\021one_time_schedu"
          + "le\030\006 \001(\0132).google.cloud.osconfig.v1.OneT"
          + "imeScheduleB\004\342A\001\002H\000\022O\n\022recurring_schedul"
          + "e\030\007 \001(\0132+.google.cloud.osconfig.v1.Recur"
          + "ringScheduleB\004\342A\001\002H\000\0225\n\013create_time\030\010 \001("
          + "\0132\032.google.protobuf.TimestampB\004\342A\001\003\0225\n\013u"
          + "pdate_time\030\t \001(\0132\032.google.protobuf.Times"
          + "tampB\004\342A\001\003\022;\n\021last_execute_time\030\n \001(\0132\032."
          + "google.protobuf.TimestampB\004\342A\001\003\022=\n\007rollo"
          + "ut\030\013 \001(\0132&.google.cloud.osconfig.v1.Patc"
          + "hRolloutB\004\342A\001\001\022D\n\005state\030\014 \001(\0162/.google.c"
          + "loud.osconfig.v1.PatchDeployment.StateB\004"
          + "\342A\001\003\"6\n\005State\022\025\n\021STATE_UNSPECIFIED\020\000\022\n\n\006"
          + "ACTIVE\020\001\022\n\n\006PAUSED\020\002:d\352Aa\n\'osconfig.goog"
          + "leapis.com/PatchDeployment\0226projects/{pr"
          + "oject}/patchDeployments/{patch_deploymen"
          + "t}B\n\n\010schedule\"I\n\017OneTimeSchedule\0226\n\014exe"
          + "cute_time\030\001 \001(\0132\032.google.protobuf.Timest"
          + "ampB\004\342A\001\002\"\217\005\n\021RecurringSchedule\022.\n\ttime_"
          + "zone\030\001 \001(\0132\025.google.type.TimeZoneB\004\342A\001\002\022"
          + "4\n\nstart_time\030\002 \001(\0132\032.google.protobuf.Ti"
          + "mestampB\004\342A\001\001\0222\n\010end_time\030\003 \001(\0132\032.google"
          + ".protobuf.TimestampB\004\342A\001\001\0221\n\013time_of_day"
          + "\030\004 \001(\0132\026.google.type.TimeOfDayB\004\342A\001\002\022N\n\t"
          + "frequency\030\005 \001(\01625.google.cloud.osconfig."
          + "v1.RecurringSchedule.FrequencyB\004\342A\001\002\022@\n\006"
          + "weekly\030\006 \001(\0132(.google.cloud.osconfig.v1."
          + "WeeklyScheduleB\004\342A\001\002H\000\022B\n\007monthly\030\007 \001(\0132"
          + ").google.cloud.osconfig.v1.MonthlySchedu"
          + "leB\004\342A\001\002H\000\022;\n\021last_execute_time\030\t \001(\0132\032."
          + "google.protobuf.TimestampB\004\342A\001\003\022;\n\021next_"
          + "execute_time\030\n \001(\0132\032.google.protobuf.Tim"
          + "estampB\004\342A\001\003\"J\n\tFrequency\022\031\n\025FREQUENCY_U"
          + "NSPECIFIED\020\000\022\n\n\006WEEKLY\020\001\022\013\n\007MONTHLY\020\002\022\t\n"
          + "\005DAILY\020\003B\021\n\017schedule_config\"C\n\016WeeklySch"
          + "edule\0221\n\013day_of_week\030\001 \001(\0162\026.google.type"
          + ".DayOfWeekB\004\342A\001\002\"\211\001\n\017MonthlySchedule\022K\n\021"
          + "week_day_of_month\030\001 \001(\0132(.google.cloud.o"
          + "sconfig.v1.WeekDayOfMonthB\004\342A\001\002H\000\022\031\n\tmon"
          + "th_day\030\002 \001(\005B\004\342A\001\002H\000B\016\n\014day_of_month\"y\n\016"
          + "WeekDayOfMonth\022\032\n\014week_ordinal\030\001 \001(\005B\004\342A"
          + "\001\002\0221\n\013day_of_week\030\002 \001(\0162\026.google.type.Da"
          + "yOfWeekB\004\342A\001\002\022\030\n\nday_offset\030\003 \001(\005B\004\342A\001\001\""
          + "\322\001\n\034CreatePatchDeploymentRequest\022D\n\006pare"
          + "nt\030\001 \001(\tB4\342A\001\002\372A-\n+cloudresourcemanager."
          + "googleapis.com/Project\022!\n\023patch_deployme"
          + "nt_id\030\002 \001(\tB\004\342A\001\002\022I\n\020patch_deployment\030\003 "
          + "\001(\0132).google.cloud.osconfig.v1.PatchDepl"
          + "oymentB\004\342A\001\002\"[\n\031GetPatchDeploymentReques"
          + "t\022>\n\004name\030\001 \001(\tB0\342A\001\002\372A)\n\'osconfig.googl"
          + "eapis.com/PatchDeployment\"\226\001\n\033ListPatchD"
          + "eploymentsRequest\022D\n\006parent\030\001 \001(\tB4\342A\001\002\372"
          + "A-\n+cloudresourcemanager.googleapis.com/"
          + "Project\022\027\n\tpage_size\030\002 \001(\005B\004\342A\001\001\022\030\n\npage"
          + "_token\030\003 \001(\tB\004\342A\001\001\"}\n\034ListPatchDeploymen"
          + "tsResponse\022D\n\021patch_deployments\030\001 \003(\0132)."
          + "google.cloud.osconfig.v1.PatchDeployment"
          + "\022\027\n\017next_page_token\030\002 \001(\t\"^\n\034DeletePatch"
          + "DeploymentRequest\022>\n\004name\030\001 \001(\tB0\342A\001\002\372A)"
          + "\n\'osconfig.googleapis.com/PatchDeploymen"
          + "t\"\240\001\n\034UpdatePatchDeploymentRequest\022I\n\020pa"
          + "tch_deployment\030\001 \001(\0132).google.cloud.osco"
          + "nfig.v1.PatchDeploymentB\004\342A\001\002\0225\n\013update_"
          + "mask\030\002 \001(\0132\032.google.protobuf.FieldMaskB\004"
          + "\342A\001\001\"]\n\033PausePatchDeploymentRequest\022>\n\004n"
          + "ame\030\001 \001(\tB0\342A\001\002\372A)\n\'osconfig.googleapis."
          + "com/PatchDeployment\"^\n\034ResumePatchDeploy"
          + "mentRequest\022>\n\004name\030\001 \001(\tB0\342A\001\002\372A)\n\'osco"
          + "nfig.googleapis.com/PatchDeploymentB\276\001\n\034"
          + "com.google.cloud.osconfig.v1B\020PatchDeplo"
          + "ymentsZ8cloud.google.com/go/osconfig/api"
          + "v1/osconfigpb;osconfigpb\252\002\030Google.Cloud."
          + "OsConfig.V1\312\002\030Google\\Cloud\\OsConfig\\V1\352\002"
          + "\033Google::Cloud::OsConfig::V1b\006proto3"
    };
    descriptor =
        com.google.protobuf.Descriptors.FileDescriptor.internalBuildGeneratedFileFrom(
            descriptorData,
            new com.google.protobuf.Descriptors.FileDescriptor[] {
              com.google.api.FieldBehaviorProto.getDescriptor(),
              com.google.api.ResourceProto.getDescriptor(),
              com.google.cloud.osconfig.v1.PatchJobs.getDescriptor(),
              com.google.protobuf.DurationProto.getDescriptor(),
              com.google.protobuf.FieldMaskProto.getDescriptor(),
              com.google.protobuf.TimestampProto.getDescriptor(),
              com.google.type.DateTimeProto.getDescriptor(),
              com.google.type.DayOfWeekProto.getDescriptor(),
              com.google.type.TimeOfDayProto.getDescriptor(),
            });
    internal_static_google_cloud_osconfig_v1_PatchDeployment_descriptor =
        getDescriptor().getMessageTypes().get(0);
    internal_static_google_cloud_osconfig_v1_PatchDeployment_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_PatchDeployment_descriptor,
            new java.lang.String[] {
              "Name",
              "Description",
              "InstanceFilter",
              "PatchConfig",
              "Duration",
              "OneTimeSchedule",
              "RecurringSchedule",
              "CreateTime",
              "UpdateTime",
              "LastExecuteTime",
              "Rollout",
              "State",
              "Schedule",
            });
    internal_static_google_cloud_osconfig_v1_OneTimeSchedule_descriptor =
        getDescriptor().getMessageTypes().get(1);
    internal_static_google_cloud_osconfig_v1_OneTimeSchedule_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_OneTimeSchedule_descriptor,
            new java.lang.String[] {
              "ExecuteTime",
            });
    internal_static_google_cloud_osconfig_v1_RecurringSchedule_descriptor =
        getDescriptor().getMessageTypes().get(2);
    internal_static_google_cloud_osconfig_v1_RecurringSchedule_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_RecurringSchedule_descriptor,
            new java.lang.String[] {
              "TimeZone",
              "StartTime",
              "EndTime",
              "TimeOfDay",
              "Frequency",
              "Weekly",
              "Monthly",
              "LastExecuteTime",
              "NextExecuteTime",
              "ScheduleConfig",
            });
    internal_static_google_cloud_osconfig_v1_WeeklySchedule_descriptor =
        getDescriptor().getMessageTypes().get(3);
    internal_static_google_cloud_osconfig_v1_WeeklySchedule_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_WeeklySchedule_descriptor,
            new java.lang.String[] {
              "DayOfWeek",
            });
    internal_static_google_cloud_osconfig_v1_MonthlySchedule_descriptor =
        getDescriptor().getMessageTypes().get(4);
    internal_static_google_cloud_osconfig_v1_MonthlySchedule_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_MonthlySchedule_descriptor,
            new java.lang.String[] {
              "WeekDayOfMonth", "MonthDay", "DayOfMonth",
            });
    internal_static_google_cloud_osconfig_v1_WeekDayOfMonth_descriptor =
        getDescriptor().getMessageTypes().get(5);
    internal_static_google_cloud_osconfig_v1_WeekDayOfMonth_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_WeekDayOfMonth_descriptor,
            new java.lang.String[] {
              "WeekOrdinal", "DayOfWeek", "DayOffset",
            });
    internal_static_google_cloud_osconfig_v1_CreatePatchDeploymentRequest_descriptor =
        getDescriptor().getMessageTypes().get(6);
    internal_static_google_cloud_osconfig_v1_CreatePatchDeploymentRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_CreatePatchDeploymentRequest_descriptor,
            new java.lang.String[] {
              "Parent", "PatchDeploymentId", "PatchDeployment",
            });
    internal_static_google_cloud_osconfig_v1_GetPatchDeploymentRequest_descriptor =
        getDescriptor().getMessageTypes().get(7);
    internal_static_google_cloud_osconfig_v1_GetPatchDeploymentRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_GetPatchDeploymentRequest_descriptor,
            new java.lang.String[] {
              "Name",
            });
    internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsRequest_descriptor =
        getDescriptor().getMessageTypes().get(8);
    internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsRequest_descriptor,
            new java.lang.String[] {
              "Parent", "PageSize", "PageToken",
            });
    internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsResponse_descriptor =
        getDescriptor().getMessageTypes().get(9);
    internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsResponse_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_ListPatchDeploymentsResponse_descriptor,
            new java.lang.String[] {
              "PatchDeployments", "NextPageToken",
            });
    internal_static_google_cloud_osconfig_v1_DeletePatchDeploymentRequest_descriptor =
        getDescriptor().getMessageTypes().get(10);
    internal_static_google_cloud_osconfig_v1_DeletePatchDeploymentRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_DeletePatchDeploymentRequest_descriptor,
            new java.lang.String[] {
              "Name",
            });
    internal_static_google_cloud_osconfig_v1_UpdatePatchDeploymentRequest_descriptor =
        getDescriptor().getMessageTypes().get(11);
    internal_static_google_cloud_osconfig_v1_UpdatePatchDeploymentRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_UpdatePatchDeploymentRequest_descriptor,
            new java.lang.String[] {
              "PatchDeployment", "UpdateMask",
            });
    internal_static_google_cloud_osconfig_v1_PausePatchDeploymentRequest_descriptor =
        getDescriptor().getMessageTypes().get(12);
    internal_static_google_cloud_osconfig_v1_PausePatchDeploymentRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_PausePatchDeploymentRequest_descriptor,
            new java.lang.String[] {
              "Name",
            });
    internal_static_google_cloud_osconfig_v1_ResumePatchDeploymentRequest_descriptor =
        getDescriptor().getMessageTypes().get(13);
    internal_static_google_cloud_osconfig_v1_ResumePatchDeploymentRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_osconfig_v1_ResumePatchDeploymentRequest_descriptor,
            new java.lang.String[] {
              "Name",
            });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.google.api.FieldBehaviorProto.fieldBehavior);
    registry.add(com.google.api.ResourceProto.resource);
    registry.add(com.google.api.ResourceProto.resourceReference);
    com.google.protobuf.Descriptors.FileDescriptor.internalUpdateFileDescriptor(
        descriptor, registry);
    com.google.api.FieldBehaviorProto.getDescriptor();
    com.google.api.ResourceProto.getDescriptor();
    com.google.cloud.osconfig.v1.PatchJobs.getDescriptor();
    com.google.protobuf.DurationProto.getDescriptor();
    com.google.protobuf.FieldMaskProto.getDescriptor();
    com.google.protobuf.TimestampProto.getDescriptor();
    com.google.type.DateTimeProto.getDescriptor();
    com.google.type.DayOfWeekProto.getDescriptor();
    com.google.type.TimeOfDayProto.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
