/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1/patch_jobs.proto

package com.google.cloud.osconfig.v1;

public final class PatchJobs {
  private PatchJobs() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  public interface ExecutePatchJobRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.ExecutePatchJobRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The project in which to run this patch in the form `projects/&#42;`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    java.lang.String getParent();
    /**
     *
     *
     * <pre>
     * Required. The project in which to run this patch in the form `projects/&#42;`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    com.google.protobuf.ByteString getParentBytes();

    /**
     *
     *
     * <pre>
     * Description of the patch job. Length of the description is limited
     * to 1024 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * Description of the patch job. Length of the description is limited
     * to 1024 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * Required. Instances to patch, either explicitly or filtered by some
     * criteria such as zone or labels.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the instanceFilter field is set.
     */
    boolean hasInstanceFilter();
    /**
     *
     *
     * <pre>
     * Required. Instances to patch, either explicitly or filtered by some
     * criteria such as zone or labels.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The instanceFilter.
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter getInstanceFilter();
    /**
     *
     *
     * <pre>
     * Required. Instances to patch, either explicitly or filtered by some
     * criteria such as zone or labels.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder
        getInstanceFilterOrBuilder();

    /**
     *
     *
     * <pre>
     * Patch configuration being applied. If omitted, instances are
     * patched using the default configurations.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
     *
     * @return Whether the patchConfig field is set.
     */
    boolean hasPatchConfig();
    /**
     *
     *
     * <pre>
     * Patch configuration being applied. If omitted, instances are
     * patched using the default configurations.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
     *
     * @return The patchConfig.
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchConfig getPatchConfig();
    /**
     *
     *
     * <pre>
     * Patch configuration being applied. If omitted, instances are
     * patched using the default configurations.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder getPatchConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Duration of the patch job. After the duration ends, the patch job
     * times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     *
     * @return Whether the duration field is set.
     */
    boolean hasDuration();
    /**
     *
     *
     * <pre>
     * Duration of the patch job. After the duration ends, the patch job
     * times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     *
     * @return The duration.
     */
    com.google.protobuf.Duration getDuration();
    /**
     *
     *
     * <pre>
     * Duration of the patch job. After the duration ends, the patch job
     * times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     */
    com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * If this patch is a dry-run only, instances are contacted but
     * will do nothing.
     * </pre>
     *
     * <code>bool dry_run = 6;</code>
     *
     * @return The dryRun.
     */
    boolean getDryRun();

    /**
     *
     *
     * <pre>
     * Display name for this patch job. This does not have to be unique.
     * </pre>
     *
     * <code>string display_name = 8;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * Display name for this patch job. This does not have to be unique.
     * </pre>
     *
     * <code>string display_name = 8;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Rollout strategy of the patch job.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
     *
     * @return Whether the rollout field is set.
     */
    boolean hasRollout();
    /**
     *
     *
     * <pre>
     * Rollout strategy of the patch job.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
     *
     * @return The rollout.
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchRollout getRollout();
    /**
     *
     *
     * <pre>
     * Rollout strategy of the patch job.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder getRolloutOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A request message to initiate patching across Compute Engine
   * instances.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.ExecutePatchJobRequest}
   */
  public static final class ExecutePatchJobRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.ExecutePatchJobRequest)
      ExecutePatchJobRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExecutePatchJobRequest.newBuilder() to construct.
    private ExecutePatchJobRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExecutePatchJobRequest() {
      parent_ = "";
      description_ = "";
      displayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExecutePatchJobRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ExecutePatchJobRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ExecutePatchJobRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest.class,
              com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest.Builder.class);
    }

    public static final int PARENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The project in which to run this patch in the form `projects/&#42;`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    @java.lang.Override
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The project in which to run this patch in the form `projects/&#42;`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of the patch job. Length of the description is limited
     * to 1024 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the patch job. Length of the description is limited
     * to 1024 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INSTANCE_FILTER_FIELD_NUMBER = 7;
    private com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter instanceFilter_;
    /**
     *
     *
     * <pre>
     * Required. Instances to patch, either explicitly or filtered by some
     * criteria such as zone or labels.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the instanceFilter field is set.
     */
    @java.lang.Override
    public boolean hasInstanceFilter() {
      return instanceFilter_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Instances to patch, either explicitly or filtered by some
     * criteria such as zone or labels.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The instanceFilter.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter getInstanceFilter() {
      return instanceFilter_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.getDefaultInstance()
          : instanceFilter_;
    }
    /**
     *
     *
     * <pre>
     * Required. Instances to patch, either explicitly or filtered by some
     * criteria such as zone or labels.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder
        getInstanceFilterOrBuilder() {
      return instanceFilter_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.getDefaultInstance()
          : instanceFilter_;
    }

    public static final int PATCH_CONFIG_FIELD_NUMBER = 4;
    private com.google.cloud.osconfig.v1.PatchJobs.PatchConfig patchConfig_;
    /**
     *
     *
     * <pre>
     * Patch configuration being applied. If omitted, instances are
     * patched using the default configurations.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
     *
     * @return Whether the patchConfig field is set.
     */
    @java.lang.Override
    public boolean hasPatchConfig() {
      return patchConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Patch configuration being applied. If omitted, instances are
     * patched using the default configurations.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
     *
     * @return The patchConfig.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig getPatchConfig() {
      return patchConfig_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()
          : patchConfig_;
    }
    /**
     *
     *
     * <pre>
     * Patch configuration being applied. If omitted, instances are
     * patched using the default configurations.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder getPatchConfigOrBuilder() {
      return patchConfig_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()
          : patchConfig_;
    }

    public static final int DURATION_FIELD_NUMBER = 5;
    private com.google.protobuf.Duration duration_;
    /**
     *
     *
     * <pre>
     * Duration of the patch job. After the duration ends, the patch job
     * times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     *
     * @return Whether the duration field is set.
     */
    @java.lang.Override
    public boolean hasDuration() {
      return duration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Duration of the patch job. After the duration ends, the patch job
     * times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     *
     * @return The duration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getDuration() {
      return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
    }
    /**
     *
     *
     * <pre>
     * Duration of the patch job. After the duration ends, the patch job
     * times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
      return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
    }

    public static final int DRY_RUN_FIELD_NUMBER = 6;
    private boolean dryRun_ = false;
    /**
     *
     *
     * <pre>
     * If this patch is a dry-run only, instances are contacted but
     * will do nothing.
     * </pre>
     *
     * <code>bool dry_run = 6;</code>
     *
     * @return The dryRun.
     */
    @java.lang.Override
    public boolean getDryRun() {
      return dryRun_;
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 8;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Display name for this patch job. This does not have to be unique.
     * </pre>
     *
     * <code>string display_name = 8;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name for this patch job. This does not have to be unique.
     * </pre>
     *
     * <code>string display_name = 8;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ROLLOUT_FIELD_NUMBER = 9;
    private com.google.cloud.osconfig.v1.PatchJobs.PatchRollout rollout_;
    /**
     *
     *
     * <pre>
     * Rollout strategy of the patch job.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
     *
     * @return Whether the rollout field is set.
     */
    @java.lang.Override
    public boolean hasRollout() {
      return rollout_ != null;
    }
    /**
     *
     *
     * <pre>
     * Rollout strategy of the patch job.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
     *
     * @return The rollout.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchRollout getRollout() {
      return rollout_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()
          : rollout_;
    }
    /**
     *
     *
     * <pre>
     * Rollout strategy of the patch job.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder getRolloutOrBuilder() {
      return rollout_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()
          : rollout_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
      }
      if (patchConfig_ != null) {
        output.writeMessage(4, getPatchConfig());
      }
      if (duration_ != null) {
        output.writeMessage(5, getDuration());
      }
      if (dryRun_ != false) {
        output.writeBool(6, dryRun_);
      }
      if (instanceFilter_ != null) {
        output.writeMessage(7, getInstanceFilter());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, displayName_);
      }
      if (rollout_ != null) {
        output.writeMessage(9, getRollout());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
      }
      if (patchConfig_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPatchConfig());
      }
      if (duration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDuration());
      }
      if (dryRun_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, dryRun_);
      }
      if (instanceFilter_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getInstanceFilter());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, displayName_);
      }
      if (rollout_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getRollout());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest other =
          (com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest) obj;

      if (!getParent().equals(other.getParent())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (hasInstanceFilter() != other.hasInstanceFilter()) return false;
      if (hasInstanceFilter()) {
        if (!getInstanceFilter().equals(other.getInstanceFilter())) return false;
      }
      if (hasPatchConfig() != other.hasPatchConfig()) return false;
      if (hasPatchConfig()) {
        if (!getPatchConfig().equals(other.getPatchConfig())) return false;
      }
      if (hasDuration() != other.hasDuration()) return false;
      if (hasDuration()) {
        if (!getDuration().equals(other.getDuration())) return false;
      }
      if (getDryRun() != other.getDryRun()) return false;
      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (hasRollout() != other.hasRollout()) return false;
      if (hasRollout()) {
        if (!getRollout().equals(other.getRollout())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      if (hasInstanceFilter()) {
        hash = (37 * hash) + INSTANCE_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getInstanceFilter().hashCode();
      }
      if (hasPatchConfig()) {
        hash = (37 * hash) + PATCH_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getPatchConfig().hashCode();
      }
      if (hasDuration()) {
        hash = (37 * hash) + DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getDuration().hashCode();
      }
      hash = (37 * hash) + DRY_RUN_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDryRun());
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      if (hasRollout()) {
        hash = (37 * hash) + ROLLOUT_FIELD_NUMBER;
        hash = (53 * hash) + getRollout().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A request message to initiate patching across Compute Engine
     * instances.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.ExecutePatchJobRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.ExecutePatchJobRequest)
        com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ExecutePatchJobRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ExecutePatchJobRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest.class,
                com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        parent_ = "";
        description_ = "";
        instanceFilter_ = null;
        if (instanceFilterBuilder_ != null) {
          instanceFilterBuilder_.dispose();
          instanceFilterBuilder_ = null;
        }
        patchConfig_ = null;
        if (patchConfigBuilder_ != null) {
          patchConfigBuilder_.dispose();
          patchConfigBuilder_ = null;
        }
        duration_ = null;
        if (durationBuilder_ != null) {
          durationBuilder_.dispose();
          durationBuilder_ = null;
        }
        dryRun_ = false;
        displayName_ = "";
        rollout_ = null;
        if (rolloutBuilder_ != null) {
          rolloutBuilder_.dispose();
          rolloutBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ExecutePatchJobRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest build() {
        com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest result =
            new com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.parent_ = parent_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.instanceFilter_ =
              instanceFilterBuilder_ == null ? instanceFilter_ : instanceFilterBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.patchConfig_ =
              patchConfigBuilder_ == null ? patchConfig_ : patchConfigBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.dryRun_ = dryRun_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.displayName_ = displayName_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.rollout_ = rolloutBuilder_ == null ? rollout_ : rolloutBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest.getDefaultInstance())
          return this;
        if (!other.getParent().isEmpty()) {
          parent_ = other.parent_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasInstanceFilter()) {
          mergeInstanceFilter(other.getInstanceFilter());
        }
        if (other.hasPatchConfig()) {
          mergePatchConfig(other.getPatchConfig());
        }
        if (other.hasDuration()) {
          mergeDuration(other.getDuration());
        }
        if (other.getDryRun() != false) {
          setDryRun(other.getDryRun());
        }
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000040;
          onChanged();
        }
        if (other.hasRollout()) {
          mergeRollout(other.getRollout());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  parent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 34:
                {
                  input.readMessage(getPatchConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 48:
                {
                  dryRun_ = input.readBool();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 48
              case 58:
                {
                  input.readMessage(
                      getInstanceFilterFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 58
              case 66:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(getRolloutFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 74
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object parent_ = "";
      /**
       *
       *
       * <pre>
       * Required. The project in which to run this patch in the form `projects/&#42;`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The parent.
       */
      public java.lang.String getParent() {
        java.lang.Object ref = parent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The project in which to run this patch in the form `projects/&#42;`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for parent.
       */
      public com.google.protobuf.ByteString getParentBytes() {
        java.lang.Object ref = parent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The project in which to run this patch in the form `projects/&#42;`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The parent to set.
       * @return This builder for chaining.
       */
      public Builder setParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The project in which to run this patch in the form `projects/&#42;`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParent() {
        parent_ = getDefaultInstance().getParent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The project in which to run this patch in the form `projects/&#42;`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for parent to set.
       * @return This builder for chaining.
       */
      public Builder setParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * Description of the patch job. Length of the description is limited
       * to 1024 characters.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description of the patch job. Length of the description is limited
       * to 1024 characters.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description of the patch job. Length of the description is limited
       * to 1024 characters.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description of the patch job. Length of the description is limited
       * to 1024 characters.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description of the patch job. Length of the description is limited
       * to 1024 characters.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter instanceFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter,
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder>
          instanceFilterBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Instances to patch, either explicitly or filtered by some
       * criteria such as zone or labels.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the instanceFilter field is set.
       */
      public boolean hasInstanceFilter() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Instances to patch, either explicitly or filtered by some
       * criteria such as zone or labels.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The instanceFilter.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter getInstanceFilter() {
        if (instanceFilterBuilder_ == null) {
          return instanceFilter_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.getDefaultInstance()
              : instanceFilter_;
        } else {
          return instanceFilterBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Instances to patch, either explicitly or filtered by some
       * criteria such as zone or labels.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setInstanceFilter(
          com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter value) {
        if (instanceFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          instanceFilter_ = value;
        } else {
          instanceFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Instances to patch, either explicitly or filtered by some
       * criteria such as zone or labels.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setInstanceFilter(
          com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder builderForValue) {
        if (instanceFilterBuilder_ == null) {
          instanceFilter_ = builderForValue.build();
        } else {
          instanceFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Instances to patch, either explicitly or filtered by some
       * criteria such as zone or labels.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeInstanceFilter(
          com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter value) {
        if (instanceFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && instanceFilter_ != null
              && instanceFilter_
                  != com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter
                      .getDefaultInstance()) {
            getInstanceFilterBuilder().mergeFrom(value);
          } else {
            instanceFilter_ = value;
          }
        } else {
          instanceFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Instances to patch, either explicitly or filtered by some
       * criteria such as zone or labels.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearInstanceFilter() {
        bitField0_ = (bitField0_ & ~0x00000004);
        instanceFilter_ = null;
        if (instanceFilterBuilder_ != null) {
          instanceFilterBuilder_.dispose();
          instanceFilterBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Instances to patch, either explicitly or filtered by some
       * criteria such as zone or labels.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder
          getInstanceFilterBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getInstanceFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Instances to patch, either explicitly or filtered by some
       * criteria such as zone or labels.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder
          getInstanceFilterOrBuilder() {
        if (instanceFilterBuilder_ != null) {
          return instanceFilterBuilder_.getMessageOrBuilder();
        } else {
          return instanceFilter_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.getDefaultInstance()
              : instanceFilter_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Instances to patch, either explicitly or filtered by some
       * criteria such as zone or labels.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 7 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter,
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder>
          getInstanceFilterFieldBuilder() {
        if (instanceFilterBuilder_ == null) {
          instanceFilterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder>(
                  getInstanceFilter(), getParentForChildren(), isClean());
          instanceFilter_ = null;
        }
        return instanceFilterBuilder_;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.PatchConfig patchConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig,
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder>
          patchConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Patch configuration being applied. If omitted, instances are
       * patched using the default configurations.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
       *
       * @return Whether the patchConfig field is set.
       */
      public boolean hasPatchConfig() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied. If omitted, instances are
       * patched using the default configurations.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
       *
       * @return The patchConfig.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig getPatchConfig() {
        if (patchConfigBuilder_ == null) {
          return patchConfig_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()
              : patchConfig_;
        } else {
          return patchConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied. If omitted, instances are
       * patched using the default configurations.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
       */
      public Builder setPatchConfig(com.google.cloud.osconfig.v1.PatchJobs.PatchConfig value) {
        if (patchConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          patchConfig_ = value;
        } else {
          patchConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied. If omitted, instances are
       * patched using the default configurations.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
       */
      public Builder setPatchConfig(
          com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder builderForValue) {
        if (patchConfigBuilder_ == null) {
          patchConfig_ = builderForValue.build();
        } else {
          patchConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied. If omitted, instances are
       * patched using the default configurations.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
       */
      public Builder mergePatchConfig(com.google.cloud.osconfig.v1.PatchJobs.PatchConfig value) {
        if (patchConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && patchConfig_ != null
              && patchConfig_
                  != com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()) {
            getPatchConfigBuilder().mergeFrom(value);
          } else {
            patchConfig_ = value;
          }
        } else {
          patchConfigBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied. If omitted, instances are
       * patched using the default configurations.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
       */
      public Builder clearPatchConfig() {
        bitField0_ = (bitField0_ & ~0x00000008);
        patchConfig_ = null;
        if (patchConfigBuilder_ != null) {
          patchConfigBuilder_.dispose();
          patchConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied. If omitted, instances are
       * patched using the default configurations.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder getPatchConfigBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getPatchConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied. If omitted, instances are
       * patched using the default configurations.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder getPatchConfigOrBuilder() {
        if (patchConfigBuilder_ != null) {
          return patchConfigBuilder_.getMessageOrBuilder();
        } else {
          return patchConfig_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()
              : patchConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied. If omitted, instances are
       * patched using the default configurations.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig,
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder>
          getPatchConfigFieldBuilder() {
        if (patchConfigBuilder_ == null) {
          patchConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.PatchConfig,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder>(
                  getPatchConfig(), getParentForChildren(), isClean());
          patchConfig_ = null;
        }
        return patchConfigBuilder_;
      }

      private com.google.protobuf.Duration duration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          durationBuilder_;
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the patch job
       * times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5;</code>
       *
       * @return Whether the duration field is set.
       */
      public boolean hasDuration() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the patch job
       * times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5;</code>
       *
       * @return The duration.
       */
      public com.google.protobuf.Duration getDuration() {
        if (durationBuilder_ == null) {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        } else {
          return durationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the patch job
       * times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5;</code>
       */
      public Builder setDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          duration_ = value;
        } else {
          durationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the patch job
       * times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5;</code>
       */
      public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (durationBuilder_ == null) {
          duration_ = builderForValue.build();
        } else {
          durationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the patch job
       * times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5;</code>
       */
      public Builder mergeDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && duration_ != null
              && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getDurationBuilder().mergeFrom(value);
          } else {
            duration_ = value;
          }
        } else {
          durationBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the patch job
       * times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5;</code>
       */
      public Builder clearDuration() {
        bitField0_ = (bitField0_ & ~0x00000010);
        duration_ = null;
        if (durationBuilder_ != null) {
          durationBuilder_.dispose();
          durationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the patch job
       * times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5;</code>
       */
      public com.google.protobuf.Duration.Builder getDurationBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the patch job
       * times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5;</code>
       */
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        if (durationBuilder_ != null) {
          return durationBuilder_.getMessageOrBuilder();
        } else {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the patch job
       * times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getDurationFieldBuilder() {
        if (durationBuilder_ == null) {
          durationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getDuration(), getParentForChildren(), isClean());
          duration_ = null;
        }
        return durationBuilder_;
      }

      private boolean dryRun_;
      /**
       *
       *
       * <pre>
       * If this patch is a dry-run only, instances are contacted but
       * will do nothing.
       * </pre>
       *
       * <code>bool dry_run = 6;</code>
       *
       * @return The dryRun.
       */
      @java.lang.Override
      public boolean getDryRun() {
        return dryRun_;
      }
      /**
       *
       *
       * <pre>
       * If this patch is a dry-run only, instances are contacted but
       * will do nothing.
       * </pre>
       *
       * <code>bool dry_run = 6;</code>
       *
       * @param value The dryRun to set.
       * @return This builder for chaining.
       */
      public Builder setDryRun(boolean value) {

        dryRun_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If this patch is a dry-run only, instances are contacted but
       * will do nothing.
       * </pre>
       *
       * <code>bool dry_run = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDryRun() {
        bitField0_ = (bitField0_ & ~0x00000020);
        dryRun_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * Display name for this patch job. This does not have to be unique.
       * </pre>
       *
       * <code>string display_name = 8;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Display name for this patch job. This does not have to be unique.
       * </pre>
       *
       * <code>string display_name = 8;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Display name for this patch job. This does not have to be unique.
       * </pre>
       *
       * <code>string display_name = 8;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display name for this patch job. This does not have to be unique.
       * </pre>
       *
       * <code>string display_name = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display name for this patch job. This does not have to be unique.
       * </pre>
       *
       * <code>string display_name = 8;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.PatchRollout rollout_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchRollout,
              com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder>
          rolloutBuilder_;
      /**
       *
       *
       * <pre>
       * Rollout strategy of the patch job.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
       *
       * @return Whether the rollout field is set.
       */
      public boolean hasRollout() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy of the patch job.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
       *
       * @return The rollout.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchRollout getRollout() {
        if (rolloutBuilder_ == null) {
          return rollout_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()
              : rollout_;
        } else {
          return rolloutBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy of the patch job.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
       */
      public Builder setRollout(com.google.cloud.osconfig.v1.PatchJobs.PatchRollout value) {
        if (rolloutBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rollout_ = value;
        } else {
          rolloutBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy of the patch job.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
       */
      public Builder setRollout(
          com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder builderForValue) {
        if (rolloutBuilder_ == null) {
          rollout_ = builderForValue.build();
        } else {
          rolloutBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy of the patch job.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
       */
      public Builder mergeRollout(com.google.cloud.osconfig.v1.PatchJobs.PatchRollout value) {
        if (rolloutBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && rollout_ != null
              && rollout_
                  != com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()) {
            getRolloutBuilder().mergeFrom(value);
          } else {
            rollout_ = value;
          }
        } else {
          rolloutBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy of the patch job.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
       */
      public Builder clearRollout() {
        bitField0_ = (bitField0_ & ~0x00000080);
        rollout_ = null;
        if (rolloutBuilder_ != null) {
          rolloutBuilder_.dispose();
          rolloutBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy of the patch job.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder getRolloutBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getRolloutFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy of the patch job.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder getRolloutOrBuilder() {
        if (rolloutBuilder_ != null) {
          return rolloutBuilder_.getMessageOrBuilder();
        } else {
          return rollout_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()
              : rollout_;
        }
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy of the patch job.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchRollout,
              com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder>
          getRolloutFieldBuilder() {
        if (rolloutBuilder_ == null) {
          rolloutBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.PatchRollout,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder>(
                  getRollout(), getParentForChildren(), isClean());
          rollout_ = null;
        }
        return rolloutBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.ExecutePatchJobRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.ExecutePatchJobRequest)
    private static final com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExecutePatchJobRequest> PARSER =
        new com.google.protobuf.AbstractParser<ExecutePatchJobRequest>() {
          @java.lang.Override
          public ExecutePatchJobRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExecutePatchJobRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExecutePatchJobRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ExecutePatchJobRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GetPatchJobRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.GetPatchJobRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Request to get an active or completed patch job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.GetPatchJobRequest}
   */
  public static final class GetPatchJobRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.GetPatchJobRequest)
      GetPatchJobRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GetPatchJobRequest.newBuilder() to construct.
    private GetPatchJobRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GetPatchJobRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GetPatchJobRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_GetPatchJobRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_GetPatchJobRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest.class,
              com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest other =
          (com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request to get an active or completed patch job.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.GetPatchJobRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.GetPatchJobRequest)
        com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_GetPatchJobRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_GetPatchJobRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest.class,
                com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_GetPatchJobRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest build() {
        com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest result =
            new com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest other) {
        if (other == com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.GetPatchJobRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.GetPatchJobRequest)
    private static final com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GetPatchJobRequest> PARSER =
        new com.google.protobuf.AbstractParser<GetPatchJobRequest>() {
          @java.lang.Override
          public GetPatchJobRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GetPatchJobRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetPatchJobRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.GetPatchJobRequest getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ListPatchJobInstanceDetailsRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.ListPatchJobInstanceDetailsRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The parent for the instances are in the form of
     * `projects/&#42;&#47;patchJobs/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    java.lang.String getParent();
    /**
     *
     *
     * <pre>
     * Required. The parent for the instances are in the form of
     * `projects/&#42;&#47;patchJobs/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    com.google.protobuf.ByteString getParentBytes();

    /**
     *
     *
     * <pre>
     * The maximum number of instance details records to return.  Default is 100.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return The pageSize.
     */
    int getPageSize();

    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call
     * that indicates where this listing should continue from.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The pageToken.
     */
    java.lang.String getPageToken();
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call
     * that indicates where this listing should continue from.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The bytes for pageToken.
     */
    com.google.protobuf.ByteString getPageTokenBytes();

    /**
     *
     *
     * <pre>
     * A filter expression that filters results listed in the response. This
     * field supports filtering results by instance zone, name, state, or
     * `failure_reason`.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return The filter.
     */
    java.lang.String getFilter();
    /**
     *
     *
     * <pre>
     * A filter expression that filters results listed in the response. This
     * field supports filtering results by instance zone, name, state, or
     * `failure_reason`.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return The bytes for filter.
     */
    com.google.protobuf.ByteString getFilterBytes();
  }
  /**
   *
   *
   * <pre>
   * Request to list details for all instances that are part of a patch job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.ListPatchJobInstanceDetailsRequest}
   */
  public static final class ListPatchJobInstanceDetailsRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.ListPatchJobInstanceDetailsRequest)
      ListPatchJobInstanceDetailsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListPatchJobInstanceDetailsRequest.newBuilder() to construct.
    private ListPatchJobInstanceDetailsRequest(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListPatchJobInstanceDetailsRequest() {
      parent_ = "";
      pageToken_ = "";
      filter_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListPatchJobInstanceDetailsRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ListPatchJobInstanceDetailsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ListPatchJobInstanceDetailsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest.class,
              com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest.Builder
                  .class);
    }

    public static final int PARENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent for the instances are in the form of
     * `projects/&#42;&#47;patchJobs/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    @java.lang.Override
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent for the instances are in the form of
     * `projects/&#42;&#47;patchJobs/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PAGE_SIZE_FIELD_NUMBER = 2;
    private int pageSize_ = 0;
    /**
     *
     *
     * <pre>
     * The maximum number of instance details records to return.  Default is 100.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    public static final int PAGE_TOKEN_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call
     * that indicates where this listing should continue from.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The pageToken.
     */
    @java.lang.Override
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call
     * that indicates where this listing should continue from.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The bytes for pageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FILTER_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * A filter expression that filters results listed in the response. This
     * field supports filtering results by instance zone, name, state, or
     * `failure_reason`.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A filter expression that filters results listed in the response. This
     * field supports filtering results by instance zone, name, state, or
     * `failure_reason`.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
      }
      if (pageSize_ != 0) {
        output.writeInt32(2, pageSize_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, filter_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
      }
      if (pageSize_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageSize_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, filter_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest other =
          (com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest) obj;

      if (!getParent().equals(other.getParent())) return false;
      if (getPageSize() != other.getPageSize()) return false;
      if (!getPageToken().equals(other.getPageToken())) return false;
      if (!getFilter().equals(other.getFilter())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
      hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getPageSize();
      hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getPageToken().hashCode();
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request to list details for all instances that are part of a patch job.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.ListPatchJobInstanceDetailsRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.ListPatchJobInstanceDetailsRequest)
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ListPatchJobInstanceDetailsRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ListPatchJobInstanceDetailsRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest.class,
                com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        parent_ = "";
        pageSize_ = 0;
        pageToken_ = "";
        filter_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ListPatchJobInstanceDetailsRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest build() {
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
          buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest result =
            new com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.parent_ = parent_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.pageSize_ = pageSize_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.pageToken_ = pageToken_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.filter_ = filter_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
                .getDefaultInstance()) return this;
        if (!other.getParent().isEmpty()) {
          parent_ = other.parent_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getPageSize() != 0) {
          setPageSize(other.getPageSize());
        }
        if (!other.getPageToken().isEmpty()) {
          pageToken_ = other.pageToken_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getFilter().isEmpty()) {
          filter_ = other.filter_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  parent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  pageSize_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  pageToken_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  filter_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object parent_ = "";
      /**
       *
       *
       * <pre>
       * Required. The parent for the instances are in the form of
       * `projects/&#42;&#47;patchJobs/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The parent.
       */
      public java.lang.String getParent() {
        java.lang.Object ref = parent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The parent for the instances are in the form of
       * `projects/&#42;&#47;patchJobs/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for parent.
       */
      public com.google.protobuf.ByteString getParentBytes() {
        java.lang.Object ref = parent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The parent for the instances are in the form of
       * `projects/&#42;&#47;patchJobs/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The parent to set.
       * @return This builder for chaining.
       */
      public Builder setParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The parent for the instances are in the form of
       * `projects/&#42;&#47;patchJobs/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParent() {
        parent_ = getDefaultInstance().getParent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The parent for the instances are in the form of
       * `projects/&#42;&#47;patchJobs/&#42;`.
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for parent to set.
       * @return This builder for chaining.
       */
      public Builder setParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int pageSize_;
      /**
       *
       *
       * <pre>
       * The maximum number of instance details records to return.  Default is 100.
       * </pre>
       *
       * <code>int32 page_size = 2;</code>
       *
       * @return The pageSize.
       */
      @java.lang.Override
      public int getPageSize() {
        return pageSize_;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of instance details records to return.  Default is 100.
       * </pre>
       *
       * <code>int32 page_size = 2;</code>
       *
       * @param value The pageSize to set.
       * @return This builder for chaining.
       */
      public Builder setPageSize(int value) {

        pageSize_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of instance details records to return.  Default is 100.
       * </pre>
       *
       * <code>int32 page_size = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageSize() {
        bitField0_ = (bitField0_ & ~0x00000002);
        pageSize_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object pageToken_ = "";
      /**
       *
       *
       * <pre>
       * A pagination token returned from a previous call
       * that indicates where this listing should continue from.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @return The pageToken.
       */
      public java.lang.String getPageToken() {
        java.lang.Object ref = pageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pageToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A pagination token returned from a previous call
       * that indicates where this listing should continue from.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @return The bytes for pageToken.
       */
      public com.google.protobuf.ByteString getPageTokenBytes() {
        java.lang.Object ref = pageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A pagination token returned from a previous call
       * that indicates where this listing should continue from.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @param value The pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageToken_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A pagination token returned from a previous call
       * that indicates where this listing should continue from.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageToken() {
        pageToken_ = getDefaultInstance().getPageToken();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A pagination token returned from a previous call
       * that indicates where this listing should continue from.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @param value The bytes for pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        pageToken_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * A filter expression that filters results listed in the response. This
       * field supports filtering results by instance zone, name, state, or
       * `failure_reason`.
       * </pre>
       *
       * <code>string filter = 4;</code>
       *
       * @return The filter.
       */
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A filter expression that filters results listed in the response. This
       * field supports filtering results by instance zone, name, state, or
       * `failure_reason`.
       * </pre>
       *
       * <code>string filter = 4;</code>
       *
       * @return The bytes for filter.
       */
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A filter expression that filters results listed in the response. This
       * field supports filtering results by instance zone, name, state, or
       * `failure_reason`.
       * </pre>
       *
       * <code>string filter = 4;</code>
       *
       * @param value The filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A filter expression that filters results listed in the response. This
       * field supports filtering results by instance zone, name, state, or
       * `failure_reason`.
       * </pre>
       *
       * <code>string filter = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilter() {
        filter_ = getDefaultInstance().getFilter();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A filter expression that filters results listed in the response. This
       * field supports filtering results by instance zone, name, state, or
       * `failure_reason`.
       * </pre>
       *
       * <code>string filter = 4;</code>
       *
       * @param value The bytes for filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        filter_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.ListPatchJobInstanceDetailsRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.ListPatchJobInstanceDetailsRequest)
    private static final com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListPatchJobInstanceDetailsRequest> PARSER =
        new com.google.protobuf.AbstractParser<ListPatchJobInstanceDetailsRequest>() {
          @java.lang.Override
          public ListPatchJobInstanceDetailsRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListPatchJobInstanceDetailsRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListPatchJobInstanceDetailsRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ListPatchJobInstanceDetailsResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.ListPatchJobInstanceDetailsResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of instance status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
     * </code>
     */
    java.util.List<com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails>
        getPatchJobInstanceDetailsList();
    /**
     *
     *
     * <pre>
     * A list of instance status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails getPatchJobInstanceDetails(
        int index);
    /**
     *
     *
     * <pre>
     * A list of instance status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
     * </code>
     */
    int getPatchJobInstanceDetailsCount();
    /**
     *
     *
     * <pre>
     * A list of instance status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetailsOrBuilder>
        getPatchJobInstanceDetailsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of instance status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetailsOrBuilder
        getPatchJobInstanceDetailsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A pagination token that can be used to get the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    java.lang.String getNextPageToken();
    /**
     *
     *
     * <pre>
     * A pagination token that can be used to get the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    com.google.protobuf.ByteString getNextPageTokenBytes();
  }
  /**
   *
   *
   * <pre>
   * A response message for listing the instances details for a patch job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.ListPatchJobInstanceDetailsResponse}
   */
  public static final class ListPatchJobInstanceDetailsResponse
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.ListPatchJobInstanceDetailsResponse)
      ListPatchJobInstanceDetailsResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListPatchJobInstanceDetailsResponse.newBuilder() to construct.
    private ListPatchJobInstanceDetailsResponse(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListPatchJobInstanceDetailsResponse() {
      patchJobInstanceDetails_ = java.util.Collections.emptyList();
      nextPageToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListPatchJobInstanceDetailsResponse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ListPatchJobInstanceDetailsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ListPatchJobInstanceDetailsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse.class,
              com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse.Builder
                  .class);
    }

    public static final int PATCH_JOB_INSTANCE_DETAILS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails>
        patchJobInstanceDetails_;
    /**
     *
     *
     * <pre>
     * A list of instance status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails>
        getPatchJobInstanceDetailsList() {
      return patchJobInstanceDetails_;
    }
    /**
     *
     *
     * <pre>
     * A list of instance status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetailsOrBuilder>
        getPatchJobInstanceDetailsOrBuilderList() {
      return patchJobInstanceDetails_;
    }
    /**
     *
     *
     * <pre>
     * A list of instance status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
     * </code>
     */
    @java.lang.Override
    public int getPatchJobInstanceDetailsCount() {
      return patchJobInstanceDetails_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of instance status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails
        getPatchJobInstanceDetails(int index) {
      return patchJobInstanceDetails_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of instance status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetailsOrBuilder
        getPatchJobInstanceDetailsOrBuilder(int index) {
      return patchJobInstanceDetails_.get(index);
    }

    public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * A pagination token that can be used to get the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    @java.lang.Override
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A pagination token that can be used to get the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < patchJobInstanceDetails_.size(); i++) {
        output.writeMessage(1, patchJobInstanceDetails_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < patchJobInstanceDetails_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, patchJobInstanceDetails_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse other =
          (com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse) obj;

      if (!getPatchJobInstanceDetailsList().equals(other.getPatchJobInstanceDetailsList()))
        return false;
      if (!getNextPageToken().equals(other.getNextPageToken())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPatchJobInstanceDetailsCount() > 0) {
        hash = (37 * hash) + PATCH_JOB_INSTANCE_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getPatchJobInstanceDetailsList().hashCode();
      }
      hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getNextPageToken().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A response message for listing the instances details for a patch job.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.ListPatchJobInstanceDetailsResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.ListPatchJobInstanceDetailsResponse)
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ListPatchJobInstanceDetailsResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ListPatchJobInstanceDetailsResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse.class,
                com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (patchJobInstanceDetailsBuilder_ == null) {
          patchJobInstanceDetails_ = java.util.Collections.emptyList();
        } else {
          patchJobInstanceDetails_ = null;
          patchJobInstanceDetailsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        nextPageToken_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ListPatchJobInstanceDetailsResponse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse build() {
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
          buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse result =
            new com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse result) {
        if (patchJobInstanceDetailsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            patchJobInstanceDetails_ =
                java.util.Collections.unmodifiableList(patchJobInstanceDetails_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.patchJobInstanceDetails_ = patchJobInstanceDetails_;
        } else {
          result.patchJobInstanceDetails_ = patchJobInstanceDetailsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.nextPageToken_ = nextPageToken_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
                .getDefaultInstance()) return this;
        if (patchJobInstanceDetailsBuilder_ == null) {
          if (!other.patchJobInstanceDetails_.isEmpty()) {
            if (patchJobInstanceDetails_.isEmpty()) {
              patchJobInstanceDetails_ = other.patchJobInstanceDetails_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePatchJobInstanceDetailsIsMutable();
              patchJobInstanceDetails_.addAll(other.patchJobInstanceDetails_);
            }
            onChanged();
          }
        } else {
          if (!other.patchJobInstanceDetails_.isEmpty()) {
            if (patchJobInstanceDetailsBuilder_.isEmpty()) {
              patchJobInstanceDetailsBuilder_.dispose();
              patchJobInstanceDetailsBuilder_ = null;
              patchJobInstanceDetails_ = other.patchJobInstanceDetails_;
              bitField0_ = (bitField0_ & ~0x00000001);
              patchJobInstanceDetailsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPatchJobInstanceDetailsFieldBuilder()
                      : null;
            } else {
              patchJobInstanceDetailsBuilder_.addAllMessages(other.patchJobInstanceDetails_);
            }
          }
        }
        if (!other.getNextPageToken().isEmpty()) {
          nextPageToken_ = other.nextPageToken_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails m =
                      input.readMessage(
                          com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.parser(),
                          extensionRegistry);
                  if (patchJobInstanceDetailsBuilder_ == null) {
                    ensurePatchJobInstanceDetailsIsMutable();
                    patchJobInstanceDetails_.add(m);
                  } else {
                    patchJobInstanceDetailsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  nextPageToken_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails>
          patchJobInstanceDetails_ = java.util.Collections.emptyList();

      private void ensurePatchJobInstanceDetailsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          patchJobInstanceDetails_ =
              new java.util.ArrayList<
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails>(
                  patchJobInstanceDetails_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetailsOrBuilder>
          patchJobInstanceDetailsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails>
          getPatchJobInstanceDetailsList() {
        if (patchJobInstanceDetailsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(patchJobInstanceDetails_);
        } else {
          return patchJobInstanceDetailsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public int getPatchJobInstanceDetailsCount() {
        if (patchJobInstanceDetailsBuilder_ == null) {
          return patchJobInstanceDetails_.size();
        } else {
          return patchJobInstanceDetailsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails
          getPatchJobInstanceDetails(int index) {
        if (patchJobInstanceDetailsBuilder_ == null) {
          return patchJobInstanceDetails_.get(index);
        } else {
          return patchJobInstanceDetailsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public Builder setPatchJobInstanceDetails(
          int index, com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails value) {
        if (patchJobInstanceDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePatchJobInstanceDetailsIsMutable();
          patchJobInstanceDetails_.set(index, value);
          onChanged();
        } else {
          patchJobInstanceDetailsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public Builder setPatchJobInstanceDetails(
          int index,
          com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.Builder builderForValue) {
        if (patchJobInstanceDetailsBuilder_ == null) {
          ensurePatchJobInstanceDetailsIsMutable();
          patchJobInstanceDetails_.set(index, builderForValue.build());
          onChanged();
        } else {
          patchJobInstanceDetailsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public Builder addPatchJobInstanceDetails(
          com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails value) {
        if (patchJobInstanceDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePatchJobInstanceDetailsIsMutable();
          patchJobInstanceDetails_.add(value);
          onChanged();
        } else {
          patchJobInstanceDetailsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public Builder addPatchJobInstanceDetails(
          int index, com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails value) {
        if (patchJobInstanceDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePatchJobInstanceDetailsIsMutable();
          patchJobInstanceDetails_.add(index, value);
          onChanged();
        } else {
          patchJobInstanceDetailsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public Builder addPatchJobInstanceDetails(
          com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.Builder builderForValue) {
        if (patchJobInstanceDetailsBuilder_ == null) {
          ensurePatchJobInstanceDetailsIsMutable();
          patchJobInstanceDetails_.add(builderForValue.build());
          onChanged();
        } else {
          patchJobInstanceDetailsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public Builder addPatchJobInstanceDetails(
          int index,
          com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.Builder builderForValue) {
        if (patchJobInstanceDetailsBuilder_ == null) {
          ensurePatchJobInstanceDetailsIsMutable();
          patchJobInstanceDetails_.add(index, builderForValue.build());
          onChanged();
        } else {
          patchJobInstanceDetailsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public Builder addAllPatchJobInstanceDetails(
          java.lang.Iterable<
                  ? extends com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails>
              values) {
        if (patchJobInstanceDetailsBuilder_ == null) {
          ensurePatchJobInstanceDetailsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, patchJobInstanceDetails_);
          onChanged();
        } else {
          patchJobInstanceDetailsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public Builder clearPatchJobInstanceDetails() {
        if (patchJobInstanceDetailsBuilder_ == null) {
          patchJobInstanceDetails_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          patchJobInstanceDetailsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public Builder removePatchJobInstanceDetails(int index) {
        if (patchJobInstanceDetailsBuilder_ == null) {
          ensurePatchJobInstanceDetailsIsMutable();
          patchJobInstanceDetails_.remove(index);
          onChanged();
        } else {
          patchJobInstanceDetailsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.Builder
          getPatchJobInstanceDetailsBuilder(int index) {
        return getPatchJobInstanceDetailsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetailsOrBuilder
          getPatchJobInstanceDetailsOrBuilder(int index) {
        if (patchJobInstanceDetailsBuilder_ == null) {
          return patchJobInstanceDetails_.get(index);
        } else {
          return patchJobInstanceDetailsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetailsOrBuilder>
          getPatchJobInstanceDetailsOrBuilderList() {
        if (patchJobInstanceDetailsBuilder_ != null) {
          return patchJobInstanceDetailsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(patchJobInstanceDetails_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.Builder
          addPatchJobInstanceDetailsBuilder() {
        return getPatchJobInstanceDetailsFieldBuilder()
            .addBuilder(
                com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.Builder
          addPatchJobInstanceDetailsBuilder(int index) {
        return getPatchJobInstanceDetailsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of instance status.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.PatchJobInstanceDetails patch_job_instance_details = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.Builder>
          getPatchJobInstanceDetailsBuilderList() {
        return getPatchJobInstanceDetailsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetailsOrBuilder>
          getPatchJobInstanceDetailsFieldBuilder() {
        if (patchJobInstanceDetailsBuilder_ == null) {
          patchJobInstanceDetailsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetailsOrBuilder>(
                  patchJobInstanceDetails_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          patchJobInstanceDetails_ = null;
        }
        return patchJobInstanceDetailsBuilder_;
      }

      private java.lang.Object nextPageToken_ = "";
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of results.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return The nextPageToken.
       */
      public java.lang.String getNextPageToken() {
        java.lang.Object ref = nextPageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          nextPageToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of results.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return The bytes for nextPageToken.
       */
      public com.google.protobuf.ByteString getNextPageTokenBytes() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          nextPageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of results.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @param value The nextPageToken to set.
       * @return This builder for chaining.
       */
      public Builder setNextPageToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        nextPageToken_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of results.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNextPageToken() {
        nextPageToken_ = getDefaultInstance().getNextPageToken();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of results.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @param value The bytes for nextPageToken to set.
       * @return This builder for chaining.
       */
      public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        nextPageToken_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.ListPatchJobInstanceDetailsResponse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.ListPatchJobInstanceDetailsResponse)
    private static final com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListPatchJobInstanceDetailsResponse> PARSER =
        new com.google.protobuf.AbstractParser<ListPatchJobInstanceDetailsResponse>() {
          @java.lang.Override
          public ListPatchJobInstanceDetailsResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListPatchJobInstanceDetailsResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListPatchJobInstanceDetailsResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobInstanceDetailsResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PatchJobInstanceDetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.PatchJobInstanceDetails)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The instance name in the form `projects/&#42;&#47;zones/&#42;&#47;instances/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * The instance name in the form `projects/&#42;&#47;zones/&#42;&#47;instances/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * The unique identifier for the instance. This identifier is
     * defined by the server.
     * </pre>
     *
     * <code>string instance_system_id = 2;</code>
     *
     * @return The instanceSystemId.
     */
    java.lang.String getInstanceSystemId();
    /**
     *
     *
     * <pre>
     * The unique identifier for the instance. This identifier is
     * defined by the server.
     * </pre>
     *
     * <code>string instance_system_id = 2;</code>
     *
     * @return The bytes for instanceSystemId.
     */
    com.google.protobuf.ByteString getInstanceSystemIdBytes();

    /**
     *
     *
     * <pre>
     * Current state of instance patch.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.Instance.PatchState state = 3;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Current state of instance patch.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.Instance.PatchState state = 3;</code>
     *
     * @return The state.
     */
    com.google.cloud.osconfig.v1.PatchJobs.Instance.PatchState getState();

    /**
     *
     *
     * <pre>
     * If the patch fails, this field provides the reason.
     * </pre>
     *
     * <code>string failure_reason = 4;</code>
     *
     * @return The failureReason.
     */
    java.lang.String getFailureReason();
    /**
     *
     *
     * <pre>
     * If the patch fails, this field provides the reason.
     * </pre>
     *
     * <code>string failure_reason = 4;</code>
     *
     * @return The bytes for failureReason.
     */
    com.google.protobuf.ByteString getFailureReasonBytes();

    /**
     *
     *
     * <pre>
     * The number of times the agent that the agent attempts to apply the patch.
     * </pre>
     *
     * <code>int64 attempt_count = 5;</code>
     *
     * @return The attemptCount.
     */
    long getAttemptCount();
  }
  /**
   *
   *
   * <pre>
   * Patch details for a VM instance. For more information about reviewing VM
   * instance details, see
   * [Listing all VM instance details for a specific patch
   * job](https://cloud.google.com/compute/docs/os-patch-management/manage-patch-jobs#list-instance-details).
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.PatchJobInstanceDetails}
   */
  public static final class PatchJobInstanceDetails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.PatchJobInstanceDetails)
      PatchJobInstanceDetailsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PatchJobInstanceDetails.newBuilder() to construct.
    private PatchJobInstanceDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PatchJobInstanceDetails() {
      name_ = "";
      instanceSystemId_ = "";
      state_ = 0;
      failureReason_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PatchJobInstanceDetails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_PatchJobInstanceDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_PatchJobInstanceDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.class,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The instance name in the form `projects/&#42;&#47;zones/&#42;&#47;instances/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The instance name in the form `projects/&#42;&#47;zones/&#42;&#47;instances/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INSTANCE_SYSTEM_ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object instanceSystemId_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier for the instance. This identifier is
     * defined by the server.
     * </pre>
     *
     * <code>string instance_system_id = 2;</code>
     *
     * @return The instanceSystemId.
     */
    @java.lang.Override
    public java.lang.String getInstanceSystemId() {
      java.lang.Object ref = instanceSystemId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceSystemId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier for the instance. This identifier is
     * defined by the server.
     * </pre>
     *
     * <code>string instance_system_id = 2;</code>
     *
     * @return The bytes for instanceSystemId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInstanceSystemIdBytes() {
      java.lang.Object ref = instanceSystemId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceSystemId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATE_FIELD_NUMBER = 3;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Current state of instance patch.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.Instance.PatchState state = 3;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Current state of instance patch.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.Instance.PatchState state = 3;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.Instance.PatchState getState() {
      com.google.cloud.osconfig.v1.PatchJobs.Instance.PatchState result =
          com.google.cloud.osconfig.v1.PatchJobs.Instance.PatchState.forNumber(state_);
      return result == null
          ? com.google.cloud.osconfig.v1.PatchJobs.Instance.PatchState.UNRECOGNIZED
          : result;
    }

    public static final int FAILURE_REASON_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object failureReason_ = "";
    /**
     *
     *
     * <pre>
     * If the patch fails, this field provides the reason.
     * </pre>
     *
     * <code>string failure_reason = 4;</code>
     *
     * @return The failureReason.
     */
    @java.lang.Override
    public java.lang.String getFailureReason() {
      java.lang.Object ref = failureReason_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        failureReason_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * If the patch fails, this field provides the reason.
     * </pre>
     *
     * <code>string failure_reason = 4;</code>
     *
     * @return The bytes for failureReason.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFailureReasonBytes() {
      java.lang.Object ref = failureReason_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        failureReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ATTEMPT_COUNT_FIELD_NUMBER = 5;
    private long attemptCount_ = 0L;
    /**
     *
     *
     * <pre>
     * The number of times the agent that the agent attempts to apply the patch.
     * </pre>
     *
     * <code>int64 attempt_count = 5;</code>
     *
     * @return The attemptCount.
     */
    @java.lang.Override
    public long getAttemptCount() {
      return attemptCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceSystemId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, instanceSystemId_);
      }
      if (state_
          != com.google.cloud.osconfig.v1.PatchJobs.Instance.PatchState.PATCH_STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(failureReason_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, failureReason_);
      }
      if (attemptCount_ != 0L) {
        output.writeInt64(5, attemptCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceSystemId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, instanceSystemId_);
      }
      if (state_
          != com.google.cloud.osconfig.v1.PatchJobs.Instance.PatchState.PATCH_STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(failureReason_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, failureReason_);
      }
      if (attemptCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, attemptCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails other =
          (com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getInstanceSystemId().equals(other.getInstanceSystemId())) return false;
      if (state_ != other.state_) return false;
      if (!getFailureReason().equals(other.getFailureReason())) return false;
      if (getAttemptCount() != other.getAttemptCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + INSTANCE_SYSTEM_ID_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceSystemId().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + FAILURE_REASON_FIELD_NUMBER;
      hash = (53 * hash) + getFailureReason().hashCode();
      hash = (37 * hash) + ATTEMPT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAttemptCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Patch details for a VM instance. For more information about reviewing VM
     * instance details, see
     * [Listing all VM instance details for a specific patch
     * job](https://cloud.google.com/compute/docs/os-patch-management/manage-patch-jobs#list-instance-details).
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.PatchJobInstanceDetails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.PatchJobInstanceDetails)
        com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_PatchJobInstanceDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_PatchJobInstanceDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.class,
                com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        instanceSystemId_ = "";
        state_ = 0;
        failureReason_ = "";
        attemptCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_PatchJobInstanceDetails_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails build() {
        com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails result =
            new com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.instanceSystemId_ = instanceSystemId_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.failureReason_ = failureReason_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.attemptCount_ = attemptCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getInstanceSystemId().isEmpty()) {
          instanceSystemId_ = other.instanceSystemId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getFailureReason().isEmpty()) {
          failureReason_ = other.failureReason_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.getAttemptCount() != 0L) {
          setAttemptCount(other.getAttemptCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  instanceSystemId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  failureReason_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 40:
                {
                  attemptCount_ = input.readInt64();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The instance name in the form `projects/&#42;&#47;zones/&#42;&#47;instances/&#42;`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The instance name in the form `projects/&#42;&#47;zones/&#42;&#47;instances/&#42;`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The instance name in the form `projects/&#42;&#47;zones/&#42;&#47;instances/&#42;`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The instance name in the form `projects/&#42;&#47;zones/&#42;&#47;instances/&#42;`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The instance name in the form `projects/&#42;&#47;zones/&#42;&#47;instances/&#42;`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object instanceSystemId_ = "";
      /**
       *
       *
       * <pre>
       * The unique identifier for the instance. This identifier is
       * defined by the server.
       * </pre>
       *
       * <code>string instance_system_id = 2;</code>
       *
       * @return The instanceSystemId.
       */
      public java.lang.String getInstanceSystemId() {
        java.lang.Object ref = instanceSystemId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          instanceSystemId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unique identifier for the instance. This identifier is
       * defined by the server.
       * </pre>
       *
       * <code>string instance_system_id = 2;</code>
       *
       * @return The bytes for instanceSystemId.
       */
      public com.google.protobuf.ByteString getInstanceSystemIdBytes() {
        java.lang.Object ref = instanceSystemId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          instanceSystemId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The unique identifier for the instance. This identifier is
       * defined by the server.
       * </pre>
       *
       * <code>string instance_system_id = 2;</code>
       *
       * @param value The instanceSystemId to set.
       * @return This builder for chaining.
       */
      public Builder setInstanceSystemId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        instanceSystemId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique identifier for the instance. This identifier is
       * defined by the server.
       * </pre>
       *
       * <code>string instance_system_id = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInstanceSystemId() {
        instanceSystemId_ = getDefaultInstance().getInstanceSystemId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The unique identifier for the instance. This identifier is
       * defined by the server.
       * </pre>
       *
       * <code>string instance_system_id = 2;</code>
       *
       * @param value The bytes for instanceSystemId to set.
       * @return This builder for chaining.
       */
      public Builder setInstanceSystemIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        instanceSystemId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Current state of instance patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.Instance.PatchState state = 3;</code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Current state of instance patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.Instance.PatchState state = 3;</code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Current state of instance patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.Instance.PatchState state = 3;</code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.Instance.PatchState getState() {
        com.google.cloud.osconfig.v1.PatchJobs.Instance.PatchState result =
            com.google.cloud.osconfig.v1.PatchJobs.Instance.PatchState.forNumber(state_);
        return result == null
            ? com.google.cloud.osconfig.v1.PatchJobs.Instance.PatchState.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Current state of instance patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.Instance.PatchState state = 3;</code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(com.google.cloud.osconfig.v1.PatchJobs.Instance.PatchState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Current state of instance patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.Instance.PatchState state = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000004);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object failureReason_ = "";
      /**
       *
       *
       * <pre>
       * If the patch fails, this field provides the reason.
       * </pre>
       *
       * <code>string failure_reason = 4;</code>
       *
       * @return The failureReason.
       */
      public java.lang.String getFailureReason() {
        java.lang.Object ref = failureReason_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          failureReason_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If the patch fails, this field provides the reason.
       * </pre>
       *
       * <code>string failure_reason = 4;</code>
       *
       * @return The bytes for failureReason.
       */
      public com.google.protobuf.ByteString getFailureReasonBytes() {
        java.lang.Object ref = failureReason_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          failureReason_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If the patch fails, this field provides the reason.
       * </pre>
       *
       * <code>string failure_reason = 4;</code>
       *
       * @param value The failureReason to set.
       * @return This builder for chaining.
       */
      public Builder setFailureReason(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        failureReason_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the patch fails, this field provides the reason.
       * </pre>
       *
       * <code>string failure_reason = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFailureReason() {
        failureReason_ = getDefaultInstance().getFailureReason();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the patch fails, this field provides the reason.
       * </pre>
       *
       * <code>string failure_reason = 4;</code>
       *
       * @param value The bytes for failureReason to set.
       * @return This builder for chaining.
       */
      public Builder setFailureReasonBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        failureReason_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private long attemptCount_;
      /**
       *
       *
       * <pre>
       * The number of times the agent that the agent attempts to apply the patch.
       * </pre>
       *
       * <code>int64 attempt_count = 5;</code>
       *
       * @return The attemptCount.
       */
      @java.lang.Override
      public long getAttemptCount() {
        return attemptCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of times the agent that the agent attempts to apply the patch.
       * </pre>
       *
       * <code>int64 attempt_count = 5;</code>
       *
       * @param value The attemptCount to set.
       * @return This builder for chaining.
       */
      public Builder setAttemptCount(long value) {

        attemptCount_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of times the agent that the agent attempts to apply the patch.
       * </pre>
       *
       * <code>int64 attempt_count = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAttemptCount() {
        bitField0_ = (bitField0_ & ~0x00000010);
        attemptCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.PatchJobInstanceDetails)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.PatchJobInstanceDetails)
    private static final com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PatchJobInstanceDetails> PARSER =
        new com.google.protobuf.AbstractParser<PatchJobInstanceDetails>() {
          @java.lang.Override
          public PatchJobInstanceDetails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PatchJobInstanceDetails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PatchJobInstanceDetails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchJobInstanceDetails
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ListPatchJobsRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.ListPatchJobsRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. In the form of `projects/&#42;`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    java.lang.String getParent();
    /**
     *
     *
     * <pre>
     * Required. In the form of `projects/&#42;`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    com.google.protobuf.ByteString getParentBytes();

    /**
     *
     *
     * <pre>
     * The maximum number of instance status to return.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return The pageSize.
     */
    int getPageSize();

    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call
     * that indicates where this listing should continue from.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The pageToken.
     */
    java.lang.String getPageToken();
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call
     * that indicates where this listing should continue from.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The bytes for pageToken.
     */
    com.google.protobuf.ByteString getPageTokenBytes();

    /**
     *
     *
     * <pre>
     * If provided, this field specifies the criteria that must be met by patch
     * jobs to be included in the response.
     * Currently, filtering is only available on the patch_deployment field.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return The filter.
     */
    java.lang.String getFilter();
    /**
     *
     *
     * <pre>
     * If provided, this field specifies the criteria that must be met by patch
     * jobs to be included in the response.
     * Currently, filtering is only available on the patch_deployment field.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return The bytes for filter.
     */
    com.google.protobuf.ByteString getFilterBytes();
  }
  /**
   *
   *
   * <pre>
   * A request message for listing patch jobs.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.ListPatchJobsRequest}
   */
  public static final class ListPatchJobsRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.ListPatchJobsRequest)
      ListPatchJobsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListPatchJobsRequest.newBuilder() to construct.
    private ListPatchJobsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListPatchJobsRequest() {
      parent_ = "";
      pageToken_ = "";
      filter_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListPatchJobsRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ListPatchJobsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ListPatchJobsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest.class,
              com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest.Builder.class);
    }

    public static final int PARENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. In the form of `projects/&#42;`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    @java.lang.Override
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. In the form of `projects/&#42;`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PAGE_SIZE_FIELD_NUMBER = 2;
    private int pageSize_ = 0;
    /**
     *
     *
     * <pre>
     * The maximum number of instance status to return.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    public static final int PAGE_TOKEN_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call
     * that indicates where this listing should continue from.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The pageToken.
     */
    @java.lang.Override
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A pagination token returned from a previous call
     * that indicates where this listing should continue from.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The bytes for pageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FILTER_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * If provided, this field specifies the criteria that must be met by patch
     * jobs to be included in the response.
     * Currently, filtering is only available on the patch_deployment field.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * If provided, this field specifies the criteria that must be met by patch
     * jobs to be included in the response.
     * Currently, filtering is only available on the patch_deployment field.
     * </pre>
     *
     * <code>string filter = 4;</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
      }
      if (pageSize_ != 0) {
        output.writeInt32(2, pageSize_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, filter_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
      }
      if (pageSize_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageSize_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, filter_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest other =
          (com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest) obj;

      if (!getParent().equals(other.getParent())) return false;
      if (getPageSize() != other.getPageSize()) return false;
      if (!getPageToken().equals(other.getPageToken())) return false;
      if (!getFilter().equals(other.getFilter())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
      hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getPageSize();
      hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getPageToken().hashCode();
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A request message for listing patch jobs.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.ListPatchJobsRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.ListPatchJobsRequest)
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ListPatchJobsRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ListPatchJobsRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest.class,
                com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        parent_ = "";
        pageSize_ = 0;
        pageToken_ = "";
        filter_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ListPatchJobsRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest build() {
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest result =
            new com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.parent_ = parent_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.pageSize_ = pageSize_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.pageToken_ = pageToken_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.filter_ = filter_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest.getDefaultInstance())
          return this;
        if (!other.getParent().isEmpty()) {
          parent_ = other.parent_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getPageSize() != 0) {
          setPageSize(other.getPageSize());
        }
        if (!other.getPageToken().isEmpty()) {
          pageToken_ = other.pageToken_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getFilter().isEmpty()) {
          filter_ = other.filter_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  parent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  pageSize_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  pageToken_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  filter_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object parent_ = "";
      /**
       *
       *
       * <pre>
       * Required. In the form of `projects/&#42;`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The parent.
       */
      public java.lang.String getParent() {
        java.lang.Object ref = parent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. In the form of `projects/&#42;`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for parent.
       */
      public com.google.protobuf.ByteString getParentBytes() {
        java.lang.Object ref = parent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. In the form of `projects/&#42;`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The parent to set.
       * @return This builder for chaining.
       */
      public Builder setParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. In the form of `projects/&#42;`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParent() {
        parent_ = getDefaultInstance().getParent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. In the form of `projects/&#42;`
       * </pre>
       *
       * <code>
       * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for parent to set.
       * @return This builder for chaining.
       */
      public Builder setParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        parent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int pageSize_;
      /**
       *
       *
       * <pre>
       * The maximum number of instance status to return.
       * </pre>
       *
       * <code>int32 page_size = 2;</code>
       *
       * @return The pageSize.
       */
      @java.lang.Override
      public int getPageSize() {
        return pageSize_;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of instance status to return.
       * </pre>
       *
       * <code>int32 page_size = 2;</code>
       *
       * @param value The pageSize to set.
       * @return This builder for chaining.
       */
      public Builder setPageSize(int value) {

        pageSize_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of instance status to return.
       * </pre>
       *
       * <code>int32 page_size = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageSize() {
        bitField0_ = (bitField0_ & ~0x00000002);
        pageSize_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object pageToken_ = "";
      /**
       *
       *
       * <pre>
       * A pagination token returned from a previous call
       * that indicates where this listing should continue from.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @return The pageToken.
       */
      public java.lang.String getPageToken() {
        java.lang.Object ref = pageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pageToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A pagination token returned from a previous call
       * that indicates where this listing should continue from.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @return The bytes for pageToken.
       */
      public com.google.protobuf.ByteString getPageTokenBytes() {
        java.lang.Object ref = pageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A pagination token returned from a previous call
       * that indicates where this listing should continue from.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @param value The pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageToken_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A pagination token returned from a previous call
       * that indicates where this listing should continue from.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageToken() {
        pageToken_ = getDefaultInstance().getPageToken();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A pagination token returned from a previous call
       * that indicates where this listing should continue from.
       * </pre>
       *
       * <code>string page_token = 3;</code>
       *
       * @param value The bytes for pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        pageToken_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * If provided, this field specifies the criteria that must be met by patch
       * jobs to be included in the response.
       * Currently, filtering is only available on the patch_deployment field.
       * </pre>
       *
       * <code>string filter = 4;</code>
       *
       * @return The filter.
       */
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If provided, this field specifies the criteria that must be met by patch
       * jobs to be included in the response.
       * Currently, filtering is only available on the patch_deployment field.
       * </pre>
       *
       * <code>string filter = 4;</code>
       *
       * @return The bytes for filter.
       */
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If provided, this field specifies the criteria that must be met by patch
       * jobs to be included in the response.
       * Currently, filtering is only available on the patch_deployment field.
       * </pre>
       *
       * <code>string filter = 4;</code>
       *
       * @param value The filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If provided, this field specifies the criteria that must be met by patch
       * jobs to be included in the response.
       * Currently, filtering is only available on the patch_deployment field.
       * </pre>
       *
       * <code>string filter = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilter() {
        filter_ = getDefaultInstance().getFilter();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If provided, this field specifies the criteria that must be met by patch
       * jobs to be included in the response.
       * Currently, filtering is only available on the patch_deployment field.
       * </pre>
       *
       * <code>string filter = 4;</code>
       *
       * @param value The bytes for filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        filter_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.ListPatchJobsRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.ListPatchJobsRequest)
    private static final com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListPatchJobsRequest> PARSER =
        new com.google.protobuf.AbstractParser<ListPatchJobsRequest>() {
          @java.lang.Override
          public ListPatchJobsRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListPatchJobsRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListPatchJobsRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsRequest getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ListPatchJobsResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.ListPatchJobsResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The list of patch jobs.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
     */
    java.util.List<com.google.cloud.osconfig.v1.PatchJobs.PatchJob> getPatchJobsList();
    /**
     *
     *
     * <pre>
     * The list of patch jobs.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchJob getPatchJobs(int index);
    /**
     *
     *
     * <pre>
     * The list of patch jobs.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
     */
    int getPatchJobsCount();
    /**
     *
     *
     * <pre>
     * The list of patch jobs.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
     */
    java.util.List<? extends com.google.cloud.osconfig.v1.PatchJobs.PatchJobOrBuilder>
        getPatchJobsOrBuilderList();
    /**
     *
     *
     * <pre>
     * The list of patch jobs.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchJobOrBuilder getPatchJobsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A pagination token that can be used to get the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    java.lang.String getNextPageToken();
    /**
     *
     *
     * <pre>
     * A pagination token that can be used to get the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    com.google.protobuf.ByteString getNextPageTokenBytes();
  }
  /**
   *
   *
   * <pre>
   * A response message for listing patch jobs.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.ListPatchJobsResponse}
   */
  public static final class ListPatchJobsResponse extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.ListPatchJobsResponse)
      ListPatchJobsResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListPatchJobsResponse.newBuilder() to construct.
    private ListPatchJobsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListPatchJobsResponse() {
      patchJobs_ = java.util.Collections.emptyList();
      nextPageToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListPatchJobsResponse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ListPatchJobsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ListPatchJobsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse.class,
              com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse.Builder.class);
    }

    public static final int PATCH_JOBS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.osconfig.v1.PatchJobs.PatchJob> patchJobs_;
    /**
     *
     *
     * <pre>
     * The list of patch jobs.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.osconfig.v1.PatchJobs.PatchJob> getPatchJobsList() {
      return patchJobs_;
    }
    /**
     *
     *
     * <pre>
     * The list of patch jobs.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.osconfig.v1.PatchJobs.PatchJobOrBuilder>
        getPatchJobsOrBuilderList() {
      return patchJobs_;
    }
    /**
     *
     *
     * <pre>
     * The list of patch jobs.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
     */
    @java.lang.Override
    public int getPatchJobsCount() {
      return patchJobs_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of patch jobs.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchJob getPatchJobs(int index) {
      return patchJobs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of patch jobs.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchJobOrBuilder getPatchJobsOrBuilder(
        int index) {
      return patchJobs_.get(index);
    }

    public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * A pagination token that can be used to get the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    @java.lang.Override
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A pagination token that can be used to get the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < patchJobs_.size(); i++) {
        output.writeMessage(1, patchJobs_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < patchJobs_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, patchJobs_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse other =
          (com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse) obj;

      if (!getPatchJobsList().equals(other.getPatchJobsList())) return false;
      if (!getNextPageToken().equals(other.getNextPageToken())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPatchJobsCount() > 0) {
        hash = (37 * hash) + PATCH_JOBS_FIELD_NUMBER;
        hash = (53 * hash) + getPatchJobsList().hashCode();
      }
      hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getNextPageToken().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A response message for listing patch jobs.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.ListPatchJobsResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.ListPatchJobsResponse)
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ListPatchJobsResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ListPatchJobsResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse.class,
                com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (patchJobsBuilder_ == null) {
          patchJobs_ = java.util.Collections.emptyList();
        } else {
          patchJobs_ = null;
          patchJobsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        nextPageToken_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ListPatchJobsResponse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse build() {
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse result =
            new com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse result) {
        if (patchJobsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            patchJobs_ = java.util.Collections.unmodifiableList(patchJobs_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.patchJobs_ = patchJobs_;
        } else {
          result.patchJobs_ = patchJobsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.nextPageToken_ = nextPageToken_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse.getDefaultInstance())
          return this;
        if (patchJobsBuilder_ == null) {
          if (!other.patchJobs_.isEmpty()) {
            if (patchJobs_.isEmpty()) {
              patchJobs_ = other.patchJobs_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePatchJobsIsMutable();
              patchJobs_.addAll(other.patchJobs_);
            }
            onChanged();
          }
        } else {
          if (!other.patchJobs_.isEmpty()) {
            if (patchJobsBuilder_.isEmpty()) {
              patchJobsBuilder_.dispose();
              patchJobsBuilder_ = null;
              patchJobs_ = other.patchJobs_;
              bitField0_ = (bitField0_ & ~0x00000001);
              patchJobsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPatchJobsFieldBuilder()
                      : null;
            } else {
              patchJobsBuilder_.addAllMessages(other.patchJobs_);
            }
          }
        }
        if (!other.getNextPageToken().isEmpty()) {
          nextPageToken_ = other.nextPageToken_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJob m =
                      input.readMessage(
                          com.google.cloud.osconfig.v1.PatchJobs.PatchJob.parser(),
                          extensionRegistry);
                  if (patchJobsBuilder_ == null) {
                    ensurePatchJobsIsMutable();
                    patchJobs_.add(m);
                  } else {
                    patchJobsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  nextPageToken_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.osconfig.v1.PatchJobs.PatchJob> patchJobs_ =
          java.util.Collections.emptyList();

      private void ensurePatchJobsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          patchJobs_ =
              new java.util.ArrayList<com.google.cloud.osconfig.v1.PatchJobs.PatchJob>(patchJobs_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchJob,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJob.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJobOrBuilder>
          patchJobsBuilder_;

      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public java.util.List<com.google.cloud.osconfig.v1.PatchJobs.PatchJob> getPatchJobsList() {
        if (patchJobsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(patchJobs_);
        } else {
          return patchJobsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public int getPatchJobsCount() {
        if (patchJobsBuilder_ == null) {
          return patchJobs_.size();
        } else {
          return patchJobsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJob getPatchJobs(int index) {
        if (patchJobsBuilder_ == null) {
          return patchJobs_.get(index);
        } else {
          return patchJobsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public Builder setPatchJobs(
          int index, com.google.cloud.osconfig.v1.PatchJobs.PatchJob value) {
        if (patchJobsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePatchJobsIsMutable();
          patchJobs_.set(index, value);
          onChanged();
        } else {
          patchJobsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public Builder setPatchJobs(
          int index, com.google.cloud.osconfig.v1.PatchJobs.PatchJob.Builder builderForValue) {
        if (patchJobsBuilder_ == null) {
          ensurePatchJobsIsMutable();
          patchJobs_.set(index, builderForValue.build());
          onChanged();
        } else {
          patchJobsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public Builder addPatchJobs(com.google.cloud.osconfig.v1.PatchJobs.PatchJob value) {
        if (patchJobsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePatchJobsIsMutable();
          patchJobs_.add(value);
          onChanged();
        } else {
          patchJobsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public Builder addPatchJobs(
          int index, com.google.cloud.osconfig.v1.PatchJobs.PatchJob value) {
        if (patchJobsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePatchJobsIsMutable();
          patchJobs_.add(index, value);
          onChanged();
        } else {
          patchJobsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public Builder addPatchJobs(
          com.google.cloud.osconfig.v1.PatchJobs.PatchJob.Builder builderForValue) {
        if (patchJobsBuilder_ == null) {
          ensurePatchJobsIsMutable();
          patchJobs_.add(builderForValue.build());
          onChanged();
        } else {
          patchJobsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public Builder addPatchJobs(
          int index, com.google.cloud.osconfig.v1.PatchJobs.PatchJob.Builder builderForValue) {
        if (patchJobsBuilder_ == null) {
          ensurePatchJobsIsMutable();
          patchJobs_.add(index, builderForValue.build());
          onChanged();
        } else {
          patchJobsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public Builder addAllPatchJobs(
          java.lang.Iterable<? extends com.google.cloud.osconfig.v1.PatchJobs.PatchJob> values) {
        if (patchJobsBuilder_ == null) {
          ensurePatchJobsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, patchJobs_);
          onChanged();
        } else {
          patchJobsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public Builder clearPatchJobs() {
        if (patchJobsBuilder_ == null) {
          patchJobs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          patchJobsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public Builder removePatchJobs(int index) {
        if (patchJobsBuilder_ == null) {
          ensurePatchJobsIsMutable();
          patchJobs_.remove(index);
          onChanged();
        } else {
          patchJobsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.Builder getPatchJobsBuilder(
          int index) {
        return getPatchJobsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJobOrBuilder getPatchJobsOrBuilder(
          int index) {
        if (patchJobsBuilder_ == null) {
          return patchJobs_.get(index);
        } else {
          return patchJobsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public java.util.List<? extends com.google.cloud.osconfig.v1.PatchJobs.PatchJobOrBuilder>
          getPatchJobsOrBuilderList() {
        if (patchJobsBuilder_ != null) {
          return patchJobsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(patchJobs_);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.Builder addPatchJobsBuilder() {
        return getPatchJobsFieldBuilder()
            .addBuilder(com.google.cloud.osconfig.v1.PatchJobs.PatchJob.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.Builder addPatchJobsBuilder(
          int index) {
        return getPatchJobsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.osconfig.v1.PatchJobs.PatchJob.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The list of patch jobs.
       * </pre>
       *
       * <code>repeated .google.cloud.osconfig.v1.PatchJob patch_jobs = 1;</code>
       */
      public java.util.List<com.google.cloud.osconfig.v1.PatchJobs.PatchJob.Builder>
          getPatchJobsBuilderList() {
        return getPatchJobsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchJob,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJob.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJobOrBuilder>
          getPatchJobsFieldBuilder() {
        if (patchJobsBuilder_ == null) {
          patchJobsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJob,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJob.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJobOrBuilder>(
                  patchJobs_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          patchJobs_ = null;
        }
        return patchJobsBuilder_;
      }

      private java.lang.Object nextPageToken_ = "";
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of results.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return The nextPageToken.
       */
      public java.lang.String getNextPageToken() {
        java.lang.Object ref = nextPageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          nextPageToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of results.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return The bytes for nextPageToken.
       */
      public com.google.protobuf.ByteString getNextPageTokenBytes() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          nextPageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of results.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @param value The nextPageToken to set.
       * @return This builder for chaining.
       */
      public Builder setNextPageToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        nextPageToken_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of results.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNextPageToken() {
        nextPageToken_ = getDefaultInstance().getNextPageToken();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A pagination token that can be used to get the next page of results.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @param value The bytes for nextPageToken to set.
       * @return This builder for chaining.
       */
      public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        nextPageToken_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.ListPatchJobsResponse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.ListPatchJobsResponse)
    private static final com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListPatchJobsResponse> PARSER =
        new com.google.protobuf.AbstractParser<ListPatchJobsResponse>() {
          @java.lang.Override
          public ListPatchJobsResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListPatchJobsResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListPatchJobsResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ListPatchJobsResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PatchJobOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.PatchJob)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Unique identifier for this patch job in the form
     * `projects/&#42;&#47;patchJobs/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Unique identifier for this patch job in the form
     * `projects/&#42;&#47;patchJobs/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Display name for this patch job. This is not a unique identifier.
     * </pre>
     *
     * <code>string display_name = 14;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * Display name for this patch job. This is not a unique identifier.
     * </pre>
     *
     * <code>string display_name = 14;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Description of the patch job. Length of the description is limited
     * to 1024 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * Description of the patch job. Length of the description is limited
     * to 1024 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * Time this patch job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return Whether the createTime field is set.
     */
    boolean hasCreateTime();
    /**
     *
     *
     * <pre>
     * Time this patch job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return The createTime.
     */
    com.google.protobuf.Timestamp getCreateTime();
    /**
     *
     *
     * <pre>
     * Time this patch job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Last time this patch job was updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     *
     * @return Whether the updateTime field is set.
     */
    boolean hasUpdateTime();
    /**
     *
     *
     * <pre>
     * Last time this patch job was updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     *
     * @return The updateTime.
     */
    com.google.protobuf.Timestamp getUpdateTime();
    /**
     *
     *
     * <pre>
     * Last time this patch job was updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The current state of the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchJob.State state = 5;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * The current state of the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchJob.State state = 5;</code>
     *
     * @return The state.
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchJob.State getState();

    /**
     *
     *
     * <pre>
     * Instances to patch.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
     *
     * @return Whether the instanceFilter field is set.
     */
    boolean hasInstanceFilter();
    /**
     *
     *
     * <pre>
     * Instances to patch.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
     *
     * @return The instanceFilter.
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter getInstanceFilter();
    /**
     *
     *
     * <pre>
     * Instances to patch.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder
        getInstanceFilterOrBuilder();

    /**
     *
     *
     * <pre>
     * Patch configuration being applied.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
     *
     * @return Whether the patchConfig field is set.
     */
    boolean hasPatchConfig();
    /**
     *
     *
     * <pre>
     * Patch configuration being applied.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
     *
     * @return The patchConfig.
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchConfig getPatchConfig();
    /**
     *
     *
     * <pre>
     * Patch configuration being applied.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder getPatchConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Duration of the patch job. After the duration ends, the
     * patch job times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 8;</code>
     *
     * @return Whether the duration field is set.
     */
    boolean hasDuration();
    /**
     *
     *
     * <pre>
     * Duration of the patch job. After the duration ends, the
     * patch job times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 8;</code>
     *
     * @return The duration.
     */
    com.google.protobuf.Duration getDuration();
    /**
     *
     *
     * <pre>
     * Duration of the patch job. After the duration ends, the
     * patch job times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 8;</code>
     */
    com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Summary of instance details.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
     * </code>
     *
     * @return Whether the instanceDetailsSummary field is set.
     */
    boolean hasInstanceDetailsSummary();
    /**
     *
     *
     * <pre>
     * Summary of instance details.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
     * </code>
     *
     * @return The instanceDetailsSummary.
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
        getInstanceDetailsSummary();
    /**
     *
     *
     * <pre>
     * Summary of instance details.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
     * </code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummaryOrBuilder
        getInstanceDetailsSummaryOrBuilder();

    /**
     *
     *
     * <pre>
     * If this patch job is a dry run, the agent reports that it has
     * finished without running any updates on the VM instance.
     * </pre>
     *
     * <code>bool dry_run = 10;</code>
     *
     * @return The dryRun.
     */
    boolean getDryRun();

    /**
     *
     *
     * <pre>
     * If this patch job failed, this message provides information about the
     * failure.
     * </pre>
     *
     * <code>string error_message = 11;</code>
     *
     * @return The errorMessage.
     */
    java.lang.String getErrorMessage();
    /**
     *
     *
     * <pre>
     * If this patch job failed, this message provides information about the
     * failure.
     * </pre>
     *
     * <code>string error_message = 11;</code>
     *
     * @return The bytes for errorMessage.
     */
    com.google.protobuf.ByteString getErrorMessageBytes();

    /**
     *
     *
     * <pre>
     * Reflects the overall progress of the patch job in the range of
     * 0.0 being no progress to 100.0 being complete.
     * </pre>
     *
     * <code>double percent_complete = 12;</code>
     *
     * @return The percentComplete.
     */
    double getPercentComplete();

    /**
     *
     *
     * <pre>
     * Output only. Name of the patch deployment that created this patch job.
     * </pre>
     *
     * <code>
     * string patch_deployment = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The patchDeployment.
     */
    java.lang.String getPatchDeployment();
    /**
     *
     *
     * <pre>
     * Output only. Name of the patch deployment that created this patch job.
     * </pre>
     *
     * <code>
     * string patch_deployment = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for patchDeployment.
     */
    com.google.protobuf.ByteString getPatchDeploymentBytes();

    /**
     *
     *
     * <pre>
     * Rollout strategy being applied.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
     *
     * @return Whether the rollout field is set.
     */
    boolean hasRollout();
    /**
     *
     *
     * <pre>
     * Rollout strategy being applied.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
     *
     * @return The rollout.
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchRollout getRollout();
    /**
     *
     *
     * <pre>
     * Rollout strategy being applied.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder getRolloutOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A high level representation of a patch job that is either in progress
   * or has completed.
   *
   * Instance details are not included in the job. To paginate through instance
   * details, use ListPatchJobInstanceDetails.
   *
   * For more information about patch jobs, see
   * [Creating patch
   * jobs](https://cloud.google.com/compute/docs/os-patch-management/create-patch-job).
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.PatchJob}
   */
  public static final class PatchJob extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.PatchJob)
      PatchJobOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PatchJob.newBuilder() to construct.
    private PatchJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PatchJob() {
      name_ = "";
      displayName_ = "";
      description_ = "";
      state_ = 0;
      errorMessage_ = "";
      patchDeployment_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PatchJob();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_PatchJob_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_PatchJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.PatchJob.class,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJob.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Enumeration of the various states a patch job passes through as it
     * executes.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.osconfig.v1.PatchJob.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * State must be specified.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The patch job was successfully initiated.
       * </pre>
       *
       * <code>STARTED = 1;</code>
       */
      STARTED(1),
      /**
       *
       *
       * <pre>
       * The patch job is looking up instances to run the patch on.
       * </pre>
       *
       * <code>INSTANCE_LOOKUP = 2;</code>
       */
      INSTANCE_LOOKUP(2),
      /**
       *
       *
       * <pre>
       * Instances are being patched.
       * </pre>
       *
       * <code>PATCHING = 3;</code>
       */
      PATCHING(3),
      /**
       *
       *
       * <pre>
       * Patch job completed successfully.
       * </pre>
       *
       * <code>SUCCEEDED = 4;</code>
       */
      SUCCEEDED(4),
      /**
       *
       *
       * <pre>
       * Patch job completed but there were errors.
       * </pre>
       *
       * <code>COMPLETED_WITH_ERRORS = 5;</code>
       */
      COMPLETED_WITH_ERRORS(5),
      /**
       *
       *
       * <pre>
       * The patch job was canceled.
       * </pre>
       *
       * <code>CANCELED = 6;</code>
       */
      CANCELED(6),
      /**
       *
       *
       * <pre>
       * The patch job timed out.
       * </pre>
       *
       * <code>TIMED_OUT = 7;</code>
       */
      TIMED_OUT(7),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * State must be specified.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The patch job was successfully initiated.
       * </pre>
       *
       * <code>STARTED = 1;</code>
       */
      public static final int STARTED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The patch job is looking up instances to run the patch on.
       * </pre>
       *
       * <code>INSTANCE_LOOKUP = 2;</code>
       */
      public static final int INSTANCE_LOOKUP_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Instances are being patched.
       * </pre>
       *
       * <code>PATCHING = 3;</code>
       */
      public static final int PATCHING_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Patch job completed successfully.
       * </pre>
       *
       * <code>SUCCEEDED = 4;</code>
       */
      public static final int SUCCEEDED_VALUE = 4;
      /**
       *
       *
       * <pre>
       * Patch job completed but there were errors.
       * </pre>
       *
       * <code>COMPLETED_WITH_ERRORS = 5;</code>
       */
      public static final int COMPLETED_WITH_ERRORS_VALUE = 5;
      /**
       *
       *
       * <pre>
       * The patch job was canceled.
       * </pre>
       *
       * <code>CANCELED = 6;</code>
       */
      public static final int CANCELED_VALUE = 6;
      /**
       *
       *
       * <pre>
       * The patch job timed out.
       * </pre>
       *
       * <code>TIMED_OUT = 7;</code>
       */
      public static final int TIMED_OUT_VALUE = 7;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return STARTED;
          case 2:
            return INSTANCE_LOOKUP;
          case 3:
            return PATCHING;
          case 4:
            return SUCCEEDED;
          case 5:
            return COMPLETED_WITH_ERRORS;
          case 6:
            return CANCELED;
          case 7:
            return TIMED_OUT;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs.PatchJob.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.PatchJob.State)
    }

    public interface InstanceDetailsSummaryOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Number of instances pending patch job.
       * </pre>
       *
       * <code>int64 pending_instance_count = 1;</code>
       *
       * @return The pendingInstanceCount.
       */
      long getPendingInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances that are inactive.
       * </pre>
       *
       * <code>int64 inactive_instance_count = 2;</code>
       *
       * @return The inactiveInstanceCount.
       */
      long getInactiveInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances notified about patch job.
       * </pre>
       *
       * <code>int64 notified_instance_count = 3;</code>
       *
       * @return The notifiedInstanceCount.
       */
      long getNotifiedInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances that have started.
       * </pre>
       *
       * <code>int64 started_instance_count = 4;</code>
       *
       * @return The startedInstanceCount.
       */
      long getStartedInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances that are downloading patches.
       * </pre>
       *
       * <code>int64 downloading_patches_instance_count = 5;</code>
       *
       * @return The downloadingPatchesInstanceCount.
       */
      long getDownloadingPatchesInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances that are applying patches.
       * </pre>
       *
       * <code>int64 applying_patches_instance_count = 6;</code>
       *
       * @return The applyingPatchesInstanceCount.
       */
      long getApplyingPatchesInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances rebooting.
       * </pre>
       *
       * <code>int64 rebooting_instance_count = 7;</code>
       *
       * @return The rebootingInstanceCount.
       */
      long getRebootingInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances that have completed successfully.
       * </pre>
       *
       * <code>int64 succeeded_instance_count = 8;</code>
       *
       * @return The succeededInstanceCount.
       */
      long getSucceededInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances that require reboot.
       * </pre>
       *
       * <code>int64 succeeded_reboot_required_instance_count = 9;</code>
       *
       * @return The succeededRebootRequiredInstanceCount.
       */
      long getSucceededRebootRequiredInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances that failed.
       * </pre>
       *
       * <code>int64 failed_instance_count = 10;</code>
       *
       * @return The failedInstanceCount.
       */
      long getFailedInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances that have acked and will start shortly.
       * </pre>
       *
       * <code>int64 acked_instance_count = 11;</code>
       *
       * @return The ackedInstanceCount.
       */
      long getAckedInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances that exceeded the time out while applying the patch.
       * </pre>
       *
       * <code>int64 timed_out_instance_count = 12;</code>
       *
       * @return The timedOutInstanceCount.
       */
      long getTimedOutInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances that are running the pre-patch step.
       * </pre>
       *
       * <code>int64 pre_patch_step_instance_count = 13;</code>
       *
       * @return The prePatchStepInstanceCount.
       */
      long getPrePatchStepInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances that are running the post-patch step.
       * </pre>
       *
       * <code>int64 post_patch_step_instance_count = 14;</code>
       *
       * @return The postPatchStepInstanceCount.
       */
      long getPostPatchStepInstanceCount();

      /**
       *
       *
       * <pre>
       * Number of instances that do not appear to be running the agent. Check to
       * ensure that the agent is installed, running, and able to communicate with
       * the service.
       * </pre>
       *
       * <code>int64 no_agent_detected_instance_count = 15;</code>
       *
       * @return The noAgentDetectedInstanceCount.
       */
      long getNoAgentDetectedInstanceCount();
    }
    /**
     *
     *
     * <pre>
     * A summary of the current patch state across all instances that this patch
     * job affects. Contains counts of instances in different states. These states
     * map to `InstancePatchState`. List patch job instance details to see the
     * specific states of each instance.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary}
     */
    public static final class InstanceDetailsSummary extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary)
        InstanceDetailsSummaryOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use InstanceDetailsSummary.newBuilder() to construct.
      private InstanceDetailsSummary(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private InstanceDetailsSummary() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new InstanceDetailsSummary();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_PatchJob_InstanceDetailsSummary_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_PatchJob_InstanceDetailsSummary_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary.class,
                com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary.Builder
                    .class);
      }

      public static final int PENDING_INSTANCE_COUNT_FIELD_NUMBER = 1;
      private long pendingInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances pending patch job.
       * </pre>
       *
       * <code>int64 pending_instance_count = 1;</code>
       *
       * @return The pendingInstanceCount.
       */
      @java.lang.Override
      public long getPendingInstanceCount() {
        return pendingInstanceCount_;
      }

      public static final int INACTIVE_INSTANCE_COUNT_FIELD_NUMBER = 2;
      private long inactiveInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances that are inactive.
       * </pre>
       *
       * <code>int64 inactive_instance_count = 2;</code>
       *
       * @return The inactiveInstanceCount.
       */
      @java.lang.Override
      public long getInactiveInstanceCount() {
        return inactiveInstanceCount_;
      }

      public static final int NOTIFIED_INSTANCE_COUNT_FIELD_NUMBER = 3;
      private long notifiedInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances notified about patch job.
       * </pre>
       *
       * <code>int64 notified_instance_count = 3;</code>
       *
       * @return The notifiedInstanceCount.
       */
      @java.lang.Override
      public long getNotifiedInstanceCount() {
        return notifiedInstanceCount_;
      }

      public static final int STARTED_INSTANCE_COUNT_FIELD_NUMBER = 4;
      private long startedInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances that have started.
       * </pre>
       *
       * <code>int64 started_instance_count = 4;</code>
       *
       * @return The startedInstanceCount.
       */
      @java.lang.Override
      public long getStartedInstanceCount() {
        return startedInstanceCount_;
      }

      public static final int DOWNLOADING_PATCHES_INSTANCE_COUNT_FIELD_NUMBER = 5;
      private long downloadingPatchesInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances that are downloading patches.
       * </pre>
       *
       * <code>int64 downloading_patches_instance_count = 5;</code>
       *
       * @return The downloadingPatchesInstanceCount.
       */
      @java.lang.Override
      public long getDownloadingPatchesInstanceCount() {
        return downloadingPatchesInstanceCount_;
      }

      public static final int APPLYING_PATCHES_INSTANCE_COUNT_FIELD_NUMBER = 6;
      private long applyingPatchesInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances that are applying patches.
       * </pre>
       *
       * <code>int64 applying_patches_instance_count = 6;</code>
       *
       * @return The applyingPatchesInstanceCount.
       */
      @java.lang.Override
      public long getApplyingPatchesInstanceCount() {
        return applyingPatchesInstanceCount_;
      }

      public static final int REBOOTING_INSTANCE_COUNT_FIELD_NUMBER = 7;
      private long rebootingInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances rebooting.
       * </pre>
       *
       * <code>int64 rebooting_instance_count = 7;</code>
       *
       * @return The rebootingInstanceCount.
       */
      @java.lang.Override
      public long getRebootingInstanceCount() {
        return rebootingInstanceCount_;
      }

      public static final int SUCCEEDED_INSTANCE_COUNT_FIELD_NUMBER = 8;
      private long succeededInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances that have completed successfully.
       * </pre>
       *
       * <code>int64 succeeded_instance_count = 8;</code>
       *
       * @return The succeededInstanceCount.
       */
      @java.lang.Override
      public long getSucceededInstanceCount() {
        return succeededInstanceCount_;
      }

      public static final int SUCCEEDED_REBOOT_REQUIRED_INSTANCE_COUNT_FIELD_NUMBER = 9;
      private long succeededRebootRequiredInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances that require reboot.
       * </pre>
       *
       * <code>int64 succeeded_reboot_required_instance_count = 9;</code>
       *
       * @return The succeededRebootRequiredInstanceCount.
       */
      @java.lang.Override
      public long getSucceededRebootRequiredInstanceCount() {
        return succeededRebootRequiredInstanceCount_;
      }

      public static final int FAILED_INSTANCE_COUNT_FIELD_NUMBER = 10;
      private long failedInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances that failed.
       * </pre>
       *
       * <code>int64 failed_instance_count = 10;</code>
       *
       * @return The failedInstanceCount.
       */
      @java.lang.Override
      public long getFailedInstanceCount() {
        return failedInstanceCount_;
      }

      public static final int ACKED_INSTANCE_COUNT_FIELD_NUMBER = 11;
      private long ackedInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances that have acked and will start shortly.
       * </pre>
       *
       * <code>int64 acked_instance_count = 11;</code>
       *
       * @return The ackedInstanceCount.
       */
      @java.lang.Override
      public long getAckedInstanceCount() {
        return ackedInstanceCount_;
      }

      public static final int TIMED_OUT_INSTANCE_COUNT_FIELD_NUMBER = 12;
      private long timedOutInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances that exceeded the time out while applying the patch.
       * </pre>
       *
       * <code>int64 timed_out_instance_count = 12;</code>
       *
       * @return The timedOutInstanceCount.
       */
      @java.lang.Override
      public long getTimedOutInstanceCount() {
        return timedOutInstanceCount_;
      }

      public static final int PRE_PATCH_STEP_INSTANCE_COUNT_FIELD_NUMBER = 13;
      private long prePatchStepInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances that are running the pre-patch step.
       * </pre>
       *
       * <code>int64 pre_patch_step_instance_count = 13;</code>
       *
       * @return The prePatchStepInstanceCount.
       */
      @java.lang.Override
      public long getPrePatchStepInstanceCount() {
        return prePatchStepInstanceCount_;
      }

      public static final int POST_PATCH_STEP_INSTANCE_COUNT_FIELD_NUMBER = 14;
      private long postPatchStepInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances that are running the post-patch step.
       * </pre>
       *
       * <code>int64 post_patch_step_instance_count = 14;</code>
       *
       * @return The postPatchStepInstanceCount.
       */
      @java.lang.Override
      public long getPostPatchStepInstanceCount() {
        return postPatchStepInstanceCount_;
      }

      public static final int NO_AGENT_DETECTED_INSTANCE_COUNT_FIELD_NUMBER = 15;
      private long noAgentDetectedInstanceCount_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of instances that do not appear to be running the agent. Check to
       * ensure that the agent is installed, running, and able to communicate with
       * the service.
       * </pre>
       *
       * <code>int64 no_agent_detected_instance_count = 15;</code>
       *
       * @return The noAgentDetectedInstanceCount.
       */
      @java.lang.Override
      public long getNoAgentDetectedInstanceCount() {
        return noAgentDetectedInstanceCount_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (pendingInstanceCount_ != 0L) {
          output.writeInt64(1, pendingInstanceCount_);
        }
        if (inactiveInstanceCount_ != 0L) {
          output.writeInt64(2, inactiveInstanceCount_);
        }
        if (notifiedInstanceCount_ != 0L) {
          output.writeInt64(3, notifiedInstanceCount_);
        }
        if (startedInstanceCount_ != 0L) {
          output.writeInt64(4, startedInstanceCount_);
        }
        if (downloadingPatchesInstanceCount_ != 0L) {
          output.writeInt64(5, downloadingPatchesInstanceCount_);
        }
        if (applyingPatchesInstanceCount_ != 0L) {
          output.writeInt64(6, applyingPatchesInstanceCount_);
        }
        if (rebootingInstanceCount_ != 0L) {
          output.writeInt64(7, rebootingInstanceCount_);
        }
        if (succeededInstanceCount_ != 0L) {
          output.writeInt64(8, succeededInstanceCount_);
        }
        if (succeededRebootRequiredInstanceCount_ != 0L) {
          output.writeInt64(9, succeededRebootRequiredInstanceCount_);
        }
        if (failedInstanceCount_ != 0L) {
          output.writeInt64(10, failedInstanceCount_);
        }
        if (ackedInstanceCount_ != 0L) {
          output.writeInt64(11, ackedInstanceCount_);
        }
        if (timedOutInstanceCount_ != 0L) {
          output.writeInt64(12, timedOutInstanceCount_);
        }
        if (prePatchStepInstanceCount_ != 0L) {
          output.writeInt64(13, prePatchStepInstanceCount_);
        }
        if (postPatchStepInstanceCount_ != 0L) {
          output.writeInt64(14, postPatchStepInstanceCount_);
        }
        if (noAgentDetectedInstanceCount_ != 0L) {
          output.writeInt64(15, noAgentDetectedInstanceCount_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (pendingInstanceCount_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, pendingInstanceCount_);
        }
        if (inactiveInstanceCount_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, inactiveInstanceCount_);
        }
        if (notifiedInstanceCount_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, notifiedInstanceCount_);
        }
        if (startedInstanceCount_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, startedInstanceCount_);
        }
        if (downloadingPatchesInstanceCount_ != 0L) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt64Size(
                  5, downloadingPatchesInstanceCount_);
        }
        if (applyingPatchesInstanceCount_ != 0L) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt64Size(
                  6, applyingPatchesInstanceCount_);
        }
        if (rebootingInstanceCount_ != 0L) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt64Size(7, rebootingInstanceCount_);
        }
        if (succeededInstanceCount_ != 0L) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt64Size(8, succeededInstanceCount_);
        }
        if (succeededRebootRequiredInstanceCount_ != 0L) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt64Size(
                  9, succeededRebootRequiredInstanceCount_);
        }
        if (failedInstanceCount_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(10, failedInstanceCount_);
        }
        if (ackedInstanceCount_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(11, ackedInstanceCount_);
        }
        if (timedOutInstanceCount_ != 0L) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt64Size(12, timedOutInstanceCount_);
        }
        if (prePatchStepInstanceCount_ != 0L) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt64Size(
                  13, prePatchStepInstanceCount_);
        }
        if (postPatchStepInstanceCount_ != 0L) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt64Size(
                  14, postPatchStepInstanceCount_);
        }
        if (noAgentDetectedInstanceCount_ != 0L) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt64Size(
                  15, noAgentDetectedInstanceCount_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary)) {
          return super.equals(obj);
        }
        com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary other =
            (com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary) obj;

        if (getPendingInstanceCount() != other.getPendingInstanceCount()) return false;
        if (getInactiveInstanceCount() != other.getInactiveInstanceCount()) return false;
        if (getNotifiedInstanceCount() != other.getNotifiedInstanceCount()) return false;
        if (getStartedInstanceCount() != other.getStartedInstanceCount()) return false;
        if (getDownloadingPatchesInstanceCount() != other.getDownloadingPatchesInstanceCount())
          return false;
        if (getApplyingPatchesInstanceCount() != other.getApplyingPatchesInstanceCount())
          return false;
        if (getRebootingInstanceCount() != other.getRebootingInstanceCount()) return false;
        if (getSucceededInstanceCount() != other.getSucceededInstanceCount()) return false;
        if (getSucceededRebootRequiredInstanceCount()
            != other.getSucceededRebootRequiredInstanceCount()) return false;
        if (getFailedInstanceCount() != other.getFailedInstanceCount()) return false;
        if (getAckedInstanceCount() != other.getAckedInstanceCount()) return false;
        if (getTimedOutInstanceCount() != other.getTimedOutInstanceCount()) return false;
        if (getPrePatchStepInstanceCount() != other.getPrePatchStepInstanceCount()) return false;
        if (getPostPatchStepInstanceCount() != other.getPostPatchStepInstanceCount()) return false;
        if (getNoAgentDetectedInstanceCount() != other.getNoAgentDetectedInstanceCount())
          return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + PENDING_INSTANCE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPendingInstanceCount());
        hash = (37 * hash) + INACTIVE_INSTANCE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getInactiveInstanceCount());
        hash = (37 * hash) + NOTIFIED_INSTANCE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getNotifiedInstanceCount());
        hash = (37 * hash) + STARTED_INSTANCE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getStartedInstanceCount());
        hash = (37 * hash) + DOWNLOADING_PATCHES_INSTANCE_COUNT_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(getDownloadingPatchesInstanceCount());
        hash = (37 * hash) + APPLYING_PATCHES_INSTANCE_COUNT_FIELD_NUMBER;
        hash =
            (53 * hash) + com.google.protobuf.Internal.hashLong(getApplyingPatchesInstanceCount());
        hash = (37 * hash) + REBOOTING_INSTANCE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRebootingInstanceCount());
        hash = (37 * hash) + SUCCEEDED_INSTANCE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSucceededInstanceCount());
        hash = (37 * hash) + SUCCEEDED_REBOOT_REQUIRED_INSTANCE_COUNT_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(getSucceededRebootRequiredInstanceCount());
        hash = (37 * hash) + FAILED_INSTANCE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFailedInstanceCount());
        hash = (37 * hash) + ACKED_INSTANCE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAckedInstanceCount());
        hash = (37 * hash) + TIMED_OUT_INSTANCE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTimedOutInstanceCount());
        hash = (37 * hash) + PRE_PATCH_STEP_INSTANCE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPrePatchStepInstanceCount());
        hash = (37 * hash) + POST_PATCH_STEP_INSTANCE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPostPatchStepInstanceCount());
        hash = (37 * hash) + NO_AGENT_DETECTED_INSTANCE_COUNT_FIELD_NUMBER;
        hash =
            (53 * hash) + com.google.protobuf.Internal.hashLong(getNoAgentDetectedInstanceCount());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A summary of the current patch state across all instances that this patch
       * job affects. Contains counts of instances in different states. These states
       * map to `InstancePatchState`. List patch job instance details to see the
       * specific states of each instance.
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary)
          com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummaryOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1.PatchJobs
              .internal_static_google_cloud_osconfig_v1_PatchJob_InstanceDetailsSummary_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1.PatchJobs
              .internal_static_google_cloud_osconfig_v1_PatchJob_InstanceDetailsSummary_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary.class,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          pendingInstanceCount_ = 0L;
          inactiveInstanceCount_ = 0L;
          notifiedInstanceCount_ = 0L;
          startedInstanceCount_ = 0L;
          downloadingPatchesInstanceCount_ = 0L;
          applyingPatchesInstanceCount_ = 0L;
          rebootingInstanceCount_ = 0L;
          succeededInstanceCount_ = 0L;
          succeededRebootRequiredInstanceCount_ = 0L;
          failedInstanceCount_ = 0L;
          ackedInstanceCount_ = 0L;
          timedOutInstanceCount_ = 0L;
          prePatchStepInstanceCount_ = 0L;
          postPatchStepInstanceCount_ = 0L;
          noAgentDetectedInstanceCount_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.osconfig.v1.PatchJobs
              .internal_static_google_cloud_osconfig_v1_PatchJob_InstanceDetailsSummary_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
            getDefaultInstanceForType() {
          return com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary build() {
          com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
            buildPartial() {
          com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary result =
              new com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.pendingInstanceCount_ = pendingInstanceCount_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.inactiveInstanceCount_ = inactiveInstanceCount_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.notifiedInstanceCount_ = notifiedInstanceCount_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.startedInstanceCount_ = startedInstanceCount_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.downloadingPatchesInstanceCount_ = downloadingPatchesInstanceCount_;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.applyingPatchesInstanceCount_ = applyingPatchesInstanceCount_;
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.rebootingInstanceCount_ = rebootingInstanceCount_;
          }
          if (((from_bitField0_ & 0x00000080) != 0)) {
            result.succeededInstanceCount_ = succeededInstanceCount_;
          }
          if (((from_bitField0_ & 0x00000100) != 0)) {
            result.succeededRebootRequiredInstanceCount_ = succeededRebootRequiredInstanceCount_;
          }
          if (((from_bitField0_ & 0x00000200) != 0)) {
            result.failedInstanceCount_ = failedInstanceCount_;
          }
          if (((from_bitField0_ & 0x00000400) != 0)) {
            result.ackedInstanceCount_ = ackedInstanceCount_;
          }
          if (((from_bitField0_ & 0x00000800) != 0)) {
            result.timedOutInstanceCount_ = timedOutInstanceCount_;
          }
          if (((from_bitField0_ & 0x00001000) != 0)) {
            result.prePatchStepInstanceCount_ = prePatchStepInstanceCount_;
          }
          if (((from_bitField0_ & 0x00002000) != 0)) {
            result.postPatchStepInstanceCount_ = postPatchStepInstanceCount_;
          }
          if (((from_bitField0_ & 0x00004000) != 0)) {
            result.noAgentDetectedInstanceCount_ = noAgentDetectedInstanceCount_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary) {
            return mergeFrom(
                (com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary other) {
          if (other
              == com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
                  .getDefaultInstance()) return this;
          if (other.getPendingInstanceCount() != 0L) {
            setPendingInstanceCount(other.getPendingInstanceCount());
          }
          if (other.getInactiveInstanceCount() != 0L) {
            setInactiveInstanceCount(other.getInactiveInstanceCount());
          }
          if (other.getNotifiedInstanceCount() != 0L) {
            setNotifiedInstanceCount(other.getNotifiedInstanceCount());
          }
          if (other.getStartedInstanceCount() != 0L) {
            setStartedInstanceCount(other.getStartedInstanceCount());
          }
          if (other.getDownloadingPatchesInstanceCount() != 0L) {
            setDownloadingPatchesInstanceCount(other.getDownloadingPatchesInstanceCount());
          }
          if (other.getApplyingPatchesInstanceCount() != 0L) {
            setApplyingPatchesInstanceCount(other.getApplyingPatchesInstanceCount());
          }
          if (other.getRebootingInstanceCount() != 0L) {
            setRebootingInstanceCount(other.getRebootingInstanceCount());
          }
          if (other.getSucceededInstanceCount() != 0L) {
            setSucceededInstanceCount(other.getSucceededInstanceCount());
          }
          if (other.getSucceededRebootRequiredInstanceCount() != 0L) {
            setSucceededRebootRequiredInstanceCount(
                other.getSucceededRebootRequiredInstanceCount());
          }
          if (other.getFailedInstanceCount() != 0L) {
            setFailedInstanceCount(other.getFailedInstanceCount());
          }
          if (other.getAckedInstanceCount() != 0L) {
            setAckedInstanceCount(other.getAckedInstanceCount());
          }
          if (other.getTimedOutInstanceCount() != 0L) {
            setTimedOutInstanceCount(other.getTimedOutInstanceCount());
          }
          if (other.getPrePatchStepInstanceCount() != 0L) {
            setPrePatchStepInstanceCount(other.getPrePatchStepInstanceCount());
          }
          if (other.getPostPatchStepInstanceCount() != 0L) {
            setPostPatchStepInstanceCount(other.getPostPatchStepInstanceCount());
          }
          if (other.getNoAgentDetectedInstanceCount() != 0L) {
            setNoAgentDetectedInstanceCount(other.getNoAgentDetectedInstanceCount());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    pendingInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    inactiveInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    notifiedInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 32:
                  {
                    startedInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                case 40:
                  {
                    downloadingPatchesInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 40
                case 48:
                  {
                    applyingPatchesInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 48
                case 56:
                  {
                    rebootingInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00000040;
                    break;
                  } // case 56
                case 64:
                  {
                    succeededInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00000080;
                    break;
                  } // case 64
                case 72:
                  {
                    succeededRebootRequiredInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00000100;
                    break;
                  } // case 72
                case 80:
                  {
                    failedInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00000200;
                    break;
                  } // case 80
                case 88:
                  {
                    ackedInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00000400;
                    break;
                  } // case 88
                case 96:
                  {
                    timedOutInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00000800;
                    break;
                  } // case 96
                case 104:
                  {
                    prePatchStepInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00001000;
                    break;
                  } // case 104
                case 112:
                  {
                    postPatchStepInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00002000;
                    break;
                  } // case 112
                case 120:
                  {
                    noAgentDetectedInstanceCount_ = input.readInt64();
                    bitField0_ |= 0x00004000;
                    break;
                  } // case 120
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long pendingInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances pending patch job.
         * </pre>
         *
         * <code>int64 pending_instance_count = 1;</code>
         *
         * @return The pendingInstanceCount.
         */
        @java.lang.Override
        public long getPendingInstanceCount() {
          return pendingInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances pending patch job.
         * </pre>
         *
         * <code>int64 pending_instance_count = 1;</code>
         *
         * @param value The pendingInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setPendingInstanceCount(long value) {

          pendingInstanceCount_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances pending patch job.
         * </pre>
         *
         * <code>int64 pending_instance_count = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPendingInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00000001);
          pendingInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long inactiveInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances that are inactive.
         * </pre>
         *
         * <code>int64 inactive_instance_count = 2;</code>
         *
         * @return The inactiveInstanceCount.
         */
        @java.lang.Override
        public long getInactiveInstanceCount() {
          return inactiveInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that are inactive.
         * </pre>
         *
         * <code>int64 inactive_instance_count = 2;</code>
         *
         * @param value The inactiveInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setInactiveInstanceCount(long value) {

          inactiveInstanceCount_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that are inactive.
         * </pre>
         *
         * <code>int64 inactive_instance_count = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearInactiveInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00000002);
          inactiveInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long notifiedInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances notified about patch job.
         * </pre>
         *
         * <code>int64 notified_instance_count = 3;</code>
         *
         * @return The notifiedInstanceCount.
         */
        @java.lang.Override
        public long getNotifiedInstanceCount() {
          return notifiedInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances notified about patch job.
         * </pre>
         *
         * <code>int64 notified_instance_count = 3;</code>
         *
         * @param value The notifiedInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setNotifiedInstanceCount(long value) {

          notifiedInstanceCount_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances notified about patch job.
         * </pre>
         *
         * <code>int64 notified_instance_count = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearNotifiedInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00000004);
          notifiedInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long startedInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances that have started.
         * </pre>
         *
         * <code>int64 started_instance_count = 4;</code>
         *
         * @return The startedInstanceCount.
         */
        @java.lang.Override
        public long getStartedInstanceCount() {
          return startedInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that have started.
         * </pre>
         *
         * <code>int64 started_instance_count = 4;</code>
         *
         * @param value The startedInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setStartedInstanceCount(long value) {

          startedInstanceCount_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that have started.
         * </pre>
         *
         * <code>int64 started_instance_count = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearStartedInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00000008);
          startedInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long downloadingPatchesInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances that are downloading patches.
         * </pre>
         *
         * <code>int64 downloading_patches_instance_count = 5;</code>
         *
         * @return The downloadingPatchesInstanceCount.
         */
        @java.lang.Override
        public long getDownloadingPatchesInstanceCount() {
          return downloadingPatchesInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that are downloading patches.
         * </pre>
         *
         * <code>int64 downloading_patches_instance_count = 5;</code>
         *
         * @param value The downloadingPatchesInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setDownloadingPatchesInstanceCount(long value) {

          downloadingPatchesInstanceCount_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that are downloading patches.
         * </pre>
         *
         * <code>int64 downloading_patches_instance_count = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDownloadingPatchesInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00000010);
          downloadingPatchesInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long applyingPatchesInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances that are applying patches.
         * </pre>
         *
         * <code>int64 applying_patches_instance_count = 6;</code>
         *
         * @return The applyingPatchesInstanceCount.
         */
        @java.lang.Override
        public long getApplyingPatchesInstanceCount() {
          return applyingPatchesInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that are applying patches.
         * </pre>
         *
         * <code>int64 applying_patches_instance_count = 6;</code>
         *
         * @param value The applyingPatchesInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setApplyingPatchesInstanceCount(long value) {

          applyingPatchesInstanceCount_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that are applying patches.
         * </pre>
         *
         * <code>int64 applying_patches_instance_count = 6;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearApplyingPatchesInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00000020);
          applyingPatchesInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long rebootingInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances rebooting.
         * </pre>
         *
         * <code>int64 rebooting_instance_count = 7;</code>
         *
         * @return The rebootingInstanceCount.
         */
        @java.lang.Override
        public long getRebootingInstanceCount() {
          return rebootingInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances rebooting.
         * </pre>
         *
         * <code>int64 rebooting_instance_count = 7;</code>
         *
         * @param value The rebootingInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setRebootingInstanceCount(long value) {

          rebootingInstanceCount_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances rebooting.
         * </pre>
         *
         * <code>int64 rebooting_instance_count = 7;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRebootingInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00000040);
          rebootingInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long succeededInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances that have completed successfully.
         * </pre>
         *
         * <code>int64 succeeded_instance_count = 8;</code>
         *
         * @return The succeededInstanceCount.
         */
        @java.lang.Override
        public long getSucceededInstanceCount() {
          return succeededInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that have completed successfully.
         * </pre>
         *
         * <code>int64 succeeded_instance_count = 8;</code>
         *
         * @param value The succeededInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setSucceededInstanceCount(long value) {

          succeededInstanceCount_ = value;
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that have completed successfully.
         * </pre>
         *
         * <code>int64 succeeded_instance_count = 8;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSucceededInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00000080);
          succeededInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long succeededRebootRequiredInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances that require reboot.
         * </pre>
         *
         * <code>int64 succeeded_reboot_required_instance_count = 9;</code>
         *
         * @return The succeededRebootRequiredInstanceCount.
         */
        @java.lang.Override
        public long getSucceededRebootRequiredInstanceCount() {
          return succeededRebootRequiredInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that require reboot.
         * </pre>
         *
         * <code>int64 succeeded_reboot_required_instance_count = 9;</code>
         *
         * @param value The succeededRebootRequiredInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setSucceededRebootRequiredInstanceCount(long value) {

          succeededRebootRequiredInstanceCount_ = value;
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that require reboot.
         * </pre>
         *
         * <code>int64 succeeded_reboot_required_instance_count = 9;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSucceededRebootRequiredInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00000100);
          succeededRebootRequiredInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long failedInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances that failed.
         * </pre>
         *
         * <code>int64 failed_instance_count = 10;</code>
         *
         * @return The failedInstanceCount.
         */
        @java.lang.Override
        public long getFailedInstanceCount() {
          return failedInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that failed.
         * </pre>
         *
         * <code>int64 failed_instance_count = 10;</code>
         *
         * @param value The failedInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setFailedInstanceCount(long value) {

          failedInstanceCount_ = value;
          bitField0_ |= 0x00000200;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that failed.
         * </pre>
         *
         * <code>int64 failed_instance_count = 10;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFailedInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00000200);
          failedInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long ackedInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances that have acked and will start shortly.
         * </pre>
         *
         * <code>int64 acked_instance_count = 11;</code>
         *
         * @return The ackedInstanceCount.
         */
        @java.lang.Override
        public long getAckedInstanceCount() {
          return ackedInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that have acked and will start shortly.
         * </pre>
         *
         * <code>int64 acked_instance_count = 11;</code>
         *
         * @param value The ackedInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setAckedInstanceCount(long value) {

          ackedInstanceCount_ = value;
          bitField0_ |= 0x00000400;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that have acked and will start shortly.
         * </pre>
         *
         * <code>int64 acked_instance_count = 11;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAckedInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00000400);
          ackedInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long timedOutInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances that exceeded the time out while applying the patch.
         * </pre>
         *
         * <code>int64 timed_out_instance_count = 12;</code>
         *
         * @return The timedOutInstanceCount.
         */
        @java.lang.Override
        public long getTimedOutInstanceCount() {
          return timedOutInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that exceeded the time out while applying the patch.
         * </pre>
         *
         * <code>int64 timed_out_instance_count = 12;</code>
         *
         * @param value The timedOutInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setTimedOutInstanceCount(long value) {

          timedOutInstanceCount_ = value;
          bitField0_ |= 0x00000800;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that exceeded the time out while applying the patch.
         * </pre>
         *
         * <code>int64 timed_out_instance_count = 12;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTimedOutInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00000800);
          timedOutInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long prePatchStepInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances that are running the pre-patch step.
         * </pre>
         *
         * <code>int64 pre_patch_step_instance_count = 13;</code>
         *
         * @return The prePatchStepInstanceCount.
         */
        @java.lang.Override
        public long getPrePatchStepInstanceCount() {
          return prePatchStepInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that are running the pre-patch step.
         * </pre>
         *
         * <code>int64 pre_patch_step_instance_count = 13;</code>
         *
         * @param value The prePatchStepInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setPrePatchStepInstanceCount(long value) {

          prePatchStepInstanceCount_ = value;
          bitField0_ |= 0x00001000;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that are running the pre-patch step.
         * </pre>
         *
         * <code>int64 pre_patch_step_instance_count = 13;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPrePatchStepInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00001000);
          prePatchStepInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long postPatchStepInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances that are running the post-patch step.
         * </pre>
         *
         * <code>int64 post_patch_step_instance_count = 14;</code>
         *
         * @return The postPatchStepInstanceCount.
         */
        @java.lang.Override
        public long getPostPatchStepInstanceCount() {
          return postPatchStepInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that are running the post-patch step.
         * </pre>
         *
         * <code>int64 post_patch_step_instance_count = 14;</code>
         *
         * @param value The postPatchStepInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setPostPatchStepInstanceCount(long value) {

          postPatchStepInstanceCount_ = value;
          bitField0_ |= 0x00002000;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that are running the post-patch step.
         * </pre>
         *
         * <code>int64 post_patch_step_instance_count = 14;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPostPatchStepInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00002000);
          postPatchStepInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        private long noAgentDetectedInstanceCount_;
        /**
         *
         *
         * <pre>
         * Number of instances that do not appear to be running the agent. Check to
         * ensure that the agent is installed, running, and able to communicate with
         * the service.
         * </pre>
         *
         * <code>int64 no_agent_detected_instance_count = 15;</code>
         *
         * @return The noAgentDetectedInstanceCount.
         */
        @java.lang.Override
        public long getNoAgentDetectedInstanceCount() {
          return noAgentDetectedInstanceCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that do not appear to be running the agent. Check to
         * ensure that the agent is installed, running, and able to communicate with
         * the service.
         * </pre>
         *
         * <code>int64 no_agent_detected_instance_count = 15;</code>
         *
         * @param value The noAgentDetectedInstanceCount to set.
         * @return This builder for chaining.
         */
        public Builder setNoAgentDetectedInstanceCount(long value) {

          noAgentDetectedInstanceCount_ = value;
          bitField0_ |= 0x00004000;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of instances that do not appear to be running the agent. Check to
         * ensure that the agent is installed, running, and able to communicate with
         * the service.
         * </pre>
         *
         * <code>int64 no_agent_detected_instance_count = 15;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearNoAgentDetectedInstanceCount() {
          bitField0_ = (bitField0_ & ~0x00004000);
          noAgentDetectedInstanceCount_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary)
      private static final com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary();
      }

      public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<InstanceDetailsSummary> PARSER =
          new com.google.protobuf.AbstractParser<InstanceDetailsSummary>() {
            @java.lang.Override
            public InstanceDetailsSummary parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<InstanceDetailsSummary> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<InstanceDetailsSummary> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier for this patch job in the form
     * `projects/&#42;&#47;patchJobs/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this patch job in the form
     * `projects/&#42;&#47;patchJobs/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 14;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Display name for this patch job. This is not a unique identifier.
     * </pre>
     *
     * <code>string display_name = 14;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name for this patch job. This is not a unique identifier.
     * </pre>
     *
     * <code>string display_name = 14;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of the patch job. Length of the description is limited
     * to 1024 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the patch job. Length of the description is limited
     * to 1024 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CREATE_TIME_FIELD_NUMBER = 3;
    private com.google.protobuf.Timestamp createTime_;
    /**
     *
     *
     * <pre>
     * Time this patch job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return Whether the createTime field is set.
     */
    @java.lang.Override
    public boolean hasCreateTime() {
      return createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time this patch job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return The createTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getCreateTime() {
      return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
    }
    /**
     *
     *
     * <pre>
     * Time this patch job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
    }

    public static final int UPDATE_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp updateTime_;
    /**
     *
     *
     * <pre>
     * Last time this patch job was updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     *
     * @return Whether the updateTime field is set.
     */
    @java.lang.Override
    public boolean hasUpdateTime() {
      return updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Last time this patch job was updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     *
     * @return The updateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getUpdateTime() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }
    /**
     *
     *
     * <pre>
     * Last time this patch job was updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }

    public static final int STATE_FIELD_NUMBER = 5;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The current state of the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchJob.State state = 5;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The current state of the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchJob.State state = 5;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.State getState() {
      com.google.cloud.osconfig.v1.PatchJobs.PatchJob.State result =
          com.google.cloud.osconfig.v1.PatchJobs.PatchJob.State.forNumber(state_);
      return result == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchJob.State.UNRECOGNIZED
          : result;
    }

    public static final int INSTANCE_FILTER_FIELD_NUMBER = 13;
    private com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter instanceFilter_;
    /**
     *
     *
     * <pre>
     * Instances to patch.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
     *
     * @return Whether the instanceFilter field is set.
     */
    @java.lang.Override
    public boolean hasInstanceFilter() {
      return instanceFilter_ != null;
    }
    /**
     *
     *
     * <pre>
     * Instances to patch.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
     *
     * @return The instanceFilter.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter getInstanceFilter() {
      return instanceFilter_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.getDefaultInstance()
          : instanceFilter_;
    }
    /**
     *
     *
     * <pre>
     * Instances to patch.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder
        getInstanceFilterOrBuilder() {
      return instanceFilter_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.getDefaultInstance()
          : instanceFilter_;
    }

    public static final int PATCH_CONFIG_FIELD_NUMBER = 7;
    private com.google.cloud.osconfig.v1.PatchJobs.PatchConfig patchConfig_;
    /**
     *
     *
     * <pre>
     * Patch configuration being applied.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
     *
     * @return Whether the patchConfig field is set.
     */
    @java.lang.Override
    public boolean hasPatchConfig() {
      return patchConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Patch configuration being applied.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
     *
     * @return The patchConfig.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig getPatchConfig() {
      return patchConfig_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()
          : patchConfig_;
    }
    /**
     *
     *
     * <pre>
     * Patch configuration being applied.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder getPatchConfigOrBuilder() {
      return patchConfig_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()
          : patchConfig_;
    }

    public static final int DURATION_FIELD_NUMBER = 8;
    private com.google.protobuf.Duration duration_;
    /**
     *
     *
     * <pre>
     * Duration of the patch job. After the duration ends, the
     * patch job times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 8;</code>
     *
     * @return Whether the duration field is set.
     */
    @java.lang.Override
    public boolean hasDuration() {
      return duration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Duration of the patch job. After the duration ends, the
     * patch job times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 8;</code>
     *
     * @return The duration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getDuration() {
      return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
    }
    /**
     *
     *
     * <pre>
     * Duration of the patch job. After the duration ends, the
     * patch job times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 8;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
      return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
    }

    public static final int INSTANCE_DETAILS_SUMMARY_FIELD_NUMBER = 9;
    private com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
        instanceDetailsSummary_;
    /**
     *
     *
     * <pre>
     * Summary of instance details.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
     * </code>
     *
     * @return Whether the instanceDetailsSummary field is set.
     */
    @java.lang.Override
    public boolean hasInstanceDetailsSummary() {
      return instanceDetailsSummary_ != null;
    }
    /**
     *
     *
     * <pre>
     * Summary of instance details.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
     * </code>
     *
     * @return The instanceDetailsSummary.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
        getInstanceDetailsSummary() {
      return instanceDetailsSummary_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
              .getDefaultInstance()
          : instanceDetailsSummary_;
    }
    /**
     *
     *
     * <pre>
     * Summary of instance details.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummaryOrBuilder
        getInstanceDetailsSummaryOrBuilder() {
      return instanceDetailsSummary_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
              .getDefaultInstance()
          : instanceDetailsSummary_;
    }

    public static final int DRY_RUN_FIELD_NUMBER = 10;
    private boolean dryRun_ = false;
    /**
     *
     *
     * <pre>
     * If this patch job is a dry run, the agent reports that it has
     * finished without running any updates on the VM instance.
     * </pre>
     *
     * <code>bool dry_run = 10;</code>
     *
     * @return The dryRun.
     */
    @java.lang.Override
    public boolean getDryRun() {
      return dryRun_;
    }

    public static final int ERROR_MESSAGE_FIELD_NUMBER = 11;

    @SuppressWarnings("serial")
    private volatile java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * If this patch job failed, this message provides information about the
     * failure.
     * </pre>
     *
     * <code>string error_message = 11;</code>
     *
     * @return The errorMessage.
     */
    @java.lang.Override
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * If this patch job failed, this message provides information about the
     * failure.
     * </pre>
     *
     * <code>string error_message = 11;</code>
     *
     * @return The bytes for errorMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PERCENT_COMPLETE_FIELD_NUMBER = 12;
    private double percentComplete_ = 0D;
    /**
     *
     *
     * <pre>
     * Reflects the overall progress of the patch job in the range of
     * 0.0 being no progress to 100.0 being complete.
     * </pre>
     *
     * <code>double percent_complete = 12;</code>
     *
     * @return The percentComplete.
     */
    @java.lang.Override
    public double getPercentComplete() {
      return percentComplete_;
    }

    public static final int PATCH_DEPLOYMENT_FIELD_NUMBER = 15;

    @SuppressWarnings("serial")
    private volatile java.lang.Object patchDeployment_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the patch deployment that created this patch job.
     * </pre>
     *
     * <code>
     * string patch_deployment = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The patchDeployment.
     */
    @java.lang.Override
    public java.lang.String getPatchDeployment() {
      java.lang.Object ref = patchDeployment_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        patchDeployment_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the patch deployment that created this patch job.
     * </pre>
     *
     * <code>
     * string patch_deployment = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for patchDeployment.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPatchDeploymentBytes() {
      java.lang.Object ref = patchDeployment_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        patchDeployment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ROLLOUT_FIELD_NUMBER = 16;
    private com.google.cloud.osconfig.v1.PatchJobs.PatchRollout rollout_;
    /**
     *
     *
     * <pre>
     * Rollout strategy being applied.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
     *
     * @return Whether the rollout field is set.
     */
    @java.lang.Override
    public boolean hasRollout() {
      return rollout_ != null;
    }
    /**
     *
     *
     * <pre>
     * Rollout strategy being applied.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
     *
     * @return The rollout.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchRollout getRollout() {
      return rollout_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()
          : rollout_;
    }
    /**
     *
     *
     * <pre>
     * Rollout strategy being applied.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder getRolloutOrBuilder() {
      return rollout_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()
          : rollout_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
      }
      if (createTime_ != null) {
        output.writeMessage(3, getCreateTime());
      }
      if (updateTime_ != null) {
        output.writeMessage(4, getUpdateTime());
      }
      if (state_
          != com.google.cloud.osconfig.v1.PatchJobs.PatchJob.State.STATE_UNSPECIFIED.getNumber()) {
        output.writeEnum(5, state_);
      }
      if (patchConfig_ != null) {
        output.writeMessage(7, getPatchConfig());
      }
      if (duration_ != null) {
        output.writeMessage(8, getDuration());
      }
      if (instanceDetailsSummary_ != null) {
        output.writeMessage(9, getInstanceDetailsSummary());
      }
      if (dryRun_ != false) {
        output.writeBool(10, dryRun_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 11, errorMessage_);
      }
      if (java.lang.Double.doubleToRawLongBits(percentComplete_) != 0) {
        output.writeDouble(12, percentComplete_);
      }
      if (instanceFilter_ != null) {
        output.writeMessage(13, getInstanceFilter());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 14, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(patchDeployment_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 15, patchDeployment_);
      }
      if (rollout_ != null) {
        output.writeMessage(16, getRollout());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
      }
      if (createTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
      }
      if (updateTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
      }
      if (state_
          != com.google.cloud.osconfig.v1.PatchJobs.PatchJob.State.STATE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
      }
      if (patchConfig_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPatchConfig());
      }
      if (duration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDuration());
      }
      if (instanceDetailsSummary_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                9, getInstanceDetailsSummary());
      }
      if (dryRun_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, dryRun_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, errorMessage_);
      }
      if (java.lang.Double.doubleToRawLongBits(percentComplete_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(12, percentComplete_);
      }
      if (instanceFilter_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getInstanceFilter());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(patchDeployment_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, patchDeployment_);
      }
      if (rollout_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getRollout());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.PatchJob)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.PatchJob other =
          (com.google.cloud.osconfig.v1.PatchJobs.PatchJob) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (hasCreateTime() != other.hasCreateTime()) return false;
      if (hasCreateTime()) {
        if (!getCreateTime().equals(other.getCreateTime())) return false;
      }
      if (hasUpdateTime() != other.hasUpdateTime()) return false;
      if (hasUpdateTime()) {
        if (!getUpdateTime().equals(other.getUpdateTime())) return false;
      }
      if (state_ != other.state_) return false;
      if (hasInstanceFilter() != other.hasInstanceFilter()) return false;
      if (hasInstanceFilter()) {
        if (!getInstanceFilter().equals(other.getInstanceFilter())) return false;
      }
      if (hasPatchConfig() != other.hasPatchConfig()) return false;
      if (hasPatchConfig()) {
        if (!getPatchConfig().equals(other.getPatchConfig())) return false;
      }
      if (hasDuration() != other.hasDuration()) return false;
      if (hasDuration()) {
        if (!getDuration().equals(other.getDuration())) return false;
      }
      if (hasInstanceDetailsSummary() != other.hasInstanceDetailsSummary()) return false;
      if (hasInstanceDetailsSummary()) {
        if (!getInstanceDetailsSummary().equals(other.getInstanceDetailsSummary())) return false;
      }
      if (getDryRun() != other.getDryRun()) return false;
      if (!getErrorMessage().equals(other.getErrorMessage())) return false;
      if (java.lang.Double.doubleToLongBits(getPercentComplete())
          != java.lang.Double.doubleToLongBits(other.getPercentComplete())) return false;
      if (!getPatchDeployment().equals(other.getPatchDeployment())) return false;
      if (hasRollout() != other.hasRollout()) return false;
      if (hasRollout()) {
        if (!getRollout().equals(other.getRollout())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      if (hasCreateTime()) {
        hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getCreateTime().hashCode();
      }
      if (hasUpdateTime()) {
        hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateTime().hashCode();
      }
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      if (hasInstanceFilter()) {
        hash = (37 * hash) + INSTANCE_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getInstanceFilter().hashCode();
      }
      if (hasPatchConfig()) {
        hash = (37 * hash) + PATCH_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getPatchConfig().hashCode();
      }
      if (hasDuration()) {
        hash = (37 * hash) + DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getDuration().hashCode();
      }
      if (hasInstanceDetailsSummary()) {
        hash = (37 * hash) + INSTANCE_DETAILS_SUMMARY_FIELD_NUMBER;
        hash = (53 * hash) + getInstanceDetailsSummary().hashCode();
      }
      hash = (37 * hash) + DRY_RUN_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDryRun());
      hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getErrorMessage().hashCode();
      hash = (37 * hash) + PERCENT_COMPLETE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getPercentComplete()));
      hash = (37 * hash) + PATCH_DEPLOYMENT_FIELD_NUMBER;
      hash = (53 * hash) + getPatchDeployment().hashCode();
      if (hasRollout()) {
        hash = (37 * hash) + ROLLOUT_FIELD_NUMBER;
        hash = (53 * hash) + getRollout().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.osconfig.v1.PatchJobs.PatchJob prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A high level representation of a patch job that is either in progress
     * or has completed.
     *
     * Instance details are not included in the job. To paginate through instance
     * details, use ListPatchJobInstanceDetails.
     *
     * For more information about patch jobs, see
     * [Creating patch
     * jobs](https://cloud.google.com/compute/docs/os-patch-management/create-patch-job).
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.PatchJob}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.PatchJob)
        com.google.cloud.osconfig.v1.PatchJobs.PatchJobOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_PatchJob_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_PatchJob_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.PatchJob.class,
                com.google.cloud.osconfig.v1.PatchJobs.PatchJob.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.PatchJob.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        displayName_ = "";
        description_ = "";
        createTime_ = null;
        if (createTimeBuilder_ != null) {
          createTimeBuilder_.dispose();
          createTimeBuilder_ = null;
        }
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        state_ = 0;
        instanceFilter_ = null;
        if (instanceFilterBuilder_ != null) {
          instanceFilterBuilder_.dispose();
          instanceFilterBuilder_ = null;
        }
        patchConfig_ = null;
        if (patchConfigBuilder_ != null) {
          patchConfigBuilder_.dispose();
          patchConfigBuilder_ = null;
        }
        duration_ = null;
        if (durationBuilder_ != null) {
          durationBuilder_.dispose();
          durationBuilder_ = null;
        }
        instanceDetailsSummary_ = null;
        if (instanceDetailsSummaryBuilder_ != null) {
          instanceDetailsSummaryBuilder_.dispose();
          instanceDetailsSummaryBuilder_ = null;
        }
        dryRun_ = false;
        errorMessage_ = "";
        percentComplete_ = 0D;
        patchDeployment_ = "";
        rollout_ = null;
        if (rolloutBuilder_ != null) {
          rolloutBuilder_.dispose();
          rolloutBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_PatchJob_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJob getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.PatchJob.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJob build() {
        com.google.cloud.osconfig.v1.PatchJobs.PatchJob result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJob buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.PatchJob result =
            new com.google.cloud.osconfig.v1.PatchJobs.PatchJob(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.osconfig.v1.PatchJobs.PatchJob result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.displayName_ = displayName_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.createTime_ =
              createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.updateTime_ =
              updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.instanceFilter_ =
              instanceFilterBuilder_ == null ? instanceFilter_ : instanceFilterBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.patchConfig_ =
              patchConfigBuilder_ == null ? patchConfig_ : patchConfigBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.instanceDetailsSummary_ =
              instanceDetailsSummaryBuilder_ == null
                  ? instanceDetailsSummary_
                  : instanceDetailsSummaryBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.dryRun_ = dryRun_;
        }
        if (((from_bitField0_ & 0x00000800) != 0)) {
          result.errorMessage_ = errorMessage_;
        }
        if (((from_bitField0_ & 0x00001000) != 0)) {
          result.percentComplete_ = percentComplete_;
        }
        if (((from_bitField0_ & 0x00002000) != 0)) {
          result.patchDeployment_ = patchDeployment_;
        }
        if (((from_bitField0_ & 0x00004000) != 0)) {
          result.rollout_ = rolloutBuilder_ == null ? rollout_ : rolloutBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.PatchJob) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.PatchJob) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.PatchJob other) {
        if (other == com.google.cloud.osconfig.v1.PatchJobs.PatchJob.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasCreateTime()) {
          mergeCreateTime(other.getCreateTime());
        }
        if (other.hasUpdateTime()) {
          mergeUpdateTime(other.getUpdateTime());
        }
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (other.hasInstanceFilter()) {
          mergeInstanceFilter(other.getInstanceFilter());
        }
        if (other.hasPatchConfig()) {
          mergePatchConfig(other.getPatchConfig());
        }
        if (other.hasDuration()) {
          mergeDuration(other.getDuration());
        }
        if (other.hasInstanceDetailsSummary()) {
          mergeInstanceDetailsSummary(other.getInstanceDetailsSummary());
        }
        if (other.getDryRun() != false) {
          setDryRun(other.getDryRun());
        }
        if (!other.getErrorMessage().isEmpty()) {
          errorMessage_ = other.errorMessage_;
          bitField0_ |= 0x00000800;
          onChanged();
        }
        if (other.getPercentComplete() != 0D) {
          setPercentComplete(other.getPercentComplete());
        }
        if (!other.getPatchDeployment().isEmpty()) {
          patchDeployment_ = other.patchDeployment_;
          bitField0_ |= 0x00002000;
          onChanged();
        }
        if (other.hasRollout()) {
          mergeRollout(other.getRollout());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 34
              case 40:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 40
              case 58:
                {
                  input.readMessage(getPatchConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000100;
                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(
                      getInstanceDetailsSummaryFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000200;
                  break;
                } // case 74
              case 80:
                {
                  dryRun_ = input.readBool();
                  bitField0_ |= 0x00000400;
                  break;
                } // case 80
              case 90:
                {
                  errorMessage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000800;
                  break;
                } // case 90
              case 97:
                {
                  percentComplete_ = input.readDouble();
                  bitField0_ |= 0x00001000;
                  break;
                } // case 97
              case 106:
                {
                  input.readMessage(
                      getInstanceFilterFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 106
              case 114:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 114
              case 122:
                {
                  patchDeployment_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00002000;
                  break;
                } // case 122
              case 130:
                {
                  input.readMessage(getRolloutFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00004000;
                  break;
                } // case 130
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Unique identifier for this patch job in the form
       * `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Unique identifier for this patch job in the form
       * `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Unique identifier for this patch job in the form
       * `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Unique identifier for this patch job in the form
       * `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Unique identifier for this patch job in the form
       * `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * Display name for this patch job. This is not a unique identifier.
       * </pre>
       *
       * <code>string display_name = 14;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Display name for this patch job. This is not a unique identifier.
       * </pre>
       *
       * <code>string display_name = 14;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Display name for this patch job. This is not a unique identifier.
       * </pre>
       *
       * <code>string display_name = 14;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display name for this patch job. This is not a unique identifier.
       * </pre>
       *
       * <code>string display_name = 14;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display name for this patch job. This is not a unique identifier.
       * </pre>
       *
       * <code>string display_name = 14;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * Description of the patch job. Length of the description is limited
       * to 1024 characters.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description of the patch job. Length of the description is limited
       * to 1024 characters.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description of the patch job. Length of the description is limited
       * to 1024 characters.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description of the patch job. Length of the description is limited
       * to 1024 characters.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description of the patch job. Length of the description is limited
       * to 1024 characters.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp createTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          createTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Time this patch job was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 3;</code>
       *
       * @return Whether the createTime field is set.
       */
      public boolean hasCreateTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Time this patch job was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 3;</code>
       *
       * @return The createTime.
       */
      public com.google.protobuf.Timestamp getCreateTime() {
        if (createTimeBuilder_ == null) {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        } else {
          return createTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Time this patch job was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 3;</code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          createTime_ = value;
        } else {
          createTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time this patch job was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 3;</code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (createTimeBuilder_ == null) {
          createTime_ = builderForValue.build();
        } else {
          createTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time this patch job was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 3;</code>
       */
      public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && createTime_ != null
              && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getCreateTimeBuilder().mergeFrom(value);
          } else {
            createTime_ = value;
          }
        } else {
          createTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time this patch job was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 3;</code>
       */
      public Builder clearCreateTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        createTime_ = null;
        if (createTimeBuilder_ != null) {
          createTimeBuilder_.dispose();
          createTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time this patch job was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 3;</code>
       */
      public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getCreateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Time this patch job was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 3;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
        if (createTimeBuilder_ != null) {
          return createTimeBuilder_.getMessageOrBuilder();
        } else {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Time this patch job was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getCreateTimeFieldBuilder() {
        if (createTimeBuilder_ == null) {
          createTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getCreateTime(), getParentForChildren(), isClean());
          createTime_ = null;
        }
        return createTimeBuilder_;
      }

      private com.google.protobuf.Timestamp updateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          updateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Last time this patch job was updated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 4;</code>
       *
       * @return Whether the updateTime field is set.
       */
      public boolean hasUpdateTime() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Last time this patch job was updated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 4;</code>
       *
       * @return The updateTime.
       */
      public com.google.protobuf.Timestamp getUpdateTime() {
        if (updateTimeBuilder_ == null) {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        } else {
          return updateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Last time this patch job was updated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 4;</code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateTime_ = value;
        } else {
          updateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time this patch job was updated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 4;</code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (updateTimeBuilder_ == null) {
          updateTime_ = builderForValue.build();
        } else {
          updateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time this patch job was updated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 4;</code>
       */
      public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && updateTime_ != null
              && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getUpdateTimeBuilder().mergeFrom(value);
          } else {
            updateTime_ = value;
          }
        } else {
          updateTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time this patch job was updated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 4;</code>
       */
      public Builder clearUpdateTime() {
        bitField0_ = (bitField0_ & ~0x00000010);
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time this patch job was updated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 4;</code>
       */
      public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Last time this patch job was updated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 4;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
        if (updateTimeBuilder_ != null) {
          return updateTimeBuilder_.getMessageOrBuilder();
        } else {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Last time this patch job was updated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getUpdateTimeFieldBuilder() {
        if (updateTimeBuilder_ == null) {
          updateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getUpdateTime(), getParentForChildren(), isClean());
          updateTime_ = null;
        }
        return updateTimeBuilder_;
      }

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * The current state of the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchJob.State state = 5;</code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * The current state of the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchJob.State state = 5;</code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current state of the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchJob.State state = 5;</code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.State getState() {
        com.google.cloud.osconfig.v1.PatchJobs.PatchJob.State result =
            com.google.cloud.osconfig.v1.PatchJobs.PatchJob.State.forNumber(state_);
        return result == null
            ? com.google.cloud.osconfig.v1.PatchJobs.PatchJob.State.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The current state of the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchJob.State state = 5;</code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(com.google.cloud.osconfig.v1.PatchJobs.PatchJob.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000020;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current state of the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchJob.State state = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000020);
        state_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter instanceFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter,
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder>
          instanceFilterBuilder_;
      /**
       *
       *
       * <pre>
       * Instances to patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
       *
       * @return Whether the instanceFilter field is set.
       */
      public boolean hasInstanceFilter() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * Instances to patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
       *
       * @return The instanceFilter.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter getInstanceFilter() {
        if (instanceFilterBuilder_ == null) {
          return instanceFilter_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.getDefaultInstance()
              : instanceFilter_;
        } else {
          return instanceFilterBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Instances to patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
       */
      public Builder setInstanceFilter(
          com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter value) {
        if (instanceFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          instanceFilter_ = value;
        } else {
          instanceFilterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Instances to patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
       */
      public Builder setInstanceFilter(
          com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder builderForValue) {
        if (instanceFilterBuilder_ == null) {
          instanceFilter_ = builderForValue.build();
        } else {
          instanceFilterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Instances to patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
       */
      public Builder mergeInstanceFilter(
          com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter value) {
        if (instanceFilterBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && instanceFilter_ != null
              && instanceFilter_
                  != com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter
                      .getDefaultInstance()) {
            getInstanceFilterBuilder().mergeFrom(value);
          } else {
            instanceFilter_ = value;
          }
        } else {
          instanceFilterBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Instances to patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
       */
      public Builder clearInstanceFilter() {
        bitField0_ = (bitField0_ & ~0x00000040);
        instanceFilter_ = null;
        if (instanceFilterBuilder_ != null) {
          instanceFilterBuilder_.dispose();
          instanceFilterBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Instances to patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder
          getInstanceFilterBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getInstanceFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Instances to patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder
          getInstanceFilterOrBuilder() {
        if (instanceFilterBuilder_ != null) {
          return instanceFilterBuilder_.getMessageOrBuilder();
        } else {
          return instanceFilter_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.getDefaultInstance()
              : instanceFilter_;
        }
      }
      /**
       *
       *
       * <pre>
       * Instances to patch.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchInstanceFilter instance_filter = 13;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter,
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder>
          getInstanceFilterFieldBuilder() {
        if (instanceFilterBuilder_ == null) {
          instanceFilterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilter.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchInstanceFilterOrBuilder>(
                  getInstanceFilter(), getParentForChildren(), isClean());
          instanceFilter_ = null;
        }
        return instanceFilterBuilder_;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.PatchConfig patchConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig,
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder>
          patchConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Patch configuration being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
       *
       * @return Whether the patchConfig field is set.
       */
      public boolean hasPatchConfig() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
       *
       * @return The patchConfig.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig getPatchConfig() {
        if (patchConfigBuilder_ == null) {
          return patchConfig_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()
              : patchConfig_;
        } else {
          return patchConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
       */
      public Builder setPatchConfig(com.google.cloud.osconfig.v1.PatchJobs.PatchConfig value) {
        if (patchConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          patchConfig_ = value;
        } else {
          patchConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
       */
      public Builder setPatchConfig(
          com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder builderForValue) {
        if (patchConfigBuilder_ == null) {
          patchConfig_ = builderForValue.build();
        } else {
          patchConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
       */
      public Builder mergePatchConfig(com.google.cloud.osconfig.v1.PatchJobs.PatchConfig value) {
        if (patchConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && patchConfig_ != null
              && patchConfig_
                  != com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()) {
            getPatchConfigBuilder().mergeFrom(value);
          } else {
            patchConfig_ = value;
          }
        } else {
          patchConfigBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
       */
      public Builder clearPatchConfig() {
        bitField0_ = (bitField0_ & ~0x00000080);
        patchConfig_ = null;
        if (patchConfigBuilder_ != null) {
          patchConfigBuilder_.dispose();
          patchConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder getPatchConfigBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getPatchConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder getPatchConfigOrBuilder() {
        if (patchConfigBuilder_ != null) {
          return patchConfigBuilder_.getMessageOrBuilder();
        } else {
          return patchConfig_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance()
              : patchConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Patch configuration being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig patch_config = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig,
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder>
          getPatchConfigFieldBuilder() {
        if (patchConfigBuilder_ == null) {
          patchConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.PatchConfig,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder>(
                  getPatchConfig(), getParentForChildren(), isClean());
          patchConfig_ = null;
        }
        return patchConfigBuilder_;
      }

      private com.google.protobuf.Duration duration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          durationBuilder_;
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the
       * patch job times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 8;</code>
       *
       * @return Whether the duration field is set.
       */
      public boolean hasDuration() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the
       * patch job times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 8;</code>
       *
       * @return The duration.
       */
      public com.google.protobuf.Duration getDuration() {
        if (durationBuilder_ == null) {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        } else {
          return durationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the
       * patch job times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 8;</code>
       */
      public Builder setDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          duration_ = value;
        } else {
          durationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the
       * patch job times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 8;</code>
       */
      public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (durationBuilder_ == null) {
          duration_ = builderForValue.build();
        } else {
          durationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the
       * patch job times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 8;</code>
       */
      public Builder mergeDuration(com.google.protobuf.Duration value) {
        if (durationBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)
              && duration_ != null
              && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getDurationBuilder().mergeFrom(value);
          } else {
            duration_ = value;
          }
        } else {
          durationBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the
       * patch job times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 8;</code>
       */
      public Builder clearDuration() {
        bitField0_ = (bitField0_ & ~0x00000100);
        duration_ = null;
        if (durationBuilder_ != null) {
          durationBuilder_.dispose();
          durationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the
       * patch job times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 8;</code>
       */
      public com.google.protobuf.Duration.Builder getDurationBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the
       * patch job times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 8;</code>
       */
      public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
        if (durationBuilder_ != null) {
          return durationBuilder_.getMessageOrBuilder();
        } else {
          return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of the patch job. After the duration ends, the
       * patch job times out.
       * </pre>
       *
       * <code>.google.protobuf.Duration duration = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getDurationFieldBuilder() {
        if (durationBuilder_ == null) {
          durationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getDuration(), getParentForChildren(), isClean());
          duration_ = null;
        }
        return durationBuilder_;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          instanceDetailsSummary_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummaryOrBuilder>
          instanceDetailsSummaryBuilder_;
      /**
       *
       *
       * <pre>
       * Summary of instance details.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
       * </code>
       *
       * @return Whether the instanceDetailsSummary field is set.
       */
      public boolean hasInstanceDetailsSummary() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       *
       *
       * <pre>
       * Summary of instance details.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
       * </code>
       *
       * @return The instanceDetailsSummary.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
          getInstanceDetailsSummary() {
        if (instanceDetailsSummaryBuilder_ == null) {
          return instanceDetailsSummary_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
                  .getDefaultInstance()
              : instanceDetailsSummary_;
        } else {
          return instanceDetailsSummaryBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Summary of instance details.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
       * </code>
       */
      public Builder setInstanceDetailsSummary(
          com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary value) {
        if (instanceDetailsSummaryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          instanceDetailsSummary_ = value;
        } else {
          instanceDetailsSummaryBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary of instance details.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
       * </code>
       */
      public Builder setInstanceDetailsSummary(
          com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary.Builder
              builderForValue) {
        if (instanceDetailsSummaryBuilder_ == null) {
          instanceDetailsSummary_ = builderForValue.build();
        } else {
          instanceDetailsSummaryBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary of instance details.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
       * </code>
       */
      public Builder mergeInstanceDetailsSummary(
          com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary value) {
        if (instanceDetailsSummaryBuilder_ == null) {
          if (((bitField0_ & 0x00000200) != 0)
              && instanceDetailsSummary_ != null
              && instanceDetailsSummary_
                  != com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
                      .getDefaultInstance()) {
            getInstanceDetailsSummaryBuilder().mergeFrom(value);
          } else {
            instanceDetailsSummary_ = value;
          }
        } else {
          instanceDetailsSummaryBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary of instance details.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
       * </code>
       */
      public Builder clearInstanceDetailsSummary() {
        bitField0_ = (bitField0_ & ~0x00000200);
        instanceDetailsSummary_ = null;
        if (instanceDetailsSummaryBuilder_ != null) {
          instanceDetailsSummaryBuilder_.dispose();
          instanceDetailsSummaryBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary of instance details.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary.Builder
          getInstanceDetailsSummaryBuilder() {
        bitField0_ |= 0x00000200;
        onChanged();
        return getInstanceDetailsSummaryFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Summary of instance details.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
       * </code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummaryOrBuilder
          getInstanceDetailsSummaryOrBuilder() {
        if (instanceDetailsSummaryBuilder_ != null) {
          return instanceDetailsSummaryBuilder_.getMessageOrBuilder();
        } else {
          return instanceDetailsSummary_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary
                  .getDefaultInstance()
              : instanceDetailsSummary_;
        }
      }
      /**
       *
       *
       * <pre>
       * Summary of instance details.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1.PatchJob.InstanceDetailsSummary instance_details_summary = 9;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummaryOrBuilder>
          getInstanceDetailsSummaryFieldBuilder() {
        if (instanceDetailsSummaryBuilder_ == null) {
          instanceDetailsSummaryBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummary.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchJob.InstanceDetailsSummaryOrBuilder>(
                  getInstanceDetailsSummary(), getParentForChildren(), isClean());
          instanceDetailsSummary_ = null;
        }
        return instanceDetailsSummaryBuilder_;
      }

      private boolean dryRun_;
      /**
       *
       *
       * <pre>
       * If this patch job is a dry run, the agent reports that it has
       * finished without running any updates on the VM instance.
       * </pre>
       *
       * <code>bool dry_run = 10;</code>
       *
       * @return The dryRun.
       */
      @java.lang.Override
      public boolean getDryRun() {
        return dryRun_;
      }
      /**
       *
       *
       * <pre>
       * If this patch job is a dry run, the agent reports that it has
       * finished without running any updates on the VM instance.
       * </pre>
       *
       * <code>bool dry_run = 10;</code>
       *
       * @param value The dryRun to set.
       * @return This builder for chaining.
       */
      public Builder setDryRun(boolean value) {

        dryRun_ = value;
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If this patch job is a dry run, the agent reports that it has
       * finished without running any updates on the VM instance.
       * </pre>
       *
       * <code>bool dry_run = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDryRun() {
        bitField0_ = (bitField0_ & ~0x00000400);
        dryRun_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object errorMessage_ = "";
      /**
       *
       *
       * <pre>
       * If this patch job failed, this message provides information about the
       * failure.
       * </pre>
       *
       * <code>string error_message = 11;</code>
       *
       * @return The errorMessage.
       */
      public java.lang.String getErrorMessage() {
        java.lang.Object ref = errorMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          errorMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If this patch job failed, this message provides information about the
       * failure.
       * </pre>
       *
       * <code>string error_message = 11;</code>
       *
       * @return The bytes for errorMessage.
       */
      public com.google.protobuf.ByteString getErrorMessageBytes() {
        java.lang.Object ref = errorMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          errorMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If this patch job failed, this message provides information about the
       * failure.
       * </pre>
       *
       * <code>string error_message = 11;</code>
       *
       * @param value The errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorMessage_ = value;
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If this patch job failed, this message provides information about the
       * failure.
       * </pre>
       *
       * <code>string error_message = 11;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearErrorMessage() {
        errorMessage_ = getDefaultInstance().getErrorMessage();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If this patch job failed, this message provides information about the
       * failure.
       * </pre>
       *
       * <code>string error_message = 11;</code>
       *
       * @param value The bytes for errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        errorMessage_ = value;
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }

      private double percentComplete_;
      /**
       *
       *
       * <pre>
       * Reflects the overall progress of the patch job in the range of
       * 0.0 being no progress to 100.0 being complete.
       * </pre>
       *
       * <code>double percent_complete = 12;</code>
       *
       * @return The percentComplete.
       */
      @java.lang.Override
      public double getPercentComplete() {
        return percentComplete_;
      }
      /**
       *
       *
       * <pre>
       * Reflects the overall progress of the patch job in the range of
       * 0.0 being no progress to 100.0 being complete.
       * </pre>
       *
       * <code>double percent_complete = 12;</code>
       *
       * @param value The percentComplete to set.
       * @return This builder for chaining.
       */
      public Builder setPercentComplete(double value) {

        percentComplete_ = value;
        bitField0_ |= 0x00001000;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reflects the overall progress of the patch job in the range of
       * 0.0 being no progress to 100.0 being complete.
       * </pre>
       *
       * <code>double percent_complete = 12;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPercentComplete() {
        bitField0_ = (bitField0_ & ~0x00001000);
        percentComplete_ = 0D;
        onChanged();
        return this;
      }

      private java.lang.Object patchDeployment_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Name of the patch deployment that created this patch job.
       * </pre>
       *
       * <code>
       * string patch_deployment = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The patchDeployment.
       */
      public java.lang.String getPatchDeployment() {
        java.lang.Object ref = patchDeployment_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          patchDeployment_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Name of the patch deployment that created this patch job.
       * </pre>
       *
       * <code>
       * string patch_deployment = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for patchDeployment.
       */
      public com.google.protobuf.ByteString getPatchDeploymentBytes() {
        java.lang.Object ref = patchDeployment_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          patchDeployment_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Name of the patch deployment that created this patch job.
       * </pre>
       *
       * <code>
       * string patch_deployment = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The patchDeployment to set.
       * @return This builder for chaining.
       */
      public Builder setPatchDeployment(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        patchDeployment_ = value;
        bitField0_ |= 0x00002000;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Name of the patch deployment that created this patch job.
       * </pre>
       *
       * <code>
       * string patch_deployment = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPatchDeployment() {
        patchDeployment_ = getDefaultInstance().getPatchDeployment();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Name of the patch deployment that created this patch job.
       * </pre>
       *
       * <code>
       * string patch_deployment = 15 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for patchDeployment to set.
       * @return This builder for chaining.
       */
      public Builder setPatchDeploymentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        patchDeployment_ = value;
        bitField0_ |= 0x00002000;
        onChanged();
        return this;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.PatchRollout rollout_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchRollout,
              com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder>
          rolloutBuilder_;
      /**
       *
       *
       * <pre>
       * Rollout strategy being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
       *
       * @return Whether the rollout field is set.
       */
      public boolean hasRollout() {
        return ((bitField0_ & 0x00004000) != 0);
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
       *
       * @return The rollout.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchRollout getRollout() {
        if (rolloutBuilder_ == null) {
          return rollout_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()
              : rollout_;
        } else {
          return rolloutBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
       */
      public Builder setRollout(com.google.cloud.osconfig.v1.PatchJobs.PatchRollout value) {
        if (rolloutBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rollout_ = value;
        } else {
          rolloutBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00004000;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
       */
      public Builder setRollout(
          com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder builderForValue) {
        if (rolloutBuilder_ == null) {
          rollout_ = builderForValue.build();
        } else {
          rolloutBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00004000;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
       */
      public Builder mergeRollout(com.google.cloud.osconfig.v1.PatchJobs.PatchRollout value) {
        if (rolloutBuilder_ == null) {
          if (((bitField0_ & 0x00004000) != 0)
              && rollout_ != null
              && rollout_
                  != com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()) {
            getRolloutBuilder().mergeFrom(value);
          } else {
            rollout_ = value;
          }
        } else {
          rolloutBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00004000;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
       */
      public Builder clearRollout() {
        bitField0_ = (bitField0_ & ~0x00004000);
        rollout_ = null;
        if (rolloutBuilder_ != null) {
          rolloutBuilder_.dispose();
          rolloutBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder getRolloutBuilder() {
        bitField0_ |= 0x00004000;
        onChanged();
        return getRolloutFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder getRolloutOrBuilder() {
        if (rolloutBuilder_ != null) {
          return rolloutBuilder_.getMessageOrBuilder();
        } else {
          return rollout_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.getDefaultInstance()
              : rollout_;
        }
      }
      /**
       *
       *
       * <pre>
       * Rollout strategy being applied.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchRollout rollout = 16;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.PatchRollout,
              com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder>
          getRolloutFieldBuilder() {
        if (rolloutBuilder_ == null) {
          rolloutBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.PatchRollout,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchRollout.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.PatchRolloutOrBuilder>(
                  getRollout(), getParentForChildren(), isClean());
          rollout_ = null;
        }
        return rolloutBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.PatchJob)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.PatchJob)
    private static final com.google.cloud.osconfig.v1.PatchJobs.PatchJob DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.PatchJob();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchJob getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PatchJob> PARSER =
        new com.google.protobuf.AbstractParser<PatchJob>() {
          @java.lang.Override
          public PatchJob parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PatchJob> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PatchJob> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchJob getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PatchConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.PatchConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Post-patch reboot settings.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig.RebootConfig reboot_config = 1;</code>
     *
     * @return The enum numeric value on the wire for rebootConfig.
     */
    int getRebootConfigValue();
    /**
     *
     *
     * <pre>
     * Post-patch reboot settings.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig.RebootConfig reboot_config = 1;</code>
     *
     * @return The rebootConfig.
     */
    com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.RebootConfig getRebootConfig();

    /**
     *
     *
     * <pre>
     * Apt update settings. Use this setting to override the default `apt` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
     *
     * @return Whether the apt field is set.
     */
    boolean hasApt();
    /**
     *
     *
     * <pre>
     * Apt update settings. Use this setting to override the default `apt` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
     *
     * @return The apt.
     */
    com.google.cloud.osconfig.v1.PatchJobs.AptSettings getApt();
    /**
     *
     *
     * <pre>
     * Apt update settings. Use this setting to override the default `apt` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.AptSettingsOrBuilder getAptOrBuilder();

    /**
     *
     *
     * <pre>
     * Yum update settings. Use this setting to override the default `yum` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
     *
     * @return Whether the yum field is set.
     */
    boolean hasYum();
    /**
     *
     *
     * <pre>
     * Yum update settings. Use this setting to override the default `yum` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
     *
     * @return The yum.
     */
    com.google.cloud.osconfig.v1.PatchJobs.YumSettings getYum();
    /**
     *
     *
     * <pre>
     * Yum update settings. Use this setting to override the default `yum` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.YumSettingsOrBuilder getYumOrBuilder();

    /**
     *
     *
     * <pre>
     * Goo update settings. Use this setting to override the default `goo` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
     *
     * @return Whether the goo field is set.
     */
    boolean hasGoo();
    /**
     *
     *
     * <pre>
     * Goo update settings. Use this setting to override the default `goo` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
     *
     * @return The goo.
     */
    com.google.cloud.osconfig.v1.PatchJobs.GooSettings getGoo();
    /**
     *
     *
     * <pre>
     * Goo update settings. Use this setting to override the default `goo` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.GooSettingsOrBuilder getGooOrBuilder();

    /**
     *
     *
     * <pre>
     * Zypper update settings. Use this setting to override the default `zypper`
     * patch rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
     *
     * @return Whether the zypper field is set.
     */
    boolean hasZypper();
    /**
     *
     *
     * <pre>
     * Zypper update settings. Use this setting to override the default `zypper`
     * patch rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
     *
     * @return The zypper.
     */
    com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings getZypper();
    /**
     *
     *
     * <pre>
     * Zypper update settings. Use this setting to override the default `zypper`
     * patch rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.ZypperSettingsOrBuilder getZypperOrBuilder();

    /**
     *
     *
     * <pre>
     * Windows update settings. Use this override the default windows patch rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
     *
     * @return Whether the windowsUpdate field is set.
     */
    boolean hasWindowsUpdate();
    /**
     *
     *
     * <pre>
     * Windows update settings. Use this override the default windows patch rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
     *
     * @return The windowsUpdate.
     */
    com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings getWindowsUpdate();
    /**
     *
     *
     * <pre>
     * Windows update settings. Use this override the default windows patch rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettingsOrBuilder
        getWindowsUpdateOrBuilder();

    /**
     *
     *
     * <pre>
     * The `ExecStep` to run before the patch update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
     *
     * @return Whether the preStep field is set.
     */
    boolean hasPreStep();
    /**
     *
     *
     * <pre>
     * The `ExecStep` to run before the patch update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
     *
     * @return The preStep.
     */
    com.google.cloud.osconfig.v1.PatchJobs.ExecStep getPreStep();
    /**
     *
     *
     * <pre>
     * The `ExecStep` to run before the patch update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.ExecStepOrBuilder getPreStepOrBuilder();

    /**
     *
     *
     * <pre>
     * The `ExecStep` to run after the patch update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
     *
     * @return Whether the postStep field is set.
     */
    boolean hasPostStep();
    /**
     *
     *
     * <pre>
     * The `ExecStep` to run after the patch update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
     *
     * @return The postStep.
     */
    com.google.cloud.osconfig.v1.PatchJobs.ExecStep getPostStep();
    /**
     *
     *
     * <pre>
     * The `ExecStep` to run after the patch update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.ExecStepOrBuilder getPostStepOrBuilder();

    /**
     *
     *
     * <pre>
     * Allows the patch job to run on Managed instance groups (MIGs).
     * </pre>
     *
     * <code>bool mig_instances_allowed = 10;</code>
     *
     * @return The migInstancesAllowed.
     */
    boolean getMigInstancesAllowed();
  }
  /**
   *
   *
   * <pre>
   * Patch configuration specifications. Contains details on how to apply the
   * patch(es) to a VM instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.PatchConfig}
   */
  public static final class PatchConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.PatchConfig)
      PatchConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PatchConfig.newBuilder() to construct.
    private PatchConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PatchConfig() {
      rebootConfig_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PatchConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_PatchConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_PatchConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.class,
              com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Post-patch reboot settings.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.osconfig.v1.PatchConfig.RebootConfig}
     */
    public enum RebootConfig implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The default behavior is DEFAULT.
       * </pre>
       *
       * <code>REBOOT_CONFIG_UNSPECIFIED = 0;</code>
       */
      REBOOT_CONFIG_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The agent decides if a reboot is necessary by checking signals such as
       * registry keys on Windows or `/var/run/reboot-required` on APT based
       * systems. On RPM based systems, a set of core system package install times
       * are compared with system boot time.
       * </pre>
       *
       * <code>DEFAULT = 1;</code>
       */
      DEFAULT(1),
      /**
       *
       *
       * <pre>
       * Always reboot the machine after the update completes.
       * </pre>
       *
       * <code>ALWAYS = 2;</code>
       */
      ALWAYS(2),
      /**
       *
       *
       * <pre>
       * Never reboot the machine after the update completes.
       * </pre>
       *
       * <code>NEVER = 3;</code>
       */
      NEVER(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * The default behavior is DEFAULT.
       * </pre>
       *
       * <code>REBOOT_CONFIG_UNSPECIFIED = 0;</code>
       */
      public static final int REBOOT_CONFIG_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The agent decides if a reboot is necessary by checking signals such as
       * registry keys on Windows or `/var/run/reboot-required` on APT based
       * systems. On RPM based systems, a set of core system package install times
       * are compared with system boot time.
       * </pre>
       *
       * <code>DEFAULT = 1;</code>
       */
      public static final int DEFAULT_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Always reboot the machine after the update completes.
       * </pre>
       *
       * <code>ALWAYS = 2;</code>
       */
      public static final int ALWAYS_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Never reboot the machine after the update completes.
       * </pre>
       *
       * <code>NEVER = 3;</code>
       */
      public static final int NEVER_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RebootConfig valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static RebootConfig forNumber(int value) {
        switch (value) {
          case 0:
            return REBOOT_CONFIG_UNSPECIFIED;
          case 1:
            return DEFAULT;
          case 2:
            return ALWAYS;
          case 3:
            return NEVER;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<RebootConfig> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<RebootConfig> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RebootConfig>() {
            public RebootConfig findValueByNumber(int number) {
              return RebootConfig.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final RebootConfig[] VALUES = values();

      public static RebootConfig valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private RebootConfig(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.PatchConfig.RebootConfig)
    }

    public static final int REBOOT_CONFIG_FIELD_NUMBER = 1;
    private int rebootConfig_ = 0;
    /**
     *
     *
     * <pre>
     * Post-patch reboot settings.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig.RebootConfig reboot_config = 1;</code>
     *
     * @return The enum numeric value on the wire for rebootConfig.
     */
    @java.lang.Override
    public int getRebootConfigValue() {
      return rebootConfig_;
    }
    /**
     *
     *
     * <pre>
     * Post-patch reboot settings.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.PatchConfig.RebootConfig reboot_config = 1;</code>
     *
     * @return The rebootConfig.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.RebootConfig getRebootConfig() {
      com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.RebootConfig result =
          com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.RebootConfig.forNumber(rebootConfig_);
      return result == null
          ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.RebootConfig.UNRECOGNIZED
          : result;
    }

    public static final int APT_FIELD_NUMBER = 3;
    private com.google.cloud.osconfig.v1.PatchJobs.AptSettings apt_;
    /**
     *
     *
     * <pre>
     * Apt update settings. Use this setting to override the default `apt` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
     *
     * @return Whether the apt field is set.
     */
    @java.lang.Override
    public boolean hasApt() {
      return apt_ != null;
    }
    /**
     *
     *
     * <pre>
     * Apt update settings. Use this setting to override the default `apt` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
     *
     * @return The apt.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.AptSettings getApt() {
      return apt_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.AptSettings.getDefaultInstance()
          : apt_;
    }
    /**
     *
     *
     * <pre>
     * Apt update settings. Use this setting to override the default `apt` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.AptSettingsOrBuilder getAptOrBuilder() {
      return apt_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.AptSettings.getDefaultInstance()
          : apt_;
    }

    public static final int YUM_FIELD_NUMBER = 4;
    private com.google.cloud.osconfig.v1.PatchJobs.YumSettings yum_;
    /**
     *
     *
     * <pre>
     * Yum update settings. Use this setting to override the default `yum` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
     *
     * @return Whether the yum field is set.
     */
    @java.lang.Override
    public boolean hasYum() {
      return yum_ != null;
    }
    /**
     *
     *
     * <pre>
     * Yum update settings. Use this setting to override the default `yum` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
     *
     * @return The yum.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.YumSettings getYum() {
      return yum_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.YumSettings.getDefaultInstance()
          : yum_;
    }
    /**
     *
     *
     * <pre>
     * Yum update settings. Use this setting to override the default `yum` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.YumSettingsOrBuilder getYumOrBuilder() {
      return yum_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.YumSettings.getDefaultInstance()
          : yum_;
    }

    public static final int GOO_FIELD_NUMBER = 5;
    private com.google.cloud.osconfig.v1.PatchJobs.GooSettings goo_;
    /**
     *
     *
     * <pre>
     * Goo update settings. Use this setting to override the default `goo` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
     *
     * @return Whether the goo field is set.
     */
    @java.lang.Override
    public boolean hasGoo() {
      return goo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Goo update settings. Use this setting to override the default `goo` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
     *
     * @return The goo.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.GooSettings getGoo() {
      return goo_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.GooSettings.getDefaultInstance()
          : goo_;
    }
    /**
     *
     *
     * <pre>
     * Goo update settings. Use this setting to override the default `goo` patch
     * rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.GooSettingsOrBuilder getGooOrBuilder() {
      return goo_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.GooSettings.getDefaultInstance()
          : goo_;
    }

    public static final int ZYPPER_FIELD_NUMBER = 6;
    private com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings zypper_;
    /**
     *
     *
     * <pre>
     * Zypper update settings. Use this setting to override the default `zypper`
     * patch rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
     *
     * @return Whether the zypper field is set.
     */
    @java.lang.Override
    public boolean hasZypper() {
      return zypper_ != null;
    }
    /**
     *
     *
     * <pre>
     * Zypper update settings. Use this setting to override the default `zypper`
     * patch rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
     *
     * @return The zypper.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings getZypper() {
      return zypper_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.getDefaultInstance()
          : zypper_;
    }
    /**
     *
     *
     * <pre>
     * Zypper update settings. Use this setting to override the default `zypper`
     * patch rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ZypperSettingsOrBuilder getZypperOrBuilder() {
      return zypper_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.getDefaultInstance()
          : zypper_;
    }

    public static final int WINDOWS_UPDATE_FIELD_NUMBER = 7;
    private com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings windowsUpdate_;
    /**
     *
     *
     * <pre>
     * Windows update settings. Use this override the default windows patch rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
     *
     * @return Whether the windowsUpdate field is set.
     */
    @java.lang.Override
    public boolean hasWindowsUpdate() {
      return windowsUpdate_ != null;
    }
    /**
     *
     *
     * <pre>
     * Windows update settings. Use this override the default windows patch rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
     *
     * @return The windowsUpdate.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings getWindowsUpdate() {
      return windowsUpdate_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.getDefaultInstance()
          : windowsUpdate_;
    }
    /**
     *
     *
     * <pre>
     * Windows update settings. Use this override the default windows patch rules.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettingsOrBuilder
        getWindowsUpdateOrBuilder() {
      return windowsUpdate_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.getDefaultInstance()
          : windowsUpdate_;
    }

    public static final int PRE_STEP_FIELD_NUMBER = 8;
    private com.google.cloud.osconfig.v1.PatchJobs.ExecStep preStep_;
    /**
     *
     *
     * <pre>
     * The `ExecStep` to run before the patch update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
     *
     * @return Whether the preStep field is set.
     */
    @java.lang.Override
    public boolean hasPreStep() {
      return preStep_ != null;
    }
    /**
     *
     *
     * <pre>
     * The `ExecStep` to run before the patch update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
     *
     * @return The preStep.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ExecStep getPreStep() {
      return preStep_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.ExecStep.getDefaultInstance()
          : preStep_;
    }
    /**
     *
     *
     * <pre>
     * The `ExecStep` to run before the patch update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ExecStepOrBuilder getPreStepOrBuilder() {
      return preStep_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.ExecStep.getDefaultInstance()
          : preStep_;
    }

    public static final int POST_STEP_FIELD_NUMBER = 9;
    private com.google.cloud.osconfig.v1.PatchJobs.ExecStep postStep_;
    /**
     *
     *
     * <pre>
     * The `ExecStep` to run after the patch update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
     *
     * @return Whether the postStep field is set.
     */
    @java.lang.Override
    public boolean hasPostStep() {
      return postStep_ != null;
    }
    /**
     *
     *
     * <pre>
     * The `ExecStep` to run after the patch update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
     *
     * @return The postStep.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ExecStep getPostStep() {
      return postStep_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.ExecStep.getDefaultInstance()
          : postStep_;
    }
    /**
     *
     *
     * <pre>
     * The `ExecStep` to run after the patch update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ExecStepOrBuilder getPostStepOrBuilder() {
      return postStep_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.ExecStep.getDefaultInstance()
          : postStep_;
    }

    public static final int MIG_INSTANCES_ALLOWED_FIELD_NUMBER = 10;
    private boolean migInstancesAllowed_ = false;
    /**
     *
     *
     * <pre>
     * Allows the patch job to run on Managed instance groups (MIGs).
     * </pre>
     *
     * <code>bool mig_instances_allowed = 10;</code>
     *
     * @return The migInstancesAllowed.
     */
    @java.lang.Override
    public boolean getMigInstancesAllowed() {
      return migInstancesAllowed_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (rebootConfig_
          != com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.RebootConfig
              .REBOOT_CONFIG_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, rebootConfig_);
      }
      if (apt_ != null) {
        output.writeMessage(3, getApt());
      }
      if (yum_ != null) {
        output.writeMessage(4, getYum());
      }
      if (goo_ != null) {
        output.writeMessage(5, getGoo());
      }
      if (zypper_ != null) {
        output.writeMessage(6, getZypper());
      }
      if (windowsUpdate_ != null) {
        output.writeMessage(7, getWindowsUpdate());
      }
      if (preStep_ != null) {
        output.writeMessage(8, getPreStep());
      }
      if (postStep_ != null) {
        output.writeMessage(9, getPostStep());
      }
      if (migInstancesAllowed_ != false) {
        output.writeBool(10, migInstancesAllowed_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (rebootConfig_
          != com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.RebootConfig
              .REBOOT_CONFIG_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, rebootConfig_);
      }
      if (apt_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getApt());
      }
      if (yum_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getYum());
      }
      if (goo_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getGoo());
      }
      if (zypper_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getZypper());
      }
      if (windowsUpdate_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getWindowsUpdate());
      }
      if (preStep_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getPreStep());
      }
      if (postStep_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getPostStep());
      }
      if (migInstancesAllowed_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, migInstancesAllowed_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.PatchConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.PatchConfig other =
          (com.google.cloud.osconfig.v1.PatchJobs.PatchConfig) obj;

      if (rebootConfig_ != other.rebootConfig_) return false;
      if (hasApt() != other.hasApt()) return false;
      if (hasApt()) {
        if (!getApt().equals(other.getApt())) return false;
      }
      if (hasYum() != other.hasYum()) return false;
      if (hasYum()) {
        if (!getYum().equals(other.getYum())) return false;
      }
      if (hasGoo() != other.hasGoo()) return false;
      if (hasGoo()) {
        if (!getGoo().equals(other.getGoo())) return false;
      }
      if (hasZypper() != other.hasZypper()) return false;
      if (hasZypper()) {
        if (!getZypper().equals(other.getZypper())) return false;
      }
      if (hasWindowsUpdate() != other.hasWindowsUpdate()) return false;
      if (hasWindowsUpdate()) {
        if (!getWindowsUpdate().equals(other.getWindowsUpdate())) return false;
      }
      if (hasPreStep() != other.hasPreStep()) return false;
      if (hasPreStep()) {
        if (!getPreStep().equals(other.getPreStep())) return false;
      }
      if (hasPostStep() != other.hasPostStep()) return false;
      if (hasPostStep()) {
        if (!getPostStep().equals(other.getPostStep())) return false;
      }
      if (getMigInstancesAllowed() != other.getMigInstancesAllowed()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REBOOT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + rebootConfig_;
      if (hasApt()) {
        hash = (37 * hash) + APT_FIELD_NUMBER;
        hash = (53 * hash) + getApt().hashCode();
      }
      if (hasYum()) {
        hash = (37 * hash) + YUM_FIELD_NUMBER;
        hash = (53 * hash) + getYum().hashCode();
      }
      if (hasGoo()) {
        hash = (37 * hash) + GOO_FIELD_NUMBER;
        hash = (53 * hash) + getGoo().hashCode();
      }
      if (hasZypper()) {
        hash = (37 * hash) + ZYPPER_FIELD_NUMBER;
        hash = (53 * hash) + getZypper().hashCode();
      }
      if (hasWindowsUpdate()) {
        hash = (37 * hash) + WINDOWS_UPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getWindowsUpdate().hashCode();
      }
      if (hasPreStep()) {
        hash = (37 * hash) + PRE_STEP_FIELD_NUMBER;
        hash = (53 * hash) + getPreStep().hashCode();
      }
      if (hasPostStep()) {
        hash = (37 * hash) + POST_STEP_FIELD_NUMBER;
        hash = (53 * hash) + getPostStep().hashCode();
      }
      hash = (37 * hash) + MIG_INSTANCES_ALLOWED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getMigInstancesAllowed());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.osconfig.v1.PatchJobs.PatchConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Patch configuration specifications. Contains details on how to apply the
     * patch(es) to a VM instance.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.PatchConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.PatchConfig)
        com.google.cloud.osconfig.v1.PatchJobs.PatchConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_PatchConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_PatchConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.class,
                com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        rebootConfig_ = 0;
        apt_ = null;
        if (aptBuilder_ != null) {
          aptBuilder_.dispose();
          aptBuilder_ = null;
        }
        yum_ = null;
        if (yumBuilder_ != null) {
          yumBuilder_.dispose();
          yumBuilder_ = null;
        }
        goo_ = null;
        if (gooBuilder_ != null) {
          gooBuilder_.dispose();
          gooBuilder_ = null;
        }
        zypper_ = null;
        if (zypperBuilder_ != null) {
          zypperBuilder_.dispose();
          zypperBuilder_ = null;
        }
        windowsUpdate_ = null;
        if (windowsUpdateBuilder_ != null) {
          windowsUpdateBuilder_.dispose();
          windowsUpdateBuilder_ = null;
        }
        preStep_ = null;
        if (preStepBuilder_ != null) {
          preStepBuilder_.dispose();
          preStepBuilder_ = null;
        }
        postStep_ = null;
        if (postStepBuilder_ != null) {
          postStepBuilder_.dispose();
          postStepBuilder_ = null;
        }
        migInstancesAllowed_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_PatchConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig build() {
        com.google.cloud.osconfig.v1.PatchJobs.PatchConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.PatchConfig result =
            new com.google.cloud.osconfig.v1.PatchJobs.PatchConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.osconfig.v1.PatchJobs.PatchConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.rebootConfig_ = rebootConfig_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.apt_ = aptBuilder_ == null ? apt_ : aptBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.yum_ = yumBuilder_ == null ? yum_ : yumBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.goo_ = gooBuilder_ == null ? goo_ : gooBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.zypper_ = zypperBuilder_ == null ? zypper_ : zypperBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.windowsUpdate_ =
              windowsUpdateBuilder_ == null ? windowsUpdate_ : windowsUpdateBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.preStep_ = preStepBuilder_ == null ? preStep_ : preStepBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.postStep_ = postStepBuilder_ == null ? postStep_ : postStepBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.migInstancesAllowed_ = migInstancesAllowed_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.PatchConfig) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.PatchConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.PatchConfig other) {
        if (other == com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.getDefaultInstance())
          return this;
        if (other.rebootConfig_ != 0) {
          setRebootConfigValue(other.getRebootConfigValue());
        }
        if (other.hasApt()) {
          mergeApt(other.getApt());
        }
        if (other.hasYum()) {
          mergeYum(other.getYum());
        }
        if (other.hasGoo()) {
          mergeGoo(other.getGoo());
        }
        if (other.hasZypper()) {
          mergeZypper(other.getZypper());
        }
        if (other.hasWindowsUpdate()) {
          mergeWindowsUpdate(other.getWindowsUpdate());
        }
        if (other.hasPreStep()) {
          mergePreStep(other.getPreStep());
        }
        if (other.hasPostStep()) {
          mergePostStep(other.getPostStep());
        }
        if (other.getMigInstancesAllowed() != false) {
          setMigInstancesAllowed(other.getMigInstancesAllowed());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  rebootConfig_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 26:
                {
                  input.readMessage(getAptFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getYumFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getGooFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getZypperFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(getWindowsUpdateFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(getPreStepFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(getPostStepFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 74
              case 80:
                {
                  migInstancesAllowed_ = input.readBool();
                  bitField0_ |= 0x00000100;
                  break;
                } // case 80
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int rebootConfig_ = 0;
      /**
       *
       *
       * <pre>
       * Post-patch reboot settings.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig.RebootConfig reboot_config = 1;</code>
       *
       * @return The enum numeric value on the wire for rebootConfig.
       */
      @java.lang.Override
      public int getRebootConfigValue() {
        return rebootConfig_;
      }
      /**
       *
       *
       * <pre>
       * Post-patch reboot settings.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig.RebootConfig reboot_config = 1;</code>
       *
       * @param value The enum numeric value on the wire for rebootConfig to set.
       * @return This builder for chaining.
       */
      public Builder setRebootConfigValue(int value) {
        rebootConfig_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Post-patch reboot settings.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig.RebootConfig reboot_config = 1;</code>
       *
       * @return The rebootConfig.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.RebootConfig getRebootConfig() {
        com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.RebootConfig result =
            com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.RebootConfig.forNumber(
                rebootConfig_);
        return result == null
            ? com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.RebootConfig.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Post-patch reboot settings.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig.RebootConfig reboot_config = 1;</code>
       *
       * @param value The rebootConfig to set.
       * @return This builder for chaining.
       */
      public Builder setRebootConfig(
          com.google.cloud.osconfig.v1.PatchJobs.PatchConfig.RebootConfig value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        rebootConfig_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Post-patch reboot settings.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.PatchConfig.RebootConfig reboot_config = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRebootConfig() {
        bitField0_ = (bitField0_ & ~0x00000001);
        rebootConfig_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.AptSettings apt_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.AptSettings,
              com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.AptSettingsOrBuilder>
          aptBuilder_;
      /**
       *
       *
       * <pre>
       * Apt update settings. Use this setting to override the default `apt` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
       *
       * @return Whether the apt field is set.
       */
      public boolean hasApt() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Apt update settings. Use this setting to override the default `apt` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
       *
       * @return The apt.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.AptSettings getApt() {
        if (aptBuilder_ == null) {
          return apt_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.AptSettings.getDefaultInstance()
              : apt_;
        } else {
          return aptBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Apt update settings. Use this setting to override the default `apt` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
       */
      public Builder setApt(com.google.cloud.osconfig.v1.PatchJobs.AptSettings value) {
        if (aptBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          apt_ = value;
        } else {
          aptBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Apt update settings. Use this setting to override the default `apt` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
       */
      public Builder setApt(
          com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Builder builderForValue) {
        if (aptBuilder_ == null) {
          apt_ = builderForValue.build();
        } else {
          aptBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Apt update settings. Use this setting to override the default `apt` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
       */
      public Builder mergeApt(com.google.cloud.osconfig.v1.PatchJobs.AptSettings value) {
        if (aptBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && apt_ != null
              && apt_ != com.google.cloud.osconfig.v1.PatchJobs.AptSettings.getDefaultInstance()) {
            getAptBuilder().mergeFrom(value);
          } else {
            apt_ = value;
          }
        } else {
          aptBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Apt update settings. Use this setting to override the default `apt` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
       */
      public Builder clearApt() {
        bitField0_ = (bitField0_ & ~0x00000002);
        apt_ = null;
        if (aptBuilder_ != null) {
          aptBuilder_.dispose();
          aptBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Apt update settings. Use this setting to override the default `apt` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Builder getAptBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getAptFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Apt update settings. Use this setting to override the default `apt` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.AptSettingsOrBuilder getAptOrBuilder() {
        if (aptBuilder_ != null) {
          return aptBuilder_.getMessageOrBuilder();
        } else {
          return apt_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.AptSettings.getDefaultInstance()
              : apt_;
        }
      }
      /**
       *
       *
       * <pre>
       * Apt update settings. Use this setting to override the default `apt` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings apt = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.AptSettings,
              com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.AptSettingsOrBuilder>
          getAptFieldBuilder() {
        if (aptBuilder_ == null) {
          aptBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.AptSettings,
                  com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.AptSettingsOrBuilder>(
                  getApt(), getParentForChildren(), isClean());
          apt_ = null;
        }
        return aptBuilder_;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.YumSettings yum_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.YumSettings,
              com.google.cloud.osconfig.v1.PatchJobs.YumSettings.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.YumSettingsOrBuilder>
          yumBuilder_;
      /**
       *
       *
       * <pre>
       * Yum update settings. Use this setting to override the default `yum` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
       *
       * @return Whether the yum field is set.
       */
      public boolean hasYum() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Yum update settings. Use this setting to override the default `yum` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
       *
       * @return The yum.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.YumSettings getYum() {
        if (yumBuilder_ == null) {
          return yum_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.YumSettings.getDefaultInstance()
              : yum_;
        } else {
          return yumBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Yum update settings. Use this setting to override the default `yum` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
       */
      public Builder setYum(com.google.cloud.osconfig.v1.PatchJobs.YumSettings value) {
        if (yumBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          yum_ = value;
        } else {
          yumBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Yum update settings. Use this setting to override the default `yum` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
       */
      public Builder setYum(
          com.google.cloud.osconfig.v1.PatchJobs.YumSettings.Builder builderForValue) {
        if (yumBuilder_ == null) {
          yum_ = builderForValue.build();
        } else {
          yumBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Yum update settings. Use this setting to override the default `yum` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
       */
      public Builder mergeYum(com.google.cloud.osconfig.v1.PatchJobs.YumSettings value) {
        if (yumBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && yum_ != null
              && yum_ != com.google.cloud.osconfig.v1.PatchJobs.YumSettings.getDefaultInstance()) {
            getYumBuilder().mergeFrom(value);
          } else {
            yum_ = value;
          }
        } else {
          yumBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Yum update settings. Use this setting to override the default `yum` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
       */
      public Builder clearYum() {
        bitField0_ = (bitField0_ & ~0x00000004);
        yum_ = null;
        if (yumBuilder_ != null) {
          yumBuilder_.dispose();
          yumBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Yum update settings. Use this setting to override the default `yum` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.YumSettings.Builder getYumBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getYumFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Yum update settings. Use this setting to override the default `yum` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.YumSettingsOrBuilder getYumOrBuilder() {
        if (yumBuilder_ != null) {
          return yumBuilder_.getMessageOrBuilder();
        } else {
          return yum_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.YumSettings.getDefaultInstance()
              : yum_;
        }
      }
      /**
       *
       *
       * <pre>
       * Yum update settings. Use this setting to override the default `yum` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.YumSettings yum = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.YumSettings,
              com.google.cloud.osconfig.v1.PatchJobs.YumSettings.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.YumSettingsOrBuilder>
          getYumFieldBuilder() {
        if (yumBuilder_ == null) {
          yumBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.YumSettings,
                  com.google.cloud.osconfig.v1.PatchJobs.YumSettings.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.YumSettingsOrBuilder>(
                  getYum(), getParentForChildren(), isClean());
          yum_ = null;
        }
        return yumBuilder_;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.GooSettings goo_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.GooSettings,
              com.google.cloud.osconfig.v1.PatchJobs.GooSettings.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.GooSettingsOrBuilder>
          gooBuilder_;
      /**
       *
       *
       * <pre>
       * Goo update settings. Use this setting to override the default `goo` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
       *
       * @return Whether the goo field is set.
       */
      public boolean hasGoo() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Goo update settings. Use this setting to override the default `goo` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
       *
       * @return The goo.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.GooSettings getGoo() {
        if (gooBuilder_ == null) {
          return goo_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.GooSettings.getDefaultInstance()
              : goo_;
        } else {
          return gooBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Goo update settings. Use this setting to override the default `goo` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
       */
      public Builder setGoo(com.google.cloud.osconfig.v1.PatchJobs.GooSettings value) {
        if (gooBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          goo_ = value;
        } else {
          gooBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Goo update settings. Use this setting to override the default `goo` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
       */
      public Builder setGoo(
          com.google.cloud.osconfig.v1.PatchJobs.GooSettings.Builder builderForValue) {
        if (gooBuilder_ == null) {
          goo_ = builderForValue.build();
        } else {
          gooBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Goo update settings. Use this setting to override the default `goo` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
       */
      public Builder mergeGoo(com.google.cloud.osconfig.v1.PatchJobs.GooSettings value) {
        if (gooBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && goo_ != null
              && goo_ != com.google.cloud.osconfig.v1.PatchJobs.GooSettings.getDefaultInstance()) {
            getGooBuilder().mergeFrom(value);
          } else {
            goo_ = value;
          }
        } else {
          gooBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Goo update settings. Use this setting to override the default `goo` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
       */
      public Builder clearGoo() {
        bitField0_ = (bitField0_ & ~0x00000008);
        goo_ = null;
        if (gooBuilder_ != null) {
          gooBuilder_.dispose();
          gooBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Goo update settings. Use this setting to override the default `goo` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.GooSettings.Builder getGooBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getGooFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Goo update settings. Use this setting to override the default `goo` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.GooSettingsOrBuilder getGooOrBuilder() {
        if (gooBuilder_ != null) {
          return gooBuilder_.getMessageOrBuilder();
        } else {
          return goo_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.GooSettings.getDefaultInstance()
              : goo_;
        }
      }
      /**
       *
       *
       * <pre>
       * Goo update settings. Use this setting to override the default `goo` patch
       * rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GooSettings goo = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.GooSettings,
              com.google.cloud.osconfig.v1.PatchJobs.GooSettings.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.GooSettingsOrBuilder>
          getGooFieldBuilder() {
        if (gooBuilder_ == null) {
          gooBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.GooSettings,
                  com.google.cloud.osconfig.v1.PatchJobs.GooSettings.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.GooSettingsOrBuilder>(
                  getGoo(), getParentForChildren(), isClean());
          goo_ = null;
        }
        return gooBuilder_;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings zypper_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings,
              com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.ZypperSettingsOrBuilder>
          zypperBuilder_;
      /**
       *
       *
       * <pre>
       * Zypper update settings. Use this setting to override the default `zypper`
       * patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
       *
       * @return Whether the zypper field is set.
       */
      public boolean hasZypper() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Zypper update settings. Use this setting to override the default `zypper`
       * patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
       *
       * @return The zypper.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings getZypper() {
        if (zypperBuilder_ == null) {
          return zypper_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.getDefaultInstance()
              : zypper_;
        } else {
          return zypperBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Zypper update settings. Use this setting to override the default `zypper`
       * patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
       */
      public Builder setZypper(com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings value) {
        if (zypperBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          zypper_ = value;
        } else {
          zypperBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Zypper update settings. Use this setting to override the default `zypper`
       * patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
       */
      public Builder setZypper(
          com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.Builder builderForValue) {
        if (zypperBuilder_ == null) {
          zypper_ = builderForValue.build();
        } else {
          zypperBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Zypper update settings. Use this setting to override the default `zypper`
       * patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
       */
      public Builder mergeZypper(com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings value) {
        if (zypperBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && zypper_ != null
              && zypper_
                  != com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.getDefaultInstance()) {
            getZypperBuilder().mergeFrom(value);
          } else {
            zypper_ = value;
          }
        } else {
          zypperBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Zypper update settings. Use this setting to override the default `zypper`
       * patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
       */
      public Builder clearZypper() {
        bitField0_ = (bitField0_ & ~0x00000010);
        zypper_ = null;
        if (zypperBuilder_ != null) {
          zypperBuilder_.dispose();
          zypperBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Zypper update settings. Use this setting to override the default `zypper`
       * patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.Builder getZypperBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getZypperFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Zypper update settings. Use this setting to override the default `zypper`
       * patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ZypperSettingsOrBuilder getZypperOrBuilder() {
        if (zypperBuilder_ != null) {
          return zypperBuilder_.getMessageOrBuilder();
        } else {
          return zypper_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.getDefaultInstance()
              : zypper_;
        }
      }
      /**
       *
       *
       * <pre>
       * Zypper update settings. Use this setting to override the default `zypper`
       * patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ZypperSettings zypper = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings,
              com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.ZypperSettingsOrBuilder>
          getZypperFieldBuilder() {
        if (zypperBuilder_ == null) {
          zypperBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings,
                  com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.ZypperSettingsOrBuilder>(
                  getZypper(), getParentForChildren(), isClean());
          zypper_ = null;
        }
        return zypperBuilder_;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings windowsUpdate_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings,
              com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettingsOrBuilder>
          windowsUpdateBuilder_;
      /**
       *
       *
       * <pre>
       * Windows update settings. Use this override the default windows patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
       *
       * @return Whether the windowsUpdate field is set.
       */
      public boolean hasWindowsUpdate() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Windows update settings. Use this override the default windows patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
       *
       * @return The windowsUpdate.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings getWindowsUpdate() {
        if (windowsUpdateBuilder_ == null) {
          return windowsUpdate_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.getDefaultInstance()
              : windowsUpdate_;
        } else {
          return windowsUpdateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Windows update settings. Use this override the default windows patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
       */
      public Builder setWindowsUpdate(
          com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings value) {
        if (windowsUpdateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          windowsUpdate_ = value;
        } else {
          windowsUpdateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Windows update settings. Use this override the default windows patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
       */
      public Builder setWindowsUpdate(
          com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Builder builderForValue) {
        if (windowsUpdateBuilder_ == null) {
          windowsUpdate_ = builderForValue.build();
        } else {
          windowsUpdateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Windows update settings. Use this override the default windows patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
       */
      public Builder mergeWindowsUpdate(
          com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings value) {
        if (windowsUpdateBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && windowsUpdate_ != null
              && windowsUpdate_
                  != com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings
                      .getDefaultInstance()) {
            getWindowsUpdateBuilder().mergeFrom(value);
          } else {
            windowsUpdate_ = value;
          }
        } else {
          windowsUpdateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Windows update settings. Use this override the default windows patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
       */
      public Builder clearWindowsUpdate() {
        bitField0_ = (bitField0_ & ~0x00000020);
        windowsUpdate_ = null;
        if (windowsUpdateBuilder_ != null) {
          windowsUpdateBuilder_.dispose();
          windowsUpdateBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Windows update settings. Use this override the default windows patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Builder
          getWindowsUpdateBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getWindowsUpdateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Windows update settings. Use this override the default windows patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettingsOrBuilder
          getWindowsUpdateOrBuilder() {
        if (windowsUpdateBuilder_ != null) {
          return windowsUpdateBuilder_.getMessageOrBuilder();
        } else {
          return windowsUpdate_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.getDefaultInstance()
              : windowsUpdate_;
        }
      }
      /**
       *
       *
       * <pre>
       * Windows update settings. Use this override the default windows patch rules.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.WindowsUpdateSettings windows_update = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings,
              com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettingsOrBuilder>
          getWindowsUpdateFieldBuilder() {
        if (windowsUpdateBuilder_ == null) {
          windowsUpdateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings,
                  com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettingsOrBuilder>(
                  getWindowsUpdate(), getParentForChildren(), isClean());
          windowsUpdate_ = null;
        }
        return windowsUpdateBuilder_;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.ExecStep preStep_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.ExecStep,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStep.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepOrBuilder>
          preStepBuilder_;
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run before the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
       *
       * @return Whether the preStep field is set.
       */
      public boolean hasPreStep() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run before the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
       *
       * @return The preStep.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStep getPreStep() {
        if (preStepBuilder_ == null) {
          return preStep_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.ExecStep.getDefaultInstance()
              : preStep_;
        } else {
          return preStepBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run before the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
       */
      public Builder setPreStep(com.google.cloud.osconfig.v1.PatchJobs.ExecStep value) {
        if (preStepBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          preStep_ = value;
        } else {
          preStepBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run before the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
       */
      public Builder setPreStep(
          com.google.cloud.osconfig.v1.PatchJobs.ExecStep.Builder builderForValue) {
        if (preStepBuilder_ == null) {
          preStep_ = builderForValue.build();
        } else {
          preStepBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run before the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
       */
      public Builder mergePreStep(com.google.cloud.osconfig.v1.PatchJobs.ExecStep value) {
        if (preStepBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && preStep_ != null
              && preStep_ != com.google.cloud.osconfig.v1.PatchJobs.ExecStep.getDefaultInstance()) {
            getPreStepBuilder().mergeFrom(value);
          } else {
            preStep_ = value;
          }
        } else {
          preStepBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run before the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
       */
      public Builder clearPreStep() {
        bitField0_ = (bitField0_ & ~0x00000040);
        preStep_ = null;
        if (preStepBuilder_ != null) {
          preStepBuilder_.dispose();
          preStepBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run before the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStep.Builder getPreStepBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getPreStepFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run before the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStepOrBuilder getPreStepOrBuilder() {
        if (preStepBuilder_ != null) {
          return preStepBuilder_.getMessageOrBuilder();
        } else {
          return preStep_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.ExecStep.getDefaultInstance()
              : preStep_;
        }
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run before the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep pre_step = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.ExecStep,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStep.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepOrBuilder>
          getPreStepFieldBuilder() {
        if (preStepBuilder_ == null) {
          preStepBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.ExecStep,
                  com.google.cloud.osconfig.v1.PatchJobs.ExecStep.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.ExecStepOrBuilder>(
                  getPreStep(), getParentForChildren(), isClean());
          preStep_ = null;
        }
        return preStepBuilder_;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.ExecStep postStep_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.ExecStep,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStep.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepOrBuilder>
          postStepBuilder_;
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run after the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
       *
       * @return Whether the postStep field is set.
       */
      public boolean hasPostStep() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run after the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
       *
       * @return The postStep.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStep getPostStep() {
        if (postStepBuilder_ == null) {
          return postStep_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.ExecStep.getDefaultInstance()
              : postStep_;
        } else {
          return postStepBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run after the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
       */
      public Builder setPostStep(com.google.cloud.osconfig.v1.PatchJobs.ExecStep value) {
        if (postStepBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          postStep_ = value;
        } else {
          postStepBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run after the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
       */
      public Builder setPostStep(
          com.google.cloud.osconfig.v1.PatchJobs.ExecStep.Builder builderForValue) {
        if (postStepBuilder_ == null) {
          postStep_ = builderForValue.build();
        } else {
          postStepBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run after the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
       */
      public Builder mergePostStep(com.google.cloud.osconfig.v1.PatchJobs.ExecStep value) {
        if (postStepBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && postStep_ != null
              && postStep_
                  != com.google.cloud.osconfig.v1.PatchJobs.ExecStep.getDefaultInstance()) {
            getPostStepBuilder().mergeFrom(value);
          } else {
            postStep_ = value;
          }
        } else {
          postStepBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run after the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
       */
      public Builder clearPostStep() {
        bitField0_ = (bitField0_ & ~0x00000080);
        postStep_ = null;
        if (postStepBuilder_ != null) {
          postStepBuilder_.dispose();
          postStepBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run after the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStep.Builder getPostStepBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getPostStepFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run after the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStepOrBuilder getPostStepOrBuilder() {
        if (postStepBuilder_ != null) {
          return postStepBuilder_.getMessageOrBuilder();
        } else {
          return postStep_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.ExecStep.getDefaultInstance()
              : postStep_;
        }
      }
      /**
       *
       *
       * <pre>
       * The `ExecStep` to run after the patch update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStep post_step = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.ExecStep,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStep.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepOrBuilder>
          getPostStepFieldBuilder() {
        if (postStepBuilder_ == null) {
          postStepBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.ExecStep,
                  com.google.cloud.osconfig.v1.PatchJobs.ExecStep.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.ExecStepOrBuilder>(
                  getPostStep(), getParentForChildren(), isClean());
          postStep_ = null;
        }
        return postStepBuilder_;
      }

      private boolean migInstancesAllowed_;
      /**
       *
       *
       * <pre>
       * Allows the patch job to run on Managed instance groups (MIGs).
       * </pre>
       *
       * <code>bool mig_instances_allowed = 10;</code>
       *
       * @return The migInstancesAllowed.
       */
      @java.lang.Override
      public boolean getMigInstancesAllowed() {
        return migInstancesAllowed_;
      }
      /**
       *
       *
       * <pre>
       * Allows the patch job to run on Managed instance groups (MIGs).
       * </pre>
       *
       * <code>bool mig_instances_allowed = 10;</code>
       *
       * @param value The migInstancesAllowed to set.
       * @return This builder for chaining.
       */
      public Builder setMigInstancesAllowed(boolean value) {

        migInstancesAllowed_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Allows the patch job to run on Managed instance groups (MIGs).
       * </pre>
       *
       * <code>bool mig_instances_allowed = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMigInstancesAllowed() {
        bitField0_ = (bitField0_ & ~0x00000100);
        migInstancesAllowed_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.PatchConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.PatchConfig)
    private static final com.google.cloud.osconfig.v1.PatchJobs.PatchConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.PatchConfig();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.PatchConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PatchConfig> PARSER =
        new com.google.protobuf.AbstractParser<PatchConfig>() {
          @java.lang.Override
          public PatchConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PatchConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PatchConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.PatchConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InstanceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.Instance)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Namespace for instance state enums.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.Instance}
   */
  public static final class Instance extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.Instance)
      InstanceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Instance.newBuilder() to construct.
    private Instance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Instance() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Instance();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_Instance_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_Instance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.Instance.class,
              com.google.cloud.osconfig.v1.PatchJobs.Instance.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Patch state of an instance.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.osconfig.v1.Instance.PatchState}
     */
    public enum PatchState implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified.
       * </pre>
       *
       * <code>PATCH_STATE_UNSPECIFIED = 0;</code>
       */
      PATCH_STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The instance is not yet notified.
       * </pre>
       *
       * <code>PENDING = 1;</code>
       */
      PENDING(1),
      /**
       *
       *
       * <pre>
       * Instance is inactive and cannot be patched.
       * </pre>
       *
       * <code>INACTIVE = 2;</code>
       */
      INACTIVE(2),
      /**
       *
       *
       * <pre>
       * The instance is notified that it should be patched.
       * </pre>
       *
       * <code>NOTIFIED = 3;</code>
       */
      NOTIFIED(3),
      /**
       *
       *
       * <pre>
       * The instance has started the patching process.
       * </pre>
       *
       * <code>STARTED = 4;</code>
       */
      STARTED(4),
      /**
       *
       *
       * <pre>
       * The instance is downloading patches.
       * </pre>
       *
       * <code>DOWNLOADING_PATCHES = 5;</code>
       */
      DOWNLOADING_PATCHES(5),
      /**
       *
       *
       * <pre>
       * The instance is applying patches.
       * </pre>
       *
       * <code>APPLYING_PATCHES = 6;</code>
       */
      APPLYING_PATCHES(6),
      /**
       *
       *
       * <pre>
       * The instance is rebooting.
       * </pre>
       *
       * <code>REBOOTING = 7;</code>
       */
      REBOOTING(7),
      /**
       *
       *
       * <pre>
       * The instance has completed applying patches.
       * </pre>
       *
       * <code>SUCCEEDED = 8;</code>
       */
      SUCCEEDED(8),
      /**
       *
       *
       * <pre>
       * The instance has completed applying patches but a reboot is required.
       * </pre>
       *
       * <code>SUCCEEDED_REBOOT_REQUIRED = 9;</code>
       */
      SUCCEEDED_REBOOT_REQUIRED(9),
      /**
       *
       *
       * <pre>
       * The instance has failed to apply the patch.
       * </pre>
       *
       * <code>FAILED = 10;</code>
       */
      FAILED(10),
      /**
       *
       *
       * <pre>
       * The instance acked the notification and will start shortly.
       * </pre>
       *
       * <code>ACKED = 11;</code>
       */
      ACKED(11),
      /**
       *
       *
       * <pre>
       * The instance exceeded the time out while applying the patch.
       * </pre>
       *
       * <code>TIMED_OUT = 12;</code>
       */
      TIMED_OUT(12),
      /**
       *
       *
       * <pre>
       * The instance is running the pre-patch step.
       * </pre>
       *
       * <code>RUNNING_PRE_PATCH_STEP = 13;</code>
       */
      RUNNING_PRE_PATCH_STEP(13),
      /**
       *
       *
       * <pre>
       * The instance is running the post-patch step.
       * </pre>
       *
       * <code>RUNNING_POST_PATCH_STEP = 14;</code>
       */
      RUNNING_POST_PATCH_STEP(14),
      /**
       *
       *
       * <pre>
       * The service could not detect the presence of the agent. Check to ensure
       * that the agent is installed, running, and able to communicate with the
       * service.
       * </pre>
       *
       * <code>NO_AGENT_DETECTED = 15;</code>
       */
      NO_AGENT_DETECTED(15),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified.
       * </pre>
       *
       * <code>PATCH_STATE_UNSPECIFIED = 0;</code>
       */
      public static final int PATCH_STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The instance is not yet notified.
       * </pre>
       *
       * <code>PENDING = 1;</code>
       */
      public static final int PENDING_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Instance is inactive and cannot be patched.
       * </pre>
       *
       * <code>INACTIVE = 2;</code>
       */
      public static final int INACTIVE_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The instance is notified that it should be patched.
       * </pre>
       *
       * <code>NOTIFIED = 3;</code>
       */
      public static final int NOTIFIED_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The instance has started the patching process.
       * </pre>
       *
       * <code>STARTED = 4;</code>
       */
      public static final int STARTED_VALUE = 4;
      /**
       *
       *
       * <pre>
       * The instance is downloading patches.
       * </pre>
       *
       * <code>DOWNLOADING_PATCHES = 5;</code>
       */
      public static final int DOWNLOADING_PATCHES_VALUE = 5;
      /**
       *
       *
       * <pre>
       * The instance is applying patches.
       * </pre>
       *
       * <code>APPLYING_PATCHES = 6;</code>
       */
      public static final int APPLYING_PATCHES_VALUE = 6;
      /**
       *
       *
       * <pre>
       * The instance is rebooting.
       * </pre>
       *
       * <code>REBOOTING = 7;</code>
       */
      public static final int REBOOTING_VALUE = 7;
      /**
       *
       *
       * <pre>
       * The instance has completed applying patches.
       * </pre>
       *
       * <code>SUCCEEDED = 8;</code>
       */
      public static final int SUCCEEDED_VALUE = 8;
      /**
       *
       *
       * <pre>
       * The instance has completed applying patches but a reboot is required.
       * </pre>
       *
       * <code>SUCCEEDED_REBOOT_REQUIRED = 9;</code>
       */
      public static final int SUCCEEDED_REBOOT_REQUIRED_VALUE = 9;
      /**
       *
       *
       * <pre>
       * The instance has failed to apply the patch.
       * </pre>
       *
       * <code>FAILED = 10;</code>
       */
      public static final int FAILED_VALUE = 10;
      /**
       *
       *
       * <pre>
       * The instance acked the notification and will start shortly.
       * </pre>
       *
       * <code>ACKED = 11;</code>
       */
      public static final int ACKED_VALUE = 11;
      /**
       *
       *
       * <pre>
       * The instance exceeded the time out while applying the patch.
       * </pre>
       *
       * <code>TIMED_OUT = 12;</code>
       */
      public static final int TIMED_OUT_VALUE = 12;
      /**
       *
       *
       * <pre>
       * The instance is running the pre-patch step.
       * </pre>
       *
       * <code>RUNNING_PRE_PATCH_STEP = 13;</code>
       */
      public static final int RUNNING_PRE_PATCH_STEP_VALUE = 13;
      /**
       *
       *
       * <pre>
       * The instance is running the post-patch step.
       * </pre>
       *
       * <code>RUNNING_POST_PATCH_STEP = 14;</code>
       */
      public static final int RUNNING_POST_PATCH_STEP_VALUE = 14;
      /**
       *
       *
       * <pre>
       * The service could not detect the presence of the agent. Check to ensure
       * that the agent is installed, running, and able to communicate with the
       * service.
       * </pre>
       *
       * <code>NO_AGENT_DETECTED = 15;</code>
       */
      public static final int NO_AGENT_DETECTED_VALUE = 15;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static PatchState valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static PatchState forNumber(int value) {
        switch (value) {
          case 0:
            return PATCH_STATE_UNSPECIFIED;
          case 1:
            return PENDING;
          case 2:
            return INACTIVE;
          case 3:
            return NOTIFIED;
          case 4:
            return STARTED;
          case 5:
            return DOWNLOADING_PATCHES;
          case 6:
            return APPLYING_PATCHES;
          case 7:
            return REBOOTING;
          case 8:
            return SUCCEEDED;
          case 9:
            return SUCCEEDED_REBOOT_REQUIRED;
          case 10:
            return FAILED;
          case 11:
            return ACKED;
          case 12:
            return TIMED_OUT;
          case 13:
            return RUNNING_PRE_PATCH_STEP;
          case 14:
            return RUNNING_POST_PATCH_STEP;
          case 15:
            return NO_AGENT_DETECTED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<PatchState> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<PatchState> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<PatchState>() {
            public PatchState findValueByNumber(int number) {
              return PatchState.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs.Instance.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final PatchState[] VALUES = values();

      public static PatchState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private PatchState(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.Instance.PatchState)
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.Instance)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.Instance other =
          (com.google.cloud.osconfig.v1.PatchJobs.Instance) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.Instance parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.Instance parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.Instance parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.Instance parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.Instance parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.Instance parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.Instance parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.Instance parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.Instance parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.Instance parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.Instance parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.Instance parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.osconfig.v1.PatchJobs.Instance prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Namespace for instance state enums.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.Instance}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.Instance)
        com.google.cloud.osconfig.v1.PatchJobs.InstanceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_Instance_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_Instance_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.Instance.class,
                com.google.cloud.osconfig.v1.PatchJobs.Instance.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.Instance.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_Instance_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.Instance getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.Instance.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.Instance build() {
        com.google.cloud.osconfig.v1.PatchJobs.Instance result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.Instance buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.Instance result =
            new com.google.cloud.osconfig.v1.PatchJobs.Instance(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.Instance) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.Instance) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.Instance other) {
        if (other == com.google.cloud.osconfig.v1.PatchJobs.Instance.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.Instance)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.Instance)
    private static final com.google.cloud.osconfig.v1.PatchJobs.Instance DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.Instance();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.Instance getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Instance> PARSER =
        new com.google.protobuf.AbstractParser<Instance>() {
          @java.lang.Override
          public Instance parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Instance> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Instance> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.Instance getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CancelPatchJobRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.CancelPatchJobRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Message for canceling a patch job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.CancelPatchJobRequest}
   */
  public static final class CancelPatchJobRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.CancelPatchJobRequest)
      CancelPatchJobRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CancelPatchJobRequest.newBuilder() to construct.
    private CancelPatchJobRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CancelPatchJobRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CancelPatchJobRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_CancelPatchJobRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_CancelPatchJobRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest.class,
              com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest other =
          (com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message for canceling a patch job.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.CancelPatchJobRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.CancelPatchJobRequest)
        com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_CancelPatchJobRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_CancelPatchJobRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest.class,
                com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_CancelPatchJobRequest_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest build() {
        com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest result =
            new com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the patch in the form `projects/&#42;&#47;patchJobs/&#42;`
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.CancelPatchJobRequest)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.CancelPatchJobRequest)
    private static final com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CancelPatchJobRequest> PARSER =
        new com.google.protobuf.AbstractParser<CancelPatchJobRequest>() {
          @java.lang.Override
          public CancelPatchJobRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CancelPatchJobRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CancelPatchJobRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.CancelPatchJobRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AptSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.AptSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * By changing the type to DIST, the patching is performed
     * using `apt-get dist-upgrade` instead.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.AptSettings.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * By changing the type to DIST, the patching is performed
     * using `apt-get dist-upgrade` instead.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.AptSettings.Type type = 1;</code>
     *
     * @return The type.
     */
    com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Type getType();

    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages will be excluded
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @return A list containing the excludes.
     */
    java.util.List<java.lang.String> getExcludesList();
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages will be excluded
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @return The count of excludes.
     */
    int getExcludesCount();
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages will be excluded
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The excludes at the given index.
     */
    java.lang.String getExcludes(int index);
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages will be excluded
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludes at the given index.
     */
    com.google.protobuf.ByteString getExcludesBytes(int index);

    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field cannot be specified with any other patch configuration
     * fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 3;</code>
     *
     * @return A list containing the exclusivePackages.
     */
    java.util.List<java.lang.String> getExclusivePackagesList();
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field cannot be specified with any other patch configuration
     * fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 3;</code>
     *
     * @return The count of exclusivePackages.
     */
    int getExclusivePackagesCount();
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field cannot be specified with any other patch configuration
     * fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The exclusivePackages at the given index.
     */
    java.lang.String getExclusivePackages(int index);
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field cannot be specified with any other patch configuration
     * fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the exclusivePackages at the given index.
     */
    com.google.protobuf.ByteString getExclusivePackagesBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Apt patching is completed by executing `apt-get update &amp;&amp; apt-get
   * upgrade`. Additional options can be set to control how this is executed.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.AptSettings}
   */
  public static final class AptSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.AptSettings)
      AptSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AptSettings.newBuilder() to construct.
    private AptSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AptSettings() {
      type_ = 0;
      excludes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      exclusivePackages_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AptSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_AptSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_AptSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.AptSettings.class,
              com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Apt patch type.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.osconfig.v1.AptSettings.Type}
     */
    public enum Type implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * By default, upgrade will be performed.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Runs `apt-get dist-upgrade`.
       * </pre>
       *
       * <code>DIST = 1;</code>
       */
      DIST(1),
      /**
       *
       *
       * <pre>
       * Runs `apt-get upgrade`.
       * </pre>
       *
       * <code>UPGRADE = 2;</code>
       */
      UPGRADE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * By default, upgrade will be performed.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Runs `apt-get dist-upgrade`.
       * </pre>
       *
       * <code>DIST = 1;</code>
       */
      public static final int DIST_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Runs `apt-get upgrade`.
       * </pre>
       *
       * <code>UPGRADE = 2;</code>
       */
      public static final int UPGRADE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 0:
            return TYPE_UNSPECIFIED;
          case 1:
            return DIST;
          case 2:
            return UPGRADE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Type>() {
            public Type findValueByNumber(int number) {
              return Type.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs.AptSettings.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.AptSettings.Type)
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * By changing the type to DIST, the patching is performed
     * using `apt-get dist-upgrade` instead.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.AptSettings.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * By changing the type to DIST, the patching is performed
     * using `apt-get dist-upgrade` instead.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.AptSettings.Type type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Type getType() {
      com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Type result =
          com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Type.UNRECOGNIZED
          : result;
    }

    public static final int EXCLUDES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList excludes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages will be excluded
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @return A list containing the excludes.
     */
    public com.google.protobuf.ProtocolStringList getExcludesList() {
      return excludes_;
    }
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages will be excluded
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @return The count of excludes.
     */
    public int getExcludesCount() {
      return excludes_.size();
    }
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages will be excluded
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The excludes at the given index.
     */
    public java.lang.String getExcludes(int index) {
      return excludes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages will be excluded
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludes at the given index.
     */
    public com.google.protobuf.ByteString getExcludesBytes(int index) {
      return excludes_.getByteString(index);
    }

    public static final int EXCLUSIVE_PACKAGES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList exclusivePackages_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field cannot be specified with any other patch configuration
     * fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 3;</code>
     *
     * @return A list containing the exclusivePackages.
     */
    public com.google.protobuf.ProtocolStringList getExclusivePackagesList() {
      return exclusivePackages_;
    }
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field cannot be specified with any other patch configuration
     * fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 3;</code>
     *
     * @return The count of exclusivePackages.
     */
    public int getExclusivePackagesCount() {
      return exclusivePackages_.size();
    }
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field cannot be specified with any other patch configuration
     * fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The exclusivePackages at the given index.
     */
    public java.lang.String getExclusivePackages(int index) {
      return exclusivePackages_.get(index);
    }
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field cannot be specified with any other patch configuration
     * fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the exclusivePackages at the given index.
     */
    public com.google.protobuf.ByteString getExclusivePackagesBytes(int index) {
      return exclusivePackages_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (type_
          != com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Type.TYPE_UNSPECIFIED.getNumber()) {
        output.writeEnum(1, type_);
      }
      for (int i = 0; i < excludes_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, excludes_.getRaw(i));
      }
      for (int i = 0; i < exclusivePackages_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, exclusivePackages_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_
          != com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Type.TYPE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < excludes_.size(); i++) {
          dataSize += computeStringSizeNoTag(excludes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExcludesList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < exclusivePackages_.size(); i++) {
          dataSize += computeStringSizeNoTag(exclusivePackages_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExclusivePackagesList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.AptSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.AptSettings other =
          (com.google.cloud.osconfig.v1.PatchJobs.AptSettings) obj;

      if (type_ != other.type_) return false;
      if (!getExcludesList().equals(other.getExcludesList())) return false;
      if (!getExclusivePackagesList().equals(other.getExclusivePackagesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      if (getExcludesCount() > 0) {
        hash = (37 * hash) + EXCLUDES_FIELD_NUMBER;
        hash = (53 * hash) + getExcludesList().hashCode();
      }
      if (getExclusivePackagesCount() > 0) {
        hash = (37 * hash) + EXCLUSIVE_PACKAGES_FIELD_NUMBER;
        hash = (53 * hash) + getExclusivePackagesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.AptSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.AptSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.AptSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.AptSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.AptSettings parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.AptSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.AptSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.AptSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.AptSettings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.AptSettings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.AptSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.AptSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.osconfig.v1.PatchJobs.AptSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Apt patching is completed by executing `apt-get update &amp;&amp; apt-get
     * upgrade`. Additional options can be set to control how this is executed.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.AptSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.AptSettings)
        com.google.cloud.osconfig.v1.PatchJobs.AptSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_AptSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_AptSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.AptSettings.class,
                com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.AptSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 0;
        excludes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        exclusivePackages_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_AptSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.AptSettings getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.AptSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.AptSettings build() {
        com.google.cloud.osconfig.v1.PatchJobs.AptSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.AptSettings buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.AptSettings result =
            new com.google.cloud.osconfig.v1.PatchJobs.AptSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.osconfig.v1.PatchJobs.AptSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          excludes_.makeImmutable();
          result.excludes_ = excludes_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          exclusivePackages_.makeImmutable();
          result.exclusivePackages_ = exclusivePackages_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.AptSettings) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.AptSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.AptSettings other) {
        if (other == com.google.cloud.osconfig.v1.PatchJobs.AptSettings.getDefaultInstance())
          return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (!other.excludes_.isEmpty()) {
          if (excludes_.isEmpty()) {
            excludes_ = other.excludes_;
            bitField0_ |= 0x00000002;
          } else {
            ensureExcludesIsMutable();
            excludes_.addAll(other.excludes_);
          }
          onChanged();
        }
        if (!other.exclusivePackages_.isEmpty()) {
          if (exclusivePackages_.isEmpty()) {
            exclusivePackages_ = other.exclusivePackages_;
            bitField0_ |= 0x00000004;
          } else {
            ensureExclusivePackagesIsMutable();
            exclusivePackages_.addAll(other.exclusivePackages_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExcludesIsMutable();
                  excludes_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExclusivePackagesIsMutable();
                  exclusivePackages_.add(s);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * By changing the type to DIST, the patching is performed
       * using `apt-get dist-upgrade` instead.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings.Type type = 1;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * By changing the type to DIST, the patching is performed
       * using `apt-get dist-upgrade` instead.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings.Type type = 1;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * By changing the type to DIST, the patching is performed
       * using `apt-get dist-upgrade` instead.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings.Type type = 1;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Type getType() {
        com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Type result =
            com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Type.forNumber(type_);
        return result == null
            ? com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Type.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * By changing the type to DIST, the patching is performed
       * using `apt-get dist-upgrade` instead.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings.Type type = 1;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.cloud.osconfig.v1.PatchJobs.AptSettings.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * By changing the type to DIST, the patching is performed
       * using `apt-get dist-upgrade` instead.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.AptSettings.Type type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList excludes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureExcludesIsMutable() {
        if (!excludes_.isModifiable()) {
          excludes_ = new com.google.protobuf.LazyStringArrayList(excludes_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages will be excluded
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @return A list containing the excludes.
       */
      public com.google.protobuf.ProtocolStringList getExcludesList() {
        excludes_.makeImmutable();
        return excludes_;
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages will be excluded
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @return The count of excludes.
       */
      public int getExcludesCount() {
        return excludes_.size();
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages will be excluded
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The excludes at the given index.
       */
      public java.lang.String getExcludes(int index) {
        return excludes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages will be excluded
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the excludes at the given index.
       */
      public com.google.protobuf.ByteString getExcludesBytes(int index) {
        return excludes_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages will be excluded
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The excludes to set.
       * @return This builder for chaining.
       */
      public Builder setExcludes(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludesIsMutable();
        excludes_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages will be excluded
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @param value The excludes to add.
       * @return This builder for chaining.
       */
      public Builder addExcludes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludesIsMutable();
        excludes_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages will be excluded
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @param values The excludes to add.
       * @return This builder for chaining.
       */
      public Builder addAllExcludes(java.lang.Iterable<java.lang.String> values) {
        ensureExcludesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludes_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages will be excluded
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExcludes() {
        excludes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages will be excluded
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @param value The bytes of the excludes to add.
       * @return This builder for chaining.
       */
      public Builder addExcludesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExcludesIsMutable();
        excludes_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList exclusivePackages_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureExclusivePackagesIsMutable() {
        if (!exclusivePackages_.isModifiable()) {
          exclusivePackages_ = new com.google.protobuf.LazyStringArrayList(exclusivePackages_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field cannot be specified with any other patch configuration
       * fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 3;</code>
       *
       * @return A list containing the exclusivePackages.
       */
      public com.google.protobuf.ProtocolStringList getExclusivePackagesList() {
        exclusivePackages_.makeImmutable();
        return exclusivePackages_;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field cannot be specified with any other patch configuration
       * fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 3;</code>
       *
       * @return The count of exclusivePackages.
       */
      public int getExclusivePackagesCount() {
        return exclusivePackages_.size();
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field cannot be specified with any other patch configuration
       * fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The exclusivePackages at the given index.
       */
      public java.lang.String getExclusivePackages(int index) {
        return exclusivePackages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field cannot be specified with any other patch configuration
       * fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the exclusivePackages at the given index.
       */
      public com.google.protobuf.ByteString getExclusivePackagesBytes(int index) {
        return exclusivePackages_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field cannot be specified with any other patch configuration
       * fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The exclusivePackages to set.
       * @return This builder for chaining.
       */
      public Builder setExclusivePackages(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusivePackagesIsMutable();
        exclusivePackages_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field cannot be specified with any other patch configuration
       * fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 3;</code>
       *
       * @param value The exclusivePackages to add.
       * @return This builder for chaining.
       */
      public Builder addExclusivePackages(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusivePackagesIsMutable();
        exclusivePackages_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field cannot be specified with any other patch configuration
       * fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 3;</code>
       *
       * @param values The exclusivePackages to add.
       * @return This builder for chaining.
       */
      public Builder addAllExclusivePackages(java.lang.Iterable<java.lang.String> values) {
        ensureExclusivePackagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exclusivePackages_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field cannot be specified with any other patch configuration
       * fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExclusivePackages() {
        exclusivePackages_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field cannot be specified with any other patch configuration
       * fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 3;</code>
       *
       * @param value The bytes of the exclusivePackages to add.
       * @return This builder for chaining.
       */
      public Builder addExclusivePackagesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExclusivePackagesIsMutable();
        exclusivePackages_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.AptSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.AptSettings)
    private static final com.google.cloud.osconfig.v1.PatchJobs.AptSettings DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.AptSettings();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.AptSettings getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AptSettings> PARSER =
        new com.google.protobuf.AbstractParser<AptSettings>() {
          @java.lang.Override
          public AptSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AptSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AptSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.AptSettings getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface YumSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.YumSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Adds the `--security` flag to `yum update`. Not supported on
     * all platforms.
     * </pre>
     *
     * <code>bool security = 1;</code>
     *
     * @return The security.
     */
    boolean getSecurity();

    /**
     *
     *
     * <pre>
     * Will cause patch to run `yum update-minimal` instead.
     * </pre>
     *
     * <code>bool minimal = 2;</code>
     *
     * @return The minimal.
     */
    boolean getMinimal();

    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages are excluded by
     * using the yum `--exclude` flag.
     * </pre>
     *
     * <code>repeated string excludes = 3;</code>
     *
     * @return A list containing the excludes.
     */
    java.util.List<java.lang.String> getExcludesList();
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages are excluded by
     * using the yum `--exclude` flag.
     * </pre>
     *
     * <code>repeated string excludes = 3;</code>
     *
     * @return The count of excludes.
     */
    int getExcludesCount();
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages are excluded by
     * using the yum `--exclude` flag.
     * </pre>
     *
     * <code>repeated string excludes = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The excludes at the given index.
     */
    java.lang.String getExcludes(int index);
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages are excluded by
     * using the yum `--exclude` flag.
     * </pre>
     *
     * <code>repeated string excludes = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludes at the given index.
     */
    com.google.protobuf.ByteString getExcludesBytes(int index);

    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field must not be specified with any other patch
     * configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 4;</code>
     *
     * @return A list containing the exclusivePackages.
     */
    java.util.List<java.lang.String> getExclusivePackagesList();
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field must not be specified with any other patch
     * configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 4;</code>
     *
     * @return The count of exclusivePackages.
     */
    int getExclusivePackagesCount();
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field must not be specified with any other patch
     * configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The exclusivePackages at the given index.
     */
    java.lang.String getExclusivePackages(int index);
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field must not be specified with any other patch
     * configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the exclusivePackages at the given index.
     */
    com.google.protobuf.ByteString getExclusivePackagesBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Yum patching is performed by executing `yum update`. Additional options
   * can be set to control how this is executed.
   *
   * Note that not all settings are supported on all platforms.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.YumSettings}
   */
  public static final class YumSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.YumSettings)
      YumSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use YumSettings.newBuilder() to construct.
    private YumSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private YumSettings() {
      excludes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      exclusivePackages_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new YumSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_YumSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_YumSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.YumSettings.class,
              com.google.cloud.osconfig.v1.PatchJobs.YumSettings.Builder.class);
    }

    public static final int SECURITY_FIELD_NUMBER = 1;
    private boolean security_ = false;
    /**
     *
     *
     * <pre>
     * Adds the `--security` flag to `yum update`. Not supported on
     * all platforms.
     * </pre>
     *
     * <code>bool security = 1;</code>
     *
     * @return The security.
     */
    @java.lang.Override
    public boolean getSecurity() {
      return security_;
    }

    public static final int MINIMAL_FIELD_NUMBER = 2;
    private boolean minimal_ = false;
    /**
     *
     *
     * <pre>
     * Will cause patch to run `yum update-minimal` instead.
     * </pre>
     *
     * <code>bool minimal = 2;</code>
     *
     * @return The minimal.
     */
    @java.lang.Override
    public boolean getMinimal() {
      return minimal_;
    }

    public static final int EXCLUDES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList excludes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages are excluded by
     * using the yum `--exclude` flag.
     * </pre>
     *
     * <code>repeated string excludes = 3;</code>
     *
     * @return A list containing the excludes.
     */
    public com.google.protobuf.ProtocolStringList getExcludesList() {
      return excludes_;
    }
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages are excluded by
     * using the yum `--exclude` flag.
     * </pre>
     *
     * <code>repeated string excludes = 3;</code>
     *
     * @return The count of excludes.
     */
    public int getExcludesCount() {
      return excludes_.size();
    }
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages are excluded by
     * using the yum `--exclude` flag.
     * </pre>
     *
     * <code>repeated string excludes = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The excludes at the given index.
     */
    public java.lang.String getExcludes(int index) {
      return excludes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of packages to exclude from update. These packages are excluded by
     * using the yum `--exclude` flag.
     * </pre>
     *
     * <code>repeated string excludes = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludes at the given index.
     */
    public com.google.protobuf.ByteString getExcludesBytes(int index) {
      return excludes_.getByteString(index);
    }

    public static final int EXCLUSIVE_PACKAGES_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList exclusivePackages_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field must not be specified with any other patch
     * configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 4;</code>
     *
     * @return A list containing the exclusivePackages.
     */
    public com.google.protobuf.ProtocolStringList getExclusivePackagesList() {
      return exclusivePackages_;
    }
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field must not be specified with any other patch
     * configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 4;</code>
     *
     * @return The count of exclusivePackages.
     */
    public int getExclusivePackagesCount() {
      return exclusivePackages_.size();
    }
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field must not be specified with any other patch
     * configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The exclusivePackages at the given index.
     */
    public java.lang.String getExclusivePackages(int index) {
      return exclusivePackages_.get(index);
    }
    /**
     *
     *
     * <pre>
     * An exclusive list of packages to be updated. These are the only packages
     * that will be updated. If these packages are not installed, they will be
     * ignored. This field must not be specified with any other patch
     * configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_packages = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the exclusivePackages at the given index.
     */
    public com.google.protobuf.ByteString getExclusivePackagesBytes(int index) {
      return exclusivePackages_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (security_ != false) {
        output.writeBool(1, security_);
      }
      if (minimal_ != false) {
        output.writeBool(2, minimal_);
      }
      for (int i = 0; i < excludes_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, excludes_.getRaw(i));
      }
      for (int i = 0; i < exclusivePackages_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, exclusivePackages_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (security_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, security_);
      }
      if (minimal_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, minimal_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < excludes_.size(); i++) {
          dataSize += computeStringSizeNoTag(excludes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExcludesList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < exclusivePackages_.size(); i++) {
          dataSize += computeStringSizeNoTag(exclusivePackages_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExclusivePackagesList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.YumSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.YumSettings other =
          (com.google.cloud.osconfig.v1.PatchJobs.YumSettings) obj;

      if (getSecurity() != other.getSecurity()) return false;
      if (getMinimal() != other.getMinimal()) return false;
      if (!getExcludesList().equals(other.getExcludesList())) return false;
      if (!getExclusivePackagesList().equals(other.getExclusivePackagesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SECURITY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSecurity());
      hash = (37 * hash) + MINIMAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getMinimal());
      if (getExcludesCount() > 0) {
        hash = (37 * hash) + EXCLUDES_FIELD_NUMBER;
        hash = (53 * hash) + getExcludesList().hashCode();
      }
      if (getExclusivePackagesCount() > 0) {
        hash = (37 * hash) + EXCLUSIVE_PACKAGES_FIELD_NUMBER;
        hash = (53 * hash) + getExclusivePackagesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.YumSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.YumSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.YumSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.YumSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.YumSettings parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.YumSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.YumSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.YumSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.YumSettings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.YumSettings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.YumSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.YumSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.osconfig.v1.PatchJobs.YumSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Yum patching is performed by executing `yum update`. Additional options
     * can be set to control how this is executed.
     *
     * Note that not all settings are supported on all platforms.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.YumSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.YumSettings)
        com.google.cloud.osconfig.v1.PatchJobs.YumSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_YumSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_YumSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.YumSettings.class,
                com.google.cloud.osconfig.v1.PatchJobs.YumSettings.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.YumSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        security_ = false;
        minimal_ = false;
        excludes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        exclusivePackages_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_YumSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.YumSettings getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.YumSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.YumSettings build() {
        com.google.cloud.osconfig.v1.PatchJobs.YumSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.YumSettings buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.YumSettings result =
            new com.google.cloud.osconfig.v1.PatchJobs.YumSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.osconfig.v1.PatchJobs.YumSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.security_ = security_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.minimal_ = minimal_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          excludes_.makeImmutable();
          result.excludes_ = excludes_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          exclusivePackages_.makeImmutable();
          result.exclusivePackages_ = exclusivePackages_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.YumSettings) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.YumSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.YumSettings other) {
        if (other == com.google.cloud.osconfig.v1.PatchJobs.YumSettings.getDefaultInstance())
          return this;
        if (other.getSecurity() != false) {
          setSecurity(other.getSecurity());
        }
        if (other.getMinimal() != false) {
          setMinimal(other.getMinimal());
        }
        if (!other.excludes_.isEmpty()) {
          if (excludes_.isEmpty()) {
            excludes_ = other.excludes_;
            bitField0_ |= 0x00000004;
          } else {
            ensureExcludesIsMutable();
            excludes_.addAll(other.excludes_);
          }
          onChanged();
        }
        if (!other.exclusivePackages_.isEmpty()) {
          if (exclusivePackages_.isEmpty()) {
            exclusivePackages_ = other.exclusivePackages_;
            bitField0_ |= 0x00000008;
          } else {
            ensureExclusivePackagesIsMutable();
            exclusivePackages_.addAll(other.exclusivePackages_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  security_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  minimal_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExcludesIsMutable();
                  excludes_.add(s);
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExclusivePackagesIsMutable();
                  exclusivePackages_.add(s);
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean security_;
      /**
       *
       *
       * <pre>
       * Adds the `--security` flag to `yum update`. Not supported on
       * all platforms.
       * </pre>
       *
       * <code>bool security = 1;</code>
       *
       * @return The security.
       */
      @java.lang.Override
      public boolean getSecurity() {
        return security_;
      }
      /**
       *
       *
       * <pre>
       * Adds the `--security` flag to `yum update`. Not supported on
       * all platforms.
       * </pre>
       *
       * <code>bool security = 1;</code>
       *
       * @param value The security to set.
       * @return This builder for chaining.
       */
      public Builder setSecurity(boolean value) {

        security_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Adds the `--security` flag to `yum update`. Not supported on
       * all platforms.
       * </pre>
       *
       * <code>bool security = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSecurity() {
        bitField0_ = (bitField0_ & ~0x00000001);
        security_ = false;
        onChanged();
        return this;
      }

      private boolean minimal_;
      /**
       *
       *
       * <pre>
       * Will cause patch to run `yum update-minimal` instead.
       * </pre>
       *
       * <code>bool minimal = 2;</code>
       *
       * @return The minimal.
       */
      @java.lang.Override
      public boolean getMinimal() {
        return minimal_;
      }
      /**
       *
       *
       * <pre>
       * Will cause patch to run `yum update-minimal` instead.
       * </pre>
       *
       * <code>bool minimal = 2;</code>
       *
       * @param value The minimal to set.
       * @return This builder for chaining.
       */
      public Builder setMinimal(boolean value) {

        minimal_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Will cause patch to run `yum update-minimal` instead.
       * </pre>
       *
       * <code>bool minimal = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinimal() {
        bitField0_ = (bitField0_ & ~0x00000002);
        minimal_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList excludes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureExcludesIsMutable() {
        if (!excludes_.isModifiable()) {
          excludes_ = new com.google.protobuf.LazyStringArrayList(excludes_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages are excluded by
       * using the yum `--exclude` flag.
       * </pre>
       *
       * <code>repeated string excludes = 3;</code>
       *
       * @return A list containing the excludes.
       */
      public com.google.protobuf.ProtocolStringList getExcludesList() {
        excludes_.makeImmutable();
        return excludes_;
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages are excluded by
       * using the yum `--exclude` flag.
       * </pre>
       *
       * <code>repeated string excludes = 3;</code>
       *
       * @return The count of excludes.
       */
      public int getExcludesCount() {
        return excludes_.size();
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages are excluded by
       * using the yum `--exclude` flag.
       * </pre>
       *
       * <code>repeated string excludes = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The excludes at the given index.
       */
      public java.lang.String getExcludes(int index) {
        return excludes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages are excluded by
       * using the yum `--exclude` flag.
       * </pre>
       *
       * <code>repeated string excludes = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the excludes at the given index.
       */
      public com.google.protobuf.ByteString getExcludesBytes(int index) {
        return excludes_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages are excluded by
       * using the yum `--exclude` flag.
       * </pre>
       *
       * <code>repeated string excludes = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The excludes to set.
       * @return This builder for chaining.
       */
      public Builder setExcludes(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludesIsMutable();
        excludes_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages are excluded by
       * using the yum `--exclude` flag.
       * </pre>
       *
       * <code>repeated string excludes = 3;</code>
       *
       * @param value The excludes to add.
       * @return This builder for chaining.
       */
      public Builder addExcludes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludesIsMutable();
        excludes_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages are excluded by
       * using the yum `--exclude` flag.
       * </pre>
       *
       * <code>repeated string excludes = 3;</code>
       *
       * @param values The excludes to add.
       * @return This builder for chaining.
       */
      public Builder addAllExcludes(java.lang.Iterable<java.lang.String> values) {
        ensureExcludesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludes_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages are excluded by
       * using the yum `--exclude` flag.
       * </pre>
       *
       * <code>repeated string excludes = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExcludes() {
        excludes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of packages to exclude from update. These packages are excluded by
       * using the yum `--exclude` flag.
       * </pre>
       *
       * <code>repeated string excludes = 3;</code>
       *
       * @param value The bytes of the excludes to add.
       * @return This builder for chaining.
       */
      public Builder addExcludesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExcludesIsMutable();
        excludes_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList exclusivePackages_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureExclusivePackagesIsMutable() {
        if (!exclusivePackages_.isModifiable()) {
          exclusivePackages_ = new com.google.protobuf.LazyStringArrayList(exclusivePackages_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field must not be specified with any other patch
       * configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 4;</code>
       *
       * @return A list containing the exclusivePackages.
       */
      public com.google.protobuf.ProtocolStringList getExclusivePackagesList() {
        exclusivePackages_.makeImmutable();
        return exclusivePackages_;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field must not be specified with any other patch
       * configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 4;</code>
       *
       * @return The count of exclusivePackages.
       */
      public int getExclusivePackagesCount() {
        return exclusivePackages_.size();
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field must not be specified with any other patch
       * configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 4;</code>
       *
       * @param index The index of the element to return.
       * @return The exclusivePackages at the given index.
       */
      public java.lang.String getExclusivePackages(int index) {
        return exclusivePackages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field must not be specified with any other patch
       * configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 4;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the exclusivePackages at the given index.
       */
      public com.google.protobuf.ByteString getExclusivePackagesBytes(int index) {
        return exclusivePackages_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field must not be specified with any other patch
       * configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 4;</code>
       *
       * @param index The index to set the value at.
       * @param value The exclusivePackages to set.
       * @return This builder for chaining.
       */
      public Builder setExclusivePackages(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusivePackagesIsMutable();
        exclusivePackages_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field must not be specified with any other patch
       * configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 4;</code>
       *
       * @param value The exclusivePackages to add.
       * @return This builder for chaining.
       */
      public Builder addExclusivePackages(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusivePackagesIsMutable();
        exclusivePackages_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field must not be specified with any other patch
       * configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 4;</code>
       *
       * @param values The exclusivePackages to add.
       * @return This builder for chaining.
       */
      public Builder addAllExclusivePackages(java.lang.Iterable<java.lang.String> values) {
        ensureExclusivePackagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exclusivePackages_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field must not be specified with any other patch
       * configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExclusivePackages() {
        exclusivePackages_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of packages to be updated. These are the only packages
       * that will be updated. If these packages are not installed, they will be
       * ignored. This field must not be specified with any other patch
       * configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_packages = 4;</code>
       *
       * @param value The bytes of the exclusivePackages to add.
       * @return This builder for chaining.
       */
      public Builder addExclusivePackagesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExclusivePackagesIsMutable();
        exclusivePackages_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.YumSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.YumSettings)
    private static final com.google.cloud.osconfig.v1.PatchJobs.YumSettings DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.YumSettings();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.YumSettings getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<YumSettings> PARSER =
        new com.google.protobuf.AbstractParser<YumSettings>() {
          @java.lang.Override
          public YumSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<YumSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<YumSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.YumSettings getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GooSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.GooSettings)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Googet patching is performed by running `googet update`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.GooSettings}
   */
  public static final class GooSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.GooSettings)
      GooSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GooSettings.newBuilder() to construct.
    private GooSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GooSettings() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GooSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_GooSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_GooSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.GooSettings.class,
              com.google.cloud.osconfig.v1.PatchJobs.GooSettings.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.GooSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.GooSettings other =
          (com.google.cloud.osconfig.v1.PatchJobs.GooSettings) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GooSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GooSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GooSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GooSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GooSettings parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GooSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GooSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GooSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GooSettings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GooSettings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GooSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GooSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.osconfig.v1.PatchJobs.GooSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Googet patching is performed by running `googet update`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.GooSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.GooSettings)
        com.google.cloud.osconfig.v1.PatchJobs.GooSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_GooSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_GooSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.GooSettings.class,
                com.google.cloud.osconfig.v1.PatchJobs.GooSettings.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.GooSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_GooSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.GooSettings getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.GooSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.GooSettings build() {
        com.google.cloud.osconfig.v1.PatchJobs.GooSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.GooSettings buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.GooSettings result =
            new com.google.cloud.osconfig.v1.PatchJobs.GooSettings(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.GooSettings) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.GooSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.GooSettings other) {
        if (other == com.google.cloud.osconfig.v1.PatchJobs.GooSettings.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.GooSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.GooSettings)
    private static final com.google.cloud.osconfig.v1.PatchJobs.GooSettings DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.GooSettings();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.GooSettings getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GooSettings> PARSER =
        new com.google.protobuf.AbstractParser<GooSettings>() {
          @java.lang.Override
          public GooSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GooSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GooSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.GooSettings getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ZypperSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.ZypperSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Adds the `--with-optional` flag to `zypper patch`.
     * </pre>
     *
     * <code>bool with_optional = 1;</code>
     *
     * @return The withOptional.
     */
    boolean getWithOptional();

    /**
     *
     *
     * <pre>
     * Adds the `--with-update` flag, to `zypper patch`.
     * </pre>
     *
     * <code>bool with_update = 2;</code>
     *
     * @return The withUpdate.
     */
    boolean getWithUpdate();

    /**
     *
     *
     * <pre>
     * Install only patches with these categories.
     * Common categories include security, recommended, and feature.
     * </pre>
     *
     * <code>repeated string categories = 3;</code>
     *
     * @return A list containing the categories.
     */
    java.util.List<java.lang.String> getCategoriesList();
    /**
     *
     *
     * <pre>
     * Install only patches with these categories.
     * Common categories include security, recommended, and feature.
     * </pre>
     *
     * <code>repeated string categories = 3;</code>
     *
     * @return The count of categories.
     */
    int getCategoriesCount();
    /**
     *
     *
     * <pre>
     * Install only patches with these categories.
     * Common categories include security, recommended, and feature.
     * </pre>
     *
     * <code>repeated string categories = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The categories at the given index.
     */
    java.lang.String getCategories(int index);
    /**
     *
     *
     * <pre>
     * Install only patches with these categories.
     * Common categories include security, recommended, and feature.
     * </pre>
     *
     * <code>repeated string categories = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the categories at the given index.
     */
    com.google.protobuf.ByteString getCategoriesBytes(int index);

    /**
     *
     *
     * <pre>
     * Install only patches with these severities.
     * Common severities include critical, important, moderate, and low.
     * </pre>
     *
     * <code>repeated string severities = 4;</code>
     *
     * @return A list containing the severities.
     */
    java.util.List<java.lang.String> getSeveritiesList();
    /**
     *
     *
     * <pre>
     * Install only patches with these severities.
     * Common severities include critical, important, moderate, and low.
     * </pre>
     *
     * <code>repeated string severities = 4;</code>
     *
     * @return The count of severities.
     */
    int getSeveritiesCount();
    /**
     *
     *
     * <pre>
     * Install only patches with these severities.
     * Common severities include critical, important, moderate, and low.
     * </pre>
     *
     * <code>repeated string severities = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The severities at the given index.
     */
    java.lang.String getSeverities(int index);
    /**
     *
     *
     * <pre>
     * Install only patches with these severities.
     * Common severities include critical, important, moderate, and low.
     * </pre>
     *
     * <code>repeated string severities = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the severities at the given index.
     */
    com.google.protobuf.ByteString getSeveritiesBytes(int index);

    /**
     *
     *
     * <pre>
     * List of patches to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 5;</code>
     *
     * @return A list containing the excludes.
     */
    java.util.List<java.lang.String> getExcludesList();
    /**
     *
     *
     * <pre>
     * List of patches to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 5;</code>
     *
     * @return The count of excludes.
     */
    int getExcludesCount();
    /**
     *
     *
     * <pre>
     * List of patches to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The excludes at the given index.
     */
    java.lang.String getExcludes(int index);
    /**
     *
     *
     * <pre>
     * List of patches to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludes at the given index.
     */
    com.google.protobuf.ByteString getExcludesBytes(int index);

    /**
     *
     *
     * <pre>
     * An exclusive list of patches to be updated. These are the only patches
     * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
     * This field must not be used with any other patch configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 6;</code>
     *
     * @return A list containing the exclusivePatches.
     */
    java.util.List<java.lang.String> getExclusivePatchesList();
    /**
     *
     *
     * <pre>
     * An exclusive list of patches to be updated. These are the only patches
     * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
     * This field must not be used with any other patch configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 6;</code>
     *
     * @return The count of exclusivePatches.
     */
    int getExclusivePatchesCount();
    /**
     *
     *
     * <pre>
     * An exclusive list of patches to be updated. These are the only patches
     * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
     * This field must not be used with any other patch configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The exclusivePatches at the given index.
     */
    java.lang.String getExclusivePatches(int index);
    /**
     *
     *
     * <pre>
     * An exclusive list of patches to be updated. These are the only patches
     * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
     * This field must not be used with any other patch configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the exclusivePatches at the given index.
     */
    com.google.protobuf.ByteString getExclusivePatchesBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Zypper patching is performed by running `zypper patch`.
   * See also https://en.opensuse.org/SDB:Zypper_manual.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.ZypperSettings}
   */
  public static final class ZypperSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.ZypperSettings)
      ZypperSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ZypperSettings.newBuilder() to construct.
    private ZypperSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ZypperSettings() {
      categories_ = com.google.protobuf.LazyStringArrayList.emptyList();
      severities_ = com.google.protobuf.LazyStringArrayList.emptyList();
      excludes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      exclusivePatches_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ZypperSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ZypperSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ZypperSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.class,
              com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.Builder.class);
    }

    public static final int WITH_OPTIONAL_FIELD_NUMBER = 1;
    private boolean withOptional_ = false;
    /**
     *
     *
     * <pre>
     * Adds the `--with-optional` flag to `zypper patch`.
     * </pre>
     *
     * <code>bool with_optional = 1;</code>
     *
     * @return The withOptional.
     */
    @java.lang.Override
    public boolean getWithOptional() {
      return withOptional_;
    }

    public static final int WITH_UPDATE_FIELD_NUMBER = 2;
    private boolean withUpdate_ = false;
    /**
     *
     *
     * <pre>
     * Adds the `--with-update` flag, to `zypper patch`.
     * </pre>
     *
     * <code>bool with_update = 2;</code>
     *
     * @return The withUpdate.
     */
    @java.lang.Override
    public boolean getWithUpdate() {
      return withUpdate_;
    }

    public static final int CATEGORIES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList categories_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Install only patches with these categories.
     * Common categories include security, recommended, and feature.
     * </pre>
     *
     * <code>repeated string categories = 3;</code>
     *
     * @return A list containing the categories.
     */
    public com.google.protobuf.ProtocolStringList getCategoriesList() {
      return categories_;
    }
    /**
     *
     *
     * <pre>
     * Install only patches with these categories.
     * Common categories include security, recommended, and feature.
     * </pre>
     *
     * <code>repeated string categories = 3;</code>
     *
     * @return The count of categories.
     */
    public int getCategoriesCount() {
      return categories_.size();
    }
    /**
     *
     *
     * <pre>
     * Install only patches with these categories.
     * Common categories include security, recommended, and feature.
     * </pre>
     *
     * <code>repeated string categories = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The categories at the given index.
     */
    public java.lang.String getCategories(int index) {
      return categories_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Install only patches with these categories.
     * Common categories include security, recommended, and feature.
     * </pre>
     *
     * <code>repeated string categories = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the categories at the given index.
     */
    public com.google.protobuf.ByteString getCategoriesBytes(int index) {
      return categories_.getByteString(index);
    }

    public static final int SEVERITIES_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList severities_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Install only patches with these severities.
     * Common severities include critical, important, moderate, and low.
     * </pre>
     *
     * <code>repeated string severities = 4;</code>
     *
     * @return A list containing the severities.
     */
    public com.google.protobuf.ProtocolStringList getSeveritiesList() {
      return severities_;
    }
    /**
     *
     *
     * <pre>
     * Install only patches with these severities.
     * Common severities include critical, important, moderate, and low.
     * </pre>
     *
     * <code>repeated string severities = 4;</code>
     *
     * @return The count of severities.
     */
    public int getSeveritiesCount() {
      return severities_.size();
    }
    /**
     *
     *
     * <pre>
     * Install only patches with these severities.
     * Common severities include critical, important, moderate, and low.
     * </pre>
     *
     * <code>repeated string severities = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The severities at the given index.
     */
    public java.lang.String getSeverities(int index) {
      return severities_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Install only patches with these severities.
     * Common severities include critical, important, moderate, and low.
     * </pre>
     *
     * <code>repeated string severities = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the severities at the given index.
     */
    public com.google.protobuf.ByteString getSeveritiesBytes(int index) {
      return severities_.getByteString(index);
    }

    public static final int EXCLUDES_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList excludes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of patches to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 5;</code>
     *
     * @return A list containing the excludes.
     */
    public com.google.protobuf.ProtocolStringList getExcludesList() {
      return excludes_;
    }
    /**
     *
     *
     * <pre>
     * List of patches to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 5;</code>
     *
     * @return The count of excludes.
     */
    public int getExcludesCount() {
      return excludes_.size();
    }
    /**
     *
     *
     * <pre>
     * List of patches to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The excludes at the given index.
     */
    public java.lang.String getExcludes(int index) {
      return excludes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of patches to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludes at the given index.
     */
    public com.google.protobuf.ByteString getExcludesBytes(int index) {
      return excludes_.getByteString(index);
    }

    public static final int EXCLUSIVE_PATCHES_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList exclusivePatches_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * An exclusive list of patches to be updated. These are the only patches
     * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
     * This field must not be used with any other patch configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 6;</code>
     *
     * @return A list containing the exclusivePatches.
     */
    public com.google.protobuf.ProtocolStringList getExclusivePatchesList() {
      return exclusivePatches_;
    }
    /**
     *
     *
     * <pre>
     * An exclusive list of patches to be updated. These are the only patches
     * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
     * This field must not be used with any other patch configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 6;</code>
     *
     * @return The count of exclusivePatches.
     */
    public int getExclusivePatchesCount() {
      return exclusivePatches_.size();
    }
    /**
     *
     *
     * <pre>
     * An exclusive list of patches to be updated. These are the only patches
     * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
     * This field must not be used with any other patch configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The exclusivePatches at the given index.
     */
    public java.lang.String getExclusivePatches(int index) {
      return exclusivePatches_.get(index);
    }
    /**
     *
     *
     * <pre>
     * An exclusive list of patches to be updated. These are the only patches
     * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
     * This field must not be used with any other patch configuration fields.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the exclusivePatches at the given index.
     */
    public com.google.protobuf.ByteString getExclusivePatchesBytes(int index) {
      return exclusivePatches_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (withOptional_ != false) {
        output.writeBool(1, withOptional_);
      }
      if (withUpdate_ != false) {
        output.writeBool(2, withUpdate_);
      }
      for (int i = 0; i < categories_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, categories_.getRaw(i));
      }
      for (int i = 0; i < severities_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, severities_.getRaw(i));
      }
      for (int i = 0; i < excludes_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, excludes_.getRaw(i));
      }
      for (int i = 0; i < exclusivePatches_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, exclusivePatches_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (withOptional_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, withOptional_);
      }
      if (withUpdate_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, withUpdate_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < categories_.size(); i++) {
          dataSize += computeStringSizeNoTag(categories_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getCategoriesList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < severities_.size(); i++) {
          dataSize += computeStringSizeNoTag(severities_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getSeveritiesList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < excludes_.size(); i++) {
          dataSize += computeStringSizeNoTag(excludes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExcludesList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < exclusivePatches_.size(); i++) {
          dataSize += computeStringSizeNoTag(exclusivePatches_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExclusivePatchesList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings other =
          (com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings) obj;

      if (getWithOptional() != other.getWithOptional()) return false;
      if (getWithUpdate() != other.getWithUpdate()) return false;
      if (!getCategoriesList().equals(other.getCategoriesList())) return false;
      if (!getSeveritiesList().equals(other.getSeveritiesList())) return false;
      if (!getExcludesList().equals(other.getExcludesList())) return false;
      if (!getExclusivePatchesList().equals(other.getExclusivePatchesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + WITH_OPTIONAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getWithOptional());
      hash = (37 * hash) + WITH_UPDATE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getWithUpdate());
      if (getCategoriesCount() > 0) {
        hash = (37 * hash) + CATEGORIES_FIELD_NUMBER;
        hash = (53 * hash) + getCategoriesList().hashCode();
      }
      if (getSeveritiesCount() > 0) {
        hash = (37 * hash) + SEVERITIES_FIELD_NUMBER;
        hash = (53 * hash) + getSeveritiesList().hashCode();
      }
      if (getExcludesCount() > 0) {
        hash = (37 * hash) + EXCLUDES_FIELD_NUMBER;
        hash = (53 * hash) + getExcludesList().hashCode();
      }
      if (getExclusivePatchesCount() > 0) {
        hash = (37 * hash) + EXCLUSIVE_PATCHES_FIELD_NUMBER;
        hash = (53 * hash) + getExclusivePatchesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Zypper patching is performed by running `zypper patch`.
     * See also https://en.opensuse.org/SDB:Zypper_manual.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.ZypperSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.ZypperSettings)
        com.google.cloud.osconfig.v1.PatchJobs.ZypperSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ZypperSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ZypperSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.class,
                com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        withOptional_ = false;
        withUpdate_ = false;
        categories_ = com.google.protobuf.LazyStringArrayList.emptyList();
        severities_ = com.google.protobuf.LazyStringArrayList.emptyList();
        excludes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        exclusivePatches_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ZypperSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings build() {
        com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings result =
            new com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.withOptional_ = withOptional_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.withUpdate_ = withUpdate_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          categories_.makeImmutable();
          result.categories_ = categories_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          severities_.makeImmutable();
          result.severities_ = severities_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          excludes_.makeImmutable();
          result.excludes_ = excludes_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          exclusivePatches_.makeImmutable();
          result.exclusivePatches_ = exclusivePatches_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings other) {
        if (other == com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings.getDefaultInstance())
          return this;
        if (other.getWithOptional() != false) {
          setWithOptional(other.getWithOptional());
        }
        if (other.getWithUpdate() != false) {
          setWithUpdate(other.getWithUpdate());
        }
        if (!other.categories_.isEmpty()) {
          if (categories_.isEmpty()) {
            categories_ = other.categories_;
            bitField0_ |= 0x00000004;
          } else {
            ensureCategoriesIsMutable();
            categories_.addAll(other.categories_);
          }
          onChanged();
        }
        if (!other.severities_.isEmpty()) {
          if (severities_.isEmpty()) {
            severities_ = other.severities_;
            bitField0_ |= 0x00000008;
          } else {
            ensureSeveritiesIsMutable();
            severities_.addAll(other.severities_);
          }
          onChanged();
        }
        if (!other.excludes_.isEmpty()) {
          if (excludes_.isEmpty()) {
            excludes_ = other.excludes_;
            bitField0_ |= 0x00000010;
          } else {
            ensureExcludesIsMutable();
            excludes_.addAll(other.excludes_);
          }
          onChanged();
        }
        if (!other.exclusivePatches_.isEmpty()) {
          if (exclusivePatches_.isEmpty()) {
            exclusivePatches_ = other.exclusivePatches_;
            bitField0_ |= 0x00000020;
          } else {
            ensureExclusivePatchesIsMutable();
            exclusivePatches_.addAll(other.exclusivePatches_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  withOptional_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  withUpdate_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureCategoriesIsMutable();
                  categories_.add(s);
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureSeveritiesIsMutable();
                  severities_.add(s);
                  break;
                } // case 34
              case 42:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExcludesIsMutable();
                  excludes_.add(s);
                  break;
                } // case 42
              case 50:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExclusivePatchesIsMutable();
                  exclusivePatches_.add(s);
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean withOptional_;
      /**
       *
       *
       * <pre>
       * Adds the `--with-optional` flag to `zypper patch`.
       * </pre>
       *
       * <code>bool with_optional = 1;</code>
       *
       * @return The withOptional.
       */
      @java.lang.Override
      public boolean getWithOptional() {
        return withOptional_;
      }
      /**
       *
       *
       * <pre>
       * Adds the `--with-optional` flag to `zypper patch`.
       * </pre>
       *
       * <code>bool with_optional = 1;</code>
       *
       * @param value The withOptional to set.
       * @return This builder for chaining.
       */
      public Builder setWithOptional(boolean value) {

        withOptional_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Adds the `--with-optional` flag to `zypper patch`.
       * </pre>
       *
       * <code>bool with_optional = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWithOptional() {
        bitField0_ = (bitField0_ & ~0x00000001);
        withOptional_ = false;
        onChanged();
        return this;
      }

      private boolean withUpdate_;
      /**
       *
       *
       * <pre>
       * Adds the `--with-update` flag, to `zypper patch`.
       * </pre>
       *
       * <code>bool with_update = 2;</code>
       *
       * @return The withUpdate.
       */
      @java.lang.Override
      public boolean getWithUpdate() {
        return withUpdate_;
      }
      /**
       *
       *
       * <pre>
       * Adds the `--with-update` flag, to `zypper patch`.
       * </pre>
       *
       * <code>bool with_update = 2;</code>
       *
       * @param value The withUpdate to set.
       * @return This builder for chaining.
       */
      public Builder setWithUpdate(boolean value) {

        withUpdate_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Adds the `--with-update` flag, to `zypper patch`.
       * </pre>
       *
       * <code>bool with_update = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWithUpdate() {
        bitField0_ = (bitField0_ & ~0x00000002);
        withUpdate_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList categories_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureCategoriesIsMutable() {
        if (!categories_.isModifiable()) {
          categories_ = new com.google.protobuf.LazyStringArrayList(categories_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these categories.
       * Common categories include security, recommended, and feature.
       * </pre>
       *
       * <code>repeated string categories = 3;</code>
       *
       * @return A list containing the categories.
       */
      public com.google.protobuf.ProtocolStringList getCategoriesList() {
        categories_.makeImmutable();
        return categories_;
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these categories.
       * Common categories include security, recommended, and feature.
       * </pre>
       *
       * <code>repeated string categories = 3;</code>
       *
       * @return The count of categories.
       */
      public int getCategoriesCount() {
        return categories_.size();
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these categories.
       * Common categories include security, recommended, and feature.
       * </pre>
       *
       * <code>repeated string categories = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The categories at the given index.
       */
      public java.lang.String getCategories(int index) {
        return categories_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these categories.
       * Common categories include security, recommended, and feature.
       * </pre>
       *
       * <code>repeated string categories = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the categories at the given index.
       */
      public com.google.protobuf.ByteString getCategoriesBytes(int index) {
        return categories_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these categories.
       * Common categories include security, recommended, and feature.
       * </pre>
       *
       * <code>repeated string categories = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The categories to set.
       * @return This builder for chaining.
       */
      public Builder setCategories(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCategoriesIsMutable();
        categories_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these categories.
       * Common categories include security, recommended, and feature.
       * </pre>
       *
       * <code>repeated string categories = 3;</code>
       *
       * @param value The categories to add.
       * @return This builder for chaining.
       */
      public Builder addCategories(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCategoriesIsMutable();
        categories_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these categories.
       * Common categories include security, recommended, and feature.
       * </pre>
       *
       * <code>repeated string categories = 3;</code>
       *
       * @param values The categories to add.
       * @return This builder for chaining.
       */
      public Builder addAllCategories(java.lang.Iterable<java.lang.String> values) {
        ensureCategoriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, categories_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these categories.
       * Common categories include security, recommended, and feature.
       * </pre>
       *
       * <code>repeated string categories = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCategories() {
        categories_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these categories.
       * Common categories include security, recommended, and feature.
       * </pre>
       *
       * <code>repeated string categories = 3;</code>
       *
       * @param value The bytes of the categories to add.
       * @return This builder for chaining.
       */
      public Builder addCategoriesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureCategoriesIsMutable();
        categories_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList severities_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureSeveritiesIsMutable() {
        if (!severities_.isModifiable()) {
          severities_ = new com.google.protobuf.LazyStringArrayList(severities_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these severities.
       * Common severities include critical, important, moderate, and low.
       * </pre>
       *
       * <code>repeated string severities = 4;</code>
       *
       * @return A list containing the severities.
       */
      public com.google.protobuf.ProtocolStringList getSeveritiesList() {
        severities_.makeImmutable();
        return severities_;
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these severities.
       * Common severities include critical, important, moderate, and low.
       * </pre>
       *
       * <code>repeated string severities = 4;</code>
       *
       * @return The count of severities.
       */
      public int getSeveritiesCount() {
        return severities_.size();
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these severities.
       * Common severities include critical, important, moderate, and low.
       * </pre>
       *
       * <code>repeated string severities = 4;</code>
       *
       * @param index The index of the element to return.
       * @return The severities at the given index.
       */
      public java.lang.String getSeverities(int index) {
        return severities_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these severities.
       * Common severities include critical, important, moderate, and low.
       * </pre>
       *
       * <code>repeated string severities = 4;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the severities at the given index.
       */
      public com.google.protobuf.ByteString getSeveritiesBytes(int index) {
        return severities_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these severities.
       * Common severities include critical, important, moderate, and low.
       * </pre>
       *
       * <code>repeated string severities = 4;</code>
       *
       * @param index The index to set the value at.
       * @param value The severities to set.
       * @return This builder for chaining.
       */
      public Builder setSeverities(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSeveritiesIsMutable();
        severities_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these severities.
       * Common severities include critical, important, moderate, and low.
       * </pre>
       *
       * <code>repeated string severities = 4;</code>
       *
       * @param value The severities to add.
       * @return This builder for chaining.
       */
      public Builder addSeverities(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSeveritiesIsMutable();
        severities_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these severities.
       * Common severities include critical, important, moderate, and low.
       * </pre>
       *
       * <code>repeated string severities = 4;</code>
       *
       * @param values The severities to add.
       * @return This builder for chaining.
       */
      public Builder addAllSeverities(java.lang.Iterable<java.lang.String> values) {
        ensureSeveritiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, severities_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these severities.
       * Common severities include critical, important, moderate, and low.
       * </pre>
       *
       * <code>repeated string severities = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSeverities() {
        severities_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Install only patches with these severities.
       * Common severities include critical, important, moderate, and low.
       * </pre>
       *
       * <code>repeated string severities = 4;</code>
       *
       * @param value The bytes of the severities to add.
       * @return This builder for chaining.
       */
      public Builder addSeveritiesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureSeveritiesIsMutable();
        severities_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList excludes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureExcludesIsMutable() {
        if (!excludes_.isModifiable()) {
          excludes_ = new com.google.protobuf.LazyStringArrayList(excludes_);
        }
        bitField0_ |= 0x00000010;
      }
      /**
       *
       *
       * <pre>
       * List of patches to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 5;</code>
       *
       * @return A list containing the excludes.
       */
      public com.google.protobuf.ProtocolStringList getExcludesList() {
        excludes_.makeImmutable();
        return excludes_;
      }
      /**
       *
       *
       * <pre>
       * List of patches to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 5;</code>
       *
       * @return The count of excludes.
       */
      public int getExcludesCount() {
        return excludes_.size();
      }
      /**
       *
       *
       * <pre>
       * List of patches to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 5;</code>
       *
       * @param index The index of the element to return.
       * @return The excludes at the given index.
       */
      public java.lang.String getExcludes(int index) {
        return excludes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of patches to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 5;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the excludes at the given index.
       */
      public com.google.protobuf.ByteString getExcludesBytes(int index) {
        return excludes_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of patches to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 5;</code>
       *
       * @param index The index to set the value at.
       * @param value The excludes to set.
       * @return This builder for chaining.
       */
      public Builder setExcludes(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludesIsMutable();
        excludes_.set(index, value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of patches to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 5;</code>
       *
       * @param value The excludes to add.
       * @return This builder for chaining.
       */
      public Builder addExcludes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludesIsMutable();
        excludes_.add(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of patches to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 5;</code>
       *
       * @param values The excludes to add.
       * @return This builder for chaining.
       */
      public Builder addAllExcludes(java.lang.Iterable<java.lang.String> values) {
        ensureExcludesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludes_);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of patches to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExcludes() {
        excludes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of patches to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 5;</code>
       *
       * @param value The bytes of the excludes to add.
       * @return This builder for chaining.
       */
      public Builder addExcludesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExcludesIsMutable();
        excludes_.add(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList exclusivePatches_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureExclusivePatchesIsMutable() {
        if (!exclusivePatches_.isModifiable()) {
          exclusivePatches_ = new com.google.protobuf.LazyStringArrayList(exclusivePatches_);
        }
        bitField0_ |= 0x00000020;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of patches to be updated. These are the only patches
       * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
       * This field must not be used with any other patch configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 6;</code>
       *
       * @return A list containing the exclusivePatches.
       */
      public com.google.protobuf.ProtocolStringList getExclusivePatchesList() {
        exclusivePatches_.makeImmutable();
        return exclusivePatches_;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of patches to be updated. These are the only patches
       * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
       * This field must not be used with any other patch configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 6;</code>
       *
       * @return The count of exclusivePatches.
       */
      public int getExclusivePatchesCount() {
        return exclusivePatches_.size();
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of patches to be updated. These are the only patches
       * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
       * This field must not be used with any other patch configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 6;</code>
       *
       * @param index The index of the element to return.
       * @return The exclusivePatches at the given index.
       */
      public java.lang.String getExclusivePatches(int index) {
        return exclusivePatches_.get(index);
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of patches to be updated. These are the only patches
       * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
       * This field must not be used with any other patch configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 6;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the exclusivePatches at the given index.
       */
      public com.google.protobuf.ByteString getExclusivePatchesBytes(int index) {
        return exclusivePatches_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of patches to be updated. These are the only patches
       * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
       * This field must not be used with any other patch configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 6;</code>
       *
       * @param index The index to set the value at.
       * @param value The exclusivePatches to set.
       * @return This builder for chaining.
       */
      public Builder setExclusivePatches(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusivePatchesIsMutable();
        exclusivePatches_.set(index, value);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of patches to be updated. These are the only patches
       * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
       * This field must not be used with any other patch configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 6;</code>
       *
       * @param value The exclusivePatches to add.
       * @return This builder for chaining.
       */
      public Builder addExclusivePatches(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusivePatchesIsMutable();
        exclusivePatches_.add(value);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of patches to be updated. These are the only patches
       * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
       * This field must not be used with any other patch configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 6;</code>
       *
       * @param values The exclusivePatches to add.
       * @return This builder for chaining.
       */
      public Builder addAllExclusivePatches(java.lang.Iterable<java.lang.String> values) {
        ensureExclusivePatchesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exclusivePatches_);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of patches to be updated. These are the only patches
       * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
       * This field must not be used with any other patch configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExclusivePatches() {
        exclusivePatches_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of patches to be updated. These are the only patches
       * that will be installed using 'zypper patch patch:&lt;patch_name&gt;' command.
       * This field must not be used with any other patch configuration fields.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 6;</code>
       *
       * @param value The bytes of the exclusivePatches to add.
       * @return This builder for chaining.
       */
      public Builder addExclusivePatchesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExclusivePatchesIsMutable();
        exclusivePatches_.add(value);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.ZypperSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.ZypperSettings)
    private static final com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ZypperSettings> PARSER =
        new com.google.protobuf.AbstractParser<ZypperSettings>() {
          @java.lang.Override
          public ZypperSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ZypperSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ZypperSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ZypperSettings getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WindowsUpdateSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.WindowsUpdateSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Only apply updates of these windows update classifications. If empty, all
     * updates are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
     * </code>
     *
     * @return A list containing the classifications.
     */
    java.util.List<com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification>
        getClassificationsList();
    /**
     *
     *
     * <pre>
     * Only apply updates of these windows update classifications. If empty, all
     * updates are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
     * </code>
     *
     * @return The count of classifications.
     */
    int getClassificationsCount();
    /**
     *
     *
     * <pre>
     * Only apply updates of these windows update classifications. If empty, all
     * updates are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The classifications at the given index.
     */
    com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification getClassifications(
        int index);
    /**
     *
     *
     * <pre>
     * Only apply updates of these windows update classifications. If empty, all
     * updates are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for classifications.
     */
    java.util.List<java.lang.Integer> getClassificationsValueList();
    /**
     *
     *
     * <pre>
     * Only apply updates of these windows update classifications. If empty, all
     * updates are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of classifications at the given index.
     */
    int getClassificationsValue(int index);

    /**
     *
     *
     * <pre>
     * List of KBs to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @return A list containing the excludes.
     */
    java.util.List<java.lang.String> getExcludesList();
    /**
     *
     *
     * <pre>
     * List of KBs to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @return The count of excludes.
     */
    int getExcludesCount();
    /**
     *
     *
     * <pre>
     * List of KBs to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The excludes at the given index.
     */
    java.lang.String getExcludes(int index);
    /**
     *
     *
     * <pre>
     * List of KBs to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludes at the given index.
     */
    com.google.protobuf.ByteString getExcludesBytes(int index);

    /**
     *
     *
     * <pre>
     * An exclusive list of kbs to be updated. These are the only patches
     * that will be updated. This field must not be used with other
     * patch configurations.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 3;</code>
     *
     * @return A list containing the exclusivePatches.
     */
    java.util.List<java.lang.String> getExclusivePatchesList();
    /**
     *
     *
     * <pre>
     * An exclusive list of kbs to be updated. These are the only patches
     * that will be updated. This field must not be used with other
     * patch configurations.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 3;</code>
     *
     * @return The count of exclusivePatches.
     */
    int getExclusivePatchesCount();
    /**
     *
     *
     * <pre>
     * An exclusive list of kbs to be updated. These are the only patches
     * that will be updated. This field must not be used with other
     * patch configurations.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The exclusivePatches at the given index.
     */
    java.lang.String getExclusivePatches(int index);
    /**
     *
     *
     * <pre>
     * An exclusive list of kbs to be updated. These are the only patches
     * that will be updated. This field must not be used with other
     * patch configurations.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the exclusivePatches at the given index.
     */
    com.google.protobuf.ByteString getExclusivePatchesBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Windows patching is performed using the Windows Update Agent.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.WindowsUpdateSettings}
   */
  public static final class WindowsUpdateSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.WindowsUpdateSettings)
      WindowsUpdateSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WindowsUpdateSettings.newBuilder() to construct.
    private WindowsUpdateSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WindowsUpdateSettings() {
      classifications_ = java.util.Collections.emptyList();
      excludes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      exclusivePatches_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WindowsUpdateSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_WindowsUpdateSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_WindowsUpdateSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.class,
              com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Microsoft Windows update classifications as defined in
     * [1]
     * https://support.microsoft.com/en-us/help/824684/description-of-the-standard-terminology-that-is-used-to-describe-micro
     * </pre>
     *
     * Protobuf enum {@code google.cloud.osconfig.v1.WindowsUpdateSettings.Classification}
     */
    public enum Classification implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Invalid. If classifications are included, they must be specified.
       * </pre>
       *
       * <code>CLASSIFICATION_UNSPECIFIED = 0;</code>
       */
      CLASSIFICATION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * "A widely released fix for a specific problem that addresses a critical,
       * non-security-related bug." [1]
       * </pre>
       *
       * <code>CRITICAL = 1;</code>
       */
      CRITICAL(1),
      /**
       *
       *
       * <pre>
       * "A widely released fix for a product-specific, security-related
       * vulnerability. Security vulnerabilities are rated by their severity. The
       * severity rating is indicated in the Microsoft security bulletin as
       * critical, important, moderate, or low." [1]
       * </pre>
       *
       * <code>SECURITY = 2;</code>
       */
      SECURITY(2),
      /**
       *
       *
       * <pre>
       * "A widely released and frequent software update that contains additions
       * to a product's definition database. Definition databases are often used
       * to detect objects that have specific attributes, such as malicious code,
       * phishing websites, or junk mail." [1]
       * </pre>
       *
       * <code>DEFINITION = 3;</code>
       */
      DEFINITION(3),
      /**
       *
       *
       * <pre>
       * "Software that controls the input and output of a device." [1]
       * </pre>
       *
       * <code>DRIVER = 4;</code>
       */
      DRIVER(4),
      /**
       *
       *
       * <pre>
       * "New product functionality that is first distributed outside the context
       * of a product release and that is typically included in the next full
       * product release." [1]
       * </pre>
       *
       * <code>FEATURE_PACK = 5;</code>
       */
      FEATURE_PACK(5),
      /**
       *
       *
       * <pre>
       * "A tested, cumulative set of all hotfixes, security updates, critical
       * updates, and updates. Additionally, service packs may contain additional
       * fixes for problems that are found internally since the release of the
       * product. Service packs my also contain a limited number of
       * customer-requested design changes or features." [1]
       * </pre>
       *
       * <code>SERVICE_PACK = 6;</code>
       */
      SERVICE_PACK(6),
      /**
       *
       *
       * <pre>
       * "A utility or feature that helps complete a task or set of tasks." [1]
       * </pre>
       *
       * <code>TOOL = 7;</code>
       */
      TOOL(7),
      /**
       *
       *
       * <pre>
       * "A tested, cumulative set of hotfixes, security updates, critical
       * updates, and updates that are packaged together for easy deployment. A
       * rollup generally targets a specific area, such as security, or a
       * component of a product, such as Internet Information Services (IIS)." [1]
       * </pre>
       *
       * <code>UPDATE_ROLLUP = 8;</code>
       */
      UPDATE_ROLLUP(8),
      /**
       *
       *
       * <pre>
       * "A widely released fix for a specific problem. An update addresses a
       * noncritical, non-security-related bug." [1]
       * </pre>
       *
       * <code>UPDATE = 9;</code>
       */
      UPDATE(9),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Invalid. If classifications are included, they must be specified.
       * </pre>
       *
       * <code>CLASSIFICATION_UNSPECIFIED = 0;</code>
       */
      public static final int CLASSIFICATION_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * "A widely released fix for a specific problem that addresses a critical,
       * non-security-related bug." [1]
       * </pre>
       *
       * <code>CRITICAL = 1;</code>
       */
      public static final int CRITICAL_VALUE = 1;
      /**
       *
       *
       * <pre>
       * "A widely released fix for a product-specific, security-related
       * vulnerability. Security vulnerabilities are rated by their severity. The
       * severity rating is indicated in the Microsoft security bulletin as
       * critical, important, moderate, or low." [1]
       * </pre>
       *
       * <code>SECURITY = 2;</code>
       */
      public static final int SECURITY_VALUE = 2;
      /**
       *
       *
       * <pre>
       * "A widely released and frequent software update that contains additions
       * to a product's definition database. Definition databases are often used
       * to detect objects that have specific attributes, such as malicious code,
       * phishing websites, or junk mail." [1]
       * </pre>
       *
       * <code>DEFINITION = 3;</code>
       */
      public static final int DEFINITION_VALUE = 3;
      /**
       *
       *
       * <pre>
       * "Software that controls the input and output of a device." [1]
       * </pre>
       *
       * <code>DRIVER = 4;</code>
       */
      public static final int DRIVER_VALUE = 4;
      /**
       *
       *
       * <pre>
       * "New product functionality that is first distributed outside the context
       * of a product release and that is typically included in the next full
       * product release." [1]
       * </pre>
       *
       * <code>FEATURE_PACK = 5;</code>
       */
      public static final int FEATURE_PACK_VALUE = 5;
      /**
       *
       *
       * <pre>
       * "A tested, cumulative set of all hotfixes, security updates, critical
       * updates, and updates. Additionally, service packs may contain additional
       * fixes for problems that are found internally since the release of the
       * product. Service packs my also contain a limited number of
       * customer-requested design changes or features." [1]
       * </pre>
       *
       * <code>SERVICE_PACK = 6;</code>
       */
      public static final int SERVICE_PACK_VALUE = 6;
      /**
       *
       *
       * <pre>
       * "A utility or feature that helps complete a task or set of tasks." [1]
       * </pre>
       *
       * <code>TOOL = 7;</code>
       */
      public static final int TOOL_VALUE = 7;
      /**
       *
       *
       * <pre>
       * "A tested, cumulative set of hotfixes, security updates, critical
       * updates, and updates that are packaged together for easy deployment. A
       * rollup generally targets a specific area, such as security, or a
       * component of a product, such as Internet Information Services (IIS)." [1]
       * </pre>
       *
       * <code>UPDATE_ROLLUP = 8;</code>
       */
      public static final int UPDATE_ROLLUP_VALUE = 8;
      /**
       *
       *
       * <pre>
       * "A widely released fix for a specific problem. An update addresses a
       * noncritical, non-security-related bug." [1]
       * </pre>
       *
       * <code>UPDATE = 9;</code>
       */
      public static final int UPDATE_VALUE = 9;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Classification valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Classification forNumber(int value) {
        switch (value) {
          case 0:
            return CLASSIFICATION_UNSPECIFIED;
          case 1:
            return CRITICAL;
          case 2:
            return SECURITY;
          case 3:
            return DEFINITION;
          case 4:
            return DRIVER;
          case 5:
            return FEATURE_PACK;
          case 6:
            return SERVICE_PACK;
          case 7:
            return TOOL;
          case 8:
            return UPDATE_ROLLUP;
          case 9:
            return UPDATE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Classification> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Classification>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<Classification>() {
                public Classification findValueByNumber(int number) {
                  return Classification.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Classification[] VALUES = values();

      public static Classification valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Classification(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.WindowsUpdateSettings.Classification)
    }

    public static final int CLASSIFICATIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> classifications_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer,
            com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification>
        classifications_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer,
                com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification>() {
              public com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification
                  convert(java.lang.Integer from) {
                com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification result =
                    com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification
                        .forNumber(from);
                return result == null
                    ? com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification
                        .UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * Only apply updates of these windows update classifications. If empty, all
     * updates are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
     * </code>
     *
     * @return A list containing the classifications.
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification>
        getClassificationsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer,
          com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification>(
          classifications_, classifications_converter_);
    }
    /**
     *
     *
     * <pre>
     * Only apply updates of these windows update classifications. If empty, all
     * updates are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
     * </code>
     *
     * @return The count of classifications.
     */
    @java.lang.Override
    public int getClassificationsCount() {
      return classifications_.size();
    }
    /**
     *
     *
     * <pre>
     * Only apply updates of these windows update classifications. If empty, all
     * updates are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The classifications at the given index.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification
        getClassifications(int index) {
      return classifications_converter_.convert(classifications_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Only apply updates of these windows update classifications. If empty, all
     * updates are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for classifications.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getClassificationsValueList() {
      return classifications_;
    }
    /**
     *
     *
     * <pre>
     * Only apply updates of these windows update classifications. If empty, all
     * updates are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of classifications at the given index.
     */
    @java.lang.Override
    public int getClassificationsValue(int index) {
      return classifications_.get(index);
    }

    private int classificationsMemoizedSerializedSize;

    public static final int EXCLUDES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList excludes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of KBs to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @return A list containing the excludes.
     */
    public com.google.protobuf.ProtocolStringList getExcludesList() {
      return excludes_;
    }
    /**
     *
     *
     * <pre>
     * List of KBs to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @return The count of excludes.
     */
    public int getExcludesCount() {
      return excludes_.size();
    }
    /**
     *
     *
     * <pre>
     * List of KBs to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The excludes at the given index.
     */
    public java.lang.String getExcludes(int index) {
      return excludes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of KBs to exclude from update.
     * </pre>
     *
     * <code>repeated string excludes = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludes at the given index.
     */
    public com.google.protobuf.ByteString getExcludesBytes(int index) {
      return excludes_.getByteString(index);
    }

    public static final int EXCLUSIVE_PATCHES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList exclusivePatches_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * An exclusive list of kbs to be updated. These are the only patches
     * that will be updated. This field must not be used with other
     * patch configurations.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 3;</code>
     *
     * @return A list containing the exclusivePatches.
     */
    public com.google.protobuf.ProtocolStringList getExclusivePatchesList() {
      return exclusivePatches_;
    }
    /**
     *
     *
     * <pre>
     * An exclusive list of kbs to be updated. These are the only patches
     * that will be updated. This field must not be used with other
     * patch configurations.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 3;</code>
     *
     * @return The count of exclusivePatches.
     */
    public int getExclusivePatchesCount() {
      return exclusivePatches_.size();
    }
    /**
     *
     *
     * <pre>
     * An exclusive list of kbs to be updated. These are the only patches
     * that will be updated. This field must not be used with other
     * patch configurations.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The exclusivePatches at the given index.
     */
    public java.lang.String getExclusivePatches(int index) {
      return exclusivePatches_.get(index);
    }
    /**
     *
     *
     * <pre>
     * An exclusive list of kbs to be updated. These are the only patches
     * that will be updated. This field must not be used with other
     * patch configurations.
     * </pre>
     *
     * <code>repeated string exclusive_patches = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the exclusivePatches at the given index.
     */
    public com.google.protobuf.ByteString getExclusivePatchesBytes(int index) {
      return exclusivePatches_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (getClassificationsList().size() > 0) {
        output.writeUInt32NoTag(10);
        output.writeUInt32NoTag(classificationsMemoizedSerializedSize);
      }
      for (int i = 0; i < classifications_.size(); i++) {
        output.writeEnumNoTag(classifications_.get(i));
      }
      for (int i = 0; i < excludes_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, excludes_.getRaw(i));
      }
      for (int i = 0; i < exclusivePatches_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, exclusivePatches_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < classifications_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(classifications_.get(i));
        }
        size += dataSize;
        if (!getClassificationsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        classificationsMemoizedSerializedSize = dataSize;
      }
      {
        int dataSize = 0;
        for (int i = 0; i < excludes_.size(); i++) {
          dataSize += computeStringSizeNoTag(excludes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExcludesList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < exclusivePatches_.size(); i++) {
          dataSize += computeStringSizeNoTag(exclusivePatches_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExclusivePatchesList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings other =
          (com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings) obj;

      if (!classifications_.equals(other.classifications_)) return false;
      if (!getExcludesList().equals(other.getExcludesList())) return false;
      if (!getExclusivePatchesList().equals(other.getExclusivePatchesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getClassificationsCount() > 0) {
        hash = (37 * hash) + CLASSIFICATIONS_FIELD_NUMBER;
        hash = (53 * hash) + classifications_.hashCode();
      }
      if (getExcludesCount() > 0) {
        hash = (37 * hash) + EXCLUDES_FIELD_NUMBER;
        hash = (53 * hash) + getExcludesList().hashCode();
      }
      if (getExclusivePatchesCount() > 0) {
        hash = (37 * hash) + EXCLUSIVE_PATCHES_FIELD_NUMBER;
        hash = (53 * hash) + getExclusivePatchesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Windows patching is performed using the Windows Update Agent.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.WindowsUpdateSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.WindowsUpdateSettings)
        com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_WindowsUpdateSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_WindowsUpdateSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.class,
                com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        classifications_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        excludes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        exclusivePatches_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_WindowsUpdateSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings build() {
        com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings result =
            new com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings result) {
        if (((bitField0_ & 0x00000001) != 0)) {
          classifications_ = java.util.Collections.unmodifiableList(classifications_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.classifications_ = classifications_;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          excludes_.makeImmutable();
          result.excludes_ = excludes_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          exclusivePatches_.makeImmutable();
          result.exclusivePatches_ = exclusivePatches_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings other) {
        if (other
            == com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.getDefaultInstance())
          return this;
        if (!other.classifications_.isEmpty()) {
          if (classifications_.isEmpty()) {
            classifications_ = other.classifications_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureClassificationsIsMutable();
            classifications_.addAll(other.classifications_);
          }
          onChanged();
        }
        if (!other.excludes_.isEmpty()) {
          if (excludes_.isEmpty()) {
            excludes_ = other.excludes_;
            bitField0_ |= 0x00000002;
          } else {
            ensureExcludesIsMutable();
            excludes_.addAll(other.excludes_);
          }
          onChanged();
        }
        if (!other.exclusivePatches_.isEmpty()) {
          if (exclusivePatches_.isEmpty()) {
            exclusivePatches_ = other.exclusivePatches_;
            bitField0_ |= 0x00000004;
          } else {
            ensureExclusivePatchesIsMutable();
            exclusivePatches_.addAll(other.exclusivePatches_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  int tmpRaw = input.readEnum();
                  ensureClassificationsIsMutable();
                  classifications_.add(tmpRaw);
                  break;
                } // case 8
              case 10:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureClassificationsIsMutable();
                    classifications_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExcludesIsMutable();
                  excludes_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExclusivePatchesIsMutable();
                  exclusivePatches_.add(s);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<java.lang.Integer> classifications_ =
          java.util.Collections.emptyList();

      private void ensureClassificationsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          classifications_ = new java.util.ArrayList<java.lang.Integer>(classifications_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Only apply updates of these windows update classifications. If empty, all
       * updates are applied.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
       * </code>
       *
       * @return A list containing the classifications.
       */
      public java.util.List<
              com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification>
          getClassificationsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer,
            com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification>(
            classifications_, classifications_converter_);
      }
      /**
       *
       *
       * <pre>
       * Only apply updates of these windows update classifications. If empty, all
       * updates are applied.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
       * </code>
       *
       * @return The count of classifications.
       */
      public int getClassificationsCount() {
        return classifications_.size();
      }
      /**
       *
       *
       * <pre>
       * Only apply updates of these windows update classifications. If empty, all
       * updates are applied.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The classifications at the given index.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification
          getClassifications(int index) {
        return classifications_converter_.convert(classifications_.get(index));
      }
      /**
       *
       *
       * <pre>
       * Only apply updates of these windows update classifications. If empty, all
       * updates are applied.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The classifications to set.
       * @return This builder for chaining.
       */
      public Builder setClassifications(
          int index,
          com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClassificationsIsMutable();
        classifications_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only apply updates of these windows update classifications. If empty, all
       * updates are applied.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
       * </code>
       *
       * @param value The classifications to add.
       * @return This builder for chaining.
       */
      public Builder addClassifications(
          com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClassificationsIsMutable();
        classifications_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only apply updates of these windows update classifications. If empty, all
       * updates are applied.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
       * </code>
       *
       * @param values The classifications to add.
       * @return This builder for chaining.
       */
      public Builder addAllClassifications(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification>
              values) {
        ensureClassificationsIsMutable();
        for (com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings.Classification value :
            values) {
          classifications_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only apply updates of these windows update classifications. If empty, all
       * updates are applied.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearClassifications() {
        classifications_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only apply updates of these windows update classifications. If empty, all
       * updates are applied.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for classifications.
       */
      public java.util.List<java.lang.Integer> getClassificationsValueList() {
        return java.util.Collections.unmodifiableList(classifications_);
      }
      /**
       *
       *
       * <pre>
       * Only apply updates of these windows update classifications. If empty, all
       * updates are applied.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of classifications at the given index.
       */
      public int getClassificationsValue(int index) {
        return classifications_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Only apply updates of these windows update classifications. If empty, all
       * updates are applied.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for classifications to set.
       * @return This builder for chaining.
       */
      public Builder setClassificationsValue(int index, int value) {
        ensureClassificationsIsMutable();
        classifications_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only apply updates of these windows update classifications. If empty, all
       * updates are applied.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for classifications to add.
       * @return This builder for chaining.
       */
      public Builder addClassificationsValue(int value) {
        ensureClassificationsIsMutable();
        classifications_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only apply updates of these windows update classifications. If empty, all
       * updates are applied.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1.WindowsUpdateSettings.Classification classifications = 1;
       * </code>
       *
       * @param values The enum numeric values on the wire for classifications to add.
       * @return This builder for chaining.
       */
      public Builder addAllClassificationsValue(java.lang.Iterable<java.lang.Integer> values) {
        ensureClassificationsIsMutable();
        for (int value : values) {
          classifications_.add(value);
        }
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList excludes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureExcludesIsMutable() {
        if (!excludes_.isModifiable()) {
          excludes_ = new com.google.protobuf.LazyStringArrayList(excludes_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * List of KBs to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @return A list containing the excludes.
       */
      public com.google.protobuf.ProtocolStringList getExcludesList() {
        excludes_.makeImmutable();
        return excludes_;
      }
      /**
       *
       *
       * <pre>
       * List of KBs to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @return The count of excludes.
       */
      public int getExcludesCount() {
        return excludes_.size();
      }
      /**
       *
       *
       * <pre>
       * List of KBs to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The excludes at the given index.
       */
      public java.lang.String getExcludes(int index) {
        return excludes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of KBs to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the excludes at the given index.
       */
      public com.google.protobuf.ByteString getExcludesBytes(int index) {
        return excludes_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of KBs to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The excludes to set.
       * @return This builder for chaining.
       */
      public Builder setExcludes(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludesIsMutable();
        excludes_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of KBs to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @param value The excludes to add.
       * @return This builder for chaining.
       */
      public Builder addExcludes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludesIsMutable();
        excludes_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of KBs to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @param values The excludes to add.
       * @return This builder for chaining.
       */
      public Builder addAllExcludes(java.lang.Iterable<java.lang.String> values) {
        ensureExcludesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludes_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of KBs to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExcludes() {
        excludes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of KBs to exclude from update.
       * </pre>
       *
       * <code>repeated string excludes = 2;</code>
       *
       * @param value The bytes of the excludes to add.
       * @return This builder for chaining.
       */
      public Builder addExcludesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExcludesIsMutable();
        excludes_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList exclusivePatches_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureExclusivePatchesIsMutable() {
        if (!exclusivePatches_.isModifiable()) {
          exclusivePatches_ = new com.google.protobuf.LazyStringArrayList(exclusivePatches_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of kbs to be updated. These are the only patches
       * that will be updated. This field must not be used with other
       * patch configurations.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 3;</code>
       *
       * @return A list containing the exclusivePatches.
       */
      public com.google.protobuf.ProtocolStringList getExclusivePatchesList() {
        exclusivePatches_.makeImmutable();
        return exclusivePatches_;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of kbs to be updated. These are the only patches
       * that will be updated. This field must not be used with other
       * patch configurations.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 3;</code>
       *
       * @return The count of exclusivePatches.
       */
      public int getExclusivePatchesCount() {
        return exclusivePatches_.size();
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of kbs to be updated. These are the only patches
       * that will be updated. This field must not be used with other
       * patch configurations.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The exclusivePatches at the given index.
       */
      public java.lang.String getExclusivePatches(int index) {
        return exclusivePatches_.get(index);
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of kbs to be updated. These are the only patches
       * that will be updated. This field must not be used with other
       * patch configurations.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the exclusivePatches at the given index.
       */
      public com.google.protobuf.ByteString getExclusivePatchesBytes(int index) {
        return exclusivePatches_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of kbs to be updated. These are the only patches
       * that will be updated. This field must not be used with other
       * patch configurations.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The exclusivePatches to set.
       * @return This builder for chaining.
       */
      public Builder setExclusivePatches(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusivePatchesIsMutable();
        exclusivePatches_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of kbs to be updated. These are the only patches
       * that will be updated. This field must not be used with other
       * patch configurations.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 3;</code>
       *
       * @param value The exclusivePatches to add.
       * @return This builder for chaining.
       */
      public Builder addExclusivePatches(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExclusivePatchesIsMutable();
        exclusivePatches_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of kbs to be updated. These are the only patches
       * that will be updated. This field must not be used with other
       * patch configurations.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 3;</code>
       *
       * @param values The exclusivePatches to add.
       * @return This builder for chaining.
       */
      public Builder addAllExclusivePatches(java.lang.Iterable<java.lang.String> values) {
        ensureExclusivePatchesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exclusivePatches_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of kbs to be updated. These are the only patches
       * that will be updated. This field must not be used with other
       * patch configurations.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExclusivePatches() {
        exclusivePatches_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An exclusive list of kbs to be updated. These are the only patches
       * that will be updated. This field must not be used with other
       * patch configurations.
       * </pre>
       *
       * <code>repeated string exclusive_patches = 3;</code>
       *
       * @param value The bytes of the exclusivePatches to add.
       * @return This builder for chaining.
       */
      public Builder addExclusivePatchesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExclusivePatchesIsMutable();
        exclusivePatches_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.WindowsUpdateSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.WindowsUpdateSettings)
    private static final com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WindowsUpdateSettings> PARSER =
        new com.google.protobuf.AbstractParser<WindowsUpdateSettings>() {
          @java.lang.Override
          public WindowsUpdateSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WindowsUpdateSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WindowsUpdateSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.WindowsUpdateSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ExecStepOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.ExecStep)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
     *
     * @return Whether the linuxExecStepConfig field is set.
     */
    boolean hasLinuxExecStepConfig();
    /**
     *
     *
     * <pre>
     * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
     *
     * @return The linuxExecStepConfig.
     */
    com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig getLinuxExecStepConfig();
    /**
     *
     *
     * <pre>
     * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfigOrBuilder
        getLinuxExecStepConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
     *
     * @return Whether the windowsExecStepConfig field is set.
     */
    boolean hasWindowsExecStepConfig();
    /**
     *
     *
     * <pre>
     * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
     *
     * @return The windowsExecStepConfig.
     */
    com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig getWindowsExecStepConfig();
    /**
     *
     *
     * <pre>
     * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfigOrBuilder
        getWindowsExecStepConfigOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A step that runs an executable for a PatchJob.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.ExecStep}
   */
  public static final class ExecStep extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.ExecStep)
      ExecStepOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExecStep.newBuilder() to construct.
    private ExecStep(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExecStep() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExecStep();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ExecStep_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ExecStep_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.ExecStep.class,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStep.Builder.class);
    }

    public static final int LINUX_EXEC_STEP_CONFIG_FIELD_NUMBER = 1;
    private com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig linuxExecStepConfig_;
    /**
     *
     *
     * <pre>
     * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
     *
     * @return Whether the linuxExecStepConfig field is set.
     */
    @java.lang.Override
    public boolean hasLinuxExecStepConfig() {
      return linuxExecStepConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
     *
     * @return The linuxExecStepConfig.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig getLinuxExecStepConfig() {
      return linuxExecStepConfig_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.getDefaultInstance()
          : linuxExecStepConfig_;
    }
    /**
     *
     *
     * <pre>
     * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfigOrBuilder
        getLinuxExecStepConfigOrBuilder() {
      return linuxExecStepConfig_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.getDefaultInstance()
          : linuxExecStepConfig_;
    }

    public static final int WINDOWS_EXEC_STEP_CONFIG_FIELD_NUMBER = 2;
    private com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig windowsExecStepConfig_;
    /**
     *
     *
     * <pre>
     * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
     *
     * @return Whether the windowsExecStepConfig field is set.
     */
    @java.lang.Override
    public boolean hasWindowsExecStepConfig() {
      return windowsExecStepConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
     *
     * @return The windowsExecStepConfig.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig getWindowsExecStepConfig() {
      return windowsExecStepConfig_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.getDefaultInstance()
          : windowsExecStepConfig_;
    }
    /**
     *
     *
     * <pre>
     * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfigOrBuilder
        getWindowsExecStepConfigOrBuilder() {
      return windowsExecStepConfig_ == null
          ? com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.getDefaultInstance()
          : windowsExecStepConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (linuxExecStepConfig_ != null) {
        output.writeMessage(1, getLinuxExecStepConfig());
      }
      if (windowsExecStepConfig_ != null) {
        output.writeMessage(2, getWindowsExecStepConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (linuxExecStepConfig_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLinuxExecStepConfig());
      }
      if (windowsExecStepConfig_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getWindowsExecStepConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.ExecStep)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.ExecStep other =
          (com.google.cloud.osconfig.v1.PatchJobs.ExecStep) obj;

      if (hasLinuxExecStepConfig() != other.hasLinuxExecStepConfig()) return false;
      if (hasLinuxExecStepConfig()) {
        if (!getLinuxExecStepConfig().equals(other.getLinuxExecStepConfig())) return false;
      }
      if (hasWindowsExecStepConfig() != other.hasWindowsExecStepConfig()) return false;
      if (hasWindowsExecStepConfig()) {
        if (!getWindowsExecStepConfig().equals(other.getWindowsExecStepConfig())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasLinuxExecStepConfig()) {
        hash = (37 * hash) + LINUX_EXEC_STEP_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getLinuxExecStepConfig().hashCode();
      }
      if (hasWindowsExecStepConfig()) {
        hash = (37 * hash) + WINDOWS_EXEC_STEP_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getWindowsExecStepConfig().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStep parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStep parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStep parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStep parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStep parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStep parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStep parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStep parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStep parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStep parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStep parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStep parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.osconfig.v1.PatchJobs.ExecStep prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A step that runs an executable for a PatchJob.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.ExecStep}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.ExecStep)
        com.google.cloud.osconfig.v1.PatchJobs.ExecStepOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ExecStep_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ExecStep_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.ExecStep.class,
                com.google.cloud.osconfig.v1.PatchJobs.ExecStep.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.ExecStep.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        linuxExecStepConfig_ = null;
        if (linuxExecStepConfigBuilder_ != null) {
          linuxExecStepConfigBuilder_.dispose();
          linuxExecStepConfigBuilder_ = null;
        }
        windowsExecStepConfig_ = null;
        if (windowsExecStepConfigBuilder_ != null) {
          windowsExecStepConfigBuilder_.dispose();
          windowsExecStepConfigBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ExecStep_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStep getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.ExecStep.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStep build() {
        com.google.cloud.osconfig.v1.PatchJobs.ExecStep result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStep buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.ExecStep result =
            new com.google.cloud.osconfig.v1.PatchJobs.ExecStep(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.osconfig.v1.PatchJobs.ExecStep result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.linuxExecStepConfig_ =
              linuxExecStepConfigBuilder_ == null
                  ? linuxExecStepConfig_
                  : linuxExecStepConfigBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.windowsExecStepConfig_ =
              windowsExecStepConfigBuilder_ == null
                  ? windowsExecStepConfig_
                  : windowsExecStepConfigBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.ExecStep) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.ExecStep) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.ExecStep other) {
        if (other == com.google.cloud.osconfig.v1.PatchJobs.ExecStep.getDefaultInstance())
          return this;
        if (other.hasLinuxExecStepConfig()) {
          mergeLinuxExecStepConfig(other.getLinuxExecStepConfig());
        }
        if (other.hasWindowsExecStepConfig()) {
          mergeWindowsExecStepConfig(other.getWindowsExecStepConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getLinuxExecStepConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getWindowsExecStepConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig linuxExecStepConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfigOrBuilder>
          linuxExecStepConfigBuilder_;
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
       *
       * @return Whether the linuxExecStepConfig field is set.
       */
      public boolean hasLinuxExecStepConfig() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
       *
       * @return The linuxExecStepConfig.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig getLinuxExecStepConfig() {
        if (linuxExecStepConfigBuilder_ == null) {
          return linuxExecStepConfig_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.getDefaultInstance()
              : linuxExecStepConfig_;
        } else {
          return linuxExecStepConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
       */
      public Builder setLinuxExecStepConfig(
          com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig value) {
        if (linuxExecStepConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          linuxExecStepConfig_ = value;
        } else {
          linuxExecStepConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
       */
      public Builder setLinuxExecStepConfig(
          com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Builder builderForValue) {
        if (linuxExecStepConfigBuilder_ == null) {
          linuxExecStepConfig_ = builderForValue.build();
        } else {
          linuxExecStepConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
       */
      public Builder mergeLinuxExecStepConfig(
          com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig value) {
        if (linuxExecStepConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && linuxExecStepConfig_ != null
              && linuxExecStepConfig_
                  != com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.getDefaultInstance()) {
            getLinuxExecStepConfigBuilder().mergeFrom(value);
          } else {
            linuxExecStepConfig_ = value;
          }
        } else {
          linuxExecStepConfigBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
       */
      public Builder clearLinuxExecStepConfig() {
        bitField0_ = (bitField0_ & ~0x00000001);
        linuxExecStepConfig_ = null;
        if (linuxExecStepConfigBuilder_ != null) {
          linuxExecStepConfigBuilder_.dispose();
          linuxExecStepConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Builder
          getLinuxExecStepConfigBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getLinuxExecStepConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfigOrBuilder
          getLinuxExecStepConfigOrBuilder() {
        if (linuxExecStepConfigBuilder_ != null) {
          return linuxExecStepConfigBuilder_.getMessageOrBuilder();
        } else {
          return linuxExecStepConfig_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.getDefaultInstance()
              : linuxExecStepConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Linux VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig linux_exec_step_config = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfigOrBuilder>
          getLinuxExecStepConfigFieldBuilder() {
        if (linuxExecStepConfigBuilder_ == null) {
          linuxExecStepConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig,
                  com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfigOrBuilder>(
                  getLinuxExecStepConfig(), getParentForChildren(), isClean());
          linuxExecStepConfig_ = null;
        }
        return linuxExecStepConfigBuilder_;
      }

      private com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig windowsExecStepConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfigOrBuilder>
          windowsExecStepConfigBuilder_;
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
       *
       * @return Whether the windowsExecStepConfig field is set.
       */
      public boolean hasWindowsExecStepConfig() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
       *
       * @return The windowsExecStepConfig.
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig getWindowsExecStepConfig() {
        if (windowsExecStepConfigBuilder_ == null) {
          return windowsExecStepConfig_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.getDefaultInstance()
              : windowsExecStepConfig_;
        } else {
          return windowsExecStepConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
       */
      public Builder setWindowsExecStepConfig(
          com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig value) {
        if (windowsExecStepConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          windowsExecStepConfig_ = value;
        } else {
          windowsExecStepConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
       */
      public Builder setWindowsExecStepConfig(
          com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Builder builderForValue) {
        if (windowsExecStepConfigBuilder_ == null) {
          windowsExecStepConfig_ = builderForValue.build();
        } else {
          windowsExecStepConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
       */
      public Builder mergeWindowsExecStepConfig(
          com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig value) {
        if (windowsExecStepConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && windowsExecStepConfig_ != null
              && windowsExecStepConfig_
                  != com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.getDefaultInstance()) {
            getWindowsExecStepConfigBuilder().mergeFrom(value);
          } else {
            windowsExecStepConfig_ = value;
          }
        } else {
          windowsExecStepConfigBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
       */
      public Builder clearWindowsExecStepConfig() {
        bitField0_ = (bitField0_ & ~0x00000002);
        windowsExecStepConfig_ = null;
        if (windowsExecStepConfigBuilder_ != null) {
          windowsExecStepConfigBuilder_.dispose();
          windowsExecStepConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Builder
          getWindowsExecStepConfigBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getWindowsExecStepConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfigOrBuilder
          getWindowsExecStepConfigOrBuilder() {
        if (windowsExecStepConfigBuilder_ != null) {
          return windowsExecStepConfigBuilder_.getMessageOrBuilder();
        } else {
          return windowsExecStepConfig_ == null
              ? com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.getDefaultInstance()
              : windowsExecStepConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * The ExecStepConfig for all Windows VMs targeted by the PatchJob.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig windows_exec_step_config = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfigOrBuilder>
          getWindowsExecStepConfigFieldBuilder() {
        if (windowsExecStepConfigBuilder_ == null) {
          windowsExecStepConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig,
                  com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfigOrBuilder>(
                  getWindowsExecStepConfig(), getParentForChildren(), isClean());
          windowsExecStepConfig_ = null;
        }
        return windowsExecStepConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.ExecStep)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.ExecStep)
    private static final com.google.cloud.osconfig.v1.PatchJobs.ExecStep DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.ExecStep();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStep getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExecStep> PARSER =
        new com.google.protobuf.AbstractParser<ExecStep>() {
          @java.lang.Override
          public ExecStep parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExecStep> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExecStep> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ExecStep getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ExecStepConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.ExecStepConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * An absolute path to the executable on the VM.
     * </pre>
     *
     * <code>string local_path = 1;</code>
     *
     * @return Whether the localPath field is set.
     */
    boolean hasLocalPath();
    /**
     *
     *
     * <pre>
     * An absolute path to the executable on the VM.
     * </pre>
     *
     * <code>string local_path = 1;</code>
     *
     * @return The localPath.
     */
    java.lang.String getLocalPath();
    /**
     *
     *
     * <pre>
     * An absolute path to the executable on the VM.
     * </pre>
     *
     * <code>string local_path = 1;</code>
     *
     * @return The bytes for localPath.
     */
    com.google.protobuf.ByteString getLocalPathBytes();

    /**
     *
     *
     * <pre>
     * A Cloud Storage object containing the executable.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
     *
     * @return Whether the gcsObject field is set.
     */
    boolean hasGcsObject();
    /**
     *
     *
     * <pre>
     * A Cloud Storage object containing the executable.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
     *
     * @return The gcsObject.
     */
    com.google.cloud.osconfig.v1.PatchJobs.GcsObject getGcsObject();
    /**
     *
     *
     * <pre>
     * A Cloud Storage object containing the executable.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
     */
    com.google.cloud.osconfig.v1.PatchJobs.GcsObjectOrBuilder getGcsObjectOrBuilder();

    /**
     *
     *
     * <pre>
     * Defaults to [0]. A list of possible return values that the
     * execution can return to indicate a success.
     * </pre>
     *
     * <code>repeated int32 allowed_success_codes = 3;</code>
     *
     * @return A list containing the allowedSuccessCodes.
     */
    java.util.List<java.lang.Integer> getAllowedSuccessCodesList();
    /**
     *
     *
     * <pre>
     * Defaults to [0]. A list of possible return values that the
     * execution can return to indicate a success.
     * </pre>
     *
     * <code>repeated int32 allowed_success_codes = 3;</code>
     *
     * @return The count of allowedSuccessCodes.
     */
    int getAllowedSuccessCodesCount();
    /**
     *
     *
     * <pre>
     * Defaults to [0]. A list of possible return values that the
     * execution can return to indicate a success.
     * </pre>
     *
     * <code>repeated int32 allowed_success_codes = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedSuccessCodes at the given index.
     */
    int getAllowedSuccessCodes(int index);

    /**
     *
     *
     * <pre>
     * The script interpreter to use to run the script. If no interpreter is
     * specified the script will be executed directly, which will likely
     * only succeed for scripts with [shebang lines]
     * (https://en.wikipedia.org/wiki/Shebang_&#92;(Unix&#92;)).
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig.Interpreter interpreter = 4;</code>
     *
     * @return The enum numeric value on the wire for interpreter.
     */
    int getInterpreterValue();
    /**
     *
     *
     * <pre>
     * The script interpreter to use to run the script. If no interpreter is
     * specified the script will be executed directly, which will likely
     * only succeed for scripts with [shebang lines]
     * (https://en.wikipedia.org/wiki/Shebang_&#92;(Unix&#92;)).
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig.Interpreter interpreter = 4;</code>
     *
     * @return The interpreter.
     */
    com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Interpreter getInterpreter();

    com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.ExecutableCase getExecutableCase();
  }
  /**
   *
   *
   * <pre>
   * Common configurations for an ExecStep.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.ExecStepConfig}
   */
  public static final class ExecStepConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.ExecStepConfig)
      ExecStepConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExecStepConfig.newBuilder() to construct.
    private ExecStepConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExecStepConfig() {
      allowedSuccessCodes_ = emptyIntList();
      interpreter_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExecStepConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ExecStepConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_ExecStepConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.class,
              com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The interpreter used to execute the a file.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.osconfig.v1.ExecStepConfig.Interpreter}
     */
    public enum Interpreter implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Invalid for a Windows ExecStepConfig. For a Linux ExecStepConfig, the
       * interpreter will be parsed from the shebang line of the script if
       * unspecified.
       * </pre>
       *
       * <code>INTERPRETER_UNSPECIFIED = 0;</code>
       */
      INTERPRETER_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Indicates that the script is run with `/bin/sh` on Linux and `cmd`
       * on Windows.
       * </pre>
       *
       * <code>SHELL = 1;</code>
       */
      SHELL(1),
      /**
       *
       *
       * <pre>
       * Indicates that the file is run with PowerShell flags
       * `-NonInteractive`, `-NoProfile`, and `-ExecutionPolicy Bypass`.
       * </pre>
       *
       * <code>POWERSHELL = 2;</code>
       */
      POWERSHELL(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Invalid for a Windows ExecStepConfig. For a Linux ExecStepConfig, the
       * interpreter will be parsed from the shebang line of the script if
       * unspecified.
       * </pre>
       *
       * <code>INTERPRETER_UNSPECIFIED = 0;</code>
       */
      public static final int INTERPRETER_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Indicates that the script is run with `/bin/sh` on Linux and `cmd`
       * on Windows.
       * </pre>
       *
       * <code>SHELL = 1;</code>
       */
      public static final int SHELL_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Indicates that the file is run with PowerShell flags
       * `-NonInteractive`, `-NoProfile`, and `-ExecutionPolicy Bypass`.
       * </pre>
       *
       * <code>POWERSHELL = 2;</code>
       */
      public static final int POWERSHELL_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Interpreter valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Interpreter forNumber(int value) {
        switch (value) {
          case 0:
            return INTERPRETER_UNSPECIFIED;
          case 1:
            return SHELL;
          case 2:
            return POWERSHELL;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Interpreter> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Interpreter> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Interpreter>() {
            public Interpreter findValueByNumber(int number) {
              return Interpreter.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Interpreter[] VALUES = values();

      public static Interpreter valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Interpreter(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1.ExecStepConfig.Interpreter)
    }

    private int executableCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object executable_;

    public enum ExecutableCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      LOCAL_PATH(1),
      GCS_OBJECT(2),
      EXECUTABLE_NOT_SET(0);
      private final int value;

      private ExecutableCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ExecutableCase valueOf(int value) {
        return forNumber(value);
      }

      public static ExecutableCase forNumber(int value) {
        switch (value) {
          case 1:
            return LOCAL_PATH;
          case 2:
            return GCS_OBJECT;
          case 0:
            return EXECUTABLE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ExecutableCase getExecutableCase() {
      return ExecutableCase.forNumber(executableCase_);
    }

    public static final int LOCAL_PATH_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * An absolute path to the executable on the VM.
     * </pre>
     *
     * <code>string local_path = 1;</code>
     *
     * @return Whether the localPath field is set.
     */
    public boolean hasLocalPath() {
      return executableCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * An absolute path to the executable on the VM.
     * </pre>
     *
     * <code>string local_path = 1;</code>
     *
     * @return The localPath.
     */
    public java.lang.String getLocalPath() {
      java.lang.Object ref = "";
      if (executableCase_ == 1) {
        ref = executable_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (executableCase_ == 1) {
          executable_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * An absolute path to the executable on the VM.
     * </pre>
     *
     * <code>string local_path = 1;</code>
     *
     * @return The bytes for localPath.
     */
    public com.google.protobuf.ByteString getLocalPathBytes() {
      java.lang.Object ref = "";
      if (executableCase_ == 1) {
        ref = executable_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (executableCase_ == 1) {
          executable_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GCS_OBJECT_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * A Cloud Storage object containing the executable.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
     *
     * @return Whether the gcsObject field is set.
     */
    @java.lang.Override
    public boolean hasGcsObject() {
      return executableCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A Cloud Storage object containing the executable.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
     *
     * @return The gcsObject.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.GcsObject getGcsObject() {
      if (executableCase_ == 2) {
        return (com.google.cloud.osconfig.v1.PatchJobs.GcsObject) executable_;
      }
      return com.google.cloud.osconfig.v1.PatchJobs.GcsObject.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A Cloud Storage object containing the executable.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.GcsObjectOrBuilder getGcsObjectOrBuilder() {
      if (executableCase_ == 2) {
        return (com.google.cloud.osconfig.v1.PatchJobs.GcsObject) executable_;
      }
      return com.google.cloud.osconfig.v1.PatchJobs.GcsObject.getDefaultInstance();
    }

    public static final int ALLOWED_SUCCESS_CODES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.IntList allowedSuccessCodes_;
    /**
     *
     *
     * <pre>
     * Defaults to [0]. A list of possible return values that the
     * execution can return to indicate a success.
     * </pre>
     *
     * <code>repeated int32 allowed_success_codes = 3;</code>
     *
     * @return A list containing the allowedSuccessCodes.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getAllowedSuccessCodesList() {
      return allowedSuccessCodes_;
    }
    /**
     *
     *
     * <pre>
     * Defaults to [0]. A list of possible return values that the
     * execution can return to indicate a success.
     * </pre>
     *
     * <code>repeated int32 allowed_success_codes = 3;</code>
     *
     * @return The count of allowedSuccessCodes.
     */
    public int getAllowedSuccessCodesCount() {
      return allowedSuccessCodes_.size();
    }
    /**
     *
     *
     * <pre>
     * Defaults to [0]. A list of possible return values that the
     * execution can return to indicate a success.
     * </pre>
     *
     * <code>repeated int32 allowed_success_codes = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedSuccessCodes at the given index.
     */
    public int getAllowedSuccessCodes(int index) {
      return allowedSuccessCodes_.getInt(index);
    }

    private int allowedSuccessCodesMemoizedSerializedSize = -1;

    public static final int INTERPRETER_FIELD_NUMBER = 4;
    private int interpreter_ = 0;
    /**
     *
     *
     * <pre>
     * The script interpreter to use to run the script. If no interpreter is
     * specified the script will be executed directly, which will likely
     * only succeed for scripts with [shebang lines]
     * (https://en.wikipedia.org/wiki/Shebang_&#92;(Unix&#92;)).
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig.Interpreter interpreter = 4;</code>
     *
     * @return The enum numeric value on the wire for interpreter.
     */
    @java.lang.Override
    public int getInterpreterValue() {
      return interpreter_;
    }
    /**
     *
     *
     * <pre>
     * The script interpreter to use to run the script. If no interpreter is
     * specified the script will be executed directly, which will likely
     * only succeed for scripts with [shebang lines]
     * (https://en.wikipedia.org/wiki/Shebang_&#92;(Unix&#92;)).
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1.ExecStepConfig.Interpreter interpreter = 4;</code>
     *
     * @return The interpreter.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Interpreter getInterpreter() {
      com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Interpreter result =
          com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Interpreter.forNumber(interpreter_);
      return result == null
          ? com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Interpreter.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (executableCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, executable_);
      }
      if (executableCase_ == 2) {
        output.writeMessage(2, (com.google.cloud.osconfig.v1.PatchJobs.GcsObject) executable_);
      }
      if (getAllowedSuccessCodesList().size() > 0) {
        output.writeUInt32NoTag(26);
        output.writeUInt32NoTag(allowedSuccessCodesMemoizedSerializedSize);
      }
      for (int i = 0; i < allowedSuccessCodes_.size(); i++) {
        output.writeInt32NoTag(allowedSuccessCodes_.getInt(i));
      }
      if (interpreter_
          != com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Interpreter
              .INTERPRETER_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, interpreter_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (executableCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, executable_);
      }
      if (executableCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.osconfig.v1.PatchJobs.GcsObject) executable_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < allowedSuccessCodes_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(
                  allowedSuccessCodes_.getInt(i));
        }
        size += dataSize;
        if (!getAllowedSuccessCodesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
        }
        allowedSuccessCodesMemoizedSerializedSize = dataSize;
      }
      if (interpreter_
          != com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Interpreter
              .INTERPRETER_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, interpreter_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig other =
          (com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig) obj;

      if (!getAllowedSuccessCodesList().equals(other.getAllowedSuccessCodesList())) return false;
      if (interpreter_ != other.interpreter_) return false;
      if (!getExecutableCase().equals(other.getExecutableCase())) return false;
      switch (executableCase_) {
        case 1:
          if (!getLocalPath().equals(other.getLocalPath())) return false;
          break;
        case 2:
          if (!getGcsObject().equals(other.getGcsObject())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAllowedSuccessCodesCount() > 0) {
        hash = (37 * hash) + ALLOWED_SUCCESS_CODES_FIELD_NUMBER;
        hash = (53 * hash) + getAllowedSuccessCodesList().hashCode();
      }
      hash = (37 * hash) + INTERPRETER_FIELD_NUMBER;
      hash = (53 * hash) + interpreter_;
      switch (executableCase_) {
        case 1:
          hash = (37 * hash) + LOCAL_PATH_FIELD_NUMBER;
          hash = (53 * hash) + getLocalPath().hashCode();
          break;
        case 2:
          hash = (37 * hash) + GCS_OBJECT_FIELD_NUMBER;
          hash = (53 * hash) + getGcsObject().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Common configurations for an ExecStep.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1.ExecStepConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1.ExecStepConfig)
        com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ExecStepConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ExecStepConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.class,
                com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (gcsObjectBuilder_ != null) {
          gcsObjectBuilder_.clear();
        }
        allowedSuccessCodes_ = emptyIntList();
        interpreter_ = 0;
        executableCase_ = 0;
        executable_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1.PatchJobs
            .internal_static_google_cloud_osconfig_v1_ExecStepConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig build() {
        com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig buildPartial() {
        com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig result =
            new com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig result) {
        if (((bitField0_ & 0x00000004) != 0)) {
          allowedSuccessCodes_.makeImmutable();
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.allowedSuccessCodes_ = allowedSuccessCodes_;
      }

      private void buildPartial0(com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.interpreter_ = interpreter_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig result) {
        result.executableCase_ = executableCase_;
        result.executable_ = this.executable_;
        if (executableCase_ == 2 && gcsObjectBuilder_ != null) {
          result.executable_ = gcsObjectBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig) {
          return mergeFrom((com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig other) {
        if (other == com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.getDefaultInstance())
          return this;
        if (!other.allowedSuccessCodes_.isEmpty()) {
          if (allowedSuccessCodes_.isEmpty()) {
            allowedSuccessCodes_ = other.allowedSuccessCodes_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureAllowedSuccessCodesIsMutable();
            allowedSuccessCodes_.addAll(other.allowedSuccessCodes_);
          }
          onChanged();
        }
        if (other.interpreter_ != 0) {
          setInterpreterValue(other.getInterpreterValue());
        }
        switch (other.getExecutableCase()) {
          case LOCAL_PATH:
            {
              executableCase_ = 1;
              executable_ = other.executable_;
              onChanged();
              break;
            }
          case GCS_OBJECT:
            {
              mergeGcsObject(other.getGcsObject());
              break;
            }
          case EXECUTABLE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  executableCase_ = 1;
                  executable_ = s;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getGcsObjectFieldBuilder().getBuilder(), extensionRegistry);
                  executableCase_ = 2;
                  break;
                } // case 18
              case 24:
                {
                  int v = input.readInt32();
                  ensureAllowedSuccessCodesIsMutable();
                  allowedSuccessCodes_.addInt(v);
                  break;
                } // case 24
              case 26:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  ensureAllowedSuccessCodesIsMutable();
                  while (input.getBytesUntilLimit() > 0) {
                    allowedSuccessCodes_.addInt(input.readInt32());
                  }
                  input.popLimit(limit);
                  break;
                } // case 26
              case 32:
                {
                  interpreter_ = input.readEnum();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int executableCase_ = 0;
      private java.lang.Object executable_;

      public ExecutableCase getExecutableCase() {
        return ExecutableCase.forNumber(executableCase_);
      }

      public Builder clearExecutable() {
        executableCase_ = 0;
        executable_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * An absolute path to the executable on the VM.
       * </pre>
       *
       * <code>string local_path = 1;</code>
       *
       * @return Whether the localPath field is set.
       */
      @java.lang.Override
      public boolean hasLocalPath() {
        return executableCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * An absolute path to the executable on the VM.
       * </pre>
       *
       * <code>string local_path = 1;</code>
       *
       * @return The localPath.
       */
      @java.lang.Override
      public java.lang.String getLocalPath() {
        java.lang.Object ref = "";
        if (executableCase_ == 1) {
          ref = executable_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (executableCase_ == 1) {
            executable_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An absolute path to the executable on the VM.
       * </pre>
       *
       * <code>string local_path = 1;</code>
       *
       * @return The bytes for localPath.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLocalPathBytes() {
        java.lang.Object ref = "";
        if (executableCase_ == 1) {
          ref = executable_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (executableCase_ == 1) {
            executable_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An absolute path to the executable on the VM.
       * </pre>
       *
       * <code>string local_path = 1;</code>
       *
       * @param value The localPath to set.
       * @return This builder for chaining.
       */
      public Builder setLocalPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        executableCase_ = 1;
        executable_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An absolute path to the executable on the VM.
       * </pre>
       *
       * <code>string local_path = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocalPath() {
        if (executableCase_ == 1) {
          executableCase_ = 0;
          executable_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An absolute path to the executable on the VM.
       * </pre>
       *
       * <code>string local_path = 1;</code>
       *
       * @param value The bytes for localPath to set.
       * @return This builder for chaining.
       */
      public Builder setLocalPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        executableCase_ = 1;
        executable_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.GcsObject,
              com.google.cloud.osconfig.v1.PatchJobs.GcsObject.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.GcsObjectOrBuilder>
          gcsObjectBuilder_;
      /**
       *
       *
       * <pre>
       * A Cloud Storage object containing the executable.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
       *
       * @return Whether the gcsObject field is set.
       */
      @java.lang.Override
      public boolean hasGcsObject() {
        return executableCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object containing the executable.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
       *
       * @return The gcsObject.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.GcsObject getGcsObject() {
        if (gcsObjectBuilder_ == null) {
          if (executableCase_ == 2) {
            return (com.google.cloud.osconfig.v1.PatchJobs.GcsObject) executable_;
          }
          return com.google.cloud.osconfig.v1.PatchJobs.GcsObject.getDefaultInstance();
        } else {
          if (executableCase_ == 2) {
            return gcsObjectBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1.PatchJobs.GcsObject.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object containing the executable.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
       */
      public Builder setGcsObject(com.google.cloud.osconfig.v1.PatchJobs.GcsObject value) {
        if (gcsObjectBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          executable_ = value;
          onChanged();
        } else {
          gcsObjectBuilder_.setMessage(value);
        }
        executableCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object containing the executable.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
       */
      public Builder setGcsObject(
          com.google.cloud.osconfig.v1.PatchJobs.GcsObject.Builder builderForValue) {
        if (gcsObjectBuilder_ == null) {
          executable_ = builderForValue.build();
          onChanged();
        } else {
          gcsObjectBuilder_.setMessage(builderForValue.build());
        }
        executableCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object containing the executable.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
       */
      public Builder mergeGcsObject(com.google.cloud.osconfig.v1.PatchJobs.GcsObject value) {
        if (gcsObjectBuilder_ == null) {
          if (executableCase_ == 2
              && executable_
                  != com.google.cloud.osconfig.v1.PatchJobs.GcsObject.getDefaultInstance()) {
            executable_ =
                com.google.cloud.osconfig.v1.PatchJobs.GcsObject.newBuilder(
                        (com.google.cloud.osconfig.v1.PatchJobs.GcsObject) executable_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            executable_ = value;
          }
          onChanged();
        } else {
          if (executableCase_ == 2) {
            gcsObjectBuilder_.mergeFrom(value);
          } else {
            gcsObjectBuilder_.setMessage(value);
          }
        }
        executableCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object containing the executable.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
       */
      public Builder clearGcsObject() {
        if (gcsObjectBuilder_ == null) {
          if (executableCase_ == 2) {
            executableCase_ = 0;
            executable_ = null;
            onChanged();
          }
        } else {
          if (executableCase_ == 2) {
            executableCase_ = 0;
            executable_ = null;
          }
          gcsObjectBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object containing the executable.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
       */
      public com.google.cloud.osconfig.v1.PatchJobs.GcsObject.Builder getGcsObjectBuilder() {
        return getGcsObjectFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object containing the executable.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.GcsObjectOrBuilder getGcsObjectOrBuilder() {
        if ((executableCase_ == 2) && (gcsObjectBuilder_ != null)) {
          return gcsObjectBuilder_.getMessageOrBuilder();
        } else {
          if (executableCase_ == 2) {
            return (com.google.cloud.osconfig.v1.PatchJobs.GcsObject) executable_;
          }
          return com.google.cloud.osconfig.v1.PatchJobs.GcsObject.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage object containing the executable.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.GcsObject gcs_object = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1.PatchJobs.GcsObject,
              com.google.cloud.osconfig.v1.PatchJobs.GcsObject.Builder,
              com.google.cloud.osconfig.v1.PatchJobs.GcsObjectOrBuilder>
          getGcsObjectFieldBuilder() {
        if (gcsObjectBuilder_ == null) {
          if (!(executableCase_ == 2)) {
            executable_ = com.google.cloud.osconfig.v1.PatchJobs.GcsObject.getDefaultInstance();
          }
          gcsObjectBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1.PatchJobs.GcsObject,
                  com.google.cloud.osconfig.v1.PatchJobs.GcsObject.Builder,
                  com.google.cloud.osconfig.v1.PatchJobs.GcsObjectOrBuilder>(
                  (com.google.cloud.osconfig.v1.PatchJobs.GcsObject) executable_,
                  getParentForChildren(),
                  isClean());
          executable_ = null;
        }
        executableCase_ = 2;
        onChanged();
        return gcsObjectBuilder_;
      }

      private com.google.protobuf.Internal.IntList allowedSuccessCodes_ = emptyIntList();

      private void ensureAllowedSuccessCodesIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          allowedSuccessCodes_ = mutableCopy(allowedSuccessCodes_);
          bitField0_ |= 0x00000004;
        }
      }
      /**
       *
       *
       * <pre>
       * Defaults to [0]. A list of possible return values that the
       * execution can return to indicate a success.
       * </pre>
       *
       * <code>repeated int32 allowed_success_codes = 3;</code>
       *
       * @return A list containing the allowedSuccessCodes.
       */
      public java.util.List<java.lang.Integer> getAllowedSuccessCodesList() {
        return ((bitField0_ & 0x00000004) != 0)
            ? java.util.Collections.unmodifiableList(allowedSuccessCodes_)
            : allowedSuccessCodes_;
      }
      /**
       *
       *
       * <pre>
       * Defaults to [0]. A list of possible return values that the
       * execution can return to indicate a success.
       * </pre>
       *
       * <code>repeated int32 allowed_success_codes = 3;</code>
       *
       * @return The count of allowedSuccessCodes.
       */
      public int getAllowedSuccessCodesCount() {
        return allowedSuccessCodes_.size();
      }
      /**
       *
       *
       * <pre>
       * Defaults to [0]. A list of possible return values that the
       * execution can return to indicate a success.
       * </pre>
       *
       * <code>repeated int32 allowed_success_codes = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The allowedSuccessCodes at the given index.
       */
      public int getAllowedSuccessCodes(int index) {
        return allowedSuccessCodes_.getInt(index);
      }
      /**
       *
       *
       * <pre>
       * Defaults to [0]. A list of possible return values that the
       * execution can return to indicate a success.
       * </pre>
       *
       * <code>repeated int32 allowed_success_codes = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The allowedSuccessCodes to set.
       * @return This builder for chaining.
       */
      public Builder setAllowedSuccessCodes(int index, int value) {

        ensureAllowedSuccessCodesIsMutable();
        allowedSuccessCodes_.setInt(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defaults to [0]. A list of possible return values that the
       * execution can return to indicate a success.
       * </pre>
       *
       * <code>repeated int32 allowed_success_codes = 3;</code>
       *
       * @param value The allowedSuccessCodes to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedSuccessCodes(int value) {

        ensureAllowedSuccessCodesIsMutable();
        allowedSuccessCodes_.addInt(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defaults to [0]. A list of possible return values that the
       * execution can return to indicate a success.
       * </pre>
       *
       * <code>repeated int32 allowed_success_codes = 3;</code>
       *
       * @param values The allowedSuccessCodes to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllowedSuccessCodes(
          java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureAllowedSuccessCodesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedSuccessCodes_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defaults to [0]. A list of possible return values that the
       * execution can return to indicate a success.
       * </pre>
       *
       * <code>repeated int32 allowed_success_codes = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowedSuccessCodes() {
        allowedSuccessCodes_ = emptyIntList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      private int interpreter_ = 0;
      /**
       *
       *
       * <pre>
       * The script interpreter to use to run the script. If no interpreter is
       * specified the script will be executed directly, which will likely
       * only succeed for scripts with [shebang lines]
       * (https://en.wikipedia.org/wiki/Shebang_&#92;(Unix&#92;)).
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig.Interpreter interpreter = 4;</code>
       *
       * @return The enum numeric value on the wire for interpreter.
       */
      @java.lang.Override
      public int getInterpreterValue() {
        return interpreter_;
      }
      /**
       *
       *
       * <pre>
       * The script interpreter to use to run the script. If no interpreter is
       * specified the script will be executed directly, which will likely
       * only succeed for scripts with [shebang lines]
       * (https://en.wikipedia.org/wiki/Shebang_&#92;(Unix&#92;)).
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig.Interpreter interpreter = 4;</code>
       *
       * @param value The enum numeric value on the wire for interpreter to set.
       * @return This builder for chaining.
       */
      public Builder setInterpreterValue(int value) {
        interpreter_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The script interpreter to use to run the script. If no interpreter is
       * specified the script will be executed directly, which will likely
       * only succeed for scripts with [shebang lines]
       * (https://en.wikipedia.org/wiki/Shebang_&#92;(Unix&#92;)).
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig.Interpreter interpreter = 4;</code>
       *
       * @return The interpreter.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Interpreter getInterpreter() {
        com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Interpreter result =
            com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Interpreter.forNumber(
                interpreter_);
        return result == null
            ? com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Interpreter.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The script interpreter to use to run the script. If no interpreter is
       * specified the script will be executed directly, which will likely
       * only succeed for scripts with [shebang lines]
       * (https://en.wikipedia.org/wiki/Shebang_&#92;(Unix&#92;)).
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig.Interpreter interpreter = 4;</code>
       *
       * @param value The interpreter to set.
       * @return This builder for chaining.
       */
      public Builder setInterpreter(
          com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig.Interpreter value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        interpreter_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The script interpreter to use to run the script. If no interpreter is
       * specified the script will be executed directly, which will likely
       * only succeed for scripts with [shebang lines]
       * (https://en.wikipedia.org/wiki/Shebang_&#92;(Unix&#92;)).
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1.ExecStepConfig.Interpreter interpreter = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInterpreter() {
        bitField0_ = (bitField0_ & ~0x00000008);
        interpreter_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1.ExecStepConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1.ExecStepConfig)
    private static final com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig();
    }

    public static com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExecStepConfig> PARSER =
        new com.google.protobuf.AbstractParser<ExecStepConfig>() {
          @java.lang.Override
          public ExecStepConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExecStepConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExecStepConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1.PatchJobs.ExecStepConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GcsObjectOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1.GcsObject)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Bucket of the Cloud Storage object.
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucket.
     */
    java.lang.String getBucket();
    /**
     *
     *
     * <pre>
     * Required. Bucket of the Cloud Storage object.
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucket.
     */
    com.google.protobuf.ByteString getBucketBytes();

    /**
     *
     *
     * <pre>
     * Required. Name of the Cloud Storage object.
     * </pre>
     *
     * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The object.
     */
    java.lang.String getObject();
    /**
     *
     *
     * <pre>
     * Required. Name of the Cloud Storage object.
     * </pre>
     *
     * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for object.
     */
    com.google.protobuf.ByteString getObjectBytes();

    /**
     *
     *
     * <pre>
     * Required. Generation number of the Cloud Storage object. This is used to
     * ensure that the ExecStep specified by this PatchJob does not change.
     * </pre>
     *
     * <code>int64 generation_number = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The generationNumber.
     */
    long getGenerationNumber();
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage object representation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1.GcsObject}
   */
  public static final class GcsObject extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1.GcsObject)
      GcsObjectOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GcsObject.newBuilder() to construct.
    private GcsObject(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GcsObject() {
      bucket_ = "";
      object_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GcsObject();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_GcsObject_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1.PatchJobs
          .internal_static_google_cloud_osconfig_v1_GcsObject_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1.PatchJobs.GcsObject.class,
              com.google.cloud.osconfig.v1.PatchJobs.GcsObject.Builder.class);
    }

    public static final int BUCKET_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object bucket_ = "";
    /**
     *
     *
     * <pre>
     * Required. Bucket of the Cloud Storage object.
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucket.
     */
    @java.lang.Override
    public java.lang.String getBucket() {
      java.lang.Object ref = bucket_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucket_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Bucket of the Cloud Storage object.
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucket.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBucketBytes() {
      java.lang.Object ref = bucket_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OBJECT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object object_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the Cloud Storage object.
     * </pre>
     *
     * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The object.
     */
    @java.lang.Override
    public java.lang.String getObject() {
      java.lang.Object ref = object_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        object_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the Cloud Storage object.
     * </pre>
     *
     * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for object.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getObjectBytes() {
      java.lang.Object ref = object_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        object_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GENERATION_NUMBER_FIELD_NUMBER = 3;
    private long generationNumber_ = 0L;
    /**
     *
     *
     * <pre>
     * Required. Generation number of the Cloud Storage object. This is used to
     * ensure that the ExecStep specified by this PatchJob does not change.
     * </pre>
     *
     * <code>int64 generation_number = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The generationNumber.
     */
    @java.lang.Override
    public long getGenerationNumber() {
      return generationNumber_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucket_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(object_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, object_);
      }
      if 