/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.osconfig.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InstanceName
implements ResourceName {
    private static final PathTemplate PROJECT_ZONE_INSTANCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/zones/{zone}/instances/{instance}");
    private static final PathTemplate PROJECT_LOCATION_INSTANCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/instances/{instance}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String zone;
    private final String instance;
    private final String location;

    @Deprecated
    protected InstanceName() {
        this.project = null;
        this.zone = null;
        this.instance = null;
        this.location = null;
    }

    private InstanceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.location = null;
        this.pathTemplate = PROJECT_ZONE_INSTANCE;
    }

    private InstanceName(ProjectLocationInstanceBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.zone = null;
        this.pathTemplate = PROJECT_LOCATION_INSTANCE;
    }

    public String getProject() {
        return this.project;
    }

    public String getZone() {
        return this.zone;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectZoneInstanceBuilder() {
        return new Builder();
    }

    public static ProjectLocationInstanceBuilder newProjectLocationInstanceBuilder() {
        return new ProjectLocationInstanceBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InstanceName of(String project, String zone, String instance) {
        return InstanceName.newBuilder().setProject(project).setZone(zone).setInstance(instance).build();
    }

    public static InstanceName ofProjectZoneInstanceName(String project, String zone, String instance) {
        return InstanceName.newBuilder().setProject(project).setZone(zone).setInstance(instance).build();
    }

    public static InstanceName ofProjectLocationInstanceName(String project, String location, String instance) {
        return InstanceName.newProjectLocationInstanceBuilder().setProject(project).setLocation(location).setInstance(instance).build();
    }

    public static String format(String project, String zone, String instance) {
        return InstanceName.newBuilder().setProject(project).setZone(zone).setInstance(instance).build().toString();
    }

    public static String formatProjectZoneInstanceName(String project, String zone, String instance) {
        return InstanceName.newBuilder().setProject(project).setZone(zone).setInstance(instance).build().toString();
    }

    public static String formatProjectLocationInstanceName(String project, String location, String instance) {
        return InstanceName.newProjectLocationInstanceBuilder().setProject(project).setLocation(location).setInstance(instance).build().toString();
    }

    public static InstanceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_ZONE_INSTANCE.matches(formattedString)) {
            Map matchMap = PROJECT_ZONE_INSTANCE.match(formattedString);
            return InstanceName.ofProjectZoneInstanceName((String)matchMap.get("project"), (String)matchMap.get("zone"), (String)matchMap.get("instance"));
        }
        if (PROJECT_LOCATION_INSTANCE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_INSTANCE.match(formattedString);
            return InstanceName.ofProjectLocationInstanceName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("instance"));
        }
        throw new ValidationException("InstanceName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<InstanceName> parseList(List<String> formattedStrings) {
        ArrayList<InstanceName> list = new ArrayList<InstanceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InstanceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InstanceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InstanceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_ZONE_INSTANCE.matches(formattedString) || PROJECT_LOCATION_INSTANCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InstanceName instanceName = this;
            synchronized (instanceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.zone != null) {
                        fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            InstanceName that = (InstanceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.zone, that.zone) && Objects.equals(this.instance, that.instance) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.zone);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationInstanceBuilder {
        private String project;
        private String location;
        private String instance;

        protected ProjectLocationInstanceBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public ProjectLocationInstanceBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationInstanceBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationInstanceBuilder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public InstanceName build() {
            return new InstanceName(this);
        }
    }

    public static class Builder {
        private String project;
        private String zone;
        private String instance;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        private Builder(InstanceName instanceName) {
            Preconditions.checkArgument((boolean)Objects.equals(instanceName.pathTemplate, PROJECT_ZONE_INSTANCE), (Object)"toBuilder is only supported when InstanceName has the pattern of projects/{project}/zones/{zone}/instances/{instance}");
            this.project = instanceName.project;
            this.zone = instanceName.zone;
            this.instance = instanceName.instance;
        }

        public InstanceName build() {
            return new InstanceName(this);
        }
    }
}

