/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.osconfig.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InstanceOSPolicyAssignmentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSTANCE_ASSIGNMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String instance;
    private final String assignment;

    @Deprecated
    protected InstanceOSPolicyAssignmentName() {
        this.project = null;
        this.location = null;
        this.instance = null;
        this.assignment = null;
    }

    private InstanceOSPolicyAssignmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.assignment = (String)Preconditions.checkNotNull((Object)builder.getAssignment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getAssignment() {
        return this.assignment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InstanceOSPolicyAssignmentName of(String project, String location, String instance, String assignment) {
        return InstanceOSPolicyAssignmentName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setAssignment(assignment).build();
    }

    public static String format(String project, String location, String instance, String assignment) {
        return InstanceOSPolicyAssignmentName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setAssignment(assignment).build().toString();
    }

    public static InstanceOSPolicyAssignmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INSTANCE_ASSIGNMENT.validatedMatch(formattedString, "InstanceOSPolicyAssignmentName.parse: formattedString not in valid format");
        return InstanceOSPolicyAssignmentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("instance"), (String)matchMap.get("assignment"));
    }

    public static List<InstanceOSPolicyAssignmentName> parseList(List<String> formattedStrings) {
        ArrayList<InstanceOSPolicyAssignmentName> list = new ArrayList<InstanceOSPolicyAssignmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InstanceOSPolicyAssignmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InstanceOSPolicyAssignmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InstanceOSPolicyAssignmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSTANCE_ASSIGNMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InstanceOSPolicyAssignmentName instanceOSPolicyAssignmentName = this;
            synchronized (instanceOSPolicyAssignmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.assignment != null) {
                        fieldMapBuilder.put((Object)"assignment", (Object)this.assignment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INSTANCE_ASSIGNMENT.instantiate(new String[]{"project", this.project, "location", this.location, "instance", this.instance, "assignment", this.assignment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            InstanceOSPolicyAssignmentName that = (InstanceOSPolicyAssignmentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance) && Objects.equals(this.assignment, that.assignment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.assignment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String instance;
        private String assignment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getAssignment() {
            return this.assignment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setAssignment(String assignment) {
            this.assignment = assignment;
            return this;
        }

        private Builder(InstanceOSPolicyAssignmentName instanceOSPolicyAssignmentName) {
            this.project = instanceOSPolicyAssignmentName.project;
            this.location = instanceOSPolicyAssignmentName.location;
            this.instance = instanceOSPolicyAssignmentName.instance;
            this.assignment = instanceOSPolicyAssignmentName.assignment;
        }

        public InstanceOSPolicyAssignmentName build() {
            return new InstanceOSPolicyAssignmentName(this);
        }
    }
}

