/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1alpha/instance_os_policies_compliance.proto

package com.google.cloud.osconfig.v1alpha;

/**
 *
 *
 * <pre>
 * This API resource represents the OS policies compliance data for a Compute
 * Engine virtual machine (VM) instance at a given point in time.
 *
 * A Compute Engine VM can have multiple OS policy assignments, and each
 * assignment can have multiple OS policies. As a result, multiple OS policies
 * could be applied to a single VM.
 *
 * You can use this API resource to determine both the compliance state of your
 * VM as well as the compliance state of an individual OS policy.
 *
 * For more information, see [View
 * compliance](https://cloud.google.com/compute/docs/os-configuration-management/view-compliance).
 * </pre>
 *
 * Protobuf type {@code google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance}
 */
@java.lang.Deprecated
public final class InstanceOSPoliciesCompliance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance)
    InstanceOSPoliciesComplianceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InstanceOSPoliciesCompliance.newBuilder() to construct.
  private InstanceOSPoliciesCompliance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InstanceOSPoliciesCompliance() {
    name_ = "";
    instance_ = "";
    state_ = 0;
    detailedState_ = "";
    detailedStateReason_ = "";
    osPolicyCompliances_ = java.util.Collections.emptyList();
    lastComplianceRunId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InstanceOSPoliciesCompliance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesComplianceProto
        .internal_static_google_cloud_osconfig_v1alpha_InstanceOSPoliciesCompliance_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesComplianceProto
        .internal_static_google_cloud_osconfig_v1alpha_InstanceOSPoliciesCompliance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.class,
            com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.Builder.class);
  }

  @java.lang.Deprecated
  public interface OSPolicyComplianceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The OS policy id
     * </pre>
     *
     * <code>string os_policy_id = 1;</code>
     *
     * @return The osPolicyId.
     */
    java.lang.String getOsPolicyId();
    /**
     *
     *
     * <pre>
     * The OS policy id
     * </pre>
     *
     * <code>string os_policy_id = 1;</code>
     *
     * @return The bytes for osPolicyId.
     */
    com.google.protobuf.ByteString getOsPolicyIdBytes();

    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
     * belongs to.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The osPolicyAssignment.
     */
    java.lang.String getOsPolicyAssignment();
    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
     * belongs to.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for osPolicyAssignment.
     */
    com.google.protobuf.ByteString getOsPolicyAssignmentBytes();

    /**
     *
     *
     * <pre>
     * Compliance state of the OS policy.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 4;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Compliance state of the OS policy.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 4;</code>
     *
     * @return The state.
     */
    com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState getState();

    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicyResource` that is applied to the
     * VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
     * </code>
     */
    java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance>
        getOsPolicyResourceCompliancesList();
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicyResource` that is applied to the
     * VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance getOsPolicyResourceCompliances(
        int index);
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicyResource` that is applied to the
     * VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
     * </code>
     */
    int getOsPolicyResourceCompliancesCount();
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicyResource` that is applied to the
     * VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
     * </code>
     */
    java.util.List<? extends com.google.cloud.osconfig.v1alpha.OSPolicyResourceComplianceOrBuilder>
        getOsPolicyResourceCompliancesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicyResource` that is applied to the
     * VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.OSPolicyResourceComplianceOrBuilder
        getOsPolicyResourceCompliancesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Compliance data for an OS policy
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance}
   */
  @java.lang.Deprecated
  public static final class OSPolicyCompliance extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance)
      OSPolicyComplianceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OSPolicyCompliance.newBuilder() to construct.
    private OSPolicyCompliance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OSPolicyCompliance() {
      osPolicyId_ = "";
      osPolicyAssignment_ = "";
      state_ = 0;
      osPolicyResourceCompliances_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OSPolicyCompliance();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesComplianceProto
          .internal_static_google_cloud_osconfig_v1alpha_InstanceOSPoliciesCompliance_OSPolicyCompliance_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesComplianceProto
          .internal_static_google_cloud_osconfig_v1alpha_InstanceOSPoliciesCompliance_OSPolicyCompliance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
                  .class,
              com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
                  .Builder.class);
    }

    public static final int OS_POLICY_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object osPolicyId_ = "";
    /**
     *
     *
     * <pre>
     * The OS policy id
     * </pre>
     *
     * <code>string os_policy_id = 1;</code>
     *
     * @return The osPolicyId.
     */
    @java.lang.Override
    public java.lang.String getOsPolicyId() {
      java.lang.Object ref = osPolicyId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        osPolicyId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The OS policy id
     * </pre>
     *
     * <code>string os_policy_id = 1;</code>
     *
     * @return The bytes for osPolicyId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOsPolicyIdBytes() {
      java.lang.Object ref = osPolicyId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        osPolicyId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OS_POLICY_ASSIGNMENT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object osPolicyAssignment_ = "";
    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
     * belongs to.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The osPolicyAssignment.
     */
    @java.lang.Override
    public java.lang.String getOsPolicyAssignment() {
      java.lang.Object ref = osPolicyAssignment_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        osPolicyAssignment_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
     * belongs to.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for osPolicyAssignment.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOsPolicyAssignmentBytes() {
      java.lang.Object ref = osPolicyAssignment_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        osPolicyAssignment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATE_FIELD_NUMBER = 4;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Compliance state of the OS policy.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 4;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Compliance state of the OS policy.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 4;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState getState() {
      com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState result =
          com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState.forNumber(state_);
      return result == null
          ? com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState.UNRECOGNIZED
          : result;
    }

    public static final int OS_POLICY_RESOURCE_COMPLIANCES_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance>
        osPolicyResourceCompliances_;
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicyResource` that is applied to the
     * VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance>
        getOsPolicyResourceCompliancesList() {
      return osPolicyResourceCompliances_;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicyResource` that is applied to the
     * VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.osconfig.v1alpha.OSPolicyResourceComplianceOrBuilder>
        getOsPolicyResourceCompliancesOrBuilderList() {
      return osPolicyResourceCompliances_;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicyResource` that is applied to the
     * VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
     * </code>
     */
    @java.lang.Override
    public int getOsPolicyResourceCompliancesCount() {
      return osPolicyResourceCompliances_.size();
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicyResource` that is applied to the
     * VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance
        getOsPolicyResourceCompliances(int index) {
      return osPolicyResourceCompliances_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Compliance data for each `OSPolicyResource` that is applied to the
     * VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceComplianceOrBuilder
        getOsPolicyResourceCompliancesOrBuilder(int index) {
      return osPolicyResourceCompliances_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, osPolicyId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyAssignment_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, osPolicyAssignment_);
      }
      if (state_
          != com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState
              .OS_POLICY_COMPLIANCE_STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, state_);
      }
      for (int i = 0; i < osPolicyResourceCompliances_.size(); i++) {
        output.writeMessage(5, osPolicyResourceCompliances_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, osPolicyId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyAssignment_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, osPolicyAssignment_);
      }
      if (state_
          != com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState
              .OS_POLICY_COMPLIANCE_STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
      }
      for (int i = 0; i < osPolicyResourceCompliances_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, osPolicyResourceCompliances_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance other =
          (com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance) obj;

      if (!getOsPolicyId().equals(other.getOsPolicyId())) return false;
      if (!getOsPolicyAssignment().equals(other.getOsPolicyAssignment())) return false;
      if (state_ != other.state_) return false;
      if (!getOsPolicyResourceCompliancesList().equals(other.getOsPolicyResourceCompliancesList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OS_POLICY_ID_FIELD_NUMBER;
      hash = (53 * hash) + getOsPolicyId().hashCode();
      hash = (37 * hash) + OS_POLICY_ASSIGNMENT_FIELD_NUMBER;
      hash = (53 * hash) + getOsPolicyAssignment().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      if (getOsPolicyResourceCompliancesCount() > 0) {
        hash = (37 * hash) + OS_POLICY_RESOURCE_COMPLIANCES_FIELD_NUMBER;
        hash = (53 * hash) + getOsPolicyResourceCompliancesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Compliance data for an OS policy
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance)
        com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyComplianceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesComplianceProto
            .internal_static_google_cloud_osconfig_v1alpha_InstanceOSPoliciesCompliance_OSPolicyCompliance_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesComplianceProto
            .internal_static_google_cloud_osconfig_v1alpha_InstanceOSPoliciesCompliance_OSPolicyCompliance_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
                    .class,
                com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        osPolicyId_ = "";
        osPolicyAssignment_ = "";
        state_ = 0;
        if (osPolicyResourceCompliancesBuilder_ == null) {
          osPolicyResourceCompliances_ = java.util.Collections.emptyList();
        } else {
          osPolicyResourceCompliances_ = null;
          osPolicyResourceCompliancesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesComplianceProto
            .internal_static_google_cloud_osconfig_v1alpha_InstanceOSPoliciesCompliance_OSPolicyCompliance_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
          build() {
        com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
          buildPartial() {
        com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance result =
            new com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
              result) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            osPolicyResourceCompliances_ =
                java.util.Collections.unmodifiableList(osPolicyResourceCompliances_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.osPolicyResourceCompliances_ = osPolicyResourceCompliances_;
        } else {
          result.osPolicyResourceCompliances_ = osPolicyResourceCompliancesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.osPolicyId_ = osPolicyId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.osPolicyAssignment_ = osPolicyAssignment_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.state_ = state_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance other) {
        if (other
            == com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
                .getDefaultInstance()) return this;
        if (!other.getOsPolicyId().isEmpty()) {
          osPolicyId_ = other.osPolicyId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getOsPolicyAssignment().isEmpty()) {
          osPolicyAssignment_ = other.osPolicyAssignment_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (osPolicyResourceCompliancesBuilder_ == null) {
          if (!other.osPolicyResourceCompliances_.isEmpty()) {
            if (osPolicyResourceCompliances_.isEmpty()) {
              osPolicyResourceCompliances_ = other.osPolicyResourceCompliances_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureOsPolicyResourceCompliancesIsMutable();
              osPolicyResourceCompliances_.addAll(other.osPolicyResourceCompliances_);
            }
            onChanged();
          }
        } else {
          if (!other.osPolicyResourceCompliances_.isEmpty()) {
            if (osPolicyResourceCompliancesBuilder_.isEmpty()) {
              osPolicyResourceCompliancesBuilder_.dispose();
              osPolicyResourceCompliancesBuilder_ = null;
              osPolicyResourceCompliances_ = other.osPolicyResourceCompliances_;
              bitField0_ = (bitField0_ & ~0x00000008);
              osPolicyResourceCompliancesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getOsPolicyResourceCompliancesFieldBuilder()
                      : null;
            } else {
              osPolicyResourceCompliancesBuilder_.addAllMessages(
                  other.osPolicyResourceCompliances_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  osPolicyId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  osPolicyAssignment_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 32:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 32
              case 42:
                {
                  com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance m =
                      input.readMessage(
                          com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.parser(),
                          extensionRegistry);
                  if (osPolicyResourceCompliancesBuilder_ == null) {
                    ensureOsPolicyResourceCompliancesIsMutable();
                    osPolicyResourceCompliances_.add(m);
                  } else {
                    osPolicyResourceCompliancesBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object osPolicyId_ = "";
      /**
       *
       *
       * <pre>
       * The OS policy id
       * </pre>
       *
       * <code>string os_policy_id = 1;</code>
       *
       * @return The osPolicyId.
       */
      public java.lang.String getOsPolicyId() {
        java.lang.Object ref = osPolicyId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          osPolicyId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The OS policy id
       * </pre>
       *
       * <code>string os_policy_id = 1;</code>
       *
       * @return The bytes for osPolicyId.
       */
      public com.google.protobuf.ByteString getOsPolicyIdBytes() {
        java.lang.Object ref = osPolicyId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          osPolicyId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The OS policy id
       * </pre>
       *
       * <code>string os_policy_id = 1;</code>
       *
       * @param value The osPolicyId to set.
       * @return This builder for chaining.
       */
      public Builder setOsPolicyId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        osPolicyId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The OS policy id
       * </pre>
       *
       * <code>string os_policy_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOsPolicyId() {
        osPolicyId_ = getDefaultInstance().getOsPolicyId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The OS policy id
       * </pre>
       *
       * <code>string os_policy_id = 1;</code>
       *
       * @param value The bytes for osPolicyId to set.
       * @return This builder for chaining.
       */
      public Builder setOsPolicyIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        osPolicyId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object osPolicyAssignment_ = "";
      /**
       *
       *
       * <pre>
       * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
       * belongs to.
       *
       * Format:
       * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
       * </pre>
       *
       * <code>string os_policy_assignment = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The osPolicyAssignment.
       */
      public java.lang.String getOsPolicyAssignment() {
        java.lang.Object ref = osPolicyAssignment_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          osPolicyAssignment_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
       * belongs to.
       *
       * Format:
       * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
       * </pre>
       *
       * <code>string os_policy_assignment = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for osPolicyAssignment.
       */
      public com.google.protobuf.ByteString getOsPolicyAssignmentBytes() {
        java.lang.Object ref = osPolicyAssignment_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          osPolicyAssignment_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
       * belongs to.
       *
       * Format:
       * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
       * </pre>
       *
       * <code>string os_policy_assignment = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The osPolicyAssignment to set.
       * @return This builder for chaining.
       */
      public Builder setOsPolicyAssignment(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        osPolicyAssignment_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
       * belongs to.
       *
       * Format:
       * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
       * </pre>
       *
       * <code>string os_policy_assignment = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOsPolicyAssignment() {
        osPolicyAssignment_ = getDefaultInstance().getOsPolicyAssignment();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
       * belongs to.
       *
       * Format:
       * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
       * </pre>
       *
       * <code>string os_policy_assignment = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for osPolicyAssignment to set.
       * @return This builder for chaining.
       */
      public Builder setOsPolicyAssignmentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        osPolicyAssignment_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Compliance state of the OS policy.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 4;</code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Compliance state of the OS policy.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 4;</code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance state of the OS policy.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 4;</code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState getState() {
        com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState result =
            com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState.forNumber(state_);
        return result == null
            ? com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Compliance state of the OS policy.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 4;</code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance state of the OS policy.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000004);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance>
          osPolicyResourceCompliances_ = java.util.Collections.emptyList();

      private void ensureOsPolicyResourceCompliancesIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          osPolicyResourceCompliances_ =
              new java.util.ArrayList<com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance>(
                  osPolicyResourceCompliances_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance,
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.Builder,
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceComplianceOrBuilder>
          osPolicyResourceCompliancesBuilder_;

      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance>
          getOsPolicyResourceCompliancesList() {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(osPolicyResourceCompliances_);
        } else {
          return osPolicyResourceCompliancesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public int getOsPolicyResourceCompliancesCount() {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          return osPolicyResourceCompliances_.size();
        } else {
          return osPolicyResourceCompliancesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance
          getOsPolicyResourceCompliances(int index) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          return osPolicyResourceCompliances_.get(index);
        } else {
          return osPolicyResourceCompliancesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public Builder setOsPolicyResourceCompliances(
          int index, com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance value) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.set(index, value);
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public Builder setOsPolicyResourceCompliances(
          int index,
          com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.Builder builderForValue) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.set(index, builderForValue.build());
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public Builder addOsPolicyResourceCompliances(
          com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance value) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.add(value);
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public Builder addOsPolicyResourceCompliances(
          int index, com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance value) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.add(index, value);
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public Builder addOsPolicyResourceCompliances(
          com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.Builder builderForValue) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.add(builderForValue.build());
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public Builder addOsPolicyResourceCompliances(
          int index,
          com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.Builder builderForValue) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.add(index, builderForValue.build());
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public Builder addAllOsPolicyResourceCompliances(
          java.lang.Iterable<? extends com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance>
              values) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          ensureOsPolicyResourceCompliancesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, osPolicyResourceCompliances_);
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public Builder clearOsPolicyResourceCompliances() {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          osPolicyResourceCompliances_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public Builder removeOsPolicyResourceCompliances(int index) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          ensureOsPolicyResourceCompliancesIsMutable();
          osPolicyResourceCompliances_.remove(index);
          onChanged();
        } else {
          osPolicyResourceCompliancesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.Builder
          getOsPolicyResourceCompliancesBuilder(int index) {
        return getOsPolicyResourceCompliancesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyResourceComplianceOrBuilder
          getOsPolicyResourceCompliancesOrBuilder(int index) {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          return osPolicyResourceCompliances_.get(index);
        } else {
          return osPolicyResourceCompliancesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.osconfig.v1alpha.OSPolicyResourceComplianceOrBuilder>
          getOsPolicyResourceCompliancesOrBuilderList() {
        if (osPolicyResourceCompliancesBuilder_ != null) {
          return osPolicyResourceCompliancesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(osPolicyResourceCompliances_);
        }
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.Builder
          addOsPolicyResourceCompliancesBuilder() {
        return getOsPolicyResourceCompliancesFieldBuilder()
            .addBuilder(
                com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.Builder
          addOsPolicyResourceCompliancesBuilder(int index) {
        return getOsPolicyResourceCompliancesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Compliance data for each `OSPolicyResource` that is applied to the
       * VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance os_policy_resource_compliances = 5;
       * </code>
       */
      public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.Builder>
          getOsPolicyResourceCompliancesBuilderList() {
        return getOsPolicyResourceCompliancesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance,
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.Builder,
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceComplianceOrBuilder>
          getOsPolicyResourceCompliancesFieldBuilder() {
        if (osPolicyResourceCompliancesBuilder_ == null) {
          osPolicyResourceCompliancesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance,
                  com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.Builder,
                  com.google.cloud.osconfig.v1alpha.OSPolicyResourceComplianceOrBuilder>(
                  osPolicyResourceCompliances_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          osPolicyResourceCompliances_ = null;
        }
        return osPolicyResourceCompliancesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance)
    private static final com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
            .OSPolicyCompliance
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance();
    }

    public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OSPolicyCompliance> PARSER =
        new com.google.protobuf.AbstractParser<OSPolicyCompliance>() {
          @java.lang.Override
          public OSPolicyCompliance parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OSPolicyCompliance> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OSPolicyCompliance> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The `InstanceOSPoliciesCompliance` API resource name.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/instanceOSPoliciesCompliances/{instance_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The `InstanceOSPoliciesCompliance` API resource name.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/instanceOSPoliciesCompliances/{instance_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instance_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The Compute Engine VM instance name.
   * </pre>
   *
   * <code>string instance = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The instance.
   */
  @java.lang.Override
  public java.lang.String getInstance() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instance_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Compute Engine VM instance name.
   * </pre>
   *
   * <code>string instance = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for instance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceBytes() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Compliance state of the VM.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Compliance state of the VM.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState getState() {
    com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState result =
        com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState.forNumber(state_);
    return result == null
        ? com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState.UNRECOGNIZED
        : result;
  }

  public static final int DETAILED_STATE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object detailedState_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Detailed compliance state of the VM.
   * This field is populated only when compliance state is `UNKNOWN`.
   *
   * It may contain one of the following values:
   *
   * * `no-compliance-data`: Compliance data is not available for this VM.
   * * `no-agent-detected`: OS Config agent is not detected for this VM.
   * * `config-not-supported-by-agent`: The version of the OS Config agent
   * running on this VM does not support configuration management.
   * * `inactive`: VM is not running.
   * * `internal-service-errors`: There were internal service errors encountered
   * while enforcing compliance.
   * * `agent-errors`: OS config agent encountered errors while enforcing
   * compliance.
   * </pre>
   *
   * <code>string detailed_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The detailedState.
   */
  @java.lang.Override
  public java.lang.String getDetailedState() {
    java.lang.Object ref = detailedState_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      detailedState_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Detailed compliance state of the VM.
   * This field is populated only when compliance state is `UNKNOWN`.
   *
   * It may contain one of the following values:
   *
   * * `no-compliance-data`: Compliance data is not available for this VM.
   * * `no-agent-detected`: OS Config agent is not detected for this VM.
   * * `config-not-supported-by-agent`: The version of the OS Config agent
   * running on this VM does not support configuration management.
   * * `inactive`: VM is not running.
   * * `internal-service-errors`: There were internal service errors encountered
   * while enforcing compliance.
   * * `agent-errors`: OS config agent encountered errors while enforcing
   * compliance.
   * </pre>
   *
   * <code>string detailed_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for detailedState.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDetailedStateBytes() {
    java.lang.Object ref = detailedState_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      detailedState_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DETAILED_STATE_REASON_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object detailedStateReason_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The reason for the `detailed_state` of the VM (if any).
   * </pre>
   *
   * <code>string detailed_state_reason = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The detailedStateReason.
   */
  @java.lang.Override
  public java.lang.String getDetailedStateReason() {
    java.lang.Object ref = detailedStateReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      detailedStateReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The reason for the `detailed_state` of the VM (if any).
   * </pre>
   *
   * <code>string detailed_state_reason = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for detailedStateReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDetailedStateReasonBytes() {
    java.lang.Object ref = detailedStateReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      detailedStateReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OS_POLICY_COMPLIANCES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance>
      osPolicyCompliances_;
  /**
   *
   *
   * <pre>
   * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance>
      getOsPolicyCompliancesList() {
    return osPolicyCompliances_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
                  .OSPolicyComplianceOrBuilder>
      getOsPolicyCompliancesOrBuilderList() {
    return osPolicyCompliances_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getOsPolicyCompliancesCount() {
    return osPolicyCompliances_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
      getOsPolicyCompliances(int index) {
    return osPolicyCompliances_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyComplianceOrBuilder
      getOsPolicyCompliancesOrBuilder(int index) {
    return osPolicyCompliances_.get(index);
  }

  public static final int LAST_COMPLIANCE_CHECK_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp lastComplianceCheckTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last compliance check for the VM.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastComplianceCheckTime field is set.
   */
  @java.lang.Override
  public boolean hasLastComplianceCheckTime() {
    return lastComplianceCheckTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last compliance check for the VM.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastComplianceCheckTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastComplianceCheckTime() {
    return lastComplianceCheckTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastComplianceCheckTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last compliance check for the VM.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastComplianceCheckTimeOrBuilder() {
    return lastComplianceCheckTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastComplianceCheckTime_;
  }

  public static final int LAST_COMPLIANCE_RUN_ID_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastComplianceRunId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier for the last compliance run.
   * This id will be logged by the OS config agent during a compliance run and
   * can be used for debugging and tracing purpose.
   * </pre>
   *
   * <code>string last_compliance_run_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The lastComplianceRunId.
   */
  @java.lang.Override
  public java.lang.String getLastComplianceRunId() {
    java.lang.Object ref = lastComplianceRunId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastComplianceRunId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier for the last compliance run.
   * This id will be logged by the OS config agent during a compliance run and
   * can be used for debugging and tracing purpose.
   * </pre>
   *
   * <code>string last_compliance_run_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for lastComplianceRunId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastComplianceRunIdBytes() {
    java.lang.Object ref = lastComplianceRunId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastComplianceRunId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instance_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, instance_);
    }
    if (state_
        != com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState
            .OS_POLICY_COMPLIANCE_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detailedState_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, detailedState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detailedStateReason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, detailedStateReason_);
    }
    for (int i = 0; i < osPolicyCompliances_.size(); i++) {
      output.writeMessage(6, osPolicyCompliances_.get(i));
    }
    if (lastComplianceCheckTime_ != null) {
      output.writeMessage(7, getLastComplianceCheckTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastComplianceRunId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, lastComplianceRunId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instance_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, instance_);
    }
    if (state_
        != com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState
            .OS_POLICY_COMPLIANCE_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detailedState_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, detailedState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detailedStateReason_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, detailedStateReason_);
    }
    for (int i = 0; i < osPolicyCompliances_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, osPolicyCompliances_.get(i));
    }
    if (lastComplianceCheckTime_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, getLastComplianceCheckTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastComplianceRunId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, lastComplianceRunId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance)) {
      return super.equals(obj);
    }
    com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance other =
        (com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getInstance().equals(other.getInstance())) return false;
    if (state_ != other.state_) return false;
    if (!getDetailedState().equals(other.getDetailedState())) return false;
    if (!getDetailedStateReason().equals(other.getDetailedStateReason())) return false;
    if (!getOsPolicyCompliancesList().equals(other.getOsPolicyCompliancesList())) return false;
    if (hasLastComplianceCheckTime() != other.hasLastComplianceCheckTime()) return false;
    if (hasLastComplianceCheckTime()) {
      if (!getLastComplianceCheckTime().equals(other.getLastComplianceCheckTime())) return false;
    }
    if (!getLastComplianceRunId().equals(other.getLastComplianceRunId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
    hash = (53 * hash) + getInstance().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + DETAILED_STATE_FIELD_NUMBER;
    hash = (53 * hash) + getDetailedState().hashCode();
    hash = (37 * hash) + DETAILED_STATE_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getDetailedStateReason().hashCode();
    if (getOsPolicyCompliancesCount() > 0) {
      hash = (37 * hash) + OS_POLICY_COMPLIANCES_FIELD_NUMBER;
      hash = (53 * hash) + getOsPolicyCompliancesList().hashCode();
    }
    if (hasLastComplianceCheckTime()) {
      hash = (37 * hash) + LAST_COMPLIANCE_CHECK_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastComplianceCheckTime().hashCode();
    }
    hash = (37 * hash) + LAST_COMPLIANCE_RUN_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLastComplianceRunId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * This API resource represents the OS policies compliance data for a Compute
   * Engine virtual machine (VM) instance at a given point in time.
   *
   * A Compute Engine VM can have multiple OS policy assignments, and each
   * assignment can have multiple OS policies. As a result, multiple OS policies
   * could be applied to a single VM.
   *
   * You can use this API resource to determine both the compliance state of your
   * VM as well as the compliance state of an individual OS policy.
   *
   * For more information, see [View
   * compliance](https://cloud.google.com/compute/docs/os-configuration-management/view-compliance).
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance)
      com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesComplianceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesComplianceProto
          .internal_static_google_cloud_osconfig_v1alpha_InstanceOSPoliciesCompliance_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesComplianceProto
          .internal_static_google_cloud_osconfig_v1alpha_InstanceOSPoliciesCompliance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.class,
              com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.Builder.class);
    }

    // Construct using com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      instance_ = "";
      state_ = 0;
      detailedState_ = "";
      detailedStateReason_ = "";
      if (osPolicyCompliancesBuilder_ == null) {
        osPolicyCompliances_ = java.util.Collections.emptyList();
      } else {
        osPolicyCompliances_ = null;
        osPolicyCompliancesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      lastComplianceCheckTime_ = null;
      if (lastComplianceCheckTimeBuilder_ != null) {
        lastComplianceCheckTimeBuilder_.dispose();
        lastComplianceCheckTimeBuilder_ = null;
      }
      lastComplianceRunId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesComplianceProto
          .internal_static_google_cloud_osconfig_v1alpha_InstanceOSPoliciesCompliance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
        getDefaultInstanceForType() {
      return com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance build() {
      com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance buildPartial() {
      com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance result =
          new com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance result) {
      if (osPolicyCompliancesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          osPolicyCompliances_ = java.util.Collections.unmodifiableList(osPolicyCompliances_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.osPolicyCompliances_ = osPolicyCompliances_;
      } else {
        result.osPolicyCompliances_ = osPolicyCompliancesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.instance_ = instance_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.detailedState_ = detailedState_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.detailedStateReason_ = detailedStateReason_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.lastComplianceCheckTime_ =
            lastComplianceCheckTimeBuilder_ == null
                ? lastComplianceCheckTime_
                : lastComplianceCheckTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.lastComplianceRunId_ = lastComplianceRunId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance) {
        return mergeFrom((com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance other) {
      if (other
          == com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getInstance().isEmpty()) {
        instance_ = other.instance_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getDetailedState().isEmpty()) {
        detailedState_ = other.detailedState_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDetailedStateReason().isEmpty()) {
        detailedStateReason_ = other.detailedStateReason_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (osPolicyCompliancesBuilder_ == null) {
        if (!other.osPolicyCompliances_.isEmpty()) {
          if (osPolicyCompliances_.isEmpty()) {
            osPolicyCompliances_ = other.osPolicyCompliances_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureOsPolicyCompliancesIsMutable();
            osPolicyCompliances_.addAll(other.osPolicyCompliances_);
          }
          onChanged();
        }
      } else {
        if (!other.osPolicyCompliances_.isEmpty()) {
          if (osPolicyCompliancesBuilder_.isEmpty()) {
            osPolicyCompliancesBuilder_.dispose();
            osPolicyCompliancesBuilder_ = null;
            osPolicyCompliances_ = other.osPolicyCompliances_;
            bitField0_ = (bitField0_ & ~0x00000020);
            osPolicyCompliancesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOsPolicyCompliancesFieldBuilder()
                    : null;
          } else {
            osPolicyCompliancesBuilder_.addAllMessages(other.osPolicyCompliances_);
          }
        }
      }
      if (other.hasLastComplianceCheckTime()) {
        mergeLastComplianceCheckTime(other.getLastComplianceCheckTime());
      }
      if (!other.getLastComplianceRunId().isEmpty()) {
        lastComplianceRunId_ = other.lastComplianceRunId_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                instance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                detailedState_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                detailedStateReason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
                    m =
                        input.readMessage(
                            com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
                                .OSPolicyCompliance.parser(),
                            extensionRegistry);
                if (osPolicyCompliancesBuilder_ == null) {
                  ensureOsPolicyCompliancesIsMutable();
                  osPolicyCompliances_.add(m);
                } else {
                  osPolicyCompliancesBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getLastComplianceCheckTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                lastComplianceRunId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The `InstanceOSPoliciesCompliance` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instanceOSPoliciesCompliances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The `InstanceOSPoliciesCompliance` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instanceOSPoliciesCompliances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The `InstanceOSPoliciesCompliance` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instanceOSPoliciesCompliances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The `InstanceOSPoliciesCompliance` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instanceOSPoliciesCompliances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The `InstanceOSPoliciesCompliance` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instanceOSPoliciesCompliances/{instance_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object instance_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Compute Engine VM instance name.
     * </pre>
     *
     * <code>string instance = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The instance.
     */
    public java.lang.String getInstance() {
      java.lang.Object ref = instance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Compute Engine VM instance name.
     * </pre>
     *
     * <code>string instance = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for instance.
     */
    public com.google.protobuf.ByteString getInstanceBytes() {
      java.lang.Object ref = instance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Compute Engine VM instance name.
     * </pre>
     *
     * <code>string instance = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instance_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Compute Engine VM instance name.
     * </pre>
     *
     * <code>string instance = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstance() {
      instance_ = getDefaultInstance().getInstance();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Compute Engine VM instance name.
     * </pre>
     *
     * <code>string instance = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instance_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Compliance state of the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance state of the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance state of the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState getState() {
      com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState result =
          com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState.forNumber(state_);
      return result == null
          ? com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance state of the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance state of the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object detailedState_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Detailed compliance state of the VM.
     * This field is populated only when compliance state is `UNKNOWN`.
     *
     * It may contain one of the following values:
     *
     * * `no-compliance-data`: Compliance data is not available for this VM.
     * * `no-agent-detected`: OS Config agent is not detected for this VM.
     * * `config-not-supported-by-agent`: The version of the OS Config agent
     * running on this VM does not support configuration management.
     * * `inactive`: VM is not running.
     * * `internal-service-errors`: There were internal service errors encountered
     * while enforcing compliance.
     * * `agent-errors`: OS config agent encountered errors while enforcing
     * compliance.
     * </pre>
     *
     * <code>string detailed_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The detailedState.
     */
    public java.lang.String getDetailedState() {
      java.lang.Object ref = detailedState_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        detailedState_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed compliance state of the VM.
     * This field is populated only when compliance state is `UNKNOWN`.
     *
     * It may contain one of the following values:
     *
     * * `no-compliance-data`: Compliance data is not available for this VM.
     * * `no-agent-detected`: OS Config agent is not detected for this VM.
     * * `config-not-supported-by-agent`: The version of the OS Config agent
     * running on this VM does not support configuration management.
     * * `inactive`: VM is not running.
     * * `internal-service-errors`: There were internal service errors encountered
     * while enforcing compliance.
     * * `agent-errors`: OS config agent encountered errors while enforcing
     * compliance.
     * </pre>
     *
     * <code>string detailed_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for detailedState.
     */
    public com.google.protobuf.ByteString getDetailedStateBytes() {
      java.lang.Object ref = detailedState_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        detailedState_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed compliance state of the VM.
     * This field is populated only when compliance state is `UNKNOWN`.
     *
     * It may contain one of the following values:
     *
     * * `no-compliance-data`: Compliance data is not available for this VM.
     * * `no-agent-detected`: OS Config agent is not detected for this VM.
     * * `config-not-supported-by-agent`: The version of the OS Config agent
     * running on this VM does not support configuration management.
     * * `inactive`: VM is not running.
     * * `internal-service-errors`: There were internal service errors encountered
     * while enforcing compliance.
     * * `agent-errors`: OS config agent encountered errors while enforcing
     * compliance.
     * </pre>
     *
     * <code>string detailed_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The detailedState to set.
     * @return This builder for chaining.
     */
    public Builder setDetailedState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      detailedState_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed compliance state of the VM.
     * This field is populated only when compliance state is `UNKNOWN`.
     *
     * It may contain one of the following values:
     *
     * * `no-compliance-data`: Compliance data is not available for this VM.
     * * `no-agent-detected`: OS Config agent is not detected for this VM.
     * * `config-not-supported-by-agent`: The version of the OS Config agent
     * running on this VM does not support configuration management.
     * * `inactive`: VM is not running.
     * * `internal-service-errors`: There were internal service errors encountered
     * while enforcing compliance.
     * * `agent-errors`: OS config agent encountered errors while enforcing
     * compliance.
     * </pre>
     *
     * <code>string detailed_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDetailedState() {
      detailedState_ = getDefaultInstance().getDetailedState();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed compliance state of the VM.
     * This field is populated only when compliance state is `UNKNOWN`.
     *
     * It may contain one of the following values:
     *
     * * `no-compliance-data`: Compliance data is not available for this VM.
     * * `no-agent-detected`: OS Config agent is not detected for this VM.
     * * `config-not-supported-by-agent`: The version of the OS Config agent
     * running on this VM does not support configuration management.
     * * `inactive`: VM is not running.
     * * `internal-service-errors`: There were internal service errors encountered
     * while enforcing compliance.
     * * `agent-errors`: OS config agent encountered errors while enforcing
     * compliance.
     * </pre>
     *
     * <code>string detailed_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for detailedState to set.
     * @return This builder for chaining.
     */
    public Builder setDetailedStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      detailedState_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object detailedStateReason_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The reason for the `detailed_state` of the VM (if any).
     * </pre>
     *
     * <code>string detailed_state_reason = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The detailedStateReason.
     */
    public java.lang.String getDetailedStateReason() {
      java.lang.Object ref = detailedStateReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        detailedStateReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason for the `detailed_state` of the VM (if any).
     * </pre>
     *
     * <code>string detailed_state_reason = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for detailedStateReason.
     */
    public com.google.protobuf.ByteString getDetailedStateReasonBytes() {
      java.lang.Object ref = detailedStateReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        detailedStateReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason for the `detailed_state` of the VM (if any).
     * </pre>
     *
     * <code>string detailed_state_reason = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The detailedStateReason to set.
     * @return This builder for chaining.
     */
    public Builder setDetailedStateReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      detailedStateReason_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason for the `detailed_state` of the VM (if any).
     * </pre>
     *
     * <code>string detailed_state_reason = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDetailedStateReason() {
      detailedStateReason_ = getDefaultInstance().getDetailedStateReason();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason for the `detailed_state` of the VM (if any).
     * </pre>
     *
     * <code>string detailed_state_reason = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for detailedStateReason to set.
     * @return This builder for chaining.
     */
    public Builder setDetailedStateReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      detailedStateReason_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance>
        osPolicyCompliances_ = java.util.Collections.emptyList();

    private void ensureOsPolicyCompliancesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        osPolicyCompliances_ =
            new java.util.ArrayList<
                com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance>(
                osPolicyCompliances_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance,
            com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
                .Builder,
            com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
                .OSPolicyComplianceOrBuilder>
        osPolicyCompliancesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance>
        getOsPolicyCompliancesList() {
      if (osPolicyCompliancesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(osPolicyCompliances_);
      } else {
        return osPolicyCompliancesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getOsPolicyCompliancesCount() {
      if (osPolicyCompliancesBuilder_ == null) {
        return osPolicyCompliances_.size();
      } else {
        return osPolicyCompliancesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
        getOsPolicyCompliances(int index) {
      if (osPolicyCompliancesBuilder_ == null) {
        return osPolicyCompliances_.get(index);
      } else {
        return osPolicyCompliancesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOsPolicyCompliances(
        int index,
        com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance value) {
      if (osPolicyCompliancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.set(index, value);
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOsPolicyCompliances(
        int index,
        com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance.Builder
            builderForValue) {
      if (osPolicyCompliancesBuilder_ == null) {
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.set(index, builderForValue.build());
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addOsPolicyCompliances(
        com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance value) {
      if (osPolicyCompliancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.add(value);
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addOsPolicyCompliances(
        int index,
        com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance value) {
      if (osPolicyCompliancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.add(index, value);
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addOsPolicyCompliances(
        com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance.Builder
            builderForValue) {
      if (osPolicyCompliancesBuilder_ == null) {
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.add(builderForValue.build());
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addOsPolicyCompliances(
        int index,
        com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance.Builder
            builderForValue) {
      if (osPolicyCompliancesBuilder_ == null) {
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.add(index, builderForValue.build());
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllOsPolicyCompliances(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
                        .OSPolicyCompliance>
            values) {
      if (osPolicyCompliancesBuilder_ == null) {
        ensureOsPolicyCompliancesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, osPolicyCompliances_);
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOsPolicyCompliances() {
      if (osPolicyCompliancesBuilder_ == null) {
        osPolicyCompliances_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeOsPolicyCompliances(int index) {
      if (osPolicyCompliancesBuilder_ == null) {
        ensureOsPolicyCompliancesIsMutable();
        osPolicyCompliances_.remove(index);
        onChanged();
      } else {
        osPolicyCompliancesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance.Builder
        getOsPolicyCompliancesBuilder(int index) {
      return getOsPolicyCompliancesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
            .OSPolicyComplianceOrBuilder
        getOsPolicyCompliancesOrBuilder(int index) {
      if (osPolicyCompliancesBuilder_ == null) {
        return osPolicyCompliances_.get(index);
      } else {
        return osPolicyCompliancesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
                    .OSPolicyComplianceOrBuilder>
        getOsPolicyCompliancesOrBuilderList() {
      if (osPolicyCompliancesBuilder_ != null) {
        return osPolicyCompliancesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(osPolicyCompliances_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance.Builder
        addOsPolicyCompliancesBuilder() {
      return getOsPolicyCompliancesFieldBuilder()
          .addBuilder(
              com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance.Builder
        addOsPolicyCompliancesBuilder(int index) {
      return getOsPolicyCompliancesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
                .Builder>
        getOsPolicyCompliancesBuilderList() {
      return getOsPolicyCompliancesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance,
            com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
                .Builder,
            com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
                .OSPolicyComplianceOrBuilder>
        getOsPolicyCompliancesFieldBuilder() {
      if (osPolicyCompliancesBuilder_ == null) {
        osPolicyCompliancesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance,
                com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
                    .Builder,
                com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
                    .OSPolicyComplianceOrBuilder>(
                osPolicyCompliances_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        osPolicyCompliances_ = null;
      }
      return osPolicyCompliancesBuilder_;
    }

    private com.google.protobuf.Timestamp lastComplianceCheckTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastComplianceCheckTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last compliance check for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastComplianceCheckTime field is set.
     */
    public boolean hasLastComplianceCheckTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last compliance check for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastComplianceCheckTime.
     */
    public com.google.protobuf.Timestamp getLastComplianceCheckTime() {
      if (lastComplianceCheckTimeBuilder_ == null) {
        return lastComplianceCheckTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastComplianceCheckTime_;
      } else {
        return lastComplianceCheckTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last compliance check for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastComplianceCheckTime(com.google.protobuf.Timestamp value) {
      if (lastComplianceCheckTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastComplianceCheckTime_ = value;
      } else {
        lastComplianceCheckTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last compliance check for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastComplianceCheckTime(
        com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastComplianceCheckTimeBuilder_ == null) {
        lastComplianceCheckTime_ = builderForValue.build();
      } else {
        lastComplianceCheckTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last compliance check for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastComplianceCheckTime(com.google.protobuf.Timestamp value) {
      if (lastComplianceCheckTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && lastComplianceCheckTime_ != null
            && lastComplianceCheckTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastComplianceCheckTimeBuilder().mergeFrom(value);
        } else {
          lastComplianceCheckTime_ = value;
        }
      } else {
        lastComplianceCheckTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last compliance check for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastComplianceCheckTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      lastComplianceCheckTime_ = null;
      if (lastComplianceCheckTimeBuilder_ != null) {
        lastComplianceCheckTimeBuilder_.dispose();
        lastComplianceCheckTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last compliance check for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastComplianceCheckTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getLastComplianceCheckTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last compliance check for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastComplianceCheckTimeOrBuilder() {
      if (lastComplianceCheckTimeBuilder_ != null) {
        return lastComplianceCheckTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastComplianceCheckTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastComplianceCheckTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last compliance check for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastComplianceCheckTimeFieldBuilder() {
      if (lastComplianceCheckTimeBuilder_ == null) {
        lastComplianceCheckTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastComplianceCheckTime(), getParentForChildren(), isClean());
        lastComplianceCheckTime_ = null;
      }
      return lastComplianceCheckTimeBuilder_;
    }

    private java.lang.Object lastComplianceRunId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the last compliance run.
     * This id will be logged by the OS config agent during a compliance run and
     * can be used for debugging and tracing purpose.
     * </pre>
     *
     * <code>string last_compliance_run_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The lastComplianceRunId.
     */
    public java.lang.String getLastComplianceRunId() {
      java.lang.Object ref = lastComplianceRunId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastComplianceRunId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the last compliance run.
     * This id will be logged by the OS config agent during a compliance run and
     * can be used for debugging and tracing purpose.
     * </pre>
     *
     * <code>string last_compliance_run_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for lastComplianceRunId.
     */
    public com.google.protobuf.ByteString getLastComplianceRunIdBytes() {
      java.lang.Object ref = lastComplianceRunId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastComplianceRunId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the last compliance run.
     * This id will be logged by the OS config agent during a compliance run and
     * can be used for debugging and tracing purpose.
     * </pre>
     *
     * <code>string last_compliance_run_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The lastComplianceRunId to set.
     * @return This builder for chaining.
     */
    public Builder setLastComplianceRunId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastComplianceRunId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the last compliance run.
     * This id will be logged by the OS config agent during a compliance run and
     * can be used for debugging and tracing purpose.
     * </pre>
     *
     * <code>string last_compliance_run_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastComplianceRunId() {
      lastComplianceRunId_ = getDefaultInstance().getLastComplianceRunId();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the last compliance run.
     * This id will be logged by the OS config agent during a compliance run and
     * can be used for debugging and tracing purpose.
     * </pre>
     *
     * <code>string last_compliance_run_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for lastComplianceRunId to set.
     * @return This builder for chaining.
     */
    public Builder setLastComplianceRunIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastComplianceRunId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance)
  private static final com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance();
  }

  public static com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InstanceOSPoliciesCompliance> PARSER =
      new com.google.protobuf.AbstractParser<InstanceOSPoliciesCompliance>() {
        @java.lang.Override
        public InstanceOSPoliciesCompliance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InstanceOSPoliciesCompliance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InstanceOSPoliciesCompliance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
