/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1alpha/instance_os_policies_compliance.proto

package com.google.cloud.osconfig.v1alpha;

@java.lang.Deprecated
public interface InstanceOSPoliciesComplianceOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. The `InstanceOSPoliciesCompliance` API resource name.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/instanceOSPoliciesCompliances/{instance_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. The `InstanceOSPoliciesCompliance` API resource name.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/instanceOSPoliciesCompliances/{instance_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The Compute Engine VM instance name.
   * </pre>
   *
   * <code>string instance = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The instance.
   */
  java.lang.String getInstance();
  /**
   *
   *
   * <pre>
   * Output only. The Compute Engine VM instance name.
   * </pre>
   *
   * <code>string instance = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for instance.
   */
  com.google.protobuf.ByteString getInstanceBytes();

  /**
   *
   *
   * <pre>
   * Output only. Compliance state of the VM.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. Compliance state of the VM.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState getState();

  /**
   *
   *
   * <pre>
   * Output only. Detailed compliance state of the VM.
   * This field is populated only when compliance state is `UNKNOWN`.
   *
   * It may contain one of the following values:
   *
   * * `no-compliance-data`: Compliance data is not available for this VM.
   * * `no-agent-detected`: OS Config agent is not detected for this VM.
   * * `config-not-supported-by-agent`: The version of the OS Config agent
   * running on this VM does not support configuration management.
   * * `inactive`: VM is not running.
   * * `internal-service-errors`: There were internal service errors encountered
   * while enforcing compliance.
   * * `agent-errors`: OS config agent encountered errors while enforcing
   * compliance.
   * </pre>
   *
   * <code>string detailed_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The detailedState.
   */
  java.lang.String getDetailedState();
  /**
   *
   *
   * <pre>
   * Output only. Detailed compliance state of the VM.
   * This field is populated only when compliance state is `UNKNOWN`.
   *
   * It may contain one of the following values:
   *
   * * `no-compliance-data`: Compliance data is not available for this VM.
   * * `no-agent-detected`: OS Config agent is not detected for this VM.
   * * `config-not-supported-by-agent`: The version of the OS Config agent
   * running on this VM does not support configuration management.
   * * `inactive`: VM is not running.
   * * `internal-service-errors`: There were internal service errors encountered
   * while enforcing compliance.
   * * `agent-errors`: OS config agent encountered errors while enforcing
   * compliance.
   * </pre>
   *
   * <code>string detailed_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for detailedState.
   */
  com.google.protobuf.ByteString getDetailedStateBytes();

  /**
   *
   *
   * <pre>
   * Output only. The reason for the `detailed_state` of the VM (if any).
   * </pre>
   *
   * <code>string detailed_state_reason = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The detailedStateReason.
   */
  java.lang.String getDetailedStateReason();
  /**
   *
   *
   * <pre>
   * Output only. The reason for the `detailed_state` of the VM (if any).
   * </pre>
   *
   * <code>string detailed_state_reason = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for detailedStateReason.
   */
  com.google.protobuf.ByteString getDetailedStateReasonBytes();

  /**
   *
   *
   * <pre>
   * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance>
      getOsPolicyCompliancesList();
  /**
   *
   *
   * <pre>
   * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance
      getOsPolicyCompliances(int index);
  /**
   *
   *
   * <pre>
   * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getOsPolicyCompliancesCount();
  /**
   *
   *
   * <pre>
   * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<
          ? extends
              com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance
                  .OSPolicyComplianceOrBuilder>
      getOsPolicyCompliancesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Output only. Compliance data for each `OSPolicy` that is applied to the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyCompliance os_policy_compliances = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance.OSPolicyComplianceOrBuilder
      getOsPolicyCompliancesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last compliance check for the VM.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastComplianceCheckTime field is set.
   */
  boolean hasLastComplianceCheckTime();
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last compliance check for the VM.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastComplianceCheckTime.
   */
  com.google.protobuf.Timestamp getLastComplianceCheckTime();
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last compliance check for the VM.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_compliance_check_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getLastComplianceCheckTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Unique identifier for the last compliance run.
   * This id will be logged by the OS config agent during a compliance run and
   * can be used for debugging and tracing purpose.
   * </pre>
   *
   * <code>string last_compliance_run_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The lastComplianceRunId.
   */
  java.lang.String getLastComplianceRunId();
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier for the last compliance run.
   * This id will be logged by the OS config agent during a compliance run and
   * can be used for debugging and tracing purpose.
   * </pre>
   *
   * <code>string last_compliance_run_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for lastComplianceRunId.
   */
  com.google.protobuf.ByteString getLastComplianceRunIdBytes();
}
