/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1alpha/inventory.proto

package com.google.cloud.osconfig.v1alpha;

/**
 *
 *
 * <pre>
 * This API resource represents the available inventory data for a
 * Compute Engine virtual machine (VM) instance at a given point in time.
 *
 * You can use this API resource to determine the inventory data of your VM.
 *
 * For more information, see [Information provided by OS inventory
 * management](https://cloud.google.com/compute/docs/instances/os-inventory-management#data-collected).
 * </pre>
 *
 * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory}
 */
public final class Inventory extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.Inventory)
    InventoryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Inventory.newBuilder() to construct.
  private Inventory(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Inventory() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Inventory();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.osconfig.v1alpha.Inventories
        .internal_static_google_cloud_osconfig_v1alpha_Inventory_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetItems();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.osconfig.v1alpha.Inventories
        .internal_static_google_cloud_osconfig_v1alpha_Inventory_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.osconfig.v1alpha.Inventory.class,
            com.google.cloud.osconfig.v1alpha.Inventory.Builder.class);
  }

  public interface OsInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.Inventory.OsInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The VM hostname.
     * </pre>
     *
     * <code>string hostname = 9;</code>
     *
     * @return The hostname.
     */
    java.lang.String getHostname();
    /**
     *
     *
     * <pre>
     * The VM hostname.
     * </pre>
     *
     * <code>string hostname = 9;</code>
     *
     * @return The bytes for hostname.
     */
    com.google.protobuf.ByteString getHostnameBytes();

    /**
     *
     *
     * <pre>
     * The operating system long name.
     * For example 'Debian GNU/Linux 9' or 'Microsoft Window Server 2019
     * Datacenter'.
     * </pre>
     *
     * <code>string long_name = 2;</code>
     *
     * @return The longName.
     */
    java.lang.String getLongName();
    /**
     *
     *
     * <pre>
     * The operating system long name.
     * For example 'Debian GNU/Linux 9' or 'Microsoft Window Server 2019
     * Datacenter'.
     * </pre>
     *
     * <code>string long_name = 2;</code>
     *
     * @return The bytes for longName.
     */
    com.google.protobuf.ByteString getLongNameBytes();

    /**
     *
     *
     * <pre>
     * The operating system short name.
     * For example, 'windows' or 'debian'.
     * </pre>
     *
     * <code>string short_name = 3;</code>
     *
     * @return The shortName.
     */
    java.lang.String getShortName();
    /**
     *
     *
     * <pre>
     * The operating system short name.
     * For example, 'windows' or 'debian'.
     * </pre>
     *
     * <code>string short_name = 3;</code>
     *
     * @return The bytes for shortName.
     */
    com.google.protobuf.ByteString getShortNameBytes();

    /**
     *
     *
     * <pre>
     * The version of the operating system.
     * </pre>
     *
     * <code>string version = 4;</code>
     *
     * @return The version.
     */
    java.lang.String getVersion();
    /**
     *
     *
     * <pre>
     * The version of the operating system.
     * </pre>
     *
     * <code>string version = 4;</code>
     *
     * @return The bytes for version.
     */
    com.google.protobuf.ByteString getVersionBytes();

    /**
     *
     *
     * <pre>
     * The system architecture of the operating system.
     * </pre>
     *
     * <code>string architecture = 5;</code>
     *
     * @return The architecture.
     */
    java.lang.String getArchitecture();
    /**
     *
     *
     * <pre>
     * The system architecture of the operating system.
     * </pre>
     *
     * <code>string architecture = 5;</code>
     *
     * @return The bytes for architecture.
     */
    com.google.protobuf.ByteString getArchitectureBytes();

    /**
     *
     *
     * <pre>
     * The kernel version of the operating system.
     * </pre>
     *
     * <code>string kernel_version = 6;</code>
     *
     * @return The kernelVersion.
     */
    java.lang.String getKernelVersion();
    /**
     *
     *
     * <pre>
     * The kernel version of the operating system.
     * </pre>
     *
     * <code>string kernel_version = 6;</code>
     *
     * @return The bytes for kernelVersion.
     */
    com.google.protobuf.ByteString getKernelVersionBytes();

    /**
     *
     *
     * <pre>
     * The kernel release of the operating system.
     * </pre>
     *
     * <code>string kernel_release = 7;</code>
     *
     * @return The kernelRelease.
     */
    java.lang.String getKernelRelease();
    /**
     *
     *
     * <pre>
     * The kernel release of the operating system.
     * </pre>
     *
     * <code>string kernel_release = 7;</code>
     *
     * @return The bytes for kernelRelease.
     */
    com.google.protobuf.ByteString getKernelReleaseBytes();

    /**
     *
     *
     * <pre>
     * The current version of the OS Config agent running on the VM.
     * </pre>
     *
     * <code>string osconfig_agent_version = 8;</code>
     *
     * @return The osconfigAgentVersion.
     */
    java.lang.String getOsconfigAgentVersion();
    /**
     *
     *
     * <pre>
     * The current version of the OS Config agent running on the VM.
     * </pre>
     *
     * <code>string osconfig_agent_version = 8;</code>
     *
     * @return The bytes for osconfigAgentVersion.
     */
    com.google.protobuf.ByteString getOsconfigAgentVersionBytes();
  }
  /**
   *
   *
   * <pre>
   * Operating system information for the VM.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.OsInfo}
   */
  public static final class OsInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.Inventory.OsInfo)
      OsInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OsInfo.newBuilder() to construct.
    private OsInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OsInfo() {
      hostname_ = "";
      longName_ = "";
      shortName_ = "";
      version_ = "";
      architecture_ = "";
      kernelVersion_ = "";
      kernelRelease_ = "";
      osconfigAgentVersion_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OsInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_OsInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_OsInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.class,
              com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.Builder.class);
    }

    public static final int HOSTNAME_FIELD_NUMBER = 9;

    @SuppressWarnings("serial")
    private volatile java.lang.Object hostname_ = "";
    /**
     *
     *
     * <pre>
     * The VM hostname.
     * </pre>
     *
     * <code>string hostname = 9;</code>
     *
     * @return The hostname.
     */
    @java.lang.Override
    public java.lang.String getHostname() {
      java.lang.Object ref = hostname_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hostname_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The VM hostname.
     * </pre>
     *
     * <code>string hostname = 9;</code>
     *
     * @return The bytes for hostname.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHostnameBytes() {
      java.lang.Object ref = hostname_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hostname_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LONG_NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object longName_ = "";
    /**
     *
     *
     * <pre>
     * The operating system long name.
     * For example 'Debian GNU/Linux 9' or 'Microsoft Window Server 2019
     * Datacenter'.
     * </pre>
     *
     * <code>string long_name = 2;</code>
     *
     * @return The longName.
     */
    @java.lang.Override
    public java.lang.String getLongName() {
      java.lang.Object ref = longName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        longName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The operating system long name.
     * For example 'Debian GNU/Linux 9' or 'Microsoft Window Server 2019
     * Datacenter'.
     * </pre>
     *
     * <code>string long_name = 2;</code>
     *
     * @return The bytes for longName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLongNameBytes() {
      java.lang.Object ref = longName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        longName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SHORT_NAME_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object shortName_ = "";
    /**
     *
     *
     * <pre>
     * The operating system short name.
     * For example, 'windows' or 'debian'.
     * </pre>
     *
     * <code>string short_name = 3;</code>
     *
     * @return The shortName.
     */
    @java.lang.Override
    public java.lang.String getShortName() {
      java.lang.Object ref = shortName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        shortName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The operating system short name.
     * For example, 'windows' or 'debian'.
     * </pre>
     *
     * <code>string short_name = 3;</code>
     *
     * @return The bytes for shortName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getShortNameBytes() {
      java.lang.Object ref = shortName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        shortName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERSION_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * The version of the operating system.
     * </pre>
     *
     * <code>string version = 4;</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The version of the operating system.
     * </pre>
     *
     * <code>string version = 4;</code>
     *
     * @return The bytes for version.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ARCHITECTURE_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object architecture_ = "";
    /**
     *
     *
     * <pre>
     * The system architecture of the operating system.
     * </pre>
     *
     * <code>string architecture = 5;</code>
     *
     * @return The architecture.
     */
    @java.lang.Override
    public java.lang.String getArchitecture() {
      java.lang.Object ref = architecture_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        architecture_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The system architecture of the operating system.
     * </pre>
     *
     * <code>string architecture = 5;</code>
     *
     * @return The bytes for architecture.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getArchitectureBytes() {
      java.lang.Object ref = architecture_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        architecture_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KERNEL_VERSION_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object kernelVersion_ = "";
    /**
     *
     *
     * <pre>
     * The kernel version of the operating system.
     * </pre>
     *
     * <code>string kernel_version = 6;</code>
     *
     * @return The kernelVersion.
     */
    @java.lang.Override
    public java.lang.String getKernelVersion() {
      java.lang.Object ref = kernelVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kernelVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The kernel version of the operating system.
     * </pre>
     *
     * <code>string kernel_version = 6;</code>
     *
     * @return The bytes for kernelVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKernelVersionBytes() {
      java.lang.Object ref = kernelVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kernelVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KERNEL_RELEASE_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private volatile java.lang.Object kernelRelease_ = "";
    /**
     *
     *
     * <pre>
     * The kernel release of the operating system.
     * </pre>
     *
     * <code>string kernel_release = 7;</code>
     *
     * @return The kernelRelease.
     */
    @java.lang.Override
    public java.lang.String getKernelRelease() {
      java.lang.Object ref = kernelRelease_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kernelRelease_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The kernel release of the operating system.
     * </pre>
     *
     * <code>string kernel_release = 7;</code>
     *
     * @return The bytes for kernelRelease.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKernelReleaseBytes() {
      java.lang.Object ref = kernelRelease_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kernelRelease_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OSCONFIG_AGENT_VERSION_FIELD_NUMBER = 8;

    @SuppressWarnings("serial")
    private volatile java.lang.Object osconfigAgentVersion_ = "";
    /**
     *
     *
     * <pre>
     * The current version of the OS Config agent running on the VM.
     * </pre>
     *
     * <code>string osconfig_agent_version = 8;</code>
     *
     * @return The osconfigAgentVersion.
     */
    @java.lang.Override
    public java.lang.String getOsconfigAgentVersion() {
      java.lang.Object ref = osconfigAgentVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        osconfigAgentVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The current version of the OS Config agent running on the VM.
     * </pre>
     *
     * <code>string osconfig_agent_version = 8;</code>
     *
     * @return The bytes for osconfigAgentVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOsconfigAgentVersionBytes() {
      java.lang.Object ref = osconfigAgentVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        osconfigAgentVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(longName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, longName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(shortName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, shortName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, version_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(architecture_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, architecture_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kernelVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, kernelVersion_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kernelRelease_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, kernelRelease_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osconfigAgentVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, osconfigAgentVersion_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 9, hostname_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(longName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, longName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(shortName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, shortName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, version_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(architecture_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, architecture_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kernelVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, kernelVersion_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kernelRelease_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, kernelRelease_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osconfigAgentVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, osconfigAgentVersion_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, hostname_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1alpha.Inventory.OsInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.Inventory.OsInfo other =
          (com.google.cloud.osconfig.v1alpha.Inventory.OsInfo) obj;

      if (!getHostname().equals(other.getHostname())) return false;
      if (!getLongName().equals(other.getLongName())) return false;
      if (!getShortName().equals(other.getShortName())) return false;
      if (!getVersion().equals(other.getVersion())) return false;
      if (!getArchitecture().equals(other.getArchitecture())) return false;
      if (!getKernelVersion().equals(other.getKernelVersion())) return false;
      if (!getKernelRelease().equals(other.getKernelRelease())) return false;
      if (!getOsconfigAgentVersion().equals(other.getOsconfigAgentVersion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + HOSTNAME_FIELD_NUMBER;
      hash = (53 * hash) + getHostname().hashCode();
      hash = (37 * hash) + LONG_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getLongName().hashCode();
      hash = (37 * hash) + SHORT_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getShortName().hashCode();
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion().hashCode();
      hash = (37 * hash) + ARCHITECTURE_FIELD_NUMBER;
      hash = (53 * hash) + getArchitecture().hashCode();
      hash = (37 * hash) + KERNEL_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getKernelVersion().hashCode();
      hash = (37 * hash) + KERNEL_RELEASE_FIELD_NUMBER;
      hash = (53 * hash) + getKernelRelease().hashCode();
      hash = (37 * hash) + OSCONFIG_AGENT_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getOsconfigAgentVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.OsInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.OsInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.OsInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.OsInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.OsInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.OsInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.OsInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.OsInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.OsInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.OsInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.OsInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.OsInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.osconfig.v1alpha.Inventory.OsInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Operating system information for the VM.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.OsInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.Inventory.OsInfo)
        com.google.cloud.osconfig.v1alpha.Inventory.OsInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_OsInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_OsInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.class,
                com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        hostname_ = "";
        longName_ = "";
        shortName_ = "";
        version_ = "";
        architecture_ = "";
        kernelVersion_ = "";
        kernelRelease_ = "";
        osconfigAgentVersion_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_OsInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.OsInfo getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.OsInfo build() {
        com.google.cloud.osconfig.v1alpha.Inventory.OsInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.OsInfo buildPartial() {
        com.google.cloud.osconfig.v1alpha.Inventory.OsInfo result =
            new com.google.cloud.osconfig.v1alpha.Inventory.OsInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.osconfig.v1alpha.Inventory.OsInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.hostname_ = hostname_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.longName_ = longName_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.shortName_ = shortName_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.version_ = version_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.architecture_ = architecture_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.kernelVersion_ = kernelVersion_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.kernelRelease_ = kernelRelease_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.osconfigAgentVersion_ = osconfigAgentVersion_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1alpha.Inventory.OsInfo) {
          return mergeFrom((com.google.cloud.osconfig.v1alpha.Inventory.OsInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1alpha.Inventory.OsInfo other) {
        if (other == com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.getDefaultInstance())
          return this;
        if (!other.getHostname().isEmpty()) {
          hostname_ = other.hostname_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getLongName().isEmpty()) {
          longName_ = other.longName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getShortName().isEmpty()) {
          shortName_ = other.shortName_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getVersion().isEmpty()) {
          version_ = other.version_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getArchitecture().isEmpty()) {
          architecture_ = other.architecture_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (!other.getKernelVersion().isEmpty()) {
          kernelVersion_ = other.kernelVersion_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        if (!other.getKernelRelease().isEmpty()) {
          kernelRelease_ = other.kernelRelease_;
          bitField0_ |= 0x00000040;
          onChanged();
        }
        if (!other.getOsconfigAgentVersion().isEmpty()) {
          osconfigAgentVersion_ = other.osconfigAgentVersion_;
          bitField0_ |= 0x00000080;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  longName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  shortName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  version_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  architecture_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  kernelVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  kernelRelease_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              case 66:
                {
                  osconfigAgentVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 66
              case 74:
                {
                  hostname_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 74
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object hostname_ = "";
      /**
       *
       *
       * <pre>
       * The VM hostname.
       * </pre>
       *
       * <code>string hostname = 9;</code>
       *
       * @return The hostname.
       */
      public java.lang.String getHostname() {
        java.lang.Object ref = hostname_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          hostname_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The VM hostname.
       * </pre>
       *
       * <code>string hostname = 9;</code>
       *
       * @return The bytes for hostname.
       */
      public com.google.protobuf.ByteString getHostnameBytes() {
        java.lang.Object ref = hostname_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          hostname_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The VM hostname.
       * </pre>
       *
       * <code>string hostname = 9;</code>
       *
       * @param value The hostname to set.
       * @return This builder for chaining.
       */
      public Builder setHostname(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        hostname_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The VM hostname.
       * </pre>
       *
       * <code>string hostname = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHostname() {
        hostname_ = getDefaultInstance().getHostname();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The VM hostname.
       * </pre>
       *
       * <code>string hostname = 9;</code>
       *
       * @param value The bytes for hostname to set.
       * @return This builder for chaining.
       */
      public Builder setHostnameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        hostname_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object longName_ = "";
      /**
       *
       *
       * <pre>
       * The operating system long name.
       * For example 'Debian GNU/Linux 9' or 'Microsoft Window Server 2019
       * Datacenter'.
       * </pre>
       *
       * <code>string long_name = 2;</code>
       *
       * @return The longName.
       */
      public java.lang.String getLongName() {
        java.lang.Object ref = longName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          longName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The operating system long name.
       * For example 'Debian GNU/Linux 9' or 'Microsoft Window Server 2019
       * Datacenter'.
       * </pre>
       *
       * <code>string long_name = 2;</code>
       *
       * @return The bytes for longName.
       */
      public com.google.protobuf.ByteString getLongNameBytes() {
        java.lang.Object ref = longName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          longName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The operating system long name.
       * For example 'Debian GNU/Linux 9' or 'Microsoft Window Server 2019
       * Datacenter'.
       * </pre>
       *
       * <code>string long_name = 2;</code>
       *
       * @param value The longName to set.
       * @return This builder for chaining.
       */
      public Builder setLongName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        longName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operating system long name.
       * For example 'Debian GNU/Linux 9' or 'Microsoft Window Server 2019
       * Datacenter'.
       * </pre>
       *
       * <code>string long_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLongName() {
        longName_ = getDefaultInstance().getLongName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operating system long name.
       * For example 'Debian GNU/Linux 9' or 'Microsoft Window Server 2019
       * Datacenter'.
       * </pre>
       *
       * <code>string long_name = 2;</code>
       *
       * @param value The bytes for longName to set.
       * @return This builder for chaining.
       */
      public Builder setLongNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        longName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object shortName_ = "";
      /**
       *
       *
       * <pre>
       * The operating system short name.
       * For example, 'windows' or 'debian'.
       * </pre>
       *
       * <code>string short_name = 3;</code>
       *
       * @return The shortName.
       */
      public java.lang.String getShortName() {
        java.lang.Object ref = shortName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          shortName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The operating system short name.
       * For example, 'windows' or 'debian'.
       * </pre>
       *
       * <code>string short_name = 3;</code>
       *
       * @return The bytes for shortName.
       */
      public com.google.protobuf.ByteString getShortNameBytes() {
        java.lang.Object ref = shortName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          shortName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The operating system short name.
       * For example, 'windows' or 'debian'.
       * </pre>
       *
       * <code>string short_name = 3;</code>
       *
       * @param value The shortName to set.
       * @return This builder for chaining.
       */
      public Builder setShortName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        shortName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operating system short name.
       * For example, 'windows' or 'debian'.
       * </pre>
       *
       * <code>string short_name = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearShortName() {
        shortName_ = getDefaultInstance().getShortName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operating system short name.
       * For example, 'windows' or 'debian'.
       * </pre>
       *
       * <code>string short_name = 3;</code>
       *
       * @param value The bytes for shortName to set.
       * @return This builder for chaining.
       */
      public Builder setShortNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        shortName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object version_ = "";
      /**
       *
       *
       * <pre>
       * The version of the operating system.
       * </pre>
       *
       * <code>string version = 4;</code>
       *
       * @return The version.
       */
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The version of the operating system.
       * </pre>
       *
       * <code>string version = 4;</code>
       *
       * @return The bytes for version.
       */
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The version of the operating system.
       * </pre>
       *
       * <code>string version = 4;</code>
       *
       * @param value The version to set.
       * @return This builder for chaining.
       */
      public Builder setVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        version_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The version of the operating system.
       * </pre>
       *
       * <code>string version = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVersion() {
        version_ = getDefaultInstance().getVersion();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The version of the operating system.
       * </pre>
       *
       * <code>string version = 4;</code>
       *
       * @param value The bytes for version to set.
       * @return This builder for chaining.
       */
      public Builder setVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        version_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object architecture_ = "";
      /**
       *
       *
       * <pre>
       * The system architecture of the operating system.
       * </pre>
       *
       * <code>string architecture = 5;</code>
       *
       * @return The architecture.
       */
      public java.lang.String getArchitecture() {
        java.lang.Object ref = architecture_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          architecture_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The system architecture of the operating system.
       * </pre>
       *
       * <code>string architecture = 5;</code>
       *
       * @return The bytes for architecture.
       */
      public com.google.protobuf.ByteString getArchitectureBytes() {
        java.lang.Object ref = architecture_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          architecture_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The system architecture of the operating system.
       * </pre>
       *
       * <code>string architecture = 5;</code>
       *
       * @param value The architecture to set.
       * @return This builder for chaining.
       */
      public Builder setArchitecture(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        architecture_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The system architecture of the operating system.
       * </pre>
       *
       * <code>string architecture = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearArchitecture() {
        architecture_ = getDefaultInstance().getArchitecture();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The system architecture of the operating system.
       * </pre>
       *
       * <code>string architecture = 5;</code>
       *
       * @param value The bytes for architecture to set.
       * @return This builder for chaining.
       */
      public Builder setArchitectureBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        architecture_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private java.lang.Object kernelVersion_ = "";
      /**
       *
       *
       * <pre>
       * The kernel version of the operating system.
       * </pre>
       *
       * <code>string kernel_version = 6;</code>
       *
       * @return The kernelVersion.
       */
      public java.lang.String getKernelVersion() {
        java.lang.Object ref = kernelVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          kernelVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The kernel version of the operating system.
       * </pre>
       *
       * <code>string kernel_version = 6;</code>
       *
       * @return The bytes for kernelVersion.
       */
      public com.google.protobuf.ByteString getKernelVersionBytes() {
        java.lang.Object ref = kernelVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kernelVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The kernel version of the operating system.
       * </pre>
       *
       * <code>string kernel_version = 6;</code>
       *
       * @param value The kernelVersion to set.
       * @return This builder for chaining.
       */
      public Builder setKernelVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        kernelVersion_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The kernel version of the operating system.
       * </pre>
       *
       * <code>string kernel_version = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKernelVersion() {
        kernelVersion_ = getDefaultInstance().getKernelVersion();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The kernel version of the operating system.
       * </pre>
       *
       * <code>string kernel_version = 6;</code>
       *
       * @param value The bytes for kernelVersion to set.
       * @return This builder for chaining.
       */
      public Builder setKernelVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        kernelVersion_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      private java.lang.Object kernelRelease_ = "";
      /**
       *
       *
       * <pre>
       * The kernel release of the operating system.
       * </pre>
       *
       * <code>string kernel_release = 7;</code>
       *
       * @return The kernelRelease.
       */
      public java.lang.String getKernelRelease() {
        java.lang.Object ref = kernelRelease_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          kernelRelease_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The kernel release of the operating system.
       * </pre>
       *
       * <code>string kernel_release = 7;</code>
       *
       * @return The bytes for kernelRelease.
       */
      public com.google.protobuf.ByteString getKernelReleaseBytes() {
        java.lang.Object ref = kernelRelease_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kernelRelease_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The kernel release of the operating system.
       * </pre>
       *
       * <code>string kernel_release = 7;</code>
       *
       * @param value The kernelRelease to set.
       * @return This builder for chaining.
       */
      public Builder setKernelRelease(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        kernelRelease_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The kernel release of the operating system.
       * </pre>
       *
       * <code>string kernel_release = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKernelRelease() {
        kernelRelease_ = getDefaultInstance().getKernelRelease();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The kernel release of the operating system.
       * </pre>
       *
       * <code>string kernel_release = 7;</code>
       *
       * @param value The bytes for kernelRelease to set.
       * @return This builder for chaining.
       */
      public Builder setKernelReleaseBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        kernelRelease_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      private java.lang.Object osconfigAgentVersion_ = "";
      /**
       *
       *
       * <pre>
       * The current version of the OS Config agent running on the VM.
       * </pre>
       *
       * <code>string osconfig_agent_version = 8;</code>
       *
       * @return The osconfigAgentVersion.
       */
      public java.lang.String getOsconfigAgentVersion() {
        java.lang.Object ref = osconfigAgentVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          osconfigAgentVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The current version of the OS Config agent running on the VM.
       * </pre>
       *
       * <code>string osconfig_agent_version = 8;</code>
       *
       * @return The bytes for osconfigAgentVersion.
       */
      public com.google.protobuf.ByteString getOsconfigAgentVersionBytes() {
        java.lang.Object ref = osconfigAgentVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          osconfigAgentVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The current version of the OS Config agent running on the VM.
       * </pre>
       *
       * <code>string osconfig_agent_version = 8;</code>
       *
       * @param value The osconfigAgentVersion to set.
       * @return This builder for chaining.
       */
      public Builder setOsconfigAgentVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        osconfigAgentVersion_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current version of the OS Config agent running on the VM.
       * </pre>
       *
       * <code>string osconfig_agent_version = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOsconfigAgentVersion() {
        osconfigAgentVersion_ = getDefaultInstance().getOsconfigAgentVersion();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current version of the OS Config agent running on the VM.
       * </pre>
       *
       * <code>string osconfig_agent_version = 8;</code>
       *
       * @param value The bytes for osconfigAgentVersion to set.
       * @return This builder for chaining.
       */
      public Builder setOsconfigAgentVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        osconfigAgentVersion_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.Inventory.OsInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.Inventory.OsInfo)
    private static final com.google.cloud.osconfig.v1alpha.Inventory.OsInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.Inventory.OsInfo();
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.OsInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OsInfo> PARSER =
        new com.google.protobuf.AbstractParser<OsInfo>() {
          @java.lang.Override
          public OsInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OsInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OsInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.OsInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ItemOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.Inventory.Item)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Identifier for this item, unique across items for this VM.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * Identifier for this item, unique across items for this VM.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * The origin of this inventory item.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType origin_type = 2;</code>
     *
     * @return The enum numeric value on the wire for originType.
     */
    int getOriginTypeValue();
    /**
     *
     *
     * <pre>
     * The origin of this inventory item.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType origin_type = 2;</code>
     *
     * @return The originType.
     */
    com.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType getOriginType();

    /**
     *
     *
     * <pre>
     * When this inventory item was first detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 8;</code>
     *
     * @return Whether the createTime field is set.
     */
    boolean hasCreateTime();
    /**
     *
     *
     * <pre>
     * When this inventory item was first detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 8;</code>
     *
     * @return The createTime.
     */
    com.google.protobuf.Timestamp getCreateTime();
    /**
     *
     *
     * <pre>
     * When this inventory item was first detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 8;</code>
     */
    com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * When this inventory item was last modified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 9;</code>
     *
     * @return Whether the updateTime field is set.
     */
    boolean hasUpdateTime();
    /**
     *
     *
     * <pre>
     * When this inventory item was last modified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 9;</code>
     *
     * @return The updateTime.
     */
    com.google.protobuf.Timestamp getUpdateTime();
    /**
     *
     *
     * <pre>
     * When this inventory item was last modified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 9;</code>
     */
    com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The specific type of inventory, correlating to its specific details.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.Type type = 5;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * The specific type of inventory, correlating to its specific details.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.Type type = 5;</code>
     *
     * @return The type.
     */
    com.google.cloud.osconfig.v1alpha.Inventory.Item.Type getType();

    /**
     *
     *
     * <pre>
     * Software package present on the VM instance.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;</code>
     *
     * @return Whether the installedPackage field is set.
     */
    boolean hasInstalledPackage();
    /**
     *
     *
     * <pre>
     * Software package present on the VM instance.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;</code>
     *
     * @return The installedPackage.
     */
    com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage getInstalledPackage();
    /**
     *
     *
     * <pre>
     * Software package present on the VM instance.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;</code>
     */
    com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackageOrBuilder
        getInstalledPackageOrBuilder();

    /**
     *
     *
     * <pre>
     * Software package available to be installed on the VM instance.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;</code>
     *
     * @return Whether the availablePackage field is set.
     */
    boolean hasAvailablePackage();
    /**
     *
     *
     * <pre>
     * Software package available to be installed on the VM instance.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;</code>
     *
     * @return The availablePackage.
     */
    com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage getAvailablePackage();
    /**
     *
     *
     * <pre>
     * Software package available to be installed on the VM instance.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;</code>
     */
    com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackageOrBuilder
        getAvailablePackageOrBuilder();

    com.google.cloud.osconfig.v1alpha.Inventory.Item.DetailsCase getDetailsCase();
  }
  /**
   *
   *
   * <pre>
   * A single piece of inventory on a VM.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.Item}
   */
  public static final class Item extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.Inventory.Item)
      ItemOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Item.newBuilder() to construct.
    private Item(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Item() {
      id_ = "";
      originType_ = 0;
      type_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Item();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_Item_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_Item_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.Inventory.Item.class,
              com.google.cloud.osconfig.v1alpha.Inventory.Item.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The origin of a specific inventory item.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.osconfig.v1alpha.Inventory.Item.OriginType}
     */
    public enum OriginType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Invalid. An origin type must be specified.
       * </pre>
       *
       * <code>ORIGIN_TYPE_UNSPECIFIED = 0;</code>
       */
      ORIGIN_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * This inventory item was discovered as the result of the agent
       * reporting inventory via the reporting API.
       * </pre>
       *
       * <code>INVENTORY_REPORT = 1;</code>
       */
      INVENTORY_REPORT(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Invalid. An origin type must be specified.
       * </pre>
       *
       * <code>ORIGIN_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int ORIGIN_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * This inventory item was discovered as the result of the agent
       * reporting inventory via the reporting API.
       * </pre>
       *
       * <code>INVENTORY_REPORT = 1;</code>
       */
      public static final int INVENTORY_REPORT_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OriginType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static OriginType forNumber(int value) {
        switch (value) {
          case 0:
            return ORIGIN_TYPE_UNSPECIFIED;
          case 1:
            return INVENTORY_REPORT;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<OriginType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<OriginType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<OriginType>() {
            public OriginType findValueByNumber(int number) {
              return OriginType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.Inventory.Item.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final OriginType[] VALUES = values();

      public static OriginType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private OriginType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1alpha.Inventory.Item.OriginType)
    }

    /**
     *
     *
     * <pre>
     * The different types of inventory that are tracked on a VM.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.osconfig.v1alpha.Inventory.Item.Type}
     */
    public enum Type implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Invalid. An type must be specified.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * This represents a package that is installed on the VM.
       * </pre>
       *
       * <code>INSTALLED_PACKAGE = 1;</code>
       */
      INSTALLED_PACKAGE(1),
      /**
       *
       *
       * <pre>
       * This represents an update that is available for a package.
       * </pre>
       *
       * <code>AVAILABLE_PACKAGE = 2;</code>
       */
      AVAILABLE_PACKAGE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Invalid. An type must be specified.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * This represents a package that is installed on the VM.
       * </pre>
       *
       * <code>INSTALLED_PACKAGE = 1;</code>
       */
      public static final int INSTALLED_PACKAGE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * This represents an update that is available for a package.
       * </pre>
       *
       * <code>AVAILABLE_PACKAGE = 2;</code>
       */
      public static final int AVAILABLE_PACKAGE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 0:
            return TYPE_UNSPECIFIED;
          case 1:
            return INSTALLED_PACKAGE;
          case 2:
            return AVAILABLE_PACKAGE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Type>() {
            public Type findValueByNumber(int number) {
              return Type.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.Inventory.Item.getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1alpha.Inventory.Item.Type)
    }

    private int detailsCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object details_;

    public enum DetailsCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      INSTALLED_PACKAGE(6),
      AVAILABLE_PACKAGE(7),
      DETAILS_NOT_SET(0);
      private final int value;

      private DetailsCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DetailsCase valueOf(int value) {
        return forNumber(value);
      }

      public static DetailsCase forNumber(int value) {
        switch (value) {
          case 6:
            return INSTALLED_PACKAGE;
          case 7:
            return AVAILABLE_PACKAGE;
          case 0:
            return DETAILS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DetailsCase getDetailsCase() {
      return DetailsCase.forNumber(detailsCase_);
    }

    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Identifier for this item, unique across items for this VM.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier for this item, unique across items for this VM.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ORIGIN_TYPE_FIELD_NUMBER = 2;
    private int originType_ = 0;
    /**
     *
     *
     * <pre>
     * The origin of this inventory item.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType origin_type = 2;</code>
     *
     * @return The enum numeric value on the wire for originType.
     */
    @java.lang.Override
    public int getOriginTypeValue() {
      return originType_;
    }
    /**
     *
     *
     * <pre>
     * The origin of this inventory item.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType origin_type = 2;</code>
     *
     * @return The originType.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType getOriginType() {
      com.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType result =
          com.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType.forNumber(originType_);
      return result == null
          ? com.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType.UNRECOGNIZED
          : result;
    }

    public static final int CREATE_TIME_FIELD_NUMBER = 8;
    private com.google.protobuf.Timestamp createTime_;
    /**
     *
     *
     * <pre>
     * When this inventory item was first detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 8;</code>
     *
     * @return Whether the createTime field is set.
     */
    @java.lang.Override
    public boolean hasCreateTime() {
      return createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * When this inventory item was first detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 8;</code>
     *
     * @return The createTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getCreateTime() {
      return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
    }
    /**
     *
     *
     * <pre>
     * When this inventory item was first detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 8;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
    }

    public static final int UPDATE_TIME_FIELD_NUMBER = 9;
    private com.google.protobuf.Timestamp updateTime_;
    /**
     *
     *
     * <pre>
     * When this inventory item was last modified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 9;</code>
     *
     * @return Whether the updateTime field is set.
     */
    @java.lang.Override
    public boolean hasUpdateTime() {
      return updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * When this inventory item was last modified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 9;</code>
     *
     * @return The updateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getUpdateTime() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }
    /**
     *
     *
     * <pre>
     * When this inventory item was last modified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 9;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }

    public static final int TYPE_FIELD_NUMBER = 5;
    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The specific type of inventory, correlating to its specific details.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.Type type = 5;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The specific type of inventory, correlating to its specific details.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.Type type = 5;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.Item.Type getType() {
      com.google.cloud.osconfig.v1alpha.Inventory.Item.Type result =
          com.google.cloud.osconfig.v1alpha.Inventory.Item.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.osconfig.v1alpha.Inventory.Item.Type.UNRECOGNIZED
          : result;
    }

    public static final int INSTALLED_PACKAGE_FIELD_NUMBER = 6;
    /**
     *
     *
     * <pre>
     * Software package present on the VM instance.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;</code>
     *
     * @return Whether the installedPackage field is set.
     */
    @java.lang.Override
    public boolean hasInstalledPackage() {
      return detailsCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Software package present on the VM instance.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;</code>
     *
     * @return The installedPackage.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage getInstalledPackage() {
      if (detailsCase_ == 6) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Software package present on the VM instance.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackageOrBuilder
        getInstalledPackageOrBuilder() {
      if (detailsCase_ == 6) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance();
    }

    public static final int AVAILABLE_PACKAGE_FIELD_NUMBER = 7;
    /**
     *
     *
     * <pre>
     * Software package available to be installed on the VM instance.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;</code>
     *
     * @return Whether the availablePackage field is set.
     */
    @java.lang.Override
    public boolean hasAvailablePackage() {
      return detailsCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Software package available to be installed on the VM instance.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;</code>
     *
     * @return The availablePackage.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage getAvailablePackage() {
      if (detailsCase_ == 7) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Software package available to be installed on the VM instance.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackageOrBuilder
        getAvailablePackageOrBuilder() {
      if (detailsCase_ == 7) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (originType_
          != com.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType.ORIGIN_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, originType_);
      }
      if (type_
          != com.google.cloud.osconfig.v1alpha.Inventory.Item.Type.TYPE_UNSPECIFIED.getNumber()) {
        output.writeEnum(5, type_);
      }
      if (detailsCase_ == 6) {
        output.writeMessage(
            6, (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_);
      }
      if (detailsCase_ == 7) {
        output.writeMessage(
            7, (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_);
      }
      if (createTime_ != null) {
        output.writeMessage(8, getCreateTime());
      }
      if (updateTime_ != null) {
        output.writeMessage(9, getUpdateTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (originType_
          != com.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType.ORIGIN_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, originType_);
      }
      if (type_
          != com.google.cloud.osconfig.v1alpha.Inventory.Item.Type.TYPE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, type_);
      }
      if (detailsCase_ == 6) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6, (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_);
      }
      if (detailsCase_ == 7) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                7, (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_);
      }
      if (createTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreateTime());
      }
      if (updateTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1alpha.Inventory.Item)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.Inventory.Item other =
          (com.google.cloud.osconfig.v1alpha.Inventory.Item) obj;

      if (!getId().equals(other.getId())) return false;
      if (originType_ != other.originType_) return false;
      if (hasCreateTime() != other.hasCreateTime()) return false;
      if (hasCreateTime()) {
        if (!getCreateTime().equals(other.getCreateTime())) return false;
      }
      if (hasUpdateTime() != other.hasUpdateTime()) return false;
      if (hasUpdateTime()) {
        if (!getUpdateTime().equals(other.getUpdateTime())) return false;
      }
      if (type_ != other.type_) return false;
      if (!getDetailsCase().equals(other.getDetailsCase())) return false;
      switch (detailsCase_) {
        case 6:
          if (!getInstalledPackage().equals(other.getInstalledPackage())) return false;
          break;
        case 7:
          if (!getAvailablePackage().equals(other.getAvailablePackage())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      hash = (37 * hash) + ORIGIN_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + originType_;
      if (hasCreateTime()) {
        hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getCreateTime().hashCode();
      }
      if (hasUpdateTime()) {
        hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateTime().hashCode();
      }
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      switch (detailsCase_) {
        case 6:
          hash = (37 * hash) + INSTALLED_PACKAGE_FIELD_NUMBER;
          hash = (53 * hash) + getInstalledPackage().hashCode();
          break;
        case 7:
          hash = (37 * hash) + AVAILABLE_PACKAGE_FIELD_NUMBER;
          hash = (53 * hash) + getAvailablePackage().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.Item parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.Item parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.Item parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.Item parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.Item parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.Item parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.Item parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.Item parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.Item parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.Item parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.Item parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.Item parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.osconfig.v1alpha.Inventory.Item prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A single piece of inventory on a VM.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.Item}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.Inventory.Item)
        com.google.cloud.osconfig.v1alpha.Inventory.ItemOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_Item_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_Item_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.Inventory.Item.class,
                com.google.cloud.osconfig.v1alpha.Inventory.Item.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1alpha.Inventory.Item.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        originType_ = 0;
        createTime_ = null;
        if (createTimeBuilder_ != null) {
          createTimeBuilder_.dispose();
          createTimeBuilder_ = null;
        }
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        type_ = 0;
        if (installedPackageBuilder_ != null) {
          installedPackageBuilder_.clear();
        }
        if (availablePackageBuilder_ != null) {
          availablePackageBuilder_.clear();
        }
        detailsCase_ = 0;
        details_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_Item_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.Item getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.Inventory.Item.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.Item build() {
        com.google.cloud.osconfig.v1alpha.Inventory.Item result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.Item buildPartial() {
        com.google.cloud.osconfig.v1alpha.Inventory.Item result =
            new com.google.cloud.osconfig.v1alpha.Inventory.Item(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.osconfig.v1alpha.Inventory.Item result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.originType_ = originType_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.createTime_ =
              createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.updateTime_ =
              updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.type_ = type_;
        }
      }

      private void buildPartialOneofs(com.google.cloud.osconfig.v1alpha.Inventory.Item result) {
        result.detailsCase_ = detailsCase_;
        result.details_ = this.details_;
        if (detailsCase_ == 6 && installedPackageBuilder_ != null) {
          result.details_ = installedPackageBuilder_.build();
        }
        if (detailsCase_ == 7 && availablePackageBuilder_ != null) {
          result.details_ = availablePackageBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1alpha.Inventory.Item) {
          return mergeFrom((com.google.cloud.osconfig.v1alpha.Inventory.Item) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1alpha.Inventory.Item other) {
        if (other == com.google.cloud.osconfig.v1alpha.Inventory.Item.getDefaultInstance())
          return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.originType_ != 0) {
          setOriginTypeValue(other.getOriginTypeValue());
        }
        if (other.hasCreateTime()) {
          mergeCreateTime(other.getCreateTime());
        }
        if (other.hasUpdateTime()) {
          mergeUpdateTime(other.getUpdateTime());
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        switch (other.getDetailsCase()) {
          case INSTALLED_PACKAGE:
            {
              mergeInstalledPackage(other.getInstalledPackage());
              break;
            }
          case AVAILABLE_PACKAGE:
            {
              mergeAvailablePackage(other.getAvailablePackage());
              break;
            }
          case DETAILS_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  originType_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 40:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              case 50:
                {
                  input.readMessage(
                      getInstalledPackageFieldBuilder().getBuilder(), extensionRegistry);
                  detailsCase_ = 6;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(
                      getAvailablePackageFieldBuilder().getBuilder(), extensionRegistry);
                  detailsCase_ = 7;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 74
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int detailsCase_ = 0;
      private java.lang.Object details_;

      public DetailsCase getDetailsCase() {
        return DetailsCase.forNumber(detailsCase_);
      }

      public Builder clearDetails() {
        detailsCase_ = 0;
        details_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * Identifier for this item, unique across items for this VM.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Identifier for this item, unique across items for this VM.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Identifier for this item, unique across items for this VM.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Identifier for this item, unique across items for this VM.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Identifier for this item, unique across items for this VM.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int originType_ = 0;
      /**
       *
       *
       * <pre>
       * The origin of this inventory item.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType origin_type = 2;</code>
       *
       * @return The enum numeric value on the wire for originType.
       */
      @java.lang.Override
      public int getOriginTypeValue() {
        return originType_;
      }
      /**
       *
       *
       * <pre>
       * The origin of this inventory item.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType origin_type = 2;</code>
       *
       * @param value The enum numeric value on the wire for originType to set.
       * @return This builder for chaining.
       */
      public Builder setOriginTypeValue(int value) {
        originType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The origin of this inventory item.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType origin_type = 2;</code>
       *
       * @return The originType.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType getOriginType() {
        com.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType result =
            com.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType.forNumber(originType_);
        return result == null
            ? com.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The origin of this inventory item.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType origin_type = 2;</code>
       *
       * @param value The originType to set.
       * @return This builder for chaining.
       */
      public Builder setOriginType(
          com.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        originType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The origin of this inventory item.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.OriginType origin_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOriginType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        originType_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp createTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          createTimeBuilder_;
      /**
       *
       *
       * <pre>
       * When this inventory item was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       *
       * @return Whether the createTime field is set.
       */
      public boolean hasCreateTime() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       *
       * @return The createTime.
       */
      public com.google.protobuf.Timestamp getCreateTime() {
        if (createTimeBuilder_ == null) {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        } else {
          return createTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          createTime_ = value;
        } else {
          createTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (createTimeBuilder_ == null) {
          createTime_ = builderForValue.build();
        } else {
          createTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && createTime_ != null
              && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getCreateTimeBuilder().mergeFrom(value);
          } else {
            createTime_ = value;
          }
        } else {
          createTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      public Builder clearCreateTime() {
        bitField0_ = (bitField0_ & ~0x00000004);
        createTime_ = null;
        if (createTimeBuilder_ != null) {
          createTimeBuilder_.dispose();
          createTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getCreateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
        if (createTimeBuilder_ != null) {
          return createTimeBuilder_.getMessageOrBuilder();
        } else {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getCreateTimeFieldBuilder() {
        if (createTimeBuilder_ == null) {
          createTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getCreateTime(), getParentForChildren(), isClean());
          createTime_ = null;
        }
        return createTimeBuilder_;
      }

      private com.google.protobuf.Timestamp updateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          updateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * When this inventory item was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       *
       * @return Whether the updateTime field is set.
       */
      public boolean hasUpdateTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       *
       * @return The updateTime.
       */
      public com.google.protobuf.Timestamp getUpdateTime() {
        if (updateTimeBuilder_ == null) {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        } else {
          return updateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateTime_ = value;
        } else {
          updateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (updateTimeBuilder_ == null) {
          updateTime_ = builderForValue.build();
        } else {
          updateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && updateTime_ != null
              && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getUpdateTimeBuilder().mergeFrom(value);
          } else {
            updateTime_ = value;
          }
        } else {
          updateTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      public Builder clearUpdateTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
        if (updateTimeBuilder_ != null) {
          return updateTimeBuilder_.getMessageOrBuilder();
        } else {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * When this inventory item was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getUpdateTimeFieldBuilder() {
        if (updateTimeBuilder_ == null) {
          updateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getUpdateTime(), getParentForChildren(), isClean());
          updateTime_ = null;
        }
        return updateTimeBuilder_;
      }

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * The specific type of inventory, correlating to its specific details.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.Type type = 5;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * The specific type of inventory, correlating to its specific details.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.Type type = 5;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The specific type of inventory, correlating to its specific details.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.Type type = 5;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.Item.Type getType() {
        com.google.cloud.osconfig.v1alpha.Inventory.Item.Type result =
            com.google.cloud.osconfig.v1alpha.Inventory.Item.Type.forNumber(type_);
        return result == null
            ? com.google.cloud.osconfig.v1alpha.Inventory.Item.Type.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The specific type of inventory, correlating to its specific details.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.Type type = 5;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.cloud.osconfig.v1alpha.Inventory.Item.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The specific type of inventory, correlating to its specific details.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.Item.Type type = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000010);
        type_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage,
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackageOrBuilder>
          installedPackageBuilder_;
      /**
       *
       *
       * <pre>
       * Software package present on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;
       * </code>
       *
       * @return Whether the installedPackage field is set.
       */
      @java.lang.Override
      public boolean hasInstalledPackage() {
        return detailsCase_ == 6;
      }
      /**
       *
       *
       * <pre>
       * Software package present on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;
       * </code>
       *
       * @return The installedPackage.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage getInstalledPackage() {
        if (installedPackageBuilder_ == null) {
          if (detailsCase_ == 6) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance();
        } else {
          if (detailsCase_ == 6) {
            return installedPackageBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Software package present on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;
       * </code>
       */
      public Builder setInstalledPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage value) {
        if (installedPackageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          details_ = value;
          onChanged();
        } else {
          installedPackageBuilder_.setMessage(value);
        }
        detailsCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Software package present on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;
       * </code>
       */
      public Builder setInstalledPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.Builder builderForValue) {
        if (installedPackageBuilder_ == null) {
          details_ = builderForValue.build();
          onChanged();
        } else {
          installedPackageBuilder_.setMessage(builderForValue.build());
        }
        detailsCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Software package present on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;
       * </code>
       */
      public Builder mergeInstalledPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage value) {
        if (installedPackageBuilder_ == null) {
          if (detailsCase_ == 6
              && details_
                  != com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage
                      .getDefaultInstance()) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.newBuilder(
                        (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            details_ = value;
          }
          onChanged();
        } else {
          if (detailsCase_ == 6) {
            installedPackageBuilder_.mergeFrom(value);
          } else {
            installedPackageBuilder_.setMessage(value);
          }
        }
        detailsCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Software package present on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;
       * </code>
       */
      public Builder clearInstalledPackage() {
        if (installedPackageBuilder_ == null) {
          if (detailsCase_ == 6) {
            detailsCase_ = 0;
            details_ = null;
            onChanged();
          }
        } else {
          if (detailsCase_ == 6) {
            detailsCase_ = 0;
            details_ = null;
          }
          installedPackageBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Software package present on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.Builder
          getInstalledPackageBuilder() {
        return getInstalledPackageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Software package present on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackageOrBuilder
          getInstalledPackageOrBuilder() {
        if ((detailsCase_ == 6) && (installedPackageBuilder_ != null)) {
          return installedPackageBuilder_.getMessageOrBuilder();
        } else {
          if (detailsCase_ == 6) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Software package present on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage installed_package = 6;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage,
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackageOrBuilder>
          getInstalledPackageFieldBuilder() {
        if (installedPackageBuilder_ == null) {
          if (!(detailsCase_ == 6)) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance();
          }
          installedPackageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage,
                  com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.Builder,
                  com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackageOrBuilder>(
                  (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_,
                  getParentForChildren(),
                  isClean());
          details_ = null;
        }
        detailsCase_ = 6;
        onChanged();
        return installedPackageBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage,
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackageOrBuilder>
          availablePackageBuilder_;
      /**
       *
       *
       * <pre>
       * Software package available to be installed on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;
       * </code>
       *
       * @return Whether the availablePackage field is set.
       */
      @java.lang.Override
      public boolean hasAvailablePackage() {
        return detailsCase_ == 7;
      }
      /**
       *
       *
       * <pre>
       * Software package available to be installed on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;
       * </code>
       *
       * @return The availablePackage.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage getAvailablePackage() {
        if (availablePackageBuilder_ == null) {
          if (detailsCase_ == 7) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance();
        } else {
          if (detailsCase_ == 7) {
            return availablePackageBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Software package available to be installed on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;
       * </code>
       */
      public Builder setAvailablePackage(
          com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage value) {
        if (availablePackageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          details_ = value;
          onChanged();
        } else {
          availablePackageBuilder_.setMessage(value);
        }
        detailsCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Software package available to be installed on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;
       * </code>
       */
      public Builder setAvailablePackage(
          com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.Builder builderForValue) {
        if (availablePackageBuilder_ == null) {
          details_ = builderForValue.build();
          onChanged();
        } else {
          availablePackageBuilder_.setMessage(builderForValue.build());
        }
        detailsCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Software package available to be installed on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;
       * </code>
       */
      public Builder mergeAvailablePackage(
          com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage value) {
        if (availablePackageBuilder_ == null) {
          if (detailsCase_ == 7
              && details_
                  != com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage
                      .getDefaultInstance()) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.newBuilder(
                        (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            details_ = value;
          }
          onChanged();
        } else {
          if (detailsCase_ == 7) {
            availablePackageBuilder_.mergeFrom(value);
          } else {
            availablePackageBuilder_.setMessage(value);
          }
        }
        detailsCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Software package available to be installed on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;
       * </code>
       */
      public Builder clearAvailablePackage() {
        if (availablePackageBuilder_ == null) {
          if (detailsCase_ == 7) {
            detailsCase_ = 0;
            details_ = null;
            onChanged();
          }
        } else {
          if (detailsCase_ == 7) {
            detailsCase_ = 0;
            details_ = null;
          }
          availablePackageBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Software package available to be installed on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.Builder
          getAvailablePackageBuilder() {
        return getAvailablePackageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Software package available to be installed on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackageOrBuilder
          getAvailablePackageOrBuilder() {
        if ((detailsCase_ == 7) && (availablePackageBuilder_ != null)) {
          return availablePackageBuilder_.getMessageOrBuilder();
        } else {
          if (detailsCase_ == 7) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Software package available to be installed on the VM instance.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage available_package = 7;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage,
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackageOrBuilder>
          getAvailablePackageFieldBuilder() {
        if (availablePackageBuilder_ == null) {
          if (!(detailsCase_ == 7)) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance();
          }
          availablePackageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage,
                  com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.Builder,
                  com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackageOrBuilder>(
                  (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) details_,
                  getParentForChildren(),
                  isClean());
          details_ = null;
        }
        detailsCase_ = 7;
        onChanged();
        return availablePackageBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.Inventory.Item)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.Inventory.Item)
    private static final com.google.cloud.osconfig.v1alpha.Inventory.Item DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.Inventory.Item();
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.Item getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Item> PARSER =
        new com.google.protobuf.AbstractParser<Item>() {
          @java.lang.Override
          public Item parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Item> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Item> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.Item getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SoftwarePackageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Yum package info.
     * For details about the yum package manager, see
     * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
     *
     * @return Whether the yumPackage field is set.
     */
    boolean hasYumPackage();
    /**
     *
     *
     * <pre>
     * Yum package info.
     * For details about the yum package manager, see
     * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
     *
     * @return The yumPackage.
     */
    com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getYumPackage();
    /**
     *
     *
     * <pre>
     * Yum package info.
     * For details about the yum package manager, see
     * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
     */
    com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder getYumPackageOrBuilder();

    /**
     *
     *
     * <pre>
     * Details of an APT package.
     * For details about the apt package manager, see
     * https://wiki.debian.org/Apt.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
     *
     * @return Whether the aptPackage field is set.
     */
    boolean hasAptPackage();
    /**
     *
     *
     * <pre>
     * Details of an APT package.
     * For details about the apt package manager, see
     * https://wiki.debian.org/Apt.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
     *
     * @return The aptPackage.
     */
    com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getAptPackage();
    /**
     *
     *
     * <pre>
     * Details of an APT package.
     * For details about the apt package manager, see
     * https://wiki.debian.org/Apt.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
     */
    com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder getAptPackageOrBuilder();

    /**
     *
     *
     * <pre>
     * Details of a Zypper package.
     * For details about the Zypper package manager, see
     * https://en.opensuse.org/SDB:Zypper_manual.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
     *
     * @return Whether the zypperPackage field is set.
     */
    boolean hasZypperPackage();
    /**
     *
     *
     * <pre>
     * Details of a Zypper package.
     * For details about the Zypper package manager, see
     * https://en.opensuse.org/SDB:Zypper_manual.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
     *
     * @return The zypperPackage.
     */
    com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getZypperPackage();
    /**
     *
     *
     * <pre>
     * Details of a Zypper package.
     * For details about the Zypper package manager, see
     * https://en.opensuse.org/SDB:Zypper_manual.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
     */
    com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder
        getZypperPackageOrBuilder();

    /**
     *
     *
     * <pre>
     * Details of a Googet package.
     *  For details about the googet package manager, see
     *  https://github.com/google/googet.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
     *
     * @return Whether the googetPackage field is set.
     */
    boolean hasGoogetPackage();
    /**
     *
     *
     * <pre>
     * Details of a Googet package.
     *  For details about the googet package manager, see
     *  https://github.com/google/googet.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
     *
     * @return The googetPackage.
     */
    com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getGoogetPackage();
    /**
     *
     *
     * <pre>
     * Details of a Googet package.
     *  For details about the googet package manager, see
     *  https://github.com/google/googet.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
     */
    com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder
        getGoogetPackageOrBuilder();

    /**
     *
     *
     * <pre>
     * Details of a Zypper patch.
     * For details about the Zypper package manager, see
     * https://en.opensuse.org/SDB:Zypper_manual.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
     *
     * @return Whether the zypperPatch field is set.
     */
    boolean hasZypperPatch();
    /**
     *
     *
     * <pre>
     * Details of a Zypper patch.
     * For details about the Zypper package manager, see
     * https://en.opensuse.org/SDB:Zypper_manual.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
     *
     * @return The zypperPatch.
     */
    com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch getZypperPatch();
    /**
     *
     *
     * <pre>
     * Details of a Zypper patch.
     * For details about the Zypper package manager, see
     * https://en.opensuse.org/SDB:Zypper_manual.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
     */
    com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatchOrBuilder getZypperPatchOrBuilder();

    /**
     *
     *
     * <pre>
     * Details of a Windows Update package.
     * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
     * information about Windows Update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
     *
     * @return Whether the wuaPackage field is set.
     */
    boolean hasWuaPackage();
    /**
     *
     *
     * <pre>
     * Details of a Windows Update package.
     * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
     * information about Windows Update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
     *
     * @return The wuaPackage.
     */
    com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage getWuaPackage();
    /**
     *
     *
     * <pre>
     * Details of a Windows Update package.
     * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
     * information about Windows Update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
     */
    com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackageOrBuilder
        getWuaPackageOrBuilder();

    /**
     *
     *
     * <pre>
     * Details of a Windows Quick Fix engineering package.
     * See
     * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
     * for info in Windows Quick Fix Engineering.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
     * </code>
     *
     * @return Whether the qfePackage field is set.
     */
    boolean hasQfePackage();
    /**
     *
     *
     * <pre>
     * Details of a Windows Quick Fix engineering package.
     * See
     * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
     * for info in Windows Quick Fix Engineering.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
     * </code>
     *
     * @return The qfePackage.
     */
    com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage getQfePackage();
    /**
     *
     *
     * <pre>
     * Details of a Windows Quick Fix engineering package.
     * See
     * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
     * for info in Windows Quick Fix Engineering.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackageOrBuilder
        getQfePackageOrBuilder();

    /**
     *
     *
     * <pre>
     * Details of a COS package.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
     *
     * @return Whether the cosPackage field is set.
     */
    boolean hasCosPackage();
    /**
     *
     *
     * <pre>
     * Details of a COS package.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
     *
     * @return The cosPackage.
     */
    com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getCosPackage();
    /**
     *
     *
     * <pre>
     * Details of a COS package.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
     */
    com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder getCosPackageOrBuilder();

    /**
     *
     *
     * <pre>
     * Details of Windows Application.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
     * </code>
     *
     * @return Whether the windowsApplication field is set.
     */
    boolean hasWindowsApplication();
    /**
     *
     *
     * <pre>
     * Details of Windows Application.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
     * </code>
     *
     * @return The windowsApplication.
     */
    com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication getWindowsApplication();
    /**
     *
     *
     * <pre>
     * Details of Windows Application.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplicationOrBuilder
        getWindowsApplicationOrBuilder();

    com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.DetailsCase getDetailsCase();
  }
  /**
   *
   *
   * <pre>
   * Software package information of the operating system.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage}
   */
  public static final class SoftwarePackage extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage)
      SoftwarePackageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SoftwarePackage.newBuilder() to construct.
    private SoftwarePackage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SoftwarePackage() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SoftwarePackage();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_SoftwarePackage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_SoftwarePackage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.class,
              com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.Builder.class);
    }

    private int detailsCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object details_;

    public enum DetailsCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      YUM_PACKAGE(1),
      APT_PACKAGE(2),
      ZYPPER_PACKAGE(3),
      GOOGET_PACKAGE(4),
      ZYPPER_PATCH(5),
      WUA_PACKAGE(6),
      QFE_PACKAGE(7),
      COS_PACKAGE(8),
      WINDOWS_APPLICATION(9),
      DETAILS_NOT_SET(0);
      private final int value;

      private DetailsCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DetailsCase valueOf(int value) {
        return forNumber(value);
      }

      public static DetailsCase forNumber(int value) {
        switch (value) {
          case 1:
            return YUM_PACKAGE;
          case 2:
            return APT_PACKAGE;
          case 3:
            return ZYPPER_PACKAGE;
          case 4:
            return GOOGET_PACKAGE;
          case 5:
            return ZYPPER_PATCH;
          case 6:
            return WUA_PACKAGE;
          case 7:
            return QFE_PACKAGE;
          case 8:
            return COS_PACKAGE;
          case 9:
            return WINDOWS_APPLICATION;
          case 0:
            return DETAILS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DetailsCase getDetailsCase() {
      return DetailsCase.forNumber(detailsCase_);
    }

    public static final int YUM_PACKAGE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Yum package info.
     * For details about the yum package manager, see
     * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
     *
     * @return Whether the yumPackage field is set.
     */
    @java.lang.Override
    public boolean hasYumPackage() {
      return detailsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Yum package info.
     * For details about the yum package manager, see
     * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
     *
     * @return The yumPackage.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getYumPackage() {
      if (detailsCase_ == 1) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Yum package info.
     * For details about the yum package manager, see
     * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder
        getYumPackageOrBuilder() {
      if (detailsCase_ == 1) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
    }

    public static final int APT_PACKAGE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Details of an APT package.
     * For details about the apt package manager, see
     * https://wiki.debian.org/Apt.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
     *
     * @return Whether the aptPackage field is set.
     */
    @java.lang.Override
    public boolean hasAptPackage() {
      return detailsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Details of an APT package.
     * For details about the apt package manager, see
     * https://wiki.debian.org/Apt.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
     *
     * @return The aptPackage.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getAptPackage() {
      if (detailsCase_ == 2) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Details of an APT package.
     * For details about the apt package manager, see
     * https://wiki.debian.org/Apt.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder
        getAptPackageOrBuilder() {
      if (detailsCase_ == 2) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
    }

    public static final int ZYPPER_PACKAGE_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Details of a Zypper package.
     * For details about the Zypper package manager, see
     * https://en.opensuse.org/SDB:Zypper_manual.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
     *
     * @return Whether the zypperPackage field is set.
     */
    @java.lang.Override
    public boolean hasZypperPackage() {
      return detailsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Details of a Zypper package.
     * For details about the Zypper package manager, see
     * https://en.opensuse.org/SDB:Zypper_manual.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
     *
     * @return The zypperPackage.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getZypperPackage() {
      if (detailsCase_ == 3) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Details of a Zypper package.
     * For details about the Zypper package manager, see
     * https://en.opensuse.org/SDB:Zypper_manual.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder
        getZypperPackageOrBuilder() {
      if (detailsCase_ == 3) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
    }

    public static final int GOOGET_PACKAGE_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Details of a Googet package.
     *  For details about the googet package manager, see
     *  https://github.com/google/googet.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
     *
     * @return Whether the googetPackage field is set.
     */
    @java.lang.Override
    public boolean hasGoogetPackage() {
      return detailsCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Details of a Googet package.
     *  For details about the googet package manager, see
     *  https://github.com/google/googet.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
     *
     * @return The googetPackage.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getGoogetPackage() {
      if (detailsCase_ == 4) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Details of a Googet package.
     *  For details about the googet package manager, see
     *  https://github.com/google/googet.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder
        getGoogetPackageOrBuilder() {
      if (detailsCase_ == 4) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
    }

    public static final int ZYPPER_PATCH_FIELD_NUMBER = 5;
    /**
     *
     *
     * <pre>
     * Details of a Zypper patch.
     * For details about the Zypper package manager, see
     * https://en.opensuse.org/SDB:Zypper_manual.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
     *
     * @return Whether the zypperPatch field is set.
     */
    @java.lang.Override
    public boolean hasZypperPatch() {
      return detailsCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Details of a Zypper patch.
     * For details about the Zypper package manager, see
     * https://en.opensuse.org/SDB:Zypper_manual.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
     *
     * @return The zypperPatch.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch getZypperPatch() {
      if (detailsCase_ == 5) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Details of a Zypper patch.
     * For details about the Zypper package manager, see
     * https://en.opensuse.org/SDB:Zypper_manual.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatchOrBuilder
        getZypperPatchOrBuilder() {
      if (detailsCase_ == 5) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.getDefaultInstance();
    }

    public static final int WUA_PACKAGE_FIELD_NUMBER = 6;
    /**
     *
     *
     * <pre>
     * Details of a Windows Update package.
     * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
     * information about Windows Update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
     *
     * @return Whether the wuaPackage field is set.
     */
    @java.lang.Override
    public boolean hasWuaPackage() {
      return detailsCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Details of a Windows Update package.
     * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
     * information about Windows Update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
     *
     * @return The wuaPackage.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage getWuaPackage() {
      if (detailsCase_ == 6) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Details of a Windows Update package.
     * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
     * information about Windows Update.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackageOrBuilder
        getWuaPackageOrBuilder() {
      if (detailsCase_ == 6) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.getDefaultInstance();
    }

    public static final int QFE_PACKAGE_FIELD_NUMBER = 7;
    /**
     *
     *
     * <pre>
     * Details of a Windows Quick Fix engineering package.
     * See
     * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
     * for info in Windows Quick Fix Engineering.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
     * </code>
     *
     * @return Whether the qfePackage field is set.
     */
    @java.lang.Override
    public boolean hasQfePackage() {
      return detailsCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Details of a Windows Quick Fix engineering package.
     * See
     * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
     * for info in Windows Quick Fix Engineering.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
     * </code>
     *
     * @return The qfePackage.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        getQfePackage() {
      if (detailsCase_ == 7) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)
            details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Details of a Windows Quick Fix engineering package.
     * See
     * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
     * for info in Windows Quick Fix Engineering.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackageOrBuilder
        getQfePackageOrBuilder() {
      if (detailsCase_ == 7) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)
            details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
          .getDefaultInstance();
    }

    public static final int COS_PACKAGE_FIELD_NUMBER = 8;
    /**
     *
     *
     * <pre>
     * Details of a COS package.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
     *
     * @return Whether the cosPackage field is set.
     */
    @java.lang.Override
    public boolean hasCosPackage() {
      return detailsCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Details of a COS package.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
     *
     * @return The cosPackage.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getCosPackage() {
      if (detailsCase_ == 8) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Details of a COS package.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder
        getCosPackageOrBuilder() {
      if (detailsCase_ == 8) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
    }

    public static final int WINDOWS_APPLICATION_FIELD_NUMBER = 9;
    /**
     *
     *
     * <pre>
     * Details of Windows Application.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
     * </code>
     *
     * @return Whether the windowsApplication field is set.
     */
    @java.lang.Override
    public boolean hasWindowsApplication() {
      return detailsCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Details of Windows Application.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
     * </code>
     *
     * @return The windowsApplication.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication getWindowsApplication() {
      if (detailsCase_ == 9) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Details of Windows Application.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplicationOrBuilder
        getWindowsApplicationOrBuilder() {
      if (detailsCase_ == 9) {
        return (com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication) details_;
      }
      return com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (detailsCase_ == 1) {
        output.writeMessage(
            1, (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_);
      }
      if (detailsCase_ == 2) {
        output.writeMessage(
            2, (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_);
      }
      if (detailsCase_ == 3) {
        output.writeMessage(
            3, (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_);
      }
      if (detailsCase_ == 4) {
        output.writeMessage(
            4, (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_);
      }
      if (detailsCase_ == 5) {
        output.writeMessage(5, (com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch) details_);
      }
      if (detailsCase_ == 6) {
        output.writeMessage(
            6, (com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage) details_);
      }
      if (detailsCase_ == 7) {
        output.writeMessage(
            7,
            (com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)
                details_);
      }
      if (detailsCase_ == 8) {
        output.writeMessage(
            8, (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_);
      }
      if (detailsCase_ == 9) {
        output.writeMessage(
            9, (com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication) details_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (detailsCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_);
      }
      if (detailsCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_);
      }
      if (detailsCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_);
      }
      if (detailsCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_);
      }
      if (detailsCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, (com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch) details_);
      }
      if (detailsCase_ == 6) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6, (com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage) details_);
      }
      if (detailsCase_ == 7) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                7,
                (com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)
                    details_);
      }
      if (detailsCase_ == 8) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                8, (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_);
      }
      if (detailsCase_ == 9) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                9, (com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication) details_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage other =
          (com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) obj;

      if (!getDetailsCase().equals(other.getDetailsCase())) return false;
      switch (detailsCase_) {
        case 1:
          if (!getYumPackage().equals(other.getYumPackage())) return false;
          break;
        case 2:
          if (!getAptPackage().equals(other.getAptPackage())) return false;
          break;
        case 3:
          if (!getZypperPackage().equals(other.getZypperPackage())) return false;
          break;
        case 4:
          if (!getGoogetPackage().equals(other.getGoogetPackage())) return false;
          break;
        case 5:
          if (!getZypperPatch().equals(other.getZypperPatch())) return false;
          break;
        case 6:
          if (!getWuaPackage().equals(other.getWuaPackage())) return false;
          break;
        case 7:
          if (!getQfePackage().equals(other.getQfePackage())) return false;
          break;
        case 8:
          if (!getCosPackage().equals(other.getCosPackage())) return false;
          break;
        case 9:
          if (!getWindowsApplication().equals(other.getWindowsApplication())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (detailsCase_) {
        case 1:
          hash = (37 * hash) + YUM_PACKAGE_FIELD_NUMBER;
          hash = (53 * hash) + getYumPackage().hashCode();
          break;
        case 2:
          hash = (37 * hash) + APT_PACKAGE_FIELD_NUMBER;
          hash = (53 * hash) + getAptPackage().hashCode();
          break;
        case 3:
          hash = (37 * hash) + ZYPPER_PACKAGE_FIELD_NUMBER;
          hash = (53 * hash) + getZypperPackage().hashCode();
          break;
        case 4:
          hash = (37 * hash) + GOOGET_PACKAGE_FIELD_NUMBER;
          hash = (53 * hash) + getGoogetPackage().hashCode();
          break;
        case 5:
          hash = (37 * hash) + ZYPPER_PATCH_FIELD_NUMBER;
          hash = (53 * hash) + getZypperPatch().hashCode();
          break;
        case 6:
          hash = (37 * hash) + WUA_PACKAGE_FIELD_NUMBER;
          hash = (53 * hash) + getWuaPackage().hashCode();
          break;
        case 7:
          hash = (37 * hash) + QFE_PACKAGE_FIELD_NUMBER;
          hash = (53 * hash) + getQfePackage().hashCode();
          break;
        case 8:
          hash = (37 * hash) + COS_PACKAGE_FIELD_NUMBER;
          hash = (53 * hash) + getCosPackage().hashCode();
          break;
        case 9:
          hash = (37 * hash) + WINDOWS_APPLICATION_FIELD_NUMBER;
          hash = (53 * hash) + getWindowsApplication().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Software package information of the operating system.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage)
        com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_SoftwarePackage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_SoftwarePackage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.class,
                com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (yumPackageBuilder_ != null) {
          yumPackageBuilder_.clear();
        }
        if (aptPackageBuilder_ != null) {
          aptPackageBuilder_.clear();
        }
        if (zypperPackageBuilder_ != null) {
          zypperPackageBuilder_.clear();
        }
        if (googetPackageBuilder_ != null) {
          googetPackageBuilder_.clear();
        }
        if (zypperPatchBuilder_ != null) {
          zypperPatchBuilder_.clear();
        }
        if (wuaPackageBuilder_ != null) {
          wuaPackageBuilder_.clear();
        }
        if (qfePackageBuilder_ != null) {
          qfePackageBuilder_.clear();
        }
        if (cosPackageBuilder_ != null) {
          cosPackageBuilder_.clear();
        }
        if (windowsApplicationBuilder_ != null) {
          windowsApplicationBuilder_.clear();
        }
        detailsCase_ = 0;
        details_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_SoftwarePackage_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage build() {
        com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage buildPartial() {
        com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage result =
            new com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage result) {
        result.detailsCase_ = detailsCase_;
        result.details_ = this.details_;
        if (detailsCase_ == 1 && yumPackageBuilder_ != null) {
          result.details_ = yumPackageBuilder_.build();
        }
        if (detailsCase_ == 2 && aptPackageBuilder_ != null) {
          result.details_ = aptPackageBuilder_.build();
        }
        if (detailsCase_ == 3 && zypperPackageBuilder_ != null) {
          result.details_ = zypperPackageBuilder_.build();
        }
        if (detailsCase_ == 4 && googetPackageBuilder_ != null) {
          result.details_ = googetPackageBuilder_.build();
        }
        if (detailsCase_ == 5 && zypperPatchBuilder_ != null) {
          result.details_ = zypperPatchBuilder_.build();
        }
        if (detailsCase_ == 6 && wuaPackageBuilder_ != null) {
          result.details_ = wuaPackageBuilder_.build();
        }
        if (detailsCase_ == 7 && qfePackageBuilder_ != null) {
          result.details_ = qfePackageBuilder_.build();
        }
        if (detailsCase_ == 8 && cosPackageBuilder_ != null) {
          result.details_ = cosPackageBuilder_.build();
        }
        if (detailsCase_ == 9 && windowsApplicationBuilder_ != null) {
          result.details_ = windowsApplicationBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) {
          return mergeFrom((com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage other) {
        if (other
            == com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.getDefaultInstance())
          return this;
        switch (other.getDetailsCase()) {
          case YUM_PACKAGE:
            {
              mergeYumPackage(other.getYumPackage());
              break;
            }
          case APT_PACKAGE:
            {
              mergeAptPackage(other.getAptPackage());
              break;
            }
          case ZYPPER_PACKAGE:
            {
              mergeZypperPackage(other.getZypperPackage());
              break;
            }
          case GOOGET_PACKAGE:
            {
              mergeGoogetPackage(other.getGoogetPackage());
              break;
            }
          case ZYPPER_PATCH:
            {
              mergeZypperPatch(other.getZypperPatch());
              break;
            }
          case WUA_PACKAGE:
            {
              mergeWuaPackage(other.getWuaPackage());
              break;
            }
          case QFE_PACKAGE:
            {
              mergeQfePackage(other.getQfePackage());
              break;
            }
          case COS_PACKAGE:
            {
              mergeCosPackage(other.getCosPackage());
              break;
            }
          case WINDOWS_APPLICATION:
            {
              mergeWindowsApplication(other.getWindowsApplication());
              break;
            }
          case DETAILS_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getYumPackageFieldBuilder().getBuilder(), extensionRegistry);
                  detailsCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getAptPackageFieldBuilder().getBuilder(), extensionRegistry);
                  detailsCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getZypperPackageFieldBuilder().getBuilder(), extensionRegistry);
                  detailsCase_ = 3;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getGoogetPackageFieldBuilder().getBuilder(), extensionRegistry);
                  detailsCase_ = 4;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getZypperPatchFieldBuilder().getBuilder(), extensionRegistry);
                  detailsCase_ = 5;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getWuaPackageFieldBuilder().getBuilder(), extensionRegistry);
                  detailsCase_ = 6;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(getQfePackageFieldBuilder().getBuilder(), extensionRegistry);
                  detailsCase_ = 7;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(getCosPackageFieldBuilder().getBuilder(), extensionRegistry);
                  detailsCase_ = 8;
                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(
                      getWindowsApplicationFieldBuilder().getBuilder(), extensionRegistry);
                  detailsCase_ = 9;
                  break;
                } // case 74
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int detailsCase_ = 0;
      private java.lang.Object details_;

      public DetailsCase getDetailsCase() {
        return DetailsCase.forNumber(detailsCase_);
      }

      public Builder clearDetails() {
        detailsCase_ = 0;
        details_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>
          yumPackageBuilder_;
      /**
       *
       *
       * <pre>
       * Yum package info.
       * For details about the yum package manager, see
       * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
       *
       * @return Whether the yumPackage field is set.
       */
      @java.lang.Override
      public boolean hasYumPackage() {
        return detailsCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Yum package info.
       * For details about the yum package manager, see
       * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
       *
       * @return The yumPackage.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getYumPackage() {
        if (yumPackageBuilder_ == null) {
          if (detailsCase_ == 1) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        } else {
          if (detailsCase_ == 1) {
            return yumPackageBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Yum package info.
       * For details about the yum package manager, see
       * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
       */
      public Builder setYumPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage value) {
        if (yumPackageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          details_ = value;
          onChanged();
        } else {
          yumPackageBuilder_.setMessage(value);
        }
        detailsCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Yum package info.
       * For details about the yum package manager, see
       * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
       */
      public Builder setYumPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder builderForValue) {
        if (yumPackageBuilder_ == null) {
          details_ = builderForValue.build();
          onChanged();
        } else {
          yumPackageBuilder_.setMessage(builderForValue.build());
        }
        detailsCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Yum package info.
       * For details about the yum package manager, see
       * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
       */
      public Builder mergeYumPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage value) {
        if (yumPackageBuilder_ == null) {
          if (detailsCase_ == 1
              && details_
                  != com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
                      .getDefaultInstance()) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.newBuilder(
                        (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            details_ = value;
          }
          onChanged();
        } else {
          if (detailsCase_ == 1) {
            yumPackageBuilder_.mergeFrom(value);
          } else {
            yumPackageBuilder_.setMessage(value);
          }
        }
        detailsCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Yum package info.
       * For details about the yum package manager, see
       * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
       */
      public Builder clearYumPackage() {
        if (yumPackageBuilder_ == null) {
          if (detailsCase_ == 1) {
            detailsCase_ = 0;
            details_ = null;
            onChanged();
          }
        } else {
          if (detailsCase_ == 1) {
            detailsCase_ = 0;
            details_ = null;
          }
          yumPackageBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Yum package info.
       * For details about the yum package manager, see
       * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder
          getYumPackageBuilder() {
        return getYumPackageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Yum package info.
       * For details about the yum package manager, see
       * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder
          getYumPackageOrBuilder() {
        if ((detailsCase_ == 1) && (yumPackageBuilder_ != null)) {
          return yumPackageBuilder_.getMessageOrBuilder();
        } else {
          if (detailsCase_ == 1) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Yum package info.
       * For details about the yum package manager, see
       * https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage yum_package = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>
          getYumPackageFieldBuilder() {
        if (yumPackageBuilder_ == null) {
          if (!(detailsCase_ == 1)) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
          }
          yumPackageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>(
                  (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_,
                  getParentForChildren(),
                  isClean());
          details_ = null;
        }
        detailsCase_ = 1;
        onChanged();
        return yumPackageBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>
          aptPackageBuilder_;
      /**
       *
       *
       * <pre>
       * Details of an APT package.
       * For details about the apt package manager, see
       * https://wiki.debian.org/Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
       *
       * @return Whether the aptPackage field is set.
       */
      @java.lang.Override
      public boolean hasAptPackage() {
        return detailsCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Details of an APT package.
       * For details about the apt package manager, see
       * https://wiki.debian.org/Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
       *
       * @return The aptPackage.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getAptPackage() {
        if (aptPackageBuilder_ == null) {
          if (detailsCase_ == 2) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        } else {
          if (detailsCase_ == 2) {
            return aptPackageBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of an APT package.
       * For details about the apt package manager, see
       * https://wiki.debian.org/Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
       */
      public Builder setAptPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage value) {
        if (aptPackageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          details_ = value;
          onChanged();
        } else {
          aptPackageBuilder_.setMessage(value);
        }
        detailsCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of an APT package.
       * For details about the apt package manager, see
       * https://wiki.debian.org/Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
       */
      public Builder setAptPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder builderForValue) {
        if (aptPackageBuilder_ == null) {
          details_ = builderForValue.build();
          onChanged();
        } else {
          aptPackageBuilder_.setMessage(builderForValue.build());
        }
        detailsCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of an APT package.
       * For details about the apt package manager, see
       * https://wiki.debian.org/Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
       */
      public Builder mergeAptPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage value) {
        if (aptPackageBuilder_ == null) {
          if (detailsCase_ == 2
              && details_
                  != com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
                      .getDefaultInstance()) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.newBuilder(
                        (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            details_ = value;
          }
          onChanged();
        } else {
          if (detailsCase_ == 2) {
            aptPackageBuilder_.mergeFrom(value);
          } else {
            aptPackageBuilder_.setMessage(value);
          }
        }
        detailsCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of an APT package.
       * For details about the apt package manager, see
       * https://wiki.debian.org/Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
       */
      public Builder clearAptPackage() {
        if (aptPackageBuilder_ == null) {
          if (detailsCase_ == 2) {
            detailsCase_ = 0;
            details_ = null;
            onChanged();
          }
        } else {
          if (detailsCase_ == 2) {
            detailsCase_ = 0;
            details_ = null;
          }
          aptPackageBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of an APT package.
       * For details about the apt package manager, see
       * https://wiki.debian.org/Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder
          getAptPackageBuilder() {
        return getAptPackageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Details of an APT package.
       * For details about the apt package manager, see
       * https://wiki.debian.org/Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder
          getAptPackageOrBuilder() {
        if ((detailsCase_ == 2) && (aptPackageBuilder_ != null)) {
          return aptPackageBuilder_.getMessageOrBuilder();
        } else {
          if (detailsCase_ == 2) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of an APT package.
       * For details about the apt package manager, see
       * https://wiki.debian.org/Apt.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage apt_package = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>
          getAptPackageFieldBuilder() {
        if (aptPackageBuilder_ == null) {
          if (!(detailsCase_ == 2)) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
          }
          aptPackageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>(
                  (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_,
                  getParentForChildren(),
                  isClean());
          details_ = null;
        }
        detailsCase_ = 2;
        onChanged();
        return aptPackageBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>
          zypperPackageBuilder_;
      /**
       *
       *
       * <pre>
       * Details of a Zypper package.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
       *
       * @return Whether the zypperPackage field is set.
       */
      @java.lang.Override
      public boolean hasZypperPackage() {
        return detailsCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper package.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
       *
       * @return The zypperPackage.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getZypperPackage() {
        if (zypperPackageBuilder_ == null) {
          if (detailsCase_ == 3) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        } else {
          if (detailsCase_ == 3) {
            return zypperPackageBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper package.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
       */
      public Builder setZypperPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage value) {
        if (zypperPackageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          details_ = value;
          onChanged();
        } else {
          zypperPackageBuilder_.setMessage(value);
        }
        detailsCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper package.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
       */
      public Builder setZypperPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder builderForValue) {
        if (zypperPackageBuilder_ == null) {
          details_ = builderForValue.build();
          onChanged();
        } else {
          zypperPackageBuilder_.setMessage(builderForValue.build());
        }
        detailsCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper package.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
       */
      public Builder mergeZypperPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage value) {
        if (zypperPackageBuilder_ == null) {
          if (detailsCase_ == 3
              && details_
                  != com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
                      .getDefaultInstance()) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.newBuilder(
                        (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            details_ = value;
          }
          onChanged();
        } else {
          if (detailsCase_ == 3) {
            zypperPackageBuilder_.mergeFrom(value);
          } else {
            zypperPackageBuilder_.setMessage(value);
          }
        }
        detailsCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper package.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
       */
      public Builder clearZypperPackage() {
        if (zypperPackageBuilder_ == null) {
          if (detailsCase_ == 3) {
            detailsCase_ = 0;
            details_ = null;
            onChanged();
          }
        } else {
          if (detailsCase_ == 3) {
            detailsCase_ = 0;
            details_ = null;
          }
          zypperPackageBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper package.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder
          getZypperPackageBuilder() {
        return getZypperPackageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper package.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder
          getZypperPackageOrBuilder() {
        if ((detailsCase_ == 3) && (zypperPackageBuilder_ != null)) {
          return zypperPackageBuilder_.getMessageOrBuilder();
        } else {
          if (detailsCase_ == 3) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper package.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage zypper_package = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>
          getZypperPackageFieldBuilder() {
        if (zypperPackageBuilder_ == null) {
          if (!(detailsCase_ == 3)) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
          }
          zypperPackageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>(
                  (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_,
                  getParentForChildren(),
                  isClean());
          details_ = null;
        }
        detailsCase_ = 3;
        onChanged();
        return zypperPackageBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>
          googetPackageBuilder_;
      /**
       *
       *
       * <pre>
       * Details of a Googet package.
       *  For details about the googet package manager, see
       *  https://github.com/google/googet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
       *
       * @return Whether the googetPackage field is set.
       */
      @java.lang.Override
      public boolean hasGoogetPackage() {
        return detailsCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Details of a Googet package.
       *  For details about the googet package manager, see
       *  https://github.com/google/googet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
       *
       * @return The googetPackage.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getGoogetPackage() {
        if (googetPackageBuilder_ == null) {
          if (detailsCase_ == 4) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        } else {
          if (detailsCase_ == 4) {
            return googetPackageBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of a Googet package.
       *  For details about the googet package manager, see
       *  https://github.com/google/googet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
       */
      public Builder setGoogetPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage value) {
        if (googetPackageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          details_ = value;
          onChanged();
        } else {
          googetPackageBuilder_.setMessage(value);
        }
        detailsCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Googet package.
       *  For details about the googet package manager, see
       *  https://github.com/google/googet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
       */
      public Builder setGoogetPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder builderForValue) {
        if (googetPackageBuilder_ == null) {
          details_ = builderForValue.build();
          onChanged();
        } else {
          googetPackageBuilder_.setMessage(builderForValue.build());
        }
        detailsCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Googet package.
       *  For details about the googet package manager, see
       *  https://github.com/google/googet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
       */
      public Builder mergeGoogetPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage value) {
        if (googetPackageBuilder_ == null) {
          if (detailsCase_ == 4
              && details_
                  != com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
                      .getDefaultInstance()) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.newBuilder(
                        (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            details_ = value;
          }
          onChanged();
        } else {
          if (detailsCase_ == 4) {
            googetPackageBuilder_.mergeFrom(value);
          } else {
            googetPackageBuilder_.setMessage(value);
          }
        }
        detailsCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Googet package.
       *  For details about the googet package manager, see
       *  https://github.com/google/googet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
       */
      public Builder clearGoogetPackage() {
        if (googetPackageBuilder_ == null) {
          if (detailsCase_ == 4) {
            detailsCase_ = 0;
            details_ = null;
            onChanged();
          }
        } else {
          if (detailsCase_ == 4) {
            detailsCase_ = 0;
            details_ = null;
          }
          googetPackageBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Googet package.
       *  For details about the googet package manager, see
       *  https://github.com/google/googet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder
          getGoogetPackageBuilder() {
        return getGoogetPackageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Details of a Googet package.
       *  For details about the googet package manager, see
       *  https://github.com/google/googet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder
          getGoogetPackageOrBuilder() {
        if ((detailsCase_ == 4) && (googetPackageBuilder_ != null)) {
          return googetPackageBuilder_.getMessageOrBuilder();
        } else {
          if (detailsCase_ == 4) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of a Googet package.
       *  For details about the googet package manager, see
       *  https://github.com/google/googet.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage googet_package = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>
          getGoogetPackageFieldBuilder() {
        if (googetPackageBuilder_ == null) {
          if (!(detailsCase_ == 4)) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
          }
          googetPackageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>(
                  (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_,
                  getParentForChildren(),
                  isClean());
          details_ = null;
        }
        detailsCase_ = 4;
        onChanged();
        return googetPackageBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch,
              com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatchOrBuilder>
          zypperPatchBuilder_;
      /**
       *
       *
       * <pre>
       * Details of a Zypper patch.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
       *
       * @return Whether the zypperPatch field is set.
       */
      @java.lang.Override
      public boolean hasZypperPatch() {
        return detailsCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper patch.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
       *
       * @return The zypperPatch.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch getZypperPatch() {
        if (zypperPatchBuilder_ == null) {
          if (detailsCase_ == 5) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.getDefaultInstance();
        } else {
          if (detailsCase_ == 5) {
            return zypperPatchBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper patch.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
       */
      public Builder setZypperPatch(com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch value) {
        if (zypperPatchBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          details_ = value;
          onChanged();
        } else {
          zypperPatchBuilder_.setMessage(value);
        }
        detailsCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper patch.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
       */
      public Builder setZypperPatch(
          com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.Builder builderForValue) {
        if (zypperPatchBuilder_ == null) {
          details_ = builderForValue.build();
          onChanged();
        } else {
          zypperPatchBuilder_.setMessage(builderForValue.build());
        }
        detailsCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper patch.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
       */
      public Builder mergeZypperPatch(
          com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch value) {
        if (zypperPatchBuilder_ == null) {
          if (detailsCase_ == 5
              && details_
                  != com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.getDefaultInstance()) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.newBuilder(
                        (com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch) details_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            details_ = value;
          }
          onChanged();
        } else {
          if (detailsCase_ == 5) {
            zypperPatchBuilder_.mergeFrom(value);
          } else {
            zypperPatchBuilder_.setMessage(value);
          }
        }
        detailsCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper patch.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
       */
      public Builder clearZypperPatch() {
        if (zypperPatchBuilder_ == null) {
          if (detailsCase_ == 5) {
            detailsCase_ = 0;
            details_ = null;
            onChanged();
          }
        } else {
          if (detailsCase_ == 5) {
            detailsCase_ = 0;
            details_ = null;
          }
          zypperPatchBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper patch.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.Builder
          getZypperPatchBuilder() {
        return getZypperPatchFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper patch.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatchOrBuilder
          getZypperPatchOrBuilder() {
        if ((detailsCase_ == 5) && (zypperPatchBuilder_ != null)) {
          return zypperPatchBuilder_.getMessageOrBuilder();
        } else {
          if (detailsCase_ == 5) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of a Zypper patch.
       * For details about the Zypper package manager, see
       * https://en.opensuse.org/SDB:Zypper_manual.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch zypper_patch = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch,
              com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatchOrBuilder>
          getZypperPatchFieldBuilder() {
        if (zypperPatchBuilder_ == null) {
          if (!(detailsCase_ == 5)) {
            details_ = com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.getDefaultInstance();
          }
          zypperPatchBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch,
                  com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.Builder,
                  com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatchOrBuilder>(
                  (com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch) details_,
                  getParentForChildren(),
                  isClean());
          details_ = null;
        }
        detailsCase_ = 5;
        onChanged();
        return zypperPatchBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackageOrBuilder>
          wuaPackageBuilder_;
      /**
       *
       *
       * <pre>
       * Details of a Windows Update package.
       * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
       * information about Windows Update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
       *
       * @return Whether the wuaPackage field is set.
       */
      @java.lang.Override
      public boolean hasWuaPackage() {
        return detailsCase_ == 6;
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Update package.
       * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
       * information about Windows Update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
       *
       * @return The wuaPackage.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage getWuaPackage() {
        if (wuaPackageBuilder_ == null) {
          if (detailsCase_ == 6) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .getDefaultInstance();
        } else {
          if (detailsCase_ == 6) {
            return wuaPackageBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Update package.
       * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
       * information about Windows Update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
       */
      public Builder setWuaPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage value) {
        if (wuaPackageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          details_ = value;
          onChanged();
        } else {
          wuaPackageBuilder_.setMessage(value);
        }
        detailsCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Update package.
       * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
       * information about Windows Update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
       */
      public Builder setWuaPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.Builder
              builderForValue) {
        if (wuaPackageBuilder_ == null) {
          details_ = builderForValue.build();
          onChanged();
        } else {
          wuaPackageBuilder_.setMessage(builderForValue.build());
        }
        detailsCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Update package.
       * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
       * information about Windows Update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
       */
      public Builder mergeWuaPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage value) {
        if (wuaPackageBuilder_ == null) {
          if (detailsCase_ == 6
              && details_
                  != com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                      .getDefaultInstance()) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.newBuilder(
                        (com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage) details_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            details_ = value;
          }
          onChanged();
        } else {
          if (detailsCase_ == 6) {
            wuaPackageBuilder_.mergeFrom(value);
          } else {
            wuaPackageBuilder_.setMessage(value);
          }
        }
        detailsCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Update package.
       * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
       * information about Windows Update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
       */
      public Builder clearWuaPackage() {
        if (wuaPackageBuilder_ == null) {
          if (detailsCase_ == 6) {
            detailsCase_ = 0;
            details_ = null;
            onChanged();
          }
        } else {
          if (detailsCase_ == 6) {
            detailsCase_ = 0;
            details_ = null;
          }
          wuaPackageBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Update package.
       * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
       * information about Windows Update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.Builder
          getWuaPackageBuilder() {
        return getWuaPackageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Update package.
       * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
       * information about Windows Update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackageOrBuilder
          getWuaPackageOrBuilder() {
        if ((detailsCase_ == 6) && (wuaPackageBuilder_ != null)) {
          return wuaPackageBuilder_.getMessageOrBuilder();
        } else {
          if (detailsCase_ == 6) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Update package.
       * See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
       * information about Windows Update.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage wua_package = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackageOrBuilder>
          getWuaPackageFieldBuilder() {
        if (wuaPackageBuilder_ == null) {
          if (!(detailsCase_ == 6)) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                    .getDefaultInstance();
          }
          wuaPackageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage,
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.Builder,
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackageOrBuilder>(
                  (com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage) details_,
                  getParentForChildren(),
                  isClean());
          details_ = null;
        }
        detailsCase_ = 6;
        onChanged();
        return wuaPackageBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory
                  .WindowsQuickFixEngineeringPackageOrBuilder>
          qfePackageBuilder_;
      /**
       *
       *
       * <pre>
       * Details of a Windows Quick Fix engineering package.
       * See
       * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
       * for info in Windows Quick Fix Engineering.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
       * </code>
       *
       * @return Whether the qfePackage field is set.
       */
      @java.lang.Override
      public boolean hasQfePackage() {
        return detailsCase_ == 7;
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Quick Fix engineering package.
       * See
       * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
       * for info in Windows Quick Fix Engineering.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
       * </code>
       *
       * @return The qfePackage.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
          getQfePackage() {
        if (qfePackageBuilder_ == null) {
          if (detailsCase_ == 7) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)
                details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
              .getDefaultInstance();
        } else {
          if (detailsCase_ == 7) {
            return qfePackageBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Quick Fix engineering package.
       * See
       * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
       * for info in Windows Quick Fix Engineering.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
       * </code>
       */
      public Builder setQfePackage(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage value) {
        if (qfePackageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          details_ = value;
          onChanged();
        } else {
          qfePackageBuilder_.setMessage(value);
        }
        detailsCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Quick Fix engineering package.
       * See
       * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
       * for info in Windows Quick Fix Engineering.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
       * </code>
       */
      public Builder setQfePackage(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage.Builder
              builderForValue) {
        if (qfePackageBuilder_ == null) {
          details_ = builderForValue.build();
          onChanged();
        } else {
          qfePackageBuilder_.setMessage(builderForValue.build());
        }
        detailsCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Quick Fix engineering package.
       * See
       * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
       * for info in Windows Quick Fix Engineering.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
       * </code>
       */
      public Builder mergeQfePackage(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage value) {
        if (qfePackageBuilder_ == null) {
          if (detailsCase_ == 7
              && details_
                  != com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
                      .getDefaultInstance()) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
                    .newBuilder(
                        (com.google.cloud.osconfig.v1alpha.Inventory
                                .WindowsQuickFixEngineeringPackage)
                            details_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            details_ = value;
          }
          onChanged();
        } else {
          if (detailsCase_ == 7) {
            qfePackageBuilder_.mergeFrom(value);
          } else {
            qfePackageBuilder_.setMessage(value);
          }
        }
        detailsCase_ = 7;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Quick Fix engineering package.
       * See
       * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
       * for info in Windows Quick Fix Engineering.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
       * </code>
       */
      public Builder clearQfePackage() {
        if (qfePackageBuilder_ == null) {
          if (detailsCase_ == 7) {
            detailsCase_ = 0;
            details_ = null;
            onChanged();
          }
        } else {
          if (detailsCase_ == 7) {
            detailsCase_ = 0;
            details_ = null;
          }
          qfePackageBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Quick Fix engineering package.
       * See
       * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
       * for info in Windows Quick Fix Engineering.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage.Builder
          getQfePackageBuilder() {
        return getQfePackageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Quick Fix engineering package.
       * See
       * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
       * for info in Windows Quick Fix Engineering.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackageOrBuilder
          getQfePackageOrBuilder() {
        if ((detailsCase_ == 7) && (qfePackageBuilder_ != null)) {
          return qfePackageBuilder_.getMessageOrBuilder();
        } else {
          if (detailsCase_ == 7) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)
                details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of a Windows Quick Fix engineering package.
       * See
       * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
       * for info in Windows Quick Fix Engineering.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage qfe_package = 7;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory
                  .WindowsQuickFixEngineeringPackageOrBuilder>
          getQfePackageFieldBuilder() {
        if (qfePackageBuilder_ == null) {
          if (!(detailsCase_ == 7)) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
                    .getDefaultInstance();
          }
          qfePackageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage,
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
                      .Builder,
                  com.google.cloud.osconfig.v1alpha.Inventory
                      .WindowsQuickFixEngineeringPackageOrBuilder>(
                  (com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)
                      details_,
                  getParentForChildren(),
                  isClean());
          details_ = null;
        }
        detailsCase_ = 7;
        onChanged();
        return qfePackageBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>
          cosPackageBuilder_;
      /**
       *
       *
       * <pre>
       * Details of a COS package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
       *
       * @return Whether the cosPackage field is set.
       */
      @java.lang.Override
      public boolean hasCosPackage() {
        return detailsCase_ == 8;
      }
      /**
       *
       *
       * <pre>
       * Details of a COS package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
       *
       * @return The cosPackage.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage getCosPackage() {
        if (cosPackageBuilder_ == null) {
          if (detailsCase_ == 8) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        } else {
          if (detailsCase_ == 8) {
            return cosPackageBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of a COS package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
       */
      public Builder setCosPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage value) {
        if (cosPackageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          details_ = value;
          onChanged();
        } else {
          cosPackageBuilder_.setMessage(value);
        }
        detailsCase_ = 8;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a COS package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
       */
      public Builder setCosPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder builderForValue) {
        if (cosPackageBuilder_ == null) {
          details_ = builderForValue.build();
          onChanged();
        } else {
          cosPackageBuilder_.setMessage(builderForValue.build());
        }
        detailsCase_ = 8;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a COS package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
       */
      public Builder mergeCosPackage(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage value) {
        if (cosPackageBuilder_ == null) {
          if (detailsCase_ == 8
              && details_
                  != com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
                      .getDefaultInstance()) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.newBuilder(
                        (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            details_ = value;
          }
          onChanged();
        } else {
          if (detailsCase_ == 8) {
            cosPackageBuilder_.mergeFrom(value);
          } else {
            cosPackageBuilder_.setMessage(value);
          }
        }
        detailsCase_ = 8;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a COS package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
       */
      public Builder clearCosPackage() {
        if (cosPackageBuilder_ == null) {
          if (detailsCase_ == 8) {
            detailsCase_ = 0;
            details_ = null;
            onChanged();
          }
        } else {
          if (detailsCase_ == 8) {
            detailsCase_ = 0;
            details_ = null;
          }
          cosPackageBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of a COS package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder
          getCosPackageBuilder() {
        return getCosPackageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Details of a COS package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder
          getCosPackageOrBuilder() {
        if ((detailsCase_ == 8) && (cosPackageBuilder_ != null)) {
          return cosPackageBuilder_.getMessageOrBuilder();
        } else {
          if (detailsCase_ == 8) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of a COS package.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage cos_package = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>
          getCosPackageFieldBuilder() {
        if (cosPackageBuilder_ == null) {
          if (!(detailsCase_ == 8)) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
          }
          cosPackageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage,
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder,
                  com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder>(
                  (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) details_,
                  getParentForChildren(),
                  isClean());
          details_ = null;
        }
        detailsCase_ = 8;
        onChanged();
        return cosPackageBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplicationOrBuilder>
          windowsApplicationBuilder_;
      /**
       *
       *
       * <pre>
       * Details of Windows Application.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
       * </code>
       *
       * @return Whether the windowsApplication field is set.
       */
      @java.lang.Override
      public boolean hasWindowsApplication() {
        return detailsCase_ == 9;
      }
      /**
       *
       *
       * <pre>
       * Details of Windows Application.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
       * </code>
       *
       * @return The windowsApplication.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication
          getWindowsApplication() {
        if (windowsApplicationBuilder_ == null) {
          if (detailsCase_ == 9) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication
              .getDefaultInstance();
        } else {
          if (detailsCase_ == 9) {
            return windowsApplicationBuilder_.getMessage();
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of Windows Application.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
       * </code>
       */
      public Builder setWindowsApplication(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication value) {
        if (windowsApplicationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          details_ = value;
          onChanged();
        } else {
          windowsApplicationBuilder_.setMessage(value);
        }
        detailsCase_ = 9;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of Windows Application.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
       * </code>
       */
      public Builder setWindowsApplication(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.Builder builderForValue) {
        if (windowsApplicationBuilder_ == null) {
          details_ = builderForValue.build();
          onChanged();
        } else {
          windowsApplicationBuilder_.setMessage(builderForValue.build());
        }
        detailsCase_ = 9;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of Windows Application.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
       * </code>
       */
      public Builder mergeWindowsApplication(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication value) {
        if (windowsApplicationBuilder_ == null) {
          if (detailsCase_ == 9
              && details_
                  != com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication
                      .getDefaultInstance()) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.newBuilder(
                        (com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication) details_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            details_ = value;
          }
          onChanged();
        } else {
          if (detailsCase_ == 9) {
            windowsApplicationBuilder_.mergeFrom(value);
          } else {
            windowsApplicationBuilder_.setMessage(value);
          }
        }
        detailsCase_ = 9;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of Windows Application.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
       * </code>
       */
      public Builder clearWindowsApplication() {
        if (windowsApplicationBuilder_ == null) {
          if (detailsCase_ == 9) {
            detailsCase_ = 0;
            details_ = null;
            onChanged();
          }
        } else {
          if (detailsCase_ == 9) {
            detailsCase_ = 0;
            details_ = null;
          }
          windowsApplicationBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of Windows Application.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.Builder
          getWindowsApplicationBuilder() {
        return getWindowsApplicationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Details of Windows Application.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplicationOrBuilder
          getWindowsApplicationOrBuilder() {
        if ((detailsCase_ == 9) && (windowsApplicationBuilder_ != null)) {
          return windowsApplicationBuilder_.getMessageOrBuilder();
        } else {
          if (detailsCase_ == 9) {
            return (com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication) details_;
          }
          return com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of Windows Application.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication windows_application = 9;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplicationOrBuilder>
          getWindowsApplicationFieldBuilder() {
        if (windowsApplicationBuilder_ == null) {
          if (!(detailsCase_ == 9)) {
            details_ =
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.getDefaultInstance();
          }
          windowsApplicationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication,
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.Builder,
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplicationOrBuilder>(
                  (com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication) details_,
                  getParentForChildren(),
                  isClean());
          details_ = null;
        }
        detailsCase_ = 9;
        onChanged();
        return windowsApplicationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage)
    private static final com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage();
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SoftwarePackage> PARSER =
        new com.google.protobuf.AbstractParser<SoftwarePackage>() {
          @java.lang.Override
          public SoftwarePackage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SoftwarePackage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SoftwarePackage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VersionedPackageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.Inventory.VersionedPackage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the package.
     * </pre>
     *
     * <code>string package_name = 4;</code>
     *
     * @return The packageName.
     */
    java.lang.String getPackageName();
    /**
     *
     *
     * <pre>
     * The name of the package.
     * </pre>
     *
     * <code>string package_name = 4;</code>
     *
     * @return The bytes for packageName.
     */
    com.google.protobuf.ByteString getPackageNameBytes();

    /**
     *
     *
     * <pre>
     * The system architecture this package is intended for.
     * </pre>
     *
     * <code>string architecture = 2;</code>
     *
     * @return The architecture.
     */
    java.lang.String getArchitecture();
    /**
     *
     *
     * <pre>
     * The system architecture this package is intended for.
     * </pre>
     *
     * <code>string architecture = 2;</code>
     *
     * @return The bytes for architecture.
     */
    com.google.protobuf.ByteString getArchitectureBytes();

    /**
     *
     *
     * <pre>
     * The version of the package.
     * </pre>
     *
     * <code>string version = 3;</code>
     *
     * @return The version.
     */
    java.lang.String getVersion();
    /**
     *
     *
     * <pre>
     * The version of the package.
     * </pre>
     *
     * <code>string version = 3;</code>
     *
     * @return The bytes for version.
     */
    com.google.protobuf.ByteString getVersionBytes();
  }
  /**
   *
   *
   * <pre>
   * Information related to the a standard versioned package.  This includes
   * package info for APT, Yum, Zypper, and Googet package managers.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.VersionedPackage}
   */
  public static final class VersionedPackage extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.Inventory.VersionedPackage)
      VersionedPackageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VersionedPackage.newBuilder() to construct.
    private VersionedPackage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VersionedPackage() {
      packageName_ = "";
      architecture_ = "";
      version_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VersionedPackage();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_VersionedPackage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_VersionedPackage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.class,
              com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder.class);
    }

    public static final int PACKAGE_NAME_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object packageName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the package.
     * </pre>
     *
     * <code>string package_name = 4;</code>
     *
     * @return The packageName.
     */
    @java.lang.Override
    public java.lang.String getPackageName() {
      java.lang.Object ref = packageName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        packageName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the package.
     * </pre>
     *
     * <code>string package_name = 4;</code>
     *
     * @return The bytes for packageName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPackageNameBytes() {
      java.lang.Object ref = packageName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        packageName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ARCHITECTURE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object architecture_ = "";
    /**
     *
     *
     * <pre>
     * The system architecture this package is intended for.
     * </pre>
     *
     * <code>string architecture = 2;</code>
     *
     * @return The architecture.
     */
    @java.lang.Override
    public java.lang.String getArchitecture() {
      java.lang.Object ref = architecture_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        architecture_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The system architecture this package is intended for.
     * </pre>
     *
     * <code>string architecture = 2;</code>
     *
     * @return The bytes for architecture.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getArchitectureBytes() {
      java.lang.Object ref = architecture_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        architecture_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERSION_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * The version of the package.
     * </pre>
     *
     * <code>string version = 3;</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The version of the package.
     * </pre>
     *
     * <code>string version = 3;</code>
     *
     * @return The bytes for version.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(architecture_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, architecture_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, version_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(packageName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, packageName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(architecture_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, architecture_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, version_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(packageName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, packageName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage other =
          (com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) obj;

      if (!getPackageName().equals(other.getPackageName())) return false;
      if (!getArchitecture().equals(other.getArchitecture())) return false;
      if (!getVersion().equals(other.getVersion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PACKAGE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getPackageName().hashCode();
      hash = (37 * hash) + ARCHITECTURE_FIELD_NUMBER;
      hash = (53 * hash) + getArchitecture().hashCode();
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information related to the a standard versioned package.  This includes
     * package info for APT, Yum, Zypper, and Googet package managers.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.VersionedPackage}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.Inventory.VersionedPackage)
        com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_VersionedPackage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_VersionedPackage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.class,
                com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        packageName_ = "";
        architecture_ = "";
        version_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_VersionedPackage_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage build() {
        com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage buildPartial() {
        com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage result =
            new com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.packageName_ = packageName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.architecture_ = architecture_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.version_ = version_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) {
          return mergeFrom((com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage other) {
        if (other
            == com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage.getDefaultInstance())
          return this;
        if (!other.getPackageName().isEmpty()) {
          packageName_ = other.packageName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getArchitecture().isEmpty()) {
          architecture_ = other.architecture_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getVersion().isEmpty()) {
          version_ = other.version_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  architecture_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  version_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  packageName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object packageName_ = "";
      /**
       *
       *
       * <pre>
       * The name of the package.
       * </pre>
       *
       * <code>string package_name = 4;</code>
       *
       * @return The packageName.
       */
      public java.lang.String getPackageName() {
        java.lang.Object ref = packageName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          packageName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the package.
       * </pre>
       *
       * <code>string package_name = 4;</code>
       *
       * @return The bytes for packageName.
       */
      public com.google.protobuf.ByteString getPackageNameBytes() {
        java.lang.Object ref = packageName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          packageName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the package.
       * </pre>
       *
       * <code>string package_name = 4;</code>
       *
       * @param value The packageName to set.
       * @return This builder for chaining.
       */
      public Builder setPackageName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        packageName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the package.
       * </pre>
       *
       * <code>string package_name = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPackageName() {
        packageName_ = getDefaultInstance().getPackageName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the package.
       * </pre>
       *
       * <code>string package_name = 4;</code>
       *
       * @param value The bytes for packageName to set.
       * @return This builder for chaining.
       */
      public Builder setPackageNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        packageName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object architecture_ = "";
      /**
       *
       *
       * <pre>
       * The system architecture this package is intended for.
       * </pre>
       *
       * <code>string architecture = 2;</code>
       *
       * @return The architecture.
       */
      public java.lang.String getArchitecture() {
        java.lang.Object ref = architecture_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          architecture_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The system architecture this package is intended for.
       * </pre>
       *
       * <code>string architecture = 2;</code>
       *
       * @return The bytes for architecture.
       */
      public com.google.protobuf.ByteString getArchitectureBytes() {
        java.lang.Object ref = architecture_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          architecture_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The system architecture this package is intended for.
       * </pre>
       *
       * <code>string architecture = 2;</code>
       *
       * @param value The architecture to set.
       * @return This builder for chaining.
       */
      public Builder setArchitecture(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        architecture_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The system architecture this package is intended for.
       * </pre>
       *
       * <code>string architecture = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearArchitecture() {
        architecture_ = getDefaultInstance().getArchitecture();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The system architecture this package is intended for.
       * </pre>
       *
       * <code>string architecture = 2;</code>
       *
       * @param value The bytes for architecture to set.
       * @return This builder for chaining.
       */
      public Builder setArchitectureBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        architecture_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object version_ = "";
      /**
       *
       *
       * <pre>
       * The version of the package.
       * </pre>
       *
       * <code>string version = 3;</code>
       *
       * @return The version.
       */
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The version of the package.
       * </pre>
       *
       * <code>string version = 3;</code>
       *
       * @return The bytes for version.
       */
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The version of the package.
       * </pre>
       *
       * <code>string version = 3;</code>
       *
       * @param value The version to set.
       * @return This builder for chaining.
       */
      public Builder setVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        version_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The version of the package.
       * </pre>
       *
       * <code>string version = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVersion() {
        version_ = getDefaultInstance().getVersion();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The version of the package.
       * </pre>
       *
       * <code>string version = 3;</code>
       *
       * @param value The bytes for version to set.
       * @return This builder for chaining.
       */
      public Builder setVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        version_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.Inventory.VersionedPackage)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.Inventory.VersionedPackage)
    private static final com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage();
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VersionedPackage> PARSER =
        new com.google.protobuf.AbstractParser<VersionedPackage>() {
          @java.lang.Override
          public VersionedPackage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VersionedPackage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VersionedPackage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ZypperPatchOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.Inventory.ZypperPatch)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the patch.
     * </pre>
     *
     * <code>string patch_name = 5;</code>
     *
     * @return The patchName.
     */
    java.lang.String getPatchName();
    /**
     *
     *
     * <pre>
     * The name of the patch.
     * </pre>
     *
     * <code>string patch_name = 5;</code>
     *
     * @return The bytes for patchName.
     */
    com.google.protobuf.ByteString getPatchNameBytes();

    /**
     *
     *
     * <pre>
     * The category of the patch.
     * </pre>
     *
     * <code>string category = 2;</code>
     *
     * @return The category.
     */
    java.lang.String getCategory();
    /**
     *
     *
     * <pre>
     * The category of the patch.
     * </pre>
     *
     * <code>string category = 2;</code>
     *
     * @return The bytes for category.
     */
    com.google.protobuf.ByteString getCategoryBytes();

    /**
     *
     *
     * <pre>
     * The severity specified for this patch
     * </pre>
     *
     * <code>string severity = 3;</code>
     *
     * @return The severity.
     */
    java.lang.String getSeverity();
    /**
     *
     *
     * <pre>
     * The severity specified for this patch
     * </pre>
     *
     * <code>string severity = 3;</code>
     *
     * @return The bytes for severity.
     */
    com.google.protobuf.ByteString getSeverityBytes();

    /**
     *
     *
     * <pre>
     * Any summary information provided about this patch.
     * </pre>
     *
     * <code>string summary = 4;</code>
     *
     * @return The summary.
     */
    java.lang.String getSummary();
    /**
     *
     *
     * <pre>
     * Any summary information provided about this patch.
     * </pre>
     *
     * <code>string summary = 4;</code>
     *
     * @return The bytes for summary.
     */
    com.google.protobuf.ByteString getSummaryBytes();
  }
  /**
   *
   *
   * <pre>
   * Details related to a Zypper Patch.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.ZypperPatch}
   */
  public static final class ZypperPatch extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.Inventory.ZypperPatch)
      ZypperPatchOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ZypperPatch.newBuilder() to construct.
    private ZypperPatch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ZypperPatch() {
      patchName_ = "";
      category_ = "";
      severity_ = "";
      summary_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ZypperPatch();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_ZypperPatch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_ZypperPatch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.class,
              com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.Builder.class);
    }

    public static final int PATCH_NAME_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object patchName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the patch.
     * </pre>
     *
     * <code>string patch_name = 5;</code>
     *
     * @return The patchName.
     */
    @java.lang.Override
    public java.lang.String getPatchName() {
      java.lang.Object ref = patchName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        patchName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the patch.
     * </pre>
     *
     * <code>string patch_name = 5;</code>
     *
     * @return The bytes for patchName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPatchNameBytes() {
      java.lang.Object ref = patchName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        patchName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CATEGORY_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object category_ = "";
    /**
     *
     *
     * <pre>
     * The category of the patch.
     * </pre>
     *
     * <code>string category = 2;</code>
     *
     * @return The category.
     */
    @java.lang.Override
    public java.lang.String getCategory() {
      java.lang.Object ref = category_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        category_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The category of the patch.
     * </pre>
     *
     * <code>string category = 2;</code>
     *
     * @return The bytes for category.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCategoryBytes() {
      java.lang.Object ref = category_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        category_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SEVERITY_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object severity_ = "";
    /**
     *
     *
     * <pre>
     * The severity specified for this patch
     * </pre>
     *
     * <code>string severity = 3;</code>
     *
     * @return The severity.
     */
    @java.lang.Override
    public java.lang.String getSeverity() {
      java.lang.Object ref = severity_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        severity_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The severity specified for this patch
     * </pre>
     *
     * <code>string severity = 3;</code>
     *
     * @return The bytes for severity.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSeverityBytes() {
      java.lang.Object ref = severity_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        severity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUMMARY_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object summary_ = "";
    /**
     *
     *
     * <pre>
     * Any summary information provided about this patch.
     * </pre>
     *
     * <code>string summary = 4;</code>
     *
     * @return The summary.
     */
    @java.lang.Override
    public java.lang.String getSummary() {
      java.lang.Object ref = summary_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        summary_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Any summary information provided about this patch.
     * </pre>
     *
     * <code>string summary = 4;</code>
     *
     * @return The bytes for summary.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSummaryBytes() {
      java.lang.Object ref = summary_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        summary_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(category_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, category_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(severity_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, severity_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summary_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, summary_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(patchName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, patchName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(category_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, category_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(severity_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, severity_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summary_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, summary_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(patchName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, patchName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch other =
          (com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch) obj;

      if (!getPatchName().equals(other.getPatchName())) return false;
      if (!getCategory().equals(other.getCategory())) return false;
      if (!getSeverity().equals(other.getSeverity())) return false;
      if (!getSummary().equals(other.getSummary())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PATCH_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getPatchName().hashCode();
      hash = (37 * hash) + CATEGORY_FIELD_NUMBER;
      hash = (53 * hash) + getCategory().hashCode();
      hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
      hash = (53 * hash) + getSeverity().hashCode();
      hash = (37 * hash) + SUMMARY_FIELD_NUMBER;
      hash = (53 * hash) + getSummary().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details related to a Zypper Patch.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.ZypperPatch}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.Inventory.ZypperPatch)
        com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatchOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_ZypperPatch_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_ZypperPatch_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.class,
                com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        patchName_ = "";
        category_ = "";
        severity_ = "";
        summary_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_ZypperPatch_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch build() {
        com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch buildPartial() {
        com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch result =
            new com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.patchName_ = patchName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.category_ = category_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.severity_ = severity_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.summary_ = summary_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch) {
          return mergeFrom((com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch other) {
        if (other == com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch.getDefaultInstance())
          return this;
        if (!other.getPatchName().isEmpty()) {
          patchName_ = other.patchName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getCategory().isEmpty()) {
          category_ = other.category_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getSeverity().isEmpty()) {
          severity_ = other.severity_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getSummary().isEmpty()) {
          summary_ = other.summary_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  category_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  severity_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  summary_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  patchName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object patchName_ = "";
      /**
       *
       *
       * <pre>
       * The name of the patch.
       * </pre>
       *
       * <code>string patch_name = 5;</code>
       *
       * @return The patchName.
       */
      public java.lang.String getPatchName() {
        java.lang.Object ref = patchName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          patchName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the patch.
       * </pre>
       *
       * <code>string patch_name = 5;</code>
       *
       * @return The bytes for patchName.
       */
      public com.google.protobuf.ByteString getPatchNameBytes() {
        java.lang.Object ref = patchName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          patchName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the patch.
       * </pre>
       *
       * <code>string patch_name = 5;</code>
       *
       * @param value The patchName to set.
       * @return This builder for chaining.
       */
      public Builder setPatchName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        patchName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the patch.
       * </pre>
       *
       * <code>string patch_name = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPatchName() {
        patchName_ = getDefaultInstance().getPatchName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the patch.
       * </pre>
       *
       * <code>string patch_name = 5;</code>
       *
       * @param value The bytes for patchName to set.
       * @return This builder for chaining.
       */
      public Builder setPatchNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        patchName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object category_ = "";
      /**
       *
       *
       * <pre>
       * The category of the patch.
       * </pre>
       *
       * <code>string category = 2;</code>
       *
       * @return The category.
       */
      public java.lang.String getCategory() {
        java.lang.Object ref = category_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          category_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The category of the patch.
       * </pre>
       *
       * <code>string category = 2;</code>
       *
       * @return The bytes for category.
       */
      public com.google.protobuf.ByteString getCategoryBytes() {
        java.lang.Object ref = category_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          category_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The category of the patch.
       * </pre>
       *
       * <code>string category = 2;</code>
       *
       * @param value The category to set.
       * @return This builder for chaining.
       */
      public Builder setCategory(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        category_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The category of the patch.
       * </pre>
       *
       * <code>string category = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCategory() {
        category_ = getDefaultInstance().getCategory();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The category of the patch.
       * </pre>
       *
       * <code>string category = 2;</code>
       *
       * @param value The bytes for category to set.
       * @return This builder for chaining.
       */
      public Builder setCategoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        category_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object severity_ = "";
      /**
       *
       *
       * <pre>
       * The severity specified for this patch
       * </pre>
       *
       * <code>string severity = 3;</code>
       *
       * @return The severity.
       */
      public java.lang.String getSeverity() {
        java.lang.Object ref = severity_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          severity_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The severity specified for this patch
       * </pre>
       *
       * <code>string severity = 3;</code>
       *
       * @return The bytes for severity.
       */
      public com.google.protobuf.ByteString getSeverityBytes() {
        java.lang.Object ref = severity_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          severity_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The severity specified for this patch
       * </pre>
       *
       * <code>string severity = 3;</code>
       *
       * @param value The severity to set.
       * @return This builder for chaining.
       */
      public Builder setSeverity(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        severity_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The severity specified for this patch
       * </pre>
       *
       * <code>string severity = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSeverity() {
        severity_ = getDefaultInstance().getSeverity();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The severity specified for this patch
       * </pre>
       *
       * <code>string severity = 3;</code>
       *
       * @param value The bytes for severity to set.
       * @return This builder for chaining.
       */
      public Builder setSeverityBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        severity_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object summary_ = "";
      /**
       *
       *
       * <pre>
       * Any summary information provided about this patch.
       * </pre>
       *
       * <code>string summary = 4;</code>
       *
       * @return The summary.
       */
      public java.lang.String getSummary() {
        java.lang.Object ref = summary_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          summary_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Any summary information provided about this patch.
       * </pre>
       *
       * <code>string summary = 4;</code>
       *
       * @return The bytes for summary.
       */
      public com.google.protobuf.ByteString getSummaryBytes() {
        java.lang.Object ref = summary_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          summary_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Any summary information provided about this patch.
       * </pre>
       *
       * <code>string summary = 4;</code>
       *
       * @param value The summary to set.
       * @return This builder for chaining.
       */
      public Builder setSummary(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        summary_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Any summary information provided about this patch.
       * </pre>
       *
       * <code>string summary = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSummary() {
        summary_ = getDefaultInstance().getSummary();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Any summary information provided about this patch.
       * </pre>
       *
       * <code>string summary = 4;</code>
       *
       * @param value The bytes for summary to set.
       * @return This builder for chaining.
       */
      public Builder setSummaryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        summary_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.Inventory.ZypperPatch)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.Inventory.ZypperPatch)
    private static final com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch();
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ZypperPatch> PARSER =
        new com.google.protobuf.AbstractParser<ZypperPatch>() {
          @java.lang.Override
          public ZypperPatch parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ZypperPatch> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ZypperPatch> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.ZypperPatch getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WindowsUpdatePackageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The localized title of the update package.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The title.
     */
    java.lang.String getTitle();
    /**
     *
     *
     * <pre>
     * The localized title of the update package.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The bytes for title.
     */
    com.google.protobuf.ByteString getTitleBytes();

    /**
     *
     *
     * <pre>
     * The localized description of the update package.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * The localized description of the update package.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * The categories that are associated with this update package.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
     * </code>
     */
    java.util.List<
            com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory>
        getCategoriesList();
    /**
     *
     *
     * <pre>
     * The categories that are associated with this update package.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
        getCategories(int index);
    /**
     *
     *
     * <pre>
     * The categories that are associated with this update package.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
     * </code>
     */
    int getCategoriesCount();
    /**
     *
     *
     * <pre>
     * The categories that are associated with this update package.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                    .WindowsUpdateCategoryOrBuilder>
        getCategoriesOrBuilderList();
    /**
     *
     *
     * <pre>
     * The categories that are associated with this update package.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategoryOrBuilder
        getCategoriesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A collection of Microsoft Knowledge Base article IDs that are associated
     * with the update package.
     * </pre>
     *
     * <code>repeated string kb_article_ids = 4;</code>
     *
     * @return A list containing the kbArticleIds.
     */
    java.util.List<java.lang.String> getKbArticleIdsList();
    /**
     *
     *
     * <pre>
     * A collection of Microsoft Knowledge Base article IDs that are associated
     * with the update package.
     * </pre>
     *
     * <code>repeated string kb_article_ids = 4;</code>
     *
     * @return The count of kbArticleIds.
     */
    int getKbArticleIdsCount();
    /**
     *
     *
     * <pre>
     * A collection of Microsoft Knowledge Base article IDs that are associated
     * with the update package.
     * </pre>
     *
     * <code>repeated string kb_article_ids = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The kbArticleIds at the given index.
     */
    java.lang.String getKbArticleIds(int index);
    /**
     *
     *
     * <pre>
     * A collection of Microsoft Knowledge Base article IDs that are associated
     * with the update package.
     * </pre>
     *
     * <code>repeated string kb_article_ids = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the kbArticleIds at the given index.
     */
    com.google.protobuf.ByteString getKbArticleIdsBytes(int index);

    /**
     *
     *
     * <pre>
     * A hyperlink to the language-specific support information for the update.
     * </pre>
     *
     * <code>string support_url = 11;</code>
     *
     * @return The supportUrl.
     */
    java.lang.String getSupportUrl();
    /**
     *
     *
     * <pre>
     * A hyperlink to the language-specific support information for the update.
     * </pre>
     *
     * <code>string support_url = 11;</code>
     *
     * @return The bytes for supportUrl.
     */
    com.google.protobuf.ByteString getSupportUrlBytes();

    /**
     *
     *
     * <pre>
     * A collection of URLs that provide more information about the update
     * package.
     * </pre>
     *
     * <code>repeated string more_info_urls = 5;</code>
     *
     * @return A list containing the moreInfoUrls.
     */
    java.util.List<java.lang.String> getMoreInfoUrlsList();
    /**
     *
     *
     * <pre>
     * A collection of URLs that provide more information about the update
     * package.
     * </pre>
     *
     * <code>repeated string more_info_urls = 5;</code>
     *
     * @return The count of moreInfoUrls.
     */
    int getMoreInfoUrlsCount();
    /**
     *
     *
     * <pre>
     * A collection of URLs that provide more information about the update
     * package.
     * </pre>
     *
     * <code>repeated string more_info_urls = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The moreInfoUrls at the given index.
     */
    java.lang.String getMoreInfoUrls(int index);
    /**
     *
     *
     * <pre>
     * A collection of URLs that provide more information about the update
     * package.
     * </pre>
     *
     * <code>repeated string more_info_urls = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the moreInfoUrls at the given index.
     */
    com.google.protobuf.ByteString getMoreInfoUrlsBytes(int index);

    /**
     *
     *
     * <pre>
     * Gets the identifier of an update package.  Stays the same across
     * revisions.
     * </pre>
     *
     * <code>string update_id = 6;</code>
     *
     * @return The updateId.
     */
    java.lang.String getUpdateId();
    /**
     *
     *
     * <pre>
     * Gets the identifier of an update package.  Stays the same across
     * revisions.
     * </pre>
     *
     * <code>string update_id = 6;</code>
     *
     * @return The bytes for updateId.
     */
    com.google.protobuf.ByteString getUpdateIdBytes();

    /**
     *
     *
     * <pre>
     * The revision number of this update package.
     * </pre>
     *
     * <code>int32 revision_number = 7;</code>
     *
     * @return The revisionNumber.
     */
    int getRevisionNumber();

    /**
     *
     *
     * <pre>
     * The last published date of the update, in (UTC) date and time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
     *
     * @return Whether the lastDeploymentChangeTime field is set.
     */
    boolean hasLastDeploymentChangeTime();
    /**
     *
     *
     * <pre>
     * The last published date of the update, in (UTC) date and time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
     *
     * @return The lastDeploymentChangeTime.
     */
    com.google.protobuf.Timestamp getLastDeploymentChangeTime();
    /**
     *
     *
     * <pre>
     * The last published date of the update, in (UTC) date and time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
     */
    com.google.protobuf.TimestampOrBuilder getLastDeploymentChangeTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Details related to a Windows Update package.
   * Field data and names are taken from Windows Update API IUpdate Interface:
   * https://docs.microsoft.com/en-us/windows/win32/api/_wua/
   * Descriptive fields like title, and description are localized based on
   * the locale of the VM being updated.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage}
   */
  public static final class WindowsUpdatePackage extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage)
      WindowsUpdatePackageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WindowsUpdatePackage.newBuilder() to construct.
    private WindowsUpdatePackage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WindowsUpdatePackage() {
      title_ = "";
      description_ = "";
      categories_ = java.util.Collections.emptyList();
      kbArticleIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      supportUrl_ = "";
      moreInfoUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
      updateId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WindowsUpdatePackage();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsUpdatePackage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsUpdatePackage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.class,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.Builder.class);
    }

    public interface WindowsUpdateCategoryOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The identifier of the windows update category.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      java.lang.String getId();
      /**
       *
       *
       * <pre>
       * The identifier of the windows update category.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      com.google.protobuf.ByteString getIdBytes();

      /**
       *
       *
       * <pre>
       * The name of the windows update category.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return The name.
       */
      java.lang.String getName();
      /**
       *
       *
       * <pre>
       * The name of the windows update category.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString getNameBytes();
    }
    /**
     *
     *
     * <pre>
     * Categories specified by the Windows Update.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory}
     */
    public static final class WindowsUpdateCategory extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory)
        WindowsUpdateCategoryOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use WindowsUpdateCategory.newBuilder() to construct.
      private WindowsUpdateCategory(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private WindowsUpdateCategory() {
        id_ = "";
        name_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new WindowsUpdateCategory();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsUpdatePackage_WindowsUpdateCategory_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsUpdatePackage_WindowsUpdateCategory_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                    .WindowsUpdateCategory.class,
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                    .WindowsUpdateCategory.Builder.class);
      }

      public static final int ID_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * The identifier of the windows update category.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      @java.lang.Override
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The identifier of the windows update category.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int NAME_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The name of the windows update category.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the windows update category.
       * </pre>
       *
       * <code>string name = 2;</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                .WindowsUpdateCategory)) {
          return super.equals(obj);
        }
        com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
            other =
                (com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                        .WindowsUpdateCategory)
                    obj;

        if (!getId().equals(other.getId())) return false;
        if (!getName().equals(other.getName())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ID_FIELD_NUMBER;
        hash = (53 * hash) + getId().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Categories specified by the Windows Update.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory)
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategoryOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1alpha.Inventories
              .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsUpdatePackage_WindowsUpdateCategory_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1alpha.Inventories
              .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsUpdatePackage_WindowsUpdateCategory_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                      .WindowsUpdateCategory.class,
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                      .WindowsUpdateCategory.Builder.class);
        }

        // Construct using
        // com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          id_ = "";
          name_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.osconfig.v1alpha.Inventories
              .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsUpdatePackage_WindowsUpdateCategory_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                .WindowsUpdateCategory
            getDefaultInstanceForType() {
          return com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                .WindowsUpdateCategory
            build() {
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                .WindowsUpdateCategory
            buildPartial() {
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
              result =
                  new com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                      .WindowsUpdateCategory(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.id_ = id_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.name_ = name_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                  .WindowsUpdateCategory) {
            return mergeFrom(
                (com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                        .WindowsUpdateCategory)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
                other) {
          if (other
              == com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                  .WindowsUpdateCategory.getDefaultInstance()) return this;
          if (!other.getId().isEmpty()) {
            id_ = other.id_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    id_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    name_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object id_ = "";
        /**
         *
         *
         * <pre>
         * The identifier of the windows update category.
         * </pre>
         *
         * <code>string id = 1;</code>
         *
         * @return The id.
         */
        public java.lang.String getId() {
          java.lang.Object ref = id_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            id_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The identifier of the windows update category.
         * </pre>
         *
         * <code>string id = 1;</code>
         *
         * @return The bytes for id.
         */
        public com.google.protobuf.ByteString getIdBytes() {
          java.lang.Object ref = id_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            id_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The identifier of the windows update category.
         * </pre>
         *
         * <code>string id = 1;</code>
         *
         * @param value The id to set.
         * @return This builder for chaining.
         */
        public Builder setId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          id_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The identifier of the windows update category.
         * </pre>
         *
         * <code>string id = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearId() {
          id_ = getDefaultInstance().getId();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The identifier of the windows update category.
         * </pre>
         *
         * <code>string id = 1;</code>
         *
         * @param value The bytes for id to set.
         * @return This builder for chaining.
         */
        public Builder setIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          id_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * The name of the windows update category.
         * </pre>
         *
         * <code>string name = 2;</code>
         *
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the windows update category.
         * </pre>
         *
         * <code>string name = 2;</code>
         *
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the windows update category.
         * </pre>
         *
         * <code>string name = 2;</code>
         *
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the windows update category.
         * </pre>
         *
         * <code>string name = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearName() {
          name_ = getDefaultInstance().getName();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the windows update category.
         * </pre>
         *
         * <code>string name = 2;</code>
         *
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          name_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory)
      private static final com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                .WindowsUpdateCategory();
      }

      public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategory
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<WindowsUpdateCategory> PARSER =
          new com.google.protobuf.AbstractParser<WindowsUpdateCategory>() {
            @java.lang.Override
            public WindowsUpdateCategory parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<WindowsUpdateCategory> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<WindowsUpdateCategory> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int TITLE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object title_ = "";
    /**
     *
     *
     * <pre>
     * The localized title of the update package.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The title.
     */
    @java.lang.Override
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The localized title of the update package.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The bytes for title.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The localized description of the update package.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The localized description of the update package.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CATEGORIES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory>
        categories_;
    /**
     *
     *
     * <pre>
     * The categories that are associated with this update package.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory>
        getCategoriesList() {
      return categories_;
    }
    /**
     *
     *
     * <pre>
     * The categories that are associated with this update package.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                    .WindowsUpdateCategoryOrBuilder>
        getCategoriesOrBuilderList() {
      return categories_;
    }
    /**
     *
     *
     * <pre>
     * The categories that are associated with this update package.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
     * </code>
     */
    @java.lang.Override
    public int getCategoriesCount() {
      return categories_.size();
    }
    /**
     *
     *
     * <pre>
     * The categories that are associated with this update package.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
        getCategories(int index) {
      return categories_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The categories that are associated with this update package.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
            .WindowsUpdateCategoryOrBuilder
        getCategoriesOrBuilder(int index) {
      return categories_.get(index);
    }

    public static final int KB_ARTICLE_IDS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList kbArticleIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * A collection of Microsoft Knowledge Base article IDs that are associated
     * with the update package.
     * </pre>
     *
     * <code>repeated string kb_article_ids = 4;</code>
     *
     * @return A list containing the kbArticleIds.
     */
    public com.google.protobuf.ProtocolStringList getKbArticleIdsList() {
      return kbArticleIds_;
    }
    /**
     *
     *
     * <pre>
     * A collection of Microsoft Knowledge Base article IDs that are associated
     * with the update package.
     * </pre>
     *
     * <code>repeated string kb_article_ids = 4;</code>
     *
     * @return The count of kbArticleIds.
     */
    public int getKbArticleIdsCount() {
      return kbArticleIds_.size();
    }
    /**
     *
     *
     * <pre>
     * A collection of Microsoft Knowledge Base article IDs that are associated
     * with the update package.
     * </pre>
     *
     * <code>repeated string kb_article_ids = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The kbArticleIds at the given index.
     */
    public java.lang.String getKbArticleIds(int index) {
      return kbArticleIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A collection of Microsoft Knowledge Base article IDs that are associated
     * with the update package.
     * </pre>
     *
     * <code>repeated string kb_article_ids = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the kbArticleIds at the given index.
     */
    public com.google.protobuf.ByteString getKbArticleIdsBytes(int index) {
      return kbArticleIds_.getByteString(index);
    }

    public static final int SUPPORT_URL_FIELD_NUMBER = 11;

    @SuppressWarnings("serial")
    private volatile java.lang.Object supportUrl_ = "";
    /**
     *
     *
     * <pre>
     * A hyperlink to the language-specific support information for the update.
     * </pre>
     *
     * <code>string support_url = 11;</code>
     *
     * @return The supportUrl.
     */
    @java.lang.Override
    public java.lang.String getSupportUrl() {
      java.lang.Object ref = supportUrl_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        supportUrl_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A hyperlink to the language-specific support information for the update.
     * </pre>
     *
     * <code>string support_url = 11;</code>
     *
     * @return The bytes for supportUrl.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSupportUrlBytes() {
      java.lang.Object ref = supportUrl_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        supportUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MORE_INFO_URLS_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList moreInfoUrls_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * A collection of URLs that provide more information about the update
     * package.
     * </pre>
     *
     * <code>repeated string more_info_urls = 5;</code>
     *
     * @return A list containing the moreInfoUrls.
     */
    public com.google.protobuf.ProtocolStringList getMoreInfoUrlsList() {
      return moreInfoUrls_;
    }
    /**
     *
     *
     * <pre>
     * A collection of URLs that provide more information about the update
     * package.
     * </pre>
     *
     * <code>repeated string more_info_urls = 5;</code>
     *
     * @return The count of moreInfoUrls.
     */
    public int getMoreInfoUrlsCount() {
      return moreInfoUrls_.size();
    }
    /**
     *
     *
     * <pre>
     * A collection of URLs that provide more information about the update
     * package.
     * </pre>
     *
     * <code>repeated string more_info_urls = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The moreInfoUrls at the given index.
     */
    public java.lang.String getMoreInfoUrls(int index) {
      return moreInfoUrls_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A collection of URLs that provide more information about the update
     * package.
     * </pre>
     *
     * <code>repeated string more_info_urls = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the moreInfoUrls at the given index.
     */
    public com.google.protobuf.ByteString getMoreInfoUrlsBytes(int index) {
      return moreInfoUrls_.getByteString(index);
    }

    public static final int UPDATE_ID_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object updateId_ = "";
    /**
     *
     *
     * <pre>
     * Gets the identifier of an update package.  Stays the same across
     * revisions.
     * </pre>
     *
     * <code>string update_id = 6;</code>
     *
     * @return The updateId.
     */
    @java.lang.Override
    public java.lang.String getUpdateId() {
      java.lang.Object ref = updateId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        updateId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Gets the identifier of an update package.  Stays the same across
     * revisions.
     * </pre>
     *
     * <code>string update_id = 6;</code>
     *
     * @return The bytes for updateId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUpdateIdBytes() {
      java.lang.Object ref = updateId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        updateId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REVISION_NUMBER_FIELD_NUMBER = 7;
    private int revisionNumber_ = 0;
    /**
     *
     *
     * <pre>
     * The revision number of this update package.
     * </pre>
     *
     * <code>int32 revision_number = 7;</code>
     *
     * @return The revisionNumber.
     */
    @java.lang.Override
    public int getRevisionNumber() {
      return revisionNumber_;
    }

    public static final int LAST_DEPLOYMENT_CHANGE_TIME_FIELD_NUMBER = 10;
    private com.google.protobuf.Timestamp lastDeploymentChangeTime_;
    /**
     *
     *
     * <pre>
     * The last published date of the update, in (UTC) date and time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
     *
     * @return Whether the lastDeploymentChangeTime field is set.
     */
    @java.lang.Override
    public boolean hasLastDeploymentChangeTime() {
      return lastDeploymentChangeTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The last published date of the update, in (UTC) date and time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
     *
     * @return The lastDeploymentChangeTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getLastDeploymentChangeTime() {
      return lastDeploymentChangeTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : lastDeploymentChangeTime_;
    }
    /**
     *
     *
     * <pre>
     * The last published date of the update, in (UTC) date and time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getLastDeploymentChangeTimeOrBuilder() {
      return lastDeploymentChangeTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : lastDeploymentChangeTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, title_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
      }
      for (int i = 0; i < categories_.size(); i++) {
        output.writeMessage(3, categories_.get(i));
      }
      for (int i = 0; i < kbArticleIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, kbArticleIds_.getRaw(i));
      }
      for (int i = 0; i < moreInfoUrls_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, moreInfoUrls_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(updateId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, updateId_);
      }
      if (revisionNumber_ != 0) {
        output.writeInt32(7, revisionNumber_);
      }
      if (lastDeploymentChangeTime_ != null) {
        output.writeMessage(10, getLastDeploymentChangeTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(supportUrl_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 11, supportUrl_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, title_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
      }
      for (int i = 0; i < categories_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, categories_.get(i));
      }
      {
        int dataSize = 0;
        for (int i = 0; i < kbArticleIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(kbArticleIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getKbArticleIdsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < moreInfoUrls_.size(); i++) {
          dataSize += computeStringSizeNoTag(moreInfoUrls_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getMoreInfoUrlsList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(updateId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, updateId_);
      }
      if (revisionNumber_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, revisionNumber_);
      }
      if (lastDeploymentChangeTime_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                10, getLastDeploymentChangeTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(supportUrl_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, supportUrl_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage other =
          (com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage) obj;

      if (!getTitle().equals(other.getTitle())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (!getCategoriesList().equals(other.getCategoriesList())) return false;
      if (!getKbArticleIdsList().equals(other.getKbArticleIdsList())) return false;
      if (!getSupportUrl().equals(other.getSupportUrl())) return false;
      if (!getMoreInfoUrlsList().equals(other.getMoreInfoUrlsList())) return false;
      if (!getUpdateId().equals(other.getUpdateId())) return false;
      if (getRevisionNumber() != other.getRevisionNumber()) return false;
      if (hasLastDeploymentChangeTime() != other.hasLastDeploymentChangeTime()) return false;
      if (hasLastDeploymentChangeTime()) {
        if (!getLastDeploymentChangeTime().equals(other.getLastDeploymentChangeTime()))
          return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getTitle().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      if (getCategoriesCount() > 0) {
        hash = (37 * hash) + CATEGORIES_FIELD_NUMBER;
        hash = (53 * hash) + getCategoriesList().hashCode();
      }
      if (getKbArticleIdsCount() > 0) {
        hash = (37 * hash) + KB_ARTICLE_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getKbArticleIdsList().hashCode();
      }
      hash = (37 * hash) + SUPPORT_URL_FIELD_NUMBER;
      hash = (53 * hash) + getSupportUrl().hashCode();
      if (getMoreInfoUrlsCount() > 0) {
        hash = (37 * hash) + MORE_INFO_URLS_FIELD_NUMBER;
        hash = (53 * hash) + getMoreInfoUrlsList().hashCode();
      }
      hash = (37 * hash) + UPDATE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateId().hashCode();
      hash = (37 * hash) + REVISION_NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + getRevisionNumber();
      if (hasLastDeploymentChangeTime()) {
        hash = (37 * hash) + LAST_DEPLOYMENT_CHANGE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getLastDeploymentChangeTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details related to a Windows Update package.
     * Field data and names are taken from Windows Update API IUpdate Interface:
     * https://docs.microsoft.com/en-us/windows/win32/api/_wua/
     * Descriptive fields like title, and description are localized based on
     * the locale of the VM being updated.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage)
        com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsUpdatePackage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsUpdatePackage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.class,
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.Builder.class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        title_ = "";
        description_ = "";
        if (categoriesBuilder_ == null) {
          categories_ = java.util.Collections.emptyList();
        } else {
          categories_ = null;
          categoriesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        kbArticleIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        supportUrl_ = "";
        moreInfoUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
        updateId_ = "";
        revisionNumber_ = 0;
        lastDeploymentChangeTime_ = null;
        if (lastDeploymentChangeTimeBuilder_ != null) {
          lastDeploymentChangeTimeBuilder_.dispose();
          lastDeploymentChangeTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsUpdatePackage_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage build() {
        com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage buildPartial() {
        com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage result =
            new com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage result) {
        if (categoriesBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            categories_ = java.util.Collections.unmodifiableList(categories_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.categories_ = categories_;
        } else {
          result.categories_ = categoriesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.title_ = title_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          kbArticleIds_.makeImmutable();
          result.kbArticleIds_ = kbArticleIds_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.supportUrl_ = supportUrl_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          moreInfoUrls_.makeImmutable();
          result.moreInfoUrls_ = moreInfoUrls_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.updateId_ = updateId_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.revisionNumber_ = revisionNumber_;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.lastDeploymentChangeTime_ =
              lastDeploymentChangeTimeBuilder_ == null
                  ? lastDeploymentChangeTime_
                  : lastDeploymentChangeTimeBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage other) {
        if (other
            == com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                .getDefaultInstance()) return this;
        if (!other.getTitle().isEmpty()) {
          title_ = other.title_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (categoriesBuilder_ == null) {
          if (!other.categories_.isEmpty()) {
            if (categories_.isEmpty()) {
              categories_ = other.categories_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureCategoriesIsMutable();
              categories_.addAll(other.categories_);
            }
            onChanged();
          }
        } else {
          if (!other.categories_.isEmpty()) {
            if (categoriesBuilder_.isEmpty()) {
              categoriesBuilder_.dispose();
              categoriesBuilder_ = null;
              categories_ = other.categories_;
              bitField0_ = (bitField0_ & ~0x00000004);
              categoriesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getCategoriesFieldBuilder()
                      : null;
            } else {
              categoriesBuilder_.addAllMessages(other.categories_);
            }
          }
        }
        if (!other.kbArticleIds_.isEmpty()) {
          if (kbArticleIds_.isEmpty()) {
            kbArticleIds_ = other.kbArticleIds_;
            bitField0_ |= 0x00000008;
          } else {
            ensureKbArticleIdsIsMutable();
            kbArticleIds_.addAll(other.kbArticleIds_);
          }
          onChanged();
        }
        if (!other.getSupportUrl().isEmpty()) {
          supportUrl_ = other.supportUrl_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (!other.moreInfoUrls_.isEmpty()) {
          if (moreInfoUrls_.isEmpty()) {
            moreInfoUrls_ = other.moreInfoUrls_;
            bitField0_ |= 0x00000020;
          } else {
            ensureMoreInfoUrlsIsMutable();
            moreInfoUrls_.addAll(other.moreInfoUrls_);
          }
          onChanged();
        }
        if (!other.getUpdateId().isEmpty()) {
          updateId_ = other.updateId_;
          bitField0_ |= 0x00000040;
          onChanged();
        }
        if (other.getRevisionNumber() != 0) {
          setRevisionNumber(other.getRevisionNumber());
        }
        if (other.hasLastDeploymentChangeTime()) {
          mergeLastDeploymentChangeTime(other.getLastDeploymentChangeTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  title_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                          .WindowsUpdateCategory
                      m =
                          input.readMessage(
                              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                                  .WindowsUpdateCategory.parser(),
                              extensionRegistry);
                  if (categoriesBuilder_ == null) {
                    ensureCategoriesIsMutable();
                    categories_.add(m);
                  } else {
                    categoriesBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureKbArticleIdsIsMutable();
                  kbArticleIds_.add(s);
                  break;
                } // case 34
              case 42:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureMoreInfoUrlsIsMutable();
                  moreInfoUrls_.add(s);
                  break;
                } // case 42
              case 50:
                {
                  updateId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 50
              case 56:
                {
                  revisionNumber_ = input.readInt32();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 56
              case 82:
                {
                  input.readMessage(
                      getLastDeploymentChangeTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000100;
                  break;
                } // case 82
              case 90:
                {
                  supportUrl_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 90
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * The localized title of the update package.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The title.
       */
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The localized title of the update package.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The bytes for title.
       */
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The localized title of the update package.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @param value The title to set.
       * @return This builder for chaining.
       */
      public Builder setTitle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        title_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The localized title of the update package.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTitle() {
        title_ = getDefaultInstance().getTitle();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The localized title of the update package.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @param value The bytes for title to set.
       * @return This builder for chaining.
       */
      public Builder setTitleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        title_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * The localized description of the update package.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The localized description of the update package.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The localized description of the update package.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The localized description of the update package.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The localized description of the update package.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                  .WindowsUpdateCategory>
          categories_ = java.util.Collections.emptyList();

      private void ensureCategoriesIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          categories_ =
              new java.util.ArrayList<
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                      .WindowsUpdateCategory>(categories_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                  .WindowsUpdateCategory,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
                  .Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                  .WindowsUpdateCategoryOrBuilder>
          categoriesBuilder_;

      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                  .WindowsUpdateCategory>
          getCategoriesList() {
        if (categoriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(categories_);
        } else {
          return categoriesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public int getCategoriesCount() {
        if (categoriesBuilder_ == null) {
          return categories_.size();
        } else {
          return categoriesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
          getCategories(int index) {
        if (categoriesBuilder_ == null) {
          return categories_.get(index);
        } else {
          return categoriesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public Builder setCategories(
          int index,
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
              value) {
        if (categoriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCategoriesIsMutable();
          categories_.set(index, value);
          onChanged();
        } else {
          categoriesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public Builder setCategories(
          int index,
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
                  .Builder
              builderForValue) {
        if (categoriesBuilder_ == null) {
          ensureCategoriesIsMutable();
          categories_.set(index, builderForValue.build());
          onChanged();
        } else {
          categoriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public Builder addCategories(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
              value) {
        if (categoriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCategoriesIsMutable();
          categories_.add(value);
          onChanged();
        } else {
          categoriesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public Builder addCategories(
          int index,
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
              value) {
        if (categoriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCategoriesIsMutable();
          categories_.add(index, value);
          onChanged();
        } else {
          categoriesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public Builder addCategories(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
                  .Builder
              builderForValue) {
        if (categoriesBuilder_ == null) {
          ensureCategoriesIsMutable();
          categories_.add(builderForValue.build());
          onChanged();
        } else {
          categoriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public Builder addCategories(
          int index,
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
                  .Builder
              builderForValue) {
        if (categoriesBuilder_ == null) {
          ensureCategoriesIsMutable();
          categories_.add(index, builderForValue.build());
          onChanged();
        } else {
          categoriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public Builder addAllCategories(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                          .WindowsUpdateCategory>
              values) {
        if (categoriesBuilder_ == null) {
          ensureCategoriesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, categories_);
          onChanged();
        } else {
          categoriesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public Builder clearCategories() {
        if (categoriesBuilder_ == null) {
          categories_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          categoriesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public Builder removeCategories(int index) {
        if (categoriesBuilder_ == null) {
          ensureCategoriesIsMutable();
          categories_.remove(index);
          onChanged();
        } else {
          categoriesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
              .Builder
          getCategoriesBuilder(int index) {
        return getCategoriesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
              .WindowsUpdateCategoryOrBuilder
          getCategoriesOrBuilder(int index) {
        if (categoriesBuilder_ == null) {
          return categories_.get(index);
        } else {
          return categoriesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                      .WindowsUpdateCategoryOrBuilder>
          getCategoriesOrBuilderList() {
        if (categoriesBuilder_ != null) {
          return categoriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(categories_);
        }
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
              .Builder
          addCategoriesBuilder() {
        return getCategoriesFieldBuilder()
            .addBuilder(
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                    .WindowsUpdateCategory.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
              .Builder
          addCategoriesBuilder(int index) {
        return getCategoriesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                    .WindowsUpdateCategory.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The categories that are associated with this update package.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory categories = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
                  .Builder>
          getCategoriesBuilderList() {
        return getCategoriesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                  .WindowsUpdateCategory,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
                  .Builder,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                  .WindowsUpdateCategoryOrBuilder>
          getCategoriesFieldBuilder() {
        if (categoriesBuilder_ == null) {
          categoriesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                      .WindowsUpdateCategory,
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                      .WindowsUpdateCategory.Builder,
                  com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
                      .WindowsUpdateCategoryOrBuilder>(
                  categories_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
          categories_ = null;
        }
        return categoriesBuilder_;
      }

      private com.google.protobuf.LazyStringArrayList kbArticleIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureKbArticleIdsIsMutable() {
        if (!kbArticleIds_.isModifiable()) {
          kbArticleIds_ = new com.google.protobuf.LazyStringArrayList(kbArticleIds_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       *
       *
       * <pre>
       * A collection of Microsoft Knowledge Base article IDs that are associated
       * with the update package.
       * </pre>
       *
       * <code>repeated string kb_article_ids = 4;</code>
       *
       * @return A list containing the kbArticleIds.
       */
      public com.google.protobuf.ProtocolStringList getKbArticleIdsList() {
        kbArticleIds_.makeImmutable();
        return kbArticleIds_;
      }
      /**
       *
       *
       * <pre>
       * A collection of Microsoft Knowledge Base article IDs that are associated
       * with the update package.
       * </pre>
       *
       * <code>repeated string kb_article_ids = 4;</code>
       *
       * @return The count of kbArticleIds.
       */
      public int getKbArticleIdsCount() {
        return kbArticleIds_.size();
      }
      /**
       *
       *
       * <pre>
       * A collection of Microsoft Knowledge Base article IDs that are associated
       * with the update package.
       * </pre>
       *
       * <code>repeated string kb_article_ids = 4;</code>
       *
       * @param index The index of the element to return.
       * @return The kbArticleIds at the given index.
       */
      public java.lang.String getKbArticleIds(int index) {
        return kbArticleIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A collection of Microsoft Knowledge Base article IDs that are associated
       * with the update package.
       * </pre>
       *
       * <code>repeated string kb_article_ids = 4;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the kbArticleIds at the given index.
       */
      public com.google.protobuf.ByteString getKbArticleIdsBytes(int index) {
        return kbArticleIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * A collection of Microsoft Knowledge Base article IDs that are associated
       * with the update package.
       * </pre>
       *
       * <code>repeated string kb_article_ids = 4;</code>
       *
       * @param index The index to set the value at.
       * @param value The kbArticleIds to set.
       * @return This builder for chaining.
       */
      public Builder setKbArticleIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKbArticleIdsIsMutable();
        kbArticleIds_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of Microsoft Knowledge Base article IDs that are associated
       * with the update package.
       * </pre>
       *
       * <code>repeated string kb_article_ids = 4;</code>
       *
       * @param value The kbArticleIds to add.
       * @return This builder for chaining.
       */
      public Builder addKbArticleIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKbArticleIdsIsMutable();
        kbArticleIds_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of Microsoft Knowledge Base article IDs that are associated
       * with the update package.
       * </pre>
       *
       * <code>repeated string kb_article_ids = 4;</code>
       *
       * @param values The kbArticleIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllKbArticleIds(java.lang.Iterable<java.lang.String> values) {
        ensureKbArticleIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, kbArticleIds_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of Microsoft Knowledge Base article IDs that are associated
       * with the update package.
       * </pre>
       *
       * <code>repeated string kb_article_ids = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKbArticleIds() {
        kbArticleIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of Microsoft Knowledge Base article IDs that are associated
       * with the update package.
       * </pre>
       *
       * <code>repeated string kb_article_ids = 4;</code>
       *
       * @param value The bytes of the kbArticleIds to add.
       * @return This builder for chaining.
       */
      public Builder addKbArticleIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureKbArticleIdsIsMutable();
        kbArticleIds_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object supportUrl_ = "";
      /**
       *
       *
       * <pre>
       * A hyperlink to the language-specific support information for the update.
       * </pre>
       *
       * <code>string support_url = 11;</code>
       *
       * @return The supportUrl.
       */
      public java.lang.String getSupportUrl() {
        java.lang.Object ref = supportUrl_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          supportUrl_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A hyperlink to the language-specific support information for the update.
       * </pre>
       *
       * <code>string support_url = 11;</code>
       *
       * @return The bytes for supportUrl.
       */
      public com.google.protobuf.ByteString getSupportUrlBytes() {
        java.lang.Object ref = supportUrl_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          supportUrl_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A hyperlink to the language-specific support information for the update.
       * </pre>
       *
       * <code>string support_url = 11;</code>
       *
       * @param value The supportUrl to set.
       * @return This builder for chaining.
       */
      public Builder setSupportUrl(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        supportUrl_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A hyperlink to the language-specific support information for the update.
       * </pre>
       *
       * <code>string support_url = 11;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSupportUrl() {
        supportUrl_ = getDefaultInstance().getSupportUrl();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A hyperlink to the language-specific support information for the update.
       * </pre>
       *
       * <code>string support_url = 11;</code>
       *
       * @param value The bytes for supportUrl to set.
       * @return This builder for chaining.
       */
      public Builder setSupportUrlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        supportUrl_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList moreInfoUrls_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureMoreInfoUrlsIsMutable() {
        if (!moreInfoUrls_.isModifiable()) {
          moreInfoUrls_ = new com.google.protobuf.LazyStringArrayList(moreInfoUrls_);
        }
        bitField0_ |= 0x00000020;
      }
      /**
       *
       *
       * <pre>
       * A collection of URLs that provide more information about the update
       * package.
       * </pre>
       *
       * <code>repeated string more_info_urls = 5;</code>
       *
       * @return A list containing the moreInfoUrls.
       */
      public com.google.protobuf.ProtocolStringList getMoreInfoUrlsList() {
        moreInfoUrls_.makeImmutable();
        return moreInfoUrls_;
      }
      /**
       *
       *
       * <pre>
       * A collection of URLs that provide more information about the update
       * package.
       * </pre>
       *
       * <code>repeated string more_info_urls = 5;</code>
       *
       * @return The count of moreInfoUrls.
       */
      public int getMoreInfoUrlsCount() {
        return moreInfoUrls_.size();
      }
      /**
       *
       *
       * <pre>
       * A collection of URLs that provide more information about the update
       * package.
       * </pre>
       *
       * <code>repeated string more_info_urls = 5;</code>
       *
       * @param index The index of the element to return.
       * @return The moreInfoUrls at the given index.
       */
      public java.lang.String getMoreInfoUrls(int index) {
        return moreInfoUrls_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A collection of URLs that provide more information about the update
       * package.
       * </pre>
       *
       * <code>repeated string more_info_urls = 5;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the moreInfoUrls at the given index.
       */
      public com.google.protobuf.ByteString getMoreInfoUrlsBytes(int index) {
        return moreInfoUrls_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * A collection of URLs that provide more information about the update
       * package.
       * </pre>
       *
       * <code>repeated string more_info_urls = 5;</code>
       *
       * @param index The index to set the value at.
       * @param value The moreInfoUrls to set.
       * @return This builder for chaining.
       */
      public Builder setMoreInfoUrls(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMoreInfoUrlsIsMutable();
        moreInfoUrls_.set(index, value);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of URLs that provide more information about the update
       * package.
       * </pre>
       *
       * <code>repeated string more_info_urls = 5;</code>
       *
       * @param value The moreInfoUrls to add.
       * @return This builder for chaining.
       */
      public Builder addMoreInfoUrls(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMoreInfoUrlsIsMutable();
        moreInfoUrls_.add(value);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of URLs that provide more information about the update
       * package.
       * </pre>
       *
       * <code>repeated string more_info_urls = 5;</code>
       *
       * @param values The moreInfoUrls to add.
       * @return This builder for chaining.
       */
      public Builder addAllMoreInfoUrls(java.lang.Iterable<java.lang.String> values) {
        ensureMoreInfoUrlsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, moreInfoUrls_);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of URLs that provide more information about the update
       * package.
       * </pre>
       *
       * <code>repeated string more_info_urls = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMoreInfoUrls() {
        moreInfoUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of URLs that provide more information about the update
       * package.
       * </pre>
       *
       * <code>repeated string more_info_urls = 5;</code>
       *
       * @param value The bytes of the moreInfoUrls to add.
       * @return This builder for chaining.
       */
      public Builder addMoreInfoUrlsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureMoreInfoUrlsIsMutable();
        moreInfoUrls_.add(value);
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      private java.lang.Object updateId_ = "";
      /**
       *
       *
       * <pre>
       * Gets the identifier of an update package.  Stays the same across
       * revisions.
       * </pre>
       *
       * <code>string update_id = 6;</code>
       *
       * @return The updateId.
       */
      public java.lang.String getUpdateId() {
        java.lang.Object ref = updateId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          updateId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Gets the identifier of an update package.  Stays the same across
       * revisions.
       * </pre>
       *
       * <code>string update_id = 6;</code>
       *
       * @return The bytes for updateId.
       */
      public com.google.protobuf.ByteString getUpdateIdBytes() {
        java.lang.Object ref = updateId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          updateId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Gets the identifier of an update package.  Stays the same across
       * revisions.
       * </pre>
       *
       * <code>string update_id = 6;</code>
       *
       * @param value The updateId to set.
       * @return This builder for chaining.
       */
      public Builder setUpdateId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateId_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Gets the identifier of an update package.  Stays the same across
       * revisions.
       * </pre>
       *
       * <code>string update_id = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUpdateId() {
        updateId_ = getDefaultInstance().getUpdateId();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Gets the identifier of an update package.  Stays the same across
       * revisions.
       * </pre>
       *
       * <code>string update_id = 6;</code>
       *
       * @param value The bytes for updateId to set.
       * @return This builder for chaining.
       */
      public Builder setUpdateIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        updateId_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      private int revisionNumber_;
      /**
       *
       *
       * <pre>
       * The revision number of this update package.
       * </pre>
       *
       * <code>int32 revision_number = 7;</code>
       *
       * @return The revisionNumber.
       */
      @java.lang.Override
      public int getRevisionNumber() {
        return revisionNumber_;
      }
      /**
       *
       *
       * <pre>
       * The revision number of this update package.
       * </pre>
       *
       * <code>int32 revision_number = 7;</code>
       *
       * @param value The revisionNumber to set.
       * @return This builder for chaining.
       */
      public Builder setRevisionNumber(int value) {

        revisionNumber_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The revision number of this update package.
       * </pre>
       *
       * <code>int32 revision_number = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRevisionNumber() {
        bitField0_ = (bitField0_ & ~0x00000080);
        revisionNumber_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp lastDeploymentChangeTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          lastDeploymentChangeTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The last published date of the update, in (UTC) date and time.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
       *
       * @return Whether the lastDeploymentChangeTime field is set.
       */
      public boolean hasLastDeploymentChangeTime() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       *
       *
       * <pre>
       * The last published date of the update, in (UTC) date and time.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
       *
       * @return The lastDeploymentChangeTime.
       */
      public com.google.protobuf.Timestamp getLastDeploymentChangeTime() {
        if (lastDeploymentChangeTimeBuilder_ == null) {
          return lastDeploymentChangeTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastDeploymentChangeTime_;
        } else {
          return lastDeploymentChangeTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The last published date of the update, in (UTC) date and time.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
       */
      public Builder setLastDeploymentChangeTime(com.google.protobuf.Timestamp value) {
        if (lastDeploymentChangeTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastDeploymentChangeTime_ = value;
        } else {
          lastDeploymentChangeTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last published date of the update, in (UTC) date and time.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
       */
      public Builder setLastDeploymentChangeTime(
          com.google.protobuf.Timestamp.Builder builderForValue) {
        if (lastDeploymentChangeTimeBuilder_ == null) {
          lastDeploymentChangeTime_ = builderForValue.build();
        } else {
          lastDeploymentChangeTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last published date of the update, in (UTC) date and time.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
       */
      public Builder mergeLastDeploymentChangeTime(com.google.protobuf.Timestamp value) {
        if (lastDeploymentChangeTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)
              && lastDeploymentChangeTime_ != null
              && lastDeploymentChangeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getLastDeploymentChangeTimeBuilder().mergeFrom(value);
          } else {
            lastDeploymentChangeTime_ = value;
          }
        } else {
          lastDeploymentChangeTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last published date of the update, in (UTC) date and time.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
       */
      public Builder clearLastDeploymentChangeTime() {
        bitField0_ = (bitField0_ & ~0x00000100);
        lastDeploymentChangeTime_ = null;
        if (lastDeploymentChangeTimeBuilder_ != null) {
          lastDeploymentChangeTimeBuilder_.dispose();
          lastDeploymentChangeTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last published date of the update, in (UTC) date and time.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
       */
      public com.google.protobuf.Timestamp.Builder getLastDeploymentChangeTimeBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getLastDeploymentChangeTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The last published date of the update, in (UTC) date and time.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getLastDeploymentChangeTimeOrBuilder() {
        if (lastDeploymentChangeTimeBuilder_ != null) {
          return lastDeploymentChangeTimeBuilder_.getMessageOrBuilder();
        } else {
          return lastDeploymentChangeTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastDeploymentChangeTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The last published date of the update, in (UTC) date and time.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_deployment_change_time = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getLastDeploymentChangeTimeFieldBuilder() {
        if (lastDeploymentChangeTimeBuilder_ == null) {
          lastDeploymentChangeTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getLastDeploymentChangeTime(), getParentForChildren(), isClean());
          lastDeploymentChangeTime_ = null;
        }
        return lastDeploymentChangeTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage)
    private static final com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage();
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WindowsUpdatePackage> PARSER =
        new com.google.protobuf.AbstractParser<WindowsUpdatePackage>() {
          @java.lang.Override
          public WindowsUpdatePackage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WindowsUpdatePackage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WindowsUpdatePackage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WindowsQuickFixEngineeringPackageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A short textual description of the QFE update.
     * </pre>
     *
     * <code>string caption = 1;</code>
     *
     * @return The caption.
     */
    java.lang.String getCaption();
    /**
     *
     *
     * <pre>
     * A short textual description of the QFE update.
     * </pre>
     *
     * <code>string caption = 1;</code>
     *
     * @return The bytes for caption.
     */
    com.google.protobuf.ByteString getCaptionBytes();

    /**
     *
     *
     * <pre>
     * A textual description of the QFE update.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * A textual description of the QFE update.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * Unique identifier associated with a particular QFE update.
     * </pre>
     *
     * <code>string hot_fix_id = 3;</code>
     *
     * @return The hotFixId.
     */
    java.lang.String getHotFixId();
    /**
     *
     *
     * <pre>
     * Unique identifier associated with a particular QFE update.
     * </pre>
     *
     * <code>string hot_fix_id = 3;</code>
     *
     * @return The bytes for hotFixId.
     */
    com.google.protobuf.ByteString getHotFixIdBytes();

    /**
     *
     *
     * <pre>
     * Date that the QFE update was installed.  Mapped from installed_on field.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp install_time = 5;</code>
     *
     * @return Whether the installTime field is set.
     */
    boolean hasInstallTime();
    /**
     *
     *
     * <pre>
     * Date that the QFE update was installed.  Mapped from installed_on field.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp install_time = 5;</code>
     *
     * @return The installTime.
     */
    com.google.protobuf.Timestamp getInstallTime();
    /**
     *
     *
     * <pre>
     * Date that the QFE update was installed.  Mapped from installed_on field.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp install_time = 5;</code>
     */
    com.google.protobuf.TimestampOrBuilder getInstallTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Information related to a Quick Fix Engineering package.
   * Fields are taken from Windows QuickFixEngineering Interface and match
   * the source names:
   * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage}
   */
  public static final class WindowsQuickFixEngineeringPackage
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)
      WindowsQuickFixEngineeringPackageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WindowsQuickFixEngineeringPackage.newBuilder() to construct.
    private WindowsQuickFixEngineeringPackage(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WindowsQuickFixEngineeringPackage() {
      caption_ = "";
      description_ = "";
      hotFixId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WindowsQuickFixEngineeringPackage();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsQuickFixEngineeringPackage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsQuickFixEngineeringPackage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage.class,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage.Builder
                  .class);
    }

    public static final int CAPTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object caption_ = "";
    /**
     *
     *
     * <pre>
     * A short textual description of the QFE update.
     * </pre>
     *
     * <code>string caption = 1;</code>
     *
     * @return The caption.
     */
    @java.lang.Override
    public java.lang.String getCaption() {
      java.lang.Object ref = caption_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        caption_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A short textual description of the QFE update.
     * </pre>
     *
     * <code>string caption = 1;</code>
     *
     * @return The bytes for caption.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCaptionBytes() {
      java.lang.Object ref = caption_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        caption_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A textual description of the QFE update.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A textual description of the QFE update.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int HOT_FIX_ID_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object hotFixId_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier associated with a particular QFE update.
     * </pre>
     *
     * <code>string hot_fix_id = 3;</code>
     *
     * @return The hotFixId.
     */
    @java.lang.Override
    public java.lang.String getHotFixId() {
      java.lang.Object ref = hotFixId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hotFixId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier associated with a particular QFE update.
     * </pre>
     *
     * <code>string hot_fix_id = 3;</code>
     *
     * @return The bytes for hotFixId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHotFixIdBytes() {
      java.lang.Object ref = hotFixId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hotFixId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INSTALL_TIME_FIELD_NUMBER = 5;
    private com.google.protobuf.Timestamp installTime_;
    /**
     *
     *
     * <pre>
     * Date that the QFE update was installed.  Mapped from installed_on field.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp install_time = 5;</code>
     *
     * @return Whether the installTime field is set.
     */
    @java.lang.Override
    public boolean hasInstallTime() {
      return installTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Date that the QFE update was installed.  Mapped from installed_on field.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp install_time = 5;</code>
     *
     * @return The installTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getInstallTime() {
      return installTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : installTime_;
    }
    /**
     *
     *
     * <pre>
     * Date that the QFE update was installed.  Mapped from installed_on field.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp install_time = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getInstallTimeOrBuilder() {
      return installTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : installTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(caption_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, caption_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hotFixId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, hotFixId_);
      }
      if (installTime_ != null) {
        output.writeMessage(5, getInstallTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(caption_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, caption_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hotFixId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, hotFixId_);
      }
      if (installTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getInstallTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage other =
          (com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage) obj;

      if (!getCaption().equals(other.getCaption())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (!getHotFixId().equals(other.getHotFixId())) return false;
      if (hasInstallTime() != other.hasInstallTime()) return false;
      if (hasInstallTime()) {
        if (!getInstallTime().equals(other.getInstallTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CAPTION_FIELD_NUMBER;
      hash = (53 * hash) + getCaption().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (37 * hash) + HOT_FIX_ID_FIELD_NUMBER;
      hash = (53 * hash) + getHotFixId().hashCode();
      if (hasInstallTime()) {
        hash = (37 * hash) + INSTALL_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getInstallTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information related to a Quick Fix Engineering package.
     * Fields are taken from Windows QuickFixEngineering Interface and match
     * the source names:
     * https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)
        com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsQuickFixEngineeringPackage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsQuickFixEngineeringPackage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage.class,
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        caption_ = "";
        description_ = "";
        hotFixId_ = "";
        installTime_ = null;
        if (installTimeBuilder_ != null) {
          installTimeBuilder_.dispose();
          installTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsQuickFixEngineeringPackage_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage build() {
        com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
          buildPartial() {
        com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage result =
            new com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.caption_ = caption_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.hotFixId_ = hotFixId_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.installTime_ =
              installTimeBuilder_ == null ? installTime_ : installTimeBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage other) {
        if (other
            == com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
                .getDefaultInstance()) return this;
        if (!other.getCaption().isEmpty()) {
          caption_ = other.caption_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getHotFixId().isEmpty()) {
          hotFixId_ = other.hotFixId_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasInstallTime()) {
          mergeInstallTime(other.getInstallTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  caption_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  hotFixId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 42:
                {
                  input.readMessage(getInstallTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object caption_ = "";
      /**
       *
       *
       * <pre>
       * A short textual description of the QFE update.
       * </pre>
       *
       * <code>string caption = 1;</code>
       *
       * @return The caption.
       */
      public java.lang.String getCaption() {
        java.lang.Object ref = caption_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          caption_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A short textual description of the QFE update.
       * </pre>
       *
       * <code>string caption = 1;</code>
       *
       * @return The bytes for caption.
       */
      public com.google.protobuf.ByteString getCaptionBytes() {
        java.lang.Object ref = caption_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          caption_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A short textual description of the QFE update.
       * </pre>
       *
       * <code>string caption = 1;</code>
       *
       * @param value The caption to set.
       * @return This builder for chaining.
       */
      public Builder setCaption(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        caption_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A short textual description of the QFE update.
       * </pre>
       *
       * <code>string caption = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCaption() {
        caption_ = getDefaultInstance().getCaption();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A short textual description of the QFE update.
       * </pre>
       *
       * <code>string caption = 1;</code>
       *
       * @param value The bytes for caption to set.
       * @return This builder for chaining.
       */
      public Builder setCaptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        caption_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * A textual description of the QFE update.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A textual description of the QFE update.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A textual description of the QFE update.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A textual description of the QFE update.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A textual description of the QFE update.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object hotFixId_ = "";
      /**
       *
       *
       * <pre>
       * Unique identifier associated with a particular QFE update.
       * </pre>
       *
       * <code>string hot_fix_id = 3;</code>
       *
       * @return The hotFixId.
       */
      public java.lang.String getHotFixId() {
        java.lang.Object ref = hotFixId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          hotFixId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Unique identifier associated with a particular QFE update.
       * </pre>
       *
       * <code>string hot_fix_id = 3;</code>
       *
       * @return The bytes for hotFixId.
       */
      public com.google.protobuf.ByteString getHotFixIdBytes() {
        java.lang.Object ref = hotFixId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          hotFixId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Unique identifier associated with a particular QFE update.
       * </pre>
       *
       * <code>string hot_fix_id = 3;</code>
       *
       * @param value The hotFixId to set.
       * @return This builder for chaining.
       */
      public Builder setHotFixId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        hotFixId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Unique identifier associated with a particular QFE update.
       * </pre>
       *
       * <code>string hot_fix_id = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHotFixId() {
        hotFixId_ = getDefaultInstance().getHotFixId();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Unique identifier associated with a particular QFE update.
       * </pre>
       *
       * <code>string hot_fix_id = 3;</code>
       *
       * @param value The bytes for hotFixId to set.
       * @return This builder for chaining.
       */
      public Builder setHotFixIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        hotFixId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp installTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          installTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Date that the QFE update was installed.  Mapped from installed_on field.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp install_time = 5;</code>
       *
       * @return Whether the installTime field is set.
       */
      public boolean hasInstallTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Date that the QFE update was installed.  Mapped from installed_on field.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp install_time = 5;</code>
       *
       * @return The installTime.
       */
      public com.google.protobuf.Timestamp getInstallTime() {
        if (installTimeBuilder_ == null) {
          return installTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : installTime_;
        } else {
          return installTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Date that the QFE update was installed.  Mapped from installed_on field.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp install_time = 5;</code>
       */
      public Builder setInstallTime(com.google.protobuf.Timestamp value) {
        if (installTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          installTime_ = value;
        } else {
          installTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Date that the QFE update was installed.  Mapped from installed_on field.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp install_time = 5;</code>
       */
      public Builder setInstallTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (installTimeBuilder_ == null) {
          installTime_ = builderForValue.build();
        } else {
          installTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Date that the QFE update was installed.  Mapped from installed_on field.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp install_time = 5;</code>
       */
      public Builder mergeInstallTime(com.google.protobuf.Timestamp value) {
        if (installTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && installTime_ != null
              && installTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getInstallTimeBuilder().mergeFrom(value);
          } else {
            installTime_ = value;
          }
        } else {
          installTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Date that the QFE update was installed.  Mapped from installed_on field.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp install_time = 5;</code>
       */
      public Builder clearInstallTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        installTime_ = null;
        if (installTimeBuilder_ != null) {
          installTimeBuilder_.dispose();
          installTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Date that the QFE update was installed.  Mapped from installed_on field.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp install_time = 5;</code>
       */
      public com.google.protobuf.Timestamp.Builder getInstallTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getInstallTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Date that the QFE update was installed.  Mapped from installed_on field.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp install_time = 5;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getInstallTimeOrBuilder() {
        if (installTimeBuilder_ != null) {
          return installTimeBuilder_.getMessageOrBuilder();
        } else {
          return installTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : installTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Date that the QFE update was installed.  Mapped from installed_on field.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp install_time = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getInstallTimeFieldBuilder() {
        if (installTimeBuilder_ == null) {
          installTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getInstallTime(), getParentForChildren(), isClean());
          installTime_ = null;
        }
        return installTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage)
    private static final com.google.cloud.osconfig.v1alpha.Inventory
            .WindowsQuickFixEngineeringPackage
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage();
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WindowsQuickFixEngineeringPackage> PARSER =
        new com.google.protobuf.AbstractParser<WindowsQuickFixEngineeringPackage>() {
          @java.lang.Override
          public WindowsQuickFixEngineeringPackage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WindowsQuickFixEngineeringPackage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WindowsQuickFixEngineeringPackage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WindowsApplicationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.Inventory.WindowsApplication)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the application or product.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * The name of the application or product.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * The version of the product or application in string format.
     * </pre>
     *
     * <code>string display_version = 2;</code>
     *
     * @return The displayVersion.
     */
    java.lang.String getDisplayVersion();
    /**
     *
     *
     * <pre>
     * The version of the product or application in string format.
     * </pre>
     *
     * <code>string display_version = 2;</code>
     *
     * @return The bytes for displayVersion.
     */
    com.google.protobuf.ByteString getDisplayVersionBytes();

    /**
     *
     *
     * <pre>
     * The name of the manufacturer for the product or application.
     * </pre>
     *
     * <code>string publisher = 3;</code>
     *
     * @return The publisher.
     */
    java.lang.String getPublisher();
    /**
     *
     *
     * <pre>
     * The name of the manufacturer for the product or application.
     * </pre>
     *
     * <code>string publisher = 3;</code>
     *
     * @return The bytes for publisher.
     */
    com.google.protobuf.ByteString getPublisherBytes();

    /**
     *
     *
     * <pre>
     * The last time this product received service. The value of this property
     * is replaced each time a patch is applied or removed from the product or
     * the command-line option is used to repair the product.
     * </pre>
     *
     * <code>.google.type.Date install_date = 4;</code>
     *
     * @return Whether the installDate field is set.
     */
    boolean hasInstallDate();
    /**
     *
     *
     * <pre>
     * The last time this product received service. The value of this property
     * is replaced each time a patch is applied or removed from the product or
     * the command-line option is used to repair the product.
     * </pre>
     *
     * <code>.google.type.Date install_date = 4;</code>
     *
     * @return The installDate.
     */
    com.google.type.Date getInstallDate();
    /**
     *
     *
     * <pre>
     * The last time this product received service. The value of this property
     * is replaced each time a patch is applied or removed from the product or
     * the command-line option is used to repair the product.
     * </pre>
     *
     * <code>.google.type.Date install_date = 4;</code>
     */
    com.google.type.DateOrBuilder getInstallDateOrBuilder();

    /**
     *
     *
     * <pre>
     * The internet address for technical support.
     * </pre>
     *
     * <code>string help_link = 5;</code>
     *
     * @return The helpLink.
     */
    java.lang.String getHelpLink();
    /**
     *
     *
     * <pre>
     * The internet address for technical support.
     * </pre>
     *
     * <code>string help_link = 5;</code>
     *
     * @return The bytes for helpLink.
     */
    com.google.protobuf.ByteString getHelpLinkBytes();
  }
  /**
   *
   *
   * <pre>
   * Contains information about a Windows application that is retrieved from the
   * Windows Registry. For more information about these fields, see:
   * https://docs.microsoft.com/en-us/windows/win32/msi/uninstall-registry-key
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.WindowsApplication}
   */
  public static final class WindowsApplication extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.Inventory.WindowsApplication)
      WindowsApplicationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WindowsApplication.newBuilder() to construct.
    private WindowsApplication(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WindowsApplication() {
      displayName_ = "";
      displayVersion_ = "";
      publisher_ = "";
      helpLink_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WindowsApplication();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsApplication_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsApplication_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.class,
              com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.Builder.class);
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the application or product.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the application or product.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DISPLAY_VERSION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayVersion_ = "";
    /**
     *
     *
     * <pre>
     * The version of the product or application in string format.
     * </pre>
     *
     * <code>string display_version = 2;</code>
     *
     * @return The displayVersion.
     */
    @java.lang.Override
    public java.lang.String getDisplayVersion() {
      java.lang.Object ref = displayVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The version of the product or application in string format.
     * </pre>
     *
     * <code>string display_version = 2;</code>
     *
     * @return The bytes for displayVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayVersionBytes() {
      java.lang.Object ref = displayVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PUBLISHER_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object publisher_ = "";
    /**
     *
     *
     * <pre>
     * The name of the manufacturer for the product or application.
     * </pre>
     *
     * <code>string publisher = 3;</code>
     *
     * @return The publisher.
     */
    @java.lang.Override
    public java.lang.String getPublisher() {
      java.lang.Object ref = publisher_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publisher_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the manufacturer for the product or application.
     * </pre>
     *
     * <code>string publisher = 3;</code>
     *
     * @return The bytes for publisher.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPublisherBytes() {
      java.lang.Object ref = publisher_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publisher_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INSTALL_DATE_FIELD_NUMBER = 4;
    private com.google.type.Date installDate_;
    /**
     *
     *
     * <pre>
     * The last time this product received service. The value of this property
     * is replaced each time a patch is applied or removed from the product or
     * the command-line option is used to repair the product.
     * </pre>
     *
     * <code>.google.type.Date install_date = 4;</code>
     *
     * @return Whether the installDate field is set.
     */
    @java.lang.Override
    public boolean hasInstallDate() {
      return installDate_ != null;
    }
    /**
     *
     *
     * <pre>
     * The last time this product received service. The value of this property
     * is replaced each time a patch is applied or removed from the product or
     * the command-line option is used to repair the product.
     * </pre>
     *
     * <code>.google.type.Date install_date = 4;</code>
     *
     * @return The installDate.
     */
    @java.lang.Override
    public com.google.type.Date getInstallDate() {
      return installDate_ == null ? com.google.type.Date.getDefaultInstance() : installDate_;
    }
    /**
     *
     *
     * <pre>
     * The last time this product received service. The value of this property
     * is replaced each time a patch is applied or removed from the product or
     * the command-line option is used to repair the product.
     * </pre>
     *
     * <code>.google.type.Date install_date = 4;</code>
     */
    @java.lang.Override
    public com.google.type.DateOrBuilder getInstallDateOrBuilder() {
      return installDate_ == null ? com.google.type.Date.getDefaultInstance() : installDate_;
    }

    public static final int HELP_LINK_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object helpLink_ = "";
    /**
     *
     *
     * <pre>
     * The internet address for technical support.
     * </pre>
     *
     * <code>string help_link = 5;</code>
     *
     * @return The helpLink.
     */
    @java.lang.Override
    public java.lang.String getHelpLink() {
      java.lang.Object ref = helpLink_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        helpLink_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The internet address for technical support.
     * </pre>
     *
     * <code>string help_link = 5;</code>
     *
     * @return The bytes for helpLink.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHelpLinkBytes() {
      java.lang.Object ref = helpLink_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        helpLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayVersion_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publisher_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, publisher_);
      }
      if (installDate_ != null) {
        output.writeMessage(4, getInstallDate());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(helpLink_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, helpLink_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayVersion_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publisher_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, publisher_);
      }
      if (installDate_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getInstallDate());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(helpLink_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, helpLink_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication other =
          (com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication) obj;

      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (!getDisplayVersion().equals(other.getDisplayVersion())) return false;
      if (!getPublisher().equals(other.getPublisher())) return false;
      if (hasInstallDate() != other.hasInstallDate()) return false;
      if (hasInstallDate()) {
        if (!getInstallDate().equals(other.getInstallDate())) return false;
      }
      if (!getHelpLink().equals(other.getHelpLink())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (37 * hash) + DISPLAY_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayVersion().hashCode();
      hash = (37 * hash) + PUBLISHER_FIELD_NUMBER;
      hash = (53 * hash) + getPublisher().hashCode();
      if (hasInstallDate()) {
        hash = (37 * hash) + INSTALL_DATE_FIELD_NUMBER;
        hash = (53 * hash) + getInstallDate().hashCode();
      }
      hash = (37 * hash) + HELP_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getHelpLink().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Contains information about a Windows application that is retrieved from the
     * Windows Registry. For more information about these fields, see:
     * https://docs.microsoft.com/en-us/windows/win32/msi/uninstall-registry-key
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory.WindowsApplication}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.Inventory.WindowsApplication)
        com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplicationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsApplication_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsApplication_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.class,
                com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        displayName_ = "";
        displayVersion_ = "";
        publisher_ = "";
        installDate_ = null;
        if (installDateBuilder_ != null) {
          installDateBuilder_.dispose();
          installDateBuilder_ = null;
        }
        helpLink_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.Inventories
            .internal_static_google_cloud_osconfig_v1alpha_Inventory_WindowsApplication_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication build() {
        com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication buildPartial() {
        com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication result =
            new com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.displayName_ = displayName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.displayVersion_ = displayVersion_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.publisher_ = publisher_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.installDate_ =
              installDateBuilder_ == null ? installDate_ : installDateBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.helpLink_ = helpLink_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication) {
          return mergeFrom((com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication other) {
        if (other
            == com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.getDefaultInstance())
          return this;
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDisplayVersion().isEmpty()) {
          displayVersion_ = other.displayVersion_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getPublisher().isEmpty()) {
          publisher_ = other.publisher_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasInstallDate()) {
          mergeInstallDate(other.getInstallDate());
        }
        if (!other.getHelpLink().isEmpty()) {
          helpLink_ = other.helpLink_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  displayVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  publisher_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getInstallDateFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  helpLink_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * The name of the application or product.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the application or product.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the application or product.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the application or product.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the application or product.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object displayVersion_ = "";
      /**
       *
       *
       * <pre>
       * The version of the product or application in string format.
       * </pre>
       *
       * <code>string display_version = 2;</code>
       *
       * @return The displayVersion.
       */
      public java.lang.String getDisplayVersion() {
        java.lang.Object ref = displayVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The version of the product or application in string format.
       * </pre>
       *
       * <code>string display_version = 2;</code>
       *
       * @return The bytes for displayVersion.
       */
      public com.google.protobuf.ByteString getDisplayVersionBytes() {
        java.lang.Object ref = displayVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The version of the product or application in string format.
       * </pre>
       *
       * <code>string display_version = 2;</code>
       *
       * @param value The displayVersion to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayVersion_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The version of the product or application in string format.
       * </pre>
       *
       * <code>string display_version = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayVersion() {
        displayVersion_ = getDefaultInstance().getDisplayVersion();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The version of the product or application in string format.
       * </pre>
       *
       * <code>string display_version = 2;</code>
       *
       * @param value The bytes for displayVersion to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayVersion_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object publisher_ = "";
      /**
       *
       *
       * <pre>
       * The name of the manufacturer for the product or application.
       * </pre>
       *
       * <code>string publisher = 3;</code>
       *
       * @return The publisher.
       */
      public java.lang.String getPublisher() {
        java.lang.Object ref = publisher_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          publisher_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the manufacturer for the product or application.
       * </pre>
       *
       * <code>string publisher = 3;</code>
       *
       * @return The bytes for publisher.
       */
      public com.google.protobuf.ByteString getPublisherBytes() {
        java.lang.Object ref = publisher_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          publisher_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the manufacturer for the product or application.
       * </pre>
       *
       * <code>string publisher = 3;</code>
       *
       * @param value The publisher to set.
       * @return This builder for chaining.
       */
      public Builder setPublisher(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        publisher_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the manufacturer for the product or application.
       * </pre>
       *
       * <code>string publisher = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPublisher() {
        publisher_ = getDefaultInstance().getPublisher();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the manufacturer for the product or application.
       * </pre>
       *
       * <code>string publisher = 3;</code>
       *
       * @param value The bytes for publisher to set.
       * @return This builder for chaining.
       */
      public Builder setPublisherBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        publisher_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.type.Date installDate_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
          installDateBuilder_;
      /**
       *
       *
       * <pre>
       * The last time this product received service. The value of this property
       * is replaced each time a patch is applied or removed from the product or
       * the command-line option is used to repair the product.
       * </pre>
       *
       * <code>.google.type.Date install_date = 4;</code>
       *
       * @return Whether the installDate field is set.
       */
      public boolean hasInstallDate() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * The last time this product received service. The value of this property
       * is replaced each time a patch is applied or removed from the product or
       * the command-line option is used to repair the product.
       * </pre>
       *
       * <code>.google.type.Date install_date = 4;</code>
       *
       * @return The installDate.
       */
      public com.google.type.Date getInstallDate() {
        if (installDateBuilder_ == null) {
          return installDate_ == null ? com.google.type.Date.getDefaultInstance() : installDate_;
        } else {
          return installDateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The last time this product received service. The value of this property
       * is replaced each time a patch is applied or removed from the product or
       * the command-line option is used to repair the product.
       * </pre>
       *
       * <code>.google.type.Date install_date = 4;</code>
       */
      public Builder setInstallDate(com.google.type.Date value) {
        if (installDateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          installDate_ = value;
        } else {
          installDateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time this product received service. The value of this property
       * is replaced each time a patch is applied or removed from the product or
       * the command-line option is used to repair the product.
       * </pre>
       *
       * <code>.google.type.Date install_date = 4;</code>
       */
      public Builder setInstallDate(com.google.type.Date.Builder builderForValue) {
        if (installDateBuilder_ == null) {
          installDate_ = builderForValue.build();
        } else {
          installDateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time this product received service. The value of this property
       * is replaced each time a patch is applied or removed from the product or
       * the command-line option is used to repair the product.
       * </pre>
       *
       * <code>.google.type.Date install_date = 4;</code>
       */
      public Builder mergeInstallDate(com.google.type.Date value) {
        if (installDateBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && installDate_ != null
              && installDate_ != com.google.type.Date.getDefaultInstance()) {
            getInstallDateBuilder().mergeFrom(value);
          } else {
            installDate_ = value;
          }
        } else {
          installDateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time this product received service. The value of this property
       * is replaced each time a patch is applied or removed from the product or
       * the command-line option is used to repair the product.
       * </pre>
       *
       * <code>.google.type.Date install_date = 4;</code>
       */
      public Builder clearInstallDate() {
        bitField0_ = (bitField0_ & ~0x00000008);
        installDate_ = null;
        if (installDateBuilder_ != null) {
          installDateBuilder_.dispose();
          installDateBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time this product received service. The value of this property
       * is replaced each time a patch is applied or removed from the product or
       * the command-line option is used to repair the product.
       * </pre>
       *
       * <code>.google.type.Date install_date = 4;</code>
       */
      public com.google.type.Date.Builder getInstallDateBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getInstallDateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The last time this product received service. The value of this property
       * is replaced each time a patch is applied or removed from the product or
       * the command-line option is used to repair the product.
       * </pre>
       *
       * <code>.google.type.Date install_date = 4;</code>
       */
      public com.google.type.DateOrBuilder getInstallDateOrBuilder() {
        if (installDateBuilder_ != null) {
          return installDateBuilder_.getMessageOrBuilder();
        } else {
          return installDate_ == null ? com.google.type.Date.getDefaultInstance() : installDate_;
        }
      }
      /**
       *
       *
       * <pre>
       * The last time this product received service. The value of this property
       * is replaced each time a patch is applied or removed from the product or
       * the command-line option is used to repair the product.
       * </pre>
       *
       * <code>.google.type.Date install_date = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
          getInstallDateFieldBuilder() {
        if (installDateBuilder_ == null) {
          installDateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date,
                  com.google.type.Date.Builder,
                  com.google.type.DateOrBuilder>(
                  getInstallDate(), getParentForChildren(), isClean());
          installDate_ = null;
        }
        return installDateBuilder_;
      }

      private java.lang.Object helpLink_ = "";
      /**
       *
       *
       * <pre>
       * The internet address for technical support.
       * </pre>
       *
       * <code>string help_link = 5;</code>
       *
       * @return The helpLink.
       */
      public java.lang.String getHelpLink() {
        java.lang.Object ref = helpLink_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          helpLink_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The internet address for technical support.
       * </pre>
       *
       * <code>string help_link = 5;</code>
       *
       * @return The bytes for helpLink.
       */
      public com.google.protobuf.ByteString getHelpLinkBytes() {
        java.lang.Object ref = helpLink_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          helpLink_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The internet address for technical support.
       * </pre>
       *
       * <code>string help_link = 5;</code>
       *
       * @param value The helpLink to set.
       * @return This builder for chaining.
       */
      public Builder setHelpLink(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        helpLink_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The internet address for technical support.
       * </pre>
       *
       * <code>string help_link = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHelpLink() {
        helpLink_ = getDefaultInstance().getHelpLink();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The internet address for technical support.
       * </pre>
       *
       * <code>string help_link = 5;</code>
       *
       * @param value The bytes for helpLink to set.
       * @return This builder for chaining.
       */
      public Builder setHelpLinkBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        helpLink_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.Inventory.WindowsApplication)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.Inventory.WindowsApplication)
    private static final com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication();
    }

    public static com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WindowsApplication> PARSER =
        new com.google.protobuf.AbstractParser<WindowsApplication>() {
          @java.lang.Override
          public WindowsApplication parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WindowsApplication> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WindowsApplication> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.WindowsApplication
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The `Inventory` API resource name.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/instances/{instance_id}/inventory`
   * </pre>
   *
   * <code>string name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The `Inventory` API resource name.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/instances/{instance_id}/inventory`
   * </pre>
   *
   * <code>string name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OS_INFO_FIELD_NUMBER = 1;
  private com.google.cloud.osconfig.v1alpha.Inventory.OsInfo osInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Base level operating system information for the VM.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.Inventory.OsInfo os_info = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the osInfo field is set.
   */
  @java.lang.Override
  public boolean hasOsInfo() {
    return osInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Base level operating system information for the VM.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.Inventory.OsInfo os_info = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The osInfo.
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.Inventory.OsInfo getOsInfo() {
    return osInfo_ == null
        ? com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.getDefaultInstance()
        : osInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Base level operating system information for the VM.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.Inventory.OsInfo os_info = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.Inventory.OsInfoOrBuilder getOsInfoOrBuilder() {
    return osInfo_ == null
        ? com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.getDefaultInstance()
        : osInfo_;
  }

  public static final int ITEMS_FIELD_NUMBER = 2;

  private static final class ItemsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
                    newDefaultInstance(
                        com.google.cloud.osconfig.v1alpha.Inventories
                            .internal_static_google_cloud_osconfig_v1alpha_Inventory_ItemsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.osconfig.v1alpha.Inventory.Item.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
      items_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
      internalGetItems() {
    if (items_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ItemsDefaultEntryHolder.defaultEntry);
    }
    return items_;
  }

  public int getItemsCount() {
    return internalGetItems().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Inventory items related to the VM keyed by an opaque unique identifier for
   * each inventory item. The identifier is unique to each distinct and
   * addressable inventory item and will change, when there is a new package
   * version.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.osconfig.v1alpha.Inventory.Item&gt; items = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsItems(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetItems().getMap().containsKey(key);
  }
  /** Use {@link #getItemsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
      getItems() {
    return getItemsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Inventory items related to the VM keyed by an opaque unique identifier for
   * each inventory item. The identifier is unique to each distinct and
   * addressable inventory item and will change, when there is a new package
   * version.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.osconfig.v1alpha.Inventory.Item&gt; items = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
      getItemsMap() {
    return internalGetItems().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Inventory items related to the VM keyed by an opaque unique identifier for
   * each inventory item. The identifier is unique to each distinct and
   * addressable inventory item and will change, when there is a new package
   * version.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.osconfig.v1alpha.Inventory.Item&gt; items = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.osconfig.v1alpha.Inventory.Item getItemsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.osconfig.v1alpha.Inventory.Item defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item> map =
        internalGetItems().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Inventory items related to the VM keyed by an opaque unique identifier for
   * each inventory item. The identifier is unique to each distinct and
   * addressable inventory item and will change, when there is a new package
   * version.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.osconfig.v1alpha.Inventory.Item&gt; items = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.Inventory.Item getItemsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item> map =
        internalGetItems().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last reported inventory for the VM.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last reported inventory for the VM.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last reported inventory for the VM.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (osInfo_ != null) {
      output.writeMessage(1, getOsInfo());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetItems(), ItemsDefaultEntryHolder.defaultEntry, 2);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
    }
    if (updateTime_ != null) {
      output.writeMessage(4, getUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (osInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getOsInfo());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
        entry : internalGetItems().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
          items__ =
              ItemsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.osconfig.v1alpha.Inventory)) {
      return super.equals(obj);
    }
    com.google.cloud.osconfig.v1alpha.Inventory other =
        (com.google.cloud.osconfig.v1alpha.Inventory) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasOsInfo() != other.hasOsInfo()) return false;
    if (hasOsInfo()) {
      if (!getOsInfo().equals(other.getOsInfo())) return false;
    }
    if (!internalGetItems().equals(other.internalGetItems())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasOsInfo()) {
      hash = (37 * hash) + OS_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getOsInfo().hashCode();
    }
    if (!internalGetItems().getMap().isEmpty()) {
      hash = (37 * hash) + ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetItems().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.osconfig.v1alpha.Inventory parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.Inventory parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.Inventory parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.Inventory parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.Inventory parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.Inventory parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.Inventory parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.Inventory parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.Inventory parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.Inventory parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.Inventory parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.Inventory parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.osconfig.v1alpha.Inventory prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * This API resource represents the available inventory data for a
   * Compute Engine virtual machine (VM) instance at a given point in time.
   *
   * You can use this API resource to determine the inventory data of your VM.
   *
   * For more information, see [Information provided by OS inventory
   * management](https://cloud.google.com/compute/docs/instances/os-inventory-management#data-collected).
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.Inventory}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.Inventory)
      com.google.cloud.osconfig.v1alpha.InventoryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetItems();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutableItems();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.Inventory.class,
              com.google.cloud.osconfig.v1alpha.Inventory.Builder.class);
    }

    // Construct using com.google.cloud.osconfig.v1alpha.Inventory.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      osInfo_ = null;
      if (osInfoBuilder_ != null) {
        osInfoBuilder_.dispose();
        osInfoBuilder_ = null;
      }
      internalGetMutableItems().clear();
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.osconfig.v1alpha.Inventories
          .internal_static_google_cloud_osconfig_v1alpha_Inventory_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory getDefaultInstanceForType() {
      return com.google.cloud.osconfig.v1alpha.Inventory.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory build() {
      com.google.cloud.osconfig.v1alpha.Inventory result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory buildPartial() {
      com.google.cloud.osconfig.v1alpha.Inventory result =
          new com.google.cloud.osconfig.v1alpha.Inventory(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.osconfig.v1alpha.Inventory result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.osInfo_ = osInfoBuilder_ == null ? osInfo_ : osInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.items_ = internalGetItems();
        result.items_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.osconfig.v1alpha.Inventory) {
        return mergeFrom((com.google.cloud.osconfig.v1alpha.Inventory) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.osconfig.v1alpha.Inventory other) {
      if (other == com.google.cloud.osconfig.v1alpha.Inventory.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasOsInfo()) {
        mergeOsInfo(other.getOsInfo());
      }
      internalGetMutableItems().mergeFrom(other.internalGetItems());
      bitField0_ |= 0x00000004;
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getOsInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
                    items__ =
                        input.readMessage(
                            ItemsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableItems().getMutableMap().put(items__.getKey(), items__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The `Inventory` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/inventory`
     * </pre>
     *
     * <code>string name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The `Inventory` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/inventory`
     * </pre>
     *
     * <code>string name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The `Inventory` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/inventory`
     * </pre>
     *
     * <code>string name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The `Inventory` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/inventory`
     * </pre>
     *
     * <code>string name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The `Inventory` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/inventory`
     * </pre>
     *
     * <code>string name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.osconfig.v1alpha.Inventory.OsInfo osInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.Inventory.OsInfo,
            com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.Builder,
            com.google.cloud.osconfig.v1alpha.Inventory.OsInfoOrBuilder>
        osInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Base level operating system information for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.OsInfo os_info = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the osInfo field is set.
     */
    public boolean hasOsInfo() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Base level operating system information for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.OsInfo os_info = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The osInfo.
     */
    public com.google.cloud.osconfig.v1alpha.Inventory.OsInfo getOsInfo() {
      if (osInfoBuilder_ == null) {
        return osInfo_ == null
            ? com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.getDefaultInstance()
            : osInfo_;
      } else {
        return osInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Base level operating system information for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.OsInfo os_info = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOsInfo(com.google.cloud.osconfig.v1alpha.Inventory.OsInfo value) {
      if (osInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        osInfo_ = value;
      } else {
        osInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Base level operating system information for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.OsInfo os_info = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOsInfo(
        com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.Builder builderForValue) {
      if (osInfoBuilder_ == null) {
        osInfo_ = builderForValue.build();
      } else {
        osInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Base level operating system information for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.OsInfo os_info = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeOsInfo(com.google.cloud.osconfig.v1alpha.Inventory.OsInfo value) {
      if (osInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && osInfo_ != null
            && osInfo_ != com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.getDefaultInstance()) {
          getOsInfoBuilder().mergeFrom(value);
        } else {
          osInfo_ = value;
        }
      } else {
        osInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Base level operating system information for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.OsInfo os_info = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOsInfo() {
      bitField0_ = (bitField0_ & ~0x00000002);
      osInfo_ = null;
      if (osInfoBuilder_ != null) {
        osInfoBuilder_.dispose();
        osInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Base level operating system information for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.OsInfo os_info = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.Builder getOsInfoBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getOsInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Base level operating system information for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.OsInfo os_info = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.Inventory.OsInfoOrBuilder getOsInfoOrBuilder() {
      if (osInfoBuilder_ != null) {
        return osInfoBuilder_.getMessageOrBuilder();
      } else {
        return osInfo_ == null
            ? com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.getDefaultInstance()
            : osInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Base level operating system information for the VM.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.Inventory.OsInfo os_info = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.Inventory.OsInfo,
            com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.Builder,
            com.google.cloud.osconfig.v1alpha.Inventory.OsInfoOrBuilder>
        getOsInfoFieldBuilder() {
      if (osInfoBuilder_ == null) {
        osInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1alpha.Inventory.OsInfo,
                com.google.cloud.osconfig.v1alpha.Inventory.OsInfo.Builder,
                com.google.cloud.osconfig.v1alpha.Inventory.OsInfoOrBuilder>(
                getOsInfo(), getParentForChildren(), isClean());
        osInfo_ = null;
      }
      return osInfoBuilder_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
        items_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
        internalGetItems() {
      if (items_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ItemsDefaultEntryHolder.defaultEntry);
      }
      return items_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
        internalGetMutableItems() {
      if (items_ == null) {
        items_ = com.google.protobuf.MapField.newMapField(ItemsDefaultEntryHolder.defaultEntry);
      }
      if (!items_.isMutable()) {
        items_ = items_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return items_;
    }

    public int getItemsCount() {
      return internalGetItems().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Inventory items related to the VM keyed by an opaque unique identifier for
     * each inventory item. The identifier is unique to each distinct and
     * addressable inventory item and will change, when there is a new package
     * version.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.osconfig.v1alpha.Inventory.Item&gt; items = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsItems(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetItems().getMap().containsKey(key);
    }
    /** Use {@link #getItemsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
        getItems() {
      return getItemsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Inventory items related to the VM keyed by an opaque unique identifier for
     * each inventory item. The identifier is unique to each distinct and
     * addressable inventory item and will change, when there is a new package
     * version.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.osconfig.v1alpha.Inventory.Item&gt; items = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
        getItemsMap() {
      return internalGetItems().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Inventory items related to the VM keyed by an opaque unique identifier for
     * each inventory item. The identifier is unique to each distinct and
     * addressable inventory item and will change, when there is a new package
     * version.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.osconfig.v1alpha.Inventory.Item&gt; items = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.osconfig.v1alpha.Inventory.Item getItemsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.osconfig.v1alpha.Inventory.Item defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item> map =
          internalGetItems().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Inventory items related to the VM keyed by an opaque unique identifier for
     * each inventory item. The identifier is unique to each distinct and
     * addressable inventory item and will change, when there is a new package
     * version.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.osconfig.v1alpha.Inventory.Item&gt; items = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.Inventory.Item getItemsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item> map =
          internalGetItems().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearItems() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableItems().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Inventory items related to the VM keyed by an opaque unique identifier for
     * each inventory item. The identifier is unique to each distinct and
     * addressable inventory item and will change, when there is a new package
     * version.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.osconfig.v1alpha.Inventory.Item&gt; items = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeItems(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableItems().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item>
        getMutableItems() {
      bitField0_ |= 0x00000004;
      return internalGetMutableItems().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Inventory items related to the VM keyed by an opaque unique identifier for
     * each inventory item. The identifier is unique to each distinct and
     * addressable inventory item and will change, when there is a new package
     * version.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.osconfig.v1alpha.Inventory.Item&gt; items = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putItems(
        java.lang.String key, com.google.cloud.osconfig.v1alpha.Inventory.Item value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableItems().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Inventory items related to the VM keyed by an opaque unique identifier for
     * each inventory item. The identifier is unique to each distinct and
     * addressable inventory item and will change, when there is a new package
     * version.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.osconfig.v1alpha.Inventory.Item&gt; items = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllItems(
        java.util.Map<java.lang.String, com.google.cloud.osconfig.v1alpha.Inventory.Item> values) {
      internalGetMutableItems().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last reported inventory for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last reported inventory for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last reported inventory for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last reported inventory for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last reported inventory for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last reported inventory for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last reported inventory for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last reported inventory for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last reported inventory for the VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.Inventory)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.Inventory)
  private static final com.google.cloud.osconfig.v1alpha.Inventory DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.Inventory();
  }

  public static com.google.cloud.osconfig.v1alpha.Inventory getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Inventory> PARSER =
      new com.google.protobuf.AbstractParser<Inventory>() {
        @java.lang.Override
        public Inventory parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Inventory> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Inventory> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.Inventory getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
