/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1alpha/os_policy_assignments.proto

package com.google.cloud.osconfig.v1alpha;

/**
 *
 *
 * <pre>
 * OS policy assignment is an API resource that is used to
 * apply a set of OS policies to a dynamically targeted group of Compute Engine
 * VM instances.
 *
 * An OS policy is used to define the desired state configuration for a
 * Compute Engine VM instance through a set of configuration resources that
 * provide capabilities such as installing or removing software packages, or
 * executing a script.
 *
 * For more information, see [OS policy and OS policy
 * assignment](https://cloud.google.com/compute/docs/os-configuration-management/working-with-os-policies).
 * </pre>
 *
 * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyAssignment}
 */
public final class OSPolicyAssignment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.OSPolicyAssignment)
    OSPolicyAssignmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OSPolicyAssignment.newBuilder() to construct.
  private OSPolicyAssignment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OSPolicyAssignment() {
    name_ = "";
    description_ = "";
    osPolicies_ = java.util.Collections.emptyList();
    revisionId_ = "";
    etag_ = "";
    rolloutState_ = 0;
    uid_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OSPolicyAssignment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
        .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
        .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.class,
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * OS policy assignment rollout state
   * </pre>
   *
   * Protobuf enum {@code google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState}
   */
  public enum RolloutState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid value
     * </pre>
     *
     * <code>ROLLOUT_STATE_UNSPECIFIED = 0;</code>
     */
    ROLLOUT_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The rollout is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    IN_PROGRESS(1),
    /**
     *
     *
     * <pre>
     * The rollout is being cancelled.
     * </pre>
     *
     * <code>CANCELLING = 2;</code>
     */
    CANCELLING(2),
    /**
     *
     *
     * <pre>
     * The rollout is cancelled.
     * </pre>
     *
     * <code>CANCELLED = 3;</code>
     */
    CANCELLED(3),
    /**
     *
     *
     * <pre>
     * The rollout has completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    SUCCEEDED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid value
     * </pre>
     *
     * <code>ROLLOUT_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int ROLLOUT_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The rollout is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    public static final int IN_PROGRESS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The rollout is being cancelled.
     * </pre>
     *
     * <code>CANCELLING = 2;</code>
     */
    public static final int CANCELLING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The rollout is cancelled.
     * </pre>
     *
     * <code>CANCELLED = 3;</code>
     */
    public static final int CANCELLED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The rollout has completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    public static final int SUCCEEDED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RolloutState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RolloutState forNumber(int value) {
      switch (value) {
        case 0:
          return ROLLOUT_STATE_UNSPECIFIED;
        case 1:
          return IN_PROGRESS;
        case 2:
          return CANCELLING;
        case 3:
          return CANCELLED;
        case 4:
          return SUCCEEDED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RolloutState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RolloutState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RolloutState>() {
          public RolloutState findValueByNumber(int number) {
            return RolloutState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final RolloutState[] VALUES = values();

    public static RolloutState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RolloutState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState)
  }

  public interface LabelSetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Labels are identified by key/value pairs in this map.
     * A VM should contain all the key/value pairs specified in this
     * map to be selected.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    int getLabelsCount();
    /**
     *
     *
     * <pre>
     * Labels are identified by key/value pairs in this map.
     * A VM should contain all the key/value pairs specified in this
     * map to be selected.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    boolean containsLabels(java.lang.String key);
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getLabels();
    /**
     *
     *
     * <pre>
     * Labels are identified by key/value pairs in this map.
     * A VM should contain all the key/value pairs specified in this
     * map to be selected.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
    /**
     *
     *
     * <pre>
     * Labels are identified by key/value pairs in this map.
     * A VM should contain all the key/value pairs specified in this
     * map to be selected.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    /* nullable */
    java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * Labels are identified by key/value pairs in this map.
     * A VM should contain all the key/value pairs specified in this
     * map to be selected.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    java.lang.String getLabelsOrThrow(java.lang.String key);
  }
  /**
   *
   *
   * <pre>
   * Message representing label set.
   * * A label is a key value pair set for a VM.
   * * A LabelSet is a set of labels.
   * * Labels within a LabelSet are ANDed. In other words, a LabelSet is
   *   applicable for a VM only if it matches all the labels in the
   *   LabelSet.
   * * Example: A LabelSet with 2 labels: `env=prod` and `type=webserver` will
   *            only be applicable for those VMs with both labels
   *            present.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet}
   */
  public static final class LabelSet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet)
      LabelSetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LabelSet.newBuilder() to construct.
    private LabelSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LabelSet() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LabelSet();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_LabelSet_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 1:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_LabelSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.class,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder.class);
    }

    public static final int LABELS_FIELD_NUMBER = 1;

    private static final class LabelsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
                  .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_LabelSet_LabelsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels are identified by key/value pairs in this map.
     * A VM should contain all the key/value pairs specified in this
     * map to be selected.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are identified by key/value pairs in this map.
     * A VM should contain all the key/value pairs specified in this
     * map to be selected.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are identified by key/value pairs in this map.
     * A VM should contain all the key/value pairs specified in this
     * map to be selected.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels are identified by key/value pairs in this map.
     * A VM should contain all the key/value pairs specified in this
     * map to be selected.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 1);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetLabels().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
            LabelsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, labels__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet other =
          (com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet) obj;

      if (!internalGetLabels().equals(other.internalGetLabels())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (!internalGetLabels().getMap().isEmpty()) {
        hash = (37 * hash) + LABELS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetLabels().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message representing label set.
     * * A label is a key value pair set for a VM.
     * * A LabelSet is a set of labels.
     * * Labels within a LabelSet are ANDed. In other words, a LabelSet is
     *   applicable for a VM only if it matches all the labels in the
     *   LabelSet.
     * * Example: A LabelSet with 2 labels: `env=prod` and `type=webserver` will
     *            only be applicable for those VMs with both labels
     *            present.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet)
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_LabelSet_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 1:
            return internalGetLabels();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 1:
            return internalGetMutableLabels();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_LabelSet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.class,
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        internalGetMutableLabels().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_LabelSet_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet build() {
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet buildPartial() {
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet result =
            new com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.labels_ = internalGetLabels();
          result.labels_.makeImmutable();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet) {
          return mergeFrom((com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet other) {
        if (other
            == com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.getDefaultInstance())
          return this;
        internalGetMutableLabels().mergeFrom(other.internalGetLabels());
        bitField0_ |= 0x00000001;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                      input.readMessage(
                          LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableLabels()
                      .getMutableMap()
                      .put(labels__.getKey(), labels__.getValue());
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
        if (labels_ == null) {
          return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return labels_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableLabels() {
        if (labels_ == null) {
          labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        if (!labels_.isMutable()) {
          labels_ = labels_.copy();
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return labels_;
      }

      public int getLabelsCount() {
        return internalGetLabels().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Labels are identified by key/value pairs in this map.
       * A VM should contain all the key/value pairs specified in this
       * map to be selected.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 1;</code>
       */
      @java.lang.Override
      public boolean containsLabels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetLabels().getMap().containsKey(key);
      }
      /** Use {@link #getLabelsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getLabels() {
        return getLabelsMap();
      }
      /**
       *
       *
       * <pre>
       * Labels are identified by key/value pairs in this map.
       * A VM should contain all the key/value pairs specified in this
       * map to be selected.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 1;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
        return internalGetLabels().getMap();
      }
      /**
       *
       *
       * <pre>
       * Labels are identified by key/value pairs in this map.
       * A VM should contain all the key/value pairs specified in this
       * map to be selected.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 1;</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getLabelsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Labels are identified by key/value pairs in this map.
       * A VM should contain all the key/value pairs specified in this
       * map to be selected.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 1;</code>
       */
      @java.lang.Override
      public java.lang.String getLabelsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearLabels() {
        bitField0_ = (bitField0_ & ~0x00000001);
        internalGetMutableLabels().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Labels are identified by key/value pairs in this map.
       * A VM should contain all the key/value pairs specified in this
       * map to be selected.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 1;</code>
       */
      public Builder removeLabels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableLabels().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
        bitField0_ |= 0x00000001;
        return internalGetMutableLabels().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Labels are identified by key/value pairs in this map.
       * A VM should contain all the key/value pairs specified in this
       * map to be selected.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 1;</code>
       */
      public Builder putLabels(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableLabels().getMutableMap().put(key, value);
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Labels are identified by key/value pairs in this map.
       * A VM should contain all the key/value pairs specified in this
       * map to be selected.
       * </pre>
       *
       * <code>map&lt;string, string&gt; labels = 1;</code>
       */
      public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableLabels().getMutableMap().putAll(values);
        bitField0_ |= 0x00000001;
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet)
    private static final com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet();
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LabelSet> PARSER =
        new com.google.protobuf.AbstractParser<LabelSet>() {
          @java.lang.Override
          public LabelSet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LabelSet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LabelSet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InstanceFilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Target all VMs in the project. If true, no other criteria is
     * permitted.
     * </pre>
     *
     * <code>bool all = 1;</code>
     *
     * @return The all.
     */
    boolean getAll();

    /**
     *
     *
     * <pre>
     * Deprecated. Use the `inventories` field instead.
     * A VM is selected if it's OS short name matches with any of the
     * values provided in this list.
     * </pre>
     *
     * <code>repeated string os_short_names = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names is
     *     deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
     * @return A list containing the osShortNames.
     */
    @java.lang.Deprecated
    java.util.List<java.lang.String> getOsShortNamesList();
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `inventories` field instead.
     * A VM is selected if it's OS short name matches with any of the
     * values provided in this list.
     * </pre>
     *
     * <code>repeated string os_short_names = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names is
     *     deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
     * @return The count of osShortNames.
     */
    @java.lang.Deprecated
    int getOsShortNamesCount();
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `inventories` field instead.
     * A VM is selected if it's OS short name matches with any of the
     * values provided in this list.
     * </pre>
     *
     * <code>repeated string os_short_names = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names is
     *     deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
     * @param index The index of the element to return.
     * @return The osShortNames at the given index.
     */
    @java.lang.Deprecated
    java.lang.String getOsShortNames(int index);
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `inventories` field instead.
     * A VM is selected if it's OS short name matches with any of the
     * values provided in this list.
     * </pre>
     *
     * <code>repeated string os_short_names = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names is
     *     deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
     * @param index The index of the value to return.
     * @return The bytes of the osShortNames at the given index.
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getOsShortNamesBytes(int index);

    /**
     *
     *
     * <pre>
     * List of label sets used for VM inclusion.
     *
     * If the list has more than one `LabelSet`, the VM is included if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
     * </code>
     */
    java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>
        getInclusionLabelsList();
    /**
     *
     *
     * <pre>
     * List of label sets used for VM inclusion.
     *
     * If the list has more than one `LabelSet`, the VM is included if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet getInclusionLabels(int index);
    /**
     *
     *
     * <pre>
     * List of label sets used for VM inclusion.
     *
     * If the list has more than one `LabelSet`, the VM is included if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
     * </code>
     */
    int getInclusionLabelsCount();
    /**
     *
     *
     * <pre>
     * List of label sets used for VM inclusion.
     *
     * If the list has more than one `LabelSet`, the VM is included if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
     * </code>
     */
    java.util.List<? extends com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder>
        getInclusionLabelsOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of label sets used for VM inclusion.
     *
     * If the list has more than one `LabelSet`, the VM is included if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder
        getInclusionLabelsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * List of label sets used for VM exclusion.
     *
     * If the list has more than one label set, the VM is excluded if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
     * </code>
     */
    java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>
        getExclusionLabelsList();
    /**
     *
     *
     * <pre>
     * List of label sets used for VM exclusion.
     *
     * If the list has more than one label set, the VM is excluded if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet getExclusionLabels(int index);
    /**
     *
     *
     * <pre>
     * List of label sets used for VM exclusion.
     *
     * If the list has more than one label set, the VM is excluded if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
     * </code>
     */
    int getExclusionLabelsCount();
    /**
     *
     *
     * <pre>
     * List of label sets used for VM exclusion.
     *
     * If the list has more than one label set, the VM is excluded if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
     * </code>
     */
    java.util.List<? extends com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder>
        getExclusionLabelsOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of label sets used for VM exclusion.
     *
     * If the list has more than one label set, the VM is excluded if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder
        getExclusionLabelsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * List of inventories to select VMs.
     *
     * A VM is selected if its inventory data matches at least one of the
     * following inventories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
     * </code>
     */
    java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory>
        getInventoriesList();
    /**
     *
     *
     * <pre>
     * List of inventories to select VMs.
     *
     * A VM is selected if its inventory data matches at least one of the
     * following inventories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory getInventories(
        int index);
    /**
     *
     *
     * <pre>
     * List of inventories to select VMs.
     *
     * A VM is selected if its inventory data matches at least one of the
     * following inventories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
     * </code>
     */
    int getInventoriesCount();
    /**
     *
     *
     * <pre>
     * List of inventories to select VMs.
     *
     * A VM is selected if its inventory data matches at least one of the
     * following inventories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
                    .InventoryOrBuilder>
        getInventoriesOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of inventories to select VMs.
     *
     * A VM is selected if its inventory data matches at least one of the
     * following inventories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.InventoryOrBuilder
        getInventoriesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Filters to select target VMs for an assignment.
   *
   * If more than one filter criteria is specified below, a VM will be selected
   * if and only if it satisfies all of them.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter}
   */
  public static final class InstanceFilter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter)
      InstanceFilterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InstanceFilter.newBuilder() to construct.
    private InstanceFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InstanceFilter() {
      osShortNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      inclusionLabels_ = java.util.Collections.emptyList();
      exclusionLabels_ = java.util.Collections.emptyList();
      inventories_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InstanceFilter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_InstanceFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_InstanceFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.class,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Builder.class);
    }

    public interface InventoryOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The OS short name
       * </pre>
       *
       * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The osShortName.
       */
      java.lang.String getOsShortName();
      /**
       *
       *
       * <pre>
       * Required. The OS short name
       * </pre>
       *
       * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for osShortName.
       */
      com.google.protobuf.ByteString getOsShortNameBytes();

      /**
       *
       *
       * <pre>
       * The OS version
       *
       * Prefix matches are supported if asterisk(*) is provided as the
       * last character. For example, to match all versions with a major
       * version of `7`, specify the following value for this field `7.*`
       *
       * An empty string matches all OS versions.
       * </pre>
       *
       * <code>string os_version = 2;</code>
       *
       * @return The osVersion.
       */
      java.lang.String getOsVersion();
      /**
       *
       *
       * <pre>
       * The OS version
       *
       * Prefix matches are supported if asterisk(*) is provided as the
       * last character. For example, to match all versions with a major
       * version of `7`, specify the following value for this field `7.*`
       *
       * An empty string matches all OS versions.
       * </pre>
       *
       * <code>string os_version = 2;</code>
       *
       * @return The bytes for osVersion.
       */
      com.google.protobuf.ByteString getOsVersionBytes();
    }
    /**
     *
     *
     * <pre>
     * VM inventory details.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory}
     */
    public static final class Inventory extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory)
        InventoryOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Inventory.newBuilder() to construct.
      private Inventory(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Inventory() {
        osShortName_ = "";
        osVersion_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Inventory();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_InstanceFilter_Inventory_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_InstanceFilter_Inventory_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory.class,
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
                    .Builder.class);
      }

      public static final int OS_SHORT_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object osShortName_ = "";
      /**
       *
       *
       * <pre>
       * Required. The OS short name
       * </pre>
       *
       * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The osShortName.
       */
      @java.lang.Override
      public java.lang.String getOsShortName() {
        java.lang.Object ref = osShortName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          osShortName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The OS short name
       * </pre>
       *
       * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for osShortName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getOsShortNameBytes() {
        java.lang.Object ref = osShortName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          osShortName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int OS_VERSION_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object osVersion_ = "";
      /**
       *
       *
       * <pre>
       * The OS version
       *
       * Prefix matches are supported if asterisk(*) is provided as the
       * last character. For example, to match all versions with a major
       * version of `7`, specify the following value for this field `7.*`
       *
       * An empty string matches all OS versions.
       * </pre>
       *
       * <code>string os_version = 2;</code>
       *
       * @return The osVersion.
       */
      @java.lang.Override
      public java.lang.String getOsVersion() {
        java.lang.Object ref = osVersion_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          osVersion_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The OS version
       *
       * Prefix matches are supported if asterisk(*) is provided as the
       * last character. For example, to match all versions with a major
       * version of `7`, specify the following value for this field `7.*`
       *
       * An empty string matches all OS versions.
       * </pre>
       *
       * <code>string os_version = 2;</code>
       *
       * @return The bytes for osVersion.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getOsVersionBytes() {
        java.lang.Object ref = osVersion_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          osVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osShortName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, osShortName_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osVersion_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, osVersion_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osShortName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, osShortName_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osVersion_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, osVersion_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory)) {
          return super.equals(obj);
        }
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory other =
            (com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory) obj;

        if (!getOsShortName().equals(other.getOsShortName())) return false;
        if (!getOsVersion().equals(other.getOsVersion())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + OS_SHORT_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getOsShortName().hashCode();
        hash = (37 * hash) + OS_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getOsVersion().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * VM inventory details.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory)
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.InventoryOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
              .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_InstanceFilter_Inventory_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
              .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_InstanceFilter_Inventory_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
                      .class,
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          osShortName_ = "";
          osVersion_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
              .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_InstanceFilter_Inventory_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
            getDefaultInstanceForType() {
          return com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
            build() {
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
            buildPartial() {
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory result =
              new com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.osShortName_ = osShortName_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.osVersion_ = osVersion_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory) {
            return mergeFrom(
                (com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory other) {
          if (other
              == com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
                  .getDefaultInstance()) return this;
          if (!other.getOsShortName().isEmpty()) {
            osShortName_ = other.osShortName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getOsVersion().isEmpty()) {
            osVersion_ = other.osVersion_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    osShortName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    osVersion_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object osShortName_ = "";
        /**
         *
         *
         * <pre>
         * Required. The OS short name
         * </pre>
         *
         * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The osShortName.
         */
        public java.lang.String getOsShortName() {
          java.lang.Object ref = osShortName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            osShortName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The OS short name
         * </pre>
         *
         * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for osShortName.
         */
        public com.google.protobuf.ByteString getOsShortNameBytes() {
          java.lang.Object ref = osShortName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            osShortName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The OS short name
         * </pre>
         *
         * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The osShortName to set.
         * @return This builder for chaining.
         */
        public Builder setOsShortName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          osShortName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The OS short name
         * </pre>
         *
         * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOsShortName() {
          osShortName_ = getDefaultInstance().getOsShortName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The OS short name
         * </pre>
         *
         * <code>string os_short_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for osShortName to set.
         * @return This builder for chaining.
         */
        public Builder setOsShortNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          osShortName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object osVersion_ = "";
        /**
         *
         *
         * <pre>
         * The OS version
         *
         * Prefix matches are supported if asterisk(*) is provided as the
         * last character. For example, to match all versions with a major
         * version of `7`, specify the following value for this field `7.*`
         *
         * An empty string matches all OS versions.
         * </pre>
         *
         * <code>string os_version = 2;</code>
         *
         * @return The osVersion.
         */
        public java.lang.String getOsVersion() {
          java.lang.Object ref = osVersion_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            osVersion_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The OS version
         *
         * Prefix matches are supported if asterisk(*) is provided as the
         * last character. For example, to match all versions with a major
         * version of `7`, specify the following value for this field `7.*`
         *
         * An empty string matches all OS versions.
         * </pre>
         *
         * <code>string os_version = 2;</code>
         *
         * @return The bytes for osVersion.
         */
        public com.google.protobuf.ByteString getOsVersionBytes() {
          java.lang.Object ref = osVersion_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            osVersion_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The OS version
         *
         * Prefix matches are supported if asterisk(*) is provided as the
         * last character. For example, to match all versions with a major
         * version of `7`, specify the following value for this field `7.*`
         *
         * An empty string matches all OS versions.
         * </pre>
         *
         * <code>string os_version = 2;</code>
         *
         * @param value The osVersion to set.
         * @return This builder for chaining.
         */
        public Builder setOsVersion(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          osVersion_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The OS version
         *
         * Prefix matches are supported if asterisk(*) is provided as the
         * last character. For example, to match all versions with a major
         * version of `7`, specify the following value for this field `7.*`
         *
         * An empty string matches all OS versions.
         * </pre>
         *
         * <code>string os_version = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOsVersion() {
          osVersion_ = getDefaultInstance().getOsVersion();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The OS version
         *
         * Prefix matches are supported if asterisk(*) is provided as the
         * last character. For example, to match all versions with a major
         * version of `7`, specify the following value for this field `7.*`
         *
         * An empty string matches all OS versions.
         * </pre>
         *
         * <code>string os_version = 2;</code>
         *
         * @param value The bytes for osVersion to set.
         * @return This builder for chaining.
         */
        public Builder setOsVersionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          osVersion_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory)
      private static final com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
              .Inventory
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory();
      }

      public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Inventory> PARSER =
          new com.google.protobuf.AbstractParser<Inventory>() {
            @java.lang.Override
            public Inventory parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Inventory> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Inventory> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int ALL_FIELD_NUMBER = 1;
    private boolean all_ = false;
    /**
     *
     *
     * <pre>
     * Target all VMs in the project. If true, no other criteria is
     * permitted.
     * </pre>
     *
     * <code>bool all = 1;</code>
     *
     * @return The all.
     */
    @java.lang.Override
    public boolean getAll() {
      return all_;
    }

    public static final int OS_SHORT_NAMES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList osShortNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `inventories` field instead.
     * A VM is selected if it's OS short name matches with any of the
     * values provided in this list.
     * </pre>
     *
     * <code>repeated string os_short_names = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names is
     *     deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
     * @return A list containing the osShortNames.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ProtocolStringList getOsShortNamesList() {
      return osShortNames_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `inventories` field instead.
     * A VM is selected if it's OS short name matches with any of the
     * values provided in this list.
     * </pre>
     *
     * <code>repeated string os_short_names = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names is
     *     deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
     * @return The count of osShortNames.
     */
    @java.lang.Deprecated
    public int getOsShortNamesCount() {
      return osShortNames_.size();
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `inventories` field instead.
     * A VM is selected if it's OS short name matches with any of the
     * values provided in this list.
     * </pre>
     *
     * <code>repeated string os_short_names = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names is
     *     deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
     * @param index The index of the element to return.
     * @return The osShortNames at the given index.
     */
    @java.lang.Deprecated
    public java.lang.String getOsShortNames(int index) {
      return osShortNames_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `inventories` field instead.
     * A VM is selected if it's OS short name matches with any of the
     * values provided in this list.
     * </pre>
     *
     * <code>repeated string os_short_names = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names is
     *     deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
     * @param index The index of the value to return.
     * @return The bytes of the osShortNames at the given index.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getOsShortNamesBytes(int index) {
      return osShortNames_.getByteString(index);
    }

    public static final int INCLUSION_LABELS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>
        inclusionLabels_;
    /**
     *
     *
     * <pre>
     * List of label sets used for VM inclusion.
     *
     * If the list has more than one `LabelSet`, the VM is included if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>
        getInclusionLabelsList() {
      return inclusionLabels_;
    }
    /**
     *
     *
     * <pre>
     * List of label sets used for VM inclusion.
     *
     * If the list has more than one `LabelSet`, the VM is included if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder>
        getInclusionLabelsOrBuilderList() {
      return inclusionLabels_;
    }
    /**
     *
     *
     * <pre>
     * List of label sets used for VM inclusion.
     *
     * If the list has more than one `LabelSet`, the VM is included if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
     * </code>
     */
    @java.lang.Override
    public int getInclusionLabelsCount() {
      return inclusionLabels_.size();
    }
    /**
     *
     *
     * <pre>
     * List of label sets used for VM inclusion.
     *
     * If the list has more than one `LabelSet`, the VM is included if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet getInclusionLabels(
        int index) {
      return inclusionLabels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of label sets used for VM inclusion.
     *
     * If the list has more than one `LabelSet`, the VM is included if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder
        getInclusionLabelsOrBuilder(int index) {
      return inclusionLabels_.get(index);
    }

    public static final int EXCLUSION_LABELS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>
        exclusionLabels_;
    /**
     *
     *
     * <pre>
     * List of label sets used for VM exclusion.
     *
     * If the list has more than one label set, the VM is excluded if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>
        getExclusionLabelsList() {
      return exclusionLabels_;
    }
    /**
     *
     *
     * <pre>
     * List of label sets used for VM exclusion.
     *
     * If the list has more than one label set, the VM is excluded if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder>
        getExclusionLabelsOrBuilderList() {
      return exclusionLabels_;
    }
    /**
     *
     *
     * <pre>
     * List of label sets used for VM exclusion.
     *
     * If the list has more than one label set, the VM is excluded if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
     * </code>
     */
    @java.lang.Override
    public int getExclusionLabelsCount() {
      return exclusionLabels_.size();
    }
    /**
     *
     *
     * <pre>
     * List of label sets used for VM exclusion.
     *
     * If the list has more than one label set, the VM is excluded if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet getExclusionLabels(
        int index) {
      return exclusionLabels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of label sets used for VM exclusion.
     *
     * If the list has more than one label set, the VM is excluded if any
     * of the label sets are applicable for the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder
        getExclusionLabelsOrBuilder(int index) {
      return exclusionLabels_.get(index);
    }

    public static final int INVENTORIES_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory>
        inventories_;
    /**
     *
     *
     * <pre>
     * List of inventories to select VMs.
     *
     * A VM is selected if its inventory data matches at least one of the
     * following inventories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory>
        getInventoriesList() {
      return inventories_;
    }
    /**
     *
     *
     * <pre>
     * List of inventories to select VMs.
     *
     * A VM is selected if its inventory data matches at least one of the
     * following inventories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
                    .InventoryOrBuilder>
        getInventoriesOrBuilderList() {
      return inventories_;
    }
    /**
     *
     *
     * <pre>
     * List of inventories to select VMs.
     *
     * A VM is selected if its inventory data matches at least one of the
     * following inventories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
     * </code>
     */
    @java.lang.Override
    public int getInventoriesCount() {
      return inventories_.size();
    }
    /**
     *
     *
     * <pre>
     * List of inventories to select VMs.
     *
     * A VM is selected if its inventory data matches at least one of the
     * following inventories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
        getInventories(int index) {
      return inventories_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of inventories to select VMs.
     *
     * A VM is selected if its inventory data matches at least one of the
     * following inventories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.InventoryOrBuilder
        getInventoriesOrBuilder(int index) {
      return inventories_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (all_ != false) {
        output.writeBool(1, all_);
      }
      for (int i = 0; i < osShortNames_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, osShortNames_.getRaw(i));
      }
      for (int i = 0; i < inclusionLabels_.size(); i++) {
        output.writeMessage(3, inclusionLabels_.get(i));
      }
      for (int i = 0; i < exclusionLabels_.size(); i++) {
        output.writeMessage(4, exclusionLabels_.get(i));
      }
      for (int i = 0; i < inventories_.size(); i++) {
        output.writeMessage(5, inventories_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (all_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, all_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < osShortNames_.size(); i++) {
          dataSize += computeStringSizeNoTag(osShortNames_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getOsShortNamesList().size();
      }
      for (int i = 0; i < inclusionLabels_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, inclusionLabels_.get(i));
      }
      for (int i = 0; i < exclusionLabels_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(4, exclusionLabels_.get(i));
      }
      for (int i = 0; i < inventories_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, inventories_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter other =
          (com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter) obj;

      if (getAll() != other.getAll()) return false;
      if (!getOsShortNamesList().equals(other.getOsShortNamesList())) return false;
      if (!getInclusionLabelsList().equals(other.getInclusionLabelsList())) return false;
      if (!getExclusionLabelsList().equals(other.getExclusionLabelsList())) return false;
      if (!getInventoriesList().equals(other.getInventoriesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ALL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAll());
      if (getOsShortNamesCount() > 0) {
        hash = (37 * hash) + OS_SHORT_NAMES_FIELD_NUMBER;
        hash = (53 * hash) + getOsShortNamesList().hashCode();
      }
      if (getInclusionLabelsCount() > 0) {
        hash = (37 * hash) + INCLUSION_LABELS_FIELD_NUMBER;
        hash = (53 * hash) + getInclusionLabelsList().hashCode();
      }
      if (getExclusionLabelsCount() > 0) {
        hash = (37 * hash) + EXCLUSION_LABELS_FIELD_NUMBER;
        hash = (53 * hash) + getExclusionLabelsList().hashCode();
      }
      if (getInventoriesCount() > 0) {
        hash = (37 * hash) + INVENTORIES_FIELD_NUMBER;
        hash = (53 * hash) + getInventoriesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Filters to select target VMs for an assignment.
     *
     * If more than one filter criteria is specified below, a VM will be selected
     * if and only if it satisfies all of them.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter)
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_InstanceFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_InstanceFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.class,
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Builder.class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        all_ = false;
        osShortNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
        if (inclusionLabelsBuilder_ == null) {
          inclusionLabels_ = java.util.Collections.emptyList();
        } else {
          inclusionLabels_ = null;
          inclusionLabelsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (exclusionLabelsBuilder_ == null) {
          exclusionLabels_ = java.util.Collections.emptyList();
        } else {
          exclusionLabels_ = null;
          exclusionLabelsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        if (inventoriesBuilder_ == null) {
          inventories_ = java.util.Collections.emptyList();
        } else {
          inventories_ = null;
          inventoriesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_InstanceFilter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter build() {
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter buildPartial() {
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter result =
            new com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter result) {
        if (inclusionLabelsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            inclusionLabels_ = java.util.Collections.unmodifiableList(inclusionLabels_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.inclusionLabels_ = inclusionLabels_;
        } else {
          result.inclusionLabels_ = inclusionLabelsBuilder_.build();
        }
        if (exclusionLabelsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            exclusionLabels_ = java.util.Collections.unmodifiableList(exclusionLabels_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.exclusionLabels_ = exclusionLabels_;
        } else {
          result.exclusionLabels_ = exclusionLabelsBuilder_.build();
        }
        if (inventoriesBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            inventories_ = java.util.Collections.unmodifiableList(inventories_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.inventories_ = inventories_;
        } else {
          result.inventories_ = inventoriesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.all_ = all_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          osShortNames_.makeImmutable();
          result.osShortNames_ = osShortNames_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter other) {
        if (other
            == com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
                .getDefaultInstance()) return this;
        if (other.getAll() != false) {
          setAll(other.getAll());
        }
        if (!other.osShortNames_.isEmpty()) {
          if (osShortNames_.isEmpty()) {
            osShortNames_ = other.osShortNames_;
            bitField0_ |= 0x00000002;
          } else {
            ensureOsShortNamesIsMutable();
            osShortNames_.addAll(other.osShortNames_);
          }
          onChanged();
        }
        if (inclusionLabelsBuilder_ == null) {
          if (!other.inclusionLabels_.isEmpty()) {
            if (inclusionLabels_.isEmpty()) {
              inclusionLabels_ = other.inclusionLabels_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureInclusionLabelsIsMutable();
              inclusionLabels_.addAll(other.inclusionLabels_);
            }
            onChanged();
          }
        } else {
          if (!other.inclusionLabels_.isEmpty()) {
            if (inclusionLabelsBuilder_.isEmpty()) {
              inclusionLabelsBuilder_.dispose();
              inclusionLabelsBuilder_ = null;
              inclusionLabels_ = other.inclusionLabels_;
              bitField0_ = (bitField0_ & ~0x00000004);
              inclusionLabelsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getInclusionLabelsFieldBuilder()
                      : null;
            } else {
              inclusionLabelsBuilder_.addAllMessages(other.inclusionLabels_);
            }
          }
        }
        if (exclusionLabelsBuilder_ == null) {
          if (!other.exclusionLabels_.isEmpty()) {
            if (exclusionLabels_.isEmpty()) {
              exclusionLabels_ = other.exclusionLabels_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureExclusionLabelsIsMutable();
              exclusionLabels_.addAll(other.exclusionLabels_);
            }
            onChanged();
          }
        } else {
          if (!other.exclusionLabels_.isEmpty()) {
            if (exclusionLabelsBuilder_.isEmpty()) {
              exclusionLabelsBuilder_.dispose();
              exclusionLabelsBuilder_ = null;
              exclusionLabels_ = other.exclusionLabels_;
              bitField0_ = (bitField0_ & ~0x00000008);
              exclusionLabelsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getExclusionLabelsFieldBuilder()
                      : null;
            } else {
              exclusionLabelsBuilder_.addAllMessages(other.exclusionLabels_);
            }
          }
        }
        if (inventoriesBuilder_ == null) {
          if (!other.inventories_.isEmpty()) {
            if (inventories_.isEmpty()) {
              inventories_ = other.inventories_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureInventoriesIsMutable();
              inventories_.addAll(other.inventories_);
            }
            onChanged();
          }
        } else {
          if (!other.inventories_.isEmpty()) {
            if (inventoriesBuilder_.isEmpty()) {
              inventoriesBuilder_.dispose();
              inventoriesBuilder_ = null;
              inventories_ = other.inventories_;
              bitField0_ = (bitField0_ & ~0x00000010);
              inventoriesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getInventoriesFieldBuilder()
                      : null;
            } else {
              inventoriesBuilder_.addAllMessages(other.inventories_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  all_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureOsShortNamesIsMutable();
                  osShortNames_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet m =
                      input.readMessage(
                          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.parser(),
                          extensionRegistry);
                  if (inclusionLabelsBuilder_ == null) {
                    ensureInclusionLabelsIsMutable();
                    inclusionLabels_.add(m);
                  } else {
                    inclusionLabelsBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              case 34:
                {
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet m =
                      input.readMessage(
                          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.parser(),
                          extensionRegistry);
                  if (exclusionLabelsBuilder_ == null) {
                    ensureExclusionLabelsIsMutable();
                    exclusionLabels_.add(m);
                  } else {
                    exclusionLabelsBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              case 42:
                {
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory m =
                      input.readMessage(
                          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
                              .Inventory.parser(),
                          extensionRegistry);
                  if (inventoriesBuilder_ == null) {
                    ensureInventoriesIsMutable();
                    inventories_.add(m);
                  } else {
                    inventoriesBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean all_;
      /**
       *
       *
       * <pre>
       * Target all VMs in the project. If true, no other criteria is
       * permitted.
       * </pre>
       *
       * <code>bool all = 1;</code>
       *
       * @return The all.
       */
      @java.lang.Override
      public boolean getAll() {
        return all_;
      }
      /**
       *
       *
       * <pre>
       * Target all VMs in the project. If true, no other criteria is
       * permitted.
       * </pre>
       *
       * <code>bool all = 1;</code>
       *
       * @param value The all to set.
       * @return This builder for chaining.
       */
      public Builder setAll(boolean value) {

        all_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Target all VMs in the project. If true, no other criteria is
       * permitted.
       * </pre>
       *
       * <code>bool all = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAll() {
        bitField0_ = (bitField0_ & ~0x00000001);
        all_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList osShortNames_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureOsShortNamesIsMutable() {
        if (!osShortNames_.isModifiable()) {
          osShortNames_ = new com.google.protobuf.LazyStringArrayList(osShortNames_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use the `inventories` field instead.
       * A VM is selected if it's OS short name matches with any of the
       * values provided in this list.
       * </pre>
       *
       * <code>repeated string os_short_names = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names
       *     is deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
       * @return A list containing the osShortNames.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ProtocolStringList getOsShortNamesList() {
        osShortNames_.makeImmutable();
        return osShortNames_;
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use the `inventories` field instead.
       * A VM is selected if it's OS short name matches with any of the
       * values provided in this list.
       * </pre>
       *
       * <code>repeated string os_short_names = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names
       *     is deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
       * @return The count of osShortNames.
       */
      @java.lang.Deprecated
      public int getOsShortNamesCount() {
        return osShortNames_.size();
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use the `inventories` field instead.
       * A VM is selected if it's OS short name matches with any of the
       * values provided in this list.
       * </pre>
       *
       * <code>repeated string os_short_names = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names
       *     is deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
       * @param index The index of the element to return.
       * @return The osShortNames at the given index.
       */
      @java.lang.Deprecated
      public java.lang.String getOsShortNames(int index) {
        return osShortNames_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use the `inventories` field instead.
       * A VM is selected if it's OS short name matches with any of the
       * values provided in this list.
       * </pre>
       *
       * <code>repeated string os_short_names = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names
       *     is deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
       * @param index The index of the value to return.
       * @return The bytes of the osShortNames at the given index.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getOsShortNamesBytes(int index) {
        return osShortNames_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use the `inventories` field instead.
       * A VM is selected if it's OS short name matches with any of the
       * values provided in this list.
       * </pre>
       *
       * <code>repeated string os_short_names = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names
       *     is deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
       * @param index The index to set the value at.
       * @param value The osShortNames to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setOsShortNames(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOsShortNamesIsMutable();
        osShortNames_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use the `inventories` field instead.
       * A VM is selected if it's OS short name matches with any of the
       * values provided in this list.
       * </pre>
       *
       * <code>repeated string os_short_names = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names
       *     is deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
       * @param value The osShortNames to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder addOsShortNames(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOsShortNamesIsMutable();
        osShortNames_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use the `inventories` field instead.
       * A VM is selected if it's OS short name matches with any of the
       * values provided in this list.
       * </pre>
       *
       * <code>repeated string os_short_names = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names
       *     is deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
       * @param values The osShortNames to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder addAllOsShortNames(java.lang.Iterable<java.lang.String> values) {
        ensureOsShortNamesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, osShortNames_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use the `inventories` field instead.
       * A VM is selected if it's OS short name matches with any of the
       * values provided in this list.
       * </pre>
       *
       * <code>repeated string os_short_names = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names
       *     is deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearOsShortNames() {
        osShortNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated. Use the `inventories` field instead.
       * A VM is selected if it's OS short name matches with any of the
       * values provided in this list.
       * </pre>
       *
       * <code>repeated string os_short_names = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.os_short_names
       *     is deprecated. See google/cloud/osconfig/v1alpha/os_policy_assignments.proto;l=94
       * @param value The bytes of the osShortNames to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder addOsShortNamesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureOsShortNamesIsMutable();
        osShortNames_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>
          inclusionLabels_ = java.util.Collections.emptyList();

      private void ensureInclusionLabelsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          inclusionLabels_ =
              new java.util.ArrayList<
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>(inclusionLabels_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder>
          inclusionLabelsBuilder_;

      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>
          getInclusionLabelsList() {
        if (inclusionLabelsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(inclusionLabels_);
        } else {
          return inclusionLabelsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public int getInclusionLabelsCount() {
        if (inclusionLabelsBuilder_ == null) {
          return inclusionLabels_.size();
        } else {
          return inclusionLabelsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet getInclusionLabels(
          int index) {
        if (inclusionLabelsBuilder_ == null) {
          return inclusionLabels_.get(index);
        } else {
          return inclusionLabelsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public Builder setInclusionLabels(
          int index, com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet value) {
        if (inclusionLabelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInclusionLabelsIsMutable();
          inclusionLabels_.set(index, value);
          onChanged();
        } else {
          inclusionLabelsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public Builder setInclusionLabels(
          int index,
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder builderForValue) {
        if (inclusionLabelsBuilder_ == null) {
          ensureInclusionLabelsIsMutable();
          inclusionLabels_.set(index, builderForValue.build());
          onChanged();
        } else {
          inclusionLabelsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public Builder addInclusionLabels(
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet value) {
        if (inclusionLabelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInclusionLabelsIsMutable();
          inclusionLabels_.add(value);
          onChanged();
        } else {
          inclusionLabelsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public Builder addInclusionLabels(
          int index, com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet value) {
        if (inclusionLabelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInclusionLabelsIsMutable();
          inclusionLabels_.add(index, value);
          onChanged();
        } else {
          inclusionLabelsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public Builder addInclusionLabels(
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder builderForValue) {
        if (inclusionLabelsBuilder_ == null) {
          ensureInclusionLabelsIsMutable();
          inclusionLabels_.add(builderForValue.build());
          onChanged();
        } else {
          inclusionLabelsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public Builder addInclusionLabels(
          int index,
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder builderForValue) {
        if (inclusionLabelsBuilder_ == null) {
          ensureInclusionLabelsIsMutable();
          inclusionLabels_.add(index, builderForValue.build());
          onChanged();
        } else {
          inclusionLabelsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public Builder addAllInclusionLabels(
          java.lang.Iterable<
                  ? extends com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>
              values) {
        if (inclusionLabelsBuilder_ == null) {
          ensureInclusionLabelsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inclusionLabels_);
          onChanged();
        } else {
          inclusionLabelsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public Builder clearInclusionLabels() {
        if (inclusionLabelsBuilder_ == null) {
          inclusionLabels_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          inclusionLabelsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public Builder removeInclusionLabels(int index) {
        if (inclusionLabelsBuilder_ == null) {
          ensureInclusionLabelsIsMutable();
          inclusionLabels_.remove(index);
          onChanged();
        } else {
          inclusionLabelsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder
          getInclusionLabelsBuilder(int index) {
        return getInclusionLabelsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder
          getInclusionLabelsOrBuilder(int index) {
        if (inclusionLabelsBuilder_ == null) {
          return inclusionLabels_.get(index);
        } else {
          return inclusionLabelsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder>
          getInclusionLabelsOrBuilderList() {
        if (inclusionLabelsBuilder_ != null) {
          return inclusionLabelsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(inclusionLabels_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder
          addInclusionLabelsBuilder() {
        return getInclusionLabelsFieldBuilder()
            .addBuilder(
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder
          addInclusionLabelsBuilder(int index) {
        return getInclusionLabelsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM inclusion.
       *
       * If the list has more than one `LabelSet`, the VM is included if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet inclusion_labels = 3;
       * </code>
       */
      public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder>
          getInclusionLabelsBuilderList() {
        return getInclusionLabelsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder>
          getInclusionLabelsFieldBuilder() {
        if (inclusionLabelsBuilder_ == null) {
          inclusionLabelsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet,
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder,
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder>(
                  inclusionLabels_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          inclusionLabels_ = null;
        }
        return inclusionLabelsBuilder_;
      }

      private java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>
          exclusionLabels_ = java.util.Collections.emptyList();

      private void ensureExclusionLabelsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          exclusionLabels_ =
              new java.util.ArrayList<
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>(exclusionLabels_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder>
          exclusionLabelsBuilder_;

      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>
          getExclusionLabelsList() {
        if (exclusionLabelsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(exclusionLabels_);
        } else {
          return exclusionLabelsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public int getExclusionLabelsCount() {
        if (exclusionLabelsBuilder_ == null) {
          return exclusionLabels_.size();
        } else {
          return exclusionLabelsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet getExclusionLabels(
          int index) {
        if (exclusionLabelsBuilder_ == null) {
          return exclusionLabels_.get(index);
        } else {
          return exclusionLabelsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public Builder setExclusionLabels(
          int index, com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet value) {
        if (exclusionLabelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExclusionLabelsIsMutable();
          exclusionLabels_.set(index, value);
          onChanged();
        } else {
          exclusionLabelsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public Builder setExclusionLabels(
          int index,
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder builderForValue) {
        if (exclusionLabelsBuilder_ == null) {
          ensureExclusionLabelsIsMutable();
          exclusionLabels_.set(index, builderForValue.build());
          onChanged();
        } else {
          exclusionLabelsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public Builder addExclusionLabels(
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet value) {
        if (exclusionLabelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExclusionLabelsIsMutable();
          exclusionLabels_.add(value);
          onChanged();
        } else {
          exclusionLabelsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public Builder addExclusionLabels(
          int index, com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet value) {
        if (exclusionLabelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExclusionLabelsIsMutable();
          exclusionLabels_.add(index, value);
          onChanged();
        } else {
          exclusionLabelsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public Builder addExclusionLabels(
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder builderForValue) {
        if (exclusionLabelsBuilder_ == null) {
          ensureExclusionLabelsIsMutable();
          exclusionLabels_.add(builderForValue.build());
          onChanged();
        } else {
          exclusionLabelsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public Builder addExclusionLabels(
          int index,
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder builderForValue) {
        if (exclusionLabelsBuilder_ == null) {
          ensureExclusionLabelsIsMutable();
          exclusionLabels_.add(index, builderForValue.build());
          onChanged();
        } else {
          exclusionLabelsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public Builder addAllExclusionLabels(
          java.lang.Iterable<
                  ? extends com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet>
              values) {
        if (exclusionLabelsBuilder_ == null) {
          ensureExclusionLabelsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exclusionLabels_);
          onChanged();
        } else {
          exclusionLabelsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public Builder clearExclusionLabels() {
        if (exclusionLabelsBuilder_ == null) {
          exclusionLabels_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          exclusionLabelsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public Builder removeExclusionLabels(int index) {
        if (exclusionLabelsBuilder_ == null) {
          ensureExclusionLabelsIsMutable();
          exclusionLabels_.remove(index);
          onChanged();
        } else {
          exclusionLabelsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder
          getExclusionLabelsBuilder(int index) {
        return getExclusionLabelsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder
          getExclusionLabelsOrBuilder(int index) {
        if (exclusionLabelsBuilder_ == null) {
          return exclusionLabels_.get(index);
        } else {
          return exclusionLabelsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder>
          getExclusionLabelsOrBuilderList() {
        if (exclusionLabelsBuilder_ != null) {
          return exclusionLabelsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(exclusionLabels_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder
          addExclusionLabelsBuilder() {
        return getExclusionLabelsFieldBuilder()
            .addBuilder(
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder
          addExclusionLabelsBuilder(int index) {
        return getExclusionLabelsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of label sets used for VM exclusion.
       *
       * If the list has more than one label set, the VM is excluded if any
       * of the label sets are applicable for the VM.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet exclusion_labels = 4;
       * </code>
       */
      public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder>
          getExclusionLabelsBuilderList() {
        return getExclusionLabelsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder>
          getExclusionLabelsFieldBuilder() {
        if (exclusionLabelsBuilder_ == null) {
          exclusionLabelsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet,
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSet.Builder,
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.LabelSetOrBuilder>(
                  exclusionLabels_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          exclusionLabels_ = null;
        }
        return exclusionLabelsBuilder_;
      }

      private java.util.List<
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory>
          inventories_ = java.util.Collections.emptyList();

      private void ensureInventoriesIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          inventories_ =
              new java.util.ArrayList<
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory>(
                  inventories_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory.Builder,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
                  .InventoryOrBuilder>
          inventoriesBuilder_;

      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public java.util.List<
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory>
          getInventoriesList() {
        if (inventoriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(inventories_);
        } else {
          return inventoriesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public int getInventoriesCount() {
        if (inventoriesBuilder_ == null) {
          return inventories_.size();
        } else {
          return inventoriesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
          getInventories(int index) {
        if (inventoriesBuilder_ == null) {
          return inventories_.get(index);
        } else {
          return inventoriesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public Builder setInventories(
          int index,
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory value) {
        if (inventoriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInventoriesIsMutable();
          inventories_.set(index, value);
          onChanged();
        } else {
          inventoriesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public Builder setInventories(
          int index,
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory.Builder
              builderForValue) {
        if (inventoriesBuilder_ == null) {
          ensureInventoriesIsMutable();
          inventories_.set(index, builderForValue.build());
          onChanged();
        } else {
          inventoriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public Builder addInventories(
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory value) {
        if (inventoriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInventoriesIsMutable();
          inventories_.add(value);
          onChanged();
        } else {
          inventoriesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public Builder addInventories(
          int index,
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory value) {
        if (inventoriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInventoriesIsMutable();
          inventories_.add(index, value);
          onChanged();
        } else {
          inventoriesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public Builder addInventories(
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory.Builder
              builderForValue) {
        if (inventoriesBuilder_ == null) {
          ensureInventoriesIsMutable();
          inventories_.add(builderForValue.build());
          onChanged();
        } else {
          inventoriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public Builder addInventories(
          int index,
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory.Builder
              builderForValue) {
        if (inventoriesBuilder_ == null) {
          ensureInventoriesIsMutable();
          inventories_.add(index, builderForValue.build());
          onChanged();
        } else {
          inventoriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public Builder addAllInventories(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory>
              values) {
        if (inventoriesBuilder_ == null) {
          ensureInventoriesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inventories_);
          onChanged();
        } else {
          inventoriesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public Builder clearInventories() {
        if (inventoriesBuilder_ == null) {
          inventories_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          inventoriesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public Builder removeInventories(int index) {
        if (inventoriesBuilder_ == null) {
          ensureInventoriesIsMutable();
          inventories_.remove(index);
          onChanged();
        } else {
          inventoriesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory.Builder
          getInventoriesBuilder(int index) {
        return getInventoriesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.InventoryOrBuilder
          getInventoriesOrBuilder(int index) {
        if (inventoriesBuilder_ == null) {
          return inventories_.get(index);
        } else {
          return inventoriesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
                      .InventoryOrBuilder>
          getInventoriesOrBuilderList() {
        if (inventoriesBuilder_ != null) {
          return inventoriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(inventories_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory.Builder
          addInventoriesBuilder() {
        return getInventoriesFieldBuilder()
            .addBuilder(
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory.Builder
          addInventoriesBuilder(int index) {
        return getInventoriesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of inventories to select VMs.
       *
       * A VM is selected if its inventory data matches at least one of the
       * following inventories.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory inventories = 5;
       * </code>
       */
      public java.util.List<
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory.Builder>
          getInventoriesBuilderList() {
        return getInventoriesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory.Builder,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
                  .InventoryOrBuilder>
          getInventoriesFieldBuilder() {
        if (inventoriesBuilder_ == null) {
          inventoriesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory,
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Inventory
                      .Builder,
                  com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
                      .InventoryOrBuilder>(
                  inventories_,
                  ((bitField0_ & 0x00000010) != 0),
                  getParentForChildren(),
                  isClean());
          inventories_ = null;
        }
        return inventoriesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter)
    private static final com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter();
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InstanceFilter> PARSER =
        new com.google.protobuf.AbstractParser<InstanceFilter>() {
          @java.lang.Override
          public InstanceFilter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InstanceFilter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InstanceFilter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RolloutOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The maximum number (or percentage) of VMs per zone to disrupt at
     * any given moment.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the disruptionBudget field is set.
     */
    boolean hasDisruptionBudget();
    /**
     *
     *
     * <pre>
     * Required. The maximum number (or percentage) of VMs per zone to disrupt at
     * any given moment.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The disruptionBudget.
     */
    com.google.cloud.osconfig.v1alpha.FixedOrPercent getDisruptionBudget();
    /**
     *
     *
     * <pre>
     * Required. The maximum number (or percentage) of VMs per zone to disrupt at
     * any given moment.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.FixedOrPercentOrBuilder getDisruptionBudgetOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. This determines the minimum duration of time to wait after the
     * configuration changes are applied through the current rollout. A
     * VM continues to count towards the `disruption_budget` at least
     * until this duration of time has passed after configuration changes are
     * applied.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the minWaitDuration field is set.
     */
    boolean hasMinWaitDuration();
    /**
     *
     *
     * <pre>
     * Required. This determines the minimum duration of time to wait after the
     * configuration changes are applied through the current rollout. A
     * VM continues to count towards the `disruption_budget` at least
     * until this duration of time has passed after configuration changes are
     * applied.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The minWaitDuration.
     */
    com.google.protobuf.Duration getMinWaitDuration();
    /**
     *
     *
     * <pre>
     * Required. This determines the minimum duration of time to wait after the
     * configuration changes are applied through the current rollout. A
     * VM continues to count towards the `disruption_budget` at least
     * until this duration of time has passed after configuration changes are
     * applied.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.protobuf.DurationOrBuilder getMinWaitDurationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Message to configure the rollout at the zonal level for the OS policy
   * assignment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout}
   */
  public static final class Rollout extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout)
      RolloutOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Rollout.newBuilder() to construct.
    private Rollout(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Rollout() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Rollout();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_Rollout_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_Rollout_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.class,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.Builder.class);
    }

    public static final int DISRUPTION_BUDGET_FIELD_NUMBER = 1;
    private com.google.cloud.osconfig.v1alpha.FixedOrPercent disruptionBudget_;
    /**
     *
     *
     * <pre>
     * Required. The maximum number (or percentage) of VMs per zone to disrupt at
     * any given moment.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the disruptionBudget field is set.
     */
    @java.lang.Override
    public boolean hasDisruptionBudget() {
      return disruptionBudget_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The maximum number (or percentage) of VMs per zone to disrupt at
     * any given moment.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The disruptionBudget.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.FixedOrPercent getDisruptionBudget() {
      return disruptionBudget_ == null
          ? com.google.cloud.osconfig.v1alpha.FixedOrPercent.getDefaultInstance()
          : disruptionBudget_;
    }
    /**
     *
     *
     * <pre>
     * Required. The maximum number (or percentage) of VMs per zone to disrupt at
     * any given moment.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.FixedOrPercentOrBuilder
        getDisruptionBudgetOrBuilder() {
      return disruptionBudget_ == null
          ? com.google.cloud.osconfig.v1alpha.FixedOrPercent.getDefaultInstance()
          : disruptionBudget_;
    }

    public static final int MIN_WAIT_DURATION_FIELD_NUMBER = 2;
    private com.google.protobuf.Duration minWaitDuration_;
    /**
     *
     *
     * <pre>
     * Required. This determines the minimum duration of time to wait after the
     * configuration changes are applied through the current rollout. A
     * VM continues to count towards the `disruption_budget` at least
     * until this duration of time has passed after configuration changes are
     * applied.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the minWaitDuration field is set.
     */
    @java.lang.Override
    public boolean hasMinWaitDuration() {
      return minWaitDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. This determines the minimum duration of time to wait after the
     * configuration changes are applied through the current rollout. A
     * VM continues to count towards the `disruption_budget` at least
     * until this duration of time has passed after configuration changes are
     * applied.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The minWaitDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getMinWaitDuration() {
      return minWaitDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : minWaitDuration_;
    }
    /**
     *
     *
     * <pre>
     * Required. This determines the minimum duration of time to wait after the
     * configuration changes are applied through the current rollout. A
     * VM continues to count towards the `disruption_budget` at least
     * until this duration of time has passed after configuration changes are
     * applied.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getMinWaitDurationOrBuilder() {
      return minWaitDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : minWaitDuration_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (disruptionBudget_ != null) {
        output.writeMessage(1, getDisruptionBudget());
      }
      if (minWaitDuration_ != null) {
        output.writeMessage(2, getMinWaitDuration());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (disruptionBudget_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDisruptionBudget());
      }
      if (minWaitDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMinWaitDuration());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout other =
          (com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout) obj;

      if (hasDisruptionBudget() != other.hasDisruptionBudget()) return false;
      if (hasDisruptionBudget()) {
        if (!getDisruptionBudget().equals(other.getDisruptionBudget())) return false;
      }
      if (hasMinWaitDuration() != other.hasMinWaitDuration()) return false;
      if (hasMinWaitDuration()) {
        if (!getMinWaitDuration().equals(other.getMinWaitDuration())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDisruptionBudget()) {
        hash = (37 * hash) + DISRUPTION_BUDGET_FIELD_NUMBER;
        hash = (53 * hash) + getDisruptionBudget().hashCode();
      }
      if (hasMinWaitDuration()) {
        hash = (37 * hash) + MIN_WAIT_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getMinWaitDuration().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message to configure the rollout at the zonal level for the OS policy
     * assignment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout)
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_Rollout_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_Rollout_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.class,
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.Builder.class);
      }

      // Construct using com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        disruptionBudget_ = null;
        if (disruptionBudgetBuilder_ != null) {
          disruptionBudgetBuilder_.dispose();
          disruptionBudgetBuilder_ = null;
        }
        minWaitDuration_ = null;
        if (minWaitDurationBuilder_ != null) {
          minWaitDurationBuilder_.dispose();
          minWaitDurationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_Rollout_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout build() {
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout buildPartial() {
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout result =
            new com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.disruptionBudget_ =
              disruptionBudgetBuilder_ == null
                  ? disruptionBudget_
                  : disruptionBudgetBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.minWaitDuration_ =
              minWaitDurationBuilder_ == null ? minWaitDuration_ : minWaitDurationBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout) {
          return mergeFrom((com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout other) {
        if (other
            == com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.getDefaultInstance())
          return this;
        if (other.hasDisruptionBudget()) {
          mergeDisruptionBudget(other.getDisruptionBudget());
        }
        if (other.hasMinWaitDuration()) {
          mergeMinWaitDuration(other.getMinWaitDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getDisruptionBudgetFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getMinWaitDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.osconfig.v1alpha.FixedOrPercent disruptionBudget_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.FixedOrPercent,
              com.google.cloud.osconfig.v1alpha.FixedOrPercent.Builder,
              com.google.cloud.osconfig.v1alpha.FixedOrPercentOrBuilder>
          disruptionBudgetBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The maximum number (or percentage) of VMs per zone to disrupt at
       * any given moment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the disruptionBudget field is set.
       */
      public boolean hasDisruptionBudget() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The maximum number (or percentage) of VMs per zone to disrupt at
       * any given moment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The disruptionBudget.
       */
      public com.google.cloud.osconfig.v1alpha.FixedOrPercent getDisruptionBudget() {
        if (disruptionBudgetBuilder_ == null) {
          return disruptionBudget_ == null
              ? com.google.cloud.osconfig.v1alpha.FixedOrPercent.getDefaultInstance()
              : disruptionBudget_;
        } else {
          return disruptionBudgetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The maximum number (or percentage) of VMs per zone to disrupt at
       * any given moment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDisruptionBudget(com.google.cloud.osconfig.v1alpha.FixedOrPercent value) {
        if (disruptionBudgetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          disruptionBudget_ = value;
        } else {
          disruptionBudgetBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The maximum number (or percentage) of VMs per zone to disrupt at
       * any given moment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDisruptionBudget(
          com.google.cloud.osconfig.v1alpha.FixedOrPercent.Builder builderForValue) {
        if (disruptionBudgetBuilder_ == null) {
          disruptionBudget_ = builderForValue.build();
        } else {
          disruptionBudgetBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The maximum number (or percentage) of VMs per zone to disrupt at
       * any given moment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeDisruptionBudget(com.google.cloud.osconfig.v1alpha.FixedOrPercent value) {
        if (disruptionBudgetBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && disruptionBudget_ != null
              && disruptionBudget_
                  != com.google.cloud.osconfig.v1alpha.FixedOrPercent.getDefaultInstance()) {
            getDisruptionBudgetBuilder().mergeFrom(value);
          } else {
            disruptionBudget_ = value;
          }
        } else {
          disruptionBudgetBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The maximum number (or percentage) of VMs per zone to disrupt at
       * any given moment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearDisruptionBudget() {
        bitField0_ = (bitField0_ & ~0x00000001);
        disruptionBudget_ = null;
        if (disruptionBudgetBuilder_ != null) {
          disruptionBudgetBuilder_.dispose();
          disruptionBudgetBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The maximum number (or percentage) of VMs per zone to disrupt at
       * any given moment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.FixedOrPercent.Builder getDisruptionBudgetBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getDisruptionBudgetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The maximum number (or percentage) of VMs per zone to disrupt at
       * any given moment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.FixedOrPercentOrBuilder
          getDisruptionBudgetOrBuilder() {
        if (disruptionBudgetBuilder_ != null) {
          return disruptionBudgetBuilder_.getMessageOrBuilder();
        } else {
          return disruptionBudget_ == null
              ? com.google.cloud.osconfig.v1alpha.FixedOrPercent.getDefaultInstance()
              : disruptionBudget_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The maximum number (or percentage) of VMs per zone to disrupt at
       * any given moment.
       * </pre>
       *
       * <code>
       * .google.cloud.osconfig.v1alpha.FixedOrPercent disruption_budget = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.FixedOrPercent,
              com.google.cloud.osconfig.v1alpha.FixedOrPercent.Builder,
              com.google.cloud.osconfig.v1alpha.FixedOrPercentOrBuilder>
          getDisruptionBudgetFieldBuilder() {
        if (disruptionBudgetBuilder_ == null) {
          disruptionBudgetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.FixedOrPercent,
                  com.google.cloud.osconfig.v1alpha.FixedOrPercent.Builder,
                  com.google.cloud.osconfig.v1alpha.FixedOrPercentOrBuilder>(
                  getDisruptionBudget(), getParentForChildren(), isClean());
          disruptionBudget_ = null;
        }
        return disruptionBudgetBuilder_;
      }

      private com.google.protobuf.Duration minWaitDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          minWaitDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Required. This determines the minimum duration of time to wait after the
       * configuration changes are applied through the current rollout. A
       * VM continues to count towards the `disruption_budget` at least
       * until this duration of time has passed after configuration changes are
       * applied.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the minWaitDuration field is set.
       */
      public boolean hasMinWaitDuration() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. This determines the minimum duration of time to wait after the
       * configuration changes are applied through the current rollout. A
       * VM continues to count towards the `disruption_budget` at least
       * until this duration of time has passed after configuration changes are
       * applied.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The minWaitDuration.
       */
      public com.google.protobuf.Duration getMinWaitDuration() {
        if (minWaitDurationBuilder_ == null) {
          return minWaitDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : minWaitDuration_;
        } else {
          return minWaitDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. This determines the minimum duration of time to wait after the
       * configuration changes are applied through the current rollout. A
       * VM continues to count towards the `disruption_budget` at least
       * until this duration of time has passed after configuration changes are
       * applied.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMinWaitDuration(com.google.protobuf.Duration value) {
        if (minWaitDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          minWaitDuration_ = value;
        } else {
          minWaitDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. This determines the minimum duration of time to wait after the
       * configuration changes are applied through the current rollout. A
       * VM continues to count towards the `disruption_budget` at least
       * until this duration of time has passed after configuration changes are
       * applied.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMinWaitDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (minWaitDurationBuilder_ == null) {
          minWaitDuration_ = builderForValue.build();
        } else {
          minWaitDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. This determines the minimum duration of time to wait after the
       * configuration changes are applied through the current rollout. A
       * VM continues to count towards the `disruption_budget` at least
       * until this duration of time has passed after configuration changes are
       * applied.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeMinWaitDuration(com.google.protobuf.Duration value) {
        if (minWaitDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && minWaitDuration_ != null
              && minWaitDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getMinWaitDurationBuilder().mergeFrom(value);
          } else {
            minWaitDuration_ = value;
          }
        } else {
          minWaitDurationBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. This determines the minimum duration of time to wait after the
       * configuration changes are applied through the current rollout. A
       * VM continues to count towards the `disruption_budget` at least
       * until this duration of time has passed after configuration changes are
       * applied.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearMinWaitDuration() {
        bitField0_ = (bitField0_ & ~0x00000002);
        minWaitDuration_ = null;
        if (minWaitDurationBuilder_ != null) {
          minWaitDurationBuilder_.dispose();
          minWaitDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. This determines the minimum duration of time to wait after the
       * configuration changes are applied through the current rollout. A
       * VM continues to count towards the `disruption_budget` at least
       * until this duration of time has passed after configuration changes are
       * applied.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.Duration.Builder getMinWaitDurationBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getMinWaitDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. This determines the minimum duration of time to wait after the
       * configuration changes are applied through the current rollout. A
       * VM continues to count towards the `disruption_budget` at least
       * until this duration of time has passed after configuration changes are
       * applied.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.DurationOrBuilder getMinWaitDurationOrBuilder() {
        if (minWaitDurationBuilder_ != null) {
          return minWaitDurationBuilder_.getMessageOrBuilder();
        } else {
          return minWaitDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : minWaitDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. This determines the minimum duration of time to wait after the
       * configuration changes are applied through the current rollout. A
       * VM continues to count towards the `disruption_budget` at least
       * until this duration of time has passed after configuration changes are
       * applied.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration min_wait_duration = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMinWaitDurationFieldBuilder() {
        if (minWaitDurationBuilder_ == null) {
          minWaitDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getMinWaitDuration(), getParentForChildren(), isClean());
          minWaitDuration_ = null;
        }
        return minWaitDurationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout)
    private static final com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout();
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Rollout> PARSER =
        new com.google.protobuf.AbstractParser<Rollout>() {
          @java.lang.Override
          public Rollout parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Rollout> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Rollout> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Resource name.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id}`
   *
   * This field is ignored when you create an OS policy assignment.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id}`
   *
   * This field is ignored when you create an OS policy assignment.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * OS policy assignment description.
   * Length of the description is limited to 1024 characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * OS policy assignment description.
   * Length of the description is limited to 1024 characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OS_POLICIES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicy> osPolicies_;
  /**
   *
   *
   * <pre>
   * Required. List of OS policies to be applied to the VMs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicy> getOsPoliciesList() {
    return osPolicies_;
  }
  /**
   *
   *
   * <pre>
   * Required. List of OS policies to be applied to the VMs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.osconfig.v1alpha.OSPolicyOrBuilder>
      getOsPoliciesOrBuilderList() {
    return osPolicies_;
  }
  /**
   *
   *
   * <pre>
   * Required. List of OS policies to be applied to the VMs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getOsPoliciesCount() {
    return osPolicies_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. List of OS policies to be applied to the VMs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicy getOsPolicies(int index) {
    return osPolicies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. List of OS policies to be applied to the VMs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyOrBuilder getOsPoliciesOrBuilder(int index) {
    return osPolicies_.get(index);
  }

  public static final int INSTANCE_FILTER_FIELD_NUMBER = 4;
  private com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instanceFilter_;
  /**
   *
   *
   * <pre>
   * Required. Filter to select VMs.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the instanceFilter field is set.
   */
  @java.lang.Override
  public boolean hasInstanceFilter() {
    return instanceFilter_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Filter to select VMs.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The instanceFilter.
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter getInstanceFilter() {
    return instanceFilter_ == null
        ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.getDefaultInstance()
        : instanceFilter_;
  }
  /**
   *
   *
   * <pre>
   * Required. Filter to select VMs.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilterOrBuilder
      getInstanceFilterOrBuilder() {
    return instanceFilter_ == null
        ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.getDefaultInstance()
        : instanceFilter_;
  }

  public static final int ROLLOUT_FIELD_NUMBER = 5;
  private com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout_;
  /**
   *
   *
   * <pre>
   * Required. Rollout to deploy the OS policy assignment.
   * A rollout is triggered in the following situations:
   * 1) OSPolicyAssignment is created.
   * 2) OSPolicyAssignment is updated and the update contains changes to one of
   * the following fields:
   *    - instance_filter
   *    - os_policies
   * 3) OSPolicyAssignment is deleted.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the rollout field is set.
   */
  @java.lang.Override
  public boolean hasRollout() {
    return rollout_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Rollout to deploy the OS policy assignment.
   * A rollout is triggered in the following situations:
   * 1) OSPolicyAssignment is created.
   * 2) OSPolicyAssignment is updated and the update contains changes to one of
   * the following fields:
   *    - instance_filter
   *    - os_policies
   * 3) OSPolicyAssignment is deleted.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The rollout.
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout getRollout() {
    return rollout_ == null
        ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.getDefaultInstance()
        : rollout_;
  }
  /**
   *
   *
   * <pre>
   * Required. Rollout to deploy the OS policy assignment.
   * A rollout is triggered in the following situations:
   * 1) OSPolicyAssignment is created.
   * 2) OSPolicyAssignment is updated and the update contains changes to one of
   * the following fields:
   *    - instance_filter
   *    - os_policies
   * 3) OSPolicyAssignment is deleted.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutOrBuilder
      getRolloutOrBuilder() {
    return rollout_ == null
        ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.getDefaultInstance()
        : rollout_;
  }

  public static final int REVISION_ID_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object revisionId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The assignment revision ID
   * A new revision is committed whenever a rollout is triggered for a OS policy
   * assignment
   * </pre>
   *
   * <code>string revision_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The revisionId.
   */
  @java.lang.Override
  public java.lang.String getRevisionId() {
    java.lang.Object ref = revisionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      revisionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The assignment revision ID
   * A new revision is committed whenever a rollout is triggered for a OS policy
   * assignment
   * </pre>
   *
   * <code>string revision_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for revisionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRevisionIdBytes() {
    java.lang.Object ref = revisionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      revisionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REVISION_CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp revisionCreateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the revisionCreateTime field is set.
   */
  @java.lang.Override
  public boolean hasRevisionCreateTime() {
    return revisionCreateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The revisionCreateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRevisionCreateTime() {
    return revisionCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : revisionCreateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRevisionCreateTimeOrBuilder() {
    return revisionCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : revisionCreateTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * The etag for this OS policy assignment.
   * If this is provided on update, it must match the server's etag.
   * </pre>
   *
   * <code>string etag = 8;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The etag for this OS policy assignment.
   * If this is provided on update, it must match the server's etag.
   * </pre>
   *
   * <code>string etag = 8;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLLOUT_STATE_FIELD_NUMBER = 9;
  private int rolloutState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. OS policy assignment rollout state
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState rollout_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for rolloutState.
   */
  @java.lang.Override
  public int getRolloutStateValue() {
    return rolloutState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. OS policy assignment rollout state
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState rollout_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The rolloutState.
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState getRolloutState() {
    com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState result =
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState.forNumber(rolloutState_);
    return result == null
        ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState.UNRECOGNIZED
        : result;
  }

  public static final int BASELINE_FIELD_NUMBER = 10;
  private boolean baseline_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Indicates that this revision has been successfully rolled out in this zone
   * and new VMs will be assigned OS policies from this revision.
   *
   * For a given OS policy assignment, there is only one revision with a value
   * of `true` for this field.
   * </pre>
   *
   * <code>bool baseline = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The baseline.
   */
  @java.lang.Override
  public boolean getBaseline() {
    return baseline_;
  }

  public static final int DELETED_FIELD_NUMBER = 11;
  private boolean deleted_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Indicates that this revision deletes the OS policy assignment.
   * </pre>
   *
   * <code>bool deleted = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The deleted.
   */
  @java.lang.Override
  public boolean getDeleted() {
    return deleted_;
  }

  public static final int RECONCILING_FIELD_NUMBER = 12;
  private boolean reconciling_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Indicates that reconciliation is in progress for the revision.
   * This value is `true` when the `rollout_state` is one of:
   * * IN_PROGRESS
   * * CANCELLING
   * </pre>
   *
   * <code>bool reconciling = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  @java.lang.Override
  public boolean getReconciling() {
    return reconciling_;
  }

  public static final int UID_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Server generated unique id for the OS policy assignment resource.
   * </pre>
   *
   * <code>string uid = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Server generated unique id for the OS policy assignment resource.
   * </pre>
   *
   * <code>string uid = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    for (int i = 0; i < osPolicies_.size(); i++) {
      output.writeMessage(3, osPolicies_.get(i));
    }
    if (instanceFilter_ != null) {
      output.writeMessage(4, getInstanceFilter());
    }
    if (rollout_ != null) {
      output.writeMessage(5, getRollout());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revisionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, revisionId_);
    }
    if (revisionCreateTime_ != null) {
      output.writeMessage(7, getRevisionCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, etag_);
    }
    if (rolloutState_
        != com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState
            .ROLLOUT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, rolloutState_);
    }
    if (baseline_ != false) {
      output.writeBool(10, baseline_);
    }
    if (deleted_ != false) {
      output.writeBool(11, deleted_);
    }
    if (reconciling_ != false) {
      output.writeBool(12, reconciling_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, uid_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    for (int i = 0; i < osPolicies_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, osPolicies_.get(i));
    }
    if (instanceFilter_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getInstanceFilter());
    }
    if (rollout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRollout());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revisionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, revisionId_);
    }
    if (revisionCreateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getRevisionCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, etag_);
    }
    if (rolloutState_
        != com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState
            .ROLLOUT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, rolloutState_);
    }
    if (baseline_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, baseline_);
    }
    if (deleted_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, deleted_);
    }
    if (reconciling_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, reconciling_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, uid_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.osconfig.v1alpha.OSPolicyAssignment)) {
      return super.equals(obj);
    }
    com.google.cloud.osconfig.v1alpha.OSPolicyAssignment other =
        (com.google.cloud.osconfig.v1alpha.OSPolicyAssignment) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getOsPoliciesList().equals(other.getOsPoliciesList())) return false;
    if (hasInstanceFilter() != other.hasInstanceFilter()) return false;
    if (hasInstanceFilter()) {
      if (!getInstanceFilter().equals(other.getInstanceFilter())) return false;
    }
    if (hasRollout() != other.hasRollout()) return false;
    if (hasRollout()) {
      if (!getRollout().equals(other.getRollout())) return false;
    }
    if (!getRevisionId().equals(other.getRevisionId())) return false;
    if (hasRevisionCreateTime() != other.hasRevisionCreateTime()) return false;
    if (hasRevisionCreateTime()) {
      if (!getRevisionCreateTime().equals(other.getRevisionCreateTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (rolloutState_ != other.rolloutState_) return false;
    if (getBaseline() != other.getBaseline()) return false;
    if (getDeleted() != other.getDeleted()) return false;
    if (getReconciling() != other.getReconciling()) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getOsPoliciesCount() > 0) {
      hash = (37 * hash) + OS_POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + getOsPoliciesList().hashCode();
    }
    if (hasInstanceFilter()) {
      hash = (37 * hash) + INSTANCE_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceFilter().hashCode();
    }
    if (hasRollout()) {
      hash = (37 * hash) + ROLLOUT_FIELD_NUMBER;
      hash = (53 * hash) + getRollout().hashCode();
    }
    hash = (37 * hash) + REVISION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRevisionId().hashCode();
    if (hasRevisionCreateTime()) {
      hash = (37 * hash) + REVISION_CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRevisionCreateTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + ROLLOUT_STATE_FIELD_NUMBER;
    hash = (53 * hash) + rolloutState_;
    hash = (37 * hash) + BASELINE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBaseline());
    hash = (37 * hash) + DELETED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDeleted());
    hash = (37 * hash) + RECONCILING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReconciling());
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.osconfig.v1alpha.OSPolicyAssignment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * OS policy assignment is an API resource that is used to
   * apply a set of OS policies to a dynamically targeted group of Compute Engine
   * VM instances.
   *
   * An OS policy is used to define the desired state configuration for a
   * Compute Engine VM instance through a set of configuration resources that
   * provide capabilities such as installing or removing software packages, or
   * executing a script.
   *
   * For more information, see [OS policy and OS policy
   * assignment](https://cloud.google.com/compute/docs/os-configuration-management/working-with-os-policies).
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyAssignment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.OSPolicyAssignment)
      com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.class,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Builder.class);
    }

    // Construct using com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      if (osPoliciesBuilder_ == null) {
        osPolicies_ = java.util.Collections.emptyList();
      } else {
        osPolicies_ = null;
        osPoliciesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      instanceFilter_ = null;
      if (instanceFilterBuilder_ != null) {
        instanceFilterBuilder_.dispose();
        instanceFilterBuilder_ = null;
      }
      rollout_ = null;
      if (rolloutBuilder_ != null) {
        rolloutBuilder_.dispose();
        rolloutBuilder_ = null;
      }
      revisionId_ = "";
      revisionCreateTime_ = null;
      if (revisionCreateTimeBuilder_ != null) {
        revisionCreateTimeBuilder_.dispose();
        revisionCreateTimeBuilder_ = null;
      }
      etag_ = "";
      rolloutState_ = 0;
      baseline_ = false;
      deleted_ = false;
      reconciling_ = false;
      uid_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment getDefaultInstanceForType() {
      return com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment build() {
      com.google.cloud.osconfig.v1alpha.OSPolicyAssignment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment buildPartial() {
      com.google.cloud.osconfig.v1alpha.OSPolicyAssignment result =
          new com.google.cloud.osconfig.v1alpha.OSPolicyAssignment(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment result) {
      if (osPoliciesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          osPolicies_ = java.util.Collections.unmodifiableList(osPolicies_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.osPolicies_ = osPolicies_;
      } else {
        result.osPolicies_ = osPoliciesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.osconfig.v1alpha.OSPolicyAssignment result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.instanceFilter_ =
            instanceFilterBuilder_ == null ? instanceFilter_ : instanceFilterBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.rollout_ = rolloutBuilder_ == null ? rollout_ : rolloutBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.revisionId_ = revisionId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.revisionCreateTime_ =
            revisionCreateTimeBuilder_ == null
                ? revisionCreateTime_
                : revisionCreateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.rolloutState_ = rolloutState_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.baseline_ = baseline_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.deleted_ = deleted_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.reconciling_ = reconciling_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.uid_ = uid_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.osconfig.v1alpha.OSPolicyAssignment) {
        return mergeFrom((com.google.cloud.osconfig.v1alpha.OSPolicyAssignment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.osconfig.v1alpha.OSPolicyAssignment other) {
      if (other == com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (osPoliciesBuilder_ == null) {
        if (!other.osPolicies_.isEmpty()) {
          if (osPolicies_.isEmpty()) {
            osPolicies_ = other.osPolicies_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureOsPoliciesIsMutable();
            osPolicies_.addAll(other.osPolicies_);
          }
          onChanged();
        }
      } else {
        if (!other.osPolicies_.isEmpty()) {
          if (osPoliciesBuilder_.isEmpty()) {
            osPoliciesBuilder_.dispose();
            osPoliciesBuilder_ = null;
            osPolicies_ = other.osPolicies_;
            bitField0_ = (bitField0_ & ~0x00000004);
            osPoliciesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOsPoliciesFieldBuilder()
                    : null;
          } else {
            osPoliciesBuilder_.addAllMessages(other.osPolicies_);
          }
        }
      }
      if (other.hasInstanceFilter()) {
        mergeInstanceFilter(other.getInstanceFilter());
      }
      if (other.hasRollout()) {
        mergeRollout(other.getRollout());
      }
      if (!other.getRevisionId().isEmpty()) {
        revisionId_ = other.revisionId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasRevisionCreateTime()) {
        mergeRevisionCreateTime(other.getRevisionCreateTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.rolloutState_ != 0) {
        setRolloutStateValue(other.getRolloutStateValue());
      }
      if (other.getBaseline() != false) {
        setBaseline(other.getBaseline());
      }
      if (other.getDeleted() != false) {
        setDeleted(other.getDeleted());
      }
      if (other.getReconciling() != false) {
        setReconciling(other.getReconciling());
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.osconfig.v1alpha.OSPolicy m =
                    input.readMessage(
                        com.google.cloud.osconfig.v1alpha.OSPolicy.parser(), extensionRegistry);
                if (osPoliciesBuilder_ == null) {
                  ensureOsPoliciesIsMutable();
                  osPolicies_.add(m);
                } else {
                  osPoliciesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getInstanceFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getRolloutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                revisionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getRevisionCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                rolloutState_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 80:
              {
                baseline_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 88:
              {
                deleted_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 96:
              {
                reconciling_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 96
            case 106:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id}`
     *
     * This field is ignored when you create an OS policy assignment.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id}`
     *
     * This field is ignored when you create an OS policy assignment.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id}`
     *
     * This field is ignored when you create an OS policy assignment.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id}`
     *
     * This field is ignored when you create an OS policy assignment.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id}`
     *
     * This field is ignored when you create an OS policy assignment.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * OS policy assignment description.
     * Length of the description is limited to 1024 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * OS policy assignment description.
     * Length of the description is limited to 1024 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * OS policy assignment description.
     * Length of the description is limited to 1024 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OS policy assignment description.
     * Length of the description is limited to 1024 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OS policy assignment description.
     * Length of the description is limited to 1024 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicy> osPolicies_ =
        java.util.Collections.emptyList();

    private void ensureOsPoliciesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        osPolicies_ =
            new java.util.ArrayList<com.google.cloud.osconfig.v1alpha.OSPolicy>(osPolicies_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.OSPolicy,
            com.google.cloud.osconfig.v1alpha.OSPolicy.Builder,
            com.google.cloud.osconfig.v1alpha.OSPolicyOrBuilder>
        osPoliciesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicy> getOsPoliciesList() {
      if (osPoliciesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(osPolicies_);
      } else {
        return osPoliciesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getOsPoliciesCount() {
      if (osPoliciesBuilder_ == null) {
        return osPolicies_.size();
      } else {
        return osPoliciesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicy getOsPolicies(int index) {
      if (osPoliciesBuilder_ == null) {
        return osPolicies_.get(index);
      } else {
        return osPoliciesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOsPolicies(int index, com.google.cloud.osconfig.v1alpha.OSPolicy value) {
      if (osPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOsPoliciesIsMutable();
        osPolicies_.set(index, value);
        onChanged();
      } else {
        osPoliciesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOsPolicies(
        int index, com.google.cloud.osconfig.v1alpha.OSPolicy.Builder builderForValue) {
      if (osPoliciesBuilder_ == null) {
        ensureOsPoliciesIsMutable();
        osPolicies_.set(index, builderForValue.build());
        onChanged();
      } else {
        osPoliciesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addOsPolicies(com.google.cloud.osconfig.v1alpha.OSPolicy value) {
      if (osPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOsPoliciesIsMutable();
        osPolicies_.add(value);
        onChanged();
      } else {
        osPoliciesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addOsPolicies(int index, com.google.cloud.osconfig.v1alpha.OSPolicy value) {
      if (osPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOsPoliciesIsMutable();
        osPolicies_.add(index, value);
        onChanged();
      } else {
        osPoliciesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addOsPolicies(
        com.google.cloud.osconfig.v1alpha.OSPolicy.Builder builderForValue) {
      if (osPoliciesBuilder_ == null) {
        ensureOsPoliciesIsMutable();
        osPolicies_.add(builderForValue.build());
        onChanged();
      } else {
        osPoliciesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addOsPolicies(
        int index, com.google.cloud.osconfig.v1alpha.OSPolicy.Builder builderForValue) {
      if (osPoliciesBuilder_ == null) {
        ensureOsPoliciesIsMutable();
        osPolicies_.add(index, builderForValue.build());
        onChanged();
      } else {
        osPoliciesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllOsPolicies(
        java.lang.Iterable<? extends com.google.cloud.osconfig.v1alpha.OSPolicy> values) {
      if (osPoliciesBuilder_ == null) {
        ensureOsPoliciesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, osPolicies_);
        onChanged();
      } else {
        osPoliciesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOsPolicies() {
      if (osPoliciesBuilder_ == null) {
        osPolicies_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        osPoliciesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeOsPolicies(int index) {
      if (osPoliciesBuilder_ == null) {
        ensureOsPoliciesIsMutable();
        osPolicies_.remove(index);
        onChanged();
      } else {
        osPoliciesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicy.Builder getOsPoliciesBuilder(int index) {
      return getOsPoliciesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicyOrBuilder getOsPoliciesOrBuilder(int index) {
      if (osPoliciesBuilder_ == null) {
        return osPolicies_.get(index);
      } else {
        return osPoliciesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.osconfig.v1alpha.OSPolicyOrBuilder>
        getOsPoliciesOrBuilderList() {
      if (osPoliciesBuilder_ != null) {
        return osPoliciesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(osPolicies_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicy.Builder addOsPoliciesBuilder() {
      return getOsPoliciesFieldBuilder()
          .addBuilder(com.google.cloud.osconfig.v1alpha.OSPolicy.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicy.Builder addOsPoliciesBuilder(int index) {
      return getOsPoliciesFieldBuilder()
          .addBuilder(index, com.google.cloud.osconfig.v1alpha.OSPolicy.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. List of OS policies to be applied to the VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.OSPolicy os_policies = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicy.Builder>
        getOsPoliciesBuilderList() {
      return getOsPoliciesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.OSPolicy,
            com.google.cloud.osconfig.v1alpha.OSPolicy.Builder,
            com.google.cloud.osconfig.v1alpha.OSPolicyOrBuilder>
        getOsPoliciesFieldBuilder() {
      if (osPoliciesBuilder_ == null) {
        osPoliciesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.osconfig.v1alpha.OSPolicy,
                com.google.cloud.osconfig.v1alpha.OSPolicy.Builder,
                com.google.cloud.osconfig.v1alpha.OSPolicyOrBuilder>(
                osPolicies_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        osPolicies_ = null;
      }
      return osPoliciesBuilder_;
    }

    private com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instanceFilter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter,
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Builder,
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilterOrBuilder>
        instanceFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Filter to select VMs.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the instanceFilter field is set.
     */
    public boolean hasInstanceFilter() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Filter to select VMs.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The instanceFilter.
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter getInstanceFilter() {
      if (instanceFilterBuilder_ == null) {
        return instanceFilter_ == null
            ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
                .getDefaultInstance()
            : instanceFilter_;
      } else {
        return instanceFilterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Filter to select VMs.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInstanceFilter(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter value) {
      if (instanceFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instanceFilter_ = value;
      } else {
        instanceFilterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Filter to select VMs.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInstanceFilter(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Builder
            builderForValue) {
      if (instanceFilterBuilder_ == null) {
        instanceFilter_ = builderForValue.build();
      } else {
        instanceFilterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Filter to select VMs.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInstanceFilter(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter value) {
      if (instanceFilterBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && instanceFilter_ != null
            && instanceFilter_
                != com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
                    .getDefaultInstance()) {
          getInstanceFilterBuilder().mergeFrom(value);
        } else {
          instanceFilter_ = value;
        }
      } else {
        instanceFilterBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Filter to select VMs.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInstanceFilter() {
      bitField0_ = (bitField0_ & ~0x00000008);
      instanceFilter_ = null;
      if (instanceFilterBuilder_ != null) {
        instanceFilterBuilder_.dispose();
        instanceFilterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Filter to select VMs.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Builder
        getInstanceFilterBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getInstanceFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Filter to select VMs.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilterOrBuilder
        getInstanceFilterOrBuilder() {
      if (instanceFilterBuilder_ != null) {
        return instanceFilterBuilder_.getMessageOrBuilder();
      } else {
        return instanceFilter_ == null
            ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter
                .getDefaultInstance()
            : instanceFilter_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Filter to select VMs.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter instance_filter = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter,
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Builder,
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilterOrBuilder>
        getInstanceFilterFieldBuilder() {
      if (instanceFilterBuilder_ == null) {
        instanceFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter,
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilter.Builder,
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.InstanceFilterOrBuilder>(
                getInstanceFilter(), getParentForChildren(), isClean());
        instanceFilter_ = null;
      }
      return instanceFilterBuilder_;
    }

    private com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout,
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.Builder,
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutOrBuilder>
        rolloutBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Rollout to deploy the OS policy assignment.
     * A rollout is triggered in the following situations:
     * 1) OSPolicyAssignment is created.
     * 2) OSPolicyAssignment is updated and the update contains changes to one of
     * the following fields:
     *    - instance_filter
     *    - os_policies
     * 3) OSPolicyAssignment is deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the rollout field is set.
     */
    public boolean hasRollout() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Rollout to deploy the OS policy assignment.
     * A rollout is triggered in the following situations:
     * 1) OSPolicyAssignment is created.
     * 2) OSPolicyAssignment is updated and the update contains changes to one of
     * the following fields:
     *    - instance_filter
     *    - os_policies
     * 3) OSPolicyAssignment is deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The rollout.
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout getRollout() {
      if (rolloutBuilder_ == null) {
        return rollout_ == null
            ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.getDefaultInstance()
            : rollout_;
      } else {
        return rolloutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Rollout to deploy the OS policy assignment.
     * A rollout is triggered in the following situations:
     * 1) OSPolicyAssignment is created.
     * 2) OSPolicyAssignment is updated and the update contains changes to one of
     * the following fields:
     *    - instance_filter
     *    - os_policies
     * 3) OSPolicyAssignment is deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRollout(com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout value) {
      if (rolloutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rollout_ = value;
      } else {
        rolloutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rollout to deploy the OS policy assignment.
     * A rollout is triggered in the following situations:
     * 1) OSPolicyAssignment is created.
     * 2) OSPolicyAssignment is updated and the update contains changes to one of
     * the following fields:
     *    - instance_filter
     *    - os_policies
     * 3) OSPolicyAssignment is deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRollout(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.Builder builderForValue) {
      if (rolloutBuilder_ == null) {
        rollout_ = builderForValue.build();
      } else {
        rolloutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rollout to deploy the OS policy assignment.
     * A rollout is triggered in the following situations:
     * 1) OSPolicyAssignment is created.
     * 2) OSPolicyAssignment is updated and the update contains changes to one of
     * the following fields:
     *    - instance_filter
     *    - os_policies
     * 3) OSPolicyAssignment is deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeRollout(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout value) {
      if (rolloutBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && rollout_ != null
            && rollout_
                != com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout
                    .getDefaultInstance()) {
          getRolloutBuilder().mergeFrom(value);
        } else {
          rollout_ = value;
        }
      } else {
        rolloutBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rollout to deploy the OS policy assignment.
     * A rollout is triggered in the following situations:
     * 1) OSPolicyAssignment is created.
     * 2) OSPolicyAssignment is updated and the update contains changes to one of
     * the following fields:
     *    - instance_filter
     *    - os_policies
     * 3) OSPolicyAssignment is deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRollout() {
      bitField0_ = (bitField0_ & ~0x00000010);
      rollout_ = null;
      if (rolloutBuilder_ != null) {
        rolloutBuilder_.dispose();
        rolloutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Rollout to deploy the OS policy assignment.
     * A rollout is triggered in the following situations:
     * 1) OSPolicyAssignment is created.
     * 2) OSPolicyAssignment is updated and the update contains changes to one of
     * the following fields:
     *    - instance_filter
     *    - os_policies
     * 3) OSPolicyAssignment is deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.Builder
        getRolloutBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRolloutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Rollout to deploy the OS policy assignment.
     * A rollout is triggered in the following situations:
     * 1) OSPolicyAssignment is created.
     * 2) OSPolicyAssignment is updated and the update contains changes to one of
     * the following fields:
     *    - instance_filter
     *    - os_policies
     * 3) OSPolicyAssignment is deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutOrBuilder
        getRolloutOrBuilder() {
      if (rolloutBuilder_ != null) {
        return rolloutBuilder_.getMessageOrBuilder();
      } else {
        return rollout_ == null
            ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.getDefaultInstance()
            : rollout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Rollout to deploy the OS policy assignment.
     * A rollout is triggered in the following situations:
     * 1) OSPolicyAssignment is created.
     * 2) OSPolicyAssignment is updated and the update contains changes to one of
     * the following fields:
     *    - instance_filter
     *    - os_policies
     * 3) OSPolicyAssignment is deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout rollout = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout,
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.Builder,
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutOrBuilder>
        getRolloutFieldBuilder() {
      if (rolloutBuilder_ == null) {
        rolloutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout,
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.Rollout.Builder,
                com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutOrBuilder>(
                getRollout(), getParentForChildren(), isClean());
        rollout_ = null;
      }
      return rolloutBuilder_;
    }

    private java.lang.Object revisionId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The assignment revision ID
     * A new revision is committed whenever a rollout is triggered for a OS policy
     * assignment
     * </pre>
     *
     * <code>string revision_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The revisionId.
     */
    public java.lang.String getRevisionId() {
      java.lang.Object ref = revisionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        revisionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The assignment revision ID
     * A new revision is committed whenever a rollout is triggered for a OS policy
     * assignment
     * </pre>
     *
     * <code>string revision_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for revisionId.
     */
    public com.google.protobuf.ByteString getRevisionIdBytes() {
      java.lang.Object ref = revisionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        revisionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The assignment revision ID
     * A new revision is committed whenever a rollout is triggered for a OS policy
     * assignment
     * </pre>
     *
     * <code>string revision_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The revisionId to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revisionId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The assignment revision ID
     * A new revision is committed whenever a rollout is triggered for a OS policy
     * assignment
     * </pre>
     *
     * <code>string revision_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevisionId() {
      revisionId_ = getDefaultInstance().getRevisionId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The assignment revision ID
     * A new revision is committed whenever a rollout is triggered for a OS policy
     * assignment
     * </pre>
     *
     * <code>string revision_id = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for revisionId to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revisionId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp revisionCreateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        revisionCreateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the revisionCreateTime field is set.
     */
    public boolean hasRevisionCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The revisionCreateTime.
     */
    public com.google.protobuf.Timestamp getRevisionCreateTime() {
      if (revisionCreateTimeBuilder_ == null) {
        return revisionCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : revisionCreateTime_;
      } else {
        return revisionCreateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRevisionCreateTime(com.google.protobuf.Timestamp value) {
      if (revisionCreateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        revisionCreateTime_ = value;
      } else {
        revisionCreateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRevisionCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (revisionCreateTimeBuilder_ == null) {
        revisionCreateTime_ = builderForValue.build();
      } else {
        revisionCreateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRevisionCreateTime(com.google.protobuf.Timestamp value) {
      if (revisionCreateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && revisionCreateTime_ != null
            && revisionCreateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRevisionCreateTimeBuilder().mergeFrom(value);
        } else {
          revisionCreateTime_ = value;
        }
      } else {
        revisionCreateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRevisionCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      revisionCreateTime_ = null;
      if (revisionCreateTimeBuilder_ != null) {
        revisionCreateTimeBuilder_.dispose();
        revisionCreateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getRevisionCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getRevisionCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getRevisionCreateTimeOrBuilder() {
      if (revisionCreateTimeBuilder_ != null) {
        return revisionCreateTimeBuilder_.getMessageOrBuilder();
      } else {
        return revisionCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : revisionCreateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRevisionCreateTimeFieldBuilder() {
      if (revisionCreateTimeBuilder_ == null) {
        revisionCreateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRevisionCreateTime(), getParentForChildren(), isClean());
        revisionCreateTime_ = null;
      }
      return revisionCreateTimeBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * The etag for this OS policy assignment.
     * If this is provided on update, it must match the server's etag.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The etag for this OS policy assignment.
     * If this is provided on update, it must match the server's etag.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The etag for this OS policy assignment.
     * If this is provided on update, it must match the server's etag.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The etag for this OS policy assignment.
     * If this is provided on update, it must match the server's etag.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The etag for this OS policy assignment.
     * If this is provided on update, it must match the server's etag.
     * </pre>
     *
     * <code>string etag = 8;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private int rolloutState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. OS policy assignment rollout state
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState rollout_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for rolloutState.
     */
    @java.lang.Override
    public int getRolloutStateValue() {
      return rolloutState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. OS policy assignment rollout state
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState rollout_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for rolloutState to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutStateValue(int value) {
      rolloutState_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. OS policy assignment rollout state
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState rollout_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The rolloutState.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState getRolloutState() {
      com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState result =
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState.forNumber(
              rolloutState_);
      return result == null
          ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. OS policy assignment rollout state
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState rollout_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The rolloutState to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutState(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      rolloutState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. OS policy assignment rollout state
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignment.RolloutState rollout_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRolloutState() {
      bitField0_ = (bitField0_ & ~0x00000100);
      rolloutState_ = 0;
      onChanged();
      return this;
    }

    private boolean baseline_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates that this revision has been successfully rolled out in this zone
     * and new VMs will be assigned OS policies from this revision.
     *
     * For a given OS policy assignment, there is only one revision with a value
     * of `true` for this field.
     * </pre>
     *
     * <code>bool baseline = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The baseline.
     */
    @java.lang.Override
    public boolean getBaseline() {
      return baseline_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates that this revision has been successfully rolled out in this zone
     * and new VMs will be assigned OS policies from this revision.
     *
     * For a given OS policy assignment, there is only one revision with a value
     * of `true` for this field.
     * </pre>
     *
     * <code>bool baseline = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The baseline to set.
     * @return This builder for chaining.
     */
    public Builder setBaseline(boolean value) {

      baseline_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates that this revision has been successfully rolled out in this zone
     * and new VMs will be assigned OS policies from this revision.
     *
     * For a given OS policy assignment, there is only one revision with a value
     * of `true` for this field.
     * </pre>
     *
     * <code>bool baseline = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseline() {
      bitField0_ = (bitField0_ & ~0x00000200);
      baseline_ = false;
      onChanged();
      return this;
    }

    private boolean deleted_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates that this revision deletes the OS policy assignment.
     * </pre>
     *
     * <code>bool deleted = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The deleted.
     */
    @java.lang.Override
    public boolean getDeleted() {
      return deleted_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates that this revision deletes the OS policy assignment.
     * </pre>
     *
     * <code>bool deleted = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The deleted to set.
     * @return This builder for chaining.
     */
    public Builder setDeleted(boolean value) {

      deleted_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates that this revision deletes the OS policy assignment.
     * </pre>
     *
     * <code>bool deleted = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeleted() {
      bitField0_ = (bitField0_ & ~0x00000400);
      deleted_ = false;
      onChanged();
      return this;
    }

    private boolean reconciling_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates that reconciliation is in progress for the revision.
     * This value is `true` when the `rollout_state` is one of:
     * * IN_PROGRESS
     * * CANCELLING
     * </pre>
     *
     * <code>bool reconciling = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The reconciling.
     */
    @java.lang.Override
    public boolean getReconciling() {
      return reconciling_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates that reconciliation is in progress for the revision.
     * This value is `true` when the `rollout_state` is one of:
     * * IN_PROGRESS
     * * CANCELLING
     * </pre>
     *
     * <code>bool reconciling = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The reconciling to set.
     * @return This builder for chaining.
     */
    public Builder setReconciling(boolean value) {

      reconciling_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates that reconciliation is in progress for the revision.
     * This value is `true` when the `rollout_state` is one of:
     * * IN_PROGRESS
     * * CANCELLING
     * </pre>
     *
     * <code>bool reconciling = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciling() {
      bitField0_ = (bitField0_ & ~0x00000800);
      reconciling_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Server generated unique id for the OS policy assignment resource.
     * </pre>
     *
     * <code>string uid = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated unique id for the OS policy assignment resource.
     * </pre>
     *
     * <code>string uid = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated unique id for the OS policy assignment resource.
     * </pre>
     *
     * <code>string uid = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated unique id for the OS policy assignment resource.
     * </pre>
     *
     * <code>string uid = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server generated unique id for the OS policy assignment resource.
     * </pre>
     *
     * <code>string uid = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignment)
  private static final com.google.cloud.osconfig.v1alpha.OSPolicyAssignment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.OSPolicyAssignment();
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OSPolicyAssignment> PARSER =
      new com.google.protobuf.AbstractParser<OSPolicyAssignment>() {
        @java.lang.Override
        public OSPolicyAssignment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OSPolicyAssignment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OSPolicyAssignment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyAssignment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
