/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1alpha/os_policy_assignments.proto

package com.google.cloud.osconfig.v1alpha;

/**
 *
 *
 * <pre>
 * OS policy assignment operation metadata provided by OS policy assignment API
 * methods that return long running operations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata}
 */
public final class OSPolicyAssignmentOperationMetadata
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata)
    OSPolicyAssignmentOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OSPolicyAssignmentOperationMetadata.newBuilder() to construct.
  private OSPolicyAssignmentOperationMetadata(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OSPolicyAssignmentOperationMetadata() {
    osPolicyAssignment_ = "";
    apiMethod_ = 0;
    rolloutState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OSPolicyAssignmentOperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
        .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignmentOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
        .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignmentOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.class,
            com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The OS policy assignment API method.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod}
   */
  public enum APIMethod implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid value
     * </pre>
     *
     * <code>API_METHOD_UNSPECIFIED = 0;</code>
     */
    API_METHOD_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Create OS policy assignment API method
     * </pre>
     *
     * <code>CREATE = 1;</code>
     */
    CREATE(1),
    /**
     *
     *
     * <pre>
     * Update OS policy assignment API method
     * </pre>
     *
     * <code>UPDATE = 2;</code>
     */
    UPDATE(2),
    /**
     *
     *
     * <pre>
     * Delete OS policy assignment API method
     * </pre>
     *
     * <code>DELETE = 3;</code>
     */
    DELETE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid value
     * </pre>
     *
     * <code>API_METHOD_UNSPECIFIED = 0;</code>
     */
    public static final int API_METHOD_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Create OS policy assignment API method
     * </pre>
     *
     * <code>CREATE = 1;</code>
     */
    public static final int CREATE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Update OS policy assignment API method
     * </pre>
     *
     * <code>UPDATE = 2;</code>
     */
    public static final int UPDATE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Delete OS policy assignment API method
     * </pre>
     *
     * <code>DELETE = 3;</code>
     */
    public static final int DELETE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static APIMethod valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static APIMethod forNumber(int value) {
      switch (value) {
        case 0:
          return API_METHOD_UNSPECIFIED;
        case 1:
          return CREATE;
        case 2:
          return UPDATE;
        case 3:
          return DELETE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<APIMethod> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<APIMethod> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<APIMethod>() {
          public APIMethod findValueByNumber(int number) {
            return APIMethod.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final APIMethod[] VALUES = values();

    public static APIMethod valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private APIMethod(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod)
  }

  /**
   *
   *
   * <pre>
   * State of the rollout
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState}
   */
  public enum RolloutState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid value
     * </pre>
     *
     * <code>ROLLOUT_STATE_UNSPECIFIED = 0;</code>
     */
    ROLLOUT_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The rollout is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    IN_PROGRESS(1),
    /**
     *
     *
     * <pre>
     * The rollout is being cancelled.
     * </pre>
     *
     * <code>CANCELLING = 2;</code>
     */
    CANCELLING(2),
    /**
     *
     *
     * <pre>
     * The rollout is cancelled.
     * </pre>
     *
     * <code>CANCELLED = 3;</code>
     */
    CANCELLED(3),
    /**
     *
     *
     * <pre>
     * The rollout has completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    SUCCEEDED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid value
     * </pre>
     *
     * <code>ROLLOUT_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int ROLLOUT_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The rollout is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    public static final int IN_PROGRESS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The rollout is being cancelled.
     * </pre>
     *
     * <code>CANCELLING = 2;</code>
     */
    public static final int CANCELLING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The rollout is cancelled.
     * </pre>
     *
     * <code>CANCELLED = 3;</code>
     */
    public static final int CANCELLED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The rollout has completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    public static final int SUCCEEDED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RolloutState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RolloutState forNumber(int value) {
      switch (value) {
        case 0:
          return ROLLOUT_STATE_UNSPECIFIED;
        case 1:
          return IN_PROGRESS;
        case 2:
          return CANCELLING;
        case 3:
          return CANCELLED;
        case 4:
          return SUCCEEDED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RolloutState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RolloutState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RolloutState>() {
          public RolloutState findValueByNumber(int number) {
            return RolloutState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final RolloutState[] VALUES = values();

    public static RolloutState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RolloutState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState)
  }

  public static final int OS_POLICY_ASSIGNMENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object osPolicyAssignment_ = "";
  /**
   *
   *
   * <pre>
   * Reference to the `OSPolicyAssignment` API resource.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
   * </pre>
   *
   * <code>string os_policy_assignment = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The osPolicyAssignment.
   */
  @java.lang.Override
  public java.lang.String getOsPolicyAssignment() {
    java.lang.Object ref = osPolicyAssignment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      osPolicyAssignment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Reference to the `OSPolicyAssignment` API resource.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
   * </pre>
   *
   * <code>string os_policy_assignment = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for osPolicyAssignment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOsPolicyAssignmentBytes() {
    java.lang.Object ref = osPolicyAssignment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      osPolicyAssignment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int API_METHOD_FIELD_NUMBER = 2;
  private int apiMethod_ = 0;
  /**
   *
   *
   * <pre>
   * The OS policy assignment API method.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod api_method = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for apiMethod.
   */
  @java.lang.Override
  public int getApiMethodValue() {
    return apiMethod_;
  }
  /**
   *
   *
   * <pre>
   * The OS policy assignment API method.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod api_method = 2;
   * </code>
   *
   * @return The apiMethod.
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod
      getApiMethod() {
    com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod result =
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod.forNumber(
            apiMethod_);
    return result == null
        ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod
            .UNRECOGNIZED
        : result;
  }

  public static final int ROLLOUT_STATE_FIELD_NUMBER = 3;
  private int rolloutState_ = 0;
  /**
   *
   *
   * <pre>
   * State of the rollout
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState rollout_state = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for rolloutState.
   */
  @java.lang.Override
  public int getRolloutStateValue() {
    return rolloutState_;
  }
  /**
   *
   *
   * <pre>
   * State of the rollout
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState rollout_state = 3;
   * </code>
   *
   * @return The rolloutState.
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState
      getRolloutState() {
    com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState result =
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState
            .forNumber(rolloutState_);
    return result == null
        ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState
            .UNRECOGNIZED
        : result;
  }

  public static final int ROLLOUT_START_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp rolloutStartTime_;
  /**
   *
   *
   * <pre>
   * Rollout start time
   * </pre>
   *
   * <code>.google.protobuf.Timestamp rollout_start_time = 4;</code>
   *
   * @return Whether the rolloutStartTime field is set.
   */
  @java.lang.Override
  public boolean hasRolloutStartTime() {
    return rolloutStartTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Rollout start time
   * </pre>
   *
   * <code>.google.protobuf.Timestamp rollout_start_time = 4;</code>
   *
   * @return The rolloutStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRolloutStartTime() {
    return rolloutStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : rolloutStartTime_;
  }
  /**
   *
   *
   * <pre>
   * Rollout start time
   * </pre>
   *
   * <code>.google.protobuf.Timestamp rollout_start_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRolloutStartTimeOrBuilder() {
    return rolloutStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : rolloutStartTime_;
  }

  public static final int ROLLOUT_UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp rolloutUpdateTime_;
  /**
   *
   *
   * <pre>
   * Rollout update time
   * </pre>
   *
   * <code>.google.protobuf.Timestamp rollout_update_time = 5;</code>
   *
   * @return Whether the rolloutUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasRolloutUpdateTime() {
    return rolloutUpdateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Rollout update time
   * </pre>
   *
   * <code>.google.protobuf.Timestamp rollout_update_time = 5;</code>
   *
   * @return The rolloutUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRolloutUpdateTime() {
    return rolloutUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : rolloutUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * Rollout update time
   * </pre>
   *
   * <code>.google.protobuf.Timestamp rollout_update_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRolloutUpdateTimeOrBuilder() {
    return rolloutUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : rolloutUpdateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyAssignment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, osPolicyAssignment_);
    }
    if (apiMethod_
        != com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod
            .API_METHOD_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, apiMethod_);
    }
    if (rolloutState_
        != com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState
            .ROLLOUT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, rolloutState_);
    }
    if (rolloutStartTime_ != null) {
      output.writeMessage(4, getRolloutStartTime());
    }
    if (rolloutUpdateTime_ != null) {
      output.writeMessage(5, getRolloutUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyAssignment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, osPolicyAssignment_);
    }
    if (apiMethod_
        != com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod
            .API_METHOD_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, apiMethod_);
    }
    if (rolloutState_
        != com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState
            .ROLLOUT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, rolloutState_);
    }
    if (rolloutStartTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRolloutStartTime());
    }
    if (rolloutUpdateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRolloutUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata other =
        (com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata) obj;

    if (!getOsPolicyAssignment().equals(other.getOsPolicyAssignment())) return false;
    if (apiMethod_ != other.apiMethod_) return false;
    if (rolloutState_ != other.rolloutState_) return false;
    if (hasRolloutStartTime() != other.hasRolloutStartTime()) return false;
    if (hasRolloutStartTime()) {
      if (!getRolloutStartTime().equals(other.getRolloutStartTime())) return false;
    }
    if (hasRolloutUpdateTime() != other.hasRolloutUpdateTime()) return false;
    if (hasRolloutUpdateTime()) {
      if (!getRolloutUpdateTime().equals(other.getRolloutUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + OS_POLICY_ASSIGNMENT_FIELD_NUMBER;
    hash = (53 * hash) + getOsPolicyAssignment().hashCode();
    hash = (37 * hash) + API_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + apiMethod_;
    hash = (37 * hash) + ROLLOUT_STATE_FIELD_NUMBER;
    hash = (53 * hash) + rolloutState_;
    if (hasRolloutStartTime()) {
      hash = (37 * hash) + ROLLOUT_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRolloutStartTime().hashCode();
    }
    if (hasRolloutUpdateTime()) {
      hash = (37 * hash) + ROLLOUT_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRolloutUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * OS policy assignment operation metadata provided by OS policy assignment API
   * methods that return long running operations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata)
      com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignmentOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignmentOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.class,
              com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.Builder.class);
    }

    // Construct using
    // com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      osPolicyAssignment_ = "";
      apiMethod_ = 0;
      rolloutState_ = 0;
      rolloutStartTime_ = null;
      if (rolloutStartTimeBuilder_ != null) {
        rolloutStartTimeBuilder_.dispose();
        rolloutStartTimeBuilder_ = null;
      }
      rolloutUpdateTime_ = null;
      if (rolloutUpdateTimeBuilder_ != null) {
        rolloutUpdateTimeBuilder_.dispose();
        rolloutUpdateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.osconfig.v1alpha.OsPolicyAssignmentsProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyAssignmentOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata build() {
      com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata buildPartial() {
      com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata result =
          new com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.osPolicyAssignment_ = osPolicyAssignment_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.apiMethod_ = apiMethod_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rolloutState_ = rolloutState_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.rolloutStartTime_ =
            rolloutStartTimeBuilder_ == null ? rolloutStartTime_ : rolloutStartTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.rolloutUpdateTime_ =
            rolloutUpdateTimeBuilder_ == null
                ? rolloutUpdateTime_
                : rolloutUpdateTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata) {
        return mergeFrom(
            (com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata other) {
      if (other
          == com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata
              .getDefaultInstance()) return this;
      if (!other.getOsPolicyAssignment().isEmpty()) {
        osPolicyAssignment_ = other.osPolicyAssignment_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.apiMethod_ != 0) {
        setApiMethodValue(other.getApiMethodValue());
      }
      if (other.rolloutState_ != 0) {
        setRolloutStateValue(other.getRolloutStateValue());
      }
      if (other.hasRolloutStartTime()) {
        mergeRolloutStartTime(other.getRolloutStartTime());
      }
      if (other.hasRolloutUpdateTime()) {
        mergeRolloutUpdateTime(other.getRolloutUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                osPolicyAssignment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                apiMethod_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                rolloutState_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(
                    getRolloutStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getRolloutUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object osPolicyAssignment_ = "";
    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The osPolicyAssignment.
     */
    public java.lang.String getOsPolicyAssignment() {
      java.lang.Object ref = osPolicyAssignment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        osPolicyAssignment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for osPolicyAssignment.
     */
    public com.google.protobuf.ByteString getOsPolicyAssignmentBytes() {
      java.lang.Object ref = osPolicyAssignment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        osPolicyAssignment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The osPolicyAssignment to set.
     * @return This builder for chaining.
     */
    public Builder setOsPolicyAssignment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      osPolicyAssignment_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOsPolicyAssignment() {
      osPolicyAssignment_ = getDefaultInstance().getOsPolicyAssignment();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reference to the `OSPolicyAssignment` API resource.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id&#64;revision_id}`
     * </pre>
     *
     * <code>string os_policy_assignment = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for osPolicyAssignment to set.
     * @return This builder for chaining.
     */
    public Builder setOsPolicyAssignmentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      osPolicyAssignment_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int apiMethod_ = 0;
    /**
     *
     *
     * <pre>
     * The OS policy assignment API method.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod api_method = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for apiMethod.
     */
    @java.lang.Override
    public int getApiMethodValue() {
      return apiMethod_;
    }
    /**
     *
     *
     * <pre>
     * The OS policy assignment API method.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod api_method = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for apiMethod to set.
     * @return This builder for chaining.
     */
    public Builder setApiMethodValue(int value) {
      apiMethod_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The OS policy assignment API method.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod api_method = 2;
     * </code>
     *
     * @return The apiMethod.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod
        getApiMethod() {
      com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod result =
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod.forNumber(
              apiMethod_);
      return result == null
          ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The OS policy assignment API method.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod api_method = 2;
     * </code>
     *
     * @param value The apiMethod to set.
     * @return This builder for chaining.
     */
    public Builder setApiMethod(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      apiMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The OS policy assignment API method.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.APIMethod api_method = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApiMethod() {
      bitField0_ = (bitField0_ & ~0x00000002);
      apiMethod_ = 0;
      onChanged();
      return this;
    }

    private int rolloutState_ = 0;
    /**
     *
     *
     * <pre>
     * State of the rollout
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState rollout_state = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for rolloutState.
     */
    @java.lang.Override
    public int getRolloutStateValue() {
      return rolloutState_;
    }
    /**
     *
     *
     * <pre>
     * State of the rollout
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState rollout_state = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for rolloutState to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutStateValue(int value) {
      rolloutState_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of the rollout
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState rollout_state = 3;
     * </code>
     *
     * @return The rolloutState.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState
        getRolloutState() {
      com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState result =
          com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState
              .forNumber(rolloutState_);
      return result == null
          ? com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * State of the rollout
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState rollout_state = 3;
     * </code>
     *
     * @param value The rolloutState to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutState(
        com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      rolloutState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of the rollout
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata.RolloutState rollout_state = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRolloutState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      rolloutState_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp rolloutStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        rolloutStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Rollout start time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_start_time = 4;</code>
     *
     * @return Whether the rolloutStartTime field is set.
     */
    public boolean hasRolloutStartTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Rollout start time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_start_time = 4;</code>
     *
     * @return The rolloutStartTime.
     */
    public com.google.protobuf.Timestamp getRolloutStartTime() {
      if (rolloutStartTimeBuilder_ == null) {
        return rolloutStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : rolloutStartTime_;
      } else {
        return rolloutStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Rollout start time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_start_time = 4;</code>
     */
    public Builder setRolloutStartTime(com.google.protobuf.Timestamp value) {
      if (rolloutStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rolloutStartTime_ = value;
      } else {
        rolloutStartTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rollout start time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_start_time = 4;</code>
     */
    public Builder setRolloutStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (rolloutStartTimeBuilder_ == null) {
        rolloutStartTime_ = builderForValue.build();
      } else {
        rolloutStartTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rollout start time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_start_time = 4;</code>
     */
    public Builder mergeRolloutStartTime(com.google.protobuf.Timestamp value) {
      if (rolloutStartTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && rolloutStartTime_ != null
            && rolloutStartTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRolloutStartTimeBuilder().mergeFrom(value);
        } else {
          rolloutStartTime_ = value;
        }
      } else {
        rolloutStartTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rollout start time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_start_time = 4;</code>
     */
    public Builder clearRolloutStartTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      rolloutStartTime_ = null;
      if (rolloutStartTimeBuilder_ != null) {
        rolloutStartTimeBuilder_.dispose();
        rolloutStartTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rollout start time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_start_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getRolloutStartTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRolloutStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Rollout start time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_start_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getRolloutStartTimeOrBuilder() {
      if (rolloutStartTimeBuilder_ != null) {
        return rolloutStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return rolloutStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : rolloutStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Rollout start time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_start_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRolloutStartTimeFieldBuilder() {
      if (rolloutStartTimeBuilder_ == null) {
        rolloutStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRolloutStartTime(), getParentForChildren(), isClean());
        rolloutStartTime_ = null;
      }
      return rolloutStartTimeBuilder_;
    }

    private com.google.protobuf.Timestamp rolloutUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        rolloutUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Rollout update time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_update_time = 5;</code>
     *
     * @return Whether the rolloutUpdateTime field is set.
     */
    public boolean hasRolloutUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Rollout update time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_update_time = 5;</code>
     *
     * @return The rolloutUpdateTime.
     */
    public com.google.protobuf.Timestamp getRolloutUpdateTime() {
      if (rolloutUpdateTimeBuilder_ == null) {
        return rolloutUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : rolloutUpdateTime_;
      } else {
        return rolloutUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Rollout update time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_update_time = 5;</code>
     */
    public Builder setRolloutUpdateTime(com.google.protobuf.Timestamp value) {
      if (rolloutUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rolloutUpdateTime_ = value;
      } else {
        rolloutUpdateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rollout update time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_update_time = 5;</code>
     */
    public Builder setRolloutUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (rolloutUpdateTimeBuilder_ == null) {
        rolloutUpdateTime_ = builderForValue.build();
      } else {
        rolloutUpdateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rollout update time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_update_time = 5;</code>
     */
    public Builder mergeRolloutUpdateTime(com.google.protobuf.Timestamp value) {
      if (rolloutUpdateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && rolloutUpdateTime_ != null
            && rolloutUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRolloutUpdateTimeBuilder().mergeFrom(value);
        } else {
          rolloutUpdateTime_ = value;
        }
      } else {
        rolloutUpdateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rollout update time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_update_time = 5;</code>
     */
    public Builder clearRolloutUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      rolloutUpdateTime_ = null;
      if (rolloutUpdateTimeBuilder_ != null) {
        rolloutUpdateTimeBuilder_.dispose();
        rolloutUpdateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rollout update time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_update_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getRolloutUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRolloutUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Rollout update time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_update_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getRolloutUpdateTimeOrBuilder() {
      if (rolloutUpdateTimeBuilder_ != null) {
        return rolloutUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return rolloutUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : rolloutUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Rollout update time
     * </pre>
     *
     * <code>.google.protobuf.Timestamp rollout_update_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRolloutUpdateTimeFieldBuilder() {
      if (rolloutUpdateTimeBuilder_ == null) {
        rolloutUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRolloutUpdateTime(), getParentForChildren(), isClean());
        rolloutUpdateTime_ = null;
      }
      return rolloutUpdateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata)
  private static final com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata();
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OSPolicyAssignmentOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<OSPolicyAssignmentOperationMetadata>() {
        @java.lang.Override
        public OSPolicyAssignmentOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OSPolicyAssignmentOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OSPolicyAssignmentOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
