/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1alpha/os_policy.proto

package com.google.cloud.osconfig.v1alpha;

public interface OSPolicyOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.OSPolicy)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The id of the OS policy with the following restrictions:
   *
   * * Must contain only lowercase letters, numbers, and hyphens.
   * * Must start with a letter.
   * * Must be between 1-63 characters.
   * * Must end with a number or a letter.
   * * Must be unique within the assignment.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The id.
   */
  java.lang.String getId();
  /**
   *
   *
   * <pre>
   * Required. The id of the OS policy with the following restrictions:
   *
   * * Must contain only lowercase letters, numbers, and hyphens.
   * * Must start with a letter.
   * * Must be between 1-63 characters.
   * * Must end with a number or a letter.
   * * Must be unique within the assignment.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for id.
   */
  com.google.protobuf.ByteString getIdBytes();

  /**
   *
   *
   * <pre>
   * Policy description.
   * Length of the description is limited to 1024 characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * Policy description.
   * Length of the description is limited to 1024 characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Required. Policy mode
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicy.Mode mode = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for mode.
   */
  int getModeValue();
  /**
   *
   *
   * <pre>
   * Required. Policy mode
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicy.Mode mode = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The mode.
   */
  com.google.cloud.osconfig.v1alpha.OSPolicy.Mode getMode();

  /**
   *
   *
   * <pre>
   * Required. List of resource groups for the policy.
   * For a particular VM, resource groups are evaluated in the order specified
   * and the first resource group that is applicable is selected and the rest
   * are ignored.
   *
   * If none of the resource groups are applicable for a VM, the VM is
   * considered to be non-compliant w.r.t this policy. This behavior can be
   * toggled by the flag `allow_no_resource_group_match`
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.OSPolicy.ResourceGroup resource_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicy.ResourceGroup> getResourceGroupsList();
  /**
   *
   *
   * <pre>
   * Required. List of resource groups for the policy.
   * For a particular VM, resource groups are evaluated in the order specified
   * and the first resource group that is applicable is selected and the rest
   * are ignored.
   *
   * If none of the resource groups are applicable for a VM, the VM is
   * considered to be non-compliant w.r.t this policy. This behavior can be
   * toggled by the flag `allow_no_resource_group_match`
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.OSPolicy.ResourceGroup resource_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.osconfig.v1alpha.OSPolicy.ResourceGroup getResourceGroups(int index);
  /**
   *
   *
   * <pre>
   * Required. List of resource groups for the policy.
   * For a particular VM, resource groups are evaluated in the order specified
   * and the first resource group that is applicable is selected and the rest
   * are ignored.
   *
   * If none of the resource groups are applicable for a VM, the VM is
   * considered to be non-compliant w.r.t this policy. This behavior can be
   * toggled by the flag `allow_no_resource_group_match`
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.OSPolicy.ResourceGroup resource_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  int getResourceGroupsCount();
  /**
   *
   *
   * <pre>
   * Required. List of resource groups for the policy.
   * For a particular VM, resource groups are evaluated in the order specified
   * and the first resource group that is applicable is selected and the rest
   * are ignored.
   *
   * If none of the resource groups are applicable for a VM, the VM is
   * considered to be non-compliant w.r.t this policy. This behavior can be
   * toggled by the flag `allow_no_resource_group_match`
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.OSPolicy.ResourceGroup resource_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<? extends com.google.cloud.osconfig.v1alpha.OSPolicy.ResourceGroupOrBuilder>
      getResourceGroupsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Required. List of resource groups for the policy.
   * For a particular VM, resource groups are evaluated in the order specified
   * and the first resource group that is applicable is selected and the rest
   * are ignored.
   *
   * If none of the resource groups are applicable for a VM, the VM is
   * considered to be non-compliant w.r.t this policy. This behavior can be
   * toggled by the flag `allow_no_resource_group_match`
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.OSPolicy.ResourceGroup resource_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.osconfig.v1alpha.OSPolicy.ResourceGroupOrBuilder getResourceGroupsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * This flag determines the OS policy compliance status when none of the
   * resource groups within the policy are applicable for a VM. Set this value
   * to `true` if the policy needs to be reported as compliant even if the
   * policy has nothing to validate or enforce.
   * </pre>
   *
   * <code>bool allow_no_resource_group_match = 5;</code>
   *
   * @return The allowNoResourceGroupMatch.
   */
  boolean getAllowNoResourceGroupMatch();
}
