/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1alpha/config_common.proto

package com.google.cloud.osconfig.v1alpha;

/**
 *
 *
 * <pre>
 * Compliance data for an OS policy resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance}
 */
@java.lang.Deprecated
public final class OSPolicyResourceCompliance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance)
    OSPolicyResourceComplianceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OSPolicyResourceCompliance.newBuilder() to construct.
  private OSPolicyResourceCompliance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OSPolicyResourceCompliance() {
    osPolicyResourceId_ = "";
    configSteps_ = java.util.Collections.emptyList();
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OSPolicyResourceCompliance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
        .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceCompliance_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
        .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceCompliance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.class,
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.Builder.class);
  }

  @java.lang.Deprecated
  public interface ExecResourceOutputOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output from Enforcement phase output file (if run).
     * Output size is limited to 100K bytes.
     * </pre>
     *
     * <code>bytes enforcement_output = 2;</code>
     *
     * @return The enforcementOutput.
     */
    com.google.protobuf.ByteString getEnforcementOutput();
  }
  /**
   *
   *
   * <pre>
   * ExecResource specific output.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput}
   */
  @java.lang.Deprecated
  public static final class ExecResourceOutput extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)
      ExecResourceOutputOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExecResourceOutput.newBuilder() to construct.
    private ExecResourceOutput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExecResourceOutput() {
      enforcementOutput_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExecResourceOutput();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceCompliance_ExecResourceOutput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceCompliance_ExecResourceOutput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput.class,
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
                  .Builder.class);
    }

    public static final int ENFORCEMENT_OUTPUT_FIELD_NUMBER = 2;
    private com.google.protobuf.ByteString enforcementOutput_ =
        com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Output from Enforcement phase output file (if run).
     * Output size is limited to 100K bytes.
     * </pre>
     *
     * <code>bytes enforcement_output = 2;</code>
     *
     * @return The enforcementOutput.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEnforcementOutput() {
      return enforcementOutput_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!enforcementOutput_.isEmpty()) {
        output.writeBytes(2, enforcementOutput_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!enforcementOutput_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, enforcementOutput_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput other =
          (com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput) obj;

      if (!getEnforcementOutput().equals(other.getEnforcementOutput())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENFORCEMENT_OUTPUT_FIELD_NUMBER;
      hash = (53 * hash) + getEnforcementOutput().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ExecResource specific output.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutputOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceCompliance_ExecResourceOutput_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceCompliance_ExecResourceOutput_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
                    .class,
                com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enforcementOutput_ = com.google.protobuf.ByteString.EMPTY;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
            .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceCompliance_ExecResourceOutput_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
          build() {
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
          buildPartial() {
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput result =
            new com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enforcementOutput_ = enforcementOutput_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput other) {
        if (other
            == com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
                .getDefaultInstance()) return this;
        if (other.getEnforcementOutput() != com.google.protobuf.ByteString.EMPTY) {
          setEnforcementOutput(other.getEnforcementOutput());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  enforcementOutput_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.ByteString enforcementOutput_ =
          com.google.protobuf.ByteString.EMPTY;
      /**
       *
       *
       * <pre>
       * Output from Enforcement phase output file (if run).
       * Output size is limited to 100K bytes.
       * </pre>
       *
       * <code>bytes enforcement_output = 2;</code>
       *
       * @return The enforcementOutput.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getEnforcementOutput() {
        return enforcementOutput_;
      }
      /**
       *
       *
       * <pre>
       * Output from Enforcement phase output file (if run).
       * Output size is limited to 100K bytes.
       * </pre>
       *
       * <code>bytes enforcement_output = 2;</code>
       *
       * @param value The enforcementOutput to set.
       * @return This builder for chaining.
       */
      public Builder setEnforcementOutput(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        enforcementOutput_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output from Enforcement phase output file (if run).
       * Output size is limited to 100K bytes.
       * </pre>
       *
       * <code>bytes enforcement_output = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnforcementOutput() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enforcementOutput_ = getDefaultInstance().getEnforcementOutput();
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)
    private static final com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance
            .ExecResourceOutput
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput();
    }

    public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExecResourceOutput> PARSER =
        new com.google.protobuf.AbstractParser<ExecResourceOutput>() {
          @java.lang.Override
          public ExecResourceOutput parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExecResourceOutput> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExecResourceOutput> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int outputCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object output_;

  public enum OutputCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXEC_RESOURCE_OUTPUT(4),
    OUTPUT_NOT_SET(0);
    private final int value;

    private OutputCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OutputCase valueOf(int value) {
      return forNumber(value);
    }

    public static OutputCase forNumber(int value) {
      switch (value) {
        case 4:
          return EXEC_RESOURCE_OUTPUT;
        case 0:
          return OUTPUT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OutputCase getOutputCase() {
    return OutputCase.forNumber(outputCase_);
  }

  public static final int OS_POLICY_RESOURCE_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object osPolicyResourceId_ = "";
  /**
   *
   *
   * <pre>
   * The id of the OS policy resource.
   * </pre>
   *
   * <code>string os_policy_resource_id = 1;</code>
   *
   * @return The osPolicyResourceId.
   */
  @java.lang.Override
  public java.lang.String getOsPolicyResourceId() {
    java.lang.Object ref = osPolicyResourceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      osPolicyResourceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The id of the OS policy resource.
   * </pre>
   *
   * <code>string os_policy_resource_id = 1;</code>
   *
   * @return The bytes for osPolicyResourceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOsPolicyResourceIdBytes() {
    java.lang.Object ref = osPolicyResourceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      osPolicyResourceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_STEPS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep> configSteps_;
  /**
   *
   *
   * <pre>
   * Ordered list of configuration steps taken by the agent for the OS policy
   * resource.
   * </pre>
   *
   * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep>
      getConfigStepsList() {
    return configSteps_;
  }
  /**
   *
   *
   * <pre>
   * Ordered list of configuration steps taken by the agent for the OS policy
   * resource.
   * </pre>
   *
   * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStepOrBuilder>
      getConfigStepsOrBuilderList() {
    return configSteps_;
  }
  /**
   *
   *
   * <pre>
   * Ordered list of configuration steps taken by the agent for the OS policy
   * resource.
   * </pre>
   *
   * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
   * </code>
   */
  @java.lang.Override
  public int getConfigStepsCount() {
    return configSteps_.size();
  }
  /**
   *
   *
   * <pre>
   * Ordered list of configuration steps taken by the agent for the OS policy
   * resource.
   * </pre>
   *
   * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep getConfigSteps(int index) {
    return configSteps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Ordered list of configuration steps taken by the agent for the OS policy
   * resource.
   * </pre>
   *
   * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStepOrBuilder
      getConfigStepsOrBuilder(int index) {
    return configSteps_.get(index);
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Compliance state of the OS policy resource.
   * </pre>
   *
   * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Compliance state of the OS policy resource.
   * </pre>
   *
   * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState getState() {
    com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState result =
        com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState.forNumber(state_);
    return result == null
        ? com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState.UNRECOGNIZED
        : result;
  }

  public static final int EXEC_RESOURCE_OUTPUT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * ExecResource specific output.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 4;
   * </code>
   *
   * @return Whether the execResourceOutput field is set.
   */
  @java.lang.Override
  public boolean hasExecResourceOutput() {
    return outputCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * ExecResource specific output.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 4;
   * </code>
   *
   * @return The execResourceOutput.
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
      getExecResourceOutput() {
    if (outputCase_ == 4) {
      return (com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)
          output_;
    }
    return com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * ExecResource specific output.
   * </pre>
   *
   * <code>
   * .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutputOrBuilder
      getExecResourceOutputOrBuilder() {
    if (outputCase_ == 4) {
      return (com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)
          output_;
    }
    return com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyResourceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, osPolicyResourceId_);
    }
    for (int i = 0; i < configSteps_.size(); i++) {
      output.writeMessage(2, configSteps_.get(i));
    }
    if (state_
        != com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState
            .OS_POLICY_COMPLIANCE_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, state_);
    }
    if (outputCase_ == 4) {
      output.writeMessage(
          4,
          (com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)
              output_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osPolicyResourceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, osPolicyResourceId_);
    }
    for (int i = 0; i < configSteps_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, configSteps_.get(i));
    }
    if (state_
        != com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState
            .OS_POLICY_COMPLIANCE_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (outputCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)
                  output_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance)) {
      return super.equals(obj);
    }
    com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance other =
        (com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance) obj;

    if (!getOsPolicyResourceId().equals(other.getOsPolicyResourceId())) return false;
    if (!getConfigStepsList().equals(other.getConfigStepsList())) return false;
    if (state_ != other.state_) return false;
    if (!getOutputCase().equals(other.getOutputCase())) return false;
    switch (outputCase_) {
      case 4:
        if (!getExecResourceOutput().equals(other.getExecResourceOutput())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + OS_POLICY_RESOURCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getOsPolicyResourceId().hashCode();
    if (getConfigStepsCount() > 0) {
      hash = (37 * hash) + CONFIG_STEPS_FIELD_NUMBER;
      hash = (53 * hash) + getConfigStepsList().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    switch (outputCase_) {
      case 4:
        hash = (37 * hash) + EXEC_RESOURCE_OUTPUT_FIELD_NUMBER;
        hash = (53 * hash) + getExecResourceOutput().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Compliance data for an OS policy resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance)
      com.google.cloud.osconfig.v1alpha.OSPolicyResourceComplianceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceCompliance_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceCompliance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.class,
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.Builder.class);
    }

    // Construct using com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      osPolicyResourceId_ = "";
      if (configStepsBuilder_ == null) {
        configSteps_ = java.util.Collections.emptyList();
      } else {
        configSteps_ = null;
        configStepsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      if (execResourceOutputBuilder_ != null) {
        execResourceOutputBuilder_.clear();
      }
      outputCase_ = 0;
      output_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceCompliance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance
        getDefaultInstanceForType() {
      return com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance build() {
      com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance buildPartial() {
      com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance result =
          new com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance result) {
      if (configStepsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          configSteps_ = java.util.Collections.unmodifiableList(configSteps_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.configSteps_ = configSteps_;
      } else {
        result.configSteps_ = configStepsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.osPolicyResourceId_ = osPolicyResourceId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = state_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance result) {
      result.outputCase_ = outputCase_;
      result.output_ = this.output_;
      if (outputCase_ == 4 && execResourceOutputBuilder_ != null) {
        result.output_ = execResourceOutputBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance) {
        return mergeFrom((com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance other) {
      if (other
          == com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.getDefaultInstance())
        return this;
      if (!other.getOsPolicyResourceId().isEmpty()) {
        osPolicyResourceId_ = other.osPolicyResourceId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (configStepsBuilder_ == null) {
        if (!other.configSteps_.isEmpty()) {
          if (configSteps_.isEmpty()) {
            configSteps_ = other.configSteps_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureConfigStepsIsMutable();
            configSteps_.addAll(other.configSteps_);
          }
          onChanged();
        }
      } else {
        if (!other.configSteps_.isEmpty()) {
          if (configStepsBuilder_.isEmpty()) {
            configStepsBuilder_.dispose();
            configStepsBuilder_ = null;
            configSteps_ = other.configSteps_;
            bitField0_ = (bitField0_ & ~0x00000002);
            configStepsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConfigStepsFieldBuilder()
                    : null;
          } else {
            configStepsBuilder_.addAllMessages(other.configSteps_);
          }
        }
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      switch (other.getOutputCase()) {
        case EXEC_RESOURCE_OUTPUT:
          {
            mergeExecResourceOutput(other.getExecResourceOutput());
            break;
          }
        case OUTPUT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                osPolicyResourceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep m =
                    input.readMessage(
                        com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.parser(),
                        extensionRegistry);
                if (configStepsBuilder_ == null) {
                  ensureConfigStepsIsMutable();
                  configSteps_.add(m);
                } else {
                  configStepsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(
                    getExecResourceOutputFieldBuilder().getBuilder(), extensionRegistry);
                outputCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int outputCase_ = 0;
    private java.lang.Object output_;

    public OutputCase getOutputCase() {
      return OutputCase.forNumber(outputCase_);
    }

    public Builder clearOutput() {
      outputCase_ = 0;
      output_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object osPolicyResourceId_ = "";
    /**
     *
     *
     * <pre>
     * The id of the OS policy resource.
     * </pre>
     *
     * <code>string os_policy_resource_id = 1;</code>
     *
     * @return The osPolicyResourceId.
     */
    public java.lang.String getOsPolicyResourceId() {
      java.lang.Object ref = osPolicyResourceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        osPolicyResourceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The id of the OS policy resource.
     * </pre>
     *
     * <code>string os_policy_resource_id = 1;</code>
     *
     * @return The bytes for osPolicyResourceId.
     */
    public com.google.protobuf.ByteString getOsPolicyResourceIdBytes() {
      java.lang.Object ref = osPolicyResourceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        osPolicyResourceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The id of the OS policy resource.
     * </pre>
     *
     * <code>string os_policy_resource_id = 1;</code>
     *
     * @param value The osPolicyResourceId to set.
     * @return This builder for chaining.
     */
    public Builder setOsPolicyResourceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      osPolicyResourceId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The id of the OS policy resource.
     * </pre>
     *
     * <code>string os_policy_resource_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOsPolicyResourceId() {
      osPolicyResourceId_ = getDefaultInstance().getOsPolicyResourceId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The id of the OS policy resource.
     * </pre>
     *
     * <code>string os_policy_resource_id = 1;</code>
     *
     * @param value The bytes for osPolicyResourceId to set.
     * @return This builder for chaining.
     */
    public Builder setOsPolicyResourceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      osPolicyResourceId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep>
        configSteps_ = java.util.Collections.emptyList();

    private void ensureConfigStepsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        configSteps_ =
            new java.util.ArrayList<com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep>(
                configSteps_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep,
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Builder,
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStepOrBuilder>
        configStepsBuilder_;

    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep>
        getConfigStepsList() {
      if (configStepsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(configSteps_);
      } else {
        return configStepsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public int getConfigStepsCount() {
      if (configStepsBuilder_ == null) {
        return configSteps_.size();
      } else {
        return configStepsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep getConfigSteps(int index) {
      if (configStepsBuilder_ == null) {
        return configSteps_.get(index);
      } else {
        return configStepsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public Builder setConfigSteps(
        int index, com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep value) {
      if (configStepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConfigStepsIsMutable();
        configSteps_.set(index, value);
        onChanged();
      } else {
        configStepsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public Builder setConfigSteps(
        int index,
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Builder builderForValue) {
      if (configStepsBuilder_ == null) {
        ensureConfigStepsIsMutable();
        configSteps_.set(index, builderForValue.build());
        onChanged();
      } else {
        configStepsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public Builder addConfigSteps(
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep value) {
      if (configStepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConfigStepsIsMutable();
        configSteps_.add(value);
        onChanged();
      } else {
        configStepsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public Builder addConfigSteps(
        int index, com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep value) {
      if (configStepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConfigStepsIsMutable();
        configSteps_.add(index, value);
        onChanged();
      } else {
        configStepsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public Builder addConfigSteps(
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Builder builderForValue) {
      if (configStepsBuilder_ == null) {
        ensureConfigStepsIsMutable();
        configSteps_.add(builderForValue.build());
        onChanged();
      } else {
        configStepsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public Builder addConfigSteps(
        int index,
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Builder builderForValue) {
      if (configStepsBuilder_ == null) {
        ensureConfigStepsIsMutable();
        configSteps_.add(index, builderForValue.build());
        onChanged();
      } else {
        configStepsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public Builder addAllConfigSteps(
        java.lang.Iterable<? extends com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep>
            values) {
      if (configStepsBuilder_ == null) {
        ensureConfigStepsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, configSteps_);
        onChanged();
      } else {
        configStepsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public Builder clearConfigSteps() {
      if (configStepsBuilder_ == null) {
        configSteps_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        configStepsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public Builder removeConfigSteps(int index) {
      if (configStepsBuilder_ == null) {
        ensureConfigStepsIsMutable();
        configSteps_.remove(index);
        onChanged();
      } else {
        configStepsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Builder
        getConfigStepsBuilder(int index) {
      return getConfigStepsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStepOrBuilder
        getConfigStepsOrBuilder(int index) {
      if (configStepsBuilder_ == null) {
        return configSteps_.get(index);
      } else {
        return configStepsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStepOrBuilder>
        getConfigStepsOrBuilderList() {
      if (configStepsBuilder_ != null) {
        return configStepsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(configSteps_);
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Builder
        addConfigStepsBuilder() {
      return getConfigStepsFieldBuilder()
          .addBuilder(
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Builder
        addConfigStepsBuilder(int index) {
      return getConfigStepsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Ordered list of configuration steps taken by the agent for the OS policy
     * resource.
     * </pre>
     *
     * <code>repeated .google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep config_steps = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Builder>
        getConfigStepsBuilderList() {
      return getConfigStepsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep,
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Builder,
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStepOrBuilder>
        getConfigStepsFieldBuilder() {
      if (configStepsBuilder_ == null) {
        configStepsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep,
                com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Builder,
                com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStepOrBuilder>(
                configSteps_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        configSteps_ = null;
      }
      return configStepsBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Compliance state of the OS policy resource.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Compliance state of the OS policy resource.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compliance state of the OS policy resource.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState getState() {
      com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState result =
          com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState.forNumber(state_);
      return result == null
          ? com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Compliance state of the OS policy resource.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.osconfig.v1alpha.OSPolicyComplianceState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compliance state of the OS policy resource.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyComplianceState state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput,
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput.Builder,
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance
                .ExecResourceOutputOrBuilder>
        execResourceOutputBuilder_;
    /**
     *
     *
     * <pre>
     * ExecResource specific output.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 4;
     * </code>
     *
     * @return Whether the execResourceOutput field is set.
     */
    @java.lang.Override
    public boolean hasExecResourceOutput() {
      return outputCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * ExecResource specific output.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 4;
     * </code>
     *
     * @return The execResourceOutput.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
        getExecResourceOutput() {
      if (execResourceOutputBuilder_ == null) {
        if (outputCase_ == 4) {
          return (com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)
              output_;
        }
        return com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
            .getDefaultInstance();
      } else {
        if (outputCase_ == 4) {
          return execResourceOutputBuilder_.getMessage();
        }
        return com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * ExecResource specific output.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 4;
     * </code>
     */
    public Builder setExecResourceOutput(
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput value) {
      if (execResourceOutputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        output_ = value;
        onChanged();
      } else {
        execResourceOutputBuilder_.setMessage(value);
      }
      outputCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * ExecResource specific output.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 4;
     * </code>
     */
    public Builder setExecResourceOutput(
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput.Builder
            builderForValue) {
      if (execResourceOutputBuilder_ == null) {
        output_ = builderForValue.build();
        onChanged();
      } else {
        execResourceOutputBuilder_.setMessage(builderForValue.build());
      }
      outputCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * ExecResource specific output.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 4;
     * </code>
     */
    public Builder mergeExecResourceOutput(
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput value) {
      if (execResourceOutputBuilder_ == null) {
        if (outputCase_ == 4
            && output_
                != com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
                    .getDefaultInstance()) {
          output_ =
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
                  .newBuilder(
                      (com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance
                              .ExecResourceOutput)
                          output_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          output_ = value;
        }
        onChanged();
      } else {
        if (outputCase_ == 4) {
          execResourceOutputBuilder_.mergeFrom(value);
        } else {
          execResourceOutputBuilder_.setMessage(value);
        }
      }
      outputCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * ExecResource specific output.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 4;
     * </code>
     */
    public Builder clearExecResourceOutput() {
      if (execResourceOutputBuilder_ == null) {
        if (outputCase_ == 4) {
          outputCase_ = 0;
          output_ = null;
          onChanged();
        }
      } else {
        if (outputCase_ == 4) {
          outputCase_ = 0;
          output_ = null;
        }
        execResourceOutputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * ExecResource specific output.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 4;
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput.Builder
        getExecResourceOutputBuilder() {
      return getExecResourceOutputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * ExecResource specific output.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutputOrBuilder
        getExecResourceOutputOrBuilder() {
      if ((outputCase_ == 4) && (execResourceOutputBuilder_ != null)) {
        return execResourceOutputBuilder_.getMessageOrBuilder();
      } else {
        if (outputCase_ == 4) {
          return (com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)
              output_;
        }
        return com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * ExecResource specific output.
     * </pre>
     *
     * <code>
     * .google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput exec_resource_output = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput,
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput.Builder,
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance
                .ExecResourceOutputOrBuilder>
        getExecResourceOutputFieldBuilder() {
      if (execResourceOutputBuilder_ == null) {
        if (!(outputCase_ == 4)) {
          output_ =
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
                  .getDefaultInstance();
        }
        execResourceOutputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput,
                com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput
                    .Builder,
                com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance
                    .ExecResourceOutputOrBuilder>(
                (com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance.ExecResourceOutput)
                    output_,
                getParentForChildren(),
                isClean());
        output_ = null;
      }
      outputCase_ = 4;
      onChanged();
      return execResourceOutputBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance)
  private static final com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance();
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OSPolicyResourceCompliance> PARSER =
      new com.google.protobuf.AbstractParser<OSPolicyResourceCompliance>() {
        @java.lang.Override
        public OSPolicyResourceCompliance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OSPolicyResourceCompliance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OSPolicyResourceCompliance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyResourceCompliance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
