/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1alpha/config_common.proto

package com.google.cloud.osconfig.v1alpha;

/**
 *
 *
 * <pre>
 * Step performed by the OS Config agent for configuring an `OSPolicyResource`
 * to its desired state.
 * </pre>
 *
 * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep}
 */
@java.lang.Deprecated
public final class OSPolicyResourceConfigStep extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep)
    OSPolicyResourceConfigStepOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OSPolicyResourceConfigStep.newBuilder() to construct.
  private OSPolicyResourceConfigStep(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OSPolicyResourceConfigStep() {
    type_ = 0;
    outcome_ = 0;
    errorMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OSPolicyResourceConfigStep();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
        .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceConfigStep_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
        .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceConfigStep_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.class,
            com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Supported configuration step types
   * </pre>
   *
   * Protobuf enum {@code google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type}
   */
  @java.lang.Deprecated
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Validation to detect resource conflicts, schema errors, etc.
     * </pre>
     *
     * <code>VALIDATION = 1;</code>
     */
    VALIDATION(1),
    /**
     *
     *
     * <pre>
     * Check the current desired state status of the resource.
     * </pre>
     *
     * <code>DESIRED_STATE_CHECK = 2;</code>
     */
    DESIRED_STATE_CHECK(2),
    /**
     *
     *
     * <pre>
     * Enforce the desired state for a resource that is not in desired state.
     * </pre>
     *
     * <code>DESIRED_STATE_ENFORCEMENT = 3;</code>
     */
    DESIRED_STATE_ENFORCEMENT(3),
    /**
     *
     *
     * <pre>
     * Re-check desired state status for a resource after enforcement of all
     * resources in the current configuration run.
     *
     * This step is used to determine the final desired state status for the
     * resource. It accounts for any resources that might have drifted from
     * their desired state due to side effects from configuring other resources
     * during the current configuration run.
     * </pre>
     *
     * <code>DESIRED_STATE_CHECK_POST_ENFORCEMENT = 4;</code>
     */
    DESIRED_STATE_CHECK_POST_ENFORCEMENT(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Validation to detect resource conflicts, schema errors, etc.
     * </pre>
     *
     * <code>VALIDATION = 1;</code>
     */
    public static final int VALIDATION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Check the current desired state status of the resource.
     * </pre>
     *
     * <code>DESIRED_STATE_CHECK = 2;</code>
     */
    public static final int DESIRED_STATE_CHECK_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Enforce the desired state for a resource that is not in desired state.
     * </pre>
     *
     * <code>DESIRED_STATE_ENFORCEMENT = 3;</code>
     */
    public static final int DESIRED_STATE_ENFORCEMENT_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Re-check desired state status for a resource after enforcement of all
     * resources in the current configuration run.
     *
     * This step is used to determine the final desired state status for the
     * resource. It accounts for any resources that might have drifted from
     * their desired state due to side effects from configuring other resources
     * during the current configuration run.
     * </pre>
     *
     * <code>DESIRED_STATE_CHECK_POST_ENFORCEMENT = 4;</code>
     */
    public static final int DESIRED_STATE_CHECK_POST_ENFORCEMENT_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return VALIDATION;
        case 2:
          return DESIRED_STATE_CHECK;
        case 3:
          return DESIRED_STATE_ENFORCEMENT;
        case 4:
          return DESIRED_STATE_CHECK_POST_ENFORCEMENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type)
  }

  /**
   *
   *
   * <pre>
   * Supported outcomes for a configuration step.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome}
   */
  @java.lang.Deprecated
  public enum Outcome implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>OUTCOME_UNSPECIFIED = 0;</code>
     */
    OUTCOME_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The step succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 1;</code>
     */
    SUCCEEDED(1),
    /**
     *
     *
     * <pre>
     * The step failed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    FAILED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>OUTCOME_UNSPECIFIED = 0;</code>
     */
    public static final int OUTCOME_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The step succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 1;</code>
     */
    public static final int SUCCEEDED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The step failed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    public static final int FAILED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Outcome valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Outcome forNumber(int value) {
      switch (value) {
        case 0:
          return OUTCOME_UNSPECIFIED;
        case 1:
          return SUCCEEDED;
        case 2:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Outcome> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Outcome> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Outcome>() {
          public Outcome findValueByNumber(int number) {
            return Outcome.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Outcome[] VALUES = values();

    public static Outcome valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Outcome(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome)
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Configuration step type.
   * </pre>
   *
   * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type type = 1;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Configuration step type.
   * </pre>
   *
   * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type getType() {
    com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type result =
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type.forNumber(type_);
    return result == null
        ? com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type.UNRECOGNIZED
        : result;
  }

  public static final int OUTCOME_FIELD_NUMBER = 2;
  private int outcome_ = 0;
  /**
   *
   *
   * <pre>
   * Outcome of the configuration step.
   * </pre>
   *
   * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome outcome = 2;</code>
   *
   * @return The enum numeric value on the wire for outcome.
   */
  @java.lang.Override
  public int getOutcomeValue() {
    return outcome_;
  }
  /**
   *
   *
   * <pre>
   * Outcome of the configuration step.
   * </pre>
   *
   * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome outcome = 2;</code>
   *
   * @return The outcome.
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome getOutcome() {
    com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome result =
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome.forNumber(outcome_);
    return result == null
        ? com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome.UNRECOGNIZED
        : result;
  }

  public static final int ERROR_MESSAGE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorMessage_ = "";
  /**
   *
   *
   * <pre>
   * An error message recorded during the execution of this step.
   * Only populated when outcome is FAILED.
   * </pre>
   *
   * <code>string error_message = 3;</code>
   *
   * @return The errorMessage.
   */
  @java.lang.Override
  public java.lang.String getErrorMessage() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An error message recorded during the execution of this step.
   * Only populated when outcome is FAILED.
   * </pre>
   *
   * <code>string error_message = 3;</code>
   *
   * @return The bytes for errorMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorMessageBytes() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_
        != com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, type_);
    }
    if (outcome_
        != com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome.OUTCOME_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, outcome_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, errorMessage_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_
        != com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    if (outcome_
        != com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome.OUTCOME_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, outcome_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, errorMessage_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep)) {
      return super.equals(obj);
    }
    com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep other =
        (com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep) obj;

    if (type_ != other.type_) return false;
    if (outcome_ != other.outcome_) return false;
    if (!getErrorMessage().equals(other.getErrorMessage())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + OUTCOME_FIELD_NUMBER;
    hash = (53 * hash) + outcome_;
    hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getErrorMessage().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Step performed by the OS Config agent for configuring an `OSPolicyResource`
   * to its desired state.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep)
      com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStepOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceConfigStep_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceConfigStep_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.class,
              com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Builder.class);
    }

    // Construct using com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      outcome_ = 0;
      errorMessage_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.osconfig.v1alpha.ConfigCommonProto
          .internal_static_google_cloud_osconfig_v1alpha_OSPolicyResourceConfigStep_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep
        getDefaultInstanceForType() {
      return com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep build() {
      com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep buildPartial() {
      com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep result =
          new com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.outcome_ = outcome_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.errorMessage_ = errorMessage_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep) {
        return mergeFrom((com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep other) {
      if (other
          == com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.getDefaultInstance())
        return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.outcome_ != 0) {
        setOutcomeValue(other.getOutcomeValue());
      }
      if (!other.getErrorMessage().isEmpty()) {
        errorMessage_ = other.errorMessage_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                outcome_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                errorMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Configuration step type.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Configuration step type.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type type = 1;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration step type.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type getType() {
      com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type result =
          com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Configuration step type.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration step type.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Type type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private int outcome_ = 0;
    /**
     *
     *
     * <pre>
     * Outcome of the configuration step.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome outcome = 2;</code>
     *
     * @return The enum numeric value on the wire for outcome.
     */
    @java.lang.Override
    public int getOutcomeValue() {
      return outcome_;
    }
    /**
     *
     *
     * <pre>
     * Outcome of the configuration step.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome outcome = 2;</code>
     *
     * @param value The enum numeric value on the wire for outcome to set.
     * @return This builder for chaining.
     */
    public Builder setOutcomeValue(int value) {
      outcome_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Outcome of the configuration step.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome outcome = 2;</code>
     *
     * @return The outcome.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome getOutcome() {
      com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome result =
          com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome.forNumber(outcome_);
      return result == null
          ? com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Outcome of the configuration step.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome outcome = 2;</code>
     *
     * @param value The outcome to set.
     * @return This builder for chaining.
     */
    public Builder setOutcome(
        com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      outcome_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Outcome of the configuration step.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep.Outcome outcome = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutcome() {
      bitField0_ = (bitField0_ & ~0x00000002);
      outcome_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * An error message recorded during the execution of this step.
     * Only populated when outcome is FAILED.
     * </pre>
     *
     * <code>string error_message = 3;</code>
     *
     * @return The errorMessage.
     */
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An error message recorded during the execution of this step.
     * Only populated when outcome is FAILED.
     * </pre>
     *
     * <code>string error_message = 3;</code>
     *
     * @return The bytes for errorMessage.
     */
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An error message recorded during the execution of this step.
     * Only populated when outcome is FAILED.
     * </pre>
     *
     * <code>string error_message = 3;</code>
     *
     * @param value The errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An error message recorded during the execution of this step.
     * Only populated when outcome is FAILED.
     * </pre>
     *
     * <code>string error_message = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorMessage() {
      errorMessage_ = getDefaultInstance().getErrorMessage();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An error message recorded during the execution of this step.
     * Only populated when outcome is FAILED.
     * </pre>
     *
     * <code>string error_message = 3;</code>
     *
     * @param value The bytes for errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep)
  private static final com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep();
  }

  public static com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OSPolicyResourceConfigStep> PARSER =
      new com.google.protobuf.AbstractParser<OSPolicyResourceConfigStep>() {
        @java.lang.Override
        public OSPolicyResourceConfigStep parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OSPolicyResourceConfigStep> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OSPolicyResourceConfigStep> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.OSPolicyResourceConfigStep getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
