/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/osconfig/v1alpha/vulnerability.proto

package com.google.cloud.osconfig.v1alpha;

/**
 *
 *
 * <pre>
 * This API resource represents the vulnerability report for a specified
 * Compute Engine virtual machine (VM) instance at a given point in time.
 *
 * For more information, see [Vulnerability
 * reports](https://cloud.google.com/compute/docs/instances/os-inventory-management#vulnerability-reports).
 * </pre>
 *
 * Protobuf type {@code google.cloud.osconfig.v1alpha.VulnerabilityReport}
 */
public final class VulnerabilityReport extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.VulnerabilityReport)
    VulnerabilityReportOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VulnerabilityReport.newBuilder() to construct.
  private VulnerabilityReport(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VulnerabilityReport() {
    name_ = "";
    vulnerabilities_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VulnerabilityReport();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
        .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
        .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.class,
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Builder.class);
  }

  public interface VulnerabilityOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Contains metadata as per the upstream feed of the operating system and
     * NVD.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
     * </code>
     *
     * @return Whether the details field is set.
     */
    boolean hasDetails();
    /**
     *
     *
     * <pre>
     * Contains metadata as per the upstream feed of the operating system and
     * NVD.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
     * </code>
     *
     * @return The details.
     */
    com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details getDetails();
    /**
     *
     *
     * <pre>
     * Contains metadata as per the upstream feed of the operating system and
     * NVD.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.DetailsOrBuilder
        getDetailsOrBuilder();

    /**
     *
     *
     * <pre>
     * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
     * This field displays the inventory items affected by this vulnerability.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. For some distros,
     * this field may be empty.
     * </pre>
     *
     * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
     * @return A list containing the installedInventoryItemIds.
     */
    @java.lang.Deprecated
    java.util.List<java.lang.String> getInstalledInventoryItemIdsList();
    /**
     *
     *
     * <pre>
     * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
     * This field displays the inventory items affected by this vulnerability.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. For some distros,
     * this field may be empty.
     * </pre>
     *
     * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
     * @return The count of installedInventoryItemIds.
     */
    @java.lang.Deprecated
    int getInstalledInventoryItemIdsCount();
    /**
     *
     *
     * <pre>
     * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
     * This field displays the inventory items affected by this vulnerability.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. For some distros,
     * this field may be empty.
     * </pre>
     *
     * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
     * @param index The index of the element to return.
     * @return The installedInventoryItemIds at the given index.
     */
    @java.lang.Deprecated
    java.lang.String getInstalledInventoryItemIds(int index);
    /**
     *
     *
     * <pre>
     * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
     * This field displays the inventory items affected by this vulnerability.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. For some distros,
     * this field may be empty.
     * </pre>
     *
     * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
     * @param index The index of the value to return.
     * @return The bytes of the installedInventoryItemIds at the given index.
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getInstalledInventoryItemIdsBytes(int index);

    /**
     *
     *
     * <pre>
     * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. If there is no
     * available fix, the field is empty. The `inventory_item` value specifies
     * the latest `SoftwarePackage` available to the VM that fixes the
     * vulnerability.
     * </pre>
     *
     * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
     * @return A list containing the availableInventoryItemIds.
     */
    @java.lang.Deprecated
    java.util.List<java.lang.String> getAvailableInventoryItemIdsList();
    /**
     *
     *
     * <pre>
     * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. If there is no
     * available fix, the field is empty. The `inventory_item` value specifies
     * the latest `SoftwarePackage` available to the VM that fixes the
     * vulnerability.
     * </pre>
     *
     * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
     * @return The count of availableInventoryItemIds.
     */
    @java.lang.Deprecated
    int getAvailableInventoryItemIdsCount();
    /**
     *
     *
     * <pre>
     * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. If there is no
     * available fix, the field is empty. The `inventory_item` value specifies
     * the latest `SoftwarePackage` available to the VM that fixes the
     * vulnerability.
     * </pre>
     *
     * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
     * @param index The index of the element to return.
     * @return The availableInventoryItemIds at the given index.
     */
    @java.lang.Deprecated
    java.lang.String getAvailableInventoryItemIds(int index);
    /**
     *
     *
     * <pre>
     * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. If there is no
     * available fix, the field is empty. The `inventory_item` value specifies
     * the latest `SoftwarePackage` available to the VM that fixes the
     * vulnerability.
     * </pre>
     *
     * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
     * @param index The index of the value to return.
     * @return The bytes of the availableInventoryItemIds at the given index.
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getAvailableInventoryItemIdsBytes(int index);

    /**
     *
     *
     * <pre>
     * The timestamp for when the vulnerability was first detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return Whether the createTime field is set.
     */
    boolean hasCreateTime();
    /**
     *
     *
     * <pre>
     * The timestamp for when the vulnerability was first detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return The createTime.
     */
    com.google.protobuf.Timestamp getCreateTime();
    /**
     *
     *
     * <pre>
     * The timestamp for when the vulnerability was first detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The timestamp for when the vulnerability was last modified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     *
     * @return Whether the updateTime field is set.
     */
    boolean hasUpdateTime();
    /**
     *
     *
     * <pre>
     * The timestamp for when the vulnerability was last modified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     *
     * @return The updateTime.
     */
    com.google.protobuf.Timestamp getUpdateTime();
    /**
     *
     *
     * <pre>
     * The timestamp for when the vulnerability was last modified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * List of items affected by the vulnerability.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
     * </code>
     */
    java.util.List<com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item>
        getItemsList();
    /**
     *
     *
     * <pre>
     * List of items affected by the vulnerability.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item getItems(int index);
    /**
     *
     *
     * <pre>
     * List of items affected by the vulnerability.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
     * </code>
     */
    int getItemsCount();
    /**
     *
     *
     * <pre>
     * List of items affected by the vulnerability.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.ItemOrBuilder>
        getItemsOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of items affected by the vulnerability.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
     * </code>
     */
    com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.ItemOrBuilder
        getItemsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A vulnerability affecting the VM instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability}
   */
  public static final class Vulnerability extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability)
      VulnerabilityOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Vulnerability.newBuilder() to construct.
    private Vulnerability(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Vulnerability() {
      installedInventoryItemIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      availableInventoryItemIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      items_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Vulnerability();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
          .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
          .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.class,
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Builder.class);
    }

    public interface DetailsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The CVE of the vulnerability. CVE cannot be
       * empty and the combination of &lt;cve, classification&gt; should be unique
       * across vulnerabilities for a VM.
       * </pre>
       *
       * <code>string cve = 1;</code>
       *
       * @return The cve.
       */
      java.lang.String getCve();
      /**
       *
       *
       * <pre>
       * The CVE of the vulnerability. CVE cannot be
       * empty and the combination of &lt;cve, classification&gt; should be unique
       * across vulnerabilities for a VM.
       * </pre>
       *
       * <code>string cve = 1;</code>
       *
       * @return The bytes for cve.
       */
      com.google.protobuf.ByteString getCveBytes();

      /**
       *
       *
       * <pre>
       * The CVSS V2 score of this vulnerability. CVSS V2 score is on a scale of
       * 0 - 10 where 0 indicates low severity and 10 indicates high severity.
       * </pre>
       *
       * <code>float cvss_v2_score = 2;</code>
       *
       * @return The cvssV2Score.
       */
      float getCvssV2Score();

      /**
       *
       *
       * <pre>
       * The full description of the CVSSv3 for this vulnerability from NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
       *
       * @return Whether the cvssV3 field is set.
       */
      boolean hasCvssV3();
      /**
       *
       *
       * <pre>
       * The full description of the CVSSv3 for this vulnerability from NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
       *
       * @return The cvssV3.
       */
      com.google.cloud.osconfig.v1alpha.CVSSv3 getCvssV3();
      /**
       *
       *
       * <pre>
       * The full description of the CVSSv3 for this vulnerability from NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
       */
      com.google.cloud.osconfig.v1alpha.CVSSv3OrBuilder getCvssV3OrBuilder();

      /**
       *
       *
       * <pre>
       * Assigned severity/impact ranking from the distro.
       * </pre>
       *
       * <code>string severity = 4;</code>
       *
       * @return The severity.
       */
      java.lang.String getSeverity();
      /**
       *
       *
       * <pre>
       * Assigned severity/impact ranking from the distro.
       * </pre>
       *
       * <code>string severity = 4;</code>
       *
       * @return The bytes for severity.
       */
      com.google.protobuf.ByteString getSeverityBytes();

      /**
       *
       *
       * <pre>
       * The note or description describing the vulnerability from the distro.
       * </pre>
       *
       * <code>string description = 5;</code>
       *
       * @return The description.
       */
      java.lang.String getDescription();
      /**
       *
       *
       * <pre>
       * The note or description describing the vulnerability from the distro.
       * </pre>
       *
       * <code>string description = 5;</code>
       *
       * @return The bytes for description.
       */
      com.google.protobuf.ByteString getDescriptionBytes();

      /**
       *
       *
       * <pre>
       * Corresponds to the references attached to the `VulnerabilityDetails`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
       * </code>
       */
      java.util.List<
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference>
          getReferencesList();
      /**
       *
       *
       * <pre>
       * Corresponds to the references attached to the `VulnerabilityDetails`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
       * </code>
       */
      com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
          getReferences(int index);
      /**
       *
       *
       * <pre>
       * Corresponds to the references attached to the `VulnerabilityDetails`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
       * </code>
       */
      int getReferencesCount();
      /**
       *
       *
       * <pre>
       * Corresponds to the references attached to the `VulnerabilityDetails`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                      .ReferenceOrBuilder>
          getReferencesOrBuilderList();
      /**
       *
       *
       * <pre>
       * Corresponds to the references attached to the `VulnerabilityDetails`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
       * </code>
       */
      com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.ReferenceOrBuilder
          getReferencesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Contains metadata information for the vulnerability. This information is
     * collected from the upstream feed of the operating system.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details}
     */
    public static final class Details extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details)
        DetailsOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Details.newBuilder() to construct.
      private Details(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Details() {
        cve_ = "";
        severity_ = "";
        description_ = "";
        references_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Details();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
            .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Details_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
            .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Details_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.class,
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Builder
                    .class);
      }

      public interface ReferenceOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * The url of the reference.
         * </pre>
         *
         * <code>string url = 1;</code>
         *
         * @return The url.
         */
        java.lang.String getUrl();
        /**
         *
         *
         * <pre>
         * The url of the reference.
         * </pre>
         *
         * <code>string url = 1;</code>
         *
         * @return The bytes for url.
         */
        com.google.protobuf.ByteString getUrlBytes();

        /**
         *
         *
         * <pre>
         * The source of the reference e.g. NVD.
         * </pre>
         *
         * <code>string source = 2;</code>
         *
         * @return The source.
         */
        java.lang.String getSource();
        /**
         *
         *
         * <pre>
         * The source of the reference e.g. NVD.
         * </pre>
         *
         * <code>string source = 2;</code>
         *
         * @return The bytes for source.
         */
        com.google.protobuf.ByteString getSourceBytes();
      }
      /**
       *
       *
       * <pre>
       * A reference for this vulnerability.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference}
       */
      public static final class Reference extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference)
          ReferenceOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Reference.newBuilder() to construct.
        private Reference(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Reference() {
          url_ = "";
          source_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Reference();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
              .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Details_Reference_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
              .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Details_Reference_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                      .Reference.class,
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                      .Reference.Builder.class);
        }

        public static final int URL_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object url_ = "";
        /**
         *
         *
         * <pre>
         * The url of the reference.
         * </pre>
         *
         * <code>string url = 1;</code>
         *
         * @return The url.
         */
        @java.lang.Override
        public java.lang.String getUrl() {
          java.lang.Object ref = url_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            url_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The url of the reference.
         * </pre>
         *
         * <code>string url = 1;</code>
         *
         * @return The bytes for url.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getUrlBytes() {
          java.lang.Object ref = url_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            url_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int SOURCE_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object source_ = "";
        /**
         *
         *
         * <pre>
         * The source of the reference e.g. NVD.
         * </pre>
         *
         * <code>string source = 2;</code>
         *
         * @return The source.
         */
        @java.lang.Override
        public java.lang.String getSource() {
          java.lang.Object ref = source_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            source_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The source of the reference e.g. NVD.
         * </pre>
         *
         * <code>string source = 2;</code>
         *
         * @return The bytes for source.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getSourceBytes() {
          java.lang.Object ref = source_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            source_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, url_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, source_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, url_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, source_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                  .Reference)) {
            return super.equals(obj);
          }
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
              other =
                  (com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                          .Reference)
                      obj;

          if (!getUrl().equals(other.getUrl())) return false;
          if (!getSource().equals(other.getSource())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + URL_FIELD_NUMBER;
          hash = (53 * hash) + getUrl().hashCode();
          hash = (37 * hash) + SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getSource().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A reference for this vulnerability.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference)
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .ReferenceOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
                .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Details_Reference_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
                .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Details_Reference_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                        .Reference.class,
                    com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                        .Reference.Builder.class);
          }

          // Construct using
          // com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            url_ = "";
            source_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
                .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Details_Reference_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                  .Reference
              getDefaultInstanceForType() {
            return com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                  .Reference
              build() {
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                  .Reference
              buildPartial() {
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                result =
                    new com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                        .Reference(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.url_ = url_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.source_ = source_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                    .Reference) {
              return mergeFrom(
                  (com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                          .Reference)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                  other) {
            if (other
                == com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                    .Reference.getDefaultInstance()) return this;
            if (!other.getUrl().isEmpty()) {
              url_ = other.url_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getSource().isEmpty()) {
              source_ = other.source_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      url_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      source_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object url_ = "";
          /**
           *
           *
           * <pre>
           * The url of the reference.
           * </pre>
           *
           * <code>string url = 1;</code>
           *
           * @return The url.
           */
          public java.lang.String getUrl() {
            java.lang.Object ref = url_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              url_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The url of the reference.
           * </pre>
           *
           * <code>string url = 1;</code>
           *
           * @return The bytes for url.
           */
          public com.google.protobuf.ByteString getUrlBytes() {
            java.lang.Object ref = url_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              url_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The url of the reference.
           * </pre>
           *
           * <code>string url = 1;</code>
           *
           * @param value The url to set.
           * @return This builder for chaining.
           */
          public Builder setUrl(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            url_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The url of the reference.
           * </pre>
           *
           * <code>string url = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearUrl() {
            url_ = getDefaultInstance().getUrl();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The url of the reference.
           * </pre>
           *
           * <code>string url = 1;</code>
           *
           * @param value The bytes for url to set.
           * @return This builder for chaining.
           */
          public Builder setUrlBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            url_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object source_ = "";
          /**
           *
           *
           * <pre>
           * The source of the reference e.g. NVD.
           * </pre>
           *
           * <code>string source = 2;</code>
           *
           * @return The source.
           */
          public java.lang.String getSource() {
            java.lang.Object ref = source_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              source_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The source of the reference e.g. NVD.
           * </pre>
           *
           * <code>string source = 2;</code>
           *
           * @return The bytes for source.
           */
          public com.google.protobuf.ByteString getSourceBytes() {
            java.lang.Object ref = source_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              source_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The source of the reference e.g. NVD.
           * </pre>
           *
           * <code>string source = 2;</code>
           *
           * @param value The source to set.
           * @return This builder for chaining.
           */
          public Builder setSource(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            source_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The source of the reference e.g. NVD.
           * </pre>
           *
           * <code>string source = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearSource() {
            source_ = getDefaultInstance().getSource();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The source of the reference e.g. NVD.
           * </pre>
           *
           * <code>string source = 2;</code>
           *
           * @param value The bytes for source to set.
           * @return This builder for chaining.
           */
          public Builder setSourceBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            source_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference)
        private static final com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
                .Details.Reference
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                  .Reference();
        }

        public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .Reference
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Reference> PARSER =
            new com.google.protobuf.AbstractParser<Reference>() {
              @java.lang.Override
              public Reference parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Reference> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Reference> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int CVE_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object cve_ = "";
      /**
       *
       *
       * <pre>
       * The CVE of the vulnerability. CVE cannot be
       * empty and the combination of &lt;cve, classification&gt; should be unique
       * across vulnerabilities for a VM.
       * </pre>
       *
       * <code>string cve = 1;</code>
       *
       * @return The cve.
       */
      @java.lang.Override
      public java.lang.String getCve() {
        java.lang.Object ref = cve_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          cve_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The CVE of the vulnerability. CVE cannot be
       * empty and the combination of &lt;cve, classification&gt; should be unique
       * across vulnerabilities for a VM.
       * </pre>
       *
       * <code>string cve = 1;</code>
       *
       * @return The bytes for cve.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getCveBytes() {
        java.lang.Object ref = cve_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          cve_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CVSS_V2_SCORE_FIELD_NUMBER = 2;
      private float cvssV2Score_ = 0F;
      /**
       *
       *
       * <pre>
       * The CVSS V2 score of this vulnerability. CVSS V2 score is on a scale of
       * 0 - 10 where 0 indicates low severity and 10 indicates high severity.
       * </pre>
       *
       * <code>float cvss_v2_score = 2;</code>
       *
       * @return The cvssV2Score.
       */
      @java.lang.Override
      public float getCvssV2Score() {
        return cvssV2Score_;
      }

      public static final int CVSS_V3_FIELD_NUMBER = 3;
      private com.google.cloud.osconfig.v1alpha.CVSSv3 cvssV3_;
      /**
       *
       *
       * <pre>
       * The full description of the CVSSv3 for this vulnerability from NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
       *
       * @return Whether the cvssV3 field is set.
       */
      @java.lang.Override
      public boolean hasCvssV3() {
        return cvssV3_ != null;
      }
      /**
       *
       *
       * <pre>
       * The full description of the CVSSv3 for this vulnerability from NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
       *
       * @return The cvssV3.
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.CVSSv3 getCvssV3() {
        return cvssV3_ == null
            ? com.google.cloud.osconfig.v1alpha.CVSSv3.getDefaultInstance()
            : cvssV3_;
      }
      /**
       *
       *
       * <pre>
       * The full description of the CVSSv3 for this vulnerability from NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.CVSSv3OrBuilder getCvssV3OrBuilder() {
        return cvssV3_ == null
            ? com.google.cloud.osconfig.v1alpha.CVSSv3.getDefaultInstance()
            : cvssV3_;
      }

      public static final int SEVERITY_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object severity_ = "";
      /**
       *
       *
       * <pre>
       * Assigned severity/impact ranking from the distro.
       * </pre>
       *
       * <code>string severity = 4;</code>
       *
       * @return The severity.
       */
      @java.lang.Override
      public java.lang.String getSeverity() {
        java.lang.Object ref = severity_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          severity_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Assigned severity/impact ranking from the distro.
       * </pre>
       *
       * <code>string severity = 4;</code>
       *
       * @return The bytes for severity.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSeverityBytes() {
        java.lang.Object ref = severity_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          severity_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DESCRIPTION_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private volatile java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * The note or description describing the vulnerability from the distro.
       * </pre>
       *
       * <code>string description = 5;</code>
       *
       * @return The description.
       */
      @java.lang.Override
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The note or description describing the vulnerability from the distro.
       * </pre>
       *
       * <code>string description = 5;</code>
       *
       * @return The bytes for description.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int REFERENCES_FIELD_NUMBER = 6;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference>
          references_;
      /**
       *
       *
       * <pre>
       * Corresponds to the references attached to the `VulnerabilityDetails`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference>
          getReferencesList() {
        return references_;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the references attached to the `VulnerabilityDetails`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                      .ReferenceOrBuilder>
          getReferencesOrBuilderList() {
        return references_;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the references attached to the `VulnerabilityDetails`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
       * </code>
       */
      @java.lang.Override
      public int getReferencesCount() {
        return references_.size();
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the references attached to the `VulnerabilityDetails`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
          getReferences(int index) {
        return references_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the references attached to the `VulnerabilityDetails`.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
              .ReferenceOrBuilder
          getReferencesOrBuilder(int index) {
        return references_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cve_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, cve_);
        }
        if (java.lang.Float.floatToRawIntBits(cvssV2Score_) != 0) {
          output.writeFloat(2, cvssV2Score_);
        }
        if (cvssV3_ != null) {
          output.writeMessage(3, getCvssV3());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(severity_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, severity_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
        }
        for (int i = 0; i < references_.size(); i++) {
          output.writeMessage(6, references_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cve_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, cve_);
        }
        if (java.lang.Float.floatToRawIntBits(cvssV2Score_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, cvssV2Score_);
        }
        if (cvssV3_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCvssV3());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(severity_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, severity_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
        }
        for (int i = 0; i < references_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, references_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details)) {
          return super.equals(obj);
        }
        com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details other =
            (com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details) obj;

        if (!getCve().equals(other.getCve())) return false;
        if (java.lang.Float.floatToIntBits(getCvssV2Score())
            != java.lang.Float.floatToIntBits(other.getCvssV2Score())) return false;
        if (hasCvssV3() != other.hasCvssV3()) return false;
        if (hasCvssV3()) {
          if (!getCvssV3().equals(other.getCvssV3())) return false;
        }
        if (!getSeverity().equals(other.getSeverity())) return false;
        if (!getDescription().equals(other.getDescription())) return false;
        if (!getReferencesList().equals(other.getReferencesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CVE_FIELD_NUMBER;
        hash = (53 * hash) + getCve().hashCode();
        hash = (37 * hash) + CVSS_V2_SCORE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getCvssV2Score());
        if (hasCvssV3()) {
          hash = (37 * hash) + CVSS_V3_FIELD_NUMBER;
          hash = (53 * hash) + getCvssV3().hashCode();
        }
        hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
        hash = (53 * hash) + getSeverity().hashCode();
        hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
        hash = (53 * hash) + getDescription().hashCode();
        if (getReferencesCount() > 0) {
          hash = (37 * hash) + REFERENCES_FIELD_NUMBER;
          hash = (53 * hash) + getReferencesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Contains metadata information for the vulnerability. This information is
       * collected from the upstream feed of the operating system.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details)
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.DetailsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
              .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Details_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
              .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Details_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.class,
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          cve_ = "";
          cvssV2Score_ = 0F;
          cvssV3_ = null;
          if (cvssV3Builder_ != null) {
            cvssV3Builder_.dispose();
            cvssV3Builder_ = null;
          }
          severity_ = "";
          description_ = "";
          if (referencesBuilder_ == null) {
            references_ = java.util.Collections.emptyList();
          } else {
            references_ = null;
            referencesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000020);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
              .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Details_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
            getDefaultInstanceForType() {
          return com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details build() {
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
            buildPartial() {
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details result =
              new com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details result) {
          if (referencesBuilder_ == null) {
            if (((bitField0_ & 0x00000020) != 0)) {
              references_ = java.util.Collections.unmodifiableList(references_);
              bitField0_ = (bitField0_ & ~0x00000020);
            }
            result.references_ = references_;
          } else {
            result.references_ = referencesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.cve_ = cve_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.cvssV2Score_ = cvssV2Score_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.cvssV3_ = cvssV3Builder_ == null ? cvssV3_ : cvssV3Builder_.build();
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.severity_ = severity_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.description_ = description_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details) {
            return mergeFrom(
                (com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details other) {
          if (other
              == com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                  .getDefaultInstance()) return this;
          if (!other.getCve().isEmpty()) {
            cve_ = other.cve_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getCvssV2Score() != 0F) {
            setCvssV2Score(other.getCvssV2Score());
          }
          if (other.hasCvssV3()) {
            mergeCvssV3(other.getCvssV3());
          }
          if (!other.getSeverity().isEmpty()) {
            severity_ = other.severity_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          if (!other.getDescription().isEmpty()) {
            description_ = other.description_;
            bitField0_ |= 0x00000010;
            onChanged();
          }
          if (referencesBuilder_ == null) {
            if (!other.references_.isEmpty()) {
              if (references_.isEmpty()) {
                references_ = other.references_;
                bitField0_ = (bitField0_ & ~0x00000020);
              } else {
                ensureReferencesIsMutable();
                references_.addAll(other.references_);
              }
              onChanged();
            }
          } else {
            if (!other.references_.isEmpty()) {
              if (referencesBuilder_.isEmpty()) {
                referencesBuilder_.dispose();
                referencesBuilder_ = null;
                references_ = other.references_;
                bitField0_ = (bitField0_ & ~0x00000020);
                referencesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getReferencesFieldBuilder()
                        : null;
              } else {
                referencesBuilder_.addAllMessages(other.references_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    cve_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 21:
                  {
                    cvssV2Score_ = input.readFloat();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 21
                case 26:
                  {
                    input.readMessage(getCvssV3FieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    severity_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                case 42:
                  {
                    description_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 42
                case 50:
                  {
                    com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                            .Reference
                        m =
                            input.readMessage(
                                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
                                    .Details.Reference.parser(),
                                extensionRegistry);
                    if (referencesBuilder_ == null) {
                      ensureReferencesIsMutable();
                      references_.add(m);
                    } else {
                      referencesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 50
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object cve_ = "";
        /**
         *
         *
         * <pre>
         * The CVE of the vulnerability. CVE cannot be
         * empty and the combination of &lt;cve, classification&gt; should be unique
         * across vulnerabilities for a VM.
         * </pre>
         *
         * <code>string cve = 1;</code>
         *
         * @return The cve.
         */
        public java.lang.String getCve() {
          java.lang.Object ref = cve_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            cve_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The CVE of the vulnerability. CVE cannot be
         * empty and the combination of &lt;cve, classification&gt; should be unique
         * across vulnerabilities for a VM.
         * </pre>
         *
         * <code>string cve = 1;</code>
         *
         * @return The bytes for cve.
         */
        public com.google.protobuf.ByteString getCveBytes() {
          java.lang.Object ref = cve_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            cve_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The CVE of the vulnerability. CVE cannot be
         * empty and the combination of &lt;cve, classification&gt; should be unique
         * across vulnerabilities for a VM.
         * </pre>
         *
         * <code>string cve = 1;</code>
         *
         * @param value The cve to set.
         * @return This builder for chaining.
         */
        public Builder setCve(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          cve_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The CVE of the vulnerability. CVE cannot be
         * empty and the combination of &lt;cve, classification&gt; should be unique
         * across vulnerabilities for a VM.
         * </pre>
         *
         * <code>string cve = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCve() {
          cve_ = getDefaultInstance().getCve();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The CVE of the vulnerability. CVE cannot be
         * empty and the combination of &lt;cve, classification&gt; should be unique
         * across vulnerabilities for a VM.
         * </pre>
         *
         * <code>string cve = 1;</code>
         *
         * @param value The bytes for cve to set.
         * @return This builder for chaining.
         */
        public Builder setCveBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          cve_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private float cvssV2Score_;
        /**
         *
         *
         * <pre>
         * The CVSS V2 score of this vulnerability. CVSS V2 score is on a scale of
         * 0 - 10 where 0 indicates low severity and 10 indicates high severity.
         * </pre>
         *
         * <code>float cvss_v2_score = 2;</code>
         *
         * @return The cvssV2Score.
         */
        @java.lang.Override
        public float getCvssV2Score() {
          return cvssV2Score_;
        }
        /**
         *
         *
         * <pre>
         * The CVSS V2 score of this vulnerability. CVSS V2 score is on a scale of
         * 0 - 10 where 0 indicates low severity and 10 indicates high severity.
         * </pre>
         *
         * <code>float cvss_v2_score = 2;</code>
         *
         * @param value The cvssV2Score to set.
         * @return This builder for chaining.
         */
        public Builder setCvssV2Score(float value) {

          cvssV2Score_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The CVSS V2 score of this vulnerability. CVSS V2 score is on a scale of
         * 0 - 10 where 0 indicates low severity and 10 indicates high severity.
         * </pre>
         *
         * <code>float cvss_v2_score = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCvssV2Score() {
          bitField0_ = (bitField0_ & ~0x00000002);
          cvssV2Score_ = 0F;
          onChanged();
          return this;
        }

        private com.google.cloud.osconfig.v1alpha.CVSSv3 cvssV3_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1alpha.CVSSv3,
                com.google.cloud.osconfig.v1alpha.CVSSv3.Builder,
                com.google.cloud.osconfig.v1alpha.CVSSv3OrBuilder>
            cvssV3Builder_;
        /**
         *
         *
         * <pre>
         * The full description of the CVSSv3 for this vulnerability from NVD.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
         *
         * @return Whether the cvssV3 field is set.
         */
        public boolean hasCvssV3() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * The full description of the CVSSv3 for this vulnerability from NVD.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
         *
         * @return The cvssV3.
         */
        public com.google.cloud.osconfig.v1alpha.CVSSv3 getCvssV3() {
          if (cvssV3Builder_ == null) {
            return cvssV3_ == null
                ? com.google.cloud.osconfig.v1alpha.CVSSv3.getDefaultInstance()
                : cvssV3_;
          } else {
            return cvssV3Builder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The full description of the CVSSv3 for this vulnerability from NVD.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
         */
        public Builder setCvssV3(com.google.cloud.osconfig.v1alpha.CVSSv3 value) {
          if (cvssV3Builder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            cvssV3_ = value;
          } else {
            cvssV3Builder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full description of the CVSSv3 for this vulnerability from NVD.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
         */
        public Builder setCvssV3(com.google.cloud.osconfig.v1alpha.CVSSv3.Builder builderForValue) {
          if (cvssV3Builder_ == null) {
            cvssV3_ = builderForValue.build();
          } else {
            cvssV3Builder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full description of the CVSSv3 for this vulnerability from NVD.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
         */
        public Builder mergeCvssV3(com.google.cloud.osconfig.v1alpha.CVSSv3 value) {
          if (cvssV3Builder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && cvssV3_ != null
                && cvssV3_ != com.google.cloud.osconfig.v1alpha.CVSSv3.getDefaultInstance()) {
              getCvssV3Builder().mergeFrom(value);
            } else {
              cvssV3_ = value;
            }
          } else {
            cvssV3Builder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full description of the CVSSv3 for this vulnerability from NVD.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
         */
        public Builder clearCvssV3() {
          bitField0_ = (bitField0_ & ~0x00000004);
          cvssV3_ = null;
          if (cvssV3Builder_ != null) {
            cvssV3Builder_.dispose();
            cvssV3Builder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The full description of the CVSSv3 for this vulnerability from NVD.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
         */
        public com.google.cloud.osconfig.v1alpha.CVSSv3.Builder getCvssV3Builder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getCvssV3FieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The full description of the CVSSv3 for this vulnerability from NVD.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
         */
        public com.google.cloud.osconfig.v1alpha.CVSSv3OrBuilder getCvssV3OrBuilder() {
          if (cvssV3Builder_ != null) {
            return cvssV3Builder_.getMessageOrBuilder();
          } else {
            return cvssV3_ == null
                ? com.google.cloud.osconfig.v1alpha.CVSSv3.getDefaultInstance()
                : cvssV3_;
          }
        }
        /**
         *
         *
         * <pre>
         * The full description of the CVSSv3 for this vulnerability from NVD.
         * </pre>
         *
         * <code>.google.cloud.osconfig.v1alpha.CVSSv3 cvss_v3 = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.osconfig.v1alpha.CVSSv3,
                com.google.cloud.osconfig.v1alpha.CVSSv3.Builder,
                com.google.cloud.osconfig.v1alpha.CVSSv3OrBuilder>
            getCvssV3FieldBuilder() {
          if (cvssV3Builder_ == null) {
            cvssV3Builder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.osconfig.v1alpha.CVSSv3,
                    com.google.cloud.osconfig.v1alpha.CVSSv3.Builder,
                    com.google.cloud.osconfig.v1alpha.CVSSv3OrBuilder>(
                    getCvssV3(), getParentForChildren(), isClean());
            cvssV3_ = null;
          }
          return cvssV3Builder_;
        }

        private java.lang.Object severity_ = "";
        /**
         *
         *
         * <pre>
         * Assigned severity/impact ranking from the distro.
         * </pre>
         *
         * <code>string severity = 4;</code>
         *
         * @return The severity.
         */
        public java.lang.String getSeverity() {
          java.lang.Object ref = severity_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            severity_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Assigned severity/impact ranking from the distro.
         * </pre>
         *
         * <code>string severity = 4;</code>
         *
         * @return The bytes for severity.
         */
        public com.google.protobuf.ByteString getSeverityBytes() {
          java.lang.Object ref = severity_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            severity_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Assigned severity/impact ranking from the distro.
         * </pre>
         *
         * <code>string severity = 4;</code>
         *
         * @param value The severity to set.
         * @return This builder for chaining.
         */
        public Builder setSeverity(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          severity_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Assigned severity/impact ranking from the distro.
         * </pre>
         *
         * <code>string severity = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSeverity() {
          severity_ = getDefaultInstance().getSeverity();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Assigned severity/impact ranking from the distro.
         * </pre>
         *
         * <code>string severity = 4;</code>
         *
         * @param value The bytes for severity to set.
         * @return This builder for chaining.
         */
        public Builder setSeverityBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          severity_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private java.lang.Object description_ = "";
        /**
         *
         *
         * <pre>
         * The note or description describing the vulnerability from the distro.
         * </pre>
         *
         * <code>string description = 5;</code>
         *
         * @return The description.
         */
        public java.lang.String getDescription() {
          java.lang.Object ref = description_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            description_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The note or description describing the vulnerability from the distro.
         * </pre>
         *
         * <code>string description = 5;</code>
         *
         * @return The bytes for description.
         */
        public com.google.protobuf.ByteString getDescriptionBytes() {
          java.lang.Object ref = description_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            description_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The note or description describing the vulnerability from the distro.
         * </pre>
         *
         * <code>string description = 5;</code>
         *
         * @param value The description to set.
         * @return This builder for chaining.
         */
        public Builder setDescription(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          description_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The note or description describing the vulnerability from the distro.
         * </pre>
         *
         * <code>string description = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDescription() {
          description_ = getDefaultInstance().getDescription();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The note or description describing the vulnerability from the distro.
         * </pre>
         *
         * <code>string description = 5;</code>
         *
         * @param value The bytes for description to set.
         * @return This builder for chaining.
         */
        public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          description_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                    .Reference>
            references_ = java.util.Collections.emptyList();

        private void ensureReferencesIsMutable() {
          if (!((bitField0_ & 0x00000020) != 0)) {
            references_ =
                new java.util.ArrayList<
                    com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                        .Reference>(references_);
            bitField0_ |= 0x00000020;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                    .Reference,
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                    .Reference.Builder,
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                    .ReferenceOrBuilder>
            referencesBuilder_;

        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public java.util.List<
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                    .Reference>
            getReferencesList() {
          if (referencesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(references_);
          } else {
            return referencesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public int getReferencesCount() {
          if (referencesBuilder_ == null) {
            return references_.size();
          } else {
            return referencesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
            getReferences(int index) {
          if (referencesBuilder_ == null) {
            return references_.get(index);
          } else {
            return referencesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public Builder setReferences(
            int index,
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                value) {
          if (referencesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureReferencesIsMutable();
            references_.set(index, value);
            onChanged();
          } else {
            referencesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public Builder setReferences(
            int index,
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                    .Builder
                builderForValue) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            references_.set(index, builderForValue.build());
            onChanged();
          } else {
            referencesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public Builder addReferences(
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                value) {
          if (referencesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureReferencesIsMutable();
            references_.add(value);
            onChanged();
          } else {
            referencesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public Builder addReferences(
            int index,
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                value) {
          if (referencesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureReferencesIsMutable();
            references_.add(index, value);
            onChanged();
          } else {
            referencesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public Builder addReferences(
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                    .Builder
                builderForValue) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            references_.add(builderForValue.build());
            onChanged();
          } else {
            referencesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public Builder addReferences(
            int index,
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                    .Builder
                builderForValue) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            references_.add(index, builderForValue.build());
            onChanged();
          } else {
            referencesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public Builder addAllReferences(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                            .Reference>
                values) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, references_);
            onChanged();
          } else {
            referencesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public Builder clearReferences() {
          if (referencesBuilder_ == null) {
            references_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000020);
            onChanged();
          } else {
            referencesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public Builder removeReferences(int index) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            references_.remove(index);
            onChanged();
          } else {
            referencesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                .Builder
            getReferencesBuilder(int index) {
          return getReferencesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                .ReferenceOrBuilder
            getReferencesOrBuilder(int index) {
          if (referencesBuilder_ == null) {
            return references_.get(index);
          } else {
            return referencesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                        .ReferenceOrBuilder>
            getReferencesOrBuilderList() {
          if (referencesBuilder_ != null) {
            return referencesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(references_);
          }
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                .Builder
            addReferencesBuilder() {
          return getReferencesFieldBuilder()
              .addBuilder(
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                      .Reference.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference
                .Builder
            addReferencesBuilder(int index) {
          return getReferencesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                      .Reference.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the references attached to the `VulnerabilityDetails`.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Reference references = 6;
         * </code>
         */
        public java.util.List<
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                    .Reference.Builder>
            getReferencesBuilderList() {
          return getReferencesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                    .Reference,
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                    .Reference.Builder,
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                    .ReferenceOrBuilder>
            getReferencesFieldBuilder() {
          if (referencesBuilder_ == null) {
            referencesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                        .Reference,
                    com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                        .Reference.Builder,
                    com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                        .ReferenceOrBuilder>(
                    references_,
                    ((bitField0_ & 0x00000020) != 0),
                    getParentForChildren(),
                    isClean());
            references_ = null;
          }
          return referencesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details)
      private static final com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
              .Details
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details();
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Details> PARSER =
          new com.google.protobuf.AbstractParser<Details>() {
            @java.lang.Override
            public Details parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Details> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Details> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ItemOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
       * This field displays the inventory items affected by this vulnerability.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. For some
       * operating systems, this field might be empty.
       * </pre>
       *
       * <code>string installed_inventory_item_id = 1;</code>
       *
       * @return The installedInventoryItemId.
       */
      java.lang.String getInstalledInventoryItemId();
      /**
       *
       *
       * <pre>
       * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
       * This field displays the inventory items affected by this vulnerability.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. For some
       * operating systems, this field might be empty.
       * </pre>
       *
       * <code>string installed_inventory_item_id = 1;</code>
       *
       * @return The bytes for installedInventoryItemId.
       */
      com.google.protobuf.ByteString getInstalledInventoryItemIdBytes();

      /**
       *
       *
       * <pre>
       * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. If there is no
       * available fix, the field is empty. The `inventory_item` value specifies
       * the latest `SoftwarePackage` available to the VM that fixes the
       * vulnerability.
       * </pre>
       *
       * <code>string available_inventory_item_id = 2;</code>
       *
       * @return The availableInventoryItemId.
       */
      java.lang.String getAvailableInventoryItemId();
      /**
       *
       *
       * <pre>
       * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. If there is no
       * available fix, the field is empty. The `inventory_item` value specifies
       * the latest `SoftwarePackage` available to the VM that fixes the
       * vulnerability.
       * </pre>
       *
       * <code>string available_inventory_item_id = 2;</code>
       *
       * @return The bytes for availableInventoryItemId.
       */
      com.google.protobuf.ByteString getAvailableInventoryItemIdBytes();

      /**
       *
       *
       * <pre>
       * The recommended [CPE URI](https://cpe.mitre.org/specification/) update
       * that contains a fix for this vulnerability.
       * </pre>
       *
       * <code>string fixed_cpe_uri = 3;</code>
       *
       * @return The fixedCpeUri.
       */
      java.lang.String getFixedCpeUri();
      /**
       *
       *
       * <pre>
       * The recommended [CPE URI](https://cpe.mitre.org/specification/) update
       * that contains a fix for this vulnerability.
       * </pre>
       *
       * <code>string fixed_cpe_uri = 3;</code>
       *
       * @return The bytes for fixedCpeUri.
       */
      com.google.protobuf.ByteString getFixedCpeUriBytes();

      /**
       *
       *
       * <pre>
       * The upstream OS patch, packages or KB that fixes the vulnerability.
       * </pre>
       *
       * <code>string upstream_fix = 4;</code>
       *
       * @return The upstreamFix.
       */
      java.lang.String getUpstreamFix();
      /**
       *
       *
       * <pre>
       * The upstream OS patch, packages or KB that fixes the vulnerability.
       * </pre>
       *
       * <code>string upstream_fix = 4;</code>
       *
       * @return The bytes for upstreamFix.
       */
      com.google.protobuf.ByteString getUpstreamFixBytes();
    }
    /**
     *
     *
     * <pre>
     * OS inventory item that is affected by a vulnerability or fixed as a
     * result of a vulnerability.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item}
     */
    public static final class Item extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item)
        ItemOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Item.newBuilder() to construct.
      private Item(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Item() {
        installedInventoryItemId_ = "";
        availableInventoryItemId_ = "";
        fixedCpeUri_ = "";
        upstreamFix_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Item();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
            .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Item_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
            .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Item_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.class,
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.Builder
                    .class);
      }

      public static final int INSTALLED_INVENTORY_ITEM_ID_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object installedInventoryItemId_ = "";
      /**
       *
       *
       * <pre>
       * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
       * This field displays the inventory items affected by this vulnerability.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. For some
       * operating systems, this field might be empty.
       * </pre>
       *
       * <code>string installed_inventory_item_id = 1;</code>
       *
       * @return The installedInventoryItemId.
       */
      @java.lang.Override
      public java.lang.String getInstalledInventoryItemId() {
        java.lang.Object ref = installedInventoryItemId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          installedInventoryItemId_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
       * This field displays the inventory items affected by this vulnerability.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. For some
       * operating systems, this field might be empty.
       * </pre>
       *
       * <code>string installed_inventory_item_id = 1;</code>
       *
       * @return The bytes for installedInventoryItemId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getInstalledInventoryItemIdBytes() {
        java.lang.Object ref = installedInventoryItemId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          installedInventoryItemId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int AVAILABLE_INVENTORY_ITEM_ID_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object availableInventoryItemId_ = "";
      /**
       *
       *
       * <pre>
       * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. If there is no
       * available fix, the field is empty. The `inventory_item` value specifies
       * the latest `SoftwarePackage` available to the VM that fixes the
       * vulnerability.
       * </pre>
       *
       * <code>string available_inventory_item_id = 2;</code>
       *
       * @return The availableInventoryItemId.
       */
      @java.lang.Override
      public java.lang.String getAvailableInventoryItemId() {
        java.lang.Object ref = availableInventoryItemId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          availableInventoryItemId_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. If there is no
       * available fix, the field is empty. The `inventory_item` value specifies
       * the latest `SoftwarePackage` available to the VM that fixes the
       * vulnerability.
       * </pre>
       *
       * <code>string available_inventory_item_id = 2;</code>
       *
       * @return The bytes for availableInventoryItemId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAvailableInventoryItemIdBytes() {
        java.lang.Object ref = availableInventoryItemId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          availableInventoryItemId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int FIXED_CPE_URI_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object fixedCpeUri_ = "";
      /**
       *
       *
       * <pre>
       * The recommended [CPE URI](https://cpe.mitre.org/specification/) update
       * that contains a fix for this vulnerability.
       * </pre>
       *
       * <code>string fixed_cpe_uri = 3;</code>
       *
       * @return The fixedCpeUri.
       */
      @java.lang.Override
      public java.lang.String getFixedCpeUri() {
        java.lang.Object ref = fixedCpeUri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fixedCpeUri_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The recommended [CPE URI](https://cpe.mitre.org/specification/) update
       * that contains a fix for this vulnerability.
       * </pre>
       *
       * <code>string fixed_cpe_uri = 3;</code>
       *
       * @return The bytes for fixedCpeUri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFixedCpeUriBytes() {
        java.lang.Object ref = fixedCpeUri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fixedCpeUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int UPSTREAM_FIX_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object upstreamFix_ = "";
      /**
       *
       *
       * <pre>
       * The upstream OS patch, packages or KB that fixes the vulnerability.
       * </pre>
       *
       * <code>string upstream_fix = 4;</code>
       *
       * @return The upstreamFix.
       */
      @java.lang.Override
      public java.lang.String getUpstreamFix() {
        java.lang.Object ref = upstreamFix_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          upstreamFix_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The upstream OS patch, packages or KB that fixes the vulnerability.
       * </pre>
       *
       * <code>string upstream_fix = 4;</code>
       *
       * @return The bytes for upstreamFix.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUpstreamFixBytes() {
        java.lang.Object ref = upstreamFix_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          upstreamFix_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(installedInventoryItemId_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, installedInventoryItemId_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(availableInventoryItemId_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, availableInventoryItemId_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fixedCpeUri_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, fixedCpeUri_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(upstreamFix_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, upstreamFix_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(installedInventoryItemId_)) {
          size +=
              com.google.protobuf.GeneratedMessageV3.computeStringSize(
                  1, installedInventoryItemId_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(availableInventoryItemId_)) {
          size +=
              com.google.protobuf.GeneratedMessageV3.computeStringSize(
                  2, availableInventoryItemId_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fixedCpeUri_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, fixedCpeUri_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(upstreamFix_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, upstreamFix_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item)) {
          return super.equals(obj);
        }
        com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item other =
            (com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item) obj;

        if (!getInstalledInventoryItemId().equals(other.getInstalledInventoryItemId()))
          return false;
        if (!getAvailableInventoryItemId().equals(other.getAvailableInventoryItemId()))
          return false;
        if (!getFixedCpeUri().equals(other.getFixedCpeUri())) return false;
        if (!getUpstreamFix().equals(other.getUpstreamFix())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + INSTALLED_INVENTORY_ITEM_ID_FIELD_NUMBER;
        hash = (53 * hash) + getInstalledInventoryItemId().hashCode();
        hash = (37 * hash) + AVAILABLE_INVENTORY_ITEM_ID_FIELD_NUMBER;
        hash = (53 * hash) + getAvailableInventoryItemId().hashCode();
        hash = (37 * hash) + FIXED_CPE_URI_FIELD_NUMBER;
        hash = (53 * hash) + getFixedCpeUri().hashCode();
        hash = (37 * hash) + UPSTREAM_FIX_FIELD_NUMBER;
        hash = (53 * hash) + getUpstreamFix().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * OS inventory item that is affected by a vulnerability or fixed as a
       * result of a vulnerability.
       * </pre>
       *
       * Protobuf type {@code google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item)
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.ItemOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
              .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Item_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
              .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Item_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.class,
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          installedInventoryItemId_ = "";
          availableInventoryItemId_ = "";
          fixedCpeUri_ = "";
          upstreamFix_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
              .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_Item_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
            getDefaultInstanceForType() {
          return com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item build() {
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
            buildPartial() {
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item result =
              new com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.installedInventoryItemId_ = installedInventoryItemId_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.availableInventoryItemId_ = availableInventoryItemId_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.fixedCpeUri_ = fixedCpeUri_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.upstreamFix_ = upstreamFix_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item) {
            return mergeFrom(
                (com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item other) {
          if (other
              == com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
                  .getDefaultInstance()) return this;
          if (!other.getInstalledInventoryItemId().isEmpty()) {
            installedInventoryItemId_ = other.installedInventoryItemId_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getAvailableInventoryItemId().isEmpty()) {
            availableInventoryItemId_ = other.availableInventoryItemId_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.getFixedCpeUri().isEmpty()) {
            fixedCpeUri_ = other.fixedCpeUri_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (!other.getUpstreamFix().isEmpty()) {
            upstreamFix_ = other.upstreamFix_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    installedInventoryItemId_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    availableInventoryItemId_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    fixedCpeUri_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    upstreamFix_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object installedInventoryItemId_ = "";
        /**
         *
         *
         * <pre>
         * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
         * This field displays the inventory items affected by this vulnerability.
         * If the vulnerability report was not updated after the VM inventory
         * update, these values might not display in VM inventory. For some
         * operating systems, this field might be empty.
         * </pre>
         *
         * <code>string installed_inventory_item_id = 1;</code>
         *
         * @return The installedInventoryItemId.
         */
        public java.lang.String getInstalledInventoryItemId() {
          java.lang.Object ref = installedInventoryItemId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            installedInventoryItemId_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
         * This field displays the inventory items affected by this vulnerability.
         * If the vulnerability report was not updated after the VM inventory
         * update, these values might not display in VM inventory. For some
         * operating systems, this field might be empty.
         * </pre>
         *
         * <code>string installed_inventory_item_id = 1;</code>
         *
         * @return The bytes for installedInventoryItemId.
         */
        public com.google.protobuf.ByteString getInstalledInventoryItemIdBytes() {
          java.lang.Object ref = installedInventoryItemId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            installedInventoryItemId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
         * This field displays the inventory items affected by this vulnerability.
         * If the vulnerability report was not updated after the VM inventory
         * update, these values might not display in VM inventory. For some
         * operating systems, this field might be empty.
         * </pre>
         *
         * <code>string installed_inventory_item_id = 1;</code>
         *
         * @param value The installedInventoryItemId to set.
         * @return This builder for chaining.
         */
        public Builder setInstalledInventoryItemId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          installedInventoryItemId_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
         * This field displays the inventory items affected by this vulnerability.
         * If the vulnerability report was not updated after the VM inventory
         * update, these values might not display in VM inventory. For some
         * operating systems, this field might be empty.
         * </pre>
         *
         * <code>string installed_inventory_item_id = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearInstalledInventoryItemId() {
          installedInventoryItemId_ = getDefaultInstance().getInstalledInventoryItemId();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
         * This field displays the inventory items affected by this vulnerability.
         * If the vulnerability report was not updated after the VM inventory
         * update, these values might not display in VM inventory. For some
         * operating systems, this field might be empty.
         * </pre>
         *
         * <code>string installed_inventory_item_id = 1;</code>
         *
         * @param value The bytes for installedInventoryItemId to set.
         * @return This builder for chaining.
         */
        public Builder setInstalledInventoryItemIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          installedInventoryItemId_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object availableInventoryItemId_ = "";
        /**
         *
         *
         * <pre>
         * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
         * If the vulnerability report was not updated after the VM inventory
         * update, these values might not display in VM inventory. If there is no
         * available fix, the field is empty. The `inventory_item` value specifies
         * the latest `SoftwarePackage` available to the VM that fixes the
         * vulnerability.
         * </pre>
         *
         * <code>string available_inventory_item_id = 2;</code>
         *
         * @return The availableInventoryItemId.
         */
        public java.lang.String getAvailableInventoryItemId() {
          java.lang.Object ref = availableInventoryItemId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            availableInventoryItemId_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
         * If the vulnerability report was not updated after the VM inventory
         * update, these values might not display in VM inventory. If there is no
         * available fix, the field is empty. The `inventory_item` value specifies
         * the latest `SoftwarePackage` available to the VM that fixes the
         * vulnerability.
         * </pre>
         *
         * <code>string available_inventory_item_id = 2;</code>
         *
         * @return The bytes for availableInventoryItemId.
         */
        public com.google.protobuf.ByteString getAvailableInventoryItemIdBytes() {
          java.lang.Object ref = availableInventoryItemId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            availableInventoryItemId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
         * If the vulnerability report was not updated after the VM inventory
         * update, these values might not display in VM inventory. If there is no
         * available fix, the field is empty. The `inventory_item` value specifies
         * the latest `SoftwarePackage` available to the VM that fixes the
         * vulnerability.
         * </pre>
         *
         * <code>string available_inventory_item_id = 2;</code>
         *
         * @param value The availableInventoryItemId to set.
         * @return This builder for chaining.
         */
        public Builder setAvailableInventoryItemId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          availableInventoryItemId_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
         * If the vulnerability report was not updated after the VM inventory
         * update, these values might not display in VM inventory. If there is no
         * available fix, the field is empty. The `inventory_item` value specifies
         * the latest `SoftwarePackage` available to the VM that fixes the
         * vulnerability.
         * </pre>
         *
         * <code>string available_inventory_item_id = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAvailableInventoryItemId() {
          availableInventoryItemId_ = getDefaultInstance().getAvailableInventoryItemId();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
         * If the vulnerability report was not updated after the VM inventory
         * update, these values might not display in VM inventory. If there is no
         * available fix, the field is empty. The `inventory_item` value specifies
         * the latest `SoftwarePackage` available to the VM that fixes the
         * vulnerability.
         * </pre>
         *
         * <code>string available_inventory_item_id = 2;</code>
         *
         * @param value The bytes for availableInventoryItemId to set.
         * @return This builder for chaining.
         */
        public Builder setAvailableInventoryItemIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          availableInventoryItemId_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object fixedCpeUri_ = "";
        /**
         *
         *
         * <pre>
         * The recommended [CPE URI](https://cpe.mitre.org/specification/) update
         * that contains a fix for this vulnerability.
         * </pre>
         *
         * <code>string fixed_cpe_uri = 3;</code>
         *
         * @return The fixedCpeUri.
         */
        public java.lang.String getFixedCpeUri() {
          java.lang.Object ref = fixedCpeUri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            fixedCpeUri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The recommended [CPE URI](https://cpe.mitre.org/specification/) update
         * that contains a fix for this vulnerability.
         * </pre>
         *
         * <code>string fixed_cpe_uri = 3;</code>
         *
         * @return The bytes for fixedCpeUri.
         */
        public com.google.protobuf.ByteString getFixedCpeUriBytes() {
          java.lang.Object ref = fixedCpeUri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            fixedCpeUri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The recommended [CPE URI](https://cpe.mitre.org/specification/) update
         * that contains a fix for this vulnerability.
         * </pre>
         *
         * <code>string fixed_cpe_uri = 3;</code>
         *
         * @param value The fixedCpeUri to set.
         * @return This builder for chaining.
         */
        public Builder setFixedCpeUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          fixedCpeUri_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The recommended [CPE URI](https://cpe.mitre.org/specification/) update
         * that contains a fix for this vulnerability.
         * </pre>
         *
         * <code>string fixed_cpe_uri = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFixedCpeUri() {
          fixedCpeUri_ = getDefaultInstance().getFixedCpeUri();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The recommended [CPE URI](https://cpe.mitre.org/specification/) update
         * that contains a fix for this vulnerability.
         * </pre>
         *
         * <code>string fixed_cpe_uri = 3;</code>
         *
         * @param value The bytes for fixedCpeUri to set.
         * @return This builder for chaining.
         */
        public Builder setFixedCpeUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          fixedCpeUri_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.lang.Object upstreamFix_ = "";
        /**
         *
         *
         * <pre>
         * The upstream OS patch, packages or KB that fixes the vulnerability.
         * </pre>
         *
         * <code>string upstream_fix = 4;</code>
         *
         * @return The upstreamFix.
         */
        public java.lang.String getUpstreamFix() {
          java.lang.Object ref = upstreamFix_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            upstreamFix_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The upstream OS patch, packages or KB that fixes the vulnerability.
         * </pre>
         *
         * <code>string upstream_fix = 4;</code>
         *
         * @return The bytes for upstreamFix.
         */
        public com.google.protobuf.ByteString getUpstreamFixBytes() {
          java.lang.Object ref = upstreamFix_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            upstreamFix_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The upstream OS patch, packages or KB that fixes the vulnerability.
         * </pre>
         *
         * <code>string upstream_fix = 4;</code>
         *
         * @param value The upstreamFix to set.
         * @return This builder for chaining.
         */
        public Builder setUpstreamFix(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          upstreamFix_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The upstream OS patch, packages or KB that fixes the vulnerability.
         * </pre>
         *
         * <code>string upstream_fix = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUpstreamFix() {
          upstreamFix_ = getDefaultInstance().getUpstreamFix();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The upstream OS patch, packages or KB that fixes the vulnerability.
         * </pre>
         *
         * <code>string upstream_fix = 4;</code>
         *
         * @param value The bytes for upstreamFix to set.
         * @return This builder for chaining.
         */
        public Builder setUpstreamFixBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          upstreamFix_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item)
      private static final com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item();
      }

      public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Item> PARSER =
          new com.google.protobuf.AbstractParser<Item>() {
            @java.lang.Override
            public Item parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Item> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Item> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int DETAILS_FIELD_NUMBER = 1;
    private com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details_;
    /**
     *
     *
     * <pre>
     * Contains metadata as per the upstream feed of the operating system and
     * NVD.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
     * </code>
     *
     * @return Whether the details field is set.
     */
    @java.lang.Override
    public boolean hasDetails() {
      return details_ != null;
    }
    /**
     *
     *
     * <pre>
     * Contains metadata as per the upstream feed of the operating system and
     * NVD.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
     * </code>
     *
     * @return The details.
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
        getDetails() {
      return details_ == null
          ? com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
              .getDefaultInstance()
          : details_;
    }
    /**
     *
     *
     * <pre>
     * Contains metadata as per the upstream feed of the operating system and
     * NVD.
     * </pre>
     *
     * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.DetailsOrBuilder
        getDetailsOrBuilder() {
      return details_ == null
          ? com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
              .getDefaultInstance()
          : details_;
    }

    public static final int INSTALLED_INVENTORY_ITEM_IDS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList installedInventoryItemIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
     * This field displays the inventory items affected by this vulnerability.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. For some distros,
     * this field may be empty.
     * </pre>
     *
     * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
     * @return A list containing the installedInventoryItemIds.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ProtocolStringList getInstalledInventoryItemIdsList() {
      return installedInventoryItemIds_;
    }
    /**
     *
     *
     * <pre>
     * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
     * This field displays the inventory items affected by this vulnerability.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. For some distros,
     * this field may be empty.
     * </pre>
     *
     * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
     * @return The count of installedInventoryItemIds.
     */
    @java.lang.Deprecated
    public int getInstalledInventoryItemIdsCount() {
      return installedInventoryItemIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
     * This field displays the inventory items affected by this vulnerability.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. For some distros,
     * this field may be empty.
     * </pre>
     *
     * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
     * @param index The index of the element to return.
     * @return The installedInventoryItemIds at the given index.
     */
    @java.lang.Deprecated
    public java.lang.String getInstalledInventoryItemIds(int index) {
      return installedInventoryItemIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
     * This field displays the inventory items affected by this vulnerability.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. For some distros,
     * this field may be empty.
     * </pre>
     *
     * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
     * @param index The index of the value to return.
     * @return The bytes of the installedInventoryItemIds at the given index.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getInstalledInventoryItemIdsBytes(int index) {
      return installedInventoryItemIds_.getByteString(index);
    }

    public static final int AVAILABLE_INVENTORY_ITEM_IDS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList availableInventoryItemIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. If there is no
     * available fix, the field is empty. The `inventory_item` value specifies
     * the latest `SoftwarePackage` available to the VM that fixes the
     * vulnerability.
     * </pre>
     *
     * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
     * @return A list containing the availableInventoryItemIds.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ProtocolStringList getAvailableInventoryItemIdsList() {
      return availableInventoryItemIds_;
    }
    /**
     *
     *
     * <pre>
     * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. If there is no
     * available fix, the field is empty. The `inventory_item` value specifies
     * the latest `SoftwarePackage` available to the VM that fixes the
     * vulnerability.
     * </pre>
     *
     * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
     * @return The count of availableInventoryItemIds.
     */
    @java.lang.Deprecated
    public int getAvailableInventoryItemIdsCount() {
      return availableInventoryItemIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. If there is no
     * available fix, the field is empty. The `inventory_item` value specifies
     * the latest `SoftwarePackage` available to the VM that fixes the
     * vulnerability.
     * </pre>
     *
     * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
     * @param index The index of the element to return.
     * @return The availableInventoryItemIds at the given index.
     */
    @java.lang.Deprecated
    public java.lang.String getAvailableInventoryItemIds(int index) {
      return availableInventoryItemIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. If there is no
     * available fix, the field is empty. The `inventory_item` value specifies
     * the latest `SoftwarePackage` available to the VM that fixes the
     * vulnerability.
     * </pre>
     *
     * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
     *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
     * @param index The index of the value to return.
     * @return The bytes of the availableInventoryItemIds at the given index.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getAvailableInventoryItemIdsBytes(int index) {
      return availableInventoryItemIds_.getByteString(index);
    }

    public static final int CREATE_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp createTime_;
    /**
     *
     *
     * <pre>
     * The timestamp for when the vulnerability was first detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return Whether the createTime field is set.
     */
    @java.lang.Override
    public boolean hasCreateTime() {
      return createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The timestamp for when the vulnerability was first detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return The createTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getCreateTime() {
      return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
    }
    /**
     *
     *
     * <pre>
     * The timestamp for when the vulnerability was first detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
    }

    public static final int UPDATE_TIME_FIELD_NUMBER = 5;
    private com.google.protobuf.Timestamp updateTime_;
    /**
     *
     *
     * <pre>
     * The timestamp for when the vulnerability was last modified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     *
     * @return Whether the updateTime field is set.
     */
    @java.lang.Override
    public boolean hasUpdateTime() {
      return updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The timestamp for when the vulnerability was last modified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     *
     * @return The updateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getUpdateTime() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }
    /**
     *
     *
     * <pre>
     * The timestamp for when the vulnerability was last modified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }

    public static final int ITEMS_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item>
        items_;
    /**
     *
     *
     * <pre>
     * List of items affected by the vulnerability.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item>
        getItemsList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * List of items affected by the vulnerability.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.ItemOrBuilder>
        getItemsOrBuilderList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * List of items affected by the vulnerability.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
     * </code>
     */
    @java.lang.Override
    public int getItemsCount() {
      return items_.size();
    }
    /**
     *
     *
     * <pre>
     * List of items affected by the vulnerability.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item getItems(
        int index) {
      return items_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of items affected by the vulnerability.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.ItemOrBuilder
        getItemsOrBuilder(int index) {
      return items_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (details_ != null) {
        output.writeMessage(1, getDetails());
      }
      for (int i = 0; i < installedInventoryItemIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 2, installedInventoryItemIds_.getRaw(i));
      }
      for (int i = 0; i < availableInventoryItemIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 3, availableInventoryItemIds_.getRaw(i));
      }
      if (createTime_ != null) {
        output.writeMessage(4, getCreateTime());
      }
      if (updateTime_ != null) {
        output.writeMessage(5, getUpdateTime());
      }
      for (int i = 0; i < items_.size(); i++) {
        output.writeMessage(6, items_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (details_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDetails());
      }
      {
        int dataSize = 0;
        for (int i = 0; i < installedInventoryItemIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(installedInventoryItemIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getInstalledInventoryItemIdsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < availableInventoryItemIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(availableInventoryItemIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAvailableInventoryItemIdsList().size();
      }
      if (createTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
      }
      if (updateTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
      }
      for (int i = 0; i < items_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, items_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability)) {
        return super.equals(obj);
      }
      com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability other =
          (com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability) obj;

      if (hasDetails() != other.hasDetails()) return false;
      if (hasDetails()) {
        if (!getDetails().equals(other.getDetails())) return false;
      }
      if (!getInstalledInventoryItemIdsList().equals(other.getInstalledInventoryItemIdsList()))
        return false;
      if (!getAvailableInventoryItemIdsList().equals(other.getAvailableInventoryItemIdsList()))
        return false;
      if (hasCreateTime() != other.hasCreateTime()) return false;
      if (hasCreateTime()) {
        if (!getCreateTime().equals(other.getCreateTime())) return false;
      }
      if (hasUpdateTime() != other.hasUpdateTime()) return false;
      if (hasUpdateTime()) {
        if (!getUpdateTime().equals(other.getUpdateTime())) return false;
      }
      if (!getItemsList().equals(other.getItemsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDetails()) {
        hash = (37 * hash) + DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getDetails().hashCode();
      }
      if (getInstalledInventoryItemIdsCount() > 0) {
        hash = (37 * hash) + INSTALLED_INVENTORY_ITEM_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getInstalledInventoryItemIdsList().hashCode();
      }
      if (getAvailableInventoryItemIdsCount() > 0) {
        hash = (37 * hash) + AVAILABLE_INVENTORY_ITEM_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getAvailableInventoryItemIdsList().hashCode();
      }
      if (hasCreateTime()) {
        hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getCreateTime().hashCode();
      }
      if (hasUpdateTime()) {
        hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateTime().hashCode();
      }
      if (getItemsCount() > 0) {
        hash = (37 * hash) + ITEMS_FIELD_NUMBER;
        hash = (53 * hash) + getItemsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A vulnerability affecting the VM instance.
     * </pre>
     *
     * Protobuf type {@code google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability)
        com.google.cloud.osconfig.v1alpha.VulnerabilityReport.VulnerabilityOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
            .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
            .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.class,
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Builder.class);
      }

      // Construct using
      // com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        details_ = null;
        if (detailsBuilder_ != null) {
          detailsBuilder_.dispose();
          detailsBuilder_ = null;
        }
        installedInventoryItemIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        availableInventoryItemIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        createTime_ = null;
        if (createTimeBuilder_ != null) {
          createTimeBuilder_.dispose();
          createTimeBuilder_ = null;
        }
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
        } else {
          items_ = null;
          itemsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
            .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_Vulnerability_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
          getDefaultInstanceForType() {
        return com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability build() {
        com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability buildPartial() {
        com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability result =
            new com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability result) {
        if (itemsBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)) {
            items_ = java.util.Collections.unmodifiableList(items_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.items_ = items_;
        } else {
          result.items_ = itemsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.details_ = detailsBuilder_ == null ? details_ : detailsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          installedInventoryItemIds_.makeImmutable();
          result.installedInventoryItemIds_ = installedInventoryItemIds_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          availableInventoryItemIds_.makeImmutable();
          result.availableInventoryItemIds_ = availableInventoryItemIds_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.createTime_ =
              createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.updateTime_ =
              updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability) {
          return mergeFrom(
              (com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability other) {
        if (other
            == com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
                .getDefaultInstance()) return this;
        if (other.hasDetails()) {
          mergeDetails(other.getDetails());
        }
        if (!other.installedInventoryItemIds_.isEmpty()) {
          if (installedInventoryItemIds_.isEmpty()) {
            installedInventoryItemIds_ = other.installedInventoryItemIds_;
            bitField0_ |= 0x00000002;
          } else {
            ensureInstalledInventoryItemIdsIsMutable();
            installedInventoryItemIds_.addAll(other.installedInventoryItemIds_);
          }
          onChanged();
        }
        if (!other.availableInventoryItemIds_.isEmpty()) {
          if (availableInventoryItemIds_.isEmpty()) {
            availableInventoryItemIds_ = other.availableInventoryItemIds_;
            bitField0_ |= 0x00000004;
          } else {
            ensureAvailableInventoryItemIdsIsMutable();
            availableInventoryItemIds_.addAll(other.availableInventoryItemIds_);
          }
          onChanged();
        }
        if (other.hasCreateTime()) {
          mergeCreateTime(other.getCreateTime());
        }
        if (other.hasUpdateTime()) {
          mergeUpdateTime(other.getUpdateTime());
        }
        if (itemsBuilder_ == null) {
          if (!other.items_.isEmpty()) {
            if (items_.isEmpty()) {
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureItemsIsMutable();
              items_.addAll(other.items_);
            }
            onChanged();
          }
        } else {
          if (!other.items_.isEmpty()) {
            if (itemsBuilder_.isEmpty()) {
              itemsBuilder_.dispose();
              itemsBuilder_ = null;
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000020);
              itemsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getItemsFieldBuilder()
                      : null;
            } else {
              itemsBuilder_.addAllMessages(other.items_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getDetailsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureInstalledInventoryItemIdsIsMutable();
                  installedInventoryItemIds_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAvailableInventoryItemIdsIsMutable();
                  availableInventoryItemIds_.add(s);
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item m =
                      input.readMessage(
                          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
                              .parser(),
                          extensionRegistry);
                  if (itemsBuilder_ == null) {
                    ensureItemsIsMutable();
                    items_.add(m);
                  } else {
                    itemsBuilder_.addMessage(m);
                  }
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details,
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Builder,
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.DetailsOrBuilder>
          detailsBuilder_;
      /**
       *
       *
       * <pre>
       * Contains metadata as per the upstream feed of the operating system and
       * NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
       * </code>
       *
       * @return Whether the details field is set.
       */
      public boolean hasDetails() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Contains metadata as per the upstream feed of the operating system and
       * NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
       * </code>
       *
       * @return The details.
       */
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
          getDetails() {
        if (detailsBuilder_ == null) {
          return details_ == null
              ? com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                  .getDefaultInstance()
              : details_;
        } else {
          return detailsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Contains metadata as per the upstream feed of the operating system and
       * NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
       * </code>
       */
      public Builder setDetails(
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details value) {
        if (detailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          details_ = value;
        } else {
          detailsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contains metadata as per the upstream feed of the operating system and
       * NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
       * </code>
       */
      public Builder setDetails(
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Builder
              builderForValue) {
        if (detailsBuilder_ == null) {
          details_ = builderForValue.build();
        } else {
          detailsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contains metadata as per the upstream feed of the operating system and
       * NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
       * </code>
       */
      public Builder mergeDetails(
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details value) {
        if (detailsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && details_ != null
              && details_
                  != com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                      .getDefaultInstance()) {
            getDetailsBuilder().mergeFrom(value);
          } else {
            details_ = value;
          }
        } else {
          detailsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contains metadata as per the upstream feed of the operating system and
       * NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
       * </code>
       */
      public Builder clearDetails() {
        bitField0_ = (bitField0_ & ~0x00000001);
        details_ = null;
        if (detailsBuilder_ != null) {
          detailsBuilder_.dispose();
          detailsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contains metadata as per the upstream feed of the operating system and
       * NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Builder
          getDetailsBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getDetailsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Contains metadata as per the upstream feed of the operating system and
       * NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.DetailsOrBuilder
          getDetailsOrBuilder() {
        if (detailsBuilder_ != null) {
          return detailsBuilder_.getMessageOrBuilder();
        } else {
          return details_ == null
              ? com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                  .getDefaultInstance()
              : details_;
        }
      }
      /**
       *
       *
       * <pre>
       * Contains metadata as per the upstream feed of the operating system and
       * NVD.
       * </pre>
       *
       * <code>.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details details = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details,
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details.Builder,
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.DetailsOrBuilder>
          getDetailsFieldBuilder() {
        if (detailsBuilder_ == null) {
          detailsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details,
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Details
                      .Builder,
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
                      .DetailsOrBuilder>(getDetails(), getParentForChildren(), isClean());
          details_ = null;
        }
        return detailsBuilder_;
      }

      private com.google.protobuf.LazyStringArrayList installedInventoryItemIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureInstalledInventoryItemIdsIsMutable() {
        if (!installedInventoryItemIds_.isModifiable()) {
          installedInventoryItemIds_ =
              new com.google.protobuf.LazyStringArrayList(installedInventoryItemIds_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
       * This field displays the inventory items affected by this vulnerability.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. For some distros,
       * this field may be empty.
       * </pre>
       *
       * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
       * @return A list containing the installedInventoryItemIds.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ProtocolStringList getInstalledInventoryItemIdsList() {
        installedInventoryItemIds_.makeImmutable();
        return installedInventoryItemIds_;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
       * This field displays the inventory items affected by this vulnerability.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. For some distros,
       * this field may be empty.
       * </pre>
       *
       * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
       * @return The count of installedInventoryItemIds.
       */
      @java.lang.Deprecated
      public int getInstalledInventoryItemIdsCount() {
        return installedInventoryItemIds_.size();
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
       * This field displays the inventory items affected by this vulnerability.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. For some distros,
       * this field may be empty.
       * </pre>
       *
       * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
       * @param index The index of the element to return.
       * @return The installedInventoryItemIds at the given index.
       */
      @java.lang.Deprecated
      public java.lang.String getInstalledInventoryItemIds(int index) {
        return installedInventoryItemIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
       * This field displays the inventory items affected by this vulnerability.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. For some distros,
       * this field may be empty.
       * </pre>
       *
       * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
       * @param index The index of the value to return.
       * @return The bytes of the installedInventoryItemIds at the given index.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getInstalledInventoryItemIdsBytes(int index) {
        return installedInventoryItemIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
       * This field displays the inventory items affected by this vulnerability.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. For some distros,
       * this field may be empty.
       * </pre>
       *
       * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
       * @param index The index to set the value at.
       * @param value The installedInventoryItemIds to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setInstalledInventoryItemIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstalledInventoryItemIdsIsMutable();
        installedInventoryItemIds_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
       * This field displays the inventory items affected by this vulnerability.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. For some distros,
       * this field may be empty.
       * </pre>
       *
       * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
       * @param value The installedInventoryItemIds to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder addInstalledInventoryItemIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstalledInventoryItemIdsIsMutable();
        installedInventoryItemIds_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
       * This field displays the inventory items affected by this vulnerability.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. For some distros,
       * this field may be empty.
       * </pre>
       *
       * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
       * @param values The installedInventoryItemIds to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder addAllInstalledInventoryItemIds(java.lang.Iterable<java.lang.String> values) {
        ensureInstalledInventoryItemIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, installedInventoryItemIds_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
       * This field displays the inventory items affected by this vulnerability.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. For some distros,
       * this field may be empty.
       * </pre>
       *
       * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearInstalledInventoryItemIds() {
        installedInventoryItemIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
       * This field displays the inventory items affected by this vulnerability.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. For some distros,
       * this field may be empty.
       * </pre>
       *
       * <code>repeated string installed_inventory_item_ids = 2 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.installed_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=112
       * @param value The bytes of the installedInventoryItemIds to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder addInstalledInventoryItemIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureInstalledInventoryItemIdsIsMutable();
        installedInventoryItemIds_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList availableInventoryItemIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAvailableInventoryItemIdsIsMutable() {
        if (!availableInventoryItemIds_.isModifiable()) {
          availableInventoryItemIds_ =
              new com.google.protobuf.LazyStringArrayList(availableInventoryItemIds_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. If there is no
       * available fix, the field is empty. The `inventory_item` value specifies
       * the latest `SoftwarePackage` available to the VM that fixes the
       * vulnerability.
       * </pre>
       *
       * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
       * @return A list containing the availableInventoryItemIds.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ProtocolStringList getAvailableInventoryItemIdsList() {
        availableInventoryItemIds_.makeImmutable();
        return availableInventoryItemIds_;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. If there is no
       * available fix, the field is empty. The `inventory_item` value specifies
       * the latest `SoftwarePackage` available to the VM that fixes the
       * vulnerability.
       * </pre>
       *
       * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
       * @return The count of availableInventoryItemIds.
       */
      @java.lang.Deprecated
      public int getAvailableInventoryItemIdsCount() {
        return availableInventoryItemIds_.size();
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. If there is no
       * available fix, the field is empty. The `inventory_item` value specifies
       * the latest `SoftwarePackage` available to the VM that fixes the
       * vulnerability.
       * </pre>
       *
       * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
       * @param index The index of the element to return.
       * @return The availableInventoryItemIds at the given index.
       */
      @java.lang.Deprecated
      public java.lang.String getAvailableInventoryItemIds(int index) {
        return availableInventoryItemIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. If there is no
       * available fix, the field is empty. The `inventory_item` value specifies
       * the latest `SoftwarePackage` available to the VM that fixes the
       * vulnerability.
       * </pre>
       *
       * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
       * @param index The index of the value to return.
       * @return The bytes of the availableInventoryItemIds at the given index.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getAvailableInventoryItemIdsBytes(int index) {
        return availableInventoryItemIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. If there is no
       * available fix, the field is empty. The `inventory_item` value specifies
       * the latest `SoftwarePackage` available to the VM that fixes the
       * vulnerability.
       * </pre>
       *
       * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
       * @param index The index to set the value at.
       * @param value The availableInventoryItemIds to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setAvailableInventoryItemIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAvailableInventoryItemIdsIsMutable();
        availableInventoryItemIds_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. If there is no
       * available fix, the field is empty. The `inventory_item` value specifies
       * the latest `SoftwarePackage` available to the VM that fixes the
       * vulnerability.
       * </pre>
       *
       * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
       * @param value The availableInventoryItemIds to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder addAvailableInventoryItemIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAvailableInventoryItemIdsIsMutable();
        availableInventoryItemIds_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. If there is no
       * available fix, the field is empty. The `inventory_item` value specifies
       * the latest `SoftwarePackage` available to the VM that fixes the
       * vulnerability.
       * </pre>
       *
       * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
       * @param values The availableInventoryItemIds to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder addAllAvailableInventoryItemIds(java.lang.Iterable<java.lang.String> values) {
        ensureAvailableInventoryItemIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, availableInventoryItemIds_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. If there is no
       * available fix, the field is empty. The `inventory_item` value specifies
       * the latest `SoftwarePackage` available to the VM that fixes the
       * vulnerability.
       * </pre>
       *
       * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearAvailableInventoryItemIds() {
        availableInventoryItemIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
       * If the vulnerability report was not updated after the VM inventory
       * update, these values might not display in VM inventory. If there is no
       * available fix, the field is empty. The `inventory_item` value specifies
       * the latest `SoftwarePackage` available to the VM that fixes the
       * vulnerability.
       * </pre>
       *
       * <code>repeated string available_inventory_item_ids = 3 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.available_inventory_item_ids
       *     is deprecated. See google/cloud/osconfig/v1alpha/vulnerability.proto;l=120
       * @param value The bytes of the availableInventoryItemIds to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder addAvailableInventoryItemIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAvailableInventoryItemIdsIsMutable();
        availableInventoryItemIds_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp createTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          createTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 4;</code>
       *
       * @return Whether the createTime field is set.
       */
      public boolean hasCreateTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 4;</code>
       *
       * @return The createTime.
       */
      public com.google.protobuf.Timestamp getCreateTime() {
        if (createTimeBuilder_ == null) {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        } else {
          return createTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 4;</code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          createTime_ = value;
        } else {
          createTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 4;</code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (createTimeBuilder_ == null) {
          createTime_ = builderForValue.build();
        } else {
          createTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 4;</code>
       */
      public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && createTime_ != null
              && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getCreateTimeBuilder().mergeFrom(value);
          } else {
            createTime_ = value;
          }
        } else {
          createTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 4;</code>
       */
      public Builder clearCreateTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        createTime_ = null;
        if (createTimeBuilder_ != null) {
          createTimeBuilder_.dispose();
          createTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 4;</code>
       */
      public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getCreateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 4;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
        if (createTimeBuilder_ != null) {
          return createTimeBuilder_.getMessageOrBuilder();
        } else {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was first detected.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getCreateTimeFieldBuilder() {
        if (createTimeBuilder_ == null) {
          createTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getCreateTime(), getParentForChildren(), isClean());
          createTime_ = null;
        }
        return createTimeBuilder_;
      }

      private com.google.protobuf.Timestamp updateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          updateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 5;</code>
       *
       * @return Whether the updateTime field is set.
       */
      public boolean hasUpdateTime() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 5;</code>
       *
       * @return The updateTime.
       */
      public com.google.protobuf.Timestamp getUpdateTime() {
        if (updateTimeBuilder_ == null) {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        } else {
          return updateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 5;</code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateTime_ = value;
        } else {
          updateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 5;</code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (updateTimeBuilder_ == null) {
          updateTime_ = builderForValue.build();
        } else {
          updateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 5;</code>
       */
      public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && updateTime_ != null
              && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getUpdateTimeBuilder().mergeFrom(value);
          } else {
            updateTime_ = value;
          }
        } else {
          updateTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 5;</code>
       */
      public Builder clearUpdateTime() {
        bitField0_ = (bitField0_ & ~0x00000010);
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 5;</code>
       */
      public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 5;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
        if (updateTimeBuilder_ != null) {
          return updateTimeBuilder_.getMessageOrBuilder();
        } else {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The timestamp for when the vulnerability was last modified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp update_time = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getUpdateTimeFieldBuilder() {
        if (updateTimeBuilder_ == null) {
          updateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getUpdateTime(), getParentForChildren(), isClean());
          updateTime_ = null;
        }
        return updateTimeBuilder_;
      }

      private java.util.List<
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item>
          items_ = java.util.Collections.emptyList();

      private void ensureItemsIsMutable() {
        if (!((bitField0_ & 0x00000020) != 0)) {
          items_ =
              new java.util.ArrayList<
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item>(items_);
          bitField0_ |= 0x00000020;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item,
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.Builder,
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.ItemOrBuilder>
          itemsBuilder_;

      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public java.util.List<
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item>
          getItemsList() {
        if (itemsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(items_);
        } else {
          return itemsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public int getItemsCount() {
        if (itemsBuilder_ == null) {
          return items_.size();
        } else {
          return itemsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item getItems(
          int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public Builder setItems(
          int index,
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.set(index, value);
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public Builder setItems(
          int index,
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.Builder
              builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.set(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public Builder addItems(
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public Builder addItems(
          int index,
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(index, value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public Builder addItems(
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.Builder
              builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public Builder addItems(
          int index,
          com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.Builder
              builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public Builder addAllItems(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item>
              values) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
          onChanged();
        } else {
          itemsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public Builder clearItems() {
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public Builder removeItems(int index) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.remove(index);
          onChanged();
        } else {
          itemsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.Builder
          getItemsBuilder(int index) {
        return getItemsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.ItemOrBuilder
          getItemsOrBuilder(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.ItemOrBuilder>
          getItemsOrBuilderList() {
        if (itemsBuilder_ != null) {
          return itemsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(items_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.Builder
          addItemsBuilder() {
        return getItemsFieldBuilder()
            .addBuilder(
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.Builder
          addItemsBuilder(int index) {
        return getItemsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of items affected by the vulnerability.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item items = 6;
       * </code>
       */
      public java.util.List<
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.Builder>
          getItemsBuilderList() {
        return getItemsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item,
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.Builder,
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.ItemOrBuilder>
          getItemsFieldBuilder() {
        if (itemsBuilder_ == null) {
          itemsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item,
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Item.Builder,
                  com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
                      .ItemOrBuilder>(
                  items_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
          items_ = null;
        }
        return itemsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability)
    private static final com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability();
    }

    public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Vulnerability> PARSER =
        new com.google.protobuf.AbstractParser<Vulnerability>() {
          @java.lang.Override
          public Vulnerability parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Vulnerability> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Vulnerability> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The `vulnerabilityReport` API resource name.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/instances/{instance_id}/vulnerabilityReport`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The `vulnerabilityReport` API resource name.
   *
   * Format:
   * `projects/{project_number}/locations/{location}/instances/{instance_id}/vulnerabilityReport`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VULNERABILITIES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability>
      vulnerabilities_;
  /**
   *
   *
   * <pre>
   * Output only. List of vulnerabilities affecting the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability>
      getVulnerabilitiesList() {
    return vulnerabilities_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of vulnerabilities affecting the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.osconfig.v1alpha.VulnerabilityReport.VulnerabilityOrBuilder>
      getVulnerabilitiesOrBuilderList() {
    return vulnerabilities_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of vulnerabilities affecting the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getVulnerabilitiesCount() {
    return vulnerabilities_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. List of vulnerabilities affecting the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability getVulnerabilities(
      int index) {
    return vulnerabilities_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. List of vulnerabilities affecting the VM.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.VulnerabilityOrBuilder
      getVulnerabilitiesOrBuilder(int index) {
    return vulnerabilities_.get(index);
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp for when the last vulnerability report was generated for the
   * VM.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp for when the last vulnerability report was generated for the
   * VM.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp for when the last vulnerability report was generated for the
   * VM.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < vulnerabilities_.size(); i++) {
      output.writeMessage(2, vulnerabilities_.get(i));
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < vulnerabilities_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, vulnerabilities_.get(i));
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.osconfig.v1alpha.VulnerabilityReport)) {
      return super.equals(obj);
    }
    com.google.cloud.osconfig.v1alpha.VulnerabilityReport other =
        (com.google.cloud.osconfig.v1alpha.VulnerabilityReport) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getVulnerabilitiesList().equals(other.getVulnerabilitiesList())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getVulnerabilitiesCount() > 0) {
      hash = (37 * hash) + VULNERABILITIES_FIELD_NUMBER;
      hash = (53 * hash) + getVulnerabilitiesList().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.osconfig.v1alpha.VulnerabilityReport prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * This API resource represents the vulnerability report for a specified
   * Compute Engine virtual machine (VM) instance at a given point in time.
   *
   * For more information, see [Vulnerability
   * reports](https://cloud.google.com/compute/docs/instances/os-inventory-management#vulnerability-reports).
   * </pre>
   *
   * Protobuf type {@code google.cloud.osconfig.v1alpha.VulnerabilityReport}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.osconfig.v1alpha.VulnerabilityReport)
      com.google.cloud.osconfig.v1alpha.VulnerabilityReportOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
          .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
          .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.class,
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Builder.class);
    }

    // Construct using com.google.cloud.osconfig.v1alpha.VulnerabilityReport.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (vulnerabilitiesBuilder_ == null) {
        vulnerabilities_ = java.util.Collections.emptyList();
      } else {
        vulnerabilities_ = null;
        vulnerabilitiesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.osconfig.v1alpha.VulnerabilityProto
          .internal_static_google_cloud_osconfig_v1alpha_VulnerabilityReport_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.VulnerabilityReport getDefaultInstanceForType() {
      return com.google.cloud.osconfig.v1alpha.VulnerabilityReport.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.VulnerabilityReport build() {
      com.google.cloud.osconfig.v1alpha.VulnerabilityReport result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.osconfig.v1alpha.VulnerabilityReport buildPartial() {
      com.google.cloud.osconfig.v1alpha.VulnerabilityReport result =
          new com.google.cloud.osconfig.v1alpha.VulnerabilityReport(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.osconfig.v1alpha.VulnerabilityReport result) {
      if (vulnerabilitiesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          vulnerabilities_ = java.util.Collections.unmodifiableList(vulnerabilities_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.vulnerabilities_ = vulnerabilities_;
      } else {
        result.vulnerabilities_ = vulnerabilitiesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.osconfig.v1alpha.VulnerabilityReport result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.osconfig.v1alpha.VulnerabilityReport) {
        return mergeFrom((com.google.cloud.osconfig.v1alpha.VulnerabilityReport) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.osconfig.v1alpha.VulnerabilityReport other) {
      if (other == com.google.cloud.osconfig.v1alpha.VulnerabilityReport.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (vulnerabilitiesBuilder_ == null) {
        if (!other.vulnerabilities_.isEmpty()) {
          if (vulnerabilities_.isEmpty()) {
            vulnerabilities_ = other.vulnerabilities_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureVulnerabilitiesIsMutable();
            vulnerabilities_.addAll(other.vulnerabilities_);
          }
          onChanged();
        }
      } else {
        if (!other.vulnerabilities_.isEmpty()) {
          if (vulnerabilitiesBuilder_.isEmpty()) {
            vulnerabilitiesBuilder_.dispose();
            vulnerabilitiesBuilder_ = null;
            vulnerabilities_ = other.vulnerabilities_;
            bitField0_ = (bitField0_ & ~0x00000002);
            vulnerabilitiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVulnerabilitiesFieldBuilder()
                    : null;
          } else {
            vulnerabilitiesBuilder_.addAllMessages(other.vulnerabilities_);
          }
        }
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability m =
                    input.readMessage(
                        com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
                            .parser(),
                        extensionRegistry);
                if (vulnerabilitiesBuilder_ == null) {
                  ensureVulnerabilitiesIsMutable();
                  vulnerabilities_.add(m);
                } else {
                  vulnerabilitiesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The `vulnerabilityReport` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/vulnerabilityReport`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The `vulnerabilityReport` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/vulnerabilityReport`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The `vulnerabilityReport` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/vulnerabilityReport`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The `vulnerabilityReport` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/vulnerabilityReport`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The `vulnerabilityReport` API resource name.
     *
     * Format:
     * `projects/{project_number}/locations/{location}/instances/{instance_id}/vulnerabilityReport`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability>
        vulnerabilities_ = java.util.Collections.emptyList();

    private void ensureVulnerabilitiesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        vulnerabilities_ =
            new java.util.ArrayList<
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability>(
                vulnerabilities_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability,
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Builder,
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.VulnerabilityOrBuilder>
        vulnerabilitiesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability>
        getVulnerabilitiesList() {
      if (vulnerabilitiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(vulnerabilities_);
      } else {
        return vulnerabilitiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getVulnerabilitiesCount() {
      if (vulnerabilitiesBuilder_ == null) {
        return vulnerabilities_.size();
      } else {
        return vulnerabilitiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability getVulnerabilities(
        int index) {
      if (vulnerabilitiesBuilder_ == null) {
        return vulnerabilities_.get(index);
      } else {
        return vulnerabilitiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVulnerabilities(
        int index, com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability value) {
      if (vulnerabilitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVulnerabilitiesIsMutable();
        vulnerabilities_.set(index, value);
        onChanged();
      } else {
        vulnerabilitiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVulnerabilities(
        int index,
        com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Builder
            builderForValue) {
      if (vulnerabilitiesBuilder_ == null) {
        ensureVulnerabilitiesIsMutable();
        vulnerabilities_.set(index, builderForValue.build());
        onChanged();
      } else {
        vulnerabilitiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addVulnerabilities(
        com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability value) {
      if (vulnerabilitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVulnerabilitiesIsMutable();
        vulnerabilities_.add(value);
        onChanged();
      } else {
        vulnerabilitiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addVulnerabilities(
        int index, com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability value) {
      if (vulnerabilitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVulnerabilitiesIsMutable();
        vulnerabilities_.add(index, value);
        onChanged();
      } else {
        vulnerabilitiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addVulnerabilities(
        com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Builder
            builderForValue) {
      if (vulnerabilitiesBuilder_ == null) {
        ensureVulnerabilitiesIsMutable();
        vulnerabilities_.add(builderForValue.build());
        onChanged();
      } else {
        vulnerabilitiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addVulnerabilities(
        int index,
        com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Builder
            builderForValue) {
      if (vulnerabilitiesBuilder_ == null) {
        ensureVulnerabilitiesIsMutable();
        vulnerabilities_.add(index, builderForValue.build());
        onChanged();
      } else {
        vulnerabilitiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllVulnerabilities(
        java.lang.Iterable<
                ? extends com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability>
            values) {
      if (vulnerabilitiesBuilder_ == null) {
        ensureVulnerabilitiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, vulnerabilities_);
        onChanged();
      } else {
        vulnerabilitiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearVulnerabilities() {
      if (vulnerabilitiesBuilder_ == null) {
        vulnerabilities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        vulnerabilitiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeVulnerabilities(int index) {
      if (vulnerabilitiesBuilder_ == null) {
        ensureVulnerabilitiesIsMutable();
        vulnerabilities_.remove(index);
        onChanged();
      } else {
        vulnerabilitiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Builder
        getVulnerabilitiesBuilder(int index) {
      return getVulnerabilitiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.VulnerabilityOrBuilder
        getVulnerabilitiesOrBuilder(int index) {
      if (vulnerabilitiesBuilder_ == null) {
        return vulnerabilities_.get(index);
      } else {
        return vulnerabilitiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.osconfig.v1alpha.VulnerabilityReport.VulnerabilityOrBuilder>
        getVulnerabilitiesOrBuilderList() {
      if (vulnerabilitiesBuilder_ != null) {
        return vulnerabilitiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(vulnerabilities_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Builder
        addVulnerabilitiesBuilder() {
      return getVulnerabilitiesFieldBuilder()
          .addBuilder(
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Builder
        addVulnerabilitiesBuilder(int index) {
      return getVulnerabilitiesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. List of vulnerabilities affecting the VM.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability vulnerabilities = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Builder>
        getVulnerabilitiesBuilderList() {
      return getVulnerabilitiesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability,
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Builder,
            com.google.cloud.osconfig.v1alpha.VulnerabilityReport.VulnerabilityOrBuilder>
        getVulnerabilitiesFieldBuilder() {
      if (vulnerabilitiesBuilder_ == null) {
        vulnerabilitiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability,
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.Vulnerability.Builder,
                com.google.cloud.osconfig.v1alpha.VulnerabilityReport.VulnerabilityOrBuilder>(
                vulnerabilities_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        vulnerabilities_ = null;
      }
      return vulnerabilitiesBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp for when the last vulnerability report was generated for the
     * VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp for when the last vulnerability report was generated for the
     * VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp for when the last vulnerability report was generated for the
     * VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp for when the last vulnerability report was generated for the
     * VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp for when the last vulnerability report was generated for the
     * VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp for when the last vulnerability report was generated for the
     * VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp for when the last vulnerability report was generated for the
     * VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp for when the last vulnerability report was generated for the
     * VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp for when the last vulnerability report was generated for the
     * VM.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.osconfig.v1alpha.VulnerabilityReport)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.osconfig.v1alpha.VulnerabilityReport)
  private static final com.google.cloud.osconfig.v1alpha.VulnerabilityReport DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.osconfig.v1alpha.VulnerabilityReport();
  }

  public static com.google.cloud.osconfig.v1alpha.VulnerabilityReport getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VulnerabilityReport> PARSER =
      new com.google.protobuf.AbstractParser<VulnerabilityReport>() {
        @java.lang.Override
        public VulnerabilityReport parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VulnerabilityReport> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VulnerabilityReport> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.osconfig.v1alpha.VulnerabilityReport getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
