/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/oslogin/common/common.proto

package com.google.cloud.oslogin.common;

public final class OsLoginProto {
  private OsLoginProto() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   *
   *
   * <pre>
   * The operating system options for account entries.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.oslogin.common.OperatingSystemType}
   */
  public enum OperatingSystemType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The operating system type associated with the user account information is
     * unspecified.
     * </pre>
     *
     * <code>OPERATING_SYSTEM_TYPE_UNSPECIFIED = 0;</code>
     */
    OPERATING_SYSTEM_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Linux user account information.
     * </pre>
     *
     * <code>LINUX = 1;</code>
     */
    LINUX(1),
    /**
     *
     *
     * <pre>
     * Windows user account information.
     * </pre>
     *
     * <code>WINDOWS = 2;</code>
     */
    WINDOWS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The operating system type associated with the user account information is
     * unspecified.
     * </pre>
     *
     * <code>OPERATING_SYSTEM_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int OPERATING_SYSTEM_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Linux user account information.
     * </pre>
     *
     * <code>LINUX = 1;</code>
     */
    public static final int LINUX_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Windows user account information.
     * </pre>
     *
     * <code>WINDOWS = 2;</code>
     */
    public static final int WINDOWS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OperatingSystemType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static OperatingSystemType forNumber(int value) {
      switch (value) {
        case 0:
          return OPERATING_SYSTEM_TYPE_UNSPECIFIED;
        case 1:
          return LINUX;
        case 2:
          return WINDOWS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OperatingSystemType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<OperatingSystemType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<OperatingSystemType>() {
              public OperatingSystemType findValueByNumber(int number) {
                return OperatingSystemType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.oslogin.common.OsLoginProto.getDescriptor().getEnumTypes().get(0);
    }

    private static final OperatingSystemType[] VALUES = values();

    public static OperatingSystemType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private OperatingSystemType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.oslogin.common.OperatingSystemType)
  }

  public interface PosixAccountOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.oslogin.common.PosixAccount)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Only one POSIX account can be marked as primary.
     * </pre>
     *
     * <code>bool primary = 1;</code>
     *
     * @return The primary.
     */
    boolean getPrimary();

    /**
     *
     *
     * <pre>
     * The username of the POSIX account.
     * </pre>
     *
     * <code>string username = 2;</code>
     *
     * @return The username.
     */
    java.lang.String getUsername();
    /**
     *
     *
     * <pre>
     * The username of the POSIX account.
     * </pre>
     *
     * <code>string username = 2;</code>
     *
     * @return The bytes for username.
     */
    com.google.protobuf.ByteString getUsernameBytes();

    /**
     *
     *
     * <pre>
     * The user ID.
     * </pre>
     *
     * <code>int64 uid = 3;</code>
     *
     * @return The uid.
     */
    long getUid();

    /**
     *
     *
     * <pre>
     * The default group ID.
     * </pre>
     *
     * <code>int64 gid = 4;</code>
     *
     * @return The gid.
     */
    long getGid();

    /**
     *
     *
     * <pre>
     * The path to the home directory for this account.
     * </pre>
     *
     * <code>string home_directory = 5;</code>
     *
     * @return The homeDirectory.
     */
    java.lang.String getHomeDirectory();
    /**
     *
     *
     * <pre>
     * The path to the home directory for this account.
     * </pre>
     *
     * <code>string home_directory = 5;</code>
     *
     * @return The bytes for homeDirectory.
     */
    com.google.protobuf.ByteString getHomeDirectoryBytes();

    /**
     *
     *
     * <pre>
     * The path to the logic shell for this account.
     * </pre>
     *
     * <code>string shell = 6;</code>
     *
     * @return The shell.
     */
    java.lang.String getShell();
    /**
     *
     *
     * <pre>
     * The path to the logic shell for this account.
     * </pre>
     *
     * <code>string shell = 6;</code>
     *
     * @return The bytes for shell.
     */
    com.google.protobuf.ByteString getShellBytes();

    /**
     *
     *
     * <pre>
     * The GECOS (user information) entry for this account.
     * </pre>
     *
     * <code>string gecos = 7;</code>
     *
     * @return The gecos.
     */
    java.lang.String getGecos();
    /**
     *
     *
     * <pre>
     * The GECOS (user information) entry for this account.
     * </pre>
     *
     * <code>string gecos = 7;</code>
     *
     * @return The bytes for gecos.
     */
    com.google.protobuf.ByteString getGecosBytes();

    /**
     *
     *
     * <pre>
     * System identifier for which account the username or uid applies to.
     * By default, the empty value is used.
     * </pre>
     *
     * <code>string system_id = 8;</code>
     *
     * @return The systemId.
     */
    java.lang.String getSystemId();
    /**
     *
     *
     * <pre>
     * System identifier for which account the username or uid applies to.
     * By default, the empty value is used.
     * </pre>
     *
     * <code>string system_id = 8;</code>
     *
     * @return The bytes for systemId.
     */
    com.google.protobuf.ByteString getSystemIdBytes();

    /**
     *
     *
     * <pre>
     * Output only. A POSIX account identifier.
     * </pre>
     *
     * <code>string account_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The accountId.
     */
    java.lang.String getAccountId();
    /**
     *
     *
     * <pre>
     * Output only. A POSIX account identifier.
     * </pre>
     *
     * <code>string account_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for accountId.
     */
    com.google.protobuf.ByteString getAccountIdBytes();

    /**
     *
     *
     * <pre>
     * The operating system type where this account applies.
     * </pre>
     *
     * <code>.google.cloud.oslogin.common.OperatingSystemType operating_system_type = 10;</code>
     *
     * @return The enum numeric value on the wire for operatingSystemType.
     */
    int getOperatingSystemTypeValue();
    /**
     *
     *
     * <pre>
     * The operating system type where this account applies.
     * </pre>
     *
     * <code>.google.cloud.oslogin.common.OperatingSystemType operating_system_type = 10;</code>
     *
     * @return The operatingSystemType.
     */
    com.google.cloud.oslogin.common.OsLoginProto.OperatingSystemType getOperatingSystemType();

    /**
     *
     *
     * <pre>
     * Output only. The canonical resource name.
     * </pre>
     *
     * <code>string name = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Output only. The canonical resource name.
     * </pre>
     *
     * <code>string name = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * The POSIX account information associated with a Google account.
   * </pre>
   *
   * Protobuf type {@code google.cloud.oslogin.common.PosixAccount}
   */
  public static final class PosixAccount extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.oslogin.common.PosixAccount)
      PosixAccountOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PosixAccount.newBuilder() to construct.
    private PosixAccount(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PosixAccount() {
      username_ = "";
      homeDirectory_ = "";
      shell_ = "";
      gecos_ = "";
      systemId_ = "";
      accountId_ = "";
      operatingSystemType_ = 0;
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PosixAccount();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private PosixAccount(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                primary_ = input.readBool();
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                username_ = s;
                break;
              }
            case 24:
              {
                uid_ = input.readInt64();
                break;
              }
            case 32:
              {
                gid_ = input.readInt64();
                break;
              }
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();

                homeDirectory_ = s;
                break;
              }
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();

                shell_ = s;
                break;
              }
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();

                gecos_ = s;
                break;
              }
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();

                systemId_ = s;
                break;
              }
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();

                accountId_ = s;
                break;
              }
            case 80:
              {
                int rawValue = input.readEnum();

                operatingSystemType_ = rawValue;
                break;
              }
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();

                name_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.oslogin.common.OsLoginProto
          .internal_static_google_cloud_oslogin_common_PosixAccount_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.oslogin.common.OsLoginProto
          .internal_static_google_cloud_oslogin_common_PosixAccount_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.class,
              com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.Builder.class);
    }

    public static final int PRIMARY_FIELD_NUMBER = 1;
    private boolean primary_;
    /**
     *
     *
     * <pre>
     * Only one POSIX account can be marked as primary.
     * </pre>
     *
     * <code>bool primary = 1;</code>
     *
     * @return The primary.
     */
    @java.lang.Override
    public boolean getPrimary() {
      return primary_;
    }

    public static final int USERNAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object username_;
    /**
     *
     *
     * <pre>
     * The username of the POSIX account.
     * </pre>
     *
     * <code>string username = 2;</code>
     *
     * @return The username.
     */
    @java.lang.Override
    public java.lang.String getUsername() {
      java.lang.Object ref = username_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        username_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The username of the POSIX account.
     * </pre>
     *
     * <code>string username = 2;</code>
     *
     * @return The bytes for username.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUsernameBytes() {
      java.lang.Object ref = username_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        username_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int UID_FIELD_NUMBER = 3;
    private long uid_;
    /**
     *
     *
     * <pre>
     * The user ID.
     * </pre>
     *
     * <code>int64 uid = 3;</code>
     *
     * @return The uid.
     */
    @java.lang.Override
    public long getUid() {
      return uid_;
    }

    public static final int GID_FIELD_NUMBER = 4;
    private long gid_;
    /**
     *
     *
     * <pre>
     * The default group ID.
     * </pre>
     *
     * <code>int64 gid = 4;</code>
     *
     * @return The gid.
     */
    @java.lang.Override
    public long getGid() {
      return gid_;
    }

    public static final int HOME_DIRECTORY_FIELD_NUMBER = 5;
    private volatile java.lang.Object homeDirectory_;
    /**
     *
     *
     * <pre>
     * The path to the home directory for this account.
     * </pre>
     *
     * <code>string home_directory = 5;</code>
     *
     * @return The homeDirectory.
     */
    @java.lang.Override
    public java.lang.String getHomeDirectory() {
      java.lang.Object ref = homeDirectory_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        homeDirectory_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The path to the home directory for this account.
     * </pre>
     *
     * <code>string home_directory = 5;</code>
     *
     * @return The bytes for homeDirectory.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHomeDirectoryBytes() {
      java.lang.Object ref = homeDirectory_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        homeDirectory_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SHELL_FIELD_NUMBER = 6;
    private volatile java.lang.Object shell_;
    /**
     *
     *
     * <pre>
     * The path to the logic shell for this account.
     * </pre>
     *
     * <code>string shell = 6;</code>
     *
     * @return The shell.
     */
    @java.lang.Override
    public java.lang.String getShell() {
      java.lang.Object ref = shell_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        shell_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The path to the logic shell for this account.
     * </pre>
     *
     * <code>string shell = 6;</code>
     *
     * @return The bytes for shell.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getShellBytes() {
      java.lang.Object ref = shell_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        shell_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GECOS_FIELD_NUMBER = 7;
    private volatile java.lang.Object gecos_;
    /**
     *
     *
     * <pre>
     * The GECOS (user information) entry for this account.
     * </pre>
     *
     * <code>string gecos = 7;</code>
     *
     * @return The gecos.
     */
    @java.lang.Override
    public java.lang.String getGecos() {
      java.lang.Object ref = gecos_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gecos_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The GECOS (user information) entry for this account.
     * </pre>
     *
     * <code>string gecos = 7;</code>
     *
     * @return The bytes for gecos.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGecosBytes() {
      java.lang.Object ref = gecos_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gecos_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SYSTEM_ID_FIELD_NUMBER = 8;
    private volatile java.lang.Object systemId_;
    /**
     *
     *
     * <pre>
     * System identifier for which account the username or uid applies to.
     * By default, the empty value is used.
     * </pre>
     *
     * <code>string system_id = 8;</code>
     *
     * @return The systemId.
     */
    @java.lang.Override
    public java.lang.String getSystemId() {
      java.lang.Object ref = systemId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        systemId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * System identifier for which account the username or uid applies to.
     * By default, the empty value is used.
     * </pre>
     *
     * <code>string system_id = 8;</code>
     *
     * @return The bytes for systemId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSystemIdBytes() {
      java.lang.Object ref = systemId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        systemId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ACCOUNT_ID_FIELD_NUMBER = 9;
    private volatile java.lang.Object accountId_;
    /**
     *
     *
     * <pre>
     * Output only. A POSIX account identifier.
     * </pre>
     *
     * <code>string account_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The accountId.
     */
    @java.lang.Override
    public java.lang.String getAccountId() {
      java.lang.Object ref = accountId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        accountId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A POSIX account identifier.
     * </pre>
     *
     * <code>string account_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for accountId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAccountIdBytes() {
      java.lang.Object ref = accountId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        accountId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OPERATING_SYSTEM_TYPE_FIELD_NUMBER = 10;
    private int operatingSystemType_;
    /**
     *
     *
     * <pre>
     * The operating system type where this account applies.
     * </pre>
     *
     * <code>.google.cloud.oslogin.common.OperatingSystemType operating_system_type = 10;</code>
     *
     * @return The enum numeric value on the wire for operatingSystemType.
     */
    @java.lang.Override
    public int getOperatingSystemTypeValue() {
      return operatingSystemType_;
    }
    /**
     *
     *
     * <pre>
     * The operating system type where this account applies.
     * </pre>
     *
     * <code>.google.cloud.oslogin.common.OperatingSystemType operating_system_type = 10;</code>
     *
     * @return The operatingSystemType.
     */
    @java.lang.Override
    public com.google.cloud.oslogin.common.OsLoginProto.OperatingSystemType
        getOperatingSystemType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.oslogin.common.OsLoginProto.OperatingSystemType result =
          com.google.cloud.oslogin.common.OsLoginProto.OperatingSystemType.valueOf(
              operatingSystemType_);
      return result == null
          ? com.google.cloud.oslogin.common.OsLoginProto.OperatingSystemType.UNRECOGNIZED
          : result;
    }

    public static final int NAME_FIELD_NUMBER = 11;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Output only. The canonical resource name.
     * </pre>
     *
     * <code>string name = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The canonical resource name.
     * </pre>
     *
     * <code>string name = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (primary_ != false) {
        output.writeBool(1, primary_);
      }
      if (!getUsernameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, username_);
      }
      if (uid_ != 0L) {
        output.writeInt64(3, uid_);
      }
      if (gid_ != 0L) {
        output.writeInt64(4, gid_);
      }
      if (!getHomeDirectoryBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, homeDirectory_);
      }
      if (!getShellBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, shell_);
      }
      if (!getGecosBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, gecos_);
      }
      if (!getSystemIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, systemId_);
      }
      if (!getAccountIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 9, accountId_);
      }
      if (operatingSystemType_
          != com.google.cloud.oslogin.common.OsLoginProto.OperatingSystemType
              .OPERATING_SYSTEM_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(10, operatingSystemType_);
      }
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 11, name_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (primary_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, primary_);
      }
      if (!getUsernameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, username_);
      }
      if (uid_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, uid_);
      }
      if (gid_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, gid_);
      }
      if (!getHomeDirectoryBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, homeDirectory_);
      }
      if (!getShellBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, shell_);
      }
      if (!getGecosBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, gecos_);
      }
      if (!getSystemIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, systemId_);
      }
      if (!getAccountIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, accountId_);
      }
      if (operatingSystemType_
          != com.google.cloud.oslogin.common.OsLoginProto.OperatingSystemType
              .OPERATING_SYSTEM_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, operatingSystemType_);
      }
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, name_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.oslogin.common.OsLoginProto.PosixAccount)) {
        return super.equals(obj);
      }
      com.google.cloud.oslogin.common.OsLoginProto.PosixAccount other =
          (com.google.cloud.oslogin.common.OsLoginProto.PosixAccount) obj;

      if (getPrimary() != other.getPrimary()) return false;
      if (!getUsername().equals(other.getUsername())) return false;
      if (getUid() != other.getUid()) return false;
      if (getGid() != other.getGid()) return false;
      if (!getHomeDirectory().equals(other.getHomeDirectory())) return false;
      if (!getShell().equals(other.getShell())) return false;
      if (!getGecos().equals(other.getGecos())) return false;
      if (!getSystemId().equals(other.getSystemId())) return false;
      if (!getAccountId().equals(other.getAccountId())) return false;
      if (operatingSystemType_ != other.operatingSystemType_) return false;
      if (!getName().equals(other.getName())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PRIMARY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPrimary());
      hash = (37 * hash) + USERNAME_FIELD_NUMBER;
      hash = (53 * hash) + getUsername().hashCode();
      hash = (37 * hash) + UID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getUid());
      hash = (37 * hash) + GID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getGid());
      hash = (37 * hash) + HOME_DIRECTORY_FIELD_NUMBER;
      hash = (53 * hash) + getHomeDirectory().hashCode();
      hash = (37 * hash) + SHELL_FIELD_NUMBER;
      hash = (53 * hash) + getShell().hashCode();
      hash = (37 * hash) + GECOS_FIELD_NUMBER;
      hash = (53 * hash) + getGecos().hashCode();
      hash = (37 * hash) + SYSTEM_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSystemId().hashCode();
      hash = (37 * hash) + ACCOUNT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getAccountId().hashCode();
      hash = (37 * hash) + OPERATING_SYSTEM_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + operatingSystemType_;
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.PosixAccount parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.PosixAccount parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.PosixAccount parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.PosixAccount parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.PosixAccount parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.PosixAccount parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.PosixAccount parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.PosixAccount parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.PosixAccount parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.PosixAccount parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.PosixAccount parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.PosixAccount parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.oslogin.common.OsLoginProto.PosixAccount prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The POSIX account information associated with a Google account.
     * </pre>
     *
     * Protobuf type {@code google.cloud.oslogin.common.PosixAccount}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.oslogin.common.PosixAccount)
        com.google.cloud.oslogin.common.OsLoginProto.PosixAccountOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.oslogin.common.OsLoginProto
            .internal_static_google_cloud_oslogin_common_PosixAccount_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.oslogin.common.OsLoginProto
            .internal_static_google_cloud_oslogin_common_PosixAccount_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.class,
                com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.Builder.class);
      }

      // Construct using com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        primary_ = false;

        username_ = "";

        uid_ = 0L;

        gid_ = 0L;

        homeDirectory_ = "";

        shell_ = "";

        gecos_ = "";

        systemId_ = "";

        accountId_ = "";

        operatingSystemType_ = 0;

        name_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.oslogin.common.OsLoginProto
            .internal_static_google_cloud_oslogin_common_PosixAccount_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.oslogin.common.OsLoginProto.PosixAccount getDefaultInstanceForType() {
        return com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.oslogin.common.OsLoginProto.PosixAccount build() {
        com.google.cloud.oslogin.common.OsLoginProto.PosixAccount result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.oslogin.common.OsLoginProto.PosixAccount buildPartial() {
        com.google.cloud.oslogin.common.OsLoginProto.PosixAccount result =
            new com.google.cloud.oslogin.common.OsLoginProto.PosixAccount(this);
        result.primary_ = primary_;
        result.username_ = username_;
        result.uid_ = uid_;
        result.gid_ = gid_;
        result.homeDirectory_ = homeDirectory_;
        result.shell_ = shell_;
        result.gecos_ = gecos_;
        result.systemId_ = systemId_;
        result.accountId_ = accountId_;
        result.operatingSystemType_ = operatingSystemType_;
        result.name_ = name_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.oslogin.common.OsLoginProto.PosixAccount) {
          return mergeFrom((com.google.cloud.oslogin.common.OsLoginProto.PosixAccount) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.oslogin.common.OsLoginProto.PosixAccount other) {
        if (other == com.google.cloud.oslogin.common.OsLoginProto.PosixAccount.getDefaultInstance())
          return this;
        if (other.getPrimary() != false) {
          setPrimary(other.getPrimary());
        }
        if (!other.getUsername().isEmpty()) {
          username_ = other.username_;
          onChanged();
        }
        if (other.getUid() != 0L) {
          setUid(other.getUid());
        }
        if (other.getGid() != 0L) {
          setGid(other.getGid());
        }
        if (!other.getHomeDirectory().isEmpty()) {
          homeDirectory_ = other.homeDirectory_;
          onChanged();
        }
        if (!other.getShell().isEmpty()) {
          shell_ = other.shell_;
          onChanged();
        }
        if (!other.getGecos().isEmpty()) {
          gecos_ = other.gecos_;
          onChanged();
        }
        if (!other.getSystemId().isEmpty()) {
          systemId_ = other.systemId_;
          onChanged();
        }
        if (!other.getAccountId().isEmpty()) {
          accountId_ = other.accountId_;
          onChanged();
        }
        if (other.operatingSystemType_ != 0) {
          setOperatingSystemTypeValue(other.getOperatingSystemTypeValue());
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.oslogin.common.OsLoginProto.PosixAccount parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.oslogin.common.OsLoginProto.PosixAccount) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean primary_;
      /**
       *
       *
       * <pre>
       * Only one POSIX account can be marked as primary.
       * </pre>
       *
       * <code>bool primary = 1;</code>
       *
       * @return The primary.
       */
      @java.lang.Override
      public boolean getPrimary() {
        return primary_;
      }
      /**
       *
       *
       * <pre>
       * Only one POSIX account can be marked as primary.
       * </pre>
       *
       * <code>bool primary = 1;</code>
       *
       * @param value The primary to set.
       * @return This builder for chaining.
       */
      public Builder setPrimary(boolean value) {

        primary_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only one POSIX account can be marked as primary.
       * </pre>
       *
       * <code>bool primary = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrimary() {

        primary_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object username_ = "";
      /**
       *
       *
       * <pre>
       * The username of the POSIX account.
       * </pre>
       *
       * <code>string username = 2;</code>
       *
       * @return The username.
       */
      public java.lang.String getUsername() {
        java.lang.Object ref = username_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          username_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The username of the POSIX account.
       * </pre>
       *
       * <code>string username = 2;</code>
       *
       * @return The bytes for username.
       */
      public com.google.protobuf.ByteString getUsernameBytes() {
        java.lang.Object ref = username_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          username_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The username of the POSIX account.
       * </pre>
       *
       * <code>string username = 2;</code>
       *
       * @param value The username to set.
       * @return This builder for chaining.
       */
      public Builder setUsername(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        username_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The username of the POSIX account.
       * </pre>
       *
       * <code>string username = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUsername() {

        username_ = getDefaultInstance().getUsername();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The username of the POSIX account.
       * </pre>
       *
       * <code>string username = 2;</code>
       *
       * @param value The bytes for username to set.
       * @return This builder for chaining.
       */
      public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        username_ = value;
        onChanged();
        return this;
      }

      private long uid_;
      /**
       *
       *
       * <pre>
       * The user ID.
       * </pre>
       *
       * <code>int64 uid = 3;</code>
       *
       * @return The uid.
       */
      @java.lang.Override
      public long getUid() {
        return uid_;
      }
      /**
       *
       *
       * <pre>
       * The user ID.
       * </pre>
       *
       * <code>int64 uid = 3;</code>
       *
       * @param value The uid to set.
       * @return This builder for chaining.
       */
      public Builder setUid(long value) {

        uid_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The user ID.
       * </pre>
       *
       * <code>int64 uid = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUid() {

        uid_ = 0L;
        onChanged();
        return this;
      }

      private long gid_;
      /**
       *
       *
       * <pre>
       * The default group ID.
       * </pre>
       *
       * <code>int64 gid = 4;</code>
       *
       * @return The gid.
       */
      @java.lang.Override
      public long getGid() {
        return gid_;
      }
      /**
       *
       *
       * <pre>
       * The default group ID.
       * </pre>
       *
       * <code>int64 gid = 4;</code>
       *
       * @param value The gid to set.
       * @return This builder for chaining.
       */
      public Builder setGid(long value) {

        gid_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The default group ID.
       * </pre>
       *
       * <code>int64 gid = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGid() {

        gid_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object homeDirectory_ = "";
      /**
       *
       *
       * <pre>
       * The path to the home directory for this account.
       * </pre>
       *
       * <code>string home_directory = 5;</code>
       *
       * @return The homeDirectory.
       */
      public java.lang.String getHomeDirectory() {
        java.lang.Object ref = homeDirectory_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          homeDirectory_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The path to the home directory for this account.
       * </pre>
       *
       * <code>string home_directory = 5;</code>
       *
       * @return The bytes for homeDirectory.
       */
      public com.google.protobuf.ByteString getHomeDirectoryBytes() {
        java.lang.Object ref = homeDirectory_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          homeDirectory_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The path to the home directory for this account.
       * </pre>
       *
       * <code>string home_directory = 5;</code>
       *
       * @param value The homeDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setHomeDirectory(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        homeDirectory_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The path to the home directory for this account.
       * </pre>
       *
       * <code>string home_directory = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHomeDirectory() {

        homeDirectory_ = getDefaultInstance().getHomeDirectory();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The path to the home directory for this account.
       * </pre>
       *
       * <code>string home_directory = 5;</code>
       *
       * @param value The bytes for homeDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setHomeDirectoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        homeDirectory_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object shell_ = "";
      /**
       *
       *
       * <pre>
       * The path to the logic shell for this account.
       * </pre>
       *
       * <code>string shell = 6;</code>
       *
       * @return The shell.
       */
      public java.lang.String getShell() {
        java.lang.Object ref = shell_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          shell_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The path to the logic shell for this account.
       * </pre>
       *
       * <code>string shell = 6;</code>
       *
       * @return The bytes for shell.
       */
      public com.google.protobuf.ByteString getShellBytes() {
        java.lang.Object ref = shell_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          shell_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The path to the logic shell for this account.
       * </pre>
       *
       * <code>string shell = 6;</code>
       *
       * @param value The shell to set.
       * @return This builder for chaining.
       */
      public Builder setShell(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        shell_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The path to the logic shell for this account.
       * </pre>
       *
       * <code>string shell = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearShell() {

        shell_ = getDefaultInstance().getShell();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The path to the logic shell for this account.
       * </pre>
       *
       * <code>string shell = 6;</code>
       *
       * @param value The bytes for shell to set.
       * @return This builder for chaining.
       */
      public Builder setShellBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        shell_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object gecos_ = "";
      /**
       *
       *
       * <pre>
       * The GECOS (user information) entry for this account.
       * </pre>
       *
       * <code>string gecos = 7;</code>
       *
       * @return The gecos.
       */
      public java.lang.String getGecos() {
        java.lang.Object ref = gecos_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gecos_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The GECOS (user information) entry for this account.
       * </pre>
       *
       * <code>string gecos = 7;</code>
       *
       * @return The bytes for gecos.
       */
      public com.google.protobuf.ByteString getGecosBytes() {
        java.lang.Object ref = gecos_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gecos_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The GECOS (user information) entry for this account.
       * </pre>
       *
       * <code>string gecos = 7;</code>
       *
       * @param value The gecos to set.
       * @return This builder for chaining.
       */
      public Builder setGecos(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        gecos_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The GECOS (user information) entry for this account.
       * </pre>
       *
       * <code>string gecos = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGecos() {

        gecos_ = getDefaultInstance().getGecos();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The GECOS (user information) entry for this account.
       * </pre>
       *
       * <code>string gecos = 7;</code>
       *
       * @param value The bytes for gecos to set.
       * @return This builder for chaining.
       */
      public Builder setGecosBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        gecos_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object systemId_ = "";
      /**
       *
       *
       * <pre>
       * System identifier for which account the username or uid applies to.
       * By default, the empty value is used.
       * </pre>
       *
       * <code>string system_id = 8;</code>
       *
       * @return The systemId.
       */
      public java.lang.String getSystemId() {
        java.lang.Object ref = systemId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          systemId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * System identifier for which account the username or uid applies to.
       * By default, the empty value is used.
       * </pre>
       *
       * <code>string system_id = 8;</code>
       *
       * @return The bytes for systemId.
       */
      public com.google.protobuf.ByteString getSystemIdBytes() {
        java.lang.Object ref = systemId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          systemId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * System identifier for which account the username or uid applies to.
       * By default, the empty value is used.
       * </pre>
       *
       * <code>string system_id = 8;</code>
       *
       * @param value The systemId to set.
       * @return This builder for chaining.
       */
      public Builder setSystemId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        systemId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * System identifier for which account the username or uid applies to.
       * By default, the empty value is used.
       * </pre>
       *
       * <code>string system_id = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSystemId() {

        systemId_ = getDefaultInstance().getSystemId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * System identifier for which account the username or uid applies to.
       * By default, the empty value is used.
       * </pre>
       *
       * <code>string system_id = 8;</code>
       *
       * @param value The bytes for systemId to set.
       * @return This builder for chaining.
       */
      public Builder setSystemIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        systemId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object accountId_ = "";
      /**
       *
       *
       * <pre>
       * Output only. A POSIX account identifier.
       * </pre>
       *
       * <code>string account_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The accountId.
       */
      public java.lang.String getAccountId() {
        java.lang.Object ref = accountId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          accountId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. A POSIX account identifier.
       * </pre>
       *
       * <code>string account_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for accountId.
       */
      public com.google.protobuf.ByteString getAccountIdBytes() {
        java.lang.Object ref = accountId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          accountId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. A POSIX account identifier.
       * </pre>
       *
       * <code>string account_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The accountId to set.
       * @return This builder for chaining.
       */
      public Builder setAccountId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        accountId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A POSIX account identifier.
       * </pre>
       *
       * <code>string account_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAccountId() {

        accountId_ = getDefaultInstance().getAccountId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A POSIX account identifier.
       * </pre>
       *
       * <code>string account_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for accountId to set.
       * @return This builder for chaining.
       */
      public Builder setAccountIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        accountId_ = value;
        onChanged();
        return this;
      }

      private int operatingSystemType_ = 0;
      /**
       *
       *
       * <pre>
       * The operating system type where this account applies.
       * </pre>
       *
       * <code>.google.cloud.oslogin.common.OperatingSystemType operating_system_type = 10;</code>
       *
       * @return The enum numeric value on the wire for operatingSystemType.
       */
      @java.lang.Override
      public int getOperatingSystemTypeValue() {
        return operatingSystemType_;
      }
      /**
       *
       *
       * <pre>
       * The operating system type where this account applies.
       * </pre>
       *
       * <code>.google.cloud.oslogin.common.OperatingSystemType operating_system_type = 10;</code>
       *
       * @param value The enum numeric value on the wire for operatingSystemType to set.
       * @return This builder for chaining.
       */
      public Builder setOperatingSystemTypeValue(int value) {

        operatingSystemType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operating system type where this account applies.
       * </pre>
       *
       * <code>.google.cloud.oslogin.common.OperatingSystemType operating_system_type = 10;</code>
       *
       * @return The operatingSystemType.
       */
      @java.lang.Override
      public com.google.cloud.oslogin.common.OsLoginProto.OperatingSystemType
          getOperatingSystemType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.oslogin.common.OsLoginProto.OperatingSystemType result =
            com.google.cloud.oslogin.common.OsLoginProto.OperatingSystemType.valueOf(
                operatingSystemType_);
        return result == null
            ? com.google.cloud.oslogin.common.OsLoginProto.OperatingSystemType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The operating system type where this account applies.
       * </pre>
       *
       * <code>.google.cloud.oslogin.common.OperatingSystemType operating_system_type = 10;</code>
       *
       * @param value The operatingSystemType to set.
       * @return This builder for chaining.
       */
      public Builder setOperatingSystemType(
          com.google.cloud.oslogin.common.OsLoginProto.OperatingSystemType value) {
        if (value == null) {
          throw new NullPointerException();
        }

        operatingSystemType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operating system type where this account applies.
       * </pre>
       *
       * <code>.google.cloud.oslogin.common.OperatingSystemType operating_system_type = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOperatingSystemType() {

        operatingSystemType_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The canonical resource name.
       * </pre>
       *
       * <code>string name = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The canonical resource name.
       * </pre>
       *
       * <code>string name = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The canonical resource name.
       * </pre>
       *
       * <code>string name = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The canonical resource name.
       * </pre>
       *
       * <code>string name = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The canonical resource name.
       * </pre>
       *
       * <code>string name = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.oslogin.common.PosixAccount)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.oslogin.common.PosixAccount)
    private static final com.google.cloud.oslogin.common.OsLoginProto.PosixAccount DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.oslogin.common.OsLoginProto.PosixAccount();
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.PosixAccount getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PosixAccount> PARSER =
        new com.google.protobuf.AbstractParser<PosixAccount>() {
          @java.lang.Override
          public PosixAccount parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new PosixAccount(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<PosixAccount> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PosixAccount> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.oslogin.common.OsLoginProto.PosixAccount getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SshPublicKeyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.oslogin.common.SshPublicKey)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Public key text in SSH format, defined by
     * &lt;a href="https://www.ietf.org/rfc/rfc4253.txt" target="_blank"&gt;RFC4253&lt;/a&gt;
     * section 6.6.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    java.lang.String getKey();
    /**
     *
     *
     * <pre>
     * Public key text in SSH format, defined by
     * &lt;a href="https://www.ietf.org/rfc/rfc4253.txt" target="_blank"&gt;RFC4253&lt;/a&gt;
     * section 6.6.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString getKeyBytes();

    /**
     *
     *
     * <pre>
     * An expiration time in microseconds since epoch.
     * </pre>
     *
     * <code>int64 expiration_time_usec = 2;</code>
     *
     * @return The expirationTimeUsec.
     */
    long getExpirationTimeUsec();

    /**
     *
     *
     * <pre>
     * Output only. The SHA-256 fingerprint of the SSH public key.
     * </pre>
     *
     * <code>string fingerprint = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The fingerprint.
     */
    java.lang.String getFingerprint();
    /**
     *
     *
     * <pre>
     * Output only. The SHA-256 fingerprint of the SSH public key.
     * </pre>
     *
     * <code>string fingerprint = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for fingerprint.
     */
    com.google.protobuf.ByteString getFingerprintBytes();

    /**
     *
     *
     * <pre>
     * Output only. The canonical resource name.
     * </pre>
     *
     * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Output only. The canonical resource name.
     * </pre>
     *
     * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * The SSH public key information associated with a Google account.
   * </pre>
   *
   * Protobuf type {@code google.cloud.oslogin.common.SshPublicKey}
   */
  public static final class SshPublicKey extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.oslogin.common.SshPublicKey)
      SshPublicKeyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SshPublicKey.newBuilder() to construct.
    private SshPublicKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SshPublicKey() {
      key_ = "";
      fingerprint_ = "";
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SshPublicKey();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private SshPublicKey(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                key_ = s;
                break;
              }
            case 16:
              {
                expirationTimeUsec_ = input.readInt64();
                break;
              }
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();

                fingerprint_ = s;
                break;
              }
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();

                name_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.oslogin.common.OsLoginProto
          .internal_static_google_cloud_oslogin_common_SshPublicKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.oslogin.common.OsLoginProto
          .internal_static_google_cloud_oslogin_common_SshPublicKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.class,
              com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.Builder.class);
    }

    public static final int KEY_FIELD_NUMBER = 1;
    private volatile java.lang.Object key_;
    /**
     *
     *
     * <pre>
     * Public key text in SSH format, defined by
     * &lt;a href="https://www.ietf.org/rfc/rfc4253.txt" target="_blank"&gt;RFC4253&lt;/a&gt;
     * section 6.6.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Public key text in SSH format, defined by
     * &lt;a href="https://www.ietf.org/rfc/rfc4253.txt" target="_blank"&gt;RFC4253&lt;/a&gt;
     * section 6.6.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EXPIRATION_TIME_USEC_FIELD_NUMBER = 2;
    private long expirationTimeUsec_;
    /**
     *
     *
     * <pre>
     * An expiration time in microseconds since epoch.
     * </pre>
     *
     * <code>int64 expiration_time_usec = 2;</code>
     *
     * @return The expirationTimeUsec.
     */
    @java.lang.Override
    public long getExpirationTimeUsec() {
      return expirationTimeUsec_;
    }

    public static final int FINGERPRINT_FIELD_NUMBER = 3;
    private volatile java.lang.Object fingerprint_;
    /**
     *
     *
     * <pre>
     * Output only. The SHA-256 fingerprint of the SSH public key.
     * </pre>
     *
     * <code>string fingerprint = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The fingerprint.
     */
    @java.lang.Override
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The SHA-256 fingerprint of the SSH public key.
     * </pre>
     *
     * <code>string fingerprint = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for fingerprint.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 4;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Output only. The canonical resource name.
     * </pre>
     *
     * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The canonical resource name.
     * </pre>
     *
     * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getKeyBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
      }
      if (expirationTimeUsec_ != 0L) {
        output.writeInt64(2, expirationTimeUsec_);
      }
      if (!getFingerprintBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, fingerprint_);
      }
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, name_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getKeyBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
      }
      if (expirationTimeUsec_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, expirationTimeUsec_);
      }
      if (!getFingerprintBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, fingerprint_);
      }
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, name_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey)) {
        return super.equals(obj);
      }
      com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey other =
          (com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey) obj;

      if (!getKey().equals(other.getKey())) return false;
      if (getExpirationTimeUsec() != other.getExpirationTimeUsec()) return false;
      if (!getFingerprint().equals(other.getFingerprint())) return false;
      if (!getName().equals(other.getName())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      hash = (37 * hash) + EXPIRATION_TIME_USEC_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getExpirationTimeUsec());
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The SSH public key information associated with a Google account.
     * </pre>
     *
     * Protobuf type {@code google.cloud.oslogin.common.SshPublicKey}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.oslogin.common.SshPublicKey)
        com.google.cloud.oslogin.common.OsLoginProto.SshPublicKeyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.oslogin.common.OsLoginProto
            .internal_static_google_cloud_oslogin_common_SshPublicKey_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.oslogin.common.OsLoginProto
            .internal_static_google_cloud_oslogin_common_SshPublicKey_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.class,
                com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.Builder.class);
      }

      // Construct using com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        key_ = "";

        expirationTimeUsec_ = 0L;

        fingerprint_ = "";

        name_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.oslogin.common.OsLoginProto
            .internal_static_google_cloud_oslogin_common_SshPublicKey_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey getDefaultInstanceForType() {
        return com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey build() {
        com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey buildPartial() {
        com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey result =
            new com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey(this);
        result.key_ = key_;
        result.expirationTimeUsec_ = expirationTimeUsec_;
        result.fingerprint_ = fingerprint_;
        result.name_ = name_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey) {
          return mergeFrom((com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey other) {
        if (other == com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey.getDefaultInstance())
          return this;
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          onChanged();
        }
        if (other.getExpirationTimeUsec() != 0L) {
          setExpirationTimeUsec(other.getExpirationTimeUsec());
        }
        if (!other.getFingerprint().isEmpty()) {
          fingerprint_ = other.fingerprint_;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object key_ = "";
      /**
       *
       *
       * <pre>
       * Public key text in SSH format, defined by
       * &lt;a href="https://www.ietf.org/rfc/rfc4253.txt" target="_blank"&gt;RFC4253&lt;/a&gt;
       * section 6.6.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The key.
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Public key text in SSH format, defined by
       * &lt;a href="https://www.ietf.org/rfc/rfc4253.txt" target="_blank"&gt;RFC4253&lt;/a&gt;
       * section 6.6.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The bytes for key.
       */
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Public key text in SSH format, defined by
       * &lt;a href="https://www.ietf.org/rfc/rfc4253.txt" target="_blank"&gt;RFC4253&lt;/a&gt;
       * section 6.6.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        key_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Public key text in SSH format, defined by
       * &lt;a href="https://www.ietf.org/rfc/rfc4253.txt" target="_blank"&gt;RFC4253&lt;/a&gt;
       * section 6.6.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKey() {

        key_ = getDefaultInstance().getKey();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Public key text in SSH format, defined by
       * &lt;a href="https://www.ietf.org/rfc/rfc4253.txt" target="_blank"&gt;RFC4253&lt;/a&gt;
       * section 6.6.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        key_ = value;
        onChanged();
        return this;
      }

      private long expirationTimeUsec_;
      /**
       *
       *
       * <pre>
       * An expiration time in microseconds since epoch.
       * </pre>
       *
       * <code>int64 expiration_time_usec = 2;</code>
       *
       * @return The expirationTimeUsec.
       */
      @java.lang.Override
      public long getExpirationTimeUsec() {
        return expirationTimeUsec_;
      }
      /**
       *
       *
       * <pre>
       * An expiration time in microseconds since epoch.
       * </pre>
       *
       * <code>int64 expiration_time_usec = 2;</code>
       *
       * @param value The expirationTimeUsec to set.
       * @return This builder for chaining.
       */
      public Builder setExpirationTimeUsec(long value) {

        expirationTimeUsec_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An expiration time in microseconds since epoch.
       * </pre>
       *
       * <code>int64 expiration_time_usec = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExpirationTimeUsec() {

        expirationTimeUsec_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object fingerprint_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The SHA-256 fingerprint of the SSH public key.
       * </pre>
       *
       * <code>string fingerprint = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The fingerprint.
       */
      public java.lang.String getFingerprint() {
        java.lang.Object ref = fingerprint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fingerprint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The SHA-256 fingerprint of the SSH public key.
       * </pre>
       *
       * <code>string fingerprint = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for fingerprint.
       */
      public com.google.protobuf.ByteString getFingerprintBytes() {
        java.lang.Object ref = fingerprint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fingerprint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The SHA-256 fingerprint of the SSH public key.
       * </pre>
       *
       * <code>string fingerprint = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The fingerprint to set.
       * @return This builder for chaining.
       */
      public Builder setFingerprint(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        fingerprint_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The SHA-256 fingerprint of the SSH public key.
       * </pre>
       *
       * <code>string fingerprint = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFingerprint() {

        fingerprint_ = getDefaultInstance().getFingerprint();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The SHA-256 fingerprint of the SSH public key.
       * </pre>
       *
       * <code>string fingerprint = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for fingerprint to set.
       * @return This builder for chaining.
       */
      public Builder setFingerprintBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        fingerprint_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The canonical resource name.
       * </pre>
       *
       * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The canonical resource name.
       * </pre>
       *
       * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The canonical resource name.
       * </pre>
       *
       * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The canonical resource name.
       * </pre>
       *
       * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The canonical resource name.
       * </pre>
       *
       * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.oslogin.common.SshPublicKey)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.oslogin.common.SshPublicKey)
    private static final com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey();
    }

    public static com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SshPublicKey> PARSER =
        new com.google.protobuf.AbstractParser<SshPublicKey>() {
          @java.lang.Override
          public SshPublicKey parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new SshPublicKey(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<SshPublicKey> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SshPublicKey> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.oslogin.common.OsLoginProto.SshPublicKey getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_oslogin_common_PosixAccount_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_oslogin_common_PosixAccount_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_oslogin_common_SshPublicKey_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_oslogin_common_SshPublicKey_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor getDescriptor() {
    return descriptor;
  }

  private static com.google.protobuf.Descriptors.FileDescriptor descriptor;

  static {
    java.lang.String[] descriptorData = {
      "\n(google/cloud/oslogin/common/common.pro"
          + "to\022\033google.cloud.oslogin.common\032\037google/"
          + "api/field_behavior.proto\032\031google/api/res"
          + "ource.proto\"\334\002\n\014PosixAccount\022\017\n\007primary\030"
          + "\001 \001(\010\022\020\n\010username\030\002 \001(\t\022\013\n\003uid\030\003 \001(\003\022\013\n\003"
          + "gid\030\004 \001(\003\022\026\n\016home_directory\030\005 \001(\t\022\r\n\005she"
          + "ll\030\006 \001(\t\022\r\n\005gecos\030\007 \001(\t\022\021\n\tsystem_id\030\010 \001"
          + "(\t\022\027\n\naccount_id\030\t \001(\tB\003\340A\003\022O\n\025operating"
          + "_system_type\030\n \001(\01620.google.cloud.oslogi"
          + "n.common.OperatingSystemType\022\021\n\004name\030\013 \001"
          + "(\tB\003\340A\003:I\352AF\n#oslogin.googleapis.com/Pos"
          + "ixAccount\022\037users/{user}/projects/{projec"
          + "t}\"\272\001\n\014SshPublicKey\022\013\n\003key\030\001 \001(\t\022\034\n\024expi"
          + "ration_time_usec\030\002 \001(\003\022\030\n\013fingerprint\030\003 "
          + "\001(\tB\003\340A\003\022\021\n\004name\030\004 \001(\tB\003\340A\003:R\352AO\n#oslogi"
          + "n.googleapis.com/SshPublicKey\022(users/{us"
          + "er}/sshPublicKeys/{fingerprint}*T\n\023Opera"
          + "tingSystemType\022%\n!OPERATING_SYSTEM_TYPE_"
          + "UNSPECIFIED\020\000\022\t\n\005LINUX\020\001\022\013\n\007WINDOWS\020\002B\375\001"
          + "\n\037com.google.cloud.oslogin.commonB\014OsLog"
          + "inProtoZAgoogle.golang.org/genproto/goog"
          + "leapis/cloud/oslogin/common;common\252\002\033Goo"
          + "gle.Cloud.OsLogin.Common\312\002\033Google\\Cloud\\"
          + "OsLogin\\Common\352\002\036Google::Cloud::OsLogin:"
          + ":Common\352A+\n\033oslogin.googleapis.com/User\022"
          + "\014users/{user}b\006proto3"
    };
    descriptor =
        com.google.protobuf.Descriptors.FileDescriptor.internalBuildGeneratedFileFrom(
            descriptorData,
            new com.google.protobuf.Descriptors.FileDescriptor[] {
              com.google.api.FieldBehaviorProto.getDescriptor(),
              com.google.api.ResourceProto.getDescriptor(),
            });
    internal_static_google_cloud_oslogin_common_PosixAccount_descriptor =
        getDescriptor().getMessageTypes().get(0);
    internal_static_google_cloud_oslogin_common_PosixAccount_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_oslogin_common_PosixAccount_descriptor,
            new java.lang.String[] {
              "Primary",
              "Username",
              "Uid",
              "Gid",
              "HomeDirectory",
              "Shell",
              "Gecos",
              "SystemId",
              "AccountId",
              "OperatingSystemType",
              "Name",
            });
    internal_static_google_cloud_oslogin_common_SshPublicKey_descriptor =
        getDescriptor().getMessageTypes().get(1);
    internal_static_google_cloud_oslogin_common_SshPublicKey_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_oslogin_common_SshPublicKey_descriptor,
            new java.lang.String[] {
              "Key", "ExpirationTimeUsec", "Fingerprint", "Name",
            });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.google.api.FieldBehaviorProto.fieldBehavior);
    registry.add(com.google.api.ResourceProto.resource);
    registry.add(com.google.api.ResourceProto.resourceDefinition);
    com.google.protobuf.Descriptors.FileDescriptor.internalUpdateFileDescriptor(
        descriptor, registry);
    com.google.api.FieldBehaviorProto.getDescriptor();
    com.google.api.ResourceProto.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
