/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/parametermanager/v1/service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.parametermanager.v1;

/**
 *
 *
 * <pre>
 * Message for creating a Parameter
 * </pre>
 *
 * Protobuf type {@code google.cloud.parametermanager.v1.CreateParameterRequest}
 */
public final class CreateParameterRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.parametermanager.v1.CreateParameterRequest)
    CreateParameterRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CreateParameterRequest.newBuilder() to construct.
  private CreateParameterRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateParameterRequest() {
    parent_ = "";
    parameterId_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateParameterRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.parametermanager.v1.V1mainProto
        .internal_static_google_cloud_parametermanager_v1_CreateParameterRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.parametermanager.v1.V1mainProto
        .internal_static_google_cloud_parametermanager_v1_CreateParameterRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.parametermanager.v1.CreateParameterRequest.class,
            com.google.cloud.parametermanager.v1.CreateParameterRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. Value for parent in the format
   * `projects/&#42;&#47;locations/&#42;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Value for parent in the format
   * `projects/&#42;&#47;locations/&#42;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMETER_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parameterId_ = "";

  /**
   *
   *
   * <pre>
   * Required. Id of the Parameter resource
   * </pre>
   *
   * <code>string parameter_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parameterId.
   */
  @java.lang.Override
  public java.lang.String getParameterId() {
    java.lang.Object ref = parameterId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parameterId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Id of the Parameter resource
   * </pre>
   *
   * <code>string parameter_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parameterId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParameterIdBytes() {
    java.lang.Object ref = parameterId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parameterId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMETER_FIELD_NUMBER = 3;
  private com.google.cloud.parametermanager.v1.Parameter parameter_;

  /**
   *
   *
   * <pre>
   * Required. The Parameter resource being created
   * </pre>
   *
   * <code>
   * .google.cloud.parametermanager.v1.Parameter parameter = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the parameter field is set.
   */
  @java.lang.Override
  public boolean hasParameter() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The Parameter resource being created
   * </pre>
   *
   * <code>
   * .google.cloud.parametermanager.v1.Parameter parameter = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The parameter.
   */
  @java.lang.Override
  public com.google.cloud.parametermanager.v1.Parameter getParameter() {
    return parameter_ == null
        ? com.google.cloud.parametermanager.v1.Parameter.getDefaultInstance()
        : parameter_;
  }

  /**
   *
   *
   * <pre>
   * Required. The Parameter resource being created
   * </pre>
   *
   * <code>
   * .google.cloud.parametermanager.v1.Parameter parameter = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.parametermanager.v1.ParameterOrBuilder getParameterOrBuilder() {
    return parameter_ == null
        ? com.google.cloud.parametermanager.v1.Parameter.getDefaultInstance()
        : parameter_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";

  /**
   *
   *
   * <pre>
   * Optional. An optional request ID to identify requests. Specify a unique
   * request ID so that if you must retry your request, the server will know to
   * ignore the request if it has already been completed. The server will
   * guarantee that for at least 60 minutes since the first request.
   *
   * For example, consider a situation where you make an initial request and the
   * request times out. If you make the request again with the same request
   * ID, the server can check if original operation with the same request ID
   * was received, and if so, will ignore the second request. This prevents
   * clients from accidentally creating duplicate commitments.
   *
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>
   * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. An optional request ID to identify requests. Specify a unique
   * request ID so that if you must retry your request, the server will know to
   * ignore the request if it has already been completed. The server will
   * guarantee that for at least 60 minutes since the first request.
   *
   * For example, consider a situation where you make an initial request and the
   * request times out. If you make the request again with the same request
   * ID, the server can check if original operation with the same request ID
   * was received, and if so, will ignore the second request. This prevents
   * clients from accidentally creating duplicate commitments.
   *
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>
   * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parameterId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, parameterId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getParameter());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, requestId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parameterId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, parameterId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getParameter());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, requestId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.parametermanager.v1.CreateParameterRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.parametermanager.v1.CreateParameterRequest other =
        (com.google.cloud.parametermanager.v1.CreateParameterRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getParameterId().equals(other.getParameterId())) return false;
    if (hasParameter() != other.hasParameter()) return false;
    if (hasParameter()) {
      if (!getParameter().equals(other.getParameter())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PARAMETER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getParameterId().hashCode();
    if (hasParameter()) {
      hash = (37 * hash) + PARAMETER_FIELD_NUMBER;
      hash = (53 * hash) + getParameter().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.parametermanager.v1.CreateParameterRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.parametermanager.v1.CreateParameterRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.parametermanager.v1.CreateParameterRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.parametermanager.v1.CreateParameterRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.parametermanager.v1.CreateParameterRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.parametermanager.v1.CreateParameterRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.parametermanager.v1.CreateParameterRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.parametermanager.v1.CreateParameterRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.parametermanager.v1.CreateParameterRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.parametermanager.v1.CreateParameterRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.parametermanager.v1.CreateParameterRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.parametermanager.v1.CreateParameterRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.parametermanager.v1.CreateParameterRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Message for creating a Parameter
   * </pre>
   *
   * Protobuf type {@code google.cloud.parametermanager.v1.CreateParameterRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.parametermanager.v1.CreateParameterRequest)
      com.google.cloud.parametermanager.v1.CreateParameterRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.parametermanager.v1.V1mainProto
          .internal_static_google_cloud_parametermanager_v1_CreateParameterRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.parametermanager.v1.V1mainProto
          .internal_static_google_cloud_parametermanager_v1_CreateParameterRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.parametermanager.v1.CreateParameterRequest.class,
              com.google.cloud.parametermanager.v1.CreateParameterRequest.Builder.class);
    }

    // Construct using com.google.cloud.parametermanager.v1.CreateParameterRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getParameterFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      parameterId_ = "";
      parameter_ = null;
      if (parameterBuilder_ != null) {
        parameterBuilder_.dispose();
        parameterBuilder_ = null;
      }
      requestId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.parametermanager.v1.V1mainProto
          .internal_static_google_cloud_parametermanager_v1_CreateParameterRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.parametermanager.v1.CreateParameterRequest getDefaultInstanceForType() {
      return com.google.cloud.parametermanager.v1.CreateParameterRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.parametermanager.v1.CreateParameterRequest build() {
      com.google.cloud.parametermanager.v1.CreateParameterRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.parametermanager.v1.CreateParameterRequest buildPartial() {
      com.google.cloud.parametermanager.v1.CreateParameterRequest result =
          new com.google.cloud.parametermanager.v1.CreateParameterRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.parametermanager.v1.CreateParameterRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parameterId_ = parameterId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parameter_ = parameterBuilder_ == null ? parameter_ : parameterBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestId_ = requestId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.parametermanager.v1.CreateParameterRequest) {
        return mergeFrom((com.google.cloud.parametermanager.v1.CreateParameterRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.parametermanager.v1.CreateParameterRequest other) {
      if (other == com.google.cloud.parametermanager.v1.CreateParameterRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getParameterId().isEmpty()) {
        parameterId_ = other.parameterId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasParameter()) {
        mergeParameter(other.getParameter());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                parameterId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getParameterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. Value for parent in the format
     * `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Value for parent in the format
     * `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Value for parent in the format
     * `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Value for parent in the format
     * `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Value for parent in the format
     * `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object parameterId_ = "";

    /**
     *
     *
     * <pre>
     * Required. Id of the Parameter resource
     * </pre>
     *
     * <code>string parameter_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parameterId.
     */
    public java.lang.String getParameterId() {
      java.lang.Object ref = parameterId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parameterId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Id of the Parameter resource
     * </pre>
     *
     * <code>string parameter_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parameterId.
     */
    public com.google.protobuf.ByteString getParameterIdBytes() {
      java.lang.Object ref = parameterId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parameterId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Id of the Parameter resource
     * </pre>
     *
     * <code>string parameter_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parameterId to set.
     * @return This builder for chaining.
     */
    public Builder setParameterId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parameterId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Id of the Parameter resource
     * </pre>
     *
     * <code>string parameter_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParameterId() {
      parameterId_ = getDefaultInstance().getParameterId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Id of the Parameter resource
     * </pre>
     *
     * <code>string parameter_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parameterId to set.
     * @return This builder for chaining.
     */
    public Builder setParameterIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parameterId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.parametermanager.v1.Parameter parameter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.parametermanager.v1.Parameter,
            com.google.cloud.parametermanager.v1.Parameter.Builder,
            com.google.cloud.parametermanager.v1.ParameterOrBuilder>
        parameterBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The Parameter resource being created
     * </pre>
     *
     * <code>
     * .google.cloud.parametermanager.v1.Parameter parameter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the parameter field is set.
     */
    public boolean hasParameter() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The Parameter resource being created
     * </pre>
     *
     * <code>
     * .google.cloud.parametermanager.v1.Parameter parameter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The parameter.
     */
    public com.google.cloud.parametermanager.v1.Parameter getParameter() {
      if (parameterBuilder_ == null) {
        return parameter_ == null
            ? com.google.cloud.parametermanager.v1.Parameter.getDefaultInstance()
            : parameter_;
      } else {
        return parameterBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The Parameter resource being created
     * </pre>
     *
     * <code>
     * .google.cloud.parametermanager.v1.Parameter parameter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setParameter(com.google.cloud.parametermanager.v1.Parameter value) {
      if (parameterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameter_ = value;
      } else {
        parameterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The Parameter resource being created
     * </pre>
     *
     * <code>
     * .google.cloud.parametermanager.v1.Parameter parameter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setParameter(
        com.google.cloud.parametermanager.v1.Parameter.Builder builderForValue) {
      if (parameterBuilder_ == null) {
        parameter_ = builderForValue.build();
      } else {
        parameterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The Parameter resource being created
     * </pre>
     *
     * <code>
     * .google.cloud.parametermanager.v1.Parameter parameter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeParameter(com.google.cloud.parametermanager.v1.Parameter value) {
      if (parameterBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && parameter_ != null
            && parameter_ != com.google.cloud.parametermanager.v1.Parameter.getDefaultInstance()) {
          getParameterBuilder().mergeFrom(value);
        } else {
          parameter_ = value;
        }
      } else {
        parameterBuilder_.mergeFrom(value);
      }
      if (parameter_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The Parameter resource being created
     * </pre>
     *
     * <code>
     * .google.cloud.parametermanager.v1.Parameter parameter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearParameter() {
      bitField0_ = (bitField0_ & ~0x00000004);
      parameter_ = null;
      if (parameterBuilder_ != null) {
        parameterBuilder_.dispose();
        parameterBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The Parameter resource being created
     * </pre>
     *
     * <code>
     * .google.cloud.parametermanager.v1.Parameter parameter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.parametermanager.v1.Parameter.Builder getParameterBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getParameterFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The Parameter resource being created
     * </pre>
     *
     * <code>
     * .google.cloud.parametermanager.v1.Parameter parameter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.parametermanager.v1.ParameterOrBuilder getParameterOrBuilder() {
      if (parameterBuilder_ != null) {
        return parameterBuilder_.getMessageOrBuilder();
      } else {
        return parameter_ == null
            ? com.google.cloud.parametermanager.v1.Parameter.getDefaultInstance()
            : parameter_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The Parameter resource being created
     * </pre>
     *
     * <code>
     * .google.cloud.parametermanager.v1.Parameter parameter = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.parametermanager.v1.Parameter,
            com.google.cloud.parametermanager.v1.Parameter.Builder,
            com.google.cloud.parametermanager.v1.ParameterOrBuilder>
        getParameterFieldBuilder() {
      if (parameterBuilder_ == null) {
        parameterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.parametermanager.v1.Parameter,
                com.google.cloud.parametermanager.v1.Parameter.Builder,
                com.google.cloud.parametermanager.v1.ParameterOrBuilder>(
                getParameter(), getParentForChildren(), isClean());
        parameter_ = null;
      }
      return parameterBuilder_;
    }

    private java.lang.Object requestId_ = "";

    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>
     * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>
     * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>
     * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>
     * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>
     * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.parametermanager.v1.CreateParameterRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.parametermanager.v1.CreateParameterRequest)
  private static final com.google.cloud.parametermanager.v1.CreateParameterRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.parametermanager.v1.CreateParameterRequest();
  }

  public static com.google.cloud.parametermanager.v1.CreateParameterRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateParameterRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateParameterRequest>() {
        @java.lang.Override
        public CreateParameterRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateParameterRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateParameterRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.parametermanager.v1.CreateParameterRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
