/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/explanations.proto

package com.google.cloud.policysimulator.v1;

/**
 *
 *
 * <pre>
 * Whether a principal has a permission for a resource.
 * </pre>
 *
 * Protobuf enum {@code google.cloud.policysimulator.v1.AccessState}
 */
public enum AccessState implements com.google.protobuf.ProtocolMessageEnum {
  /**
   *
   *
   * <pre>
   * Default value. This value is unused.
   * </pre>
   *
   * <code>ACCESS_STATE_UNSPECIFIED = 0;</code>
   */
  ACCESS_STATE_UNSPECIFIED(0),
  /**
   *
   *
   * <pre>
   * The principal has the permission.
   * </pre>
   *
   * <code>GRANTED = 1;</code>
   */
  GRANTED(1),
  /**
   *
   *
   * <pre>
   * The principal does not have the permission.
   * </pre>
   *
   * <code>NOT_GRANTED = 2;</code>
   */
  NOT_GRANTED(2),
  /**
   *
   *
   * <pre>
   * The principal has the permission only if a condition expression evaluates
   * to `true`.
   * </pre>
   *
   * <code>UNKNOWN_CONDITIONAL = 3;</code>
   */
  UNKNOWN_CONDITIONAL(3),
  /**
   *
   *
   * <pre>
   * The user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to all of the policies that Policy Simulator needs to evaluate.
   * </pre>
   *
   * <code>UNKNOWN_INFO_DENIED = 4;</code>
   */
  UNKNOWN_INFO_DENIED(4),
  UNRECOGNIZED(-1),
  ;

  /**
   *
   *
   * <pre>
   * Default value. This value is unused.
   * </pre>
   *
   * <code>ACCESS_STATE_UNSPECIFIED = 0;</code>
   */
  public static final int ACCESS_STATE_UNSPECIFIED_VALUE = 0;
  /**
   *
   *
   * <pre>
   * The principal has the permission.
   * </pre>
   *
   * <code>GRANTED = 1;</code>
   */
  public static final int GRANTED_VALUE = 1;
  /**
   *
   *
   * <pre>
   * The principal does not have the permission.
   * </pre>
   *
   * <code>NOT_GRANTED = 2;</code>
   */
  public static final int NOT_GRANTED_VALUE = 2;
  /**
   *
   *
   * <pre>
   * The principal has the permission only if a condition expression evaluates
   * to `true`.
   * </pre>
   *
   * <code>UNKNOWN_CONDITIONAL = 3;</code>
   */
  public static final int UNKNOWN_CONDITIONAL_VALUE = 3;
  /**
   *
   *
   * <pre>
   * The user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to all of the policies that Policy Simulator needs to evaluate.
   * </pre>
   *
   * <code>UNKNOWN_INFO_DENIED = 4;</code>
   */
  public static final int UNKNOWN_INFO_DENIED_VALUE = 4;

  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static AccessState valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static AccessState forNumber(int value) {
    switch (value) {
      case 0:
        return ACCESS_STATE_UNSPECIFIED;
      case 1:
        return GRANTED;
      case 2:
        return NOT_GRANTED;
      case 3:
        return UNKNOWN_CONDITIONAL;
      case 4:
        return UNKNOWN_INFO_DENIED;
      default:
        return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<AccessState> internalGetValueMap() {
    return internalValueMap;
  }

  private static final com.google.protobuf.Internal.EnumLiteMap<AccessState> internalValueMap =
      new com.google.protobuf.Internal.EnumLiteMap<AccessState>() {
        public AccessState findValueByNumber(int number) {
          return AccessState.forNumber(number);
        }
      };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalStateException(
          "Can't get the descriptor of an unrecognized enum value.");
    }
    return getDescriptor().getValues().get(ordinal());
  }

  public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
    return getDescriptor();
  }

  public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
    return com.google.cloud.policysimulator.v1.ExplanationsProto.getDescriptor()
        .getEnumTypes()
        .get(0);
  }

  private static final AccessState[] VALUES = values();

  public static AccessState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private AccessState(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.cloud.policysimulator.v1.AccessState)
}
