/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/simulator.proto

package com.google.cloud.policysimulator.v1;

/**
 *
 *
 * <pre>
 * A summary and comparison of the principal's access under the current
 * (baseline) policies and the proposed (simulated) policies for a single
 * access tuple.
 * </pre>
 *
 * Protobuf type {@code google.cloud.policysimulator.v1.AccessStateDiff}
 */
public final class AccessStateDiff extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.policysimulator.v1.AccessStateDiff)
    AccessStateDiffOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AccessStateDiff.newBuilder() to construct.
  private AccessStateDiff(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AccessStateDiff() {
    accessChange_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AccessStateDiff();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.policysimulator.v1.SimulatorProto
        .internal_static_google_cloud_policysimulator_v1_AccessStateDiff_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.policysimulator.v1.SimulatorProto
        .internal_static_google_cloud_policysimulator_v1_AccessStateDiff_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.policysimulator.v1.AccessStateDiff.class,
            com.google.cloud.policysimulator.v1.AccessStateDiff.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * How the principal's access, specified in the AccessState field, changed
   * between the current (baseline) policies and proposed (simulated) policies.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType}
   */
  public enum AccessChangeType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>ACCESS_CHANGE_TYPE_UNSPECIFIED = 0;</code>
     */
    ACCESS_CHANGE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The principal's access did not change.
     * This includes the case where both baseline and simulated are UNKNOWN,
     * but the unknown information is equivalent.
     * </pre>
     *
     * <code>NO_CHANGE = 1;</code>
     */
    NO_CHANGE(1),
    /**
     *
     *
     * <pre>
     * The principal's access under both the current policies and the proposed
     * policies is `UNKNOWN`, but the unknown information differs between them.
     * </pre>
     *
     * <code>UNKNOWN_CHANGE = 2;</code>
     */
    UNKNOWN_CHANGE(2),
    /**
     *
     *
     * <pre>
     * The principal had access under the current policies (`GRANTED`), but will
     * no longer have access after the proposed changes (`NOT_GRANTED`).
     * </pre>
     *
     * <code>ACCESS_REVOKED = 3;</code>
     */
    ACCESS_REVOKED(3),
    /**
     *
     *
     * <pre>
     * The principal did not have access under the current policies
     * (`NOT_GRANTED`), but will have access after the proposed changes
     * (`GRANTED`).
     * </pre>
     *
     * <code>ACCESS_GAINED = 4;</code>
     */
    ACCESS_GAINED(4),
    /**
     *
     *
     * <pre>
     * This result can occur for the following reasons:
     *
     * * The principal had access under the current policies (`GRANTED`), but
     *   their access after the proposed changes is `UNKNOWN`.
     *
     * * The principal's access under the current policies is `UNKNOWN`, but
     * they
     *   will not have access after the proposed changes (`NOT_GRANTED`).
     * </pre>
     *
     * <code>ACCESS_MAYBE_REVOKED = 5;</code>
     */
    ACCESS_MAYBE_REVOKED(5),
    /**
     *
     *
     * <pre>
     * This result can occur for the following reasons:
     *
     * * The principal did not have access under the current policies
     *   (`NOT_GRANTED`), but their access after the proposed changes is
     *   `UNKNOWN`.
     *
     * * The principal's access under the current policies is `UNKNOWN`, but
     * they will have access after the proposed changes (`GRANTED`).
     * </pre>
     *
     * <code>ACCESS_MAYBE_GAINED = 6;</code>
     */
    ACCESS_MAYBE_GAINED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>ACCESS_CHANGE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int ACCESS_CHANGE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The principal's access did not change.
     * This includes the case where both baseline and simulated are UNKNOWN,
     * but the unknown information is equivalent.
     * </pre>
     *
     * <code>NO_CHANGE = 1;</code>
     */
    public static final int NO_CHANGE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The principal's access under both the current policies and the proposed
     * policies is `UNKNOWN`, but the unknown information differs between them.
     * </pre>
     *
     * <code>UNKNOWN_CHANGE = 2;</code>
     */
    public static final int UNKNOWN_CHANGE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The principal had access under the current policies (`GRANTED`), but will
     * no longer have access after the proposed changes (`NOT_GRANTED`).
     * </pre>
     *
     * <code>ACCESS_REVOKED = 3;</code>
     */
    public static final int ACCESS_REVOKED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The principal did not have access under the current policies
     * (`NOT_GRANTED`), but will have access after the proposed changes
     * (`GRANTED`).
     * </pre>
     *
     * <code>ACCESS_GAINED = 4;</code>
     */
    public static final int ACCESS_GAINED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * This result can occur for the following reasons:
     *
     * * The principal had access under the current policies (`GRANTED`), but
     *   their access after the proposed changes is `UNKNOWN`.
     *
     * * The principal's access under the current policies is `UNKNOWN`, but
     * they
     *   will not have access after the proposed changes (`NOT_GRANTED`).
     * </pre>
     *
     * <code>ACCESS_MAYBE_REVOKED = 5;</code>
     */
    public static final int ACCESS_MAYBE_REVOKED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * This result can occur for the following reasons:
     *
     * * The principal did not have access under the current policies
     *   (`NOT_GRANTED`), but their access after the proposed changes is
     *   `UNKNOWN`.
     *
     * * The principal's access under the current policies is `UNKNOWN`, but
     * they will have access after the proposed changes (`GRANTED`).
     * </pre>
     *
     * <code>ACCESS_MAYBE_GAINED = 6;</code>
     */
    public static final int ACCESS_MAYBE_GAINED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AccessChangeType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AccessChangeType forNumber(int value) {
      switch (value) {
        case 0:
          return ACCESS_CHANGE_TYPE_UNSPECIFIED;
        case 1:
          return NO_CHANGE;
        case 2:
          return UNKNOWN_CHANGE;
        case 3:
          return ACCESS_REVOKED;
        case 4:
          return ACCESS_GAINED;
        case 5:
          return ACCESS_MAYBE_REVOKED;
        case 6:
          return ACCESS_MAYBE_GAINED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AccessChangeType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AccessChangeType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AccessChangeType>() {
              public AccessChangeType findValueByNumber(int number) {
                return AccessChangeType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.AccessStateDiff.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final AccessChangeType[] VALUES = values();

    public static AccessChangeType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AccessChangeType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType)
  }

  public static final int BASELINE_FIELD_NUMBER = 1;
  private com.google.cloud.policysimulator.v1.ExplainedAccess baseline_;
  /**
   *
   *
   * <pre>
   * The results of evaluating the access tuple under the current (baseline)
   * policies.
   *
   * If the [AccessState][google.cloud.policysimulator.v1.AccessState] couldn't
   * be fully evaluated, this field explains why.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ExplainedAccess baseline = 1;</code>
   *
   * @return Whether the baseline field is set.
   */
  @java.lang.Override
  public boolean hasBaseline() {
    return baseline_ != null;
  }
  /**
   *
   *
   * <pre>
   * The results of evaluating the access tuple under the current (baseline)
   * policies.
   *
   * If the [AccessState][google.cloud.policysimulator.v1.AccessState] couldn't
   * be fully evaluated, this field explains why.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ExplainedAccess baseline = 1;</code>
   *
   * @return The baseline.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ExplainedAccess getBaseline() {
    return baseline_ == null
        ? com.google.cloud.policysimulator.v1.ExplainedAccess.getDefaultInstance()
        : baseline_;
  }
  /**
   *
   *
   * <pre>
   * The results of evaluating the access tuple under the current (baseline)
   * policies.
   *
   * If the [AccessState][google.cloud.policysimulator.v1.AccessState] couldn't
   * be fully evaluated, this field explains why.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ExplainedAccess baseline = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ExplainedAccessOrBuilder getBaselineOrBuilder() {
    return baseline_ == null
        ? com.google.cloud.policysimulator.v1.ExplainedAccess.getDefaultInstance()
        : baseline_;
  }

  public static final int SIMULATED_FIELD_NUMBER = 2;
  private com.google.cloud.policysimulator.v1.ExplainedAccess simulated_;
  /**
   *
   *
   * <pre>
   * The results of evaluating the access tuple under the proposed (simulated)
   * policies.
   *
   * If the AccessState couldn't be fully evaluated, this field explains why.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ExplainedAccess simulated = 2;</code>
   *
   * @return Whether the simulated field is set.
   */
  @java.lang.Override
  public boolean hasSimulated() {
    return simulated_ != null;
  }
  /**
   *
   *
   * <pre>
   * The results of evaluating the access tuple under the proposed (simulated)
   * policies.
   *
   * If the AccessState couldn't be fully evaluated, this field explains why.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ExplainedAccess simulated = 2;</code>
   *
   * @return The simulated.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ExplainedAccess getSimulated() {
    return simulated_ == null
        ? com.google.cloud.policysimulator.v1.ExplainedAccess.getDefaultInstance()
        : simulated_;
  }
  /**
   *
   *
   * <pre>
   * The results of evaluating the access tuple under the proposed (simulated)
   * policies.
   *
   * If the AccessState couldn't be fully evaluated, this field explains why.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ExplainedAccess simulated = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ExplainedAccessOrBuilder getSimulatedOrBuilder() {
    return simulated_ == null
        ? com.google.cloud.policysimulator.v1.ExplainedAccess.getDefaultInstance()
        : simulated_;
  }

  public static final int ACCESS_CHANGE_FIELD_NUMBER = 3;
  private int accessChange_ = 0;
  /**
   *
   *
   * <pre>
   * How the principal's access, specified in the AccessState field, changed
   * between the current (baseline) policies and proposed (simulated) policies.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType access_change = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for accessChange.
   */
  @java.lang.Override
  public int getAccessChangeValue() {
    return accessChange_;
  }
  /**
   *
   *
   * <pre>
   * How the principal's access, specified in the AccessState field, changed
   * between the current (baseline) policies and proposed (simulated) policies.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType access_change = 3;
   * </code>
   *
   * @return The accessChange.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType getAccessChange() {
    com.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType result =
        com.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType.forNumber(
            accessChange_);
    return result == null
        ? com.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (baseline_ != null) {
      output.writeMessage(1, getBaseline());
    }
    if (simulated_ != null) {
      output.writeMessage(2, getSimulated());
    }
    if (accessChange_
        != com.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType
            .ACCESS_CHANGE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, accessChange_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (baseline_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getBaseline());
    }
    if (simulated_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSimulated());
    }
    if (accessChange_
        != com.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType
            .ACCESS_CHANGE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, accessChange_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.policysimulator.v1.AccessStateDiff)) {
      return super.equals(obj);
    }
    com.google.cloud.policysimulator.v1.AccessStateDiff other =
        (com.google.cloud.policysimulator.v1.AccessStateDiff) obj;

    if (hasBaseline() != other.hasBaseline()) return false;
    if (hasBaseline()) {
      if (!getBaseline().equals(other.getBaseline())) return false;
    }
    if (hasSimulated() != other.hasSimulated()) return false;
    if (hasSimulated()) {
      if (!getSimulated().equals(other.getSimulated())) return false;
    }
    if (accessChange_ != other.accessChange_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBaseline()) {
      hash = (37 * hash) + BASELINE_FIELD_NUMBER;
      hash = (53 * hash) + getBaseline().hashCode();
    }
    if (hasSimulated()) {
      hash = (37 * hash) + SIMULATED_FIELD_NUMBER;
      hash = (53 * hash) + getSimulated().hashCode();
    }
    hash = (37 * hash) + ACCESS_CHANGE_FIELD_NUMBER;
    hash = (53 * hash) + accessChange_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.policysimulator.v1.AccessStateDiff parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.AccessStateDiff parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.AccessStateDiff parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.AccessStateDiff parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.AccessStateDiff parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.AccessStateDiff parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.AccessStateDiff parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.AccessStateDiff parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.AccessStateDiff parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.AccessStateDiff parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.AccessStateDiff parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.AccessStateDiff parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.policysimulator.v1.AccessStateDiff prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A summary and comparison of the principal's access under the current
   * (baseline) policies and the proposed (simulated) policies for a single
   * access tuple.
   * </pre>
   *
   * Protobuf type {@code google.cloud.policysimulator.v1.AccessStateDiff}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.policysimulator.v1.AccessStateDiff)
      com.google.cloud.policysimulator.v1.AccessStateDiffOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_AccessStateDiff_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_AccessStateDiff_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.policysimulator.v1.AccessStateDiff.class,
              com.google.cloud.policysimulator.v1.AccessStateDiff.Builder.class);
    }

    // Construct using com.google.cloud.policysimulator.v1.AccessStateDiff.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      baseline_ = null;
      if (baselineBuilder_ != null) {
        baselineBuilder_.dispose();
        baselineBuilder_ = null;
      }
      simulated_ = null;
      if (simulatedBuilder_ != null) {
        simulatedBuilder_.dispose();
        simulatedBuilder_ = null;
      }
      accessChange_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_AccessStateDiff_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.AccessStateDiff getDefaultInstanceForType() {
      return com.google.cloud.policysimulator.v1.AccessStateDiff.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.AccessStateDiff build() {
      com.google.cloud.policysimulator.v1.AccessStateDiff result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.AccessStateDiff buildPartial() {
      com.google.cloud.policysimulator.v1.AccessStateDiff result =
          new com.google.cloud.policysimulator.v1.AccessStateDiff(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.policysimulator.v1.AccessStateDiff result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.baseline_ = baselineBuilder_ == null ? baseline_ : baselineBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.simulated_ = simulatedBuilder_ == null ? simulated_ : simulatedBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.accessChange_ = accessChange_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.policysimulator.v1.AccessStateDiff) {
        return mergeFrom((com.google.cloud.policysimulator.v1.AccessStateDiff) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.policysimulator.v1.AccessStateDiff other) {
      if (other == com.google.cloud.policysimulator.v1.AccessStateDiff.getDefaultInstance())
        return this;
      if (other.hasBaseline()) {
        mergeBaseline(other.getBaseline());
      }
      if (other.hasSimulated()) {
        mergeSimulated(other.getSimulated());
      }
      if (other.accessChange_ != 0) {
        setAccessChangeValue(other.getAccessChangeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getBaselineFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSimulatedFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                accessChange_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.policysimulator.v1.ExplainedAccess baseline_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.policysimulator.v1.ExplainedAccess,
            com.google.cloud.policysimulator.v1.ExplainedAccess.Builder,
            com.google.cloud.policysimulator.v1.ExplainedAccessOrBuilder>
        baselineBuilder_;
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the current (baseline)
     * policies.
     *
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] couldn't
     * be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess baseline = 1;</code>
     *
     * @return Whether the baseline field is set.
     */
    public boolean hasBaseline() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the current (baseline)
     * policies.
     *
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] couldn't
     * be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess baseline = 1;</code>
     *
     * @return The baseline.
     */
    public com.google.cloud.policysimulator.v1.ExplainedAccess getBaseline() {
      if (baselineBuilder_ == null) {
        return baseline_ == null
            ? com.google.cloud.policysimulator.v1.ExplainedAccess.getDefaultInstance()
            : baseline_;
      } else {
        return baselineBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the current (baseline)
     * policies.
     *
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] couldn't
     * be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess baseline = 1;</code>
     */
    public Builder setBaseline(com.google.cloud.policysimulator.v1.ExplainedAccess value) {
      if (baselineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        baseline_ = value;
      } else {
        baselineBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the current (baseline)
     * policies.
     *
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] couldn't
     * be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess baseline = 1;</code>
     */
    public Builder setBaseline(
        com.google.cloud.policysimulator.v1.ExplainedAccess.Builder builderForValue) {
      if (baselineBuilder_ == null) {
        baseline_ = builderForValue.build();
      } else {
        baselineBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the current (baseline)
     * policies.
     *
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] couldn't
     * be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess baseline = 1;</code>
     */
    public Builder mergeBaseline(com.google.cloud.policysimulator.v1.ExplainedAccess value) {
      if (baselineBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && baseline_ != null
            && baseline_
                != com.google.cloud.policysimulator.v1.ExplainedAccess.getDefaultInstance()) {
          getBaselineBuilder().mergeFrom(value);
        } else {
          baseline_ = value;
        }
      } else {
        baselineBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the current (baseline)
     * policies.
     *
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] couldn't
     * be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess baseline = 1;</code>
     */
    public Builder clearBaseline() {
      bitField0_ = (bitField0_ & ~0x00000001);
      baseline_ = null;
      if (baselineBuilder_ != null) {
        baselineBuilder_.dispose();
        baselineBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the current (baseline)
     * policies.
     *
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] couldn't
     * be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess baseline = 1;</code>
     */
    public com.google.cloud.policysimulator.v1.ExplainedAccess.Builder getBaselineBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getBaselineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the current (baseline)
     * policies.
     *
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] couldn't
     * be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess baseline = 1;</code>
     */
    public com.google.cloud.policysimulator.v1.ExplainedAccessOrBuilder getBaselineOrBuilder() {
      if (baselineBuilder_ != null) {
        return baselineBuilder_.getMessageOrBuilder();
      } else {
        return baseline_ == null
            ? com.google.cloud.policysimulator.v1.ExplainedAccess.getDefaultInstance()
            : baseline_;
      }
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the current (baseline)
     * policies.
     *
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] couldn't
     * be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess baseline = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.policysimulator.v1.ExplainedAccess,
            com.google.cloud.policysimulator.v1.ExplainedAccess.Builder,
            com.google.cloud.policysimulator.v1.ExplainedAccessOrBuilder>
        getBaselineFieldBuilder() {
      if (baselineBuilder_ == null) {
        baselineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.policysimulator.v1.ExplainedAccess,
                com.google.cloud.policysimulator.v1.ExplainedAccess.Builder,
                com.google.cloud.policysimulator.v1.ExplainedAccessOrBuilder>(
                getBaseline(), getParentForChildren(), isClean());
        baseline_ = null;
      }
      return baselineBuilder_;
    }

    private com.google.cloud.policysimulator.v1.ExplainedAccess simulated_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.policysimulator.v1.ExplainedAccess,
            com.google.cloud.policysimulator.v1.ExplainedAccess.Builder,
            com.google.cloud.policysimulator.v1.ExplainedAccessOrBuilder>
        simulatedBuilder_;
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the proposed (simulated)
     * policies.
     *
     * If the AccessState couldn't be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess simulated = 2;</code>
     *
     * @return Whether the simulated field is set.
     */
    public boolean hasSimulated() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the proposed (simulated)
     * policies.
     *
     * If the AccessState couldn't be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess simulated = 2;</code>
     *
     * @return The simulated.
     */
    public com.google.cloud.policysimulator.v1.ExplainedAccess getSimulated() {
      if (simulatedBuilder_ == null) {
        return simulated_ == null
            ? com.google.cloud.policysimulator.v1.ExplainedAccess.getDefaultInstance()
            : simulated_;
      } else {
        return simulatedBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the proposed (simulated)
     * policies.
     *
     * If the AccessState couldn't be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess simulated = 2;</code>
     */
    public Builder setSimulated(com.google.cloud.policysimulator.v1.ExplainedAccess value) {
      if (simulatedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        simulated_ = value;
      } else {
        simulatedBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the proposed (simulated)
     * policies.
     *
     * If the AccessState couldn't be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess simulated = 2;</code>
     */
    public Builder setSimulated(
        com.google.cloud.policysimulator.v1.ExplainedAccess.Builder builderForValue) {
      if (simulatedBuilder_ == null) {
        simulated_ = builderForValue.build();
      } else {
        simulatedBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the proposed (simulated)
     * policies.
     *
     * If the AccessState couldn't be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess simulated = 2;</code>
     */
    public Builder mergeSimulated(com.google.cloud.policysimulator.v1.ExplainedAccess value) {
      if (simulatedBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && simulated_ != null
            && simulated_
                != com.google.cloud.policysimulator.v1.ExplainedAccess.getDefaultInstance()) {
          getSimulatedBuilder().mergeFrom(value);
        } else {
          simulated_ = value;
        }
      } else {
        simulatedBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the proposed (simulated)
     * policies.
     *
     * If the AccessState couldn't be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess simulated = 2;</code>
     */
    public Builder clearSimulated() {
      bitField0_ = (bitField0_ & ~0x00000002);
      simulated_ = null;
      if (simulatedBuilder_ != null) {
        simulatedBuilder_.dispose();
        simulatedBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the proposed (simulated)
     * policies.
     *
     * If the AccessState couldn't be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess simulated = 2;</code>
     */
    public com.google.cloud.policysimulator.v1.ExplainedAccess.Builder getSimulatedBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSimulatedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the proposed (simulated)
     * policies.
     *
     * If the AccessState couldn't be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess simulated = 2;</code>
     */
    public com.google.cloud.policysimulator.v1.ExplainedAccessOrBuilder getSimulatedOrBuilder() {
      if (simulatedBuilder_ != null) {
        return simulatedBuilder_.getMessageOrBuilder();
      } else {
        return simulated_ == null
            ? com.google.cloud.policysimulator.v1.ExplainedAccess.getDefaultInstance()
            : simulated_;
      }
    }
    /**
     *
     *
     * <pre>
     * The results of evaluating the access tuple under the proposed (simulated)
     * policies.
     *
     * If the AccessState couldn't be fully evaluated, this field explains why.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ExplainedAccess simulated = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.policysimulator.v1.ExplainedAccess,
            com.google.cloud.policysimulator.v1.ExplainedAccess.Builder,
            com.google.cloud.policysimulator.v1.ExplainedAccessOrBuilder>
        getSimulatedFieldBuilder() {
      if (simulatedBuilder_ == null) {
        simulatedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.policysimulator.v1.ExplainedAccess,
                com.google.cloud.policysimulator.v1.ExplainedAccess.Builder,
                com.google.cloud.policysimulator.v1.ExplainedAccessOrBuilder>(
                getSimulated(), getParentForChildren(), isClean());
        simulated_ = null;
      }
      return simulatedBuilder_;
    }

    private int accessChange_ = 0;
    /**
     *
     *
     * <pre>
     * How the principal's access, specified in the AccessState field, changed
     * between the current (baseline) policies and proposed (simulated) policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType access_change = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for accessChange.
     */
    @java.lang.Override
    public int getAccessChangeValue() {
      return accessChange_;
    }
    /**
     *
     *
     * <pre>
     * How the principal's access, specified in the AccessState field, changed
     * between the current (baseline) policies and proposed (simulated) policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType access_change = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for accessChange to set.
     * @return This builder for chaining.
     */
    public Builder setAccessChangeValue(int value) {
      accessChange_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How the principal's access, specified in the AccessState field, changed
     * between the current (baseline) policies and proposed (simulated) policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType access_change = 3;
     * </code>
     *
     * @return The accessChange.
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType getAccessChange() {
      com.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType result =
          com.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType.forNumber(
              accessChange_);
      return result == null
          ? com.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * How the principal's access, specified in the AccessState field, changed
     * between the current (baseline) policies and proposed (simulated) policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType access_change = 3;
     * </code>
     *
     * @param value The accessChange to set.
     * @return This builder for chaining.
     */
    public Builder setAccessChange(
        com.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      accessChange_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How the principal's access, specified in the AccessState field, changed
     * between the current (baseline) policies and proposed (simulated) policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessStateDiff.AccessChangeType access_change = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAccessChange() {
      bitField0_ = (bitField0_ & ~0x00000004);
      accessChange_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.policysimulator.v1.AccessStateDiff)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.policysimulator.v1.AccessStateDiff)
  private static final com.google.cloud.policysimulator.v1.AccessStateDiff DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.policysimulator.v1.AccessStateDiff();
  }

  public static com.google.cloud.policysimulator.v1.AccessStateDiff getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AccessStateDiff> PARSER =
      new com.google.protobuf.AbstractParser<AccessStateDiff>() {
        @java.lang.Override
        public AccessStateDiff parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AccessStateDiff> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AccessStateDiff> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.policysimulator.v1.AccessStateDiff getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
