/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/explanations.proto

package com.google.cloud.policysimulator.v1;

/**
 *
 *
 * <pre>
 * Information about the principal, resource, and permission to check.
 * </pre>
 *
 * Protobuf type {@code google.cloud.policysimulator.v1.AccessTuple}
 */
public final class AccessTuple extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.policysimulator.v1.AccessTuple)
    AccessTupleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AccessTuple.newBuilder() to construct.
  private AccessTuple(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AccessTuple() {
    principal_ = "";
    fullResourceName_ = "";
    permission_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AccessTuple();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.policysimulator.v1.ExplanationsProto
        .internal_static_google_cloud_policysimulator_v1_AccessTuple_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.policysimulator.v1.ExplanationsProto
        .internal_static_google_cloud_policysimulator_v1_AccessTuple_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.policysimulator.v1.AccessTuple.class,
            com.google.cloud.policysimulator.v1.AccessTuple.Builder.class);
  }

  public static final int PRINCIPAL_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object principal_ = "";
  /**
   *
   *
   * <pre>
   * Required. The principal whose access you want to check, in the form of
   * the email address that represents that principal. For example,
   * `alice&#64;example.com` or
   * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
   *
   * The principal must be a Google Account or a service account. Other types of
   * principals are not supported.
   * </pre>
   *
   * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The principal.
   */
  @java.lang.Override
  public java.lang.String getPrincipal() {
    java.lang.Object ref = principal_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      principal_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The principal whose access you want to check, in the form of
   * the email address that represents that principal. For example,
   * `alice&#64;example.com` or
   * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
   *
   * The principal must be a Google Account or a service account. Other types of
   * principals are not supported.
   * </pre>
   *
   * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for principal.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrincipalBytes() {
    java.lang.Object ref = principal_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      principal_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FULL_RESOURCE_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fullResourceName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The full resource name that identifies the resource. For example,
   * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
   *
   * For examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   * </pre>
   *
   * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The fullResourceName.
   */
  @java.lang.Override
  public java.lang.String getFullResourceName() {
    java.lang.Object ref = fullResourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fullResourceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The full resource name that identifies the resource. For example,
   * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
   *
   * For examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   * </pre>
   *
   * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for fullResourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFullResourceNameBytes() {
    java.lang.Object ref = fullResourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fullResourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PERMISSION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object permission_ = "";
  /**
   *
   *
   * <pre>
   * Required. The IAM permission to check for the specified principal and
   * resource.
   *
   * For a complete list of IAM permissions, see
   * https://cloud.google.com/iam/help/permissions/reference.
   *
   * For a complete list of predefined IAM roles and the permissions in each
   * role, see https://cloud.google.com/iam/help/roles/reference.
   * </pre>
   *
   * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The permission.
   */
  @java.lang.Override
  public java.lang.String getPermission() {
    java.lang.Object ref = permission_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      permission_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The IAM permission to check for the specified principal and
   * resource.
   *
   * For a complete list of IAM permissions, see
   * https://cloud.google.com/iam/help/permissions/reference.
   *
   * For a complete list of predefined IAM roles and the permissions in each
   * role, see https://cloud.google.com/iam/help/roles/reference.
   * </pre>
   *
   * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for permission.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPermissionBytes() {
    java.lang.Object ref = permission_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      permission_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principal_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, principal_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullResourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fullResourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(permission_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, permission_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principal_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, principal_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullResourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fullResourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(permission_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, permission_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.policysimulator.v1.AccessTuple)) {
      return super.equals(obj);
    }
    com.google.cloud.policysimulator.v1.AccessTuple other =
        (com.google.cloud.policysimulator.v1.AccessTuple) obj;

    if (!getPrincipal().equals(other.getPrincipal())) return false;
    if (!getFullResourceName().equals(other.getFullResourceName())) return false;
    if (!getPermission().equals(other.getPermission())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PRINCIPAL_FIELD_NUMBER;
    hash = (53 * hash) + getPrincipal().hashCode();
    hash = (37 * hash) + FULL_RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFullResourceName().hashCode();
    hash = (37 * hash) + PERMISSION_FIELD_NUMBER;
    hash = (53 * hash) + getPermission().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.policysimulator.v1.AccessTuple parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.AccessTuple parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.AccessTuple parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.AccessTuple parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.AccessTuple parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.AccessTuple parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.AccessTuple parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.AccessTuple parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.AccessTuple parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.AccessTuple parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.AccessTuple parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.AccessTuple parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.policysimulator.v1.AccessTuple prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information about the principal, resource, and permission to check.
   * </pre>
   *
   * Protobuf type {@code google.cloud.policysimulator.v1.AccessTuple}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.policysimulator.v1.AccessTuple)
      com.google.cloud.policysimulator.v1.AccessTupleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.ExplanationsProto
          .internal_static_google_cloud_policysimulator_v1_AccessTuple_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.policysimulator.v1.ExplanationsProto
          .internal_static_google_cloud_policysimulator_v1_AccessTuple_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.policysimulator.v1.AccessTuple.class,
              com.google.cloud.policysimulator.v1.AccessTuple.Builder.class);
    }

    // Construct using com.google.cloud.policysimulator.v1.AccessTuple.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      principal_ = "";
      fullResourceName_ = "";
      permission_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.policysimulator.v1.ExplanationsProto
          .internal_static_google_cloud_policysimulator_v1_AccessTuple_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.AccessTuple getDefaultInstanceForType() {
      return com.google.cloud.policysimulator.v1.AccessTuple.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.AccessTuple build() {
      com.google.cloud.policysimulator.v1.AccessTuple result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.AccessTuple buildPartial() {
      com.google.cloud.policysimulator.v1.AccessTuple result =
          new com.google.cloud.policysimulator.v1.AccessTuple(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.policysimulator.v1.AccessTuple result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.principal_ = principal_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.fullResourceName_ = fullResourceName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.permission_ = permission_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.policysimulator.v1.AccessTuple) {
        return mergeFrom((com.google.cloud.policysimulator.v1.AccessTuple) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.policysimulator.v1.AccessTuple other) {
      if (other == com.google.cloud.policysimulator.v1.AccessTuple.getDefaultInstance())
        return this;
      if (!other.getPrincipal().isEmpty()) {
        principal_ = other.principal_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getFullResourceName().isEmpty()) {
        fullResourceName_ = other.fullResourceName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getPermission().isEmpty()) {
        permission_ = other.permission_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                principal_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                fullResourceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                permission_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object principal_ = "";
    /**
     *
     *
     * <pre>
     * Required. The principal whose access you want to check, in the form of
     * the email address that represents that principal. For example,
     * `alice&#64;example.com` or
     * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
     *
     * The principal must be a Google Account or a service account. Other types of
     * principals are not supported.
     * </pre>
     *
     * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The principal.
     */
    public java.lang.String getPrincipal() {
      java.lang.Object ref = principal_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        principal_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The principal whose access you want to check, in the form of
     * the email address that represents that principal. For example,
     * `alice&#64;example.com` or
     * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
     *
     * The principal must be a Google Account or a service account. Other types of
     * principals are not supported.
     * </pre>
     *
     * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for principal.
     */
    public com.google.protobuf.ByteString getPrincipalBytes() {
      java.lang.Object ref = principal_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        principal_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The principal whose access you want to check, in the form of
     * the email address that represents that principal. For example,
     * `alice&#64;example.com` or
     * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
     *
     * The principal must be a Google Account or a service account. Other types of
     * principals are not supported.
     * </pre>
     *
     * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The principal to set.
     * @return This builder for chaining.
     */
    public Builder setPrincipal(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      principal_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The principal whose access you want to check, in the form of
     * the email address that represents that principal. For example,
     * `alice&#64;example.com` or
     * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
     *
     * The principal must be a Google Account or a service account. Other types of
     * principals are not supported.
     * </pre>
     *
     * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrincipal() {
      principal_ = getDefaultInstance().getPrincipal();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The principal whose access you want to check, in the form of
     * the email address that represents that principal. For example,
     * `alice&#64;example.com` or
     * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
     *
     * The principal must be a Google Account or a service account. Other types of
     * principals are not supported.
     * </pre>
     *
     * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for principal to set.
     * @return This builder for chaining.
     */
    public Builder setPrincipalBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      principal_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object fullResourceName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     *
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The fullResourceName.
     */
    public java.lang.String getFullResourceName() {
      java.lang.Object ref = fullResourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fullResourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     *
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for fullResourceName.
     */
    public com.google.protobuf.ByteString getFullResourceNameBytes() {
      java.lang.Object ref = fullResourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fullResourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     *
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The fullResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setFullResourceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fullResourceName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     *
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFullResourceName() {
      fullResourceName_ = getDefaultInstance().getFullResourceName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     *
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for fullResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setFullResourceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fullResourceName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object permission_ = "";
    /**
     *
     *
     * <pre>
     * Required. The IAM permission to check for the specified principal and
     * resource.
     *
     * For a complete list of IAM permissions, see
     * https://cloud.google.com/iam/help/permissions/reference.
     *
     * For a complete list of predefined IAM roles and the permissions in each
     * role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The permission.
     */
    public java.lang.String getPermission() {
      java.lang.Object ref = permission_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        permission_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The IAM permission to check for the specified principal and
     * resource.
     *
     * For a complete list of IAM permissions, see
     * https://cloud.google.com/iam/help/permissions/reference.
     *
     * For a complete list of predefined IAM roles and the permissions in each
     * role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for permission.
     */
    public com.google.protobuf.ByteString getPermissionBytes() {
      java.lang.Object ref = permission_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        permission_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The IAM permission to check for the specified principal and
     * resource.
     *
     * For a complete list of IAM permissions, see
     * https://cloud.google.com/iam/help/permissions/reference.
     *
     * For a complete list of predefined IAM roles and the permissions in each
     * role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The permission to set.
     * @return This builder for chaining.
     */
    public Builder setPermission(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      permission_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The IAM permission to check for the specified principal and
     * resource.
     *
     * For a complete list of IAM permissions, see
     * https://cloud.google.com/iam/help/permissions/reference.
     *
     * For a complete list of predefined IAM roles and the permissions in each
     * role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPermission() {
      permission_ = getDefaultInstance().getPermission();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The IAM permission to check for the specified principal and
     * resource.
     *
     * For a complete list of IAM permissions, see
     * https://cloud.google.com/iam/help/permissions/reference.
     *
     * For a complete list of predefined IAM roles and the permissions in each
     * role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for permission to set.
     * @return This builder for chaining.
     */
    public Builder setPermissionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      permission_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.policysimulator.v1.AccessTuple)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.policysimulator.v1.AccessTuple)
  private static final com.google.cloud.policysimulator.v1.AccessTuple DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.policysimulator.v1.AccessTuple();
  }

  public static com.google.cloud.policysimulator.v1.AccessTuple getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AccessTuple> PARSER =
      new com.google.protobuf.AbstractParser<AccessTuple>() {
        @java.lang.Override
        public AccessTuple parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AccessTuple> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AccessTuple> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.policysimulator.v1.AccessTuple getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
