/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/explanations.proto

package com.google.cloud.policysimulator.v1;

public interface AccessTupleOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.policysimulator.v1.AccessTuple)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The principal whose access you want to check, in the form of
   * the email address that represents that principal. For example,
   * `alice&#64;example.com` or
   * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
   *
   * The principal must be a Google Account or a service account. Other types of
   * principals are not supported.
   * </pre>
   *
   * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The principal.
   */
  java.lang.String getPrincipal();
  /**
   *
   *
   * <pre>
   * Required. The principal whose access you want to check, in the form of
   * the email address that represents that principal. For example,
   * `alice&#64;example.com` or
   * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
   *
   * The principal must be a Google Account or a service account. Other types of
   * principals are not supported.
   * </pre>
   *
   * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for principal.
   */
  com.google.protobuf.ByteString getPrincipalBytes();

  /**
   *
   *
   * <pre>
   * Required. The full resource name that identifies the resource. For example,
   * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
   *
   * For examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   * </pre>
   *
   * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The fullResourceName.
   */
  java.lang.String getFullResourceName();
  /**
   *
   *
   * <pre>
   * Required. The full resource name that identifies the resource. For example,
   * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
   *
   * For examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   * </pre>
   *
   * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for fullResourceName.
   */
  com.google.protobuf.ByteString getFullResourceNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The IAM permission to check for the specified principal and
   * resource.
   *
   * For a complete list of IAM permissions, see
   * https://cloud.google.com/iam/help/permissions/reference.
   *
   * For a complete list of predefined IAM roles and the permissions in each
   * role, see https://cloud.google.com/iam/help/roles/reference.
   * </pre>
   *
   * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The permission.
   */
  java.lang.String getPermission();
  /**
   *
   *
   * <pre>
   * Required. The IAM permission to check for the specified principal and
   * resource.
   *
   * For a complete list of IAM permissions, see
   * https://cloud.google.com/iam/help/permissions/reference.
   *
   * For a complete list of predefined IAM roles and the permissions in each
   * role, see https://cloud.google.com/iam/help/roles/reference.
   * </pre>
   *
   * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for permission.
   */
  com.google.protobuf.ByteString getPermissionBytes();
}
