/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/explanations.proto

package com.google.cloud.policysimulator.v1;

/**
 *
 *
 * <pre>
 * Details about how a binding in a policy affects a principal's ability to use
 * a permission.
 * </pre>
 *
 * Protobuf type {@code google.cloud.policysimulator.v1.BindingExplanation}
 */
public final class BindingExplanation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.policysimulator.v1.BindingExplanation)
    BindingExplanationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BindingExplanation.newBuilder() to construct.
  private BindingExplanation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BindingExplanation() {
    access_ = 0;
    role_ = "";
    rolePermission_ = 0;
    rolePermissionRelevance_ = 0;
    relevance_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BindingExplanation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.policysimulator.v1.ExplanationsProto
        .internal_static_google_cloud_policysimulator_v1_BindingExplanation_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetMemberships();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.policysimulator.v1.ExplanationsProto
        .internal_static_google_cloud_policysimulator_v1_BindingExplanation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.policysimulator.v1.BindingExplanation.class,
            com.google.cloud.policysimulator.v1.BindingExplanation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Whether a role includes a specific permission.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.policysimulator.v1.BindingExplanation.RolePermission}
   */
  public enum RolePermission implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>ROLE_PERMISSION_UNSPECIFIED = 0;</code>
     */
    ROLE_PERMISSION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The permission is included in the role.
     * </pre>
     *
     * <code>ROLE_PERMISSION_INCLUDED = 1;</code>
     */
    ROLE_PERMISSION_INCLUDED(1),
    /**
     *
     *
     * <pre>
     * The permission is not included in the role.
     * </pre>
     *
     * <code>ROLE_PERMISSION_NOT_INCLUDED = 2;</code>
     */
    ROLE_PERMISSION_NOT_INCLUDED(2),
    /**
     *
     *
     * <pre>
     * The user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] is not
     * allowed to access the binding.
     * </pre>
     *
     * <code>ROLE_PERMISSION_UNKNOWN_INFO_DENIED = 3;</code>
     */
    ROLE_PERMISSION_UNKNOWN_INFO_DENIED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>ROLE_PERMISSION_UNSPECIFIED = 0;</code>
     */
    public static final int ROLE_PERMISSION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The permission is included in the role.
     * </pre>
     *
     * <code>ROLE_PERMISSION_INCLUDED = 1;</code>
     */
    public static final int ROLE_PERMISSION_INCLUDED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The permission is not included in the role.
     * </pre>
     *
     * <code>ROLE_PERMISSION_NOT_INCLUDED = 2;</code>
     */
    public static final int ROLE_PERMISSION_NOT_INCLUDED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] is not
     * allowed to access the binding.
     * </pre>
     *
     * <code>ROLE_PERMISSION_UNKNOWN_INFO_DENIED = 3;</code>
     */
    public static final int ROLE_PERMISSION_UNKNOWN_INFO_DENIED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RolePermission valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RolePermission forNumber(int value) {
      switch (value) {
        case 0:
          return ROLE_PERMISSION_UNSPECIFIED;
        case 1:
          return ROLE_PERMISSION_INCLUDED;
        case 2:
          return ROLE_PERMISSION_NOT_INCLUDED;
        case 3:
          return ROLE_PERMISSION_UNKNOWN_INFO_DENIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RolePermission> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RolePermission> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RolePermission>() {
          public RolePermission findValueByNumber(int number) {
            return RolePermission.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.BindingExplanation.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final RolePermission[] VALUES = values();

    public static RolePermission valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RolePermission(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.policysimulator.v1.BindingExplanation.RolePermission)
  }

  /**
   *
   *
   * <pre>
   * Whether the binding includes the principal.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.policysimulator.v1.BindingExplanation.Membership}
   */
  public enum Membership implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>MEMBERSHIP_UNSPECIFIED = 0;</code>
     */
    MEMBERSHIP_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The binding includes the principal. The principal can be included
     * directly or indirectly. For example:
     *
     * * A principal is included directly if that principal is listed in the
     *   binding.
     * * A principal is included indirectly if that principal is in a Google
     *   group or Google Workspace domain that is listed in the binding.
     * </pre>
     *
     * <code>MEMBERSHIP_INCLUDED = 1;</code>
     */
    MEMBERSHIP_INCLUDED(1),
    /**
     *
     *
     * <pre>
     * The binding does not include the principal.
     * </pre>
     *
     * <code>MEMBERSHIP_NOT_INCLUDED = 2;</code>
     */
    MEMBERSHIP_NOT_INCLUDED(2),
    /**
     *
     *
     * <pre>
     * The user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] is not
     * allowed to access the binding.
     * </pre>
     *
     * <code>MEMBERSHIP_UNKNOWN_INFO_DENIED = 3;</code>
     */
    MEMBERSHIP_UNKNOWN_INFO_DENIED(3),
    /**
     *
     *
     * <pre>
     * The principal is an unsupported type. Only Google Accounts and service
     * accounts are supported.
     * </pre>
     *
     * <code>MEMBERSHIP_UNKNOWN_UNSUPPORTED = 4;</code>
     */
    MEMBERSHIP_UNKNOWN_UNSUPPORTED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>MEMBERSHIP_UNSPECIFIED = 0;</code>
     */
    public static final int MEMBERSHIP_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The binding includes the principal. The principal can be included
     * directly or indirectly. For example:
     *
     * * A principal is included directly if that principal is listed in the
     *   binding.
     * * A principal is included indirectly if that principal is in a Google
     *   group or Google Workspace domain that is listed in the binding.
     * </pre>
     *
     * <code>MEMBERSHIP_INCLUDED = 1;</code>
     */
    public static final int MEMBERSHIP_INCLUDED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The binding does not include the principal.
     * </pre>
     *
     * <code>MEMBERSHIP_NOT_INCLUDED = 2;</code>
     */
    public static final int MEMBERSHIP_NOT_INCLUDED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] is not
     * allowed to access the binding.
     * </pre>
     *
     * <code>MEMBERSHIP_UNKNOWN_INFO_DENIED = 3;</code>
     */
    public static final int MEMBERSHIP_UNKNOWN_INFO_DENIED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The principal is an unsupported type. Only Google Accounts and service
     * accounts are supported.
     * </pre>
     *
     * <code>MEMBERSHIP_UNKNOWN_UNSUPPORTED = 4;</code>
     */
    public static final int MEMBERSHIP_UNKNOWN_UNSUPPORTED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Membership valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Membership forNumber(int value) {
      switch (value) {
        case 0:
          return MEMBERSHIP_UNSPECIFIED;
        case 1:
          return MEMBERSHIP_INCLUDED;
        case 2:
          return MEMBERSHIP_NOT_INCLUDED;
        case 3:
          return MEMBERSHIP_UNKNOWN_INFO_DENIED;
        case 4:
          return MEMBERSHIP_UNKNOWN_UNSUPPORTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Membership> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Membership> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Membership>() {
          public Membership findValueByNumber(int number) {
            return Membership.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.BindingExplanation.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Membership[] VALUES = values();

    public static Membership valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Membership(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.policysimulator.v1.BindingExplanation.Membership)
  }

  public interface AnnotatedMembershipOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Indicates whether the binding includes the principal.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.BindingExplanation.Membership membership = 1;</code>
     *
     * @return The enum numeric value on the wire for membership.
     */
    int getMembershipValue();
    /**
     *
     *
     * <pre>
     * Indicates whether the binding includes the principal.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.BindingExplanation.Membership membership = 1;</code>
     *
     * @return The membership.
     */
    com.google.cloud.policysimulator.v1.BindingExplanation.Membership getMembership();

    /**
     *
     *
     * <pre>
     * The relevance of the principal's status to the overall determination for
     * the binding.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 2;</code>
     *
     * @return The enum numeric value on the wire for relevance.
     */
    int getRelevanceValue();
    /**
     *
     *
     * <pre>
     * The relevance of the principal's status to the overall determination for
     * the binding.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 2;</code>
     *
     * @return The relevance.
     */
    com.google.cloud.policysimulator.v1.HeuristicRelevance getRelevance();
  }
  /**
   *
   *
   * <pre>
   * Details about whether the binding includes the principal.
   * </pre>
   *
   * Protobuf type {@code google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership}
   */
  public static final class AnnotatedMembership extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership)
      AnnotatedMembershipOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnnotatedMembership.newBuilder() to construct.
    private AnnotatedMembership(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnnotatedMembership() {
      membership_ = 0;
      relevance_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnnotatedMembership();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.ExplanationsProto
          .internal_static_google_cloud_policysimulator_v1_BindingExplanation_AnnotatedMembership_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.policysimulator.v1.ExplanationsProto
          .internal_static_google_cloud_policysimulator_v1_BindingExplanation_AnnotatedMembership_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership.class,
              com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership.Builder
                  .class);
    }

    public static final int MEMBERSHIP_FIELD_NUMBER = 1;
    private int membership_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates whether the binding includes the principal.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.BindingExplanation.Membership membership = 1;</code>
     *
     * @return The enum numeric value on the wire for membership.
     */
    @java.lang.Override
    public int getMembershipValue() {
      return membership_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the binding includes the principal.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.BindingExplanation.Membership membership = 1;</code>
     *
     * @return The membership.
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.BindingExplanation.Membership getMembership() {
      com.google.cloud.policysimulator.v1.BindingExplanation.Membership result =
          com.google.cloud.policysimulator.v1.BindingExplanation.Membership.forNumber(membership_);
      return result == null
          ? com.google.cloud.policysimulator.v1.BindingExplanation.Membership.UNRECOGNIZED
          : result;
    }

    public static final int RELEVANCE_FIELD_NUMBER = 2;
    private int relevance_ = 0;
    /**
     *
     *
     * <pre>
     * The relevance of the principal's status to the overall determination for
     * the binding.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 2;</code>
     *
     * @return The enum numeric value on the wire for relevance.
     */
    @java.lang.Override
    public int getRelevanceValue() {
      return relevance_;
    }
    /**
     *
     *
     * <pre>
     * The relevance of the principal's status to the overall determination for
     * the binding.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 2;</code>
     *
     * @return The relevance.
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.HeuristicRelevance getRelevance() {
      com.google.cloud.policysimulator.v1.HeuristicRelevance result =
          com.google.cloud.policysimulator.v1.HeuristicRelevance.forNumber(relevance_);
      return result == null
          ? com.google.cloud.policysimulator.v1.HeuristicRelevance.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (membership_
          != com.google.cloud.policysimulator.v1.BindingExplanation.Membership
              .MEMBERSHIP_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, membership_);
      }
      if (relevance_
          != com.google.cloud.policysimulator.v1.HeuristicRelevance.HEURISTIC_RELEVANCE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, relevance_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (membership_
          != com.google.cloud.policysimulator.v1.BindingExplanation.Membership
              .MEMBERSHIP_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, membership_);
      }
      if (relevance_
          != com.google.cloud.policysimulator.v1.HeuristicRelevance.HEURISTIC_RELEVANCE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, relevance_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership)) {
        return super.equals(obj);
      }
      com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership other =
          (com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership) obj;

      if (membership_ != other.membership_) return false;
      if (relevance_ != other.relevance_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MEMBERSHIP_FIELD_NUMBER;
      hash = (53 * hash) + membership_;
      hash = (37 * hash) + RELEVANCE_FIELD_NUMBER;
      hash = (53 * hash) + relevance_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details about whether the binding includes the principal.
     * </pre>
     *
     * Protobuf type {@code google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership)
        com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembershipOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.policysimulator.v1.ExplanationsProto
            .internal_static_google_cloud_policysimulator_v1_BindingExplanation_AnnotatedMembership_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.policysimulator.v1.ExplanationsProto
            .internal_static_google_cloud_policysimulator_v1_BindingExplanation_AnnotatedMembership_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership.class,
                com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        membership_ = 0;
        relevance_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.policysimulator.v1.ExplanationsProto
            .internal_static_google_cloud_policysimulator_v1_BindingExplanation_AnnotatedMembership_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
          getDefaultInstanceForType() {
        return com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership build() {
        com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
          buildPartial() {
        com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership result =
            new com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.membership_ = membership_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.relevance_ = relevance_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership) {
          return mergeFrom(
              (com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership other) {
        if (other
            == com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
                .getDefaultInstance()) return this;
        if (other.membership_ != 0) {
          setMembershipValue(other.getMembershipValue());
        }
        if (other.relevance_ != 0) {
          setRelevanceValue(other.getRelevanceValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  membership_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  relevance_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int membership_ = 0;
      /**
       *
       *
       * <pre>
       * Indicates whether the binding includes the principal.
       * </pre>
       *
       * <code>.google.cloud.policysimulator.v1.BindingExplanation.Membership membership = 1;</code>
       *
       * @return The enum numeric value on the wire for membership.
       */
      @java.lang.Override
      public int getMembershipValue() {
        return membership_;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the binding includes the principal.
       * </pre>
       *
       * <code>.google.cloud.policysimulator.v1.BindingExplanation.Membership membership = 1;</code>
       *
       * @param value The enum numeric value on the wire for membership to set.
       * @return This builder for chaining.
       */
      public Builder setMembershipValue(int value) {
        membership_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the binding includes the principal.
       * </pre>
       *
       * <code>.google.cloud.policysimulator.v1.BindingExplanation.Membership membership = 1;</code>
       *
       * @return The membership.
       */
      @java.lang.Override
      public com.google.cloud.policysimulator.v1.BindingExplanation.Membership getMembership() {
        com.google.cloud.policysimulator.v1.BindingExplanation.Membership result =
            com.google.cloud.policysimulator.v1.BindingExplanation.Membership.forNumber(
                membership_);
        return result == null
            ? com.google.cloud.policysimulator.v1.BindingExplanation.Membership.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the binding includes the principal.
       * </pre>
       *
       * <code>.google.cloud.policysimulator.v1.BindingExplanation.Membership membership = 1;</code>
       *
       * @param value The membership to set.
       * @return This builder for chaining.
       */
      public Builder setMembership(
          com.google.cloud.policysimulator.v1.BindingExplanation.Membership value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        membership_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the binding includes the principal.
       * </pre>
       *
       * <code>.google.cloud.policysimulator.v1.BindingExplanation.Membership membership = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMembership() {
        bitField0_ = (bitField0_ & ~0x00000001);
        membership_ = 0;
        onChanged();
        return this;
      }

      private int relevance_ = 0;
      /**
       *
       *
       * <pre>
       * The relevance of the principal's status to the overall determination for
       * the binding.
       * </pre>
       *
       * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 2;</code>
       *
       * @return The enum numeric value on the wire for relevance.
       */
      @java.lang.Override
      public int getRelevanceValue() {
        return relevance_;
      }
      /**
       *
       *
       * <pre>
       * The relevance of the principal's status to the overall determination for
       * the binding.
       * </pre>
       *
       * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 2;</code>
       *
       * @param value The enum numeric value on the wire for relevance to set.
       * @return This builder for chaining.
       */
      public Builder setRelevanceValue(int value) {
        relevance_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The relevance of the principal's status to the overall determination for
       * the binding.
       * </pre>
       *
       * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 2;</code>
       *
       * @return The relevance.
       */
      @java.lang.Override
      public com.google.cloud.policysimulator.v1.HeuristicRelevance getRelevance() {
        com.google.cloud.policysimulator.v1.HeuristicRelevance result =
            com.google.cloud.policysimulator.v1.HeuristicRelevance.forNumber(relevance_);
        return result == null
            ? com.google.cloud.policysimulator.v1.HeuristicRelevance.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The relevance of the principal's status to the overall determination for
       * the binding.
       * </pre>
       *
       * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 2;</code>
       *
       * @param value The relevance to set.
       * @return This builder for chaining.
       */
      public Builder setRelevance(com.google.cloud.policysimulator.v1.HeuristicRelevance value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        relevance_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The relevance of the principal's status to the overall determination for
       * the binding.
       * </pre>
       *
       * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRelevance() {
        bitField0_ = (bitField0_ & ~0x00000002);
        relevance_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership)
    private static final com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership();
    }

    public static com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnnotatedMembership> PARSER =
        new com.google.protobuf.AbstractParser<AnnotatedMembership>() {
          @java.lang.Override
          public AnnotatedMembership parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AnnotatedMembership> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnnotatedMembership> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ACCESS_FIELD_NUMBER = 1;
  private int access_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Indicates whether _this binding_ provides the specified
   * permission to the specified principal for the specified resource.
   *
   * This field does _not_ indicate whether the principal actually has the
   * permission for the resource. There might be another binding that overrides
   * this binding. To determine whether the principal actually has the
   * permission, use the `access` field in the
   * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for access.
   */
  @java.lang.Override
  public int getAccessValue() {
    return access_;
  }
  /**
   *
   *
   * <pre>
   * Required. Indicates whether _this binding_ provides the specified
   * permission to the specified principal for the specified resource.
   *
   * This field does _not_ indicate whether the principal actually has the
   * permission for the resource. There might be another binding that overrides
   * this binding. To determine whether the principal actually has the
   * permission, use the `access` field in the
   * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The access.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.AccessState getAccess() {
    com.google.cloud.policysimulator.v1.AccessState result =
        com.google.cloud.policysimulator.v1.AccessState.forNumber(access_);
    return result == null ? com.google.cloud.policysimulator.v1.AccessState.UNRECOGNIZED : result;
  }

  public static final int ROLE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object role_ = "";
  /**
   *
   *
   * <pre>
   * The role that this binding grants. For example,
   * `roles/compute.serviceAgent`.
   *
   * For a complete list of predefined IAM roles, as well as the permissions in
   * each role, see https://cloud.google.com/iam/help/roles/reference.
   * </pre>
   *
   * <code>string role = 2;</code>
   *
   * @return The role.
   */
  @java.lang.Override
  public java.lang.String getRole() {
    java.lang.Object ref = role_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      role_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The role that this binding grants. For example,
   * `roles/compute.serviceAgent`.
   *
   * For a complete list of predefined IAM roles, as well as the permissions in
   * each role, see https://cloud.google.com/iam/help/roles/reference.
   * </pre>
   *
   * <code>string role = 2;</code>
   *
   * @return The bytes for role.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRoleBytes() {
    java.lang.Object ref = role_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      role_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLE_PERMISSION_FIELD_NUMBER = 3;
  private int rolePermission_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates whether the role granted by this binding contains the specified
   * permission.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.BindingExplanation.RolePermission role_permission = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for rolePermission.
   */
  @java.lang.Override
  public int getRolePermissionValue() {
    return rolePermission_;
  }
  /**
   *
   *
   * <pre>
   * Indicates whether the role granted by this binding contains the specified
   * permission.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.BindingExplanation.RolePermission role_permission = 3;
   * </code>
   *
   * @return The rolePermission.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.BindingExplanation.RolePermission getRolePermission() {
    com.google.cloud.policysimulator.v1.BindingExplanation.RolePermission result =
        com.google.cloud.policysimulator.v1.BindingExplanation.RolePermission.forNumber(
            rolePermission_);
    return result == null
        ? com.google.cloud.policysimulator.v1.BindingExplanation.RolePermission.UNRECOGNIZED
        : result;
  }

  public static final int ROLE_PERMISSION_RELEVANCE_FIELD_NUMBER = 4;
  private int rolePermissionRelevance_ = 0;
  /**
   *
   *
   * <pre>
   * The relevance of the permission's existence, or nonexistence, in the role
   * to the overall determination for the entire policy.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.HeuristicRelevance role_permission_relevance = 4;</code>
   *
   * @return The enum numeric value on the wire for rolePermissionRelevance.
   */
  @java.lang.Override
  public int getRolePermissionRelevanceValue() {
    return rolePermissionRelevance_;
  }
  /**
   *
   *
   * <pre>
   * The relevance of the permission's existence, or nonexistence, in the role
   * to the overall determination for the entire policy.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.HeuristicRelevance role_permission_relevance = 4;</code>
   *
   * @return The rolePermissionRelevance.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.HeuristicRelevance getRolePermissionRelevance() {
    com.google.cloud.policysimulator.v1.HeuristicRelevance result =
        com.google.cloud.policysimulator.v1.HeuristicRelevance.forNumber(rolePermissionRelevance_);
    return result == null
        ? com.google.cloud.policysimulator.v1.HeuristicRelevance.UNRECOGNIZED
        : result;
  }

  public static final int MEMBERSHIPS_FIELD_NUMBER = 5;

  private static final class MembershipsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String,
            com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
                    newDefaultInstance(
                        com.google.cloud.policysimulator.v1.ExplanationsProto
                            .internal_static_google_cloud_policysimulator_v1_BindingExplanation_MembershipsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
      memberships_;

  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
      internalGetMemberships() {
    if (memberships_ == null) {
      return com.google.protobuf.MapField.emptyMapField(MembershipsDefaultEntryHolder.defaultEntry);
    }
    return memberships_;
  }

  public int getMembershipsCount() {
    return internalGetMemberships().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Indicates whether each principal in the binding includes the principal
   * specified in the request, either directly or indirectly. Each key
   * identifies a principal in the binding, and each value indicates whether the
   * principal in the binding includes the principal in the request.
   *
   * For example, suppose that a binding includes the following principals:
   *
   * * `user:alice&#64;example.com`
   * * `group:product-eng&#64;example.com`
   *
   * The principal in the replayed access tuple is `user:bob&#64;example.com`. This
   * user is a principal of the group `group:product-eng&#64;example.com`.
   *
   * For the first principal in the binding, the key is
   * `user:alice&#64;example.com`, and the `membership` field in the value is set to
   * `MEMBERSHIP_NOT_INCLUDED`.
   *
   * For the second principal in the binding, the key is
   * `group:product-eng&#64;example.com`, and the `membership` field in the value is
   * set to `MEMBERSHIP_INCLUDED`.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
   * </code>
   */
  @java.lang.Override
  public boolean containsMemberships(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMemberships().getMap().containsKey(key);
  }
  /** Use {@link #getMembershipsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String,
          com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
      getMemberships() {
    return getMembershipsMap();
  }
  /**
   *
   *
   * <pre>
   * Indicates whether each principal in the binding includes the principal
   * specified in the request, either directly or indirectly. Each key
   * identifies a principal in the binding, and each value indicates whether the
   * principal in the binding includes the principal in the request.
   *
   * For example, suppose that a binding includes the following principals:
   *
   * * `user:alice&#64;example.com`
   * * `group:product-eng&#64;example.com`
   *
   * The principal in the replayed access tuple is `user:bob&#64;example.com`. This
   * user is a principal of the group `group:product-eng&#64;example.com`.
   *
   * For the first principal in the binding, the key is
   * `user:alice&#64;example.com`, and the `membership` field in the value is set to
   * `MEMBERSHIP_NOT_INCLUDED`.
   *
   * For the second principal in the binding, the key is
   * `group:product-eng&#64;example.com`, and the `membership` field in the value is
   * set to `MEMBERSHIP_INCLUDED`.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String,
          com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
      getMembershipsMap() {
    return internalGetMemberships().getMap();
  }
  /**
   *
   *
   * <pre>
   * Indicates whether each principal in the binding includes the principal
   * specified in the request, either directly or indirectly. Each key
   * identifies a principal in the binding, and each value indicates whether the
   * principal in the binding includes the principal in the request.
   *
   * For example, suppose that a binding includes the following principals:
   *
   * * `user:alice&#64;example.com`
   * * `group:product-eng&#64;example.com`
   *
   * The principal in the replayed access tuple is `user:bob&#64;example.com`. This
   * user is a principal of the group `group:product-eng&#64;example.com`.
   *
   * For the first principal in the binding, the key is
   * `user:alice&#64;example.com`, and the `membership` field in the value is set to
   * `MEMBERSHIP_NOT_INCLUDED`.
   *
   * For the second principal in the binding, the key is
   * `group:product-eng&#64;example.com`, and the `membership` field in the value is
   * set to `MEMBERSHIP_INCLUDED`.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
      getMembershipsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
        map = internalGetMemberships().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Indicates whether each principal in the binding includes the principal
   * specified in the request, either directly or indirectly. Each key
   * identifies a principal in the binding, and each value indicates whether the
   * principal in the binding includes the principal in the request.
   *
   * For example, suppose that a binding includes the following principals:
   *
   * * `user:alice&#64;example.com`
   * * `group:product-eng&#64;example.com`
   *
   * The principal in the replayed access tuple is `user:bob&#64;example.com`. This
   * user is a principal of the group `group:product-eng&#64;example.com`.
   *
   * For the first principal in the binding, the key is
   * `user:alice&#64;example.com`, and the `membership` field in the value is set to
   * `MEMBERSHIP_NOT_INCLUDED`.
   *
   * For the second principal in the binding, the key is
   * `group:product-eng&#64;example.com`, and the `membership` field in the value is
   * set to `MEMBERSHIP_INCLUDED`.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
      getMembershipsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
        map = internalGetMemberships().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RELEVANCE_FIELD_NUMBER = 6;
  private int relevance_ = 0;
  /**
   *
   *
   * <pre>
   * The relevance of this binding to the overall determination for the entire
   * policy.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 6;</code>
   *
   * @return The enum numeric value on the wire for relevance.
   */
  @java.lang.Override
  public int getRelevanceValue() {
    return relevance_;
  }
  /**
   *
   *
   * <pre>
   * The relevance of this binding to the overall determination for the entire
   * policy.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 6;</code>
   *
   * @return The relevance.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.HeuristicRelevance getRelevance() {
    com.google.cloud.policysimulator.v1.HeuristicRelevance result =
        com.google.cloud.policysimulator.v1.HeuristicRelevance.forNumber(relevance_);
    return result == null
        ? com.google.cloud.policysimulator.v1.HeuristicRelevance.UNRECOGNIZED
        : result;
  }

  public static final int CONDITION_FIELD_NUMBER = 7;
  private com.google.type.Expr condition_;
  /**
   *
   *
   * <pre>
   * A condition expression that prevents this binding from granting access
   * unless the expression evaluates to `true`.
   *
   * To learn about IAM Conditions, see
   * https://cloud.google.com/iam/docs/conditions-overview.
   * </pre>
   *
   * <code>.google.type.Expr condition = 7;</code>
   *
   * @return Whether the condition field is set.
   */
  @java.lang.Override
  public boolean hasCondition() {
    return condition_ != null;
  }
  /**
   *
   *
   * <pre>
   * A condition expression that prevents this binding from granting access
   * unless the expression evaluates to `true`.
   *
   * To learn about IAM Conditions, see
   * https://cloud.google.com/iam/docs/conditions-overview.
   * </pre>
   *
   * <code>.google.type.Expr condition = 7;</code>
   *
   * @return The condition.
   */
  @java.lang.Override
  public com.google.type.Expr getCondition() {
    return condition_ == null ? com.google.type.Expr.getDefaultInstance() : condition_;
  }
  /**
   *
   *
   * <pre>
   * A condition expression that prevents this binding from granting access
   * unless the expression evaluates to `true`.
   *
   * To learn about IAM Conditions, see
   * https://cloud.google.com/iam/docs/conditions-overview.
   * </pre>
   *
   * <code>.google.type.Expr condition = 7;</code>
   */
  @java.lang.Override
  public com.google.type.ExprOrBuilder getConditionOrBuilder() {
    return condition_ == null ? com.google.type.Expr.getDefaultInstance() : condition_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (access_
        != com.google.cloud.policysimulator.v1.AccessState.ACCESS_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, access_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(role_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, role_);
    }
    if (rolePermission_
        != com.google.cloud.policysimulator.v1.BindingExplanation.RolePermission
            .ROLE_PERMISSION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, rolePermission_);
    }
    if (rolePermissionRelevance_
        != com.google.cloud.policysimulator.v1.HeuristicRelevance.HEURISTIC_RELEVANCE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, rolePermissionRelevance_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMemberships(), MembershipsDefaultEntryHolder.defaultEntry, 5);
    if (relevance_
        != com.google.cloud.policysimulator.v1.HeuristicRelevance.HEURISTIC_RELEVANCE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, relevance_);
    }
    if (condition_ != null) {
      output.writeMessage(7, getCondition());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (access_
        != com.google.cloud.policysimulator.v1.AccessState.ACCESS_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, access_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(role_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, role_);
    }
    if (rolePermission_
        != com.google.cloud.policysimulator.v1.BindingExplanation.RolePermission
            .ROLE_PERMISSION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, rolePermission_);
    }
    if (rolePermissionRelevance_
        != com.google.cloud.policysimulator.v1.HeuristicRelevance.HEURISTIC_RELEVANCE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, rolePermissionRelevance_);
    }
    for (java.util.Map.Entry<
            java.lang.String,
            com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
        entry : internalGetMemberships().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
          memberships__ =
              MembershipsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, memberships__);
    }
    if (relevance_
        != com.google.cloud.policysimulator.v1.HeuristicRelevance.HEURISTIC_RELEVANCE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, relevance_);
    }
    if (condition_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCondition());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.policysimulator.v1.BindingExplanation)) {
      return super.equals(obj);
    }
    com.google.cloud.policysimulator.v1.BindingExplanation other =
        (com.google.cloud.policysimulator.v1.BindingExplanation) obj;

    if (access_ != other.access_) return false;
    if (!getRole().equals(other.getRole())) return false;
    if (rolePermission_ != other.rolePermission_) return false;
    if (rolePermissionRelevance_ != other.rolePermissionRelevance_) return false;
    if (!internalGetMemberships().equals(other.internalGetMemberships())) return false;
    if (relevance_ != other.relevance_) return false;
    if (hasCondition() != other.hasCondition()) return false;
    if (hasCondition()) {
      if (!getCondition().equals(other.getCondition())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + access_;
    hash = (37 * hash) + ROLE_FIELD_NUMBER;
    hash = (53 * hash) + getRole().hashCode();
    hash = (37 * hash) + ROLE_PERMISSION_FIELD_NUMBER;
    hash = (53 * hash) + rolePermission_;
    hash = (37 * hash) + ROLE_PERMISSION_RELEVANCE_FIELD_NUMBER;
    hash = (53 * hash) + rolePermissionRelevance_;
    if (!internalGetMemberships().getMap().isEmpty()) {
      hash = (37 * hash) + MEMBERSHIPS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMemberships().hashCode();
    }
    hash = (37 * hash) + RELEVANCE_FIELD_NUMBER;
    hash = (53 * hash) + relevance_;
    if (hasCondition()) {
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getCondition().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.policysimulator.v1.BindingExplanation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.BindingExplanation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.BindingExplanation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.BindingExplanation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.BindingExplanation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.BindingExplanation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.BindingExplanation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.BindingExplanation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.BindingExplanation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.BindingExplanation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.BindingExplanation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.BindingExplanation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.policysimulator.v1.BindingExplanation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details about how a binding in a policy affects a principal's ability to use
   * a permission.
   * </pre>
   *
   * Protobuf type {@code google.cloud.policysimulator.v1.BindingExplanation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.policysimulator.v1.BindingExplanation)
      com.google.cloud.policysimulator.v1.BindingExplanationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.ExplanationsProto
          .internal_static_google_cloud_policysimulator_v1_BindingExplanation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMemberships();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableMemberships();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.policysimulator.v1.ExplanationsProto
          .internal_static_google_cloud_policysimulator_v1_BindingExplanation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.policysimulator.v1.BindingExplanation.class,
              com.google.cloud.policysimulator.v1.BindingExplanation.Builder.class);
    }

    // Construct using com.google.cloud.policysimulator.v1.BindingExplanation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      access_ = 0;
      role_ = "";
      rolePermission_ = 0;
      rolePermissionRelevance_ = 0;
      internalGetMutableMemberships().clear();
      relevance_ = 0;
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.policysimulator.v1.ExplanationsProto
          .internal_static_google_cloud_policysimulator_v1_BindingExplanation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.BindingExplanation getDefaultInstanceForType() {
      return com.google.cloud.policysimulator.v1.BindingExplanation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.BindingExplanation build() {
      com.google.cloud.policysimulator.v1.BindingExplanation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.BindingExplanation buildPartial() {
      com.google.cloud.policysimulator.v1.BindingExplanation result =
          new com.google.cloud.policysimulator.v1.BindingExplanation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.policysimulator.v1.BindingExplanation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.access_ = access_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.role_ = role_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rolePermission_ = rolePermission_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.rolePermissionRelevance_ = rolePermissionRelevance_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.memberships_ = internalGetMemberships();
        result.memberships_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.relevance_ = relevance_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.condition_ = conditionBuilder_ == null ? condition_ : conditionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.policysimulator.v1.BindingExplanation) {
        return mergeFrom((com.google.cloud.policysimulator.v1.BindingExplanation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.policysimulator.v1.BindingExplanation other) {
      if (other == com.google.cloud.policysimulator.v1.BindingExplanation.getDefaultInstance())
        return this;
      if (other.access_ != 0) {
        setAccessValue(other.getAccessValue());
      }
      if (!other.getRole().isEmpty()) {
        role_ = other.role_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.rolePermission_ != 0) {
        setRolePermissionValue(other.getRolePermissionValue());
      }
      if (other.rolePermissionRelevance_ != 0) {
        setRolePermissionRelevanceValue(other.getRolePermissionRelevanceValue());
      }
      internalGetMutableMemberships().mergeFrom(other.internalGetMemberships());
      bitField0_ |= 0x00000010;
      if (other.relevance_ != 0) {
        setRelevanceValue(other.getRelevanceValue());
      }
      if (other.hasCondition()) {
        mergeCondition(other.getCondition());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                access_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                role_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                rolePermission_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                rolePermissionRelevance_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
                    memberships__ =
                        input.readMessage(
                            MembershipsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableMemberships()
                    .getMutableMap()
                    .put(memberships__.getKey(), memberships__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                relevance_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getConditionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int access_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Indicates whether _this binding_ provides the specified
     * permission to the specified principal for the specified resource.
     *
     * This field does _not_ indicate whether the principal actually has the
     * permission for the resource. There might be another binding that overrides
     * this binding. To determine whether the principal actually has the
     * permission, use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for access.
     */
    @java.lang.Override
    public int getAccessValue() {
      return access_;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates whether _this binding_ provides the specified
     * permission to the specified principal for the specified resource.
     *
     * This field does _not_ indicate whether the principal actually has the
     * permission for the resource. There might be another binding that overrides
     * this binding. To determine whether the principal actually has the
     * permission, use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for access to set.
     * @return This builder for chaining.
     */
    public Builder setAccessValue(int value) {
      access_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates whether _this binding_ provides the specified
     * permission to the specified principal for the specified resource.
     *
     * This field does _not_ indicate whether the principal actually has the
     * permission for the resource. There might be another binding that overrides
     * this binding. To determine whether the principal actually has the
     * permission, use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The access.
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.AccessState getAccess() {
      com.google.cloud.policysimulator.v1.AccessState result =
          com.google.cloud.policysimulator.v1.AccessState.forNumber(access_);
      return result == null ? com.google.cloud.policysimulator.v1.AccessState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates whether _this binding_ provides the specified
     * permission to the specified principal for the specified resource.
     *
     * This field does _not_ indicate whether the principal actually has the
     * permission for the resource. There might be another binding that overrides
     * this binding. To determine whether the principal actually has the
     * permission, use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The access to set.
     * @return This builder for chaining.
     */
    public Builder setAccess(com.google.cloud.policysimulator.v1.AccessState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      access_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates whether _this binding_ provides the specified
     * permission to the specified principal for the specified resource.
     *
     * This field does _not_ indicate whether the principal actually has the
     * permission for the resource. There might be another binding that overrides
     * this binding. To determine whether the principal actually has the
     * permission, use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAccess() {
      bitField0_ = (bitField0_ & ~0x00000001);
      access_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object role_ = "";
    /**
     *
     *
     * <pre>
     * The role that this binding grants. For example,
     * `roles/compute.serviceAgent`.
     *
     * For a complete list of predefined IAM roles, as well as the permissions in
     * each role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string role = 2;</code>
     *
     * @return The role.
     */
    public java.lang.String getRole() {
      java.lang.Object ref = role_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        role_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The role that this binding grants. For example,
     * `roles/compute.serviceAgent`.
     *
     * For a complete list of predefined IAM roles, as well as the permissions in
     * each role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string role = 2;</code>
     *
     * @return The bytes for role.
     */
    public com.google.protobuf.ByteString getRoleBytes() {
      java.lang.Object ref = role_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        role_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The role that this binding grants. For example,
     * `roles/compute.serviceAgent`.
     *
     * For a complete list of predefined IAM roles, as well as the permissions in
     * each role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string role = 2;</code>
     *
     * @param value The role to set.
     * @return This builder for chaining.
     */
    public Builder setRole(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      role_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The role that this binding grants. For example,
     * `roles/compute.serviceAgent`.
     *
     * For a complete list of predefined IAM roles, as well as the permissions in
     * each role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string role = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRole() {
      role_ = getDefaultInstance().getRole();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The role that this binding grants. For example,
     * `roles/compute.serviceAgent`.
     *
     * For a complete list of predefined IAM roles, as well as the permissions in
     * each role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string role = 2;</code>
     *
     * @param value The bytes for role to set.
     * @return This builder for chaining.
     */
    public Builder setRoleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      role_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int rolePermission_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates whether the role granted by this binding contains the specified
     * permission.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.BindingExplanation.RolePermission role_permission = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for rolePermission.
     */
    @java.lang.Override
    public int getRolePermissionValue() {
      return rolePermission_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the role granted by this binding contains the specified
     * permission.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.BindingExplanation.RolePermission role_permission = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for rolePermission to set.
     * @return This builder for chaining.
     */
    public Builder setRolePermissionValue(int value) {
      rolePermission_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the role granted by this binding contains the specified
     * permission.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.BindingExplanation.RolePermission role_permission = 3;
     * </code>
     *
     * @return The rolePermission.
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.BindingExplanation.RolePermission
        getRolePermission() {
      com.google.cloud.policysimulator.v1.BindingExplanation.RolePermission result =
          com.google.cloud.policysimulator.v1.BindingExplanation.RolePermission.forNumber(
              rolePermission_);
      return result == null
          ? com.google.cloud.policysimulator.v1.BindingExplanation.RolePermission.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the role granted by this binding contains the specified
     * permission.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.BindingExplanation.RolePermission role_permission = 3;
     * </code>
     *
     * @param value The rolePermission to set.
     * @return This builder for chaining.
     */
    public Builder setRolePermission(
        com.google.cloud.policysimulator.v1.BindingExplanation.RolePermission value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      rolePermission_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the role granted by this binding contains the specified
     * permission.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.BindingExplanation.RolePermission role_permission = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRolePermission() {
      bitField0_ = (bitField0_ & ~0x00000004);
      rolePermission_ = 0;
      onChanged();
      return this;
    }

    private int rolePermissionRelevance_ = 0;
    /**
     *
     *
     * <pre>
     * The relevance of the permission's existence, or nonexistence, in the role
     * to the overall determination for the entire policy.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance role_permission_relevance = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for rolePermissionRelevance.
     */
    @java.lang.Override
    public int getRolePermissionRelevanceValue() {
      return rolePermissionRelevance_;
    }
    /**
     *
     *
     * <pre>
     * The relevance of the permission's existence, or nonexistence, in the role
     * to the overall determination for the entire policy.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance role_permission_relevance = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for rolePermissionRelevance to set.
     * @return This builder for chaining.
     */
    public Builder setRolePermissionRelevanceValue(int value) {
      rolePermissionRelevance_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relevance of the permission's existence, or nonexistence, in the role
     * to the overall determination for the entire policy.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance role_permission_relevance = 4;
     * </code>
     *
     * @return The rolePermissionRelevance.
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.HeuristicRelevance getRolePermissionRelevance() {
      com.google.cloud.policysimulator.v1.HeuristicRelevance result =
          com.google.cloud.policysimulator.v1.HeuristicRelevance.forNumber(
              rolePermissionRelevance_);
      return result == null
          ? com.google.cloud.policysimulator.v1.HeuristicRelevance.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The relevance of the permission's existence, or nonexistence, in the role
     * to the overall determination for the entire policy.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance role_permission_relevance = 4;
     * </code>
     *
     * @param value The rolePermissionRelevance to set.
     * @return This builder for chaining.
     */
    public Builder setRolePermissionRelevance(
        com.google.cloud.policysimulator.v1.HeuristicRelevance value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      rolePermissionRelevance_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relevance of the permission's existence, or nonexistence, in the role
     * to the overall determination for the entire policy.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance role_permission_relevance = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRolePermissionRelevance() {
      bitField0_ = (bitField0_ & ~0x00000008);
      rolePermissionRelevance_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
        memberships_;

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
        internalGetMemberships() {
      if (memberships_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            MembershipsDefaultEntryHolder.defaultEntry);
      }
      return memberships_;
    }

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
        internalGetMutableMemberships() {
      if (memberships_ == null) {
        memberships_ =
            com.google.protobuf.MapField.newMapField(MembershipsDefaultEntryHolder.defaultEntry);
      }
      if (!memberships_.isMutable()) {
        memberships_ = memberships_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return memberships_;
    }

    public int getMembershipsCount() {
      return internalGetMemberships().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Indicates whether each principal in the binding includes the principal
     * specified in the request, either directly or indirectly. Each key
     * identifies a principal in the binding, and each value indicates whether the
     * principal in the binding includes the principal in the request.
     *
     * For example, suppose that a binding includes the following principals:
     *
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     *
     * The principal in the replayed access tuple is `user:bob&#64;example.com`. This
     * user is a principal of the group `group:product-eng&#64;example.com`.
     *
     * For the first principal in the binding, the key is
     * `user:alice&#64;example.com`, and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     *
     * For the second principal in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    @java.lang.Override
    public boolean containsMemberships(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMemberships().getMap().containsKey(key);
    }
    /** Use {@link #getMembershipsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
        getMemberships() {
      return getMembershipsMap();
    }
    /**
     *
     *
     * <pre>
     * Indicates whether each principal in the binding includes the principal
     * specified in the request, either directly or indirectly. Each key
     * identifies a principal in the binding, and each value indicates whether the
     * principal in the binding includes the principal in the request.
     *
     * For example, suppose that a binding includes the following principals:
     *
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     *
     * The principal in the replayed access tuple is `user:bob&#64;example.com`. This
     * user is a principal of the group `group:product-eng&#64;example.com`.
     *
     * For the first principal in the binding, the key is
     * `user:alice&#64;example.com`, and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     *
     * For the second principal in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
        getMembershipsMap() {
      return internalGetMemberships().getMap();
    }
    /**
     *
     *
     * <pre>
     * Indicates whether each principal in the binding includes the principal
     * specified in the request, either directly or indirectly. Each key
     * identifies a principal in the binding, and each value indicates whether the
     * principal in the binding includes the principal in the request.
     *
     * For example, suppose that a binding includes the following principals:
     *
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     *
     * The principal in the replayed access tuple is `user:bob&#64;example.com`. This
     * user is a principal of the group `group:product-eng&#64;example.com`.
     *
     * For the first principal in the binding, the key is
     * `user:alice&#64;example.com`, and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     *
     * For the second principal in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        getMembershipsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
          map = internalGetMemberships().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether each principal in the binding includes the principal
     * specified in the request, either directly or indirectly. Each key
     * identifies a principal in the binding, and each value indicates whether the
     * principal in the binding includes the principal in the request.
     *
     * For example, suppose that a binding includes the following principals:
     *
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     *
     * The principal in the replayed access tuple is `user:bob&#64;example.com`. This
     * user is a principal of the group `group:product-eng&#64;example.com`.
     *
     * For the first principal in the binding, the key is
     * `user:alice&#64;example.com`, and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     *
     * For the second principal in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership
        getMembershipsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
          map = internalGetMemberships().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMemberships() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableMemberships().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether each principal in the binding includes the principal
     * specified in the request, either directly or indirectly. Each key
     * identifies a principal in the binding, and each value indicates whether the
     * principal in the binding includes the principal in the request.
     *
     * For example, suppose that a binding includes the following principals:
     *
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     *
     * The principal in the replayed access tuple is `user:bob&#64;example.com`. This
     * user is a principal of the group `group:product-eng&#64;example.com`.
     *
     * For the first principal in the binding, the key is
     * `user:alice&#64;example.com`, and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     *
     * For the second principal in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    public Builder removeMemberships(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMemberships().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
        getMutableMemberships() {
      bitField0_ |= 0x00000010;
      return internalGetMutableMemberships().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Indicates whether each principal in the binding includes the principal
     * specified in the request, either directly or indirectly. Each key
     * identifies a principal in the binding, and each value indicates whether the
     * principal in the binding includes the principal in the request.
     *
     * For example, suppose that a binding includes the following principals:
     *
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     *
     * The principal in the replayed access tuple is `user:bob&#64;example.com`. This
     * user is a principal of the group `group:product-eng&#64;example.com`.
     *
     * For the first principal in the binding, the key is
     * `user:alice&#64;example.com`, and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     *
     * For the second principal in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    public Builder putMemberships(
        java.lang.String key,
        com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableMemberships().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether each principal in the binding includes the principal
     * specified in the request, either directly or indirectly. Each key
     * identifies a principal in the binding, and each value indicates whether the
     * principal in the binding includes the principal in the request.
     *
     * For example, suppose that a binding includes the following principals:
     *
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     *
     * The principal in the replayed access tuple is `user:bob&#64;example.com`. This
     * user is a principal of the group `group:product-eng&#64;example.com`.
     *
     * For the first principal in the binding, the key is
     * `user:alice&#64;example.com`, and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     *
     * For the second principal in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    public Builder putAllMemberships(
        java.util.Map<
                java.lang.String,
                com.google.cloud.policysimulator.v1.BindingExplanation.AnnotatedMembership>
            values) {
      internalGetMutableMemberships().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private int relevance_ = 0;
    /**
     *
     *
     * <pre>
     * The relevance of this binding to the overall determination for the entire
     * policy.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 6;</code>
     *
     * @return The enum numeric value on the wire for relevance.
     */
    @java.lang.Override
    public int getRelevanceValue() {
      return relevance_;
    }
    /**
     *
     *
     * <pre>
     * The relevance of this binding to the overall determination for the entire
     * policy.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 6;</code>
     *
     * @param value The enum numeric value on the wire for relevance to set.
     * @return This builder for chaining.
     */
    public Builder setRelevanceValue(int value) {
      relevance_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relevance of this binding to the overall determination for the entire
     * policy.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 6;</code>
     *
     * @return The relevance.
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.HeuristicRelevance getRelevance() {
      com.google.cloud.policysimulator.v1.HeuristicRelevance result =
          com.google.cloud.policysimulator.v1.HeuristicRelevance.forNumber(relevance_);
      return result == null
          ? com.google.cloud.policysimulator.v1.HeuristicRelevance.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The relevance of this binding to the overall determination for the entire
     * policy.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 6;</code>
     *
     * @param value The relevance to set.
     * @return This builder for chaining.
     */
    public Builder setRelevance(com.google.cloud.policysimulator.v1.HeuristicRelevance value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      relevance_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relevance of this binding to the overall determination for the entire
     * policy.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelevance() {
      bitField0_ = (bitField0_ & ~0x00000020);
      relevance_ = 0;
      onChanged();
      return this;
    }

    private com.google.type.Expr condition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Expr, com.google.type.Expr.Builder, com.google.type.ExprOrBuilder>
        conditionBuilder_;
    /**
     *
     *
     * <pre>
     * A condition expression that prevents this binding from granting access
     * unless the expression evaluates to `true`.
     *
     * To learn about IAM Conditions, see
     * https://cloud.google.com/iam/docs/conditions-overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     *
     * @return Whether the condition field is set.
     */
    public boolean hasCondition() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * A condition expression that prevents this binding from granting access
     * unless the expression evaluates to `true`.
     *
     * To learn about IAM Conditions, see
     * https://cloud.google.com/iam/docs/conditions-overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     *
     * @return The condition.
     */
    public com.google.type.Expr getCondition() {
      if (conditionBuilder_ == null) {
        return condition_ == null ? com.google.type.Expr.getDefaultInstance() : condition_;
      } else {
        return conditionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A condition expression that prevents this binding from granting access
     * unless the expression evaluates to `true`.
     *
     * To learn about IAM Conditions, see
     * https://cloud.google.com/iam/docs/conditions-overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     */
    public Builder setCondition(com.google.type.Expr value) {
      if (conditionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        condition_ = value;
      } else {
        conditionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A condition expression that prevents this binding from granting access
     * unless the expression evaluates to `true`.
     *
     * To learn about IAM Conditions, see
     * https://cloud.google.com/iam/docs/conditions-overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     */
    public Builder setCondition(com.google.type.Expr.Builder builderForValue) {
      if (conditionBuilder_ == null) {
        condition_ = builderForValue.build();
      } else {
        conditionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A condition expression that prevents this binding from granting access
     * unless the expression evaluates to `true`.
     *
     * To learn about IAM Conditions, see
     * https://cloud.google.com/iam/docs/conditions-overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     */
    public Builder mergeCondition(com.google.type.Expr value) {
      if (conditionBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && condition_ != null
            && condition_ != com.google.type.Expr.getDefaultInstance()) {
          getConditionBuilder().mergeFrom(value);
        } else {
          condition_ = value;
        }
      } else {
        conditionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A condition expression that prevents this binding from granting access
     * unless the expression evaluates to `true`.
     *
     * To learn about IAM Conditions, see
     * https://cloud.google.com/iam/docs/conditions-overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     */
    public Builder clearCondition() {
      bitField0_ = (bitField0_ & ~0x00000040);
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A condition expression that prevents this binding from granting access
     * unless the expression evaluates to `true`.
     *
     * To learn about IAM Conditions, see
     * https://cloud.google.com/iam/docs/conditions-overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     */
    public com.google.type.Expr.Builder getConditionBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getConditionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A condition expression that prevents this binding from granting access
     * unless the expression evaluates to `true`.
     *
     * To learn about IAM Conditions, see
     * https://cloud.google.com/iam/docs/conditions-overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     */
    public com.google.type.ExprOrBuilder getConditionOrBuilder() {
      if (conditionBuilder_ != null) {
        return conditionBuilder_.getMessageOrBuilder();
      } else {
        return condition_ == null ? com.google.type.Expr.getDefaultInstance() : condition_;
      }
    }
    /**
     *
     *
     * <pre>
     * A condition expression that prevents this binding from granting access
     * unless the expression evaluates to `true`.
     *
     * To learn about IAM Conditions, see
     * https://cloud.google.com/iam/docs/conditions-overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Expr, com.google.type.Expr.Builder, com.google.type.ExprOrBuilder>
        getConditionFieldBuilder() {
      if (conditionBuilder_ == null) {
        conditionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Expr, com.google.type.Expr.Builder, com.google.type.ExprOrBuilder>(
                getCondition(), getParentForChildren(), isClean());
        condition_ = null;
      }
      return conditionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.policysimulator.v1.BindingExplanation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.policysimulator.v1.BindingExplanation)
  private static final com.google.cloud.policysimulator.v1.BindingExplanation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.policysimulator.v1.BindingExplanation();
  }

  public static com.google.cloud.policysimulator.v1.BindingExplanation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BindingExplanation> PARSER =
      new com.google.protobuf.AbstractParser<BindingExplanation>() {
        @java.lang.Override
        public BindingExplanation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BindingExplanation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BindingExplanation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.policysimulator.v1.BindingExplanation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
