/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/explanations.proto

package com.google.cloud.policysimulator.v1;

/**
 *
 *
 * <pre>
 * Details about how a specific IAM [Policy][google.iam.v1.Policy] contributed
 * to the access check.
 * </pre>
 *
 * Protobuf type {@code google.cloud.policysimulator.v1.ExplainedPolicy}
 */
public final class ExplainedPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.policysimulator.v1.ExplainedPolicy)
    ExplainedPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExplainedPolicy.newBuilder() to construct.
  private ExplainedPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExplainedPolicy() {
    access_ = 0;
    fullResourceName_ = "";
    bindingExplanations_ = java.util.Collections.emptyList();
    relevance_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExplainedPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.policysimulator.v1.ExplanationsProto
        .internal_static_google_cloud_policysimulator_v1_ExplainedPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.policysimulator.v1.ExplanationsProto
        .internal_static_google_cloud_policysimulator_v1_ExplainedPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.policysimulator.v1.ExplainedPolicy.class,
            com.google.cloud.policysimulator.v1.ExplainedPolicy.Builder.class);
  }

  public static final int ACCESS_FIELD_NUMBER = 1;
  private int access_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates whether _this policy_ provides the specified permission to the
   * specified principal for the specified resource.
   *
   * This field does _not_ indicate whether the principal actually has the
   * permission for the resource. There might be another policy that overrides
   * this policy. To determine whether the principal actually has the
   * permission, use the `access` field in the
   * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessState access = 1;</code>
   *
   * @return The enum numeric value on the wire for access.
   */
  @java.lang.Override
  public int getAccessValue() {
    return access_;
  }
  /**
   *
   *
   * <pre>
   * Indicates whether _this policy_ provides the specified permission to the
   * specified principal for the specified resource.
   *
   * This field does _not_ indicate whether the principal actually has the
   * permission for the resource. There might be another policy that overrides
   * this policy. To determine whether the principal actually has the
   * permission, use the `access` field in the
   * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessState access = 1;</code>
   *
   * @return The access.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.AccessState getAccess() {
    com.google.cloud.policysimulator.v1.AccessState result =
        com.google.cloud.policysimulator.v1.AccessState.forNumber(access_);
    return result == null ? com.google.cloud.policysimulator.v1.AccessState.UNRECOGNIZED : result;
  }

  public static final int FULL_RESOURCE_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fullResourceName_ = "";
  /**
   *
   *
   * <pre>
   * The full resource name that identifies the resource. For example,
   * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   *
   * For examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   * </pre>
   *
   * <code>string full_resource_name = 2;</code>
   *
   * @return The fullResourceName.
   */
  @java.lang.Override
  public java.lang.String getFullResourceName() {
    java.lang.Object ref = fullResourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fullResourceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full resource name that identifies the resource. For example,
   * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   *
   * For examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   * </pre>
   *
   * <code>string full_resource_name = 2;</code>
   *
   * @return The bytes for fullResourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFullResourceNameBytes() {
    java.lang.Object ref = fullResourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fullResourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POLICY_FIELD_NUMBER = 3;
  private com.google.iam.v1.Policy policy_;
  /**
   *
   *
   * <pre>
   * The IAM policy attached to the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is empty.
   * </pre>
   *
   * <code>.google.iam.v1.Policy policy = 3;</code>
   *
   * @return Whether the policy field is set.
   */
  @java.lang.Override
  public boolean hasPolicy() {
    return policy_ != null;
  }
  /**
   *
   *
   * <pre>
   * The IAM policy attached to the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is empty.
   * </pre>
   *
   * <code>.google.iam.v1.Policy policy = 3;</code>
   *
   * @return The policy.
   */
  @java.lang.Override
  public com.google.iam.v1.Policy getPolicy() {
    return policy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : policy_;
  }
  /**
   *
   *
   * <pre>
   * The IAM policy attached to the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is empty.
   * </pre>
   *
   * <code>.google.iam.v1.Policy policy = 3;</code>
   */
  @java.lang.Override
  public com.google.iam.v1.PolicyOrBuilder getPolicyOrBuilder() {
    return policy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : policy_;
  }

  public static final int BINDING_EXPLANATIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.policysimulator.v1.BindingExplanation>
      bindingExplanations_;
  /**
   *
   *
   * <pre>
   * Details about how each binding in the policy affects the principal's
   * ability, or inability, to use the permission for the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.policysimulator.v1.BindingExplanation>
      getBindingExplanationsList() {
    return bindingExplanations_;
  }
  /**
   *
   *
   * <pre>
   * Details about how each binding in the policy affects the principal's
   * ability, or inability, to use the permission for the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.policysimulator.v1.BindingExplanationOrBuilder>
      getBindingExplanationsOrBuilderList() {
    return bindingExplanations_;
  }
  /**
   *
   *
   * <pre>
   * Details about how each binding in the policy affects the principal's
   * ability, or inability, to use the permission for the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
   * </code>
   */
  @java.lang.Override
  public int getBindingExplanationsCount() {
    return bindingExplanations_.size();
  }
  /**
   *
   *
   * <pre>
   * Details about how each binding in the policy affects the principal's
   * ability, or inability, to use the permission for the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.BindingExplanation getBindingExplanations(int index) {
    return bindingExplanations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Details about how each binding in the policy affects the principal's
   * ability, or inability, to use the permission for the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.BindingExplanationOrBuilder
      getBindingExplanationsOrBuilder(int index) {
    return bindingExplanations_.get(index);
  }

  public static final int RELEVANCE_FIELD_NUMBER = 5;
  private int relevance_ = 0;
  /**
   *
   *
   * <pre>
   * The relevance of this policy to the overall determination in the
   * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 5;</code>
   *
   * @return The enum numeric value on the wire for relevance.
   */
  @java.lang.Override
  public int getRelevanceValue() {
    return relevance_;
  }
  /**
   *
   *
   * <pre>
   * The relevance of this policy to the overall determination in the
   * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 5;</code>
   *
   * @return The relevance.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.HeuristicRelevance getRelevance() {
    com.google.cloud.policysimulator.v1.HeuristicRelevance result =
        com.google.cloud.policysimulator.v1.HeuristicRelevance.forNumber(relevance_);
    return result == null
        ? com.google.cloud.policysimulator.v1.HeuristicRelevance.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (access_
        != com.google.cloud.policysimulator.v1.AccessState.ACCESS_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, access_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullResourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fullResourceName_);
    }
    if (policy_ != null) {
      output.writeMessage(3, getPolicy());
    }
    for (int i = 0; i < bindingExplanations_.size(); i++) {
      output.writeMessage(4, bindingExplanations_.get(i));
    }
    if (relevance_
        != com.google.cloud.policysimulator.v1.HeuristicRelevance.HEURISTIC_RELEVANCE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, relevance_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (access_
        != com.google.cloud.policysimulator.v1.AccessState.ACCESS_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, access_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullResourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fullResourceName_);
    }
    if (policy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPolicy());
    }
    for (int i = 0; i < bindingExplanations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, bindingExplanations_.get(i));
    }
    if (relevance_
        != com.google.cloud.policysimulator.v1.HeuristicRelevance.HEURISTIC_RELEVANCE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, relevance_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.policysimulator.v1.ExplainedPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.policysimulator.v1.ExplainedPolicy other =
        (com.google.cloud.policysimulator.v1.ExplainedPolicy) obj;

    if (access_ != other.access_) return false;
    if (!getFullResourceName().equals(other.getFullResourceName())) return false;
    if (hasPolicy() != other.hasPolicy()) return false;
    if (hasPolicy()) {
      if (!getPolicy().equals(other.getPolicy())) return false;
    }
    if (!getBindingExplanationsList().equals(other.getBindingExplanationsList())) return false;
    if (relevance_ != other.relevance_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + access_;
    hash = (37 * hash) + FULL_RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFullResourceName().hashCode();
    if (hasPolicy()) {
      hash = (37 * hash) + POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getPolicy().hashCode();
    }
    if (getBindingExplanationsCount() > 0) {
      hash = (37 * hash) + BINDING_EXPLANATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getBindingExplanationsList().hashCode();
    }
    hash = (37 * hash) + RELEVANCE_FIELD_NUMBER;
    hash = (53 * hash) + relevance_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.policysimulator.v1.ExplainedPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.policysimulator.v1.ExplainedPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details about how a specific IAM [Policy][google.iam.v1.Policy] contributed
   * to the access check.
   * </pre>
   *
   * Protobuf type {@code google.cloud.policysimulator.v1.ExplainedPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.policysimulator.v1.ExplainedPolicy)
      com.google.cloud.policysimulator.v1.ExplainedPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.ExplanationsProto
          .internal_static_google_cloud_policysimulator_v1_ExplainedPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.policysimulator.v1.ExplanationsProto
          .internal_static_google_cloud_policysimulator_v1_ExplainedPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.policysimulator.v1.ExplainedPolicy.class,
              com.google.cloud.policysimulator.v1.ExplainedPolicy.Builder.class);
    }

    // Construct using com.google.cloud.policysimulator.v1.ExplainedPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      access_ = 0;
      fullResourceName_ = "";
      policy_ = null;
      if (policyBuilder_ != null) {
        policyBuilder_.dispose();
        policyBuilder_ = null;
      }
      if (bindingExplanationsBuilder_ == null) {
        bindingExplanations_ = java.util.Collections.emptyList();
      } else {
        bindingExplanations_ = null;
        bindingExplanationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      relevance_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.policysimulator.v1.ExplanationsProto
          .internal_static_google_cloud_policysimulator_v1_ExplainedPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ExplainedPolicy getDefaultInstanceForType() {
      return com.google.cloud.policysimulator.v1.ExplainedPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ExplainedPolicy build() {
      com.google.cloud.policysimulator.v1.ExplainedPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ExplainedPolicy buildPartial() {
      com.google.cloud.policysimulator.v1.ExplainedPolicy result =
          new com.google.cloud.policysimulator.v1.ExplainedPolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.policysimulator.v1.ExplainedPolicy result) {
      if (bindingExplanationsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          bindingExplanations_ = java.util.Collections.unmodifiableList(bindingExplanations_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.bindingExplanations_ = bindingExplanations_;
      } else {
        result.bindingExplanations_ = bindingExplanationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.policysimulator.v1.ExplainedPolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.access_ = access_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.fullResourceName_ = fullResourceName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.policy_ = policyBuilder_ == null ? policy_ : policyBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.relevance_ = relevance_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.policysimulator.v1.ExplainedPolicy) {
        return mergeFrom((com.google.cloud.policysimulator.v1.ExplainedPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.policysimulator.v1.ExplainedPolicy other) {
      if (other == com.google.cloud.policysimulator.v1.ExplainedPolicy.getDefaultInstance())
        return this;
      if (other.access_ != 0) {
        setAccessValue(other.getAccessValue());
      }
      if (!other.getFullResourceName().isEmpty()) {
        fullResourceName_ = other.fullResourceName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPolicy()) {
        mergePolicy(other.getPolicy());
      }
      if (bindingExplanationsBuilder_ == null) {
        if (!other.bindingExplanations_.isEmpty()) {
          if (bindingExplanations_.isEmpty()) {
            bindingExplanations_ = other.bindingExplanations_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureBindingExplanationsIsMutable();
            bindingExplanations_.addAll(other.bindingExplanations_);
          }
          onChanged();
        }
      } else {
        if (!other.bindingExplanations_.isEmpty()) {
          if (bindingExplanationsBuilder_.isEmpty()) {
            bindingExplanationsBuilder_.dispose();
            bindingExplanationsBuilder_ = null;
            bindingExplanations_ = other.bindingExplanations_;
            bitField0_ = (bitField0_ & ~0x00000008);
            bindingExplanationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBindingExplanationsFieldBuilder()
                    : null;
          } else {
            bindingExplanationsBuilder_.addAllMessages(other.bindingExplanations_);
          }
        }
      }
      if (other.relevance_ != 0) {
        setRelevanceValue(other.getRelevanceValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                access_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                fullResourceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.policysimulator.v1.BindingExplanation m =
                    input.readMessage(
                        com.google.cloud.policysimulator.v1.BindingExplanation.parser(),
                        extensionRegistry);
                if (bindingExplanationsBuilder_ == null) {
                  ensureBindingExplanationsIsMutable();
                  bindingExplanations_.add(m);
                } else {
                  bindingExplanationsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 40:
              {
                relevance_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int access_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates whether _this policy_ provides the specified permission to the
     * specified principal for the specified resource.
     *
     * This field does _not_ indicate whether the principal actually has the
     * permission for the resource. There might be another policy that overrides
     * this policy. To determine whether the principal actually has the
     * permission, use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessState access = 1;</code>
     *
     * @return The enum numeric value on the wire for access.
     */
    @java.lang.Override
    public int getAccessValue() {
      return access_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether _this policy_ provides the specified permission to the
     * specified principal for the specified resource.
     *
     * This field does _not_ indicate whether the principal actually has the
     * permission for the resource. There might be another policy that overrides
     * this policy. To determine whether the principal actually has the
     * permission, use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessState access = 1;</code>
     *
     * @param value The enum numeric value on the wire for access to set.
     * @return This builder for chaining.
     */
    public Builder setAccessValue(int value) {
      access_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether _this policy_ provides the specified permission to the
     * specified principal for the specified resource.
     *
     * This field does _not_ indicate whether the principal actually has the
     * permission for the resource. There might be another policy that overrides
     * this policy. To determine whether the principal actually has the
     * permission, use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessState access = 1;</code>
     *
     * @return The access.
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.AccessState getAccess() {
      com.google.cloud.policysimulator.v1.AccessState result =
          com.google.cloud.policysimulator.v1.AccessState.forNumber(access_);
      return result == null ? com.google.cloud.policysimulator.v1.AccessState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether _this policy_ provides the specified permission to the
     * specified principal for the specified resource.
     *
     * This field does _not_ indicate whether the principal actually has the
     * permission for the resource. There might be another policy that overrides
     * this policy. To determine whether the principal actually has the
     * permission, use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessState access = 1;</code>
     *
     * @param value The access to set.
     * @return This builder for chaining.
     */
    public Builder setAccess(com.google.cloud.policysimulator.v1.AccessState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      access_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether _this policy_ provides the specified permission to the
     * specified principal for the specified resource.
     *
     * This field does _not_ indicate whether the principal actually has the
     * permission for the resource. There might be another policy that overrides
     * this policy. To determine whether the principal actually has the
     * permission, use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessState access = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAccess() {
      bitField0_ = (bitField0_ & ~0x00000001);
      access_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object fullResourceName_ = "";
    /**
     *
     *
     * <pre>
     * The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     *
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2;</code>
     *
     * @return The fullResourceName.
     */
    public java.lang.String getFullResourceName() {
      java.lang.Object ref = fullResourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fullResourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     *
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2;</code>
     *
     * @return The bytes for fullResourceName.
     */
    public com.google.protobuf.ByteString getFullResourceNameBytes() {
      java.lang.Object ref = fullResourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fullResourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     *
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2;</code>
     *
     * @param value The fullResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setFullResourceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fullResourceName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     *
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFullResourceName() {
      fullResourceName_ = getDefaultInstance().getFullResourceName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     *
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2;</code>
     *
     * @param value The bytes for fullResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setFullResourceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fullResourceName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.iam.v1.Policy policy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.iam.v1.Policy,
            com.google.iam.v1.Policy.Builder,
            com.google.iam.v1.PolicyOrBuilder>
        policyBuilder_;
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     *
     * @return Whether the policy field is set.
     */
    public boolean hasPolicy() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     *
     * @return The policy.
     */
    public com.google.iam.v1.Policy getPolicy() {
      if (policyBuilder_ == null) {
        return policy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : policy_;
      } else {
        return policyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     */
    public Builder setPolicy(com.google.iam.v1.Policy value) {
      if (policyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        policy_ = value;
      } else {
        policyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     */
    public Builder setPolicy(com.google.iam.v1.Policy.Builder builderForValue) {
      if (policyBuilder_ == null) {
        policy_ = builderForValue.build();
      } else {
        policyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     */
    public Builder mergePolicy(com.google.iam.v1.Policy value) {
      if (policyBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && policy_ != null
            && policy_ != com.google.iam.v1.Policy.getDefaultInstance()) {
          getPolicyBuilder().mergeFrom(value);
        } else {
          policy_ = value;
        }
      } else {
        policyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     */
    public Builder clearPolicy() {
      bitField0_ = (bitField0_ & ~0x00000004);
      policy_ = null;
      if (policyBuilder_ != null) {
        policyBuilder_.dispose();
        policyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     */
    public com.google.iam.v1.Policy.Builder getPolicyBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     */
    public com.google.iam.v1.PolicyOrBuilder getPolicyOrBuilder() {
      if (policyBuilder_ != null) {
        return policyBuilder_.getMessageOrBuilder();
      } else {
        return policy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : policy_;
      }
    }
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.iam.v1.Policy,
            com.google.iam.v1.Policy.Builder,
            com.google.iam.v1.PolicyOrBuilder>
        getPolicyFieldBuilder() {
      if (policyBuilder_ == null) {
        policyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.iam.v1.Policy,
                com.google.iam.v1.Policy.Builder,
                com.google.iam.v1.PolicyOrBuilder>(getPolicy(), getParentForChildren(), isClean());
        policy_ = null;
      }
      return policyBuilder_;
    }

    private java.util.List<com.google.cloud.policysimulator.v1.BindingExplanation>
        bindingExplanations_ = java.util.Collections.emptyList();

    private void ensureBindingExplanationsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        bindingExplanations_ =
            new java.util.ArrayList<com.google.cloud.policysimulator.v1.BindingExplanation>(
                bindingExplanations_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.policysimulator.v1.BindingExplanation,
            com.google.cloud.policysimulator.v1.BindingExplanation.Builder,
            com.google.cloud.policysimulator.v1.BindingExplanationOrBuilder>
        bindingExplanationsBuilder_;

    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.policysimulator.v1.BindingExplanation>
        getBindingExplanationsList() {
      if (bindingExplanationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(bindingExplanations_);
      } else {
        return bindingExplanationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public int getBindingExplanationsCount() {
      if (bindingExplanationsBuilder_ == null) {
        return bindingExplanations_.size();
      } else {
        return bindingExplanationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public com.google.cloud.policysimulator.v1.BindingExplanation getBindingExplanations(
        int index) {
      if (bindingExplanationsBuilder_ == null) {
        return bindingExplanations_.get(index);
      } else {
        return bindingExplanationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public Builder setBindingExplanations(
        int index, com.google.cloud.policysimulator.v1.BindingExplanation value) {
      if (bindingExplanationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBindingExplanationsIsMutable();
        bindingExplanations_.set(index, value);
        onChanged();
      } else {
        bindingExplanationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public Builder setBindingExplanations(
        int index, com.google.cloud.policysimulator.v1.BindingExplanation.Builder builderForValue) {
      if (bindingExplanationsBuilder_ == null) {
        ensureBindingExplanationsIsMutable();
        bindingExplanations_.set(index, builderForValue.build());
        onChanged();
      } else {
        bindingExplanationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public Builder addBindingExplanations(
        com.google.cloud.policysimulator.v1.BindingExplanation value) {
      if (bindingExplanationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBindingExplanationsIsMutable();
        bindingExplanations_.add(value);
        onChanged();
      } else {
        bindingExplanationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public Builder addBindingExplanations(
        int index, com.google.cloud.policysimulator.v1.BindingExplanation value) {
      if (bindingExplanationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBindingExplanationsIsMutable();
        bindingExplanations_.add(index, value);
        onChanged();
      } else {
        bindingExplanationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public Builder addBindingExplanations(
        com.google.cloud.policysimulator.v1.BindingExplanation.Builder builderForValue) {
      if (bindingExplanationsBuilder_ == null) {
        ensureBindingExplanationsIsMutable();
        bindingExplanations_.add(builderForValue.build());
        onChanged();
      } else {
        bindingExplanationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public Builder addBindingExplanations(
        int index, com.google.cloud.policysimulator.v1.BindingExplanation.Builder builderForValue) {
      if (bindingExplanationsBuilder_ == null) {
        ensureBindingExplanationsIsMutable();
        bindingExplanations_.add(index, builderForValue.build());
        onChanged();
      } else {
        bindingExplanationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public Builder addAllBindingExplanations(
        java.lang.Iterable<? extends com.google.cloud.policysimulator.v1.BindingExplanation>
            values) {
      if (bindingExplanationsBuilder_ == null) {
        ensureBindingExplanationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bindingExplanations_);
        onChanged();
      } else {
        bindingExplanationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public Builder clearBindingExplanations() {
      if (bindingExplanationsBuilder_ == null) {
        bindingExplanations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        bindingExplanationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public Builder removeBindingExplanations(int index) {
      if (bindingExplanationsBuilder_ == null) {
        ensureBindingExplanationsIsMutable();
        bindingExplanations_.remove(index);
        onChanged();
      } else {
        bindingExplanationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public com.google.cloud.policysimulator.v1.BindingExplanation.Builder
        getBindingExplanationsBuilder(int index) {
      return getBindingExplanationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public com.google.cloud.policysimulator.v1.BindingExplanationOrBuilder
        getBindingExplanationsOrBuilder(int index) {
      if (bindingExplanationsBuilder_ == null) {
        return bindingExplanations_.get(index);
      } else {
        return bindingExplanationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.policysimulator.v1.BindingExplanationOrBuilder>
        getBindingExplanationsOrBuilderList() {
      if (bindingExplanationsBuilder_ != null) {
        return bindingExplanationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(bindingExplanations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public com.google.cloud.policysimulator.v1.BindingExplanation.Builder
        addBindingExplanationsBuilder() {
      return getBindingExplanationsFieldBuilder()
          .addBuilder(com.google.cloud.policysimulator.v1.BindingExplanation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public com.google.cloud.policysimulator.v1.BindingExplanation.Builder
        addBindingExplanationsBuilder(int index) {
      return getBindingExplanationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.policysimulator.v1.BindingExplanation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the principal's
     * ability, or inability, to use the permission for the resource.
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.policysimulator.v1.BindingExplanation.Builder>
        getBindingExplanationsBuilderList() {
      return getBindingExplanationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.policysimulator.v1.BindingExplanation,
            com.google.cloud.policysimulator.v1.BindingExplanation.Builder,
            com.google.cloud.policysimulator.v1.BindingExplanationOrBuilder>
        getBindingExplanationsFieldBuilder() {
      if (bindingExplanationsBuilder_ == null) {
        bindingExplanationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.policysimulator.v1.BindingExplanation,
                com.google.cloud.policysimulator.v1.BindingExplanation.Builder,
                com.google.cloud.policysimulator.v1.BindingExplanationOrBuilder>(
                bindingExplanations_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        bindingExplanations_ = null;
      }
      return bindingExplanationsBuilder_;
    }

    private int relevance_ = 0;
    /**
     *
     *
     * <pre>
     * The relevance of this policy to the overall determination in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 5;</code>
     *
     * @return The enum numeric value on the wire for relevance.
     */
    @java.lang.Override
    public int getRelevanceValue() {
      return relevance_;
    }
    /**
     *
     *
     * <pre>
     * The relevance of this policy to the overall determination in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 5;</code>
     *
     * @param value The enum numeric value on the wire for relevance to set.
     * @return This builder for chaining.
     */
    public Builder setRelevanceValue(int value) {
      relevance_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relevance of this policy to the overall determination in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 5;</code>
     *
     * @return The relevance.
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.HeuristicRelevance getRelevance() {
      com.google.cloud.policysimulator.v1.HeuristicRelevance result =
          com.google.cloud.policysimulator.v1.HeuristicRelevance.forNumber(relevance_);
      return result == null
          ? com.google.cloud.policysimulator.v1.HeuristicRelevance.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The relevance of this policy to the overall determination in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 5;</code>
     *
     * @param value The relevance to set.
     * @return This builder for chaining.
     */
    public Builder setRelevance(com.google.cloud.policysimulator.v1.HeuristicRelevance value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      relevance_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relevance of this policy to the overall determination in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     *
     * If the user who created the
     * [Replay][google.cloud.policysimulator.v1.Replay] does not have
     * access to the policy, this field is omitted.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelevance() {
      bitField0_ = (bitField0_ & ~0x00000010);
      relevance_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.policysimulator.v1.ExplainedPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.policysimulator.v1.ExplainedPolicy)
  private static final com.google.cloud.policysimulator.v1.ExplainedPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.policysimulator.v1.ExplainedPolicy();
  }

  public static com.google.cloud.policysimulator.v1.ExplainedPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExplainedPolicy> PARSER =
      new com.google.protobuf.AbstractParser<ExplainedPolicy>() {
        @java.lang.Override
        public ExplainedPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExplainedPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExplainedPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ExplainedPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
