/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/explanations.proto

package com.google.cloud.policysimulator.v1;

public interface ExplainedPolicyOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.policysimulator.v1.ExplainedPolicy)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Indicates whether _this policy_ provides the specified permission to the
   * specified principal for the specified resource.
   *
   * This field does _not_ indicate whether the principal actually has the
   * permission for the resource. There might be another policy that overrides
   * this policy. To determine whether the principal actually has the
   * permission, use the `access` field in the
   * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessState access = 1;</code>
   *
   * @return The enum numeric value on the wire for access.
   */
  int getAccessValue();
  /**
   *
   *
   * <pre>
   * Indicates whether _this policy_ provides the specified permission to the
   * specified principal for the specified resource.
   *
   * This field does _not_ indicate whether the principal actually has the
   * permission for the resource. There might be another policy that overrides
   * this policy. To determine whether the principal actually has the
   * permission, use the `access` field in the
   * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessState access = 1;</code>
   *
   * @return The access.
   */
  com.google.cloud.policysimulator.v1.AccessState getAccess();

  /**
   *
   *
   * <pre>
   * The full resource name that identifies the resource. For example,
   * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   *
   * For examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   * </pre>
   *
   * <code>string full_resource_name = 2;</code>
   *
   * @return The fullResourceName.
   */
  java.lang.String getFullResourceName();
  /**
   *
   *
   * <pre>
   * The full resource name that identifies the resource. For example,
   * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   *
   * For examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   * </pre>
   *
   * <code>string full_resource_name = 2;</code>
   *
   * @return The bytes for fullResourceName.
   */
  com.google.protobuf.ByteString getFullResourceNameBytes();

  /**
   *
   *
   * <pre>
   * The IAM policy attached to the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is empty.
   * </pre>
   *
   * <code>.google.iam.v1.Policy policy = 3;</code>
   *
   * @return Whether the policy field is set.
   */
  boolean hasPolicy();
  /**
   *
   *
   * <pre>
   * The IAM policy attached to the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is empty.
   * </pre>
   *
   * <code>.google.iam.v1.Policy policy = 3;</code>
   *
   * @return The policy.
   */
  com.google.iam.v1.Policy getPolicy();
  /**
   *
   *
   * <pre>
   * The IAM policy attached to the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is empty.
   * </pre>
   *
   * <code>.google.iam.v1.Policy policy = 3;</code>
   */
  com.google.iam.v1.PolicyOrBuilder getPolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * Details about how each binding in the policy affects the principal's
   * ability, or inability, to use the permission for the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
   * </code>
   */
  java.util.List<com.google.cloud.policysimulator.v1.BindingExplanation>
      getBindingExplanationsList();
  /**
   *
   *
   * <pre>
   * Details about how each binding in the policy affects the principal's
   * ability, or inability, to use the permission for the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
   * </code>
   */
  com.google.cloud.policysimulator.v1.BindingExplanation getBindingExplanations(int index);
  /**
   *
   *
   * <pre>
   * Details about how each binding in the policy affects the principal's
   * ability, or inability, to use the permission for the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
   * </code>
   */
  int getBindingExplanationsCount();
  /**
   *
   *
   * <pre>
   * Details about how each binding in the policy affects the principal's
   * ability, or inability, to use the permission for the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
   * </code>
   */
  java.util.List<? extends com.google.cloud.policysimulator.v1.BindingExplanationOrBuilder>
      getBindingExplanationsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Details about how each binding in the policy affects the principal's
   * ability, or inability, to use the permission for the resource.
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.BindingExplanation binding_explanations = 4;
   * </code>
   */
  com.google.cloud.policysimulator.v1.BindingExplanationOrBuilder getBindingExplanationsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * The relevance of this policy to the overall determination in the
   * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 5;</code>
   *
   * @return The enum numeric value on the wire for relevance.
   */
  int getRelevanceValue();
  /**
   *
   *
   * <pre>
   * The relevance of this policy to the overall determination in the
   * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
   *
   * If the user who created the
   * [Replay][google.cloud.policysimulator.v1.Replay] does not have
   * access to the policy, this field is omitted.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.HeuristicRelevance relevance = 5;</code>
   *
   * @return The relevance.
   */
  com.google.cloud.policysimulator.v1.HeuristicRelevance getRelevance();
}
