/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/explanations.proto

package com.google.cloud.policysimulator.v1;

/**
 *
 *
 * <pre>
 * The extent to which a single data point, such as the existence of a binding
 * or whether a binding includes a specific principal, contributes to an overall
 * determination.
 * </pre>
 *
 * Protobuf enum {@code google.cloud.policysimulator.v1.HeuristicRelevance}
 */
public enum HeuristicRelevance implements com.google.protobuf.ProtocolMessageEnum {
  /**
   *
   *
   * <pre>
   * Default value. This value is unused.
   * </pre>
   *
   * <code>HEURISTIC_RELEVANCE_UNSPECIFIED = 0;</code>
   */
  HEURISTIC_RELEVANCE_UNSPECIFIED(0),
  /**
   *
   *
   * <pre>
   * The data point has a limited effect on the result. Changing the data point
   * is unlikely to affect the overall determination.
   * </pre>
   *
   * <code>NORMAL = 1;</code>
   */
  NORMAL(1),
  /**
   *
   *
   * <pre>
   * The data point has a strong effect on the result. Changing the data point
   * is likely to affect the overall determination.
   * </pre>
   *
   * <code>HIGH = 2;</code>
   */
  HIGH(2),
  UNRECOGNIZED(-1),
  ;

  /**
   *
   *
   * <pre>
   * Default value. This value is unused.
   * </pre>
   *
   * <code>HEURISTIC_RELEVANCE_UNSPECIFIED = 0;</code>
   */
  public static final int HEURISTIC_RELEVANCE_UNSPECIFIED_VALUE = 0;
  /**
   *
   *
   * <pre>
   * The data point has a limited effect on the result. Changing the data point
   * is unlikely to affect the overall determination.
   * </pre>
   *
   * <code>NORMAL = 1;</code>
   */
  public static final int NORMAL_VALUE = 1;
  /**
   *
   *
   * <pre>
   * The data point has a strong effect on the result. Changing the data point
   * is likely to affect the overall determination.
   * </pre>
   *
   * <code>HIGH = 2;</code>
   */
  public static final int HIGH_VALUE = 2;

  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static HeuristicRelevance valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static HeuristicRelevance forNumber(int value) {
    switch (value) {
      case 0:
        return HEURISTIC_RELEVANCE_UNSPECIFIED;
      case 1:
        return NORMAL;
      case 2:
        return HIGH;
      default:
        return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<HeuristicRelevance> internalGetValueMap() {
    return internalValueMap;
  }

  private static final com.google.protobuf.Internal.EnumLiteMap<HeuristicRelevance>
      internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<HeuristicRelevance>() {
            public HeuristicRelevance findValueByNumber(int number) {
              return HeuristicRelevance.forNumber(number);
            }
          };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalStateException(
          "Can't get the descriptor of an unrecognized enum value.");
    }
    return getDescriptor().getValues().get(ordinal());
  }

  public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
    return getDescriptor();
  }

  public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
    return com.google.cloud.policysimulator.v1.ExplanationsProto.getDescriptor()
        .getEnumTypes()
        .get(1);
  }

  private static final HeuristicRelevance[] VALUES = values();

  public static HeuristicRelevance valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private HeuristicRelevance(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.cloud.policysimulator.v1.HeuristicRelevance)
}
