/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/simulator.proto

package com.google.cloud.policysimulator.v1;

/**
 *
 *
 * <pre>
 * The configuration used for a
 * [Replay][google.cloud.policysimulator.v1.Replay].
 * </pre>
 *
 * Protobuf type {@code google.cloud.policysimulator.v1.ReplayConfig}
 */
public final class ReplayConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.policysimulator.v1.ReplayConfig)
    ReplayConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReplayConfig.newBuilder() to construct.
  private ReplayConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReplayConfig() {
    logSource_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReplayConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.policysimulator.v1.SimulatorProto
        .internal_static_google_cloud_policysimulator_v1_ReplayConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 1:
        return internalGetPolicyOverlay();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.policysimulator.v1.SimulatorProto
        .internal_static_google_cloud_policysimulator_v1_ReplayConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.policysimulator.v1.ReplayConfig.class,
            com.google.cloud.policysimulator.v1.ReplayConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The source of the logs to use for a
   * [Replay][google.cloud.policysimulator.v1.Replay].
   * </pre>
   *
   * Protobuf enum {@code google.cloud.policysimulator.v1.ReplayConfig.LogSource}
   */
  public enum LogSource implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * An unspecified log source.
     * If the log source is unspecified, the
     * [Replay][google.cloud.policysimulator.v1.Replay] defaults to using
     * `RECENT_ACCESSES`.
     * </pre>
     *
     * <code>LOG_SOURCE_UNSPECIFIED = 0;</code>
     */
    LOG_SOURCE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * All access logs from the last 90 days. These logs may not include logs
     * from the most recent 7 days.
     * </pre>
     *
     * <code>RECENT_ACCESSES = 1;</code>
     */
    RECENT_ACCESSES(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * An unspecified log source.
     * If the log source is unspecified, the
     * [Replay][google.cloud.policysimulator.v1.Replay] defaults to using
     * `RECENT_ACCESSES`.
     * </pre>
     *
     * <code>LOG_SOURCE_UNSPECIFIED = 0;</code>
     */
    public static final int LOG_SOURCE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * All access logs from the last 90 days. These logs may not include logs
     * from the most recent 7 days.
     * </pre>
     *
     * <code>RECENT_ACCESSES = 1;</code>
     */
    public static final int RECENT_ACCESSES_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LogSource valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LogSource forNumber(int value) {
      switch (value) {
        case 0:
          return LOG_SOURCE_UNSPECIFIED;
        case 1:
          return RECENT_ACCESSES;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LogSource> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LogSource> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<LogSource>() {
          public LogSource findValueByNumber(int number) {
            return LogSource.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.ReplayConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final LogSource[] VALUES = values();

    public static LogSource valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LogSource(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.policysimulator.v1.ReplayConfig.LogSource)
  }

  public static final int POLICY_OVERLAY_FIELD_NUMBER = 1;

  private static final class PolicyOverlayDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.iam.v1.Policy>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.iam.v1.Policy>newDefaultInstance(
                    com.google.cloud.policysimulator.v1.SimulatorProto
                        .internal_static_google_cloud_policysimulator_v1_ReplayConfig_PolicyOverlayEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.iam.v1.Policy.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.iam.v1.Policy> policyOverlay_;

  private com.google.protobuf.MapField<java.lang.String, com.google.iam.v1.Policy>
      internalGetPolicyOverlay() {
    if (policyOverlay_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          PolicyOverlayDefaultEntryHolder.defaultEntry);
    }
    return policyOverlay_;
  }

  public int getPolicyOverlayCount() {
    return internalGetPolicyOverlay().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A mapping of the resources that you want to simulate policies for and the
   * policies that you want to simulate.
   *
   * Keys are the full resource names for the resources. For example,
   * `//cloudresourcemanager.googleapis.com/projects/my-project`.
   * For examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   *
   * Values are [Policy][google.iam.v1.Policy] objects representing the policies
   * that you want to simulate.
   *
   * Replays automatically take into account any IAM policies inherited through
   * the resource hierarchy, and any policies set on descendant resources. You
   * do not need to include these policies in the policy overlay.
   * </pre>
   *
   * <code>map&lt;string, .google.iam.v1.Policy&gt; policy_overlay = 1;</code>
   */
  @java.lang.Override
  public boolean containsPolicyOverlay(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetPolicyOverlay().getMap().containsKey(key);
  }
  /** Use {@link #getPolicyOverlayMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.iam.v1.Policy> getPolicyOverlay() {
    return getPolicyOverlayMap();
  }
  /**
   *
   *
   * <pre>
   * A mapping of the resources that you want to simulate policies for and the
   * policies that you want to simulate.
   *
   * Keys are the full resource names for the resources. For example,
   * `//cloudresourcemanager.googleapis.com/projects/my-project`.
   * For examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   *
   * Values are [Policy][google.iam.v1.Policy] objects representing the policies
   * that you want to simulate.
   *
   * Replays automatically take into account any IAM policies inherited through
   * the resource hierarchy, and any policies set on descendant resources. You
   * do not need to include these policies in the policy overlay.
   * </pre>
   *
   * <code>map&lt;string, .google.iam.v1.Policy&gt; policy_overlay = 1;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.iam.v1.Policy> getPolicyOverlayMap() {
    return internalGetPolicyOverlay().getMap();
  }
  /**
   *
   *
   * <pre>
   * A mapping of the resources that you want to simulate policies for and the
   * policies that you want to simulate.
   *
   * Keys are the full resource names for the resources. For example,
   * `//cloudresourcemanager.googleapis.com/projects/my-project`.
   * For examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   *
   * Values are [Policy][google.iam.v1.Policy] objects representing the policies
   * that you want to simulate.
   *
   * Replays automatically take into account any IAM policies inherited through
   * the resource hierarchy, and any policies set on descendant resources. You
   * do not need to include these policies in the policy overlay.
   * </pre>
   *
   * <code>map&lt;string, .google.iam.v1.Policy&gt; policy_overlay = 1;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.iam.v1.Policy getPolicyOverlayOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.iam.v1.Policy defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.iam.v1.Policy> map =
        internalGetPolicyOverlay().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A mapping of the resources that you want to simulate policies for and the
   * policies that you want to simulate.
   *
   * Keys are the full resource names for the resources. For example,
   * `//cloudresourcemanager.googleapis.com/projects/my-project`.
   * For examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   *
   * Values are [Policy][google.iam.v1.Policy] objects representing the policies
   * that you want to simulate.
   *
   * Replays automatically take into account any IAM policies inherited through
   * the resource hierarchy, and any policies set on descendant resources. You
   * do not need to include these policies in the policy overlay.
   * </pre>
   *
   * <code>map&lt;string, .google.iam.v1.Policy&gt; policy_overlay = 1;</code>
   */
  @java.lang.Override
  public com.google.iam.v1.Policy getPolicyOverlayOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.iam.v1.Policy> map =
        internalGetPolicyOverlay().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LOG_SOURCE_FIELD_NUMBER = 2;
  private int logSource_ = 0;
  /**
   *
   *
   * <pre>
   * The logs to use as input for the
   * [Replay][google.cloud.policysimulator.v1.Replay].
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ReplayConfig.LogSource log_source = 2;</code>
   *
   * @return The enum numeric value on the wire for logSource.
   */
  @java.lang.Override
  public int getLogSourceValue() {
    return logSource_;
  }
  /**
   *
   *
   * <pre>
   * The logs to use as input for the
   * [Replay][google.cloud.policysimulator.v1.Replay].
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ReplayConfig.LogSource log_source = 2;</code>
   *
   * @return The logSource.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ReplayConfig.LogSource getLogSource() {
    com.google.cloud.policysimulator.v1.ReplayConfig.LogSource result =
        com.google.cloud.policysimulator.v1.ReplayConfig.LogSource.forNumber(logSource_);
    return result == null
        ? com.google.cloud.policysimulator.v1.ReplayConfig.LogSource.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetPolicyOverlay(), PolicyOverlayDefaultEntryHolder.defaultEntry, 1);
    if (logSource_
        != com.google.cloud.policysimulator.v1.ReplayConfig.LogSource.LOG_SOURCE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, logSource_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<java.lang.String, com.google.iam.v1.Policy> entry :
        internalGetPolicyOverlay().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.iam.v1.Policy> policyOverlay__ =
          PolicyOverlayDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, policyOverlay__);
    }
    if (logSource_
        != com.google.cloud.policysimulator.v1.ReplayConfig.LogSource.LOG_SOURCE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, logSource_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.policysimulator.v1.ReplayConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.policysimulator.v1.ReplayConfig other =
        (com.google.cloud.policysimulator.v1.ReplayConfig) obj;

    if (!internalGetPolicyOverlay().equals(other.internalGetPolicyOverlay())) return false;
    if (logSource_ != other.logSource_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetPolicyOverlay().getMap().isEmpty()) {
      hash = (37 * hash) + POLICY_OVERLAY_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPolicyOverlay().hashCode();
    }
    hash = (37 * hash) + LOG_SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + logSource_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.policysimulator.v1.ReplayConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.ReplayConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ReplayConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.ReplayConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ReplayConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.ReplayConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ReplayConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.ReplayConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ReplayConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.ReplayConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ReplayConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.ReplayConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.policysimulator.v1.ReplayConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration used for a
   * [Replay][google.cloud.policysimulator.v1.Replay].
   * </pre>
   *
   * Protobuf type {@code google.cloud.policysimulator.v1.ReplayConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.policysimulator.v1.ReplayConfig)
      com.google.cloud.policysimulator.v1.ReplayConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_ReplayConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 1:
          return internalGetPolicyOverlay();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 1:
          return internalGetMutablePolicyOverlay();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_ReplayConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.policysimulator.v1.ReplayConfig.class,
              com.google.cloud.policysimulator.v1.ReplayConfig.Builder.class);
    }

    // Construct using com.google.cloud.policysimulator.v1.ReplayConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutablePolicyOverlay().clear();
      logSource_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_ReplayConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ReplayConfig getDefaultInstanceForType() {
      return com.google.cloud.policysimulator.v1.ReplayConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ReplayConfig build() {
      com.google.cloud.policysimulator.v1.ReplayConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ReplayConfig buildPartial() {
      com.google.cloud.policysimulator.v1.ReplayConfig result =
          new com.google.cloud.policysimulator.v1.ReplayConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.policysimulator.v1.ReplayConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.policyOverlay_ = internalGetPolicyOverlay();
        result.policyOverlay_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.logSource_ = logSource_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.policysimulator.v1.ReplayConfig) {
        return mergeFrom((com.google.cloud.policysimulator.v1.ReplayConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.policysimulator.v1.ReplayConfig other) {
      if (other == com.google.cloud.policysimulator.v1.ReplayConfig.getDefaultInstance())
        return this;
      internalGetMutablePolicyOverlay().mergeFrom(other.internalGetPolicyOverlay());
      bitField0_ |= 0x00000001;
      if (other.logSource_ != 0) {
        setLogSourceValue(other.getLogSourceValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.iam.v1.Policy>
                    policyOverlay__ =
                        input.readMessage(
                            PolicyOverlayDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutablePolicyOverlay()
                    .getMutableMap()
                    .put(policyOverlay__.getKey(), policyOverlay__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                logSource_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<java.lang.String, com.google.iam.v1.Policy> policyOverlay_;

    private com.google.protobuf.MapField<java.lang.String, com.google.iam.v1.Policy>
        internalGetPolicyOverlay() {
      if (policyOverlay_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PolicyOverlayDefaultEntryHolder.defaultEntry);
      }
      return policyOverlay_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.iam.v1.Policy>
        internalGetMutablePolicyOverlay() {
      if (policyOverlay_ == null) {
        policyOverlay_ =
            com.google.protobuf.MapField.newMapField(PolicyOverlayDefaultEntryHolder.defaultEntry);
      }
      if (!policyOverlay_.isMutable()) {
        policyOverlay_ = policyOverlay_.copy();
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return policyOverlay_;
    }

    public int getPolicyOverlayCount() {
      return internalGetPolicyOverlay().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A mapping of the resources that you want to simulate policies for and the
     * policies that you want to simulate.
     *
     * Keys are the full resource names for the resources. For example,
     * `//cloudresourcemanager.googleapis.com/projects/my-project`.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     *
     * Values are [Policy][google.iam.v1.Policy] objects representing the policies
     * that you want to simulate.
     *
     * Replays automatically take into account any IAM policies inherited through
     * the resource hierarchy, and any policies set on descendant resources. You
     * do not need to include these policies in the policy overlay.
     * </pre>
     *
     * <code>map&lt;string, .google.iam.v1.Policy&gt; policy_overlay = 1;</code>
     */
    @java.lang.Override
    public boolean containsPolicyOverlay(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetPolicyOverlay().getMap().containsKey(key);
    }
    /** Use {@link #getPolicyOverlayMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.iam.v1.Policy> getPolicyOverlay() {
      return getPolicyOverlayMap();
    }
    /**
     *
     *
     * <pre>
     * A mapping of the resources that you want to simulate policies for and the
     * policies that you want to simulate.
     *
     * Keys are the full resource names for the resources. For example,
     * `//cloudresourcemanager.googleapis.com/projects/my-project`.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     *
     * Values are [Policy][google.iam.v1.Policy] objects representing the policies
     * that you want to simulate.
     *
     * Replays automatically take into account any IAM policies inherited through
     * the resource hierarchy, and any policies set on descendant resources. You
     * do not need to include these policies in the policy overlay.
     * </pre>
     *
     * <code>map&lt;string, .google.iam.v1.Policy&gt; policy_overlay = 1;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.iam.v1.Policy> getPolicyOverlayMap() {
      return internalGetPolicyOverlay().getMap();
    }
    /**
     *
     *
     * <pre>
     * A mapping of the resources that you want to simulate policies for and the
     * policies that you want to simulate.
     *
     * Keys are the full resource names for the resources. For example,
     * `//cloudresourcemanager.googleapis.com/projects/my-project`.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     *
     * Values are [Policy][google.iam.v1.Policy] objects representing the policies
     * that you want to simulate.
     *
     * Replays automatically take into account any IAM policies inherited through
     * the resource hierarchy, and any policies set on descendant resources. You
     * do not need to include these policies in the policy overlay.
     * </pre>
     *
     * <code>map&lt;string, .google.iam.v1.Policy&gt; policy_overlay = 1;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.iam.v1.Policy getPolicyOverlayOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.iam.v1.Policy defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.iam.v1.Policy> map =
          internalGetPolicyOverlay().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A mapping of the resources that you want to simulate policies for and the
     * policies that you want to simulate.
     *
     * Keys are the full resource names for the resources. For example,
     * `//cloudresourcemanager.googleapis.com/projects/my-project`.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     *
     * Values are [Policy][google.iam.v1.Policy] objects representing the policies
     * that you want to simulate.
     *
     * Replays automatically take into account any IAM policies inherited through
     * the resource hierarchy, and any policies set on descendant resources. You
     * do not need to include these policies in the policy overlay.
     * </pre>
     *
     * <code>map&lt;string, .google.iam.v1.Policy&gt; policy_overlay = 1;</code>
     */
    @java.lang.Override
    public com.google.iam.v1.Policy getPolicyOverlayOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.iam.v1.Policy> map =
          internalGetPolicyOverlay().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearPolicyOverlay() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutablePolicyOverlay().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A mapping of the resources that you want to simulate policies for and the
     * policies that you want to simulate.
     *
     * Keys are the full resource names for the resources. For example,
     * `//cloudresourcemanager.googleapis.com/projects/my-project`.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     *
     * Values are [Policy][google.iam.v1.Policy] objects representing the policies
     * that you want to simulate.
     *
     * Replays automatically take into account any IAM policies inherited through
     * the resource hierarchy, and any policies set on descendant resources. You
     * do not need to include these policies in the policy overlay.
     * </pre>
     *
     * <code>map&lt;string, .google.iam.v1.Policy&gt; policy_overlay = 1;</code>
     */
    public Builder removePolicyOverlay(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutablePolicyOverlay().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.iam.v1.Policy> getMutablePolicyOverlay() {
      bitField0_ |= 0x00000001;
      return internalGetMutablePolicyOverlay().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A mapping of the resources that you want to simulate policies for and the
     * policies that you want to simulate.
     *
     * Keys are the full resource names for the resources. For example,
     * `//cloudresourcemanager.googleapis.com/projects/my-project`.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     *
     * Values are [Policy][google.iam.v1.Policy] objects representing the policies
     * that you want to simulate.
     *
     * Replays automatically take into account any IAM policies inherited through
     * the resource hierarchy, and any policies set on descendant resources. You
     * do not need to include these policies in the policy overlay.
     * </pre>
     *
     * <code>map&lt;string, .google.iam.v1.Policy&gt; policy_overlay = 1;</code>
     */
    public Builder putPolicyOverlay(java.lang.String key, com.google.iam.v1.Policy value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutablePolicyOverlay().getMutableMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A mapping of the resources that you want to simulate policies for and the
     * policies that you want to simulate.
     *
     * Keys are the full resource names for the resources. For example,
     * `//cloudresourcemanager.googleapis.com/projects/my-project`.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     *
     * Values are [Policy][google.iam.v1.Policy] objects representing the policies
     * that you want to simulate.
     *
     * Replays automatically take into account any IAM policies inherited through
     * the resource hierarchy, and any policies set on descendant resources. You
     * do not need to include these policies in the policy overlay.
     * </pre>
     *
     * <code>map&lt;string, .google.iam.v1.Policy&gt; policy_overlay = 1;</code>
     */
    public Builder putAllPolicyOverlay(
        java.util.Map<java.lang.String, com.google.iam.v1.Policy> values) {
      internalGetMutablePolicyOverlay().getMutableMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    private int logSource_ = 0;
    /**
     *
     *
     * <pre>
     * The logs to use as input for the
     * [Replay][google.cloud.policysimulator.v1.Replay].
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayConfig.LogSource log_source = 2;</code>
     *
     * @return The enum numeric value on the wire for logSource.
     */
    @java.lang.Override
    public int getLogSourceValue() {
      return logSource_;
    }
    /**
     *
     *
     * <pre>
     * The logs to use as input for the
     * [Replay][google.cloud.policysimulator.v1.Replay].
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayConfig.LogSource log_source = 2;</code>
     *
     * @param value The enum numeric value on the wire for logSource to set.
     * @return This builder for chaining.
     */
    public Builder setLogSourceValue(int value) {
      logSource_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The logs to use as input for the
     * [Replay][google.cloud.policysimulator.v1.Replay].
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayConfig.LogSource log_source = 2;</code>
     *
     * @return The logSource.
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ReplayConfig.LogSource getLogSource() {
      com.google.cloud.policysimulator.v1.ReplayConfig.LogSource result =
          com.google.cloud.policysimulator.v1.ReplayConfig.LogSource.forNumber(logSource_);
      return result == null
          ? com.google.cloud.policysimulator.v1.ReplayConfig.LogSource.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The logs to use as input for the
     * [Replay][google.cloud.policysimulator.v1.Replay].
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayConfig.LogSource log_source = 2;</code>
     *
     * @param value The logSource to set.
     * @return This builder for chaining.
     */
    public Builder setLogSource(com.google.cloud.policysimulator.v1.ReplayConfig.LogSource value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      logSource_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The logs to use as input for the
     * [Replay][google.cloud.policysimulator.v1.Replay].
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayConfig.LogSource log_source = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogSource() {
      bitField0_ = (bitField0_ & ~0x00000002);
      logSource_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.policysimulator.v1.ReplayConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.policysimulator.v1.ReplayConfig)
  private static final com.google.cloud.policysimulator.v1.ReplayConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.policysimulator.v1.ReplayConfig();
  }

  public static com.google.cloud.policysimulator.v1.ReplayConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReplayConfig> PARSER =
      new com.google.protobuf.AbstractParser<ReplayConfig>() {
        @java.lang.Override
        public ReplayConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReplayConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReplayConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ReplayConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
