/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/simulator.proto

package com.google.cloud.policysimulator.v1;

/**
 *
 *
 * <pre>
 * The result of replaying a single access tuple against a simulated state.
 * </pre>
 *
 * Protobuf type {@code google.cloud.policysimulator.v1.ReplayResult}
 */
public final class ReplayResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.policysimulator.v1.ReplayResult)
    ReplayResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReplayResult.newBuilder() to construct.
  private ReplayResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReplayResult() {
    name_ = "";
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReplayResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.policysimulator.v1.SimulatorProto
        .internal_static_google_cloud_policysimulator_v1_ReplayResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.policysimulator.v1.SimulatorProto
        .internal_static_google_cloud_policysimulator_v1_ReplayResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.policysimulator.v1.ReplayResult.class,
            com.google.cloud.policysimulator.v1.ReplayResult.Builder.class);
  }

  private int resultCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object result_;

  public enum ResultCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DIFF(5),
    ERROR(6),
    RESULT_NOT_SET(0);
    private final int value;

    private ResultCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResultCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResultCase forNumber(int value) {
      switch (value) {
        case 5:
          return DIFF;
        case 6:
          return ERROR;
        case 0:
          return RESULT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResultCase getResultCase() {
    return ResultCase.forNumber(resultCase_);
  }

  public static final int DIFF_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The difference between the principal's access under the current
   * (baseline) policies and the principal's access under the proposed
   * (simulated) policies.
   *
   * This field is only included for access tuples that were successfully
   * replayed and had different results under the current policies and the
   * proposed policies.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
   *
   * @return Whether the diff field is set.
   */
  @java.lang.Override
  public boolean hasDiff() {
    return resultCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The difference between the principal's access under the current
   * (baseline) policies and the principal's access under the proposed
   * (simulated) policies.
   *
   * This field is only included for access tuples that were successfully
   * replayed and had different results under the current policies and the
   * proposed policies.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
   *
   * @return The diff.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ReplayDiff getDiff() {
    if (resultCase_ == 5) {
      return (com.google.cloud.policysimulator.v1.ReplayDiff) result_;
    }
    return com.google.cloud.policysimulator.v1.ReplayDiff.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The difference between the principal's access under the current
   * (baseline) policies and the principal's access under the proposed
   * (simulated) policies.
   *
   * This field is only included for access tuples that were successfully
   * replayed and had different results under the current policies and the
   * proposed policies.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ReplayDiffOrBuilder getDiffOrBuilder() {
    if (resultCase_ == 5) {
      return (com.google.cloud.policysimulator.v1.ReplayDiff) result_;
    }
    return com.google.cloud.policysimulator.v1.ReplayDiff.getDefaultInstance();
  }

  public static final int ERROR_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The error that caused the access tuple replay to fail.
   *
   * This field is only included for access tuples that were not replayed
   * successfully.
   * </pre>
   *
   * <code>.google.rpc.Status error = 6;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return resultCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The error that caused the access tuple replay to fail.
   *
   * This field is only included for access tuples that were not replayed
   * successfully.
   * </pre>
   *
   * <code>.google.rpc.Status error = 6;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    if (resultCase_ == 6) {
      return (com.google.rpc.Status) result_;
    }
    return com.google.rpc.Status.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The error that caused the access tuple replay to fail.
   *
   * This field is only included for access tuples that were not replayed
   * successfully.
   * </pre>
   *
   * <code>.google.rpc.Status error = 6;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    if (resultCase_ == 6) {
      return (com.google.rpc.Status) result_;
    }
    return com.google.rpc.Status.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the `ReplayResult`, in the following format:
   *
   * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
   * where `{resource-id}` is the ID of the project, folder, or organization
   * that owns the [Replay][google.cloud.policysimulator.v1.Replay].
   *
   * Example:
   * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the `ReplayResult`, in the following format:
   *
   * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
   * where `{resource-id}` is the ID of the project, folder, or organization
   * that owns the [Replay][google.cloud.policysimulator.v1.Replay].
   *
   * Example:
   * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
   * was included in.
   * </pre>
   *
   * <code>string parent = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
   * was included in.
   * </pre>
   *
   * <code>string parent = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACCESS_TUPLE_FIELD_NUMBER = 3;
  private com.google.cloud.policysimulator.v1.AccessTuple accessTuple_;
  /**
   *
   *
   * <pre>
   * The access tuple that was replayed. This field includes information about
   * the principal, resource, and permission that were involved in the access
   * attempt.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
   *
   * @return Whether the accessTuple field is set.
   */
  @java.lang.Override
  public boolean hasAccessTuple() {
    return accessTuple_ != null;
  }
  /**
   *
   *
   * <pre>
   * The access tuple that was replayed. This field includes information about
   * the principal, resource, and permission that were involved in the access
   * attempt.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
   *
   * @return The accessTuple.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.AccessTuple getAccessTuple() {
    return accessTuple_ == null
        ? com.google.cloud.policysimulator.v1.AccessTuple.getDefaultInstance()
        : accessTuple_;
  }
  /**
   *
   *
   * <pre>
   * The access tuple that was replayed. This field includes information about
   * the principal, resource, and permission that were involved in the access
   * attempt.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.AccessTupleOrBuilder getAccessTupleOrBuilder() {
    return accessTuple_ == null
        ? com.google.cloud.policysimulator.v1.AccessTuple.getDefaultInstance()
        : accessTuple_;
  }

  public static final int LAST_SEEN_DATE_FIELD_NUMBER = 4;
  private com.google.type.Date lastSeenDate_;
  /**
   *
   *
   * <pre>
   * The latest date this access tuple was seen in the logs.
   * </pre>
   *
   * <code>.google.type.Date last_seen_date = 4;</code>
   *
   * @return Whether the lastSeenDate field is set.
   */
  @java.lang.Override
  public boolean hasLastSeenDate() {
    return lastSeenDate_ != null;
  }
  /**
   *
   *
   * <pre>
   * The latest date this access tuple was seen in the logs.
   * </pre>
   *
   * <code>.google.type.Date last_seen_date = 4;</code>
   *
   * @return The lastSeenDate.
   */
  @java.lang.Override
  public com.google.type.Date getLastSeenDate() {
    return lastSeenDate_ == null ? com.google.type.Date.getDefaultInstance() : lastSeenDate_;
  }
  /**
   *
   *
   * <pre>
   * The latest date this access tuple was seen in the logs.
   * </pre>
   *
   * <code>.google.type.Date last_seen_date = 4;</code>
   */
  @java.lang.Override
  public com.google.type.DateOrBuilder getLastSeenDateOrBuilder() {
    return lastSeenDate_ == null ? com.google.type.Date.getDefaultInstance() : lastSeenDate_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, parent_);
    }
    if (accessTuple_ != null) {
      output.writeMessage(3, getAccessTuple());
    }
    if (lastSeenDate_ != null) {
      output.writeMessage(4, getLastSeenDate());
    }
    if (resultCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.policysimulator.v1.ReplayDiff) result_);
    }
    if (resultCase_ == 6) {
      output.writeMessage(6, (com.google.rpc.Status) result_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, parent_);
    }
    if (accessTuple_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAccessTuple());
    }
    if (lastSeenDate_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getLastSeenDate());
    }
    if (resultCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.policysimulator.v1.ReplayDiff) result_);
    }
    if (resultCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.rpc.Status) result_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.policysimulator.v1.ReplayResult)) {
      return super.equals(obj);
    }
    com.google.cloud.policysimulator.v1.ReplayResult other =
        (com.google.cloud.policysimulator.v1.ReplayResult) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getParent().equals(other.getParent())) return false;
    if (hasAccessTuple() != other.hasAccessTuple()) return false;
    if (hasAccessTuple()) {
      if (!getAccessTuple().equals(other.getAccessTuple())) return false;
    }
    if (hasLastSeenDate() != other.hasLastSeenDate()) return false;
    if (hasLastSeenDate()) {
      if (!getLastSeenDate().equals(other.getLastSeenDate())) return false;
    }
    if (!getResultCase().equals(other.getResultCase())) return false;
    switch (resultCase_) {
      case 5:
        if (!getDiff().equals(other.getDiff())) return false;
        break;
      case 6:
        if (!getError().equals(other.getError())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasAccessTuple()) {
      hash = (37 * hash) + ACCESS_TUPLE_FIELD_NUMBER;
      hash = (53 * hash) + getAccessTuple().hashCode();
    }
    if (hasLastSeenDate()) {
      hash = (37 * hash) + LAST_SEEN_DATE_FIELD_NUMBER;
      hash = (53 * hash) + getLastSeenDate().hashCode();
    }
    switch (resultCase_) {
      case 5:
        hash = (37 * hash) + DIFF_FIELD_NUMBER;
        hash = (53 * hash) + getDiff().hashCode();
        break;
      case 6:
        hash = (37 * hash) + ERROR_FIELD_NUMBER;
        hash = (53 * hash) + getError().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.policysimulator.v1.ReplayResult parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.ReplayResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ReplayResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.ReplayResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ReplayResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.ReplayResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ReplayResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.ReplayResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ReplayResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.ReplayResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ReplayResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.ReplayResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.policysimulator.v1.ReplayResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The result of replaying a single access tuple against a simulated state.
   * </pre>
   *
   * Protobuf type {@code google.cloud.policysimulator.v1.ReplayResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.policysimulator.v1.ReplayResult)
      com.google.cloud.policysimulator.v1.ReplayResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_ReplayResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_ReplayResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.policysimulator.v1.ReplayResult.class,
              com.google.cloud.policysimulator.v1.ReplayResult.Builder.class);
    }

    // Construct using com.google.cloud.policysimulator.v1.ReplayResult.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (diffBuilder_ != null) {
        diffBuilder_.clear();
      }
      if (errorBuilder_ != null) {
        errorBuilder_.clear();
      }
      name_ = "";
      parent_ = "";
      accessTuple_ = null;
      if (accessTupleBuilder_ != null) {
        accessTupleBuilder_.dispose();
        accessTupleBuilder_ = null;
      }
      lastSeenDate_ = null;
      if (lastSeenDateBuilder_ != null) {
        lastSeenDateBuilder_.dispose();
        lastSeenDateBuilder_ = null;
      }
      resultCase_ = 0;
      result_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_ReplayResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ReplayResult getDefaultInstanceForType() {
      return com.google.cloud.policysimulator.v1.ReplayResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ReplayResult build() {
      com.google.cloud.policysimulator.v1.ReplayResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ReplayResult buildPartial() {
      com.google.cloud.policysimulator.v1.ReplayResult result =
          new com.google.cloud.policysimulator.v1.ReplayResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.policysimulator.v1.ReplayResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.accessTuple_ =
            accessTupleBuilder_ == null ? accessTuple_ : accessTupleBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.lastSeenDate_ =
            lastSeenDateBuilder_ == null ? lastSeenDate_ : lastSeenDateBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.policysimulator.v1.ReplayResult result) {
      result.resultCase_ = resultCase_;
      result.result_ = this.result_;
      if (resultCase_ == 5 && diffBuilder_ != null) {
        result.result_ = diffBuilder_.build();
      }
      if (resultCase_ == 6 && errorBuilder_ != null) {
        result.result_ = errorBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.policysimulator.v1.ReplayResult) {
        return mergeFrom((com.google.cloud.policysimulator.v1.ReplayResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.policysimulator.v1.ReplayResult other) {
      if (other == com.google.cloud.policysimulator.v1.ReplayResult.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasAccessTuple()) {
        mergeAccessTuple(other.getAccessTuple());
      }
      if (other.hasLastSeenDate()) {
        mergeLastSeenDate(other.getLastSeenDate());
      }
      switch (other.getResultCase()) {
        case DIFF:
          {
            mergeDiff(other.getDiff());
            break;
          }
        case ERROR:
          {
            mergeError(other.getError());
            break;
          }
        case RESULT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAccessTupleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getLastSeenDateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getDiffFieldBuilder().getBuilder(), extensionRegistry);
                resultCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                resultCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int resultCase_ = 0;
    private java.lang.Object result_;

    public ResultCase getResultCase() {
      return ResultCase.forNumber(resultCase_);
    }

    public Builder clearResult() {
      resultCase_ = 0;
      result_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.policysimulator.v1.ReplayDiff,
            com.google.cloud.policysimulator.v1.ReplayDiff.Builder,
            com.google.cloud.policysimulator.v1.ReplayDiffOrBuilder>
        diffBuilder_;
    /**
     *
     *
     * <pre>
     * The difference between the principal's access under the current
     * (baseline) policies and the principal's access under the proposed
     * (simulated) policies.
     *
     * This field is only included for access tuples that were successfully
     * replayed and had different results under the current policies and the
     * proposed policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
     *
     * @return Whether the diff field is set.
     */
    @java.lang.Override
    public boolean hasDiff() {
      return resultCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The difference between the principal's access under the current
     * (baseline) policies and the principal's access under the proposed
     * (simulated) policies.
     *
     * This field is only included for access tuples that were successfully
     * replayed and had different results under the current policies and the
     * proposed policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
     *
     * @return The diff.
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ReplayDiff getDiff() {
      if (diffBuilder_ == null) {
        if (resultCase_ == 5) {
          return (com.google.cloud.policysimulator.v1.ReplayDiff) result_;
        }
        return com.google.cloud.policysimulator.v1.ReplayDiff.getDefaultInstance();
      } else {
        if (resultCase_ == 5) {
          return diffBuilder_.getMessage();
        }
        return com.google.cloud.policysimulator.v1.ReplayDiff.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The difference between the principal's access under the current
     * (baseline) policies and the principal's access under the proposed
     * (simulated) policies.
     *
     * This field is only included for access tuples that were successfully
     * replayed and had different results under the current policies and the
     * proposed policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
     */
    public Builder setDiff(com.google.cloud.policysimulator.v1.ReplayDiff value) {
      if (diffBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        diffBuilder_.setMessage(value);
      }
      resultCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The difference between the principal's access under the current
     * (baseline) policies and the principal's access under the proposed
     * (simulated) policies.
     *
     * This field is only included for access tuples that were successfully
     * replayed and had different results under the current policies and the
     * proposed policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
     */
    public Builder setDiff(com.google.cloud.policysimulator.v1.ReplayDiff.Builder builderForValue) {
      if (diffBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        diffBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The difference between the principal's access under the current
     * (baseline) policies and the principal's access under the proposed
     * (simulated) policies.
     *
     * This field is only included for access tuples that were successfully
     * replayed and had different results under the current policies and the
     * proposed policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
     */
    public Builder mergeDiff(com.google.cloud.policysimulator.v1.ReplayDiff value) {
      if (diffBuilder_ == null) {
        if (resultCase_ == 5
            && result_ != com.google.cloud.policysimulator.v1.ReplayDiff.getDefaultInstance()) {
          result_ =
              com.google.cloud.policysimulator.v1.ReplayDiff.newBuilder(
                      (com.google.cloud.policysimulator.v1.ReplayDiff) result_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 5) {
          diffBuilder_.mergeFrom(value);
        } else {
          diffBuilder_.setMessage(value);
        }
      }
      resultCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The difference between the principal's access under the current
     * (baseline) policies and the principal's access under the proposed
     * (simulated) policies.
     *
     * This field is only included for access tuples that were successfully
     * replayed and had different results under the current policies and the
     * proposed policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
     */
    public Builder clearDiff() {
      if (diffBuilder_ == null) {
        if (resultCase_ == 5) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 5) {
          resultCase_ = 0;
          result_ = null;
        }
        diffBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The difference between the principal's access under the current
     * (baseline) policies and the principal's access under the proposed
     * (simulated) policies.
     *
     * This field is only included for access tuples that were successfully
     * replayed and had different results under the current policies and the
     * proposed policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
     */
    public com.google.cloud.policysimulator.v1.ReplayDiff.Builder getDiffBuilder() {
      return getDiffFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The difference between the principal's access under the current
     * (baseline) policies and the principal's access under the proposed
     * (simulated) policies.
     *
     * This field is only included for access tuples that were successfully
     * replayed and had different results under the current policies and the
     * proposed policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ReplayDiffOrBuilder getDiffOrBuilder() {
      if ((resultCase_ == 5) && (diffBuilder_ != null)) {
        return diffBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 5) {
          return (com.google.cloud.policysimulator.v1.ReplayDiff) result_;
        }
        return com.google.cloud.policysimulator.v1.ReplayDiff.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The difference between the principal's access under the current
     * (baseline) policies and the principal's access under the proposed
     * (simulated) policies.
     *
     * This field is only included for access tuples that were successfully
     * replayed and had different results under the current policies and the
     * proposed policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.policysimulator.v1.ReplayDiff,
            com.google.cloud.policysimulator.v1.ReplayDiff.Builder,
            com.google.cloud.policysimulator.v1.ReplayDiffOrBuilder>
        getDiffFieldBuilder() {
      if (diffBuilder_ == null) {
        if (!(resultCase_ == 5)) {
          result_ = com.google.cloud.policysimulator.v1.ReplayDiff.getDefaultInstance();
        }
        diffBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.policysimulator.v1.ReplayDiff,
                com.google.cloud.policysimulator.v1.ReplayDiff.Builder,
                com.google.cloud.policysimulator.v1.ReplayDiffOrBuilder>(
                (com.google.cloud.policysimulator.v1.ReplayDiff) result_,
                getParentForChildren(),
                isClean());
        result_ = null;
      }
      resultCase_ = 5;
      onChanged();
      return diffBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * The error that caused the access tuple replay to fail.
     *
     * This field is only included for access tuples that were not replayed
     * successfully.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6;</code>
     *
     * @return Whether the error field is set.
     */
    @java.lang.Override
    public boolean hasError() {
      return resultCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The error that caused the access tuple replay to fail.
     *
     * This field is only included for access tuples that were not replayed
     * successfully.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6;</code>
     *
     * @return The error.
     */
    @java.lang.Override
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        if (resultCase_ == 6) {
          return (com.google.rpc.Status) result_;
        }
        return com.google.rpc.Status.getDefaultInstance();
      } else {
        if (resultCase_ == 6) {
          return errorBuilder_.getMessage();
        }
        return com.google.rpc.Status.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The error that caused the access tuple replay to fail.
     *
     * This field is only included for access tuples that were not replayed
     * successfully.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }
      resultCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The error that caused the access tuple replay to fail.
     *
     * This field is only included for access tuples that were not replayed
     * successfully.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The error that caused the access tuple replay to fail.
     *
     * This field is only included for access tuples that were not replayed
     * successfully.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (resultCase_ == 6 && result_ != com.google.rpc.Status.getDefaultInstance()) {
          result_ =
              com.google.rpc.Status.newBuilder((com.google.rpc.Status) result_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 6) {
          errorBuilder_.mergeFrom(value);
        } else {
          errorBuilder_.setMessage(value);
        }
      }
      resultCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The error that caused the access tuple replay to fail.
     *
     * This field is only included for access tuples that were not replayed
     * successfully.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6;</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        if (resultCase_ == 6) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 6) {
          resultCase_ = 0;
          result_ = null;
        }
        errorBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The error that caused the access tuple replay to fail.
     *
     * This field is only included for access tuples that were not replayed
     * successfully.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The error that caused the access tuple replay to fail.
     *
     * This field is only included for access tuples that were not replayed
     * successfully.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if ((resultCase_ == 6) && (errorBuilder_ != null)) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 6) {
          return (com.google.rpc.Status) result_;
        }
        return com.google.rpc.Status.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The error that caused the access tuple replay to fail.
     *
     * This field is only included for access tuples that were not replayed
     * successfully.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        if (!(resultCase_ == 6)) {
          result_ = com.google.rpc.Status.getDefaultInstance();
        }
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                (com.google.rpc.Status) result_, getParentForChildren(), isClean());
        result_ = null;
      }
      resultCase_ = 6;
      onChanged();
      return errorBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the `ReplayResult`, in the following format:
     *
     * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
     * where `{resource-id}` is the ID of the project, folder, or organization
     * that owns the [Replay][google.cloud.policysimulator.v1.Replay].
     *
     * Example:
     * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the `ReplayResult`, in the following format:
     *
     * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
     * where `{resource-id}` is the ID of the project, folder, or organization
     * that owns the [Replay][google.cloud.policysimulator.v1.Replay].
     *
     * Example:
     * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the `ReplayResult`, in the following format:
     *
     * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
     * where `{resource-id}` is the ID of the project, folder, or organization
     * that owns the [Replay][google.cloud.policysimulator.v1.Replay].
     *
     * Example:
     * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the `ReplayResult`, in the following format:
     *
     * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
     * where `{resource-id}` is the ID of the project, folder, or organization
     * that owns the [Replay][google.cloud.policysimulator.v1.Replay].
     *
     * Example:
     * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the `ReplayResult`, in the following format:
     *
     * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
     * where `{resource-id}` is the ID of the project, folder, or organization
     * that owns the [Replay][google.cloud.policysimulator.v1.Replay].
     *
     * Example:
     * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
     * was included in.
     * </pre>
     *
     * <code>string parent = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
     * was included in.
     * </pre>
     *
     * <code>string parent = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
     * was included in.
     * </pre>
     *
     * <code>string parent = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
     * was included in.
     * </pre>
     *
     * <code>string parent = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
     * was included in.
     * </pre>
     *
     * <code>string parent = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.policysimulator.v1.AccessTuple accessTuple_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.policysimulator.v1.AccessTuple,
            com.google.cloud.policysimulator.v1.AccessTuple.Builder,
            com.google.cloud.policysimulator.v1.AccessTupleOrBuilder>
        accessTupleBuilder_;
    /**
     *
     *
     * <pre>
     * The access tuple that was replayed. This field includes information about
     * the principal, resource, and permission that were involved in the access
     * attempt.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
     *
     * @return Whether the accessTuple field is set.
     */
    public boolean hasAccessTuple() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The access tuple that was replayed. This field includes information about
     * the principal, resource, and permission that were involved in the access
     * attempt.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
     *
     * @return The accessTuple.
     */
    public com.google.cloud.policysimulator.v1.AccessTuple getAccessTuple() {
      if (accessTupleBuilder_ == null) {
        return accessTuple_ == null
            ? com.google.cloud.policysimulator.v1.AccessTuple.getDefaultInstance()
            : accessTuple_;
      } else {
        return accessTupleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The access tuple that was replayed. This field includes information about
     * the principal, resource, and permission that were involved in the access
     * attempt.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
     */
    public Builder setAccessTuple(com.google.cloud.policysimulator.v1.AccessTuple value) {
      if (accessTupleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        accessTuple_ = value;
      } else {
        accessTupleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access tuple that was replayed. This field includes information about
     * the principal, resource, and permission that were involved in the access
     * attempt.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
     */
    public Builder setAccessTuple(
        com.google.cloud.policysimulator.v1.AccessTuple.Builder builderForValue) {
      if (accessTupleBuilder_ == null) {
        accessTuple_ = builderForValue.build();
      } else {
        accessTupleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access tuple that was replayed. This field includes information about
     * the principal, resource, and permission that were involved in the access
     * attempt.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
     */
    public Builder mergeAccessTuple(com.google.cloud.policysimulator.v1.AccessTuple value) {
      if (accessTupleBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && accessTuple_ != null
            && accessTuple_
                != com.google.cloud.policysimulator.v1.AccessTuple.getDefaultInstance()) {
          getAccessTupleBuilder().mergeFrom(value);
        } else {
          accessTuple_ = value;
        }
      } else {
        accessTupleBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access tuple that was replayed. This field includes information about
     * the principal, resource, and permission that were involved in the access
     * attempt.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
     */
    public Builder clearAccessTuple() {
      bitField0_ = (bitField0_ & ~0x00000010);
      accessTuple_ = null;
      if (accessTupleBuilder_ != null) {
        accessTupleBuilder_.dispose();
        accessTupleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The access tuple that was replayed. This field includes information about
     * the principal, resource, and permission that were involved in the access
     * attempt.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
     */
    public com.google.cloud.policysimulator.v1.AccessTuple.Builder getAccessTupleBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getAccessTupleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The access tuple that was replayed. This field includes information about
     * the principal, resource, and permission that were involved in the access
     * attempt.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
     */
    public com.google.cloud.policysimulator.v1.AccessTupleOrBuilder getAccessTupleOrBuilder() {
      if (accessTupleBuilder_ != null) {
        return accessTupleBuilder_.getMessageOrBuilder();
      } else {
        return accessTuple_ == null
            ? com.google.cloud.policysimulator.v1.AccessTuple.getDefaultInstance()
            : accessTuple_;
      }
    }
    /**
     *
     *
     * <pre>
     * The access tuple that was replayed. This field includes information about
     * the principal, resource, and permission that were involved in the access
     * attempt.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.policysimulator.v1.AccessTuple,
            com.google.cloud.policysimulator.v1.AccessTuple.Builder,
            com.google.cloud.policysimulator.v1.AccessTupleOrBuilder>
        getAccessTupleFieldBuilder() {
      if (accessTupleBuilder_ == null) {
        accessTupleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.policysimulator.v1.AccessTuple,
                com.google.cloud.policysimulator.v1.AccessTuple.Builder,
                com.google.cloud.policysimulator.v1.AccessTupleOrBuilder>(
                getAccessTuple(), getParentForChildren(), isClean());
        accessTuple_ = null;
      }
      return accessTupleBuilder_;
    }

    private com.google.type.Date lastSeenDate_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        lastSeenDateBuilder_;
    /**
     *
     *
     * <pre>
     * The latest date this access tuple was seen in the logs.
     * </pre>
     *
     * <code>.google.type.Date last_seen_date = 4;</code>
     *
     * @return Whether the lastSeenDate field is set.
     */
    public boolean hasLastSeenDate() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The latest date this access tuple was seen in the logs.
     * </pre>
     *
     * <code>.google.type.Date last_seen_date = 4;</code>
     *
     * @return The lastSeenDate.
     */
    public com.google.type.Date getLastSeenDate() {
      if (lastSeenDateBuilder_ == null) {
        return lastSeenDate_ == null ? com.google.type.Date.getDefaultInstance() : lastSeenDate_;
      } else {
        return lastSeenDateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The latest date this access tuple was seen in the logs.
     * </pre>
     *
     * <code>.google.type.Date last_seen_date = 4;</code>
     */
    public Builder setLastSeenDate(com.google.type.Date value) {
      if (lastSeenDateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastSeenDate_ = value;
      } else {
        lastSeenDateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest date this access tuple was seen in the logs.
     * </pre>
     *
     * <code>.google.type.Date last_seen_date = 4;</code>
     */
    public Builder setLastSeenDate(com.google.type.Date.Builder builderForValue) {
      if (lastSeenDateBuilder_ == null) {
        lastSeenDate_ = builderForValue.build();
      } else {
        lastSeenDateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest date this access tuple was seen in the logs.
     * </pre>
     *
     * <code>.google.type.Date last_seen_date = 4;</code>
     */
    public Builder mergeLastSeenDate(com.google.type.Date value) {
      if (lastSeenDateBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && lastSeenDate_ != null
            && lastSeenDate_ != com.google.type.Date.getDefaultInstance()) {
          getLastSeenDateBuilder().mergeFrom(value);
        } else {
          lastSeenDate_ = value;
        }
      } else {
        lastSeenDateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest date this access tuple was seen in the logs.
     * </pre>
     *
     * <code>.google.type.Date last_seen_date = 4;</code>
     */
    public Builder clearLastSeenDate() {
      bitField0_ = (bitField0_ & ~0x00000020);
      lastSeenDate_ = null;
      if (lastSeenDateBuilder_ != null) {
        lastSeenDateBuilder_.dispose();
        lastSeenDateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest date this access tuple was seen in the logs.
     * </pre>
     *
     * <code>.google.type.Date last_seen_date = 4;</code>
     */
    public com.google.type.Date.Builder getLastSeenDateBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getLastSeenDateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The latest date this access tuple was seen in the logs.
     * </pre>
     *
     * <code>.google.type.Date last_seen_date = 4;</code>
     */
    public com.google.type.DateOrBuilder getLastSeenDateOrBuilder() {
      if (lastSeenDateBuilder_ != null) {
        return lastSeenDateBuilder_.getMessageOrBuilder();
      } else {
        return lastSeenDate_ == null ? com.google.type.Date.getDefaultInstance() : lastSeenDate_;
      }
    }
    /**
     *
     *
     * <pre>
     * The latest date this access tuple was seen in the logs.
     * </pre>
     *
     * <code>.google.type.Date last_seen_date = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        getLastSeenDateFieldBuilder() {
      if (lastSeenDateBuilder_ == null) {
        lastSeenDateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>(
                getLastSeenDate(), getParentForChildren(), isClean());
        lastSeenDate_ = null;
      }
      return lastSeenDateBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.policysimulator.v1.ReplayResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.policysimulator.v1.ReplayResult)
  private static final com.google.cloud.policysimulator.v1.ReplayResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.policysimulator.v1.ReplayResult();
  }

  public static com.google.cloud.policysimulator.v1.ReplayResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReplayResult> PARSER =
      new com.google.protobuf.AbstractParser<ReplayResult>() {
        @java.lang.Override
        public ReplayResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReplayResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReplayResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ReplayResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
