/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/simulator.proto

package com.google.cloud.policysimulator.v1;

/**
 *
 *
 * <pre>
 * Details about how a set of policies, listed in
 * [ExplainedPolicy][google.cloud.policysimulator.v1.ExplainedPolicy], resulted
 * in a certain [AccessState][google.cloud.policysimulator.v1.AccessState] when
 * replaying an access tuple.
 * </pre>
 *
 * Protobuf type {@code google.cloud.policysimulator.v1.ExplainedAccess}
 */
public final class ExplainedAccess extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.policysimulator.v1.ExplainedAccess)
    ExplainedAccessOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExplainedAccess.newBuilder() to construct.
  private ExplainedAccess(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExplainedAccess() {
    accessState_ = 0;
    policies_ = java.util.Collections.emptyList();
    errors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExplainedAccess();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.policysimulator.v1.SimulatorProto
        .internal_static_google_cloud_policysimulator_v1_ExplainedAccess_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.policysimulator.v1.SimulatorProto
        .internal_static_google_cloud_policysimulator_v1_ExplainedAccess_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.policysimulator.v1.ExplainedAccess.class,
            com.google.cloud.policysimulator.v1.ExplainedAccess.Builder.class);
  }

  public static final int ACCESS_STATE_FIELD_NUMBER = 1;
  private int accessState_ = 0;
  /**
   *
   *
   * <pre>
   * Whether the principal in the access tuple has permission to access the
   * resource in the access tuple under the given policies.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessState access_state = 1;</code>
   *
   * @return The enum numeric value on the wire for accessState.
   */
  @java.lang.Override
  public int getAccessStateValue() {
    return accessState_;
  }
  /**
   *
   *
   * <pre>
   * Whether the principal in the access tuple has permission to access the
   * resource in the access tuple under the given policies.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessState access_state = 1;</code>
   *
   * @return The accessState.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.AccessState getAccessState() {
    com.google.cloud.policysimulator.v1.AccessState result =
        com.google.cloud.policysimulator.v1.AccessState.forNumber(accessState_);
    return result == null ? com.google.cloud.policysimulator.v1.AccessState.UNRECOGNIZED : result;
  }

  public static final int POLICIES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.policysimulator.v1.ExplainedPolicy> policies_;
  /**
   *
   *
   * <pre>
   * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
   * `UNKNOWN`, this field contains the policies that led to that result.
   *
   * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
   * omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.policysimulator.v1.ExplainedPolicy> getPoliciesList() {
    return policies_;
  }
  /**
   *
   *
   * <pre>
   * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
   * `UNKNOWN`, this field contains the policies that led to that result.
   *
   * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
   * omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.policysimulator.v1.ExplainedPolicyOrBuilder>
      getPoliciesOrBuilderList() {
    return policies_;
  }
  /**
   *
   *
   * <pre>
   * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
   * `UNKNOWN`, this field contains the policies that led to that result.
   *
   * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
   * omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
   */
  @java.lang.Override
  public int getPoliciesCount() {
    return policies_.size();
  }
  /**
   *
   *
   * <pre>
   * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
   * `UNKNOWN`, this field contains the policies that led to that result.
   *
   * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
   * omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ExplainedPolicy getPolicies(int index) {
    return policies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
   * `UNKNOWN`, this field contains the policies that led to that result.
   *
   * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
   * omitted.
   * </pre>
   *
   * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ExplainedPolicyOrBuilder getPoliciesOrBuilder(
      int index) {
    return policies_.get(index);
  }

  public static final int ERRORS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.Status> errors_;
  /**
   *
   *
   * <pre>
   * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
   * `UNKNOWN`, this field contains a list of errors explaining why the result
   * is `UNKNOWN`.
   *
   * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
   * omitted.
   * </pre>
   *
   * <code>repeated .google.rpc.Status errors = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
   * `UNKNOWN`, this field contains a list of errors explaining why the result
   * is `UNKNOWN`.
   *
   * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
   * omitted.
   * </pre>
   *
   * <code>repeated .google.rpc.Status errors = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder> getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
   * `UNKNOWN`, this field contains a list of errors explaining why the result
   * is `UNKNOWN`.
   *
   * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
   * omitted.
   * </pre>
   *
   * <code>repeated .google.rpc.Status errors = 3;</code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
   * `UNKNOWN`, this field contains a list of errors explaining why the result
   * is `UNKNOWN`.
   *
   * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
   * omitted.
   * </pre>
   *
   * <code>repeated .google.rpc.Status errors = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.Status getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
   * `UNKNOWN`, this field contains a list of errors explaining why the result
   * is `UNKNOWN`.
   *
   * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
   * omitted.
   * </pre>
   *
   * <code>repeated .google.rpc.Status errors = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorsOrBuilder(int index) {
    return errors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (accessState_
        != com.google.cloud.policysimulator.v1.AccessState.ACCESS_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, accessState_);
    }
    for (int i = 0; i < policies_.size(); i++) {
      output.writeMessage(2, policies_.get(i));
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(3, errors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (accessState_
        != com.google.cloud.policysimulator.v1.AccessState.ACCESS_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, accessState_);
    }
    for (int i = 0; i < policies_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, policies_.get(i));
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, errors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.policysimulator.v1.ExplainedAccess)) {
      return super.equals(obj);
    }
    com.google.cloud.policysimulator.v1.ExplainedAccess other =
        (com.google.cloud.policysimulator.v1.ExplainedAccess) obj;

    if (accessState_ != other.accessState_) return false;
    if (!getPoliciesList().equals(other.getPoliciesList())) return false;
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ACCESS_STATE_FIELD_NUMBER;
    hash = (53 * hash) + accessState_;
    if (getPoliciesCount() > 0) {
      hash = (37 * hash) + POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + getPoliciesList().hashCode();
    }
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.policysimulator.v1.ExplainedAccess parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedAccess parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedAccess parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedAccess parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedAccess parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedAccess parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedAccess parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedAccess parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedAccess parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedAccess parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedAccess parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.ExplainedAccess parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.policysimulator.v1.ExplainedAccess prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details about how a set of policies, listed in
   * [ExplainedPolicy][google.cloud.policysimulator.v1.ExplainedPolicy], resulted
   * in a certain [AccessState][google.cloud.policysimulator.v1.AccessState] when
   * replaying an access tuple.
   * </pre>
   *
   * Protobuf type {@code google.cloud.policysimulator.v1.ExplainedAccess}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.policysimulator.v1.ExplainedAccess)
      com.google.cloud.policysimulator.v1.ExplainedAccessOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_ExplainedAccess_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_ExplainedAccess_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.policysimulator.v1.ExplainedAccess.class,
              com.google.cloud.policysimulator.v1.ExplainedAccess.Builder.class);
    }

    // Construct using com.google.cloud.policysimulator.v1.ExplainedAccess.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      accessState_ = 0;
      if (policiesBuilder_ == null) {
        policies_ = java.util.Collections.emptyList();
      } else {
        policies_ = null;
        policiesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_ExplainedAccess_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ExplainedAccess getDefaultInstanceForType() {
      return com.google.cloud.policysimulator.v1.ExplainedAccess.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ExplainedAccess build() {
      com.google.cloud.policysimulator.v1.ExplainedAccess result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.ExplainedAccess buildPartial() {
      com.google.cloud.policysimulator.v1.ExplainedAccess result =
          new com.google.cloud.policysimulator.v1.ExplainedAccess(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.policysimulator.v1.ExplainedAccess result) {
      if (policiesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          policies_ = java.util.Collections.unmodifiableList(policies_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.policies_ = policies_;
      } else {
        result.policies_ = policiesBuilder_.build();
      }
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.policysimulator.v1.ExplainedAccess result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.accessState_ = accessState_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.policysimulator.v1.ExplainedAccess) {
        return mergeFrom((com.google.cloud.policysimulator.v1.ExplainedAccess) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.policysimulator.v1.ExplainedAccess other) {
      if (other == com.google.cloud.policysimulator.v1.ExplainedAccess.getDefaultInstance())
        return this;
      if (other.accessState_ != 0) {
        setAccessStateValue(other.getAccessStateValue());
      }
      if (policiesBuilder_ == null) {
        if (!other.policies_.isEmpty()) {
          if (policies_.isEmpty()) {
            policies_ = other.policies_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePoliciesIsMutable();
            policies_.addAll(other.policies_);
          }
          onChanged();
        }
      } else {
        if (!other.policies_.isEmpty()) {
          if (policiesBuilder_.isEmpty()) {
            policiesBuilder_.dispose();
            policiesBuilder_ = null;
            policies_ = other.policies_;
            bitField0_ = (bitField0_ & ~0x00000002);
            policiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPoliciesFieldBuilder()
                    : null;
          } else {
            policiesBuilder_.addAllMessages(other.policies_);
          }
        }
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000004);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                accessState_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                com.google.cloud.policysimulator.v1.ExplainedPolicy m =
                    input.readMessage(
                        com.google.cloud.policysimulator.v1.ExplainedPolicy.parser(),
                        extensionRegistry);
                if (policiesBuilder_ == null) {
                  ensurePoliciesIsMutable();
                  policies_.add(m);
                } else {
                  policiesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int accessState_ = 0;
    /**
     *
     *
     * <pre>
     * Whether the principal in the access tuple has permission to access the
     * resource in the access tuple under the given policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessState access_state = 1;</code>
     *
     * @return The enum numeric value on the wire for accessState.
     */
    @java.lang.Override
    public int getAccessStateValue() {
      return accessState_;
    }
    /**
     *
     *
     * <pre>
     * Whether the principal in the access tuple has permission to access the
     * resource in the access tuple under the given policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessState access_state = 1;</code>
     *
     * @param value The enum numeric value on the wire for accessState to set.
     * @return This builder for chaining.
     */
    public Builder setAccessStateValue(int value) {
      accessState_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the principal in the access tuple has permission to access the
     * resource in the access tuple under the given policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessState access_state = 1;</code>
     *
     * @return The accessState.
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.AccessState getAccessState() {
      com.google.cloud.policysimulator.v1.AccessState result =
          com.google.cloud.policysimulator.v1.AccessState.forNumber(accessState_);
      return result == null ? com.google.cloud.policysimulator.v1.AccessState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Whether the principal in the access tuple has permission to access the
     * resource in the access tuple under the given policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessState access_state = 1;</code>
     *
     * @param value The accessState to set.
     * @return This builder for chaining.
     */
    public Builder setAccessState(com.google.cloud.policysimulator.v1.AccessState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      accessState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the principal in the access tuple has permission to access the
     * resource in the access tuple under the given policies.
     * </pre>
     *
     * <code>.google.cloud.policysimulator.v1.AccessState access_state = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAccessState() {
      bitField0_ = (bitField0_ & ~0x00000001);
      accessState_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.policysimulator.v1.ExplainedPolicy> policies_ =
        java.util.Collections.emptyList();

    private void ensurePoliciesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        policies_ =
            new java.util.ArrayList<com.google.cloud.policysimulator.v1.ExplainedPolicy>(policies_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.policysimulator.v1.ExplainedPolicy,
            com.google.cloud.policysimulator.v1.ExplainedPolicy.Builder,
            com.google.cloud.policysimulator.v1.ExplainedPolicyOrBuilder>
        policiesBuilder_;

    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public java.util.List<com.google.cloud.policysimulator.v1.ExplainedPolicy> getPoliciesList() {
      if (policiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(policies_);
      } else {
        return policiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public int getPoliciesCount() {
      if (policiesBuilder_ == null) {
        return policies_.size();
      } else {
        return policiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public com.google.cloud.policysimulator.v1.ExplainedPolicy getPolicies(int index) {
      if (policiesBuilder_ == null) {
        return policies_.get(index);
      } else {
        return policiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public Builder setPolicies(
        int index, com.google.cloud.policysimulator.v1.ExplainedPolicy value) {
      if (policiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePoliciesIsMutable();
        policies_.set(index, value);
        onChanged();
      } else {
        policiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public Builder setPolicies(
        int index, com.google.cloud.policysimulator.v1.ExplainedPolicy.Builder builderForValue) {
      if (policiesBuilder_ == null) {
        ensurePoliciesIsMutable();
        policies_.set(index, builderForValue.build());
        onChanged();
      } else {
        policiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public Builder addPolicies(com.google.cloud.policysimulator.v1.ExplainedPolicy value) {
      if (policiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePoliciesIsMutable();
        policies_.add(value);
        onChanged();
      } else {
        policiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public Builder addPolicies(
        int index, com.google.cloud.policysimulator.v1.ExplainedPolicy value) {
      if (policiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePoliciesIsMutable();
        policies_.add(index, value);
        onChanged();
      } else {
        policiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public Builder addPolicies(
        com.google.cloud.policysimulator.v1.ExplainedPolicy.Builder builderForValue) {
      if (policiesBuilder_ == null) {
        ensurePoliciesIsMutable();
        policies_.add(builderForValue.build());
        onChanged();
      } else {
        policiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public Builder addPolicies(
        int index, com.google.cloud.policysimulator.v1.ExplainedPolicy.Builder builderForValue) {
      if (policiesBuilder_ == null) {
        ensurePoliciesIsMutable();
        policies_.add(index, builderForValue.build());
        onChanged();
      } else {
        policiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public Builder addAllPolicies(
        java.lang.Iterable<? extends com.google.cloud.policysimulator.v1.ExplainedPolicy> values) {
      if (policiesBuilder_ == null) {
        ensurePoliciesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, policies_);
        onChanged();
      } else {
        policiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public Builder clearPolicies() {
      if (policiesBuilder_ == null) {
        policies_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        policiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public Builder removePolicies(int index) {
      if (policiesBuilder_ == null) {
        ensurePoliciesIsMutable();
        policies_.remove(index);
        onChanged();
      } else {
        policiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public com.google.cloud.policysimulator.v1.ExplainedPolicy.Builder getPoliciesBuilder(
        int index) {
      return getPoliciesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public com.google.cloud.policysimulator.v1.ExplainedPolicyOrBuilder getPoliciesOrBuilder(
        int index) {
      if (policiesBuilder_ == null) {
        return policies_.get(index);
      } else {
        return policiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.policysimulator.v1.ExplainedPolicyOrBuilder>
        getPoliciesOrBuilderList() {
      if (policiesBuilder_ != null) {
        return policiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(policies_);
      }
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public com.google.cloud.policysimulator.v1.ExplainedPolicy.Builder addPoliciesBuilder() {
      return getPoliciesFieldBuilder()
          .addBuilder(com.google.cloud.policysimulator.v1.ExplainedPolicy.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public com.google.cloud.policysimulator.v1.ExplainedPolicy.Builder addPoliciesBuilder(
        int index) {
      return getPoliciesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.policysimulator.v1.ExplainedPolicy.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains the policies that led to that result.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.cloud.policysimulator.v1.ExplainedPolicy policies = 2;</code>
     */
    public java.util.List<com.google.cloud.policysimulator.v1.ExplainedPolicy.Builder>
        getPoliciesBuilderList() {
      return getPoliciesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.policysimulator.v1.ExplainedPolicy,
            com.google.cloud.policysimulator.v1.ExplainedPolicy.Builder,
            com.google.cloud.policysimulator.v1.ExplainedPolicyOrBuilder>
        getPoliciesFieldBuilder() {
      if (policiesBuilder_ == null) {
        policiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.policysimulator.v1.ExplainedPolicy,
                com.google.cloud.policysimulator.v1.ExplainedPolicy.Builder,
                com.google.cloud.policysimulator.v1.ExplainedPolicyOrBuilder>(
                policies_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        policies_ = null;
      }
      return policiesBuilder_;
    }

    private java.util.List<com.google.rpc.Status> errors_ = java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        errors_ = new java.util.ArrayList<com.google.rpc.Status>(errors_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public java.util.List<com.google.rpc.Status> getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public com.google.rpc.Status getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public Builder setErrors(int index, com.google.rpc.Status value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public Builder setErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public Builder addErrors(com.google.rpc.Status value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public Builder addErrors(int index, com.google.rpc.Status value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public Builder addErrors(com.google.rpc.Status.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public Builder addErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public Builder addAllErrors(java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public com.google.rpc.Status.Builder getErrorsBuilder(int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorsOrBuilder(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder> getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public com.google.rpc.Status.Builder addErrorsBuilder() {
      return getErrorsFieldBuilder().addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public com.google.rpc.Status.Builder addErrorsBuilder(int index) {
      return getErrorsFieldBuilder().addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If the [AccessState][google.cloud.policysimulator.v1.AccessState] is
     * `UNKNOWN`, this field contains a list of errors explaining why the result
     * is `UNKNOWN`.
     *
     * If the `AccessState` is `GRANTED` or `NOT_GRANTED`, this field is
     * omitted.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 3;</code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                errors_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.policysimulator.v1.ExplainedAccess)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.policysimulator.v1.ExplainedAccess)
  private static final com.google.cloud.policysimulator.v1.ExplainedAccess DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.policysimulator.v1.ExplainedAccess();
  }

  public static com.google.cloud.policysimulator.v1.ExplainedAccess getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExplainedAccess> PARSER =
      new com.google.protobuf.AbstractParser<ExplainedAccess>() {
        @java.lang.Override
        public ExplainedAccess parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExplainedAccess> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExplainedAccess> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ExplainedAccess getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
