/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/simulator.proto

package com.google.cloud.policysimulator.v1;

/**
 *
 *
 * <pre>
 * A resource describing a `Replay`, or simulation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.policysimulator.v1.Replay}
 */
public final class Replay extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.policysimulator.v1.Replay)
    ReplayOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Replay.newBuilder() to construct.
  private Replay(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Replay() {
    name_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Replay();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.policysimulator.v1.SimulatorProto
        .internal_static_google_cloud_policysimulator_v1_Replay_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.policysimulator.v1.SimulatorProto
        .internal_static_google_cloud_policysimulator_v1_Replay_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.policysimulator.v1.Replay.class,
            com.google.cloud.policysimulator.v1.Replay.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The current state of the [Replay][google.cloud.policysimulator.v1.Replay].
   * </pre>
   *
   * Protobuf enum {@code google.cloud.policysimulator.v1.Replay.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The `Replay` has not started yet.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The `Replay` is currently running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The `Replay` has successfully completed.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    SUCCEEDED(3),
    /**
     *
     *
     * <pre>
     * The `Replay` has finished with an error.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    FAILED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The `Replay` has not started yet.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The `Replay` is currently running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The `Replay` has successfully completed.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    public static final int SUCCEEDED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The `Replay` has finished with an error.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    public static final int FAILED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return RUNNING;
        case 3:
          return SUCCEEDED;
        case 4:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.Replay.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.policysimulator.v1.Replay.State)
  }

  public interface ResultsSummaryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.policysimulator.v1.Replay.ResultsSummary)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The total number of log entries replayed.
     * </pre>
     *
     * <code>int32 log_count = 1;</code>
     *
     * @return The logCount.
     */
    int getLogCount();

    /**
     *
     *
     * <pre>
     * The number of replayed log entries with no difference between
     * baseline and simulated policies.
     * </pre>
     *
     * <code>int32 unchanged_count = 2;</code>
     *
     * @return The unchangedCount.
     */
    int getUnchangedCount();

    /**
     *
     *
     * <pre>
     * The number of replayed log entries with a difference between baseline and
     * simulated policies.
     * </pre>
     *
     * <code>int32 difference_count = 3;</code>
     *
     * @return The differenceCount.
     */
    int getDifferenceCount();

    /**
     *
     *
     * <pre>
     * The number of log entries that could not be replayed.
     * </pre>
     *
     * <code>int32 error_count = 4;</code>
     *
     * @return The errorCount.
     */
    int getErrorCount();

    /**
     *
     *
     * <pre>
     * The date of the oldest log entry replayed.
     * </pre>
     *
     * <code>.google.type.Date oldest_date = 5;</code>
     *
     * @return Whether the oldestDate field is set.
     */
    boolean hasOldestDate();
    /**
     *
     *
     * <pre>
     * The date of the oldest log entry replayed.
     * </pre>
     *
     * <code>.google.type.Date oldest_date = 5;</code>
     *
     * @return The oldestDate.
     */
    com.google.type.Date getOldestDate();
    /**
     *
     *
     * <pre>
     * The date of the oldest log entry replayed.
     * </pre>
     *
     * <code>.google.type.Date oldest_date = 5;</code>
     */
    com.google.type.DateOrBuilder getOldestDateOrBuilder();

    /**
     *
     *
     * <pre>
     * The date of the newest log entry replayed.
     * </pre>
     *
     * <code>.google.type.Date newest_date = 6;</code>
     *
     * @return Whether the newestDate field is set.
     */
    boolean hasNewestDate();
    /**
     *
     *
     * <pre>
     * The date of the newest log entry replayed.
     * </pre>
     *
     * <code>.google.type.Date newest_date = 6;</code>
     *
     * @return The newestDate.
     */
    com.google.type.Date getNewestDate();
    /**
     *
     *
     * <pre>
     * The date of the newest log entry replayed.
     * </pre>
     *
     * <code>.google.type.Date newest_date = 6;</code>
     */
    com.google.type.DateOrBuilder getNewestDateOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Summary statistics about the replayed log entries.
   * </pre>
   *
   * Protobuf type {@code google.cloud.policysimulator.v1.Replay.ResultsSummary}
   */
  public static final class ResultsSummary extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.policysimulator.v1.Replay.ResultsSummary)
      ResultsSummaryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ResultsSummary.newBuilder() to construct.
    private ResultsSummary(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ResultsSummary() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ResultsSummary();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_Replay_ResultsSummary_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_Replay_ResultsSummary_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.policysimulator.v1.Replay.ResultsSummary.class,
              com.google.cloud.policysimulator.v1.Replay.ResultsSummary.Builder.class);
    }

    public static final int LOG_COUNT_FIELD_NUMBER = 1;
    private int logCount_ = 0;
    /**
     *
     *
     * <pre>
     * The total number of log entries replayed.
     * </pre>
     *
     * <code>int32 log_count = 1;</code>
     *
     * @return The logCount.
     */
    @java.lang.Override
    public int getLogCount() {
      return logCount_;
    }

    public static final int UNCHANGED_COUNT_FIELD_NUMBER = 2;
    private int unchangedCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of replayed log entries with no difference between
     * baseline and simulated policies.
     * </pre>
     *
     * <code>int32 unchanged_count = 2;</code>
     *
     * @return The unchangedCount.
     */
    @java.lang.Override
    public int getUnchangedCount() {
      return unchangedCount_;
    }

    public static final int DIFFERENCE_COUNT_FIELD_NUMBER = 3;
    private int differenceCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of replayed log entries with a difference between baseline and
     * simulated policies.
     * </pre>
     *
     * <code>int32 difference_count = 3;</code>
     *
     * @return The differenceCount.
     */
    @java.lang.Override
    public int getDifferenceCount() {
      return differenceCount_;
    }

    public static final int ERROR_COUNT_FIELD_NUMBER = 4;
    private int errorCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of log entries that could not be replayed.
     * </pre>
     *
     * <code>int32 error_count = 4;</code>
     *
     * @return The errorCount.
     */
    @java.lang.Override
    public int getErrorCount() {
      return errorCount_;
    }

    public static final int OLDEST_DATE_FIELD_NUMBER = 5;
    private com.google.type.Date oldestDate_;
    /**
     *
     *
     * <pre>
     * The date of the oldest log entry replayed.
     * </pre>
     *
     * <code>.google.type.Date oldest_date = 5;</code>
     *
     * @return Whether the oldestDate field is set.
     */
    @java.lang.Override
    public boolean hasOldestDate() {
      return oldestDate_ != null;
    }
    /**
     *
     *
     * <pre>
     * The date of the oldest log entry replayed.
     * </pre>
     *
     * <code>.google.type.Date oldest_date = 5;</code>
     *
     * @return The oldestDate.
     */
    @java.lang.Override
    public com.google.type.Date getOldestDate() {
      return oldestDate_ == null ? com.google.type.Date.getDefaultInstance() : oldestDate_;
    }
    /**
     *
     *
     * <pre>
     * The date of the oldest log entry replayed.
     * </pre>
     *
     * <code>.google.type.Date oldest_date = 5;</code>
     */
    @java.lang.Override
    public com.google.type.DateOrBuilder getOldestDateOrBuilder() {
      return oldestDate_ == null ? com.google.type.Date.getDefaultInstance() : oldestDate_;
    }

    public static final int NEWEST_DATE_FIELD_NUMBER = 6;
    private com.google.type.Date newestDate_;
    /**
     *
     *
     * <pre>
     * The date of the newest log entry replayed.
     * </pre>
     *
     * <code>.google.type.Date newest_date = 6;</code>
     *
     * @return Whether the newestDate field is set.
     */
    @java.lang.Override
    public boolean hasNewestDate() {
      return newestDate_ != null;
    }
    /**
     *
     *
     * <pre>
     * The date of the newest log entry replayed.
     * </pre>
     *
     * <code>.google.type.Date newest_date = 6;</code>
     *
     * @return The newestDate.
     */
    @java.lang.Override
    public com.google.type.Date getNewestDate() {
      return newestDate_ == null ? com.google.type.Date.getDefaultInstance() : newestDate_;
    }
    /**
     *
     *
     * <pre>
     * The date of the newest log entry replayed.
     * </pre>
     *
     * <code>.google.type.Date newest_date = 6;</code>
     */
    @java.lang.Override
    public com.google.type.DateOrBuilder getNewestDateOrBuilder() {
      return newestDate_ == null ? com.google.type.Date.getDefaultInstance() : newestDate_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (logCount_ != 0) {
        output.writeInt32(1, logCount_);
      }
      if (unchangedCount_ != 0) {
        output.writeInt32(2, unchangedCount_);
      }
      if (differenceCount_ != 0) {
        output.writeInt32(3, differenceCount_);
      }
      if (errorCount_ != 0) {
        output.writeInt32(4, errorCount_);
      }
      if (oldestDate_ != null) {
        output.writeMessage(5, getOldestDate());
      }
      if (newestDate_ != null) {
        output.writeMessage(6, getNewestDate());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (logCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, logCount_);
      }
      if (unchangedCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, unchangedCount_);
      }
      if (differenceCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, differenceCount_);
      }
      if (errorCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, errorCount_);
      }
      if (oldestDate_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getOldestDate());
      }
      if (newestDate_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getNewestDate());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.policysimulator.v1.Replay.ResultsSummary)) {
        return super.equals(obj);
      }
      com.google.cloud.policysimulator.v1.Replay.ResultsSummary other =
          (com.google.cloud.policysimulator.v1.Replay.ResultsSummary) obj;

      if (getLogCount() != other.getLogCount()) return false;
      if (getUnchangedCount() != other.getUnchangedCount()) return false;
      if (getDifferenceCount() != other.getDifferenceCount()) return false;
      if (getErrorCount() != other.getErrorCount()) return false;
      if (hasOldestDate() != other.hasOldestDate()) return false;
      if (hasOldestDate()) {
        if (!getOldestDate().equals(other.getOldestDate())) return false;
      }
      if (hasNewestDate() != other.hasNewestDate()) return false;
      if (hasNewestDate()) {
        if (!getNewestDate().equals(other.getNewestDate())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOG_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getLogCount();
      hash = (37 * hash) + UNCHANGED_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getUnchangedCount();
      hash = (37 * hash) + DIFFERENCE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getDifferenceCount();
      hash = (37 * hash) + ERROR_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getErrorCount();
      if (hasOldestDate()) {
        hash = (37 * hash) + OLDEST_DATE_FIELD_NUMBER;
        hash = (53 * hash) + getOldestDate().hashCode();
      }
      if (hasNewestDate()) {
        hash = (37 * hash) + NEWEST_DATE_FIELD_NUMBER;
        hash = (53 * hash) + getNewestDate().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.policysimulator.v1.Replay.ResultsSummary parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.policysimulator.v1.Replay.ResultsSummary parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.policysimulator.v1.Replay.ResultsSummary parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.policysimulator.v1.Replay.ResultsSummary parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.policysimulator.v1.Replay.ResultsSummary parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.policysimulator.v1.Replay.ResultsSummary parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.policysimulator.v1.Replay.ResultsSummary parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.policysimulator.v1.Replay.ResultsSummary parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.policysimulator.v1.Replay.ResultsSummary parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.policysimulator.v1.Replay.ResultsSummary parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.policysimulator.v1.Replay.ResultsSummary parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.policysimulator.v1.Replay.ResultsSummary parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.policysimulator.v1.Replay.ResultsSummary prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Summary statistics about the replayed log entries.
     * </pre>
     *
     * Protobuf type {@code google.cloud.policysimulator.v1.Replay.ResultsSummary}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.policysimulator.v1.Replay.ResultsSummary)
        com.google.cloud.policysimulator.v1.Replay.ResultsSummaryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.policysimulator.v1.SimulatorProto
            .internal_static_google_cloud_policysimulator_v1_Replay_ResultsSummary_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.policysimulator.v1.SimulatorProto
            .internal_static_google_cloud_policysimulator_v1_Replay_ResultsSummary_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.policysimulator.v1.Replay.ResultsSummary.class,
                com.google.cloud.policysimulator.v1.Replay.ResultsSummary.Builder.class);
      }

      // Construct using com.google.cloud.policysimulator.v1.Replay.ResultsSummary.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        logCount_ = 0;
        unchangedCount_ = 0;
        differenceCount_ = 0;
        errorCount_ = 0;
        oldestDate_ = null;
        if (oldestDateBuilder_ != null) {
          oldestDateBuilder_.dispose();
          oldestDateBuilder_ = null;
        }
        newestDate_ = null;
        if (newestDateBuilder_ != null) {
          newestDateBuilder_.dispose();
          newestDateBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.policysimulator.v1.SimulatorProto
            .internal_static_google_cloud_policysimulator_v1_Replay_ResultsSummary_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.policysimulator.v1.Replay.ResultsSummary getDefaultInstanceForType() {
        return com.google.cloud.policysimulator.v1.Replay.ResultsSummary.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.policysimulator.v1.Replay.ResultsSummary build() {
        com.google.cloud.policysimulator.v1.Replay.ResultsSummary result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.policysimulator.v1.Replay.ResultsSummary buildPartial() {
        com.google.cloud.policysimulator.v1.Replay.ResultsSummary result =
            new com.google.cloud.policysimulator.v1.Replay.ResultsSummary(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.policysimulator.v1.Replay.ResultsSummary result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.logCount_ = logCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.unchangedCount_ = unchangedCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.differenceCount_ = differenceCount_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.errorCount_ = errorCount_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.oldestDate_ =
              oldestDateBuilder_ == null ? oldestDate_ : oldestDateBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.newestDate_ =
              newestDateBuilder_ == null ? newestDate_ : newestDateBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.policysimulator.v1.Replay.ResultsSummary) {
          return mergeFrom((com.google.cloud.policysimulator.v1.Replay.ResultsSummary) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.policysimulator.v1.Replay.ResultsSummary other) {
        if (other == com.google.cloud.policysimulator.v1.Replay.ResultsSummary.getDefaultInstance())
          return this;
        if (other.getLogCount() != 0) {
          setLogCount(other.getLogCount());
        }
        if (other.getUnchangedCount() != 0) {
          setUnchangedCount(other.getUnchangedCount());
        }
        if (other.getDifferenceCount() != 0) {
          setDifferenceCount(other.getDifferenceCount());
        }
        if (other.getErrorCount() != 0) {
          setErrorCount(other.getErrorCount());
        }
        if (other.hasOldestDate()) {
          mergeOldestDate(other.getOldestDate());
        }
        if (other.hasNewestDate()) {
          mergeNewestDate(other.getNewestDate());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  logCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  unchangedCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  differenceCount_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  errorCount_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 42:
                {
                  input.readMessage(getOldestDateFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getNewestDateFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int logCount_;
      /**
       *
       *
       * <pre>
       * The total number of log entries replayed.
       * </pre>
       *
       * <code>int32 log_count = 1;</code>
       *
       * @return The logCount.
       */
      @java.lang.Override
      public int getLogCount() {
        return logCount_;
      }
      /**
       *
       *
       * <pre>
       * The total number of log entries replayed.
       * </pre>
       *
       * <code>int32 log_count = 1;</code>
       *
       * @param value The logCount to set.
       * @return This builder for chaining.
       */
      public Builder setLogCount(int value) {

        logCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The total number of log entries replayed.
       * </pre>
       *
       * <code>int32 log_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLogCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        logCount_ = 0;
        onChanged();
        return this;
      }

      private int unchangedCount_;
      /**
       *
       *
       * <pre>
       * The number of replayed log entries with no difference between
       * baseline and simulated policies.
       * </pre>
       *
       * <code>int32 unchanged_count = 2;</code>
       *
       * @return The unchangedCount.
       */
      @java.lang.Override
      public int getUnchangedCount() {
        return unchangedCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of replayed log entries with no difference between
       * baseline and simulated policies.
       * </pre>
       *
       * <code>int32 unchanged_count = 2;</code>
       *
       * @param value The unchangedCount to set.
       * @return This builder for chaining.
       */
      public Builder setUnchangedCount(int value) {

        unchangedCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of replayed log entries with no difference between
       * baseline and simulated policies.
       * </pre>
       *
       * <code>int32 unchanged_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUnchangedCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        unchangedCount_ = 0;
        onChanged();
        return this;
      }

      private int differenceCount_;
      /**
       *
       *
       * <pre>
       * The number of replayed log entries with a difference between baseline and
       * simulated policies.
       * </pre>
       *
       * <code>int32 difference_count = 3;</code>
       *
       * @return The differenceCount.
       */
      @java.lang.Override
      public int getDifferenceCount() {
        return differenceCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of replayed log entries with a difference between baseline and
       * simulated policies.
       * </pre>
       *
       * <code>int32 difference_count = 3;</code>
       *
       * @param value The differenceCount to set.
       * @return This builder for chaining.
       */
      public Builder setDifferenceCount(int value) {

        differenceCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of replayed log entries with a difference between baseline and
       * simulated policies.
       * </pre>
       *
       * <code>int32 difference_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDifferenceCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        differenceCount_ = 0;
        onChanged();
        return this;
      }

      private int errorCount_;
      /**
       *
       *
       * <pre>
       * The number of log entries that could not be replayed.
       * </pre>
       *
       * <code>int32 error_count = 4;</code>
       *
       * @return The errorCount.
       */
      @java.lang.Override
      public int getErrorCount() {
        return errorCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of log entries that could not be replayed.
       * </pre>
       *
       * <code>int32 error_count = 4;</code>
       *
       * @param value The errorCount to set.
       * @return This builder for chaining.
       */
      public Builder setErrorCount(int value) {

        errorCount_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of log entries that could not be replayed.
       * </pre>
       *
       * <code>int32 error_count = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearErrorCount() {
        bitField0_ = (bitField0_ & ~0x00000008);
        errorCount_ = 0;
        onChanged();
        return this;
      }

      private com.google.type.Date oldestDate_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
          oldestDateBuilder_;
      /**
       *
       *
       * <pre>
       * The date of the oldest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date oldest_date = 5;</code>
       *
       * @return Whether the oldestDate field is set.
       */
      public boolean hasOldestDate() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * The date of the oldest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date oldest_date = 5;</code>
       *
       * @return The oldestDate.
       */
      public com.google.type.Date getOldestDate() {
        if (oldestDateBuilder_ == null) {
          return oldestDate_ == null ? com.google.type.Date.getDefaultInstance() : oldestDate_;
        } else {
          return oldestDateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The date of the oldest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date oldest_date = 5;</code>
       */
      public Builder setOldestDate(com.google.type.Date value) {
        if (oldestDateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          oldestDate_ = value;
        } else {
          oldestDateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The date of the oldest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date oldest_date = 5;</code>
       */
      public Builder setOldestDate(com.google.type.Date.Builder builderForValue) {
        if (oldestDateBuilder_ == null) {
          oldestDate_ = builderForValue.build();
        } else {
          oldestDateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The date of the oldest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date oldest_date = 5;</code>
       */
      public Builder mergeOldestDate(com.google.type.Date value) {
        if (oldestDateBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && oldestDate_ != null
              && oldestDate_ != com.google.type.Date.getDefaultInstance()) {
            getOldestDateBuilder().mergeFrom(value);
          } else {
            oldestDate_ = value;
          }
        } else {
          oldestDateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The date of the oldest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date oldest_date = 5;</code>
       */
      public Builder clearOldestDate() {
        bitField0_ = (bitField0_ & ~0x00000010);
        oldestDate_ = null;
        if (oldestDateBuilder_ != null) {
          oldestDateBuilder_.dispose();
          oldestDateBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The date of the oldest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date oldest_date = 5;</code>
       */
      public com.google.type.Date.Builder getOldestDateBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getOldestDateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The date of the oldest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date oldest_date = 5;</code>
       */
      public com.google.type.DateOrBuilder getOldestDateOrBuilder() {
        if (oldestDateBuilder_ != null) {
          return oldestDateBuilder_.getMessageOrBuilder();
        } else {
          return oldestDate_ == null ? com.google.type.Date.getDefaultInstance() : oldestDate_;
        }
      }
      /**
       *
       *
       * <pre>
       * The date of the oldest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date oldest_date = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
          getOldestDateFieldBuilder() {
        if (oldestDateBuilder_ == null) {
          oldestDateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date,
                  com.google.type.Date.Builder,
                  com.google.type.DateOrBuilder>(
                  getOldestDate(), getParentForChildren(), isClean());
          oldestDate_ = null;
        }
        return oldestDateBuilder_;
      }

      private com.google.type.Date newestDate_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
          newestDateBuilder_;
      /**
       *
       *
       * <pre>
       * The date of the newest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date newest_date = 6;</code>
       *
       * @return Whether the newestDate field is set.
       */
      public boolean hasNewestDate() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * The date of the newest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date newest_date = 6;</code>
       *
       * @return The newestDate.
       */
      public com.google.type.Date getNewestDate() {
        if (newestDateBuilder_ == null) {
          return newestDate_ == null ? com.google.type.Date.getDefaultInstance() : newestDate_;
        } else {
          return newestDateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The date of the newest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date newest_date = 6;</code>
       */
      public Builder setNewestDate(com.google.type.Date value) {
        if (newestDateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          newestDate_ = value;
        } else {
          newestDateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The date of the newest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date newest_date = 6;</code>
       */
      public Builder setNewestDate(com.google.type.Date.Builder builderForValue) {
        if (newestDateBuilder_ == null) {
          newestDate_ = builderForValue.build();
        } else {
          newestDateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The date of the newest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date newest_date = 6;</code>
       */
      public Builder mergeNewestDate(com.google.type.Date value) {
        if (newestDateBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && newestDate_ != null
              && newestDate_ != com.google.type.Date.getDefaultInstance()) {
            getNewestDateBuilder().mergeFrom(value);
          } else {
            newestDate_ = value;
          }
        } else {
          newestDateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The date of the newest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date newest_date = 6;</code>
       */
      public Builder clearNewestDate() {
        bitField0_ = (bitField0_ & ~0x00000020);
        newestDate_ = null;
        if (newestDateBuilder_ != null) {
          newestDateBuilder_.dispose();
          newestDateBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The date of the newest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date newest_date = 6;</code>
       */
      public com.google.type.Date.Builder getNewestDateBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getNewestDateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The date of the newest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date newest_date = 6;</code>
       */
      public com.google.type.DateOrBuilder getNewestDateOrBuilder() {
        if (newestDateBuilder_ != null) {
          return newestDateBuilder_.getMessageOrBuilder();
        } else {
          return newestDate_ == null ? com.google.type.Date.getDefaultInstance() : newestDate_;
        }
      }
      /**
       *
       *
       * <pre>
       * The date of the newest log entry replayed.
       * </pre>
       *
       * <code>.google.type.Date newest_date = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
          getNewestDateFieldBuilder() {
        if (newestDateBuilder_ == null) {
          newestDateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date,
                  com.google.type.Date.Builder,
                  com.google.type.DateOrBuilder>(
                  getNewestDate(), getParentForChildren(), isClean());
          newestDate_ = null;
        }
        return newestDateBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.policysimulator.v1.Replay.ResultsSummary)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.policysimulator.v1.Replay.ResultsSummary)
    private static final com.google.cloud.policysimulator.v1.Replay.ResultsSummary DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.policysimulator.v1.Replay.ResultsSummary();
    }

    public static com.google.cloud.policysimulator.v1.Replay.ResultsSummary getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ResultsSummary> PARSER =
        new com.google.protobuf.AbstractParser<ResultsSummary>() {
          @java.lang.Override
          public ResultsSummary parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ResultsSummary> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ResultsSummary> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.Replay.ResultsSummary getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the `Replay`, which has the following
   * format:
   *
   * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
   * where `{resource-id}` is the ID of the project, folder, or organization
   * that owns the Replay.
   *
   * Example:
   * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the `Replay`, which has the following
   * format:
   *
   * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
   * where `{resource-id}` is the ID of the project, folder, or organization
   * that owns the Replay.
   *
   * Example:
   * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the `Replay`.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.Replay.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the `Replay`.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.Replay.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.Replay.State getState() {
    com.google.cloud.policysimulator.v1.Replay.State result =
        com.google.cloud.policysimulator.v1.Replay.State.forNumber(state_);
    return result == null ? com.google.cloud.policysimulator.v1.Replay.State.UNRECOGNIZED : result;
  }

  public static final int CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.policysimulator.v1.ReplayConfig config_;
  /**
   *
   *
   * <pre>
   * Required. The configuration used for the `Replay`.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return config_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The configuration used for the `Replay`.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ReplayConfig getConfig() {
    return config_ == null
        ? com.google.cloud.policysimulator.v1.ReplayConfig.getDefaultInstance()
        : config_;
  }
  /**
   *
   *
   * <pre>
   * Required. The configuration used for the `Replay`.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.ReplayConfigOrBuilder getConfigOrBuilder() {
    return config_ == null
        ? com.google.cloud.policysimulator.v1.ReplayConfig.getDefaultInstance()
        : config_;
  }

  public static final int RESULTS_SUMMARY_FIELD_NUMBER = 5;
  private com.google.cloud.policysimulator.v1.Replay.ResultsSummary resultsSummary_;
  /**
   *
   *
   * <pre>
   * Output only. Summary statistics about the replayed log entries.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the resultsSummary field is set.
   */
  @java.lang.Override
  public boolean hasResultsSummary() {
    return resultsSummary_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Summary statistics about the replayed log entries.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The resultsSummary.
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.Replay.ResultsSummary getResultsSummary() {
    return resultsSummary_ == null
        ? com.google.cloud.policysimulator.v1.Replay.ResultsSummary.getDefaultInstance()
        : resultsSummary_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Summary statistics about the replayed log entries.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.policysimulator.v1.Replay.ResultsSummaryOrBuilder
      getResultsSummaryOrBuilder() {
    return resultsSummary_ == null
        ? com.google.cloud.policysimulator.v1.Replay.ResultsSummary.getDefaultInstance()
        : resultsSummary_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (state_ != com.google.cloud.policysimulator.v1.Replay.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (config_ != null) {
      output.writeMessage(3, getConfig());
    }
    if (resultsSummary_ != null) {
      output.writeMessage(5, getResultsSummary());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (state_ != com.google.cloud.policysimulator.v1.Replay.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (config_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getConfig());
    }
    if (resultsSummary_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getResultsSummary());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.policysimulator.v1.Replay)) {
      return super.equals(obj);
    }
    com.google.cloud.policysimulator.v1.Replay other =
        (com.google.cloud.policysimulator.v1.Replay) obj;

    if (!getName().equals(other.getName())) return false;
    if (state_ != other.state_) return false;
    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (hasResultsSummary() != other.hasResultsSummary()) return false;
    if (hasResultsSummary()) {
      if (!getResultsSummary().equals(other.getResultsSummary())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (hasResultsSummary()) {
      hash = (37 * hash) + RESULTS_SUMMARY_FIELD_NUMBER;
      hash = (53 * hash) + getResultsSummary().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.policysimulator.v1.Replay parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.Replay parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.Replay parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.Replay parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.Replay parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.policysimulator.v1.Replay parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.Replay parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.Replay parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.Replay parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.Replay parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.policysimulator.v1.Replay parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.policysimulator.v1.Replay parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.policysimulator.v1.Replay prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A resource describing a `Replay`, or simulation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.policysimulator.v1.Replay}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.policysimulator.v1.Replay)
      com.google.cloud.policysimulator.v1.ReplayOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_Replay_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_Replay_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.policysimulator.v1.Replay.class,
              com.google.cloud.policysimulator.v1.Replay.Builder.class);
    }

    // Construct using com.google.cloud.policysimulator.v1.Replay.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      state_ = 0;
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      resultsSummary_ = null;
      if (resultsSummaryBuilder_ != null) {
        resultsSummaryBuilder_.dispose();
        resultsSummaryBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.policysimulator.v1.SimulatorProto
          .internal_static_google_cloud_policysimulator_v1_Replay_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.Replay getDefaultInstanceForType() {
      return com.google.cloud.policysimulator.v1.Replay.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.Replay build() {
      com.google.cloud.policysimulator.v1.Replay result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.policysimulator.v1.Replay buildPartial() {
      com.google.cloud.policysimulator.v1.Replay result =
          new com.google.cloud.policysimulator.v1.Replay(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.policysimulator.v1.Replay result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.config_ = configBuilder_ == null ? config_ : configBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.resultsSummary_ =
            resultsSummaryBuilder_ == null ? resultsSummary_ : resultsSummaryBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.policysimulator.v1.Replay) {
        return mergeFrom((com.google.cloud.policysimulator.v1.Replay) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.policysimulator.v1.Replay other) {
      if (other == com.google.cloud.policysimulator.v1.Replay.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (other.hasResultsSummary()) {
        mergeResultsSummary(other.getResultsSummary());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getResultsSummaryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the `Replay`, which has the following
     * format:
     *
     * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
     * where `{resource-id}` is the ID of the project, folder, or organization
     * that owns the Replay.
     *
     * Example:
     * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the `Replay`, which has the following
     * format:
     *
     * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
     * where `{resource-id}` is the ID of the project, folder, or organization
     * that owns the Replay.
     *
     * Example:
     * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the `Replay`, which has the following
     * format:
     *
     * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
     * where `{resource-id}` is the ID of the project, folder, or organization
     * that owns the Replay.
     *
     * Example:
     * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the `Replay`, which has the following
     * format:
     *
     * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
     * where `{resource-id}` is the ID of the project, folder, or organization
     * that owns the Replay.
     *
     * Example:
     * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the `Replay`, which has the following
     * format:
     *
     * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
     * where `{resource-id}` is the ID of the project, folder, or organization
     * that owns the Replay.
     *
     * Example:
     * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.policysimulator.v1.Replay.State getState() {
      com.google.cloud.policysimulator.v1.Replay.State result =
          com.google.cloud.policysimulator.v1.Replay.State.forNumber(state_);
      return result == null
          ? com.google.cloud.policysimulator.v1.Replay.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.policysimulator.v1.Replay.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.policysimulator.v1.ReplayConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.policysimulator.v1.ReplayConfig,
            com.google.cloud.policysimulator.v1.ReplayConfig.Builder,
            com.google.cloud.policysimulator.v1.ReplayConfigOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The configuration used for the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration used for the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The config.
     */
    public com.google.cloud.policysimulator.v1.ReplayConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.cloud.policysimulator.v1.ReplayConfig.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration used for the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConfig(com.google.cloud.policysimulator.v1.ReplayConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
      } else {
        configBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration used for the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConfig(
        com.google.cloud.policysimulator.v1.ReplayConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration used for the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeConfig(com.google.cloud.policysimulator.v1.ReplayConfig value) {
      if (configBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && config_ != null
            && config_ != com.google.cloud.policysimulator.v1.ReplayConfig.getDefaultInstance()) {
          getConfigBuilder().mergeFrom(value);
        } else {
          config_ = value;
        }
      } else {
        configBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration used for the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration used for the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.policysimulator.v1.ReplayConfig.Builder getConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration used for the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.policysimulator.v1.ReplayConfigOrBuilder getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.cloud.policysimulator.v1.ReplayConfig.getDefaultInstance()
            : config_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration used for the `Replay`.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.policysimulator.v1.ReplayConfig,
            com.google.cloud.policysimulator.v1.ReplayConfig.Builder,
            com.google.cloud.policysimulator.v1.ReplayConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.policysimulator.v1.ReplayConfig,
                com.google.cloud.policysimulator.v1.ReplayConfig.Builder,
                com.google.cloud.policysimulator.v1.ReplayConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.cloud.policysimulator.v1.Replay.ResultsSummary resultsSummary_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.policysimulator.v1.Replay.ResultsSummary,
            com.google.cloud.policysimulator.v1.Replay.ResultsSummary.Builder,
            com.google.cloud.policysimulator.v1.Replay.ResultsSummaryOrBuilder>
        resultsSummaryBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Summary statistics about the replayed log entries.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the resultsSummary field is set.
     */
    public boolean hasResultsSummary() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary statistics about the replayed log entries.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The resultsSummary.
     */
    public com.google.cloud.policysimulator.v1.Replay.ResultsSummary getResultsSummary() {
      if (resultsSummaryBuilder_ == null) {
        return resultsSummary_ == null
            ? com.google.cloud.policysimulator.v1.Replay.ResultsSummary.getDefaultInstance()
            : resultsSummary_;
      } else {
        return resultsSummaryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary statistics about the replayed log entries.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResultsSummary(
        com.google.cloud.policysimulator.v1.Replay.ResultsSummary value) {
      if (resultsSummaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resultsSummary_ = value;
      } else {
        resultsSummaryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary statistics about the replayed log entries.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResultsSummary(
        com.google.cloud.policysimulator.v1.Replay.ResultsSummary.Builder builderForValue) {
      if (resultsSummaryBuilder_ == null) {
        resultsSummary_ = builderForValue.build();
      } else {
        resultsSummaryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary statistics about the replayed log entries.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeResultsSummary(
        com.google.cloud.policysimulator.v1.Replay.ResultsSummary value) {
      if (resultsSummaryBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && resultsSummary_ != null
            && resultsSummary_
                != com.google.cloud.policysimulator.v1.Replay.ResultsSummary.getDefaultInstance()) {
          getResultsSummaryBuilder().mergeFrom(value);
        } else {
          resultsSummary_ = value;
        }
      } else {
        resultsSummaryBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary statistics about the replayed log entries.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearResultsSummary() {
      bitField0_ = (bitField0_ & ~0x00000008);
      resultsSummary_ = null;
      if (resultsSummaryBuilder_ != null) {
        resultsSummaryBuilder_.dispose();
        resultsSummaryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary statistics about the replayed log entries.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.policysimulator.v1.Replay.ResultsSummary.Builder
        getResultsSummaryBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getResultsSummaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary statistics about the replayed log entries.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.policysimulator.v1.Replay.ResultsSummaryOrBuilder
        getResultsSummaryOrBuilder() {
      if (resultsSummaryBuilder_ != null) {
        return resultsSummaryBuilder_.getMessageOrBuilder();
      } else {
        return resultsSummary_ == null
            ? com.google.cloud.policysimulator.v1.Replay.ResultsSummary.getDefaultInstance()
            : resultsSummary_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Summary statistics about the replayed log entries.
     * </pre>
     *
     * <code>
     * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.policysimulator.v1.Replay.ResultsSummary,
            com.google.cloud.policysimulator.v1.Replay.ResultsSummary.Builder,
            com.google.cloud.policysimulator.v1.Replay.ResultsSummaryOrBuilder>
        getResultsSummaryFieldBuilder() {
      if (resultsSummaryBuilder_ == null) {
        resultsSummaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.policysimulator.v1.Replay.ResultsSummary,
                com.google.cloud.policysimulator.v1.Replay.ResultsSummary.Builder,
                com.google.cloud.policysimulator.v1.Replay.ResultsSummaryOrBuilder>(
                getResultsSummary(), getParentForChildren(), isClean());
        resultsSummary_ = null;
      }
      return resultsSummaryBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.policysimulator.v1.Replay)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.policysimulator.v1.Replay)
  private static final com.google.cloud.policysimulator.v1.Replay DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.policysimulator.v1.Replay();
  }

  public static com.google.cloud.policysimulator.v1.Replay getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Replay> PARSER =
      new com.google.protobuf.AbstractParser<Replay>() {
        @java.lang.Override
        public Replay parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Replay> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Replay> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.policysimulator.v1.Replay getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
