/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/simulator.proto

package com.google.cloud.policysimulator.v1;

public interface ReplayOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.policysimulator.v1.Replay)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the `Replay`, which has the following
   * format:
   *
   * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
   * where `{resource-id}` is the ID of the project, folder, or organization
   * that owns the Replay.
   *
   * Example:
   * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the `Replay`, which has the following
   * format:
   *
   * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
   * where `{resource-id}` is the ID of the project, folder, or organization
   * that owns the Replay.
   *
   * Example:
   * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The current state of the `Replay`.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.Replay.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. The current state of the `Replay`.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.Replay.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.policysimulator.v1.Replay.State getState();

  /**
   *
   *
   * <pre>
   * Required. The configuration used for the `Replay`.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the config field is set.
   */
  boolean hasConfig();
  /**
   *
   *
   * <pre>
   * Required. The configuration used for the `Replay`.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The config.
   */
  com.google.cloud.policysimulator.v1.ReplayConfig getConfig();
  /**
   *
   *
   * <pre>
   * Required. The configuration used for the `Replay`.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.ReplayConfig config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.policysimulator.v1.ReplayConfigOrBuilder getConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Summary statistics about the replayed log entries.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the resultsSummary field is set.
   */
  boolean hasResultsSummary();
  /**
   *
   *
   * <pre>
   * Output only. Summary statistics about the replayed log entries.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The resultsSummary.
   */
  com.google.cloud.policysimulator.v1.Replay.ResultsSummary getResultsSummary();
  /**
   *
   *
   * <pre>
   * Output only. Summary statistics about the replayed log entries.
   * </pre>
   *
   * <code>
   * .google.cloud.policysimulator.v1.Replay.ResultsSummary results_summary = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.policysimulator.v1.Replay.ResultsSummaryOrBuilder getResultsSummaryOrBuilder();
}
