/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policysimulator/v1/simulator.proto

package com.google.cloud.policysimulator.v1;

public interface ReplayResultOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.policysimulator.v1.ReplayResult)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The difference between the principal's access under the current
   * (baseline) policies and the principal's access under the proposed
   * (simulated) policies.
   *
   * This field is only included for access tuples that were successfully
   * replayed and had different results under the current policies and the
   * proposed policies.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
   *
   * @return Whether the diff field is set.
   */
  boolean hasDiff();
  /**
   *
   *
   * <pre>
   * The difference between the principal's access under the current
   * (baseline) policies and the principal's access under the proposed
   * (simulated) policies.
   *
   * This field is only included for access tuples that were successfully
   * replayed and had different results under the current policies and the
   * proposed policies.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
   *
   * @return The diff.
   */
  com.google.cloud.policysimulator.v1.ReplayDiff getDiff();
  /**
   *
   *
   * <pre>
   * The difference between the principal's access under the current
   * (baseline) policies and the principal's access under the proposed
   * (simulated) policies.
   *
   * This field is only included for access tuples that were successfully
   * replayed and had different results under the current policies and the
   * proposed policies.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
   */
  com.google.cloud.policysimulator.v1.ReplayDiffOrBuilder getDiffOrBuilder();

  /**
   *
   *
   * <pre>
   * The error that caused the access tuple replay to fail.
   *
   * This field is only included for access tuples that were not replayed
   * successfully.
   * </pre>
   *
   * <code>.google.rpc.Status error = 6;</code>
   *
   * @return Whether the error field is set.
   */
  boolean hasError();
  /**
   *
   *
   * <pre>
   * The error that caused the access tuple replay to fail.
   *
   * This field is only included for access tuples that were not replayed
   * successfully.
   * </pre>
   *
   * <code>.google.rpc.Status error = 6;</code>
   *
   * @return The error.
   */
  com.google.rpc.Status getError();
  /**
   *
   *
   * <pre>
   * The error that caused the access tuple replay to fail.
   *
   * This field is only included for access tuples that were not replayed
   * successfully.
   * </pre>
   *
   * <code>.google.rpc.Status error = 6;</code>
   */
  com.google.rpc.StatusOrBuilder getErrorOrBuilder();

  /**
   *
   *
   * <pre>
   * The resource name of the `ReplayResult`, in the following format:
   *
   * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
   * where `{resource-id}` is the ID of the project, folder, or organization
   * that owns the [Replay][google.cloud.policysimulator.v1.Replay].
   *
   * Example:
   * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The resource name of the `ReplayResult`, in the following format:
   *
   * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
   * where `{resource-id}` is the ID of the project, folder, or organization
   * that owns the [Replay][google.cloud.policysimulator.v1.Replay].
   *
   * Example:
   * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
   * was included in.
   * </pre>
   *
   * <code>string parent = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
   * was included in.
   * </pre>
   *
   * <code>string parent = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * The access tuple that was replayed. This field includes information about
   * the principal, resource, and permission that were involved in the access
   * attempt.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
   *
   * @return Whether the accessTuple field is set.
   */
  boolean hasAccessTuple();
  /**
   *
   *
   * <pre>
   * The access tuple that was replayed. This field includes information about
   * the principal, resource, and permission that were involved in the access
   * attempt.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
   *
   * @return The accessTuple.
   */
  com.google.cloud.policysimulator.v1.AccessTuple getAccessTuple();
  /**
   *
   *
   * <pre>
   * The access tuple that was replayed. This field includes information about
   * the principal, resource, and permission that were involved in the access
   * attempt.
   * </pre>
   *
   * <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
   */
  com.google.cloud.policysimulator.v1.AccessTupleOrBuilder getAccessTupleOrBuilder();

  /**
   *
   *
   * <pre>
   * The latest date this access tuple was seen in the logs.
   * </pre>
   *
   * <code>.google.type.Date last_seen_date = 4;</code>
   *
   * @return Whether the lastSeenDate field is set.
   */
  boolean hasLastSeenDate();
  /**
   *
   *
   * <pre>
   * The latest date this access tuple was seen in the logs.
   * </pre>
   *
   * <code>.google.type.Date last_seen_date = 4;</code>
   *
   * @return The lastSeenDate.
   */
  com.google.type.Date getLastSeenDate();
  /**
   *
   *
   * <pre>
   * The latest date this access tuple was seen in the logs.
   * </pre>
   *
   * <code>.google.type.Date last_seen_date = 4;</code>
   */
  com.google.type.DateOrBuilder getLastSeenDateOrBuilder();

  com.google.cloud.policysimulator.v1.ReplayResult.ResultCase getResultCase();
}
