/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudprofiler/v2/profiler.proto

package com.google.devtools.cloudprofiler.v2;

/**
 *
 *
 * <pre>
 * CreateProfileRequest describes a profile resource online creation request.
 * The deployment field must be populated. The profile_type specifies the list
 * of profile types supported by the agent. The creation call will hang until a
 * profile of one of these types needs to be collected.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudprofiler.v2.CreateProfileRequest}
 */
public final class CreateProfileRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudprofiler.v2.CreateProfileRequest)
    CreateProfileRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateProfileRequest.newBuilder() to construct.
  private CreateProfileRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateProfileRequest() {
    parent_ = "";
    profileType_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateProfileRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.devtools.cloudprofiler.v2.ProfilerProto
        .internal_static_google_devtools_cloudprofiler_v2_CreateProfileRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.cloudprofiler.v2.ProfilerProto
        .internal_static_google_devtools_cloudprofiler_v2_CreateProfileRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.cloudprofiler.v2.CreateProfileRequest.class,
            com.google.devtools.cloudprofiler.v2.CreateProfileRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Parent project to create the profile in.
   * </pre>
   *
   * <code>string parent = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Parent project to create the profile in.
   * </pre>
   *
   * <code>string parent = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOYMENT_FIELD_NUMBER = 1;
  private com.google.devtools.cloudprofiler.v2.Deployment deployment_;
  /**
   *
   *
   * <pre>
   * Deployment details.
   * </pre>
   *
   * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
   *
   * @return Whether the deployment field is set.
   */
  @java.lang.Override
  public boolean hasDeployment() {
    return deployment_ != null;
  }
  /**
   *
   *
   * <pre>
   * Deployment details.
   * </pre>
   *
   * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
   *
   * @return The deployment.
   */
  @java.lang.Override
  public com.google.devtools.cloudprofiler.v2.Deployment getDeployment() {
    return deployment_ == null
        ? com.google.devtools.cloudprofiler.v2.Deployment.getDefaultInstance()
        : deployment_;
  }
  /**
   *
   *
   * <pre>
   * Deployment details.
   * </pre>
   *
   * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
   */
  @java.lang.Override
  public com.google.devtools.cloudprofiler.v2.DeploymentOrBuilder getDeploymentOrBuilder() {
    return deployment_ == null
        ? com.google.devtools.cloudprofiler.v2.Deployment.getDefaultInstance()
        : deployment_;
  }

  public static final int PROFILE_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> profileType_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.devtools.cloudprofiler.v2.ProfileType>
      profileType_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.devtools.cloudprofiler.v2.ProfileType>() {
            public com.google.devtools.cloudprofiler.v2.ProfileType convert(
                java.lang.Integer from) {
              com.google.devtools.cloudprofiler.v2.ProfileType result =
                  com.google.devtools.cloudprofiler.v2.ProfileType.forNumber(from);
              return result == null
                  ? com.google.devtools.cloudprofiler.v2.ProfileType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * One or more profile types that the agent is capable of providing.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
   *
   * @return A list containing the profileType.
   */
  @java.lang.Override
  public java.util.List<com.google.devtools.cloudprofiler.v2.ProfileType> getProfileTypeList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.devtools.cloudprofiler.v2.ProfileType>(
        profileType_, profileType_converter_);
  }
  /**
   *
   *
   * <pre>
   * One or more profile types that the agent is capable of providing.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
   *
   * @return The count of profileType.
   */
  @java.lang.Override
  public int getProfileTypeCount() {
    return profileType_.size();
  }
  /**
   *
   *
   * <pre>
   * One or more profile types that the agent is capable of providing.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The profileType at the given index.
   */
  @java.lang.Override
  public com.google.devtools.cloudprofiler.v2.ProfileType getProfileType(int index) {
    return profileType_converter_.convert(profileType_.get(index));
  }
  /**
   *
   *
   * <pre>
   * One or more profile types that the agent is capable of providing.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
   *
   * @return A list containing the enum numeric values on the wire for profileType.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getProfileTypeValueList() {
    return profileType_;
  }
  /**
   *
   *
   * <pre>
   * One or more profile types that the agent is capable of providing.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of profileType at the given index.
   */
  @java.lang.Override
  public int getProfileTypeValue(int index) {
    return profileType_.get(index);
  }

  private int profileTypeMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (deployment_ != null) {
      output.writeMessage(1, getDeployment());
    }
    if (getProfileTypeList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(profileTypeMemoizedSerializedSize);
    }
    for (int i = 0; i < profileType_.size(); i++) {
      output.writeEnumNoTag(profileType_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, parent_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (deployment_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDeployment());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < profileType_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(profileType_.get(i));
      }
      size += dataSize;
      if (!getProfileTypeList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      profileTypeMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, parent_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.devtools.cloudprofiler.v2.CreateProfileRequest)) {
      return super.equals(obj);
    }
    com.google.devtools.cloudprofiler.v2.CreateProfileRequest other =
        (com.google.devtools.cloudprofiler.v2.CreateProfileRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasDeployment() != other.hasDeployment()) return false;
    if (hasDeployment()) {
      if (!getDeployment().equals(other.getDeployment())) return false;
    }
    if (!profileType_.equals(other.profileType_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasDeployment()) {
      hash = (37 * hash) + DEPLOYMENT_FIELD_NUMBER;
      hash = (53 * hash) + getDeployment().hashCode();
    }
    if (getProfileTypeCount() > 0) {
      hash = (37 * hash) + PROFILE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + profileType_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.cloudprofiler.v2.CreateProfileRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudprofiler.v2.CreateProfileRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.CreateProfileRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudprofiler.v2.CreateProfileRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.CreateProfileRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudprofiler.v2.CreateProfileRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.CreateProfileRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudprofiler.v2.CreateProfileRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.CreateProfileRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudprofiler.v2.CreateProfileRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.CreateProfileRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudprofiler.v2.CreateProfileRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.devtools.cloudprofiler.v2.CreateProfileRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * CreateProfileRequest describes a profile resource online creation request.
   * The deployment field must be populated. The profile_type specifies the list
   * of profile types supported by the agent. The creation call will hang until a
   * profile of one of these types needs to be collected.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudprofiler.v2.CreateProfileRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudprofiler.v2.CreateProfileRequest)
      com.google.devtools.cloudprofiler.v2.CreateProfileRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.devtools.cloudprofiler.v2.ProfilerProto
          .internal_static_google_devtools_cloudprofiler_v2_CreateProfileRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.cloudprofiler.v2.ProfilerProto
          .internal_static_google_devtools_cloudprofiler_v2_CreateProfileRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.cloudprofiler.v2.CreateProfileRequest.class,
              com.google.devtools.cloudprofiler.v2.CreateProfileRequest.Builder.class);
    }

    // Construct using com.google.devtools.cloudprofiler.v2.CreateProfileRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      deployment_ = null;
      if (deploymentBuilder_ != null) {
        deploymentBuilder_.dispose();
        deploymentBuilder_ = null;
      }
      profileType_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.devtools.cloudprofiler.v2.ProfilerProto
          .internal_static_google_devtools_cloudprofiler_v2_CreateProfileRequest_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.cloudprofiler.v2.CreateProfileRequest getDefaultInstanceForType() {
      return com.google.devtools.cloudprofiler.v2.CreateProfileRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.cloudprofiler.v2.CreateProfileRequest build() {
      com.google.devtools.cloudprofiler.v2.CreateProfileRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.cloudprofiler.v2.CreateProfileRequest buildPartial() {
      com.google.devtools.cloudprofiler.v2.CreateProfileRequest result =
          new com.google.devtools.cloudprofiler.v2.CreateProfileRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.devtools.cloudprofiler.v2.CreateProfileRequest result) {
      if (((bitField0_ & 0x00000004) != 0)) {
        profileType_ = java.util.Collections.unmodifiableList(profileType_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.profileType_ = profileType_;
    }

    private void buildPartial0(com.google.devtools.cloudprofiler.v2.CreateProfileRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deployment_ = deploymentBuilder_ == null ? deployment_ : deploymentBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.cloudprofiler.v2.CreateProfileRequest) {
        return mergeFrom((com.google.devtools.cloudprofiler.v2.CreateProfileRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.cloudprofiler.v2.CreateProfileRequest other) {
      if (other == com.google.devtools.cloudprofiler.v2.CreateProfileRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDeployment()) {
        mergeDeployment(other.getDeployment());
      }
      if (!other.profileType_.isEmpty()) {
        if (profileType_.isEmpty()) {
          profileType_ = other.profileType_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureProfileTypeIsMutable();
          profileType_.addAll(other.profileType_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDeploymentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 16:
              {
                int tmpRaw = input.readEnum();
                ensureProfileTypeIsMutable();
                profileType_.add(tmpRaw);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureProfileTypeIsMutable();
                  profileType_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 18
            case 34:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Parent project to create the profile in.
     * </pre>
     *
     * <code>string parent = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parent project to create the profile in.
     * </pre>
     *
     * <code>string parent = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parent project to create the profile in.
     * </pre>
     *
     * <code>string parent = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parent project to create the profile in.
     * </pre>
     *
     * <code>string parent = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parent project to create the profile in.
     * </pre>
     *
     * <code>string parent = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.devtools.cloudprofiler.v2.Deployment deployment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.cloudprofiler.v2.Deployment,
            com.google.devtools.cloudprofiler.v2.Deployment.Builder,
            com.google.devtools.cloudprofiler.v2.DeploymentOrBuilder>
        deploymentBuilder_;
    /**
     *
     *
     * <pre>
     * Deployment details.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
     *
     * @return Whether the deployment field is set.
     */
    public boolean hasDeployment() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Deployment details.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
     *
     * @return The deployment.
     */
    public com.google.devtools.cloudprofiler.v2.Deployment getDeployment() {
      if (deploymentBuilder_ == null) {
        return deployment_ == null
            ? com.google.devtools.cloudprofiler.v2.Deployment.getDefaultInstance()
            : deployment_;
      } else {
        return deploymentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Deployment details.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
     */
    public Builder setDeployment(com.google.devtools.cloudprofiler.v2.Deployment value) {
      if (deploymentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deployment_ = value;
      } else {
        deploymentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment details.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
     */
    public Builder setDeployment(
        com.google.devtools.cloudprofiler.v2.Deployment.Builder builderForValue) {
      if (deploymentBuilder_ == null) {
        deployment_ = builderForValue.build();
      } else {
        deploymentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment details.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
     */
    public Builder mergeDeployment(com.google.devtools.cloudprofiler.v2.Deployment value) {
      if (deploymentBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && deployment_ != null
            && deployment_
                != com.google.devtools.cloudprofiler.v2.Deployment.getDefaultInstance()) {
          getDeploymentBuilder().mergeFrom(value);
        } else {
          deployment_ = value;
        }
      } else {
        deploymentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment details.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
     */
    public Builder clearDeployment() {
      bitField0_ = (bitField0_ & ~0x00000002);
      deployment_ = null;
      if (deploymentBuilder_ != null) {
        deploymentBuilder_.dispose();
        deploymentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment details.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
     */
    public com.google.devtools.cloudprofiler.v2.Deployment.Builder getDeploymentBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDeploymentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Deployment details.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
     */
    public com.google.devtools.cloudprofiler.v2.DeploymentOrBuilder getDeploymentOrBuilder() {
      if (deploymentBuilder_ != null) {
        return deploymentBuilder_.getMessageOrBuilder();
      } else {
        return deployment_ == null
            ? com.google.devtools.cloudprofiler.v2.Deployment.getDefaultInstance()
            : deployment_;
      }
    }
    /**
     *
     *
     * <pre>
     * Deployment details.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.cloudprofiler.v2.Deployment,
            com.google.devtools.cloudprofiler.v2.Deployment.Builder,
            com.google.devtools.cloudprofiler.v2.DeploymentOrBuilder>
        getDeploymentFieldBuilder() {
      if (deploymentBuilder_ == null) {
        deploymentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.devtools.cloudprofiler.v2.Deployment,
                com.google.devtools.cloudprofiler.v2.Deployment.Builder,
                com.google.devtools.cloudprofiler.v2.DeploymentOrBuilder>(
                getDeployment(), getParentForChildren(), isClean());
        deployment_ = null;
      }
      return deploymentBuilder_;
    }

    private java.util.List<java.lang.Integer> profileType_ = java.util.Collections.emptyList();

    private void ensureProfileTypeIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        profileType_ = new java.util.ArrayList<java.lang.Integer>(profileType_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * One or more profile types that the agent is capable of providing.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @return A list containing the profileType.
     */
    public java.util.List<com.google.devtools.cloudprofiler.v2.ProfileType> getProfileTypeList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.devtools.cloudprofiler.v2.ProfileType>(
          profileType_, profileType_converter_);
    }
    /**
     *
     *
     * <pre>
     * One or more profile types that the agent is capable of providing.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @return The count of profileType.
     */
    public int getProfileTypeCount() {
      return profileType_.size();
    }
    /**
     *
     *
     * <pre>
     * One or more profile types that the agent is capable of providing.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The profileType at the given index.
     */
    public com.google.devtools.cloudprofiler.v2.ProfileType getProfileType(int index) {
      return profileType_converter_.convert(profileType_.get(index));
    }
    /**
     *
     *
     * <pre>
     * One or more profile types that the agent is capable of providing.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The profileType to set.
     * @return This builder for chaining.
     */
    public Builder setProfileType(
        int index, com.google.devtools.cloudprofiler.v2.ProfileType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProfileTypeIsMutable();
      profileType_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more profile types that the agent is capable of providing.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @param value The profileType to add.
     * @return This builder for chaining.
     */
    public Builder addProfileType(com.google.devtools.cloudprofiler.v2.ProfileType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProfileTypeIsMutable();
      profileType_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more profile types that the agent is capable of providing.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @param values The profileType to add.
     * @return This builder for chaining.
     */
    public Builder addAllProfileType(
        java.lang.Iterable<? extends com.google.devtools.cloudprofiler.v2.ProfileType> values) {
      ensureProfileTypeIsMutable();
      for (com.google.devtools.cloudprofiler.v2.ProfileType value : values) {
        profileType_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more profile types that the agent is capable of providing.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProfileType() {
      profileType_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more profile types that the agent is capable of providing.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @return A list containing the enum numeric values on the wire for profileType.
     */
    public java.util.List<java.lang.Integer> getProfileTypeValueList() {
      return java.util.Collections.unmodifiableList(profileType_);
    }
    /**
     *
     *
     * <pre>
     * One or more profile types that the agent is capable of providing.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of profileType at the given index.
     */
    public int getProfileTypeValue(int index) {
      return profileType_.get(index);
    }
    /**
     *
     *
     * <pre>
     * One or more profile types that the agent is capable of providing.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for profileType to set.
     * @return This builder for chaining.
     */
    public Builder setProfileTypeValue(int index, int value) {
      ensureProfileTypeIsMutable();
      profileType_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more profile types that the agent is capable of providing.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @param value The enum numeric value on the wire for profileType to add.
     * @return This builder for chaining.
     */
    public Builder addProfileTypeValue(int value) {
      ensureProfileTypeIsMutable();
      profileType_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more profile types that the agent is capable of providing.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @param values The enum numeric values on the wire for profileType to add.
     * @return This builder for chaining.
     */
    public Builder addAllProfileTypeValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureProfileTypeIsMutable();
      for (int value : values) {
        profileType_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudprofiler.v2.CreateProfileRequest)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudprofiler.v2.CreateProfileRequest)
  private static final com.google.devtools.cloudprofiler.v2.CreateProfileRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.devtools.cloudprofiler.v2.CreateProfileRequest();
  }

  public static com.google.devtools.cloudprofiler.v2.CreateProfileRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateProfileRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateProfileRequest>() {
        @java.lang.Override
        public CreateProfileRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateProfileRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateProfileRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.cloudprofiler.v2.CreateProfileRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
