/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudprofiler/v2/profiler.proto

package com.google.devtools.cloudprofiler.v2;

/**
 *
 *
 * <pre>
 * Deployment contains the deployment identification information.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudprofiler.v2.Deployment}
 */
public final class Deployment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudprofiler.v2.Deployment)
    DeploymentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Deployment.newBuilder() to construct.
  private Deployment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Deployment() {
    projectId_ = "";
    target_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Deployment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.devtools.cloudprofiler.v2.ProfilerProto
        .internal_static_google_devtools_cloudprofiler_v2_Deployment_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.cloudprofiler.v2.ProfilerProto
        .internal_static_google_devtools_cloudprofiler_v2_Deployment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.cloudprofiler.v2.Deployment.class,
            com.google.devtools.cloudprofiler.v2.Deployment.Builder.class);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Project ID is the ID of a cloud project.
   * Validation regex: `^[a-z][-a-z0-9:.]{4,61}[a-z0-9]$`.
   * </pre>
   *
   * <code>string project_id = 1;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Project ID is the ID of a cloud project.
   * Validation regex: `^[a-z][-a-z0-9:.]{4,61}[a-z0-9]$`.
   * </pre>
   *
   * <code>string project_id = 1;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object target_ = "";
  /**
   *
   *
   * <pre>
   * Target is the service name used to group related deployments:
   * * Service name for App Engine Flex / Standard.
   * * Cluster and container name for GKE.
   * * User-specified string for direct Compute Engine profiling (e.g. Java).
   * * Job name for Dataflow.
   * Validation regex: `^[a-z0-9]([-a-z0-9_.]{0,253}[a-z0-9])?$`.
   * </pre>
   *
   * <code>string target = 2;</code>
   *
   * @return The target.
   */
  @java.lang.Override
  public java.lang.String getTarget() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      target_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Target is the service name used to group related deployments:
   * * Service name for App Engine Flex / Standard.
   * * Cluster and container name for GKE.
   * * User-specified string for direct Compute Engine profiling (e.g. Java).
   * * Job name for Dataflow.
   * Validation regex: `^[a-z0-9]([-a-z0-9_.]{0,253}[a-z0-9])?$`.
   * </pre>
   *
   * <code>string target = 2;</code>
   *
   * @return The bytes for target.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetBytes() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      target_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 3;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.devtools.cloudprofiler.v2.ProfilerProto
                .internal_static_google_devtools_cloudprofiler_v2_Deployment_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels identify the deployment within the user universe and same target.
   * Validation regex for label names: `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * Value for an individual label must be &lt;= 512 bytes, the total
   * size of all label names and values must be &lt;= 1024 bytes.
   *
   * Label named "language" can be used to record the programming language of
   * the profiled deployment. The standard choices for the value include "java",
   * "go", "python", "ruby", "nodejs", "php", "dotnet".
   *
   * For deployments running on Google Cloud Platform, "zone" or "region" label
   * should be present describing the deployment location. An example of a zone
   * is "us-central1-a", an example of a region is "us-central1" or
   * "us-central".
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels identify the deployment within the user universe and same target.
   * Validation regex for label names: `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * Value for an individual label must be &lt;= 512 bytes, the total
   * size of all label names and values must be &lt;= 1024 bytes.
   *
   * Label named "language" can be used to record the programming language of
   * the profiled deployment. The standard choices for the value include "java",
   * "go", "python", "ruby", "nodejs", "php", "dotnet".
   *
   * For deployments running on Google Cloud Platform, "zone" or "region" label
   * should be present describing the deployment location. An example of a zone
   * is "us-central1-a", an example of a region is "us-central1" or
   * "us-central".
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels identify the deployment within the user universe and same target.
   * Validation regex for label names: `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * Value for an individual label must be &lt;= 512 bytes, the total
   * size of all label names and values must be &lt;= 1024 bytes.
   *
   * Label named "language" can be used to record the programming language of
   * the profiled deployment. The standard choices for the value include "java",
   * "go", "python", "ruby", "nodejs", "php", "dotnet".
   *
   * For deployments running on Google Cloud Platform, "zone" or "region" label
   * should be present describing the deployment location. An example of a zone
   * is "us-central1-a", an example of a region is "us-central1" or
   * "us-central".
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels identify the deployment within the user universe and same target.
   * Validation regex for label names: `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * Value for an individual label must be &lt;= 512 bytes, the total
   * size of all label names and values must be &lt;= 1024 bytes.
   *
   * Label named "language" can be used to record the programming language of
   * the profiled deployment. The standard choices for the value include "java",
   * "go", "python", "ruby", "nodejs", "php", "dotnet".
   *
   * For deployments running on Google Cloud Platform, "zone" or "region" label
   * should be present describing the deployment location. An example of a zone
   * is "us-central1-a", an example of a region is "us-central1" or
   * "us-central".
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, target_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 3);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, target_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.devtools.cloudprofiler.v2.Deployment)) {
      return super.equals(obj);
    }
    com.google.devtools.cloudprofiler.v2.Deployment other =
        (com.google.devtools.cloudprofiler.v2.Deployment) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getTarget().equals(other.getTarget())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + TARGET_FIELD_NUMBER;
    hash = (53 * hash) + getTarget().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.cloudprofiler.v2.Deployment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudprofiler.v2.Deployment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.Deployment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudprofiler.v2.Deployment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.Deployment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudprofiler.v2.Deployment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.Deployment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudprofiler.v2.Deployment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.Deployment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudprofiler.v2.Deployment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.Deployment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudprofiler.v2.Deployment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.devtools.cloudprofiler.v2.Deployment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Deployment contains the deployment identification information.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudprofiler.v2.Deployment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudprofiler.v2.Deployment)
      com.google.devtools.cloudprofiler.v2.DeploymentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.devtools.cloudprofiler.v2.ProfilerProto
          .internal_static_google_devtools_cloudprofiler_v2_Deployment_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.cloudprofiler.v2.ProfilerProto
          .internal_static_google_devtools_cloudprofiler_v2_Deployment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.cloudprofiler.v2.Deployment.class,
              com.google.devtools.cloudprofiler.v2.Deployment.Builder.class);
    }

    // Construct using com.google.devtools.cloudprofiler.v2.Deployment.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      target_ = "";
      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.devtools.cloudprofiler.v2.ProfilerProto
          .internal_static_google_devtools_cloudprofiler_v2_Deployment_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.cloudprofiler.v2.Deployment getDefaultInstanceForType() {
      return com.google.devtools.cloudprofiler.v2.Deployment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.cloudprofiler.v2.Deployment build() {
      com.google.devtools.cloudprofiler.v2.Deployment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.cloudprofiler.v2.Deployment buildPartial() {
      com.google.devtools.cloudprofiler.v2.Deployment result =
          new com.google.devtools.cloudprofiler.v2.Deployment(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.devtools.cloudprofiler.v2.Deployment result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.target_ = target_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.cloudprofiler.v2.Deployment) {
        return mergeFrom((com.google.devtools.cloudprofiler.v2.Deployment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.cloudprofiler.v2.Deployment other) {
      if (other == com.google.devtools.cloudprofiler.v2.Deployment.getDefaultInstance())
        return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTarget().isEmpty()) {
        target_ = other.target_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000004;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                target_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Project ID is the ID of a cloud project.
     * Validation regex: `^[a-z][-a-z0-9:.]{4,61}[a-z0-9]$`.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID is the ID of a cloud project.
     * Validation regex: `^[a-z][-a-z0-9:.]{4,61}[a-z0-9]$`.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID is the ID of a cloud project.
     * Validation regex: `^[a-z][-a-z0-9:.]{4,61}[a-z0-9]$`.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID is the ID of a cloud project.
     * Validation regex: `^[a-z][-a-z0-9:.]{4,61}[a-z0-9]$`.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID is the ID of a cloud project.
     * Validation regex: `^[a-z][-a-z0-9:.]{4,61}[a-z0-9]$`.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object target_ = "";
    /**
     *
     *
     * <pre>
     * Target is the service name used to group related deployments:
     * * Service name for App Engine Flex / Standard.
     * * Cluster and container name for GKE.
     * * User-specified string for direct Compute Engine profiling (e.g. Java).
     * * Job name for Dataflow.
     * Validation regex: `^[a-z0-9]([-a-z0-9_.]{0,253}[a-z0-9])?$`.
     * </pre>
     *
     * <code>string target = 2;</code>
     *
     * @return The target.
     */
    public java.lang.String getTarget() {
      java.lang.Object ref = target_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        target_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Target is the service name used to group related deployments:
     * * Service name for App Engine Flex / Standard.
     * * Cluster and container name for GKE.
     * * User-specified string for direct Compute Engine profiling (e.g. Java).
     * * Job name for Dataflow.
     * Validation regex: `^[a-z0-9]([-a-z0-9_.]{0,253}[a-z0-9])?$`.
     * </pre>
     *
     * <code>string target = 2;</code>
     *
     * @return The bytes for target.
     */
    public com.google.protobuf.ByteString getTargetBytes() {
      java.lang.Object ref = target_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        target_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Target is the service name used to group related deployments:
     * * Service name for App Engine Flex / Standard.
     * * Cluster and container name for GKE.
     * * User-specified string for direct Compute Engine profiling (e.g. Java).
     * * Job name for Dataflow.
     * Validation regex: `^[a-z0-9]([-a-z0-9_.]{0,253}[a-z0-9])?$`.
     * </pre>
     *
     * <code>string target = 2;</code>
     *
     * @param value The target to set.
     * @return This builder for chaining.
     */
    public Builder setTarget(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      target_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target is the service name used to group related deployments:
     * * Service name for App Engine Flex / Standard.
     * * Cluster and container name for GKE.
     * * User-specified string for direct Compute Engine profiling (e.g. Java).
     * * Job name for Dataflow.
     * Validation regex: `^[a-z0-9]([-a-z0-9_.]{0,253}[a-z0-9])?$`.
     * </pre>
     *
     * <code>string target = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTarget() {
      target_ = getDefaultInstance().getTarget();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target is the service name used to group related deployments:
     * * Service name for App Engine Flex / Standard.
     * * Cluster and container name for GKE.
     * * User-specified string for direct Compute Engine profiling (e.g. Java).
     * * Job name for Dataflow.
     * Validation regex: `^[a-z0-9]([-a-z0-9_.]{0,253}[a-z0-9])?$`.
     * </pre>
     *
     * <code>string target = 2;</code>
     *
     * @param value The bytes for target to set.
     * @return This builder for chaining.
     */
    public Builder setTargetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      target_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels identify the deployment within the user universe and same target.
     * Validation regex for label names: `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * Value for an individual label must be &lt;= 512 bytes, the total
     * size of all label names and values must be &lt;= 1024 bytes.
     *
     * Label named "language" can be used to record the programming language of
     * the profiled deployment. The standard choices for the value include "java",
     * "go", "python", "ruby", "nodejs", "php", "dotnet".
     *
     * For deployments running on Google Cloud Platform, "zone" or "region" label
     * should be present describing the deployment location. An example of a zone
     * is "us-central1-a", an example of a region is "us-central1" or
     * "us-central".
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels identify the deployment within the user universe and same target.
     * Validation regex for label names: `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * Value for an individual label must be &lt;= 512 bytes, the total
     * size of all label names and values must be &lt;= 1024 bytes.
     *
     * Label named "language" can be used to record the programming language of
     * the profiled deployment. The standard choices for the value include "java",
     * "go", "python", "ruby", "nodejs", "php", "dotnet".
     *
     * For deployments running on Google Cloud Platform, "zone" or "region" label
     * should be present describing the deployment location. An example of a zone
     * is "us-central1-a", an example of a region is "us-central1" or
     * "us-central".
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels identify the deployment within the user universe and same target.
     * Validation regex for label names: `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * Value for an individual label must be &lt;= 512 bytes, the total
     * size of all label names and values must be &lt;= 1024 bytes.
     *
     * Label named "language" can be used to record the programming language of
     * the profiled deployment. The standard choices for the value include "java",
     * "go", "python", "ruby", "nodejs", "php", "dotnet".
     *
     * For deployments running on Google Cloud Platform, "zone" or "region" label
     * should be present describing the deployment location. An example of a zone
     * is "us-central1-a", an example of a region is "us-central1" or
     * "us-central".
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels identify the deployment within the user universe and same target.
     * Validation regex for label names: `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * Value for an individual label must be &lt;= 512 bytes, the total
     * size of all label names and values must be &lt;= 1024 bytes.
     *
     * Label named "language" can be used to record the programming language of
     * the profiled deployment. The standard choices for the value include "java",
     * "go", "python", "ruby", "nodejs", "php", "dotnet".
     *
     * For deployments running on Google Cloud Platform, "zone" or "region" label
     * should be present describing the deployment location. An example of a zone
     * is "us-central1-a", an example of a region is "us-central1" or
     * "us-central".
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels identify the deployment within the user universe and same target.
     * Validation regex for label names: `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * Value for an individual label must be &lt;= 512 bytes, the total
     * size of all label names and values must be &lt;= 1024 bytes.
     *
     * Label named "language" can be used to record the programming language of
     * the profiled deployment. The standard choices for the value include "java",
     * "go", "python", "ruby", "nodejs", "php", "dotnet".
     *
     * For deployments running on Google Cloud Platform, "zone" or "region" label
     * should be present describing the deployment location. An example of a zone
     * is "us-central1-a", an example of a region is "us-central1" or
     * "us-central".
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000004;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels identify the deployment within the user universe and same target.
     * Validation regex for label names: `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * Value for an individual label must be &lt;= 512 bytes, the total
     * size of all label names and values must be &lt;= 1024 bytes.
     *
     * Label named "language" can be used to record the programming language of
     * the profiled deployment. The standard choices for the value include "java",
     * "go", "python", "ruby", "nodejs", "php", "dotnet".
     *
     * For deployments running on Google Cloud Platform, "zone" or "region" label
     * should be present describing the deployment location. An example of a zone
     * is "us-central1-a", an example of a region is "us-central1" or
     * "us-central".
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels identify the deployment within the user universe and same target.
     * Validation regex for label names: `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * Value for an individual label must be &lt;= 512 bytes, the total
     * size of all label names and values must be &lt;= 1024 bytes.
     *
     * Label named "language" can be used to record the programming language of
     * the profiled deployment. The standard choices for the value include "java",
     * "go", "python", "ruby", "nodejs", "php", "dotnet".
     *
     * For deployments running on Google Cloud Platform, "zone" or "region" label
     * should be present describing the deployment location. An example of a zone
     * is "us-central1-a", an example of a region is "us-central1" or
     * "us-central".
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudprofiler.v2.Deployment)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudprofiler.v2.Deployment)
  private static final com.google.devtools.cloudprofiler.v2.Deployment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.devtools.cloudprofiler.v2.Deployment();
  }

  public static com.google.devtools.cloudprofiler.v2.Deployment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Deployment> PARSER =
      new com.google.protobuf.AbstractParser<Deployment>() {
        @java.lang.Override
        public Deployment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Deployment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Deployment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.cloudprofiler.v2.Deployment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
