/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudprofiler/v2/profiler.proto

package com.google.devtools.cloudprofiler.v2;

/**
 *
 *
 * <pre>
 * Profile resource.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudprofiler.v2.Profile}
 */
public final class Profile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudprofiler.v2.Profile)
    ProfileOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Profile.newBuilder() to construct.
  private Profile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Profile() {
    name_ = "";
    profileType_ = 0;
    profileBytes_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Profile();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.devtools.cloudprofiler.v2.ProfilerProto
        .internal_static_google_devtools_cloudprofiler_v2_Profile_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 6:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.cloudprofiler.v2.ProfilerProto
        .internal_static_google_devtools_cloudprofiler_v2_Profile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.cloudprofiler.v2.Profile.class,
            com.google.devtools.cloudprofiler.v2.Profile.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Opaque, server-assigned, unique ID for this profile.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Opaque, server-assigned, unique ID for this profile.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROFILE_TYPE_FIELD_NUMBER = 2;
  private int profileType_ = 0;
  /**
   *
   *
   * <pre>
   * Type of profile.
   * For offline mode, this must be specified when creating the profile. For
   * online mode it is assigned and returned by the server.
   * </pre>
   *
   * <code>.google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
   *
   * @return The enum numeric value on the wire for profileType.
   */
  @java.lang.Override
  public int getProfileTypeValue() {
    return profileType_;
  }
  /**
   *
   *
   * <pre>
   * Type of profile.
   * For offline mode, this must be specified when creating the profile. For
   * online mode it is assigned and returned by the server.
   * </pre>
   *
   * <code>.google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
   *
   * @return The profileType.
   */
  @java.lang.Override
  public com.google.devtools.cloudprofiler.v2.ProfileType getProfileType() {
    com.google.devtools.cloudprofiler.v2.ProfileType result =
        com.google.devtools.cloudprofiler.v2.ProfileType.forNumber(profileType_);
    return result == null ? com.google.devtools.cloudprofiler.v2.ProfileType.UNRECOGNIZED : result;
  }

  public static final int DEPLOYMENT_FIELD_NUMBER = 3;
  private com.google.devtools.cloudprofiler.v2.Deployment deployment_;
  /**
   *
   *
   * <pre>
   * Deployment this profile corresponds to.
   * </pre>
   *
   * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 3;</code>
   *
   * @return Whether the deployment field is set.
   */
  @java.lang.Override
  public boolean hasDeployment() {
    return deployment_ != null;
  }
  /**
   *
   *
   * <pre>
   * Deployment this profile corresponds to.
   * </pre>
   *
   * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 3;</code>
   *
   * @return The deployment.
   */
  @java.lang.Override
  public com.google.devtools.cloudprofiler.v2.Deployment getDeployment() {
    return deployment_ == null
        ? com.google.devtools.cloudprofiler.v2.Deployment.getDefaultInstance()
        : deployment_;
  }
  /**
   *
   *
   * <pre>
   * Deployment this profile corresponds to.
   * </pre>
   *
   * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 3;</code>
   */
  @java.lang.Override
  public com.google.devtools.cloudprofiler.v2.DeploymentOrBuilder getDeploymentOrBuilder() {
    return deployment_ == null
        ? com.google.devtools.cloudprofiler.v2.Deployment.getDefaultInstance()
        : deployment_;
  }

  public static final int DURATION_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration duration_;
  /**
   *
   *
   * <pre>
   * Duration of the profiling session.
   * Input (for the offline mode) or output (for the online mode).
   * The field represents requested profiling duration. It may slightly differ
   * from the effective profiling duration, which is recorded in the profile
   * data, in case the profiling can't be stopped immediately (e.g. in case
   * stopping the profiling is handled asynchronously).
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 4;</code>
   *
   * @return Whether the duration field is set.
   */
  @java.lang.Override
  public boolean hasDuration() {
    return duration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Duration of the profiling session.
   * Input (for the offline mode) or output (for the online mode).
   * The field represents requested profiling duration. It may slightly differ
   * from the effective profiling duration, which is recorded in the profile
   * data, in case the profiling can't be stopped immediately (e.g. in case
   * stopping the profiling is handled asynchronously).
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 4;</code>
   *
   * @return The duration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDuration() {
    return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
  }
  /**
   *
   *
   * <pre>
   * Duration of the profiling session.
   * Input (for the offline mode) or output (for the online mode).
   * The field represents requested profiling duration. It may slightly differ
   * from the effective profiling duration, which is recorded in the profile
   * data, in case the profiling can't be stopped immediately (e.g. in case
   * stopping the profiling is handled asynchronously).
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
    return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
  }

  public static final int PROFILE_BYTES_FIELD_NUMBER = 5;
  private com.google.protobuf.ByteString profileBytes_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Input only. Profile bytes, as a gzip compressed serialized proto, the
   * format is https://github.com/google/pprof/blob/master/proto/profile.proto.
   * </pre>
   *
   * <code>bytes profile_bytes = 5 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The profileBytes.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProfileBytes() {
    return profileBytes_;
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.devtools.cloudprofiler.v2.ProfilerProto
                .internal_static_google_devtools_cloudprofiler_v2_Profile_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Input only. Labels associated to this specific profile. These labels will
   * get merged with the deployment labels for the final data set. See
   * documentation on deployment labels for validation rules and limits.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Input only. Labels associated to this specific profile. These labels will
   * get merged with the deployment labels for the final data set. See
   * documentation on deployment labels for validation rules and limits.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Input only. Labels associated to this specific profile. These labels will
   * get merged with the deployment labels for the final data set. See
   * documentation on deployment labels for validation rules and limits.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Input only. Labels associated to this specific profile. These labels will
   * get merged with the deployment labels for the final data set. See
   * documentation on deployment labels for validation rules and limits.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (profileType_
        != com.google.devtools.cloudprofiler.v2.ProfileType.PROFILE_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, profileType_);
    }
    if (deployment_ != null) {
      output.writeMessage(3, getDeployment());
    }
    if (duration_ != null) {
      output.writeMessage(4, getDuration());
    }
    if (!profileBytes_.isEmpty()) {
      output.writeBytes(5, profileBytes_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (profileType_
        != com.google.devtools.cloudprofiler.v2.ProfileType.PROFILE_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, profileType_);
    }
    if (deployment_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDeployment());
    }
    if (duration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDuration());
    }
    if (!profileBytes_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(5, profileBytes_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.devtools.cloudprofiler.v2.Profile)) {
      return super.equals(obj);
    }
    com.google.devtools.cloudprofiler.v2.Profile other =
        (com.google.devtools.cloudprofiler.v2.Profile) obj;

    if (!getName().equals(other.getName())) return false;
    if (profileType_ != other.profileType_) return false;
    if (hasDeployment() != other.hasDeployment()) return false;
    if (hasDeployment()) {
      if (!getDeployment().equals(other.getDeployment())) return false;
    }
    if (hasDuration() != other.hasDuration()) return false;
    if (hasDuration()) {
      if (!getDuration().equals(other.getDuration())) return false;
    }
    if (!getProfileBytes().equals(other.getProfileBytes())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PROFILE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + profileType_;
    if (hasDeployment()) {
      hash = (37 * hash) + DEPLOYMENT_FIELD_NUMBER;
      hash = (53 * hash) + getDeployment().hashCode();
    }
    if (hasDuration()) {
      hash = (37 * hash) + DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getDuration().hashCode();
    }
    hash = (37 * hash) + PROFILE_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + getProfileBytes().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.cloudprofiler.v2.Profile parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudprofiler.v2.Profile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.Profile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudprofiler.v2.Profile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.Profile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudprofiler.v2.Profile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.Profile parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudprofiler.v2.Profile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.Profile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudprofiler.v2.Profile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.cloudprofiler.v2.Profile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudprofiler.v2.Profile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.devtools.cloudprofiler.v2.Profile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Profile resource.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudprofiler.v2.Profile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudprofiler.v2.Profile)
      com.google.devtools.cloudprofiler.v2.ProfileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.devtools.cloudprofiler.v2.ProfilerProto
          .internal_static_google_devtools_cloudprofiler_v2_Profile_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 6:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.cloudprofiler.v2.ProfilerProto
          .internal_static_google_devtools_cloudprofiler_v2_Profile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.cloudprofiler.v2.Profile.class,
              com.google.devtools.cloudprofiler.v2.Profile.Builder.class);
    }

    // Construct using com.google.devtools.cloudprofiler.v2.Profile.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      profileType_ = 0;
      deployment_ = null;
      if (deploymentBuilder_ != null) {
        deploymentBuilder_.dispose();
        deploymentBuilder_ = null;
      }
      duration_ = null;
      if (durationBuilder_ != null) {
        durationBuilder_.dispose();
        durationBuilder_ = null;
      }
      profileBytes_ = com.google.protobuf.ByteString.EMPTY;
      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.devtools.cloudprofiler.v2.ProfilerProto
          .internal_static_google_devtools_cloudprofiler_v2_Profile_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.cloudprofiler.v2.Profile getDefaultInstanceForType() {
      return com.google.devtools.cloudprofiler.v2.Profile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.cloudprofiler.v2.Profile build() {
      com.google.devtools.cloudprofiler.v2.Profile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.cloudprofiler.v2.Profile buildPartial() {
      com.google.devtools.cloudprofiler.v2.Profile result =
          new com.google.devtools.cloudprofiler.v2.Profile(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.devtools.cloudprofiler.v2.Profile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.profileType_ = profileType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.deployment_ = deploymentBuilder_ == null ? deployment_ : deploymentBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.profileBytes_ = profileBytes_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.cloudprofiler.v2.Profile) {
        return mergeFrom((com.google.devtools.cloudprofiler.v2.Profile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.cloudprofiler.v2.Profile other) {
      if (other == com.google.devtools.cloudprofiler.v2.Profile.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.profileType_ != 0) {
        setProfileTypeValue(other.getProfileTypeValue());
      }
      if (other.hasDeployment()) {
        mergeDeployment(other.getDeployment());
      }
      if (other.hasDuration()) {
        mergeDuration(other.getDuration());
      }
      if (other.getProfileBytes() != com.google.protobuf.ByteString.EMPTY) {
        setProfileBytes(other.getProfileBytes());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000020;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                profileType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getDeploymentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                profileBytes_ = input.readBytes();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Opaque, server-assigned, unique ID for this profile.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Opaque, server-assigned, unique ID for this profile.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Opaque, server-assigned, unique ID for this profile.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Opaque, server-assigned, unique ID for this profile.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Opaque, server-assigned, unique ID for this profile.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int profileType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of profile.
     * For offline mode, this must be specified when creating the profile. For
     * online mode it is assigned and returned by the server.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @return The enum numeric value on the wire for profileType.
     */
    @java.lang.Override
    public int getProfileTypeValue() {
      return profileType_;
    }
    /**
     *
     *
     * <pre>
     * Type of profile.
     * For offline mode, this must be specified when creating the profile. For
     * online mode it is assigned and returned by the server.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @param value The enum numeric value on the wire for profileType to set.
     * @return This builder for chaining.
     */
    public Builder setProfileTypeValue(int value) {
      profileType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of profile.
     * For offline mode, this must be specified when creating the profile. For
     * online mode it is assigned and returned by the server.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @return The profileType.
     */
    @java.lang.Override
    public com.google.devtools.cloudprofiler.v2.ProfileType getProfileType() {
      com.google.devtools.cloudprofiler.v2.ProfileType result =
          com.google.devtools.cloudprofiler.v2.ProfileType.forNumber(profileType_);
      return result == null
          ? com.google.devtools.cloudprofiler.v2.ProfileType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of profile.
     * For offline mode, this must be specified when creating the profile. For
     * online mode it is assigned and returned by the server.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @param value The profileType to set.
     * @return This builder for chaining.
     */
    public Builder setProfileType(com.google.devtools.cloudprofiler.v2.ProfileType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      profileType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of profile.
     * For offline mode, this must be specified when creating the profile. For
     * online mode it is assigned and returned by the server.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.ProfileType profile_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProfileType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      profileType_ = 0;
      onChanged();
      return this;
    }

    private com.google.devtools.cloudprofiler.v2.Deployment deployment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.cloudprofiler.v2.Deployment,
            com.google.devtools.cloudprofiler.v2.Deployment.Builder,
            com.google.devtools.cloudprofiler.v2.DeploymentOrBuilder>
        deploymentBuilder_;
    /**
     *
     *
     * <pre>
     * Deployment this profile corresponds to.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 3;</code>
     *
     * @return Whether the deployment field is set.
     */
    public boolean hasDeployment() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Deployment this profile corresponds to.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 3;</code>
     *
     * @return The deployment.
     */
    public com.google.devtools.cloudprofiler.v2.Deployment getDeployment() {
      if (deploymentBuilder_ == null) {
        return deployment_ == null
            ? com.google.devtools.cloudprofiler.v2.Deployment.getDefaultInstance()
            : deployment_;
      } else {
        return deploymentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Deployment this profile corresponds to.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 3;</code>
     */
    public Builder setDeployment(com.google.devtools.cloudprofiler.v2.Deployment value) {
      if (deploymentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deployment_ = value;
      } else {
        deploymentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment this profile corresponds to.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 3;</code>
     */
    public Builder setDeployment(
        com.google.devtools.cloudprofiler.v2.Deployment.Builder builderForValue) {
      if (deploymentBuilder_ == null) {
        deployment_ = builderForValue.build();
      } else {
        deploymentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment this profile corresponds to.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 3;</code>
     */
    public Builder mergeDeployment(com.google.devtools.cloudprofiler.v2.Deployment value) {
      if (deploymentBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && deployment_ != null
            && deployment_
                != com.google.devtools.cloudprofiler.v2.Deployment.getDefaultInstance()) {
          getDeploymentBuilder().mergeFrom(value);
        } else {
          deployment_ = value;
        }
      } else {
        deploymentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment this profile corresponds to.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 3;</code>
     */
    public Builder clearDeployment() {
      bitField0_ = (bitField0_ & ~0x00000004);
      deployment_ = null;
      if (deploymentBuilder_ != null) {
        deploymentBuilder_.dispose();
        deploymentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deployment this profile corresponds to.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 3;</code>
     */
    public com.google.devtools.cloudprofiler.v2.Deployment.Builder getDeploymentBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDeploymentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Deployment this profile corresponds to.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 3;</code>
     */
    public com.google.devtools.cloudprofiler.v2.DeploymentOrBuilder getDeploymentOrBuilder() {
      if (deploymentBuilder_ != null) {
        return deploymentBuilder_.getMessageOrBuilder();
      } else {
        return deployment_ == null
            ? com.google.devtools.cloudprofiler.v2.Deployment.getDefaultInstance()
            : deployment_;
      }
    }
    /**
     *
     *
     * <pre>
     * Deployment this profile corresponds to.
     * </pre>
     *
     * <code>.google.devtools.cloudprofiler.v2.Deployment deployment = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.cloudprofiler.v2.Deployment,
            com.google.devtools.cloudprofiler.v2.Deployment.Builder,
            com.google.devtools.cloudprofiler.v2.DeploymentOrBuilder>
        getDeploymentFieldBuilder() {
      if (deploymentBuilder_ == null) {
        deploymentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.devtools.cloudprofiler.v2.Deployment,
                com.google.devtools.cloudprofiler.v2.Deployment.Builder,
                com.google.devtools.cloudprofiler.v2.DeploymentOrBuilder>(
                getDeployment(), getParentForChildren(), isClean());
        deployment_ = null;
      }
      return deploymentBuilder_;
    }

    private com.google.protobuf.Duration duration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        durationBuilder_;
    /**
     *
     *
     * <pre>
     * Duration of the profiling session.
     * Input (for the offline mode) or output (for the online mode).
     * The field represents requested profiling duration. It may slightly differ
     * from the effective profiling duration, which is recorded in the profile
     * data, in case the profiling can't be stopped immediately (e.g. in case
     * stopping the profiling is handled asynchronously).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 4;</code>
     *
     * @return Whether the duration field is set.
     */
    public boolean hasDuration() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Duration of the profiling session.
     * Input (for the offline mode) or output (for the online mode).
     * The field represents requested profiling duration. It may slightly differ
     * from the effective profiling duration, which is recorded in the profile
     * data, in case the profiling can't be stopped immediately (e.g. in case
     * stopping the profiling is handled asynchronously).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 4;</code>
     *
     * @return The duration.
     */
    public com.google.protobuf.Duration getDuration() {
      if (durationBuilder_ == null) {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      } else {
        return durationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Duration of the profiling session.
     * Input (for the offline mode) or output (for the online mode).
     * The field represents requested profiling duration. It may slightly differ
     * from the effective profiling duration, which is recorded in the profile
     * data, in case the profiling can't be stopped immediately (e.g. in case
     * stopping the profiling is handled asynchronously).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 4;</code>
     */
    public Builder setDuration(com.google.protobuf.Duration value) {
      if (durationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        duration_ = value;
      } else {
        durationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration of the profiling session.
     * Input (for the offline mode) or output (for the online mode).
     * The field represents requested profiling duration. It may slightly differ
     * from the effective profiling duration, which is recorded in the profile
     * data, in case the profiling can't be stopped immediately (e.g. in case
     * stopping the profiling is handled asynchronously).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 4;</code>
     */
    public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (durationBuilder_ == null) {
        duration_ = builderForValue.build();
      } else {
        durationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration of the profiling session.
     * Input (for the offline mode) or output (for the online mode).
     * The field represents requested profiling duration. It may slightly differ
     * from the effective profiling duration, which is recorded in the profile
     * data, in case the profiling can't be stopped immediately (e.g. in case
     * stopping the profiling is handled asynchronously).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 4;</code>
     */
    public Builder mergeDuration(com.google.protobuf.Duration value) {
      if (durationBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && duration_ != null
            && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getDurationBuilder().mergeFrom(value);
        } else {
          duration_ = value;
        }
      } else {
        durationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration of the profiling session.
     * Input (for the offline mode) or output (for the online mode).
     * The field represents requested profiling duration. It may slightly differ
     * from the effective profiling duration, which is recorded in the profile
     * data, in case the profiling can't be stopped immediately (e.g. in case
     * stopping the profiling is handled asynchronously).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 4;</code>
     */
    public Builder clearDuration() {
      bitField0_ = (bitField0_ & ~0x00000008);
      duration_ = null;
      if (durationBuilder_ != null) {
        durationBuilder_.dispose();
        durationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration of the profiling session.
     * Input (for the offline mode) or output (for the online mode).
     * The field represents requested profiling duration. It may slightly differ
     * from the effective profiling duration, which is recorded in the profile
     * data, in case the profiling can't be stopped immediately (e.g. in case
     * stopping the profiling is handled asynchronously).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getDurationBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Duration of the profiling session.
     * Input (for the offline mode) or output (for the online mode).
     * The field represents requested profiling duration. It may slightly differ
     * from the effective profiling duration, which is recorded in the profile
     * data, in case the profiling can't be stopped immediately (e.g. in case
     * stopping the profiling is handled asynchronously).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
      if (durationBuilder_ != null) {
        return durationBuilder_.getMessageOrBuilder();
      } else {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Duration of the profiling session.
     * Input (for the offline mode) or output (for the online mode).
     * The field represents requested profiling duration. It may slightly differ
     * from the effective profiling duration, which is recorded in the profile
     * data, in case the profiling can't be stopped immediately (e.g. in case
     * stopping the profiling is handled asynchronously).
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDurationFieldBuilder() {
      if (durationBuilder_ == null) {
        durationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDuration(), getParentForChildren(), isClean());
        duration_ = null;
      }
      return durationBuilder_;
    }

    private com.google.protobuf.ByteString profileBytes_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Input only. Profile bytes, as a gzip compressed serialized proto, the
     * format is https://github.com/google/pprof/blob/master/proto/profile.proto.
     * </pre>
     *
     * <code>bytes profile_bytes = 5 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The profileBytes.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProfileBytes() {
      return profileBytes_;
    }
    /**
     *
     *
     * <pre>
     * Input only. Profile bytes, as a gzip compressed serialized proto, the
     * format is https://github.com/google/pprof/blob/master/proto/profile.proto.
     * </pre>
     *
     * <code>bytes profile_bytes = 5 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The profileBytes to set.
     * @return This builder for chaining.
     */
    public Builder setProfileBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      profileBytes_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Profile bytes, as a gzip compressed serialized proto, the
     * format is https://github.com/google/pprof/blob/master/proto/profile.proto.
     * </pre>
     *
     * <code>bytes profile_bytes = 5 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProfileBytes() {
      bitField0_ = (bitField0_ & ~0x00000010);
      profileBytes_ = getDefaultInstance().getProfileBytes();
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Input only. Labels associated to this specific profile. These labels will
     * get merged with the deployment labels for the final data set. See
     * documentation on deployment labels for validation rules and limits.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Input only. Labels associated to this specific profile. These labels will
     * get merged with the deployment labels for the final data set. See
     * documentation on deployment labels for validation rules and limits.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Input only. Labels associated to this specific profile. These labels will
     * get merged with the deployment labels for the final data set. See
     * documentation on deployment labels for validation rules and limits.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Input only. Labels associated to this specific profile. These labels will
     * get merged with the deployment labels for the final data set. See
     * documentation on deployment labels for validation rules and limits.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Labels associated to this specific profile. These labels will
     * get merged with the deployment labels for the final data set. See
     * documentation on deployment labels for validation rules and limits.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Input only. Labels associated to this specific profile. These labels will
     * get merged with the deployment labels for the final data set. See
     * documentation on deployment labels for validation rules and limits.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Labels associated to this specific profile. These labels will
     * get merged with the deployment labels for the final data set. See
     * documentation on deployment labels for validation rules and limits.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudprofiler.v2.Profile)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudprofiler.v2.Profile)
  private static final com.google.devtools.cloudprofiler.v2.Profile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.devtools.cloudprofiler.v2.Profile();
  }

  public static com.google.devtools.cloudprofiler.v2.Profile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Profile> PARSER =
      new com.google.protobuf.AbstractParser<Profile>() {
        @java.lang.Override
        public Profile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Profile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Profile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.cloudprofiler.v2.Profile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
