/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudprofiler/v2/profiler.proto

package com.google.devtools.cloudprofiler.v2;

/**
 *
 *
 * <pre>
 * ProfileType is type of profiling data.
 * NOTE: the enumeration member names are used (in lowercase) as unique string
 * identifiers of profile types, so they must not be renamed.
 * </pre>
 *
 * Protobuf enum {@code google.devtools.cloudprofiler.v2.ProfileType}
 */
public enum ProfileType implements com.google.protobuf.ProtocolMessageEnum {
  /**
   *
   *
   * <pre>
   * Unspecified profile type.
   * </pre>
   *
   * <code>PROFILE_TYPE_UNSPECIFIED = 0;</code>
   */
  PROFILE_TYPE_UNSPECIFIED(0),
  /**
   *
   *
   * <pre>
   * Thread CPU time sampling.
   * </pre>
   *
   * <code>CPU = 1;</code>
   */
  CPU(1),
  /**
   *
   *
   * <pre>
   * Wallclock time sampling. More expensive as stops all threads.
   * </pre>
   *
   * <code>WALL = 2;</code>
   */
  WALL(2),
  /**
   *
   *
   * <pre>
   * In-use heap profile. Represents a snapshot of the allocations that are
   * live at the time of the profiling.
   * </pre>
   *
   * <code>HEAP = 3;</code>
   */
  HEAP(3),
  /**
   *
   *
   * <pre>
   * Single-shot collection of all thread stacks.
   * </pre>
   *
   * <code>THREADS = 4;</code>
   */
  THREADS(4),
  /**
   *
   *
   * <pre>
   * Synchronization contention profile.
   * </pre>
   *
   * <code>CONTENTION = 5;</code>
   */
  CONTENTION(5),
  /**
   *
   *
   * <pre>
   * Peak heap profile.
   * </pre>
   *
   * <code>PEAK_HEAP = 6;</code>
   */
  PEAK_HEAP(6),
  /**
   *
   *
   * <pre>
   * Heap allocation profile. It represents the aggregation of all allocations
   * made over the duration of the profile. All allocations are included,
   * including those that might have been freed by the end of the profiling
   * interval. The profile is in particular useful for garbage collecting
   * languages to understand which parts of the code create most of the garbage
   * collection pressure to see if those can be optimized.
   * </pre>
   *
   * <code>HEAP_ALLOC = 7;</code>
   */
  HEAP_ALLOC(7),
  UNRECOGNIZED(-1),
  ;

  /**
   *
   *
   * <pre>
   * Unspecified profile type.
   * </pre>
   *
   * <code>PROFILE_TYPE_UNSPECIFIED = 0;</code>
   */
  public static final int PROFILE_TYPE_UNSPECIFIED_VALUE = 0;
  /**
   *
   *
   * <pre>
   * Thread CPU time sampling.
   * </pre>
   *
   * <code>CPU = 1;</code>
   */
  public static final int CPU_VALUE = 1;
  /**
   *
   *
   * <pre>
   * Wallclock time sampling. More expensive as stops all threads.
   * </pre>
   *
   * <code>WALL = 2;</code>
   */
  public static final int WALL_VALUE = 2;
  /**
   *
   *
   * <pre>
   * In-use heap profile. Represents a snapshot of the allocations that are
   * live at the time of the profiling.
   * </pre>
   *
   * <code>HEAP = 3;</code>
   */
  public static final int HEAP_VALUE = 3;
  /**
   *
   *
   * <pre>
   * Single-shot collection of all thread stacks.
   * </pre>
   *
   * <code>THREADS = 4;</code>
   */
  public static final int THREADS_VALUE = 4;
  /**
   *
   *
   * <pre>
   * Synchronization contention profile.
   * </pre>
   *
   * <code>CONTENTION = 5;</code>
   */
  public static final int CONTENTION_VALUE = 5;
  /**
   *
   *
   * <pre>
   * Peak heap profile.
   * </pre>
   *
   * <code>PEAK_HEAP = 6;</code>
   */
  public static final int PEAK_HEAP_VALUE = 6;
  /**
   *
   *
   * <pre>
   * Heap allocation profile. It represents the aggregation of all allocations
   * made over the duration of the profile. All allocations are included,
   * including those that might have been freed by the end of the profiling
   * interval. The profile is in particular useful for garbage collecting
   * languages to understand which parts of the code create most of the garbage
   * collection pressure to see if those can be optimized.
   * </pre>
   *
   * <code>HEAP_ALLOC = 7;</code>
   */
  public static final int HEAP_ALLOC_VALUE = 7;

  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static ProfileType valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static ProfileType forNumber(int value) {
    switch (value) {
      case 0:
        return PROFILE_TYPE_UNSPECIFIED;
      case 1:
        return CPU;
      case 2:
        return WALL;
      case 3:
        return HEAP;
      case 4:
        return THREADS;
      case 5:
        return CONTENTION;
      case 6:
        return PEAK_HEAP;
      case 7:
        return HEAP_ALLOC;
      default:
        return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<ProfileType> internalGetValueMap() {
    return internalValueMap;
  }

  private static final com.google.protobuf.Internal.EnumLiteMap<ProfileType> internalValueMap =
      new com.google.protobuf.Internal.EnumLiteMap<ProfileType>() {
        public ProfileType findValueByNumber(int number) {
          return ProfileType.forNumber(number);
        }
      };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalStateException(
          "Can't get the descriptor of an unrecognized enum value.");
    }
    return getDescriptor().getValues().get(ordinal());
  }

  public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
    return getDescriptor();
  }

  public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
    return com.google.devtools.cloudprofiler.v2.ProfilerProto.getDescriptor().getEnumTypes().get(0);
  }

  private static final ProfileType[] VALUES = values();

  public static ProfileType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private ProfileType(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.devtools.cloudprofiler.v2.ProfileType)
}
