/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * Request for the `StreamingPull` streaming RPC method. This request is used to
 * establish the initial stream as well as to stream acknowledgements and ack
 * deadline modifications from the client to the server.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.StreamingPullRequest}
 */
public final class StreamingPullRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.StreamingPullRequest)
    StreamingPullRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamingPullRequest.newBuilder() to construct.
  private StreamingPullRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingPullRequest() {
    subscription_ = "";
    ackIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    modifyDeadlineSeconds_ = emptyIntList();
    modifyDeadlineAckIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    clientId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingPullRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_StreamingPullRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_StreamingPullRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.StreamingPullRequest.class,
            com.google.pubsub.v1.StreamingPullRequest.Builder.class);
  }

  public static final int SUBSCRIPTION_FIELD_NUMBER = 1;
  private volatile java.lang.Object subscription_;
  /**
   *
   *
   * <pre>
   * Required. The subscription for which to initialize the new stream. This
   * must be provided in the first request on the stream, and must not be set in
   * subsequent requests from client to server.
   * Format is `projects/{project}/subscriptions/{sub}`.
   * </pre>
   *
   * <code>
   * string subscription = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The subscription.
   */
  @java.lang.Override
  public java.lang.String getSubscription() {
    java.lang.Object ref = subscription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subscription_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The subscription for which to initialize the new stream. This
   * must be provided in the first request on the stream, and must not be set in
   * subsequent requests from client to server.
   * Format is `projects/{project}/subscriptions/{sub}`.
   * </pre>
   *
   * <code>
   * string subscription = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for subscription.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubscriptionBytes() {
    java.lang.Object ref = subscription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subscription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACK_IDS_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList ackIds_;
  /**
   *
   *
   * <pre>
   * List of acknowledgement IDs for acknowledging previously received messages
   * (received on this stream or a different stream). If an ack ID has expired,
   * the corresponding message may be redelivered later. Acknowledging a message
   * more than once will not result in an error. If the acknowledgement ID is
   * malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated string ack_ids = 2;</code>
   *
   * @return A list containing the ackIds.
   */
  public com.google.protobuf.ProtocolStringList getAckIdsList() {
    return ackIds_;
  }
  /**
   *
   *
   * <pre>
   * List of acknowledgement IDs for acknowledging previously received messages
   * (received on this stream or a different stream). If an ack ID has expired,
   * the corresponding message may be redelivered later. Acknowledging a message
   * more than once will not result in an error. If the acknowledgement ID is
   * malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated string ack_ids = 2;</code>
   *
   * @return The count of ackIds.
   */
  public int getAckIdsCount() {
    return ackIds_.size();
  }
  /**
   *
   *
   * <pre>
   * List of acknowledgement IDs for acknowledging previously received messages
   * (received on this stream or a different stream). If an ack ID has expired,
   * the corresponding message may be redelivered later. Acknowledging a message
   * more than once will not result in an error. If the acknowledgement ID is
   * malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated string ack_ids = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The ackIds at the given index.
   */
  public java.lang.String getAckIds(int index) {
    return ackIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of acknowledgement IDs for acknowledging previously received messages
   * (received on this stream or a different stream). If an ack ID has expired,
   * the corresponding message may be redelivered later. Acknowledging a message
   * more than once will not result in an error. If the acknowledgement ID is
   * malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated string ack_ids = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ackIds at the given index.
   */
  public com.google.protobuf.ByteString getAckIdsBytes(int index) {
    return ackIds_.getByteString(index);
  }

  public static final int MODIFY_DEADLINE_SECONDS_FIELD_NUMBER = 3;
  private com.google.protobuf.Internal.IntList modifyDeadlineSeconds_;
  /**
   *
   *
   * <pre>
   * The list of new ack deadlines for the IDs listed in
   * `modify_deadline_ack_ids`. The size of this list must be the same as the
   * size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
   * with `INVALID_ARGUMENT`. Each element in this list is applied to the
   * element in the same position in `modify_deadline_ack_ids`. The new ack
   * deadline is with respect to the time this request was sent to the Pub/Sub
   * system. Must be &gt;= 0. For example, if the value is 10, the new ack deadline
   * will expire 10 seconds after this request is received. If the value is 0,
   * the message is immediately made available for another streaming or
   * non-streaming pull request. If the value is &lt; 0 (an error), the stream will
   * be aborted with status `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated int32 modify_deadline_seconds = 3;</code>
   *
   * @return A list containing the modifyDeadlineSeconds.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getModifyDeadlineSecondsList() {
    return modifyDeadlineSeconds_;
  }
  /**
   *
   *
   * <pre>
   * The list of new ack deadlines for the IDs listed in
   * `modify_deadline_ack_ids`. The size of this list must be the same as the
   * size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
   * with `INVALID_ARGUMENT`. Each element in this list is applied to the
   * element in the same position in `modify_deadline_ack_ids`. The new ack
   * deadline is with respect to the time this request was sent to the Pub/Sub
   * system. Must be &gt;= 0. For example, if the value is 10, the new ack deadline
   * will expire 10 seconds after this request is received. If the value is 0,
   * the message is immediately made available for another streaming or
   * non-streaming pull request. If the value is &lt; 0 (an error), the stream will
   * be aborted with status `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated int32 modify_deadline_seconds = 3;</code>
   *
   * @return The count of modifyDeadlineSeconds.
   */
  public int getModifyDeadlineSecondsCount() {
    return modifyDeadlineSeconds_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of new ack deadlines for the IDs listed in
   * `modify_deadline_ack_ids`. The size of this list must be the same as the
   * size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
   * with `INVALID_ARGUMENT`. Each element in this list is applied to the
   * element in the same position in `modify_deadline_ack_ids`. The new ack
   * deadline is with respect to the time this request was sent to the Pub/Sub
   * system. Must be &gt;= 0. For example, if the value is 10, the new ack deadline
   * will expire 10 seconds after this request is received. If the value is 0,
   * the message is immediately made available for another streaming or
   * non-streaming pull request. If the value is &lt; 0 (an error), the stream will
   * be aborted with status `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated int32 modify_deadline_seconds = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The modifyDeadlineSeconds at the given index.
   */
  public int getModifyDeadlineSeconds(int index) {
    return modifyDeadlineSeconds_.getInt(index);
  }

  private int modifyDeadlineSecondsMemoizedSerializedSize = -1;

  public static final int MODIFY_DEADLINE_ACK_IDS_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList modifyDeadlineAckIds_;
  /**
   *
   *
   * <pre>
   * List of acknowledgement IDs whose deadline will be modified based on the
   * corresponding element in `modify_deadline_seconds`. This field can be used
   * to indicate that more time is needed to process a message by the
   * subscriber, or to make the message available for redelivery if the
   * processing was interrupted.
   * </pre>
   *
   * <code>repeated string modify_deadline_ack_ids = 4;</code>
   *
   * @return A list containing the modifyDeadlineAckIds.
   */
  public com.google.protobuf.ProtocolStringList getModifyDeadlineAckIdsList() {
    return modifyDeadlineAckIds_;
  }
  /**
   *
   *
   * <pre>
   * List of acknowledgement IDs whose deadline will be modified based on the
   * corresponding element in `modify_deadline_seconds`. This field can be used
   * to indicate that more time is needed to process a message by the
   * subscriber, or to make the message available for redelivery if the
   * processing was interrupted.
   * </pre>
   *
   * <code>repeated string modify_deadline_ack_ids = 4;</code>
   *
   * @return The count of modifyDeadlineAckIds.
   */
  public int getModifyDeadlineAckIdsCount() {
    return modifyDeadlineAckIds_.size();
  }
  /**
   *
   *
   * <pre>
   * List of acknowledgement IDs whose deadline will be modified based on the
   * corresponding element in `modify_deadline_seconds`. This field can be used
   * to indicate that more time is needed to process a message by the
   * subscriber, or to make the message available for redelivery if the
   * processing was interrupted.
   * </pre>
   *
   * <code>repeated string modify_deadline_ack_ids = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The modifyDeadlineAckIds at the given index.
   */
  public java.lang.String getModifyDeadlineAckIds(int index) {
    return modifyDeadlineAckIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of acknowledgement IDs whose deadline will be modified based on the
   * corresponding element in `modify_deadline_seconds`. This field can be used
   * to indicate that more time is needed to process a message by the
   * subscriber, or to make the message available for redelivery if the
   * processing was interrupted.
   * </pre>
   *
   * <code>repeated string modify_deadline_ack_ids = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the modifyDeadlineAckIds at the given index.
   */
  public com.google.protobuf.ByteString getModifyDeadlineAckIdsBytes(int index) {
    return modifyDeadlineAckIds_.getByteString(index);
  }

  public static final int STREAM_ACK_DEADLINE_SECONDS_FIELD_NUMBER = 5;
  private int streamAckDeadlineSeconds_;
  /**
   *
   *
   * <pre>
   * Required. The ack deadline to use for the stream. This must be provided in
   * the first request on the stream, but it can also be updated on subsequent
   * requests from client to server. The minimum deadline you can specify is 10
   * seconds. The maximum deadline you can specify is 600 seconds (10 minutes).
   * </pre>
   *
   * <code>int32 stream_ack_deadline_seconds = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The streamAckDeadlineSeconds.
   */
  @java.lang.Override
  public int getStreamAckDeadlineSeconds() {
    return streamAckDeadlineSeconds_;
  }

  public static final int CLIENT_ID_FIELD_NUMBER = 6;
  private volatile java.lang.Object clientId_;
  /**
   *
   *
   * <pre>
   * A unique identifier that is used to distinguish client instances from each
   * other. Only needs to be provided on the initial request. When a stream
   * disconnects and reconnects for the same stream, the client_id should be set
   * to the same value so that state associated with the old stream can be
   * transferred to the new stream. The same client_id should not be used for
   * different client instances.
   * </pre>
   *
   * <code>string client_id = 6;</code>
   *
   * @return The clientId.
   */
  @java.lang.Override
  public java.lang.String getClientId() {
    java.lang.Object ref = clientId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique identifier that is used to distinguish client instances from each
   * other. Only needs to be provided on the initial request. When a stream
   * disconnects and reconnects for the same stream, the client_id should be set
   * to the same value so that state associated with the old stream can be
   * transferred to the new stream. The same client_id should not be used for
   * different client instances.
   * </pre>
   *
   * <code>string client_id = 6;</code>
   *
   * @return The bytes for clientId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientIdBytes() {
    java.lang.Object ref = clientId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_OUTSTANDING_MESSAGES_FIELD_NUMBER = 7;
  private long maxOutstandingMessages_;
  /**
   *
   *
   * <pre>
   * Flow control settings for the maximum number of outstanding messages. When
   * there are `max_outstanding_messages` or more currently sent to the
   * streaming pull client that have not yet been acked or nacked, the server
   * stops sending more messages. The sending of messages resumes once the
   * number of outstanding messages is less than this value. If the value is
   * &lt;= 0, there is no limit to the number of outstanding messages. This
   * property can only be set on the initial StreamingPullRequest. If it is set
   * on a subsequent request, the stream will be aborted with status
   * `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>int64 max_outstanding_messages = 7;</code>
   *
   * @return The maxOutstandingMessages.
   */
  @java.lang.Override
  public long getMaxOutstandingMessages() {
    return maxOutstandingMessages_;
  }

  public static final int MAX_OUTSTANDING_BYTES_FIELD_NUMBER = 8;
  private long maxOutstandingBytes_;
  /**
   *
   *
   * <pre>
   * Flow control settings for the maximum number of outstanding bytes. When
   * there are `max_outstanding_bytes` or more worth of messages currently sent
   * to the streaming pull client that have not yet been acked or nacked, the
   * server will stop sending more messages. The sending of messages resumes
   * once the number of outstanding bytes is less than this value. If the value
   * is &lt;= 0, there is no limit to the number of outstanding bytes. This
   * property can only be set on the initial StreamingPullRequest. If it is set
   * on a subsequent request, the stream will be aborted with status
   * `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>int64 max_outstanding_bytes = 8;</code>
   *
   * @return The maxOutstandingBytes.
   */
  @java.lang.Override
  public long getMaxOutstandingBytes() {
    return maxOutstandingBytes_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subscription_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, subscription_);
    }
    for (int i = 0; i < ackIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, ackIds_.getRaw(i));
    }
    if (getModifyDeadlineSecondsList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(modifyDeadlineSecondsMemoizedSerializedSize);
    }
    for (int i = 0; i < modifyDeadlineSeconds_.size(); i++) {
      output.writeInt32NoTag(modifyDeadlineSeconds_.getInt(i));
    }
    for (int i = 0; i < modifyDeadlineAckIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 4, modifyDeadlineAckIds_.getRaw(i));
    }
    if (streamAckDeadlineSeconds_ != 0) {
      output.writeInt32(5, streamAckDeadlineSeconds_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, clientId_);
    }
    if (maxOutstandingMessages_ != 0L) {
      output.writeInt64(7, maxOutstandingMessages_);
    }
    if (maxOutstandingBytes_ != 0L) {
      output.writeInt64(8, maxOutstandingBytes_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subscription_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, subscription_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < ackIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(ackIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAckIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < modifyDeadlineSeconds_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(
                modifyDeadlineSeconds_.getInt(i));
      }
      size += dataSize;
      if (!getModifyDeadlineSecondsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      modifyDeadlineSecondsMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < modifyDeadlineAckIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(modifyDeadlineAckIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getModifyDeadlineAckIdsList().size();
    }
    if (streamAckDeadlineSeconds_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, streamAckDeadlineSeconds_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, clientId_);
    }
    if (maxOutstandingMessages_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, maxOutstandingMessages_);
    }
    if (maxOutstandingBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, maxOutstandingBytes_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.StreamingPullRequest)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.StreamingPullRequest other =
        (com.google.pubsub.v1.StreamingPullRequest) obj;

    if (!getSubscription().equals(other.getSubscription())) return false;
    if (!getAckIdsList().equals(other.getAckIdsList())) return false;
    if (!getModifyDeadlineSecondsList().equals(other.getModifyDeadlineSecondsList())) return false;
    if (!getModifyDeadlineAckIdsList().equals(other.getModifyDeadlineAckIdsList())) return false;
    if (getStreamAckDeadlineSeconds() != other.getStreamAckDeadlineSeconds()) return false;
    if (!getClientId().equals(other.getClientId())) return false;
    if (getMaxOutstandingMessages() != other.getMaxOutstandingMessages()) return false;
    if (getMaxOutstandingBytes() != other.getMaxOutstandingBytes()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SUBSCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getSubscription().hashCode();
    if (getAckIdsCount() > 0) {
      hash = (37 * hash) + ACK_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getAckIdsList().hashCode();
    }
    if (getModifyDeadlineSecondsCount() > 0) {
      hash = (37 * hash) + MODIFY_DEADLINE_SECONDS_FIELD_NUMBER;
      hash = (53 * hash) + getModifyDeadlineSecondsList().hashCode();
    }
    if (getModifyDeadlineAckIdsCount() > 0) {
      hash = (37 * hash) + MODIFY_DEADLINE_ACK_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getModifyDeadlineAckIdsList().hashCode();
    }
    hash = (37 * hash) + STREAM_ACK_DEADLINE_SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + getStreamAckDeadlineSeconds();
    hash = (37 * hash) + CLIENT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getClientId().hashCode();
    hash = (37 * hash) + MAX_OUTSTANDING_MESSAGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxOutstandingMessages());
    hash = (37 * hash) + MAX_OUTSTANDING_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxOutstandingBytes());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.StreamingPullRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.StreamingPullRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.StreamingPullRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.StreamingPullRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.StreamingPullRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.StreamingPullRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.StreamingPullRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.StreamingPullRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.StreamingPullRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.StreamingPullRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.StreamingPullRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.StreamingPullRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.StreamingPullRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request for the `StreamingPull` streaming RPC method. This request is used to
   * establish the initial stream as well as to stream acknowledgements and ack
   * deadline modifications from the client to the server.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.StreamingPullRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.StreamingPullRequest)
      com.google.pubsub.v1.StreamingPullRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_StreamingPullRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_StreamingPullRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.StreamingPullRequest.class,
              com.google.pubsub.v1.StreamingPullRequest.Builder.class);
    }

    // Construct using com.google.pubsub.v1.StreamingPullRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      subscription_ = "";

      ackIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      modifyDeadlineSeconds_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000002);
      modifyDeadlineAckIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      streamAckDeadlineSeconds_ = 0;

      clientId_ = "";

      maxOutstandingMessages_ = 0L;

      maxOutstandingBytes_ = 0L;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_StreamingPullRequest_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.StreamingPullRequest getDefaultInstanceForType() {
      return com.google.pubsub.v1.StreamingPullRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.StreamingPullRequest build() {
      com.google.pubsub.v1.StreamingPullRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.StreamingPullRequest buildPartial() {
      com.google.pubsub.v1.StreamingPullRequest result =
          new com.google.pubsub.v1.StreamingPullRequest(this);
      int from_bitField0_ = bitField0_;
      result.subscription_ = subscription_;
      if (((bitField0_ & 0x00000001) != 0)) {
        ackIds_ = ackIds_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.ackIds_ = ackIds_;
      if (((bitField0_ & 0x00000002) != 0)) {
        modifyDeadlineSeconds_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.modifyDeadlineSeconds_ = modifyDeadlineSeconds_;
      if (((bitField0_ & 0x00000004) != 0)) {
        modifyDeadlineAckIds_ = modifyDeadlineAckIds_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.modifyDeadlineAckIds_ = modifyDeadlineAckIds_;
      result.streamAckDeadlineSeconds_ = streamAckDeadlineSeconds_;
      result.clientId_ = clientId_;
      result.maxOutstandingMessages_ = maxOutstandingMessages_;
      result.maxOutstandingBytes_ = maxOutstandingBytes_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.StreamingPullRequest) {
        return mergeFrom((com.google.pubsub.v1.StreamingPullRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.StreamingPullRequest other) {
      if (other == com.google.pubsub.v1.StreamingPullRequest.getDefaultInstance()) return this;
      if (!other.getSubscription().isEmpty()) {
        subscription_ = other.subscription_;
        onChanged();
      }
      if (!other.ackIds_.isEmpty()) {
        if (ackIds_.isEmpty()) {
          ackIds_ = other.ackIds_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureAckIdsIsMutable();
          ackIds_.addAll(other.ackIds_);
        }
        onChanged();
      }
      if (!other.modifyDeadlineSeconds_.isEmpty()) {
        if (modifyDeadlineSeconds_.isEmpty()) {
          modifyDeadlineSeconds_ = other.modifyDeadlineSeconds_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureModifyDeadlineSecondsIsMutable();
          modifyDeadlineSeconds_.addAll(other.modifyDeadlineSeconds_);
        }
        onChanged();
      }
      if (!other.modifyDeadlineAckIds_.isEmpty()) {
        if (modifyDeadlineAckIds_.isEmpty()) {
          modifyDeadlineAckIds_ = other.modifyDeadlineAckIds_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureModifyDeadlineAckIdsIsMutable();
          modifyDeadlineAckIds_.addAll(other.modifyDeadlineAckIds_);
        }
        onChanged();
      }
      if (other.getStreamAckDeadlineSeconds() != 0) {
        setStreamAckDeadlineSeconds(other.getStreamAckDeadlineSeconds());
      }
      if (!other.getClientId().isEmpty()) {
        clientId_ = other.clientId_;
        onChanged();
      }
      if (other.getMaxOutstandingMessages() != 0L) {
        setMaxOutstandingMessages(other.getMaxOutstandingMessages());
      }
      if (other.getMaxOutstandingBytes() != 0L) {
        setMaxOutstandingBytes(other.getMaxOutstandingBytes());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                subscription_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAckIdsIsMutable();
                ackIds_.add(s);
                break;
              } // case 18
            case 24:
              {
                int v = input.readInt32();
                ensureModifyDeadlineSecondsIsMutable();
                modifyDeadlineSeconds_.addInt(v);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureModifyDeadlineSecondsIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  modifyDeadlineSeconds_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureModifyDeadlineAckIdsIsMutable();
                modifyDeadlineAckIds_.add(s);
                break;
              } // case 34
            case 40:
              {
                streamAckDeadlineSeconds_ = input.readInt32();

                break;
              } // case 40
            case 50:
              {
                clientId_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 56:
              {
                maxOutstandingMessages_ = input.readInt64();

                break;
              } // case 56
            case 64:
              {
                maxOutstandingBytes_ = input.readInt64();

                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object subscription_ = "";
    /**
     *
     *
     * <pre>
     * Required. The subscription for which to initialize the new stream. This
     * must be provided in the first request on the stream, and must not be set in
     * subsequent requests from client to server.
     * Format is `projects/{project}/subscriptions/{sub}`.
     * </pre>
     *
     * <code>
     * string subscription = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The subscription.
     */
    public java.lang.String getSubscription() {
      java.lang.Object ref = subscription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subscription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The subscription for which to initialize the new stream. This
     * must be provided in the first request on the stream, and must not be set in
     * subsequent requests from client to server.
     * Format is `projects/{project}/subscriptions/{sub}`.
     * </pre>
     *
     * <code>
     * string subscription = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for subscription.
     */
    public com.google.protobuf.ByteString getSubscriptionBytes() {
      java.lang.Object ref = subscription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subscription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The subscription for which to initialize the new stream. This
     * must be provided in the first request on the stream, and must not be set in
     * subsequent requests from client to server.
     * Format is `projects/{project}/subscriptions/{sub}`.
     * </pre>
     *
     * <code>
     * string subscription = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The subscription to set.
     * @return This builder for chaining.
     */
    public Builder setSubscription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      subscription_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The subscription for which to initialize the new stream. This
     * must be provided in the first request on the stream, and must not be set in
     * subsequent requests from client to server.
     * Format is `projects/{project}/subscriptions/{sub}`.
     * </pre>
     *
     * <code>
     * string subscription = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubscription() {

      subscription_ = getDefaultInstance().getSubscription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The subscription for which to initialize the new stream. This
     * must be provided in the first request on the stream, and must not be set in
     * subsequent requests from client to server.
     * Format is `projects/{project}/subscriptions/{sub}`.
     * </pre>
     *
     * <code>
     * string subscription = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for subscription to set.
     * @return This builder for chaining.
     */
    public Builder setSubscriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      subscription_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList ackIds_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureAckIdsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        ackIds_ = new com.google.protobuf.LazyStringArrayList(ackIds_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs for acknowledging previously received messages
     * (received on this stream or a different stream). If an ack ID has expired,
     * the corresponding message may be redelivered later. Acknowledging a message
     * more than once will not result in an error. If the acknowledgement ID is
     * malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated string ack_ids = 2;</code>
     *
     * @return A list containing the ackIds.
     */
    public com.google.protobuf.ProtocolStringList getAckIdsList() {
      return ackIds_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs for acknowledging previously received messages
     * (received on this stream or a different stream). If an ack ID has expired,
     * the corresponding message may be redelivered later. Acknowledging a message
     * more than once will not result in an error. If the acknowledgement ID is
     * malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated string ack_ids = 2;</code>
     *
     * @return The count of ackIds.
     */
    public int getAckIdsCount() {
      return ackIds_.size();
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs for acknowledging previously received messages
     * (received on this stream or a different stream). If an ack ID has expired,
     * the corresponding message may be redelivered later. Acknowledging a message
     * more than once will not result in an error. If the acknowledgement ID is
     * malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated string ack_ids = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The ackIds at the given index.
     */
    public java.lang.String getAckIds(int index) {
      return ackIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs for acknowledging previously received messages
     * (received on this stream or a different stream). If an ack ID has expired,
     * the corresponding message may be redelivered later. Acknowledging a message
     * more than once will not result in an error. If the acknowledgement ID is
     * malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated string ack_ids = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ackIds at the given index.
     */
    public com.google.protobuf.ByteString getAckIdsBytes(int index) {
      return ackIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs for acknowledging previously received messages
     * (received on this stream or a different stream). If an ack ID has expired,
     * the corresponding message may be redelivered later. Acknowledging a message
     * more than once will not result in an error. If the acknowledgement ID is
     * malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated string ack_ids = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The ackIds to set.
     * @return This builder for chaining.
     */
    public Builder setAckIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAckIdsIsMutable();
      ackIds_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs for acknowledging previously received messages
     * (received on this stream or a different stream). If an ack ID has expired,
     * the corresponding message may be redelivered later. Acknowledging a message
     * more than once will not result in an error. If the acknowledgement ID is
     * malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated string ack_ids = 2;</code>
     *
     * @param value The ackIds to add.
     * @return This builder for chaining.
     */
    public Builder addAckIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAckIdsIsMutable();
      ackIds_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs for acknowledging previously received messages
     * (received on this stream or a different stream). If an ack ID has expired,
     * the corresponding message may be redelivered later. Acknowledging a message
     * more than once will not result in an error. If the acknowledgement ID is
     * malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated string ack_ids = 2;</code>
     *
     * @param values The ackIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllAckIds(java.lang.Iterable<java.lang.String> values) {
      ensureAckIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ackIds_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs for acknowledging previously received messages
     * (received on this stream or a different stream). If an ack ID has expired,
     * the corresponding message may be redelivered later. Acknowledging a message
     * more than once will not result in an error. If the acknowledgement ID is
     * malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated string ack_ids = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAckIds() {
      ackIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs for acknowledging previously received messages
     * (received on this stream or a different stream). If an ack ID has expired,
     * the corresponding message may be redelivered later. Acknowledging a message
     * more than once will not result in an error. If the acknowledgement ID is
     * malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated string ack_ids = 2;</code>
     *
     * @param value The bytes of the ackIds to add.
     * @return This builder for chaining.
     */
    public Builder addAckIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAckIdsIsMutable();
      ackIds_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList modifyDeadlineSeconds_ = emptyIntList();

    private void ensureModifyDeadlineSecondsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        modifyDeadlineSeconds_ = mutableCopy(modifyDeadlineSeconds_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of new ack deadlines for the IDs listed in
     * `modify_deadline_ack_ids`. The size of this list must be the same as the
     * size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
     * with `INVALID_ARGUMENT`. Each element in this list is applied to the
     * element in the same position in `modify_deadline_ack_ids`. The new ack
     * deadline is with respect to the time this request was sent to the Pub/Sub
     * system. Must be &gt;= 0. For example, if the value is 10, the new ack deadline
     * will expire 10 seconds after this request is received. If the value is 0,
     * the message is immediately made available for another streaming or
     * non-streaming pull request. If the value is &lt; 0 (an error), the stream will
     * be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated int32 modify_deadline_seconds = 3;</code>
     *
     * @return A list containing the modifyDeadlineSeconds.
     */
    public java.util.List<java.lang.Integer> getModifyDeadlineSecondsList() {
      return ((bitField0_ & 0x00000002) != 0)
          ? java.util.Collections.unmodifiableList(modifyDeadlineSeconds_)
          : modifyDeadlineSeconds_;
    }
    /**
     *
     *
     * <pre>
     * The list of new ack deadlines for the IDs listed in
     * `modify_deadline_ack_ids`. The size of this list must be the same as the
     * size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
     * with `INVALID_ARGUMENT`. Each element in this list is applied to the
     * element in the same position in `modify_deadline_ack_ids`. The new ack
     * deadline is with respect to the time this request was sent to the Pub/Sub
     * system. Must be &gt;= 0. For example, if the value is 10, the new ack deadline
     * will expire 10 seconds after this request is received. If the value is 0,
     * the message is immediately made available for another streaming or
     * non-streaming pull request. If the value is &lt; 0 (an error), the stream will
     * be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated int32 modify_deadline_seconds = 3;</code>
     *
     * @return The count of modifyDeadlineSeconds.
     */
    public int getModifyDeadlineSecondsCount() {
      return modifyDeadlineSeconds_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of new ack deadlines for the IDs listed in
     * `modify_deadline_ack_ids`. The size of this list must be the same as the
     * size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
     * with `INVALID_ARGUMENT`. Each element in this list is applied to the
     * element in the same position in `modify_deadline_ack_ids`. The new ack
     * deadline is with respect to the time this request was sent to the Pub/Sub
     * system. Must be &gt;= 0. For example, if the value is 10, the new ack deadline
     * will expire 10 seconds after this request is received. If the value is 0,
     * the message is immediately made available for another streaming or
     * non-streaming pull request. If the value is &lt; 0 (an error), the stream will
     * be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated int32 modify_deadline_seconds = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The modifyDeadlineSeconds at the given index.
     */
    public int getModifyDeadlineSeconds(int index) {
      return modifyDeadlineSeconds_.getInt(index);
    }
    /**
     *
     *
     * <pre>
     * The list of new ack deadlines for the IDs listed in
     * `modify_deadline_ack_ids`. The size of this list must be the same as the
     * size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
     * with `INVALID_ARGUMENT`. Each element in this list is applied to the
     * element in the same position in `modify_deadline_ack_ids`. The new ack
     * deadline is with respect to the time this request was sent to the Pub/Sub
     * system. Must be &gt;= 0. For example, if the value is 10, the new ack deadline
     * will expire 10 seconds after this request is received. If the value is 0,
     * the message is immediately made available for another streaming or
     * non-streaming pull request. If the value is &lt; 0 (an error), the stream will
     * be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated int32 modify_deadline_seconds = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The modifyDeadlineSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setModifyDeadlineSeconds(int index, int value) {
      ensureModifyDeadlineSecondsIsMutable();
      modifyDeadlineSeconds_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of new ack deadlines for the IDs listed in
     * `modify_deadline_ack_ids`. The size of this list must be the same as the
     * size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
     * with `INVALID_ARGUMENT`. Each element in this list is applied to the
     * element in the same position in `modify_deadline_ack_ids`. The new ack
     * deadline is with respect to the time this request was sent to the Pub/Sub
     * system. Must be &gt;= 0. For example, if the value is 10, the new ack deadline
     * will expire 10 seconds after this request is received. If the value is 0,
     * the message is immediately made available for another streaming or
     * non-streaming pull request. If the value is &lt; 0 (an error), the stream will
     * be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated int32 modify_deadline_seconds = 3;</code>
     *
     * @param value The modifyDeadlineSeconds to add.
     * @return This builder for chaining.
     */
    public Builder addModifyDeadlineSeconds(int value) {
      ensureModifyDeadlineSecondsIsMutable();
      modifyDeadlineSeconds_.addInt(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of new ack deadlines for the IDs listed in
     * `modify_deadline_ack_ids`. The size of this list must be the same as the
     * size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
     * with `INVALID_ARGUMENT`. Each element in this list is applied to the
     * element in the same position in `modify_deadline_ack_ids`. The new ack
     * deadline is with respect to the time this request was sent to the Pub/Sub
     * system. Must be &gt;= 0. For example, if the value is 10, the new ack deadline
     * will expire 10 seconds after this request is received. If the value is 0,
     * the message is immediately made available for another streaming or
     * non-streaming pull request. If the value is &lt; 0 (an error), the stream will
     * be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated int32 modify_deadline_seconds = 3;</code>
     *
     * @param values The modifyDeadlineSeconds to add.
     * @return This builder for chaining.
     */
    public Builder addAllModifyDeadlineSeconds(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureModifyDeadlineSecondsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, modifyDeadlineSeconds_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of new ack deadlines for the IDs listed in
     * `modify_deadline_ack_ids`. The size of this list must be the same as the
     * size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
     * with `INVALID_ARGUMENT`. Each element in this list is applied to the
     * element in the same position in `modify_deadline_ack_ids`. The new ack
     * deadline is with respect to the time this request was sent to the Pub/Sub
     * system. Must be &gt;= 0. For example, if the value is 10, the new ack deadline
     * will expire 10 seconds after this request is received. If the value is 0,
     * the message is immediately made available for another streaming or
     * non-streaming pull request. If the value is &lt; 0 (an error), the stream will
     * be aborted with status `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>repeated int32 modify_deadline_seconds = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModifyDeadlineSeconds() {
      modifyDeadlineSeconds_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList modifyDeadlineAckIds_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureModifyDeadlineAckIdsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        modifyDeadlineAckIds_ = new com.google.protobuf.LazyStringArrayList(modifyDeadlineAckIds_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs whose deadline will be modified based on the
     * corresponding element in `modify_deadline_seconds`. This field can be used
     * to indicate that more time is needed to process a message by the
     * subscriber, or to make the message available for redelivery if the
     * processing was interrupted.
     * </pre>
     *
     * <code>repeated string modify_deadline_ack_ids = 4;</code>
     *
     * @return A list containing the modifyDeadlineAckIds.
     */
    public com.google.protobuf.ProtocolStringList getModifyDeadlineAckIdsList() {
      return modifyDeadlineAckIds_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs whose deadline will be modified based on the
     * corresponding element in `modify_deadline_seconds`. This field can be used
     * to indicate that more time is needed to process a message by the
     * subscriber, or to make the message available for redelivery if the
     * processing was interrupted.
     * </pre>
     *
     * <code>repeated string modify_deadline_ack_ids = 4;</code>
     *
     * @return The count of modifyDeadlineAckIds.
     */
    public int getModifyDeadlineAckIdsCount() {
      return modifyDeadlineAckIds_.size();
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs whose deadline will be modified based on the
     * corresponding element in `modify_deadline_seconds`. This field can be used
     * to indicate that more time is needed to process a message by the
     * subscriber, or to make the message available for redelivery if the
     * processing was interrupted.
     * </pre>
     *
     * <code>repeated string modify_deadline_ack_ids = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The modifyDeadlineAckIds at the given index.
     */
    public java.lang.String getModifyDeadlineAckIds(int index) {
      return modifyDeadlineAckIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs whose deadline will be modified based on the
     * corresponding element in `modify_deadline_seconds`. This field can be used
     * to indicate that more time is needed to process a message by the
     * subscriber, or to make the message available for redelivery if the
     * processing was interrupted.
     * </pre>
     *
     * <code>repeated string modify_deadline_ack_ids = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the modifyDeadlineAckIds at the given index.
     */
    public com.google.protobuf.ByteString getModifyDeadlineAckIdsBytes(int index) {
      return modifyDeadlineAckIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs whose deadline will be modified based on the
     * corresponding element in `modify_deadline_seconds`. This field can be used
     * to indicate that more time is needed to process a message by the
     * subscriber, or to make the message available for redelivery if the
     * processing was interrupted.
     * </pre>
     *
     * <code>repeated string modify_deadline_ack_ids = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The modifyDeadlineAckIds to set.
     * @return This builder for chaining.
     */
    public Builder setModifyDeadlineAckIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureModifyDeadlineAckIdsIsMutable();
      modifyDeadlineAckIds_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs whose deadline will be modified based on the
     * corresponding element in `modify_deadline_seconds`. This field can be used
     * to indicate that more time is needed to process a message by the
     * subscriber, or to make the message available for redelivery if the
     * processing was interrupted.
     * </pre>
     *
     * <code>repeated string modify_deadline_ack_ids = 4;</code>
     *
     * @param value The modifyDeadlineAckIds to add.
     * @return This builder for chaining.
     */
    public Builder addModifyDeadlineAckIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureModifyDeadlineAckIdsIsMutable();
      modifyDeadlineAckIds_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs whose deadline will be modified based on the
     * corresponding element in `modify_deadline_seconds`. This field can be used
     * to indicate that more time is needed to process a message by the
     * subscriber, or to make the message available for redelivery if the
     * processing was interrupted.
     * </pre>
     *
     * <code>repeated string modify_deadline_ack_ids = 4;</code>
     *
     * @param values The modifyDeadlineAckIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllModifyDeadlineAckIds(java.lang.Iterable<java.lang.String> values) {
      ensureModifyDeadlineAckIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, modifyDeadlineAckIds_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs whose deadline will be modified based on the
     * corresponding element in `modify_deadline_seconds`. This field can be used
     * to indicate that more time is needed to process a message by the
     * subscriber, or to make the message available for redelivery if the
     * processing was interrupted.
     * </pre>
     *
     * <code>repeated string modify_deadline_ack_ids = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModifyDeadlineAckIds() {
      modifyDeadlineAckIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of acknowledgement IDs whose deadline will be modified based on the
     * corresponding element in `modify_deadline_seconds`. This field can be used
     * to indicate that more time is needed to process a message by the
     * subscriber, or to make the message available for redelivery if the
     * processing was interrupted.
     * </pre>
     *
     * <code>repeated string modify_deadline_ack_ids = 4;</code>
     *
     * @param value The bytes of the modifyDeadlineAckIds to add.
     * @return This builder for chaining.
     */
    public Builder addModifyDeadlineAckIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureModifyDeadlineAckIdsIsMutable();
      modifyDeadlineAckIds_.add(value);
      onChanged();
      return this;
    }

    private int streamAckDeadlineSeconds_;
    /**
     *
     *
     * <pre>
     * Required. The ack deadline to use for the stream. This must be provided in
     * the first request on the stream, but it can also be updated on subsequent
     * requests from client to server. The minimum deadline you can specify is 10
     * seconds. The maximum deadline you can specify is 600 seconds (10 minutes).
     * </pre>
     *
     * <code>int32 stream_ack_deadline_seconds = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The streamAckDeadlineSeconds.
     */
    @java.lang.Override
    public int getStreamAckDeadlineSeconds() {
      return streamAckDeadlineSeconds_;
    }
    /**
     *
     *
     * <pre>
     * Required. The ack deadline to use for the stream. This must be provided in
     * the first request on the stream, but it can also be updated on subsequent
     * requests from client to server. The minimum deadline you can specify is 10
     * seconds. The maximum deadline you can specify is 600 seconds (10 minutes).
     * </pre>
     *
     * <code>int32 stream_ack_deadline_seconds = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The streamAckDeadlineSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setStreamAckDeadlineSeconds(int value) {

      streamAckDeadlineSeconds_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ack deadline to use for the stream. This must be provided in
     * the first request on the stream, but it can also be updated on subsequent
     * requests from client to server. The minimum deadline you can specify is 10
     * seconds. The maximum deadline you can specify is 600 seconds (10 minutes).
     * </pre>
     *
     * <code>int32 stream_ack_deadline_seconds = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStreamAckDeadlineSeconds() {

      streamAckDeadlineSeconds_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object clientId_ = "";
    /**
     *
     *
     * <pre>
     * A unique identifier that is used to distinguish client instances from each
     * other. Only needs to be provided on the initial request. When a stream
     * disconnects and reconnects for the same stream, the client_id should be set
     * to the same value so that state associated with the old stream can be
     * transferred to the new stream. The same client_id should not be used for
     * different client instances.
     * </pre>
     *
     * <code>string client_id = 6;</code>
     *
     * @return The clientId.
     */
    public java.lang.String getClientId() {
      java.lang.Object ref = clientId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier that is used to distinguish client instances from each
     * other. Only needs to be provided on the initial request. When a stream
     * disconnects and reconnects for the same stream, the client_id should be set
     * to the same value so that state associated with the old stream can be
     * transferred to the new stream. The same client_id should not be used for
     * different client instances.
     * </pre>
     *
     * <code>string client_id = 6;</code>
     *
     * @return The bytes for clientId.
     */
    public com.google.protobuf.ByteString getClientIdBytes() {
      java.lang.Object ref = clientId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier that is used to distinguish client instances from each
     * other. Only needs to be provided on the initial request. When a stream
     * disconnects and reconnects for the same stream, the client_id should be set
     * to the same value so that state associated with the old stream can be
     * transferred to the new stream. The same client_id should not be used for
     * different client instances.
     * </pre>
     *
     * <code>string client_id = 6;</code>
     *
     * @param value The clientId to set.
     * @return This builder for chaining.
     */
    public Builder setClientId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      clientId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier that is used to distinguish client instances from each
     * other. Only needs to be provided on the initial request. When a stream
     * disconnects and reconnects for the same stream, the client_id should be set
     * to the same value so that state associated with the old stream can be
     * transferred to the new stream. The same client_id should not be used for
     * different client instances.
     * </pre>
     *
     * <code>string client_id = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientId() {

      clientId_ = getDefaultInstance().getClientId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier that is used to distinguish client instances from each
     * other. Only needs to be provided on the initial request. When a stream
     * disconnects and reconnects for the same stream, the client_id should be set
     * to the same value so that state associated with the old stream can be
     * transferred to the new stream. The same client_id should not be used for
     * different client instances.
     * </pre>
     *
     * <code>string client_id = 6;</code>
     *
     * @param value The bytes for clientId to set.
     * @return This builder for chaining.
     */
    public Builder setClientIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      clientId_ = value;
      onChanged();
      return this;
    }

    private long maxOutstandingMessages_;
    /**
     *
     *
     * <pre>
     * Flow control settings for the maximum number of outstanding messages. When
     * there are `max_outstanding_messages` or more currently sent to the
     * streaming pull client that have not yet been acked or nacked, the server
     * stops sending more messages. The sending of messages resumes once the
     * number of outstanding messages is less than this value. If the value is
     * &lt;= 0, there is no limit to the number of outstanding messages. This
     * property can only be set on the initial StreamingPullRequest. If it is set
     * on a subsequent request, the stream will be aborted with status
     * `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>int64 max_outstanding_messages = 7;</code>
     *
     * @return The maxOutstandingMessages.
     */
    @java.lang.Override
    public long getMaxOutstandingMessages() {
      return maxOutstandingMessages_;
    }
    /**
     *
     *
     * <pre>
     * Flow control settings for the maximum number of outstanding messages. When
     * there are `max_outstanding_messages` or more currently sent to the
     * streaming pull client that have not yet been acked or nacked, the server
     * stops sending more messages. The sending of messages resumes once the
     * number of outstanding messages is less than this value. If the value is
     * &lt;= 0, there is no limit to the number of outstanding messages. This
     * property can only be set on the initial StreamingPullRequest. If it is set
     * on a subsequent request, the stream will be aborted with status
     * `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>int64 max_outstanding_messages = 7;</code>
     *
     * @param value The maxOutstandingMessages to set.
     * @return This builder for chaining.
     */
    public Builder setMaxOutstandingMessages(long value) {

      maxOutstandingMessages_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Flow control settings for the maximum number of outstanding messages. When
     * there are `max_outstanding_messages` or more currently sent to the
     * streaming pull client that have not yet been acked or nacked, the server
     * stops sending more messages. The sending of messages resumes once the
     * number of outstanding messages is less than this value. If the value is
     * &lt;= 0, there is no limit to the number of outstanding messages. This
     * property can only be set on the initial StreamingPullRequest. If it is set
     * on a subsequent request, the stream will be aborted with status
     * `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>int64 max_outstanding_messages = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxOutstandingMessages() {

      maxOutstandingMessages_ = 0L;
      onChanged();
      return this;
    }

    private long maxOutstandingBytes_;
    /**
     *
     *
     * <pre>
     * Flow control settings for the maximum number of outstanding bytes. When
     * there are `max_outstanding_bytes` or more worth of messages currently sent
     * to the streaming pull client that have not yet been acked or nacked, the
     * server will stop sending more messages. The sending of messages resumes
     * once the number of outstanding bytes is less than this value. If the value
     * is &lt;= 0, there is no limit to the number of outstanding bytes. This
     * property can only be set on the initial StreamingPullRequest. If it is set
     * on a subsequent request, the stream will be aborted with status
     * `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>int64 max_outstanding_bytes = 8;</code>
     *
     * @return The maxOutstandingBytes.
     */
    @java.lang.Override
    public long getMaxOutstandingBytes() {
      return maxOutstandingBytes_;
    }
    /**
     *
     *
     * <pre>
     * Flow control settings for the maximum number of outstanding bytes. When
     * there are `max_outstanding_bytes` or more worth of messages currently sent
     * to the streaming pull client that have not yet been acked or nacked, the
     * server will stop sending more messages. The sending of messages resumes
     * once the number of outstanding bytes is less than this value. If the value
     * is &lt;= 0, there is no limit to the number of outstanding bytes. This
     * property can only be set on the initial StreamingPullRequest. If it is set
     * on a subsequent request, the stream will be aborted with status
     * `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>int64 max_outstanding_bytes = 8;</code>
     *
     * @param value The maxOutstandingBytes to set.
     * @return This builder for chaining.
     */
    public Builder setMaxOutstandingBytes(long value) {

      maxOutstandingBytes_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Flow control settings for the maximum number of outstanding bytes. When
     * there are `max_outstanding_bytes` or more worth of messages currently sent
     * to the streaming pull client that have not yet been acked or nacked, the
     * server will stop sending more messages. The sending of messages resumes
     * once the number of outstanding bytes is less than this value. If the value
     * is &lt;= 0, there is no limit to the number of outstanding bytes. This
     * property can only be set on the initial StreamingPullRequest. If it is set
     * on a subsequent request, the stream will be aborted with status
     * `INVALID_ARGUMENT`.
     * </pre>
     *
     * <code>int64 max_outstanding_bytes = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxOutstandingBytes() {

      maxOutstandingBytes_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.StreamingPullRequest)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.StreamingPullRequest)
  private static final com.google.pubsub.v1.StreamingPullRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.StreamingPullRequest();
  }

  public static com.google.pubsub.v1.StreamingPullRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingPullRequest> PARSER =
      new com.google.protobuf.AbstractParser<StreamingPullRequest>() {
        @java.lang.Override
        public StreamingPullRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamingPullRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingPullRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.StreamingPullRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
