/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

package com.google.pubsub.v1;

public interface ListTopicSubscriptionsResponseOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.pubsub.v1.ListTopicSubscriptionsResponse)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The names of subscriptions attached to the topic specified in the request.
   * </pre>
   *
   * <code>repeated string subscriptions = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the subscriptions.
   */
  java.util.List<java.lang.String> getSubscriptionsList();
  /**
   *
   *
   * <pre>
   * The names of subscriptions attached to the topic specified in the request.
   * </pre>
   *
   * <code>repeated string subscriptions = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of subscriptions.
   */
  int getSubscriptionsCount();
  /**
   *
   *
   * <pre>
   * The names of subscriptions attached to the topic specified in the request.
   * </pre>
   *
   * <code>repeated string subscriptions = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The subscriptions at the given index.
   */
  java.lang.String getSubscriptions(int index);
  /**
   *
   *
   * <pre>
   * The names of subscriptions attached to the topic specified in the request.
   * </pre>
   *
   * <code>repeated string subscriptions = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the subscriptions at the given index.
   */
  com.google.protobuf.ByteString getSubscriptionsBytes(int index);

  /**
   *
   *
   * <pre>
   * If not empty, indicates that there may be more subscriptions that match
   * the request; this value should be passed in a new
   * `ListTopicSubscriptionsRequest` to get more subscriptions.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  java.lang.String getNextPageToken();
  /**
   *
   *
   * <pre>
   * If not empty, indicates that there may be more subscriptions that match
   * the request; this value should be passed in a new
   * `ListTopicSubscriptionsRequest` to get more subscriptions.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  com.google.protobuf.ByteString getNextPageTokenBytes();
}
