/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

// Protobuf Java Version: 3.25.3
package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * Configuration for a Cloud Storage subscription.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.CloudStorageConfig}
 */
public final class CloudStorageConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.CloudStorageConfig)
    CloudStorageConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudStorageConfig.newBuilder() to construct.
  private CloudStorageConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudStorageConfig() {
    bucket_ = "";
    filenamePrefix_ = "";
    filenameSuffix_ = "";
    filenameDatetimeFormat_ = "";
    state_ = 0;
    serviceAccountEmail_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudStorageConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_CloudStorageConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_CloudStorageConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.CloudStorageConfig.class,
            com.google.pubsub.v1.CloudStorageConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states for a Cloud Storage subscription.
   * </pre>
   *
   * Protobuf enum {@code google.pubsub.v1.CloudStorageConfig.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The subscription can actively send messages to Cloud Storage.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * Cannot write to the Cloud Storage bucket because of permission denied
     * errors.
     * </pre>
     *
     * <code>PERMISSION_DENIED = 2;</code>
     */
    PERMISSION_DENIED(2),
    /**
     *
     *
     * <pre>
     * Cannot write to the Cloud Storage bucket because it does not exist.
     * </pre>
     *
     * <code>NOT_FOUND = 3;</code>
     */
    NOT_FOUND(3),
    /**
     *
     *
     * <pre>
     * Cannot write to the destination because enforce_in_transit is set to true
     * and the destination locations are not in the allowed regions.
     * </pre>
     *
     * <code>IN_TRANSIT_LOCATION_RESTRICTION = 4;</code>
     */
    IN_TRANSIT_LOCATION_RESTRICTION(4),
    /**
     *
     *
     * <pre>
     * Cannot write to the Cloud Storage bucket due to an incompatibility
     * between the topic schema and subscription settings.
     * </pre>
     *
     * <code>SCHEMA_MISMATCH = 5;</code>
     */
    SCHEMA_MISMATCH(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The subscription can actively send messages to Cloud Storage.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Cannot write to the Cloud Storage bucket because of permission denied
     * errors.
     * </pre>
     *
     * <code>PERMISSION_DENIED = 2;</code>
     */
    public static final int PERMISSION_DENIED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Cannot write to the Cloud Storage bucket because it does not exist.
     * </pre>
     *
     * <code>NOT_FOUND = 3;</code>
     */
    public static final int NOT_FOUND_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Cannot write to the destination because enforce_in_transit is set to true
     * and the destination locations are not in the allowed regions.
     * </pre>
     *
     * <code>IN_TRANSIT_LOCATION_RESTRICTION = 4;</code>
     */
    public static final int IN_TRANSIT_LOCATION_RESTRICTION_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Cannot write to the Cloud Storage bucket due to an incompatibility
     * between the topic schema and subscription settings.
     * </pre>
     *
     * <code>SCHEMA_MISMATCH = 5;</code>
     */
    public static final int SCHEMA_MISMATCH_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return PERMISSION_DENIED;
        case 3:
          return NOT_FOUND;
        case 4:
          return IN_TRANSIT_LOCATION_RESTRICTION;
        case 5:
          return SCHEMA_MISMATCH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.pubsub.v1.CloudStorageConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.pubsub.v1.CloudStorageConfig.State)
  }

  public interface TextConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.CloudStorageConfig.TextConfig)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Configuration for writing message data in text format.
   * Message payloads will be written to files as raw text, separated by a
   * newline.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.CloudStorageConfig.TextConfig}
   */
  public static final class TextConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.CloudStorageConfig.TextConfig)
      TextConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TextConfig.newBuilder() to construct.
    private TextConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TextConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TextConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_CloudStorageConfig_TextConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_CloudStorageConfig_TextConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.CloudStorageConfig.TextConfig.class,
              com.google.pubsub.v1.CloudStorageConfig.TextConfig.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.CloudStorageConfig.TextConfig)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.CloudStorageConfig.TextConfig other =
          (com.google.pubsub.v1.CloudStorageConfig.TextConfig) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.CloudStorageConfig.TextConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.TextConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.TextConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.TextConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.TextConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.TextConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.TextConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.TextConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.TextConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.TextConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.TextConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.TextConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.pubsub.v1.CloudStorageConfig.TextConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for writing message data in text format.
     * Message payloads will be written to files as raw text, separated by a
     * newline.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.CloudStorageConfig.TextConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.CloudStorageConfig.TextConfig)
        com.google.pubsub.v1.CloudStorageConfig.TextConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_CloudStorageConfig_TextConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_CloudStorageConfig_TextConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.CloudStorageConfig.TextConfig.class,
                com.google.pubsub.v1.CloudStorageConfig.TextConfig.Builder.class);
      }

      // Construct using com.google.pubsub.v1.CloudStorageConfig.TextConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_CloudStorageConfig_TextConfig_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.CloudStorageConfig.TextConfig getDefaultInstanceForType() {
        return com.google.pubsub.v1.CloudStorageConfig.TextConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.CloudStorageConfig.TextConfig build() {
        com.google.pubsub.v1.CloudStorageConfig.TextConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.CloudStorageConfig.TextConfig buildPartial() {
        com.google.pubsub.v1.CloudStorageConfig.TextConfig result =
            new com.google.pubsub.v1.CloudStorageConfig.TextConfig(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.CloudStorageConfig.TextConfig) {
          return mergeFrom((com.google.pubsub.v1.CloudStorageConfig.TextConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.pubsub.v1.CloudStorageConfig.TextConfig other) {
        if (other == com.google.pubsub.v1.CloudStorageConfig.TextConfig.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.CloudStorageConfig.TextConfig)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.CloudStorageConfig.TextConfig)
    private static final com.google.pubsub.v1.CloudStorageConfig.TextConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.CloudStorageConfig.TextConfig();
    }

    public static com.google.pubsub.v1.CloudStorageConfig.TextConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TextConfig> PARSER =
        new com.google.protobuf.AbstractParser<TextConfig>() {
          @java.lang.Override
          public TextConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TextConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TextConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.CloudStorageConfig.TextConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AvroConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.CloudStorageConfig.AvroConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. When true, write the subscription name, message_id,
     * publish_time, attributes, and ordering_key as additional fields in the
     * output. The subscription name, message_id, and publish_time fields are
     * put in their own fields while all other message properties other than
     * data (for example, an ordering_key, if present) are added as entries in
     * the attributes map.
     * </pre>
     *
     * <code>bool write_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The writeMetadata.
     */
    boolean getWriteMetadata();

    /**
     *
     *
     * <pre>
     * Optional. When true, the output Cloud Storage file will be serialized
     * using the topic schema, if it exists.
     * </pre>
     *
     * <code>bool use_topic_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The useTopicSchema.
     */
    boolean getUseTopicSchema();
  }
  /**
   *
   *
   * <pre>
   * Configuration for writing message data in Avro format.
   * Message payloads and metadata will be written to files as an Avro binary.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.CloudStorageConfig.AvroConfig}
   */
  public static final class AvroConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.CloudStorageConfig.AvroConfig)
      AvroConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AvroConfig.newBuilder() to construct.
    private AvroConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AvroConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AvroConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_CloudStorageConfig_AvroConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_CloudStorageConfig_AvroConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.CloudStorageConfig.AvroConfig.class,
              com.google.pubsub.v1.CloudStorageConfig.AvroConfig.Builder.class);
    }

    public static final int WRITE_METADATA_FIELD_NUMBER = 1;
    private boolean writeMetadata_ = false;
    /**
     *
     *
     * <pre>
     * Optional. When true, write the subscription name, message_id,
     * publish_time, attributes, and ordering_key as additional fields in the
     * output. The subscription name, message_id, and publish_time fields are
     * put in their own fields while all other message properties other than
     * data (for example, an ordering_key, if present) are added as entries in
     * the attributes map.
     * </pre>
     *
     * <code>bool write_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The writeMetadata.
     */
    @java.lang.Override
    public boolean getWriteMetadata() {
      return writeMetadata_;
    }

    public static final int USE_TOPIC_SCHEMA_FIELD_NUMBER = 2;
    private boolean useTopicSchema_ = false;
    /**
     *
     *
     * <pre>
     * Optional. When true, the output Cloud Storage file will be serialized
     * using the topic schema, if it exists.
     * </pre>
     *
     * <code>bool use_topic_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The useTopicSchema.
     */
    @java.lang.Override
    public boolean getUseTopicSchema() {
      return useTopicSchema_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (writeMetadata_ != false) {
        output.writeBool(1, writeMetadata_);
      }
      if (useTopicSchema_ != false) {
        output.writeBool(2, useTopicSchema_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (writeMetadata_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, writeMetadata_);
      }
      if (useTopicSchema_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, useTopicSchema_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.CloudStorageConfig.AvroConfig)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.CloudStorageConfig.AvroConfig other =
          (com.google.pubsub.v1.CloudStorageConfig.AvroConfig) obj;

      if (getWriteMetadata() != other.getWriteMetadata()) return false;
      if (getUseTopicSchema() != other.getUseTopicSchema()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + WRITE_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getWriteMetadata());
      hash = (37 * hash) + USE_TOPIC_SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseTopicSchema());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.CloudStorageConfig.AvroConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.AvroConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.AvroConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.AvroConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.AvroConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.AvroConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.AvroConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.AvroConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.AvroConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.AvroConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.AvroConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.CloudStorageConfig.AvroConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.pubsub.v1.CloudStorageConfig.AvroConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for writing message data in Avro format.
     * Message payloads and metadata will be written to files as an Avro binary.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.CloudStorageConfig.AvroConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.CloudStorageConfig.AvroConfig)
        com.google.pubsub.v1.CloudStorageConfig.AvroConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_CloudStorageConfig_AvroConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_CloudStorageConfig_AvroConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.CloudStorageConfig.AvroConfig.class,
                com.google.pubsub.v1.CloudStorageConfig.AvroConfig.Builder.class);
      }

      // Construct using com.google.pubsub.v1.CloudStorageConfig.AvroConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        writeMetadata_ = false;
        useTopicSchema_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_CloudStorageConfig_AvroConfig_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.CloudStorageConfig.AvroConfig getDefaultInstanceForType() {
        return com.google.pubsub.v1.CloudStorageConfig.AvroConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.CloudStorageConfig.AvroConfig build() {
        com.google.pubsub.v1.CloudStorageConfig.AvroConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.CloudStorageConfig.AvroConfig buildPartial() {
        com.google.pubsub.v1.CloudStorageConfig.AvroConfig result =
            new com.google.pubsub.v1.CloudStorageConfig.AvroConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.pubsub.v1.CloudStorageConfig.AvroConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.writeMetadata_ = writeMetadata_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.useTopicSchema_ = useTopicSchema_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.CloudStorageConfig.AvroConfig) {
          return mergeFrom((com.google.pubsub.v1.CloudStorageConfig.AvroConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.pubsub.v1.CloudStorageConfig.AvroConfig other) {
        if (other == com.google.pubsub.v1.CloudStorageConfig.AvroConfig.getDefaultInstance())
          return this;
        if (other.getWriteMetadata() != false) {
          setWriteMetadata(other.getWriteMetadata());
        }
        if (other.getUseTopicSchema() != false) {
          setUseTopicSchema(other.getUseTopicSchema());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  writeMetadata_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  useTopicSchema_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean writeMetadata_;
      /**
       *
       *
       * <pre>
       * Optional. When true, write the subscription name, message_id,
       * publish_time, attributes, and ordering_key as additional fields in the
       * output. The subscription name, message_id, and publish_time fields are
       * put in their own fields while all other message properties other than
       * data (for example, an ordering_key, if present) are added as entries in
       * the attributes map.
       * </pre>
       *
       * <code>bool write_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The writeMetadata.
       */
      @java.lang.Override
      public boolean getWriteMetadata() {
        return writeMetadata_;
      }
      /**
       *
       *
       * <pre>
       * Optional. When true, write the subscription name, message_id,
       * publish_time, attributes, and ordering_key as additional fields in the
       * output. The subscription name, message_id, and publish_time fields are
       * put in their own fields while all other message properties other than
       * data (for example, an ordering_key, if present) are added as entries in
       * the attributes map.
       * </pre>
       *
       * <code>bool write_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The writeMetadata to set.
       * @return This builder for chaining.
       */
      public Builder setWriteMetadata(boolean value) {

        writeMetadata_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. When true, write the subscription name, message_id,
       * publish_time, attributes, and ordering_key as additional fields in the
       * output. The subscription name, message_id, and publish_time fields are
       * put in their own fields while all other message properties other than
       * data (for example, an ordering_key, if present) are added as entries in
       * the attributes map.
       * </pre>
       *
       * <code>bool write_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWriteMetadata() {
        bitField0_ = (bitField0_ & ~0x00000001);
        writeMetadata_ = false;
        onChanged();
        return this;
      }

      private boolean useTopicSchema_;
      /**
       *
       *
       * <pre>
       * Optional. When true, the output Cloud Storage file will be serialized
       * using the topic schema, if it exists.
       * </pre>
       *
       * <code>bool use_topic_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The useTopicSchema.
       */
      @java.lang.Override
      public boolean getUseTopicSchema() {
        return useTopicSchema_;
      }
      /**
       *
       *
       * <pre>
       * Optional. When true, the output Cloud Storage file will be serialized
       * using the topic schema, if it exists.
       * </pre>
       *
       * <code>bool use_topic_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The useTopicSchema to set.
       * @return This builder for chaining.
       */
      public Builder setUseTopicSchema(boolean value) {

        useTopicSchema_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. When true, the output Cloud Storage file will be serialized
       * using the topic schema, if it exists.
       * </pre>
       *
       * <code>bool use_topic_schema = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUseTopicSchema() {
        bitField0_ = (bitField0_ & ~0x00000002);
        useTopicSchema_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.CloudStorageConfig.AvroConfig)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.CloudStorageConfig.AvroConfig)
    private static final com.google.pubsub.v1.CloudStorageConfig.AvroConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.CloudStorageConfig.AvroConfig();
    }

    public static com.google.pubsub.v1.CloudStorageConfig.AvroConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AvroConfig> PARSER =
        new com.google.protobuf.AbstractParser<AvroConfig>() {
          @java.lang.Override
          public AvroConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AvroConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AvroConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.CloudStorageConfig.AvroConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int outputFormatCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object outputFormat_;

  public enum OutputFormatCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT_CONFIG(4),
    AVRO_CONFIG(5),
    OUTPUTFORMAT_NOT_SET(0);
    private final int value;

    private OutputFormatCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OutputFormatCase valueOf(int value) {
      return forNumber(value);
    }

    public static OutputFormatCase forNumber(int value) {
      switch (value) {
        case 4:
          return TEXT_CONFIG;
        case 5:
          return AVRO_CONFIG;
        case 0:
          return OUTPUTFORMAT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OutputFormatCase getOutputFormatCase() {
    return OutputFormatCase.forNumber(outputFormatCase_);
  }

  public static final int BUCKET_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bucket_ = "";
  /**
   *
   *
   * <pre>
   * Required. User-provided name for the Cloud Storage bucket.
   * The bucket must be created by the user. The bucket name must be without
   * any prefix like "gs://". See the [bucket naming
   * requirements] (https://cloud.google.com/storage/docs/buckets#naming).
   * </pre>
   *
   * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bucket.
   */
  @java.lang.Override
  public java.lang.String getBucket() {
    java.lang.Object ref = bucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bucket_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. User-provided name for the Cloud Storage bucket.
   * The bucket must be created by the user. The bucket name must be without
   * any prefix like "gs://". See the [bucket naming
   * requirements] (https://cloud.google.com/storage/docs/buckets#naming).
   * </pre>
   *
   * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for bucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBucketBytes() {
    java.lang.Object ref = bucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILENAME_PREFIX_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filenamePrefix_ = "";
  /**
   *
   *
   * <pre>
   * Optional. User-provided prefix for Cloud Storage filename. See the [object
   * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
   * </pre>
   *
   * <code>string filename_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filenamePrefix.
   */
  @java.lang.Override
  public java.lang.String getFilenamePrefix() {
    java.lang.Object ref = filenamePrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filenamePrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. User-provided prefix for Cloud Storage filename. See the [object
   * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
   * </pre>
   *
   * <code>string filename_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filenamePrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilenamePrefixBytes() {
    java.lang.Object ref = filenamePrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filenamePrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILENAME_SUFFIX_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filenameSuffix_ = "";
  /**
   *
   *
   * <pre>
   * Optional. User-provided suffix for Cloud Storage filename. See the [object
   * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
   * Must not end in "/".
   * </pre>
   *
   * <code>string filename_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filenameSuffix.
   */
  @java.lang.Override
  public java.lang.String getFilenameSuffix() {
    java.lang.Object ref = filenameSuffix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filenameSuffix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. User-provided suffix for Cloud Storage filename. See the [object
   * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
   * Must not end in "/".
   * </pre>
   *
   * <code>string filename_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filenameSuffix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilenameSuffixBytes() {
    java.lang.Object ref = filenameSuffix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filenameSuffix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILENAME_DATETIME_FORMAT_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filenameDatetimeFormat_ = "";
  /**
   *
   *
   * <pre>
   * Optional. User-provided format string specifying how to represent datetimes
   * in Cloud Storage filenames. See the [datetime format
   * guidance](https://cloud.google.com/pubsub/docs/create-cloudstorage-subscription#file_names).
   * </pre>
   *
   * <code>string filename_datetime_format = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filenameDatetimeFormat.
   */
  @java.lang.Override
  public java.lang.String getFilenameDatetimeFormat() {
    java.lang.Object ref = filenameDatetimeFormat_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filenameDatetimeFormat_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. User-provided format string specifying how to represent datetimes
   * in Cloud Storage filenames. See the [datetime format
   * guidance](https://cloud.google.com/pubsub/docs/create-cloudstorage-subscription#file_names).
   * </pre>
   *
   * <code>string filename_datetime_format = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filenameDatetimeFormat.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilenameDatetimeFormatBytes() {
    java.lang.Object ref = filenameDatetimeFormat_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filenameDatetimeFormat_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEXT_CONFIG_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. If set, message data will be written to Cloud Storage in text
   * format.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.CloudStorageConfig.TextConfig text_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the textConfig field is set.
   */
  @java.lang.Override
  public boolean hasTextConfig() {
    return outputFormatCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. If set, message data will be written to Cloud Storage in text
   * format.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.CloudStorageConfig.TextConfig text_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The textConfig.
   */
  @java.lang.Override
  public com.google.pubsub.v1.CloudStorageConfig.TextConfig getTextConfig() {
    if (outputFormatCase_ == 4) {
      return (com.google.pubsub.v1.CloudStorageConfig.TextConfig) outputFormat_;
    }
    return com.google.pubsub.v1.CloudStorageConfig.TextConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. If set, message data will be written to Cloud Storage in text
   * format.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.CloudStorageConfig.TextConfig text_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.CloudStorageConfig.TextConfigOrBuilder getTextConfigOrBuilder() {
    if (outputFormatCase_ == 4) {
      return (com.google.pubsub.v1.CloudStorageConfig.TextConfig) outputFormat_;
    }
    return com.google.pubsub.v1.CloudStorageConfig.TextConfig.getDefaultInstance();
  }

  public static final int AVRO_CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Optional. If set, message data will be written to Cloud Storage in Avro
   * format.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.CloudStorageConfig.AvroConfig avro_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the avroConfig field is set.
   */
  @java.lang.Override
  public boolean hasAvroConfig() {
    return outputFormatCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Optional. If set, message data will be written to Cloud Storage in Avro
   * format.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.CloudStorageConfig.AvroConfig avro_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The avroConfig.
   */
  @java.lang.Override
  public com.google.pubsub.v1.CloudStorageConfig.AvroConfig getAvroConfig() {
    if (outputFormatCase_ == 5) {
      return (com.google.pubsub.v1.CloudStorageConfig.AvroConfig) outputFormat_;
    }
    return com.google.pubsub.v1.CloudStorageConfig.AvroConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. If set, message data will be written to Cloud Storage in Avro
   * format.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.CloudStorageConfig.AvroConfig avro_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.CloudStorageConfig.AvroConfigOrBuilder getAvroConfigOrBuilder() {
    if (outputFormatCase_ == 5) {
      return (com.google.pubsub.v1.CloudStorageConfig.AvroConfig) outputFormat_;
    }
    return com.google.pubsub.v1.CloudStorageConfig.AvroConfig.getDefaultInstance();
  }

  public static final int MAX_DURATION_FIELD_NUMBER = 6;
  private com.google.protobuf.Duration maxDuration_;
  /**
   *
   *
   * <pre>
   * Optional. The maximum duration that can elapse before a new Cloud Storage
   * file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
   * exceed the subscription's acknowledgement deadline.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the maxDuration field is set.
   */
  @java.lang.Override
  public boolean hasMaxDuration() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The maximum duration that can elapse before a new Cloud Storage
   * file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
   * exceed the subscription's acknowledgement deadline.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The maxDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMaxDuration() {
    return maxDuration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : maxDuration_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The maximum duration that can elapse before a new Cloud Storage
   * file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
   * exceed the subscription's acknowledgement deadline.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMaxDurationOrBuilder() {
    return maxDuration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : maxDuration_;
  }

  public static final int MAX_BYTES_FIELD_NUMBER = 7;
  private long maxBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. The maximum bytes that can be written to a Cloud Storage file
   * before a new file is created. Min 1 KB, max 10 GiB. The max_bytes limit may
   * be exceeded in cases where messages are larger than the limit.
   * </pre>
   *
   * <code>int64 max_bytes = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxBytes.
   */
  @java.lang.Override
  public long getMaxBytes() {
    return maxBytes_;
  }

  public static final int MAX_MESSAGES_FIELD_NUMBER = 8;
  private long maxMessages_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. The maximum number of messages that can be written to a Cloud
   * Storage file before a new file is created. Min 1000 messages.
   * </pre>
   *
   * <code>int64 max_messages = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxMessages.
   */
  @java.lang.Override
  public long getMaxMessages() {
    return maxMessages_;
  }

  public static final int STATE_FIELD_NUMBER = 9;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. An output-only field that indicates whether or not the
   * subscription can receive messages.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.CloudStorageConfig.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. An output-only field that indicates whether or not the
   * subscription can receive messages.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.CloudStorageConfig.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.pubsub.v1.CloudStorageConfig.State getState() {
    com.google.pubsub.v1.CloudStorageConfig.State result =
        com.google.pubsub.v1.CloudStorageConfig.State.forNumber(state_);
    return result == null ? com.google.pubsub.v1.CloudStorageConfig.State.UNRECOGNIZED : result;
  }

  public static final int SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccountEmail_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The service account to use to write to Cloud Storage. The
   * subscription creator or updater that specifies this field must have
   * `iam.serviceAccounts.actAs` permission on the service account. If not
   * specified, the Pub/Sub
   * [service agent](https://cloud.google.com/iam/docs/service-agents),
   * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
   * </pre>
   *
   * <code>string service_account_email = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccountEmail.
   */
  @java.lang.Override
  public java.lang.String getServiceAccountEmail() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccountEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The service account to use to write to Cloud Storage. The
   * subscription creator or updater that specifies this field must have
   * `iam.serviceAccounts.actAs` permission on the service account. If not
   * specified, the Pub/Sub
   * [service agent](https://cloud.google.com/iam/docs/service-agents),
   * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
   * </pre>
   *
   * <code>string service_account_email = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccountEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccountEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucket_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filenamePrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filenamePrefix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filenameSuffix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, filenameSuffix_);
    }
    if (outputFormatCase_ == 4) {
      output.writeMessage(4, (com.google.pubsub.v1.CloudStorageConfig.TextConfig) outputFormat_);
    }
    if (outputFormatCase_ == 5) {
      output.writeMessage(5, (com.google.pubsub.v1.CloudStorageConfig.AvroConfig) outputFormat_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getMaxDuration());
    }
    if (maxBytes_ != 0L) {
      output.writeInt64(7, maxBytes_);
    }
    if (maxMessages_ != 0L) {
      output.writeInt64(8, maxMessages_);
    }
    if (state_ != com.google.pubsub.v1.CloudStorageConfig.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filenameDatetimeFormat_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, filenameDatetimeFormat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, serviceAccountEmail_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, bucket_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filenamePrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filenamePrefix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filenameSuffix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, filenameSuffix_);
    }
    if (outputFormatCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.pubsub.v1.CloudStorageConfig.TextConfig) outputFormat_);
    }
    if (outputFormatCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.pubsub.v1.CloudStorageConfig.AvroConfig) outputFormat_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getMaxDuration());
    }
    if (maxBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, maxBytes_);
    }
    if (maxMessages_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, maxMessages_);
    }
    if (state_ != com.google.pubsub.v1.CloudStorageConfig.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filenameDatetimeFormat_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, filenameDatetimeFormat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, serviceAccountEmail_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.CloudStorageConfig)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.CloudStorageConfig other = (com.google.pubsub.v1.CloudStorageConfig) obj;

    if (!getBucket().equals(other.getBucket())) return false;
    if (!getFilenamePrefix().equals(other.getFilenamePrefix())) return false;
    if (!getFilenameSuffix().equals(other.getFilenameSuffix())) return false;
    if (!getFilenameDatetimeFormat().equals(other.getFilenameDatetimeFormat())) return false;
    if (hasMaxDuration() != other.hasMaxDuration()) return false;
    if (hasMaxDuration()) {
      if (!getMaxDuration().equals(other.getMaxDuration())) return false;
    }
    if (getMaxBytes() != other.getMaxBytes()) return false;
    if (getMaxMessages() != other.getMaxMessages()) return false;
    if (state_ != other.state_) return false;
    if (!getServiceAccountEmail().equals(other.getServiceAccountEmail())) return false;
    if (!getOutputFormatCase().equals(other.getOutputFormatCase())) return false;
    switch (outputFormatCase_) {
      case 4:
        if (!getTextConfig().equals(other.getTextConfig())) return false;
        break;
      case 5:
        if (!getAvroConfig().equals(other.getAvroConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getBucket().hashCode();
    hash = (37 * hash) + FILENAME_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getFilenamePrefix().hashCode();
    hash = (37 * hash) + FILENAME_SUFFIX_FIELD_NUMBER;
    hash = (53 * hash) + getFilenameSuffix().hashCode();
    hash = (37 * hash) + FILENAME_DATETIME_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + getFilenameDatetimeFormat().hashCode();
    if (hasMaxDuration()) {
      hash = (37 * hash) + MAX_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getMaxDuration().hashCode();
    }
    hash = (37 * hash) + MAX_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxBytes());
    hash = (37 * hash) + MAX_MESSAGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxMessages());
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccountEmail().hashCode();
    switch (outputFormatCase_) {
      case 4:
        hash = (37 * hash) + TEXT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTextConfig().hashCode();
        break;
      case 5:
        hash = (37 * hash) + AVRO_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getAvroConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.CloudStorageConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.CloudStorageConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.CloudStorageConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.CloudStorageConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.CloudStorageConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.CloudStorageConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.CloudStorageConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.CloudStorageConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.CloudStorageConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.CloudStorageConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.CloudStorageConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.CloudStorageConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.CloudStorageConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a Cloud Storage subscription.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.CloudStorageConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.CloudStorageConfig)
      com.google.pubsub.v1.CloudStorageConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_CloudStorageConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_CloudStorageConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.CloudStorageConfig.class,
              com.google.pubsub.v1.CloudStorageConfig.Builder.class);
    }

    // Construct using com.google.pubsub.v1.CloudStorageConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMaxDurationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bucket_ = "";
      filenamePrefix_ = "";
      filenameSuffix_ = "";
      filenameDatetimeFormat_ = "";
      if (textConfigBuilder_ != null) {
        textConfigBuilder_.clear();
      }
      if (avroConfigBuilder_ != null) {
        avroConfigBuilder_.clear();
      }
      maxDuration_ = null;
      if (maxDurationBuilder_ != null) {
        maxDurationBuilder_.dispose();
        maxDurationBuilder_ = null;
      }
      maxBytes_ = 0L;
      maxMessages_ = 0L;
      state_ = 0;
      serviceAccountEmail_ = "";
      outputFormatCase_ = 0;
      outputFormat_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_CloudStorageConfig_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.CloudStorageConfig getDefaultInstanceForType() {
      return com.google.pubsub.v1.CloudStorageConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.CloudStorageConfig build() {
      com.google.pubsub.v1.CloudStorageConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.CloudStorageConfig buildPartial() {
      com.google.pubsub.v1.CloudStorageConfig result =
          new com.google.pubsub.v1.CloudStorageConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.pubsub.v1.CloudStorageConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.bucket_ = bucket_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.filenamePrefix_ = filenamePrefix_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filenameSuffix_ = filenameSuffix_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.filenameDatetimeFormat_ = filenameDatetimeFormat_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.maxDuration_ =
            maxDurationBuilder_ == null ? maxDuration_ : maxDurationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.maxBytes_ = maxBytes_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.maxMessages_ = maxMessages_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.serviceAccountEmail_ = serviceAccountEmail_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.pubsub.v1.CloudStorageConfig result) {
      result.outputFormatCase_ = outputFormatCase_;
      result.outputFormat_ = this.outputFormat_;
      if (outputFormatCase_ == 4 && textConfigBuilder_ != null) {
        result.outputFormat_ = textConfigBuilder_.build();
      }
      if (outputFormatCase_ == 5 && avroConfigBuilder_ != null) {
        result.outputFormat_ = avroConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.CloudStorageConfig) {
        return mergeFrom((com.google.pubsub.v1.CloudStorageConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.CloudStorageConfig other) {
      if (other == com.google.pubsub.v1.CloudStorageConfig.getDefaultInstance()) return this;
      if (!other.getBucket().isEmpty()) {
        bucket_ = other.bucket_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getFilenamePrefix().isEmpty()) {
        filenamePrefix_ = other.filenamePrefix_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getFilenameSuffix().isEmpty()) {
        filenameSuffix_ = other.filenameSuffix_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getFilenameDatetimeFormat().isEmpty()) {
        filenameDatetimeFormat_ = other.filenameDatetimeFormat_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasMaxDuration()) {
        mergeMaxDuration(other.getMaxDuration());
      }
      if (other.getMaxBytes() != 0L) {
        setMaxBytes(other.getMaxBytes());
      }
      if (other.getMaxMessages() != 0L) {
        setMaxMessages(other.getMaxMessages());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getServiceAccountEmail().isEmpty()) {
        serviceAccountEmail_ = other.serviceAccountEmail_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      switch (other.getOutputFormatCase()) {
        case TEXT_CONFIG:
          {
            mergeTextConfig(other.getTextConfig());
            break;
          }
        case AVRO_CONFIG:
          {
            mergeAvroConfig(other.getAvroConfig());
            break;
          }
        case OUTPUTFORMAT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                bucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                filenamePrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                filenameSuffix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTextConfigFieldBuilder().getBuilder(), extensionRegistry);
                outputFormatCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getAvroConfigFieldBuilder().getBuilder(), extensionRegistry);
                outputFormatCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getMaxDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 56:
              {
                maxBytes_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 56
            case 64:
              {
                maxMessages_ = input.readInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 64
            case 72:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 72
            case 82:
              {
                filenameDatetimeFormat_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 82
            case 90:
              {
                serviceAccountEmail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int outputFormatCase_ = 0;
    private java.lang.Object outputFormat_;

    public OutputFormatCase getOutputFormatCase() {
      return OutputFormatCase.forNumber(outputFormatCase_);
    }

    public Builder clearOutputFormat() {
      outputFormatCase_ = 0;
      outputFormat_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object bucket_ = "";
    /**
     *
     *
     * <pre>
     * Required. User-provided name for the Cloud Storage bucket.
     * The bucket must be created by the user. The bucket name must be without
     * any prefix like "gs://". See the [bucket naming
     * requirements] (https://cloud.google.com/storage/docs/buckets#naming).
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucket.
     */
    public java.lang.String getBucket() {
      java.lang.Object ref = bucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User-provided name for the Cloud Storage bucket.
     * The bucket must be created by the user. The bucket name must be without
     * any prefix like "gs://". See the [bucket naming
     * requirements] (https://cloud.google.com/storage/docs/buckets#naming).
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucket.
     */
    public com.google.protobuf.ByteString getBucketBytes() {
      java.lang.Object ref = bucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User-provided name for the Cloud Storage bucket.
     * The bucket must be created by the user. The bucket name must be without
     * any prefix like "gs://". See the [bucket naming
     * requirements] (https://cloud.google.com/storage/docs/buckets#naming).
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bucket to set.
     * @return This builder for chaining.
     */
    public Builder setBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bucket_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User-provided name for the Cloud Storage bucket.
     * The bucket must be created by the user. The bucket name must be without
     * any prefix like "gs://". See the [bucket naming
     * requirements] (https://cloud.google.com/storage/docs/buckets#naming).
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucket() {
      bucket_ = getDefaultInstance().getBucket();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User-provided name for the Cloud Storage bucket.
     * The bucket must be created by the user. The bucket name must be without
     * any prefix like "gs://". See the [bucket naming
     * requirements] (https://cloud.google.com/storage/docs/buckets#naming).
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for bucket to set.
     * @return This builder for chaining.
     */
    public Builder setBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bucket_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object filenamePrefix_ = "";
    /**
     *
     *
     * <pre>
     * Optional. User-provided prefix for Cloud Storage filename. See the [object
     * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
     * </pre>
     *
     * <code>string filename_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filenamePrefix.
     */
    public java.lang.String getFilenamePrefix() {
      java.lang.Object ref = filenamePrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filenamePrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided prefix for Cloud Storage filename. See the [object
     * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
     * </pre>
     *
     * <code>string filename_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filenamePrefix.
     */
    public com.google.protobuf.ByteString getFilenamePrefixBytes() {
      java.lang.Object ref = filenamePrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filenamePrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided prefix for Cloud Storage filename. See the [object
     * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
     * </pre>
     *
     * <code>string filename_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filenamePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setFilenamePrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filenamePrefix_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided prefix for Cloud Storage filename. See the [object
     * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
     * </pre>
     *
     * <code>string filename_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilenamePrefix() {
      filenamePrefix_ = getDefaultInstance().getFilenamePrefix();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided prefix for Cloud Storage filename. See the [object
     * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
     * </pre>
     *
     * <code>string filename_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for filenamePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setFilenamePrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filenamePrefix_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object filenameSuffix_ = "";
    /**
     *
     *
     * <pre>
     * Optional. User-provided suffix for Cloud Storage filename. See the [object
     * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
     * Must not end in "/".
     * </pre>
     *
     * <code>string filename_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filenameSuffix.
     */
    public java.lang.String getFilenameSuffix() {
      java.lang.Object ref = filenameSuffix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filenameSuffix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided suffix for Cloud Storage filename. See the [object
     * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
     * Must not end in "/".
     * </pre>
     *
     * <code>string filename_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filenameSuffix.
     */
    public com.google.protobuf.ByteString getFilenameSuffixBytes() {
      java.lang.Object ref = filenameSuffix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filenameSuffix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided suffix for Cloud Storage filename. See the [object
     * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
     * Must not end in "/".
     * </pre>
     *
     * <code>string filename_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filenameSuffix to set.
     * @return This builder for chaining.
     */
    public Builder setFilenameSuffix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filenameSuffix_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided suffix for Cloud Storage filename. See the [object
     * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
     * Must not end in "/".
     * </pre>
     *
     * <code>string filename_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilenameSuffix() {
      filenameSuffix_ = getDefaultInstance().getFilenameSuffix();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided suffix for Cloud Storage filename. See the [object
     * naming requirements](https://cloud.google.com/storage/docs/objects#naming).
     * Must not end in "/".
     * </pre>
     *
     * <code>string filename_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for filenameSuffix to set.
     * @return This builder for chaining.
     */
    public Builder setFilenameSuffixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filenameSuffix_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object filenameDatetimeFormat_ = "";
    /**
     *
     *
     * <pre>
     * Optional. User-provided format string specifying how to represent datetimes
     * in Cloud Storage filenames. See the [datetime format
     * guidance](https://cloud.google.com/pubsub/docs/create-cloudstorage-subscription#file_names).
     * </pre>
     *
     * <code>string filename_datetime_format = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filenameDatetimeFormat.
     */
    public java.lang.String getFilenameDatetimeFormat() {
      java.lang.Object ref = filenameDatetimeFormat_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filenameDatetimeFormat_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided format string specifying how to represent datetimes
     * in Cloud Storage filenames. See the [datetime format
     * guidance](https://cloud.google.com/pubsub/docs/create-cloudstorage-subscription#file_names).
     * </pre>
     *
     * <code>string filename_datetime_format = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filenameDatetimeFormat.
     */
    public com.google.protobuf.ByteString getFilenameDatetimeFormatBytes() {
      java.lang.Object ref = filenameDatetimeFormat_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filenameDatetimeFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided format string specifying how to represent datetimes
     * in Cloud Storage filenames. See the [datetime format
     * guidance](https://cloud.google.com/pubsub/docs/create-cloudstorage-subscription#file_names).
     * </pre>
     *
     * <code>string filename_datetime_format = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filenameDatetimeFormat to set.
     * @return This builder for chaining.
     */
    public Builder setFilenameDatetimeFormat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filenameDatetimeFormat_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided format string specifying how to represent datetimes
     * in Cloud Storage filenames. See the [datetime format
     * guidance](https://cloud.google.com/pubsub/docs/create-cloudstorage-subscription#file_names).
     * </pre>
     *
     * <code>string filename_datetime_format = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilenameDatetimeFormat() {
      filenameDatetimeFormat_ = getDefaultInstance().getFilenameDatetimeFormat();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided format string specifying how to represent datetimes
     * in Cloud Storage filenames. See the [datetime format
     * guidance](https://cloud.google.com/pubsub/docs/create-cloudstorage-subscription#file_names).
     * </pre>
     *
     * <code>string filename_datetime_format = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for filenameDatetimeFormat to set.
     * @return This builder for chaining.
     */
    public Builder setFilenameDatetimeFormatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filenameDatetimeFormat_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.CloudStorageConfig.TextConfig,
            com.google.pubsub.v1.CloudStorageConfig.TextConfig.Builder,
            com.google.pubsub.v1.CloudStorageConfig.TextConfigOrBuilder>
        textConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in text
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.TextConfig text_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the textConfig field is set.
     */
    @java.lang.Override
    public boolean hasTextConfig() {
      return outputFormatCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in text
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.TextConfig text_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The textConfig.
     */
    @java.lang.Override
    public com.google.pubsub.v1.CloudStorageConfig.TextConfig getTextConfig() {
      if (textConfigBuilder_ == null) {
        if (outputFormatCase_ == 4) {
          return (com.google.pubsub.v1.CloudStorageConfig.TextConfig) outputFormat_;
        }
        return com.google.pubsub.v1.CloudStorageConfig.TextConfig.getDefaultInstance();
      } else {
        if (outputFormatCase_ == 4) {
          return textConfigBuilder_.getMessage();
        }
        return com.google.pubsub.v1.CloudStorageConfig.TextConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in text
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.TextConfig text_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTextConfig(com.google.pubsub.v1.CloudStorageConfig.TextConfig value) {
      if (textConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputFormat_ = value;
        onChanged();
      } else {
        textConfigBuilder_.setMessage(value);
      }
      outputFormatCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in text
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.TextConfig text_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTextConfig(
        com.google.pubsub.v1.CloudStorageConfig.TextConfig.Builder builderForValue) {
      if (textConfigBuilder_ == null) {
        outputFormat_ = builderForValue.build();
        onChanged();
      } else {
        textConfigBuilder_.setMessage(builderForValue.build());
      }
      outputFormatCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in text
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.TextConfig text_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTextConfig(com.google.pubsub.v1.CloudStorageConfig.TextConfig value) {
      if (textConfigBuilder_ == null) {
        if (outputFormatCase_ == 4
            && outputFormat_
                != com.google.pubsub.v1.CloudStorageConfig.TextConfig.getDefaultInstance()) {
          outputFormat_ =
              com.google.pubsub.v1.CloudStorageConfig.TextConfig.newBuilder(
                      (com.google.pubsub.v1.CloudStorageConfig.TextConfig) outputFormat_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputFormat_ = value;
        }
        onChanged();
      } else {
        if (outputFormatCase_ == 4) {
          textConfigBuilder_.mergeFrom(value);
        } else {
          textConfigBuilder_.setMessage(value);
        }
      }
      outputFormatCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in text
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.TextConfig text_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTextConfig() {
      if (textConfigBuilder_ == null) {
        if (outputFormatCase_ == 4) {
          outputFormatCase_ = 0;
          outputFormat_ = null;
          onChanged();
        }
      } else {
        if (outputFormatCase_ == 4) {
          outputFormatCase_ = 0;
          outputFormat_ = null;
        }
        textConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in text
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.TextConfig text_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.CloudStorageConfig.TextConfig.Builder getTextConfigBuilder() {
      return getTextConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in text
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.TextConfig text_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.CloudStorageConfig.TextConfigOrBuilder getTextConfigOrBuilder() {
      if ((outputFormatCase_ == 4) && (textConfigBuilder_ != null)) {
        return textConfigBuilder_.getMessageOrBuilder();
      } else {
        if (outputFormatCase_ == 4) {
          return (com.google.pubsub.v1.CloudStorageConfig.TextConfig) outputFormat_;
        }
        return com.google.pubsub.v1.CloudStorageConfig.TextConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in text
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.TextConfig text_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.CloudStorageConfig.TextConfig,
            com.google.pubsub.v1.CloudStorageConfig.TextConfig.Builder,
            com.google.pubsub.v1.CloudStorageConfig.TextConfigOrBuilder>
        getTextConfigFieldBuilder() {
      if (textConfigBuilder_ == null) {
        if (!(outputFormatCase_ == 4)) {
          outputFormat_ = com.google.pubsub.v1.CloudStorageConfig.TextConfig.getDefaultInstance();
        }
        textConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.CloudStorageConfig.TextConfig,
                com.google.pubsub.v1.CloudStorageConfig.TextConfig.Builder,
                com.google.pubsub.v1.CloudStorageConfig.TextConfigOrBuilder>(
                (com.google.pubsub.v1.CloudStorageConfig.TextConfig) outputFormat_,
                getParentForChildren(),
                isClean());
        outputFormat_ = null;
      }
      outputFormatCase_ = 4;
      onChanged();
      return textConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.CloudStorageConfig.AvroConfig,
            com.google.pubsub.v1.CloudStorageConfig.AvroConfig.Builder,
            com.google.pubsub.v1.CloudStorageConfig.AvroConfigOrBuilder>
        avroConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in Avro
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.AvroConfig avro_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the avroConfig field is set.
     */
    @java.lang.Override
    public boolean hasAvroConfig() {
      return outputFormatCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in Avro
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.AvroConfig avro_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The avroConfig.
     */
    @java.lang.Override
    public com.google.pubsub.v1.CloudStorageConfig.AvroConfig getAvroConfig() {
      if (avroConfigBuilder_ == null) {
        if (outputFormatCase_ == 5) {
          return (com.google.pubsub.v1.CloudStorageConfig.AvroConfig) outputFormat_;
        }
        return com.google.pubsub.v1.CloudStorageConfig.AvroConfig.getDefaultInstance();
      } else {
        if (outputFormatCase_ == 5) {
          return avroConfigBuilder_.getMessage();
        }
        return com.google.pubsub.v1.CloudStorageConfig.AvroConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in Avro
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.AvroConfig avro_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAvroConfig(com.google.pubsub.v1.CloudStorageConfig.AvroConfig value) {
      if (avroConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputFormat_ = value;
        onChanged();
      } else {
        avroConfigBuilder_.setMessage(value);
      }
      outputFormatCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in Avro
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.AvroConfig avro_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAvroConfig(
        com.google.pubsub.v1.CloudStorageConfig.AvroConfig.Builder builderForValue) {
      if (avroConfigBuilder_ == null) {
        outputFormat_ = builderForValue.build();
        onChanged();
      } else {
        avroConfigBuilder_.setMessage(builderForValue.build());
      }
      outputFormatCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in Avro
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.AvroConfig avro_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAvroConfig(com.google.pubsub.v1.CloudStorageConfig.AvroConfig value) {
      if (avroConfigBuilder_ == null) {
        if (outputFormatCase_ == 5
            && outputFormat_
                != com.google.pubsub.v1.CloudStorageConfig.AvroConfig.getDefaultInstance()) {
          outputFormat_ =
              com.google.pubsub.v1.CloudStorageConfig.AvroConfig.newBuilder(
                      (com.google.pubsub.v1.CloudStorageConfig.AvroConfig) outputFormat_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputFormat_ = value;
        }
        onChanged();
      } else {
        if (outputFormatCase_ == 5) {
          avroConfigBuilder_.mergeFrom(value);
        } else {
          avroConfigBuilder_.setMessage(value);
        }
      }
      outputFormatCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in Avro
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.AvroConfig avro_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAvroConfig() {
      if (avroConfigBuilder_ == null) {
        if (outputFormatCase_ == 5) {
          outputFormatCase_ = 0;
          outputFormat_ = null;
          onChanged();
        }
      } else {
        if (outputFormatCase_ == 5) {
          outputFormatCase_ = 0;
          outputFormat_ = null;
        }
        avroConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in Avro
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.AvroConfig avro_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.CloudStorageConfig.AvroConfig.Builder getAvroConfigBuilder() {
      return getAvroConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in Avro
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.AvroConfig avro_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.CloudStorageConfig.AvroConfigOrBuilder getAvroConfigOrBuilder() {
      if ((outputFormatCase_ == 5) && (avroConfigBuilder_ != null)) {
        return avroConfigBuilder_.getMessageOrBuilder();
      } else {
        if (outputFormatCase_ == 5) {
          return (com.google.pubsub.v1.CloudStorageConfig.AvroConfig) outputFormat_;
        }
        return com.google.pubsub.v1.CloudStorageConfig.AvroConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, message data will be written to Cloud Storage in Avro
     * format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.AvroConfig avro_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.CloudStorageConfig.AvroConfig,
            com.google.pubsub.v1.CloudStorageConfig.AvroConfig.Builder,
            com.google.pubsub.v1.CloudStorageConfig.AvroConfigOrBuilder>
        getAvroConfigFieldBuilder() {
      if (avroConfigBuilder_ == null) {
        if (!(outputFormatCase_ == 5)) {
          outputFormat_ = com.google.pubsub.v1.CloudStorageConfig.AvroConfig.getDefaultInstance();
        }
        avroConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.CloudStorageConfig.AvroConfig,
                com.google.pubsub.v1.CloudStorageConfig.AvroConfig.Builder,
                com.google.pubsub.v1.CloudStorageConfig.AvroConfigOrBuilder>(
                (com.google.pubsub.v1.CloudStorageConfig.AvroConfig) outputFormat_,
                getParentForChildren(),
                isClean());
        outputFormat_ = null;
      }
      outputFormatCase_ = 5;
      onChanged();
      return avroConfigBuilder_;
    }

    private com.google.protobuf.Duration maxDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        maxDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The maximum duration that can elapse before a new Cloud Storage
     * file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
     * exceed the subscription's acknowledgement deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the maxDuration field is set.
     */
    public boolean hasMaxDuration() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum duration that can elapse before a new Cloud Storage
     * file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
     * exceed the subscription's acknowledgement deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The maxDuration.
     */
    public com.google.protobuf.Duration getMaxDuration() {
      if (maxDurationBuilder_ == null) {
        return maxDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxDuration_;
      } else {
        return maxDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum duration that can elapse before a new Cloud Storage
     * file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
     * exceed the subscription's acknowledgement deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMaxDuration(com.google.protobuf.Duration value) {
      if (maxDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxDuration_ = value;
      } else {
        maxDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum duration that can elapse before a new Cloud Storage
     * file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
     * exceed the subscription's acknowledgement deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMaxDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (maxDurationBuilder_ == null) {
        maxDuration_ = builderForValue.build();
      } else {
        maxDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum duration that can elapse before a new Cloud Storage
     * file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
     * exceed the subscription's acknowledgement deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMaxDuration(com.google.protobuf.Duration value) {
      if (maxDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && maxDuration_ != null
            && maxDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getMaxDurationBuilder().mergeFrom(value);
        } else {
          maxDuration_ = value;
        }
      } else {
        maxDurationBuilder_.mergeFrom(value);
      }
      if (maxDuration_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum duration that can elapse before a new Cloud Storage
     * file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
     * exceed the subscription's acknowledgement deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMaxDuration() {
      bitField0_ = (bitField0_ & ~0x00000040);
      maxDuration_ = null;
      if (maxDurationBuilder_ != null) {
        maxDurationBuilder_.dispose();
        maxDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum duration that can elapse before a new Cloud Storage
     * file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
     * exceed the subscription's acknowledgement deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getMaxDurationBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getMaxDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum duration that can elapse before a new Cloud Storage
     * file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
     * exceed the subscription's acknowledgement deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getMaxDurationOrBuilder() {
      if (maxDurationBuilder_ != null) {
        return maxDurationBuilder_.getMessageOrBuilder();
      } else {
        return maxDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum duration that can elapse before a new Cloud Storage
     * file is created. Min 1 minute, max 10 minutes, default 5 minutes. May not
     * exceed the subscription's acknowledgement deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMaxDurationFieldBuilder() {
      if (maxDurationBuilder_ == null) {
        maxDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMaxDuration(), getParentForChildren(), isClean());
        maxDuration_ = null;
      }
      return maxDurationBuilder_;
    }

    private long maxBytes_;
    /**
     *
     *
     * <pre>
     * Optional. The maximum bytes that can be written to a Cloud Storage file
     * before a new file is created. Min 1 KB, max 10 GiB. The max_bytes limit may
     * be exceeded in cases where messages are larger than the limit.
     * </pre>
     *
     * <code>int64 max_bytes = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxBytes.
     */
    @java.lang.Override
    public long getMaxBytes() {
      return maxBytes_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum bytes that can be written to a Cloud Storage file
     * before a new file is created. Min 1 KB, max 10 GiB. The max_bytes limit may
     * be exceeded in cases where messages are larger than the limit.
     * </pre>
     *
     * <code>int64 max_bytes = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxBytes to set.
     * @return This builder for chaining.
     */
    public Builder setMaxBytes(long value) {

      maxBytes_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum bytes that can be written to a Cloud Storage file
     * before a new file is created. Min 1 KB, max 10 GiB. The max_bytes limit may
     * be exceeded in cases where messages are larger than the limit.
     * </pre>
     *
     * <code>int64 max_bytes = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxBytes() {
      bitField0_ = (bitField0_ & ~0x00000080);
      maxBytes_ = 0L;
      onChanged();
      return this;
    }

    private long maxMessages_;
    /**
     *
     *
     * <pre>
     * Optional. The maximum number of messages that can be written to a Cloud
     * Storage file before a new file is created. Min 1000 messages.
     * </pre>
     *
     * <code>int64 max_messages = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxMessages.
     */
    @java.lang.Override
    public long getMaxMessages() {
      return maxMessages_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum number of messages that can be written to a Cloud
     * Storage file before a new file is created. Min 1000 messages.
     * </pre>
     *
     * <code>int64 max_messages = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxMessages to set.
     * @return This builder for chaining.
     */
    public Builder setMaxMessages(long value) {

      maxMessages_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum number of messages that can be written to a Cloud
     * Storage file before a new file is created. Min 1000 messages.
     * </pre>
     *
     * <code>int64 max_messages = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxMessages() {
      bitField0_ = (bitField0_ & ~0x00000100);
      maxMessages_ = 0L;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.pubsub.v1.CloudStorageConfig.State getState() {
      com.google.pubsub.v1.CloudStorageConfig.State result =
          com.google.pubsub.v1.CloudStorageConfig.State.forNumber(state_);
      return result == null ? com.google.pubsub.v1.CloudStorageConfig.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.pubsub.v1.CloudStorageConfig.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.CloudStorageConfig.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000200);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccountEmail_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The service account to use to write to Cloud Storage. The
     * subscription creator or updater that specifies this field must have
     * `iam.serviceAccounts.actAs` permission on the service account. If not
     * specified, the Pub/Sub
     * [service agent](https://cloud.google.com/iam/docs/service-agents),
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     * </pre>
     *
     * <code>string service_account_email = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccountEmail.
     */
    public java.lang.String getServiceAccountEmail() {
      java.lang.Object ref = serviceAccountEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccountEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account to use to write to Cloud Storage. The
     * subscription creator or updater that specifies this field must have
     * `iam.serviceAccounts.actAs` permission on the service account. If not
     * specified, the Pub/Sub
     * [service agent](https://cloud.google.com/iam/docs/service-agents),
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     * </pre>
     *
     * <code>string service_account_email = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccountEmail.
     */
    public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
      java.lang.Object ref = serviceAccountEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccountEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account to use to write to Cloud Storage. The
     * subscription creator or updater that specifies this field must have
     * `iam.serviceAccounts.actAs` permission on the service account. If not
     * specified, the Pub/Sub
     * [service agent](https://cloud.google.com/iam/docs/service-agents),
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     * </pre>
     *
     * <code>string service_account_email = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccountEmail_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account to use to write to Cloud Storage. The
     * subscription creator or updater that specifies this field must have
     * `iam.serviceAccounts.actAs` permission on the service account. If not
     * specified, the Pub/Sub
     * [service agent](https://cloud.google.com/iam/docs/service-agents),
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     * </pre>
     *
     * <code>string service_account_email = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccountEmail() {
      serviceAccountEmail_ = getDefaultInstance().getServiceAccountEmail();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The service account to use to write to Cloud Storage. The
     * subscription creator or updater that specifies this field must have
     * `iam.serviceAccounts.actAs` permission on the service account. If not
     * specified, the Pub/Sub
     * [service agent](https://cloud.google.com/iam/docs/service-agents),
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com, is used.
     * </pre>
     *
     * <code>string service_account_email = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccountEmail_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.CloudStorageConfig)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.CloudStorageConfig)
  private static final com.google.pubsub.v1.CloudStorageConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.CloudStorageConfig();
  }

  public static com.google.pubsub.v1.CloudStorageConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudStorageConfig> PARSER =
      new com.google.protobuf.AbstractParser<CloudStorageConfig>() {
        @java.lang.Override
        public CloudStorageConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudStorageConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudStorageConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.CloudStorageConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
