/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

// Protobuf Java Version: 3.25.5
package com.google.pubsub.v1;

public interface SchemaSettingsOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.pubsub.v1.SchemaSettings)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The name of the schema that messages published should be
   * validated against. Format is `projects/{project}/schemas/{schema}`. The
   * value of this field will be `_deleted-schema_` if the schema has been
   * deleted.
   * </pre>
   *
   * <code>
   * string schema = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The schema.
   */
  java.lang.String getSchema();
  /**
   *
   *
   * <pre>
   * Required. The name of the schema that messages published should be
   * validated against. Format is `projects/{project}/schemas/{schema}`. The
   * value of this field will be `_deleted-schema_` if the schema has been
   * deleted.
   * </pre>
   *
   * <code>
   * string schema = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for schema.
   */
  com.google.protobuf.ByteString getSchemaBytes();

  /**
   *
   *
   * <pre>
   * Optional. The encoding of messages validated against `schema`.
   * </pre>
   *
   * <code>.google.pubsub.v1.Encoding encoding = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enum numeric value on the wire for encoding.
   */
  int getEncodingValue();
  /**
   *
   *
   * <pre>
   * Optional. The encoding of messages validated against `schema`.
   * </pre>
   *
   * <code>.google.pubsub.v1.Encoding encoding = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The encoding.
   */
  com.google.pubsub.v1.Encoding getEncoding();

  /**
   *
   *
   * <pre>
   * Optional. The minimum (inclusive) revision allowed for validating messages.
   * If empty or not present, allow any revision to be validated against
   * last_revision or any revision created before.
   * </pre>
   *
   * <code>string first_revision_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The firstRevisionId.
   */
  java.lang.String getFirstRevisionId();
  /**
   *
   *
   * <pre>
   * Optional. The minimum (inclusive) revision allowed for validating messages.
   * If empty or not present, allow any revision to be validated against
   * last_revision or any revision created before.
   * </pre>
   *
   * <code>string first_revision_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for firstRevisionId.
   */
  com.google.protobuf.ByteString getFirstRevisionIdBytes();

  /**
   *
   *
   * <pre>
   * Optional. The maximum (inclusive) revision allowed for validating messages.
   * If empty or not present, allow any revision to be validated against
   * first_revision or any revision created after.
   * </pre>
   *
   * <code>string last_revision_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The lastRevisionId.
   */
  java.lang.String getLastRevisionId();
  /**
   *
   *
   * <pre>
   * Optional. The maximum (inclusive) revision allowed for validating messages.
   * If empty or not present, allow any revision to be validated against
   * first_revision or any revision created after.
   * </pre>
   *
   * <code>string last_revision_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for lastRevisionId.
   */
  com.google.protobuf.ByteString getLastRevisionIdBytes();
}
