/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

// Protobuf Java Version: 3.25.5
package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * Payload of the Platform Log entry sent when a failure is encountered while
 * ingesting.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.IngestionFailureEvent}
 */
public final class IngestionFailureEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionFailureEvent)
    IngestionFailureEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IngestionFailureEvent.newBuilder() to construct.
  private IngestionFailureEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IngestionFailureEvent() {
    topic_ = "";
    errorMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IngestionFailureEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_IngestionFailureEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_IngestionFailureEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.IngestionFailureEvent.class,
            com.google.pubsub.v1.IngestionFailureEvent.Builder.class);
  }

  public interface ApiViolationReasonOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionFailureEvent.ApiViolationReason)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Specifies the reason why some data may have been left out of
   * the desired Pub/Sub message due to the API message limits
   * (https://cloud.google.com/pubsub/quotas#resource_limits). For example,
   * when the number of attributes is larger than 100, the number of
   * attributes is truncated to 100 to respect the limit on the attribute count.
   * Other attribute limits are treated similarly. When the size of the desired
   * message would've been larger than 10MB, the message won't be published at
   * all, and ingestion of the subsequent messages will proceed as normal.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionFailureEvent.ApiViolationReason}
   */
  public static final class ApiViolationReason extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionFailureEvent.ApiViolationReason)
      ApiViolationReasonOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ApiViolationReason.newBuilder() to construct.
    private ApiViolationReason(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ApiViolationReason() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ApiViolationReason();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionFailureEvent_ApiViolationReason_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionFailureEvent_ApiViolationReason_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.class,
              com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason other =
          (com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies the reason why some data may have been left out of
     * the desired Pub/Sub message due to the API message limits
     * (https://cloud.google.com/pubsub/quotas#resource_limits). For example,
     * when the number of attributes is larger than 100, the number of
     * attributes is truncated to 100 to respect the limit on the attribute count.
     * Other attribute limits are treated similarly. When the size of the desired
     * message would've been larger than 10MB, the message won't be published at
     * all, and ingestion of the subsequent messages will proceed as normal.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionFailureEvent.ApiViolationReason}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionFailureEvent.ApiViolationReason)
        com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReasonOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionFailureEvent_ApiViolationReason_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionFailureEvent_ApiViolationReason_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.class,
                com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.Builder.class);
      }

      // Construct using com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionFailureEvent_ApiViolationReason_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
          getDefaultInstanceForType() {
        return com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason build() {
        com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason buildPartial() {
        com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason result =
            new com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason) {
          return mergeFrom((com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason other) {
        if (other
            == com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionFailureEvent.ApiViolationReason)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionFailureEvent.ApiViolationReason)
    private static final com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason();
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ApiViolationReason> PARSER =
        new com.google.protobuf.AbstractParser<ApiViolationReason>() {
          @java.lang.Override
          public ApiViolationReason parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ApiViolationReason> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ApiViolationReason> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AvroFailureReasonOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionFailureEvent.AvroFailureReason)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Set when an Avro file is unsupported or its format is not valid. When this
   * occurs, one or more Avro objects won't be ingested.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionFailureEvent.AvroFailureReason}
   */
  public static final class AvroFailureReason extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionFailureEvent.AvroFailureReason)
      AvroFailureReasonOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AvroFailureReason.newBuilder() to construct.
    private AvroFailureReason(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AvroFailureReason() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AvroFailureReason();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionFailureEvent_AvroFailureReason_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionFailureEvent_AvroFailureReason_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.class,
              com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason other =
          (com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Set when an Avro file is unsupported or its format is not valid. When this
     * occurs, one or more Avro objects won't be ingested.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionFailureEvent.AvroFailureReason}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionFailureEvent.AvroFailureReason)
        com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReasonOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionFailureEvent_AvroFailureReason_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionFailureEvent_AvroFailureReason_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.class,
                com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.Builder.class);
      }

      // Construct using com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionFailureEvent_AvroFailureReason_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
          getDefaultInstanceForType() {
        return com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason build() {
        com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason buildPartial() {
        com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason result =
            new com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason) {
          return mergeFrom((com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason other) {
        if (other
            == com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionFailureEvent.AvroFailureReason)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionFailureEvent.AvroFailureReason)
    private static final com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason();
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AvroFailureReason> PARSER =
        new com.google.protobuf.AbstractParser<AvroFailureReason>() {
          @java.lang.Override
          public AvroFailureReason parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AvroFailureReason> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AvroFailureReason> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CloudStorageFailureOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Name of the Cloud Storage bucket used for ingestion.
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bucket.
     */
    java.lang.String getBucket();
    /**
     *
     *
     * <pre>
     * Optional. Name of the Cloud Storage bucket used for ingestion.
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for bucket.
     */
    com.google.protobuf.ByteString getBucketBytes();

    /**
     *
     *
     * <pre>
     * Optional. Name of the Cloud Storage object which contained the section
     * that couldn't be ingested.
     * </pre>
     *
     * <code>string object_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The objectName.
     */
    java.lang.String getObjectName();
    /**
     *
     *
     * <pre>
     * Optional. Name of the Cloud Storage object which contained the section
     * that couldn't be ingested.
     * </pre>
     *
     * <code>string object_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for objectName.
     */
    com.google.protobuf.ByteString getObjectNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. Generation of the Cloud Storage object which contained the
     * section that couldn't be ingested.
     * </pre>
     *
     * <code>int64 object_generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The objectGeneration.
     */
    long getObjectGeneration();

    /**
     *
     *
     * <pre>
     * Optional. Failure encountered when parsing an Avro file.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the avroFailureReason field is set.
     */
    boolean hasAvroFailureReason();
    /**
     *
     *
     * <pre>
     * Optional. Failure encountered when parsing an Avro file.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The avroFailureReason.
     */
    com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason getAvroFailureReason();
    /**
     *
     *
     * <pre>
     * Optional. Failure encountered when parsing an Avro file.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReasonOrBuilder
        getAvroFailureReasonOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. The Pub/Sub API limits prevented the desired message from
     * being published.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the apiViolationReason field is set.
     */
    boolean hasApiViolationReason();
    /**
     *
     *
     * <pre>
     * Optional. The Pub/Sub API limits prevented the desired message from
     * being published.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The apiViolationReason.
     */
    com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason getApiViolationReason();
    /**
     *
     *
     * <pre>
     * Optional. The Pub/Sub API limits prevented the desired message from
     * being published.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReasonOrBuilder
        getApiViolationReasonOrBuilder();

    com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.ReasonCase getReasonCase();
  }
  /**
   *
   *
   * <pre>
   * Failure when ingesting from a Cloud Storage source.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure}
   */
  public static final class CloudStorageFailure extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure)
      CloudStorageFailureOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CloudStorageFailure.newBuilder() to construct.
    private CloudStorageFailure(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CloudStorageFailure() {
      bucket_ = "";
      objectName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CloudStorageFailure();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionFailureEvent_CloudStorageFailure_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionFailureEvent_CloudStorageFailure_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.class,
              com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.Builder.class);
    }

    private int reasonCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object reason_;

    public enum ReasonCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      AVRO_FAILURE_REASON(5),
      API_VIOLATION_REASON(6),
      REASON_NOT_SET(0);
      private final int value;

      private ReasonCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ReasonCase valueOf(int value) {
        return forNumber(value);
      }

      public static ReasonCase forNumber(int value) {
        switch (value) {
          case 5:
            return AVRO_FAILURE_REASON;
          case 6:
            return API_VIOLATION_REASON;
          case 0:
            return REASON_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ReasonCase getReasonCase() {
      return ReasonCase.forNumber(reasonCase_);
    }

    public static final int BUCKET_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object bucket_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Name of the Cloud Storage bucket used for ingestion.
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bucket.
     */
    @java.lang.Override
    public java.lang.String getBucket() {
      java.lang.Object ref = bucket_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucket_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the Cloud Storage bucket used for ingestion.
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for bucket.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBucketBytes() {
      java.lang.Object ref = bucket_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OBJECT_NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object objectName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Name of the Cloud Storage object which contained the section
     * that couldn't be ingested.
     * </pre>
     *
     * <code>string object_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The objectName.
     */
    @java.lang.Override
    public java.lang.String getObjectName() {
      java.lang.Object ref = objectName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        objectName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the Cloud Storage object which contained the section
     * that couldn't be ingested.
     * </pre>
     *
     * <code>string object_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for objectName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getObjectNameBytes() {
      java.lang.Object ref = objectName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        objectName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OBJECT_GENERATION_FIELD_NUMBER = 3;
    private long objectGeneration_ = 0L;
    /**
     *
     *
     * <pre>
     * Optional. Generation of the Cloud Storage object which contained the
     * section that couldn't be ingested.
     * </pre>
     *
     * <code>int64 object_generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The objectGeneration.
     */
    @java.lang.Override
    public long getObjectGeneration() {
      return objectGeneration_;
    }

    public static final int AVRO_FAILURE_REASON_FIELD_NUMBER = 5;
    /**
     *
     *
     * <pre>
     * Optional. Failure encountered when parsing an Avro file.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the avroFailureReason field is set.
     */
    @java.lang.Override
    public boolean hasAvroFailureReason() {
      return reasonCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Optional. Failure encountered when parsing an Avro file.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The avroFailureReason.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason getAvroFailureReason() {
      if (reasonCase_ == 5) {
        return (com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason) reason_;
      }
      return com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Optional. Failure encountered when parsing an Avro file.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReasonOrBuilder
        getAvroFailureReasonOrBuilder() {
      if (reasonCase_ == 5) {
        return (com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason) reason_;
      }
      return com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.getDefaultInstance();
    }

    public static final int API_VIOLATION_REASON_FIELD_NUMBER = 6;
    /**
     *
     *
     * <pre>
     * Optional. The Pub/Sub API limits prevented the desired message from
     * being published.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the apiViolationReason field is set.
     */
    @java.lang.Override
    public boolean hasApiViolationReason() {
      return reasonCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Pub/Sub API limits prevented the desired message from
     * being published.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The apiViolationReason.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason getApiViolationReason() {
      if (reasonCase_ == 6) {
        return (com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason) reason_;
      }
      return com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Optional. The Pub/Sub API limits prevented the desired message from
     * being published.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReasonOrBuilder
        getApiViolationReasonOrBuilder() {
      if (reasonCase_ == 6) {
        return (com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason) reason_;
      }
      return com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucket_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, objectName_);
      }
      if (objectGeneration_ != 0L) {
        output.writeInt64(3, objectGeneration_);
      }
      if (reasonCase_ == 5) {
        output.writeMessage(
            5, (com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason) reason_);
      }
      if (reasonCase_ == 6) {
        output.writeMessage(
            6, (com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason) reason_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, bucket_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, objectName_);
      }
      if (objectGeneration_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, objectGeneration_);
      }
      if (reasonCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, (com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason) reason_);
      }
      if (reasonCase_ == 6) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6, (com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason) reason_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure other =
          (com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure) obj;

      if (!getBucket().equals(other.getBucket())) return false;
      if (!getObjectName().equals(other.getObjectName())) return false;
      if (getObjectGeneration() != other.getObjectGeneration()) return false;
      if (!getReasonCase().equals(other.getReasonCase())) return false;
      switch (reasonCase_) {
        case 5:
          if (!getAvroFailureReason().equals(other.getAvroFailureReason())) return false;
          break;
        case 6:
          if (!getApiViolationReason().equals(other.getApiViolationReason())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BUCKET_FIELD_NUMBER;
      hash = (53 * hash) + getBucket().hashCode();
      hash = (37 * hash) + OBJECT_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getObjectName().hashCode();
      hash = (37 * hash) + OBJECT_GENERATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getObjectGeneration());
      switch (reasonCase_) {
        case 5:
          hash = (37 * hash) + AVRO_FAILURE_REASON_FIELD_NUMBER;
          hash = (53 * hash) + getAvroFailureReason().hashCode();
          break;
        case 6:
          hash = (37 * hash) + API_VIOLATION_REASON_FIELD_NUMBER;
          hash = (53 * hash) + getApiViolationReason().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Failure when ingesting from a Cloud Storage source.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure)
        com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailureOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionFailureEvent_CloudStorageFailure_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionFailureEvent_CloudStorageFailure_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.class,
                com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.Builder.class);
      }

      // Construct using com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        bucket_ = "";
        objectName_ = "";
        objectGeneration_ = 0L;
        if (avroFailureReasonBuilder_ != null) {
          avroFailureReasonBuilder_.clear();
        }
        if (apiViolationReasonBuilder_ != null) {
          apiViolationReasonBuilder_.clear();
        }
        reasonCase_ = 0;
        reason_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionFailureEvent_CloudStorageFailure_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
          getDefaultInstanceForType() {
        return com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure build() {
        com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure buildPartial() {
        com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure result =
            new com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.bucket_ = bucket_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.objectName_ = objectName_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.objectGeneration_ = objectGeneration_;
        }
      }

      private void buildPartialOneofs(
          com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure result) {
        result.reasonCase_ = reasonCase_;
        result.reason_ = this.reason_;
        if (reasonCase_ == 5 && avroFailureReasonBuilder_ != null) {
          result.reason_ = avroFailureReasonBuilder_.build();
        }
        if (reasonCase_ == 6 && apiViolationReasonBuilder_ != null) {
          result.reason_ = apiViolationReasonBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure) {
          return mergeFrom((com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure other) {
        if (other
            == com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.getDefaultInstance())
          return this;
        if (!other.getBucket().isEmpty()) {
          bucket_ = other.bucket_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getObjectName().isEmpty()) {
          objectName_ = other.objectName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.getObjectGeneration() != 0L) {
          setObjectGeneration(other.getObjectGeneration());
        }
        switch (other.getReasonCase()) {
          case AVRO_FAILURE_REASON:
            {
              mergeAvroFailureReason(other.getAvroFailureReason());
              break;
            }
          case API_VIOLATION_REASON:
            {
              mergeApiViolationReason(other.getApiViolationReason());
              break;
            }
          case REASON_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  bucket_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  objectName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  objectGeneration_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 42:
                {
                  input.readMessage(
                      getAvroFailureReasonFieldBuilder().getBuilder(), extensionRegistry);
                  reasonCase_ = 5;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getApiViolationReasonFieldBuilder().getBuilder(), extensionRegistry);
                  reasonCase_ = 6;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int reasonCase_ = 0;
      private java.lang.Object reason_;

      public ReasonCase getReasonCase() {
        return ReasonCase.forNumber(reasonCase_);
      }

      public Builder clearReason() {
        reasonCase_ = 0;
        reason_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object bucket_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Name of the Cloud Storage bucket used for ingestion.
       * </pre>
       *
       * <code>string bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bucket.
       */
      public java.lang.String getBucket() {
        java.lang.Object ref = bucket_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bucket_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Name of the Cloud Storage bucket used for ingestion.
       * </pre>
       *
       * <code>string bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for bucket.
       */
      public com.google.protobuf.ByteString getBucketBytes() {
        java.lang.Object ref = bucket_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bucket_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Name of the Cloud Storage bucket used for ingestion.
       * </pre>
       *
       * <code>string bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bucket to set.
       * @return This builder for chaining.
       */
      public Builder setBucket(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucket_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Name of the Cloud Storage bucket used for ingestion.
       * </pre>
       *
       * <code>string bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBucket() {
        bucket_ = getDefaultInstance().getBucket();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Name of the Cloud Storage bucket used for ingestion.
       * </pre>
       *
       * <code>string bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for bucket to set.
       * @return This builder for chaining.
       */
      public Builder setBucketBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        bucket_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object objectName_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Name of the Cloud Storage object which contained the section
       * that couldn't be ingested.
       * </pre>
       *
       * <code>string object_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The objectName.
       */
      public java.lang.String getObjectName() {
        java.lang.Object ref = objectName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          objectName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Name of the Cloud Storage object which contained the section
       * that couldn't be ingested.
       * </pre>
       *
       * <code>string object_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for objectName.
       */
      public com.google.protobuf.ByteString getObjectNameBytes() {
        java.lang.Object ref = objectName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          objectName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Name of the Cloud Storage object which contained the section
       * that couldn't be ingested.
       * </pre>
       *
       * <code>string object_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The objectName to set.
       * @return This builder for chaining.
       */
      public Builder setObjectName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        objectName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Name of the Cloud Storage object which contained the section
       * that couldn't be ingested.
       * </pre>
       *
       * <code>string object_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearObjectName() {
        objectName_ = getDefaultInstance().getObjectName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Name of the Cloud Storage object which contained the section
       * that couldn't be ingested.
       * </pre>
       *
       * <code>string object_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for objectName to set.
       * @return This builder for chaining.
       */
      public Builder setObjectNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        objectName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private long objectGeneration_;
      /**
       *
       *
       * <pre>
       * Optional. Generation of the Cloud Storage object which contained the
       * section that couldn't be ingested.
       * </pre>
       *
       * <code>int64 object_generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The objectGeneration.
       */
      @java.lang.Override
      public long getObjectGeneration() {
        return objectGeneration_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Generation of the Cloud Storage object which contained the
       * section that couldn't be ingested.
       * </pre>
       *
       * <code>int64 object_generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The objectGeneration to set.
       * @return This builder for chaining.
       */
      public Builder setObjectGeneration(long value) {

        objectGeneration_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Generation of the Cloud Storage object which contained the
       * section that couldn't be ingested.
       * </pre>
       *
       * <code>int64 object_generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearObjectGeneration() {
        bitField0_ = (bitField0_ & ~0x00000004);
        objectGeneration_ = 0L;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason,
              com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.Builder,
              com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReasonOrBuilder>
          avroFailureReasonBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Failure encountered when parsing an Avro file.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the avroFailureReason field is set.
       */
      @java.lang.Override
      public boolean hasAvroFailureReason() {
        return reasonCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * Optional. Failure encountered when parsing an Avro file.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The avroFailureReason.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason getAvroFailureReason() {
        if (avroFailureReasonBuilder_ == null) {
          if (reasonCase_ == 5) {
            return (com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason) reason_;
          }
          return com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.getDefaultInstance();
        } else {
          if (reasonCase_ == 5) {
            return avroFailureReasonBuilder_.getMessage();
          }
          return com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Failure encountered when parsing an Avro file.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAvroFailureReason(
          com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason value) {
        if (avroFailureReasonBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          reason_ = value;
          onChanged();
        } else {
          avroFailureReasonBuilder_.setMessage(value);
        }
        reasonCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Failure encountered when parsing an Avro file.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAvroFailureReason(
          com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.Builder builderForValue) {
        if (avroFailureReasonBuilder_ == null) {
          reason_ = builderForValue.build();
          onChanged();
        } else {
          avroFailureReasonBuilder_.setMessage(builderForValue.build());
        }
        reasonCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Failure encountered when parsing an Avro file.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeAvroFailureReason(
          com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason value) {
        if (avroFailureReasonBuilder_ == null) {
          if (reasonCase_ == 5
              && reason_
                  != com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason
                      .getDefaultInstance()) {
            reason_ =
                com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.newBuilder(
                        (com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason) reason_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            reason_ = value;
          }
          onChanged();
        } else {
          if (reasonCase_ == 5) {
            avroFailureReasonBuilder_.mergeFrom(value);
          } else {
            avroFailureReasonBuilder_.setMessage(value);
          }
        }
        reasonCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Failure encountered when parsing an Avro file.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearAvroFailureReason() {
        if (avroFailureReasonBuilder_ == null) {
          if (reasonCase_ == 5) {
            reasonCase_ = 0;
            reason_ = null;
            onChanged();
          }
        } else {
          if (reasonCase_ == 5) {
            reasonCase_ = 0;
            reason_ = null;
          }
          avroFailureReasonBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Failure encountered when parsing an Avro file.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.Builder
          getAvroFailureReasonBuilder() {
        return getAvroFailureReasonFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Failure encountered when parsing an Avro file.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReasonOrBuilder
          getAvroFailureReasonOrBuilder() {
        if ((reasonCase_ == 5) && (avroFailureReasonBuilder_ != null)) {
          return avroFailureReasonBuilder_.getMessageOrBuilder();
        } else {
          if (reasonCase_ == 5) {
            return (com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason) reason_;
          }
          return com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Failure encountered when parsing an Avro file.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.AvroFailureReason avro_failure_reason = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason,
              com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.Builder,
              com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReasonOrBuilder>
          getAvroFailureReasonFieldBuilder() {
        if (avroFailureReasonBuilder_ == null) {
          if (!(reasonCase_ == 5)) {
            reason_ =
                com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.getDefaultInstance();
          }
          avroFailureReasonBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason,
                  com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason.Builder,
                  com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReasonOrBuilder>(
                  (com.google.pubsub.v1.IngestionFailureEvent.AvroFailureReason) reason_,
                  getParentForChildren(),
                  isClean());
          reason_ = null;
        }
        reasonCase_ = 5;
        onChanged();
        return avroFailureReasonBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason,
              com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.Builder,
              com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReasonOrBuilder>
          apiViolationReasonBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. The Pub/Sub API limits prevented the desired message from
       * being published.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the apiViolationReason field is set.
       */
      @java.lang.Override
      public boolean hasApiViolationReason() {
        return reasonCase_ == 6;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Pub/Sub API limits prevented the desired message from
       * being published.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The apiViolationReason.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason getApiViolationReason() {
        if (apiViolationReasonBuilder_ == null) {
          if (reasonCase_ == 6) {
            return (com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason) reason_;
          }
          return com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.getDefaultInstance();
        } else {
          if (reasonCase_ == 6) {
            return apiViolationReasonBuilder_.getMessage();
          }
          return com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Pub/Sub API limits prevented the desired message from
       * being published.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setApiViolationReason(
          com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason value) {
        if (apiViolationReasonBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          reason_ = value;
          onChanged();
        } else {
          apiViolationReasonBuilder_.setMessage(value);
        }
        reasonCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Pub/Sub API limits prevented the desired message from
       * being published.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setApiViolationReason(
          com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.Builder builderForValue) {
        if (apiViolationReasonBuilder_ == null) {
          reason_ = builderForValue.build();
          onChanged();
        } else {
          apiViolationReasonBuilder_.setMessage(builderForValue.build());
        }
        reasonCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Pub/Sub API limits prevented the desired message from
       * being published.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeApiViolationReason(
          com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason value) {
        if (apiViolationReasonBuilder_ == null) {
          if (reasonCase_ == 6
              && reason_
                  != com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason
                      .getDefaultInstance()) {
            reason_ =
                com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.newBuilder(
                        (com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason) reason_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            reason_ = value;
          }
          onChanged();
        } else {
          if (reasonCase_ == 6) {
            apiViolationReasonBuilder_.mergeFrom(value);
          } else {
            apiViolationReasonBuilder_.setMessage(value);
          }
        }
        reasonCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Pub/Sub API limits prevented the desired message from
       * being published.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearApiViolationReason() {
        if (apiViolationReasonBuilder_ == null) {
          if (reasonCase_ == 6) {
            reasonCase_ = 0;
            reason_ = null;
            onChanged();
          }
        } else {
          if (reasonCase_ == 6) {
            reasonCase_ = 0;
            reason_ = null;
          }
          apiViolationReasonBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Pub/Sub API limits prevented the desired message from
       * being published.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.Builder
          getApiViolationReasonBuilder() {
        return getApiViolationReasonFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. The Pub/Sub API limits prevented the desired message from
       * being published.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReasonOrBuilder
          getApiViolationReasonOrBuilder() {
        if ((reasonCase_ == 6) && (apiViolationReasonBuilder_ != null)) {
          return apiViolationReasonBuilder_.getMessageOrBuilder();
        } else {
          if (reasonCase_ == 6) {
            return (com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason) reason_;
          }
          return com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Pub/Sub API limits prevented the desired message from
       * being published.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionFailureEvent.ApiViolationReason api_violation_reason = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason,
              com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.Builder,
              com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReasonOrBuilder>
          getApiViolationReasonFieldBuilder() {
        if (apiViolationReasonBuilder_ == null) {
          if (!(reasonCase_ == 6)) {
            reason_ =
                com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.getDefaultInstance();
          }
          apiViolationReasonBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason,
                  com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason.Builder,
                  com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReasonOrBuilder>(
                  (com.google.pubsub.v1.IngestionFailureEvent.ApiViolationReason) reason_,
                  getParentForChildren(),
                  isClean());
          reason_ = null;
        }
        reasonCase_ = 6;
        onChanged();
        return apiViolationReasonBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure)
    private static final com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure();
    }

    public static com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloudStorageFailure> PARSER =
        new com.google.protobuf.AbstractParser<CloudStorageFailure>() {
          @java.lang.Override
          public CloudStorageFailure parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CloudStorageFailure> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloudStorageFailure> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int failureCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object failure_;

  public enum FailureCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CLOUD_STORAGE_FAILURE(3),
    FAILURE_NOT_SET(0);
    private final int value;

    private FailureCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FailureCase valueOf(int value) {
      return forNumber(value);
    }

    public static FailureCase forNumber(int value) {
      switch (value) {
        case 3:
          return CLOUD_STORAGE_FAILURE;
        case 0:
          return FAILURE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FailureCase getFailureCase() {
    return FailureCase.forNumber(failureCase_);
  }

  public static final int TOPIC_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object topic_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the import topic. Format is:
   * projects/{project_name}/topics/{topic_name}.
   * </pre>
   *
   * <code>string topic = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The topic.
   */
  @java.lang.Override
  public java.lang.String getTopic() {
    java.lang.Object ref = topic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      topic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the import topic. Format is:
   * projects/{project_name}/topics/{topic_name}.
   * </pre>
   *
   * <code>string topic = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for topic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTopicBytes() {
    java.lang.Object ref = topic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      topic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_MESSAGE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorMessage_ = "";
  /**
   *
   *
   * <pre>
   * Required. Error details explaining why ingestion to Pub/Sub has failed.
   * </pre>
   *
   * <code>string error_message = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The errorMessage.
   */
  @java.lang.Override
  public java.lang.String getErrorMessage() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Error details explaining why ingestion to Pub/Sub has failed.
   * </pre>
   *
   * <code>string error_message = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for errorMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorMessageBytes() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLOUD_STORAGE_FAILURE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Optional. Failure when ingesting from Cloud Storage.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure cloud_storage_failure = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the cloudStorageFailure field is set.
   */
  @java.lang.Override
  public boolean hasCloudStorageFailure() {
    return failureCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Optional. Failure when ingesting from Cloud Storage.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure cloud_storage_failure = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The cloudStorageFailure.
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure getCloudStorageFailure() {
    if (failureCase_ == 3) {
      return (com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure) failure_;
    }
    return com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Failure when ingesting from Cloud Storage.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure cloud_storage_failure = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailureOrBuilder
      getCloudStorageFailureOrBuilder() {
    if (failureCase_ == 3) {
      return (com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure) failure_;
    }
    return com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, topic_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, errorMessage_);
    }
    if (failureCase_ == 3) {
      output.writeMessage(
          3, (com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure) failure_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, topic_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, errorMessage_);
    }
    if (failureCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure) failure_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.IngestionFailureEvent)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.IngestionFailureEvent other =
        (com.google.pubsub.v1.IngestionFailureEvent) obj;

    if (!getTopic().equals(other.getTopic())) return false;
    if (!getErrorMessage().equals(other.getErrorMessage())) return false;
    if (!getFailureCase().equals(other.getFailureCase())) return false;
    switch (failureCase_) {
      case 3:
        if (!getCloudStorageFailure().equals(other.getCloudStorageFailure())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getTopic().hashCode();
    hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getErrorMessage().hashCode();
    switch (failureCase_) {
      case 3:
        hash = (37 * hash) + CLOUD_STORAGE_FAILURE_FIELD_NUMBER;
        hash = (53 * hash) + getCloudStorageFailure().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.IngestionFailureEvent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.IngestionFailureEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionFailureEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.IngestionFailureEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionFailureEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.IngestionFailureEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionFailureEvent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.IngestionFailureEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionFailureEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.IngestionFailureEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionFailureEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.IngestionFailureEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.IngestionFailureEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Payload of the Platform Log entry sent when a failure is encountered while
   * ingesting.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionFailureEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionFailureEvent)
      com.google.pubsub.v1.IngestionFailureEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionFailureEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionFailureEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionFailureEvent.class,
              com.google.pubsub.v1.IngestionFailureEvent.Builder.class);
    }

    // Construct using com.google.pubsub.v1.IngestionFailureEvent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      topic_ = "";
      errorMessage_ = "";
      if (cloudStorageFailureBuilder_ != null) {
        cloudStorageFailureBuilder_.clear();
      }
      failureCase_ = 0;
      failure_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionFailureEvent_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionFailureEvent getDefaultInstanceForType() {
      return com.google.pubsub.v1.IngestionFailureEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionFailureEvent build() {
      com.google.pubsub.v1.IngestionFailureEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionFailureEvent buildPartial() {
      com.google.pubsub.v1.IngestionFailureEvent result =
          new com.google.pubsub.v1.IngestionFailureEvent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.pubsub.v1.IngestionFailureEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.topic_ = topic_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.errorMessage_ = errorMessage_;
      }
    }

    private void buildPartialOneofs(com.google.pubsub.v1.IngestionFailureEvent result) {
      result.failureCase_ = failureCase_;
      result.failure_ = this.failure_;
      if (failureCase_ == 3 && cloudStorageFailureBuilder_ != null) {
        result.failure_ = cloudStorageFailureBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.IngestionFailureEvent) {
        return mergeFrom((com.google.pubsub.v1.IngestionFailureEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.IngestionFailureEvent other) {
      if (other == com.google.pubsub.v1.IngestionFailureEvent.getDefaultInstance()) return this;
      if (!other.getTopic().isEmpty()) {
        topic_ = other.topic_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getErrorMessage().isEmpty()) {
        errorMessage_ = other.errorMessage_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      switch (other.getFailureCase()) {
        case CLOUD_STORAGE_FAILURE:
          {
            mergeCloudStorageFailure(other.getCloudStorageFailure());
            break;
          }
        case FAILURE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                topic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                errorMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getCloudStorageFailureFieldBuilder().getBuilder(), extensionRegistry);
                failureCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int failureCase_ = 0;
    private java.lang.Object failure_;

    public FailureCase getFailureCase() {
      return FailureCase.forNumber(failureCase_);
    }

    public Builder clearFailure() {
      failureCase_ = 0;
      failure_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object topic_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the import topic. Format is:
     * projects/{project_name}/topics/{topic_name}.
     * </pre>
     *
     * <code>string topic = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The topic.
     */
    public java.lang.String getTopic() {
      java.lang.Object ref = topic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the import topic. Format is:
     * projects/{project_name}/topics/{topic_name}.
     * </pre>
     *
     * <code>string topic = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for topic.
     */
    public com.google.protobuf.ByteString getTopicBytes() {
      java.lang.Object ref = topic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        topic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the import topic. Format is:
     * projects/{project_name}/topics/{topic_name}.
     * </pre>
     *
     * <code>string topic = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The topic to set.
     * @return This builder for chaining.
     */
    public Builder setTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      topic_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the import topic. Format is:
     * projects/{project_name}/topics/{topic_name}.
     * </pre>
     *
     * <code>string topic = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTopic() {
      topic_ = getDefaultInstance().getTopic();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the import topic. Format is:
     * projects/{project_name}/topics/{topic_name}.
     * </pre>
     *
     * <code>string topic = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for topic to set.
     * @return This builder for chaining.
     */
    public Builder setTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      topic_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * Required. Error details explaining why ingestion to Pub/Sub has failed.
     * </pre>
     *
     * <code>string error_message = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The errorMessage.
     */
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Error details explaining why ingestion to Pub/Sub has failed.
     * </pre>
     *
     * <code>string error_message = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for errorMessage.
     */
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Error details explaining why ingestion to Pub/Sub has failed.
     * </pre>
     *
     * <code>string error_message = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorMessage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Error details explaining why ingestion to Pub/Sub has failed.
     * </pre>
     *
     * <code>string error_message = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorMessage() {
      errorMessage_ = getDefaultInstance().getErrorMessage();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Error details explaining why ingestion to Pub/Sub has failed.
     * </pre>
     *
     * <code>string error_message = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorMessage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure,
            com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.Builder,
            com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailureOrBuilder>
        cloudStorageFailureBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Failure when ingesting from Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure cloud_storage_failure = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the cloudStorageFailure field is set.
     */
    @java.lang.Override
    public boolean hasCloudStorageFailure() {
      return failureCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. Failure when ingesting from Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure cloud_storage_failure = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The cloudStorageFailure.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure getCloudStorageFailure() {
      if (cloudStorageFailureBuilder_ == null) {
        if (failureCase_ == 3) {
          return (com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure) failure_;
        }
        return com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.getDefaultInstance();
      } else {
        if (failureCase_ == 3) {
          return cloudStorageFailureBuilder_.getMessage();
        }
        return com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Failure when ingesting from Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure cloud_storage_failure = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCloudStorageFailure(
        com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure value) {
      if (cloudStorageFailureBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        failure_ = value;
        onChanged();
      } else {
        cloudStorageFailureBuilder_.setMessage(value);
      }
      failureCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Failure when ingesting from Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure cloud_storage_failure = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCloudStorageFailure(
        com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.Builder builderForValue) {
      if (cloudStorageFailureBuilder_ == null) {
        failure_ = builderForValue.build();
        onChanged();
      } else {
        cloudStorageFailureBuilder_.setMessage(builderForValue.build());
      }
      failureCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Failure when ingesting from Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure cloud_storage_failure = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCloudStorageFailure(
        com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure value) {
      if (cloudStorageFailureBuilder_ == null) {
        if (failureCase_ == 3
            && failure_
                != com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure
                    .getDefaultInstance()) {
          failure_ =
              com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.newBuilder(
                      (com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure) failure_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          failure_ = value;
        }
        onChanged();
      } else {
        if (failureCase_ == 3) {
          cloudStorageFailureBuilder_.mergeFrom(value);
        } else {
          cloudStorageFailureBuilder_.setMessage(value);
        }
      }
      failureCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Failure when ingesting from Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure cloud_storage_failure = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCloudStorageFailure() {
      if (cloudStorageFailureBuilder_ == null) {
        if (failureCase_ == 3) {
          failureCase_ = 0;
          failure_ = null;
          onChanged();
        }
      } else {
        if (failureCase_ == 3) {
          failureCase_ = 0;
          failure_ = null;
        }
        cloudStorageFailureBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Failure when ingesting from Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure cloud_storage_failure = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.Builder
        getCloudStorageFailureBuilder() {
      return getCloudStorageFailureFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Failure when ingesting from Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure cloud_storage_failure = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailureOrBuilder
        getCloudStorageFailureOrBuilder() {
      if ((failureCase_ == 3) && (cloudStorageFailureBuilder_ != null)) {
        return cloudStorageFailureBuilder_.getMessageOrBuilder();
      } else {
        if (failureCase_ == 3) {
          return (com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure) failure_;
        }
        return com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Failure when ingesting from Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure cloud_storage_failure = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure,
            com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.Builder,
            com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailureOrBuilder>
        getCloudStorageFailureFieldBuilder() {
      if (cloudStorageFailureBuilder_ == null) {
        if (!(failureCase_ == 3)) {
          failure_ =
              com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.getDefaultInstance();
        }
        cloudStorageFailureBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure,
                com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure.Builder,
                com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailureOrBuilder>(
                (com.google.pubsub.v1.IngestionFailureEvent.CloudStorageFailure) failure_,
                getParentForChildren(),
                isClean());
        failure_ = null;
      }
      failureCase_ = 3;
      onChanged();
      return cloudStorageFailureBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionFailureEvent)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionFailureEvent)
  private static final com.google.pubsub.v1.IngestionFailureEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionFailureEvent();
  }

  public static com.google.pubsub.v1.IngestionFailureEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IngestionFailureEvent> PARSER =
      new com.google.protobuf.AbstractParser<IngestionFailureEvent>() {
        @java.lang.Override
        public IngestionFailureEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IngestionFailureEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IngestionFailureEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.IngestionFailureEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
