/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class TopicName
implements ResourceName {
    private static final PathTemplate PROJECT_TOPIC_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/topics/{topic}");
    private static final String DELETED_TOPIC_FIXED_VALUE = "_deleted-topic_";
    private static final TopicName DELETED_TOPIC_INSTANCE = new TopicName("_deleted-topic_");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String topic;

    @Deprecated
    protected TopicName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getTopic() {
        return this.topic;
    }

    private TopicName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.topic = (String)Preconditions.checkNotNull((Object)builder.getTopic());
        this.pathTemplate = PROJECT_TOPIC_PATH_TEMPLATE;
    }

    private TopicName(String fixedValue) {
        this.fixedValue = fixedValue;
        this.fieldValuesMap = ImmutableMap.of((Object)"", (Object)fixedValue);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectTopicBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TopicName of(String project, String topic) {
        return TopicName.newProjectTopicBuilder().setProject(project).setTopic(topic).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static TopicName ofProjectTopicName(String project, String topic) {
        return TopicName.newProjectTopicBuilder().setProject(project).setTopic(topic).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static TopicName ofDeletedTopicName() {
        return DELETED_TOPIC_INSTANCE;
    }

    public static String format(String project, String topic) {
        return TopicName.newBuilder().setProject(project).setTopic(topic).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectTopicName(String project, String topic) {
        return TopicName.newBuilder().setProject(project).setTopic(topic).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatDeletedTopicName() {
        return DELETED_TOPIC_FIXED_VALUE;
    }

    public static TopicName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_TOPIC_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_TOPIC_PATH_TEMPLATE.match(formattedString);
            return TopicName.ofProjectTopicName((String)matchMap.get("project"), (String)matchMap.get("topic"));
        }
        if (DELETED_TOPIC_FIXED_VALUE.equals(formattedString)) {
            return DELETED_TOPIC_INSTANCE;
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_TOPIC_PATH_TEMPLATE.matches(formattedString) || DELETED_TOPIC_FIXED_VALUE.equals(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TopicName topicName = this;
            synchronized (topicName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.topic != null) {
                        fieldMapBuilder.put((Object)"topic", (Object)this.topic);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            TopicName that = (TopicName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.topic, that.topic);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.topic);
    }

    public static class Builder {
        private String project;
        private String topic;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTopic() {
            return this.topic;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        private Builder(TopicName topicName) {
            Preconditions.checkArgument((topicName.pathTemplate == PROJECT_TOPIC_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when TopicName has the pattern of projects/{project}/topics/{topic}.");
            this.project = topicName.project;
            this.topic = topicName.topic;
        }

        public TopicName build() {
            return new TopicName(this);
        }
    }
}

