/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/rapidmigrationassessment/v1/api_entities.proto

package com.google.cloud.rapidmigrationassessment.v1;

/**
 *
 *
 * <pre>
 * Message describing Collector object.
 * </pre>
 *
 * Protobuf type {@code google.cloud.rapidmigrationassessment.v1.Collector}
 */
public final class Collector extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.rapidmigrationassessment.v1.Collector)
    CollectorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Collector.newBuilder() to construct.
  private Collector(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Collector() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    serviceAccount_ = "";
    bucket_ = "";
    state_ = 0;
    clientVersion_ = "";
    eulaUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Collector();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.rapidmigrationassessment.v1.ApiEntitiesProto
        .internal_static_google_cloud_rapidmigrationassessment_v1_Collector_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.rapidmigrationassessment.v1.ApiEntitiesProto
        .internal_static_google_cloud_rapidmigrationassessment_v1_Collector_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.rapidmigrationassessment.v1.Collector.class,
            com.google.cloud.rapidmigrationassessment.v1.Collector.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * -- Using suggestion from API Linter Analyzer for nesting enum --
   * -- https://linter.aip.dev/216/nesting --
   * State of a Collector (server_side).
   * States are used for internal purposes and named to keep
   * convention of legacy product:
   * https://cloud.google.com/migrate/stratozone/docs/about-stratoprobe.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.rapidmigrationassessment.v1.Collector.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Collector state is not recognized.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Collector started to create, but hasn't been completed MC source creation
     * and db object creation.
     * </pre>
     *
     * <code>STATE_INITIALIZING = 1;</code>
     */
    STATE_INITIALIZING(1),
    /**
     *
     *
     * <pre>
     * Collector has been created, MC source creation and db object creation
     * completed.
     * </pre>
     *
     * <code>STATE_READY_TO_USE = 2;</code>
     */
    STATE_READY_TO_USE(2),
    /**
     *
     *
     * <pre>
     * Collector client has been registered with client.
     * </pre>
     *
     * <code>STATE_REGISTERED = 3;</code>
     */
    STATE_REGISTERED(3),
    /**
     *
     *
     * <pre>
     * Collector client is actively scanning.
     * </pre>
     *
     * <code>STATE_ACTIVE = 4;</code>
     */
    STATE_ACTIVE(4),
    /**
     *
     *
     * <pre>
     * Collector is not actively scanning.
     * </pre>
     *
     * <code>STATE_PAUSED = 5;</code>
     */
    STATE_PAUSED(5),
    /**
     *
     *
     * <pre>
     * Collector is starting background job for deletion.
     * </pre>
     *
     * <code>STATE_DELETING = 6;</code>
     */
    STATE_DELETING(6),
    /**
     *
     *
     * <pre>
     * Collector completed all tasks for deletion.
     * </pre>
     *
     * <code>STATE_DECOMMISSIONED = 7;</code>
     */
    STATE_DECOMMISSIONED(7),
    /**
     *
     *
     * <pre>
     * Collector is in error state.
     * </pre>
     *
     * <code>STATE_ERROR = 8;</code>
     */
    STATE_ERROR(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Collector state is not recognized.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Collector started to create, but hasn't been completed MC source creation
     * and db object creation.
     * </pre>
     *
     * <code>STATE_INITIALIZING = 1;</code>
     */
    public static final int STATE_INITIALIZING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Collector has been created, MC source creation and db object creation
     * completed.
     * </pre>
     *
     * <code>STATE_READY_TO_USE = 2;</code>
     */
    public static final int STATE_READY_TO_USE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Collector client has been registered with client.
     * </pre>
     *
     * <code>STATE_REGISTERED = 3;</code>
     */
    public static final int STATE_REGISTERED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Collector client is actively scanning.
     * </pre>
     *
     * <code>STATE_ACTIVE = 4;</code>
     */
    public static final int STATE_ACTIVE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Collector is not actively scanning.
     * </pre>
     *
     * <code>STATE_PAUSED = 5;</code>
     */
    public static final int STATE_PAUSED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Collector is starting background job for deletion.
     * </pre>
     *
     * <code>STATE_DELETING = 6;</code>
     */
    public static final int STATE_DELETING_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Collector completed all tasks for deletion.
     * </pre>
     *
     * <code>STATE_DECOMMISSIONED = 7;</code>
     */
    public static final int STATE_DECOMMISSIONED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Collector is in error state.
     * </pre>
     *
     * <code>STATE_ERROR = 8;</code>
     */
    public static final int STATE_ERROR_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return STATE_INITIALIZING;
        case 2:
          return STATE_READY_TO_USE;
        case 3:
          return STATE_REGISTERED;
        case 4:
          return STATE_ACTIVE;
        case 5:
          return STATE_PAUSED;
        case 6:
          return STATE_DELETING;
        case 7:
          return STATE_DECOMMISSIONED;
        case 8:
          return STATE_ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.rapidmigrationassessment.v1.Collector.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.rapidmigrationassessment.v1.Collector.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * name of resource.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * name of resource.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Create time stamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Create time stamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Create time stamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Update time stamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Update time stamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Update time stamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.rapidmigrationassessment.v1.ApiEntitiesProto
                .internal_static_google_cloud_rapidmigrationassessment_v1_Collector_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * User specified name of the Collector.
   * </pre>
   *
   * <code>string display_name = 5;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User specified name of the Collector.
   * </pre>
   *
   * <code>string display_name = 5;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * User specified description of the Collector.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User specified description of the Collector.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Service Account email used to ingest data to this Collector.
   * </pre>
   *
   * <code>string service_account = 7;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Service Account email used to ingest data to this Collector.
   * </pre>
   *
   * <code>string service_account = 7;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUCKET_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bucket_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Store cloud storage bucket name (which is a guid) created with
   * this Collector.
   * </pre>
   *
   * <code>string bucket = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bucket.
   */
  @java.lang.Override
  public java.lang.String getBucket() {
    java.lang.Object ref = bucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bucket_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Store cloud storage bucket name (which is a guid) created with
   * this Collector.
   * </pre>
   *
   * <code>string bucket = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for bucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBucketBytes() {
    java.lang.Object ref = bucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPECTED_ASSET_COUNT_FIELD_NUMBER = 9;
  private long expectedAssetCount_ = 0L;
  /**
   *
   *
   * <pre>
   * User specified expected asset count.
   * </pre>
   *
   * <code>int64 expected_asset_count = 9;</code>
   *
   * @return The expectedAssetCount.
   */
  @java.lang.Override
  public long getExpectedAssetCount() {
    return expectedAssetCount_;
  }

  public static final int STATE_FIELD_NUMBER = 10;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the Collector.
   * </pre>
   *
   * <code>
   * .google.cloud.rapidmigrationassessment.v1.Collector.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the Collector.
   * </pre>
   *
   * <code>
   * .google.cloud.rapidmigrationassessment.v1.Collector.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.rapidmigrationassessment.v1.Collector.State getState() {
    com.google.cloud.rapidmigrationassessment.v1.Collector.State result =
        com.google.cloud.rapidmigrationassessment.v1.Collector.State.forNumber(state_);
    return result == null
        ? com.google.cloud.rapidmigrationassessment.v1.Collector.State.UNRECOGNIZED
        : result;
  }

  public static final int CLIENT_VERSION_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clientVersion_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Client version.
   * </pre>
   *
   * <code>string client_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The clientVersion.
   */
  @java.lang.Override
  public java.lang.String getClientVersion() {
    java.lang.Object ref = clientVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Client version.
   * </pre>
   *
   * <code>string client_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for clientVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientVersionBytes() {
    java.lang.Object ref = clientVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GUEST_OS_SCAN_FIELD_NUMBER = 12;
  private com.google.cloud.rapidmigrationassessment.v1.GuestOsScan guestOsScan_;
  /**
   *
   *
   * <pre>
   * Output only. Reference to MC Source Guest Os Scan.
   * </pre>
   *
   * <code>
   * .google.cloud.rapidmigrationassessment.v1.GuestOsScan guest_os_scan = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the guestOsScan field is set.
   */
  @java.lang.Override
  public boolean hasGuestOsScan() {
    return guestOsScan_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Reference to MC Source Guest Os Scan.
   * </pre>
   *
   * <code>
   * .google.cloud.rapidmigrationassessment.v1.GuestOsScan guest_os_scan = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The guestOsScan.
   */
  @java.lang.Override
  public com.google.cloud.rapidmigrationassessment.v1.GuestOsScan getGuestOsScan() {
    return guestOsScan_ == null
        ? com.google.cloud.rapidmigrationassessment.v1.GuestOsScan.getDefaultInstance()
        : guestOsScan_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Reference to MC Source Guest Os Scan.
   * </pre>
   *
   * <code>
   * .google.cloud.rapidmigrationassessment.v1.GuestOsScan guest_os_scan = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.rapidmigrationassessment.v1.GuestOsScanOrBuilder
      getGuestOsScanOrBuilder() {
    return guestOsScan_ == null
        ? com.google.cloud.rapidmigrationassessment.v1.GuestOsScan.getDefaultInstance()
        : guestOsScan_;
  }

  public static final int VSPHERE_SCAN_FIELD_NUMBER = 13;
  private com.google.cloud.rapidmigrationassessment.v1.VSphereScan vsphereScan_;
  /**
   *
   *
   * <pre>
   * Output only. Reference to MC Source vsphere_scan.
   * </pre>
   *
   * <code>
   * .google.cloud.rapidmigrationassessment.v1.VSphereScan vsphere_scan = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the vsphereScan field is set.
   */
  @java.lang.Override
  public boolean hasVsphereScan() {
    return vsphereScan_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Reference to MC Source vsphere_scan.
   * </pre>
   *
   * <code>
   * .google.cloud.rapidmigrationassessment.v1.VSphereScan vsphere_scan = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The vsphereScan.
   */
  @java.lang.Override
  public com.google.cloud.rapidmigrationassessment.v1.VSphereScan getVsphereScan() {
    return vsphereScan_ == null
        ? com.google.cloud.rapidmigrationassessment.v1.VSphereScan.getDefaultInstance()
        : vsphereScan_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Reference to MC Source vsphere_scan.
   * </pre>
   *
   * <code>
   * .google.cloud.rapidmigrationassessment.v1.VSphereScan vsphere_scan = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.rapidmigrationassessment.v1.VSphereScanOrBuilder
      getVsphereScanOrBuilder() {
    return vsphereScan_ == null
        ? com.google.cloud.rapidmigrationassessment.v1.VSphereScan.getDefaultInstance()
        : vsphereScan_;
  }

  public static final int COLLECTION_DAYS_FIELD_NUMBER = 14;
  private int collectionDays_ = 0;
  /**
   *
   *
   * <pre>
   * How many days to collect data.
   * </pre>
   *
   * <code>int32 collection_days = 14;</code>
   *
   * @return The collectionDays.
   */
  @java.lang.Override
  public int getCollectionDays() {
    return collectionDays_;
  }

  public static final int EULA_URI_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object eulaUri_ = "";
  /**
   *
   *
   * <pre>
   * Uri for EULA (End User License Agreement) from customer.
   * </pre>
   *
   * <code>string eula_uri = 15;</code>
   *
   * @return The eulaUri.
   */
  @java.lang.Override
  public java.lang.String getEulaUri() {
    java.lang.Object ref = eulaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      eulaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Uri for EULA (End User License Agreement) from customer.
   * </pre>
   *
   * <code>string eula_uri = 15;</code>
   *
   * @return The bytes for eulaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEulaUriBytes() {
    java.lang.Object ref = eulaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      eulaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, bucket_);
    }
    if (expectedAssetCount_ != 0L) {
      output.writeInt64(9, expectedAssetCount_);
    }
    if (state_
        != com.google.cloud.rapidmigrationassessment.v1.Collector.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, clientVersion_);
    }
    if (guestOsScan_ != null) {
      output.writeMessage(12, getGuestOsScan());
    }
    if (vsphereScan_ != null) {
      output.writeMessage(13, getVsphereScan());
    }
    if (collectionDays_ != 0) {
      output.writeInt32(14, collectionDays_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eulaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, eulaUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, bucket_);
    }
    if (expectedAssetCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, expectedAssetCount_);
    }
    if (state_
        != com.google.cloud.rapidmigrationassessment.v1.Collector.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, clientVersion_);
    }
    if (guestOsScan_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getGuestOsScan());
    }
    if (vsphereScan_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getVsphereScan());
    }
    if (collectionDays_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(14, collectionDays_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eulaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, eulaUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.rapidmigrationassessment.v1.Collector)) {
      return super.equals(obj);
    }
    com.google.cloud.rapidmigrationassessment.v1.Collector other =
        (com.google.cloud.rapidmigrationassessment.v1.Collector) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getBucket().equals(other.getBucket())) return false;
    if (getExpectedAssetCount() != other.getExpectedAssetCount()) return false;
    if (state_ != other.state_) return false;
    if (!getClientVersion().equals(other.getClientVersion())) return false;
    if (hasGuestOsScan() != other.hasGuestOsScan()) return false;
    if (hasGuestOsScan()) {
      if (!getGuestOsScan().equals(other.getGuestOsScan())) return false;
    }
    if (hasVsphereScan() != other.hasVsphereScan()) return false;
    if (hasVsphereScan()) {
      if (!getVsphereScan().equals(other.getVsphereScan())) return false;
    }
    if (getCollectionDays() != other.getCollectionDays()) return false;
    if (!getEulaUri().equals(other.getEulaUri())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getBucket().hashCode();
    hash = (37 * hash) + EXPECTED_ASSET_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getExpectedAssetCount());
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + CLIENT_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getClientVersion().hashCode();
    if (hasGuestOsScan()) {
      hash = (37 * hash) + GUEST_OS_SCAN_FIELD_NUMBER;
      hash = (53 * hash) + getGuestOsScan().hashCode();
    }
    if (hasVsphereScan()) {
      hash = (37 * hash) + VSPHERE_SCAN_FIELD_NUMBER;
      hash = (53 * hash) + getVsphereScan().hashCode();
    }
    hash = (37 * hash) + COLLECTION_DAYS_FIELD_NUMBER;
    hash = (53 * hash) + getCollectionDays();
    hash = (37 * hash) + EULA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getEulaUri().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.rapidmigrationassessment.v1.Collector parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.rapidmigrationassessment.v1.Collector parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.rapidmigrationassessment.v1.Collector parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.rapidmigrationassessment.v1.Collector parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.rapidmigrationassessment.v1.Collector parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.rapidmigrationassessment.v1.Collector parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.rapidmigrationassessment.v1.Collector parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.rapidmigrationassessment.v1.Collector parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.rapidmigrationassessment.v1.Collector parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.rapidmigrationassessment.v1.Collector parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.rapidmigrationassessment.v1.Collector parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.rapidmigrationassessment.v1.Collector parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.rapidmigrationassessment.v1.Collector prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Message describing Collector object.
   * </pre>
   *
   * Protobuf type {@code google.cloud.rapidmigrationassessment.v1.Collector}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.rapidmigrationassessment.v1.Collector)
      com.google.cloud.rapidmigrationassessment.v1.CollectorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.rapidmigrationassessment.v1.ApiEntitiesProto
          .internal_static_google_cloud_rapidmigrationassessment_v1_Collector_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.rapidmigrationassessment.v1.ApiEntitiesProto
          .internal_static_google_cloud_rapidmigrationassessment_v1_Collector_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.rapidmigrationassessment.v1.Collector.class,
              com.google.cloud.rapidmigrationassessment.v1.Collector.Builder.class);
    }

    // Construct using com.google.cloud.rapidmigrationassessment.v1.Collector.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      displayName_ = "";
      description_ = "";
      serviceAccount_ = "";
      bucket_ = "";
      expectedAssetCount_ = 0L;
      state_ = 0;
      clientVersion_ = "";
      guestOsScan_ = null;
      if (guestOsScanBuilder_ != null) {
        guestOsScanBuilder_.dispose();
        guestOsScanBuilder_ = null;
      }
      vsphereScan_ = null;
      if (vsphereScanBuilder_ != null) {
        vsphereScanBuilder_.dispose();
        vsphereScanBuilder_ = null;
      }
      collectionDays_ = 0;
      eulaUri_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.rapidmigrationassessment.v1.ApiEntitiesProto
          .internal_static_google_cloud_rapidmigrationassessment_v1_Collector_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.rapidmigrationassessment.v1.Collector getDefaultInstanceForType() {
      return com.google.cloud.rapidmigrationassessment.v1.Collector.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.rapidmigrationassessment.v1.Collector build() {
      com.google.cloud.rapidmigrationassessment.v1.Collector result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.rapidmigrationassessment.v1.Collector buildPartial() {
      com.google.cloud.rapidmigrationassessment.v1.Collector result =
          new com.google.cloud.rapidmigrationassessment.v1.Collector(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.rapidmigrationassessment.v1.Collector result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.bucket_ = bucket_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.expectedAssetCount_ = expectedAssetCount_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.clientVersion_ = clientVersion_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.guestOsScan_ =
            guestOsScanBuilder_ == null ? guestOsScan_ : guestOsScanBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.vsphereScan_ =
            vsphereScanBuilder_ == null ? vsphereScan_ : vsphereScanBuilder_.build();
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.collectionDays_ = collectionDays_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.eulaUri_ = eulaUri_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.rapidmigrationassessment.v1.Collector) {
        return mergeFrom((com.google.cloud.rapidmigrationassessment.v1.Collector) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.rapidmigrationassessment.v1.Collector other) {
      if (other == com.google.cloud.rapidmigrationassessment.v1.Collector.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getBucket().isEmpty()) {
        bucket_ = other.bucket_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.getExpectedAssetCount() != 0L) {
        setExpectedAssetCount(other.getExpectedAssetCount());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getClientVersion().isEmpty()) {
        clientVersion_ = other.clientVersion_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasGuestOsScan()) {
        mergeGuestOsScan(other.getGuestOsScan());
      }
      if (other.hasVsphereScan()) {
        mergeVsphereScan(other.getVsphereScan());
      }
      if (other.getCollectionDays() != 0) {
        setCollectionDays(other.getCollectionDays());
      }
      if (!other.getEulaUri().isEmpty()) {
        eulaUri_ = other.eulaUri_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                bucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                expectedAssetCount_ = input.readInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 80:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 90:
              {
                clientVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getGuestOsScanFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getVsphereScanFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 112:
              {
                collectionDays_ = input.readInt32();
                bitField0_ |= 0x00002000;
                break;
              } // case 112
            case 122:
              {
                eulaUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * name of resource.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * name of resource.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * name of resource.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * name of resource.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * name of resource.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Create time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Update time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time stamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * User specified name of the Collector.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User specified name of the Collector.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User specified name of the Collector.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified name of the Collector.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified name of the Collector.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * User specified description of the Collector.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User specified description of the Collector.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User specified description of the Collector.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified description of the Collector.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified description of the Collector.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Service Account email used to ingest data to this Collector.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Service Account email used to ingest data to this Collector.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Service Account email used to ingest data to this Collector.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service Account email used to ingest data to this Collector.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service Account email used to ingest data to this Collector.
     * </pre>
     *
     * <code>string service_account = 7;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object bucket_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Store cloud storage bucket name (which is a guid) created with
     * this Collector.
     * </pre>
     *
     * <code>string bucket = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bucket.
     */
    public java.lang.String getBucket() {
      java.lang.Object ref = bucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Store cloud storage bucket name (which is a guid) created with
     * this Collector.
     * </pre>
     *
     * <code>string bucket = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for bucket.
     */
    public com.google.protobuf.ByteString getBucketBytes() {
      java.lang.Object ref = bucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Store cloud storage bucket name (which is a guid) created with
     * this Collector.
     * </pre>
     *
     * <code>string bucket = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bucket to set.
     * @return This builder for chaining.
     */
    public Builder setBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bucket_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Store cloud storage bucket name (which is a guid) created with
     * this Collector.
     * </pre>
     *
     * <code>string bucket = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucket() {
      bucket_ = getDefaultInstance().getBucket();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Store cloud storage bucket name (which is a guid) created with
     * this Collector.
     * </pre>
     *
     * <code>string bucket = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for bucket to set.
     * @return This builder for chaining.
     */
    public Builder setBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bucket_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private long expectedAssetCount_;
    /**
     *
     *
     * <pre>
     * User specified expected asset count.
     * </pre>
     *
     * <code>int64 expected_asset_count = 9;</code>
     *
     * @return The expectedAssetCount.
     */
    @java.lang.Override
    public long getExpectedAssetCount() {
      return expectedAssetCount_;
    }
    /**
     *
     *
     * <pre>
     * User specified expected asset count.
     * </pre>
     *
     * <code>int64 expected_asset_count = 9;</code>
     *
     * @param value The expectedAssetCount to set.
     * @return This builder for chaining.
     */
    public Builder setExpectedAssetCount(long value) {

      expectedAssetCount_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User specified expected asset count.
     * </pre>
     *
     * <code>int64 expected_asset_count = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExpectedAssetCount() {
      bitField0_ = (bitField0_ & ~0x00000100);
      expectedAssetCount_ = 0L;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the Collector.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.Collector.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Collector.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.Collector.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Collector.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.Collector.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.rapidmigrationassessment.v1.Collector.State getState() {
      com.google.cloud.rapidmigrationassessment.v1.Collector.State result =
          com.google.cloud.rapidmigrationassessment.v1.Collector.State.forNumber(state_);
      return result == null
          ? com.google.cloud.rapidmigrationassessment.v1.Collector.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Collector.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.Collector.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.rapidmigrationassessment.v1.Collector.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the Collector.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.Collector.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000200);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object clientVersion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Client version.
     * </pre>
     *
     * <code>string client_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The clientVersion.
     */
    public java.lang.String getClientVersion() {
      java.lang.Object ref = clientVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Client version.
     * </pre>
     *
     * <code>string client_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for clientVersion.
     */
    public com.google.protobuf.ByteString getClientVersionBytes() {
      java.lang.Object ref = clientVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Client version.
     * </pre>
     *
     * <code>string client_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The clientVersion to set.
     * @return This builder for chaining.
     */
    public Builder setClientVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clientVersion_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Client version.
     * </pre>
     *
     * <code>string client_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientVersion() {
      clientVersion_ = getDefaultInstance().getClientVersion();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Client version.
     * </pre>
     *
     * <code>string client_version = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for clientVersion to set.
     * @return This builder for chaining.
     */
    public Builder setClientVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clientVersion_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.cloud.rapidmigrationassessment.v1.GuestOsScan guestOsScan_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.rapidmigrationassessment.v1.GuestOsScan,
            com.google.cloud.rapidmigrationassessment.v1.GuestOsScan.Builder,
            com.google.cloud.rapidmigrationassessment.v1.GuestOsScanOrBuilder>
        guestOsScanBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source Guest Os Scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.GuestOsScan guest_os_scan = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the guestOsScan field is set.
     */
    public boolean hasGuestOsScan() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source Guest Os Scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.GuestOsScan guest_os_scan = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The guestOsScan.
     */
    public com.google.cloud.rapidmigrationassessment.v1.GuestOsScan getGuestOsScan() {
      if (guestOsScanBuilder_ == null) {
        return guestOsScan_ == null
            ? com.google.cloud.rapidmigrationassessment.v1.GuestOsScan.getDefaultInstance()
            : guestOsScan_;
      } else {
        return guestOsScanBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source Guest Os Scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.GuestOsScan guest_os_scan = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGuestOsScan(com.google.cloud.rapidmigrationassessment.v1.GuestOsScan value) {
      if (guestOsScanBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        guestOsScan_ = value;
      } else {
        guestOsScanBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source Guest Os Scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.GuestOsScan guest_os_scan = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGuestOsScan(
        com.google.cloud.rapidmigrationassessment.v1.GuestOsScan.Builder builderForValue) {
      if (guestOsScanBuilder_ == null) {
        guestOsScan_ = builderForValue.build();
      } else {
        guestOsScanBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source Guest Os Scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.GuestOsScan guest_os_scan = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeGuestOsScan(
        com.google.cloud.rapidmigrationassessment.v1.GuestOsScan value) {
      if (guestOsScanBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && guestOsScan_ != null
            && guestOsScan_
                != com.google.cloud.rapidmigrationassessment.v1.GuestOsScan.getDefaultInstance()) {
          getGuestOsScanBuilder().mergeFrom(value);
        } else {
          guestOsScan_ = value;
        }
      } else {
        guestOsScanBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source Guest Os Scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.GuestOsScan guest_os_scan = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearGuestOsScan() {
      bitField0_ = (bitField0_ & ~0x00000800);
      guestOsScan_ = null;
      if (guestOsScanBuilder_ != null) {
        guestOsScanBuilder_.dispose();
        guestOsScanBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source Guest Os Scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.GuestOsScan guest_os_scan = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.rapidmigrationassessment.v1.GuestOsScan.Builder
        getGuestOsScanBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getGuestOsScanFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source Guest Os Scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.GuestOsScan guest_os_scan = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.rapidmigrationassessment.v1.GuestOsScanOrBuilder
        getGuestOsScanOrBuilder() {
      if (guestOsScanBuilder_ != null) {
        return guestOsScanBuilder_.getMessageOrBuilder();
      } else {
        return guestOsScan_ == null
            ? com.google.cloud.rapidmigrationassessment.v1.GuestOsScan.getDefaultInstance()
            : guestOsScan_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source Guest Os Scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.GuestOsScan guest_os_scan = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.rapidmigrationassessment.v1.GuestOsScan,
            com.google.cloud.rapidmigrationassessment.v1.GuestOsScan.Builder,
            com.google.cloud.rapidmigrationassessment.v1.GuestOsScanOrBuilder>
        getGuestOsScanFieldBuilder() {
      if (guestOsScanBuilder_ == null) {
        guestOsScanBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.rapidmigrationassessment.v1.GuestOsScan,
                com.google.cloud.rapidmigrationassessment.v1.GuestOsScan.Builder,
                com.google.cloud.rapidmigrationassessment.v1.GuestOsScanOrBuilder>(
                getGuestOsScan(), getParentForChildren(), isClean());
        guestOsScan_ = null;
      }
      return guestOsScanBuilder_;
    }

    private com.google.cloud.rapidmigrationassessment.v1.VSphereScan vsphereScan_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.rapidmigrationassessment.v1.VSphereScan,
            com.google.cloud.rapidmigrationassessment.v1.VSphereScan.Builder,
            com.google.cloud.rapidmigrationassessment.v1.VSphereScanOrBuilder>
        vsphereScanBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source vsphere_scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.VSphereScan vsphere_scan = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the vsphereScan field is set.
     */
    public boolean hasVsphereScan() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source vsphere_scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.VSphereScan vsphere_scan = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The vsphereScan.
     */
    public com.google.cloud.rapidmigrationassessment.v1.VSphereScan getVsphereScan() {
      if (vsphereScanBuilder_ == null) {
        return vsphereScan_ == null
            ? com.google.cloud.rapidmigrationassessment.v1.VSphereScan.getDefaultInstance()
            : vsphereScan_;
      } else {
        return vsphereScanBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source vsphere_scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.VSphereScan vsphere_scan = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVsphereScan(com.google.cloud.rapidmigrationassessment.v1.VSphereScan value) {
      if (vsphereScanBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vsphereScan_ = value;
      } else {
        vsphereScanBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source vsphere_scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.VSphereScan vsphere_scan = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVsphereScan(
        com.google.cloud.rapidmigrationassessment.v1.VSphereScan.Builder builderForValue) {
      if (vsphereScanBuilder_ == null) {
        vsphereScan_ = builderForValue.build();
      } else {
        vsphereScanBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source vsphere_scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.VSphereScan vsphere_scan = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeVsphereScan(
        com.google.cloud.rapidmigrationassessment.v1.VSphereScan value) {
      if (vsphereScanBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && vsphereScan_ != null
            && vsphereScan_
                != com.google.cloud.rapidmigrationassessment.v1.VSphereScan.getDefaultInstance()) {
          getVsphereScanBuilder().mergeFrom(value);
        } else {
          vsphereScan_ = value;
        }
      } else {
        vsphereScanBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source vsphere_scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.VSphereScan vsphere_scan = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearVsphereScan() {
      bitField0_ = (bitField0_ & ~0x00001000);
      vsphereScan_ = null;
      if (vsphereScanBuilder_ != null) {
        vsphereScanBuilder_.dispose();
        vsphereScanBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source vsphere_scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.VSphereScan vsphere_scan = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.rapidmigrationassessment.v1.VSphereScan.Builder
        getVsphereScanBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getVsphereScanFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source vsphere_scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.VSphereScan vsphere_scan = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.rapidmigrationassessment.v1.VSphereScanOrBuilder
        getVsphereScanOrBuilder() {
      if (vsphereScanBuilder_ != null) {
        return vsphereScanBuilder_.getMessageOrBuilder();
      } else {
        return vsphereScan_ == null
            ? com.google.cloud.rapidmigrationassessment.v1.VSphereScan.getDefaultInstance()
            : vsphereScan_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Reference to MC Source vsphere_scan.
     * </pre>
     *
     * <code>
     * .google.cloud.rapidmigrationassessment.v1.VSphereScan vsphere_scan = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.rapidmigrationassessment.v1.VSphereScan,
            com.google.cloud.rapidmigrationassessment.v1.VSphereScan.Builder,
            com.google.cloud.rapidmigrationassessment.v1.VSphereScanOrBuilder>
        getVsphereScanFieldBuilder() {
      if (vsphereScanBuilder_ == null) {
        vsphereScanBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.rapidmigrationassessment.v1.VSphereScan,
                com.google.cloud.rapidmigrationassessment.v1.VSphereScan.Builder,
                com.google.cloud.rapidmigrationassessment.v1.VSphereScanOrBuilder>(
                getVsphereScan(), getParentForChildren(), isClean());
        vsphereScan_ = null;
      }
      return vsphereScanBuilder_;
    }

    private int collectionDays_;
    /**
     *
     *
     * <pre>
     * How many days to collect data.
     * </pre>
     *
     * <code>int32 collection_days = 14;</code>
     *
     * @return The collectionDays.
     */
    @java.lang.Override
    public int getCollectionDays() {
      return collectionDays_;
    }
    /**
     *
     *
     * <pre>
     * How many days to collect data.
     * </pre>
     *
     * <code>int32 collection_days = 14;</code>
     *
     * @param value The collectionDays to set.
     * @return This builder for chaining.
     */
    public Builder setCollectionDays(int value) {

      collectionDays_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How many days to collect data.
     * </pre>
     *
     * <code>int32 collection_days = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCollectionDays() {
      bitField0_ = (bitField0_ & ~0x00002000);
      collectionDays_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object eulaUri_ = "";
    /**
     *
     *
     * <pre>
     * Uri for EULA (End User License Agreement) from customer.
     * </pre>
     *
     * <code>string eula_uri = 15;</code>
     *
     * @return The eulaUri.
     */
    public java.lang.String getEulaUri() {
      java.lang.Object ref = eulaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        eulaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Uri for EULA (End User License Agreement) from customer.
     * </pre>
     *
     * <code>string eula_uri = 15;</code>
     *
     * @return The bytes for eulaUri.
     */
    public com.google.protobuf.ByteString getEulaUriBytes() {
      java.lang.Object ref = eulaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        eulaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Uri for EULA (End User License Agreement) from customer.
     * </pre>
     *
     * <code>string eula_uri = 15;</code>
     *
     * @param value The eulaUri to set.
     * @return This builder for chaining.
     */
    public Builder setEulaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      eulaUri_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uri for EULA (End User License Agreement) from customer.
     * </pre>
     *
     * <code>string eula_uri = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEulaUri() {
      eulaUri_ = getDefaultInstance().getEulaUri();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uri for EULA (End User License Agreement) from customer.
     * </pre>
     *
     * <code>string eula_uri = 15;</code>
     *
     * @param value The bytes for eulaUri to set.
     * @return This builder for chaining.
     */
    public Builder setEulaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      eulaUri_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.rapidmigrationassessment.v1.Collector)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.rapidmigrationassessment.v1.Collector)
  private static final com.google.cloud.rapidmigrationassessment.v1.Collector DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.rapidmigrationassessment.v1.Collector();
  }

  public static com.google.cloud.rapidmigrationassessment.v1.Collector getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Collector> PARSER =
      new com.google.protobuf.AbstractParser<Collector>() {
        @java.lang.Override
        public Collector parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Collector> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Collector> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.rapidmigrationassessment.v1.Collector getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
