/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.rapidmigrationassessment.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CollectorName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_COLLECTOR = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collectors/{collector}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String collector;

    @Deprecated
    protected CollectorName() {
        this.project = null;
        this.location = null;
        this.collector = null;
    }

    private CollectorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collector = (String)Preconditions.checkNotNull((Object)builder.getCollector());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCollector() {
        return this.collector;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CollectorName of(String project, String location, String collector) {
        return CollectorName.newBuilder().setProject(project).setLocation(location).setCollector(collector).build();
    }

    public static String format(String project, String location, String collector) {
        return CollectorName.newBuilder().setProject(project).setLocation(location).setCollector(collector).build().toString();
    }

    public static CollectorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_COLLECTOR.validatedMatch(formattedString, "CollectorName.parse: formattedString not in valid format");
        return CollectorName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collector"));
    }

    public static List<CollectorName> parseList(List<String> formattedStrings) {
        ArrayList<CollectorName> list = new ArrayList<CollectorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CollectorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CollectorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CollectorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_COLLECTOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CollectorName collectorName = this;
            synchronized (collectorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.collector != null) {
                        fieldMapBuilder.put((Object)"collector", (Object)this.collector);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_COLLECTOR.instantiate(new String[]{"project", this.project, "location", this.location, "collector", this.collector});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CollectorName that = (CollectorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.collector, that.collector);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.collector);
    }

    public static class Builder {
        private String project;
        private String location;
        private String collector;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollector() {
            return this.collector;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCollector(String collector) {
            this.collector = collector;
            return this;
        }

        private Builder(CollectorName collectorName) {
            this.project = collectorName.project;
            this.location = collectorName.location;
            this.collector = collectorName.collector;
        }

        public CollectorName build() {
            return new CollectorName(this);
        }
    }
}

