/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

package com.google.recaptchaenterprise.v1;

/**
 *
 *
 * <pre>
 * A recaptcha assessment resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1.Assessment}
 */
public final class Assessment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1.Assessment)
    AssessmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Assessment.newBuilder() to construct.
  private Assessment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Assessment() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Assessment();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Assessment(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              com.google.recaptchaenterprise.v1.Event.Builder subBuilder = null;
              if (event_ != null) {
                subBuilder = event_.toBuilder();
              }
              event_ =
                  input.readMessage(
                      com.google.recaptchaenterprise.v1.Event.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(event_);
                event_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.recaptchaenterprise.v1.RiskAnalysis.Builder subBuilder = null;
              if (riskAnalysis_ != null) {
                subBuilder = riskAnalysis_.toBuilder();
              }
              riskAnalysis_ =
                  input.readMessage(
                      com.google.recaptchaenterprise.v1.RiskAnalysis.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(riskAnalysis_);
                riskAnalysis_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.recaptchaenterprise.v1.TokenProperties.Builder subBuilder = null;
              if (tokenProperties_ != null) {
                subBuilder = tokenProperties_.toBuilder();
              }
              tokenProperties_ =
                  input.readMessage(
                      com.google.recaptchaenterprise.v1.TokenProperties.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(tokenProperties_);
                tokenProperties_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.recaptchaenterprise.v1.AccountDefenderAssessment.Builder subBuilder = null;
              if (accountDefenderAssessment_ != null) {
                subBuilder = accountDefenderAssessment_.toBuilder();
              }
              accountDefenderAssessment_ =
                  input.readMessage(
                      com.google.recaptchaenterprise.v1.AccountDefenderAssessment.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(accountDefenderAssessment_);
                accountDefenderAssessment_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_Assessment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_Assessment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1.Assessment.class,
            com.google.recaptchaenterprise.v1.Assessment.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name for the Assessment in the format
   * "projects/{project}/assessments/{assessment}".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name for the Assessment in the format
   * "projects/{project}/assessments/{assessment}".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_FIELD_NUMBER = 2;
  private com.google.recaptchaenterprise.v1.Event event_;
  /**
   *
   *
   * <pre>
   * The event being assessed.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1.Event event = 2;</code>
   *
   * @return Whether the event field is set.
   */
  @java.lang.Override
  public boolean hasEvent() {
    return event_ != null;
  }
  /**
   *
   *
   * <pre>
   * The event being assessed.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1.Event event = 2;</code>
   *
   * @return The event.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.Event getEvent() {
    return event_ == null ? com.google.recaptchaenterprise.v1.Event.getDefaultInstance() : event_;
  }
  /**
   *
   *
   * <pre>
   * The event being assessed.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1.Event event = 2;</code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.EventOrBuilder getEventOrBuilder() {
    return getEvent();
  }

  public static final int RISK_ANALYSIS_FIELD_NUMBER = 3;
  private com.google.recaptchaenterprise.v1.RiskAnalysis riskAnalysis_;
  /**
   *
   *
   * <pre>
   * Output only. The risk analysis result for the event being assessed.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the riskAnalysis field is set.
   */
  @java.lang.Override
  public boolean hasRiskAnalysis() {
    return riskAnalysis_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The risk analysis result for the event being assessed.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The riskAnalysis.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.RiskAnalysis getRiskAnalysis() {
    return riskAnalysis_ == null
        ? com.google.recaptchaenterprise.v1.RiskAnalysis.getDefaultInstance()
        : riskAnalysis_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The risk analysis result for the event being assessed.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.RiskAnalysisOrBuilder getRiskAnalysisOrBuilder() {
    return getRiskAnalysis();
  }

  public static final int TOKEN_PROPERTIES_FIELD_NUMBER = 4;
  private com.google.recaptchaenterprise.v1.TokenProperties tokenProperties_;
  /**
   *
   *
   * <pre>
   * Output only. Properties of the provided event token.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the tokenProperties field is set.
   */
  @java.lang.Override
  public boolean hasTokenProperties() {
    return tokenProperties_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Properties of the provided event token.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The tokenProperties.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.TokenProperties getTokenProperties() {
    return tokenProperties_ == null
        ? com.google.recaptchaenterprise.v1.TokenProperties.getDefaultInstance()
        : tokenProperties_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Properties of the provided event token.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.TokenPropertiesOrBuilder getTokenPropertiesOrBuilder() {
    return getTokenProperties();
  }

  public static final int ACCOUNT_DEFENDER_ASSESSMENT_FIELD_NUMBER = 6;
  private com.google.recaptchaenterprise.v1.AccountDefenderAssessment accountDefenderAssessment_;
  /**
   *
   *
   * <pre>
   * Assessment returned by Account Defender when a hashed_account_id is
   * provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6;
   * </code>
   *
   * @return Whether the accountDefenderAssessment field is set.
   */
  @java.lang.Override
  public boolean hasAccountDefenderAssessment() {
    return accountDefenderAssessment_ != null;
  }
  /**
   *
   *
   * <pre>
   * Assessment returned by Account Defender when a hashed_account_id is
   * provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6;
   * </code>
   *
   * @return The accountDefenderAssessment.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AccountDefenderAssessment
      getAccountDefenderAssessment() {
    return accountDefenderAssessment_ == null
        ? com.google.recaptchaenterprise.v1.AccountDefenderAssessment.getDefaultInstance()
        : accountDefenderAssessment_;
  }
  /**
   *
   *
   * <pre>
   * Assessment returned by Account Defender when a hashed_account_id is
   * provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AccountDefenderAssessmentOrBuilder
      getAccountDefenderAssessmentOrBuilder() {
    return getAccountDefenderAssessment();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (event_ != null) {
      output.writeMessage(2, getEvent());
    }
    if (riskAnalysis_ != null) {
      output.writeMessage(3, getRiskAnalysis());
    }
    if (tokenProperties_ != null) {
      output.writeMessage(4, getTokenProperties());
    }
    if (accountDefenderAssessment_ != null) {
      output.writeMessage(6, getAccountDefenderAssessment());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (event_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEvent());
    }
    if (riskAnalysis_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRiskAnalysis());
    }
    if (tokenProperties_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTokenProperties());
    }
    if (accountDefenderAssessment_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, getAccountDefenderAssessment());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1.Assessment)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1.Assessment other =
        (com.google.recaptchaenterprise.v1.Assessment) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasEvent() != other.hasEvent()) return false;
    if (hasEvent()) {
      if (!getEvent().equals(other.getEvent())) return false;
    }
    if (hasRiskAnalysis() != other.hasRiskAnalysis()) return false;
    if (hasRiskAnalysis()) {
      if (!getRiskAnalysis().equals(other.getRiskAnalysis())) return false;
    }
    if (hasTokenProperties() != other.hasTokenProperties()) return false;
    if (hasTokenProperties()) {
      if (!getTokenProperties().equals(other.getTokenProperties())) return false;
    }
    if (hasAccountDefenderAssessment() != other.hasAccountDefenderAssessment()) return false;
    if (hasAccountDefenderAssessment()) {
      if (!getAccountDefenderAssessment().equals(other.getAccountDefenderAssessment()))
        return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasEvent()) {
      hash = (37 * hash) + EVENT_FIELD_NUMBER;
      hash = (53 * hash) + getEvent().hashCode();
    }
    if (hasRiskAnalysis()) {
      hash = (37 * hash) + RISK_ANALYSIS_FIELD_NUMBER;
      hash = (53 * hash) + getRiskAnalysis().hashCode();
    }
    if (hasTokenProperties()) {
      hash = (37 * hash) + TOKEN_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getTokenProperties().hashCode();
    }
    if (hasAccountDefenderAssessment()) {
      hash = (37 * hash) + ACCOUNT_DEFENDER_ASSESSMENT_FIELD_NUMBER;
      hash = (53 * hash) + getAccountDefenderAssessment().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.recaptchaenterprise.v1.Assessment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A recaptcha assessment resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1.Assessment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1.Assessment)
      com.google.recaptchaenterprise.v1.AssessmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Assessment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Assessment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1.Assessment.class,
              com.google.recaptchaenterprise.v1.Assessment.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1.Assessment.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (eventBuilder_ == null) {
        event_ = null;
      } else {
        event_ = null;
        eventBuilder_ = null;
      }
      if (riskAnalysisBuilder_ == null) {
        riskAnalysis_ = null;
      } else {
        riskAnalysis_ = null;
        riskAnalysisBuilder_ = null;
      }
      if (tokenPropertiesBuilder_ == null) {
        tokenProperties_ = null;
      } else {
        tokenProperties_ = null;
        tokenPropertiesBuilder_ = null;
      }
      if (accountDefenderAssessmentBuilder_ == null) {
        accountDefenderAssessment_ = null;
      } else {
        accountDefenderAssessment_ = null;
        accountDefenderAssessmentBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Assessment_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Assessment getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1.Assessment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Assessment build() {
      com.google.recaptchaenterprise.v1.Assessment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Assessment buildPartial() {
      com.google.recaptchaenterprise.v1.Assessment result =
          new com.google.recaptchaenterprise.v1.Assessment(this);
      result.name_ = name_;
      if (eventBuilder_ == null) {
        result.event_ = event_;
      } else {
        result.event_ = eventBuilder_.build();
      }
      if (riskAnalysisBuilder_ == null) {
        result.riskAnalysis_ = riskAnalysis_;
      } else {
        result.riskAnalysis_ = riskAnalysisBuilder_.build();
      }
      if (tokenPropertiesBuilder_ == null) {
        result.tokenProperties_ = tokenProperties_;
      } else {
        result.tokenProperties_ = tokenPropertiesBuilder_.build();
      }
      if (accountDefenderAssessmentBuilder_ == null) {
        result.accountDefenderAssessment_ = accountDefenderAssessment_;
      } else {
        result.accountDefenderAssessment_ = accountDefenderAssessmentBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1.Assessment) {
        return mergeFrom((com.google.recaptchaenterprise.v1.Assessment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1.Assessment other) {
      if (other == com.google.recaptchaenterprise.v1.Assessment.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasEvent()) {
        mergeEvent(other.getEvent());
      }
      if (other.hasRiskAnalysis()) {
        mergeRiskAnalysis(other.getRiskAnalysis());
      }
      if (other.hasTokenProperties()) {
        mergeTokenProperties(other.getTokenProperties());
      }
      if (other.hasAccountDefenderAssessment()) {
        mergeAccountDefenderAssessment(other.getAccountDefenderAssessment());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.recaptchaenterprise.v1.Assessment parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.recaptchaenterprise.v1.Assessment) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * "projects/{project}/assessments/{assessment}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * "projects/{project}/assessments/{assessment}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * "projects/{project}/assessments/{assessment}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * "projects/{project}/assessments/{assessment}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for the Assessment in the format
     * "projects/{project}/assessments/{assessment}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.recaptchaenterprise.v1.Event event_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.Event,
            com.google.recaptchaenterprise.v1.Event.Builder,
            com.google.recaptchaenterprise.v1.EventOrBuilder>
        eventBuilder_;
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.Event event = 2;</code>
     *
     * @return Whether the event field is set.
     */
    public boolean hasEvent() {
      return eventBuilder_ != null || event_ != null;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.Event event = 2;</code>
     *
     * @return The event.
     */
    public com.google.recaptchaenterprise.v1.Event getEvent() {
      if (eventBuilder_ == null) {
        return event_ == null
            ? com.google.recaptchaenterprise.v1.Event.getDefaultInstance()
            : event_;
      } else {
        return eventBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.Event event = 2;</code>
     */
    public Builder setEvent(com.google.recaptchaenterprise.v1.Event value) {
      if (eventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        event_ = value;
        onChanged();
      } else {
        eventBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.Event event = 2;</code>
     */
    public Builder setEvent(com.google.recaptchaenterprise.v1.Event.Builder builderForValue) {
      if (eventBuilder_ == null) {
        event_ = builderForValue.build();
        onChanged();
      } else {
        eventBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.Event event = 2;</code>
     */
    public Builder mergeEvent(com.google.recaptchaenterprise.v1.Event value) {
      if (eventBuilder_ == null) {
        if (event_ != null) {
          event_ =
              com.google.recaptchaenterprise.v1.Event.newBuilder(event_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          event_ = value;
        }
        onChanged();
      } else {
        eventBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.Event event = 2;</code>
     */
    public Builder clearEvent() {
      if (eventBuilder_ == null) {
        event_ = null;
        onChanged();
      } else {
        event_ = null;
        eventBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.Event event = 2;</code>
     */
    public com.google.recaptchaenterprise.v1.Event.Builder getEventBuilder() {

      onChanged();
      return getEventFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.Event event = 2;</code>
     */
    public com.google.recaptchaenterprise.v1.EventOrBuilder getEventOrBuilder() {
      if (eventBuilder_ != null) {
        return eventBuilder_.getMessageOrBuilder();
      } else {
        return event_ == null
            ? com.google.recaptchaenterprise.v1.Event.getDefaultInstance()
            : event_;
      }
    }
    /**
     *
     *
     * <pre>
     * The event being assessed.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.Event event = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.Event,
            com.google.recaptchaenterprise.v1.Event.Builder,
            com.google.recaptchaenterprise.v1.EventOrBuilder>
        getEventFieldBuilder() {
      if (eventBuilder_ == null) {
        eventBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.Event,
                com.google.recaptchaenterprise.v1.Event.Builder,
                com.google.recaptchaenterprise.v1.EventOrBuilder>(
                getEvent(), getParentForChildren(), isClean());
        event_ = null;
      }
      return eventBuilder_;
    }

    private com.google.recaptchaenterprise.v1.RiskAnalysis riskAnalysis_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.RiskAnalysis,
            com.google.recaptchaenterprise.v1.RiskAnalysis.Builder,
            com.google.recaptchaenterprise.v1.RiskAnalysisOrBuilder>
        riskAnalysisBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the riskAnalysis field is set.
     */
    public boolean hasRiskAnalysis() {
      return riskAnalysisBuilder_ != null || riskAnalysis_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The riskAnalysis.
     */
    public com.google.recaptchaenterprise.v1.RiskAnalysis getRiskAnalysis() {
      if (riskAnalysisBuilder_ == null) {
        return riskAnalysis_ == null
            ? com.google.recaptchaenterprise.v1.RiskAnalysis.getDefaultInstance()
            : riskAnalysis_;
      } else {
        return riskAnalysisBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRiskAnalysis(com.google.recaptchaenterprise.v1.RiskAnalysis value) {
      if (riskAnalysisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        riskAnalysis_ = value;
        onChanged();
      } else {
        riskAnalysisBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRiskAnalysis(
        com.google.recaptchaenterprise.v1.RiskAnalysis.Builder builderForValue) {
      if (riskAnalysisBuilder_ == null) {
        riskAnalysis_ = builderForValue.build();
        onChanged();
      } else {
        riskAnalysisBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRiskAnalysis(com.google.recaptchaenterprise.v1.RiskAnalysis value) {
      if (riskAnalysisBuilder_ == null) {
        if (riskAnalysis_ != null) {
          riskAnalysis_ =
              com.google.recaptchaenterprise.v1.RiskAnalysis.newBuilder(riskAnalysis_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          riskAnalysis_ = value;
        }
        onChanged();
      } else {
        riskAnalysisBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRiskAnalysis() {
      if (riskAnalysisBuilder_ == null) {
        riskAnalysis_ = null;
        onChanged();
      } else {
        riskAnalysis_ = null;
        riskAnalysisBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.RiskAnalysis.Builder getRiskAnalysisBuilder() {

      onChanged();
      return getRiskAnalysisFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.RiskAnalysisOrBuilder getRiskAnalysisOrBuilder() {
      if (riskAnalysisBuilder_ != null) {
        return riskAnalysisBuilder_.getMessageOrBuilder();
      } else {
        return riskAnalysis_ == null
            ? com.google.recaptchaenterprise.v1.RiskAnalysis.getDefaultInstance()
            : riskAnalysis_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.RiskAnalysis,
            com.google.recaptchaenterprise.v1.RiskAnalysis.Builder,
            com.google.recaptchaenterprise.v1.RiskAnalysisOrBuilder>
        getRiskAnalysisFieldBuilder() {
      if (riskAnalysisBuilder_ == null) {
        riskAnalysisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.RiskAnalysis,
                com.google.recaptchaenterprise.v1.RiskAnalysis.Builder,
                com.google.recaptchaenterprise.v1.RiskAnalysisOrBuilder>(
                getRiskAnalysis(), getParentForChildren(), isClean());
        riskAnalysis_ = null;
      }
      return riskAnalysisBuilder_;
    }

    private com.google.recaptchaenterprise.v1.TokenProperties tokenProperties_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.TokenProperties,
            com.google.recaptchaenterprise.v1.TokenProperties.Builder,
            com.google.recaptchaenterprise.v1.TokenPropertiesOrBuilder>
        tokenPropertiesBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the tokenProperties field is set.
     */
    public boolean hasTokenProperties() {
      return tokenPropertiesBuilder_ != null || tokenProperties_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The tokenProperties.
     */
    public com.google.recaptchaenterprise.v1.TokenProperties getTokenProperties() {
      if (tokenPropertiesBuilder_ == null) {
        return tokenProperties_ == null
            ? com.google.recaptchaenterprise.v1.TokenProperties.getDefaultInstance()
            : tokenProperties_;
      } else {
        return tokenPropertiesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTokenProperties(com.google.recaptchaenterprise.v1.TokenProperties value) {
      if (tokenPropertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tokenProperties_ = value;
        onChanged();
      } else {
        tokenPropertiesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTokenProperties(
        com.google.recaptchaenterprise.v1.TokenProperties.Builder builderForValue) {
      if (tokenPropertiesBuilder_ == null) {
        tokenProperties_ = builderForValue.build();
        onChanged();
      } else {
        tokenPropertiesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTokenProperties(com.google.recaptchaenterprise.v1.TokenProperties value) {
      if (tokenPropertiesBuilder_ == null) {
        if (tokenProperties_ != null) {
          tokenProperties_ =
              com.google.recaptchaenterprise.v1.TokenProperties.newBuilder(tokenProperties_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          tokenProperties_ = value;
        }
        onChanged();
      } else {
        tokenPropertiesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTokenProperties() {
      if (tokenPropertiesBuilder_ == null) {
        tokenProperties_ = null;
        onChanged();
      } else {
        tokenProperties_ = null;
        tokenPropertiesBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.TokenProperties.Builder getTokenPropertiesBuilder() {

      onChanged();
      return getTokenPropertiesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.TokenPropertiesOrBuilder
        getTokenPropertiesOrBuilder() {
      if (tokenPropertiesBuilder_ != null) {
        return tokenPropertiesBuilder_.getMessageOrBuilder();
      } else {
        return tokenProperties_ == null
            ? com.google.recaptchaenterprise.v1.TokenProperties.getDefaultInstance()
            : tokenProperties_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.TokenProperties,
            com.google.recaptchaenterprise.v1.TokenProperties.Builder,
            com.google.recaptchaenterprise.v1.TokenPropertiesOrBuilder>
        getTokenPropertiesFieldBuilder() {
      if (tokenPropertiesBuilder_ == null) {
        tokenPropertiesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.TokenProperties,
                com.google.recaptchaenterprise.v1.TokenProperties.Builder,
                com.google.recaptchaenterprise.v1.TokenPropertiesOrBuilder>(
                getTokenProperties(), getParentForChildren(), isClean());
        tokenProperties_ = null;
      }
      return tokenPropertiesBuilder_;
    }

    private com.google.recaptchaenterprise.v1.AccountDefenderAssessment accountDefenderAssessment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.AccountDefenderAssessment,
            com.google.recaptchaenterprise.v1.AccountDefenderAssessment.Builder,
            com.google.recaptchaenterprise.v1.AccountDefenderAssessmentOrBuilder>
        accountDefenderAssessmentBuilder_;
    /**
     *
     *
     * <pre>
     * Assessment returned by Account Defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6;
     * </code>
     *
     * @return Whether the accountDefenderAssessment field is set.
     */
    public boolean hasAccountDefenderAssessment() {
      return accountDefenderAssessmentBuilder_ != null || accountDefenderAssessment_ != null;
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Account Defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6;
     * </code>
     *
     * @return The accountDefenderAssessment.
     */
    public com.google.recaptchaenterprise.v1.AccountDefenderAssessment
        getAccountDefenderAssessment() {
      if (accountDefenderAssessmentBuilder_ == null) {
        return accountDefenderAssessment_ == null
            ? com.google.recaptchaenterprise.v1.AccountDefenderAssessment.getDefaultInstance()
            : accountDefenderAssessment_;
      } else {
        return accountDefenderAssessmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Account Defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6;
     * </code>
     */
    public Builder setAccountDefenderAssessment(
        com.google.recaptchaenterprise.v1.AccountDefenderAssessment value) {
      if (accountDefenderAssessmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        accountDefenderAssessment_ = value;
        onChanged();
      } else {
        accountDefenderAssessmentBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Account Defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6;
     * </code>
     */
    public Builder setAccountDefenderAssessment(
        com.google.recaptchaenterprise.v1.AccountDefenderAssessment.Builder builderForValue) {
      if (accountDefenderAssessmentBuilder_ == null) {
        accountDefenderAssessment_ = builderForValue.build();
        onChanged();
      } else {
        accountDefenderAssessmentBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Account Defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6;
     * </code>
     */
    public Builder mergeAccountDefenderAssessment(
        com.google.recaptchaenterprise.v1.AccountDefenderAssessment value) {
      if (accountDefenderAssessmentBuilder_ == null) {
        if (accountDefenderAssessment_ != null) {
          accountDefenderAssessment_ =
              com.google.recaptchaenterprise.v1.AccountDefenderAssessment.newBuilder(
                      accountDefenderAssessment_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          accountDefenderAssessment_ = value;
        }
        onChanged();
      } else {
        accountDefenderAssessmentBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Account Defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6;
     * </code>
     */
    public Builder clearAccountDefenderAssessment() {
      if (accountDefenderAssessmentBuilder_ == null) {
        accountDefenderAssessment_ = null;
        onChanged();
      } else {
        accountDefenderAssessment_ = null;
        accountDefenderAssessmentBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Account Defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6;
     * </code>
     */
    public com.google.recaptchaenterprise.v1.AccountDefenderAssessment.Builder
        getAccountDefenderAssessmentBuilder() {

      onChanged();
      return getAccountDefenderAssessmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Account Defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6;
     * </code>
     */
    public com.google.recaptchaenterprise.v1.AccountDefenderAssessmentOrBuilder
        getAccountDefenderAssessmentOrBuilder() {
      if (accountDefenderAssessmentBuilder_ != null) {
        return accountDefenderAssessmentBuilder_.getMessageOrBuilder();
      } else {
        return accountDefenderAssessment_ == null
            ? com.google.recaptchaenterprise.v1.AccountDefenderAssessment.getDefaultInstance()
            : accountDefenderAssessment_;
      }
    }
    /**
     *
     *
     * <pre>
     * Assessment returned by Account Defender when a hashed_account_id is
     * provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.AccountDefenderAssessment,
            com.google.recaptchaenterprise.v1.AccountDefenderAssessment.Builder,
            com.google.recaptchaenterprise.v1.AccountDefenderAssessmentOrBuilder>
        getAccountDefenderAssessmentFieldBuilder() {
      if (accountDefenderAssessmentBuilder_ == null) {
        accountDefenderAssessmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.AccountDefenderAssessment,
                com.google.recaptchaenterprise.v1.AccountDefenderAssessment.Builder,
                com.google.recaptchaenterprise.v1.AccountDefenderAssessmentOrBuilder>(
                getAccountDefenderAssessment(), getParentForChildren(), isClean());
        accountDefenderAssessment_ = null;
      }
      return accountDefenderAssessmentBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1.Assessment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1.Assessment)
  private static final com.google.recaptchaenterprise.v1.Assessment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1.Assessment();
  }

  public static com.google.recaptchaenterprise.v1.Assessment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Assessment> PARSER =
      new com.google.protobuf.AbstractParser<Assessment>() {
        @java.lang.Override
        public Assessment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Assessment(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Assessment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Assessment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1.Assessment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
