/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

package com.google.recaptchaenterprise.v1;

/**
 *
 *
 * <pre>
 * The event being assessed.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1.Event}
 */
public final class Event extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1.Event)
    EventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Event.newBuilder() to construct.
  private Event(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Event() {
    token_ = "";
    siteKey_ = "";
    userAgent_ = "";
    userIpAddress_ = "";
    expectedAction_ = "";
    hashedAccountId_ = com.google.protobuf.ByteString.EMPTY;
    requestedUri_ = "";
    ja3_ = "";
    headers_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Event();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_Event_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_Event_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1.Event.class,
            com.google.recaptchaenterprise.v1.Event.Builder.class);
  }

  public static final int TOKEN_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object token_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The user response token provided by the reCAPTCHA Enterprise
   * client-side integration on your site.
   * </pre>
   *
   * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The token.
   */
  @java.lang.Override
  public java.lang.String getToken() {
    java.lang.Object ref = token_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      token_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The user response token provided by the reCAPTCHA Enterprise
   * client-side integration on your site.
   * </pre>
   *
   * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for token.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTokenBytes() {
    java.lang.Object ref = token_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      token_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SITE_KEY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object siteKey_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The site key that was used to invoke reCAPTCHA Enterprise on your
   * site and generate the token.
   * </pre>
   *
   * <code>string site_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The siteKey.
   */
  @java.lang.Override
  public java.lang.String getSiteKey() {
    java.lang.Object ref = siteKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      siteKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The site key that was used to invoke reCAPTCHA Enterprise on your
   * site and generate the token.
   * </pre>
   *
   * <code>string site_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for siteKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSiteKeyBytes() {
    java.lang.Object ref = siteKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      siteKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_AGENT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userAgent_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The user agent present in the request from the user's device
   * related to this event.
   * </pre>
   *
   * <code>string user_agent = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The userAgent.
   */
  @java.lang.Override
  public java.lang.String getUserAgent() {
    java.lang.Object ref = userAgent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userAgent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The user agent present in the request from the user's device
   * related to this event.
   * </pre>
   *
   * <code>string user_agent = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for userAgent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserAgentBytes() {
    java.lang.Object ref = userAgent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userAgent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_IP_ADDRESS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userIpAddress_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The IP address in the request from the user's device related to
   * this event.
   * </pre>
   *
   * <code>string user_ip_address = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The userIpAddress.
   */
  @java.lang.Override
  public java.lang.String getUserIpAddress() {
    java.lang.Object ref = userIpAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userIpAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The IP address in the request from the user's device related to
   * this event.
   * </pre>
   *
   * <code>string user_ip_address = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for userIpAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserIpAddressBytes() {
    java.lang.Object ref = userIpAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userIpAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPECTED_ACTION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object expectedAction_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The expected action for this type of event. This should be the
   * same action provided at token generation time on client-side platforms
   * already integrated with recaptcha enterprise.
   * </pre>
   *
   * <code>string expected_action = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The expectedAction.
   */
  @java.lang.Override
  public java.lang.String getExpectedAction() {
    java.lang.Object ref = expectedAction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      expectedAction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The expected action for this type of event. This should be the
   * same action provided at token generation time on client-side platforms
   * already integrated with recaptcha enterprise.
   * </pre>
   *
   * <code>string expected_action = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for expectedAction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExpectedActionBytes() {
    java.lang.Object ref = expectedAction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      expectedAction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HASHED_ACCOUNT_ID_FIELD_NUMBER = 6;
  private com.google.protobuf.ByteString hashedAccountId_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Optional. Deprecated: use `user_info.account_id` instead.
   * Unique stable hashed user identifier for the request. The identifier must
   * be hashed using hmac-sha256 with stable secret.
   * </pre>
   *
   * <code>bytes hashed_account_id = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.recaptchaenterprise.v1.Event.hashed_account_id is deprecated. See
   *     google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto;l=663
   * @return The hashedAccountId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getHashedAccountId() {
    return hashedAccountId_;
  }

  public static final int EXPRESS_FIELD_NUMBER = 14;
  private boolean express_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Flag for a reCAPTCHA express request for an assessment without a
   * token. If enabled, `site_key` must reference a SCORE key with WAF feature
   * set to EXPRESS.
   * </pre>
   *
   * <code>bool express = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The express.
   */
  @java.lang.Override
  public boolean getExpress() {
    return express_;
  }

  public static final int REQUESTED_URI_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestedUri_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The URI resource the user requested that triggered an assessment.
   * </pre>
   *
   * <code>string requested_uri = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestedUri.
   */
  @java.lang.Override
  public java.lang.String getRequestedUri() {
    java.lang.Object ref = requestedUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestedUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The URI resource the user requested that triggered an assessment.
   * </pre>
   *
   * <code>string requested_uri = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestedUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestedUriBytes() {
    java.lang.Object ref = requestedUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestedUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WAF_TOKEN_ASSESSMENT_FIELD_NUMBER = 9;
  private boolean wafTokenAssessment_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Flag for running WAF token assessment.
   * If enabled, the token must be specified, and have been created by a
   * WAF-enabled key.
   * </pre>
   *
   * <code>bool waf_token_assessment = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The wafTokenAssessment.
   */
  @java.lang.Override
  public boolean getWafTokenAssessment() {
    return wafTokenAssessment_;
  }

  public static final int JA3_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ja3_ = "";
  /**
   *
   *
   * <pre>
   * Optional. JA3 fingerprint for SSL clients.
   * </pre>
   *
   * <code>string ja3 = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The ja3.
   */
  @java.lang.Override
  public java.lang.String getJa3() {
    java.lang.Object ref = ja3_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ja3_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. JA3 fingerprint for SSL clients.
   * </pre>
   *
   * <code>string ja3 = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for ja3.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJa3Bytes() {
    java.lang.Object ref = ja3_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ja3_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEADERS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList headers_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. HTTP header information about the request.
   * </pre>
   *
   * <code>repeated string headers = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the headers.
   */
  public com.google.protobuf.ProtocolStringList getHeadersList() {
    return headers_;
  }
  /**
   *
   *
   * <pre>
   * Optional. HTTP header information about the request.
   * </pre>
   *
   * <code>repeated string headers = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of headers.
   */
  public int getHeadersCount() {
    return headers_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. HTTP header information about the request.
   * </pre>
   *
   * <code>repeated string headers = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The headers at the given index.
   */
  public java.lang.String getHeaders(int index) {
    return headers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. HTTP header information about the request.
   * </pre>
   *
   * <code>repeated string headers = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the headers at the given index.
   */
  public com.google.protobuf.ByteString getHeadersBytes(int index) {
    return headers_.getByteString(index);
  }

  public static final int FIREWALL_POLICY_EVALUATION_FIELD_NUMBER = 12;
  private boolean firewallPolicyEvaluation_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Flag for enabling firewall policy config assessment.
   * If this flag is enabled, the firewall policy will be evaluated and a
   * suggested firewall action will be returned in the response.
   * </pre>
   *
   * <code>bool firewall_policy_evaluation = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The firewallPolicyEvaluation.
   */
  @java.lang.Override
  public boolean getFirewallPolicyEvaluation() {
    return firewallPolicyEvaluation_;
  }

  public static final int TRANSACTION_DATA_FIELD_NUMBER = 13;
  private com.google.recaptchaenterprise.v1.TransactionData transactionData_;
  /**
   *
   *
   * <pre>
   * Optional. Data describing a payment transaction to be assessed. Sending
   * this data enables reCAPTCHA Enterprise Fraud Prevention and the
   * FraudPreventionAssessment component in the response.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.TransactionData transaction_data = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the transactionData field is set.
   */
  @java.lang.Override
  public boolean hasTransactionData() {
    return transactionData_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Data describing a payment transaction to be assessed. Sending
   * this data enables reCAPTCHA Enterprise Fraud Prevention and the
   * FraudPreventionAssessment component in the response.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.TransactionData transaction_data = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The transactionData.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.TransactionData getTransactionData() {
    return transactionData_ == null
        ? com.google.recaptchaenterprise.v1.TransactionData.getDefaultInstance()
        : transactionData_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Data describing a payment transaction to be assessed. Sending
   * this data enables reCAPTCHA Enterprise Fraud Prevention and the
   * FraudPreventionAssessment component in the response.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.TransactionData transaction_data = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.TransactionDataOrBuilder getTransactionDataOrBuilder() {
    return transactionData_ == null
        ? com.google.recaptchaenterprise.v1.TransactionData.getDefaultInstance()
        : transactionData_;
  }

  public static final int USER_INFO_FIELD_NUMBER = 15;
  private com.google.recaptchaenterprise.v1.UserInfo userInfo_;
  /**
   *
   *
   * <pre>
   * Optional. Information about the user that generates this event, when they
   * can be identified. They are often identified through the use of an account
   * for logged-in requests or login/registration requests, or by providing user
   * identifiers for guest actions like checkout.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.UserInfo user_info = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the userInfo field is set.
   */
  @java.lang.Override
  public boolean hasUserInfo() {
    return userInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information about the user that generates this event, when they
   * can be identified. They are often identified through the use of an account
   * for logged-in requests or login/registration requests, or by providing user
   * identifiers for guest actions like checkout.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.UserInfo user_info = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The userInfo.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.UserInfo getUserInfo() {
    return userInfo_ == null
        ? com.google.recaptchaenterprise.v1.UserInfo.getDefaultInstance()
        : userInfo_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information about the user that generates this event, when they
   * can be identified. They are often identified through the use of an account
   * for logged-in requests or login/registration requests, or by providing user
   * identifiers for guest actions like checkout.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.UserInfo user_info = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.UserInfoOrBuilder getUserInfoOrBuilder() {
    return userInfo_ == null
        ? com.google.recaptchaenterprise.v1.UserInfo.getDefaultInstance()
        : userInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(token_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, token_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(siteKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, siteKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userAgent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, userAgent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userIpAddress_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, userIpAddress_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(expectedAction_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, expectedAction_);
    }
    if (!hashedAccountId_.isEmpty()) {
      output.writeBytes(6, hashedAccountId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestedUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, requestedUri_);
    }
    if (wafTokenAssessment_ != false) {
      output.writeBool(9, wafTokenAssessment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ja3_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, ja3_);
    }
    for (int i = 0; i < headers_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, headers_.getRaw(i));
    }
    if (firewallPolicyEvaluation_ != false) {
      output.writeBool(12, firewallPolicyEvaluation_);
    }
    if (transactionData_ != null) {
      output.writeMessage(13, getTransactionData());
    }
    if (express_ != false) {
      output.writeBool(14, express_);
    }
    if (userInfo_ != null) {
      output.writeMessage(15, getUserInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(token_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, token_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(siteKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, siteKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userAgent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, userAgent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userIpAddress_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, userIpAddress_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(expectedAction_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, expectedAction_);
    }
    if (!hashedAccountId_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(6, hashedAccountId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestedUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, requestedUri_);
    }
    if (wafTokenAssessment_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, wafTokenAssessment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ja3_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, ja3_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < headers_.size(); i++) {
        dataSize += computeStringSizeNoTag(headers_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getHeadersList().size();
    }
    if (firewallPolicyEvaluation_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, firewallPolicyEvaluation_);
    }
    if (transactionData_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getTransactionData());
    }
    if (express_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, express_);
    }
    if (userInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getUserInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1.Event)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1.Event other = (com.google.recaptchaenterprise.v1.Event) obj;

    if (!getToken().equals(other.getToken())) return false;
    if (!getSiteKey().equals(other.getSiteKey())) return false;
    if (!getUserAgent().equals(other.getUserAgent())) return false;
    if (!getUserIpAddress().equals(other.getUserIpAddress())) return false;
    if (!getExpectedAction().equals(other.getExpectedAction())) return false;
    if (!getHashedAccountId().equals(other.getHashedAccountId())) return false;
    if (getExpress() != other.getExpress()) return false;
    if (!getRequestedUri().equals(other.getRequestedUri())) return false;
    if (getWafTokenAssessment() != other.getWafTokenAssessment()) return false;
    if (!getJa3().equals(other.getJa3())) return false;
    if (!getHeadersList().equals(other.getHeadersList())) return false;
    if (getFirewallPolicyEvaluation() != other.getFirewallPolicyEvaluation()) return false;
    if (hasTransactionData() != other.hasTransactionData()) return false;
    if (hasTransactionData()) {
      if (!getTransactionData().equals(other.getTransactionData())) return false;
    }
    if (hasUserInfo() != other.hasUserInfo()) return false;
    if (hasUserInfo()) {
      if (!getUserInfo().equals(other.getUserInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getToken().hashCode();
    hash = (37 * hash) + SITE_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getSiteKey().hashCode();
    hash = (37 * hash) + USER_AGENT_FIELD_NUMBER;
    hash = (53 * hash) + getUserAgent().hashCode();
    hash = (37 * hash) + USER_IP_ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getUserIpAddress().hashCode();
    hash = (37 * hash) + EXPECTED_ACTION_FIELD_NUMBER;
    hash = (53 * hash) + getExpectedAction().hashCode();
    hash = (37 * hash) + HASHED_ACCOUNT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getHashedAccountId().hashCode();
    hash = (37 * hash) + EXPRESS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExpress());
    hash = (37 * hash) + REQUESTED_URI_FIELD_NUMBER;
    hash = (53 * hash) + getRequestedUri().hashCode();
    hash = (37 * hash) + WAF_TOKEN_ASSESSMENT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getWafTokenAssessment());
    hash = (37 * hash) + JA3_FIELD_NUMBER;
    hash = (53 * hash) + getJa3().hashCode();
    if (getHeadersCount() > 0) {
      hash = (37 * hash) + HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getHeadersList().hashCode();
    }
    hash = (37 * hash) + FIREWALL_POLICY_EVALUATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getFirewallPolicyEvaluation());
    if (hasTransactionData()) {
      hash = (37 * hash) + TRANSACTION_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getTransactionData().hashCode();
    }
    if (hasUserInfo()) {
      hash = (37 * hash) + USER_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getUserInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1.Event parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Event parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Event parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Event parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Event parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Event parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Event parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Event parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Event parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Event parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Event parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Event parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.recaptchaenterprise.v1.Event prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The event being assessed.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1.Event}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1.Event)
      com.google.recaptchaenterprise.v1.EventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Event_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Event_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1.Event.class,
              com.google.recaptchaenterprise.v1.Event.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1.Event.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      token_ = "";
      siteKey_ = "";
      userAgent_ = "";
      userIpAddress_ = "";
      expectedAction_ = "";
      hashedAccountId_ = com.google.protobuf.ByteString.EMPTY;
      express_ = false;
      requestedUri_ = "";
      wafTokenAssessment_ = false;
      ja3_ = "";
      headers_ = com.google.protobuf.LazyStringArrayList.emptyList();
      firewallPolicyEvaluation_ = false;
      transactionData_ = null;
      if (transactionDataBuilder_ != null) {
        transactionDataBuilder_.dispose();
        transactionDataBuilder_ = null;
      }
      userInfo_ = null;
      if (userInfoBuilder_ != null) {
        userInfoBuilder_.dispose();
        userInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Event_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Event getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1.Event.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Event build() {
      com.google.recaptchaenterprise.v1.Event result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Event buildPartial() {
      com.google.recaptchaenterprise.v1.Event result =
          new com.google.recaptchaenterprise.v1.Event(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1.Event result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.token_ = token_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.siteKey_ = siteKey_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.userAgent_ = userAgent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.userIpAddress_ = userIpAddress_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.expectedAction_ = expectedAction_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.hashedAccountId_ = hashedAccountId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.express_ = express_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.requestedUri_ = requestedUri_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.wafTokenAssessment_ = wafTokenAssessment_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.ja3_ = ja3_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        headers_.makeImmutable();
        result.headers_ = headers_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.firewallPolicyEvaluation_ = firewallPolicyEvaluation_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.transactionData_ =
            transactionDataBuilder_ == null ? transactionData_ : transactionDataBuilder_.build();
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.userInfo_ = userInfoBuilder_ == null ? userInfo_ : userInfoBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1.Event) {
        return mergeFrom((com.google.recaptchaenterprise.v1.Event) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1.Event other) {
      if (other == com.google.recaptchaenterprise.v1.Event.getDefaultInstance()) return this;
      if (!other.getToken().isEmpty()) {
        token_ = other.token_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSiteKey().isEmpty()) {
        siteKey_ = other.siteKey_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUserAgent().isEmpty()) {
        userAgent_ = other.userAgent_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getUserIpAddress().isEmpty()) {
        userIpAddress_ = other.userIpAddress_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getExpectedAction().isEmpty()) {
        expectedAction_ = other.expectedAction_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getHashedAccountId() != com.google.protobuf.ByteString.EMPTY) {
        setHashedAccountId(other.getHashedAccountId());
      }
      if (other.getExpress() != false) {
        setExpress(other.getExpress());
      }
      if (!other.getRequestedUri().isEmpty()) {
        requestedUri_ = other.requestedUri_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.getWafTokenAssessment() != false) {
        setWafTokenAssessment(other.getWafTokenAssessment());
      }
      if (!other.getJa3().isEmpty()) {
        ja3_ = other.ja3_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.headers_.isEmpty()) {
        if (headers_.isEmpty()) {
          headers_ = other.headers_;
          bitField0_ |= 0x00000400;
        } else {
          ensureHeadersIsMutable();
          headers_.addAll(other.headers_);
        }
        onChanged();
      }
      if (other.getFirewallPolicyEvaluation() != false) {
        setFirewallPolicyEvaluation(other.getFirewallPolicyEvaluation());
      }
      if (other.hasTransactionData()) {
        mergeTransactionData(other.getTransactionData());
      }
      if (other.hasUserInfo()) {
        mergeUserInfo(other.getUserInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                token_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                siteKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                userAgent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                userIpAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                expectedAction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                hashedAccountId_ = input.readBytes();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 66:
              {
                requestedUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                wafTokenAssessment_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                ja3_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureHeadersIsMutable();
                headers_.add(s);
                break;
              } // case 90
            case 96:
              {
                firewallPolicyEvaluation_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 96
            case 106:
              {
                input.readMessage(getTransactionDataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 112:
              {
                express_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 112
            case 122:
              {
                input.readMessage(getUserInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object token_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The user response token provided by the reCAPTCHA Enterprise
     * client-side integration on your site.
     * </pre>
     *
     * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The token.
     */
    public java.lang.String getToken() {
      java.lang.Object ref = token_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        token_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The user response token provided by the reCAPTCHA Enterprise
     * client-side integration on your site.
     * </pre>
     *
     * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for token.
     */
    public com.google.protobuf.ByteString getTokenBytes() {
      java.lang.Object ref = token_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        token_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The user response token provided by the reCAPTCHA Enterprise
     * client-side integration on your site.
     * </pre>
     *
     * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The token to set.
     * @return This builder for chaining.
     */
    public Builder setToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      token_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The user response token provided by the reCAPTCHA Enterprise
     * client-side integration on your site.
     * </pre>
     *
     * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearToken() {
      token_ = getDefaultInstance().getToken();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The user response token provided by the reCAPTCHA Enterprise
     * client-side integration on your site.
     * </pre>
     *
     * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for token to set.
     * @return This builder for chaining.
     */
    public Builder setTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      token_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object siteKey_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The site key that was used to invoke reCAPTCHA Enterprise on your
     * site and generate the token.
     * </pre>
     *
     * <code>string site_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The siteKey.
     */
    public java.lang.String getSiteKey() {
      java.lang.Object ref = siteKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        siteKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The site key that was used to invoke reCAPTCHA Enterprise on your
     * site and generate the token.
     * </pre>
     *
     * <code>string site_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for siteKey.
     */
    public com.google.protobuf.ByteString getSiteKeyBytes() {
      java.lang.Object ref = siteKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        siteKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The site key that was used to invoke reCAPTCHA Enterprise on your
     * site and generate the token.
     * </pre>
     *
     * <code>string site_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The siteKey to set.
     * @return This builder for chaining.
     */
    public Builder setSiteKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      siteKey_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The site key that was used to invoke reCAPTCHA Enterprise on your
     * site and generate the token.
     * </pre>
     *
     * <code>string site_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSiteKey() {
      siteKey_ = getDefaultInstance().getSiteKey();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The site key that was used to invoke reCAPTCHA Enterprise on your
     * site and generate the token.
     * </pre>
     *
     * <code>string site_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for siteKey to set.
     * @return This builder for chaining.
     */
    public Builder setSiteKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      siteKey_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object userAgent_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The user agent present in the request from the user's device
     * related to this event.
     * </pre>
     *
     * <code>string user_agent = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The userAgent.
     */
    public java.lang.String getUserAgent() {
      java.lang.Object ref = userAgent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userAgent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The user agent present in the request from the user's device
     * related to this event.
     * </pre>
     *
     * <code>string user_agent = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for userAgent.
     */
    public com.google.protobuf.ByteString getUserAgentBytes() {
      java.lang.Object ref = userAgent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userAgent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The user agent present in the request from the user's device
     * related to this event.
     * </pre>
     *
     * <code>string user_agent = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The userAgent to set.
     * @return This builder for chaining.
     */
    public Builder setUserAgent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userAgent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The user agent present in the request from the user's device
     * related to this event.
     * </pre>
     *
     * <code>string user_agent = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserAgent() {
      userAgent_ = getDefaultInstance().getUserAgent();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The user agent present in the request from the user's device
     * related to this event.
     * </pre>
     *
     * <code>string user_agent = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for userAgent to set.
     * @return This builder for chaining.
     */
    public Builder setUserAgentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userAgent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object userIpAddress_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The IP address in the request from the user's device related to
     * this event.
     * </pre>
     *
     * <code>string user_ip_address = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The userIpAddress.
     */
    public java.lang.String getUserIpAddress() {
      java.lang.Object ref = userIpAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userIpAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP address in the request from the user's device related to
     * this event.
     * </pre>
     *
     * <code>string user_ip_address = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for userIpAddress.
     */
    public com.google.protobuf.ByteString getUserIpAddressBytes() {
      java.lang.Object ref = userIpAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userIpAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP address in the request from the user's device related to
     * this event.
     * </pre>
     *
     * <code>string user_ip_address = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The userIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setUserIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userIpAddress_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP address in the request from the user's device related to
     * this event.
     * </pre>
     *
     * <code>string user_ip_address = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserIpAddress() {
      userIpAddress_ = getDefaultInstance().getUserIpAddress();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP address in the request from the user's device related to
     * this event.
     * </pre>
     *
     * <code>string user_ip_address = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for userIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setUserIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userIpAddress_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object expectedAction_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The expected action for this type of event. This should be the
     * same action provided at token generation time on client-side platforms
     * already integrated with recaptcha enterprise.
     * </pre>
     *
     * <code>string expected_action = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The expectedAction.
     */
    public java.lang.String getExpectedAction() {
      java.lang.Object ref = expectedAction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        expectedAction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The expected action for this type of event. This should be the
     * same action provided at token generation time on client-side platforms
     * already integrated with recaptcha enterprise.
     * </pre>
     *
     * <code>string expected_action = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for expectedAction.
     */
    public com.google.protobuf.ByteString getExpectedActionBytes() {
      java.lang.Object ref = expectedAction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        expectedAction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The expected action for this type of event. This should be the
     * same action provided at token generation time on client-side platforms
     * already integrated with recaptcha enterprise.
     * </pre>
     *
     * <code>string expected_action = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The expectedAction to set.
     * @return This builder for chaining.
     */
    public Builder setExpectedAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      expectedAction_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The expected action for this type of event. This should be the
     * same action provided at token generation time on client-side platforms
     * already integrated with recaptcha enterprise.
     * </pre>
     *
     * <code>string expected_action = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExpectedAction() {
      expectedAction_ = getDefaultInstance().getExpectedAction();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The expected action for this type of event. This should be the
     * same action provided at token generation time on client-side platforms
     * already integrated with recaptcha enterprise.
     * </pre>
     *
     * <code>string expected_action = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for expectedAction to set.
     * @return This builder for chaining.
     */
    public Builder setExpectedActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      expectedAction_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString hashedAccountId_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Optional. Deprecated: use `user_info.account_id` instead.
     * Unique stable hashed user identifier for the request. The identifier must
     * be hashed using hmac-sha256 with stable secret.
     * </pre>
     *
     * <code>
     * bytes hashed_account_id = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.recaptchaenterprise.v1.Event.hashed_account_id is deprecated. See
     *     google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto;l=663
     * @return The hashedAccountId.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getHashedAccountId() {
      return hashedAccountId_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated: use `user_info.account_id` instead.
     * Unique stable hashed user identifier for the request. The identifier must
     * be hashed using hmac-sha256 with stable secret.
     * </pre>
     *
     * <code>
     * bytes hashed_account_id = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.recaptchaenterprise.v1.Event.hashed_account_id is deprecated. See
     *     google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto;l=663
     * @param value The hashedAccountId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setHashedAccountId(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      hashedAccountId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated: use `user_info.account_id` instead.
     * Unique stable hashed user identifier for the request. The identifier must
     * be hashed using hmac-sha256 with stable secret.
     * </pre>
     *
     * <code>
     * bytes hashed_account_id = 6 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.recaptchaenterprise.v1.Event.hashed_account_id is deprecated. See
     *     google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto;l=663
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearHashedAccountId() {
      bitField0_ = (bitField0_ & ~0x00000020);
      hashedAccountId_ = getDefaultInstance().getHashedAccountId();
      onChanged();
      return this;
    }

    private boolean express_;
    /**
     *
     *
     * <pre>
     * Optional. Flag for a reCAPTCHA express request for an assessment without a
     * token. If enabled, `site_key` must reference a SCORE key with WAF feature
     * set to EXPRESS.
     * </pre>
     *
     * <code>bool express = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The express.
     */
    @java.lang.Override
    public boolean getExpress() {
      return express_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Flag for a reCAPTCHA express request for an assessment without a
     * token. If enabled, `site_key` must reference a SCORE key with WAF feature
     * set to EXPRESS.
     * </pre>
     *
     * <code>bool express = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The express to set.
     * @return This builder for chaining.
     */
    public Builder setExpress(boolean value) {

      express_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Flag for a reCAPTCHA express request for an assessment without a
     * token. If enabled, `site_key` must reference a SCORE key with WAF feature
     * set to EXPRESS.
     * </pre>
     *
     * <code>bool express = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExpress() {
      bitField0_ = (bitField0_ & ~0x00000040);
      express_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object requestedUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The URI resource the user requested that triggered an assessment.
     * </pre>
     *
     * <code>string requested_uri = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestedUri.
     */
    public java.lang.String getRequestedUri() {
      java.lang.Object ref = requestedUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestedUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The URI resource the user requested that triggered an assessment.
     * </pre>
     *
     * <code>string requested_uri = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestedUri.
     */
    public com.google.protobuf.ByteString getRequestedUriBytes() {
      java.lang.Object ref = requestedUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestedUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The URI resource the user requested that triggered an assessment.
     * </pre>
     *
     * <code>string requested_uri = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestedUri to set.
     * @return This builder for chaining.
     */
    public Builder setRequestedUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestedUri_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The URI resource the user requested that triggered an assessment.
     * </pre>
     *
     * <code>string requested_uri = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestedUri() {
      requestedUri_ = getDefaultInstance().getRequestedUri();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The URI resource the user requested that triggered an assessment.
     * </pre>
     *
     * <code>string requested_uri = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestedUri to set.
     * @return This builder for chaining.
     */
    public Builder setRequestedUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestedUri_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private boolean wafTokenAssessment_;
    /**
     *
     *
     * <pre>
     * Optional. Flag for running WAF token assessment.
     * If enabled, the token must be specified, and have been created by a
     * WAF-enabled key.
     * </pre>
     *
     * <code>bool waf_token_assessment = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The wafTokenAssessment.
     */
    @java.lang.Override
    public boolean getWafTokenAssessment() {
      return wafTokenAssessment_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Flag for running WAF token assessment.
     * If enabled, the token must be specified, and have been created by a
     * WAF-enabled key.
     * </pre>
     *
     * <code>bool waf_token_assessment = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The wafTokenAssessment to set.
     * @return This builder for chaining.
     */
    public Builder setWafTokenAssessment(boolean value) {

      wafTokenAssessment_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Flag for running WAF token assessment.
     * If enabled, the token must be specified, and have been created by a
     * WAF-enabled key.
     * </pre>
     *
     * <code>bool waf_token_assessment = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWafTokenAssessment() {
      bitField0_ = (bitField0_ & ~0x00000100);
      wafTokenAssessment_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object ja3_ = "";
    /**
     *
     *
     * <pre>
     * Optional. JA3 fingerprint for SSL clients.
     * </pre>
     *
     * <code>string ja3 = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The ja3.
     */
    public java.lang.String getJa3() {
      java.lang.Object ref = ja3_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ja3_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. JA3 fingerprint for SSL clients.
     * </pre>
     *
     * <code>string ja3 = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for ja3.
     */
    public com.google.protobuf.ByteString getJa3Bytes() {
      java.lang.Object ref = ja3_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ja3_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. JA3 fingerprint for SSL clients.
     * </pre>
     *
     * <code>string ja3 = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The ja3 to set.
     * @return This builder for chaining.
     */
    public Builder setJa3(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ja3_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. JA3 fingerprint for SSL clients.
     * </pre>
     *
     * <code>string ja3 = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJa3() {
      ja3_ = getDefaultInstance().getJa3();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. JA3 fingerprint for SSL clients.
     * </pre>
     *
     * <code>string ja3 = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for ja3 to set.
     * @return This builder for chaining.
     */
    public Builder setJa3Bytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ja3_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList headers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureHeadersIsMutable() {
      if (!headers_.isModifiable()) {
        headers_ = new com.google.protobuf.LazyStringArrayList(headers_);
      }
      bitField0_ |= 0x00000400;
    }
    /**
     *
     *
     * <pre>
     * Optional. HTTP header information about the request.
     * </pre>
     *
     * <code>repeated string headers = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the headers.
     */
    public com.google.protobuf.ProtocolStringList getHeadersList() {
      headers_.makeImmutable();
      return headers_;
    }
    /**
     *
     *
     * <pre>
     * Optional. HTTP header information about the request.
     * </pre>
     *
     * <code>repeated string headers = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of headers.
     */
    public int getHeadersCount() {
      return headers_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. HTTP header information about the request.
     * </pre>
     *
     * <code>repeated string headers = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The headers at the given index.
     */
    public java.lang.String getHeaders(int index) {
      return headers_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HTTP header information about the request.
     * </pre>
     *
     * <code>repeated string headers = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the headers at the given index.
     */
    public com.google.protobuf.ByteString getHeadersBytes(int index) {
      return headers_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HTTP header information about the request.
     * </pre>
     *
     * <code>repeated string headers = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The headers to set.
     * @return This builder for chaining.
     */
    public Builder setHeaders(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureHeadersIsMutable();
      headers_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HTTP header information about the request.
     * </pre>
     *
     * <code>repeated string headers = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The headers to add.
     * @return This builder for chaining.
     */
    public Builder addHeaders(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureHeadersIsMutable();
      headers_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HTTP header information about the request.
     * </pre>
     *
     * <code>repeated string headers = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The headers to add.
     * @return This builder for chaining.
     */
    public Builder addAllHeaders(java.lang.Iterable<java.lang.String> values) {
      ensureHeadersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, headers_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HTTP header information about the request.
     * </pre>
     *
     * <code>repeated string headers = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHeaders() {
      headers_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HTTP header information about the request.
     * </pre>
     *
     * <code>repeated string headers = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the headers to add.
     * @return This builder for chaining.
     */
    public Builder addHeadersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureHeadersIsMutable();
      headers_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private boolean firewallPolicyEvaluation_;
    /**
     *
     *
     * <pre>
     * Optional. Flag for enabling firewall policy config assessment.
     * If this flag is enabled, the firewall policy will be evaluated and a
     * suggested firewall action will be returned in the response.
     * </pre>
     *
     * <code>bool firewall_policy_evaluation = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The firewallPolicyEvaluation.
     */
    @java.lang.Override
    public boolean getFirewallPolicyEvaluation() {
      return firewallPolicyEvaluation_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Flag for enabling firewall policy config assessment.
     * If this flag is enabled, the firewall policy will be evaluated and a
     * suggested firewall action will be returned in the response.
     * </pre>
     *
     * <code>bool firewall_policy_evaluation = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The firewallPolicyEvaluation to set.
     * @return This builder for chaining.
     */
    public Builder setFirewallPolicyEvaluation(boolean value) {

      firewallPolicyEvaluation_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Flag for enabling firewall policy config assessment.
     * If this flag is enabled, the firewall policy will be evaluated and a
     * suggested firewall action will be returned in the response.
     * </pre>
     *
     * <code>bool firewall_policy_evaluation = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFirewallPolicyEvaluation() {
      bitField0_ = (bitField0_ & ~0x00000800);
      firewallPolicyEvaluation_ = false;
      onChanged();
      return this;
    }

    private com.google.recaptchaenterprise.v1.TransactionData transactionData_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.TransactionData,
            com.google.recaptchaenterprise.v1.TransactionData.Builder,
            com.google.recaptchaenterprise.v1.TransactionDataOrBuilder>
        transactionDataBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Data describing a payment transaction to be assessed. Sending
     * this data enables reCAPTCHA Enterprise Fraud Prevention and the
     * FraudPreventionAssessment component in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TransactionData transaction_data = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the transactionData field is set.
     */
    public boolean hasTransactionData() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Data describing a payment transaction to be assessed. Sending
     * this data enables reCAPTCHA Enterprise Fraud Prevention and the
     * FraudPreventionAssessment component in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TransactionData transaction_data = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The transactionData.
     */
    public com.google.recaptchaenterprise.v1.TransactionData getTransactionData() {
      if (transactionDataBuilder_ == null) {
        return transactionData_ == null
            ? com.google.recaptchaenterprise.v1.TransactionData.getDefaultInstance()
            : transactionData_;
      } else {
        return transactionDataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Data describing a payment transaction to be assessed. Sending
     * this data enables reCAPTCHA Enterprise Fraud Prevention and the
     * FraudPreventionAssessment component in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TransactionData transaction_data = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTransactionData(com.google.recaptchaenterprise.v1.TransactionData value) {
      if (transactionDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transactionData_ = value;
      } else {
        transactionDataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data describing a payment transaction to be assessed. Sending
     * this data enables reCAPTCHA Enterprise Fraud Prevention and the
     * FraudPreventionAssessment component in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TransactionData transaction_data = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTransactionData(
        com.google.recaptchaenterprise.v1.TransactionData.Builder builderForValue) {
      if (transactionDataBuilder_ == null) {
        transactionData_ = builderForValue.build();
      } else {
        transactionDataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data describing a payment transaction to be assessed. Sending
     * this data enables reCAPTCHA Enterprise Fraud Prevention and the
     * FraudPreventionAssessment component in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TransactionData transaction_data = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTransactionData(com.google.recaptchaenterprise.v1.TransactionData value) {
      if (transactionDataBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && transactionData_ != null
            && transactionData_
                != com.google.recaptchaenterprise.v1.TransactionData.getDefaultInstance()) {
          getTransactionDataBuilder().mergeFrom(value);
        } else {
          transactionData_ = value;
        }
      } else {
        transactionDataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data describing a payment transaction to be assessed. Sending
     * this data enables reCAPTCHA Enterprise Fraud Prevention and the
     * FraudPreventionAssessment component in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TransactionData transaction_data = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTransactionData() {
      bitField0_ = (bitField0_ & ~0x00001000);
      transactionData_ = null;
      if (transactionDataBuilder_ != null) {
        transactionDataBuilder_.dispose();
        transactionDataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data describing a payment transaction to be assessed. Sending
     * this data enables reCAPTCHA Enterprise Fraud Prevention and the
     * FraudPreventionAssessment component in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TransactionData transaction_data = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.TransactionData.Builder getTransactionDataBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getTransactionDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Data describing a payment transaction to be assessed. Sending
     * this data enables reCAPTCHA Enterprise Fraud Prevention and the
     * FraudPreventionAssessment component in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TransactionData transaction_data = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.TransactionDataOrBuilder
        getTransactionDataOrBuilder() {
      if (transactionDataBuilder_ != null) {
        return transactionDataBuilder_.getMessageOrBuilder();
      } else {
        return transactionData_ == null
            ? com.google.recaptchaenterprise.v1.TransactionData.getDefaultInstance()
            : transactionData_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Data describing a payment transaction to be assessed. Sending
     * this data enables reCAPTCHA Enterprise Fraud Prevention and the
     * FraudPreventionAssessment component in the response.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TransactionData transaction_data = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.TransactionData,
            com.google.recaptchaenterprise.v1.TransactionData.Builder,
            com.google.recaptchaenterprise.v1.TransactionDataOrBuilder>
        getTransactionDataFieldBuilder() {
      if (transactionDataBuilder_ == null) {
        transactionDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.TransactionData,
                com.google.recaptchaenterprise.v1.TransactionData.Builder,
                com.google.recaptchaenterprise.v1.TransactionDataOrBuilder>(
                getTransactionData(), getParentForChildren(), isClean());
        transactionData_ = null;
      }
      return transactionDataBuilder_;
    }

    private com.google.recaptchaenterprise.v1.UserInfo userInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.UserInfo,
            com.google.recaptchaenterprise.v1.UserInfo.Builder,
            com.google.recaptchaenterprise.v1.UserInfoOrBuilder>
        userInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Information about the user that generates this event, when they
     * can be identified. They are often identified through the use of an account
     * for logged-in requests or login/registration requests, or by providing user
     * identifiers for guest actions like checkout.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.UserInfo user_info = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the userInfo field is set.
     */
    public boolean hasUserInfo() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the user that generates this event, when they
     * can be identified. They are often identified through the use of an account
     * for logged-in requests or login/registration requests, or by providing user
     * identifiers for guest actions like checkout.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.UserInfo user_info = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The userInfo.
     */
    public com.google.recaptchaenterprise.v1.UserInfo getUserInfo() {
      if (userInfoBuilder_ == null) {
        return userInfo_ == null
            ? com.google.recaptchaenterprise.v1.UserInfo.getDefaultInstance()
            : userInfo_;
      } else {
        return userInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the user that generates this event, when they
     * can be identified. They are often identified through the use of an account
     * for logged-in requests or login/registration requests, or by providing user
     * identifiers for guest actions like checkout.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.UserInfo user_info = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUserInfo(com.google.recaptchaenterprise.v1.UserInfo value) {
      if (userInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userInfo_ = value;
      } else {
        userInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the user that generates this event, when they
     * can be identified. They are often identified through the use of an account
     * for logged-in requests or login/registration requests, or by providing user
     * identifiers for guest actions like checkout.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.UserInfo user_info = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUserInfo(com.google.recaptchaenterprise.v1.UserInfo.Builder builderForValue) {
      if (userInfoBuilder_ == null) {
        userInfo_ = builderForValue.build();
      } else {
        userInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the user that generates this event, when they
     * can be identified. They are often identified through the use of an account
     * for logged-in requests or login/registration requests, or by providing user
     * identifiers for guest actions like checkout.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.UserInfo user_info = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeUserInfo(com.google.recaptchaenterprise.v1.UserInfo value) {
      if (userInfoBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && userInfo_ != null
            && userInfo_ != com.google.recaptchaenterprise.v1.UserInfo.getDefaultInstance()) {
          getUserInfoBuilder().mergeFrom(value);
        } else {
          userInfo_ = value;
        }
      } else {
        userInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the user that generates this event, when they
     * can be identified. They are often identified through the use of an account
     * for logged-in requests or login/registration requests, or by providing user
     * identifiers for guest actions like checkout.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.UserInfo user_info = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearUserInfo() {
      bitField0_ = (bitField0_ & ~0x00002000);
      userInfo_ = null;
      if (userInfoBuilder_ != null) {
        userInfoBuilder_.dispose();
        userInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the user that generates this event, when they
     * can be identified. They are often identified through the use of an account
     * for logged-in requests or login/registration requests, or by providing user
     * identifiers for guest actions like checkout.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.UserInfo user_info = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.UserInfo.Builder getUserInfoBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getUserInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the user that generates this event, when they
     * can be identified. They are often identified through the use of an account
     * for logged-in requests or login/registration requests, or by providing user
     * identifiers for guest actions like checkout.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.UserInfo user_info = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.UserInfoOrBuilder getUserInfoOrBuilder() {
      if (userInfoBuilder_ != null) {
        return userInfoBuilder_.getMessageOrBuilder();
      } else {
        return userInfo_ == null
            ? com.google.recaptchaenterprise.v1.UserInfo.getDefaultInstance()
            : userInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the user that generates this event, when they
     * can be identified. They are often identified through the use of an account
     * for logged-in requests or login/registration requests, or by providing user
     * identifiers for guest actions like checkout.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.UserInfo user_info = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.UserInfo,
            com.google.recaptchaenterprise.v1.UserInfo.Builder,
            com.google.recaptchaenterprise.v1.UserInfoOrBuilder>
        getUserInfoFieldBuilder() {
      if (userInfoBuilder_ == null) {
        userInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.UserInfo,
                com.google.recaptchaenterprise.v1.UserInfo.Builder,
                com.google.recaptchaenterprise.v1.UserInfoOrBuilder>(
                getUserInfo(), getParentForChildren(), isClean());
        userInfo_ = null;
      }
      return userInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1.Event)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1.Event)
  private static final com.google.recaptchaenterprise.v1.Event DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1.Event();
  }

  public static com.google.recaptchaenterprise.v1.Event getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Event> PARSER =
      new com.google.protobuf.AbstractParser<Event>() {
        @java.lang.Override
        public Event parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Event> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Event> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1.Event getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
