/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

package com.google.recaptchaenterprise.v1;

/**
 *
 *
 * <pre>
 * A FirewallPolicy represents a single matching pattern and resulting actions
 * to take.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1.FirewallPolicy}
 */
public final class FirewallPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1.FirewallPolicy)
    FirewallPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FirewallPolicy.newBuilder() to construct.
  private FirewallPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FirewallPolicy() {
    name_ = "";
    description_ = "";
    path_ = "";
    condition_ = "";
    actions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FirewallPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_FirewallPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_FirewallPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1.FirewallPolicy.class,
            com.google.recaptchaenterprise.v1.FirewallPolicy.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name for the FirewallPolicy in the format
   * `projects/{project}/firewallpolicies/{firewallpolicy}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name for the FirewallPolicy in the format
   * `projects/{project}/firewallpolicies/{firewallpolicy}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A description of what this policy aims to achieve, for
   * convenience purposes. The description can at most include 256 UTF-8
   * characters.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A description of what this policy aims to achieve, for
   * convenience purposes. The description can at most include 256 UTF-8
   * characters.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PATH_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object path_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The path for which this policy applies, specified as a glob
   * pattern. For more information on glob, see the [manual
   * page](https://man7.org/linux/man-pages/man7/glob.7.html).
   * A path has a max length of 200 characters.
   * </pre>
   *
   * <code>string path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The path.
   */
  @java.lang.Override
  public java.lang.String getPath() {
    java.lang.Object ref = path_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      path_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The path for which this policy applies, specified as a glob
   * pattern. For more information on glob, see the [manual
   * page](https://man7.org/linux/man-pages/man7/glob.7.html).
   * A path has a max length of 200 characters.
   * </pre>
   *
   * <code>string path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for path.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPathBytes() {
    java.lang.Object ref = path_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      path_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONDITION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object condition_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A CEL (Common Expression Language) conditional expression that
   * specifies if this policy applies to an incoming user request. If this
   * condition evaluates to true and the requested path matched the path
   * pattern, the associated actions should be executed by the caller. The
   * condition string is checked for CEL syntax correctness on creation. For
   * more information, see the [CEL spec](https://github.com/google/cel-spec)
   * and its [language
   * definition](https://github.com/google/cel-spec/blob/master/doc/langdef.md).
   * A condition has a max length of 500 characters.
   * </pre>
   *
   * <code>string condition = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The condition.
   */
  @java.lang.Override
  public java.lang.String getCondition() {
    java.lang.Object ref = condition_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      condition_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A CEL (Common Expression Language) conditional expression that
   * specifies if this policy applies to an incoming user request. If this
   * condition evaluates to true and the requested path matched the path
   * pattern, the associated actions should be executed by the caller. The
   * condition string is checked for CEL syntax correctness on creation. For
   * more information, see the [CEL spec](https://github.com/google/cel-spec)
   * and its [language
   * definition](https://github.com/google/cel-spec/blob/master/doc/langdef.md).
   * A condition has a max length of 500 characters.
   * </pre>
   *
   * <code>string condition = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for condition.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConditionBytes() {
    java.lang.Object ref = condition_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      condition_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACTIONS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.recaptchaenterprise.v1.FirewallAction> actions_;
  /**
   *
   *
   * <pre>
   * Optional. The actions that the caller should take regarding user access.
   * There should be at most one terminal action. A terminal action is any
   * action that forces a response, such as `AllowAction`,
   * `BlockAction` or `SubstituteAction`.
   * Zero or more non-terminal actions such as `SetHeader` might be
   * specified. A single policy can contain up to 16 actions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.recaptchaenterprise.v1.FirewallAction> getActionsList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The actions that the caller should take regarding user access.
   * There should be at most one terminal action. A terminal action is any
   * action that forces a response, such as `AllowAction`,
   * `BlockAction` or `SubstituteAction`.
   * Zero or more non-terminal actions such as `SetHeader` might be
   * specified. A single policy can contain up to 16 actions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.recaptchaenterprise.v1.FirewallActionOrBuilder>
      getActionsOrBuilderList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The actions that the caller should take regarding user access.
   * There should be at most one terminal action. A terminal action is any
   * action that forces a response, such as `AllowAction`,
   * `BlockAction` or `SubstituteAction`.
   * Zero or more non-terminal actions such as `SetHeader` might be
   * specified. A single policy can contain up to 16 actions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getActionsCount() {
    return actions_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The actions that the caller should take regarding user access.
   * There should be at most one terminal action. A terminal action is any
   * action that forces a response, such as `AllowAction`,
   * `BlockAction` or `SubstituteAction`.
   * Zero or more non-terminal actions such as `SetHeader` might be
   * specified. A single policy can contain up to 16 actions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FirewallAction getActions(int index) {
    return actions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The actions that the caller should take regarding user access.
   * There should be at most one terminal action. A terminal action is any
   * action that forces a response, such as `AllowAction`,
   * `BlockAction` or `SubstituteAction`.
   * Zero or more non-terminal actions such as `SetHeader` might be
   * specified. A single policy can contain up to 16 actions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FirewallActionOrBuilder getActionsOrBuilder(int index) {
    return actions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, path_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, condition_);
    }
    for (int i = 0; i < actions_.size(); i++) {
      output.writeMessage(6, actions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, path_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, condition_);
    }
    for (int i = 0; i < actions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, actions_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1.FirewallPolicy)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1.FirewallPolicy other =
        (com.google.recaptchaenterprise.v1.FirewallPolicy) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getPath().equals(other.getPath())) return false;
    if (!getCondition().equals(other.getCondition())) return false;
    if (!getActionsList().equals(other.getActionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + PATH_FIELD_NUMBER;
    hash = (53 * hash) + getPath().hashCode();
    hash = (37 * hash) + CONDITION_FIELD_NUMBER;
    hash = (53 * hash) + getCondition().hashCode();
    if (getActionsCount() > 0) {
      hash = (37 * hash) + ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getActionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1.FirewallPolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.FirewallPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.FirewallPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.FirewallPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.FirewallPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.FirewallPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.FirewallPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.FirewallPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.FirewallPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.FirewallPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.FirewallPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.FirewallPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.recaptchaenterprise.v1.FirewallPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A FirewallPolicy represents a single matching pattern and resulting actions
   * to take.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1.FirewallPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1.FirewallPolicy)
      com.google.recaptchaenterprise.v1.FirewallPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_FirewallPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_FirewallPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1.FirewallPolicy.class,
              com.google.recaptchaenterprise.v1.FirewallPolicy.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1.FirewallPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      path_ = "";
      condition_ = "";
      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
      } else {
        actions_ = null;
        actionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_FirewallPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.FirewallPolicy getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1.FirewallPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.FirewallPolicy build() {
      com.google.recaptchaenterprise.v1.FirewallPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.FirewallPolicy buildPartial() {
      com.google.recaptchaenterprise.v1.FirewallPolicy result =
          new com.google.recaptchaenterprise.v1.FirewallPolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.recaptchaenterprise.v1.FirewallPolicy result) {
      if (actionsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          actions_ = java.util.Collections.unmodifiableList(actions_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.actions_ = actions_;
      } else {
        result.actions_ = actionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1.FirewallPolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.path_ = path_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.condition_ = condition_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1.FirewallPolicy) {
        return mergeFrom((com.google.recaptchaenterprise.v1.FirewallPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1.FirewallPolicy other) {
      if (other == com.google.recaptchaenterprise.v1.FirewallPolicy.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getPath().isEmpty()) {
        path_ = other.path_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getCondition().isEmpty()) {
        condition_ = other.condition_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (actionsBuilder_ == null) {
        if (!other.actions_.isEmpty()) {
          if (actions_.isEmpty()) {
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureActionsIsMutable();
            actions_.addAll(other.actions_);
          }
          onChanged();
        }
      } else {
        if (!other.actions_.isEmpty()) {
          if (actionsBuilder_.isEmpty()) {
            actionsBuilder_.dispose();
            actionsBuilder_ = null;
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000010);
            actionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getActionsFieldBuilder()
                    : null;
          } else {
            actionsBuilder_.addAllMessages(other.actions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                path_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                condition_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                com.google.recaptchaenterprise.v1.FirewallAction m =
                    input.readMessage(
                        com.google.recaptchaenterprise.v1.FirewallAction.parser(),
                        extensionRegistry);
                if (actionsBuilder_ == null) {
                  ensureActionsIsMutable();
                  actions_.add(m);
                } else {
                  actionsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name for the FirewallPolicy in the format
     * `projects/{project}/firewallpolicies/{firewallpolicy}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name for the FirewallPolicy in the format
     * `projects/{project}/firewallpolicies/{firewallpolicy}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name for the FirewallPolicy in the format
     * `projects/{project}/firewallpolicies/{firewallpolicy}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name for the FirewallPolicy in the format
     * `projects/{project}/firewallpolicies/{firewallpolicy}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name for the FirewallPolicy in the format
     * `projects/{project}/firewallpolicies/{firewallpolicy}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A description of what this policy aims to achieve, for
     * convenience purposes. The description can at most include 256 UTF-8
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of what this policy aims to achieve, for
     * convenience purposes. The description can at most include 256 UTF-8
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of what this policy aims to achieve, for
     * convenience purposes. The description can at most include 256 UTF-8
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of what this policy aims to achieve, for
     * convenience purposes. The description can at most include 256 UTF-8
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of what this policy aims to achieve, for
     * convenience purposes. The description can at most include 256 UTF-8
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object path_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The path for which this policy applies, specified as a glob
     * pattern. For more information on glob, see the [manual
     * page](https://man7.org/linux/man-pages/man7/glob.7.html).
     * A path has a max length of 200 characters.
     * </pre>
     *
     * <code>string path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The path.
     */
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The path for which this policy applies, specified as a glob
     * pattern. For more information on glob, see the [manual
     * page](https://man7.org/linux/man-pages/man7/glob.7.html).
     * A path has a max length of 200 characters.
     * </pre>
     *
     * <code>string path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for path.
     */
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The path for which this policy applies, specified as a glob
     * pattern. For more information on glob, see the [manual
     * page](https://man7.org/linux/man-pages/man7/glob.7.html).
     * A path has a max length of 200 characters.
     * </pre>
     *
     * <code>string path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The path to set.
     * @return This builder for chaining.
     */
    public Builder setPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      path_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The path for which this policy applies, specified as a glob
     * pattern. For more information on glob, see the [manual
     * page](https://man7.org/linux/man-pages/man7/glob.7.html).
     * A path has a max length of 200 characters.
     * </pre>
     *
     * <code>string path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPath() {
      path_ = getDefaultInstance().getPath();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The path for which this policy applies, specified as a glob
     * pattern. For more information on glob, see the [manual
     * page](https://man7.org/linux/man-pages/man7/glob.7.html).
     * A path has a max length of 200 characters.
     * </pre>
     *
     * <code>string path = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for path to set.
     * @return This builder for chaining.
     */
    public Builder setPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      path_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object condition_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A CEL (Common Expression Language) conditional expression that
     * specifies if this policy applies to an incoming user request. If this
     * condition evaluates to true and the requested path matched the path
     * pattern, the associated actions should be executed by the caller. The
     * condition string is checked for CEL syntax correctness on creation. For
     * more information, see the [CEL spec](https://github.com/google/cel-spec)
     * and its [language
     * definition](https://github.com/google/cel-spec/blob/master/doc/langdef.md).
     * A condition has a max length of 500 characters.
     * </pre>
     *
     * <code>string condition = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The condition.
     */
    public java.lang.String getCondition() {
      java.lang.Object ref = condition_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        condition_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A CEL (Common Expression Language) conditional expression that
     * specifies if this policy applies to an incoming user request. If this
     * condition evaluates to true and the requested path matched the path
     * pattern, the associated actions should be executed by the caller. The
     * condition string is checked for CEL syntax correctness on creation. For
     * more information, see the [CEL spec](https://github.com/google/cel-spec)
     * and its [language
     * definition](https://github.com/google/cel-spec/blob/master/doc/langdef.md).
     * A condition has a max length of 500 characters.
     * </pre>
     *
     * <code>string condition = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for condition.
     */
    public com.google.protobuf.ByteString getConditionBytes() {
      java.lang.Object ref = condition_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        condition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A CEL (Common Expression Language) conditional expression that
     * specifies if this policy applies to an incoming user request. If this
     * condition evaluates to true and the requested path matched the path
     * pattern, the associated actions should be executed by the caller. The
     * condition string is checked for CEL syntax correctness on creation. For
     * more information, see the [CEL spec](https://github.com/google/cel-spec)
     * and its [language
     * definition](https://github.com/google/cel-spec/blob/master/doc/langdef.md).
     * A condition has a max length of 500 characters.
     * </pre>
     *
     * <code>string condition = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The condition to set.
     * @return This builder for chaining.
     */
    public Builder setCondition(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      condition_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A CEL (Common Expression Language) conditional expression that
     * specifies if this policy applies to an incoming user request. If this
     * condition evaluates to true and the requested path matched the path
     * pattern, the associated actions should be executed by the caller. The
     * condition string is checked for CEL syntax correctness on creation. For
     * more information, see the [CEL spec](https://github.com/google/cel-spec)
     * and its [language
     * definition](https://github.com/google/cel-spec/blob/master/doc/langdef.md).
     * A condition has a max length of 500 characters.
     * </pre>
     *
     * <code>string condition = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCondition() {
      condition_ = getDefaultInstance().getCondition();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A CEL (Common Expression Language) conditional expression that
     * specifies if this policy applies to an incoming user request. If this
     * condition evaluates to true and the requested path matched the path
     * pattern, the associated actions should be executed by the caller. The
     * condition string is checked for CEL syntax correctness on creation. For
     * more information, see the [CEL spec](https://github.com/google/cel-spec)
     * and its [language
     * definition](https://github.com/google/cel-spec/blob/master/doc/langdef.md).
     * A condition has a max length of 500 characters.
     * </pre>
     *
     * <code>string condition = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for condition to set.
     * @return This builder for chaining.
     */
    public Builder setConditionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      condition_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.recaptchaenterprise.v1.FirewallAction> actions_ =
        java.util.Collections.emptyList();

    private void ensureActionsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        actions_ =
            new java.util.ArrayList<com.google.recaptchaenterprise.v1.FirewallAction>(actions_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1.FirewallAction,
            com.google.recaptchaenterprise.v1.FirewallAction.Builder,
            com.google.recaptchaenterprise.v1.FirewallActionOrBuilder>
        actionsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1.FirewallAction> getActionsList() {
      if (actionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(actions_);
      } else {
        return actionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getActionsCount() {
      if (actionsBuilder_ == null) {
        return actions_.size();
      } else {
        return actionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FirewallAction getActions(int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setActions(int index, com.google.recaptchaenterprise.v1.FirewallAction value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.set(index, value);
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setActions(
        int index, com.google.recaptchaenterprise.v1.FirewallAction.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.set(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addActions(com.google.recaptchaenterprise.v1.FirewallAction value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addActions(int index, com.google.recaptchaenterprise.v1.FirewallAction value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(index, value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addActions(
        com.google.recaptchaenterprise.v1.FirewallAction.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addActions(
        int index, com.google.recaptchaenterprise.v1.FirewallAction.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllActions(
        java.lang.Iterable<? extends com.google.recaptchaenterprise.v1.FirewallAction> values) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, actions_);
        onChanged();
      } else {
        actionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearActions() {
      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        actionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeActions(int index) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.remove(index);
        onChanged();
      } else {
        actionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FirewallAction.Builder getActionsBuilder(int index) {
      return getActionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FirewallActionOrBuilder getActionsOrBuilder(
        int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.recaptchaenterprise.v1.FirewallActionOrBuilder>
        getActionsOrBuilderList() {
      if (actionsBuilder_ != null) {
        return actionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(actions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FirewallAction.Builder addActionsBuilder() {
      return getActionsFieldBuilder()
          .addBuilder(com.google.recaptchaenterprise.v1.FirewallAction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FirewallAction.Builder addActionsBuilder(int index) {
      return getActionsFieldBuilder()
          .addBuilder(index, com.google.recaptchaenterprise.v1.FirewallAction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The actions that the caller should take regarding user access.
     * There should be at most one terminal action. A terminal action is any
     * action that forces a response, such as `AllowAction`,
     * `BlockAction` or `SubstituteAction`.
     * Zero or more non-terminal actions such as `SetHeader` might be
     * specified. A single policy can contain up to 16 actions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FirewallAction actions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1.FirewallAction.Builder>
        getActionsBuilderList() {
      return getActionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1.FirewallAction,
            com.google.recaptchaenterprise.v1.FirewallAction.Builder,
            com.google.recaptchaenterprise.v1.FirewallActionOrBuilder>
        getActionsFieldBuilder() {
      if (actionsBuilder_ == null) {
        actionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.recaptchaenterprise.v1.FirewallAction,
                com.google.recaptchaenterprise.v1.FirewallAction.Builder,
                com.google.recaptchaenterprise.v1.FirewallActionOrBuilder>(
                actions_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        actions_ = null;
      }
      return actionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1.FirewallPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1.FirewallPolicy)
  private static final com.google.recaptchaenterprise.v1.FirewallPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1.FirewallPolicy();
  }

  public static com.google.recaptchaenterprise.v1.FirewallPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FirewallPolicy> PARSER =
      new com.google.protobuf.AbstractParser<FirewallPolicy>() {
        @java.lang.Override
        public FirewallPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FirewallPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FirewallPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FirewallPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
