/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.recaptchaenterprise.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
@Generated("by gapic-generator-java")
public class FirewallPolicyName implements ResourceName {
  private static final PathTemplate PROJECT_FIREWALLPOLICY =
      PathTemplate.createWithoutUrlEncoding("projects/{project}/firewallpolicies/{firewallpolicy}");
  private volatile Map<String, String> fieldValuesMap;
  private final String project;
  private final String firewallpolicy;

  @Deprecated
  protected FirewallPolicyName() {
    project = null;
    firewallpolicy = null;
  }

  private FirewallPolicyName(Builder builder) {
    project = Preconditions.checkNotNull(builder.getProject());
    firewallpolicy = Preconditions.checkNotNull(builder.getFirewallpolicy());
  }

  public String getProject() {
    return project;
  }

  public String getFirewallpolicy() {
    return firewallpolicy;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public Builder toBuilder() {
    return new Builder(this);
  }

  public static FirewallPolicyName of(String project, String firewallpolicy) {
    return newBuilder().setProject(project).setFirewallpolicy(firewallpolicy).build();
  }

  public static String format(String project, String firewallpolicy) {
    return newBuilder().setProject(project).setFirewallpolicy(firewallpolicy).build().toString();
  }

  public static FirewallPolicyName parse(String formattedString) {
    if (formattedString.isEmpty()) {
      return null;
    }
    Map<String, String> matchMap =
        PROJECT_FIREWALLPOLICY.validatedMatch(
            formattedString, "FirewallPolicyName.parse: formattedString not in valid format");
    return of(matchMap.get("project"), matchMap.get("firewallpolicy"));
  }

  public static List<FirewallPolicyName> parseList(List<String> formattedStrings) {
    List<FirewallPolicyName> list = new ArrayList<>(formattedStrings.size());
    for (String formattedString : formattedStrings) {
      list.add(parse(formattedString));
    }
    return list;
  }

  public static List<String> toStringList(List<FirewallPolicyName> values) {
    List<String> list = new ArrayList<>(values.size());
    for (FirewallPolicyName value : values) {
      if (value == null) {
        list.add("");
      } else {
        list.add(value.toString());
      }
    }
    return list;
  }

  public static boolean isParsableFrom(String formattedString) {
    return PROJECT_FIREWALLPOLICY.matches(formattedString);
  }

  @Override
  public Map<String, String> getFieldValuesMap() {
    if (fieldValuesMap == null) {
      synchronized (this) {
        if (fieldValuesMap == null) {
          ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
          if (project != null) {
            fieldMapBuilder.put("project", project);
          }
          if (firewallpolicy != null) {
            fieldMapBuilder.put("firewallpolicy", firewallpolicy);
          }
          fieldValuesMap = fieldMapBuilder.build();
        }
      }
    }
    return fieldValuesMap;
  }

  public String getFieldValue(String fieldName) {
    return getFieldValuesMap().get(fieldName);
  }

  @Override
  public String toString() {
    return PROJECT_FIREWALLPOLICY.instantiate("project", project, "firewallpolicy", firewallpolicy);
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o != null && getClass() == o.getClass()) {
      FirewallPolicyName that = ((FirewallPolicyName) o);
      return Objects.equals(this.project, that.project)
          && Objects.equals(this.firewallpolicy, that.firewallpolicy);
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= Objects.hashCode(project);
    h *= 1000003;
    h ^= Objects.hashCode(firewallpolicy);
    return h;
  }

  /** Builder for projects/{project}/firewallpolicies/{firewallpolicy}. */
  public static class Builder {
    private String project;
    private String firewallpolicy;

    protected Builder() {}

    public String getProject() {
      return project;
    }

    public String getFirewallpolicy() {
      return firewallpolicy;
    }

    public Builder setProject(String project) {
      this.project = project;
      return this;
    }

    public Builder setFirewallpolicy(String firewallpolicy) {
      this.firewallpolicy = firewallpolicy;
      return this;
    }

    private Builder(FirewallPolicyName firewallPolicyName) {
      this.project = firewallPolicyName.project;
      this.firewallpolicy = firewallPolicyName.firewallpolicy;
    }

    public FirewallPolicyName build() {
      return new FirewallPolicyName(this);
    }
  }
}
