/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

package com.google.recaptchaenterprise.v1;

/**
 *
 *
 * <pre>
 * Fraud signals describing users and cards involved in the transaction.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1.FraudSignals}
 */
public final class FraudSignals extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1.FraudSignals)
    FraudSignalsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FraudSignals.newBuilder() to construct.
  private FraudSignals(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FraudSignals() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FraudSignals();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1.FraudSignals.class,
            com.google.recaptchaenterprise.v1.FraudSignals.Builder.class);
  }

  public interface UserSignalsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. This user (based on email, phone, and other identifiers) has
     * been seen on the internet for at least this number of days.
     * </pre>
     *
     * <code>int32 active_days_lower_bound = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The activeDaysLowerBound.
     */
    int getActiveDaysLowerBound();

    /**
     *
     *
     * <pre>
     * Output only. Likelihood (from 0.0 to 1.0) this user includes synthetic
     * components in their identity, such as a randomly generated email address,
     * temporary phone number, or fake shipping address.
     * </pre>
     *
     * <code>float synthetic_risk = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The syntheticRisk.
     */
    float getSyntheticRisk();
  }
  /**
   *
   *
   * <pre>
   * Signals describing the user involved in this transaction.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals}
   */
  public static final class UserSignals extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals)
      UserSignalsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UserSignals.newBuilder() to construct.
    private UserSignals(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UserSignals() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UserSignals();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_UserSignals_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_UserSignals_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.class,
              com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.Builder.class);
    }

    public static final int ACTIVE_DAYS_LOWER_BOUND_FIELD_NUMBER = 1;
    private int activeDaysLowerBound_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. This user (based on email, phone, and other identifiers) has
     * been seen on the internet for at least this number of days.
     * </pre>
     *
     * <code>int32 active_days_lower_bound = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The activeDaysLowerBound.
     */
    @java.lang.Override
    public int getActiveDaysLowerBound() {
      return activeDaysLowerBound_;
    }

    public static final int SYNTHETIC_RISK_FIELD_NUMBER = 2;
    private float syntheticRisk_ = 0F;
    /**
     *
     *
     * <pre>
     * Output only. Likelihood (from 0.0 to 1.0) this user includes synthetic
     * components in their identity, such as a randomly generated email address,
     * temporary phone number, or fake shipping address.
     * </pre>
     *
     * <code>float synthetic_risk = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The syntheticRisk.
     */
    @java.lang.Override
    public float getSyntheticRisk() {
      return syntheticRisk_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (activeDaysLowerBound_ != 0) {
        output.writeInt32(1, activeDaysLowerBound_);
      }
      if (java.lang.Float.floatToRawIntBits(syntheticRisk_) != 0) {
        output.writeFloat(2, syntheticRisk_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (activeDaysLowerBound_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, activeDaysLowerBound_);
      }
      if (java.lang.Float.floatToRawIntBits(syntheticRisk_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, syntheticRisk_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.recaptchaenterprise.v1.FraudSignals.UserSignals)) {
        return super.equals(obj);
      }
      com.google.recaptchaenterprise.v1.FraudSignals.UserSignals other =
          (com.google.recaptchaenterprise.v1.FraudSignals.UserSignals) obj;

      if (getActiveDaysLowerBound() != other.getActiveDaysLowerBound()) return false;
      if (java.lang.Float.floatToIntBits(getSyntheticRisk())
          != java.lang.Float.floatToIntBits(other.getSyntheticRisk())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACTIVE_DAYS_LOWER_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + getActiveDaysLowerBound();
      hash = (37 * hash) + SYNTHETIC_RISK_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getSyntheticRisk());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.UserSignals parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.UserSignals parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.UserSignals parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.UserSignals parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.UserSignals parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.UserSignals parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.UserSignals parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.UserSignals parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.UserSignals parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.UserSignals parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.UserSignals parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.UserSignals parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.recaptchaenterprise.v1.FraudSignals.UserSignals prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Signals describing the user involved in this transaction.
     * </pre>
     *
     * Protobuf type {@code google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals)
        com.google.recaptchaenterprise.v1.FraudSignals.UserSignalsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_UserSignals_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_UserSignals_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.class,
                com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.Builder.class);
      }

      // Construct using com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        activeDaysLowerBound_ = 0;
        syntheticRisk_ = 0F;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_UserSignals_descriptor;
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1.FraudSignals.UserSignals
          getDefaultInstanceForType() {
        return com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1.FraudSignals.UserSignals build() {
        com.google.recaptchaenterprise.v1.FraudSignals.UserSignals result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1.FraudSignals.UserSignals buildPartial() {
        com.google.recaptchaenterprise.v1.FraudSignals.UserSignals result =
            new com.google.recaptchaenterprise.v1.FraudSignals.UserSignals(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.recaptchaenterprise.v1.FraudSignals.UserSignals result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.activeDaysLowerBound_ = activeDaysLowerBound_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.syntheticRisk_ = syntheticRisk_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.recaptchaenterprise.v1.FraudSignals.UserSignals) {
          return mergeFrom((com.google.recaptchaenterprise.v1.FraudSignals.UserSignals) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.recaptchaenterprise.v1.FraudSignals.UserSignals other) {
        if (other
            == com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.getDefaultInstance())
          return this;
        if (other.getActiveDaysLowerBound() != 0) {
          setActiveDaysLowerBound(other.getActiveDaysLowerBound());
        }
        if (other.getSyntheticRisk() != 0F) {
          setSyntheticRisk(other.getSyntheticRisk());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  activeDaysLowerBound_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 21:
                {
                  syntheticRisk_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int activeDaysLowerBound_;
      /**
       *
       *
       * <pre>
       * Output only. This user (based on email, phone, and other identifiers) has
       * been seen on the internet for at least this number of days.
       * </pre>
       *
       * <code>int32 active_days_lower_bound = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The activeDaysLowerBound.
       */
      @java.lang.Override
      public int getActiveDaysLowerBound() {
        return activeDaysLowerBound_;
      }
      /**
       *
       *
       * <pre>
       * Output only. This user (based on email, phone, and other identifiers) has
       * been seen on the internet for at least this number of days.
       * </pre>
       *
       * <code>int32 active_days_lower_bound = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The activeDaysLowerBound to set.
       * @return This builder for chaining.
       */
      public Builder setActiveDaysLowerBound(int value) {

        activeDaysLowerBound_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. This user (based on email, phone, and other identifiers) has
       * been seen on the internet for at least this number of days.
       * </pre>
       *
       * <code>int32 active_days_lower_bound = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearActiveDaysLowerBound() {
        bitField0_ = (bitField0_ & ~0x00000001);
        activeDaysLowerBound_ = 0;
        onChanged();
        return this;
      }

      private float syntheticRisk_;
      /**
       *
       *
       * <pre>
       * Output only. Likelihood (from 0.0 to 1.0) this user includes synthetic
       * components in their identity, such as a randomly generated email address,
       * temporary phone number, or fake shipping address.
       * </pre>
       *
       * <code>float synthetic_risk = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The syntheticRisk.
       */
      @java.lang.Override
      public float getSyntheticRisk() {
        return syntheticRisk_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Likelihood (from 0.0 to 1.0) this user includes synthetic
       * components in their identity, such as a randomly generated email address,
       * temporary phone number, or fake shipping address.
       * </pre>
       *
       * <code>float synthetic_risk = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The syntheticRisk to set.
       * @return This builder for chaining.
       */
      public Builder setSyntheticRisk(float value) {

        syntheticRisk_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Likelihood (from 0.0 to 1.0) this user includes synthetic
       * components in their identity, such as a randomly generated email address,
       * temporary phone number, or fake shipping address.
       * </pre>
       *
       * <code>float synthetic_risk = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSyntheticRisk() {
        bitField0_ = (bitField0_ & ~0x00000002);
        syntheticRisk_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals)
    private static final com.google.recaptchaenterprise.v1.FraudSignals.UserSignals
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1.FraudSignals.UserSignals();
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.UserSignals getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UserSignals> PARSER =
        new com.google.protobuf.AbstractParser<UserSignals>() {
          @java.lang.Override
          public UserSignals parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UserSignals> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UserSignals> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.FraudSignals.UserSignals getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CardSignalsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The labels for the payment card in this transaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the cardLabels.
     */
    java.util.List<com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel>
        getCardLabelsList();
    /**
     *
     *
     * <pre>
     * Output only. The labels for the payment card in this transaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of cardLabels.
     */
    int getCardLabelsCount();
    /**
     *
     *
     * <pre>
     * Output only. The labels for the payment card in this transaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The cardLabels at the given index.
     */
    com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel getCardLabels(int index);
    /**
     *
     *
     * <pre>
     * Output only. The labels for the payment card in this transaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for cardLabels.
     */
    java.util.List<java.lang.Integer> getCardLabelsValueList();
    /**
     *
     *
     * <pre>
     * Output only. The labels for the payment card in this transaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of cardLabels at the given index.
     */
    int getCardLabelsValue(int index);
  }
  /**
   *
   *
   * <pre>
   * Signals describing the payment card used in this transaction.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals}
   */
  public static final class CardSignals extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals)
      CardSignalsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CardSignals.newBuilder() to construct.
    private CardSignals(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CardSignals() {
      cardLabels_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CardSignals();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_CardSignals_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_CardSignals_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.class,
              com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Risk labels describing the card being assessed, such as its funding
     * mechanism.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel}
     */
    public enum CardLabel implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * No label specified.
       * </pre>
       *
       * <code>CARD_LABEL_UNSPECIFIED = 0;</code>
       */
      CARD_LABEL_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * This card has been detected as prepaid.
       * </pre>
       *
       * <code>PREPAID = 1;</code>
       */
      PREPAID(1),
      /**
       *
       *
       * <pre>
       * This card has been detected as virtual, such as a card number generated
       * for a single transaction or merchant.
       * </pre>
       *
       * <code>VIRTUAL = 2;</code>
       */
      VIRTUAL(2),
      /**
       *
       *
       * <pre>
       * This card has been detected as being used in an unexpected geographic
       * location.
       * </pre>
       *
       * <code>UNEXPECTED_LOCATION = 3;</code>
       */
      UNEXPECTED_LOCATION(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * No label specified.
       * </pre>
       *
       * <code>CARD_LABEL_UNSPECIFIED = 0;</code>
       */
      public static final int CARD_LABEL_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * This card has been detected as prepaid.
       * </pre>
       *
       * <code>PREPAID = 1;</code>
       */
      public static final int PREPAID_VALUE = 1;
      /**
       *
       *
       * <pre>
       * This card has been detected as virtual, such as a card number generated
       * for a single transaction or merchant.
       * </pre>
       *
       * <code>VIRTUAL = 2;</code>
       */
      public static final int VIRTUAL_VALUE = 2;
      /**
       *
       *
       * <pre>
       * This card has been detected as being used in an unexpected geographic
       * location.
       * </pre>
       *
       * <code>UNEXPECTED_LOCATION = 3;</code>
       */
      public static final int UNEXPECTED_LOCATION_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static CardLabel valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static CardLabel forNumber(int value) {
        switch (value) {
          case 0:
            return CARD_LABEL_UNSPECIFIED;
          case 1:
            return PREPAID;
          case 2:
            return VIRTUAL;
          case 3:
            return UNEXPECTED_LOCATION;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<CardLabel> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<CardLabel> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<CardLabel>() {
            public CardLabel findValueByNumber(int number) {
              return CardLabel.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final CardLabel[] VALUES = values();

      public static CardLabel valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private CardLabel(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel)
    }

    public static final int CARD_LABELS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> cardLabels_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel>
        cardLabels_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer,
                com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel>() {
              public com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel convert(
                  java.lang.Integer from) {
                com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel result =
                    com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel.forNumber(
                        from);
                return result == null
                    ? com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel
                        .UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * Output only. The labels for the payment card in this transaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the cardLabels.
     */
    @java.lang.Override
    public java.util.List<com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel>
        getCardLabelsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel>(
          cardLabels_, cardLabels_converter_);
    }
    /**
     *
     *
     * <pre>
     * Output only. The labels for the payment card in this transaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of cardLabels.
     */
    @java.lang.Override
    public int getCardLabelsCount() {
      return cardLabels_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The labels for the payment card in this transaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The cardLabels at the given index.
     */
    @java.lang.Override
    public com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel getCardLabels(
        int index) {
      return cardLabels_converter_.convert(cardLabels_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Output only. The labels for the payment card in this transaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for cardLabels.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getCardLabelsValueList() {
      return cardLabels_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The labels for the payment card in this transaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of cardLabels at the given index.
     */
    @java.lang.Override
    public int getCardLabelsValue(int index) {
      return cardLabels_.get(index);
    }

    private int cardLabelsMemoizedSerializedSize;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (getCardLabelsList().size() > 0) {
        output.writeUInt32NoTag(10);
        output.writeUInt32NoTag(cardLabelsMemoizedSerializedSize);
      }
      for (int i = 0; i < cardLabels_.size(); i++) {
        output.writeEnumNoTag(cardLabels_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < cardLabels_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(cardLabels_.get(i));
        }
        size += dataSize;
        if (!getCardLabelsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        cardLabelsMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.recaptchaenterprise.v1.FraudSignals.CardSignals)) {
        return super.equals(obj);
      }
      com.google.recaptchaenterprise.v1.FraudSignals.CardSignals other =
          (com.google.recaptchaenterprise.v1.FraudSignals.CardSignals) obj;

      if (!cardLabels_.equals(other.cardLabels_)) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getCardLabelsCount() > 0) {
        hash = (37 * hash) + CARD_LABELS_FIELD_NUMBER;
        hash = (53 * hash) + cardLabels_.hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.CardSignals parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.CardSignals parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.CardSignals parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.CardSignals parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.CardSignals parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.CardSignals parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.CardSignals parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.CardSignals parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.CardSignals parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.CardSignals parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.CardSignals parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.CardSignals parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.recaptchaenterprise.v1.FraudSignals.CardSignals prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Signals describing the payment card used in this transaction.
     * </pre>
     *
     * Protobuf type {@code google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals)
        com.google.recaptchaenterprise.v1.FraudSignals.CardSignalsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_CardSignals_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_CardSignals_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.class,
                com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.Builder.class);
      }

      // Construct using com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cardLabels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
            .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_CardSignals_descriptor;
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1.FraudSignals.CardSignals
          getDefaultInstanceForType() {
        return com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1.FraudSignals.CardSignals build() {
        com.google.recaptchaenterprise.v1.FraudSignals.CardSignals result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.recaptchaenterprise.v1.FraudSignals.CardSignals buildPartial() {
        com.google.recaptchaenterprise.v1.FraudSignals.CardSignals result =
            new com.google.recaptchaenterprise.v1.FraudSignals.CardSignals(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.recaptchaenterprise.v1.FraudSignals.CardSignals result) {
        if (((bitField0_ & 0x00000001) != 0)) {
          cardLabels_ = java.util.Collections.unmodifiableList(cardLabels_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.cardLabels_ = cardLabels_;
      }

      private void buildPartial0(
          com.google.recaptchaenterprise.v1.FraudSignals.CardSignals result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.recaptchaenterprise.v1.FraudSignals.CardSignals) {
          return mergeFrom((com.google.recaptchaenterprise.v1.FraudSignals.CardSignals) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.recaptchaenterprise.v1.FraudSignals.CardSignals other) {
        if (other
            == com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.getDefaultInstance())
          return this;
        if (!other.cardLabels_.isEmpty()) {
          if (cardLabels_.isEmpty()) {
            cardLabels_ = other.cardLabels_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCardLabelsIsMutable();
            cardLabels_.addAll(other.cardLabels_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  int tmpRaw = input.readEnum();
                  ensureCardLabelsIsMutable();
                  cardLabels_.add(tmpRaw);
                  break;
                } // case 8
              case 10:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureCardLabelsIsMutable();
                    cardLabels_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<java.lang.Integer> cardLabels_ = java.util.Collections.emptyList();

      private void ensureCardLabelsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          cardLabels_ = new java.util.ArrayList<java.lang.Integer>(cardLabels_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The labels for the payment card in this transaction.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return A list containing the cardLabels.
       */
      public java.util.List<com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel>
          getCardLabelsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer,
            com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel>(
            cardLabels_, cardLabels_converter_);
      }
      /**
       *
       *
       * <pre>
       * Output only. The labels for the payment card in this transaction.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The count of cardLabels.
       */
      public int getCardLabelsCount() {
        return cardLabels_.size();
      }
      /**
       *
       *
       * <pre>
       * Output only. The labels for the payment card in this transaction.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The cardLabels at the given index.
       */
      public com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel getCardLabels(
          int index) {
        return cardLabels_converter_.convert(cardLabels_.get(index));
      }
      /**
       *
       *
       * <pre>
       * Output only. The labels for the payment card in this transaction.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The cardLabels to set.
       * @return This builder for chaining.
       */
      public Builder setCardLabels(
          int index, com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCardLabelsIsMutable();
        cardLabels_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The labels for the payment card in this transaction.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The cardLabels to add.
       * @return This builder for chaining.
       */
      public Builder addCardLabels(
          com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCardLabelsIsMutable();
        cardLabels_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The labels for the payment card in this transaction.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param values The cardLabels to add.
       * @return This builder for chaining.
       */
      public Builder addAllCardLabels(
          java.lang.Iterable<
                  ? extends com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel>
              values) {
        ensureCardLabelsIsMutable();
        for (com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel value : values) {
          cardLabels_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The labels for the payment card in this transaction.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCardLabels() {
        cardLabels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The labels for the payment card in this transaction.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for cardLabels.
       */
      public java.util.List<java.lang.Integer> getCardLabelsValueList() {
        return java.util.Collections.unmodifiableList(cardLabels_);
      }
      /**
       *
       *
       * <pre>
       * Output only. The labels for the payment card in this transaction.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of cardLabels at the given index.
       */
      public int getCardLabelsValue(int index) {
        return cardLabels_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. The labels for the payment card in this transaction.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for cardLabels to set.
       * @return This builder for chaining.
       */
      public Builder setCardLabelsValue(int index, int value) {
        ensureCardLabelsIsMutable();
        cardLabels_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The labels for the payment card in this transaction.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for cardLabels to add.
       * @return This builder for chaining.
       */
      public Builder addCardLabelsValue(int value) {
        ensureCardLabelsIsMutable();
        cardLabels_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The labels for the payment card in this transaction.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals.CardLabel card_labels = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param values The enum numeric values on the wire for cardLabels to add.
       * @return This builder for chaining.
       */
      public Builder addAllCardLabelsValue(java.lang.Iterable<java.lang.Integer> values) {
        ensureCardLabelsIsMutable();
        for (int value : values) {
          cardLabels_.add(value);
        }
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals)
    private static final com.google.recaptchaenterprise.v1.FraudSignals.CardSignals
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1.FraudSignals.CardSignals();
    }

    public static com.google.recaptchaenterprise.v1.FraudSignals.CardSignals getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CardSignals> PARSER =
        new com.google.protobuf.AbstractParser<CardSignals>() {
          @java.lang.Override
          public CardSignals parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CardSignals> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CardSignals> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.FraudSignals.CardSignals getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int USER_SIGNALS_FIELD_NUMBER = 1;
  private com.google.recaptchaenterprise.v1.FraudSignals.UserSignals userSignals_;
  /**
   *
   *
   * <pre>
   * Output only. Signals describing the end user in this transaction.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals user_signals = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the userSignals field is set.
   */
  @java.lang.Override
  public boolean hasUserSignals() {
    return userSignals_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Signals describing the end user in this transaction.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals user_signals = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The userSignals.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FraudSignals.UserSignals getUserSignals() {
    return userSignals_ == null
        ? com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.getDefaultInstance()
        : userSignals_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Signals describing the end user in this transaction.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals user_signals = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FraudSignals.UserSignalsOrBuilder
      getUserSignalsOrBuilder() {
    return userSignals_ == null
        ? com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.getDefaultInstance()
        : userSignals_;
  }

  public static final int CARD_SIGNALS_FIELD_NUMBER = 2;
  private com.google.recaptchaenterprise.v1.FraudSignals.CardSignals cardSignals_;
  /**
   *
   *
   * <pre>
   * Output only. Signals describing the payment card or cards used in this
   * transaction.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals card_signals = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the cardSignals field is set.
   */
  @java.lang.Override
  public boolean hasCardSignals() {
    return cardSignals_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Signals describing the payment card or cards used in this
   * transaction.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals card_signals = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The cardSignals.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FraudSignals.CardSignals getCardSignals() {
    return cardSignals_ == null
        ? com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.getDefaultInstance()
        : cardSignals_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Signals describing the payment card or cards used in this
   * transaction.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals card_signals = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FraudSignals.CardSignalsOrBuilder
      getCardSignalsOrBuilder() {
    return cardSignals_ == null
        ? com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.getDefaultInstance()
        : cardSignals_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (userSignals_ != null) {
      output.writeMessage(1, getUserSignals());
    }
    if (cardSignals_ != null) {
      output.writeMessage(2, getCardSignals());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (userSignals_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getUserSignals());
    }
    if (cardSignals_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCardSignals());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1.FraudSignals)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1.FraudSignals other =
        (com.google.recaptchaenterprise.v1.FraudSignals) obj;

    if (hasUserSignals() != other.hasUserSignals()) return false;
    if (hasUserSignals()) {
      if (!getUserSignals().equals(other.getUserSignals())) return false;
    }
    if (hasCardSignals() != other.hasCardSignals()) return false;
    if (hasCardSignals()) {
      if (!getCardSignals().equals(other.getCardSignals())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasUserSignals()) {
      hash = (37 * hash) + USER_SIGNALS_FIELD_NUMBER;
      hash = (53 * hash) + getUserSignals().hashCode();
    }
    if (hasCardSignals()) {
      hash = (37 * hash) + CARD_SIGNALS_FIELD_NUMBER;
      hash = (53 * hash) + getCardSignals().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1.FraudSignals parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.FraudSignals parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.FraudSignals parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.FraudSignals parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.FraudSignals parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.FraudSignals parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.FraudSignals parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.FraudSignals parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.FraudSignals parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.FraudSignals parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.FraudSignals parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.FraudSignals parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.recaptchaenterprise.v1.FraudSignals prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Fraud signals describing users and cards involved in the transaction.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1.FraudSignals}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1.FraudSignals)
      com.google.recaptchaenterprise.v1.FraudSignalsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1.FraudSignals.class,
              com.google.recaptchaenterprise.v1.FraudSignals.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1.FraudSignals.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      userSignals_ = null;
      if (userSignalsBuilder_ != null) {
        userSignalsBuilder_.dispose();
        userSignalsBuilder_ = null;
      }
      cardSignals_ = null;
      if (cardSignalsBuilder_ != null) {
        cardSignalsBuilder_.dispose();
        cardSignalsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_FraudSignals_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.FraudSignals getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1.FraudSignals.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.FraudSignals build() {
      com.google.recaptchaenterprise.v1.FraudSignals result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.FraudSignals buildPartial() {
      com.google.recaptchaenterprise.v1.FraudSignals result =
          new com.google.recaptchaenterprise.v1.FraudSignals(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1.FraudSignals result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.userSignals_ =
            userSignalsBuilder_ == null ? userSignals_ : userSignalsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.cardSignals_ =
            cardSignalsBuilder_ == null ? cardSignals_ : cardSignalsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1.FraudSignals) {
        return mergeFrom((com.google.recaptchaenterprise.v1.FraudSignals) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1.FraudSignals other) {
      if (other == com.google.recaptchaenterprise.v1.FraudSignals.getDefaultInstance()) return this;
      if (other.hasUserSignals()) {
        mergeUserSignals(other.getUserSignals());
      }
      if (other.hasCardSignals()) {
        mergeCardSignals(other.getCardSignals());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getUserSignalsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCardSignalsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.recaptchaenterprise.v1.FraudSignals.UserSignals userSignals_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.FraudSignals.UserSignals,
            com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.Builder,
            com.google.recaptchaenterprise.v1.FraudSignals.UserSignalsOrBuilder>
        userSignalsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the end user in this transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals user_signals = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the userSignals field is set.
     */
    public boolean hasUserSignals() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the end user in this transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals user_signals = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The userSignals.
     */
    public com.google.recaptchaenterprise.v1.FraudSignals.UserSignals getUserSignals() {
      if (userSignalsBuilder_ == null) {
        return userSignals_ == null
            ? com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.getDefaultInstance()
            : userSignals_;
      } else {
        return userSignalsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the end user in this transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals user_signals = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUserSignals(
        com.google.recaptchaenterprise.v1.FraudSignals.UserSignals value) {
      if (userSignalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userSignals_ = value;
      } else {
        userSignalsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the end user in this transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals user_signals = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUserSignals(
        com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.Builder builderForValue) {
      if (userSignalsBuilder_ == null) {
        userSignals_ = builderForValue.build();
      } else {
        userSignalsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the end user in this transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals user_signals = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUserSignals(
        com.google.recaptchaenterprise.v1.FraudSignals.UserSignals value) {
      if (userSignalsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && userSignals_ != null
            && userSignals_
                != com.google.recaptchaenterprise.v1.FraudSignals.UserSignals
                    .getDefaultInstance()) {
          getUserSignalsBuilder().mergeFrom(value);
        } else {
          userSignals_ = value;
        }
      } else {
        userSignalsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the end user in this transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals user_signals = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUserSignals() {
      bitField0_ = (bitField0_ & ~0x00000001);
      userSignals_ = null;
      if (userSignalsBuilder_ != null) {
        userSignalsBuilder_.dispose();
        userSignalsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the end user in this transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals user_signals = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.Builder
        getUserSignalsBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getUserSignalsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the end user in this transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals user_signals = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FraudSignals.UserSignalsOrBuilder
        getUserSignalsOrBuilder() {
      if (userSignalsBuilder_ != null) {
        return userSignalsBuilder_.getMessageOrBuilder();
      } else {
        return userSignals_ == null
            ? com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.getDefaultInstance()
            : userSignals_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the end user in this transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.UserSignals user_signals = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.FraudSignals.UserSignals,
            com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.Builder,
            com.google.recaptchaenterprise.v1.FraudSignals.UserSignalsOrBuilder>
        getUserSignalsFieldBuilder() {
      if (userSignalsBuilder_ == null) {
        userSignalsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.FraudSignals.UserSignals,
                com.google.recaptchaenterprise.v1.FraudSignals.UserSignals.Builder,
                com.google.recaptchaenterprise.v1.FraudSignals.UserSignalsOrBuilder>(
                getUserSignals(), getParentForChildren(), isClean());
        userSignals_ = null;
      }
      return userSignalsBuilder_;
    }

    private com.google.recaptchaenterprise.v1.FraudSignals.CardSignals cardSignals_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.FraudSignals.CardSignals,
            com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.Builder,
            com.google.recaptchaenterprise.v1.FraudSignals.CardSignalsOrBuilder>
        cardSignalsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the payment card or cards used in this
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals card_signals = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the cardSignals field is set.
     */
    public boolean hasCardSignals() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the payment card or cards used in this
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals card_signals = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cardSignals.
     */
    public com.google.recaptchaenterprise.v1.FraudSignals.CardSignals getCardSignals() {
      if (cardSignalsBuilder_ == null) {
        return cardSignals_ == null
            ? com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.getDefaultInstance()
            : cardSignals_;
      } else {
        return cardSignalsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the payment card or cards used in this
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals card_signals = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCardSignals(
        com.google.recaptchaenterprise.v1.FraudSignals.CardSignals value) {
      if (cardSignalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cardSignals_ = value;
      } else {
        cardSignalsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the payment card or cards used in this
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals card_signals = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCardSignals(
        com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.Builder builderForValue) {
      if (cardSignalsBuilder_ == null) {
        cardSignals_ = builderForValue.build();
      } else {
        cardSignalsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the payment card or cards used in this
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals card_signals = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCardSignals(
        com.google.recaptchaenterprise.v1.FraudSignals.CardSignals value) {
      if (cardSignalsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && cardSignals_ != null
            && cardSignals_
                != com.google.recaptchaenterprise.v1.FraudSignals.CardSignals
                    .getDefaultInstance()) {
          getCardSignalsBuilder().mergeFrom(value);
        } else {
          cardSignals_ = value;
        }
      } else {
        cardSignalsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the payment card or cards used in this
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals card_signals = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCardSignals() {
      bitField0_ = (bitField0_ & ~0x00000002);
      cardSignals_ = null;
      if (cardSignalsBuilder_ != null) {
        cardSignalsBuilder_.dispose();
        cardSignalsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the payment card or cards used in this
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals card_signals = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.Builder
        getCardSignalsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCardSignalsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the payment card or cards used in this
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals card_signals = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FraudSignals.CardSignalsOrBuilder
        getCardSignalsOrBuilder() {
      if (cardSignalsBuilder_ != null) {
        return cardSignalsBuilder_.getMessageOrBuilder();
      } else {
        return cardSignals_ == null
            ? com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.getDefaultInstance()
            : cardSignals_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Signals describing the payment card or cards used in this
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals.CardSignals card_signals = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.FraudSignals.CardSignals,
            com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.Builder,
            com.google.recaptchaenterprise.v1.FraudSignals.CardSignalsOrBuilder>
        getCardSignalsFieldBuilder() {
      if (cardSignalsBuilder_ == null) {
        cardSignalsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.FraudSignals.CardSignals,
                com.google.recaptchaenterprise.v1.FraudSignals.CardSignals.Builder,
                com.google.recaptchaenterprise.v1.FraudSignals.CardSignalsOrBuilder>(
                getCardSignals(), getParentForChildren(), isClean());
        cardSignals_ = null;
      }
      return cardSignalsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1.FraudSignals)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1.FraudSignals)
  private static final com.google.recaptchaenterprise.v1.FraudSignals DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1.FraudSignals();
  }

  public static com.google.recaptchaenterprise.v1.FraudSignals getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FraudSignals> PARSER =
      new com.google.protobuf.AbstractParser<FraudSignals>() {
        @java.lang.Override
        public FraudSignals parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FraudSignals> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FraudSignals> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FraudSignals getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
