/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

package com.google.recaptchaenterprise.v1;

/**
 *
 *
 * <pre>
 * A key used to identify and configure applications (web and/or mobile) that
 * use reCAPTCHA Enterprise.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1.Key}
 */
public final class Key extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1.Key)
    KeyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Key.newBuilder() to construct.
  private Key(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Key() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Key();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_Key_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 6:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_Key_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1.Key.class,
            com.google.recaptchaenterprise.v1.Key.Builder.class);
  }

  private int platformSettingsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object platformSettings_;

  public enum PlatformSettingsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    WEB_SETTINGS(3),
    ANDROID_SETTINGS(4),
    IOS_SETTINGS(5),
    PLATFORMSETTINGS_NOT_SET(0);
    private final int value;

    private PlatformSettingsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PlatformSettingsCase valueOf(int value) {
      return forNumber(value);
    }

    public static PlatformSettingsCase forNumber(int value) {
      switch (value) {
        case 3:
          return WEB_SETTINGS;
        case 4:
          return ANDROID_SETTINGS;
        case 5:
          return IOS_SETTINGS;
        case 0:
          return PLATFORMSETTINGS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PlatformSettingsCase getPlatformSettingsCase() {
    return PlatformSettingsCase.forNumber(platformSettingsCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name for the Key in the format
   * `projects/{project}/keys/{key}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name for the Key in the format
   * `projects/{project}/keys/{key}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. Human-readable display name of this key. Modifiable by user.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Human-readable display name of this key. Modifiable by user.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WEB_SETTINGS_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by websites.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings web_settings = 3;</code>
   *
   * @return Whether the webSettings field is set.
   */
  @java.lang.Override
  public boolean hasWebSettings() {
    return platformSettingsCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by websites.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings web_settings = 3;</code>
   *
   * @return The webSettings.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.WebKeySettings getWebSettings() {
    if (platformSettingsCase_ == 3) {
      return (com.google.recaptchaenterprise.v1.WebKeySettings) platformSettings_;
    }
    return com.google.recaptchaenterprise.v1.WebKeySettings.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by websites.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings web_settings = 3;</code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.WebKeySettingsOrBuilder getWebSettingsOrBuilder() {
    if (platformSettingsCase_ == 3) {
      return (com.google.recaptchaenterprise.v1.WebKeySettings) platformSettings_;
    }
    return com.google.recaptchaenterprise.v1.WebKeySettings.getDefaultInstance();
  }

  public static final int ANDROID_SETTINGS_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by Android apps.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1.AndroidKeySettings android_settings = 4;</code>
   *
   * @return Whether the androidSettings field is set.
   */
  @java.lang.Override
  public boolean hasAndroidSettings() {
    return platformSettingsCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by Android apps.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1.AndroidKeySettings android_settings = 4;</code>
   *
   * @return The androidSettings.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AndroidKeySettings getAndroidSettings() {
    if (platformSettingsCase_ == 4) {
      return (com.google.recaptchaenterprise.v1.AndroidKeySettings) platformSettings_;
    }
    return com.google.recaptchaenterprise.v1.AndroidKeySettings.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by Android apps.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1.AndroidKeySettings android_settings = 4;</code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AndroidKeySettingsOrBuilder
      getAndroidSettingsOrBuilder() {
    if (platformSettingsCase_ == 4) {
      return (com.google.recaptchaenterprise.v1.AndroidKeySettings) platformSettings_;
    }
    return com.google.recaptchaenterprise.v1.AndroidKeySettings.getDefaultInstance();
  }

  public static final int IOS_SETTINGS_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by iOS apps.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1.IOSKeySettings ios_settings = 5;</code>
   *
   * @return Whether the iosSettings field is set.
   */
  @java.lang.Override
  public boolean hasIosSettings() {
    return platformSettingsCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by iOS apps.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1.IOSKeySettings ios_settings = 5;</code>
   *
   * @return The iosSettings.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.IOSKeySettings getIosSettings() {
    if (platformSettingsCase_ == 5) {
      return (com.google.recaptchaenterprise.v1.IOSKeySettings) platformSettings_;
    }
    return com.google.recaptchaenterprise.v1.IOSKeySettings.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Settings for keys that can be used by iOS apps.
   * </pre>
   *
   * <code>.google.cloud.recaptchaenterprise.v1.IOSKeySettings ios_settings = 5;</code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.IOSKeySettingsOrBuilder getIosSettingsOrBuilder() {
    if (platformSettingsCase_ == 5) {
      return (com.google.recaptchaenterprise.v1.IOSKeySettings) platformSettings_;
    }
    return com.google.recaptchaenterprise.v1.IOSKeySettings.getDefaultInstance();
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
                .internal_static_google_cloud_recaptchaenterprise_v1_Key_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing labels]
   * (https://cloud.google.com/recaptcha-enterprise/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing labels]
   * (https://cloud.google.com/recaptcha-enterprise/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing labels]
   * (https://cloud.google.com/recaptcha-enterprise/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing labels]
   * (https://cloud.google.com/recaptcha-enterprise/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp corresponding to the creation of this key.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp corresponding to the creation of this key.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp corresponding to the creation of this key.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int TESTING_OPTIONS_FIELD_NUMBER = 9;
  private com.google.recaptchaenterprise.v1.TestingOptions testingOptions_;
  /**
   *
   *
   * <pre>
   * Optional. Options for user acceptance testing.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.TestingOptions testing_options = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the testingOptions field is set.
   */
  @java.lang.Override
  public boolean hasTestingOptions() {
    return testingOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Options for user acceptance testing.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.TestingOptions testing_options = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The testingOptions.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.TestingOptions getTestingOptions() {
    return testingOptions_ == null
        ? com.google.recaptchaenterprise.v1.TestingOptions.getDefaultInstance()
        : testingOptions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Options for user acceptance testing.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.TestingOptions testing_options = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.TestingOptionsOrBuilder getTestingOptionsOrBuilder() {
    return testingOptions_ == null
        ? com.google.recaptchaenterprise.v1.TestingOptions.getDefaultInstance()
        : testingOptions_;
  }

  public static final int WAF_SETTINGS_FIELD_NUMBER = 10;
  private com.google.recaptchaenterprise.v1.WafSettings wafSettings_;
  /**
   *
   *
   * <pre>
   * Optional. Settings for WAF
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.WafSettings waf_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the wafSettings field is set.
   */
  @java.lang.Override
  public boolean hasWafSettings() {
    return wafSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Settings for WAF
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.WafSettings waf_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The wafSettings.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.WafSettings getWafSettings() {
    return wafSettings_ == null
        ? com.google.recaptchaenterprise.v1.WafSettings.getDefaultInstance()
        : wafSettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Settings for WAF
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.WafSettings waf_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.WafSettingsOrBuilder getWafSettingsOrBuilder() {
    return wafSettings_ == null
        ? com.google.recaptchaenterprise.v1.WafSettings.getDefaultInstance()
        : wafSettings_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (platformSettingsCase_ == 3) {
      output.writeMessage(3, (com.google.recaptchaenterprise.v1.WebKeySettings) platformSettings_);
    }
    if (platformSettingsCase_ == 4) {
      output.writeMessage(
          4, (com.google.recaptchaenterprise.v1.AndroidKeySettings) platformSettings_);
    }
    if (platformSettingsCase_ == 5) {
      output.writeMessage(5, (com.google.recaptchaenterprise.v1.IOSKeySettings) platformSettings_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    if (createTime_ != null) {
      output.writeMessage(7, getCreateTime());
    }
    if (testingOptions_ != null) {
      output.writeMessage(9, getTestingOptions());
    }
    if (wafSettings_ != null) {
      output.writeMessage(10, getWafSettings());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (platformSettingsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.recaptchaenterprise.v1.WebKeySettings) platformSettings_);
    }
    if (platformSettingsCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.recaptchaenterprise.v1.AndroidKeySettings) platformSettings_);
    }
    if (platformSettingsCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.recaptchaenterprise.v1.IOSKeySettings) platformSettings_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (testingOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getTestingOptions());
    }
    if (wafSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getWafSettings());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1.Key)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1.Key other = (com.google.recaptchaenterprise.v1.Key) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasTestingOptions() != other.hasTestingOptions()) return false;
    if (hasTestingOptions()) {
      if (!getTestingOptions().equals(other.getTestingOptions())) return false;
    }
    if (hasWafSettings() != other.hasWafSettings()) return false;
    if (hasWafSettings()) {
      if (!getWafSettings().equals(other.getWafSettings())) return false;
    }
    if (!getPlatformSettingsCase().equals(other.getPlatformSettingsCase())) return false;
    switch (platformSettingsCase_) {
      case 3:
        if (!getWebSettings().equals(other.getWebSettings())) return false;
        break;
      case 4:
        if (!getAndroidSettings().equals(other.getAndroidSettings())) return false;
        break;
      case 5:
        if (!getIosSettings().equals(other.getIosSettings())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasTestingOptions()) {
      hash = (37 * hash) + TESTING_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getTestingOptions().hashCode();
    }
    if (hasWafSettings()) {
      hash = (37 * hash) + WAF_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getWafSettings().hashCode();
    }
    switch (platformSettingsCase_) {
      case 3:
        hash = (37 * hash) + WEB_SETTINGS_FIELD_NUMBER;
        hash = (53 * hash) + getWebSettings().hashCode();
        break;
      case 4:
        hash = (37 * hash) + ANDROID_SETTINGS_FIELD_NUMBER;
        hash = (53 * hash) + getAndroidSettings().hashCode();
        break;
      case 5:
        hash = (37 * hash) + IOS_SETTINGS_FIELD_NUMBER;
        hash = (53 * hash) + getIosSettings().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1.Key parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Key parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Key parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Key parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Key parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Key parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Key parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Key parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Key parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Key parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Key parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Key parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.recaptchaenterprise.v1.Key prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A key used to identify and configure applications (web and/or mobile) that
   * use reCAPTCHA Enterprise.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1.Key}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1.Key)
      com.google.recaptchaenterprise.v1.KeyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Key_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 6:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Key_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1.Key.class,
              com.google.recaptchaenterprise.v1.Key.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1.Key.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      if (webSettingsBuilder_ != null) {
        webSettingsBuilder_.clear();
      }
      if (androidSettingsBuilder_ != null) {
        androidSettingsBuilder_.clear();
      }
      if (iosSettingsBuilder_ != null) {
        iosSettingsBuilder_.clear();
      }
      internalGetMutableLabels().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      testingOptions_ = null;
      if (testingOptionsBuilder_ != null) {
        testingOptionsBuilder_.dispose();
        testingOptionsBuilder_ = null;
      }
      wafSettings_ = null;
      if (wafSettingsBuilder_ != null) {
        wafSettingsBuilder_.dispose();
        wafSettingsBuilder_ = null;
      }
      platformSettingsCase_ = 0;
      platformSettings_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Key_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Key getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1.Key.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Key build() {
      com.google.recaptchaenterprise.v1.Key result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Key buildPartial() {
      com.google.recaptchaenterprise.v1.Key result =
          new com.google.recaptchaenterprise.v1.Key(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1.Key result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.testingOptions_ =
            testingOptionsBuilder_ == null ? testingOptions_ : testingOptionsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.wafSettings_ =
            wafSettingsBuilder_ == null ? wafSettings_ : wafSettingsBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.recaptchaenterprise.v1.Key result) {
      result.platformSettingsCase_ = platformSettingsCase_;
      result.platformSettings_ = this.platformSettings_;
      if (platformSettingsCase_ == 3 && webSettingsBuilder_ != null) {
        result.platformSettings_ = webSettingsBuilder_.build();
      }
      if (platformSettingsCase_ == 4 && androidSettingsBuilder_ != null) {
        result.platformSettings_ = androidSettingsBuilder_.build();
      }
      if (platformSettingsCase_ == 5 && iosSettingsBuilder_ != null) {
        result.platformSettings_ = iosSettingsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1.Key) {
        return mergeFrom((com.google.recaptchaenterprise.v1.Key) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1.Key other) {
      if (other == com.google.recaptchaenterprise.v1.Key.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000020;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasTestingOptions()) {
        mergeTestingOptions(other.getTestingOptions());
      }
      if (other.hasWafSettings()) {
        mergeWafSettings(other.getWafSettings());
      }
      switch (other.getPlatformSettingsCase()) {
        case WEB_SETTINGS:
          {
            mergeWebSettings(other.getWebSettings());
            break;
          }
        case ANDROID_SETTINGS:
          {
            mergeAndroidSettings(other.getAndroidSettings());
            break;
          }
        case IOS_SETTINGS:
          {
            mergeIosSettings(other.getIosSettings());
            break;
          }
        case PLATFORMSETTINGS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getWebSettingsFieldBuilder().getBuilder(), extensionRegistry);
                platformSettingsCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getAndroidSettingsFieldBuilder().getBuilder(), extensionRegistry);
                platformSettingsCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getIosSettingsFieldBuilder().getBuilder(), extensionRegistry);
                platformSettingsCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 74:
              {
                input.readMessage(getTestingOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getWafSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int platformSettingsCase_ = 0;
    private java.lang.Object platformSettings_;

    public PlatformSettingsCase getPlatformSettingsCase() {
      return PlatformSettingsCase.forNumber(platformSettingsCase_);
    }

    public Builder clearPlatformSettings() {
      platformSettingsCase_ = 0;
      platformSettings_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name for the Key in the format
     * `projects/{project}/keys/{key}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name for the Key in the format
     * `projects/{project}/keys/{key}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name for the Key in the format
     * `projects/{project}/keys/{key}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name for the Key in the format
     * `projects/{project}/keys/{key}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name for the Key in the format
     * `projects/{project}/keys/{key}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of this key. Modifiable by user.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of this key. Modifiable by user.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of this key. Modifiable by user.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of this key. Modifiable by user.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of this key. Modifiable by user.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.WebKeySettings,
            com.google.recaptchaenterprise.v1.WebKeySettings.Builder,
            com.google.recaptchaenterprise.v1.WebKeySettingsOrBuilder>
        webSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings web_settings = 3;</code>
     *
     * @return Whether the webSettings field is set.
     */
    @java.lang.Override
    public boolean hasWebSettings() {
      return platformSettingsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings web_settings = 3;</code>
     *
     * @return The webSettings.
     */
    @java.lang.Override
    public com.google.recaptchaenterprise.v1.WebKeySettings getWebSettings() {
      if (webSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 3) {
          return (com.google.recaptchaenterprise.v1.WebKeySettings) platformSettings_;
        }
        return com.google.recaptchaenterprise.v1.WebKeySettings.getDefaultInstance();
      } else {
        if (platformSettingsCase_ == 3) {
          return webSettingsBuilder_.getMessage();
        }
        return com.google.recaptchaenterprise.v1.WebKeySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings web_settings = 3;</code>
     */
    public Builder setWebSettings(com.google.recaptchaenterprise.v1.WebKeySettings value) {
      if (webSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        platformSettings_ = value;
        onChanged();
      } else {
        webSettingsBuilder_.setMessage(value);
      }
      platformSettingsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings web_settings = 3;</code>
     */
    public Builder setWebSettings(
        com.google.recaptchaenterprise.v1.WebKeySettings.Builder builderForValue) {
      if (webSettingsBuilder_ == null) {
        platformSettings_ = builderForValue.build();
        onChanged();
      } else {
        webSettingsBuilder_.setMessage(builderForValue.build());
      }
      platformSettingsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings web_settings = 3;</code>
     */
    public Builder mergeWebSettings(com.google.recaptchaenterprise.v1.WebKeySettings value) {
      if (webSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 3
            && platformSettings_
                != com.google.recaptchaenterprise.v1.WebKeySettings.getDefaultInstance()) {
          platformSettings_ =
              com.google.recaptchaenterprise.v1.WebKeySettings.newBuilder(
                      (com.google.recaptchaenterprise.v1.WebKeySettings) platformSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          platformSettings_ = value;
        }
        onChanged();
      } else {
        if (platformSettingsCase_ == 3) {
          webSettingsBuilder_.mergeFrom(value);
        } else {
          webSettingsBuilder_.setMessage(value);
        }
      }
      platformSettingsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings web_settings = 3;</code>
     */
    public Builder clearWebSettings() {
      if (webSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 3) {
          platformSettingsCase_ = 0;
          platformSettings_ = null;
          onChanged();
        }
      } else {
        if (platformSettingsCase_ == 3) {
          platformSettingsCase_ = 0;
          platformSettings_ = null;
        }
        webSettingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings web_settings = 3;</code>
     */
    public com.google.recaptchaenterprise.v1.WebKeySettings.Builder getWebSettingsBuilder() {
      return getWebSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings web_settings = 3;</code>
     */
    @java.lang.Override
    public com.google.recaptchaenterprise.v1.WebKeySettingsOrBuilder getWebSettingsOrBuilder() {
      if ((platformSettingsCase_ == 3) && (webSettingsBuilder_ != null)) {
        return webSettingsBuilder_.getMessageOrBuilder();
      } else {
        if (platformSettingsCase_ == 3) {
          return (com.google.recaptchaenterprise.v1.WebKeySettings) platformSettings_;
        }
        return com.google.recaptchaenterprise.v1.WebKeySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by websites.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings web_settings = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.WebKeySettings,
            com.google.recaptchaenterprise.v1.WebKeySettings.Builder,
            com.google.recaptchaenterprise.v1.WebKeySettingsOrBuilder>
        getWebSettingsFieldBuilder() {
      if (webSettingsBuilder_ == null) {
        if (!(platformSettingsCase_ == 3)) {
          platformSettings_ = com.google.recaptchaenterprise.v1.WebKeySettings.getDefaultInstance();
        }
        webSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.WebKeySettings,
                com.google.recaptchaenterprise.v1.WebKeySettings.Builder,
                com.google.recaptchaenterprise.v1.WebKeySettingsOrBuilder>(
                (com.google.recaptchaenterprise.v1.WebKeySettings) platformSettings_,
                getParentForChildren(),
                isClean());
        platformSettings_ = null;
      }
      platformSettingsCase_ = 3;
      onChanged();
      return webSettingsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.AndroidKeySettings,
            com.google.recaptchaenterprise.v1.AndroidKeySettings.Builder,
            com.google.recaptchaenterprise.v1.AndroidKeySettingsOrBuilder>
        androidSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.AndroidKeySettings android_settings = 4;</code>
     *
     * @return Whether the androidSettings field is set.
     */
    @java.lang.Override
    public boolean hasAndroidSettings() {
      return platformSettingsCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.AndroidKeySettings android_settings = 4;</code>
     *
     * @return The androidSettings.
     */
    @java.lang.Override
    public com.google.recaptchaenterprise.v1.AndroidKeySettings getAndroidSettings() {
      if (androidSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 4) {
          return (com.google.recaptchaenterprise.v1.AndroidKeySettings) platformSettings_;
        }
        return com.google.recaptchaenterprise.v1.AndroidKeySettings.getDefaultInstance();
      } else {
        if (platformSettingsCase_ == 4) {
          return androidSettingsBuilder_.getMessage();
        }
        return com.google.recaptchaenterprise.v1.AndroidKeySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.AndroidKeySettings android_settings = 4;</code>
     */
    public Builder setAndroidSettings(com.google.recaptchaenterprise.v1.AndroidKeySettings value) {
      if (androidSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        platformSettings_ = value;
        onChanged();
      } else {
        androidSettingsBuilder_.setMessage(value);
      }
      platformSettingsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.AndroidKeySettings android_settings = 4;</code>
     */
    public Builder setAndroidSettings(
        com.google.recaptchaenterprise.v1.AndroidKeySettings.Builder builderForValue) {
      if (androidSettingsBuilder_ == null) {
        platformSettings_ = builderForValue.build();
        onChanged();
      } else {
        androidSettingsBuilder_.setMessage(builderForValue.build());
      }
      platformSettingsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.AndroidKeySettings android_settings = 4;</code>
     */
    public Builder mergeAndroidSettings(
        com.google.recaptchaenterprise.v1.AndroidKeySettings value) {
      if (androidSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 4
            && platformSettings_
                != com.google.recaptchaenterprise.v1.AndroidKeySettings.getDefaultInstance()) {
          platformSettings_ =
              com.google.recaptchaenterprise.v1.AndroidKeySettings.newBuilder(
                      (com.google.recaptchaenterprise.v1.AndroidKeySettings) platformSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          platformSettings_ = value;
        }
        onChanged();
      } else {
        if (platformSettingsCase_ == 4) {
          androidSettingsBuilder_.mergeFrom(value);
        } else {
          androidSettingsBuilder_.setMessage(value);
        }
      }
      platformSettingsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.AndroidKeySettings android_settings = 4;</code>
     */
    public Builder clearAndroidSettings() {
      if (androidSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 4) {
          platformSettingsCase_ = 0;
          platformSettings_ = null;
          onChanged();
        }
      } else {
        if (platformSettingsCase_ == 4) {
          platformSettingsCase_ = 0;
          platformSettings_ = null;
        }
        androidSettingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.AndroidKeySettings android_settings = 4;</code>
     */
    public com.google.recaptchaenterprise.v1.AndroidKeySettings.Builder
        getAndroidSettingsBuilder() {
      return getAndroidSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.AndroidKeySettings android_settings = 4;</code>
     */
    @java.lang.Override
    public com.google.recaptchaenterprise.v1.AndroidKeySettingsOrBuilder
        getAndroidSettingsOrBuilder() {
      if ((platformSettingsCase_ == 4) && (androidSettingsBuilder_ != null)) {
        return androidSettingsBuilder_.getMessageOrBuilder();
      } else {
        if (platformSettingsCase_ == 4) {
          return (com.google.recaptchaenterprise.v1.AndroidKeySettings) platformSettings_;
        }
        return com.google.recaptchaenterprise.v1.AndroidKeySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by Android apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.AndroidKeySettings android_settings = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.AndroidKeySettings,
            com.google.recaptchaenterprise.v1.AndroidKeySettings.Builder,
            com.google.recaptchaenterprise.v1.AndroidKeySettingsOrBuilder>
        getAndroidSettingsFieldBuilder() {
      if (androidSettingsBuilder_ == null) {
        if (!(platformSettingsCase_ == 4)) {
          platformSettings_ =
              com.google.recaptchaenterprise.v1.AndroidKeySettings.getDefaultInstance();
        }
        androidSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.AndroidKeySettings,
                com.google.recaptchaenterprise.v1.AndroidKeySettings.Builder,
                com.google.recaptchaenterprise.v1.AndroidKeySettingsOrBuilder>(
                (com.google.recaptchaenterprise.v1.AndroidKeySettings) platformSettings_,
                getParentForChildren(),
                isClean());
        platformSettings_ = null;
      }
      platformSettingsCase_ = 4;
      onChanged();
      return androidSettingsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.IOSKeySettings,
            com.google.recaptchaenterprise.v1.IOSKeySettings.Builder,
            com.google.recaptchaenterprise.v1.IOSKeySettingsOrBuilder>
        iosSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.IOSKeySettings ios_settings = 5;</code>
     *
     * @return Whether the iosSettings field is set.
     */
    @java.lang.Override
    public boolean hasIosSettings() {
      return platformSettingsCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.IOSKeySettings ios_settings = 5;</code>
     *
     * @return The iosSettings.
     */
    @java.lang.Override
    public com.google.recaptchaenterprise.v1.IOSKeySettings getIosSettings() {
      if (iosSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 5) {
          return (com.google.recaptchaenterprise.v1.IOSKeySettings) platformSettings_;
        }
        return com.google.recaptchaenterprise.v1.IOSKeySettings.getDefaultInstance();
      } else {
        if (platformSettingsCase_ == 5) {
          return iosSettingsBuilder_.getMessage();
        }
        return com.google.recaptchaenterprise.v1.IOSKeySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.IOSKeySettings ios_settings = 5;</code>
     */
    public Builder setIosSettings(com.google.recaptchaenterprise.v1.IOSKeySettings value) {
      if (iosSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        platformSettings_ = value;
        onChanged();
      } else {
        iosSettingsBuilder_.setMessage(value);
      }
      platformSettingsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.IOSKeySettings ios_settings = 5;</code>
     */
    public Builder setIosSettings(
        com.google.recaptchaenterprise.v1.IOSKeySettings.Builder builderForValue) {
      if (iosSettingsBuilder_ == null) {
        platformSettings_ = builderForValue.build();
        onChanged();
      } else {
        iosSettingsBuilder_.setMessage(builderForValue.build());
      }
      platformSettingsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.IOSKeySettings ios_settings = 5;</code>
     */
    public Builder mergeIosSettings(com.google.recaptchaenterprise.v1.IOSKeySettings value) {
      if (iosSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 5
            && platformSettings_
                != com.google.recaptchaenterprise.v1.IOSKeySettings.getDefaultInstance()) {
          platformSettings_ =
              com.google.recaptchaenterprise.v1.IOSKeySettings.newBuilder(
                      (com.google.recaptchaenterprise.v1.IOSKeySettings) platformSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          platformSettings_ = value;
        }
        onChanged();
      } else {
        if (platformSettingsCase_ == 5) {
          iosSettingsBuilder_.mergeFrom(value);
        } else {
          iosSettingsBuilder_.setMessage(value);
        }
      }
      platformSettingsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.IOSKeySettings ios_settings = 5;</code>
     */
    public Builder clearIosSettings() {
      if (iosSettingsBuilder_ == null) {
        if (platformSettingsCase_ == 5) {
          platformSettingsCase_ = 0;
          platformSettings_ = null;
          onChanged();
        }
      } else {
        if (platformSettingsCase_ == 5) {
          platformSettingsCase_ = 0;
          platformSettings_ = null;
        }
        iosSettingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.IOSKeySettings ios_settings = 5;</code>
     */
    public com.google.recaptchaenterprise.v1.IOSKeySettings.Builder getIosSettingsBuilder() {
      return getIosSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.IOSKeySettings ios_settings = 5;</code>
     */
    @java.lang.Override
    public com.google.recaptchaenterprise.v1.IOSKeySettingsOrBuilder getIosSettingsOrBuilder() {
      if ((platformSettingsCase_ == 5) && (iosSettingsBuilder_ != null)) {
        return iosSettingsBuilder_.getMessageOrBuilder();
      } else {
        if (platformSettingsCase_ == 5) {
          return (com.google.recaptchaenterprise.v1.IOSKeySettings) platformSettings_;
        }
        return com.google.recaptchaenterprise.v1.IOSKeySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for keys that can be used by iOS apps.
     * </pre>
     *
     * <code>.google.cloud.recaptchaenterprise.v1.IOSKeySettings ios_settings = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.IOSKeySettings,
            com.google.recaptchaenterprise.v1.IOSKeySettings.Builder,
            com.google.recaptchaenterprise.v1.IOSKeySettingsOrBuilder>
        getIosSettingsFieldBuilder() {
      if (iosSettingsBuilder_ == null) {
        if (!(platformSettingsCase_ == 5)) {
          platformSettings_ = com.google.recaptchaenterprise.v1.IOSKeySettings.getDefaultInstance();
        }
        iosSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.IOSKeySettings,
                com.google.recaptchaenterprise.v1.IOSKeySettings.Builder,
                com.google.recaptchaenterprise.v1.IOSKeySettingsOrBuilder>(
                (com.google.recaptchaenterprise.v1.IOSKeySettings) platformSettings_,
                getParentForChildren(),
                isClean());
        platformSettings_ = null;
      }
      platformSettingsCase_ = 5;
      onChanged();
      return iosSettingsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/recaptcha-enterprise/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/recaptcha-enterprise/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/recaptcha-enterprise/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/recaptcha-enterprise/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/recaptcha-enterprise/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/recaptcha-enterprise/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/recaptcha-enterprise/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp corresponding to the creation of this key.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp corresponding to the creation of this key.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp corresponding to the creation of this key.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp corresponding to the creation of this key.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp corresponding to the creation of this key.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp corresponding to the creation of this key.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp corresponding to the creation of this key.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp corresponding to the creation of this key.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp corresponding to the creation of this key.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.recaptchaenterprise.v1.TestingOptions testingOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.TestingOptions,
            com.google.recaptchaenterprise.v1.TestingOptions.Builder,
            com.google.recaptchaenterprise.v1.TestingOptionsOrBuilder>
        testingOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Options for user acceptance testing.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TestingOptions testing_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the testingOptions field is set.
     */
    public boolean hasTestingOptions() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for user acceptance testing.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TestingOptions testing_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The testingOptions.
     */
    public com.google.recaptchaenterprise.v1.TestingOptions getTestingOptions() {
      if (testingOptionsBuilder_ == null) {
        return testingOptions_ == null
            ? com.google.recaptchaenterprise.v1.TestingOptions.getDefaultInstance()
            : testingOptions_;
      } else {
        return testingOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for user acceptance testing.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TestingOptions testing_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTestingOptions(com.google.recaptchaenterprise.v1.TestingOptions value) {
      if (testingOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        testingOptions_ = value;
      } else {
        testingOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for user acceptance testing.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TestingOptions testing_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTestingOptions(
        com.google.recaptchaenterprise.v1.TestingOptions.Builder builderForValue) {
      if (testingOptionsBuilder_ == null) {
        testingOptions_ = builderForValue.build();
      } else {
        testingOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for user acceptance testing.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TestingOptions testing_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTestingOptions(com.google.recaptchaenterprise.v1.TestingOptions value) {
      if (testingOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && testingOptions_ != null
            && testingOptions_
                != com.google.recaptchaenterprise.v1.TestingOptions.getDefaultInstance()) {
          getTestingOptionsBuilder().mergeFrom(value);
        } else {
          testingOptions_ = value;
        }
      } else {
        testingOptionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for user acceptance testing.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TestingOptions testing_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTestingOptions() {
      bitField0_ = (bitField0_ & ~0x00000080);
      testingOptions_ = null;
      if (testingOptionsBuilder_ != null) {
        testingOptionsBuilder_.dispose();
        testingOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for user acceptance testing.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TestingOptions testing_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.TestingOptions.Builder getTestingOptionsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getTestingOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for user acceptance testing.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TestingOptions testing_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.TestingOptionsOrBuilder getTestingOptionsOrBuilder() {
      if (testingOptionsBuilder_ != null) {
        return testingOptionsBuilder_.getMessageOrBuilder();
      } else {
        return testingOptions_ == null
            ? com.google.recaptchaenterprise.v1.TestingOptions.getDefaultInstance()
            : testingOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Options for user acceptance testing.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TestingOptions testing_options = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.TestingOptions,
            com.google.recaptchaenterprise.v1.TestingOptions.Builder,
            com.google.recaptchaenterprise.v1.TestingOptionsOrBuilder>
        getTestingOptionsFieldBuilder() {
      if (testingOptionsBuilder_ == null) {
        testingOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.TestingOptions,
                com.google.recaptchaenterprise.v1.TestingOptions.Builder,
                com.google.recaptchaenterprise.v1.TestingOptionsOrBuilder>(
                getTestingOptions(), getParentForChildren(), isClean());
        testingOptions_ = null;
      }
      return testingOptionsBuilder_;
    }

    private com.google.recaptchaenterprise.v1.WafSettings wafSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.WafSettings,
            com.google.recaptchaenterprise.v1.WafSettings.Builder,
            com.google.recaptchaenterprise.v1.WafSettingsOrBuilder>
        wafSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Settings for WAF
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.WafSettings waf_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the wafSettings field is set.
     */
    public boolean hasWafSettings() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for WAF
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.WafSettings waf_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The wafSettings.
     */
    public com.google.recaptchaenterprise.v1.WafSettings getWafSettings() {
      if (wafSettingsBuilder_ == null) {
        return wafSettings_ == null
            ? com.google.recaptchaenterprise.v1.WafSettings.getDefaultInstance()
            : wafSettings_;
      } else {
        return wafSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for WAF
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.WafSettings waf_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWafSettings(com.google.recaptchaenterprise.v1.WafSettings value) {
      if (wafSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        wafSettings_ = value;
      } else {
        wafSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for WAF
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.WafSettings waf_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWafSettings(
        com.google.recaptchaenterprise.v1.WafSettings.Builder builderForValue) {
      if (wafSettingsBuilder_ == null) {
        wafSettings_ = builderForValue.build();
      } else {
        wafSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for WAF
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.WafSettings waf_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeWafSettings(com.google.recaptchaenterprise.v1.WafSettings value) {
      if (wafSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && wafSettings_ != null
            && wafSettings_ != com.google.recaptchaenterprise.v1.WafSettings.getDefaultInstance()) {
          getWafSettingsBuilder().mergeFrom(value);
        } else {
          wafSettings_ = value;
        }
      } else {
        wafSettingsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for WAF
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.WafSettings waf_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearWafSettings() {
      bitField0_ = (bitField0_ & ~0x00000100);
      wafSettings_ = null;
      if (wafSettingsBuilder_ != null) {
        wafSettingsBuilder_.dispose();
        wafSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for WAF
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.WafSettings waf_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.WafSettings.Builder getWafSettingsBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getWafSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for WAF
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.WafSettings waf_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.WafSettingsOrBuilder getWafSettingsOrBuilder() {
      if (wafSettingsBuilder_ != null) {
        return wafSettingsBuilder_.getMessageOrBuilder();
      } else {
        return wafSettings_ == null
            ? com.google.recaptchaenterprise.v1.WafSettings.getDefaultInstance()
            : wafSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for WAF
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.WafSettings waf_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.WafSettings,
            com.google.recaptchaenterprise.v1.WafSettings.Builder,
            com.google.recaptchaenterprise.v1.WafSettingsOrBuilder>
        getWafSettingsFieldBuilder() {
      if (wafSettingsBuilder_ == null) {
        wafSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.WafSettings,
                com.google.recaptchaenterprise.v1.WafSettings.Builder,
                com.google.recaptchaenterprise.v1.WafSettingsOrBuilder>(
                getWafSettings(), getParentForChildren(), isClean());
        wafSettings_ = null;
      }
      return wafSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1.Key)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1.Key)
  private static final com.google.recaptchaenterprise.v1.Key DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1.Key();
  }

  public static com.google.recaptchaenterprise.v1.Key getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Key> PARSER =
      new com.google.protobuf.AbstractParser<Key>() {
        @java.lang.Override
        public Key parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Key> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Key> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1.Key getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
