/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

package com.google.recaptchaenterprise.v1;

/**
 *
 *
 * <pre>
 * Metrics for a single Key.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1.Metrics}
 */
public final class Metrics extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1.Metrics)
    MetricsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Metrics.newBuilder() to construct.
  private Metrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Metrics() {
    name_ = "";
    scoreMetrics_ = java.util.Collections.emptyList();
    challengeMetrics_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Metrics();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_Metrics_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_Metrics_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1.Metrics.class,
            com.google.recaptchaenterprise.v1.Metrics.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the metrics, in the format
   * `projects/{project}/keys/{key}/metrics`.
   * </pre>
   *
   * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the metrics, in the format
   * `projects/{project}/keys/{key}/metrics`.
   * </pre>
   *
   * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Inclusive start time aligned to a day (UTC).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Inclusive start time aligned to a day (UTC).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Inclusive start time aligned to a day (UTC).
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int SCORE_METRICS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.recaptchaenterprise.v1.ScoreMetrics> scoreMetrics_;
  /**
   *
   *
   * <pre>
   * Metrics will be continuous and in order by dates, and in the granularity
   * of day. All Key types should have score-based data.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.recaptchaenterprise.v1.ScoreMetrics> getScoreMetricsList() {
    return scoreMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Metrics will be continuous and in order by dates, and in the granularity
   * of day. All Key types should have score-based data.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.recaptchaenterprise.v1.ScoreMetricsOrBuilder>
      getScoreMetricsOrBuilderList() {
    return scoreMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Metrics will be continuous and in order by dates, and in the granularity
   * of day. All Key types should have score-based data.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
   */
  @java.lang.Override
  public int getScoreMetricsCount() {
    return scoreMetrics_.size();
  }
  /**
   *
   *
   * <pre>
   * Metrics will be continuous and in order by dates, and in the granularity
   * of day. All Key types should have score-based data.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.ScoreMetrics getScoreMetrics(int index) {
    return scoreMetrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Metrics will be continuous and in order by dates, and in the granularity
   * of day. All Key types should have score-based data.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.ScoreMetricsOrBuilder getScoreMetricsOrBuilder(
      int index) {
    return scoreMetrics_.get(index);
  }

  public static final int CHALLENGE_METRICS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.recaptchaenterprise.v1.ChallengeMetrics> challengeMetrics_;
  /**
   *
   *
   * <pre>
   * Metrics will be continuous and in order by dates, and in the granularity
   * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
   * challenge-based data.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.recaptchaenterprise.v1.ChallengeMetrics>
      getChallengeMetricsList() {
    return challengeMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Metrics will be continuous and in order by dates, and in the granularity
   * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
   * challenge-based data.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.recaptchaenterprise.v1.ChallengeMetricsOrBuilder>
      getChallengeMetricsOrBuilderList() {
    return challengeMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Metrics will be continuous and in order by dates, and in the granularity
   * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
   * challenge-based data.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
   * </code>
   */
  @java.lang.Override
  public int getChallengeMetricsCount() {
    return challengeMetrics_.size();
  }
  /**
   *
   *
   * <pre>
   * Metrics will be continuous and in order by dates, and in the granularity
   * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
   * challenge-based data.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.ChallengeMetrics getChallengeMetrics(int index) {
    return challengeMetrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Metrics will be continuous and in order by dates, and in the granularity
   * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
   * challenge-based data.
   * </pre>
   *
   * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.ChallengeMetricsOrBuilder getChallengeMetricsOrBuilder(
      int index) {
    return challengeMetrics_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (startTime_ != null) {
      output.writeMessage(1, getStartTime());
    }
    for (int i = 0; i < scoreMetrics_.size(); i++) {
      output.writeMessage(2, scoreMetrics_.get(i));
    }
    for (int i = 0; i < challengeMetrics_.size(); i++) {
      output.writeMessage(3, challengeMetrics_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, name_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
    }
    for (int i = 0; i < scoreMetrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, scoreMetrics_.get(i));
    }
    for (int i = 0; i < challengeMetrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, challengeMetrics_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, name_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1.Metrics)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1.Metrics other =
        (com.google.recaptchaenterprise.v1.Metrics) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (!getScoreMetricsList().equals(other.getScoreMetricsList())) return false;
    if (!getChallengeMetricsList().equals(other.getChallengeMetricsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (getScoreMetricsCount() > 0) {
      hash = (37 * hash) + SCORE_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getScoreMetricsList().hashCode();
    }
    if (getChallengeMetricsCount() > 0) {
      hash = (37 * hash) + CHALLENGE_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getChallengeMetricsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1.Metrics parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Metrics parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Metrics parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Metrics parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Metrics parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Metrics parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Metrics parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Metrics parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Metrics parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Metrics parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Metrics parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Metrics parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.recaptchaenterprise.v1.Metrics prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metrics for a single Key.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1.Metrics}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1.Metrics)
      com.google.recaptchaenterprise.v1.MetricsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Metrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Metrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1.Metrics.class,
              com.google.recaptchaenterprise.v1.Metrics.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1.Metrics.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      if (scoreMetricsBuilder_ == null) {
        scoreMetrics_ = java.util.Collections.emptyList();
      } else {
        scoreMetrics_ = null;
        scoreMetricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (challengeMetricsBuilder_ == null) {
        challengeMetrics_ = java.util.Collections.emptyList();
      } else {
        challengeMetrics_ = null;
        challengeMetricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Metrics_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Metrics getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1.Metrics.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Metrics build() {
      com.google.recaptchaenterprise.v1.Metrics result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Metrics buildPartial() {
      com.google.recaptchaenterprise.v1.Metrics result =
          new com.google.recaptchaenterprise.v1.Metrics(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.recaptchaenterprise.v1.Metrics result) {
      if (scoreMetricsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          scoreMetrics_ = java.util.Collections.unmodifiableList(scoreMetrics_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.scoreMetrics_ = scoreMetrics_;
      } else {
        result.scoreMetrics_ = scoreMetricsBuilder_.build();
      }
      if (challengeMetricsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          challengeMetrics_ = java.util.Collections.unmodifiableList(challengeMetrics_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.challengeMetrics_ = challengeMetrics_;
      } else {
        result.challengeMetrics_ = challengeMetricsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1.Metrics result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1.Metrics) {
        return mergeFrom((com.google.recaptchaenterprise.v1.Metrics) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1.Metrics other) {
      if (other == com.google.recaptchaenterprise.v1.Metrics.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (scoreMetricsBuilder_ == null) {
        if (!other.scoreMetrics_.isEmpty()) {
          if (scoreMetrics_.isEmpty()) {
            scoreMetrics_ = other.scoreMetrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureScoreMetricsIsMutable();
            scoreMetrics_.addAll(other.scoreMetrics_);
          }
          onChanged();
        }
      } else {
        if (!other.scoreMetrics_.isEmpty()) {
          if (scoreMetricsBuilder_.isEmpty()) {
            scoreMetricsBuilder_.dispose();
            scoreMetricsBuilder_ = null;
            scoreMetrics_ = other.scoreMetrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
            scoreMetricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getScoreMetricsFieldBuilder()
                    : null;
          } else {
            scoreMetricsBuilder_.addAllMessages(other.scoreMetrics_);
          }
        }
      }
      if (challengeMetricsBuilder_ == null) {
        if (!other.challengeMetrics_.isEmpty()) {
          if (challengeMetrics_.isEmpty()) {
            challengeMetrics_ = other.challengeMetrics_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureChallengeMetricsIsMutable();
            challengeMetrics_.addAll(other.challengeMetrics_);
          }
          onChanged();
        }
      } else {
        if (!other.challengeMetrics_.isEmpty()) {
          if (challengeMetricsBuilder_.isEmpty()) {
            challengeMetricsBuilder_.dispose();
            challengeMetricsBuilder_ = null;
            challengeMetrics_ = other.challengeMetrics_;
            bitField0_ = (bitField0_ & ~0x00000008);
            challengeMetricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getChallengeMetricsFieldBuilder()
                    : null;
          } else {
            challengeMetricsBuilder_.addAllMessages(other.challengeMetrics_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                com.google.recaptchaenterprise.v1.ScoreMetrics m =
                    input.readMessage(
                        com.google.recaptchaenterprise.v1.ScoreMetrics.parser(), extensionRegistry);
                if (scoreMetricsBuilder_ == null) {
                  ensureScoreMetricsIsMutable();
                  scoreMetrics_.add(m);
                } else {
                  scoreMetricsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.recaptchaenterprise.v1.ChallengeMetrics m =
                    input.readMessage(
                        com.google.recaptchaenterprise.v1.ChallengeMetrics.parser(),
                        extensionRegistry);
                if (challengeMetricsBuilder_ == null) {
                  ensureChallengeMetricsIsMutable();
                  challengeMetrics_.add(m);
                } else {
                  challengeMetricsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the metrics, in the format
     * `projects/{project}/keys/{key}/metrics`.
     * </pre>
     *
     * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the metrics, in the format
     * `projects/{project}/keys/{key}/metrics`.
     * </pre>
     *
     * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the metrics, in the format
     * `projects/{project}/keys/{key}/metrics`.
     * </pre>
     *
     * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the metrics, in the format
     * `projects/{project}/keys/{key}/metrics`.
     * </pre>
     *
     * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the metrics, in the format
     * `projects/{project}/keys/{key}/metrics`.
     * </pre>
     *
     * <code>string name = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Inclusive start time aligned to a day (UTC).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Inclusive start time aligned to a day (UTC).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Inclusive start time aligned to a day (UTC).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inclusive start time aligned to a day (UTC).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inclusive start time aligned to a day (UTC).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inclusive start time aligned to a day (UTC).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inclusive start time aligned to a day (UTC).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Inclusive start time aligned to a day (UTC).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Inclusive start time aligned to a day (UTC).
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private java.util.List<com.google.recaptchaenterprise.v1.ScoreMetrics> scoreMetrics_ =
        java.util.Collections.emptyList();

    private void ensureScoreMetricsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        scoreMetrics_ =
            new java.util.ArrayList<com.google.recaptchaenterprise.v1.ScoreMetrics>(scoreMetrics_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1.ScoreMetrics,
            com.google.recaptchaenterprise.v1.ScoreMetrics.Builder,
            com.google.recaptchaenterprise.v1.ScoreMetricsOrBuilder>
        scoreMetricsBuilder_;

    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1.ScoreMetrics> getScoreMetricsList() {
      if (scoreMetricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(scoreMetrics_);
      } else {
        return scoreMetricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public int getScoreMetricsCount() {
      if (scoreMetricsBuilder_ == null) {
        return scoreMetrics_.size();
      } else {
        return scoreMetricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public com.google.recaptchaenterprise.v1.ScoreMetrics getScoreMetrics(int index) {
      if (scoreMetricsBuilder_ == null) {
        return scoreMetrics_.get(index);
      } else {
        return scoreMetricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public Builder setScoreMetrics(
        int index, com.google.recaptchaenterprise.v1.ScoreMetrics value) {
      if (scoreMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureScoreMetricsIsMutable();
        scoreMetrics_.set(index, value);
        onChanged();
      } else {
        scoreMetricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public Builder setScoreMetrics(
        int index, com.google.recaptchaenterprise.v1.ScoreMetrics.Builder builderForValue) {
      if (scoreMetricsBuilder_ == null) {
        ensureScoreMetricsIsMutable();
        scoreMetrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        scoreMetricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public Builder addScoreMetrics(com.google.recaptchaenterprise.v1.ScoreMetrics value) {
      if (scoreMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureScoreMetricsIsMutable();
        scoreMetrics_.add(value);
        onChanged();
      } else {
        scoreMetricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public Builder addScoreMetrics(
        int index, com.google.recaptchaenterprise.v1.ScoreMetrics value) {
      if (scoreMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureScoreMetricsIsMutable();
        scoreMetrics_.add(index, value);
        onChanged();
      } else {
        scoreMetricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public Builder addScoreMetrics(
        com.google.recaptchaenterprise.v1.ScoreMetrics.Builder builderForValue) {
      if (scoreMetricsBuilder_ == null) {
        ensureScoreMetricsIsMutable();
        scoreMetrics_.add(builderForValue.build());
        onChanged();
      } else {
        scoreMetricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public Builder addScoreMetrics(
        int index, com.google.recaptchaenterprise.v1.ScoreMetrics.Builder builderForValue) {
      if (scoreMetricsBuilder_ == null) {
        ensureScoreMetricsIsMutable();
        scoreMetrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        scoreMetricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public Builder addAllScoreMetrics(
        java.lang.Iterable<? extends com.google.recaptchaenterprise.v1.ScoreMetrics> values) {
      if (scoreMetricsBuilder_ == null) {
        ensureScoreMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, scoreMetrics_);
        onChanged();
      } else {
        scoreMetricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public Builder clearScoreMetrics() {
      if (scoreMetricsBuilder_ == null) {
        scoreMetrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        scoreMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public Builder removeScoreMetrics(int index) {
      if (scoreMetricsBuilder_ == null) {
        ensureScoreMetricsIsMutable();
        scoreMetrics_.remove(index);
        onChanged();
      } else {
        scoreMetricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public com.google.recaptchaenterprise.v1.ScoreMetrics.Builder getScoreMetricsBuilder(
        int index) {
      return getScoreMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public com.google.recaptchaenterprise.v1.ScoreMetricsOrBuilder getScoreMetricsOrBuilder(
        int index) {
      if (scoreMetricsBuilder_ == null) {
        return scoreMetrics_.get(index);
      } else {
        return scoreMetricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public java.util.List<? extends com.google.recaptchaenterprise.v1.ScoreMetricsOrBuilder>
        getScoreMetricsOrBuilderList() {
      if (scoreMetricsBuilder_ != null) {
        return scoreMetricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(scoreMetrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public com.google.recaptchaenterprise.v1.ScoreMetrics.Builder addScoreMetricsBuilder() {
      return getScoreMetricsFieldBuilder()
          .addBuilder(com.google.recaptchaenterprise.v1.ScoreMetrics.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public com.google.recaptchaenterprise.v1.ScoreMetrics.Builder addScoreMetricsBuilder(
        int index) {
      return getScoreMetricsFieldBuilder()
          .addBuilder(index, com.google.recaptchaenterprise.v1.ScoreMetrics.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. All Key types should have score-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ScoreMetrics score_metrics = 2;</code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1.ScoreMetrics.Builder>
        getScoreMetricsBuilderList() {
      return getScoreMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1.ScoreMetrics,
            com.google.recaptchaenterprise.v1.ScoreMetrics.Builder,
            com.google.recaptchaenterprise.v1.ScoreMetricsOrBuilder>
        getScoreMetricsFieldBuilder() {
      if (scoreMetricsBuilder_ == null) {
        scoreMetricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.recaptchaenterprise.v1.ScoreMetrics,
                com.google.recaptchaenterprise.v1.ScoreMetrics.Builder,
                com.google.recaptchaenterprise.v1.ScoreMetricsOrBuilder>(
                scoreMetrics_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        scoreMetrics_ = null;
      }
      return scoreMetricsBuilder_;
    }

    private java.util.List<com.google.recaptchaenterprise.v1.ChallengeMetrics> challengeMetrics_ =
        java.util.Collections.emptyList();

    private void ensureChallengeMetricsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        challengeMetrics_ =
            new java.util.ArrayList<com.google.recaptchaenterprise.v1.ChallengeMetrics>(
                challengeMetrics_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1.ChallengeMetrics,
            com.google.recaptchaenterprise.v1.ChallengeMetrics.Builder,
            com.google.recaptchaenterprise.v1.ChallengeMetricsOrBuilder>
        challengeMetricsBuilder_;

    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1.ChallengeMetrics>
        getChallengeMetricsList() {
      if (challengeMetricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(challengeMetrics_);
      } else {
        return challengeMetricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public int getChallengeMetricsCount() {
      if (challengeMetricsBuilder_ == null) {
        return challengeMetrics_.size();
      } else {
        return challengeMetricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public com.google.recaptchaenterprise.v1.ChallengeMetrics getChallengeMetrics(int index) {
      if (challengeMetricsBuilder_ == null) {
        return challengeMetrics_.get(index);
      } else {
        return challengeMetricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public Builder setChallengeMetrics(
        int index, com.google.recaptchaenterprise.v1.ChallengeMetrics value) {
      if (challengeMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChallengeMetricsIsMutable();
        challengeMetrics_.set(index, value);
        onChanged();
      } else {
        challengeMetricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public Builder setChallengeMetrics(
        int index, com.google.recaptchaenterprise.v1.ChallengeMetrics.Builder builderForValue) {
      if (challengeMetricsBuilder_ == null) {
        ensureChallengeMetricsIsMutable();
        challengeMetrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        challengeMetricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public Builder addChallengeMetrics(com.google.recaptchaenterprise.v1.ChallengeMetrics value) {
      if (challengeMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChallengeMetricsIsMutable();
        challengeMetrics_.add(value);
        onChanged();
      } else {
        challengeMetricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public Builder addChallengeMetrics(
        int index, com.google.recaptchaenterprise.v1.ChallengeMetrics value) {
      if (challengeMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChallengeMetricsIsMutable();
        challengeMetrics_.add(index, value);
        onChanged();
      } else {
        challengeMetricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public Builder addChallengeMetrics(
        com.google.recaptchaenterprise.v1.ChallengeMetrics.Builder builderForValue) {
      if (challengeMetricsBuilder_ == null) {
        ensureChallengeMetricsIsMutable();
        challengeMetrics_.add(builderForValue.build());
        onChanged();
      } else {
        challengeMetricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public Builder addChallengeMetrics(
        int index, com.google.recaptchaenterprise.v1.ChallengeMetrics.Builder builderForValue) {
      if (challengeMetricsBuilder_ == null) {
        ensureChallengeMetricsIsMutable();
        challengeMetrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        challengeMetricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public Builder addAllChallengeMetrics(
        java.lang.Iterable<? extends com.google.recaptchaenterprise.v1.ChallengeMetrics> values) {
      if (challengeMetricsBuilder_ == null) {
        ensureChallengeMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, challengeMetrics_);
        onChanged();
      } else {
        challengeMetricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public Builder clearChallengeMetrics() {
      if (challengeMetricsBuilder_ == null) {
        challengeMetrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        challengeMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public Builder removeChallengeMetrics(int index) {
      if (challengeMetricsBuilder_ == null) {
        ensureChallengeMetricsIsMutable();
        challengeMetrics_.remove(index);
        onChanged();
      } else {
        challengeMetricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public com.google.recaptchaenterprise.v1.ChallengeMetrics.Builder getChallengeMetricsBuilder(
        int index) {
      return getChallengeMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public com.google.recaptchaenterprise.v1.ChallengeMetricsOrBuilder getChallengeMetricsOrBuilder(
        int index) {
      if (challengeMetricsBuilder_ == null) {
        return challengeMetrics_.get(index);
      } else {
        return challengeMetricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public java.util.List<? extends com.google.recaptchaenterprise.v1.ChallengeMetricsOrBuilder>
        getChallengeMetricsOrBuilderList() {
      if (challengeMetricsBuilder_ != null) {
        return challengeMetricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(challengeMetrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public com.google.recaptchaenterprise.v1.ChallengeMetrics.Builder addChallengeMetricsBuilder() {
      return getChallengeMetricsFieldBuilder()
          .addBuilder(com.google.recaptchaenterprise.v1.ChallengeMetrics.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public com.google.recaptchaenterprise.v1.ChallengeMetrics.Builder addChallengeMetricsBuilder(
        int index) {
      return getChallengeMetricsFieldBuilder()
          .addBuilder(
              index, com.google.recaptchaenterprise.v1.ChallengeMetrics.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Metrics will be continuous and in order by dates, and in the granularity
     * of day. Only challenge-based keys (CHECKBOX, INVISIBLE), will have
     * challenge-based data.
     * </pre>
     *
     * <code>repeated .google.cloud.recaptchaenterprise.v1.ChallengeMetrics challenge_metrics = 3;
     * </code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1.ChallengeMetrics.Builder>
        getChallengeMetricsBuilderList() {
      return getChallengeMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1.ChallengeMetrics,
            com.google.recaptchaenterprise.v1.ChallengeMetrics.Builder,
            com.google.recaptchaenterprise.v1.ChallengeMetricsOrBuilder>
        getChallengeMetricsFieldBuilder() {
      if (challengeMetricsBuilder_ == null) {
        challengeMetricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.recaptchaenterprise.v1.ChallengeMetrics,
                com.google.recaptchaenterprise.v1.ChallengeMetrics.Builder,
                com.google.recaptchaenterprise.v1.ChallengeMetricsOrBuilder>(
                challengeMetrics_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        challengeMetrics_ = null;
      }
      return challengeMetricsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1.Metrics)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1.Metrics)
  private static final com.google.recaptchaenterprise.v1.Metrics DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1.Metrics();
  }

  public static com.google.recaptchaenterprise.v1.Metrics getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Metrics> PARSER =
      new com.google.protobuf.AbstractParser<Metrics>() {
        @java.lang.Override
        public Metrics parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Metrics> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Metrics> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1.Metrics getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
